/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// KDE includes
#include <kgenericfactory.h>

// WorKflow includes
#include "textlibrary.h"
#include "commandfactory.h"

// commands
#include "addprefixcommand.h"
#include "addsuffixcommand.h"
#include "removeprefixcommand.h"
#include "removesuffixcommand.h"
#include "changetextcasecommand.h"
#include "getstringcommand.h"
#include "readtextfilescommand.h"

using namespace WorKflow;

typedef KGenericFactory<TextLibrary> LibraryFactory;
K_EXPORT_COMPONENT_FACTORY(libworkflow_textcommands, LibraryFactory("libworkflow_textcommands"))

TextLibrary::TextLibrary(QObject* parent, const char* name, const QStringList& args)
  : Library(parent, name, args)
{
}

TextLibrary::~TextLibrary()
{
}

void TextLibrary::init()
{
  addCommandFactory(new CommandFactory<AddPrefixCommand>("org.kde.Text.AddPrefix"));
  addCommandFactory(new CommandFactory<AddSuffixCommand>("org.kde.Text.AddSuffix"));
  addCommandFactory(new CommandFactory<RemovePrefixCommand>("org.kde.Text.RemovePrefix"));
  addCommandFactory(new CommandFactory<RemoveSuffixCommand>("org.kde.Text.RemoveSuffix"));
  addCommandFactory(new CommandFactory<ChangeTextCaseCommand>("org.kde.Text.ChangeTextCase"));
  addCommandFactory(new CommandFactory<GetStringCommand>("org.kde.Text.GetString"));
  addCommandFactory(new CommandFactory<ReadTextFilesCommand>("org.kde.Text.ReadTextFiles"));
}

#include "textlibrary.moc"
