/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

#ifndef WORKFLOWCOMMANDDESCRIPTION_H
#define WORKFLOWCOMMANDDESCRIPTION_H

// Qt includes
#include <qmap.h>
#include <qstringlist.h>

// WorKflow includes
#include "xmldescription.h"

// forward declarations
namespace WorKflow
{
  class LibraryDescription;
  class ParameterDescription;
  class ResultDescription;
  class CommandFactoryBase;
}


// TODO: put apidox somewhere
    /**
     * Returns the command factory's ID.
     * @return The command factory's ID.
     */
//     QString id();

    /**
     * Returns the internal category ID.
     * @return The commands' category ID.
     */
//     QStringList categories();

    /**
     * Returns the commands' user-visible title.
     * @return The commands' i18n'ed title.
     */
//     QString title();

    /**
     * Returns the commands' user-visible short description.
     * @return The commands' i18n'ed short help text.
     */
//     QString description();

    /**
     * Returns whether or not the command accepts drops of type @c type.
     * @param type The drop's type.
     */
//     bool acceptsDrop(const QString& type);

namespace WorKflow
{
  /**
   * @author Thomas Kadauke
   */
  class CommandDescription : public WorKflow::XMLDescription
  {
  public:
    typedef QValueList<ParameterDescription*> ParamDescList;
    typedef QValueList<ResultDescription*> ResultDescList;

    CommandDescription(LibraryDescription* parent);
    ~CommandDescription();

    CommandFactoryBase* factory() const;
    void setFactory(CommandFactoryBase* factory);

    QString iconName() const;
    QStringList categories() const;
    QStringList keywords() const;

    void setIconName(const QString& icon);
    void addCategory(const QString& category);
    void addKeyword(const QString& keyword);

    void clearCategories();
    void clearKeywords();

    ParamDescList parameters() const;
    ResultDescList results() const;

    void addParameterDescription(ParameterDescription* desc);
    void addResultDescription(ResultDescription* desc);
    void removeParameterDescription(ParameterDescription* desc);
    void removeResultDescription(ResultDescription* desc);

    ParameterDescription* parameterDescription(const QString& id) const;
    ResultDescription* resultDescription(const QString& id) const;

    QString uiFile() const;
    void setUiFile(const QString& file);

    bool isHidden() const;

    QStringList acceptedDropTypes() const;

    virtual void readXML(const QDomElement& e);
    virtual void writeXML(QDomDocument& doc, QDomElement& e);

//   protected:
//     virtual bool handleProperty(const QString& key, const QString& value);
//     virtual bool readTag(const QDomElement& e);
//     virtual void finish();

  private:
    void readCategories(const QDomElement& e);
    void readKeywords(const QDomElement& e);

    void writeCategories(QDomDocument& doc, QDomElement& e);
    void writeKeywords(QDomDocument& doc, QDomElement& e);
    void writeParameters(QDomDocument& doc, QDomElement& e);
    void writeResults(QDomDocument& doc, QDomElement& e);

    LibraryDescription* m_parent;

    CommandFactoryBase* m_factory;

    QString m_iconName;
    QStringList m_categories;
    QStringList m_keywords;

    ParamDescList m_parameters;
    ResultDescList m_results;

    QString m_uiFile;

    bool m_hidden;

    QStringList m_acceptedDropTypes;
    QMap<QString, ParameterDescription*> m_parameterMap;
    QMap<QString, ResultDescription*> m_resultMap;
  };
}

#endif
