/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// Qt includes
#include <qcstring.h>
#include <qdatastream.h>

// WorKflow includes
#include "commandinfo.h"

using namespace WorKflow;

QDataStream& WorKflow::operator<<(QDataStream& stream, const CommandInfo& info)
{
  stream << info.commandId << info.commandState;
  return stream;
}

QDataStream& WorKflow::operator>>(QDataStream& stream, CommandInfo& info)
{
  stream >> info.commandId >> info.commandState;
  info.command = 0;
  return stream;
}
