/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

#ifndef WORKFLOWLIBRARYDESCRIPTION_H
#define WORKFLOWLIBRARYDESCRIPTION_H

// Qt includes
#include <qstring.h>
#include <qvaluelist.h>

// WorKflow includes
#include "xmldescription.h"

// forward declarations
namespace WorKflow
{
  class ApplicationDescription;
  class Category;
  class CommandDescription;
  class Datatype;
  class Conversion;
}

namespace WorKflow
{
  /**
   * @author Thomas Kadauke
   */
  class LibraryDescription : public XMLDescription
  {
  public:
    typedef QValueList<ApplicationDescription*> ApplicationList;
    typedef QValueList<Category*> CategoryList;
    typedef QValueList<CommandDescription*> CommandList;
    typedef QValueList<Datatype*> DatatypeList;
    typedef QValueList<Conversion*> ConversionList;

    LibraryDescription();
    LibraryDescription(const QString& xmlFile);
    ~LibraryDescription();

    void addApplication(ApplicationDescription* app);
    void addCategory(Category* cat);
    void addCommand(CommandDescription* cmd);
    void addDatatype(Datatype* type);
    void addConversion(Conversion* conv);

    void removeApplication(ApplicationDescription* app);
    void removeCategory(Category* cat);
    void removeCommand(CommandDescription* cmd);
    void removeDatatype(Datatype* type);
    void removeConversion(Conversion* conv);

    ApplicationList applications() const;
    CategoryList categories() const;
    CommandList commands() const;
    DatatypeList datatypes() const;
    ConversionList conversions() const;

    void readXML();
    QString writeXML();

  private:
    ApplicationList m_applications;
    CategoryList m_categories;
    CommandList m_commands;
    DatatypeList m_datatypes;
    ConversionList m_conversions;

    QString m_xmlFile;
  };
}

#endif
