/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

#ifndef WORKFLOWSLOTDESCRIPTION_H
#define WORKFLOWSLOTDESCRIPTION_H

// Qt includes
#include <qstringlist.h>

// WorKflow includes
#include "xmldescription.h"

// forward declarations
namespace WorKflow
{
  class CommandDescription;
}

namespace WorKflow
{
  /**
   * @author Thomas Kadauke
   */
  class SlotDescription : public XMLDescription
  {
  public:
    SlotDescription(CommandDescription* parent);
    ~SlotDescription();

    QStringList typeIds() const;
    void clearTypeIds();
    void addTypeId(const QString& id);

    virtual void writeXML(QDomDocument& doc, QDomElement& e);
    virtual void readXML(const QDomElement& e);

  protected:
    CommandDescription* parent();

  private:
    CommandDescription* m_parent;
    QStringList m_typeIds;
  };
}

#endif
