/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// KDE includes
#include <kapplication.h>
#include <dcopclient.h>

// Qt includes
#include <qlineedit.h>
#include <qradiobutton.h>
#include <qcombobox.h>

// WorKflow includes
#include "applicationdescription.h"

// designer includes
#include "applicationdialog.h"
#include "dialoghelper.h"

using namespace WorKflow;

bool ApplicationDialog::editApplication(QWidget* parent, ApplicationDescription* desc)
{
  ApplicationDialog dialog(parent, desc);
  return dialog.exec();
}

ApplicationDescription* ApplicationDialog::newApplication(QWidget* parent, LibraryDescription* library)
{
  ApplicationDescription* app = new ApplicationDescription(library);

  ApplicationDialog dialog(parent, app);
  if (dialog.exec()) {
    return dialog.m_description;
  } else {
    delete app;
    return 0;
  }
}

void ApplicationDialog::init()
{
  m_idEdit->setText(m_description->id());
  m_nameEdit->setText(m_description->name());
  m_descriptionEdit->setText(m_description->description());

  m_uniqueRadio->setChecked(m_description->isUnique());

  m_executableEdit->setText(m_description->executableName());
  m_dcopNameComboBox->setEditText(m_description->dcopName());

  slotDcopServerChange();
}

ApplicationDialog::ApplicationDialog(QWidget* parent, ApplicationDescription* desc)
  : ApplicationDialogBase(parent), m_description(desc)
{
  kapp->dcopClient()->setNotifications(true);

  connect(kapp->dcopClient(), SIGNAL(applicationRegistered(const QCString&)), this, SLOT(slotDcopServerChange()));
  connect(kapp->dcopClient(), SIGNAL(applicationRemoved(const QCString&)), this, SLOT(slotDcopServerChange()));

  init();
}

ApplicationDialog::~ApplicationDialog()
{
}

void ApplicationDialog::accept()
{
  m_description->setId(m_idEdit->text());
  m_description->setName(m_nameEdit->text());
  m_description->setDescription(m_descriptionEdit->text());

  m_description->setUnique(m_uniqueRadio->isChecked());
  m_description->setExecutableName(m_executableEdit->text());
  m_description->setDcopName(m_dcopNameComboBox->currentText());

  QDialog::accept();
}

void ApplicationDialog::slotDcopServerChange()
{
  QStringList apps = DialogHelper::dcopNames();

  DialogHelper::fillEditComboBox(m_dcopNameComboBox, apps);
}

#include "applicationdialog.moc"
