/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

#include "mainwindow.h"
#include <kapplication.h>
#include <dcopclient.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>

static const char description[] =
    I18N_NOOP("Design WorKflow Command Libraries");

static const char version[] = "0.1";

static KCmdLineOptions options[] =
{
//     { "[Category]", I18N_NOOP("Command category"), 0 },
//     { "[Command]", I18N_NOOP("Command name to open"), 0 },
    KCmdLineLastOption
};

int main(int argc, char **argv)
{
  KAboutData about("workflowdesigner", I18N_NOOP("WorKflow Designer"), version, description,
                   KAboutData::License_GPL, "(C) 2006 Thomas Kadauke", 0, 0, "tkadauke@gmx.de");
  about.addAuthor( "Thomas Kadauke", 0, "tkadauke@gmx.de" );
  KCmdLineArgs::init(argc, argv, &about);
  KCmdLineArgs::addCmdLineOptions(options);
  KApplication app;

  // register ourselves as a dcop client
  app.dcopClient()->registerAs(app.name(), false);

  // see if we are starting with session management
  if (app.isRestored()) {
      RESTORE(MainWindow);
  } else {
    // no session.. just start up normally
    KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
    if (args->count() == 0) {
      MainWindow *widget = new MainWindow();
      widget->show();
    } else {
//       QString category = args->
//       QString command;
//       if (args->count() == 2) {
//         command = args->url(1);
//       }

//       MainWindow *widget = new MainWindow(category, command);
//       widget->show();
    }
    args->clear();
  }

  return app.exec();
}
