/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// KDE includes
#include <klocale.h>

// Qt includes
#include <qpopupmenu.h>
#include <qtooltip.h>

// WorKflow includes
#include "commandport.h"
#include "parameter.h"
#include "result.h"
#include "command.h"
#include "datatype.h"

using namespace WorKflow;

CommandPort::CommandPort(QWidget* parent, PortKind kind)
  : QLabel(parent), m_kind(kind), m_problem(Slot::NoProblem)
{
  setMinimumWidth(200);
  setSizePolicy(QSizePolicy::Fixed, QSizePolicy::Fixed);
  setAlignment(Qt::AlignHCenter);
}

void CommandPort::setCommand(Command* cmd)
{
  m_command = cmd;

  if (m_kind == InputPort && m_command->input()) {
    updateText(m_command->input());
  } else if (m_kind == OutputPort && m_command->output()) {
    updateText(m_command->output());
  }
}

CommandPort::~CommandPort()
{

}

int CommandPort::problem()
{
  return m_problem;
}

void CommandPort::setProblem(int problem)
{
  m_problem = problem;
  updateColor();
}

void CommandPort::mousePressEvent(QMouseEvent* e)
{
  QPopupMenu menu;
  int i = 0;

  QValueList<Slot*> slotlist;

//   bool allOptional = true;
  if (m_kind == InputPort) {
    Command::ParameterList params = m_command->connectableParameters();
    if (params.isEmpty())
      return;

    for (Command::ParameterList::ConstIterator it = params.begin(); it != params.end(); ++it, ++i) {
      menu.insertItem((*it)->name(), i);
      slotlist.append(*it);
    }
  } else {
    Command::ResultList results = m_command->resultList();
    if (results.isEmpty())
      return;

    for (Command::ResultList::ConstIterator it = results.begin(); it != results.end(); ++it, ++i) {
      menu.insertItem((*it)->name(), i);
      slotlist.append(*it);
    }
  }
//   menu.insertSeparator();
//   menu.insertItem(i18n("None"), -1);

  int id = menu.exec(mapToGlobal(QPoint(0, height())));

  if (id != -1) {
    if (id < slotlist.count()) {
      Slot* slot = *(slotlist.at(id));
      updateText(slot);
      emit selected(slot->id());
    }
  }

  e->accept();
}

void CommandPort::updateColor()
{
  QToolTip::remove(this);

  QColor color = Qt::red;
  if (m_problem == Slot::TypeMismatch)
    QToolTip::add(this, i18n("Cannot convert between input and output type"));
  else if (m_problem == Slot::MissingInput)
    QToolTip::add(this, i18n("This command needs input from another command"));
  else
    color = Qt::black;
  setPaletteForegroundColor(color);
}

void CommandPort::updateText(Slot* slot)
{
  setText(QString("<b>%1</b> (%2)").arg(slot->name()).arg(slot->type()->pluralName()));
}

#include "commandport.moc"
