/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

#ifndef COMMANDPORT_H
#define COMMANDPORT_H

// Qt includes
#include <qlabel.h>

namespace WorKflow
{
  class Command;
  class Slot;
}

namespace WorKflow
{
  /**
   * @author Thomas Kadauke
   */
  class CommandPort : public QLabel
  {
    Q_OBJECT

  public:
    enum PortKind {
      InputPort,
      OutputPort
    };

    CommandPort(QWidget* parent, PortKind kind);
    ~CommandPort();

    void setCommand(Command* cmd);

    int problem();
    void setProblem(int problem);

    void updateText(Slot* slot);

  signals:
    void selected(const QString& id);

  protected:
    virtual void mousePressEvent(QMouseEvent* e);

  private:
    void updateColor();

    PortKind m_kind;
    Command* m_command;

    int m_problem;
  };
}

#endif
