/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

#ifndef WORKFLOWAPPLICATIONCOMBOBOX_H
#define WORKFLOWAPPLICATIONCOMBOBOX_H

#include <qcombobox.h>

#include "widgetinterface.h"

namespace WorKflow
{
  /**
   * @author Thomas Kadauke <tkadauke@gmx.de>
   */
  class ApplicationComboBox : public QComboBox, public WorKflow::WidgetInterface
  {
    Q_OBJECT
    Q_ENUMS(ApplicationType)
    Q_PROPERTY(QString parameterId READ parameterId WRITE setParameterId)
    Q_PROPERTY(ApplicationType appType READ appType WRITE setAppType)

  public:
    enum ApplicationType {
      Known,
      Running,
      Unique,
      UniqueRunning
    };

    ApplicationComboBox(QWidget* parent, const char* name);
    ~ApplicationComboBox();

    virtual QString parameterId() const;
    virtual Value value();
    virtual void setParameterId(const QString& paramId);

    ApplicationType appType() const;
    void setAppType(ApplicationType type);

  public slots:
    virtual void setValue(const Value& value);

  signals:
    void changed(const Value& value);

  private slots:
    void slotChanged();
    void repopulate();

  private:
    class Private;
    Private* d;
  };
}

#endif
