/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// WorKflow includes
#include "buttongroup.h"
#include "parameter.h"

using namespace WorKflow;

ButtonGroup::ButtonGroup(int columns, Orientation o, const QString& title, QWidget* parent, const char* name)
  : QButtonGroup(columns, o, title, parent, name)
{
  connect(this, SIGNAL(clicked(int)), this, SLOT(slotChanged()));
}

ButtonGroup::ButtonGroup(int columns, Orientation o, QWidget* parent, const char* name)
  : QButtonGroup(columns, o, parent, name)
{
  connect(this, SIGNAL(clicked(int)), this, SLOT(slotChanged()));
}

ButtonGroup::ButtonGroup(const QString& title, QWidget* parent, const char* name)
  : QButtonGroup(title, parent, name)
{
  connect(this, SIGNAL(clicked(int)), this, SLOT(slotChanged()));
}

ButtonGroup::ButtonGroup(QWidget* parent, const char* name)
  : QButtonGroup(parent, name)
{
  connect(this, SIGNAL(clicked(int)), this, SLOT(slotChanged()));
}

ButtonGroup::~ButtonGroup()
{
}

QString ButtonGroup::parameterId() const
{
  return WidgetInterface::parameterId();
}

Value ButtonGroup::value()
{
  return Value::singleNumber(parameter()->typeId(), selectedId());
}

void ButtonGroup::setParameterId(const QString& paramId)
{
  WidgetInterface::setParameterId(paramId);
}

void ButtonGroup::setValue(const Value& value)
{
  setButton(value.asStringList().first().toInt());
}

void ButtonGroup::slotChanged()
{
  if (!parameter())
    return;

  emit changed(value());
}

#include "buttongroup.moc"
