/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

#ifndef WORKFLOWWIDGET_H
#define WORKFLOWWIDGET_H

#include <qwidget.h>

namespace WorKflow
{
  class Command;
}

namespace WorKflow
{
  /**
   * @author Thomas Kadauke
   */
  class Widget : public QWidget
  {
    Q_OBJECT

  public:
    Widget(QWidget* parent = 0, const char* name = 0, WFlags f = 0);
    ~Widget();

    void setCommand(Command* cmd);
    Command* command();

  signals:
    void changed();
    void sizeChanged();

  private slots:
    void emitChange();
    void initChildren();

    void recurseObjects(QObject* obj);

  private:
    class Private;
    Private* d;
  };
}

#endif
