#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <fcntl.h>
#include <sys/mman.h>
#include <unistd.h>
#include <sys/time.h>
#include <time.h>
#include <signal.h>
#include "usersem.h"

#ifndef PROT_SEM
#define PROT_SEM 0x8
#endif


static void spinner(struct futex *sem, int hold)
{
	while (1) {
		futex_down(sem);
		if (hold) sleep(1);
		futex_up(sem);
	}
}

/* Test maximum time to lock given furious spinners. */
int main(int argc, char *argv[])
{
	struct futex *sem;
	unsigned int i;
	unsigned long maxtime = 0;
	pid_t children[100];

	if (argc != 3) {
		fprintf(stderr, "Usage: starve <numspinners> <iterations>\n");
		exit(1);
	}

	sem = malloc(sizeof(*sem));
	futex_region(sem, sizeof(*sem));
	futex_init(sem);
	for (i = 0; i < atoi(argv[1]); i++) {
		children[i] = fork();
		if (children[i] == 0)
			spinner(sem, 0);
	}

	for (i = 0; i < atoi(argv[2]); i++) {
		struct timeval start, end, diff;

		sleep(1);
		gettimeofday(&start, NULL);
		futex_down(sem);
		gettimeofday(&end, NULL);
		futex_up(sem);
		timersub(&end, &start, &diff);
		printf("Wait time: %lu.%06lu\n", diff.tv_sec, diff.tv_usec);
		if (diff.tv_sec * 1000000 + diff.tv_usec > maxtime)
			maxtime = diff.tv_sec * 1000000 + diff.tv_usec;
	}

	/* Kill children */
	for (i = 0; i < atoi(argv[1]); i++)
		kill(children[i], SIGTERM);

	printf("Worst case: %lu\n", maxtime);
	exit(0);
}
