/*  *********************************************************************
    *  BCM1280/BCM1480 Board Support Package
    *
    *  Packet manager constants and macros	File: bcm1480_pm.h
    *
    *  This module contains constants useful for manipulating the
    *  BCM1280/BCM1480 packet manager.
    *
    *  BCM1400 specification level:  1X55_1X80-UM100-D4 (11/24/03)
    *
    *********************************************************************
    *
    *  Copyright 2000,2001,2002,2003,2004
    *  Broadcom Corporation. All rights reserved.
    *
    *  This software is furnished under license and may be used and
    *  copied only in accordance with the following terms and
    *  conditions.  Subject to these conditions, you may download,
    *  copy, install, use, modify and distribute modified or unmodified
    *  copies of this software in source and/or binary form.  No title
    *  or ownership is transferred hereby.
    *
    *  1) Any source code used, modified or distributed must reproduce
    *     and retain this copyright notice and list of conditions
    *     as they appear in the source file.
    *
    *  2) No right is granted to use any trade name, trademark, or
    *     logo of Broadcom Corporation.  The "Broadcom Corporation"
    *     name may not be used to endorse or promote products derived
    *     from this software without the prior written permission of
    *     Broadcom Corporation.
    *
    *  3) THIS SOFTWARE IS PROVIDED "AS-IS" AND ANY EXPRESS OR
    *     IMPLIED WARRANTIES, INCLUDING BUT NOT LIMITED TO, ANY IMPLIED
    *     WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
    *     PURPOSE, OR NON-INFRINGEMENT ARE DISCLAIMED. IN NO EVENT
    *     SHALL BROADCOM BE LIABLE FOR ANY DAMAGES WHATSOEVER, AND IN
    *     PARTICULAR, BROADCOM SHALL NOT BE LIABLE FOR DIRECT, INDIRECT,
    *     INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
    *     (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
    *     GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
    *     BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
    *     OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
    *     TORT (INCLUDING NEGLIGENCE OR OTHERWISE), EVEN IF ADVISED OF
    *     THE POSSIBILITY OF SUCH DAMAGE.
    ********************************************************************* */

#ifndef _BCM1480_PM_H
#define _BCM1480_PM_H

#include "sb1250_defs.h"

/*  *********************************************************************
    *  DMA Registers
    ********************************************************************* */

/*
 * Base and Size Register (Table 294)
 */

#define S_BCM1480_PM_BASE                    0
#define M_BCM1480_PM_BASE                    _SB_MAKEMASK(40,S_BCM1480_PM_BASE)
#define V_BCM1480_PM_BASE(x)                 _SB_MAKEVALUE(x,S_BCM1480_PM_BASE)
#define G_BCM1480_PM_BASE(x)                 _SB_GETVALUE(x,S_BCM1480_PM_BASE,M_BCM1480_PM_BASE)

#define S_BCM1480_PM_SIZE                    40
#define M_BCM1480_PM_SIZE                    _SB_MAKEMASK(20,S_BCM1480_PM_SIZE)
#define V_BCM1480_PM_SIZE(x)                 _SB_MAKEVALUE(x,S_BCM1480_PM_SIZE)
#define G_BCM1480_PM_SIZE(x)                 _SB_GETVALUE(x,S_BCM1480_PM_SIZE,M_BCM1480_PM_SIZE)

/*
 * Descriptor Merge Timer (Table 295)
 */

#define S_BCM1480_PM_DS_MT_CNT              0
#define M_BCM1480_PM_DS_MT_CNT              _SB_MAKEMASK(6,S_BCM1480_PM_DS_MT_CNT)
#define V_BCM1480_PM_DS_MT_CNT(x)           _SB_MAKEVALUE(x,S_BCM1480_PM_DS_MT_CNT)
#define G_BCM1480_PM_DS_MT_CNT(x)           _SB_GETVALUE(x,S_BCM1480_PM_DS_MT_CNT,M_BCM1480_PM_DS_MT_CNT)

/*
 * L2 Cache Attribute (Table 296)
 */

#define S_BCM1480_PM_HDR_SIZE                0
#define M_BCM1480_PM_HDR_SIZE                _SB_MAKEMASK(9,S_BCM1480_PM_HDR_SIZE)
#define V_BCM1480_PM_HDR_SIZE(x)             _SB_MAKEVALUE(x,S_BCM1480_PM_HDR_SIZE)
#define G_BCM1480_PM_HDR_SIZE(x)             _SB_GETVALUE(x,S_BCM1480_PM_HDR_SIZE,M_BCM1480_PM_HDR_SIZE)

/*
 * Descriptor Count Register (Table 297)
 */

#define S_BCM1480_PM_COUNT                 0
#define M_BCM1480_PM_COUNT                 _SB_MAKEMASK(20,S_BCM1480_PM_COUNT)
#define V_BCM1480_PM_COUNT(x)              _SB_MAKEVALUE(x,S_BCM1480_PM_COUNT)
#define G_BCM1480_PM_COUNT(x)              _SB_GETVALUE(x,S_BCM1480_PM_COUNT,M_BCM1480_PM_COUNT)

/*
 * Current Descriptor Index Register (Table 298)
 */

#define S_BCM1480_PM_LAST                    0
#define M_BCM1480_PM_LAST                    _SB_MAKEMASK(20,S_BCM1480_PM_LAST)
#define V_BCM1480_PM_LAST(x)                 _SB_MAKEVALUE(x,S_BCM1480_PM_LAST)
#define G_BCM1480_PM_LAST(x)                 _SB_GETVALUE(x,S_BCM1480_PM_LAST,M_BCM1480_PM_LAST)

/*
 * Packet Manager Queue Configuration (Table 299)
 */

#define M_BCM1480_PM_QUEUE_ENABLE           _SB_MAKEMASK1(0)
#define M_BCM1480_PM_DS_CACHE_EN            _SB_MAKEMASK1(1)
#define M_BCM1480_PM_HW_ASSERT              _SB_MAKEMASK1(2)
#define M_BCM1480_PM_HW_ERROR               _SB_MAKEMASK1(3)

#define S_BCM1480_PM_SW_ERROR               4
#define M_BCM1480_PM_SW_ERROR               _SB_MAKEMASK(3,S_BCM1480_PM_SW_ERROR)
#define V_BCM1480_PM_SW_ERROR(x)            _SB_MAKEVALUE(x,S_BCM1480_PM_SW_ERROR)
#define G_BCM1480_PM_SW_ERROR(x)            _SB_GETVALUE(x,S_BCM1480_PM_SW_ERROR,M_BCM1480_PM_SW_ERROR)
#define K_BCM1480_PM_SW_ERROR_NONE          0x0
#define K_BCM1480_PM_SW_ERROR_HWBIT         0x1

#define M_BCM1480_PM_FLUSH                  _SB_MAKEMASK1(7)

/*
 * Interrupt Configuration (Table 300)
 */

#define S_BCM1480_PM_INT_CORE_ID            0
#define M_BCM1480_PM_INT_CORE_ID            _SB_MAKEMASK(2,S_BCM1480_PM_INT_CORE_ID)
#define V_BCM1480_PM_INT_CORE_ID(x)         _SB_MAKEVALUE(x,S_BCM1480_PM_INT_CORE_ID)
#define G_BCM1480_PM_INT_CORE_ID(x)         _SB_GETVALUE(x,S_BCM1480_PM_INT_CORE_ID,M_BCM1480_PM_INT_CORE_ID)

#define M_BCM1480_PM_INT_PRIORITY           _SB_MAKEMASK1(4)

#define S_BCM1480_PM_INT_TIMEOUT            5
#define M_BCM1480_PM_INT_TIMEOUT            _SB_MAKEMASK(5,S_BCM1480_PM_INT_TIMEOUT)
#define V_BCM1480_PM_INT_TIMEOUT(x)         _SB_MAKEVALUE(x,S_BCM1480_PM_INT_TIMEOUT)
#define G_BCM1480_PM_INT_TIMEOUT(x)         _SB_GETVALUE(x,S_BCM1480_PM_INT_TIMEOUT,M_BCM1480_PM_INT_TIMEOUT)

#define S_BCM1480_PM_INT_PKT_CNT            11
#define M_BCM1480_PM_INT_PKT_CNT            _SB_MAKEMASK(12,S_BCM1480_PM_INT_PKT_CNT)
#define V_BCM1480_PM_INT_PKT_CNT(x)         _SB_MAKEVALUE(x,S_BCM1480_PM_INT_PKT_CNT)
#define G_BCM1480_PM_INT_PKT_CNT(x)         _SB_GETVALUE(x,S_BCM1480_PM_INT_PKT_CNT,M_BCM1480_PM_INT_PKT_CNT)

/*
 * Interrupt Watermark (Table 301)
 */

#define S_BCM1480_PM_LOW_WATERMARK          0
#define M_BCM1480_PM_LOW_WATERMARK          _SB_MAKEMASK(20,S_BCM1480_PM_LOW_WATERMARK)
#define V_BCM1480_PM_LOW_WATERMARK(x)       _SB_MAKEVALUE(x,S_BCM1480_PM_LOW_WATERMARK)
#define G_BCM1480_PM_LOW_WATERMARK(x)       _SB_GETVALUE(x,S_BCM1480_PM_LOW_WATERMARK,M_BCM1480_PM_LOW_WATERMARK)

#define S_BCM1480_PM_HIGH_WATERMARK         20
#define M_BCM1480_PM_HIGH_WATERMARK         _SB_MAKEMASK(20,S_BCM1480_PM_HIGH_WATERMARK)
#define V_BCM1480_PM_HIGH_WATERMARK(x)      _SB_MAKEVALUE(x,S_BCM1480_PM_HIGH_WATERMARK)
#define G_BCM1480_PM_HIGH_WATERMARK(x)      _SB_GETVALUE(x,S_BCM1480_PM_HIGH_WATERMARK,M_BCM1480_PM_HIGH_WATERMARK)


/*
 * NOTE: Interrupt Bits (Tables 9-36 to 9-38) are packed 8 per word
 *       per Table 9-39.
 */


#define S_BCM1480_PM_INT(q)                 ((q%8)<<8)
#define M_BCM1480_PM_INT(q)                 _SB_MAKEMASK(8,S_BCM1480_PM_INT(q))
#define V_BCM1480_PM_INT(x,q)               _SB_MAKEVALUE((x&((1<<8)-1)),S_BCM1480_PM_INT(q))
#define G_BCM1480_PM_INT(x,q)               _SB_GETVALUE(x,S_BCM1480_PM_INT(q),M_BCM1480_PM_INT(q))


/*
 * Input/Output Queue Interrupt Status Register (Table 302)
 */

#define M_BCM1480_PM_EOP_COUNT              _SB_MAKEMASK1(0)
#define M_BCM1480_PM_EOP_SEEN               _SB_MAKEMASK1(1)
#define M_BCM1480_PM_RCV_TIMER              _SB_MAKEMASK1(2)
#define M_BCM1480_PM_DE                     _SB_MAKEMASK1(3)
#define M_BCM1480_PM_HWM                    _SB_MAKEMASK1(4)
#define M_BCM1480_PM_LWM                    _SB_MAKEMASK1(5)
#define M_BCM1480_PM_RX_ERR                 _SB_MAKEMASK1(6)
#define M_BCM1480_PM_PE_ERR                 _SB_MAKEMASK1(7)

/*
 * Input/Output Queue Interrupt Mask Register (Table 303)
 */

#define M_BCM1480_PM_EOP_COUNT_MSK          _SB_MAKEMASK1(0)
#define M_BCM1480_PM_EOP_SEEN_MSK           _SB_MAKEMASK1(1)
#define M_BCM1480_PM_RCV_TIMER_MSK          _SB_MAKEMASK1(2)
#define M_BCM1480_PM_DE_MSK                 _SB_MAKEMASK1(3)
#define M_BCM1480_PM_HWM_MSK                _SB_MAKEMASK1(4)
#define M_BCM1480_PM_LWM_MSK                _SB_MAKEMASK1(5)
#define M_BCM1480_PM_RX_ERR_MSK             _SB_MAKEMASK1(6)
#define M_BCM1480_PM_PE_ERR_MSK             _SB_MAKEMASK1(7)

/*
 * Input/Output Queue Interrupt Clear Register (Table 304)
 */

#define M_BCM1480_PM_EOP_COUNT_CLR          _SB_MAKEMASK1(0)
#define M_BCM1480_PM_EOP_SEEN_CLR           _SB_MAKEMASK1(1)
#define M_BCM1480_PM_RCV_TIMER_CLR          _SB_MAKEMASK1(2)
#define M_BCM1480_PM_DE_CLR                 _SB_MAKEMASK1(3)
#define M_BCM1480_PM_RX_ERR_CLR             _SB_MAKEMASK1(6)
#define M_BCM1480_PM_PE_ERR_CLR             _SB_MAKEMASK1(7)

/*
 * Merged Interrupt Status Register (Table 306)
 */

#define M_INT_N(n)                   _SB_MAKEMASK1(n)


/*
 * PMO Mapping Register (Table 279)
 */

#define S_BCM1480_PM_MAP_DEST_ID0          0
#define M_BCM1480_PM_MAP_DEST_ID0          _SB_MAKEMASK(2,S_BCM1480_PM_MAP_DEST_ID0)
#define V_BCM1480_PM_MAP_DEST_ID0(x)       _SB_MAKEVALUE(x,S_BCM1480_PM_MAP_DEST_ID0)
#define G_BCM1480_PM_MAP_DEST_ID0(x)       _SB_GETVALUE(x,S_BCM1480_PM_MAP_DEST_ID0,M_BCM1480_PM_MAP_DEST_ID0)

#define S_BCM1480_PM_MAP_DEST_ID8          4
#define M_BCM1480_PM_MAP_DEST_ID8          _SB_MAKEMASK(2,S_BCM1480_PM_MAP_DEST_ID8)
#define V_BCM1480_PM_MAP_DEST_ID8(x)       _SB_MAKEVALUE(x,S_BCM1480_PM_MAP_DEST_ID8)
#define G_BCM1480_PM_MAP_DEST_ID8(x)       _SB_GETVALUE(x,S_BCM1480_PM_MAP_DEST_ID8,M_BCM1480_PM_MAP_DEST_ID8)

#define S_BCM1480_PM_MAP_DEST_ID16         8
#define M_BCM1480_PM_MAP_DEST_ID16         _SB_MAKEMASK(2,S_BCM1480_PM_MAP_DEST_ID16)
#define V_BCM1480_PM_MAP_DEST_ID16(x)      _SB_MAKEVALUE(x,S_BCM1480_PM_MAP_DEST_ID16)
#define G_BCM1480_PM_MAP_DEST_ID16(x)      _SB_GETVALUE(x,S_BCM1480_PM_MAP_DEST_ID16,M_BCM1480_PM_MAP_DEST_ID16)

#define S_BCM1480_PM_MAP_DEST_ID24         12
#define M_BCM1480_PM_MAP_DEST_ID24         _SB_MAKEMASK(2,S_BCM1480_PM_MAP_DEST_ID24)
#define V_BCM1480_PM_MAP_DEST_ID24(x)      _SB_MAKEVALUE(x,S_BCM1480_PM_MAP_DEST_ID24)
#define G_BCM1480_PM_MAP_DEST_ID24(x)      _SB_GETVALUE(x,S_BCM1480_PM_MAP_DEST_ID24,M_BCM1480_PM_MAP_DEST_ID24)

#define M_BCM1480_PM_MAP_DEST_HALF0        _SB_MAKEMASK1(2)
#define M_BCM1480_PM_MAP_DEST_HALF8        _SB_MAKEMASK1(6)
#define M_BCM1480_PM_MAP_DEST_HALF16       _SB_MAKEMASK1(10)
#define M_BCM1480_PM_MAP_DEST_HALF24       _SB_MAKEMASK1(14)

#define K_BCM1480_PM_MAP_DEST_ID_TX0       0
#define K_BCM1480_PM_MAP_DEST_ID_TX1       1
#define K_BCM1480_PM_MAP_DEST_ID_TX2       2



/*
 * Global Debug Mode Register (Table 307)
 */

#define M_BCM1480_PM_DEBUG_MODE              _SB_MAKEMASK1(0)
#define M_BCM1480_PM_READ_PRIORITY           _SB_MAKEMASK1(1)
#define M_BCM1480_PM_WRITE_PRIORITY          _SB_MAKEMASK1(2)

/*
 * PxD Global Debug Register (Table 308)
 */

/*
 * PIB Global Debug Register (Table 310)
 */

/*
 * PxD Local Debug Register (Table 311)
 */

/*
 * PIB Local Debug Register (Table 312)
 */

/*
 * POB Local Debug Register (Table 313)
 */

/*
 * Prefetch Count Register (Table 314)
 */

#define S_BCM1480_PM_PREF_COUNT             0
#define M_BCM1480_PM_PREF_COUNT             _SB_MAKEMASK(20,S_BCM1480_PM_PREF_COUNT)
#define V_BCM1480_PM_PREF_COUNT(x)          _SB_MAKEVALUE(x,S_BCM1480_PM_PREF_COUNT)
#define G_BCM1480_PM_PREF_COUNT(x)          _SB_GETVALUE(x,S_BCM1480_PM_PREF_COUNT,M_BCM1480_PM_PREF_COUNT)

/*
 * Descriptor Prefetch Index Register (Table 315)
 */

#define S_BCM1480_PM_PREFETCH               0
#define M_BCM1480_PM_PREFETCH               _SB_MAKEMASK(20,S_BCM1480_PM_PREFETCH)
#define V_BCM1480_PM_PREFETCH(x)            _SB_MAKEVALUE(x,S_BCM1480_PM_PREFETCH)
#define G_BCM1480_PM_PREFETCH(x)            _SB_GETVALUE(x,S_BCM1480_PM_PREFETCH,M_BCM1480_PM_PREFETCH)


/*  *********************************************************************
    *  DMA Descriptors
    ********************************************************************* */

/*
 * Packet Manager descriptor, doubleword 0 (Figure 74)
 */

#define S_BCM1480_PM_DSCR0_RSVD             _SB_MAKE64(0)
#define M_BCM1480_PM_DSCR0_RSVD             _SB_MAKEMASK(32,S_BCM1480_PM_DSCR0_RSVD)

#define S_BCM1480_PM_DSCR0_BUFFER_LENGTH    _SB_MAKE64(32)
#define M_BCM1480_PM_DSCR0_BUFFER_LENGTH    _SB_MAKEMASK(16,S_BCM1480_PM_DSCR0_BUFFER_LENGTH)
#define V_BCM1480_PM_DSCR0_BUFFER_LENGTH(x) _SB_MAKEVALUE(x,S_BCM1480_PM_DSCR0_BUFFER_LENGTH)
#define G_BCM1480_PM_DSCR0_BUFFER_LENGTH(x) _SB_GETVALUE(x,S_BCM1480_PM_DSCR0_BUFFER_LENGTH,M_BCM1480_PM_DSCR0_BUFFER_LENGTH)

/* status/control (Table 292) */
#define M_BCM1480_PM_DSCR0_PE               _SB_MAKEMASK1(55)
#define M_BCM1480_PM_DSCR0_SE               _SB_MAKEMASK1(56)
#define M_BCM1480_PM_DSCR0_LE               _SB_MAKEMASK1(57)
#define M_BCM1480_PM_DSCR0_INT              _SB_MAKEMASK1(60)
#define M_BCM1480_PM_DSCR0_EOP              _SB_MAKEMASK1(61)
#define M_BCM1480_PM_DSCR0_SOP              _SB_MAKEMASK1(62)
#define M_BCM1480_PM_DSCR0_HW               _SB_MAKEMASK1(63)

/* source port (rx only) */
#define S_BCM1480_PM_DSCR0_SWID             _SB_MAKE64(58)
#define M_BCM1480_PM_DSCR0_SWID             _SB_MAKEMASK(2,S_BCM1480_PM_DSCR0_SWID)
#define V_BCM1480_PM_DSCR0_SWID(x)          _SB_MAKEVALUE(x,S_BCM1480_PM_DSRC0_SWID)
#define G_BCM1480_PM_DSCR0_SWID(x)          _SB_GETVALUE(x,S_BCM1480_PM_DSCR0_SWID,M_BCM1480_PM_DSCR0_SWID)
#define K_BCM1480_PM_DSCR0_SWID_RX0         0
#define K_BCM1480_PM_DSCR0_SWID_RX1         1
#define K_BCM1480_PM_DSCR0_SWID_RX2         2

/*
 * Packet Manager descriptor, doubleword 1 (Figure 74)
 */

#define S_BCM1480_PM_DSCR1_BUFFER_ADDR      _SB_MAKE64(0)
#define M_BCM1480_PM_DSCR1_BUFFER_ADDR      _SB_MAKEMASK(40,S_BCM1480_PM_DSCR1_BUFFER_ADDR)
#define V_BCM1480_PM_DSCR1_BUFFER_ADDR(x)   _SB_MAKEVALUE(x,S_BCM1480_PM_DSCR1_BUFFER_ADDR)
#define G_BCM1480_PM_DSCR1_BUFFER_ADDR(x)   _SB_GETVALUE(x,S_BCM1480_PM_DSCR1_BUFFER_ADDR,M_BCM1480_PM_DSCR1_BUFFER_ADDR)

#define S_BCM1480_PM_DSCR1_IVC              _SB_MAKE64(40)
#define M_BCM1480_PM_DSCR1_IVC              _SB_MAKEMASK(8,S_BCM1480_PM_DSCR1_IVC)
#define V_BCM1480_PM_DSCR1_IVC(x)           _SB_MAKEVALUE(x,S_BCM1480_PM_DSCR1_IVC)
#define G_BCM1480_PM_DSCR1_IVC(x)           _SB_GETVALUE(x,S_BCM1480_PM_DSCR1_IVC,M_BCM1480_PM_DSCR1_IVC)

#define S_BCM1480_PM_DSCR1_NEXT_DEST        _SB_MAKE64(48)
#define M_BCM1480_PM_DSCR1_NEXT_DEST        _SB_MAKEMASK(4,S_BCM1480_PM_DSCR1_NEXT_DEST)
#define V_BCM1480_PM_DSCR1_NEXT_DEST(x)     _SB_MAKEVALUE(x,S_BCM1480_PM_DSCR1_NEXT_DEST)
#define G_BCM1480_PM_DSCR1_NEXT_DEST(x)     _SB_GETVALUE(x,S_BCM1480_PM_DSCR1_NEXT_DEST,M_BCM1480_PM_DSCR1_NEXT_DEST)

#define S_BCM1480_PM_DSCR1_RSVD             _SB_MAKE64(52)
#define M_BCM1480_PM_DSCR1_RSVD             _SB_MAKEMASK(12,S_BCM1480_PM_DSCR1_RSVD)

/*  *********************************************************************
    *  Switch performance counters
    ********************************************************************* */

#define M_BCM1480_SWPERF_CFG_CLEAR	_SB_MAKEMASK1(62)
#define M_BCM1480_SWPERF_CFG_ENABLE	_SB_MAKEMASK1(63)

#define S_BCM1480_SWPERF_CFG_C0SRC           0
#define M_BCM1480_SWPERF_CFG_C0SRC           _SB_MAKEMASK(8,S_BCM1480_SWPERF_CFG_C0SRC)
#define V_BCM1480_SWPERF_CFG_C0SRC(x)        _SB_MAKEVALUE(x,S_BCM1480_SWPERF_CFG_C0SRC)
#define G_BCM1480_SWPERF_CFG_C0SRC(x)        _SB_GETVALUE(x,S_BCM1480_SWPERF_CFG_C0SRC,M_BCM1480_SWPERF_CFG_C0SRC)

#define S_BCM1480_SWPERF_CFG_C0FILT           8
#define M_BCM1480_SWPERF_CFG_C0FILT           _SB_MAKEMASK(3,S_BCM1480_SWPERF_CFG_C0FILT)
#define V_BCM1480_SWPERF_CFG_C0FILT(x)        _SB_MAKEVALUE(x,S_BCM1480_SWPERF_CFG_C0FILT)
#define G_BCM1480_SWPERF_CFG_C0FILT(x)        _SB_GETVALUE(x,S_BCM1480_SWPERF_CFG_C0FILT,M_BCM1480_SWPERF_CFG_C0FILT)

#define M_BCM1480_SWPERF_CFG_C0FENA		_SB_MAKEMASK1(11)

#define S_BCM1480_SWPERF_CFG_C1SRC           16
#define M_BCM1480_SWPERF_CFG_C1SRC           _SB_MAKEMASK(8,S_BCM1480_SWPERF_CFG_C1SRC)
#define V_BCM1480_SWPERF_CFG_C1SRC(x)        _SB_MAKEVALUE(x,S_BCM1480_SWPERF_CFG_C1SRC)
#define G_BCM1480_SWPERF_CFG_C1SRC(x)        _SB_GETVALUE(x,S_BCM1480_SWPERF_CFG_C1SRC,M_BCM1480_SWPERF_CFG_C1SRC)

#define S_BCM1480_SWPERF_CFG_C1FILT           24
#define M_BCM1480_SWPERF_CFG_C1FILT           _SB_MAKEMASK(3,S_BCM1480_SWPERF_CFG_C1FILT)
#define V_BCM1480_SWPERF_CFG_C1FILT(x)        _SB_MAKEVALUE(x,S_BCM1480_SWPERF_CFG_C1FILT)
#define G_BCM1480_SWPERF_CFG_C1FILT(x)        _SB_GETVALUE(x,S_BCM1480_SWPERF_CFG_C1FILT,M_BCM1480_SWPERF_CFG_C1FILT)

#define M_BCM1480_SWPERF_CFG_C1FENA		_SB_MAKEMASK1(27)

#define S_BCM1480_SWPERF_CFG_C2SRC           32
#define M_BCM1480_SWPERF_CFG_C2SRC           _SB_MAKEMASK(8,S_BCM1480_SWPERF_CFG_C2SRC)
#define V_BCM1480_SWPERF_CFG_C2SRC(x)        _SB_MAKEVALUE(x,S_BCM1480_SWPERF_CFG_C2SRC)
#define G_BCM1480_SWPERF_CFG_C2SRC(x)        _SB_GETVALUE(x,S_BCM1480_SWPERF_CFG_C2SRC,M_BCM1480_SWPERF_CFG_C2SRC)

#define S_BCM1480_SWPERF_CFG_C2FILT           40
#define M_BCM1480_SWPERF_CFG_C2FILT           _SB_MAKEMASK(3,S_BCM1480_SWPERF_CFG_C2FILT)
#define V_BCM1480_SWPERF_CFG_C2FILT(x)        _SB_MAKEVALUE(x,S_BCM1480_SWPERF_CFG_C2FILT)
#define G_BCM1480_SWPERF_CFG_C2FILT(x)        _SB_GETVALUE(x,S_BCM1480_SWPERF_CFG_C2FILT,M_BCM1480_SWPERF_CFG_C2FILT)

#define M_BCM1480_SWPERF_CFG_C2FENA		_SB_MAKEMASK1(43)

#define S_BCM1480_SWPERF_CFG_C3SRC           48
#define M_BCM1480_SWPERF_CFG_C3SRC           _SB_MAKEMASK(8,S_BCM1480_SWPERF_CFG_C3SRC)
#define V_BCM1480_SWPERF_CFG_C3SRC(x)        _SB_MAKEVALUE(x,S_BCM1480_SWPERF_CFG_C3SRC)
#define G_BCM1480_SWPERF_CFG_C3SRC(x)        _SB_GETVALUE(x,S_BCM1480_SWPERF_CFG_C3SRC,M_BCM1480_SWPERF_CFG_C3SRC)

#define S_BCM1480_SWPERF_CFG_C3FILT           56
#define M_BCM1480_SWPERF_CFG_C3FILT           _SB_MAKEMASK(3,S_BCM1480_SWPERF_CFG_C3FILT)
#define V_BCM1480_SWPERF_CFG_C3FILT(x)        _SB_MAKEVALUE(x,S_BCM1480_SWPERF_CFG_C3FILT)
#define G_BCM1480_SWPERF_CFG_C3FILT(x)        _SB_GETVALUE(x,S_BCM1480_SWPERF_CFG_C3FILT,M_BCM1480_SWPERF_CFG_C3FILT)

#define M_BCM1480_SWPERF_CFG_C3FENA		_SB_MAKEMASK1(59)

/* This macro lets you specify counters by index */

#define S_BCM1480_SWPERF_CFG_CXSRC(c)           (0+(c)*16)
#define M_BCM1480_SWPERF_CFG_CXSRC(c)           _SB_MAKEMASK(8,S_BCM1480_SWPERF_CFG_CXSRC(c))
#define V_BCM1480_SWPERF_CFG_CXSRC(c,x)        _SB_MAKEVALUE(x,S_BCM1480_SWPERF_CFG_CXSRC(c))
#define G_BCM1480_SWPERF_CFG_CXSRC(c,x)        _SB_GETVALUE(x,S_BCM1480_SWPERF_CFG_CXSRC(c),M_BCM1480_SWPERF_CFG_CXSRC(c))

#define S_BCM1480_SWPERF_CFG_CXFILT(c)           (8+(c)*16)
#define M_BCM1480_SWPERF_CFG_CXFILT(c)           _SB_MAKEMASK(3,S_BCM1480_SWPERF_CFG_CXFILT(c))
#define V_BCM1480_SWPERF_CFG_CXFILT(c,x)        _SB_MAKEVALUE(x,S_BCM1480_SWPERF_CFG_CXFILT(c))
#define G_BCM1480_SWPERF_CFG_CXFILT(c,x)        _SB_GETVALUE(x,S_BCM1480_SWPERF_CFG_CXFILT(c),M_BCM1480_SWPERF_CFG_CXFILT(c))

#define M_BCM1480_SWPERF_CFG_CXFENA(c)		_SB_MAKEMASK1(11+(c)*16)

/*
 * List of available counters
 */

#define K_BCM1480_SWPERF_CFG_CXSRC_NONE		0
#define K_BCM1480_SWPERF_CFG_CXSRC_SWCYCLES	1
#define K_BCM1480_SWPERF_CFG_CXSRC_FILTPORTS	2
#define K_BCM1480_SWPERF_CFG_CXSRC_SGNT		3
#define K_BCM1480_SWPERF_CFG_CXSRC_SREQ		4
#define K_BCM1480_SWPERF_CFG_CXSRC_SRELOA	5
#define K_BCM1480_SWPERF_CFG_CXSRC_DGNT		6
#define K_BCM1480_SWPERF_CFG_CXSRC_DREQ		7
#define K_BCM1480_SWPERF_CFG_CXSRC_DRELOAD	8

/*
 * Switch agents
 */

#define K_BCM1480_SWAGENT_HSP0		0
#define K_BCM1480_SWAGENT_HSP1	        1
#define K_BCM1480_SWAGENT_HSP2		2
#define K_BCM1480_SWAGENT_NC		4
#define K_BCM1480_SWAGENT_HT		5
#define K_BCM1480_SWAGENT_PM		6


/*  *********************************************************************
    *  Switch Trace Registers
    ********************************************************************* */

/*
 * Switch trigger control match (Table 322)
 */

#define S_BCM1480_SWTRC_MATCHCTL_VC           0
#define M_BCM1480_SWTRC_MATCHCTL_VC           _SB_MAKEMASK(32,S_BCM1480_SWTRC_MATCHCTL_VC)
#define V_BCM1480_SWTRC_MATCHCTL_VC(x)        _SB_MAKEVALUE(x,S_BCM1480_SWTRC_MATCHCTL_VC)
#define G_BCM1480_SWTRC_MATCHCTL_VC(x)        _SB_GETVALUE(x,S_BCM1480_SWTRC_MATCHCTL_VC,M_BCM1480_SWTRC_MATCHCTL_VC)

#define M_BCM1480_SWTRC_MATCHCTL_VC_X(x)       _SB_MAKEMASK1(S_BCM1480_SWTRC_MATCHCTL_VC+(x))


#define S_BCM1480_SWTRC_MATCHCTL_SRC           32
#define M_BCM1480_SWTRC_MATCHCTL_SRC           _SB_MAKEMASK(8,S_BCM1480_SWTRC_MATCHCTL_SRC)
#define V_BCM1480_SWTRC_MATCHCTL_SRC(x)        _SB_MAKEVALUE(x,S_BCM1480_SWTRC_MATCHCTL_SRC)
#define G_BCM1480_SWTRC_MATCHCTL_SRC(x)        _SB_GETVALUE(x,S_BCM1480_SWTRC_MATCHCTL_SRC,M_BCM1480_SWTRC_MATCHCTL_SRC)

#define M_BCM1480_SWTRC_MATCHCTL_SRC_X(x)       _SB_MAKEMASK1(S_BCM1480_MATCHCTL_SRC+(x))


#define S_BCM1480_SWTRC_MATCHCTL_DEST           40
#define M_BCM1480_SWTRC_MATCHCTL_DEST           _SB_MAKEMASK(8,S_BCM1480_SWTRC_MATCHCTL_DEST)
#define V_BCM1480_SWTRC_MATCHCTL_DEST(x)        _SB_MAKEVALUE(x,S_BCM1480_SWTRC_MATCHCTL_DEST)
#define G_BCM1480_SWTRC_MATCHCTL_DEST(x)        _SB_GETVALUE(x,S_BCM1480_SWTRC_MATCHCTL_DEST,M_BCM1480_SWTRC_MATCHCTL_DEST)

#define M_BCM1480_SWTRC_MATCHCTL_DEST_X(x)       _SB_MAKEMASK1(S_BCM1480_MATCHCTL_DEST+(x))

#define S_BCM1480_SWTRC_MATCHCTL_TYPE           48
#define M_BCM1480_SWTRC_MATCHCTL_TYPE           _SB_MAKEMASK(2,S_BCM1480_SWTRC_MATCHCTL_TYPE)
#define V_BCM1480_SWTRC_MATCHCTL_TYPE(x)        _SB_MAKEVALUE(x,S_BCM1480_SWTRC_MATCHCTL_TYPE)
#define G_BCM1480_SWTRC_MATCHCTL_TYPE(x)        _SB_GETVALUE(x,S_BCM1480_SWTRC_MATCHCTL_TYPE,M_BCM1480_SWTRC_MATCHCTL_TYPE)

#define K_BCM1480_SWTRC_MATCHCTL_TYPE_NONE	0
#define K_BCM1480_SWTRC_MATCHCTL_TYPE_PKTS	1
#define K_BCM1480_SWTRC_MATCHCTL_TYPE_HT	2
#define K_BCM1480_SWTRC_MATCHCTL_TYPE_PKTS_HT	3

#define S_BCM1480_SWTRC_MATCHCTL_SOP           50
#define M_BCM1480_SWTRC_MATCHCTL_SOP           _SB_MAKEMASK(2,S_BCM1480_SWTRC_MATCHCTL_SOP)
#define V_BCM1480_SWTRC_MATCHCTL_SOP(x)        _SB_MAKEVALUE(x,S_BCM1480_SWTRC_MATCHCTL_SOP)
#define G_BCM1480_SWTRC_MATCHCTL_SOP(x)        _SB_GETVALUE(x,S_BCM1480_SWTRC_MATCHCTL_SOP,M_BCM1480_SWTRC_MATCHCTL_SOP)

#define K_BCM1480_SWTRC_MATCHCTL_SOP_NONE	0
#define K_BCM1480_SWTRC_MATCHCTL_SOP_NOTSOP	1
#define K_BCM1480_SWTRC_MATCHCTL_SOP_ISSOP	2
#define K_BCM1480_SWTRC_MATCHCTL_SOP_IGNORE	3

#define S_BCM1480_SWTRC_MATCHCTL_EOP           52
#define M_BCM1480_SWTRC_MATCHCTL_EOP           _SB_MAKEMASK(2,S_BCM1480_SWTRC_MATCHCTL_EOP)
#define V_BCM1480_SWTRC_MATCHCTL_EOP(x)        _SB_MAKEVALUE(x,S_BCM1480_SWTRC_MATCHCTL_EOP)
#define G_BCM1480_SWTRC_MATCHCTL_EOP(x)        _SB_GETVALUE(x,S_BCM1480_SWTRC_MATCHCTL_EOP,M_BCM1480_SWTRC_MATCHCTL_EOP)

#define K_BCM1480_SWTRC_MATCHCTL_EOP_NONE	0
#define K_BCM1480_SWTRC_MATCHCTL_EOP_NOTEOP	1
#define K_BCM1480_SWTRC_MATCHCTL_EOP_ISEOP	2
#define K_BCM1480_SWTRC_MATCHCTL_EOP_IGNORE	3

#define S_BCM1480_SWTRC_MATCHCTL_BCAST           54
#define M_BCM1480_SWTRC_MATCHCTL_BCAST           _SB_MAKEMASK(2,S_BCM1480_SWTRC_MATCHCTL_BCAST)
#define V_BCM1480_SWTRC_MATCHCTL_BCAST(x)        _SB_MAKEVALUE(x,S_BCM1480_SWTRC_MATCHCTL_BCAST)
#define G_BCM1480_SWTRC_MATCHCTL_BCAST(x)        _SB_GETVALUE(x,S_BCM1480_SWTRC_MATCHCTL_BCAST,M_BCM1480_SWTRC_MATCHCTL_BCAST)

#define K_BCM1480_SWTRC_MATCHCTL_BCAST_NONE	0
#define K_BCM1480_SWTRC_MATCHCTL_BCAST_NOTBCAST	1
#define K_BCM1480_SWTRC_MATCHCTL_BCAST_ISBCAST	2
#define K_BCM1480_SWTRC_MATCHCTL_BCAST_IGNORE	3



/*
 * Switch Trigger Event Register (Table 325)
 */

#define S_BCM1480_SWTRC_EVT_MATCH_CTL           0
#define M_BCM1480_SWTRC_EVT_MATCH_CTL           _SB_MAKEMASK(8,S_BCM1480_SWTRC_EVT_MATCH_CTL)
#define V_BCM1480_SWTRC_EVT_MATCH_CTL(x)        _SB_MAKEVALUE(x,S_BCM1480_SWTRC_EVT_MATCH_CTL)
#define G_BCM1480_SWTRC_EVT_MATCH_CTL(x)        _SB_GETVALUE(x,S_BCM1480_SWTRC_EVT_MATCH_CTL,M_BCM1480_SWTRC_EVT_MATCH_CTL)

#define S_BCM1480_SWTRC_EVT_MATCH_DATA           8
#define M_BCM1480_SWTRC_EVT_MATCH_DATA           _SB_MAKEMASK(4,S_BCM1480_SWTRC_EVT_MATCH_DATA)
#define V_BCM1480_SWTRC_EVT_MATCH_DATA(x)        _SB_MAKEVALUE(x,S_BCM1480_SWTRC_EVT_MATCH_DATA)
#define G_BCM1480_SWTRC_EVT_MATCH_DATA(x)        _SB_GETVALUE(x,S_BCM1480_SWTRC_EVT_MATCH_DATA,M_BCM1480_SWTRC_EVT_MATCH_DATA)

#define S_BCM1480_SWTRC_EVT_MATCH_TAG           12
#define M_BCM1480_SWTRC_EVT_MATCH_TAG           _SB_MAKEMASK(4,S_BCM1480_SWTRC_EVT_MATCH_TAG)
#define V_BCM1480_SWTRC_EVT_MATCH_TAG(x)        _SB_MAKEVALUE(x,S_BCM1480_SWTRC_EVT_MATCH_TAG)
#define G_BCM1480_SWTRC_EVT_MATCH_TAG(x)        _SB_GETVALUE(x,S_BCM1480_SWTRC_EVT_MATCH_TAG,M_BCM1480_SWTRC_EVT_MATCH_TAG)

#define M_BCM1480_SWTRC_EVT_MATCH_EN		_SB_MAKEMASK1(16)
#define M_BCM1480_SWTRC_EVT_DEBUG_PIN		_SB_MAKEMASK1(20)
#define M_BCM1480_SWTRC_EVT_INTERRUPT		_SB_MAKEMASK1(21)

#define S_BCM1480_SWTRC_EVT_COUNT           24
#define M_BCM1480_SWTRC_EVT_COUNT           _SB_MAKEMASK(8,S_BCM1480_SWTRC_EVT_COUNT)
#define V_BCM1480_SWTRC_EVT_COUNT(x)        _SB_MAKEVALUE(x,S_BCM1480_SWTRC_EVT_COUNT)
#define G_BCM1480_SWTRC_EVT_COUNT(x)        _SB_GETVALUE(x,S_BCM1480_SWTRC_EVT_COUNT,M_BCM1480_SWTRC_EVT_COUNT)


/*
 * Switch Trace Sequence Control (Table 326)
 * NOTE: Event select fields are numbered from zero, not one as they are
 * in the manual.
 */

#define S_BCM1480_SWTRC_SEQ_EVSEL_3           0
#define M_BCM1480_SWTRC_SEQ_EVSEL_3           _SB_MAKEMASK(4,S_BCM1480_SWTRC_SEQ_EVSEL_3)
#define V_BCM1480_SWTRC_SEQ_EVSEL_3(x)        _SB_MAKEVALUE(x,S_BCM1480_SWTRC_SEQ_EVSEL_3)
#define G_BCM1480_SWTRC_SEQ_EVSEL_3(x)        _SB_GETVALUE(x,S_BCM1480_SWTRC_SEQ_EVSEL_3,M_BCM1480_SWTRC_SEQ_EVSEL_3)

#define S_BCM1480_SWTRC_SEQ_EVSEL_2           4
#define M_BCM1480_SWTRC_SEQ_EVSEL_2           _SB_MAKEMASK(4,S_BCM1480_SWTRC_SEQ_EVSEL_2)
#define V_BCM1480_SWTRC_SEQ_EVSEL_2(x)        _SB_MAKEVALUE(x,S_BCM1480_SWTRC_SEQ_EVSEL_2)
#define G_BCM1480_SWTRC_SEQ_EVSEL_2(x)        _SB_GETVALUE(x,S_BCM1480_SWTRC_SEQ_EVSEL_2,M_BCM1480_SWTRC_SEQ_EVSEL_2)

#define S_BCM1480_SWTRC_SEQ_EVSEL_1           8
#define M_BCM1480_SWTRC_SEQ_EVSEL_1           _SB_MAKEMASK(4,S_BCM1480_SWTRC_SEQ_EVSEL_1)
#define V_BCM1480_SWTRC_SEQ_EVSEL_1(x)        _SB_MAKEVALUE(x,S_BCM1480_SWTRC_SEQ_EVSEL_1)
#define G_BCM1480_SWTRC_SEQ_EVSEL_1(x)        _SB_GETVALUE(x,S_BCM1480_SWTRC_SEQ_EVSEL_1,M_BCM1480_SWTRC_SEQ_EVSEL_1)

#define S_BCM1480_SWTRC_SEQ_EVSEL_0           12
#define M_BCM1480_SWTRC_SEQ_EVSEL_0           _SB_MAKEMASK(4,S_BCM1480_SWTRC_SEQ_EVSEL_0)
#define V_BCM1480_SWTRC_SEQ_EVSEL_0(x)        _SB_MAKEVALUE(x,S_BCM1480_SWTRC_SEQ_EVSEL_0)
#define G_BCM1480_SWTRC_SEQ_EVSEL_0(x)        _SB_GETVALUE(x,S_BCM1480_SWTRC_SEQ_EVSEL_0,M_BCM1480_SWTRC_SEQ_EVSEL_0)

#define S_BCM1480_SWTRC_SEQ_EVSEL_X(e)        (12-((e)*4)
#define M_BCM1480_SWTRC_SEQ_EVSEL_X(e)        _SB_MAKEMASK(4,S_BCM1480_SWTRC_SEQ_EVSEL_X(e))
#define V_BCM1480_SWTRC_SEQ_EVSEL_X(e,x)      _SB_MAKEVALUE(x,S_BCM1480_SWTRC_SEQ_EVSEL_X(e))
#define G_BCM1480_SWTRC_SEQ_EVSEL_X(e,x)      _SB_GETVALUE(x,S_BCM1480_SWTRC_SEQ_EVSEL_X(e),M_BCM1480_SWTRC_SEQ_EVSEL_X(e))

#define S_BCM1480_SWTRC_SEQ_FUNCTION           16
#define M_BCM1480_SWTRC_SEQ_FUNCTION           _SB_MAKEMASK(2,S_BCM1480_SWTRC_SEQ_FUNCTION)
#define V_BCM1480_SWTRC_SEQ_FUNCTION(x)        _SB_MAKEVALUE(x,S_BCM1480_SWTRC_SEQ_FUNCTION)
#define G_BCM1480_SWTRC_SEQ_FUNCTION(x)        _SB_GETVALUE(x,S_BCM1480_SWTRC_SEQ_FUNCTION,M_BCM1480_SWTRC_SEQ_FUNCTION)

#define K_BCM1480_SWTRC_SEQ_FUNCTION_NOP	0
#define K_BCM1480_SWTRC_SEQ_FUNCTION_START	1
#define K_BCM1480_SWTRC_SEQ_FUNCTION_STOP	2
#define K_BCM1480_SWTRC_SEQ_FUNCTION_FREEZE	3

#define M_BCM1480_SWTRC_SEQ_DSAMPLE		_SB_MAKEMASK1(18)
#define M_BCM1480_SWTRC_SEQ_CSAMPLE		_SB_MAKEMASK1(19)
#define M_BCM1480_SWTRC_SEQ_DEBUGPIN		_SB_MAKEMASK1(20)
#define M_BCM1480_SWTRC_SEQ_DEBUGCPU		_SB_MAKEMASK1(21)
#define M_BCM1480_SWTRC_SEQ_CLEARUSE		_SB_MAKEMASK1(22)

#define S_BCM1480_SWTRC_SEQ_ZBBUSFUNC           26
#define M_BCM1480_SWTRC_SEQ_ZBBUSFUNC           _SB_MAKEMASK(2,S_BCM1480_SWTRC_SEQ_ZBBUSFUNC)
#define V_BCM1480_SWTRC_SEQ_ZBBUSFUNC(x)        _SB_MAKEVALUE(x,S_BCM1480_SWTRC_SEQ_ZBBUSFUNC)
#define G_BCM1480_SWTRC_SEQ_ZBBUSFUNC(x)        _SB_GETVALUE(x,S_BCM1480_SWTRC_SEQ_ZBBUSFUNC,M_BCM1480_SWTRC_SEQ_ZBBUSFUNC)

#define K_BCM1480_SWTRC_SEQ_ZBBUSFUNC_NOP	0
#define K_BCM1480_SWTRC_SEQ_ZBBUSFUNC_START	1
#define K_BCM1480_SWTRC_SEQ_ZBBUSFUNC_STOP	2
#define K_BCM1480_SWTRC_SEQ_ZBBUSFUNC_FREEZE	3

#define S_BCM1480_SWTRC_SEQ_DSAMPFILT           28
#define M_BCM1480_SWTRC_SEQ_DSAMPFILT           _SB_MAKEMASK(3,S_BCM1480_SWTRC_SEQ_DSAMPFILT)
#define V_BCM1480_SWTRC_SEQ_DSAMPFILT(x)        _SB_MAKEVALUE(x,S_BCM1480_SWTRC_SEQ_DSAMPFILT)
#define G_BCM1480_SWTRC_SEQ_DSAMPFILT(x)        _SB_GETVALUE(x,S_BCM1480_SWTRC_SEQ_DSAMPFILT,M_BCM1480_SWTRC_SEQ_DSAMPFILT)

/*
 * Switch Trace Config Register (Table 327)
 */

#define M_BCM1480_SWTRC_CFG_RESET	_SB_MAKEMASK1(0)
#define M_BCM1480_SWTRC_CFG_STARTREAD	_SB_MAKEMASK1(1)
#define M_BCM1480_SWTRC_CFG_START	_SB_MAKEMASK1(2)
#define M_BCM1480_SWTRC_CFG_STOP	_SB_MAKEMASK1(3)
#define M_BCM1480_SWTRC_CFG_FREEZE	_SB_MAKEMASK1(4)
#define M_BCM1480_SWTRC_CFG_FREEZEFULL	_SB_MAKEMASK1(5)
#define M_BCM1480_SWTRC_CFG_DEBUGFULL	_SB_MAKEMASK1(6)
#define M_BCM1480_SWTRC_CFG_TRCFULL	_SB_MAKEMASK1(7)
#define M_BCM1480_SWTRC_CFG_FORCECNT	_SB_MAKEMASK1(8)

#define S_BCM1480_SWTRC_CFG_TRCADDR           10
#define M_BCM1480_SWTRC_CFG_TRCADDR           _SB_MAKEMASK(10,S_BCM1480_SWTRC_CFG_TRCADDR)
#define V_BCM1480_SWTRC_CFG_TRCADDR(x)        _SB_MAKEVALUE(x,S_BCM1480_SWTRC_CFG_TRCADDR)
#define G_BCM1480_SWTRC_CFG_TRCADDR(x)        _SB_GETVALUE(x,S_BCM1480_SWTRC_CFG_TRCADDR,M_BCM1480_SWTRC_CFG_TRCADDR)


/*
 * Switch trace buffer entry (3 64-bit words per entry)   (Table 328)
 */

#define M_BCM1480_SWENT_VALID _SB_MAKEMASK1(63)
#define M_BCM1480_SWENT_FMT _SB_MAKEMASK1(62)
#define M_BCM1480_SWENT_MULTI _SB_MAKEMASK1(61)
#define M_BCM1480_SWENT_BCAST _SB_MAKEMASK1(60)

#define S_BCM1480_SWENT_CYCDIFF           48
#define M_BCM1480_SWENT_CYCDIFF           _SB_MAKEMASK(12,S_BCM1480_SWENT_CYCDIFF)
#define V_BCM1480_SWENT_CYCDIFF(x)        _SB_MAKEVALUE(x,S_BCM1480_SWENT_CYCDIFF)
#define G_BCM1480_SWENT_CYCDIFF(x)        _SB_GETVALUE(x,S_BCM1480_SWENT_CYCDIFF,M_BCM1480_SWENT_CYCDIFF)

#define M_BCM1480_SWENT_DRELOAD _SB_MAKEMASK1(47)
#define M_BCM1480_SWENT_SRELOAD _SB_MAKEMASK1(46)
#define M_BCM1480_SWENT_EOP _SB_MAKEMASK1(45)
#define M_BCM1480_SWENT_SOP _SB_MAKEMASK1(44)

#define S_BCM1480_SWENT_VC          39
#define M_BCM1480_SWENT_VC           _SB_MAKEMASK(5,S_BCM1480_SWENT_VC)
#define V_BCM1480_SWENT_VC(x)        _SB_MAKEVALUE(x,S_BCM1480_SWENT_VC)
#define G_BCM1480_SWENT_VC(x)        _SB_GETVALUE(x,S_BCM1480_SWENT_VC,M_BCM1480_SWENT_VC)

#define M_BCM1480_SWENT_TYPE _SB_MAKEMASK1(38)

#define S_BCM1480_SWENT_DEST          35
#define M_BCM1480_SWENT_DEST           _SB_MAKEMASK(3,S_BCM1480_SWENT_DEST)
#define V_BCM1480_SWENT_DEST(x)        _SB_MAKEVALUE(x,S_BCM1480_SWENT_DEST)
#define G_BCM1480_SWENT_DEST(x)        _SB_GETVALUE(x,S_BCM1480_SWENT_DEST,M_BCM1480_SWENT_DEST)

#define S_BCM1480_SWENT_SRC          32
#define M_BCM1480_SWENT_SRC           _SB_MAKEMASK(3,S_BCM1480_SWENT_SRC)
#define V_BCM1480_SWENT_SRC(x)        _SB_MAKEVALUE(x,S_BCM1480_SWENT_SRC)
#define G_BCM1480_SWENT_SRC(x)        _SB_GETVALUE(x,S_BCM1480_SWENT_SRC,M_BCM1480_SWENT_SRC)

#define S_BCM1480_SWENT_CNT          28
#define M_BCM1480_SWENT_CNT           _SB_MAKEMASK(4,S_BCM1480_SWENT_CNT)
#define V_BCM1480_SWENT_CNT(x)        _SB_MAKEVALUE(x,S_BCM1480_SWENT_CNT)
#define G_BCM1480_SWENT_CNT(x)        _SB_GETVALUE(x,S_BCM1480_SWENT_CNT,M_BCM1480_SWENT_CNT)

#define S_BCM1480_SWENT_TAG          0
#define M_BCM1480_SWENT_TAG           _SB_MAKEMASK(28,S_BCM1480_SWENT_TAG)
#define V_BCM1480_SWENT_TAG(x)        _SB_MAKEVALUE(x,S_BCM1480_SWENT_TAG)
#define G_BCM1480_SWENT_TAG(x)        _SB_GETVALUE(x,S_BCM1480_SWENT_TAG,M_BCM1480_SWENT_TAG)



#endif /* _BCM1480_PM_H */
