/*	$NetBSD: smu_7_0_1_sh_mask.h,v 1.3 2021/12/18 23:45:23 riastradh Exp $	*/

/*
 * SMU_7_0_1 Register documentation
 *
 * Copyright (C) 2014  Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
 * AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef SMU_7_0_1_SH_MASK_H
#define SMU_7_0_1_SH_MASK_H

#define GCK_SMC_IND_INDEX__SMC_IND_ADDR_MASK 0xffffffff
#define GCK_SMC_IND_INDEX__SMC_IND_ADDR__SHIFT 0x0
#define GCK_SMC_IND_DATA__SMC_IND_DATA_MASK 0xffffffff
#define GCK_SMC_IND_DATA__SMC_IND_DATA__SHIFT 0x0
#define CG_DCLK_CNTL__DCLK_DIVIDER_MASK 0x7f
#define CG_DCLK_CNTL__DCLK_DIVIDER__SHIFT 0x0
#define CG_DCLK_CNTL__DCLK_DIR_CNTL_EN_MASK 0x100
#define CG_DCLK_CNTL__DCLK_DIR_CNTL_EN__SHIFT 0x8
#define CG_DCLK_CNTL__DCLK_DIR_CNTL_TOG_MASK 0x200
#define CG_DCLK_CNTL__DCLK_DIR_CNTL_TOG__SHIFT 0x9
#define CG_DCLK_CNTL__DCLK_DIR_CNTL_DIVIDER_MASK 0x1fc00
#define CG_DCLK_CNTL__DCLK_DIR_CNTL_DIVIDER__SHIFT 0xa
#define CG_DCLK_STATUS__DCLK_STATUS_MASK 0x1
#define CG_DCLK_STATUS__DCLK_STATUS__SHIFT 0x0
#define CG_DCLK_STATUS__DCLK_DIR_CNTL_DONETOG_MASK 0x2
#define CG_DCLK_STATUS__DCLK_DIR_CNTL_DONETOG__SHIFT 0x1
#define CG_VCLK_CNTL__VCLK_DIVIDER_MASK 0x7f
#define CG_VCLK_CNTL__VCLK_DIVIDER__SHIFT 0x0
#define CG_VCLK_CNTL__VCLK_DIR_CNTL_EN_MASK 0x100
#define CG_VCLK_CNTL__VCLK_DIR_CNTL_EN__SHIFT 0x8
#define CG_VCLK_CNTL__VCLK_DIR_CNTL_TOG_MASK 0x200
#define CG_VCLK_CNTL__VCLK_DIR_CNTL_TOG__SHIFT 0x9
#define CG_VCLK_CNTL__VCLK_DIR_CNTL_DIVIDER_MASK 0x1fc00
#define CG_VCLK_CNTL__VCLK_DIR_CNTL_DIVIDER__SHIFT 0xa
#define CG_VCLK_STATUS__VCLK_STATUS_MASK 0x1
#define CG_VCLK_STATUS__VCLK_STATUS__SHIFT 0x0
#define CG_VCLK_STATUS__VCLK_DIR_CNTL_DONETOG_MASK 0x2
#define CG_VCLK_STATUS__VCLK_DIR_CNTL_DONETOG__SHIFT 0x1
#define CG_ECLK_CNTL__ECLK_DIVIDER_MASK 0x7f
#define CG_ECLK_CNTL__ECLK_DIVIDER__SHIFT 0x0
#define CG_ECLK_CNTL__ECLK_DIR_CNTL_EN_MASK 0x100
#define CG_ECLK_CNTL__ECLK_DIR_CNTL_EN__SHIFT 0x8
#define CG_ECLK_CNTL__ECLK_DIR_CNTL_TOG_MASK 0x200
#define CG_ECLK_CNTL__ECLK_DIR_CNTL_TOG__SHIFT 0x9
#define CG_ECLK_CNTL__ECLK_DIR_CNTL_DIVIDER_MASK 0x1fc00
#define CG_ECLK_CNTL__ECLK_DIR_CNTL_DIVIDER__SHIFT 0xa
#define CG_ECLK_STATUS__ECLK_STATUS_MASK 0x1
#define CG_ECLK_STATUS__ECLK_STATUS__SHIFT 0x0
#define CG_ECLK_STATUS__ECLK_DIR_CNTL_DONETOG_MASK 0x2
#define CG_ECLK_STATUS__ECLK_DIR_CNTL_DONETOG__SHIFT 0x1
#define CG_ACLK_CNTL__ACLK_DIVIDER_MASK 0x7f
#define CG_ACLK_CNTL__ACLK_DIVIDER__SHIFT 0x0
#define CG_ACLK_CNTL__ACLK_DIR_CNTL_EN_MASK 0x100
#define CG_ACLK_CNTL__ACLK_DIR_CNTL_EN__SHIFT 0x8
#define CG_ACLK_CNTL__ACLK_DIR_CNTL_TOG_MASK 0x200
#define CG_ACLK_CNTL__ACLK_DIR_CNTL_TOG__SHIFT 0x9
#define CG_ACLK_CNTL__ACLK_DIR_CNTL_DIVIDER_MASK 0x1fc00
#define CG_ACLK_CNTL__ACLK_DIR_CNTL_DIVIDER__SHIFT 0xa
#define GCK_DFS_BYPASS_CNTL__BYPASSECLK_MASK 0x1
#define GCK_DFS_BYPASS_CNTL__BYPASSECLK__SHIFT 0x0
#define GCK_DFS_BYPASS_CNTL__BYPASSLCLK_MASK 0x2
#define GCK_DFS_BYPASS_CNTL__BYPASSLCLK__SHIFT 0x1
#define GCK_DFS_BYPASS_CNTL__BYPASSEVCLK_MASK 0x4
#define GCK_DFS_BYPASS_CNTL__BYPASSEVCLK__SHIFT 0x2
#define GCK_DFS_BYPASS_CNTL__BYPASSDCLK_MASK 0x8
#define GCK_DFS_BYPASS_CNTL__BYPASSDCLK__SHIFT 0x3
#define GCK_DFS_BYPASS_CNTL__BYPASSVCLK_MASK 0x10
#define GCK_DFS_BYPASS_CNTL__BYPASSVCLK__SHIFT 0x4
#define GCK_DFS_BYPASS_CNTL__BYPASSDISPCLK_MASK 0x20
#define GCK_DFS_BYPASS_CNTL__BYPASSDISPCLK__SHIFT 0x5
#define GCK_DFS_BYPASS_CNTL__BYPASSDPREFCLK_MASK 0x40
#define GCK_DFS_BYPASS_CNTL__BYPASSDPREFCLK__SHIFT 0x6
#define GCK_DFS_BYPASS_CNTL__BYPASSACLK_MASK 0x80
#define GCK_DFS_BYPASS_CNTL__BYPASSACLK__SHIFT 0x7
#define GCK_DFS_BYPASS_CNTL__BYPASSADIVCLK_MASK 0x100
#define GCK_DFS_BYPASS_CNTL__BYPASSADIVCLK__SHIFT 0x8
#define GCK_DFS_BYPASS_CNTL__BYPASSPSPCLK_MASK 0x200
#define GCK_DFS_BYPASS_CNTL__BYPASSPSPCLK__SHIFT 0x9
#define GCK_DFS_BYPASS_CNTL__BYPASSSAMCLK_MASK 0x400
#define GCK_DFS_BYPASS_CNTL__BYPASSSAMCLK__SHIFT 0xa
#define GCK_DFS_BYPASS_CNTL__BYPASSSCLK_MASK 0x800
#define GCK_DFS_BYPASS_CNTL__BYPASSSCLK__SHIFT 0xb
#define GCK_DFS_BYPASS_CNTL__USE_SPLL_BYPASS_EN_MASK 0x1000
#define GCK_DFS_BYPASS_CNTL__USE_SPLL_BYPASS_EN__SHIFT 0xc
#define CG_SPLL_FUNC_CNTL__SPLL_RESET_MASK 0x1
#define CG_SPLL_FUNC_CNTL__SPLL_RESET__SHIFT 0x0
#define CG_SPLL_FUNC_CNTL__SPLL_PWRON_MASK 0x2
#define CG_SPLL_FUNC_CNTL__SPLL_PWRON__SHIFT 0x1
#define CG_SPLL_FUNC_CNTL__SPLL_DIVEN_MASK 0x4
#define CG_SPLL_FUNC_CNTL__SPLL_DIVEN__SHIFT 0x2
#define CG_SPLL_FUNC_CNTL__SPLL_BYPASS_EN_MASK 0x8
#define CG_SPLL_FUNC_CNTL__SPLL_BYPASS_EN__SHIFT 0x3
#define CG_SPLL_FUNC_CNTL__SPLL_BYPASS_THRU_DFS_MASK 0x10
#define CG_SPLL_FUNC_CNTL__SPLL_BYPASS_THRU_DFS__SHIFT 0x4
#define CG_SPLL_FUNC_CNTL__SPLL_REF_DIV_MASK 0x7e0
#define CG_SPLL_FUNC_CNTL__SPLL_REF_DIV__SHIFT 0x5
#define CG_SPLL_FUNC_CNTL__SPLL_PDIV_A_UPDATE_MASK 0x800
#define CG_SPLL_FUNC_CNTL__SPLL_PDIV_A_UPDATE__SHIFT 0xb
#define CG_SPLL_FUNC_CNTL__SPLL_PDIV_A_EN_MASK 0x1000
#define CG_SPLL_FUNC_CNTL__SPLL_PDIV_A_EN__SHIFT 0xc
#define CG_SPLL_FUNC_CNTL__SPLL_PDIV_A_MASK 0x7f00000
#define CG_SPLL_FUNC_CNTL__SPLL_PDIV_A__SHIFT 0x14
#define CG_SPLL_FUNC_CNTL__SPLL_DIVA_ACK_MASK 0x8000000
#define CG_SPLL_FUNC_CNTL__SPLL_DIVA_ACK__SHIFT 0x1b
#define CG_SPLL_FUNC_CNTL__SPLL_OTEST_LOCK_EN_MASK 0x10000000
#define CG_SPLL_FUNC_CNTL__SPLL_OTEST_LOCK_EN__SHIFT 0x1c
#define CG_SPLL_FUNC_CNTL_2__SCLK_MUX_SEL_MASK 0x1ff
#define CG_SPLL_FUNC_CNTL_2__SCLK_MUX_SEL__SHIFT 0x0
#define CG_SPLL_FUNC_CNTL_2__SPLL_CTLREQ_MASK 0x800
#define CG_SPLL_FUNC_CNTL_2__SPLL_CTLREQ__SHIFT 0xb
#define CG_SPLL_FUNC_CNTL_2__SPLL_BYPASS_CHG_MASK 0x400000
#define CG_SPLL_FUNC_CNTL_2__SPLL_BYPASS_CHG__SHIFT 0x16
#define CG_SPLL_FUNC_CNTL_2__SPLL_CTLREQ_CHG_MASK 0x800000
#define CG_SPLL_FUNC_CNTL_2__SPLL_CTLREQ_CHG__SHIFT 0x17
#define CG_SPLL_FUNC_CNTL_2__SPLL_RESET_CHG_MASK 0x1000000
#define CG_SPLL_FUNC_CNTL_2__SPLL_RESET_CHG__SHIFT 0x18
#define CG_SPLL_FUNC_CNTL_2__SPLL_BABY_STEP_CHG_MASK 0x2000000
#define CG_SPLL_FUNC_CNTL_2__SPLL_BABY_STEP_CHG__SHIFT 0x19
#define CG_SPLL_FUNC_CNTL_2__SCLK_MUX_UPDATE_MASK 0x4000000
#define CG_SPLL_FUNC_CNTL_2__SCLK_MUX_UPDATE__SHIFT 0x1a
#define CG_SPLL_FUNC_CNTL_2__SPLL_UNLOCK_CLEAR_MASK 0x8000000
#define CG_SPLL_FUNC_CNTL_2__SPLL_UNLOCK_CLEAR__SHIFT 0x1b
#define CG_SPLL_FUNC_CNTL_2__SPLL_CLKF_UPDATE_MASK 0x10000000
#define CG_SPLL_FUNC_CNTL_2__SPLL_CLKF_UPDATE__SHIFT 0x1c
#define CG_SPLL_FUNC_CNTL_2__SPLL_TEST_UNLOCK_CLR_MASK 0x40000000
#define CG_SPLL_FUNC_CNTL_2__SPLL_TEST_UNLOCK_CLR__SHIFT 0x1e
#define CG_SPLL_FUNC_CNTL_3__SPLL_FB_DIV_MASK 0x3ffffff
#define CG_SPLL_FUNC_CNTL_3__SPLL_FB_DIV__SHIFT 0x0
#define CG_SPLL_FUNC_CNTL_3__SPLL_DITHEN_MASK 0x10000000
#define CG_SPLL_FUNC_CNTL_3__SPLL_DITHEN__SHIFT 0x1c
#define CG_SPLL_FUNC_CNTL_4__SPLL_SCLK_TEST_SEL_MASK 0xf
#define CG_SPLL_FUNC_CNTL_4__SPLL_SCLK_TEST_SEL__SHIFT 0x0
#define CG_SPLL_FUNC_CNTL_4__SPLL_SCLK_EXT_SEL_MASK 0x60
#define CG_SPLL_FUNC_CNTL_4__SPLL_SCLK_EXT_SEL__SHIFT 0x5
#define CG_SPLL_FUNC_CNTL_4__SPLL_SCLK_EN_MASK 0x180
#define CG_SPLL_FUNC_CNTL_4__SPLL_SCLK_EN__SHIFT 0x7
#define CG_SPLL_FUNC_CNTL_4__SPLL_SPARE_MASK 0x7fe00
#define CG_SPLL_FUNC_CNTL_4__SPLL_SPARE__SHIFT 0x9
#define CG_SPLL_FUNC_CNTL_4__TEST_FRAC_BYPASS_MASK 0x200000
#define CG_SPLL_FUNC_CNTL_4__TEST_FRAC_BYPASS__SHIFT 0x15
#define CG_SPLL_FUNC_CNTL_4__SPLL_ILOCK_MASK 0x800000
#define CG_SPLL_FUNC_CNTL_4__SPLL_ILOCK__SHIFT 0x17
#define CG_SPLL_FUNC_CNTL_4__SPLL_FBCLK_SEL_MASK 0x1000000
#define CG_SPLL_FUNC_CNTL_4__SPLL_FBCLK_SEL__SHIFT 0x18
#define CG_SPLL_FUNC_CNTL_4__SPLL_VCTRLADC_EN_MASK 0x2000000
#define CG_SPLL_FUNC_CNTL_4__SPLL_VCTRLADC_EN__SHIFT 0x19
#define CG_SPLL_FUNC_CNTL_4__SPLL_SCLK_EXT_MASK 0xc000000
#define CG_SPLL_FUNC_CNTL_4__SPLL_SCLK_EXT__SHIFT 0x1a
#define CG_SPLL_FUNC_CNTL_4__SPLL_SPARE_EXT_MASK 0x70000000
#define CG_SPLL_FUNC_CNTL_4__SPLL_SPARE_EXT__SHIFT 0x1c
#define CG_SPLL_FUNC_CNTL_4__SPLL_VTOI_BIAS_CNTL_MASK 0x80000000
#define CG_SPLL_FUNC_CNTL_4__SPLL_VTOI_BIAS_CNTL__SHIFT 0x1f
#define CG_SPLL_FUNC_CNTL_5__FBDIV_SSC_BYPASS_MASK 0x1
#define CG_SPLL_FUNC_CNTL_5__FBDIV_SSC_BYPASS__SHIFT 0x0
#define CG_SPLL_FUNC_CNTL_5__RISEFBVCO_EN_MASK 0x2
#define CG_SPLL_FUNC_CNTL_5__RISEFBVCO_EN__SHIFT 0x1
#define CG_SPLL_FUNC_CNTL_5__PFD_RESET_CNTRL_MASK 0xc
#define CG_SPLL_FUNC_CNTL_5__PFD_RESET_CNTRL__SHIFT 0x2
#define CG_SPLL_FUNC_CNTL_5__RESET_TIMER_MASK 0x30
#define CG_SPLL_FUNC_CNTL_5__RESET_TIMER__SHIFT 0x4
#define CG_SPLL_FUNC_CNTL_5__FAST_LOCK_CNTRL_MASK 0xc0
#define CG_SPLL_FUNC_CNTL_5__FAST_LOCK_CNTRL__SHIFT 0x6
#define CG_SPLL_FUNC_CNTL_5__FAST_LOCK_EN_MASK 0x100
#define CG_SPLL_FUNC_CNTL_5__FAST_LOCK_EN__SHIFT 0x8
#define CG_SPLL_FUNC_CNTL_5__RESET_ANTI_MUX_MASK 0x200
#define CG_SPLL_FUNC_CNTL_5__RESET_ANTI_MUX__SHIFT 0x9
#define CG_SPLL_FUNC_CNTL_6__SCLKMUX0_CLKOFF_CNT_MASK 0xff
#define CG_SPLL_FUNC_CNTL_6__SCLKMUX0_CLKOFF_CNT__SHIFT 0x0
#define CG_SPLL_FUNC_CNTL_6__SCLKMUX1_CLKOFF_CNT_MASK 0xff00
#define CG_SPLL_FUNC_CNTL_6__SCLKMUX1_CLKOFF_CNT__SHIFT 0x8
#define CG_SPLL_FUNC_CNTL_6__SPLL_VCTL_EN_MASK 0x10000
#define CG_SPLL_FUNC_CNTL_6__SPLL_VCTL_EN__SHIFT 0x10
#define CG_SPLL_FUNC_CNTL_6__SPLL_VCTL_CNTRL_IN_MASK 0x1e0000
#define CG_SPLL_FUNC_CNTL_6__SPLL_VCTL_CNTRL_IN__SHIFT 0x11
#define CG_SPLL_FUNC_CNTL_6__SPLL_VCTL_CNTRL_OUT_MASK 0x1e00000
#define CG_SPLL_FUNC_CNTL_6__SPLL_VCTL_CNTRL_OUT__SHIFT 0x15
#define CG_SPLL_FUNC_CNTL_6__SPLL_LF_CNTR_MASK 0xfe000000
#define CG_SPLL_FUNC_CNTL_6__SPLL_LF_CNTR__SHIFT 0x19
#define CG_SPLL_FUNC_CNTL_7__SPLL_BW_CNTRL_MASK 0xfff
#define CG_SPLL_FUNC_CNTL_7__SPLL_BW_CNTRL__SHIFT 0x0
#define CG_SPLL_STATUS__SPLL_CHG_STATUS_MASK 0x2
#define CG_SPLL_STATUS__SPLL_CHG_STATUS__SHIFT 0x1
#define SPLL_CNTL_MODE__SPLL_SW_DIR_CONTROL_MASK 0x1
#define SPLL_CNTL_MODE__SPLL_SW_DIR_CONTROL__SHIFT 0x0
#define SPLL_CNTL_MODE__SPLL_LEGACY_PDIV_MASK 0x2
#define SPLL_CNTL_MODE__SPLL_LEGACY_PDIV__SHIFT 0x1
#define SPLL_CNTL_MODE__SPLL_TEST_MASK 0x4
#define SPLL_CNTL_MODE__SPLL_TEST__SHIFT 0x2
#define SPLL_CNTL_MODE__SPLL_FASTEN_MASK 0x8
#define SPLL_CNTL_MODE__SPLL_FASTEN__SHIFT 0x3
#define SPLL_CNTL_MODE__SPLL_ENSAT_MASK 0x10
#define SPLL_CNTL_MODE__SPLL_ENSAT__SHIFT 0x4
#define SPLL_CNTL_MODE__SPLL_TEST_CLK_EXT_DIV_MASK 0xc00
#define SPLL_CNTL_MODE__SPLL_TEST_CLK_EXT_DIV__SHIFT 0xa
#define SPLL_CNTL_MODE__SPLL_CTLREQ_DLY_CNT_MASK 0xff000
#define SPLL_CNTL_MODE__SPLL_CTLREQ_DLY_CNT__SHIFT 0xc
#define SPLL_CNTL_MODE__SPLL_RESET_EN_MASK 0x10000000
#define SPLL_CNTL_MODE__SPLL_RESET_EN__SHIFT 0x1c
#define SPLL_CNTL_MODE__SPLL_VCO_MODE_MASK 0x60000000
#define SPLL_CNTL_MODE__SPLL_VCO_MODE__SHIFT 0x1d
#define CG_SPLL_SPREAD_SPECTRUM__SSEN_MASK 0x1
#define CG_SPLL_SPREAD_SPECTRUM__SSEN__SHIFT 0x0
#define CG_SPLL_SPREAD_SPECTRUM__CLKS_MASK 0xfff0
#define CG_SPLL_SPREAD_SPECTRUM__CLKS__SHIFT 0x4
#define CG_SPLL_SPREAD_SPECTRUM_2__CLKV_MASK 0x3ffffff
#define CG_SPLL_SPREAD_SPECTRUM_2__CLKV__SHIFT 0x0
#define MPLL_BYPASSCLK_SEL__MPLL_CLKOUT_SEL_MASK 0xff00
#define MPLL_BYPASSCLK_SEL__MPLL_CLKOUT_SEL__SHIFT 0x8
#define CG_CLKPIN_CNTL__XTALIN_DIVIDE_MASK 0x2
#define CG_CLKPIN_CNTL__XTALIN_DIVIDE__SHIFT 0x1
#define CG_CLKPIN_CNTL__BCLK_AS_XCLK_MASK 0x4
#define CG_CLKPIN_CNTL__BCLK_AS_XCLK__SHIFT 0x2
#define CG_CLKPIN_CNTL_2__ENABLE_XCLK_MASK 0x1
#define CG_CLKPIN_CNTL_2__ENABLE_XCLK__SHIFT 0x0
#define CG_CLKPIN_CNTL_2__FORCE_BIF_REFCLK_EN_MASK 0x8
#define CG_CLKPIN_CNTL_2__FORCE_BIF_REFCLK_EN__SHIFT 0x3
#define CG_CLKPIN_CNTL_2__MUX_TCLK_TO_XCLK_MASK 0x100
#define CG_CLKPIN_CNTL_2__MUX_TCLK_TO_XCLK__SHIFT 0x8
#define CG_CLKPIN_CNTL_2__XO_IN_OSCIN_EN_MASK 0x4000
#define CG_CLKPIN_CNTL_2__XO_IN_OSCIN_EN__SHIFT 0xe
#define CG_CLKPIN_CNTL_2__XO_IN_ICORE_CLK_OE_MASK 0x8000
#define CG_CLKPIN_CNTL_2__XO_IN_ICORE_CLK_OE__SHIFT 0xf
#define CG_CLKPIN_CNTL_2__XO_IN_CML_RXEN_MASK 0x10000
#define CG_CLKPIN_CNTL_2__XO_IN_CML_RXEN__SHIFT 0x10
#define CG_CLKPIN_CNTL_2__XO_IN_BIDIR_CML_OE_MASK 0x20000
#define CG_CLKPIN_CNTL_2__XO_IN_BIDIR_CML_OE__SHIFT 0x11
#define CG_CLKPIN_CNTL_2__XO_IN2_OSCIN_EN_MASK 0x40000
#define CG_CLKPIN_CNTL_2__XO_IN2_OSCIN_EN__SHIFT 0x12
#define CG_CLKPIN_CNTL_2__XO_IN2_ICORE_CLK_OE_MASK 0x80000
#define CG_CLKPIN_CNTL_2__XO_IN2_ICORE_CLK_OE__SHIFT 0x13
#define CG_CLKPIN_CNTL_2__XO_IN2_CML_RXEN_MASK 0x100000
#define CG_CLKPIN_CNTL_2__XO_IN2_CML_RXEN__SHIFT 0x14
#define CG_CLKPIN_CNTL_2__XO_IN2_BIDIR_CML_OE_MASK 0x200000
#define CG_CLKPIN_CNTL_2__XO_IN2_BIDIR_CML_OE__SHIFT 0x15
#define CG_CLKPIN_CNTL_2__CML_CTRL_MASK 0xc00000
#define CG_CLKPIN_CNTL_2__CML_CTRL__SHIFT 0x16
#define CG_CLKPIN_CNTL_2__CLK_SPARE_MASK 0xff000000
#define CG_CLKPIN_CNTL_2__CLK_SPARE__SHIFT 0x18
#define CG_CLKPIN_CNTL_DC__OSC_EN_MASK 0x1
#define CG_CLKPIN_CNTL_DC__OSC_EN__SHIFT 0x0
#define CG_CLKPIN_CNTL_DC__XTL_LOW_GAIN_MASK 0x6
#define CG_CLKPIN_CNTL_DC__XTL_LOW_GAIN__SHIFT 0x1
#define CG_CLKPIN_CNTL_DC__XTALIN_SEL_MASK 0x1c00
#define CG_CLKPIN_CNTL_DC__XTALIN_SEL__SHIFT 0xa
#define THM_CLK_CNTL__CMON_CLK_SEL_MASK 0xff
#define THM_CLK_CNTL__CMON_CLK_SEL__SHIFT 0x0
#define THM_CLK_CNTL__TMON_CLK_SEL_MASK 0xff00
#define THM_CLK_CNTL__TMON_CLK_SEL__SHIFT 0x8
#define THM_CLK_CNTL__CTF_CLK_SHUTOFF_EN_MASK 0x10000
#define THM_CLK_CNTL__CTF_CLK_SHUTOFF_EN__SHIFT 0x10
#define MISC_CLK_CTRL__DEEP_SLEEP_CLK_SEL_MASK 0xff
#define MISC_CLK_CTRL__DEEP_SLEEP_CLK_SEL__SHIFT 0x0
#define MISC_CLK_CTRL__ZCLK_SEL_MASK 0xff00
#define MISC_CLK_CTRL__ZCLK_SEL__SHIFT 0x8
#define MISC_CLK_CTRL__DFT_SMS_PG_CLK_SEL_MASK 0xff0000
#define MISC_CLK_CTRL__DFT_SMS_PG_CLK_SEL__SHIFT 0x10
#define GCK_PLL_TEST_CNTL__TST_SRC_SEL_MASK 0x1f
#define GCK_PLL_TEST_CNTL__TST_SRC_SEL__SHIFT 0x0
#define GCK_PLL_TEST_CNTL__TST_REF_SEL_MASK 0x3e0
#define GCK_PLL_TEST_CNTL__TST_REF_SEL__SHIFT 0x5
#define GCK_PLL_TEST_CNTL__REF_TEST_COUNT_MASK 0x1fc00
#define GCK_PLL_TEST_CNTL__REF_TEST_COUNT__SHIFT 0xa
#define GCK_PLL_TEST_CNTL__TST_RESET_MASK 0x20000
#define GCK_PLL_TEST_CNTL__TST_RESET__SHIFT 0x11
#define GCK_PLL_TEST_CNTL__TST_CLK_SEL_MODE_MASK 0x40000
#define GCK_PLL_TEST_CNTL__TST_CLK_SEL_MODE__SHIFT 0x12
#define GCK_PLL_TEST_CNTL_2__TEST_COUNT_MASK 0xfffe0000
#define GCK_PLL_TEST_CNTL_2__TEST_COUNT__SHIFT 0x11
#define GCK_ADFS_CLK_BYPASS_CNTL1__ECLK_BYPASS_CNTL_MASK 0x7
#define GCK_ADFS_CLK_BYPASS_CNTL1__ECLK_BYPASS_CNTL__SHIFT 0x0
#define GCK_ADFS_CLK_BYPASS_CNTL1__SCLK_BYPASS_CNTL_MASK 0x38
#define GCK_ADFS_CLK_BYPASS_CNTL1__SCLK_BYPASS_CNTL__SHIFT 0x3
#define GCK_ADFS_CLK_BYPASS_CNTL1__LCLK_BYPASS_CNTL_MASK 0x1c0
#define GCK_ADFS_CLK_BYPASS_CNTL1__LCLK_BYPASS_CNTL__SHIFT 0x6
#define GCK_ADFS_CLK_BYPASS_CNTL1__DCLK_BYPASS_CNTL_MASK 0xe00
#define GCK_ADFS_CLK_BYPASS_CNTL1__DCLK_BYPASS_CNTL__SHIFT 0x9
#define GCK_ADFS_CLK_BYPASS_CNTL1__VCLK_BYPASS_CNTL_MASK 0x7000
#define GCK_ADFS_CLK_BYPASS_CNTL1__VCLK_BYPASS_CNTL__SHIFT 0xc
#define GCK_ADFS_CLK_BYPASS_CNTL1__DISPCLK_BYPASS_CNTL_MASK 0x38000
#define GCK_ADFS_CLK_BYPASS_CNTL1__DISPCLK_BYPASS_CNTL__SHIFT 0xf
#define GCK_ADFS_CLK_BYPASS_CNTL1__DRREFCLK_BYPASS_CNTL_MASK 0x1c0000
#define GCK_ADFS_CLK_BYPASS_CNTL1__DRREFCLK_BYPASS_CNTL__SHIFT 0x12
#define GCK_ADFS_CLK_BYPASS_CNTL1__ACLK_BYPASS_CNTL_MASK 0xe00000
#define GCK_ADFS_CLK_BYPASS_CNTL1__ACLK_BYPASS_CNTL__SHIFT 0x15
#define GCK_ADFS_CLK_BYPASS_CNTL1__SAMCLK_BYPASS_CNTL_MASK 0x7000000
#define GCK_ADFS_CLK_BYPASS_CNTL1__SAMCLK_BYPASS_CNTL__SHIFT 0x18
#define GCK_ADFS_CLK_BYPASS_CNTL1__ACLK_DIV_BYPASS_CNTL_MASK 0x38000000
#define GCK_ADFS_CLK_BYPASS_CNTL1__ACLK_DIV_BYPASS_CNTL__SHIFT 0x1b
#define SMC_IND_INDEX__SMC_IND_ADDR_MASK 0xffffffff
#define SMC_IND_INDEX__SMC_IND_ADDR__SHIFT 0x0
#define SMC_IND_DATA__SMC_IND_DATA_MASK 0xffffffff
#define SMC_IND_DATA__SMC_IND_DATA__SHIFT 0x0
#define SMC_IND_INDEX_0__SMC_IND_ADDR_MASK 0xffffffff
#define SMC_IND_INDEX_0__SMC_IND_ADDR__SHIFT 0x0
#define SMC_IND_DATA_0__SMC_IND_DATA_MASK 0xffffffff
#define SMC_IND_DATA_0__SMC_IND_DATA__SHIFT 0x0
#define SMC_IND_INDEX_1__SMC_IND_ADDR_MASK 0xffffffff
#define SMC_IND_INDEX_1__SMC_IND_ADDR__SHIFT 0x0
#define SMC_IND_DATA_1__SMC_IND_DATA_MASK 0xffffffff
#define SMC_IND_DATA_1__SMC_IND_DATA__SHIFT 0x0
#define SMC_IND_INDEX_2__SMC_IND_ADDR_MASK 0xffffffff
#define SMC_IND_INDEX_2__SMC_IND_ADDR__SHIFT 0x0
#define SMC_IND_DATA_2__SMC_IND_DATA_MASK 0xffffffff
#define SMC_IND_DATA_2__SMC_IND_DATA__SHIFT 0x0
#define SMC_IND_INDEX_3__SMC_IND_ADDR_MASK 0xffffffff
#define SMC_IND_INDEX_3__SMC_IND_ADDR__SHIFT 0x0
#define SMC_IND_DATA_3__SMC_IND_DATA_MASK 0xffffffff
#define SMC_IND_DATA_3__SMC_IND_DATA__SHIFT 0x0
#define SMC_IND_INDEX_4__SMC_IND_ADDR_MASK 0xffffffff
#define SMC_IND_INDEX_4__SMC_IND_ADDR__SHIFT 0x0
#define SMC_IND_DATA_4__SMC_IND_DATA_MASK 0xffffffff
#define SMC_IND_DATA_4__SMC_IND_DATA__SHIFT 0x0
#define SMC_IND_INDEX_5__SMC_IND_ADDR_MASK 0xffffffff
#define SMC_IND_INDEX_5__SMC_IND_ADDR__SHIFT 0x0
#define SMC_IND_DATA_5__SMC_IND_DATA_MASK 0xffffffff
#define SMC_IND_DATA_5__SMC_IND_DATA__SHIFT 0x0
#define SMC_IND_INDEX_6__SMC_IND_ADDR_MASK 0xffffffff
#define SMC_IND_INDEX_6__SMC_IND_ADDR__SHIFT 0x0
#define SMC_IND_DATA_6__SMC_IND_DATA_MASK 0xffffffff
#define SMC_IND_DATA_6__SMC_IND_DATA__SHIFT 0x0
#define SMC_IND_INDEX_7__SMC_IND_ADDR_MASK 0xffffffff
#define SMC_IND_INDEX_7__SMC_IND_ADDR__SHIFT 0x0
#define SMC_IND_DATA_7__SMC_IND_DATA_MASK 0xffffffff
#define SMC_IND_DATA_7__SMC_IND_DATA__SHIFT 0x0
#define SMC_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_0_MASK 0x1
#define SMC_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_0__SHIFT 0x0
#define SMC_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_1_MASK 0x2
#define SMC_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_1__SHIFT 0x1
#define SMC_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_2_MASK 0x4
#define SMC_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_2__SHIFT 0x2
#define SMC_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_3_MASK 0x8
#define SMC_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_3__SHIFT 0x3
#define SMC_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_4_MASK 0x10
#define SMC_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_4__SHIFT 0x4
#define SMC_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_5_MASK 0x20
#define SMC_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_5__SHIFT 0x5
#define SMC_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_6_MASK 0x40
#define SMC_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_6__SHIFT 0x6
#define SMC_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_7_MASK 0x80
#define SMC_IND_ACCESS_CNTL__AUTO_INCREMENT_IND_7__SHIFT 0x7
#define SMC_MESSAGE_0__SMC_MSG_MASK 0xffff
#define SMC_MESSAGE_0__SMC_MSG__SHIFT 0x0
#define SMC_RESP_0__SMC_RESP_MASK 0xffff
#define SMC_RESP_0__SMC_RESP__SHIFT 0x0
#define SMC_MESSAGE_1__SMC_MSG_MASK 0xffff
#define SMC_MESSAGE_1__SMC_MSG__SHIFT 0x0
#define SMC_RESP_1__SMC_RESP_MASK 0xffff
#define SMC_RESP_1__SMC_RESP__SHIFT 0x0
#define SMC_MESSAGE_2__SMC_MSG_MASK 0xffff
#define SMC_MESSAGE_2__SMC_MSG__SHIFT 0x0
#define SMC_RESP_2__SMC_RESP_MASK 0xffff
#define SMC_RESP_2__SMC_RESP__SHIFT 0x0
#define SMC_MESSAGE_3__SMC_MSG_MASK 0xffff
#define SMC_MESSAGE_3__SMC_MSG__SHIFT 0x0
#define SMC_RESP_3__SMC_RESP_MASK 0xffff
#define SMC_RESP_3__SMC_RESP__SHIFT 0x0
#define SMC_MESSAGE_4__SMC_MSG_MASK 0xffff
#define SMC_MESSAGE_4__SMC_MSG__SHIFT 0x0
#define SMC_RESP_4__SMC_RESP_MASK 0xffff
#define SMC_RESP_4__SMC_RESP__SHIFT 0x0
#define SMC_MESSAGE_5__SMC_MSG_MASK 0xffff
#define SMC_MESSAGE_5__SMC_MSG__SHIFT 0x0
#define SMC_RESP_5__SMC_RESP_MASK 0xffff
#define SMC_RESP_5__SMC_RESP__SHIFT 0x0
#define SMC_MESSAGE_6__SMC_MSG_MASK 0xffff
#define SMC_MESSAGE_6__SMC_MSG__SHIFT 0x0
#define SMC_RESP_6__SMC_RESP_MASK 0xffff
#define SMC_RESP_6__SMC_RESP__SHIFT 0x0
#define SMC_MESSAGE_7__SMC_MSG_MASK 0xffff
#define SMC_MESSAGE_7__SMC_MSG__SHIFT 0x0
#define SMC_RESP_7__SMC_RESP_MASK 0xffff
#define SMC_RESP_7__SMC_RESP__SHIFT 0x0
#define SMC_MSG_ARG_0__SMC_MSG_ARG_MASK 0xffffffff
#define SMC_MSG_ARG_0__SMC_MSG_ARG__SHIFT 0x0
#define SMC_MSG_ARG_1__SMC_MSG_ARG_MASK 0xffffffff
#define SMC_MSG_ARG_1__SMC_MSG_ARG__SHIFT 0x0
#define SMC_MSG_ARG_2__SMC_MSG_ARG_MASK 0xffffffff
#define SMC_MSG_ARG_2__SMC_MSG_ARG__SHIFT 0x0
#define SMC_MSG_ARG_3__SMC_MSG_ARG_MASK 0xffffffff
#define SMC_MSG_ARG_3__SMC_MSG_ARG__SHIFT 0x0
#define SMC_MSG_ARG_4__SMC_MSG_ARG_MASK 0xffffffff
#define SMC_MSG_ARG_4__SMC_MSG_ARG__SHIFT 0x0
#define SMC_MSG_ARG_5__SMC_MSG_ARG_MASK 0xffffffff
#define SMC_MSG_ARG_5__SMC_MSG_ARG__SHIFT 0x0
#define SMC_MSG_ARG_6__SMC_MSG_ARG_MASK 0xffffffff
#define SMC_MSG_ARG_6__SMC_MSG_ARG__SHIFT 0x0
#define SMC_MSG_ARG_7__SMC_MSG_ARG_MASK 0xffffffff
#define SMC_MSG_ARG_7__SMC_MSG_ARG__SHIFT 0x0
#define SMC_MESSAGE_8__SMC_MSG_MASK 0xffff
#define SMC_MESSAGE_8__SMC_MSG__SHIFT 0x0
#define SMC_RESP_8__SMC_RESP_MASK 0xffff
#define SMC_RESP_8__SMC_RESP__SHIFT 0x0
#define SMC_MESSAGE_9__SMC_MSG_MASK 0xffff
#define SMC_MESSAGE_9__SMC_MSG__SHIFT 0x0
#define SMC_RESP_9__SMC_RESP_MASK 0xffff
#define SMC_RESP_9__SMC_RESP__SHIFT 0x0
#define SMC_MESSAGE_10__SMC_MSG_MASK 0xffff
#define SMC_MESSAGE_10__SMC_MSG__SHIFT 0x0
#define SMC_RESP_10__SMC_RESP_MASK 0xffff
#define SMC_RESP_10__SMC_RESP__SHIFT 0x0
#define SMC_MESSAGE_11__SMC_MSG_MASK 0xffff
#define SMC_MESSAGE_11__SMC_MSG__SHIFT 0x0
#define SMC_RESP_11__SMC_RESP_MASK 0xffff
#define SMC_RESP_11__SMC_RESP__SHIFT 0x0
#define SMC_MSG_ARG_8__SMC_MSG_ARG_MASK 0xffffffff
#define SMC_MSG_ARG_8__SMC_MSG_ARG__SHIFT 0x0
#define SMC_MSG_ARG_9__SMC_MSG_ARG_MASK 0xffffffff
#define SMC_MSG_ARG_9__SMC_MSG_ARG__SHIFT 0x0
#define SMC_MSG_ARG_10__SMC_MSG_ARG_MASK 0xffffffff
#define SMC_MSG_ARG_10__SMC_MSG_ARG__SHIFT 0x0
#define SMC_MSG_ARG_11__SMC_MSG_ARG_MASK 0xffffffff
#define SMC_MSG_ARG_11__SMC_MSG_ARG__SHIFT 0x0
#define SMC_SYSCON_RESET_CNTL__rst_reg_MASK 0x1
#define SMC_SYSCON_RESET_CNTL__rst_reg__SHIFT 0x0
#define SMC_SYSCON_RESET_CNTL__srbm_soft_rst_override_MASK 0x2
#define SMC_SYSCON_RESET_CNTL__srbm_soft_rst_override__SHIFT 0x1
#define SMC_SYSCON_RESET_CNTL__RegReset_MASK 0x40000000
#define SMC_SYSCON_RESET_CNTL__RegReset__SHIFT 0x1e
#define SMC_SYSCON_CLOCK_CNTL_0__ck_disable_MASK 0x1
#define SMC_SYSCON_CLOCK_CNTL_0__ck_disable__SHIFT 0x0
#define SMC_SYSCON_CLOCK_CNTL_0__auto_cg_en_MASK 0x2
#define SMC_SYSCON_CLOCK_CNTL_0__auto_cg_en__SHIFT 0x1
#define SMC_SYSCON_CLOCK_CNTL_0__auto_cg_timeout_MASK 0xffff00
#define SMC_SYSCON_CLOCK_CNTL_0__auto_cg_timeout__SHIFT 0x8
#define SMC_SYSCON_CLOCK_CNTL_0__cken_MASK 0x1000000
#define SMC_SYSCON_CLOCK_CNTL_0__cken__SHIFT 0x18
#define SMC_SYSCON_CLOCK_CNTL_1__auto_ck_disable_MASK 0x1
#define SMC_SYSCON_CLOCK_CNTL_1__auto_ck_disable__SHIFT 0x0
#define SMC_SYSCON_CLOCK_CNTL_2__wake_on_irq_MASK 0xffffffff
#define SMC_SYSCON_CLOCK_CNTL_2__wake_on_irq__SHIFT 0x0
#define SMC_SYSCON_MSG_ARG_0__smc_msg_arg_MASK 0xffffffff
#define SMC_SYSCON_MSG_ARG_0__smc_msg_arg__SHIFT 0x0
#define SMC_PC_C__smc_pc_c_MASK 0xffffffff
#define SMC_PC_C__smc_pc_c__SHIFT 0x0
#define SMC_SCRATCH9__SCRATCH_VALUE_MASK 0xffffffff
#define SMC_SCRATCH9__SCRATCH_VALUE__SHIFT 0x0
#define GPIOPAD_SW_INT_STAT__SW_INT_STAT_MASK 0x1
#define GPIOPAD_SW_INT_STAT__SW_INT_STAT__SHIFT 0x0
#define GPIOPAD_STRENGTH__GPIO_STRENGTH_SN_MASK 0xf
#define GPIOPAD_STRENGTH__GPIO_STRENGTH_SN__SHIFT 0x0
#define GPIOPAD_STRENGTH__GPIO_STRENGTH_SP_MASK 0xf0
#define GPIOPAD_STRENGTH__GPIO_STRENGTH_SP__SHIFT 0x4
#define GPIOPAD_MASK__GPIO_MASK_MASK 0x7fffffff
#define GPIOPAD_MASK__GPIO_MASK__SHIFT 0x0
#define GPIOPAD_A__GPIO_A_MASK 0x7fffffff
#define GPIOPAD_A__GPIO_A__SHIFT 0x0
#define GPIOPAD_EN__GPIO_EN_MASK 0x7fffffff
#define GPIOPAD_EN__GPIO_EN__SHIFT 0x0
#define GPIOPAD_Y__GPIO_Y_MASK 0x7fffffff
#define GPIOPAD_Y__GPIO_Y__SHIFT 0x0
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_0_MASK 0x1
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_0__SHIFT 0x0
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_1_MASK 0x2
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_1__SHIFT 0x1
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_2_MASK 0x4
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_2__SHIFT 0x2
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_3_MASK 0x8
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_3__SHIFT 0x3
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_4_MASK 0x10
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_4__SHIFT 0x4
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_5_MASK 0x20
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_5__SHIFT 0x5
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_6_MASK 0x40
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_6__SHIFT 0x6
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_7_MASK 0x80
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_7__SHIFT 0x7
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_8_MASK 0x100
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_8__SHIFT 0x8
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_9_MASK 0x200
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_9__SHIFT 0x9
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_10_MASK 0x400
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_10__SHIFT 0xa
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_11_MASK 0x800
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_11__SHIFT 0xb
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_12_MASK 0x1000
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_12__SHIFT 0xc
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_13_MASK 0x2000
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_13__SHIFT 0xd
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_14_MASK 0x4000
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_14__SHIFT 0xe
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_15_MASK 0x8000
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_15__SHIFT 0xf
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_16_MASK 0x10000
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_16__SHIFT 0x10
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_17_MASK 0x20000
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_17__SHIFT 0x11
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_18_MASK 0x40000
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_18__SHIFT 0x12
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_19_MASK 0x80000
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_19__SHIFT 0x13
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_20_MASK 0x100000
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_20__SHIFT 0x14
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_21_MASK 0x200000
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_21__SHIFT 0x15
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_22_MASK 0x400000
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_22__SHIFT 0x16
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_23_MASK 0x800000
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_23__SHIFT 0x17
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_24_MASK 0x1000000
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_24__SHIFT 0x18
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_25_MASK 0x2000000
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_25__SHIFT 0x19
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_26_MASK 0x4000000
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_26__SHIFT 0x1a
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_27_MASK 0x8000000
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_27__SHIFT 0x1b
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_28_MASK 0x10000000
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_28__SHIFT 0x1c
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_29_MASK 0x20000000
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_29__SHIFT 0x1d
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_30_MASK 0x40000000
#define GPIOPAD_PINSTRAPS__GPIO_PINSTRAP_30__SHIFT 0x1e
#define GPIOPAD_INT_STAT_EN__GPIO_INT_STAT_EN_MASK 0x1fffffff
#define GPIOPAD_INT_STAT_EN__GPIO_INT_STAT_EN__SHIFT 0x0
#define GPIOPAD_INT_STAT_EN__SW_INITIATED_INT_STAT_EN_MASK 0x80000000
#define GPIOPAD_INT_STAT_EN__SW_INITIATED_INT_STAT_EN__SHIFT 0x1f
#define GPIOPAD_INT_STAT__GPIO_INT_STAT_MASK 0x1fffffff
#define GPIOPAD_INT_STAT__GPIO_INT_STAT__SHIFT 0x0
#define GPIOPAD_INT_STAT__SW_INITIATED_INT_STAT_MASK 0x80000000
#define GPIOPAD_INT_STAT__SW_INITIATED_INT_STAT__SHIFT 0x1f
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_0_MASK 0x1
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_0__SHIFT 0x0
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_1_MASK 0x2
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_1__SHIFT 0x1
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_2_MASK 0x4
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_2__SHIFT 0x2
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_3_MASK 0x8
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_3__SHIFT 0x3
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_4_MASK 0x10
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_4__SHIFT 0x4
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_5_MASK 0x20
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_5__SHIFT 0x5
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_6_MASK 0x40
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_6__SHIFT 0x6
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_7_MASK 0x80
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_7__SHIFT 0x7
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_8_MASK 0x100
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_8__SHIFT 0x8
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_9_MASK 0x200
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_9__SHIFT 0x9
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_10_MASK 0x400
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_10__SHIFT 0xa
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_11_MASK 0x800
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_11__SHIFT 0xb
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_12_MASK 0x1000
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_12__SHIFT 0xc
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_13_MASK 0x2000
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_13__SHIFT 0xd
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_14_MASK 0x4000
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_14__SHIFT 0xe
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_15_MASK 0x8000
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_15__SHIFT 0xf
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_16_MASK 0x10000
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_16__SHIFT 0x10
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_17_MASK 0x20000
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_17__SHIFT 0x11
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_18_MASK 0x40000
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_18__SHIFT 0x12
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_19_MASK 0x80000
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_19__SHIFT 0x13
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_20_MASK 0x100000
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_20__SHIFT 0x14
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_21_MASK 0x200000
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_21__SHIFT 0x15
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_22_MASK 0x400000
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_22__SHIFT 0x16
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_23_MASK 0x800000
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_23__SHIFT 0x17
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_24_MASK 0x1000000
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_24__SHIFT 0x18
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_25_MASK 0x2000000
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_25__SHIFT 0x19
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_26_MASK 0x4000000
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_26__SHIFT 0x1a
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_27_MASK 0x8000000
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_27__SHIFT 0x1b
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_28_MASK 0x10000000
#define GPIOPAD_INT_STAT_AK__GPIO_INT_STAT_AK_28__SHIFT 0x1c
#define GPIOPAD_INT_STAT_AK__SW_INITIATED_INT_STAT_AK_MASK 0x80000000
#define GPIOPAD_INT_STAT_AK__SW_INITIATED_INT_STAT_AK__SHIFT 0x1f
#define GPIOPAD_INT_EN__GPIO_INT_EN_MASK 0x1fffffff
#define GPIOPAD_INT_EN__GPIO_INT_EN__SHIFT 0x0
#define GPIOPAD_INT_EN__SW_INITIATED_INT_EN_MASK 0x80000000
#define GPIOPAD_INT_EN__SW_INITIATED_INT_EN__SHIFT 0x1f
#define GPIOPAD_INT_TYPE__GPIO_INT_TYPE_MASK 0x1fffffff
#define GPIOPAD_INT_TYPE__GPIO_INT_TYPE__SHIFT 0x0
#define GPIOPAD_INT_TYPE__SW_INITIATED_INT_TYPE_MASK 0x80000000
#define GPIOPAD_INT_TYPE__SW_INITIATED_INT_TYPE__SHIFT 0x1f
#define GPIOPAD_INT_POLARITY__GPIO_INT_POLARITY_MASK 0x1fffffff
#define GPIOPAD_INT_POLARITY__GPIO_INT_POLARITY__SHIFT 0x0
#define GPIOPAD_INT_POLARITY__SW_INITIATED_INT_POLARITY_MASK 0x80000000
#define GPIOPAD_INT_POLARITY__SW_INITIATED_INT_POLARITY__SHIFT 0x1f
#define GPIOPAD_EXTERN_TRIG_CNTL__EXTERN_TRIG_SEL_MASK 0x1f
#define GPIOPAD_EXTERN_TRIG_CNTL__EXTERN_TRIG_SEL__SHIFT 0x0
#define GPIOPAD_EXTERN_TRIG_CNTL__EXTERN_TRIG_CLR_MASK 0x20
#define GPIOPAD_EXTERN_TRIG_CNTL__EXTERN_TRIG_CLR__SHIFT 0x5
#define GPIOPAD_EXTERN_TRIG_CNTL__EXTERN_TRIG_READ_MASK 0x40
#define GPIOPAD_EXTERN_TRIG_CNTL__EXTERN_TRIG_READ__SHIFT 0x6
#define GPIOPAD_RCVR_SEL__GPIO_RCVR_SEL_MASK 0x7fffffff
#define GPIOPAD_RCVR_SEL__GPIO_RCVR_SEL__SHIFT 0x0
#define GPIOPAD_PU_EN__GPIO_PU_EN_MASK 0x7fffffff
#define GPIOPAD_PU_EN__GPIO_PU_EN__SHIFT 0x0
#define GPIOPAD_PD_EN__GPIO_PD_EN_MASK 0x7fffffff
#define GPIOPAD_PD_EN__GPIO_PD_EN__SHIFT 0x0
#define CG_FPS_CNT__FPS_CNT_MASK 0xff
#define CG_FPS_CNT__FPS_CNT__SHIFT 0x0
#define SMU_SMC_IND_INDEX__SMC_IND_ADDR_MASK 0xffffffff
#define SMU_SMC_IND_INDEX__SMC_IND_ADDR__SHIFT 0x0
#define SMU_SMC_IND_DATA__SMC_IND_DATA_MASK 0xffffffff
#define SMU_SMC_IND_DATA__SMC_IND_DATA__SHIFT 0x0
#define RCU_UC_EVENTS__RCU_TST_jpc_rep_req_MASK 0x1
#define RCU_UC_EVENTS__RCU_TST_jpc_rep_req__SHIFT 0x0
#define RCU_UC_EVENTS__TST_RCU_jpc_rep_done_MASK 0x2
#define RCU_UC_EVENTS__TST_RCU_jpc_rep_done__SHIFT 0x1
#define RCU_UC_EVENTS__drv_rst_mode_MASK 0x4
#define RCU_UC_EVENTS__drv_rst_mode__SHIFT 0x2
#define RCU_UC_EVENTS__SMU_DC_efuse_status_invalid_MASK 0x8
#define RCU_UC_EVENTS__SMU_DC_efuse_status_invalid__SHIFT 0x3
#define RCU_UC_EVENTS__TP_Tester_MASK 0x40
#define RCU_UC_EVENTS__TP_Tester__SHIFT 0x6
#define RCU_UC_EVENTS__boot_seq_done_MASK 0x80
#define RCU_UC_EVENTS__boot_seq_done__SHIFT 0x7
#define RCU_UC_EVENTS__sclk_deep_sleep_exit_MASK 0x100
#define RCU_UC_EVENTS__sclk_deep_sleep_exit__SHIFT 0x8
#define RCU_UC_EVENTS__BREAK_PT1_ACTIVE_MASK 0x200
#define RCU_UC_EVENTS__BREAK_PT1_ACTIVE__SHIFT 0x9
#define RCU_UC_EVENTS__BREAK_PT2_ACTIVE_MASK 0x400
#define RCU_UC_EVENTS__BREAK_PT2_ACTIVE__SHIFT 0xa
#define RCU_UC_EVENTS__FCH_HALT_MASK 0x800
#define RCU_UC_EVENTS__FCH_HALT__SHIFT 0xb
#define RCU_UC_EVENTS__RCU_GIO_fch_lockdown_MASK 0x2000
#define RCU_UC_EVENTS__RCU_GIO_fch_lockdown__SHIFT 0xd
#define RCU_UC_EVENTS__INTERRUPTS_ENABLED_MASK 0x10000
#define RCU_UC_EVENTS__INTERRUPTS_ENABLED__SHIFT 0x10
#define RCU_UC_EVENTS__RCU_DtmCnt0_Done_MASK 0x20000
#define RCU_UC_EVENTS__RCU_DtmCnt0_Done__SHIFT 0x11
#define RCU_UC_EVENTS__RCU_DtmCnt1_Done_MASK 0x40000
#define RCU_UC_EVENTS__RCU_DtmCnt1_Done__SHIFT 0x12
#define RCU_UC_EVENTS__RCU_DtmCnt2_Done_MASK 0x80000
#define RCU_UC_EVENTS__RCU_DtmCnt2_Done__SHIFT 0x13
#define RCU_UC_EVENTS__irq31_sel_MASK 0x3000000
#define RCU_UC_EVENTS__irq31_sel__SHIFT 0x18
#define RCU_MISC_CTRL__REG_DRV_RST_MODE_MASK 0x2
#define RCU_MISC_CTRL__REG_DRV_RST_MODE__SHIFT 0x1
#define RCU_MISC_CTRL__REG_RCU_MEMREP_DIS_MASK 0x8
#define RCU_MISC_CTRL__REG_RCU_MEMREP_DIS__SHIFT 0x3
#define RCU_MISC_CTRL__REG_CC_FUSE_DISABLE_MASK 0x10
#define RCU_MISC_CTRL__REG_CC_FUSE_DISABLE__SHIFT 0x4
#define RCU_MISC_CTRL__REG_SAMU_FUSE_DISABLE_MASK 0x20
#define RCU_MISC_CTRL__REG_SAMU_FUSE_DISABLE__SHIFT 0x5
#define RCU_MISC_CTRL__REG_CC_SRBM_RD_DISABLE_MASK 0x100
#define RCU_MISC_CTRL__REG_CC_SRBM_RD_DISABLE__SHIFT 0x8
#define RCU_MISC_CTRL__BREAK_PT1_DONE_MASK 0x10000
#define RCU_MISC_CTRL__BREAK_PT1_DONE__SHIFT 0x10
#define RCU_MISC_CTRL__BREAK_PT2_DONE_MASK 0x20000
#define RCU_MISC_CTRL__BREAK_PT2_DONE__SHIFT 0x11
#define RCU_MISC_CTRL__SAMU_START_MASK 0x400000
#define RCU_MISC_CTRL__SAMU_START__SHIFT 0x16
#define RCU_MISC_CTRL__RST_PULSE_WIDTH_MASK 0xff800000
#define RCU_MISC_CTRL__RST_PULSE_WIDTH__SHIFT 0x17
#define CC_RCU_FUSES__GPU_DIS_MASK 0x2
#define CC_RCU_FUSES__GPU_DIS__SHIFT 0x1
#define CC_RCU_FUSES__DEBUG_DISABLE_MASK 0x4
#define CC_RCU_FUSES__DEBUG_DISABLE__SHIFT 0x2
#define CC_RCU_FUSES__EFUSE_RD_DISABLE_MASK 0x10
#define CC_RCU_FUSES__EFUSE_RD_DISABLE__SHIFT 0x4
#define CC_RCU_FUSES__CG_RST_GLB_REQ_DIS_MASK 0x20
#define CC_RCU_FUSES__CG_RST_GLB_REQ_DIS__SHIFT 0x5
#define CC_RCU_FUSES__DRV_RST_MODE_MASK 0x40
#define CC_RCU_FUSES__DRV_RST_MODE__SHIFT 0x6
#define CC_RCU_FUSES__ROM_DIS_MASK 0x80
#define CC_RCU_FUSES__ROM_DIS__SHIFT 0x7
#define CC_RCU_FUSES__JPC_REP_DISABLE_MASK 0x100
#define CC_RCU_FUSES__JPC_REP_DISABLE__SHIFT 0x8
#define CC_RCU_FUSES__RCU_BREAK_POINT1_MASK 0x200
#define CC_RCU_FUSES__RCU_BREAK_POINT1__SHIFT 0x9
#define CC_RCU_FUSES__RCU_BREAK_POINT2_MASK 0x400
#define CC_RCU_FUSES__RCU_BREAK_POINT2__SHIFT 0xa
#define CC_RCU_FUSES__PHY_FUSE_VALID_MASK 0x4000
#define CC_RCU_FUSES__PHY_FUSE_VALID__SHIFT 0xe
#define CC_RCU_FUSES__SMU_IOC_MST_DISABLE_MASK 0x8000
#define CC_RCU_FUSES__SMU_IOC_MST_DISABLE__SHIFT 0xf
#define CC_RCU_FUSES__FCH_LOCKOUT_ENABLE_MASK 0x10000
#define CC_RCU_FUSES__FCH_LOCKOUT_ENABLE__SHIFT 0x10
#define CC_RCU_FUSES__FCH_XFIRE_FILTER_ENABLE_MASK 0x20000
#define CC_RCU_FUSES__FCH_XFIRE_FILTER_ENABLE__SHIFT 0x11
#define CC_RCU_FUSES__XFIRE_DISABLE_MASK 0x40000
#define CC_RCU_FUSES__XFIRE_DISABLE__SHIFT 0x12
#define CC_RCU_FUSES__SAMU_FUSE_DISABLE_MASK 0x80000
#define CC_RCU_FUSES__SAMU_FUSE_DISABLE__SHIFT 0x13
#define CC_RCU_FUSES__BIF_RST_POLLING_DISABLE_MASK 0x100000
#define CC_RCU_FUSES__BIF_RST_POLLING_DISABLE__SHIFT 0x14
#define CC_RCU_FUSES__MEM_HARDREP_EN_MASK 0x400000
#define CC_RCU_FUSES__MEM_HARDREP_EN__SHIFT 0x16
#define CC_RCU_FUSES__PCIE_INIT_DISABLE_MASK 0x800000
#define CC_RCU_FUSES__PCIE_INIT_DISABLE__SHIFT 0x17
#define CC_RCU_FUSES__DSMU_DISABLE_MASK 0x1000000
#define CC_RCU_FUSES__DSMU_DISABLE__SHIFT 0x18
#define CC_RCU_FUSES__RCU_SPARE_MASK 0xfe000000
#define CC_RCU_FUSES__RCU_SPARE__SHIFT 0x19
#define CC_SMU_MISC_FUSES__IOMMU_V2_DISABLE_MASK 0x2
#define CC_SMU_MISC_FUSES__IOMMU_V2_DISABLE__SHIFT 0x1
#define CC_SMU_MISC_FUSES__MinSClkDid_MASK 0x1fc
#define CC_SMU_MISC_FUSES__MinSClkDid__SHIFT 0x2
#define CC_SMU_MISC_FUSES__MISC_SPARE_MASK 0x600
#define CC_SMU_MISC_FUSES__MISC_SPARE__SHIFT 0x9
#define CC_SMU_MISC_FUSES__PostResetGnbClkDid_MASK 0x3f800
#define CC_SMU_MISC_FUSES__PostResetGnbClkDid__SHIFT 0xb
#define CC_SMU_MISC_FUSES__L2IMU_tn2_dtc_half_MASK 0x40000
#define CC_SMU_MISC_FUSES__L2IMU_tn2_dtc_half__SHIFT 0x12
#define CC_SMU_MISC_FUSES__L2IMU_tn2_ptc_half_MASK 0x80000
#define CC_SMU_MISC_FUSES__L2IMU_tn2_ptc_half__SHIFT 0x13
#define CC_SMU_MISC_FUSES__L2IMU_tn2_itc_half_MASK 0x100000
#define CC_SMU_MISC_FUSES__L2IMU_tn2_itc_half__SHIFT 0x14
#define CC_SMU_MISC_FUSES__L2IMU_tn2_pdc_half_MASK 0x200000
#define CC_SMU_MISC_FUSES__L2IMU_tn2_pdc_half__SHIFT 0x15
#define CC_SMU_MISC_FUSES__L2IMU_tn2_ptc_dis_MASK 0x400000
#define CC_SMU_MISC_FUSES__L2IMU_tn2_ptc_dis__SHIFT 0x16
#define CC_SMU_MISC_FUSES__L2IMU_tn2_itc_dis_MASK 0x800000
#define CC_SMU_MISC_FUSES__L2IMU_tn2_itc_dis__SHIFT 0x17
#define CC_SMU_MISC_FUSES__VCE_DISABLE_MASK 0x8000000
#define CC_SMU_MISC_FUSES__VCE_DISABLE__SHIFT 0x1b
#define CC_SMU_MISC_FUSES__IOC_IOMMU_DISABLE_MASK 0x10000000
#define CC_SMU_MISC_FUSES__IOC_IOMMU_DISABLE__SHIFT 0x1c
#define CC_SMU_MISC_FUSES__GNB_SPARE_MASK 0x60000000
#define CC_SMU_MISC_FUSES__GNB_SPARE__SHIFT 0x1d
#define CC_SCLK_VID_FUSES__SClkVid0_MASK 0xff
#define CC_SCLK_VID_FUSES__SClkVid0__SHIFT 0x0
#define CC_SCLK_VID_FUSES__SClkVid1_MASK 0xff00
#define CC_SCLK_VID_FUSES__SClkVid1__SHIFT 0x8
#define CC_SCLK_VID_FUSES__SClkVid2_MASK 0xff0000
#define CC_SCLK_VID_FUSES__SClkVid2__SHIFT 0x10
#define CC_SCLK_VID_FUSES__SClkVid3_MASK 0xff000000
#define CC_SCLK_VID_FUSES__SClkVid3__SHIFT 0x18
#define CC_GIO_IOCCFG_FUSES__NB_REV_ID_MASK 0x7fe
#define CC_GIO_IOCCFG_FUSES__NB_REV_ID__SHIFT 0x1
#define CC_GIO_IOC_FUSES__IOC_FUSES_MASK 0x3e
#define CC_GIO_IOC_FUSES__IOC_FUSES__SHIFT 0x1
#define CC_SMU_TST_EFUSE1_MISC__RF_RM_6_2_MASK 0x3e
#define CC_SMU_TST_EFUSE1_MISC__RF_RM_6_2__SHIFT 0x1
#define CC_SMU_TST_EFUSE1_MISC__RME_MASK 0x40
#define CC_SMU_TST_EFUSE1_MISC__RME__SHIFT 0x6
#define CC_SMU_TST_EFUSE1_MISC__MBIST_DISABLE_MASK 0x80
#define CC_SMU_TST_EFUSE1_MISC__MBIST_DISABLE__SHIFT 0x7
#define CC_SMU_TST_EFUSE1_MISC__HARD_REPAIR_DISABLE_MASK 0x100
#define CC_SMU_TST_EFUSE1_MISC__HARD_REPAIR_DISABLE__SHIFT 0x8
#define CC_SMU_TST_EFUSE1_MISC__SOFT_REPAIR_DISABLE_MASK 0x200
#define CC_SMU_TST_EFUSE1_MISC__SOFT_REPAIR_DISABLE__SHIFT 0x9
#define CC_SMU_TST_EFUSE1_MISC__GPU_DIS_MASK 0x400
#define CC_SMU_TST_EFUSE1_MISC__GPU_DIS__SHIFT 0xa
#define CC_SMU_TST_EFUSE1_MISC__SMS_PWRDWN_DISABLE_MASK 0x800
#define CC_SMU_TST_EFUSE1_MISC__SMS_PWRDWN_DISABLE__SHIFT 0xb
#define CC_SMU_TST_EFUSE1_MISC__CRBBMP1500_DISA_MASK 0x1000
#define CC_SMU_TST_EFUSE1_MISC__CRBBMP1500_DISA__SHIFT 0xc
#define CC_SMU_TST_EFUSE1_MISC__CRBBMP1500_DISB_MASK 0x2000
#define CC_SMU_TST_EFUSE1_MISC__CRBBMP1500_DISB__SHIFT 0xd
#define CC_SMU_TST_EFUSE1_MISC__RM_RF8_MASK 0x4000
#define CC_SMU_TST_EFUSE1_MISC__RM_RF8__SHIFT 0xe
#define CC_SMU_TST_EFUSE1_MISC__DFT_SPARE1_MASK 0x400000
#define CC_SMU_TST_EFUSE1_MISC__DFT_SPARE1__SHIFT 0x16
#define CC_SMU_TST_EFUSE1_MISC__DFT_SPARE2_MASK 0x800000
#define CC_SMU_TST_EFUSE1_MISC__DFT_SPARE2__SHIFT 0x17
#define CC_SMU_TST_EFUSE1_MISC__DFT_SPARE3_MASK 0x1000000
#define CC_SMU_TST_EFUSE1_MISC__DFT_SPARE3__SHIFT 0x18
#define CC_SMU_TST_EFUSE1_MISC__VCE_DISABLE_MASK 0x2000000
#define CC_SMU_TST_EFUSE1_MISC__VCE_DISABLE__SHIFT 0x19
#define CC_SMU_TST_EFUSE1_MISC__DCE_SCAN_DISABLE_MASK 0x4000000
#define CC_SMU_TST_EFUSE1_MISC__DCE_SCAN_DISABLE__SHIFT 0x1a
#define CC_TST_ID_STRAPS__DEVICE_ID_MASK 0xffff0
#define CC_TST_ID_STRAPS__DEVICE_ID__SHIFT 0x4
#define CC_TST_ID_STRAPS__MAJOR_REV_ID_MASK 0xf00000
#define CC_TST_ID_STRAPS__MAJOR_REV_ID__SHIFT 0x14
#define CC_TST_ID_STRAPS__MINOR_REV_ID_MASK 0xf000000
#define CC_TST_ID_STRAPS__MINOR_REV_ID__SHIFT 0x18
#define CC_FCTRL_FUSES__EXT_EFUSE_MACRO_PRESENT_MASK 0x2
#define CC_FCTRL_FUSES__EXT_EFUSE_MACRO_PRESENT__SHIFT 0x1
#define SMU_MAIN_PLL_OP_FREQ__PLL_OP_FREQ_MASK 0xffffffff
#define SMU_MAIN_PLL_OP_FREQ__PLL_OP_FREQ__SHIFT 0x0
#define SMU_STATUS__SMU_DONE_MASK 0x1
#define SMU_STATUS__SMU_DONE__SHIFT 0x0
#define SMU_STATUS__SMU_PASS_MASK 0x2
#define SMU_STATUS__SMU_PASS__SHIFT 0x1
#define SMU_FIRMWARE__SMU_IN_PROG_MASK 0x1
#define SMU_FIRMWARE__SMU_IN_PROG__SHIFT 0x0
#define SMU_FIRMWARE__SMU_RD_DONE_MASK 0x6
#define SMU_FIRMWARE__SMU_RD_DONE__SHIFT 0x1
#define SMU_FIRMWARE__SMU_SRAM_RD_BLOCK_EN_MASK 0x8
#define SMU_FIRMWARE__SMU_SRAM_RD_BLOCK_EN__SHIFT 0x3
#define SMU_FIRMWARE__SMU_SRAM_WR_BLOCK_EN_MASK 0x10
#define SMU_FIRMWARE__SMU_SRAM_WR_BLOCK_EN__SHIFT 0x4
#define SMU_FIRMWARE__SMU_counter_MASK 0xf00
#define SMU_FIRMWARE__SMU_counter__SHIFT 0x8
#define SMU_FIRMWARE__SMU_MODE_MASK 0x10000
#define SMU_FIRMWARE__SMU_MODE__SHIFT 0x10
#define SMU_FIRMWARE__SMU_SEL_MASK 0x20000
#define SMU_FIRMWARE__SMU_SEL__SHIFT 0x11
#define SMU_INPUT_DATA__START_ADDR_MASK 0x7fffffff
#define SMU_INPUT_DATA__START_ADDR__SHIFT 0x0
#define SMU_INPUT_DATA__AUTO_START_MASK 0x80000000
#define SMU_INPUT_DATA__AUTO_START__SHIFT 0x1f
#define SMU_EFUSE_0__EFUSE_DATA_MASK 0xffffffff
#define SMU_EFUSE_0__EFUSE_DATA__SHIFT 0x0
#define DPM_TABLE_1__GraphicsPIDController_Ki_MASK 0xffffffff
#define DPM_TABLE_1__GraphicsPIDController_Ki__SHIFT 0x0
#define DPM_TABLE_2__GraphicsPIDController_LFWindupUpperLim_MASK 0xffffffff
#define DPM_TABLE_2__GraphicsPIDController_LFWindupUpperLim__SHIFT 0x0
#define DPM_TABLE_3__GraphicsPIDController_LFWindupLowerLim_MASK 0xffffffff
#define DPM_TABLE_3__GraphicsPIDController_LFWindupLowerLim__SHIFT 0x0
#define DPM_TABLE_4__GraphicsPIDController_StatePrecision_MASK 0xffffffff
#define DPM_TABLE_4__GraphicsPIDController_StatePrecision__SHIFT 0x0
#define DPM_TABLE_5__GraphicsPIDController_LfPrecision_MASK 0xffffffff
#define DPM_TABLE_5__GraphicsPIDController_LfPrecision__SHIFT 0x0
#define DPM_TABLE_6__GraphicsPIDController_LfOffset_MASK 0xffffffff
#define DPM_TABLE_6__GraphicsPIDController_LfOffset__SHIFT 0x0
#define DPM_TABLE_7__GraphicsPIDController_MaxState_MASK 0xffffffff
#define DPM_TABLE_7__GraphicsPIDController_MaxState__SHIFT 0x0
#define DPM_TABLE_8__GraphicsPIDController_MaxLfFraction_MASK 0xffffffff
#define DPM_TABLE_8__GraphicsPIDController_MaxLfFraction__SHIFT 0x0
#define DPM_TABLE_9__GraphicsPIDController_StateShift_MASK 0xffffffff
#define DPM_TABLE_9__GraphicsPIDController_StateShift__SHIFT 0x0
#define DPM_TABLE_10__MemoryPIDController_Ki_MASK 0xffffffff
#define DPM_TABLE_10__MemoryPIDController_Ki__SHIFT 0x0
#define DPM_TABLE_11__MemoryPIDController_LFWindupUpperLim_MASK 0xffffffff
#define DPM_TABLE_11__MemoryPIDController_LFWindupUpperLim__SHIFT 0x0
#define DPM_TABLE_12__MemoryPIDController_LFWindupLowerLim_MASK 0xffffffff
#define DPM_TABLE_12__MemoryPIDController_LFWindupLowerLim__SHIFT 0x0
#define DPM_TABLE_13__MemoryPIDController_StatePrecision_MASK 0xffffffff
#define DPM_TABLE_13__MemoryPIDController_StatePrecision__SHIFT 0x0
#define DPM_TABLE_14__MemoryPIDController_LfPrecision_MASK 0xffffffff
#define DPM_TABLE_14__MemoryPIDController_LfPrecision__SHIFT 0x0
#define DPM_TABLE_15__MemoryPIDController_LfOffset_MASK 0xffffffff
#define DPM_TABLE_15__MemoryPIDController_LfOffset__SHIFT 0x0
#define DPM_TABLE_16__MemoryPIDController_MaxState_MASK 0xffffffff
#define DPM_TABLE_16__MemoryPIDController_MaxState__SHIFT 0x0
#define DPM_TABLE_17__MemoryPIDController_MaxLfFraction_MASK 0xffffffff
#define DPM_TABLE_17__MemoryPIDController_MaxLfFraction__SHIFT 0x0
#define DPM_TABLE_18__MemoryPIDController_StateShift_MASK 0xffffffff
#define DPM_TABLE_18__MemoryPIDController_StateShift__SHIFT 0x0
#define DPM_TABLE_19__LinkPIDController_Ki_MASK 0xffffffff
#define DPM_TABLE_19__LinkPIDController_Ki__SHIFT 0x0
#define DPM_TABLE_20__LinkPIDController_LFWindupUpperLim_MASK 0xffffffff
#define DPM_TABLE_20__LinkPIDController_LFWindupUpperLim__SHIFT 0x0
#define DPM_TABLE_21__LinkPIDController_LFWindupLowerLim_MASK 0xffffffff
#define DPM_TABLE_21__LinkPIDController_LFWindupLowerLim__SHIFT 0x0
#define DPM_TABLE_22__LinkPIDController_StatePrecision_MASK 0xffffffff
#define DPM_TABLE_22__LinkPIDController_StatePrecision__SHIFT 0x0
#define DPM_TABLE_23__LinkPIDController_LfPrecision_MASK 0xffffffff
#define DPM_TABLE_23__LinkPIDController_LfPrecision__SHIFT 0x0
#define DPM_TABLE_24__LinkPIDController_LfOffset_MASK 0xffffffff
#define DPM_TABLE_24__LinkPIDController_LfOffset__SHIFT 0x0
#define DPM_TABLE_25__LinkPIDController_MaxState_MASK 0xffffffff
#define DPM_TABLE_25__LinkPIDController_MaxState__SHIFT 0x0
#define DPM_TABLE_26__LinkPIDController_MaxLfFraction_MASK 0xffffffff
#define DPM_TABLE_26__LinkPIDController_MaxLfFraction__SHIFT 0x0
#define DPM_TABLE_27__LinkPIDController_StateShift_MASK 0xffffffff
#define DPM_TABLE_27__LinkPIDController_StateShift__SHIFT 0x0
#define DPM_TABLE_28__SystemFlags_MASK 0xffffffff
#define DPM_TABLE_28__SystemFlags__SHIFT 0x0
#define DPM_TABLE_29__SmioMaskVddcVid_MASK 0xffffffff
#define DPM_TABLE_29__SmioMaskVddcVid__SHIFT 0x0
#define DPM_TABLE_30__SmioMaskVddcPhase_MASK 0xffffffff
#define DPM_TABLE_30__SmioMaskVddcPhase__SHIFT 0x0
#define DPM_TABLE_31__SmioMaskVddciVid_MASK 0xffffffff
#define DPM_TABLE_31__SmioMaskVddciVid__SHIFT 0x0
#define DPM_TABLE_32__SmioMaskMvddVid_MASK 0xffffffff
#define DPM_TABLE_32__SmioMaskMvddVid__SHIFT 0x0
#define DPM_TABLE_33__VddcLevelCount_MASK 0xffffffff
#define DPM_TABLE_33__VddcLevelCount__SHIFT 0x0
#define DPM_TABLE_34__VddciLevelCount_MASK 0xffffffff
#define DPM_TABLE_34__VddciLevelCount__SHIFT 0x0
#define DPM_TABLE_35__MvddLevelCount_MASK 0xffffffff
#define DPM_TABLE_35__MvddLevelCount__SHIFT 0x0
#define DPM_TABLE_36__VddcLevel_0_StdVoltageHiSidd_MASK 0xffff
#define DPM_TABLE_36__VddcLevel_0_StdVoltageHiSidd__SHIFT 0x0
#define DPM_TABLE_36__VddcLevel_0_Voltage_MASK 0xffff0000
#define DPM_TABLE_36__VddcLevel_0_Voltage__SHIFT 0x10
#define DPM_TABLE_37__VddcLevel_0_padding_MASK 0xff
#define DPM_TABLE_37__VddcLevel_0_padding__SHIFT 0x0
#define DPM_TABLE_37__VddcLevel_0_Smio_MASK 0xff00
#define DPM_TABLE_37__VddcLevel_0_Smio__SHIFT 0x8
#define DPM_TABLE_37__VddcLevel_0_StdVoltageLoSidd_MASK 0xffff0000
#define DPM_TABLE_37__VddcLevel_0_StdVoltageLoSidd__SHIFT 0x10
#define DPM_TABLE_38__VddcLevel_1_StdVoltageHiSidd_MASK 0xffff
#define DPM_TABLE_38__VddcLevel_1_StdVoltageHiSidd__SHIFT 0x0
#define DPM_TABLE_38__VddcLevel_1_Voltage_MASK 0xffff0000
#define DPM_TABLE_38__VddcLevel_1_Voltage__SHIFT 0x10
#define DPM_TABLE_39__VddcLevel_1_padding_MASK 0xff
#define DPM_TABLE_39__VddcLevel_1_padding__SHIFT 0x0
#define DPM_TABLE_39__VddcLevel_1_Smio_MASK 0xff00
#define DPM_TABLE_39__VddcLevel_1_Smio__SHIFT 0x8
#define DPM_TABLE_39__VddcLevel_1_StdVoltageLoSidd_MASK 0xffff0000
#define DPM_TABLE_39__VddcLevel_1_StdVoltageLoSidd__SHIFT 0x10
#define DPM_TABLE_40__VddcLevel_2_StdVoltageHiSidd_MASK 0xffff
#define DPM_TABLE_40__VddcLevel_2_StdVoltageHiSidd__SHIFT 0x0
#define DPM_TABLE_40__VddcLevel_2_Voltage_MASK 0xffff0000
#define DPM_TABLE_40__VddcLevel_2_Voltage__SHIFT 0x10
#define DPM_TABLE_41__VddcLevel_2_padding_MASK 0xff
#define DPM_TABLE_41__VddcLevel_2_padding__SHIFT 0x0
#define DPM_TABLE_41__VddcLevel_2_Smio_MASK 0xff00
#define DPM_TABLE_41__VddcLevel_2_Smio__SHIFT 0x8
#define DPM_TABLE_41__VddcLevel_2_StdVoltageLoSidd_MASK 0xffff0000
#define DPM_TABLE_41__VddcLevel_2_StdVoltageLoSidd__SHIFT 0x10
#define DPM_TABLE_42__VddcLevel_3_StdVoltageHiSidd_MASK 0xffff
#define DPM_TABLE_42__VddcLevel_3_StdVoltageHiSidd__SHIFT 0x0
#define DPM_TABLE_42__VddcLevel_3_Voltage_MASK 0xffff0000
#define DPM_TABLE_42__VddcLevel_3_Voltage__SHIFT 0x10
#define DPM_TABLE_43__VddcLevel_3_padding_MASK 0xff
#define DPM_TABLE_43__VddcLevel_3_padding__SHIFT 0x0
#define DPM_TABLE_43__VddcLevel_3_Smio_MASK 0xff00
#define DPM_TABLE_43__VddcLevel_3_Smio__SHIFT 0x8
#define DPM_TABLE_43__VddcLevel_3_StdVoltageLoSidd_MASK 0xffff0000
#define DPM_TABLE_43__VddcLevel_3_StdVoltageLoSidd__SHIFT 0x10
#define DPM_TABLE_44__VddcLevel_4_StdVoltageHiSidd_MASK 0xffff
#define DPM_TABLE_44__VddcLevel_4_StdVoltageHiSidd__SHIFT 0x0
#define DPM_TABLE_44__VddcLevel_4_Voltage_MASK 0xffff0000
#define DPM_TABLE_44__VddcLevel_4_Voltage__SHIFT 0x10
#define DPM_TABLE_45__VddcLevel_4_padding_MASK 0xff
#define DPM_TABLE_45__VddcLevel_4_padding__SHIFT 0x0
#define DPM_TABLE_45__VddcLevel_4_Smio_MASK 0xff00
#define DPM_TABLE_45__VddcLevel_4_Smio__SHIFT 0x8
#define DPM_TABLE_45__VddcLevel_4_StdVoltageLoSidd_MASK 0xffff0000
#define DPM_TABLE_45__VddcLevel_4_StdVoltageLoSidd__SHIFT 0x10
#define DPM_TABLE_46__VddcLevel_5_StdVoltageHiSidd_MASK 0xffff
#define DPM_TABLE_46__VddcLevel_5_StdVoltageHiSidd__SHIFT 0x0
#define DPM_TABLE_46__VddcLevel_5_Voltage_MASK 0xffff0000
#define DPM_TABLE_46__VddcLevel_5_Voltage__SHIFT 0x10
#define DPM_TABLE_47__VddcLevel_5_padding_MASK 0xff
#define DPM_TABLE_47__VddcLevel_5_padding__SHIFT 0x0
#define DPM_TABLE_47__VddcLevel_5_Smio_MASK 0xff00
#define DPM_TABLE_47__VddcLevel_5_Smio__SHIFT 0x8
#define DPM_TABLE_47__VddcLevel_5_StdVoltageLoSidd_MASK 0xffff0000
#define DPM_TABLE_47__VddcLevel_5_StdVoltageLoSidd__SHIFT 0x10
#define DPM_TABLE_48__VddcLevel_6_StdVoltageHiSidd_MASK 0xffff
#define DPM_TABLE_48__VddcLevel_6_StdVoltageHiSidd__SHIFT 0x0
#define DPM_TABLE_48__VddcLevel_6_Voltage_MASK 0xffff0000
#define DPM_TABLE_48__VddcLevel_6_Voltage__SHIFT 0x10
#define DPM_TABLE_49__VddcLevel_6_padding_MASK 0xff
#define DPM_TABLE_49__VddcLevel_6_padding__SHIFT 0x0
#define DPM_TABLE_49__VddcLevel_6_Smio_MASK 0xff00
#define DPM_TABLE_49__VddcLevel_6_Smio__SHIFT 0x8
#define DPM_TABLE_49__VddcLevel_6_StdVoltageLoSidd_MASK 0xffff0000
#define DPM_TABLE_49__VddcLevel_6_StdVoltageLoSidd__SHIFT 0x10
#define DPM_TABLE_50__VddcLevel_7_StdVoltageHiSidd_MASK 0xffff
#define DPM_TABLE_50__VddcLevel_7_StdVoltageHiSidd__SHIFT 0x0
#define DPM_TABLE_50__VddcLevel_7_Voltage_MASK 0xffff0000
#define DPM_TABLE_50__VddcLevel_7_Voltage__SHIFT 0x10
#define DPM_TABLE_51__VddcLevel_7_padding_MASK 0xff
#define DPM_TABLE_51__VddcLevel_7_padding__SHIFT 0x0
#define DPM_TABLE_51__VddcLevel_7_Smio_MASK 0xff00
#define DPM_TABLE_51__VddcLevel_7_Smio__SHIFT 0x8
#define DPM_TABLE_51__VddcLevel_7_StdVoltageLoSidd_MASK 0xffff0000
#define DPM_TABLE_51__VddcLevel_7_StdVoltageLoSidd__SHIFT 0x10
#define DPM_TABLE_52__VddciLevel_0_StdVoltageHiSidd_MASK 0xffff
#define DPM_TABLE_52__VddciLevel_0_StdVoltageHiSidd__SHIFT 0x0
#define DPM_TABLE_52__VddciLevel_0_Voltage_MASK 0xffff0000
#define DPM_TABLE_52__VddciLevel_0_Voltage__SHIFT 0x10
#define DPM_TABLE_53__VddciLevel_0_padding_MASK 0xff
#define DPM_TABLE_53__VddciLevel_0_padding__SHIFT 0x0
#define DPM_TABLE_53__VddciLevel_0_Smio_MASK 0xff00
#define DPM_TABLE_53__VddciLevel_0_Smio__SHIFT 0x8
#define DPM_TABLE_53__VddciLevel_0_StdVoltageLoSidd_MASK 0xffff0000
#define DPM_TABLE_53__VddciLevel_0_StdVoltageLoSidd__SHIFT 0x10
#define DPM_TABLE_54__VddciLevel_1_StdVoltageHiSidd_MASK 0xffff
#define DPM_TABLE_54__VddciLevel_1_StdVoltageHiSidd__SHIFT 0x0
#define DPM_TABLE_54__VddciLevel_1_Voltage_MASK 0xffff0000
#define DPM_TABLE_54__VddciLevel_1_Voltage__SHIFT 0x10
#define DPM_TABLE_55__VddciLevel_1_padding_MASK 0xff
#define DPM_TABLE_55__VddciLevel_1_padding__SHIFT 0x0
#define DPM_TABLE_55__VddciLevel_1_Smio_MASK 0xff00
#define DPM_TABLE_55__VddciLevel_1_Smio__SHIFT 0x8
#define DPM_TABLE_55__VddciLevel_1_StdVoltageLoSidd_MASK 0xffff0000
#define DPM_TABLE_55__VddciLevel_1_StdVoltageLoSidd__SHIFT 0x10
#define DPM_TABLE_56__VddciLevel_2_StdVoltageHiSidd_MASK 0xffff
#define DPM_TABLE_56__VddciLevel_2_StdVoltageHiSidd__SHIFT 0x0
#define DPM_TABLE_56__VddciLevel_2_Voltage_MASK 0xffff0000
#define DPM_TABLE_56__VddciLevel_2_Voltage__SHIFT 0x10
#define DPM_TABLE_57__VddciLevel_2_padding_MASK 0xff
#define DPM_TABLE_57__VddciLevel_2_padding__SHIFT 0x0
#define DPM_TABLE_57__VddciLevel_2_Smio_MASK 0xff00
#define DPM_TABLE_57__VddciLevel_2_Smio__SHIFT 0x8
#define DPM_TABLE_57__VddciLevel_2_StdVoltageLoSidd_MASK 0xffff0000
#define DPM_TABLE_57__VddciLevel_2_StdVoltageLoSidd__SHIFT 0x10
#define DPM_TABLE_58__VddciLevel_3_StdVoltageHiSidd_MASK 0xffff
#define DPM_TABLE_58__VddciLevel_3_StdVoltageHiSidd__SHIFT 0x0
#define DPM_TABLE_58__VddciLevel_3_Voltage_MASK 0xffff0000
#define DPM_TABLE_58__VddciLevel_3_Voltage__SHIFT 0x10
#define DPM_TABLE_59__VddciLevel_3_padding_MASK 0xff
#define DPM_TABLE_59__VddciLevel_3_padding__SHIFT 0x0
#define DPM_TABLE_59__VddciLevel_3_Smio_MASK 0xff00
#define DPM_TABLE_59__VddciLevel_3_Smio__SHIFT 0x8
#define DPM_TABLE_59__VddciLevel_3_StdVoltageLoSidd_MASK 0xffff0000
#define DPM_TABLE_59__VddciLevel_3_StdVoltageLoSidd__SHIFT 0x10
#define DPM_TABLE_60__MvddLevel_0_StdVoltageHiSidd_MASK 0xffff
#define DPM_TABLE_60__MvddLevel_0_StdVoltageHiSidd__SHIFT 0x0
#define DPM_TABLE_60__MvddLevel_0_Voltage_MASK 0xffff0000
#define DPM_TABLE_60__MvddLevel_0_Voltage__SHIFT 0x10
#define DPM_TABLE_61__MvddLevel_0_padding_MASK 0xff
#define DPM_TABLE_61__MvddLevel_0_padding__SHIFT 0x0
#define DPM_TABLE_61__MvddLevel_0_Smio_MASK 0xff00
#define DPM_TABLE_61__MvddLevel_0_Smio__SHIFT 0x8
#define DPM_TABLE_61__MvddLevel_0_StdVoltageLoSidd_MASK 0xffff0000
#define DPM_TABLE_61__MvddLevel_0_StdVoltageLoSidd__SHIFT 0x10
#define DPM_TABLE_62__MvddLevel_1_StdVoltageHiSidd_MASK 0xffff
#define DPM_TABLE_62__MvddLevel_1_StdVoltageHiSidd__SHIFT 0x0
#define DPM_TABLE_62__MvddLevel_1_Voltage_MASK 0xffff0000
#define DPM_TABLE_62__MvddLevel_1_Voltage__SHIFT 0x10
#define DPM_TABLE_63__MvddLevel_1_padding_MASK 0xff
#define DPM_TABLE_63__MvddLevel_1_padding__SHIFT 0x0
#define DPM_TABLE_63__MvddLevel_1_Smio_MASK 0xff00
#define DPM_TABLE_63__MvddLevel_1_Smio__SHIFT 0x8
#define DPM_TABLE_63__MvddLevel_1_StdVoltageLoSidd_MASK 0xffff0000
#define DPM_TABLE_63__MvddLevel_1_StdVoltageLoSidd__SHIFT 0x10
#define DPM_TABLE_64__MvddLevel_2_StdVoltageHiSidd_MASK 0xffff
#define DPM_TABLE_64__MvddLevel_2_StdVoltageHiSidd__SHIFT 0x0
#define DPM_TABLE_64__MvddLevel_2_Voltage_MASK 0xffff0000
#define DPM_TABLE_64__MvddLevel_2_Voltage__SHIFT 0x10
#define DPM_TABLE_65__MvddLevel_2_padding_MASK 0xff
#define DPM_TABLE_65__MvddLevel_2_padding__SHIFT 0x0
#define DPM_TABLE_65__MvddLevel_2_Smio_MASK 0xff00
#define DPM_TABLE_65__MvddLevel_2_Smio__SHIFT 0x8
#define DPM_TABLE_65__MvddLevel_2_StdVoltageLoSidd_MASK 0xffff0000
#define DPM_TABLE_65__MvddLevel_2_StdVoltageLoSidd__SHIFT 0x10
#define DPM_TABLE_66__MvddLevel_3_StdVoltageHiSidd_MASK 0xffff
#define DPM_TABLE_66__MvddLevel_3_StdVoltageHiSidd__SHIFT 0x0
#define DPM_TABLE_66__MvddLevel_3_Voltage_MASK 0xffff0000
#define DPM_TABLE_66__MvddLevel_3_Voltage__SHIFT 0x10
#define DPM_TABLE_67__MvddLevel_3_padding_MASK 0xff
#define DPM_TABLE_67__MvddLevel_3_padding__SHIFT 0x0
#define DPM_TABLE_67__MvddLevel_3_Smio_MASK 0xff00
#define DPM_TABLE_67__MvddLevel_3_Smio__SHIFT 0x8
#define DPM_TABLE_67__MvddLevel_3_StdVoltageLoSidd_MASK 0xffff0000
#define DPM_TABLE_67__MvddLevel_3_StdVoltageLoSidd__SHIFT 0x10
#define DPM_TABLE_68__UvdLevelCount_MASK 0xff
#define DPM_TABLE_68__UvdLevelCount__SHIFT 0x0
#define DPM_TABLE_68__LinkLevelCount_MASK 0xff00
#define DPM_TABLE_68__LinkLevelCount__SHIFT 0x8
#define DPM_TABLE_68__MemoryDpmLevelCount_MASK 0xff0000
#define DPM_TABLE_68__MemoryDpmLevelCount__SHIFT 0x10
#define DPM_TABLE_68__GraphicsDpmLevelCount_MASK 0xff000000
#define DPM_TABLE_68__GraphicsDpmLevelCount__SHIFT 0x18
#define DPM_TABLE_69__padding2_MASK 0xff
#define DPM_TABLE_69__padding2__SHIFT 0x0
#define DPM_TABLE_69__SamuLevelCount_MASK 0xff00
#define DPM_TABLE_69__SamuLevelCount__SHIFT 0x8
#define DPM_TABLE_69__AcpLevelCount_MASK 0xff0000
#define DPM_TABLE_69__AcpLevelCount__SHIFT 0x10
#define DPM_TABLE_69__VceLevelCount_MASK 0xff000000
#define DPM_TABLE_69__VceLevelCount__SHIFT 0x18
#define DPM_TABLE_70__Reserved_0_MASK 0xffffffff
#define DPM_TABLE_70__Reserved_0__SHIFT 0x0
#define DPM_TABLE_71__Reserved_1_MASK 0xffffffff
#define DPM_TABLE_71__Reserved_1__SHIFT 0x0
#define DPM_TABLE_72__Reserved_2_MASK 0xffffffff
#define DPM_TABLE_72__Reserved_2__SHIFT 0x0
#define DPM_TABLE_73__Reserved_3_MASK 0xffffffff
#define DPM_TABLE_73__Reserved_3__SHIFT 0x0
#define DPM_TABLE_74__Reserved_4_MASK 0xffffffff
#define DPM_TABLE_74__Reserved_4__SHIFT 0x0
#define DPM_TABLE_75__GraphicsLevel_0_Flags_MASK 0xffffffff
#define DPM_TABLE_75__GraphicsLevel_0_Flags__SHIFT 0x0
#define DPM_TABLE_76__GraphicsLevel_0_MinVddc_MASK 0xffffffff
#define DPM_TABLE_76__GraphicsLevel_0_MinVddc__SHIFT 0x0
#define DPM_TABLE_77__GraphicsLevel_0_MinVddcPhases_MASK 0xffffffff
#define DPM_TABLE_77__GraphicsLevel_0_MinVddcPhases__SHIFT 0x0
#define DPM_TABLE_78__GraphicsLevel_0_SclkFrequency_MASK 0xffffffff
#define DPM_TABLE_78__GraphicsLevel_0_SclkFrequency__SHIFT 0x0
#define DPM_TABLE_79__GraphicsLevel_0_ActivityLevel_MASK 0xffff
#define DPM_TABLE_79__GraphicsLevel_0_ActivityLevel__SHIFT 0x0
#define DPM_TABLE_79__GraphicsLevel_0_padding1_1_MASK 0xff0000
#define DPM_TABLE_79__GraphicsLevel_0_padding1_1__SHIFT 0x10
#define DPM_TABLE_79__GraphicsLevel_0_padding1_0_MASK 0xff000000
#define DPM_TABLE_79__GraphicsLevel_0_padding1_0__SHIFT 0x18
#define DPM_TABLE_80__GraphicsLevel_0_CgSpllFuncCntl3_MASK 0xffffffff
#define DPM_TABLE_80__GraphicsLevel_0_CgSpllFuncCntl3__SHIFT 0x0
#define DPM_TABLE_81__GraphicsLevel_0_CgSpllFuncCntl4_MASK 0xffffffff
#define DPM_TABLE_81__GraphicsLevel_0_CgSpllFuncCntl4__SHIFT 0x0
#define DPM_TABLE_82__GraphicsLevel_0_SpllSpreadSpectrum_MASK 0xffffffff
#define DPM_TABLE_82__GraphicsLevel_0_SpllSpreadSpectrum__SHIFT 0x0
#define DPM_TABLE_83__GraphicsLevel_0_SpllSpreadSpectrum2_MASK 0xffffffff
#define DPM_TABLE_83__GraphicsLevel_0_SpllSpreadSpectrum2__SHIFT 0x0
#define DPM_TABLE_84__GraphicsLevel_0_CcPwrDynRm_MASK 0xffffffff
#define DPM_TABLE_84__GraphicsLevel_0_CcPwrDynRm__SHIFT 0x0
#define DPM_TABLE_85__GraphicsLevel_0_CcPwrDynRm1_MASK 0xffffffff
#define DPM_TABLE_85__GraphicsLevel_0_CcPwrDynRm1__SHIFT 0x0
#define DPM_TABLE_86__GraphicsLevel_0_EnabledForThrottle_MASK 0xff
#define DPM_TABLE_86__GraphicsLevel_0_EnabledForThrottle__SHIFT 0x0
#define DPM_TABLE_86__GraphicsLevel_0_EnabledForActivity_MASK 0xff00
#define DPM_TABLE_86__GraphicsLevel_0_EnabledForActivity__SHIFT 0x8
#define DPM_TABLE_86__GraphicsLevel_0_DisplayWatermark_MASK 0xff0000
#define DPM_TABLE_86__GraphicsLevel_0_DisplayWatermark__SHIFT 0x10
#define DPM_TABLE_86__GraphicsLevel_0_SclkDid_MASK 0xff000000
#define DPM_TABLE_86__GraphicsLevel_0_SclkDid__SHIFT 0x18
#define DPM_TABLE_87__GraphicsLevel_0_PowerThrottle_MASK 0xff
#define DPM_TABLE_87__GraphicsLevel_0_PowerThrottle__SHIFT 0x0
#define DPM_TABLE_87__GraphicsLevel_0_VoltageDownHyst_MASK 0xff00
#define DPM_TABLE_87__GraphicsLevel_0_VoltageDownHyst__SHIFT 0x8
#define DPM_TABLE_87__GraphicsLevel_0_DownHyst_MASK 0xff0000
#define DPM_TABLE_87__GraphicsLevel_0_DownHyst__SHIFT 0x10
#define DPM_TABLE_87__GraphicsLevel_0_UpHyst_MASK 0xff000000
#define DPM_TABLE_87__GraphicsLevel_0_UpHyst__SHIFT 0x18
#define DPM_TABLE_88__GraphicsLevel_0_padding_2_MASK 0xff
#define DPM_TABLE_88__GraphicsLevel_0_padding_2__SHIFT 0x0
#define DPM_TABLE_88__GraphicsLevel_0_padding_1_MASK 0xff00
#define DPM_TABLE_88__GraphicsLevel_0_padding_1__SHIFT 0x8
#define DPM_TABLE_88__GraphicsLevel_0_padding_0_MASK 0xff0000
#define DPM_TABLE_88__GraphicsLevel_0_padding_0__SHIFT 0x10
#define DPM_TABLE_88__GraphicsLevel_0_DeepSleepDivId_MASK 0xff000000
#define DPM_TABLE_88__GraphicsLevel_0_DeepSleepDivId__SHIFT 0x18
#define DPM_TABLE_89__GraphicsLevel_1_Flags_MASK 0xffffffff
#define DPM_TABLE_89__GraphicsLevel_1_Flags__SHIFT 0x0
#define DPM_TABLE_90__GraphicsLevel_1_MinVddc_MASK 0xffffffff
#define DPM_TABLE_90__GraphicsLevel_1_MinVddc__SHIFT 0x0
#define DPM_TABLE_91__GraphicsLevel_1_MinVddcPhases_MASK 0xffffffff
#define DPM_TABLE_91__GraphicsLevel_1_MinVddcPhases__SHIFT 0x0
#define DPM_TABLE_92__GraphicsLevel_1_SclkFrequency_MASK 0xffffffff
#define DPM_TABLE_92__GraphicsLevel_1_SclkFrequency__SHIFT 0x0
#define DPM_TABLE_93__GraphicsLevel_1_ActivityLevel_MASK 0xffff
#define DPM_TABLE_93__GraphicsLevel_1_ActivityLevel__SHIFT 0x0
#define DPM_TABLE_93__GraphicsLevel_1_padding1_1_MASK 0xff0000
#define DPM_TABLE_93__GraphicsLevel_1_padding1_1__SHIFT 0x10
#define DPM_TABLE_93__GraphicsLevel_1_padding1_0_MASK 0xff000000
#define DPM_TABLE_93__GraphicsLevel_1_padding1_0__SHIFT 0x18
#define DPM_TABLE_94__GraphicsLevel_1_CgSpllFuncCntl3_MASK 0xffffffff
#define DPM_TABLE_94__GraphicsLevel_1_CgSpllFuncCntl3__SHIFT 0x0
#define DPM_TABLE_95__GraphicsLevel_1_CgSpllFuncCntl4_MASK 0xffffffff
#define DPM_TABLE_95__GraphicsLevel_1_CgSpllFuncCntl4__SHIFT 0x0
#define DPM_TABLE_96__GraphicsLevel_1_SpllSpreadSpectrum_MASK 0xffffffff
#define DPM_TABLE_96__GraphicsLevel_1_SpllSpreadSpectrum__SHIFT 0x0
#define DPM_TABLE_97__GraphicsLevel_1_SpllSpreadSpectrum2_MASK 0xffffffff
#define DPM_TABLE_97__GraphicsLevel_1_SpllSpreadSpectrum2__SHIFT 0x0
#define DPM_TABLE_98__GraphicsLevel_1_CcPwrDynRm_MASK 0xffffffff
#define DPM_TABLE_98__GraphicsLevel_1_CcPwrDynRm__SHIFT 0x0
#define DPM_TABLE_99__GraphicsLevel_1_CcPwrDynRm1_MASK 0xffffffff
#define DPM_TABLE_99__GraphicsLevel_1_CcPwrDynRm1__SHIFT 0x0
#define DPM_TABLE_100__GraphicsLevel_1_EnabledForThrottle_MASK 0xff
#define DPM_TABLE_100__GraphicsLevel_1_EnabledForThrottle__SHIFT 0x0
#define DPM_TABLE_100__GraphicsLevel_1_EnabledForActivity_MASK 0xff00
#define DPM_TABLE_100__GraphicsLevel_1_EnabledForActivity__SHIFT 0x8
#define DPM_TABLE_100__GraphicsLevel_1_DisplayWatermark_MASK 0xff0000
#define DPM_TABLE_100__GraphicsLevel_1_DisplayWatermark__SHIFT 0x10
#define DPM_TABLE_100__GraphicsLevel_1_SclkDid_MASK 0xff000000
#define DPM_TABLE_100__GraphicsLevel_1_SclkDid__SHIFT 0x18
#define DPM_TABLE_101__GraphicsLevel_1_PowerThrottle_MASK 0xff
#define DPM_TABLE_101__GraphicsLevel_1_PowerThrottle__SHIFT 0x0
#define DPM_TABLE_101__GraphicsLevel_1_VoltageDownHyst_MASK 0xff00
#define DPM_TABLE_101__GraphicsLevel_1_VoltageDownHyst__SHIFT 0x8
#define DPM_TABLE_101__GraphicsLevel_1_DownHyst_MASK 0xff0000
#define DPM_TABLE_101__GraphicsLevel_1_DownHyst__SHIFT 0x10
#define DPM_TABLE_101__GraphicsLevel_1_UpHyst_MASK 0xff000000
#define DPM_TABLE_101__GraphicsLevel_1_UpHyst__SHIFT 0x18
#define DPM_TABLE_102__GraphicsLevel_1_padding_2_MASK 0xff
#define DPM_TABLE_102__GraphicsLevel_1_padding_2__SHIFT 0x0
#define DPM_TABLE_102__GraphicsLevel_1_padding_1_MASK 0xff00
#define DPM_TABLE_102__GraphicsLevel_1_padding_1__SHIFT 0x8
#define DPM_TABLE_102__GraphicsLevel_1_padding_0_MASK 0xff0000
#define DPM_TABLE_102__GraphicsLevel_1_padding_0__SHIFT 0x10
#define DPM_TABLE_102__GraphicsLevel_1_DeepSleepDivId_MASK 0xff000000
#define DPM_TABLE_102__GraphicsLevel_1_DeepSleepDivId__SHIFT 0x18
#define DPM_TABLE_103__GraphicsLevel_2_Flags_MASK 0xffffffff
#define DPM_TABLE_103__GraphicsLevel_2_Flags__SHIFT 0x0
#define DPM_TABLE_104__GraphicsLevel_2_MinVddc_MASK 0xffffffff
#define DPM_TABLE_104__GraphicsLevel_2_MinVddc__SHIFT 0x0
#define DPM_TABLE_105__GraphicsLevel_2_MinVddcPhases_MASK 0xffffffff
#define DPM_TABLE_105__GraphicsLevel_2_MinVddcPhases__SHIFT 0x0
#define DPM_TABLE_106__GraphicsLevel_2_SclkFrequency_MASK 0xffffffff
#define DPM_TABLE_106__GraphicsLevel_2_SclkFrequency__SHIFT 0x0
#define DPM_TABLE_107__GraphicsLevel_2_ActivityLevel_MASK 0xffff
#define DPM_TABLE_107__GraphicsLevel_2_ActivityLevel__SHIFT 0x0
#define DPM_TABLE_107__GraphicsLevel_2_padding1_1_MASK 0xff0000
#define DPM_TABLE_107__GraphicsLevel_2_padding1_1__SHIFT 0x10
#define DPM_TABLE_107__GraphicsLevel_2_padding1_0_MASK 0xff000000
#define DPM_TABLE_107__GraphicsLevel_2_padding1_0__SHIFT 0x18
#define DPM_TABLE_108__GraphicsLevel_2_CgSpllFuncCntl3_MASK 0xffffffff
#define DPM_TABLE_108__GraphicsLevel_2_CgSpllFuncCntl3__SHIFT 0x0
#define DPM_TABLE_109__GraphicsLevel_2_CgSpllFuncCntl4_MASK 0xffffffff
#define DPM_TABLE_109__GraphicsLevel_2_CgSpllFuncCntl4__SHIFT 0x0
#define DPM_TABLE_110__GraphicsLevel_2_SpllSpreadSpectrum_MASK 0xffffffff
#define DPM_TABLE_110__GraphicsLevel_2_SpllSpreadSpectrum__SHIFT 0x0
#define DPM_TABLE_111__GraphicsLevel_2_SpllSpreadSpectrum2_MASK 0xffffffff
#define DPM_TABLE_111__GraphicsLevel_2_SpllSpreadSpectrum2__SHIFT 0x0
#define DPM_TABLE_112__GraphicsLevel_2_CcPwrDynRm_MASK 0xffffffff
#define DPM_TABLE_112__GraphicsLevel_2_CcPwrDynRm__SHIFT 0x0
#define DPM_TABLE_113__GraphicsLevel_2_CcPwrDynRm1_MASK 0xffffffff
#define DPM_TABLE_113__GraphicsLevel_2_CcPwrDynRm1__SHIFT 0x0
#define DPM_TABLE_114__GraphicsLevel_2_EnabledForThrottle_MASK 0xff
#define DPM_TABLE_114__GraphicsLevel_2_EnabledForThrottle__SHIFT 0x0
#define DPM_TABLE_114__GraphicsLevel_2_EnabledForActivity_MASK 0xff00
#define DPM_TABLE_114__GraphicsLevel_2_EnabledForActivity__SHIFT 0x8
#define DPM_TABLE_114__GraphicsLevel_2_DisplayWatermark_MASK 0xff0000
#define DPM_TABLE_114__GraphicsLevel_2_DisplayWatermark__SHIFT 0x10
#define DPM_TABLE_114__GraphicsLevel_2_SclkDid_MASK 0xff000000
#define DPM_TABLE_114__GraphicsLevel_2_SclkDid__SHIFT 0x18
#define DPM_TABLE_115__GraphicsLevel_2_PowerThrottle_MASK 0xff
#define DPM_TABLE_115__GraphicsLevel_2_PowerThrottle__SHIFT 0x0
#define DPM_TABLE_115__GraphicsLevel_2_VoltageDownHyst_MASK 0xff00
#define DPM_TABLE_115__GraphicsLevel_2_VoltageDownHyst__SHIFT 0x8
#define DPM_TABLE_115__GraphicsLevel_2_DownHyst_MASK 0xff0000
#define DPM_TABLE_115__GraphicsLevel_2_DownHyst__SHIFT 0x10
#define DPM_TABLE_115__GraphicsLevel_2_UpHyst_MASK 0xff000000
#define DPM_TABLE_115__GraphicsLevel_2_UpHyst__SHIFT 0x18
#define DPM_TABLE_116__GraphicsLevel_2_padding_2_MASK 0xff
#define DPM_TABLE_116__GraphicsLevel_2_padding_2__SHIFT 0x0
#define DPM_TABLE_116__GraphicsLevel_2_padding_1_MASK 0xff00
#define DPM_TABLE_116__GraphicsLevel_2_padding_1__SHIFT 0x8
#define DPM_TABLE_116__GraphicsLevel_2_padding_0_MASK 0xff0000
#define DPM_TABLE_116__GraphicsLevel_2_padding_0__SHIFT 0x10
#define DPM_TABLE_116__GraphicsLevel_2_DeepSleepDivId_MASK 0xff000000
#define DPM_TABLE_116__GraphicsLevel_2_DeepSleepDivId__SHIFT 0x18
#define DPM_TABLE_117__GraphicsLevel_3_Flags_MASK 0xffffffff
#define DPM_TABLE_117__GraphicsLevel_3_Flags__SHIFT 0x0
#define DPM_TABLE_118__GraphicsLevel_3_MinVddc_MASK 0xffffffff
#define DPM_TABLE_118__GraphicsLevel_3_MinVddc__SHIFT 0x0
#define DPM_TABLE_119__GraphicsLevel_3_MinVddcPhases_MASK 0xffffffff
#define DPM_TABLE_119__GraphicsLevel_3_MinVddcPhases__SHIFT 0x0
#define DPM_TABLE_120__GraphicsLevel_3_SclkFrequency_MASK 0xffffffff
#define DPM_TABLE_120__GraphicsLevel_3_SclkFrequency__SHIFT 0x0
#define DPM_TABLE_121__GraphicsLevel_3_ActivityLevel_MASK 0xffff
#define DPM_TABLE_121__GraphicsLevel_3_ActivityLevel__SHIFT 0x0
#define DPM_TABLE_121__GraphicsLevel_3_padding1_1_MASK 0xff0000
#define DPM_TABLE_121__GraphicsLevel_3_padding1_1__SHIFT 0x10
#define DPM_TABLE_121__GraphicsLevel_3_padding1_0_MASK 0xff000000
#define DPM_TABLE_121__GraphicsLevel_3_padding1_0__SHIFT 0x18
#define DPM_TABLE_122__GraphicsLevel_3_CgSpllFuncCntl3_MASK 0xffffffff
#define DPM_TABLE_122__GraphicsLevel_3_CgSpllFuncCntl3__SHIFT 0x0
#define DPM_TABLE_123__GraphicsLevel_3_CgSpllFuncCntl4_MASK 0xffffffff
#define DPM_TABLE_123__GraphicsLevel_3_CgSpllFuncCntl4__SHIFT 0x0
#define DPM_TABLE_124__GraphicsLevel_3_SpllSpreadSpectrum_MASK 0xffffffff
#define DPM_TABLE_124__GraphicsLevel_3_SpllSpreadSpectrum__SHIFT 0x0
#define DPM_TABLE_125__GraphicsLevel_3_SpllSpreadSpectrum2_MASK 0xffffffff
#define DPM_TABLE_125__GraphicsLevel_3_SpllSpreadSpectrum2__SHIFT 0x0
#define DPM_TABLE_126__GraphicsLevel_3_CcPwrDynRm_MASK 0xffffffff
#define DPM_TABLE_126__GraphicsLevel_3_CcPwrDynRm__SHIFT 0x0
#define DPM_TABLE_127__GraphicsLevel_3_CcPwrDynRm1_MASK 0xffffffff
#define DPM_TABLE_127__GraphicsLevel_3_CcPwrDynRm1__SHIFT 0x0
#define DPM_TABLE_128__GraphicsLevel_3_EnabledForThrottle_MASK 0xff
#define DPM_TABLE_128__GraphicsLevel_3_EnabledForThrottle__SHIFT 0x0
#define DPM_TABLE_128__GraphicsLevel_3_EnabledForActivity_MASK 0xff00
#define DPM_TABLE_128__GraphicsLevel_3_EnabledForActivity__SHIFT 0x8
#define DPM_TABLE_128__GraphicsLevel_3_DisplayWatermark_MASK 0xff0000
#define DPM_TABLE_128__GraphicsLevel_3_DisplayWatermark__SHIFT 0x10
#define DPM_TABLE_128__GraphicsLevel_3_SclkDid_MASK 0xff000000
#define DPM_TABLE_128__GraphicsLevel_3_SclkDid__SHIFT 0x18
#define DPM_TABLE_129__GraphicsLevel_3_PowerThrottle_MASK 0xff
#define DPM_TABLE_129__GraphicsLevel_3_PowerThrottle__SHIFT 0x0
#define DPM_TABLE_129__GraphicsLevel_3_VoltageDownHyst_MASK 0xff00
#define DPM_TABLE_129__GraphicsLevel_3_VoltageDownHyst__SHIFT 0x8
#define DPM_TABLE_129__GraphicsLevel_3_DownHyst_MASK 0xff0000
#define DPM_TABLE_129__GraphicsLevel_3_DownHyst__SHIFT 0x10
#define DPM_TABLE_129__GraphicsLevel_3_UpHyst_MASK 0xff000000
#define DPM_TABLE_129__GraphicsLevel_3_UpHyst__SHIFT 0x18
#define DPM_TABLE_130__GraphicsLevel_3_padding_2_MASK 0xff
#define DPM_TABLE_130__GraphicsLevel_3_padding_2__SHIFT 0x0
#define DPM_TABLE_130__GraphicsLevel_3_padding_1_MASK 0xff00
#define DPM_TABLE_130__GraphicsLevel_3_padding_1__SHIFT 0x8
#define DPM_TABLE_130__GraphicsLevel_3_padding_0_MASK 0xff0000
#define DPM_TABLE_130__GraphicsLevel_3_padding_0__SHIFT 0x10
#define DPM_TABLE_130__GraphicsLevel_3_DeepSleepDivId_MASK 0xff000000
#define DPM_TABLE_130__GraphicsLevel_3_DeepSleepDivId__SHIFT 0x18
#define DPM_TABLE_131__GraphicsLevel_4_Flags_MASK 0xffffffff
#define DPM_TABLE_131__GraphicsLevel_4_Flags__SHIFT 0x0
#define DPM_TABLE_132__GraphicsLevel_4_MinVddc_MASK 0xffffffff
#define DPM_TABLE_132__GraphicsLevel_4_MinVddc__SHIFT 0x0
#define DPM_TABLE_133__GraphicsLevel_4_MinVddcPhases_MASK 0xffffffff
#define DPM_TABLE_133__GraphicsLevel_4_MinVddcPhases__SHIFT 0x0
#define DPM_TABLE_134__GraphicsLevel_4_SclkFrequency_MASK 0xffffffff
#define DPM_TABLE_134__GraphicsLevel_4_SclkFrequency__SHIFT 0x0
#define DPM_TABLE_135__GraphicsLevel_4_ActivityLevel_MASK 0xffff
#define DPM_TABLE_135__GraphicsLevel_4_ActivityLevel__SHIFT 0x0
#define DPM_TABLE_135__GraphicsLevel_4_padding1_1_MASK 0xff0000
#define DPM_TABLE_135__GraphicsLevel_4_padding1_1__SHIFT 0x10
#define DPM_TABLE_135__GraphicsLevel_4_padding1_0_MASK 0xff000000
#define DPM_TABLE_135__GraphicsLevel_4_padding1_0__SHIFT 0x18
#define DPM_TABLE_136__GraphicsLevel_4_CgSpllFuncCntl3_MASK 0xffffffff
#define DPM_TABLE_136__GraphicsLevel_4_CgSpllFuncCntl3__SHIFT 0x0
#define DPM_TABLE_137__GraphicsLevel_4_CgSpllFuncCntl4_MASK 0xffffffff
#define DPM_TABLE_137__GraphicsLevel_4_CgSpllFuncCntl4__SHIFT 0x0
#define DPM_TABLE_138__GraphicsLevel_4_SpllSpreadSpectrum_MASK 0xffffffff
#define DPM_TABLE_138__GraphicsLevel_4_SpllSpreadSpectrum__SHIFT 0x0
#define DPM_TABLE_139__GraphicsLevel_4_SpllSpreadSpectrum2_MASK 0xffffffff
#define DPM_TABLE_139__GraphicsLevel_4_SpllSpreadSpectrum2__SHIFT 0x0
#define DPM_TABLE_140__GraphicsLevel_4_CcPwrDynRm_MASK 0xffffffff
#define DPM_TABLE_140__GraphicsLevel_4_CcPwrDynRm__SHIFT 0x0
#define DPM_TABLE_141__GraphicsLevel_4_CcPwrDynRm1_MASK 0xffffffff
#define DPM_TABLE_141__GraphicsLevel_4_CcPwrDynRm1__SHIFT 0x0
#define DPM_TABLE_142__GraphicsLevel_4_EnabledForThrottle_MASK 0xff
#define DPM_TABLE_142__GraphicsLevel_4_EnabledForThrottle__SHIFT 0x0
#define DPM_TABLE_142__GraphicsLevel_4_EnabledForActivity_MASK 0xff00
#define DPM_TABLE_142__GraphicsLevel_4_EnabledForActivity__SHIFT 0x8
#define DPM_TABLE_142__GraphicsLevel_4_DisplayWatermark_MASK 0xff0000
#define DPM_TABLE_142__GraphicsLevel_4_DisplayWatermark__SHIFT 0x10
#define DPM_TABLE_142__GraphicsLevel_4_SclkDid_MASK 0xff000000
#define DPM_TABLE_142__GraphicsLevel_4_SclkDid__SHIFT 0x18
#define DPM_TABLE_143__GraphicsLevel_4_PowerThrottle_MASK 0xff
#define DPM_TABLE_143__GraphicsLevel_4_PowerThrottle__SHIFT 0x0
#define DPM_TABLE_143__GraphicsLevel_4_VoltageDownHyst_MASK 0xff00
#define DPM_TABLE_143__GraphicsLevel_4_VoltageDownHyst__SHIFT 0x8
#define DPM_TABLE_143__GraphicsLevel_4_DownHyst_MASK 0xff0000
#define DPM_TABLE_143__GraphicsLevel_4_DownHyst__SHIFT 0x10
#define DPM_TABLE_143__GraphicsLevel_4_UpHyst_MASK 0xff000000
#define DPM_TABLE_143__GraphicsLevel_4_UpHyst__SHIFT 0x18
#define DPM_TABLE_144__GraphicsLevel_4_padding_2_MASK 0xff
#define DPM_TABLE_144__GraphicsLevel_4_padding_2__SHIFT 0x0
#define DPM_TABLE_144__GraphicsLevel_4_padding_1_MASK 0xff00
#define DPM_TABLE_144__GraphicsLevel_4_padding_1__SHIFT 0x8
#define DPM_TABLE_144__GraphicsLevel_4_padding_0_MASK 0xff0000
#define DPM_TABLE_144__GraphicsLevel_4_padding_0__SHIFT 0x10
#define DPM_TABLE_144__GraphicsLevel_4_DeepSleepDivId_MASK 0xff000000
#define DPM_TABLE_144__GraphicsLevel_4_DeepSleepDivId__SHIFT 0x18
#define DPM_TABLE_145__GraphicsLevel_5_Flags_MASK 0xffffffff
#define DPM_TABLE_145__GraphicsLevel_5_Flags__SHIFT 0x0
#define DPM_TABLE_146__GraphicsLevel_5_MinVddc_MASK 0xffffffff
#define DPM_TABLE_146__GraphicsLevel_5_MinVddc__SHIFT 0x0
#define DPM_TABLE_147__GraphicsLevel_5_MinVddcPhases_MASK 0xffffffff
#define DPM_TABLE_147__GraphicsLevel_5_MinVddcPhases__SHIFT 0x0
#define DPM_TABLE_148__GraphicsLevel_5_SclkFrequency_MASK 0xffffffff
#define DPM_TABLE_148__GraphicsLevel_5_SclkFrequency__SHIFT 0x0
#define DPM_TABLE_149__GraphicsLevel_5_ActivityLevel_MASK 0xffff
#define DPM_TABLE_149__GraphicsLevel_5_ActivityLevel__SHIFT 0x0
#define DPM_TABLE_149__GraphicsLevel_5_padding1_1_MASK 0xff0000
#define DPM_TABLE_149__GraphicsLevel_5_padding1_1__SHIFT 0x10
#define DPM_TABLE_149__GraphicsLevel_5_padding1_0_MASK 0xff000000
#define DPM_TABLE_149__GraphicsLevel_5_padding1_0__SHIFT 0x18
#define DPM_TABLE_150__GraphicsLevel_5_CgSpllFuncCntl3_MASK 0xffffffff
#define DPM_TABLE_150__GraphicsLevel_5_CgSpllFuncCntl3__SHIFT 0x0
#define DPM_TABLE_151__GraphicsLevel_5_CgSpllFuncCntl4_MASK 0xffffffff
#define DPM_TABLE_151__GraphicsLevel_5_CgSpllFuncCntl4__SHIFT 0x0
#define DPM_TABLE_152__GraphicsLevel_5_SpllSpreadSpectrum_MASK 0xffffffff
#define DPM_TABLE_152__GraphicsLevel_5_SpllSpreadSpectrum__SHIFT 0x0
#define DPM_TABLE_153__GraphicsLevel_5_SpllSpreadSpectrum2_MASK 0xffffffff
#define DPM_TABLE_153__GraphicsLevel_5_SpllSpreadSpectrum2__SHIFT 0x0
#define DPM_TABLE_154__GraphicsLevel_5_CcPwrDynRm_MASK 0xffffffff
#define DPM_TABLE_154__GraphicsLevel_5_CcPwrDynRm__SHIFT 0x0
#define DPM_TABLE_155__GraphicsLevel_5_CcPwrDynRm1_MASK 0xffffffff
#define DPM_TABLE_155__GraphicsLevel_5_CcPwrDynRm1__SHIFT 0x0
#define DPM_TABLE_156__GraphicsLevel_5_EnabledForThrottle_MASK 0xff
#define DPM_TABLE_156__GraphicsLevel_5_EnabledForThrottle__SHIFT 0x0
#define DPM_TABLE_156__GraphicsLevel_5_EnabledForActivity_MASK 0xff00
#define DPM_TABLE_156__GraphicsLevel_5_EnabledForActivity__SHIFT 0x8
#define DPM_TABLE_156__GraphicsLevel_5_DisplayWatermark_MASK 0xff0000
#define DPM_TABLE_156__GraphicsLevel_5_DisplayWatermark__SHIFT 0x10
#define DPM_TABLE_156__GraphicsLevel_5_SclkDid_MASK 0xff000000
#define DPM_TABLE_156__GraphicsLevel_5_SclkDid__SHIFT 0x18
#define DPM_TABLE_157__GraphicsLevel_5_PowerThrottle_MASK 0xff
#define DPM_TABLE_157__GraphicsLevel_5_PowerThrottle__SHIFT 0x0
#define DPM_TABLE_157__GraphicsLevel_5_VoltageDownHyst_MASK 0xff00
#define DPM_TABLE_157__GraphicsLevel_5_VoltageDownHyst__SHIFT 0x8
#define DPM_TABLE_157__GraphicsLevel_5_DownHyst_MASK 0xff0000
#define DPM_TABLE_157__GraphicsLevel_5_DownHyst__SHIFT 0x10
#define DPM_TABLE_157__GraphicsLevel_5_UpHyst_MASK 0xff000000
#define DPM_TABLE_157__GraphicsLevel_5_UpHyst__SHIFT 0x18
#define DPM_TABLE_158__GraphicsLevel_5_padding_2_MASK 0xff
#define DPM_TABLE_158__GraphicsLevel_5_padding_2__SHIFT 0x0
#define DPM_TABLE_158__GraphicsLevel_5_padding_1_MASK 0xff00
#define DPM_TABLE_158__GraphicsLevel_5_padding_1__SHIFT 0x8
#define DPM_TABLE_158__GraphicsLevel_5_padding_0_MASK 0xff0000
#define DPM_TABLE_158__GraphicsLevel_5_padding_0__SHIFT 0x10
#define DPM_TABLE_158__GraphicsLevel_5_DeepSleepDivId_MASK 0xff000000
#define DPM_TABLE_158__GraphicsLevel_5_DeepSleepDivId__SHIFT 0x18
#define DPM_TABLE_159__GraphicsLevel_6_Flags_MASK 0xffffffff
#define DPM_TABLE_159__GraphicsLevel_6_Flags__SHIFT 0x0
#define DPM_TABLE_160__GraphicsLevel_6_MinVddc_MASK 0xffffffff
#define DPM_TABLE_160__GraphicsLevel_6_MinVddc__SHIFT 0x0
#define DPM_TABLE_161__GraphicsLevel_6_MinVddcPhases_MASK 0xffffffff
#define DPM_TABLE_161__GraphicsLevel_6_MinVddcPhases__SHIFT 0x0
#define DPM_TABLE_162__GraphicsLevel_6_SclkFrequency_MASK 0xffffffff
#define DPM_TABLE_162__GraphicsLevel_6_SclkFrequency__SHIFT 0x0
#define DPM_TABLE_163__GraphicsLevel_6_ActivityLevel_MASK 0xffff
#define DPM_TABLE_163__GraphicsLevel_6_ActivityLevel__SHIFT 0x0
#define DPM_TABLE_163__GraphicsLevel_6_padding1_1_MASK 0xff0000
#define DPM_TABLE_163__GraphicsLevel_6_padding1_1__SHIFT 0x10
#define DPM_TABLE_163__GraphicsLevel_6_padding1_0_MASK 0xff000000
#define DPM_TABLE_163__GraphicsLevel_6_padding1_0__SHIFT 0x18
#define DPM_TABLE_164__GraphicsLevel_6_CgSpllFuncCntl3_MASK 0xffffffff
#define DPM_TABLE_164__GraphicsLevel_6_CgSpllFuncCntl3__SHIFT 0x0
#define DPM_TABLE_165__GraphicsLevel_6_CgSpllFuncCntl4_MASK 0xffffffff
#define DPM_TABLE_165__GraphicsLevel_6_CgSpllFuncCntl4__SHIFT 0x0
#define DPM_TABLE_166__GraphicsLevel_6_SpllSpreadSpectrum_MASK 0xffffffff
#define DPM_TABLE_166__GraphicsLevel_6_SpllSpreadSpectrum__SHIFT 0x0
#define DPM_TABLE_167__GraphicsLevel_6_SpllSpreadSpectrum2_MASK 0xffffffff
#define DPM_TABLE_167__GraphicsLevel_6_SpllSpreadSpectrum2__SHIFT 0x0
#define DPM_TABLE_168__GraphicsLevel_6_CcPwrDynRm_MASK 0xffffffff
#define DPM_TABLE_168__GraphicsLevel_6_CcPwrDynRm__SHIFT 0x0
#define DPM_TABLE_169__GraphicsLevel_6_CcPwrDynRm1_MASK 0xffffffff
#define DPM_TABLE_169__GraphicsLevel_6_CcPwrDynRm1__SHIFT 0x0
#define DPM_TABLE_170__GraphicsLevel_6_EnabledForThrottle_MASK 0xff
#define DPM_TABLE_170__GraphicsLevel_6_EnabledForThrottle__SHIFT 0x0
#define DPM_TABLE_170__GraphicsLevel_6_EnabledForActivity_MASK 0xff00
#define DPM_TABLE_170__GraphicsLevel_6_EnabledForActivity__SHIFT 0x8
#define DPM_TABLE_170__GraphicsLevel_6_DisplayWatermark_MASK 0xff0000
#define DPM_TABLE_170__GraphicsLevel_6_DisplayWatermark__SHIFT 0x10
#define DPM_TABLE_170__GraphicsLevel_6_SclkDid_MASK 0xff000000
#define DPM_TABLE_170__GraphicsLevel_6_SclkDid__SHIFT 0x18
#define DPM_TABLE_171__GraphicsLevel_6_PowerThrottle_MASK 0xff
#define DPM_TABLE_171__GraphicsLevel_6_PowerThrottle__SHIFT 0x0
#define DPM_TABLE_171__GraphicsLevel_6_VoltageDownHyst_MASK 0xff00
#define DPM_TABLE_171__GraphicsLevel_6_VoltageDownHyst__SHIFT 0x8
#define DPM_TABLE_171__GraphicsLevel_6_DownHyst_MASK 0xff0000
#define DPM_TABLE_171__GraphicsLevel_6_DownHyst__SHIFT 0x10
#define DPM_TABLE_171__GraphicsLevel_6_UpHyst_MASK 0xff000000
#define DPM_TABLE_171__GraphicsLevel_6_UpHyst__SHIFT 0x18
#define DPM_TABLE_172__GraphicsLevel_6_padding_2_MASK 0xff
#define DPM_TABLE_172__GraphicsLevel_6_padding_2__SHIFT 0x0
#define DPM_TABLE_172__GraphicsLevel_6_padding_1_MASK 0xff00
#define DPM_TABLE_172__GraphicsLevel_6_padding_1__SHIFT 0x8
#define DPM_TABLE_172__GraphicsLevel_6_padding_0_MASK 0xff0000
#define DPM_TABLE_172__GraphicsLevel_6_padding_0__SHIFT 0x10
#define DPM_TABLE_172__GraphicsLevel_6_DeepSleepDivId_MASK 0xff000000
#define DPM_TABLE_172__GraphicsLevel_6_DeepSleepDivId__SHIFT 0x18
#define DPM_TABLE_173__GraphicsLevel_7_Flags_MASK 0xffffffff
#define DPM_TABLE_173__GraphicsLevel_7_Flags__SHIFT 0x0
#define DPM_TABLE_174__GraphicsLevel_7_MinVddc_MASK 0xffffffff
#define DPM_TABLE_174__GraphicsLevel_7_MinVddc__SHIFT 0x0
#define DPM_TABLE_175__GraphicsLevel_7_MinVddcPhases_MASK 0xffffffff
#define DPM_TABLE_175__GraphicsLevel_7_MinVddcPhases__SHIFT 0x0
#define DPM_TABLE_176__GraphicsLevel_7_SclkFrequency_MASK 0xffffffff
#define DPM_TABLE_176__GraphicsLevel_7_SclkFrequency__SHIFT 0x0
#define DPM_TABLE_177__GraphicsLevel_7_ActivityLevel_MASK 0xffff
#define DPM_TABLE_177__GraphicsLevel_7_ActivityLevel__SHIFT 0x0
#define DPM_TABLE_177__GraphicsLevel_7_padding1_1_MASK 0xff0000
#define DPM_TABLE_177__GraphicsLevel_7_padding1_1__SHIFT 0x10
#define DPM_TABLE_177__GraphicsLevel_7_padding1_0_MASK 0xff000000
#define DPM_TABLE_177__GraphicsLevel_7_padding1_0__SHIFT 0x18
#define DPM_TABLE_178__GraphicsLevel_7_CgSpllFuncCntl3_MASK 0xffffffff
#define DPM_TABLE_178__GraphicsLevel_7_CgSpllFuncCntl3__SHIFT 0x0
#define DPM_TABLE_179__GraphicsLevel_7_CgSpllFuncCntl4_MASK 0xffffffff
#define DPM_TABLE_179__GraphicsLevel_7_CgSpllFuncCntl4__SHIFT 0x0
#define DPM_TABLE_180__GraphicsLevel_7_SpllSpreadSpectrum_MASK 0xffffffff
#define DPM_TABLE_180__GraphicsLevel_7_SpllSpreadSpectrum__SHIFT 0x0
#define DPM_TABLE_181__GraphicsLevel_7_SpllSpreadSpectrum2_MASK 0xffffffff
#define DPM_TABLE_181__GraphicsLevel_7_SpllSpreadSpectrum2__SHIFT 0x0
#define DPM_TABLE_182__GraphicsLevel_7_CcPwrDynRm_MASK 0xffffffff
#define DPM_TABLE_182__GraphicsLevel_7_CcPwrDynRm__SHIFT 0x0
#define DPM_TABLE_183__GraphicsLevel_7_CcPwrDynRm1_MASK 0xffffffff
#define DPM_TABLE_183__GraphicsLevel_7_CcPwrDynRm1__SHIFT 0x0
#define DPM_TABLE_184__GraphicsLevel_7_EnabledForThrottle_MASK 0xff
#define DPM_TABLE_184__GraphicsLevel_7_EnabledForThrottle__SHIFT 0x0
#define DPM_TABLE_184__GraphicsLevel_7_EnabledForActivity_MASK 0xff00
#define DPM_TABLE_184__GraphicsLevel_7_EnabledForActivity__SHIFT 0x8
#define DPM_TABLE_184__GraphicsLevel_7_DisplayWatermark_MASK 0xff0000
#define DPM_TABLE_184__GraphicsLevel_7_DisplayWatermark__SHIFT 0x10
#define DPM_TABLE_184__GraphicsLevel_7_SclkDid_MASK 0xff000000
#define DPM_TABLE_184__GraphicsLevel_7_SclkDid__SHIFT 0x18
#define DPM_TABLE_185__GraphicsLevel_7_PowerThrottle_MASK 0xff
#define DPM_TABLE_185__GraphicsLevel_7_PowerThrottle__SHIFT 0x0
#define DPM_TABLE_185__GraphicsLevel_7_VoltageDownHyst_MASK 0xff00
#define DPM_TABLE_185__GraphicsLevel_7_VoltageDownHyst__SHIFT 0x8
#define DPM_TABLE_185__GraphicsLevel_7_DownHyst_MASK 0xff0000
#define DPM_TABLE_185__GraphicsLevel_7_DownHyst__SHIFT 0x10
#define DPM_TABLE_185__GraphicsLevel_7_UpHyst_MASK 0xff000000
#define DPM_TABLE_185__GraphicsLevel_7_UpHyst__SHIFT 0x18
#define DPM_TABLE_186__GraphicsLevel_7_padding_2_MASK 0xff
#define DPM_TABLE_186__GraphicsLevel_7_padding_2__SHIFT 0x0
#define DPM_TABLE_186__GraphicsLevel_7_padding_1_MASK 0xff00
#define DPM_TABLE_186__GraphicsLevel_7_padding_1__SHIFT 0x8
#define DPM_TABLE_186__GraphicsLevel_7_padding_0_MASK 0xff0000
#define DPM_TABLE_186__GraphicsLevel_7_padding_0__SHIFT 0x10
#define DPM_TABLE_186__GraphicsLevel_7_DeepSleepDivId_MASK 0xff000000
#define DPM_TABLE_186__GraphicsLevel_7_DeepSleepDivId__SHIFT 0x18
#define DPM_TABLE_187__MemoryACPILevel_MinVddc_MASK 0xffffffff
#define DPM_TABLE_187__MemoryACPILevel_MinVddc__SHIFT 0x0
#define DPM_TABLE_188__MemoryACPILevel_MinVddcPhases_MASK 0xffffffff
#define DPM_TABLE_188__MemoryACPILevel_MinVddcPhases__SHIFT 0x0
#define DPM_TABLE_189__MemoryACPILevel_MinVddci_MASK 0xffffffff
#define DPM_TABLE_189__MemoryACPILevel_MinVddci__SHIFT 0x0
#define DPM_TABLE_190__MemoryACPILevel_MinMvdd_MASK 0xffffffff
#define DPM_TABLE_190__MemoryACPILevel_MinMvdd__SHIFT 0x0
#define DPM_TABLE_191__MemoryACPILevel_MclkFrequency_MASK 0xffffffff
#define DPM_TABLE_191__MemoryACPILevel_MclkFrequency__SHIFT 0x0
#define DPM_TABLE_192__MemoryACPILevel_StutterEnable_MASK 0xff
#define DPM_TABLE_192__MemoryACPILevel_StutterEnable__SHIFT 0x0
#define DPM_TABLE_192__MemoryACPILevel_RttEnable_MASK 0xff00
#define DPM_TABLE_192__MemoryACPILevel_RttEnable__SHIFT 0x8
#define DPM_TABLE_192__MemoryACPILevel_EdcWriteEnable_MASK 0xff0000
#define DPM_TABLE_192__MemoryACPILevel_EdcWriteEnable__SHIFT 0x10
#define DPM_TABLE_192__MemoryACPILevel_EdcReadEnable_MASK 0xff000000
#define DPM_TABLE_192__MemoryACPILevel_EdcReadEnable__SHIFT 0x18
#define DPM_TABLE_193__MemoryACPILevel_EnabledForActivity_MASK 0xff
#define DPM_TABLE_193__MemoryACPILevel_EnabledForActivity__SHIFT 0x0
#define DPM_TABLE_193__MemoryACPILevel_EnabledForThrottle_MASK 0xff00
#define DPM_TABLE_193__MemoryACPILevel_EnabledForThrottle__SHIFT 0x8
#define DPM_TABLE_193__MemoryACPILevel_StrobeRatio_MASK 0xff0000
#define DPM_TABLE_193__MemoryACPILevel_StrobeRatio__SHIFT 0x10
#define DPM_TABLE_193__MemoryACPILevel_StrobeEnable_MASK 0xff000000
#define DPM_TABLE_193__MemoryACPILevel_StrobeEnable__SHIFT 0x18
#define DPM_TABLE_194__MemoryACPILevel_padding_MASK 0xff
#define DPM_TABLE_194__MemoryACPILevel_padding__SHIFT 0x0
#define DPM_TABLE_194__MemoryACPILevel_VoltageDownHyst_MASK 0xff00
#define DPM_TABLE_194__MemoryACPILevel_VoltageDownHyst__SHIFT 0x8
#define DPM_TABLE_194__MemoryACPILevel_DownHyst_MASK 0xff0000
#define DPM_TABLE_194__MemoryACPILevel_DownHyst__SHIFT 0x10
#define DPM_TABLE_194__MemoryACPILevel_UpHyst_MASK 0xff000000
#define DPM_TABLE_194__MemoryACPILevel_UpHyst__SHIFT 0x18
#define DPM_TABLE_195__MemoryACPILevel_padding1_1_MASK 0xff
#define DPM_TABLE_195__MemoryACPILevel_padding1_1__SHIFT 0x0
#define DPM_TABLE_195__MemoryACPILevel_padding1_0_MASK 0xff00
#define DPM_TABLE_195__MemoryACPILevel_padding1_0__SHIFT 0x8
#define DPM_TABLE_195__MemoryACPILevel_ActivityLevel_MASK 0xffff0000
#define DPM_TABLE_195__MemoryACPILevel_ActivityLevel__SHIFT 0x10
#define DPM_TABLE_196__MemoryACPILevel_MpllFuncCntl_MASK 0xffffffff
#define DPM_TABLE_196__MemoryACPILevel_MpllFuncCntl__SHIFT 0x0
#define DPM_TABLE_197__MemoryACPILevel_MpllFuncCntl_1_MASK 0xffffffff
#define DPM_TABLE_197__MemoryACPILevel_MpllFuncCntl_1__SHIFT 0x0
#define DPM_TABLE_198__MemoryACPILevel_MpllFuncCntl_2_MASK 0xffffffff
#define DPM_TABLE_198__MemoryACPILevel_MpllFuncCntl_2__SHIFT 0x0
#define DPM_TABLE_199__MemoryACPILevel_MpllAdFuncCntl_MASK 0xffffffff
#define DPM_TABLE_199__MemoryACPILevel_MpllAdFuncCntl__SHIFT 0x0
#define DPM_TABLE_200__MemoryACPILevel_MpllDqFuncCntl_MASK 0xffffffff
#define DPM_TABLE_200__MemoryACPILevel_MpllDqFuncCntl__SHIFT 0x0
#define DPM_TABLE_201__MemoryACPILevel_MclkPwrmgtCntl_MASK 0xffffffff
#define DPM_TABLE_201__MemoryACPILevel_MclkPwrmgtCntl__SHIFT 0x0
#define DPM_TABLE_202__MemoryACPILevel_DllCntl_MASK 0xffffffff
#define DPM_TABLE_202__MemoryACPILevel_DllCntl__SHIFT 0x0
#define DPM_TABLE_203__MemoryACPILevel_MpllSs1_MASK 0xffffffff
#define DPM_TABLE_203__MemoryACPILevel_MpllSs1__SHIFT 0x0
#define DPM_TABLE_204__MemoryACPILevel_MpllSs2_MASK 0xffffffff
#define DPM_TABLE_204__MemoryACPILevel_MpllSs2__SHIFT 0x0
#define DPM_TABLE_205__MemoryLevel_0_MinVddc_MASK 0xffffffff
#define DPM_TABLE_205__MemoryLevel_0_MinVddc__SHIFT 0x0
#define DPM_TABLE_206__MemoryLevel_0_MinVddcPhases_MASK 0xffffffff
#define DPM_TABLE_206__MemoryLevel_0_MinVddcPhases__SHIFT 0x0
#define DPM_TABLE_207__MemoryLevel_0_MinVddci_MASK 0xffffffff
#define DPM_TABLE_207__MemoryLevel_0_MinVddci__SHIFT 0x0
#define DPM_TABLE_208__MemoryLevel_0_MinMvdd_MASK 0xffffffff
#define DPM_TABLE_208__MemoryLevel_0_MinMvdd__SHIFT 0x0
#define DPM_TABLE_209__MemoryLevel_0_MclkFrequency_MASK 0xffffffff
#define DPM_TABLE_209__MemoryLevel_0_MclkFrequency__SHIFT 0x0
#define DPM_TABLE_210__MemoryLevel_0_StutterEnable_MASK 0xff
#define DPM_TABLE_210__MemoryLevel_0_StutterEnable__SHIFT 0x0
#define DPM_TABLE_210__MemoryLevel_0_RttEnable_MASK 0xff00
#define DPM_TABLE_210__MemoryLevel_0_RttEnable__SHIFT 0x8
#define DPM_TABLE_210__MemoryLevel_0_EdcWriteEnable_MASK 0xff0000
#define DPM_TABLE_210__MemoryLevel_0_EdcWriteEnable__SHIFT 0x10
#define DPM_TABLE_210__MemoryLevel_0_EdcReadEnable_MASK 0xff000000
#define DPM_TABLE_210__MemoryLevel_0_EdcReadEnable__SHIFT 0x18
#define DPM_TABLE_211__MemoryLevel_0_EnabledForActivity_MASK 0xff
#define DPM_TABLE_211__MemoryLevel_0_EnabledForActivity__SHIFT 0x0
#define DPM_TABLE_211__MemoryLevel_0_EnabledForThrottle_MASK 0xff00
#define DPM_TABLE_211__MemoryLevel_0_EnabledForThrottle__SHIFT 0x8
#define DPM_TABLE_211__MemoryLevel_0_StrobeRatio_MASK 0xff0000
#define DPM_TABLE_211__MemoryLevel_0_StrobeRatio__SHIFT 0x10
#define DPM_TABLE_211__MemoryLevel_0_StrobeEnable_MASK 0xff000000
#define DPM_TABLE_211__MemoryLevel_0_StrobeEnable__SHIFT 0x18
#define DPM_TABLE_212__MemoryLevel_0_padding_MASK 0xff
#define DPM_TABLE_212__MemoryLevel_0_padding__SHIFT 0x0
#define DPM_TABLE_212__MemoryLevel_0_VoltageDownHyst_MASK 0xff00
#define DPM_TABLE_212__MemoryLevel_0_VoltageDownHyst__SHIFT 0x8
#define DPM_TABLE_212__MemoryLevel_0_DownHyst_MASK 0xff0000
#define DPM_TABLE_212__MemoryLevel_0_DownHyst__SHIFT 0x10
#define DPM_TABLE_212__MemoryLevel_0_UpHyst_MASK 0xff000000
#define DPM_TABLE_212__MemoryLevel_0_UpHyst__SHIFT 0x18
#define DPM_TABLE_213__MemoryLevel_0_padding1_1_MASK 0xff
#define DPM_TABLE_213__MemoryLevel_0_padding1_1__SHIFT 0x0
#define DPM_TABLE_213__MemoryLevel_0_padding1_0_MASK 0xff00
#define DPM_TABLE_213__MemoryLevel_0_padding1_0__SHIFT 0x8
#define DPM_TABLE_213__MemoryLevel_0_ActivityLevel_MASK 0xffff0000
#define DPM_TABLE_213__MemoryLevel_0_ActivityLevel__SHIFT 0x10
#define DPM_TABLE_214__MemoryLevel_0_MpllFuncCntl_MASK 0xffffffff
#define DPM_TABLE_214__MemoryLevel_0_MpllFuncCntl__SHIFT 0x0
#define DPM_TABLE_215__MemoryLevel_0_MpllFuncCntl_1_MASK 0xffffffff
#define DPM_TABLE_215__MemoryLevel_0_MpllFuncCntl_1__SHIFT 0x0
#define DPM_TABLE_216__MemoryLevel_0_MpllFuncCntl_2_MASK 0xffffffff
#define DPM_TABLE_216__MemoryLevel_0_MpllFuncCntl_2__SHIFT 0x0
#define DPM_TABLE_217__MemoryLevel_0_MpllAdFuncCntl_MASK 0xffffffff
#define DPM_TABLE_217__MemoryLevel_0_MpllAdFuncCntl__SHIFT 0x0
#define DPM_TABLE_218__MemoryLevel_0_MpllDqFuncCntl_MASK 0xffffffff
#define DPM_TABLE_218__MemoryLevel_0_MpllDqFuncCntl__SHIFT 0x0
#define DPM_TABLE_219__MemoryLevel_0_MclkPwrmgtCntl_MASK 0xffffffff
#define DPM_TABLE_219__MemoryLevel_0_MclkPwrmgtCntl__SHIFT 0x0
#define DPM_TABLE_220__MemoryLevel_0_DllCntl_MASK 0xffffffff
#define DPM_TABLE_220__MemoryLevel_0_DllCntl__SHIFT 0x0
#define DPM_TABLE_221__MemoryLevel_0_MpllSs1_MASK 0xffffffff
#define DPM_TABLE_221__MemoryLevel_0_MpllSs1__SHIFT 0x0
#define DPM_TABLE_222__MemoryLevel_0_MpllSs2_MASK 0xffffffff
#define DPM_TABLE_222__MemoryLevel_0_MpllSs2__SHIFT 0x0
#define DPM_TABLE_223__MemoryLevel_1_MinVddc_MASK 0xffffffff
#define DPM_TABLE_223__MemoryLevel_1_MinVddc__SHIFT 0x0
#define DPM_TABLE_224__MemoryLevel_1_MinVddcPhases_MASK 0xffffffff
#define DPM_TABLE_224__MemoryLevel_1_MinVddcPhases__SHIFT 0x0
#define DPM_TABLE_225__MemoryLevel_1_MinVddci_MASK 0xffffffff
#define DPM_TABLE_225__MemoryLevel_1_MinVddci__SHIFT 0x0
#define DPM_TABLE_226__MemoryLevel_1_MinMvdd_MASK 0xffffffff
#define DPM_TABLE_226__MemoryLevel_1_MinMvdd__SHIFT 0x0
#define DPM_TABLE_227__MemoryLevel_1_MclkFrequency_MASK 0xffffffff
#define DPM_TABLE_227__MemoryLevel_1_MclkFrequency__SHIFT 0x0
#define DPM_TABLE_228__MemoryLevel_1_StutterEnable_MASK 0xff
#define DPM_TABLE_228__MemoryLevel_1_StutterEnable__SHIFT 0x0
#define DPM_TABLE_228__MemoryLevel_1_RttEnable_MASK 0xff00
#define DPM_TABLE_228__MemoryLevel_1_RttEnable__SHIFT 0x8
#define DPM_TABLE_228__MemoryLevel_1_EdcWriteEnable_MASK 0xff0000
#define DPM_TABLE_228__MemoryLevel_1_EdcWriteEnable__SHIFT 0x10
#define DPM_TABLE_228__MemoryLevel_1_EdcReadEnable_MASK 0xff000000
#define DPM_TABLE_228__MemoryLevel_1_EdcReadEnable__SHIFT 0x18
#define DPM_TABLE_229__MemoryLevel_1_EnabledForActivity_MASK 0xff
#define DPM_TABLE_229__MemoryLevel_1_EnabledForActivity__SHIFT 0x0
#define DPM_TABLE_229__MemoryLevel_1_EnabledForThrottle_MASK 0xff00
#define DPM_TABLE_229__MemoryLevel_1_EnabledForThrottle__SHIFT 0x8
#define DPM_TABLE_229__MemoryLevel_1_StrobeRatio_MASK 0xff0000
#define DPM_TABLE_229__MemoryLevel_1_StrobeRatio__SHIFT 0x10
#define DPM_TABLE_229__MemoryLevel_1_StrobeEnable_MASK 0xff000000
#define DPM_TABLE_229__MemoryLevel_1_StrobeEnable__SHIFT 0x18
#define DPM_TABLE_230__MemoryLevel_1_padding_MASK 0xff
#define DPM_TABLE_230__MemoryLevel_1_padding__SHIFT 0x0
#define DPM_TABLE_230__MemoryLevel_1_VoltageDownHyst_MASK 0xff00
#define DPM_TABLE_230__MemoryLevel_1_VoltageDownHyst__SHIFT 0x8
#define DPM_TABLE_230__MemoryLevel_1_DownHyst_MASK 0xff0000
#define DPM_TABLE_230__MemoryLevel_1_DownHyst__SHIFT 0x10
#define DPM_TABLE_230__MemoryLevel_1_UpHyst_MASK 0xff000000
#define DPM_TABLE_230__MemoryLevel_1_UpHyst__SHIFT 0x18
#define DPM_TABLE_231__MemoryLevel_1_padding1_1_MASK 0xff
#define DPM_TABLE_231__MemoryLevel_1_padding1_1__SHIFT 0x0
#define DPM_TABLE_231__MemoryLevel_1_padding1_0_MASK 0xff00
#define DPM_TABLE_231__MemoryLevel_1_padding1_0__SHIFT 0x8
#define DPM_TABLE_231__MemoryLevel_1_ActivityLevel_MASK 0xffff0000
#define DPM_TABLE_231__MemoryLevel_1_ActivityLevel__SHIFT 0x10
#define DPM_TABLE_232__MemoryLevel_1_MpllFuncCntl_MASK 0xffffffff
#define DPM_TABLE_232__MemoryLevel_1_MpllFuncCntl__SHIFT 0x0
#define DPM_TABLE_233__MemoryLevel_1_MpllFuncCntl_1_MASK 0xffffffff
#define DPM_TABLE_233__MemoryLevel_1_MpllFuncCntl_1__SHIFT 0x0
#define DPM_TABLE_234__MemoryLevel_1_MpllFuncCntl_2_MASK 0xffffffff
#define DPM_TABLE_234__MemoryLevel_1_MpllFuncCntl_2__SHIFT 0x0
#define DPM_TABLE_235__MemoryLevel_1_MpllAdFuncCntl_MASK 0xffffffff
#define DPM_TABLE_235__MemoryLevel_1_MpllAdFuncCntl__SHIFT 0x0
#define DPM_TABLE_236__MemoryLevel_1_MpllDqFuncCntl_MASK 0xffffffff
#define DPM_TABLE_236__MemoryLevel_1_MpllDqFuncCntl__SHIFT 0x0
#define DPM_TABLE_237__MemoryLevel_1_MclkPwrmgtCntl_MASK 0xffffffff
#define DPM_TABLE_237__MemoryLevel_1_MclkPwrmgtCntl__SHIFT 0x0
#define DPM_TABLE_238__MemoryLevel_1_DllCntl_MASK 0xffffffff
#define DPM_TABLE_238__MemoryLevel_1_DllCntl__SHIFT 0x0
#define DPM_TABLE_239__MemoryLevel_1_MpllSs1_MASK 0xffffffff
#define DPM_TABLE_239__MemoryLevel_1_MpllSs1__SHIFT 0x0
#define DPM_TABLE_240__MemoryLevel_1_MpllSs2_MASK 0xffffffff
#define DPM_TABLE_240__MemoryLevel_1_MpllSs2__SHIFT 0x0
#define DPM_TABLE_241__MemoryLevel_2_MinVddc_MASK 0xffffffff
#define DPM_TABLE_241__MemoryLevel_2_MinVddc__SHIFT 0x0
#define DPM_TABLE_242__MemoryLevel_2_MinVddcPhases_MASK 0xffffffff
#define DPM_TABLE_242__MemoryLevel_2_MinVddcPhases__SHIFT 0x0
#define DPM_TABLE_243__MemoryLevel_2_MinVddci_MASK 0xffffffff
#define DPM_TABLE_243__MemoryLevel_2_MinVddci__SHIFT 0x0
#define DPM_TABLE_244__MemoryLevel_2_MinMvdd_MASK 0xffffffff
#define DPM_TABLE_244__MemoryLevel_2_MinMvdd__SHIFT 0x0
#define DPM_TABLE_245__MemoryLevel_2_MclkFrequency_MASK 0xffffffff
#define DPM_TABLE_245__MemoryLevel_2_MclkFrequency__SHIFT 0x0
#define DPM_TABLE_246__MemoryLevel_2_StutterEnable_MASK 0xff
#define DPM_TABLE_246__MemoryLevel_2_StutterEnable__SHIFT 0x0
#define DPM_TABLE_246__MemoryLevel_2_RttEnable_MASK 0xff00
#define DPM_TABLE_246__MemoryLevel_2_RttEnable__SHIFT 0x8
#define DPM_TABLE_246__MemoryLevel_2_EdcWriteEnable_MASK 0xff0000
#define DPM_TABLE_246__MemoryLevel_2_EdcWriteEnable__SHIFT 0x10
#define DPM_TABLE_246__MemoryLevel_2_EdcReadEnable_MASK 0xff000000
#define DPM_TABLE_246__MemoryLevel_2_EdcReadEnable__SHIFT 0x18
#define DPM_TABLE_247__MemoryLevel_2_EnabledForActivity_MASK 0xff
#define DPM_TABLE_247__MemoryLevel_2_EnabledForActivity__SHIFT 0x0
#define DPM_TABLE_247__MemoryLevel_2_EnabledForThrottle_MASK 0xff00
#define DPM_TABLE_247__MemoryLevel_2_EnabledForThrottle__SHIFT 0x8
#define DPM_TABLE_247__MemoryLevel_2_StrobeRatio_MASK 0xff0000
#define DPM_TABLE_247__MemoryLevel_2_StrobeRatio__SHIFT 0x10
#define DPM_TABLE_247__MemoryLevel_2_StrobeEnable_MASK 0xff000000
#define DPM_TABLE_247__MemoryLevel_2_StrobeEnable__SHIFT 0x18
#define DPM_TABLE_248__MemoryLevel_2_padding_MASK 0xff
#define DPM_TABLE_248__MemoryLevel_2_padding__SHIFT 0x0
#define DPM_TABLE_248__MemoryLevel_2_VoltageDownHyst_MASK 0xff00
#define DPM_TABLE_248__MemoryLevel_2_VoltageDownHyst__SHIFT 0x8
#define DPM_TABLE_248__MemoryLevel_2_DownHyst_MASK 0xff0000
#define DPM_TABLE_248__MemoryLevel_2_DownHyst__SHIFT 0x10
#define DPM_TABLE_248__MemoryLevel_2_UpHyst_MASK 0xff000000
#define DPM_TABLE_248__MemoryLevel_2_UpHyst__SHIFT 0x18
#define DPM_TABLE_249__MemoryLevel_2_padding1_1_MASK 0xff
#define DPM_TABLE_249__MemoryLevel_2_padding1_1__SHIFT 0x0
#define DPM_TABLE_249__MemoryLevel_2_padding1_0_MASK 0xff00
#define DPM_TABLE_249__MemoryLevel_2_padding1_0__SHIFT 0x8
#define DPM_TABLE_249__MemoryLevel_2_ActivityLevel_MASK 0xffff0000
#define DPM_TABLE_249__MemoryLevel_2_ActivityLevel__SHIFT 0x10
#define DPM_TABLE_250__MemoryLevel_2_MpllFuncCntl_MASK 0xffffffff
#define DPM_TABLE_250__MemoryLevel_2_MpllFuncCntl__SHIFT 0x0
#define DPM_TABLE_251__MemoryLevel_2_MpllFuncCntl_1_MASK 0xffffffff
#define DPM_TABLE_251__MemoryLevel_2_MpllFuncCntl_1__SHIFT 0x0
#define DPM_TABLE_252__MemoryLevel_2_MpllFuncCntl_2_MASK 0xffffffff
#define DPM_TABLE_252__MemoryLevel_2_MpllFuncCntl_2__SHIFT 0x0
#define DPM_TABLE_253__MemoryLevel_2_MpllAdFuncCntl_MASK 0xffffffff
#define DPM_TABLE_253__MemoryLevel_2_MpllAdFuncCntl__SHIFT 0x0
#define DPM_TABLE_254__MemoryLevel_2_MpllDqFuncCntl_MASK 0xffffffff
#define DPM_TABLE_254__MemoryLevel_2_MpllDqFuncCntl__SHIFT 0x0
#define DPM_TABLE_255__MemoryLevel_2_MclkPwrmgtCntl_MASK 0xffffffff
#define DPM_TABLE_255__MemoryLevel_2_MclkPwrmgtCntl__SHIFT 0x0
#define DPM_TABLE_256__MemoryLevel_2_DllCntl_MASK 0xffffffff
#define DPM_TABLE_256__MemoryLevel_2_DllCntl__SHIFT 0x0
#define DPM_TABLE_257__MemoryLevel_2_MpllSs1_MASK 0xffffffff
#define DPM_TABLE_257__MemoryLevel_2_MpllSs1__SHIFT 0x0
#define DPM_TABLE_258__MemoryLevel_2_MpllSs2_MASK 0xffffffff
#define DPM_TABLE_258__MemoryLevel_2_MpllSs2__SHIFT 0x0
#define DPM_TABLE_259__MemoryLevel_3_MinVddc_MASK 0xffffffff
#define DPM_TABLE_259__MemoryLevel_3_MinVddc__SHIFT 0x0
#define DPM_TABLE_260__MemoryLevel_3_MinVddcPhases_MASK 0xffffffff
#define DPM_TABLE_260__MemoryLevel_3_MinVddcPhases__SHIFT 0x0
#define DPM_TABLE_261__MemoryLevel_3_MinVddci_MASK 0xffffffff
#define DPM_TABLE_261__MemoryLevel_3_MinVddci__SHIFT 0x0
#define DPM_TABLE_262__MemoryLevel_3_MinMvdd_MASK 0xffffffff
#define DPM_TABLE_262__MemoryLevel_3_MinMvdd__SHIFT 0x0
#define DPM_TABLE_263__MemoryLevel_3_MclkFrequency_MASK 0xffffffff
#define DPM_TABLE_263__MemoryLevel_3_MclkFrequency__SHIFT 0x0
#define DPM_TABLE_264__MemoryLevel_3_StutterEnable_MASK 0xff
#define DPM_TABLE_264__MemoryLevel_3_StutterEnable__SHIFT 0x0
#define DPM_TABLE_264__MemoryLevel_3_RttEnable_MASK 0xff00
#define DPM_TABLE_264__MemoryLevel_3_RttEnable__SHIFT 0x8
#define DPM_TABLE_264__MemoryLevel_3_EdcWriteEnable_MASK 0xff0000
#define DPM_TABLE_264__MemoryLevel_3_EdcWriteEnable__SHIFT 0x10
#define DPM_TABLE_264__MemoryLevel_3_EdcReadEnable_MASK 0xff000000
#define DPM_TABLE_264__MemoryLevel_3_EdcReadEnable__SHIFT 0x18
#define DPM_TABLE_265__MemoryLevel_3_EnabledForActivity_MASK 0xff
#define DPM_TABLE_265__MemoryLevel_3_EnabledForActivity__SHIFT 0x0
#define DPM_TABLE_265__MemoryLevel_3_EnabledForThrottle_MASK 0xff00
#define DPM_TABLE_265__MemoryLevel_3_EnabledForThrottle__SHIFT 0x8
#define DPM_TABLE_265__MemoryLevel_3_StrobeRatio_MASK 0xff0000
#define DPM_TABLE_265__MemoryLevel_3_StrobeRatio__SHIFT 0x10
#define DPM_TABLE_265__MemoryLevel_3_StrobeEnable_MASK 0xff000000
#define DPM_TABLE_265__MemoryLevel_3_StrobeEnable__SHIFT 0x18
#define DPM_TABLE_266__MemoryLevel_3_padding_MASK 0xff
#define DPM_TABLE_266__MemoryLevel_3_padding__SHIFT 0x0
#define DPM_TABLE_266__MemoryLevel_3_VoltageDownHyst_MASK 0xff00
#define DPM_TABLE_266__MemoryLevel_3_VoltageDownHyst__SHIFT 0x8
#define DPM_TABLE_266__MemoryLevel_3_DownHyst_MASK 0xff0000
#define DPM_TABLE_266__MemoryLevel_3_DownHyst__SHIFT 0x10
#define DPM_TABLE_266__MemoryLevel_3_UpHyst_MASK 0xff000000
#define DPM_TABLE_266__MemoryLevel_3_UpHyst__SHIFT 0x18
#define DPM_TABLE_267__MemoryLevel_3_padding1_1_MASK 0xff
#define DPM_TABLE_267__MemoryLevel_3_padding1_1__SHIFT 0x0
#define DPM_TABLE_267__MemoryLevel_3_padding1_0_MASK 0xff00
#define DPM_TABLE_267__MemoryLevel_3_padding1_0__SHIFT 0x8
#define DPM_TABLE_267__MemoryLevel_3_ActivityLevel_MASK 0xffff0000
#define DPM_TABLE_267__MemoryLevel_3_ActivityLevel__SHIFT 0x10
#define DPM_TABLE_268__MemoryLevel_3_MpllFuncCntl_MASK 0xffffffff
#define DPM_TABLE_268__MemoryLevel_3_MpllFuncCntl__SHIFT 0x0
#define DPM_TABLE_269__MemoryLevel_3_MpllFuncCntl_1_MASK 0xffffffff
#define DPM_TABLE_269__MemoryLevel_3_MpllFuncCntl_1__SHIFT 0x0
#define DPM_TABLE_270__MemoryLevel_3_MpllFuncCntl_2_MASK 0xffffffff
#define DPM_TABLE_270__MemoryLevel_3_MpllFuncCntl_2__SHIFT 0x0
#define DPM_TABLE_271__MemoryLevel_3_MpllAdFuncCntl_MASK 0xffffffff
#define DPM_TABLE_271__MemoryLevel_3_MpllAdFuncCntl__SHIFT 0x0
#define DPM_TABLE_272__MemoryLevel_3_MpllDqFuncCntl_MASK 0xffffffff
#define DPM_TABLE_272__MemoryLevel_3_MpllDqFuncCntl__SHIFT 0x0
#define DPM_TABLE_273__MemoryLevel_3_MclkPwrmgtCntl_MASK 0xffffffff
#define DPM_TABLE_273__MemoryLevel_3_MclkPwrmgtCntl__SHIFT 0x0
#define DPM_TABLE_274__MemoryLevel_3_DllCntl_MASK 0xffffffff
#define DPM_TABLE_274__MemoryLevel_3_DllCntl__SHIFT 0x0
#define DPM_TABLE_275__MemoryLevel_3_MpllSs1_MASK 0xffffffff
#define DPM_TABLE_275__MemoryLevel_3_MpllSs1__SHIFT 0x0
#define DPM_TABLE_276__MemoryLevel_3_MpllSs2_MASK 0xffffffff
#define DPM_TABLE_276__MemoryLevel_3_MpllSs2__SHIFT 0x0
#define DPM_TABLE_277__MemoryLevel_4_MinVddc_MASK 0xffffffff
#define DPM_TABLE_277__MemoryLevel_4_MinVddc__SHIFT 0x0
#define DPM_TABLE_278__MemoryLevel_4_MinVddcPhases_MASK 0xffffffff
#define DPM_TABLE_278__MemoryLevel_4_MinVddcPhases__SHIFT 0x0
#define DPM_TABLE_279__MemoryLevel_4_MinVddci_MASK 0xffffffff
#define DPM_TABLE_279__MemoryLevel_4_MinVddci__SHIFT 0x0
#define DPM_TABLE_280__MemoryLevel_4_MinMvdd_MASK 0xffffffff
#define DPM_TABLE_280__MemoryLevel_4_MinMvdd__SHIFT 0x0
#define DPM_TABLE_281__MemoryLevel_4_MclkFrequency_MASK 0xffffffff
#define DPM_TABLE_281__MemoryLevel_4_MclkFrequency__SHIFT 0x0
#define DPM_TABLE_282__MemoryLevel_4_StutterEnable_MASK 0xff
#define DPM_TABLE_282__MemoryLevel_4_StutterEnable__SHIFT 0x0
#define DPM_TABLE_282__MemoryLevel_4_RttEnable_MASK 0xff00
#define DPM_TABLE_282__MemoryLevel_4_RttEnable__SHIFT 0x8
#define DPM_TABLE_282__MemoryLevel_4_EdcWriteEnable_MASK 0xff0000
#define DPM_TABLE_282__MemoryLevel_4_EdcWriteEnable__SHIFT 0x10
#define DPM_TABLE_282__MemoryLevel_4_EdcReadEnable_MASK 0xff000000
#define DPM_TABLE_282__MemoryLevel_4_EdcReadEnable__SHIFT 0x18
#define DPM_TABLE_283__MemoryLevel_4_EnabledForActivity_MASK 0xff
#define DPM_TABLE_283__MemoryLevel_4_EnabledForActivity__SHIFT 0x0
#define DPM_TABLE_283__MemoryLevel_4_EnabledForThrottle_MASK 0xff00
#define DPM_TABLE_283__MemoryLevel_4_EnabledForThrottle__SHIFT 0x8
#define DPM_TABLE_283__MemoryLevel_4_StrobeRatio_MASK 0xff0000
#define DPM_TABLE_283__MemoryLevel_4_StrobeRatio__SHIFT 0x10
#define DPM_TABLE_283__MemoryLevel_4_StrobeEnable_MASK 0xff000000
#define DPM_TABLE_283__MemoryLevel_4_StrobeEnable__SHIFT 0x18
#define DPM_TABLE_284__MemoryLevel_4_padding_MASK 0xff
#define DPM_TABLE_284__MemoryLevel_4_padding__SHIFT 0x0
#define DPM_TABLE_284__MemoryLevel_4_VoltageDownHyst_MASK 0xff00
#define DPM_TABLE_284__MemoryLevel_4_VoltageDownHyst__SHIFT 0x8
#define DPM_TABLE_284__MemoryLevel_4_DownHyst_MASK 0xff0000
#define DPM_TABLE_284__MemoryLevel_4_DownHyst__SHIFT 0x10
#define DPM_TABLE_284__MemoryLevel_4_UpHyst_MASK 0xff000000
#define DPM_TABLE_284__MemoryLevel_4_UpHyst__SHIFT 0x18
#define DPM_TABLE_285__MemoryLevel_4_padding1_1_MASK 0xff
#define DPM_TABLE_285__MemoryLevel_4_padding1_1__SHIFT 0x0
#define DPM_TABLE_285__MemoryLevel_4_padding1_0_MASK 0xff00
#define DPM_TABLE_285__MemoryLevel_4_padding1_0__SHIFT 0x8
#define DPM_TABLE_285__MemoryLevel_4_ActivityLevel_MASK 0xffff0000
#define DPM_TABLE_285__MemoryLevel_4_ActivityLevel__SHIFT 0x10
#define DPM_TABLE_286__MemoryLevel_4_MpllFuncCntl_MASK 0xffffffff
#define DPM_TABLE_286__MemoryLevel_4_MpllFuncCntl__SHIFT 0x0
#define DPM_TABLE_287__MemoryLevel_4_MpllFuncCntl_1_MASK 0xffffffff
#define DPM_TABLE_287__MemoryLevel_4_MpllFuncCntl_1__SHIFT 0x0
#define DPM_TABLE_288__MemoryLevel_4_MpllFuncCntl_2_MASK 0xffffffff
#define DPM_TABLE_288__MemoryLevel_4_MpllFuncCntl_2__SHIFT 0x0
#define DPM_TABLE_289__MemoryLevel_4_MpllAdFuncCntl_MASK 0xffffffff
#define DPM_TABLE_289__MemoryLevel_4_MpllAdFuncCntl__SHIFT 0x0
#define DPM_TABLE_290__MemoryLevel_4_MpllDqFuncCntl_MASK 0xffffffff
#define DPM_TABLE_290__MemoryLevel_4_MpllDqFuncCntl__SHIFT 0x0
#define DPM_TABLE_291__MemoryLevel_4_MclkPwrmgtCntl_MASK 0xffffffff
#define DPM_TABLE_291__MemoryLevel_4_MclkPwrmgtCntl__SHIFT 0x0
#define DPM_TABLE_292__MemoryLevel_4_DllCntl_MASK 0xffffffff
#define DPM_TABLE_292__MemoryLevel_4_DllCntl__SHIFT 0x0
#define DPM_TABLE_293__MemoryLevel_4_MpllSs1_MASK 0xffffffff
#define DPM_TABLE_293__MemoryLevel_4_MpllSs1__SHIFT 0x0
#define DPM_TABLE_294__MemoryLevel_4_MpllSs2_MASK 0xffffffff
#define DPM_TABLE_294__MemoryLevel_4_MpllSs2__SHIFT 0x0
#define DPM_TABLE_295__MemoryLevel_5_MinVddc_MASK 0xffffffff
#define DPM_TABLE_295__MemoryLevel_5_MinVddc__SHIFT 0x0
#define DPM_TABLE_296__MemoryLevel_5_MinVddcPhases_MASK 0xffffffff
#define DPM_TABLE_296__MemoryLevel_5_MinVddcPhases__SHIFT 0x0
#define DPM_TABLE_297__MemoryLevel_5_MinVddci_MASK 0xffffffff
#define DPM_TABLE_297__MemoryLevel_5_MinVddci__SHIFT 0x0
#define DPM_TABLE_298__MemoryLevel_5_MinMvdd_MASK 0xffffffff
#define DPM_TABLE_298__MemoryLevel_5_MinMvdd__SHIFT 0x0
#define DPM_TABLE_299__MemoryLevel_5_MclkFrequency_MASK 0xffffffff
#define DPM_TABLE_299__MemoryLevel_5_MclkFrequency__SHIFT 0x0
#define DPM_TABLE_300__MemoryLevel_5_StutterEnable_MASK 0xff
#define DPM_TABLE_300__MemoryLevel_5_StutterEnable__SHIFT 0x0
#define DPM_TABLE_300__MemoryLevel_5_RttEnable_MASK 0xff00
#define DPM_TABLE_300__MemoryLevel_5_RttEnable__SHIFT 0x8
#define DPM_TABLE_300__MemoryLevel_5_EdcWriteEnable_MASK 0xff0000
#define DPM_TABLE_300__MemoryLevel_5_EdcWriteEnable__SHIFT 0x10
#define DPM_TABLE_300__MemoryLevel_5_EdcReadEnable_MASK 0xff000000
#define DPM_TABLE_300__MemoryLevel_5_EdcReadEnable__SHIFT 0x18
#define DPM_TABLE_301__MemoryLevel_5_EnabledForActivity_MASK 0xff
#define DPM_TABLE_301__MemoryLevel_5_EnabledForActivity__SHIFT 0x0
#define DPM_TABLE_301__MemoryLevel_5_EnabledForThrottle_MASK 0xff00
#define DPM_TABLE_301__MemoryLevel_5_EnabledForThrottle__SHIFT 0x8
#define DPM_TABLE_301__MemoryLevel_5_StrobeRatio_MASK 0xff0000
#define DPM_TABLE_301__MemoryLevel_5_StrobeRatio__SHIFT 0x10
#define DPM_TABLE_301__MemoryLevel_5_StrobeEnable_MASK 0xff000000
#define DPM_TABLE_301__MemoryLevel_5_StrobeEnable__SHIFT 0x18
#define DPM_TABLE_302__MemoryLevel_5_padding_MASK 0xff
#define DPM_TABLE_302__MemoryLevel_5_padding__SHIFT 0x0
#define DPM_TABLE_302__MemoryLevel_5_VoltageDownHyst_MASK 0xff00
#define DPM_TABLE_302__MemoryLevel_5_VoltageDownHyst__SHIFT 0x8
#define DPM_TABLE_302__MemoryLevel_5_DownHyst_MASK 0xff0000
#define DPM_TABLE_302__MemoryLevel_5_DownHyst__SHIFT 0x10
#define DPM_TABLE_302__MemoryLevel_5_UpHyst_MASK 0xff000000
#define DPM_TABLE_302__MemoryLevel_5_UpHyst__SHIFT 0x18
#define DPM_TABLE_303__MemoryLevel_5_padding1_1_MASK 0xff
#define DPM_TABLE_303__MemoryLevel_5_padding1_1__SHIFT 0x0
#define DPM_TABLE_303__MemoryLevel_5_padding1_0_MASK 0xff00
#define DPM_TABLE_303__MemoryLevel_5_padding1_0__SHIFT 0x8
#define DPM_TABLE_303__MemoryLevel_5_ActivityLevel_MASK 0xffff0000
#define DPM_TABLE_303__MemoryLevel_5_ActivityLevel__SHIFT 0x10
#define DPM_TABLE_304__MemoryLevel_5_MpllFuncCntl_MASK 0xffffffff
#define DPM_TABLE_304__MemoryLevel_5_MpllFuncCntl__SHIFT 0x0
#define DPM_TABLE_305__MemoryLevel_5_MpllFuncCntl_1_MASK 0xffffffff
#define DPM_TABLE_305__MemoryLevel_5_MpllFuncCntl_1__SHIFT 0x0
#define DPM_TABLE_306__MemoryLevel_5_MpllFuncCntl_2_MASK 0xffffffff
#define DPM_TABLE_306__MemoryLevel_5_MpllFuncCntl_2__SHIFT 0x0
#define DPM_TABLE_307__MemoryLevel_5_MpllAdFuncCntl_MASK 0xffffffff
#define DPM_TABLE_307__MemoryLevel_5_MpllAdFuncCntl__SHIFT 0x0
#define DPM_TABLE_308__MemoryLevel_5_MpllDqFuncCntl_MASK 0xffffffff
#define DPM_TABLE_308__MemoryLevel_5_MpllDqFuncCntl__SHIFT 0x0
#define DPM_TABLE_309__MemoryLevel_5_MclkPwrmgtCntl_MASK 0xffffffff
#define DPM_TABLE_309__MemoryLevel_5_MclkPwrmgtCntl__SHIFT 0x0
#define DPM_TABLE_310__MemoryLevel_5_DllCntl_MASK 0xffffffff
#define DPM_TABLE_310__MemoryLevel_5_DllCntl__SHIFT 0x0
#define DPM_TABLE_311__MemoryLevel_5_MpllSs1_MASK 0xffffffff
#define DPM_TABLE_311__MemoryLevel_5_MpllSs1__SHIFT 0x0
#define DPM_TABLE_312__MemoryLevel_5_MpllSs2_MASK 0xffffffff
#define DPM_TABLE_312__MemoryLevel_5_MpllSs2__SHIFT 0x0
#define DPM_TABLE_313__LinkLevel_0_Padding_MASK 0xff
#define DPM_TABLE_313__LinkLevel_0_Padding__SHIFT 0x0
#define DPM_TABLE_313__LinkLevel_0_EnabledForActivity_MASK 0xff00
#define DPM_TABLE_313__LinkLevel_0_EnabledForActivity__SHIFT 0x8
#define DPM_TABLE_313__LinkLevel_0_PcieLaneCount_MASK 0xff0000
#define DPM_TABLE_313__LinkLevel_0_PcieLaneCount__SHIFT 0x10
#define DPM_TABLE_313__LinkLevel_0_PcieGenSpeed_MASK 0xff000000
#define DPM_TABLE_313__LinkLevel_0_PcieGenSpeed__SHIFT 0x18
#define DPM_TABLE_314__LinkLevel_0_DownThreshold_MASK 0xffffffff
#define DPM_TABLE_314__LinkLevel_0_DownThreshold__SHIFT 0x0
#define DPM_TABLE_315__LinkLevel_0_UpThreshold_MASK 0xffffffff
#define DPM_TABLE_315__LinkLevel_0_UpThreshold__SHIFT 0x0
#define DPM_TABLE_316__LinkLevel_0_Reserved_MASK 0xffffffff
#define DPM_TABLE_316__LinkLevel_0_Reserved__SHIFT 0x0
#define DPM_TABLE_317__LinkLevel_1_Padding_MASK 0xff
#define DPM_TABLE_317__LinkLevel_1_Padding__SHIFT 0x0
#define DPM_TABLE_317__LinkLevel_1_EnabledForActivity_MASK 0xff00
#define DPM_TABLE_317__LinkLevel_1_EnabledForActivity__SHIFT 0x8
#define DPM_TABLE_317__LinkLevel_1_PcieLaneCount_MASK 0xff0000
#define DPM_TABLE_317__LinkLevel_1_PcieLaneCount__SHIFT 0x10
#define DPM_TABLE_317__LinkLevel_1_PcieGenSpeed_MASK 0xff000000
#define DPM_TABLE_317__LinkLevel_1_PcieGenSpeed__SHIFT 0x18
#define DPM_TABLE_318__LinkLevel_1_DownThreshold_MASK 0xffffffff
#define DPM_TABLE_318__LinkLevel_1_DownThreshold__SHIFT 0x0
#define DPM_TABLE_319__LinkLevel_1_UpThreshold_MASK 0xffffffff
#define DPM_TABLE_319__LinkLevel_1_UpThreshold__SHIFT 0x0
#define DPM_TABLE_320__LinkLevel_1_Reserved_MASK 0xffffffff
#define DPM_TABLE_320__LinkLevel_1_Reserved__SHIFT 0x0
#define DPM_TABLE_321__LinkLevel_2_Padding_MASK 0xff
#define DPM_TABLE_321__LinkLevel_2_Padding__SHIFT 0x0
#define DPM_TABLE_321__LinkLevel_2_EnabledForActivity_MASK 0xff00
#define DPM_TABLE_321__LinkLevel_2_EnabledForActivity__SHIFT 0x8
#define DPM_TABLE_321__LinkLevel_2_PcieLaneCount_MASK 0xff0000
#define DPM_TABLE_321__LinkLevel_2_PcieLaneCount__SHIFT 0x10
#define DPM_TABLE_321__LinkLevel_2_PcieGenSpeed_MASK 0xff000000
#define DPM_TABLE_321__LinkLevel_2_PcieGenSpeed__SHIFT 0x18
#define DPM_TABLE_322__LinkLevel_2_DownThreshold_MASK 0xffffffff
#define DPM_TABLE_322__LinkLevel_2_DownThreshold__SHIFT 0x0
#define DPM_TABLE_323__LinkLevel_2_UpThreshold_MASK 0xffffffff
#define DPM_TABLE_323__LinkLevel_2_UpThreshold__SHIFT 0x0
#define DPM_TABLE_324__LinkLevel_2_Reserved_MASK 0xffffffff
#define DPM_TABLE_324__LinkLevel_2_Reserved__SHIFT 0x0
#define DPM_TABLE_325__LinkLevel_3_Padding_MASK 0xff
#define DPM_TABLE_325__LinkLevel_3_Padding__SHIFT 0x0
#define DPM_TABLE_325__LinkLevel_3_EnabledForActivity_MASK 0xff00
#define DPM_TABLE_325__LinkLevel_3_EnabledForActivity__SHIFT 0x8
#define DPM_TABLE_325__LinkLevel_3_PcieLaneCount_MASK 0xff0000
#define DPM_TABLE_325__LinkLevel_3_PcieLaneCount__SHIFT 0x10
#define DPM_TABLE_325__LinkLevel_3_PcieGenSpeed_MASK 0xff000000
#define DPM_TABLE_325__LinkLevel_3_PcieGenSpeed__SHIFT 0x18
#define DPM_TABLE_326__LinkLevel_3_DownThreshold_MASK 0xffffffff
#define DPM_TABLE_326__LinkLevel_3_DownThreshold__SHIFT 0x0
#define DPM_TABLE_327__LinkLevel_3_UpThreshold_MASK 0xffffffff
#define DPM_TABLE_327__LinkLevel_3_UpThreshold__SHIFT 0x0
#define DPM_TABLE_328__LinkLevel_3_Reserved_MASK 0xffffffff
#define DPM_TABLE_328__LinkLevel_3_Reserved__SHIFT 0x0
#define DPM_TABLE_329__LinkLevel_4_Padding_MASK 0xff
#define DPM_TABLE_329__LinkLevel_4_Padding__SHIFT 0x0
#define DPM_TABLE_329__LinkLevel_4_EnabledForActivity_MASK 0xff00
#define DPM_TABLE_329__LinkLevel_4_EnabledForActivity__SHIFT 0x8
#define DPM_TABLE_329__LinkLevel_4_PcieLaneCount_MASK 0xff0000
#define DPM_TABLE_329__LinkLevel_4_PcieLaneCount__SHIFT 0x10
#define DPM_TABLE_329__LinkLevel_4_PcieGenSpeed_MASK 0xff000000
#define DPM_TABLE_329__LinkLevel_4_PcieGenSpeed__SHIFT 0x18
#define DPM_TABLE_330__LinkLevel_4_DownThreshold_MASK 0xffffffff
#define DPM_TABLE_330__LinkLevel_4_DownThreshold__SHIFT 0x0
#define DPM_TABLE_331__LinkLevel_4_UpThreshold_MASK 0xffffffff
#define DPM_TABLE_331__LinkLevel_4_UpThreshold__SHIFT 0x0
#define DPM_TABLE_332__LinkLevel_4_Reserved_MASK 0xffffffff
#define DPM_TABLE_332__LinkLevel_4_Reserved__SHIFT 0x0
#define DPM_TABLE_333__LinkLevel_5_Padding_MASK 0xff
#define DPM_TABLE_333__LinkLevel_5_Padding__SHIFT 0x0
#define DPM_TABLE_333__LinkLevel_5_EnabledForActivity_MASK 0xff00
#define DPM_TABLE_333__LinkLevel_5_EnabledForActivity__SHIFT 0x8
#define DPM_TABLE_333__LinkLevel_5_PcieLaneCount_MASK 0xff0000
#define DPM_TABLE_333__LinkLevel_5_PcieLaneCount__SHIFT 0x10
#define DPM_TABLE_333__LinkLevel_5_PcieGenSpeed_MASK 0xff000000
#define DPM_TABLE_333__LinkLevel_5_PcieGenSpeed__SHIFT 0x18
#define DPM_TABLE_334__LinkLevel_5_DownThreshold_MASK 0xffffffff
#define DPM_TABLE_334__LinkLevel_5_DownThreshold__SHIFT 0x0
#define DPM_TABLE_335__LinkLevel_5_UpThreshold_MASK 0xffffffff
#define DPM_TABLE_335__LinkLevel_5_UpThreshold__SHIFT 0x0
#define DPM_TABLE_336__LinkLevel_5_Reserved_MASK 0xffffffff
#define DPM_TABLE_336__LinkLevel_5_Reserved__SHIFT 0x0
#define DPM_TABLE_337__LinkLevel_6_Padding_MASK 0xff
#define DPM_TABLE_337__LinkLevel_6_Padding__SHIFT 0x0
#define DPM_TABLE_337__LinkLevel_6_EnabledForActivity_MASK 0xff00
#define DPM_TABLE_337__LinkLevel_6_EnabledForActivity__SHIFT 0x8
#define DPM_TABLE_337__LinkLevel_6_PcieLaneCount_MASK 0xff0000
#define DPM_TABLE_337__LinkLevel_6_PcieLaneCount__SHIFT 0x10
#define DPM_TABLE_337__LinkLevel_6_PcieGenSpeed_MASK 0xff000000
#define DPM_TABLE_337__LinkLevel_6_PcieGenSpeed__SHIFT 0x18
#define DPM_TABLE_338__LinkLevel_6_DownThreshold_MASK 0xffffffff
#define DPM_TABLE_338__LinkLevel_6_DownThreshold__SHIFT 0x0
#define DPM_TABLE_339__LinkLevel_6_UpThreshold_MASK 0xffffffff
#define DPM_TABLE_339__LinkLevel_6_UpThreshold__SHIFT 0x0
#define DPM_TABLE_340__LinkLevel_6_Reserved_MASK 0xffffffff
#define DPM_TABLE_340__LinkLevel_6_Reserved__SHIFT 0x0
#define DPM_TABLE_341__LinkLevel_7_Padding_MASK 0xff
#define DPM_TABLE_341__LinkLevel_7_Padding__SHIFT 0x0
#define DPM_TABLE_341__LinkLevel_7_EnabledForActivity_MASK 0xff00
#define DPM_TABLE_341__LinkLevel_7_EnabledForActivity__SHIFT 0x8
#define DPM_TABLE_341__LinkLevel_7_PcieLaneCount_MASK 0xff0000
#define DPM_TABLE_341__LinkLevel_7_PcieLaneCount__SHIFT 0x10
#define DPM_TABLE_341__LinkLevel_7_PcieGenSpeed_MASK 0xff000000
#define DPM_TABLE_341__LinkLevel_7_PcieGenSpeed__SHIFT 0x18
#define DPM_TABLE_342__LinkLevel_7_DownThreshold_MASK 0xffffffff
#define DPM_TABLE_342__LinkLevel_7_DownThreshold__SHIFT 0x0
#define DPM_TABLE_343__LinkLevel_7_UpThreshold_MASK 0xffffffff
#define DPM_TABLE_343__LinkLevel_7_UpThreshold__SHIFT 0x0
#define DPM_TABLE_344__LinkLevel_7_Reserved_MASK 0xffffffff
#define DPM_TABLE_344__LinkLevel_7_Reserved__SHIFT 0x0
#define DPM_TABLE_345__ACPILevel_Flags_MASK 0xffffffff
#define DPM_TABLE_345__ACPILevel_Flags__SHIFT 0x0
#define DPM_TABLE_346__ACPILevel_MinVddc_MASK 0xffffffff
#define DPM_TABLE_346__ACPILevel_MinVddc__SHIFT 0x0
#define DPM_TABLE_347__ACPILevel_MinVddcPhases_MASK 0xffffffff
#define DPM_TABLE_347__ACPILevel_MinVddcPhases__SHIFT 0x0
#define DPM_TABLE_348__ACPILevel_SclkFrequency_MASK 0xffffffff
#define DPM_TABLE_348__ACPILevel_SclkFrequency__SHIFT 0x0
#define DPM_TABLE_349__ACPILevel_padding_MASK 0xff
#define DPM_TABLE_349__ACPILevel_padding__SHIFT 0x0
#define DPM_TABLE_349__ACPILevel_DeepSleepDivId_MASK 0xff00
#define DPM_TABLE_349__ACPILevel_DeepSleepDivId__SHIFT 0x8
#define DPM_TABLE_349__ACPILevel_DisplayWatermark_MASK 0xff0000
#define DPM_TABLE_349__ACPILevel_DisplayWatermark__SHIFT 0x10
#define DPM_TABLE_349__ACPILevel_SclkDid_MASK 0xff000000
#define DPM_TABLE_349__ACPILevel_SclkDid__SHIFT 0x18
#define DPM_TABLE_350__ACPILevel_CgSpllFuncCntl_MASK 0xffffffff
#define DPM_TABLE_350__ACPILevel_CgSpllFuncCntl__SHIFT 0x0
#define DPM_TABLE_351__ACPILevel_CgSpllFuncCntl2_MASK 0xffffffff
#define DPM_TABLE_351__ACPILevel_CgSpllFuncCntl2__SHIFT 0x0
#define DPM_TABLE_352__ACPILevel_CgSpllFuncCntl3_MASK 0xffffffff
#define DPM_TABLE_352__ACPILevel_CgSpllFuncCntl3__SHIFT 0x0
#define DPM_TABLE_353__ACPILevel_CgSpllFuncCntl4_MASK 0xffffffff
#define DPM_TABLE_353__ACPILevel_CgSpllFuncCntl4__SHIFT 0x0
#define DPM_TABLE_354__ACPILevel_SpllSpreadSpectrum_MASK 0xffffffff
#define DPM_TABLE_354__ACPILevel_SpllSpreadSpectrum__SHIFT 0x0
#define DPM_TABLE_355__ACPILevel_SpllSpreadSpectrum2_MASK 0xffffffff
#define DPM_TABLE_355__ACPILevel_SpllSpreadSpectrum2__SHIFT 0x0
#define DPM_TABLE_356__ACPILevel_CcPwrDynRm_MASK 0xffffffff
#define DPM_TABLE_356__ACPILevel_CcPwrDynRm__SHIFT 0x0
#define DPM_TABLE_357__ACPILevel_CcPwrDynRm1_MASK 0xffffffff
#define DPM_TABLE_357__ACPILevel_CcPwrDynRm1__SHIFT 0x0
#define DPM_TABLE_358__UvdLevel_0_VclkFrequency_MASK 0xffffffff
#define DPM_TABLE_358__UvdLevel_0_VclkFrequency__SHIFT 0x0
#define DPM_TABLE_359__UvdLevel_0_DclkFrequency_MASK 0xffffffff
#define DPM_TABLE_359__UvdLevel_0_DclkFrequency__SHIFT 0x0
#define DPM_TABLE_360__UvdLevel_0_VclkDivider_MASK 0xff
#define DPM_TABLE_360__UvdLevel_0_VclkDivider__SHIFT 0x0
#define DPM_TABLE_360__UvdLevel_0_MinVddcPhases_MASK 0xff00
#define DPM_TABLE_360__UvdLevel_0_MinVddcPhases__SHIFT 0x8
#define DPM_TABLE_360__UvdLevel_0_MinVddc_MASK 0xffff0000
#define DPM_TABLE_360__UvdLevel_0_MinVddc__SHIFT 0x10
#define DPM_TABLE_361__UvdLevel_0_padding_2_MASK 0xff
#define DPM_TABLE_361__UvdLevel_0_padding_2__SHIFT 0x0
#define DPM_TABLE_361__UvdLevel_0_padding_1_MASK 0xff00
#define DPM_TABLE_361__UvdLevel_0_padding_1__SHIFT 0x8
#define DPM_TABLE_361__UvdLevel_0_padding_0_MASK 0xff0000
#define DPM_TABLE_361__UvdLevel_0_padding_0__SHIFT 0x10
#define DPM_TABLE_361__UvdLevel_0_DclkDivider_MASK 0xff000000
#define DPM_TABLE_361__UvdLevel_0_DclkDivider__SHIFT 0x18
#define DPM_TABLE_362__UvdLevel_1_VclkFrequency_MASK 0xffffffff
#define DPM_TABLE_362__UvdLevel_1_VclkFrequency__SHIFT 0x0
#define DPM_TABLE_363__UvdLevel_1_DclkFrequency_MASK 0xffffffff
#define DPM_TABLE_363__UvdLevel_1_DclkFrequency__SHIFT 0x0
#define DPM_TABLE_364__UvdLevel_1_VclkDivider_MASK 0xff
#define DPM_TABLE_364__UvdLevel_1_VclkDivider__SHIFT 0x0
#define DPM_TABLE_364__UvdLevel_1_MinVddcPhases_MASK 0xff00
#define DPM_TABLE_364__UvdLevel_1_MinVddcPhases__SHIFT 0x8
#define DPM_TABLE_364__UvdLevel_1_MinVddc_MASK 0xffff0000
#define DPM_TABLE_364__UvdLevel_1_MinVddc__SHIFT 0x10
#define DPM_TABLE_365__UvdLevel_1_padding_2_MASK 0xff
#define DPM_TABLE_365__UvdLevel_1_padding_2__SHIFT 0x0
#define DPM_TABLE_365__UvdLevel_1_padding_1_MASK 0xff00
#define DPM_TABLE_365__UvdLevel_1_padding_1__SHIFT 0x8
#define DPM_TABLE_365__UvdLevel_1_padding_0_MASK 0xff0000
#define DPM_TABLE_365__UvdLevel_1_padding_0__SHIFT 0x10
#define DPM_TABLE_365__UvdLevel_1_DclkDivider_MASK 0xff000000
#define DPM_TABLE_365__UvdLevel_1_DclkDivider__SHIFT 0x18
#define DPM_TABLE_366__UvdLevel_2_VclkFrequency_MASK 0xffffffff
#define DPM_TABLE_366__UvdLevel_2_VclkFrequency__SHIFT 0x0
#define DPM_TABLE_367__UvdLevel_2_DclkFrequency_MASK 0xffffffff
#define DPM_TABLE_367__UvdLevel_2_DclkFrequency__SHIFT 0x0
#define DPM_TABLE_368__UvdLevel_2_VclkDivider_MASK 0xff
#define DPM_TABLE_368__UvdLevel_2_VclkDivider__SHIFT 0x0
#define DPM_TABLE_368__UvdLevel_2_MinVddcPhases_MASK 0xff00
#define DPM_TABLE_368__UvdLevel_2_MinVddcPhases__SHIFT 0x8
#define DPM_TABLE_368__UvdLevel_2_MinVddc_MASK 0xffff0000
#define DPM_TABLE_368__UvdLevel_2_MinVddc__SHIFT 0x10
#define DPM_TABLE_369__UvdLevel_2_padding_2_MASK 0xff
#define DPM_TABLE_369__UvdLevel_2_padding_2__SHIFT 0x0
#define DPM_TABLE_369__UvdLevel_2_padding_1_MASK 0xff00
#define DPM_TABLE_369__UvdLevel_2_padding_1__SHIFT 0x8
#define DPM_TABLE_369__UvdLevel_2_padding_0_MASK 0xff0000
#define DPM_TABLE_369__UvdLevel_2_padding_0__SHIFT 0x10
#define DPM_TABLE_369__UvdLevel_2_DclkDivider_MASK 0xff000000
#define DPM_TABLE_369__UvdLevel_2_DclkDivider__SHIFT 0x18
#define DPM_TABLE_370__UvdLevel_3_VclkFrequency_MASK 0xffffffff
#define DPM_TABLE_370__UvdLevel_3_VclkFrequency__SHIFT 0x0
#define DPM_TABLE_371__UvdLevel_3_DclkFrequency_MASK 0xffffffff
#define DPM_TABLE_371__UvdLevel_3_DclkFrequency__SHIFT 0x0
#define DPM_TABLE_372__UvdLevel_3_VclkDivider_MASK 0xff
#define DPM_TABLE_372__UvdLevel_3_VclkDivider__SHIFT 0x0
#define DPM_TABLE_372__UvdLevel_3_MinVddcPhases_MASK 0xff00
#define DPM_TABLE_372__UvdLevel_3_MinVddcPhases__SHIFT 0x8
#define DPM_TABLE_372__UvdLevel_3_MinVddc_MASK 0xffff0000
#define DPM_TABLE_372__UvdLevel_3_MinVddc__SHIFT 0x10
#define DPM_TABLE_373__UvdLevel_3_padding_2_MASK 0xff
#define DPM_TABLE_373__UvdLevel_3_padding_2__SHIFT 0x0
#define DPM_TABLE_373__UvdLevel_3_padding_1_MASK 0xff00
#define DPM_TABLE_373__UvdLevel_3_padding_1__SHIFT 0x8
#define DPM_TABLE_373__UvdLevel_3_padding_0_MASK 0xff0000
#define DPM_TABLE_373__UvdLevel_3_padding_0__SHIFT 0x10
#define DPM_TABLE_373__UvdLevel_3_DclkDivider_MASK 0xff000000
#define DPM_TABLE_373__UvdLevel_3_DclkDivider__SHIFT 0x18
#define DPM_TABLE_374__UvdLevel_4_VclkFrequency_MASK 0xffffffff
#define DPM_TABLE_374__UvdLevel_4_VclkFrequency__SHIFT 0x0
#define DPM_TABLE_375__UvdLevel_4_DclkFrequency_MASK 0xffffffff
#define DPM_TABLE_375__UvdLevel_4_DclkFrequency__SHIFT 0x0
#define DPM_TABLE_376__UvdLevel_4_VclkDivider_MASK 0xff
#define DPM_TABLE_376__UvdLevel_4_VclkDivider__SHIFT 0x0
#define DPM_TABLE_376__UvdLevel_4_MinVddcPhases_MASK 0xff00
#define DPM_TABLE_376__UvdLevel_4_MinVddcPhases__SHIFT 0x8
#define DPM_TABLE_376__UvdLevel_4_MinVddc_MASK 0xffff0000
#define DPM_TABLE_376__UvdLevel_4_MinVddc__SHIFT 0x10
#define DPM_TABLE_377__UvdLevel_4_padding_2_MASK 0xff
#define DPM_TABLE_377__UvdLevel_4_padding_2__SHIFT 0x0
#define DPM_TABLE_377__UvdLevel_4_padding_1_MASK 0xff00
#define DPM_TABLE_377__UvdLevel_4_padding_1__SHIFT 0x8
#define DPM_TABLE_377__UvdLevel_4_padding_0_MASK 0xff0000
#define DPM_TABLE_377__UvdLevel_4_padding_0__SHIFT 0x10
#define DPM_TABLE_377__UvdLevel_4_DclkDivider_MASK 0xff000000
#define DPM_TABLE_377__UvdLevel_4_DclkDivider__SHIFT 0x18
#define DPM_TABLE_378__UvdLevel_5_VclkFrequency_MASK 0xffffffff
#define DPM_TABLE_378__UvdLevel_5_VclkFrequency__SHIFT 0x0
#define DPM_TABLE_379__UvdLevel_5_DclkFrequency_MASK 0xffffffff
#define DPM_TABLE_379__UvdLevel_5_DclkFrequency__SHIFT 0x0
#define DPM_TABLE_380__UvdLevel_5_VclkDivider_MASK 0xff
#define DPM_TABLE_380__UvdLevel_5_VclkDivider__SHIFT 0x0
#define DPM_TABLE_380__UvdLevel_5_MinVddcPhases_MASK 0xff00
#define DPM_TABLE_380__UvdLevel_5_MinVddcPhases__SHIFT 0x8
#define DPM_TABLE_380__UvdLevel_5_MinVddc_MASK 0xffff0000
#define DPM_TABLE_380__UvdLevel_5_MinVddc__SHIFT 0x10
#define DPM_TABLE_381__UvdLevel_5_padding_2_MASK 0xff
#define DPM_TABLE_381__UvdLevel_5_padding_2__SHIFT 0x0
#define DPM_TABLE_381__UvdLevel_5_padding_1_MASK 0xff00
#define DPM_TABLE_381__UvdLevel_5_padding_1__SHIFT 0x8
#define DPM_TABLE_381__UvdLevel_5_padding_0_MASK 0xff0000
#define DPM_TABLE_381__UvdLevel_5_padding_0__SHIFT 0x10
#define DPM_TABLE_381__UvdLevel_5_DclkDivider_MASK 0xff000000
#define DPM_TABLE_381__UvdLevel_5_DclkDivider__SHIFT 0x18
#define DPM_TABLE_382__UvdLevel_6_VclkFrequency_MASK 0xffffffff
#define DPM_TABLE_382__UvdLevel_6_VclkFrequency__SHIFT 0x0
#define DPM_TABLE_383__UvdLevel_6_DclkFrequency_MASK 0xffffffff
#define DPM_TABLE_383__UvdLevel_6_DclkFrequency__SHIFT 0x0
#define DPM_TABLE_384__UvdLevel_6_VclkDivider_MASK 0xff
#define DPM_TABLE_384__UvdLevel_6_VclkDivider__SHIFT 0x0
#define DPM_TABLE_384__UvdLevel_6_MinVddcPhases_MASK 0xff00
#define DPM_TABLE_384__UvdLevel_6_MinVddcPhases__SHIFT 0x8
#define DPM_TABLE_384__UvdLevel_6_MinVddc_MASK 0xffff0000
#define DPM_TABLE_384__UvdLevel_6_MinVddc__SHIFT 0x10
#define DPM_TABLE_385__UvdLevel_6_padding_2_MASK 0xff
#define DPM_TABLE_385__UvdLevel_6_padding_2__SHIFT 0x0
#define DPM_TABLE_385__UvdLevel_6_padding_1_MASK 0xff00
#define DPM_TABLE_385__UvdLevel_6_padding_1__SHIFT 0x8
#define DPM_TABLE_385__UvdLevel_6_padding_0_MASK 0xff0000
#define DPM_TABLE_385__UvdLevel_6_padding_0__SHIFT 0x10
#define DPM_TABLE_385__UvdLevel_6_DclkDivider_MASK 0xff000000
#define DPM_TABLE_385__UvdLevel_6_DclkDivider__SHIFT 0x18
#define DPM_TABLE_386__UvdLevel_7_VclkFrequency_MASK 0xffffffff
#define DPM_TABLE_386__UvdLevel_7_VclkFrequency__SHIFT 0x0
#define DPM_TABLE_387__UvdLevel_7_DclkFrequency_MASK 0xffffffff
#define DPM_TABLE_387__UvdLevel_7_DclkFrequency__SHIFT 0x0
#define DPM_TABLE_388__UvdLevel_7_VclkDivider_MASK 0xff
#define DPM_TABLE_388__UvdLevel_7_VclkDivider__SHIFT 0x0
#define DPM_TABLE_388__UvdLevel_7_MinVddcPhases_MASK 0xff00
#define DPM_TABLE_388__UvdLevel_7_MinVddcPhases__SHIFT 0x8
#define DPM_TABLE_388__UvdLevel_7_MinVddc_MASK 0xffff0000
#define DPM_TABLE_388__UvdLevel_7_MinVddc__SHIFT 0x10
#define DPM_TABLE_389__UvdLevel_7_padding_2_MASK 0xff
#define DPM_TABLE_389__UvdLevel_7_padding_2__SHIFT 0x0
#define DPM_TABLE_389__UvdLevel_7_padding_1_MASK 0xff00
#define DPM_TABLE_389__UvdLevel_7_padding_1__SHIFT 0x8
#define DPM_TABLE_389__UvdLevel_7_padding_0_MASK 0xff0000
#define DPM_TABLE_389__UvdLevel_7_padding_0__SHIFT 0x10
#define DPM_TABLE_389__UvdLevel_7_DclkDivider_MASK 0xff000000
#define DPM_TABLE_389__UvdLevel_7_DclkDivider__SHIFT 0x18
#define DPM_TABLE_390__VceLevel_0_Frequency_MASK 0xffffffff
#define DPM_TABLE_390__VceLevel_0_Frequency__SHIFT 0x0
#define DPM_TABLE_391__VceLevel_0_Divider_MASK 0xff
#define DPM_TABLE_391__VceLevel_0_Divider__SHIFT 0x0
#define DPM_TABLE_391__VceLevel_0_MinPhases_MASK 0xff00
#define DPM_TABLE_391__VceLevel_0_MinPhases__SHIFT 0x8
#define DPM_TABLE_391__VceLevel_0_MinVoltage_MASK 0xffff0000
#define DPM_TABLE_391__VceLevel_0_MinVoltage__SHIFT 0x10
#define DPM_TABLE_392__VceLevel_1_Frequency_MASK 0xffffffff
#define DPM_TABLE_392__VceLevel_1_Frequency__SHIFT 0x0
#define DPM_TABLE_393__VceLevel_1_Divider_MASK 0xff
#define DPM_TABLE_393__VceLevel_1_Divider__SHIFT 0x0
#define DPM_TABLE_393__VceLevel_1_MinPhases_MASK 0xff00
#define DPM_TABLE_393__VceLevel_1_MinPhases__SHIFT 0x8
#define DPM_TABLE_393__VceLevel_1_MinVoltage_MASK 0xffff0000
#define DPM_TABLE_393__VceLevel_1_MinVoltage__SHIFT 0x10
#define DPM_TABLE_394__VceLevel_2_Frequency_MASK 0xffffffff
#define DPM_TABLE_394__VceLevel_2_Frequency__SHIFT 0x0
#define DPM_TABLE_395__VceLevel_2_Divider_MASK 0xff
#define DPM_TABLE_395__VceLevel_2_Divider__SHIFT 0x0
#define DPM_TABLE_395__VceLevel_2_MinPhases_MASK 0xff00
#define DPM_TABLE_395__VceLevel_2_MinPhases__SHIFT 0x8
#define DPM_TABLE_395__VceLevel_2_MinVoltage_MASK 0xffff0000
#define DPM_TABLE_395__VceLevel_2_MinVoltage__SHIFT 0x10
#define DPM_TABLE_396__VceLevel_3_Frequency_MASK 0xffffffff
#define DPM_TABLE_396__VceLevel_3_Frequency__SHIFT 0x0
#define DPM_TABLE_397__VceLevel_3_Divider_MASK 0xff
#define DPM_TABLE_397__VceLevel_3_Divider__SHIFT 0x0
#define DPM_TABLE_397__VceLevel_3_MinPhases_MASK 0xff00
#define DPM_TABLE_397__VceLevel_3_MinPhases__SHIFT 0x8
#define DPM_TABLE_397__VceLevel_3_MinVoltage_MASK 0xffff0000
#define DPM_TABLE_397__VceLevel_3_MinVoltage__SHIFT 0x10
#define DPM_TABLE_398__VceLevel_4_Frequency_MASK 0xffffffff
#define DPM_TABLE_398__VceLevel_4_Frequency__SHIFT 0x0
#define DPM_TABLE_399__VceLevel_4_Divider_MASK 0xff
#define DPM_TABLE_399__VceLevel_4_Divider__SHIFT 0x0
#define DPM_TABLE_399__VceLevel_4_MinPhases_MASK 0xff00
#define DPM_TABLE_399__VceLevel_4_MinPhases__SHIFT 0x8
#define DPM_TABLE_399__VceLevel_4_MinVoltage_MASK 0xffff0000
#define DPM_TABLE_399__VceLevel_4_MinVoltage__SHIFT 0x10
#define DPM_TABLE_400__VceLevel_5_Frequency_MASK 0xffffffff
#define DPM_TABLE_400__VceLevel_5_Frequency__SHIFT 0x0
#define DPM_TABLE_401__VceLevel_5_Divider_MASK 0xff
#define DPM_TABLE_401__VceLevel_5_Divider__SHIFT 0x0
#define DPM_TABLE_401__VceLevel_5_MinPhases_MASK 0xff00
#define DPM_TABLE_401__VceLevel_5_MinPhases__SHIFT 0x8
#define DPM_TABLE_401__VceLevel_5_MinVoltage_MASK 0xffff0000
#define DPM_TABLE_401__VceLevel_5_MinVoltage__SHIFT 0x10
#define DPM_TABLE_402__VceLevel_6_Frequency_MASK 0xffffffff
#define DPM_TABLE_402__VceLevel_6_Frequency__SHIFT 0x0
#define DPM_TABLE_403__VceLevel_6_Divider_MASK 0xff
#define DPM_TABLE_403__VceLevel_6_Divider__SHIFT 0x0
#define DPM_TABLE_403__VceLevel_6_MinPhases_MASK 0xff00
#define DPM_TABLE_403__VceLevel_6_MinPhases__SHIFT 0x8
#define DPM_TABLE_403__VceLevel_6_MinVoltage_MASK 0xffff0000
#define DPM_TABLE_403__VceLevel_6_MinVoltage__SHIFT 0x10
#define DPM_TABLE_404__VceLevel_7_Frequency_MASK 0xffffffff
#define DPM_TABLE_404__VceLevel_7_Frequency__SHIFT 0x0
#define DPM_TABLE_405__VceLevel_7_Divider_MASK 0xff
#define DPM_TABLE_405__VceLevel_7_Divider__SHIFT 0x0
#define DPM_TABLE_405__VceLevel_7_MinPhases_MASK 0xff00
#define DPM_TABLE_405__VceLevel_7_MinPhases__SHIFT 0x8
#define DPM_TABLE_405__VceLevel_7_MinVoltage_MASK 0xffff0000
#define DPM_TABLE_405__VceLevel_7_MinVoltage__SHIFT 0x10
#define DPM_TABLE_406__AcpLevel_0_Frequency_MASK 0xffffffff
#define DPM_TABLE_406__AcpLevel_0_Frequency__SHIFT 0x0
#define DPM_TABLE_407__AcpLevel_0_Divider_MASK 0xff
#define DPM_TABLE_407__AcpLevel_0_Divider__SHIFT 0x0
#define DPM_TABLE_407__AcpLevel_0_MinPhases_MASK 0xff00
#define DPM_TABLE_407__AcpLevel_0_MinPhases__SHIFT 0x8
#define DPM_TABLE_407__AcpLevel_0_MinVoltage_MASK 0xffff0000
#define DPM_TABLE_407__AcpLevel_0_MinVoltage__SHIFT 0x10
#define DPM_TABLE_408__AcpLevel_1_Frequency_MASK 0xffffffff
#define DPM_TABLE_408__AcpLevel_1_Frequency__SHIFT 0x0
#define DPM_TABLE_409__AcpLevel_1_Divider_MASK 0xff
#define DPM_TABLE_409__AcpLevel_1_Divider__SHIFT 0x0
#define DPM_TABLE_409__AcpLevel_1_MinPhases_MASK 0xff00
#define DPM_TABLE_409__AcpLevel_1_MinPhases__SHIFT 0x8
#define DPM_TABLE_409__AcpLevel_1_MinVoltage_MASK 0xffff0000
#define DPM_TABLE_409__AcpLevel_1_MinVoltage__SHIFT 0x10
#define DPM_TABLE_410__AcpLevel_2_Frequency_MASK 0xffffffff
#define DPM_TABLE_410__AcpLevel_2_Frequency__SHIFT 0x0
#define DPM_TABLE_411__AcpLevel_2_Divider_MASK 0xff
#define DPM_TABLE_411__AcpLevel_2_Divider__SHIFT 0x0
#define DPM_TABLE_411__AcpLevel_2_MinPhases_MASK 0xff00
#define DPM_TABLE_411__AcpLevel_2_MinPhases__SHIFT 0x8
#define DPM_TABLE_411__AcpLevel_2_MinVoltage_MASK 0xffff0000
#define DPM_TABLE_411__AcpLevel_2_MinVoltage__SHIFT 0x10
#define DPM_TABLE_412__AcpLevel_3_Frequency_MASK 0xffffffff
#define DPM_TABLE_412__AcpLevel_3_Frequency__SHIFT 0x0
#define DPM_TABLE_413__AcpLevel_3_Divider_MASK 0xff
#define DPM_TABLE_413__AcpLevel_3_Divider__SHIFT 0x0
#define DPM_TABLE_413__AcpLevel_3_MinPhases_MASK 0xff00
#define DPM_TABLE_413__AcpLevel_3_MinPhases__SHIFT 0x8
#define DPM_TABLE_413__AcpLevel_3_MinVoltage_MASK 0xffff0000
#define DPM_TABLE_413__AcpLevel_3_MinVoltage__SHIFT 0x10
#define DPM_TABLE_414__AcpLevel_4_Frequency_MASK 0xffffffff
#define DPM_TABLE_414__AcpLevel_4_Frequency__SHIFT 0x0
#define DPM_TABLE_415__AcpLevel_4_Divider_MASK 0xff
#define DPM_TABLE_415__AcpLevel_4_Divider__SHIFT 0x0
#define DPM_TABLE_415__AcpLevel_4_MinPhases_MASK 0xff00
#define DPM_TABLE_415__AcpLevel_4_MinPhases__SHIFT 0x8
#define DPM_TABLE_415__AcpLevel_4_MinVoltage_MASK 0xffff0000
#define DPM_TABLE_415__AcpLevel_4_MinVoltage__SHIFT 0x10
#define DPM_TABLE_416__AcpLevel_5_Frequency_MASK 0xffffffff
#define DPM_TABLE_416__AcpLevel_5_Frequency__SHIFT 0x0
#define DPM_TABLE_417__AcpLevel_5_Divider_MASK 0xff
#define DPM_TABLE_417__AcpLevel_5_Divider__SHIFT 0x0
#define DPM_TABLE_417__AcpLevel_5_MinPhases_MASK 0xff00
#define DPM_TABLE_417__AcpLevel_5_MinPhases__SHIFT 0x8
#define DPM_TABLE_417__AcpLevel_5_MinVoltage_MASK 0xffff0000
#define DPM_TABLE_417__AcpLevel_5_MinVoltage__SHIFT 0x10
#define DPM_TABLE_418__AcpLevel_6_Frequency_MASK 0xffffffff
#define DPM_TABLE_418__AcpLevel_6_Frequency__SHIFT 0x0
#define DPM_TABLE_419__AcpLevel_6_Divider_MASK 0xff
#define DPM_TABLE_419__AcpLevel_6_Divider__SHIFT 0x0
#define DPM_TABLE_419__AcpLevel_6_MinPhases_MASK 0xff00
#define DPM_TABLE_419__AcpLevel_6_MinPhases__SHIFT 0x8
#define DPM_TABLE_419__AcpLevel_6_MinVoltage_MASK 0xffff0000
#define DPM_TABLE_419__AcpLevel_6_MinVoltage__SHIFT 0x10
#define DPM_TABLE_420__AcpLevel_7_Frequency_MASK 0xffffffff
#define DPM_TABLE_420__AcpLevel_7_Frequency__SHIFT 0x0
#define DPM_TABLE_421__AcpLevel_7_Divider_MASK 0xff
#define DPM_TABLE_421__AcpLevel_7_Divider__SHIFT 0x0
#define DPM_TABLE_421__AcpLevel_7_MinPhases_MASK 0xff00
#define DPM_TABLE_421__AcpLevel_7_MinPhases__SHIFT 0x8
#define DPM_TABLE_421__AcpLevel_7_MinVoltage_MASK 0xffff0000
#define DPM_TABLE_421__AcpLevel_7_MinVoltage__SHIFT 0x10
#define DPM_TABLE_422__SamuLevel_0_Frequency_MASK 0xffffffff
#define DPM_TABLE_422__SamuLevel_0_Frequency__SHIFT 0x0
#define DPM_TABLE_423__SamuLevel_0_Divider_MASK 0xff
#define DPM_TABLE_423__SamuLevel_0_Divider__SHIFT 0x0
#define DPM_TABLE_423__SamuLevel_0_MinPhases_MASK 0xff00
#define DPM_TABLE_423__SamuLevel_0_MinPhases__SHIFT 0x8
#define DPM_TABLE_423__SamuLevel_0_MinVoltage_MASK 0xffff0000
#define DPM_TABLE_423__SamuLevel_0_MinVoltage__SHIFT 0x10
#define DPM_TABLE_424__SamuLevel_1_Frequency_MASK 0xffffffff
#define DPM_TABLE_424__SamuLevel_1_Frequency__SHIFT 0x0
#define DPM_TABLE_425__SamuLevel_1_Divider_MASK 0xff
#define DPM_TABLE_425__SamuLevel_1_Divider__SHIFT 0x0
#define DPM_TABLE_425__SamuLevel_1_MinPhases_MASK 0xff00
#define DPM_TABLE_425__SamuLevel_1_MinPhases__SHIFT 0x8
#define DPM_TABLE_425__SamuLevel_1_MinVoltage_MASK 0xffff0000
#define DPM_TABLE_425__SamuLevel_1_MinVoltage__SHIFT 0x10
#define DPM_TABLE_426__SamuLevel_2_Frequency_MASK 0xffffffff
#define DPM_TABLE_426__SamuLevel_2_Frequency__SHIFT 0x0
#define DPM_TABLE_427__SamuLevel_2_Divider_MASK 0xff
#define DPM_TABLE_427__SamuLevel_2_Divider__SHIFT 0x0
#define DPM_TABLE_427__SamuLevel_2_MinPhases_MASK 0xff00
#define DPM_TABLE_427__SamuLevel_2_MinPhases__SHIFT 0x8
#define DPM_TABLE_427__SamuLevel_2_MinVoltage_MASK 0xffff0000
#define DPM_TABLE_427__SamuLevel_2_MinVoltage__SHIFT 0x10
#define DPM_TABLE_428__SamuLevel_3_Frequency_MASK 0xffffffff
#define DPM_TABLE_428__SamuLevel_3_Frequency__SHIFT 0x0
#define DPM_TABLE_429__SamuLevel_3_Divider_MASK 0xff
#define DPM_TABLE_429__SamuLevel_3_Divider__SHIFT 0x0
#define DPM_TABLE_429__SamuLevel_3_MinPhases_MASK 0xff00
#define DPM_TABLE_429__SamuLevel_3_MinPhases__SHIFT 0x8
#define DPM_TABLE_429__SamuLevel_3_MinVoltage_MASK 0xffff0000
#define DPM_TABLE_429__SamuLevel_3_MinVoltage__SHIFT 0x10
#define DPM_TABLE_430__SamuLevel_4_Frequency_MASK 0xffffffff
#define DPM_TABLE_430__SamuLevel_4_Frequency__SHIFT 0x0
#define DPM_TABLE_431__SamuLevel_4_Divider_MASK 0xff
#define DPM_TABLE_431__SamuLevel_4_Divider__SHIFT 0x0
#define DPM_TABLE_431__SamuLevel_4_MinPhases_MASK 0xff00
#define DPM_TABLE_431__SamuLevel_4_MinPhases__SHIFT 0x8
#define DPM_TABLE_431__SamuLevel_4_MinVoltage_MASK 0xffff0000
#define DPM_TABLE_431__SamuLevel_4_MinVoltage__SHIFT 0x10
#define DPM_TABLE_432__SamuLevel_5_Frequency_MASK 0xffffffff
#define DPM_TABLE_432__SamuLevel_5_Frequency__SHIFT 0x0
#define DPM_TABLE_433__SamuLevel_5_Divider_MASK 0xff
#define DPM_TABLE_433__SamuLevel_5_Divider__SHIFT 0x0
#define DPM_TABLE_433__SamuLevel_5_MinPhases_MASK 0xff00
#define DPM_TABLE_433__SamuLevel_5_MinPhases__SHIFT 0x8
#define DPM_TABLE_433__SamuLevel_5_MinVoltage_MASK 0xffff0000
#define DPM_TABLE_433__SamuLevel_5_MinVoltage__SHIFT 0x10
#define DPM_TABLE_434__SamuLevel_6_Frequency_MASK 0xffffffff
#define DPM_TABLE_434__SamuLevel_6_Frequency__SHIFT 0x0
#define DPM_TABLE_435__SamuLevel_6_Divider_MASK 0xff
#define DPM_TABLE_435__SamuLevel_6_Divider__SHIFT 0x0
#define DPM_TABLE_435__SamuLevel_6_MinPhases_MASK 0xff00
#define DPM_TABLE_435__SamuLevel_6_MinPhases__SHIFT 0x8
#define DPM_TABLE_435__SamuLevel_6_MinVoltage_MASK 0xffff0000
#define DPM_TABLE_435__SamuLevel_6_MinVoltage__SHIFT 0x10
#define DPM_TABLE_436__SamuLevel_7_Frequency_MASK 0xffffffff
#define DPM_TABLE_436__SamuLevel_7_Frequency__SHIFT 0x0
#define DPM_TABLE_437__SamuLevel_7_Divider_MASK 0xff
#define DPM_TABLE_437__SamuLevel_7_Divider__SHIFT 0x0
#define DPM_TABLE_437__SamuLevel_7_MinPhases_MASK 0xff00
#define DPM_TABLE_437__SamuLevel_7_MinPhases__SHIFT 0x8
#define DPM_TABLE_437__SamuLevel_7_MinVoltage_MASK 0xffff0000
#define DPM_TABLE_437__SamuLevel_7_MinVoltage__SHIFT 0x10
#define DPM_TABLE_438__Ulv_CcPwrDynRm_MASK 0xffffffff
#define DPM_TABLE_438__Ulv_CcPwrDynRm__SHIFT 0x0
#define DPM_TABLE_439__Ulv_CcPwrDynRm1_MASK 0xffffffff
#define DPM_TABLE_439__Ulv_CcPwrDynRm1__SHIFT 0x0
#define DPM_TABLE_440__Ulv_VddcPhase_MASK 0xff
#define DPM_TABLE_440__Ulv_VddcPhase__SHIFT 0x0
#define DPM_TABLE_440__Ulv_VddcOffsetVid_MASK 0xff00
#define DPM_TABLE_440__Ulv_VddcOffsetVid__SHIFT 0x8
#define DPM_TABLE_440__Ulv_VddcOffset_MASK 0xffff0000
#define DPM_TABLE_440__Ulv_VddcOffset__SHIFT 0x10
#define DPM_TABLE_441__Ulv_Reserved_MASK 0xffffffff
#define DPM_TABLE_441__Ulv_Reserved__SHIFT 0x0
#define DPM_TABLE_442__SclkStepSize_MASK 0xffffffff
#define DPM_TABLE_442__SclkStepSize__SHIFT 0x0
#define DPM_TABLE_443__Smio_0_MASK 0xffffffff
#define DPM_TABLE_443__Smio_0__SHIFT 0x0
#define DPM_TABLE_444__Smio_1_MASK 0xffffffff
#define DPM_TABLE_444__Smio_1__SHIFT 0x0
#define DPM_TABLE_445__Smio_2_MASK 0xffffffff
#define DPM_TABLE_445__Smio_2__SHIFT 0x0
#define DPM_TABLE_446__Smio_3_MASK 0xffffffff
#define DPM_TABLE_446__Smio_3__SHIFT 0x0
#define DPM_TABLE_447__Smio_4_MASK 0xffffffff
#define DPM_TABLE_447__Smio_4__SHIFT 0x0
#define DPM_TABLE_448__Smio_5_MASK 0xffffffff
#define DPM_TABLE_448__Smio_5__SHIFT 0x0
#define DPM_TABLE_449__Smio_6_MASK 0xffffffff
#define DPM_TABLE_449__Smio_6__SHIFT 0x0
#define DPM_TABLE_450__Smio_7_MASK 0xffffffff
#define DPM_TABLE_450__Smio_7__SHIFT 0x0
#define DPM_TABLE_451__Smio_8_MASK 0xffffffff
#define DPM_TABLE_451__Smio_8__SHIFT 0x0
#define DPM_TABLE_452__Smio_9_MASK 0xffffffff
#define DPM_TABLE_452__Smio_9__SHIFT 0x0
#define DPM_TABLE_453__Smio_10_MASK 0xffffffff
#define DPM_TABLE_453__Smio_10__SHIFT 0x0
#define DPM_TABLE_454__Smio_11_MASK 0xffffffff
#define DPM_TABLE_454__Smio_11__SHIFT 0x0
#define DPM_TABLE_455__Smio_12_MASK 0xffffffff
#define DPM_TABLE_455__Smio_12__SHIFT 0x0
#define DPM_TABLE_456__Smio_13_MASK 0xffffffff
#define DPM_TABLE_456__Smio_13__SHIFT 0x0
#define DPM_TABLE_457__Smio_14_MASK 0xffffffff
#define DPM_TABLE_457__Smio_14__SHIFT 0x0
#define DPM_TABLE_458__Smio_15_MASK 0xffffffff
#define DPM_TABLE_458__Smio_15__SHIFT 0x0
#define DPM_TABLE_459__Smio_16_MASK 0xffffffff
#define DPM_TABLE_459__Smio_16__SHIFT 0x0
#define DPM_TABLE_460__Smio_17_MASK 0xffffffff
#define DPM_TABLE_460__Smio_17__SHIFT 0x0
#define DPM_TABLE_461__Smio_18_MASK 0xffffffff
#define DPM_TABLE_461__Smio_18__SHIFT 0x0
#define DPM_TABLE_462__Smio_19_MASK 0xffffffff
#define DPM_TABLE_462__Smio_19__SHIFT 0x0
#define DPM_TABLE_463__Smio_20_MASK 0xffffffff
#define DPM_TABLE_463__Smio_20__SHIFT 0x0
#define DPM_TABLE_464__Smio_21_MASK 0xffffffff
#define DPM_TABLE_464__Smio_21__SHIFT 0x0
#define DPM_TABLE_465__Smio_22_MASK 0xffffffff
#define DPM_TABLE_465__Smio_22__SHIFT 0x0
#define DPM_TABLE_466__Smio_23_MASK 0xffffffff
#define DPM_TABLE_466__Smio_23__SHIFT 0x0
#define DPM_TABLE_467__Smio_24_MASK 0xffffffff
#define DPM_TABLE_467__Smio_24__SHIFT 0x0
#define DPM_TABLE_468__Smio_25_MASK 0xffffffff
#define DPM_TABLE_468__Smio_25__SHIFT 0x0
#define DPM_TABLE_469__Smio_26_MASK 0xffffffff
#define DPM_TABLE_469__Smio_26__SHIFT 0x0
#define DPM_TABLE_470__Smio_27_MASK 0xffffffff
#define DPM_TABLE_470__Smio_27__SHIFT 0x0
#define DPM_TABLE_471__Smio_28_MASK 0xffffffff
#define DPM_TABLE_471__Smio_28__SHIFT 0x0
#define DPM_TABLE_472__Smio_29_MASK 0xffffffff
#define DPM_TABLE_472__Smio_29__SHIFT 0x0
#define DPM_TABLE_473__Smio_30_MASK 0xffffffff
#define DPM_TABLE_473__Smio_30__SHIFT 0x0
#define DPM_TABLE_474__Smio_31_MASK 0xffffffff
#define DPM_TABLE_474__Smio_31__SHIFT 0x0
#define DPM_TABLE_475__SamuBootLevel_MASK 0xff
#define DPM_TABLE_475__SamuBootLevel__SHIFT 0x0
#define DPM_TABLE_475__AcpBootLevel_MASK 0xff00
#define DPM_TABLE_475__AcpBootLevel__SHIFT 0x8
#define DPM_TABLE_475__VceBootLevel_MASK 0xff0000
#define DPM_TABLE_475__VceBootLevel__SHIFT 0x10
#define DPM_TABLE_475__UvdBootLevel_MASK 0xff000000
#define DPM_TABLE_475__UvdBootLevel__SHIFT 0x18
#define DPM_TABLE_476__SAMUInterval_MASK 0xff
#define DPM_TABLE_476__SAMUInterval__SHIFT 0x0
#define DPM_TABLE_476__ACPInterval_MASK 0xff00
#define DPM_TABLE_476__ACPInterval__SHIFT 0x8
#define DPM_TABLE_476__VCEInterval_MASK 0xff0000
#define DPM_TABLE_476__VCEInterval__SHIFT 0x10
#define DPM_TABLE_476__UVDInterval_MASK 0xff000000
#define DPM_TABLE_476__UVDInterval__SHIFT 0x18
#define DPM_TABLE_477__GraphicsInterval_MASK 0xff
#define DPM_TABLE_477__GraphicsInterval__SHIFT 0x0
#define DPM_TABLE_477__GraphicsThermThrottleEnable_MASK 0xff00
#define DPM_TABLE_477__GraphicsThermThrottleEnable__SHIFT 0x8
#define DPM_TABLE_477__GraphicsVoltageChangeEnable_MASK 0xff0000
#define DPM_TABLE_477__GraphicsVoltageChangeEnable__SHIFT 0x10
#define DPM_TABLE_477__GraphicsBootLevel_MASK 0xff000000
#define DPM_TABLE_477__GraphicsBootLevel__SHIFT 0x18
#define DPM_TABLE_478__TemperatureLimitHigh_MASK 0xffff
#define DPM_TABLE_478__TemperatureLimitHigh__SHIFT 0x0
#define DPM_TABLE_478__ThermalInterval_MASK 0xff0000
#define DPM_TABLE_478__ThermalInterval__SHIFT 0x10
#define DPM_TABLE_478__VoltageInterval_MASK 0xff000000
#define DPM_TABLE_478__VoltageInterval__SHIFT 0x18
#define DPM_TABLE_479__MemoryVoltageChangeEnable_MASK 0xff
#define DPM_TABLE_479__MemoryVoltageChangeEnable__SHIFT 0x0
#define DPM_TABLE_479__MemoryBootLevel_MASK 0xff00
#define DPM_TABLE_479__MemoryBootLevel__SHIFT 0x8
#define DPM_TABLE_479__TemperatureLimitLow_MASK 0xffff0000
#define DPM_TABLE_479__TemperatureLimitLow__SHIFT 0x10
#define DPM_TABLE_480__VddcVddciDelta_MASK 0xffff
#define DPM_TABLE_480__VddcVddciDelta__SHIFT 0x0
#define DPM_TABLE_480__MemoryThermThrottleEnable_MASK 0xff0000
#define DPM_TABLE_480__MemoryThermThrottleEnable__SHIFT 0x10
#define DPM_TABLE_480__MemoryInterval_MASK 0xff000000
#define DPM_TABLE_480__MemoryInterval__SHIFT 0x18
#define DPM_TABLE_481__PhaseResponseTime_MASK 0xffff
#define DPM_TABLE_481__PhaseResponseTime__SHIFT 0x0
#define DPM_TABLE_481__VoltageResponseTime_MASK 0xffff0000
#define DPM_TABLE_481__VoltageResponseTime__SHIFT 0x10
#define DPM_TABLE_482__DTEMode_MASK 0xff
#define DPM_TABLE_482__DTEMode__SHIFT 0x0
#define DPM_TABLE_482__DTEInterval_MASK 0xff00
#define DPM_TABLE_482__DTEInterval__SHIFT 0x8
#define DPM_TABLE_482__PCIeGenInterval_MASK 0xff0000
#define DPM_TABLE_482__PCIeGenInterval__SHIFT 0x10
#define DPM_TABLE_482__PCIeBootLinkLevel_MASK 0xff000000
#define DPM_TABLE_482__PCIeBootLinkLevel__SHIFT 0x18
#define DPM_TABLE_483__ThermGpio_MASK 0xff
#define DPM_TABLE_483__ThermGpio__SHIFT 0x0
#define DPM_TABLE_483__AcDcGpio_MASK 0xff00
#define DPM_TABLE_483__AcDcGpio__SHIFT 0x8
#define DPM_TABLE_483__VRHotGpio_MASK 0xff0000
#define DPM_TABLE_483__VRHotGpio__SHIFT 0x10
#define DPM_TABLE_483__SVI2Enable_MASK 0xff000000
#define DPM_TABLE_483__SVI2Enable__SHIFT 0x18
#define DPM_TABLE_484__DisplayCac_MASK 0xffffffff
#define DPM_TABLE_484__DisplayCac__SHIFT 0x0
#define DPM_TABLE_485__NomPwr_MASK 0xffff
#define DPM_TABLE_485__NomPwr__SHIFT 0x0
#define DPM_TABLE_485__MaxPwr_MASK 0xffff0000
#define DPM_TABLE_485__MaxPwr__SHIFT 0x10
#define DPM_TABLE_486__FpsLowThreshold_MASK 0xffff
#define DPM_TABLE_486__FpsLowThreshold__SHIFT 0x0
#define DPM_TABLE_486__FpsHighThreshold_MASK 0xffff0000
#define DPM_TABLE_486__FpsHighThreshold__SHIFT 0x10
#define DPM_TABLE_487__BAPMTI_R_0_1_0_MASK 0xffff
#define DPM_TABLE_487__BAPMTI_R_0_1_0__SHIFT 0x0
#define DPM_TABLE_487__BAPMTI_R_0_0_0_MASK 0xffff0000
#define DPM_TABLE_487__BAPMTI_R_0_0_0__SHIFT 0x10
#define DPM_TABLE_488__BAPMTI_R_1_0_0_MASK 0xffff
#define DPM_TABLE_488__BAPMTI_R_1_0_0__SHIFT 0x0
#define DPM_TABLE_488__BAPMTI_R_0_2_0_MASK 0xffff0000
#define DPM_TABLE_488__BAPMTI_R_0_2_0__SHIFT 0x10
#define DPM_TABLE_489__BAPMTI_R_1_2_0_MASK 0xffff
#define DPM_TABLE_489__BAPMTI_R_1_2_0__SHIFT 0x0
#define DPM_TABLE_489__BAPMTI_R_1_1_0_MASK 0xffff0000
#define DPM_TABLE_489__BAPMTI_R_1_1_0__SHIFT 0x10
#define DPM_TABLE_490__BAPMTI_R_2_1_0_MASK 0xffff
#define DPM_TABLE_490__BAPMTI_R_2_1_0__SHIFT 0x0
#define DPM_TABLE_490__BAPMTI_R_2_0_0_MASK 0xffff0000
#define DPM_TABLE_490__BAPMTI_R_2_0_0__SHIFT 0x10
#define DPM_TABLE_491__BAPMTI_R_3_0_0_MASK 0xffff
#define DPM_TABLE_491__BAPMTI_R_3_0_0__SHIFT 0x0
#define DPM_TABLE_491__BAPMTI_R_2_2_0_MASK 0xffff0000
#define DPM_TABLE_491__BAPMTI_R_2_2_0__SHIFT 0x10
#define DPM_TABLE_492__BAPMTI_R_3_2_0_MASK 0xffff
#define DPM_TABLE_492__BAPMTI_R_3_2_0__SHIFT 0x0
#define DPM_TABLE_492__BAPMTI_R_3_1_0_MASK 0xffff0000
#define DPM_TABLE_492__BAPMTI_R_3_1_0__SHIFT 0x10
#define DPM_TABLE_493__BAPMTI_R_4_1_0_MASK 0xffff
#define DPM_TABLE_493__BAPMTI_R_4_1_0__SHIFT 0x0
#define DPM_TABLE_493__BAPMTI_R_4_0_0_MASK 0xffff0000
#define DPM_TABLE_493__BAPMTI_R_4_0_0__SHIFT 0x10
#define DPM_TABLE_494__BAPMTI_RC_0_0_0_MASK 0xffff
#define DPM_TABLE_494__BAPMTI_RC_0_0_0__SHIFT 0x0
#define DPM_TABLE_494__BAPMTI_R_4_2_0_MASK 0xffff0000
#define DPM_TABLE_494__BAPMTI_R_4_2_0__SHIFT 0x10
#define DPM_TABLE_495__BAPMTI_RC_0_2_0_MASK 0xffff
#define DPM_TABLE_495__BAPMTI_RC_0_2_0__SHIFT 0x0
#define DPM_TABLE_495__BAPMTI_RC_0_1_0_MASK 0xffff0000
#define DPM_TABLE_495__BAPMTI_RC_0_1_0__SHIFT 0x10
#define DPM_TABLE_496__BAPMTI_RC_1_1_0_MASK 0xffff
#define DPM_TABLE_496__BAPMTI_RC_1_1_0__SHIFT 0x0
#define DPM_TABLE_496__BAPMTI_RC_1_0_0_MASK 0xffff0000
#define DPM_TABLE_496__BAPMTI_RC_1_0_0__SHIFT 0x10
#define DPM_TABLE_497__BAPMTI_RC_2_0_0_MASK 0xffff
#define DPM_TABLE_497__BAPMTI_RC_2_0_0__SHIFT 0x0
#define DPM_TABLE_497__BAPMTI_RC_1_2_0_MASK 0xffff0000
#define DPM_TABLE_497__BAPMTI_RC_1_2_0__SHIFT 0x10
#define DPM_TABLE_498__BAPMTI_RC_2_2_0_MASK 0xffff
#define DPM_TABLE_498__BAPMTI_RC_2_2_0__SHIFT 0x0
#define DPM_TABLE_498__BAPMTI_RC_2_1_0_MASK 0xffff0000
#define DPM_TABLE_498__BAPMTI_RC_2_1_0__SHIFT 0x10
#define DPM_TABLE_499__BAPMTI_RC_3_1_0_MASK 0xffff
#define DPM_TABLE_499__BAPMTI_RC_3_1_0__SHIFT 0x0
#define DPM_TABLE_499__BAPMTI_RC_3_0_0_MASK 0xffff0000
#define DPM_TABLE_499__BAPMTI_RC_3_0_0__SHIFT 0x10
#define DPM_TABLE_500__BAPMTI_RC_4_0_0_MASK 0xffff
#define DPM_TABLE_500__BAPMTI_RC_4_0_0__SHIFT 0x0
#define DPM_TABLE_500__BAPMTI_RC_3_2_0_MASK 0xffff0000
#define DPM_TABLE_500__BAPMTI_RC_3_2_0__SHIFT 0x10
#define DPM_TABLE_501__BAPMTI_RC_4_2_0_MASK 0xffff
#define DPM_TABLE_501__BAPMTI_RC_4_2_0__SHIFT 0x0
#define DPM_TABLE_501__BAPMTI_RC_4_1_0_MASK 0xffff0000
#define DPM_TABLE_501__BAPMTI_RC_4_1_0__SHIFT 0x10
#define DPM_TABLE_502__GpuTjHyst_MASK 0xff
#define DPM_TABLE_502__GpuTjHyst__SHIFT 0x0
#define DPM_TABLE_502__GpuTjMax_MASK 0xff00
#define DPM_TABLE_502__GpuTjMax__SHIFT 0x8
#define DPM_TABLE_502__DTETjOffset_MASK 0xff0000
#define DPM_TABLE_502__DTETjOffset__SHIFT 0x10
#define DPM_TABLE_502__DTEAmbientTempBase_MASK 0xff000000
#define DPM_TABLE_502__DTEAmbientTempBase__SHIFT 0x18
#define DPM_TABLE_503__BootVddci_MASK 0xffff
#define DPM_TABLE_503__BootVddci__SHIFT 0x0
#define DPM_TABLE_503__BootVddc_MASK 0xffff0000
#define DPM_TABLE_503__BootVddc__SHIFT 0x10
#define DPM_TABLE_504__padding_MASK 0xffff
#define DPM_TABLE_504__padding__SHIFT 0x0
#define DPM_TABLE_504__BootMVdd_MASK 0xffff0000
#define DPM_TABLE_504__BootMVdd__SHIFT 0x10
#define DPM_TABLE_505__DRAM_LOG_ADDR_H_MASK 0xffffffff
#define DPM_TABLE_505__DRAM_LOG_ADDR_H__SHIFT 0x0
#define DPM_TABLE_506__DRAM_LOG_ADDR_L_MASK 0xffffffff
#define DPM_TABLE_506__DRAM_LOG_ADDR_L__SHIFT 0x0
#define DPM_TABLE_507__DRAM_LOG_PHY_ADDR_H_MASK 0xffffffff
#define DPM_TABLE_507__DRAM_LOG_PHY_ADDR_H__SHIFT 0x0
#define DPM_TABLE_508__DRAM_LOG_PHY_ADDR_L_MASK 0xffffffff
#define DPM_TABLE_508__DRAM_LOG_PHY_ADDR_L__SHIFT 0x0
#define DPM_TABLE_509__DRAM_LOG_BUFF_SIZE_MASK 0xffffffff
#define DPM_TABLE_509__DRAM_LOG_BUFF_SIZE__SHIFT 0x0
#define DPM_TABLE_510__BAPM_TEMP_GRADIENT_MASK 0xffffffff
#define DPM_TABLE_510__BAPM_TEMP_GRADIENT__SHIFT 0x0
#define FIRMWARE_FLAGS__INTERRUPTS_ENABLED_MASK 0x1
#define FIRMWARE_FLAGS__INTERRUPTS_ENABLED__SHIFT 0x0
#define FIRMWARE_FLAGS__RESERVED_MASK 0xfffffe
#define FIRMWARE_FLAGS__RESERVED__SHIFT 0x1
#define FIRMWARE_FLAGS__TEST_COUNT_MASK 0xff000000
#define FIRMWARE_FLAGS__TEST_COUNT__SHIFT 0x18
#define TDC_STATUS__VDD_Boost_MASK 0xff
#define TDC_STATUS__VDD_Boost__SHIFT 0x0
#define TDC_STATUS__VDD_Throttle_MASK 0xff00
#define TDC_STATUS__VDD_Throttle__SHIFT 0x8
#define TDC_STATUS__VDDC_Boost_MASK 0xff0000
#define TDC_STATUS__VDDC_Boost__SHIFT 0x10
#define TDC_STATUS__VDDC_Throttle_MASK 0xff000000
#define TDC_STATUS__VDDC_Throttle__SHIFT 0x18
#define TDC_MV_AVERAGE__IDD_MASK 0xffff
#define TDC_MV_AVERAGE__IDD__SHIFT 0x0
#define TDC_MV_AVERAGE__IDDC_MASK 0xffff0000
#define TDC_MV_AVERAGE__IDDC__SHIFT 0x10
#define TDC_VRM_LIMIT__IDD_MASK 0xffff
#define TDC_VRM_LIMIT__IDD__SHIFT 0x0
#define TDC_VRM_LIMIT__IDDC_MASK 0xffff0000
#define TDC_VRM_LIMIT__IDDC__SHIFT 0x10
#define FEATURE_STATUS__SCLK_DPM_ON_MASK 0x1
#define FEATURE_STATUS__SCLK_DPM_ON__SHIFT 0x0
#define FEATURE_STATUS__MCLK_DPM_ON_MASK 0x2
#define FEATURE_STATUS__MCLK_DPM_ON__SHIFT 0x1
#define FEATURE_STATUS__LCLK_DPM_ON_MASK 0x4
#define FEATURE_STATUS__LCLK_DPM_ON__SHIFT 0x2
#define FEATURE_STATUS__UVD_DPM_ON_MASK 0x8
#define FEATURE_STATUS__UVD_DPM_ON__SHIFT 0x3
#define FEATURE_STATUS__VCE_DPM_ON_MASK 0x10
#define FEATURE_STATUS__VCE_DPM_ON__SHIFT 0x4
#define FEATURE_STATUS__ACP_DPM_ON_MASK 0x20
#define FEATURE_STATUS__ACP_DPM_ON__SHIFT 0x5
#define FEATURE_STATUS__SAMU_DPM_ON_MASK 0x40
#define FEATURE_STATUS__SAMU_DPM_ON__SHIFT 0x6
#define FEATURE_STATUS__PCIE_DPM_ON_MASK 0x80
#define FEATURE_STATUS__PCIE_DPM_ON__SHIFT 0x7
#define FEATURE_STATUS__BAPM_ON_MASK 0x100
#define FEATURE_STATUS__BAPM_ON__SHIFT 0x8
#define FEATURE_STATUS__LPMX_ON_MASK 0x200
#define FEATURE_STATUS__LPMX_ON__SHIFT 0x9
#define FEATURE_STATUS__NBDPM_ON_MASK 0x400
#define FEATURE_STATUS__NBDPM_ON__SHIFT 0xa
#define FEATURE_STATUS__LHTC_ON_MASK 0x800
#define FEATURE_STATUS__LHTC_ON__SHIFT 0xb
#define FEATURE_STATUS__VPC_ON_MASK 0x1000
#define FEATURE_STATUS__VPC_ON__SHIFT 0xc
#define FEATURE_STATUS__VOLTAGE_CONTROLLER_ON_MASK 0x2000
#define FEATURE_STATUS__VOLTAGE_CONTROLLER_ON__SHIFT 0xd
#define FEATURE_STATUS__TDC_LIMIT_ON_MASK 0x4000
#define FEATURE_STATUS__TDC_LIMIT_ON__SHIFT 0xe
#define FEATURE_STATUS__GPU_CAC_ON_MASK 0x8000
#define FEATURE_STATUS__GPU_CAC_ON__SHIFT 0xf
#define FEATURE_STATUS__AVS_ON_MASK 0x10000
#define FEATURE_STATUS__AVS_ON__SHIFT 0x10
#define FEATURE_STATUS__SPMI_ON_MASK 0x20000
#define FEATURE_STATUS__SPMI_ON__SHIFT 0x11
#define FEATURE_STATUS__SCLK_DPM_FORCED_MASK 0x40000
#define FEATURE_STATUS__SCLK_DPM_FORCED__SHIFT 0x12
#define FEATURE_STATUS__MCLK_DPM_FORCED_MASK 0x80000
#define FEATURE_STATUS__MCLK_DPM_FORCED__SHIFT 0x13
#define FEATURE_STATUS__LCLK_DPM_FORCED_MASK 0x100000
#define FEATURE_STATUS__LCLK_DPM_FORCED__SHIFT 0x14
#define FEATURE_STATUS__PCIE_DPM_FORCED_MASK 0x200000
#define FEATURE_STATUS__PCIE_DPM_FORCED__SHIFT 0x15
#define FEATURE_STATUS__RESERVED_MASK 0xffc00000
#define FEATURE_STATUS__RESERVED__SHIFT 0x16
#define ENTITY_TEMPERATURES_1__GPU_MASK 0xffffffff
#define ENTITY_TEMPERATURES_1__GPU__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_1__entries_0_0_McArbDramTiming_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_1__entries_0_0_McArbDramTiming__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_2__entries_0_0_McArbDramTiming2_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_2__entries_0_0_McArbDramTiming2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_3__entries_0_0_padding_2_MASK 0xff
#define MCARB_DRAM_TIMING_TABLE_3__entries_0_0_padding_2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_3__entries_0_0_padding_1_MASK 0xff00
#define MCARB_DRAM_TIMING_TABLE_3__entries_0_0_padding_1__SHIFT 0x8
#define MCARB_DRAM_TIMING_TABLE_3__entries_0_0_padding_0_MASK 0xff0000
#define MCARB_DRAM_TIMING_TABLE_3__entries_0_0_padding_0__SHIFT 0x10
#define MCARB_DRAM_TIMING_TABLE_3__entries_0_0_McArbBurstTime_MASK 0xff000000
#define MCARB_DRAM_TIMING_TABLE_3__entries_0_0_McArbBurstTime__SHIFT 0x18
#define MCARB_DRAM_TIMING_TABLE_4__entries_0_1_McArbDramTiming_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_4__entries_0_1_McArbDramTiming__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_5__entries_0_1_McArbDramTiming2_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_5__entries_0_1_McArbDramTiming2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_6__entries_0_1_padding_2_MASK 0xff
#define MCARB_DRAM_TIMING_TABLE_6__entries_0_1_padding_2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_6__entries_0_1_padding_1_MASK 0xff00
#define MCARB_DRAM_TIMING_TABLE_6__entries_0_1_padding_1__SHIFT 0x8
#define MCARB_DRAM_TIMING_TABLE_6__entries_0_1_padding_0_MASK 0xff0000
#define MCARB_DRAM_TIMING_TABLE_6__entries_0_1_padding_0__SHIFT 0x10
#define MCARB_DRAM_TIMING_TABLE_6__entries_0_1_McArbBurstTime_MASK 0xff000000
#define MCARB_DRAM_TIMING_TABLE_6__entries_0_1_McArbBurstTime__SHIFT 0x18
#define MCARB_DRAM_TIMING_TABLE_7__entries_0_2_McArbDramTiming_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_7__entries_0_2_McArbDramTiming__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_8__entries_0_2_McArbDramTiming2_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_8__entries_0_2_McArbDramTiming2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_9__entries_0_2_padding_2_MASK 0xff
#define MCARB_DRAM_TIMING_TABLE_9__entries_0_2_padding_2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_9__entries_0_2_padding_1_MASK 0xff00
#define MCARB_DRAM_TIMING_TABLE_9__entries_0_2_padding_1__SHIFT 0x8
#define MCARB_DRAM_TIMING_TABLE_9__entries_0_2_padding_0_MASK 0xff0000
#define MCARB_DRAM_TIMING_TABLE_9__entries_0_2_padding_0__SHIFT 0x10
#define MCARB_DRAM_TIMING_TABLE_9__entries_0_2_McArbBurstTime_MASK 0xff000000
#define MCARB_DRAM_TIMING_TABLE_9__entries_0_2_McArbBurstTime__SHIFT 0x18
#define MCARB_DRAM_TIMING_TABLE_10__entries_0_3_McArbDramTiming_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_10__entries_0_3_McArbDramTiming__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_11__entries_0_3_McArbDramTiming2_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_11__entries_0_3_McArbDramTiming2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_12__entries_0_3_padding_2_MASK 0xff
#define MCARB_DRAM_TIMING_TABLE_12__entries_0_3_padding_2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_12__entries_0_3_padding_1_MASK 0xff00
#define MCARB_DRAM_TIMING_TABLE_12__entries_0_3_padding_1__SHIFT 0x8
#define MCARB_DRAM_TIMING_TABLE_12__entries_0_3_padding_0_MASK 0xff0000
#define MCARB_DRAM_TIMING_TABLE_12__entries_0_3_padding_0__SHIFT 0x10
#define MCARB_DRAM_TIMING_TABLE_12__entries_0_3_McArbBurstTime_MASK 0xff000000
#define MCARB_DRAM_TIMING_TABLE_12__entries_0_3_McArbBurstTime__SHIFT 0x18
#define MCARB_DRAM_TIMING_TABLE_13__entries_0_4_McArbDramTiming_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_13__entries_0_4_McArbDramTiming__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_14__entries_0_4_McArbDramTiming2_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_14__entries_0_4_McArbDramTiming2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_15__entries_0_4_padding_2_MASK 0xff
#define MCARB_DRAM_TIMING_TABLE_15__entries_0_4_padding_2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_15__entries_0_4_padding_1_MASK 0xff00
#define MCARB_DRAM_TIMING_TABLE_15__entries_0_4_padding_1__SHIFT 0x8
#define MCARB_DRAM_TIMING_TABLE_15__entries_0_4_padding_0_MASK 0xff0000
#define MCARB_DRAM_TIMING_TABLE_15__entries_0_4_padding_0__SHIFT 0x10
#define MCARB_DRAM_TIMING_TABLE_15__entries_0_4_McArbBurstTime_MASK 0xff000000
#define MCARB_DRAM_TIMING_TABLE_15__entries_0_4_McArbBurstTime__SHIFT 0x18
#define MCARB_DRAM_TIMING_TABLE_16__entries_0_5_McArbDramTiming_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_16__entries_0_5_McArbDramTiming__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_17__entries_0_5_McArbDramTiming2_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_17__entries_0_5_McArbDramTiming2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_18__entries_0_5_padding_2_MASK 0xff
#define MCARB_DRAM_TIMING_TABLE_18__entries_0_5_padding_2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_18__entries_0_5_padding_1_MASK 0xff00
#define MCARB_DRAM_TIMING_TABLE_18__entries_0_5_padding_1__SHIFT 0x8
#define MCARB_DRAM_TIMING_TABLE_18__entries_0_5_padding_0_MASK 0xff0000
#define MCARB_DRAM_TIMING_TABLE_18__entries_0_5_padding_0__SHIFT 0x10
#define MCARB_DRAM_TIMING_TABLE_18__entries_0_5_McArbBurstTime_MASK 0xff000000
#define MCARB_DRAM_TIMING_TABLE_18__entries_0_5_McArbBurstTime__SHIFT 0x18
#define MCARB_DRAM_TIMING_TABLE_19__entries_1_0_McArbDramTiming_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_19__entries_1_0_McArbDramTiming__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_20__entries_1_0_McArbDramTiming2_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_20__entries_1_0_McArbDramTiming2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_21__entries_1_0_padding_2_MASK 0xff
#define MCARB_DRAM_TIMING_TABLE_21__entries_1_0_padding_2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_21__entries_1_0_padding_1_MASK 0xff00
#define MCARB_DRAM_TIMING_TABLE_21__entries_1_0_padding_1__SHIFT 0x8
#define MCARB_DRAM_TIMING_TABLE_21__entries_1_0_padding_0_MASK 0xff0000
#define MCARB_DRAM_TIMING_TABLE_21__entries_1_0_padding_0__SHIFT 0x10
#define MCARB_DRAM_TIMING_TABLE_21__entries_1_0_McArbBurstTime_MASK 0xff000000
#define MCARB_DRAM_TIMING_TABLE_21__entries_1_0_McArbBurstTime__SHIFT 0x18
#define MCARB_DRAM_TIMING_TABLE_22__entries_1_1_McArbDramTiming_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_22__entries_1_1_McArbDramTiming__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_23__entries_1_1_McArbDramTiming2_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_23__entries_1_1_McArbDramTiming2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_24__entries_1_1_padding_2_MASK 0xff
#define MCARB_DRAM_TIMING_TABLE_24__entries_1_1_padding_2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_24__entries_1_1_padding_1_MASK 0xff00
#define MCARB_DRAM_TIMING_TABLE_24__entries_1_1_padding_1__SHIFT 0x8
#define MCARB_DRAM_TIMING_TABLE_24__entries_1_1_padding_0_MASK 0xff0000
#define MCARB_DRAM_TIMING_TABLE_24__entries_1_1_padding_0__SHIFT 0x10
#define MCARB_DRAM_TIMING_TABLE_24__entries_1_1_McArbBurstTime_MASK 0xff000000
#define MCARB_DRAM_TIMING_TABLE_24__entries_1_1_McArbBurstTime__SHIFT 0x18
#define MCARB_DRAM_TIMING_TABLE_25__entries_1_2_McArbDramTiming_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_25__entries_1_2_McArbDramTiming__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_26__entries_1_2_McArbDramTiming2_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_26__entries_1_2_McArbDramTiming2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_27__entries_1_2_padding_2_MASK 0xff
#define MCARB_DRAM_TIMING_TABLE_27__entries_1_2_padding_2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_27__entries_1_2_padding_1_MASK 0xff00
#define MCARB_DRAM_TIMING_TABLE_27__entries_1_2_padding_1__SHIFT 0x8
#define MCARB_DRAM_TIMING_TABLE_27__entries_1_2_padding_0_MASK 0xff0000
#define MCARB_DRAM_TIMING_TABLE_27__entries_1_2_padding_0__SHIFT 0x10
#define MCARB_DRAM_TIMING_TABLE_27__entries_1_2_McArbBurstTime_MASK 0xff000000
#define MCARB_DRAM_TIMING_TABLE_27__entries_1_2_McArbBurstTime__SHIFT 0x18
#define MCARB_DRAM_TIMING_TABLE_28__entries_1_3_McArbDramTiming_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_28__entries_1_3_McArbDramTiming__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_29__entries_1_3_McArbDramTiming2_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_29__entries_1_3_McArbDramTiming2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_30__entries_1_3_padding_2_MASK 0xff
#define MCARB_DRAM_TIMING_TABLE_30__entries_1_3_padding_2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_30__entries_1_3_padding_1_MASK 0xff00
#define MCARB_DRAM_TIMING_TABLE_30__entries_1_3_padding_1__SHIFT 0x8
#define MCARB_DRAM_TIMING_TABLE_30__entries_1_3_padding_0_MASK 0xff0000
#define MCARB_DRAM_TIMING_TABLE_30__entries_1_3_padding_0__SHIFT 0x10
#define MCARB_DRAM_TIMING_TABLE_30__entries_1_3_McArbBurstTime_MASK 0xff000000
#define MCARB_DRAM_TIMING_TABLE_30__entries_1_3_McArbBurstTime__SHIFT 0x18
#define MCARB_DRAM_TIMING_TABLE_31__entries_1_4_McArbDramTiming_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_31__entries_1_4_McArbDramTiming__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_32__entries_1_4_McArbDramTiming2_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_32__entries_1_4_McArbDramTiming2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_33__entries_1_4_padding_2_MASK 0xff
#define MCARB_DRAM_TIMING_TABLE_33__entries_1_4_padding_2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_33__entries_1_4_padding_1_MASK 0xff00
#define MCARB_DRAM_TIMING_TABLE_33__entries_1_4_padding_1__SHIFT 0x8
#define MCARB_DRAM_TIMING_TABLE_33__entries_1_4_padding_0_MASK 0xff0000
#define MCARB_DRAM_TIMING_TABLE_33__entries_1_4_padding_0__SHIFT 0x10
#define MCARB_DRAM_TIMING_TABLE_33__entries_1_4_McArbBurstTime_MASK 0xff000000
#define MCARB_DRAM_TIMING_TABLE_33__entries_1_4_McArbBurstTime__SHIFT 0x18
#define MCARB_DRAM_TIMING_TABLE_34__entries_1_5_McArbDramTiming_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_34__entries_1_5_McArbDramTiming__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_35__entries_1_5_McArbDramTiming2_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_35__entries_1_5_McArbDramTiming2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_36__entries_1_5_padding_2_MASK 0xff
#define MCARB_DRAM_TIMING_TABLE_36__entries_1_5_padding_2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_36__entries_1_5_padding_1_MASK 0xff00
#define MCARB_DRAM_TIMING_TABLE_36__entries_1_5_padding_1__SHIFT 0x8
#define MCARB_DRAM_TIMING_TABLE_36__entries_1_5_padding_0_MASK 0xff0000
#define MCARB_DRAM_TIMING_TABLE_36__entries_1_5_padding_0__SHIFT 0x10
#define MCARB_DRAM_TIMING_TABLE_36__entries_1_5_McArbBurstTime_MASK 0xff000000
#define MCARB_DRAM_TIMING_TABLE_36__entries_1_5_McArbBurstTime__SHIFT 0x18
#define MCARB_DRAM_TIMING_TABLE_37__entries_2_0_McArbDramTiming_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_37__entries_2_0_McArbDramTiming__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_38__entries_2_0_McArbDramTiming2_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_38__entries_2_0_McArbDramTiming2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_39__entries_2_0_padding_2_MASK 0xff
#define MCARB_DRAM_TIMING_TABLE_39__entries_2_0_padding_2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_39__entries_2_0_padding_1_MASK 0xff00
#define MCARB_DRAM_TIMING_TABLE_39__entries_2_0_padding_1__SHIFT 0x8
#define MCARB_DRAM_TIMING_TABLE_39__entries_2_0_padding_0_MASK 0xff0000
#define MCARB_DRAM_TIMING_TABLE_39__entries_2_0_padding_0__SHIFT 0x10
#define MCARB_DRAM_TIMING_TABLE_39__entries_2_0_McArbBurstTime_MASK 0xff000000
#define MCARB_DRAM_TIMING_TABLE_39__entries_2_0_McArbBurstTime__SHIFT 0x18
#define MCARB_DRAM_TIMING_TABLE_40__entries_2_1_McArbDramTiming_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_40__entries_2_1_McArbDramTiming__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_41__entries_2_1_McArbDramTiming2_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_41__entries_2_1_McArbDramTiming2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_42__entries_2_1_padding_2_MASK 0xff
#define MCARB_DRAM_TIMING_TABLE_42__entries_2_1_padding_2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_42__entries_2_1_padding_1_MASK 0xff00
#define MCARB_DRAM_TIMING_TABLE_42__entries_2_1_padding_1__SHIFT 0x8
#define MCARB_DRAM_TIMING_TABLE_42__entries_2_1_padding_0_MASK 0xff0000
#define MCARB_DRAM_TIMING_TABLE_42__entries_2_1_padding_0__SHIFT 0x10
#define MCARB_DRAM_TIMING_TABLE_42__entries_2_1_McArbBurstTime_MASK 0xff000000
#define MCARB_DRAM_TIMING_TABLE_42__entries_2_1_McArbBurstTime__SHIFT 0x18
#define MCARB_DRAM_TIMING_TABLE_43__entries_2_2_McArbDramTiming_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_43__entries_2_2_McArbDramTiming__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_44__entries_2_2_McArbDramTiming2_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_44__entries_2_2_McArbDramTiming2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_45__entries_2_2_padding_2_MASK 0xff
#define MCARB_DRAM_TIMING_TABLE_45__entries_2_2_padding_2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_45__entries_2_2_padding_1_MASK 0xff00
#define MCARB_DRAM_TIMING_TABLE_45__entries_2_2_padding_1__SHIFT 0x8
#define MCARB_DRAM_TIMING_TABLE_45__entries_2_2_padding_0_MASK 0xff0000
#define MCARB_DRAM_TIMING_TABLE_45__entries_2_2_padding_0__SHIFT 0x10
#define MCARB_DRAM_TIMING_TABLE_45__entries_2_2_McArbBurstTime_MASK 0xff000000
#define MCARB_DRAM_TIMING_TABLE_45__entries_2_2_McArbBurstTime__SHIFT 0x18
#define MCARB_DRAM_TIMING_TABLE_46__entries_2_3_McArbDramTiming_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_46__entries_2_3_McArbDramTiming__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_47__entries_2_3_McArbDramTiming2_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_47__entries_2_3_McArbDramTiming2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_48__entries_2_3_padding_2_MASK 0xff
#define MCARB_DRAM_TIMING_TABLE_48__entries_2_3_padding_2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_48__entries_2_3_padding_1_MASK 0xff00
#define MCARB_DRAM_TIMING_TABLE_48__entries_2_3_padding_1__SHIFT 0x8
#define MCARB_DRAM_TIMING_TABLE_48__entries_2_3_padding_0_MASK 0xff0000
#define MCARB_DRAM_TIMING_TABLE_48__entries_2_3_padding_0__SHIFT 0x10
#define MCARB_DRAM_TIMING_TABLE_48__entries_2_3_McArbBurstTime_MASK 0xff000000
#define MCARB_DRAM_TIMING_TABLE_48__entries_2_3_McArbBurstTime__SHIFT 0x18
#define MCARB_DRAM_TIMING_TABLE_49__entries_2_4_McArbDramTiming_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_49__entries_2_4_McArbDramTiming__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_50__entries_2_4_McArbDramTiming2_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_50__entries_2_4_McArbDramTiming2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_51__entries_2_4_padding_2_MASK 0xff
#define MCARB_DRAM_TIMING_TABLE_51__entries_2_4_padding_2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_51__entries_2_4_padding_1_MASK 0xff00
#define MCARB_DRAM_TIMING_TABLE_51__entries_2_4_padding_1__SHIFT 0x8
#define MCARB_DRAM_TIMING_TABLE_51__entries_2_4_padding_0_MASK 0xff0000
#define MCARB_DRAM_TIMING_TABLE_51__entries_2_4_padding_0__SHIFT 0x10
#define MCARB_DRAM_TIMING_TABLE_51__entries_2_4_McArbBurstTime_MASK 0xff000000
#define MCARB_DRAM_TIMING_TABLE_51__entries_2_4_McArbBurstTime__SHIFT 0x18
#define MCARB_DRAM_TIMING_TABLE_52__entries_2_5_McArbDramTiming_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_52__entries_2_5_McArbDramTiming__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_53__entries_2_5_McArbDramTiming2_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_53__entries_2_5_McArbDramTiming2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_54__entries_2_5_padding_2_MASK 0xff
#define MCARB_DRAM_TIMING_TABLE_54__entries_2_5_padding_2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_54__entries_2_5_padding_1_MASK 0xff00
#define MCARB_DRAM_TIMING_TABLE_54__entries_2_5_padding_1__SHIFT 0x8
#define MCARB_DRAM_TIMING_TABLE_54__entries_2_5_padding_0_MASK 0xff0000
#define MCARB_DRAM_TIMING_TABLE_54__entries_2_5_padding_0__SHIFT 0x10
#define MCARB_DRAM_TIMING_TABLE_54__entries_2_5_McArbBurstTime_MASK 0xff000000
#define MCARB_DRAM_TIMING_TABLE_54__entries_2_5_McArbBurstTime__SHIFT 0x18
#define MCARB_DRAM_TIMING_TABLE_55__entries_3_0_McArbDramTiming_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_55__entries_3_0_McArbDramTiming__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_56__entries_3_0_McArbDramTiming2_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_56__entries_3_0_McArbDramTiming2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_57__entries_3_0_padding_2_MASK 0xff
#define MCARB_DRAM_TIMING_TABLE_57__entries_3_0_padding_2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_57__entries_3_0_padding_1_MASK 0xff00
#define MCARB_DRAM_TIMING_TABLE_57__entries_3_0_padding_1__SHIFT 0x8
#define MCARB_DRAM_TIMING_TABLE_57__entries_3_0_padding_0_MASK 0xff0000
#define MCARB_DRAM_TIMING_TABLE_57__entries_3_0_padding_0__SHIFT 0x10
#define MCARB_DRAM_TIMING_TABLE_57__entries_3_0_McArbBurstTime_MASK 0xff000000
#define MCARB_DRAM_TIMING_TABLE_57__entries_3_0_McArbBurstTime__SHIFT 0x18
#define MCARB_DRAM_TIMING_TABLE_58__entries_3_1_McArbDramTiming_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_58__entries_3_1_McArbDramTiming__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_59__entries_3_1_McArbDramTiming2_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_59__entries_3_1_McArbDramTiming2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_60__entries_3_1_padding_2_MASK 0xff
#define MCARB_DRAM_TIMING_TABLE_60__entries_3_1_padding_2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_60__entries_3_1_padding_1_MASK 0xff00
#define MCARB_DRAM_TIMING_TABLE_60__entries_3_1_padding_1__SHIFT 0x8
#define MCARB_DRAM_TIMING_TABLE_60__entries_3_1_padding_0_MASK 0xff0000
#define MCARB_DRAM_TIMING_TABLE_60__entries_3_1_padding_0__SHIFT 0x10
#define MCARB_DRAM_TIMING_TABLE_60__entries_3_1_McArbBurstTime_MASK 0xff000000
#define MCARB_DRAM_TIMING_TABLE_60__entries_3_1_McArbBurstTime__SHIFT 0x18
#define MCARB_DRAM_TIMING_TABLE_61__entries_3_2_McArbDramTiming_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_61__entries_3_2_McArbDramTiming__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_62__entries_3_2_McArbDramTiming2_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_62__entries_3_2_McArbDramTiming2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_63__entries_3_2_padding_2_MASK 0xff
#define MCARB_DRAM_TIMING_TABLE_63__entries_3_2_padding_2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_63__entries_3_2_padding_1_MASK 0xff00
#define MCARB_DRAM_TIMING_TABLE_63__entries_3_2_padding_1__SHIFT 0x8
#define MCARB_DRAM_TIMING_TABLE_63__entries_3_2_padding_0_MASK 0xff0000
#define MCARB_DRAM_TIMING_TABLE_63__entries_3_2_padding_0__SHIFT 0x10
#define MCARB_DRAM_TIMING_TABLE_63__entries_3_2_McArbBurstTime_MASK 0xff000000
#define MCARB_DRAM_TIMING_TABLE_63__entries_3_2_McArbBurstTime__SHIFT 0x18
#define MCARB_DRAM_TIMING_TABLE_64__entries_3_3_McArbDramTiming_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_64__entries_3_3_McArbDramTiming__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_65__entries_3_3_McArbDramTiming2_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_65__entries_3_3_McArbDramTiming2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_66__entries_3_3_padding_2_MASK 0xff
#define MCARB_DRAM_TIMING_TABLE_66__entries_3_3_padding_2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_66__entries_3_3_padding_1_MASK 0xff00
#define MCARB_DRAM_TIMING_TABLE_66__entries_3_3_padding_1__SHIFT 0x8
#define MCARB_DRAM_TIMING_TABLE_66__entries_3_3_padding_0_MASK 0xff0000
#define MCARB_DRAM_TIMING_TABLE_66__entries_3_3_padding_0__SHIFT 0x10
#define MCARB_DRAM_TIMING_TABLE_66__entries_3_3_McArbBurstTime_MASK 0xff000000
#define MCARB_DRAM_TIMING_TABLE_66__entries_3_3_McArbBurstTime__SHIFT 0x18
#define MCARB_DRAM_TIMING_TABLE_67__entries_3_4_McArbDramTiming_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_67__entries_3_4_McArbDramTiming__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_68__entries_3_4_McArbDramTiming2_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_68__entries_3_4_McArbDramTiming2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_69__entries_3_4_padding_2_MASK 0xff
#define MCARB_DRAM_TIMING_TABLE_69__entries_3_4_padding_2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_69__entries_3_4_padding_1_MASK 0xff00
#define MCARB_DRAM_TIMING_TABLE_69__entries_3_4_padding_1__SHIFT 0x8
#define MCARB_DRAM_TIMING_TABLE_69__entries_3_4_padding_0_MASK 0xff0000
#define MCARB_DRAM_TIMING_TABLE_69__entries_3_4_padding_0__SHIFT 0x10
#define MCARB_DRAM_TIMING_TABLE_69__entries_3_4_McArbBurstTime_MASK 0xff000000
#define MCARB_DRAM_TIMING_TABLE_69__entries_3_4_McArbBurstTime__SHIFT 0x18
#define MCARB_DRAM_TIMING_TABLE_70__entries_3_5_McArbDramTiming_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_70__entries_3_5_McArbDramTiming__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_71__entries_3_5_McArbDramTiming2_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_71__entries_3_5_McArbDramTiming2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_72__entries_3_5_padding_2_MASK 0xff
#define MCARB_DRAM_TIMING_TABLE_72__entries_3_5_padding_2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_72__entries_3_5_padding_1_MASK 0xff00
#define MCARB_DRAM_TIMING_TABLE_72__entries_3_5_padding_1__SHIFT 0x8
#define MCARB_DRAM_TIMING_TABLE_72__entries_3_5_padding_0_MASK 0xff0000
#define MCARB_DRAM_TIMING_TABLE_72__entries_3_5_padding_0__SHIFT 0x10
#define MCARB_DRAM_TIMING_TABLE_72__entries_3_5_McArbBurstTime_MASK 0xff000000
#define MCARB_DRAM_TIMING_TABLE_72__entries_3_5_McArbBurstTime__SHIFT 0x18
#define MCARB_DRAM_TIMING_TABLE_73__entries_4_0_McArbDramTiming_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_73__entries_4_0_McArbDramTiming__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_74__entries_4_0_McArbDramTiming2_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_74__entries_4_0_McArbDramTiming2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_75__entries_4_0_padding_2_MASK 0xff
#define MCARB_DRAM_TIMING_TABLE_75__entries_4_0_padding_2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_75__entries_4_0_padding_1_MASK 0xff00
#define MCARB_DRAM_TIMING_TABLE_75__entries_4_0_padding_1__SHIFT 0x8
#define MCARB_DRAM_TIMING_TABLE_75__entries_4_0_padding_0_MASK 0xff0000
#define MCARB_DRAM_TIMING_TABLE_75__entries_4_0_padding_0__SHIFT 0x10
#define MCARB_DRAM_TIMING_TABLE_75__entries_4_0_McArbBurstTime_MASK 0xff000000
#define MCARB_DRAM_TIMING_TABLE_75__entries_4_0_McArbBurstTime__SHIFT 0x18
#define MCARB_DRAM_TIMING_TABLE_76__entries_4_1_McArbDramTiming_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_76__entries_4_1_McArbDramTiming__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_77__entries_4_1_McArbDramTiming2_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_77__entries_4_1_McArbDramTiming2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_78__entries_4_1_padding_2_MASK 0xff
#define MCARB_DRAM_TIMING_TABLE_78__entries_4_1_padding_2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_78__entries_4_1_padding_1_MASK 0xff00
#define MCARB_DRAM_TIMING_TABLE_78__entries_4_1_padding_1__SHIFT 0x8
#define MCARB_DRAM_TIMING_TABLE_78__entries_4_1_padding_0_MASK 0xff0000
#define MCARB_DRAM_TIMING_TABLE_78__entries_4_1_padding_0__SHIFT 0x10
#define MCARB_DRAM_TIMING_TABLE_78__entries_4_1_McArbBurstTime_MASK 0xff000000
#define MCARB_DRAM_TIMING_TABLE_78__entries_4_1_McArbBurstTime__SHIFT 0x18
#define MCARB_DRAM_TIMING_TABLE_79__entries_4_2_McArbDramTiming_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_79__entries_4_2_McArbDramTiming__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_80__entries_4_2_McArbDramTiming2_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_80__entries_4_2_McArbDramTiming2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_81__entries_4_2_padding_2_MASK 0xff
#define MCARB_DRAM_TIMING_TABLE_81__entries_4_2_padding_2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_81__entries_4_2_padding_1_MASK 0xff00
#define MCARB_DRAM_TIMING_TABLE_81__entries_4_2_padding_1__SHIFT 0x8
#define MCARB_DRAM_TIMING_TABLE_81__entries_4_2_padding_0_MASK 0xff0000
#define MCARB_DRAM_TIMING_TABLE_81__entries_4_2_padding_0__SHIFT 0x10
#define MCARB_DRAM_TIMING_TABLE_81__entries_4_2_McArbBurstTime_MASK 0xff000000
#define MCARB_DRAM_TIMING_TABLE_81__entries_4_2_McArbBurstTime__SHIFT 0x18
#define MCARB_DRAM_TIMING_TABLE_82__entries_4_3_McArbDramTiming_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_82__entries_4_3_McArbDramTiming__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_83__entries_4_3_McArbDramTiming2_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_83__entries_4_3_McArbDramTiming2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_84__entries_4_3_padding_2_MASK 0xff
#define MCARB_DRAM_TIMING_TABLE_84__entries_4_3_padding_2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_84__entries_4_3_padding_1_MASK 0xff00
#define MCARB_DRAM_TIMING_TABLE_84__entries_4_3_padding_1__SHIFT 0x8
#define MCARB_DRAM_TIMING_TABLE_84__entries_4_3_padding_0_MASK 0xff0000
#define MCARB_DRAM_TIMING_TABLE_84__entries_4_3_padding_0__SHIFT 0x10
#define MCARB_DRAM_TIMING_TABLE_84__entries_4_3_McArbBurstTime_MASK 0xff000000
#define MCARB_DRAM_TIMING_TABLE_84__entries_4_3_McArbBurstTime__SHIFT 0x18
#define MCARB_DRAM_TIMING_TABLE_85__entries_4_4_McArbDramTiming_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_85__entries_4_4_McArbDramTiming__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_86__entries_4_4_McArbDramTiming2_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_86__entries_4_4_McArbDramTiming2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_87__entries_4_4_padding_2_MASK 0xff
#define MCARB_DRAM_TIMING_TABLE_87__entries_4_4_padding_2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_87__entries_4_4_padding_1_MASK 0xff00
#define MCARB_DRAM_TIMING_TABLE_87__entries_4_4_padding_1__SHIFT 0x8
#define MCARB_DRAM_TIMING_TABLE_87__entries_4_4_padding_0_MASK 0xff0000
#define MCARB_DRAM_TIMING_TABLE_87__entries_4_4_padding_0__SHIFT 0x10
#define MCARB_DRAM_TIMING_TABLE_87__entries_4_4_McArbBurstTime_MASK 0xff000000
#define MCARB_DRAM_TIMING_TABLE_87__entries_4_4_McArbBurstTime__SHIFT 0x18
#define MCARB_DRAM_TIMING_TABLE_88__entries_4_5_McArbDramTiming_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_88__entries_4_5_McArbDramTiming__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_89__entries_4_5_McArbDramTiming2_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_89__entries_4_5_McArbDramTiming2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_90__entries_4_5_padding_2_MASK 0xff
#define MCARB_DRAM_TIMING_TABLE_90__entries_4_5_padding_2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_90__entries_4_5_padding_1_MASK 0xff00
#define MCARB_DRAM_TIMING_TABLE_90__entries_4_5_padding_1__SHIFT 0x8
#define MCARB_DRAM_TIMING_TABLE_90__entries_4_5_padding_0_MASK 0xff0000
#define MCARB_DRAM_TIMING_TABLE_90__entries_4_5_padding_0__SHIFT 0x10
#define MCARB_DRAM_TIMING_TABLE_90__entries_4_5_McArbBurstTime_MASK 0xff000000
#define MCARB_DRAM_TIMING_TABLE_90__entries_4_5_McArbBurstTime__SHIFT 0x18
#define MCARB_DRAM_TIMING_TABLE_91__entries_5_0_McArbDramTiming_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_91__entries_5_0_McArbDramTiming__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_92__entries_5_0_McArbDramTiming2_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_92__entries_5_0_McArbDramTiming2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_93__entries_5_0_padding_2_MASK 0xff
#define MCARB_DRAM_TIMING_TABLE_93__entries_5_0_padding_2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_93__entries_5_0_padding_1_MASK 0xff00
#define MCARB_DRAM_TIMING_TABLE_93__entries_5_0_padding_1__SHIFT 0x8
#define MCARB_DRAM_TIMING_TABLE_93__entries_5_0_padding_0_MASK 0xff0000
#define MCARB_DRAM_TIMING_TABLE_93__entries_5_0_padding_0__SHIFT 0x10
#define MCARB_DRAM_TIMING_TABLE_93__entries_5_0_McArbBurstTime_MASK 0xff000000
#define MCARB_DRAM_TIMING_TABLE_93__entries_5_0_McArbBurstTime__SHIFT 0x18
#define MCARB_DRAM_TIMING_TABLE_94__entries_5_1_McArbDramTiming_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_94__entries_5_1_McArbDramTiming__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_95__entries_5_1_McArbDramTiming2_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_95__entries_5_1_McArbDramTiming2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_96__entries_5_1_padding_2_MASK 0xff
#define MCARB_DRAM_TIMING_TABLE_96__entries_5_1_padding_2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_96__entries_5_1_padding_1_MASK 0xff00
#define MCARB_DRAM_TIMING_TABLE_96__entries_5_1_padding_1__SHIFT 0x8
#define MCARB_DRAM_TIMING_TABLE_96__entries_5_1_padding_0_MASK 0xff0000
#define MCARB_DRAM_TIMING_TABLE_96__entries_5_1_padding_0__SHIFT 0x10
#define MCARB_DRAM_TIMING_TABLE_96__entries_5_1_McArbBurstTime_MASK 0xff000000
#define MCARB_DRAM_TIMING_TABLE_96__entries_5_1_McArbBurstTime__SHIFT 0x18
#define MCARB_DRAM_TIMING_TABLE_97__entries_5_2_McArbDramTiming_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_97__entries_5_2_McArbDramTiming__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_98__entries_5_2_McArbDramTiming2_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_98__entries_5_2_McArbDramTiming2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_99__entries_5_2_padding_2_MASK 0xff
#define MCARB_DRAM_TIMING_TABLE_99__entries_5_2_padding_2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_99__entries_5_2_padding_1_MASK 0xff00
#define MCARB_DRAM_TIMING_TABLE_99__entries_5_2_padding_1__SHIFT 0x8
#define MCARB_DRAM_TIMING_TABLE_99__entries_5_2_padding_0_MASK 0xff0000
#define MCARB_DRAM_TIMING_TABLE_99__entries_5_2_padding_0__SHIFT 0x10
#define MCARB_DRAM_TIMING_TABLE_99__entries_5_2_McArbBurstTime_MASK 0xff000000
#define MCARB_DRAM_TIMING_TABLE_99__entries_5_2_McArbBurstTime__SHIFT 0x18
#define MCARB_DRAM_TIMING_TABLE_100__entries_5_3_McArbDramTiming_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_100__entries_5_3_McArbDramTiming__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_101__entries_5_3_McArbDramTiming2_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_101__entries_5_3_McArbDramTiming2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_102__entries_5_3_padding_2_MASK 0xff
#define MCARB_DRAM_TIMING_TABLE_102__entries_5_3_padding_2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_102__entries_5_3_padding_1_MASK 0xff00
#define MCARB_DRAM_TIMING_TABLE_102__entries_5_3_padding_1__SHIFT 0x8
#define MCARB_DRAM_TIMING_TABLE_102__entries_5_3_padding_0_MASK 0xff0000
#define MCARB_DRAM_TIMING_TABLE_102__entries_5_3_padding_0__SHIFT 0x10
#define MCARB_DRAM_TIMING_TABLE_102__entries_5_3_McArbBurstTime_MASK 0xff000000
#define MCARB_DRAM_TIMING_TABLE_102__entries_5_3_McArbBurstTime__SHIFT 0x18
#define MCARB_DRAM_TIMING_TABLE_103__entries_5_4_McArbDramTiming_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_103__entries_5_4_McArbDramTiming__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_104__entries_5_4_McArbDramTiming2_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_104__entries_5_4_McArbDramTiming2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_105__entries_5_4_padding_2_MASK 0xff
#define MCARB_DRAM_TIMING_TABLE_105__entries_5_4_padding_2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_105__entries_5_4_padding_1_MASK 0xff00
#define MCARB_DRAM_TIMING_TABLE_105__entries_5_4_padding_1__SHIFT 0x8
#define MCARB_DRAM_TIMING_TABLE_105__entries_5_4_padding_0_MASK 0xff0000
#define MCARB_DRAM_TIMING_TABLE_105__entries_5_4_padding_0__SHIFT 0x10
#define MCARB_DRAM_TIMING_TABLE_105__entries_5_4_McArbBurstTime_MASK 0xff000000
#define MCARB_DRAM_TIMING_TABLE_105__entries_5_4_McArbBurstTime__SHIFT 0x18
#define MCARB_DRAM_TIMING_TABLE_106__entries_5_5_McArbDramTiming_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_106__entries_5_5_McArbDramTiming__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_107__entries_5_5_McArbDramTiming2_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_107__entries_5_5_McArbDramTiming2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_108__entries_5_5_padding_2_MASK 0xff
#define MCARB_DRAM_TIMING_TABLE_108__entries_5_5_padding_2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_108__entries_5_5_padding_1_MASK 0xff00
#define MCARB_DRAM_TIMING_TABLE_108__entries_5_5_padding_1__SHIFT 0x8
#define MCARB_DRAM_TIMING_TABLE_108__entries_5_5_padding_0_MASK 0xff0000
#define MCARB_DRAM_TIMING_TABLE_108__entries_5_5_padding_0__SHIFT 0x10
#define MCARB_DRAM_TIMING_TABLE_108__entries_5_5_McArbBurstTime_MASK 0xff000000
#define MCARB_DRAM_TIMING_TABLE_108__entries_5_5_McArbBurstTime__SHIFT 0x18
#define MCARB_DRAM_TIMING_TABLE_109__entries_6_0_McArbDramTiming_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_109__entries_6_0_McArbDramTiming__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_110__entries_6_0_McArbDramTiming2_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_110__entries_6_0_McArbDramTiming2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_111__entries_6_0_padding_2_MASK 0xff
#define MCARB_DRAM_TIMING_TABLE_111__entries_6_0_padding_2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_111__entries_6_0_padding_1_MASK 0xff00
#define MCARB_DRAM_TIMING_TABLE_111__entries_6_0_padding_1__SHIFT 0x8
#define MCARB_DRAM_TIMING_TABLE_111__entries_6_0_padding_0_MASK 0xff0000
#define MCARB_DRAM_TIMING_TABLE_111__entries_6_0_padding_0__SHIFT 0x10
#define MCARB_DRAM_TIMING_TABLE_111__entries_6_0_McArbBurstTime_MASK 0xff000000
#define MCARB_DRAM_TIMING_TABLE_111__entries_6_0_McArbBurstTime__SHIFT 0x18
#define MCARB_DRAM_TIMING_TABLE_112__entries_6_1_McArbDramTiming_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_112__entries_6_1_McArbDramTiming__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_113__entries_6_1_McArbDramTiming2_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_113__entries_6_1_McArbDramTiming2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_114__entries_6_1_padding_2_MASK 0xff
#define MCARB_DRAM_TIMING_TABLE_114__entries_6_1_padding_2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_114__entries_6_1_padding_1_MASK 0xff00
#define MCARB_DRAM_TIMING_TABLE_114__entries_6_1_padding_1__SHIFT 0x8
#define MCARB_DRAM_TIMING_TABLE_114__entries_6_1_padding_0_MASK 0xff0000
#define MCARB_DRAM_TIMING_TABLE_114__entries_6_1_padding_0__SHIFT 0x10
#define MCARB_DRAM_TIMING_TABLE_114__entries_6_1_McArbBurstTime_MASK 0xff000000
#define MCARB_DRAM_TIMING_TABLE_114__entries_6_1_McArbBurstTime__SHIFT 0x18
#define MCARB_DRAM_TIMING_TABLE_115__entries_6_2_McArbDramTiming_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_115__entries_6_2_McArbDramTiming__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_116__entries_6_2_McArbDramTiming2_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_116__entries_6_2_McArbDramTiming2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_117__entries_6_2_padding_2_MASK 0xff
#define MCARB_DRAM_TIMING_TABLE_117__entries_6_2_padding_2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_117__entries_6_2_padding_1_MASK 0xff00
#define MCARB_DRAM_TIMING_TABLE_117__entries_6_2_padding_1__SHIFT 0x8
#define MCARB_DRAM_TIMING_TABLE_117__entries_6_2_padding_0_MASK 0xff0000
#define MCARB_DRAM_TIMING_TABLE_117__entries_6_2_padding_0__SHIFT 0x10
#define MCARB_DRAM_TIMING_TABLE_117__entries_6_2_McArbBurstTime_MASK 0xff000000
#define MCARB_DRAM_TIMING_TABLE_117__entries_6_2_McArbBurstTime__SHIFT 0x18
#define MCARB_DRAM_TIMING_TABLE_118__entries_6_3_McArbDramTiming_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_118__entries_6_3_McArbDramTiming__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_119__entries_6_3_McArbDramTiming2_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_119__entries_6_3_McArbDramTiming2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_120__entries_6_3_padding_2_MASK 0xff
#define MCARB_DRAM_TIMING_TABLE_120__entries_6_3_padding_2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_120__entries_6_3_padding_1_MASK 0xff00
#define MCARB_DRAM_TIMING_TABLE_120__entries_6_3_padding_1__SHIFT 0x8
#define MCARB_DRAM_TIMING_TABLE_120__entries_6_3_padding_0_MASK 0xff0000
#define MCARB_DRAM_TIMING_TABLE_120__entries_6_3_padding_0__SHIFT 0x10
#define MCARB_DRAM_TIMING_TABLE_120__entries_6_3_McArbBurstTime_MASK 0xff000000
#define MCARB_DRAM_TIMING_TABLE_120__entries_6_3_McArbBurstTime__SHIFT 0x18
#define MCARB_DRAM_TIMING_TABLE_121__entries_6_4_McArbDramTiming_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_121__entries_6_4_McArbDramTiming__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_122__entries_6_4_McArbDramTiming2_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_122__entries_6_4_McArbDramTiming2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_123__entries_6_4_padding_2_MASK 0xff
#define MCARB_DRAM_TIMING_TABLE_123__entries_6_4_padding_2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_123__entries_6_4_padding_1_MASK 0xff00
#define MCARB_DRAM_TIMING_TABLE_123__entries_6_4_padding_1__SHIFT 0x8
#define MCARB_DRAM_TIMING_TABLE_123__entries_6_4_padding_0_MASK 0xff0000
#define MCARB_DRAM_TIMING_TABLE_123__entries_6_4_padding_0__SHIFT 0x10
#define MCARB_DRAM_TIMING_TABLE_123__entries_6_4_McArbBurstTime_MASK 0xff000000
#define MCARB_DRAM_TIMING_TABLE_123__entries_6_4_McArbBurstTime__SHIFT 0x18
#define MCARB_DRAM_TIMING_TABLE_124__entries_6_5_McArbDramTiming_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_124__entries_6_5_McArbDramTiming__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_125__entries_6_5_McArbDramTiming2_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_125__entries_6_5_McArbDramTiming2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_126__entries_6_5_padding_2_MASK 0xff
#define MCARB_DRAM_TIMING_TABLE_126__entries_6_5_padding_2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_126__entries_6_5_padding_1_MASK 0xff00
#define MCARB_DRAM_TIMING_TABLE_126__entries_6_5_padding_1__SHIFT 0x8
#define MCARB_DRAM_TIMING_TABLE_126__entries_6_5_padding_0_MASK 0xff0000
#define MCARB_DRAM_TIMING_TABLE_126__entries_6_5_padding_0__SHIFT 0x10
#define MCARB_DRAM_TIMING_TABLE_126__entries_6_5_McArbBurstTime_MASK 0xff000000
#define MCARB_DRAM_TIMING_TABLE_126__entries_6_5_McArbBurstTime__SHIFT 0x18
#define MCARB_DRAM_TIMING_TABLE_127__entries_7_0_McArbDramTiming_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_127__entries_7_0_McArbDramTiming__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_128__entries_7_0_McArbDramTiming2_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_128__entries_7_0_McArbDramTiming2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_129__entries_7_0_padding_2_MASK 0xff
#define MCARB_DRAM_TIMING_TABLE_129__entries_7_0_padding_2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_129__entries_7_0_padding_1_MASK 0xff00
#define MCARB_DRAM_TIMING_TABLE_129__entries_7_0_padding_1__SHIFT 0x8
#define MCARB_DRAM_TIMING_TABLE_129__entries_7_0_padding_0_MASK 0xff0000
#define MCARB_DRAM_TIMING_TABLE_129__entries_7_0_padding_0__SHIFT 0x10
#define MCARB_DRAM_TIMING_TABLE_129__entries_7_0_McArbBurstTime_MASK 0xff000000
#define MCARB_DRAM_TIMING_TABLE_129__entries_7_0_McArbBurstTime__SHIFT 0x18
#define MCARB_DRAM_TIMING_TABLE_130__entries_7_1_McArbDramTiming_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_130__entries_7_1_McArbDramTiming__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_131__entries_7_1_McArbDramTiming2_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_131__entries_7_1_McArbDramTiming2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_132__entries_7_1_padding_2_MASK 0xff
#define MCARB_DRAM_TIMING_TABLE_132__entries_7_1_padding_2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_132__entries_7_1_padding_1_MASK 0xff00
#define MCARB_DRAM_TIMING_TABLE_132__entries_7_1_padding_1__SHIFT 0x8
#define MCARB_DRAM_TIMING_TABLE_132__entries_7_1_padding_0_MASK 0xff0000
#define MCARB_DRAM_TIMING_TABLE_132__entries_7_1_padding_0__SHIFT 0x10
#define MCARB_DRAM_TIMING_TABLE_132__entries_7_1_McArbBurstTime_MASK 0xff000000
#define MCARB_DRAM_TIMING_TABLE_132__entries_7_1_McArbBurstTime__SHIFT 0x18
#define MCARB_DRAM_TIMING_TABLE_133__entries_7_2_McArbDramTiming_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_133__entries_7_2_McArbDramTiming__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_134__entries_7_2_McArbDramTiming2_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_134__entries_7_2_McArbDramTiming2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_135__entries_7_2_padding_2_MASK 0xff
#define MCARB_DRAM_TIMING_TABLE_135__entries_7_2_padding_2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_135__entries_7_2_padding_1_MASK 0xff00
#define MCARB_DRAM_TIMING_TABLE_135__entries_7_2_padding_1__SHIFT 0x8
#define MCARB_DRAM_TIMING_TABLE_135__entries_7_2_padding_0_MASK 0xff0000
#define MCARB_DRAM_TIMING_TABLE_135__entries_7_2_padding_0__SHIFT 0x10
#define MCARB_DRAM_TIMING_TABLE_135__entries_7_2_McArbBurstTime_MASK 0xff000000
#define MCARB_DRAM_TIMING_TABLE_135__entries_7_2_McArbBurstTime__SHIFT 0x18
#define MCARB_DRAM_TIMING_TABLE_136__entries_7_3_McArbDramTiming_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_136__entries_7_3_McArbDramTiming__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_137__entries_7_3_McArbDramTiming2_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_137__entries_7_3_McArbDramTiming2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_138__entries_7_3_padding_2_MASK 0xff
#define MCARB_DRAM_TIMING_TABLE_138__entries_7_3_padding_2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_138__entries_7_3_padding_1_MASK 0xff00
#define MCARB_DRAM_TIMING_TABLE_138__entries_7_3_padding_1__SHIFT 0x8
#define MCARB_DRAM_TIMING_TABLE_138__entries_7_3_padding_0_MASK 0xff0000
#define MCARB_DRAM_TIMING_TABLE_138__entries_7_3_padding_0__SHIFT 0x10
#define MCARB_DRAM_TIMING_TABLE_138__entries_7_3_McArbBurstTime_MASK 0xff000000
#define MCARB_DRAM_TIMING_TABLE_138__entries_7_3_McArbBurstTime__SHIFT 0x18
#define MCARB_DRAM_TIMING_TABLE_139__entries_7_4_McArbDramTiming_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_139__entries_7_4_McArbDramTiming__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_140__entries_7_4_McArbDramTiming2_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_140__entries_7_4_McArbDramTiming2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_141__entries_7_4_padding_2_MASK 0xff
#define MCARB_DRAM_TIMING_TABLE_141__entries_7_4_padding_2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_141__entries_7_4_padding_1_MASK 0xff00
#define MCARB_DRAM_TIMING_TABLE_141__entries_7_4_padding_1__SHIFT 0x8
#define MCARB_DRAM_TIMING_TABLE_141__entries_7_4_padding_0_MASK 0xff0000
#define MCARB_DRAM_TIMING_TABLE_141__entries_7_4_padding_0__SHIFT 0x10
#define MCARB_DRAM_TIMING_TABLE_141__entries_7_4_McArbBurstTime_MASK 0xff000000
#define MCARB_DRAM_TIMING_TABLE_141__entries_7_4_McArbBurstTime__SHIFT 0x18
#define MCARB_DRAM_TIMING_TABLE_142__entries_7_5_McArbDramTiming_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_142__entries_7_5_McArbDramTiming__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_143__entries_7_5_McArbDramTiming2_MASK 0xffffffff
#define MCARB_DRAM_TIMING_TABLE_143__entries_7_5_McArbDramTiming2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_144__entries_7_5_padding_2_MASK 0xff
#define MCARB_DRAM_TIMING_TABLE_144__entries_7_5_padding_2__SHIFT 0x0
#define MCARB_DRAM_TIMING_TABLE_144__entries_7_5_padding_1_MASK 0xff00
#define MCARB_DRAM_TIMING_TABLE_144__entries_7_5_padding_1__SHIFT 0x8
#define MCARB_DRAM_TIMING_TABLE_144__entries_7_5_padding_0_MASK 0xff0000
#define MCARB_DRAM_TIMING_TABLE_144__entries_7_5_padding_0__SHIFT 0x10
#define MCARB_DRAM_TIMING_TABLE_144__entries_7_5_McArbBurstTime_MASK 0xff000000
#define MCARB_DRAM_TIMING_TABLE_144__entries_7_5_McArbBurstTime__SHIFT 0x18
#define MC_REGISTERS_TABLE_1__reserved_2_MASK 0xff
#define MC_REGISTERS_TABLE_1__reserved_2__SHIFT 0x0
#define MC_REGISTERS_TABLE_1__reserved_1_MASK 0xff00
#define MC_REGISTERS_TABLE_1__reserved_1__SHIFT 0x8
#define MC_REGISTERS_TABLE_1__reserved_0_MASK 0xff0000
#define MC_REGISTERS_TABLE_1__reserved_0__SHIFT 0x10
#define MC_REGISTERS_TABLE_1__last_MASK 0xff000000
#define MC_REGISTERS_TABLE_1__last__SHIFT 0x18
#define MC_REGISTERS_TABLE_2__address_0_s1_MASK 0xffff
#define MC_REGISTERS_TABLE_2__address_0_s1__SHIFT 0x0
#define MC_REGISTERS_TABLE_2__address_0_s0_MASK 0xffff0000
#define MC_REGISTERS_TABLE_2__address_0_s0__SHIFT 0x10
#define MC_REGISTERS_TABLE_3__address_1_s1_MASK 0xffff
#define MC_REGISTERS_TABLE_3__address_1_s1__SHIFT 0x0
#define MC_REGISTERS_TABLE_3__address_1_s0_MASK 0xffff0000
#define MC_REGISTERS_TABLE_3__address_1_s0__SHIFT 0x10
#define MC_REGISTERS_TABLE_4__address_2_s1_MASK 0xffff
#define MC_REGISTERS_TABLE_4__address_2_s1__SHIFT 0x0
#define MC_REGISTERS_TABLE_4__address_2_s0_MASK 0xffff0000
#define MC_REGISTERS_TABLE_4__address_2_s0__SHIFT 0x10
#define MC_REGISTERS_TABLE_5__address_3_s1_MASK 0xffff
#define MC_REGISTERS_TABLE_5__address_3_s1__SHIFT 0x0
#define MC_REGISTERS_TABLE_5__address_3_s0_MASK 0xffff0000
#define MC_REGISTERS_TABLE_5__address_3_s0__SHIFT 0x10
#define MC_REGISTERS_TABLE_6__address_4_s1_MASK 0xffff
#define MC_REGISTERS_TABLE_6__address_4_s1__SHIFT 0x0
#define MC_REGISTERS_TABLE_6__address_4_s0_MASK 0xffff0000
#define MC_REGISTERS_TABLE_6__address_4_s0__SHIFT 0x10
#define MC_REGISTERS_TABLE_7__address_5_s1_MASK 0xffff
#define MC_REGISTERS_TABLE_7__address_5_s1__SHIFT 0x0
#define MC_REGISTERS_TABLE_7__address_5_s0_MASK 0xffff0000
#define MC_REGISTERS_TABLE_7__address_5_s0__SHIFT 0x10
#define MC_REGISTERS_TABLE_8__address_6_s1_MASK 0xffff
#define MC_REGISTERS_TABLE_8__address_6_s1__SHIFT 0x0
#define MC_REGISTERS_TABLE_8__address_6_s0_MASK 0xffff0000
#define MC_REGISTERS_TABLE_8__address_6_s0__SHIFT 0x10
#define MC_REGISTERS_TABLE_9__address_7_s1_MASK 0xffff
#define MC_REGISTERS_TABLE_9__address_7_s1__SHIFT 0x0
#define MC_REGISTERS_TABLE_9__address_7_s0_MASK 0xffff0000
#define MC_REGISTERS_TABLE_9__address_7_s0__SHIFT 0x10
#define MC_REGISTERS_TABLE_10__address_8_s1_MASK 0xffff
#define MC_REGISTERS_TABLE_10__address_8_s1__SHIFT 0x0
#define MC_REGISTERS_TABLE_10__address_8_s0_MASK 0xffff0000
#define MC_REGISTERS_TABLE_10__address_8_s0__SHIFT 0x10
#define MC_REGISTERS_TABLE_11__address_9_s1_MASK 0xffff
#define MC_REGISTERS_TABLE_11__address_9_s1__SHIFT 0x0
#define MC_REGISTERS_TABLE_11__address_9_s0_MASK 0xffff0000
#define MC_REGISTERS_TABLE_11__address_9_s0__SHIFT 0x10
#define MC_REGISTERS_TABLE_12__address_10_s1_MASK 0xffff
#define MC_REGISTERS_TABLE_12__address_10_s1__SHIFT 0x0
#define MC_REGISTERS_TABLE_12__address_10_s0_MASK 0xffff0000
#define MC_REGISTERS_TABLE_12__address_10_s0__SHIFT 0x10
#define MC_REGISTERS_TABLE_13__address_11_s1_MASK 0xffff
#define MC_REGISTERS_TABLE_13__address_11_s1__SHIFT 0x0
#define MC_REGISTERS_TABLE_13__address_11_s0_MASK 0xffff0000
#define MC_REGISTERS_TABLE_13__address_11_s0__SHIFT 0x10
#define MC_REGISTERS_TABLE_14__address_12_s1_MASK 0xffff
#define MC_REGISTERS_TABLE_14__address_12_s1__SHIFT 0x0
#define MC_REGISTERS_TABLE_14__address_12_s0_MASK 0xffff0000
#define MC_REGISTERS_TABLE_14__address_12_s0__SHIFT 0x10
#define MC_REGISTERS_TABLE_15__address_13_s1_MASK 0xffff
#define MC_REGISTERS_TABLE_15__address_13_s1__SHIFT 0x0
#define MC_REGISTERS_TABLE_15__address_13_s0_MASK 0xffff0000
#define MC_REGISTERS_TABLE_15__address_13_s0__SHIFT 0x10
#define MC_REGISTERS_TABLE_16__address_14_s1_MASK 0xffff
#define MC_REGISTERS_TABLE_16__address_14_s1__SHIFT 0x0
#define MC_REGISTERS_TABLE_16__address_14_s0_MASK 0xffff0000
#define MC_REGISTERS_TABLE_16__address_14_s0__SHIFT 0x10
#define MC_REGISTERS_TABLE_17__address_15_s1_MASK 0xffff
#define MC_REGISTERS_TABLE_17__address_15_s1__SHIFT 0x0
#define MC_REGISTERS_TABLE_17__address_15_s0_MASK 0xffff0000
#define MC_REGISTERS_TABLE_17__address_15_s0__SHIFT 0x10
#define MC_REGISTERS_TABLE_18__data_0_value_0_MASK 0xffffffff
#define MC_REGISTERS_TABLE_18__data_0_value_0__SHIFT 0x0
#define MC_REGISTERS_TABLE_19__data_0_value_1_MASK 0xffffffff
#define MC_REGISTERS_TABLE_19__data_0_value_1__SHIFT 0x0
#define MC_REGISTERS_TABLE_20__data_0_value_2_MASK 0xffffffff
#define MC_REGISTERS_TABLE_20__data_0_value_2__SHIFT 0x0
#define MC_REGISTERS_TABLE_21__data_0_value_3_MASK 0xffffffff
#define MC_REGISTERS_TABLE_21__data_0_value_3__SHIFT 0x0
#define MC_REGISTERS_TABLE_22__data_0_value_4_MASK 0xffffffff
#define MC_REGISTERS_TABLE_22__data_0_value_4__SHIFT 0x0
#define MC_REGISTERS_TABLE_23__data_0_value_5_MASK 0xffffffff
#define MC_REGISTERS_TABLE_23__data_0_value_5__SHIFT 0x0
#define MC_REGISTERS_TABLE_24__data_0_value_6_MASK 0xffffffff
#define MC_REGISTERS_TABLE_24__data_0_value_6__SHIFT 0x0
#define MC_REGISTERS_TABLE_25__data_0_value_7_MASK 0xffffffff
#define MC_REGISTERS_TABLE_25__data_0_value_7__SHIFT 0x0
#define MC_REGISTERS_TABLE_26__data_0_value_8_MASK 0xffffffff
#define MC_REGISTERS_TABLE_26__data_0_value_8__SHIFT 0x0
#define MC_REGISTERS_TABLE_27__data_0_value_9_MASK 0xffffffff
#define MC_REGISTERS_TABLE_27__data_0_value_9__SHIFT 0x0
#define MC_REGISTERS_TABLE_28__data_0_value_10_MASK 0xffffffff
#define MC_REGISTERS_TABLE_28__data_0_value_10__SHIFT 0x0
#define MC_REGISTERS_TABLE_29__data_0_value_11_MASK 0xffffffff
#define MC_REGISTERS_TABLE_29__data_0_value_11__SHIFT 0x0
#define MC_REGISTERS_TABLE_30__data_0_value_12_MASK 0xffffffff
#define MC_REGISTERS_TABLE_30__data_0_value_12__SHIFT 0x0
#define MC_REGISTERS_TABLE_31__data_0_value_13_MASK 0xffffffff
#define MC_REGISTERS_TABLE_31__data_0_value_13__SHIFT 0x0
#define MC_REGISTERS_TABLE_32__data_0_value_14_MASK 0xffffffff
#define MC_REGISTERS_TABLE_32__data_0_value_14__SHIFT 0x0
#define MC_REGISTERS_TABLE_33__data_0_value_15_MASK 0xffffffff
#define MC_REGISTERS_TABLE_33__data_0_value_15__SHIFT 0x0
#define MC_REGISTERS_TABLE_34__data_1_value_0_MASK 0xffffffff
#define MC_REGISTERS_TABLE_34__data_1_value_0__SHIFT 0x0
#define MC_REGISTERS_TABLE_35__data_1_value_1_MASK 0xffffffff
#define MC_REGISTERS_TABLE_35__data_1_value_1__SHIFT 0x0
#define MC_REGISTERS_TABLE_36__data_1_value_2_MASK 0xffffffff
#define MC_REGISTERS_TABLE_36__data_1_value_2__SHIFT 0x0
#define MC_REGISTERS_TABLE_37__data_1_value_3_MASK 0xffffffff
#define MC_REGISTERS_TABLE_37__data_1_value_3__SHIFT 0x0
#define MC_REGISTERS_TABLE_38__data_1_value_4_MASK 0xffffffff
#define MC_REGISTERS_TABLE_38__data_1_value_4__SHIFT 0x0
#define MC_REGISTERS_TABLE_39__data_1_value_5_MASK 0xffffffff
#define MC_REGISTERS_TABLE_39__data_1_value_5__SHIFT 0x0
#define MC_REGISTERS_TABLE_40__data_1_value_6_MASK 0xffffffff
#define MC_REGISTERS_TABLE_40__data_1_value_6__SHIFT 0x0
#define MC_REGISTERS_TABLE_41__data_1_value_7_MASK 0xffffffff
#define MC_REGISTERS_TABLE_41__data_1_value_7__SHIFT 0x0
#define MC_REGISTERS_TABLE_42__data_1_value_8_MASK 0xffffffff
#define MC_REGISTERS_TABLE_42__data_1_value_8__SHIFT 0x0
#define MC_REGISTERS_TABLE_43__data_1_value_9_MASK 0xffffffff
#define MC_REGISTERS_TABLE_43__data_1_value_9__SHIFT 0x0
#define MC_REGISTERS_TABLE_44__data_1_value_10_MASK 0xffffffff
#define MC_REGISTERS_TABLE_44__data_1_value_10__SHIFT 0x0
#define MC_REGISTERS_TABLE_45__data_1_value_11_MASK 0xffffffff
#define MC_REGISTERS_TABLE_45__data_1_value_11__SHIFT 0x0
#define MC_REGISTERS_TABLE_46__data_1_value_12_MASK 0xffffffff
#define MC_REGISTERS_TABLE_46__data_1_value_12__SHIFT 0x0
#define MC_REGISTERS_TABLE_47__data_1_value_13_MASK 0xffffffff
#define MC_REGISTERS_TABLE_47__data_1_value_13__SHIFT 0x0
#define MC_REGISTERS_TABLE_48__data_1_value_14_MASK 0xffffffff
#define MC_REGISTERS_TABLE_48__data_1_value_14__SHIFT 0x0
#define MC_REGISTERS_TABLE_49__data_1_value_15_MASK 0xffffffff
#define MC_REGISTERS_TABLE_49__data_1_value_15__SHIFT 0x0
#define MC_REGISTERS_TABLE_50__data_2_value_0_MASK 0xffffffff
#define MC_REGISTERS_TABLE_50__data_2_value_0__SHIFT 0x0
#define MC_REGISTERS_TABLE_51__data_2_value_1_MASK 0xffffffff
#define MC_REGISTERS_TABLE_51__data_2_value_1__SHIFT 0x0
#define MC_REGISTERS_TABLE_52__data_2_value_2_MASK 0xffffffff
#define MC_REGISTERS_TABLE_52__data_2_value_2__SHIFT 0x0
#define MC_REGISTERS_TABLE_53__data_2_value_3_MASK 0xffffffff
#define MC_REGISTERS_TABLE_53__data_2_value_3__SHIFT 0x0
#define MC_REGISTERS_TABLE_54__data_2_value_4_MASK 0xffffffff
#define MC_REGISTERS_TABLE_54__data_2_value_4__SHIFT 0x0
#define MC_REGISTERS_TABLE_55__data_2_value_5_MASK 0xffffffff
#define MC_REGISTERS_TABLE_55__data_2_value_5__SHIFT 0x0
#define MC_REGISTERS_TABLE_56__data_2_value_6_MASK 0xffffffff
#define MC_REGISTERS_TABLE_56__data_2_value_6__SHIFT 0x0
#define MC_REGISTERS_TABLE_57__data_2_value_7_MASK 0xffffffff
#define MC_REGISTERS_TABLE_57__data_2_value_7__SHIFT 0x0
#define MC_REGISTERS_TABLE_58__data_2_value_8_MASK 0xffffffff
#define MC_REGISTERS_TABLE_58__data_2_value_8__SHIFT 0x0
#define MC_REGISTERS_TABLE_59__data_2_value_9_MASK 0xffffffff
#define MC_REGISTERS_TABLE_59__data_2_value_9__SHIFT 0x0
#define MC_REGISTERS_TABLE_60__data_2_value_10_MASK 0xffffffff
#define MC_REGISTERS_TABLE_60__data_2_value_10__SHIFT 0x0
#define MC_REGISTERS_TABLE_61__data_2_value_11_MASK 0xffffffff
#define MC_REGISTERS_TABLE_61__data_2_value_11__SHIFT 0x0
#define MC_REGISTERS_TABLE_62__data_2_value_12_MASK 0xffffffff
#define MC_REGISTERS_TABLE_62__data_2_value_12__SHIFT 0x0
#define MC_REGISTERS_TABLE_63__data_2_value_13_MASK 0xffffffff
#define MC_REGISTERS_TABLE_63__data_2_value_13__SHIFT 0x0
#define MC_REGISTERS_TABLE_64__data_2_value_14_MASK 0xffffffff
#define MC_REGISTERS_TABLE_64__data_2_value_14__SHIFT 0x0
#define MC_REGISTERS_TABLE_65__data_2_value_15_MASK 0xffffffff
#define MC_REGISTERS_TABLE_65__data_2_value_15__SHIFT 0x0
#define MC_REGISTERS_TABLE_66__data_3_value_0_MASK 0xffffffff
#define MC_REGISTERS_TABLE_66__data_3_value_0__SHIFT 0x0
#define MC_REGISTERS_TABLE_67__data_3_value_1_MASK 0xffffffff
#define MC_REGISTERS_TABLE_67__data_3_value_1__SHIFT 0x0
#define MC_REGISTERS_TABLE_68__data_3_value_2_MASK 0xffffffff
#define MC_REGISTERS_TABLE_68__data_3_value_2__SHIFT 0x0
#define MC_REGISTERS_TABLE_69__data_3_value_3_MASK 0xffffffff
#define MC_REGISTERS_TABLE_69__data_3_value_3__SHIFT 0x0
#define MC_REGISTERS_TABLE_70__data_3_value_4_MASK 0xffffffff
#define MC_REGISTERS_TABLE_70__data_3_value_4__SHIFT 0x0
#define MC_REGISTERS_TABLE_71__data_3_value_5_MASK 0xffffffff
#define MC_REGISTERS_TABLE_71__data_3_value_5__SHIFT 0x0
#define MC_REGISTERS_TABLE_72__data_3_value_6_MASK 0xffffffff
#define MC_REGISTERS_TABLE_72__data_3_value_6__SHIFT 0x0
#define MC_REGISTERS_TABLE_73__data_3_value_7_MASK 0xffffffff
#define MC_REGISTERS_TABLE_73__data_3_value_7__SHIFT 0x0
#define MC_REGISTERS_TABLE_74__data_3_value_8_MASK 0xffffffff
#define MC_REGISTERS_TABLE_74__data_3_value_8__SHIFT 0x0
#define MC_REGISTERS_TABLE_75__data_3_value_9_MASK 0xffffffff
#define MC_REGISTERS_TABLE_75__data_3_value_9__SHIFT 0x0
#define MC_REGISTERS_TABLE_76__data_3_value_10_MASK 0xffffffff
#define MC_REGISTERS_TABLE_76__data_3_value_10__SHIFT 0x0
#define MC_REGISTERS_TABLE_77__data_3_value_11_MASK 0xffffffff
#define MC_REGISTERS_TABLE_77__data_3_value_11__SHIFT 0x0
#define MC_REGISTERS_TABLE_78__data_3_value_12_MASK 0xffffffff
#define MC_REGISTERS_TABLE_78__data_3_value_12__SHIFT 0x0
#define MC_REGISTERS_TABLE_79__data_3_value_13_MASK 0xffffffff
#define MC_REGISTERS_TABLE_79__data_3_value_13__SHIFT 0x0
#define MC_REGISTERS_TABLE_80__data_3_value_14_MASK 0xffffffff
#define MC_REGISTERS_TABLE_80__data_3_value_14__SHIFT 0x0
#define MC_REGISTERS_TABLE_81__data_3_value_15_MASK 0xffffffff
#define MC_REGISTERS_TABLE_81__data_3_value_15__SHIFT 0x0
#define MC_REGISTERS_TABLE_82__data_4_value_0_MASK 0xffffffff
#define MC_REGISTERS_TABLE_82__data_4_value_0__SHIFT 0x0
#define MC_REGISTERS_TABLE_83__data_4_value_1_MASK 0xffffffff
#define MC_REGISTERS_TABLE_83__data_4_value_1__SHIFT 0x0
#define MC_REGISTERS_TABLE_84__data_4_value_2_MASK 0xffffffff
#define MC_REGISTERS_TABLE_84__data_4_value_2__SHIFT 0x0
#define MC_REGISTERS_TABLE_85__data_4_value_3_MASK 0xffffffff
#define MC_REGISTERS_TABLE_85__data_4_value_3__SHIFT 0x0
#define MC_REGISTERS_TABLE_86__data_4_value_4_MASK 0xffffffff
#define MC_REGISTERS_TABLE_86__data_4_value_4__SHIFT 0x0
#define MC_REGISTERS_TABLE_87__data_4_value_5_MASK 0xffffffff
#define MC_REGISTERS_TABLE_87__data_4_value_5__SHIFT 0x0
#define MC_REGISTERS_TABLE_88__data_4_value_6_MASK 0xffffffff
#define MC_REGISTERS_TABLE_88__data_4_value_6__SHIFT 0x0
#define MC_REGISTERS_TABLE_89__data_4_value_7_MASK 0xffffffff
#define MC_REGISTERS_TABLE_89__data_4_value_7__SHIFT 0x0
#define MC_REGISTERS_TABLE_90__data_4_value_8_MASK 0xffffffff
#define MC_REGISTERS_TABLE_90__data_4_value_8__SHIFT 0x0
#define MC_REGISTERS_TABLE_91__data_4_value_9_MASK 0xffffffff
#define MC_REGISTERS_TABLE_91__data_4_value_9__SHIFT 0x0
#define MC_REGISTERS_TABLE_92__data_4_value_10_MASK 0xffffffff
#define MC_REGISTERS_TABLE_92__data_4_value_10__SHIFT 0x0
#define MC_REGISTERS_TABLE_93__data_4_value_11_MASK 0xffffffff
#define MC_REGISTERS_TABLE_93__data_4_value_11__SHIFT 0x0
#define MC_REGISTERS_TABLE_94__data_4_value_12_MASK 0xffffffff
#define MC_REGISTERS_TABLE_94__data_4_value_12__SHIFT 0x0
#define MC_REGISTERS_TABLE_95__data_4_value_13_MASK 0xffffffff
#define MC_REGISTERS_TABLE_95__data_4_value_13__SHIFT 0x0
#define MC_REGISTERS_TABLE_96__data_4_value_14_MASK 0xffffffff
#define MC_REGISTERS_TABLE_96__data_4_value_14__SHIFT 0x0
#define MC_REGISTERS_TABLE_97__data_4_value_15_MASK 0xffffffff
#define MC_REGISTERS_TABLE_97__data_4_value_15__SHIFT 0x0
#define MC_REGISTERS_TABLE_98__data_5_value_0_MASK 0xffffffff
#define MC_REGISTERS_TABLE_98__data_5_value_0__SHIFT 0x0
#define MC_REGISTERS_TABLE_99__data_5_value_1_MASK 0xffffffff
#define MC_REGISTERS_TABLE_99__data_5_value_1__SHIFT 0x0
#define MC_REGISTERS_TABLE_100__data_5_value_2_MASK 0xffffffff
#define MC_REGISTERS_TABLE_100__data_5_value_2__SHIFT 0x0
#define MC_REGISTERS_TABLE_101__data_5_value_3_MASK 0xffffffff
#define MC_REGISTERS_TABLE_101__data_5_value_3__SHIFT 0x0
#define MC_REGISTERS_TABLE_102__data_5_value_4_MASK 0xffffffff
#define MC_REGISTERS_TABLE_102__data_5_value_4__SHIFT 0x0
#define MC_REGISTERS_TABLE_103__data_5_value_5_MASK 0xffffffff
#define MC_REGISTERS_TABLE_103__data_5_value_5__SHIFT 0x0
#define MC_REGISTERS_TABLE_104__data_5_value_6_MASK 0xffffffff
#define MC_REGISTERS_TABLE_104__data_5_value_6__SHIFT 0x0
#define MC_REGISTERS_TABLE_105__data_5_value_7_MASK 0xffffffff
#define MC_REGISTERS_TABLE_105__data_5_value_7__SHIFT 0x0
#define MC_REGISTERS_TABLE_106__data_5_value_8_MASK 0xffffffff
#define MC_REGISTERS_TABLE_106__data_5_value_8__SHIFT 0x0
#define MC_REGISTERS_TABLE_107__data_5_value_9_MASK 0xffffffff
#define MC_REGISTERS_TABLE_107__data_5_value_9__SHIFT 0x0
#define MC_REGISTERS_TABLE_108__data_5_value_10_MASK 0xffffffff
#define MC_REGISTERS_TABLE_108__data_5_value_10__SHIFT 0x0
#define MC_REGISTERS_TABLE_109__data_5_value_11_MASK 0xffffffff
#define MC_REGISTERS_TABLE_109__data_5_value_11__SHIFT 0x0
#define MC_REGISTERS_TABLE_110__data_5_value_12_MASK 0xffffffff
#define MC_REGISTERS_TABLE_110__data_5_value_12__SHIFT 0x0
#define MC_REGISTERS_TABLE_111__data_5_value_13_MASK 0xffffffff
#define MC_REGISTERS_TABLE_111__data_5_value_13__SHIFT 0x0
#define MC_REGISTERS_TABLE_112__data_5_value_14_MASK 0xffffffff
#define MC_REGISTERS_TABLE_112__data_5_value_14__SHIFT 0x0
#define MC_REGISTERS_TABLE_113__data_5_value_15_MASK 0xffffffff
#define MC_REGISTERS_TABLE_113__data_5_value_15__SHIFT 0x0
#define FAN_TABLE_1__TempMin_MASK 0xffff
#define FAN_TABLE_1__TempMin__SHIFT 0x0
#define FAN_TABLE_1__FdoMode_MASK 0xffff0000
#define FAN_TABLE_1__FdoMode__SHIFT 0x10
#define FAN_TABLE_2__TempMax_MASK 0xffff
#define FAN_TABLE_2__TempMax__SHIFT 0x0
#define FAN_TABLE_2__TempMed_MASK 0xffff0000
#define FAN_TABLE_2__TempMed__SHIFT 0x10
#define FAN_TABLE_3__Slope2_MASK 0xffff
#define FAN_TABLE_3__Slope2__SHIFT 0x0
#define FAN_TABLE_3__Slope1_MASK 0xffff0000
#define FAN_TABLE_3__Slope1__SHIFT 0x10
#define FAN_TABLE_4__HystUp_MASK 0xffff
#define FAN_TABLE_4__HystUp__SHIFT 0x0
#define FAN_TABLE_4__FdoMin_MASK 0xffff0000
#define FAN_TABLE_4__FdoMin__SHIFT 0x10
#define FAN_TABLE_5__HystSlope_MASK 0xffff
#define FAN_TABLE_5__HystSlope__SHIFT 0x0
#define FAN_TABLE_5__HystDown_MASK 0xffff0000
#define FAN_TABLE_5__HystDown__SHIFT 0x10
#define FAN_TABLE_6__TempCurr_MASK 0xffff
#define FAN_TABLE_6__TempCurr__SHIFT 0x0
#define FAN_TABLE_6__TempRespLim_MASK 0xffff0000
#define FAN_TABLE_6__TempRespLim__SHIFT 0x10
#define FAN_TABLE_7__PwmCurr_MASK 0xffff
#define FAN_TABLE_7__PwmCurr__SHIFT 0x0
#define FAN_TABLE_7__SlopeCurr_MASK 0xffff0000
#define FAN_TABLE_7__SlopeCurr__SHIFT 0x10
#define FAN_TABLE_8__RefreshPeriod_MASK 0xffffffff
#define FAN_TABLE_8__RefreshPeriod__SHIFT 0x0
#define FAN_TABLE_9__Padding_MASK 0xff
#define FAN_TABLE_9__Padding__SHIFT 0x0
#define FAN_TABLE_9__TempSrc_MASK 0xff00
#define FAN_TABLE_9__TempSrc__SHIFT 0x8
#define FAN_TABLE_9__FdoMax_MASK 0xffff0000
#define FAN_TABLE_9__FdoMax__SHIFT 0x10
#define SOFT_REGISTERS_TABLE_1__RefClockFrequency_MASK 0xffffffff
#define SOFT_REGISTERS_TABLE_1__RefClockFrequency__SHIFT 0x0
#define SOFT_REGISTERS_TABLE_2__PmTimerPeriod_MASK 0xffffffff
#define SOFT_REGISTERS_TABLE_2__PmTimerPeriod__SHIFT 0x0
#define SOFT_REGISTERS_TABLE_3__FeatureEnables_MASK 0xffffffff
#define SOFT_REGISTERS_TABLE_3__FeatureEnables__SHIFT 0x0
#define SOFT_REGISTERS_TABLE_4__PreVBlankGap_MASK 0xffffffff
#define SOFT_REGISTERS_TABLE_4__PreVBlankGap__SHIFT 0x0
#define SOFT_REGISTERS_TABLE_5__VBlankTimeout_MASK 0xffffffff
#define SOFT_REGISTERS_TABLE_5__VBlankTimeout__SHIFT 0x0
#define SOFT_REGISTERS_TABLE_6__TrainTimeGap_MASK 0xffffffff
#define SOFT_REGISTERS_TABLE_6__TrainTimeGap__SHIFT 0x0
#define SOFT_REGISTERS_TABLE_7__MvddSwitchTime_MASK 0xffffffff
#define SOFT_REGISTERS_TABLE_7__MvddSwitchTime__SHIFT 0x0
#define SOFT_REGISTERS_TABLE_8__LongestAcpiTrainTime_MASK 0xffffffff
#define SOFT_REGISTERS_TABLE_8__LongestAcpiTrainTime__SHIFT 0x0
#define SOFT_REGISTERS_TABLE_9__AcpiDelay_MASK 0xffffffff
#define SOFT_REGISTERS_TABLE_9__AcpiDelay__SHIFT 0x0
#define SOFT_REGISTERS_TABLE_10__G5TrainTime_MASK 0xffffffff
#define SOFT_REGISTERS_TABLE_10__G5TrainTime__SHIFT 0x0
#define SOFT_REGISTERS_TABLE_11__DelayMpllPwron_MASK 0xffffffff
#define SOFT_REGISTERS_TABLE_11__DelayMpllPwron__SHIFT 0x0
#define SOFT_REGISTERS_TABLE_12__VoltageChangeTimeout_MASK 0xffffffff
#define SOFT_REGISTERS_TABLE_12__VoltageChangeTimeout__SHIFT 0x0
#define SOFT_REGISTERS_TABLE_13__HandshakeDisables_MASK 0xffffffff
#define SOFT_REGISTERS_TABLE_13__HandshakeDisables__SHIFT 0x0
#define SOFT_REGISTERS_TABLE_14__DisplayPhy4Config_MASK 0xff
#define SOFT_REGISTERS_TABLE_14__DisplayPhy4Config__SHIFT 0x0
#define SOFT_REGISTERS_TABLE_14__DisplayPhy3Config_MASK 0xff00
#define SOFT_REGISTERS_TABLE_14__DisplayPhy3Config__SHIFT 0x8
#define SOFT_REGISTERS_TABLE_14__DisplayPhy2Config_MASK 0xff0000
#define SOFT_REGISTERS_TABLE_14__DisplayPhy2Config__SHIFT 0x10
#define SOFT_REGISTERS_TABLE_14__DisplayPhy1Config_MASK 0xff000000
#define SOFT_REGISTERS_TABLE_14__DisplayPhy1Config__SHIFT 0x18
#define SOFT_REGISTERS_TABLE_15__DisplayPhy8Config_MASK 0xff
#define SOFT_REGISTERS_TABLE_15__DisplayPhy8Config__SHIFT 0x0
#define SOFT_REGISTERS_TABLE_15__DisplayPhy7Config_MASK 0xff00
#define SOFT_REGISTERS_TABLE_15__DisplayPhy7Config__SHIFT 0x8
#define SOFT_REGISTERS_TABLE_15__DisplayPhy6Config_MASK 0xff0000
#define SOFT_REGISTERS_TABLE_15__DisplayPhy6Config__SHIFT 0x10
#define SOFT_REGISTERS_TABLE_15__DisplayPhy5Config_MASK 0xff000000
#define SOFT_REGISTERS_TABLE_15__DisplayPhy5Config__SHIFT 0x18
#define SOFT_REGISTERS_TABLE_16__AverageGraphicsActivity_MASK 0xffffffff
#define SOFT_REGISTERS_TABLE_16__AverageGraphicsActivity__SHIFT 0x0
#define SOFT_REGISTERS_TABLE_17__AverageMemoryActivity_MASK 0xffffffff
#define SOFT_REGISTERS_TABLE_17__AverageMemoryActivity__SHIFT 0x0
#define SOFT_REGISTERS_TABLE_18__AverageGioActivity_MASK 0xffffffff
#define SOFT_REGISTERS_TABLE_18__AverageGioActivity__SHIFT 0x0
#define SOFT_REGISTERS_TABLE_19__PCIeDpmEnabledLevels_MASK 0xff
#define SOFT_REGISTERS_TABLE_19__PCIeDpmEnabledLevels__SHIFT 0x0
#define SOFT_REGISTERS_TABLE_19__LClkDpmEnabledLevels_MASK 0xff00
#define SOFT_REGISTERS_TABLE_19__LClkDpmEnabledLevels__SHIFT 0x8
#define SOFT_REGISTERS_TABLE_19__MClkDpmEnabledLevels_MASK 0xff0000
#define SOFT_REGISTERS_TABLE_19__MClkDpmEnabledLevels__SHIFT 0x10
#define SOFT_REGISTERS_TABLE_19__SClkDpmEnabledLevels_MASK 0xff000000
#define SOFT_REGISTERS_TABLE_19__SClkDpmEnabledLevels__SHIFT 0x18
#define SOFT_REGISTERS_TABLE_20__VCEDpmEnabledLevels_MASK 0xff
#define SOFT_REGISTERS_TABLE_20__VCEDpmEnabledLevels__SHIFT 0x0
#define SOFT_REGISTERS_TABLE_20__ACPDpmEnabledLevels_MASK 0xff00
#define SOFT_REGISTERS_TABLE_20__ACPDpmEnabledLevels__SHIFT 0x8
#define SOFT_REGISTERS_TABLE_20__SAMUDpmEnabledLevels_MASK 0xff0000
#define SOFT_REGISTERS_TABLE_20__SAMUDpmEnabledLevels__SHIFT 0x10
#define SOFT_REGISTERS_TABLE_20__UVDDpmEnabledLevels_MASK 0xff000000
#define SOFT_REGISTERS_TABLE_20__UVDDpmEnabledLevels__SHIFT 0x18
#define SOFT_REGISTERS_TABLE_21__Reserved_0_MASK 0xffffffff
#define SOFT_REGISTERS_TABLE_21__Reserved_0__SHIFT 0x0
#define SOFT_REGISTERS_TABLE_22__Reserved_1_MASK 0xffffffff
#define SOFT_REGISTERS_TABLE_22__Reserved_1__SHIFT 0x0
#define SOFT_REGISTERS_TABLE_23__Reserved_2_MASK 0xffffffff
#define SOFT_REGISTERS_TABLE_23__Reserved_2__SHIFT 0x0
#define SOFT_REGISTERS_TABLE_24__Reserved_3_MASK 0xffffffff
#define SOFT_REGISTERS_TABLE_24__Reserved_3__SHIFT 0x0
#define SOFT_REGISTERS_TABLE_25__Reserved_4_MASK 0xffffffff
#define SOFT_REGISTERS_TABLE_25__Reserved_4__SHIFT 0x0
#define SOFT_REGISTERS_TABLE_26__Reserved_5_MASK 0xffffffff
#define SOFT_REGISTERS_TABLE_26__Reserved_5__SHIFT 0x0
#define SOFT_REGISTERS_TABLE_27__Reserved_6_MASK 0xffffffff
#define SOFT_REGISTERS_TABLE_27__Reserved_6__SHIFT 0x0
#define SOFT_REGISTERS_TABLE_28__Reserved_7_MASK 0xffffffff
#define SOFT_REGISTERS_TABLE_28__Reserved_7__SHIFT 0x0
#define SOFT_REGISTERS_TABLE_29__Reserved_8_MASK 0xffffffff
#define SOFT_REGISTERS_TABLE_29__Reserved_8__SHIFT 0x0
#define SOFT_REGISTERS_TABLE_30__Reserved_9_MASK 0xffffffff
#define SOFT_REGISTERS_TABLE_30__Reserved_9__SHIFT 0x0
#define PM_FUSES_1__BapmVddCVidHiSidd_3_MASK 0xff
#define PM_FUSES_1__BapmVddCVidHiSidd_3__SHIFT 0x0
#define PM_FUSES_1__BapmVddCVidHiSidd_2_MASK 0xff00
#define PM_FUSES_1__BapmVddCVidHiSidd_2__SHIFT 0x8
#define PM_FUSES_1__BapmVddCVidHiSidd_1_MASK 0xff0000
#define PM_FUSES_1__BapmVddCVidHiSidd_1__SHIFT 0x10
#define PM_FUSES_1__BapmVddCVidHiSidd_0_MASK 0xff000000
#define PM_FUSES_1__BapmVddCVidHiSidd_0__SHIFT 0x18
#define PM_FUSES_2__BapmVddCVidHiSidd_7_MASK 0xff
#define PM_FUSES_2__BapmVddCVidHiSidd_7__SHIFT 0x0
#define PM_FUSES_2__BapmVddCVidHiSidd_6_MASK 0xff00
#define PM_FUSES_2__BapmVddCVidHiSidd_6__SHIFT 0x8
#define PM_FUSES_2__BapmVddCVidHiSidd_5_MASK 0xff0000
#define PM_FUSES_2__BapmVddCVidHiSidd_5__SHIFT 0x10
#define PM_FUSES_2__BapmVddCVidHiSidd_4_MASK 0xff000000
#define PM_FUSES_2__BapmVddCVidHiSidd_4__SHIFT 0x18
#define PM_FUSES_3__BapmVddCVidLoSidd_3_MASK 0xff
#define PM_FUSES_3__BapmVddCVidLoSidd_3__SHIFT 0x0
#define PM_FUSES_3__BapmVddCVidLoSidd_2_MASK 0xff00
#define PM_FUSES_3__BapmVddCVidLoSidd_2__SHIFT 0x8
#define PM_FUSES_3__BapmVddCVidLoSidd_1_MASK 0xff0000
#define PM_FUSES_3__BapmVddCVidLoSidd_1__SHIFT 0x10
#define PM_FUSES_3__BapmVddCVidLoSidd_0_MASK 0xff000000
#define PM_FUSES_3__BapmVddCVidLoSidd_0__SHIFT 0x18
#define PM_FUSES_4__BapmVddCVidLoSidd_7_MASK 0xff
#define PM_FUSES_4__BapmVddCVidLoSidd_7__SHIFT 0x0
#define PM_FUSES_4__BapmVddCVidLoSidd_6_MASK 0xff00
#define PM_FUSES_4__BapmVddCVidLoSidd_6__SHIFT 0x8
#define PM_FUSES_4__BapmVddCVidLoSidd_5_MASK 0xff0000
#define PM_FUSES_4__BapmVddCVidLoSidd_5__SHIFT 0x10
#define PM_FUSES_4__BapmVddCVidLoSidd_4_MASK 0xff000000
#define PM_FUSES_4__BapmVddCVidLoSidd_4__SHIFT 0x18
#define PM_FUSES_5__VddCVid_3_MASK 0xff
#define PM_FUSES_5__VddCVid_3__SHIFT 0x0
#define PM_FUSES_5__VddCVid_2_MASK 0xff00
#define PM_FUSES_5__VddCVid_2__SHIFT 0x8
#define PM_FUSES_5__VddCVid_1_MASK 0xff0000
#define PM_FUSES_5__VddCVid_1__SHIFT 0x10
#define PM_FUSES_5__VddCVid_0_MASK 0xff000000
#define PM_FUSES_5__VddCVid_0__SHIFT 0x18
#define PM_FUSES_6__VddCVid_7_MASK 0xff
#define PM_FUSES_6__VddCVid_7__SHIFT 0x0
#define PM_FUSES_6__VddCVid_6_MASK 0xff00
#define PM_FUSES_6__VddCVid_6__SHIFT 0x8
#define PM_FUSES_6__VddCVid_5_MASK 0xff0000
#define PM_FUSES_6__VddCVid_5__SHIFT 0x10
#define PM_FUSES_6__VddCVid_4_MASK 0xff000000
#define PM_FUSES_6__VddCVid_4__SHIFT 0x18
#define PM_FUSES_7__SviLoadLineOffsetVddC_MASK 0xff
#define PM_FUSES_7__SviLoadLineOffsetVddC__SHIFT 0x0
#define PM_FUSES_7__SviLoadLineTrimVddC_MASK 0xff00
#define PM_FUSES_7__SviLoadLineTrimVddC__SHIFT 0x8
#define PM_FUSES_7__SviLoadLineVddC_MASK 0xff0000
#define PM_FUSES_7__SviLoadLineVddC__SHIFT 0x10
#define PM_FUSES_7__SviLoadLineEn_MASK 0xff000000
#define PM_FUSES_7__SviLoadLineEn__SHIFT 0x18
#define PM_FUSES_8__TDC_MAWt_MASK 0xff
#define PM_FUSES_8__TDC_MAWt__SHIFT 0x0
#define PM_FUSES_8__TDC_VDDC_ThrottleReleaseLimitPerc_MASK 0xff00
#define PM_FUSES_8__TDC_VDDC_ThrottleReleaseLimitPerc__SHIFT 0x8
#define PM_FUSES_8__TDC_VDDC_PkgLimit_MASK 0xffff0000
#define PM_FUSES_8__TDC_VDDC_PkgLimit__SHIFT 0x10
#define PM_FUSES_9__Reserved_MASK 0xff
#define PM_FUSES_9__Reserved__SHIFT 0x0
#define PM_FUSES_9__LPMLTemperatureMax_MASK 0xff00
#define PM_FUSES_9__LPMLTemperatureMax__SHIFT 0x8
#define PM_FUSES_9__LPMLTemperatureMin_MASK 0xff0000
#define PM_FUSES_9__LPMLTemperatureMin__SHIFT 0x10
#define PM_FUSES_9__TdcWaterfallCtl_MASK 0xff000000
#define PM_FUSES_9__TdcWaterfallCtl__SHIFT 0x18
#define PM_FUSES_10__LPMLTemperatureScaler_3_MASK 0xff
#define PM_FUSES_10__LPMLTemperatureScaler_3__SHIFT 0x0
#define PM_FUSES_10__LPMLTemperatureScaler_2_MASK 0xff00
#define PM_FUSES_10__LPMLTemperatureScaler_2__SHIFT 0x8
#define PM_FUSES_10__LPMLTemperatureScaler_1_MASK 0xff0000
#define PM_FUSES_10__LPMLTemperatureScaler_1__SHIFT 0x10
#define PM_FUSES_10__LPMLTemperatureScaler_0_MASK 0xff000000
#define PM_FUSES_10__LPMLTemperatureScaler_0__SHIFT 0x18
#define PM_FUSES_11__LPMLTemperatureScaler_7_MASK 0xff
#define PM_FUSES_11__LPMLTemperatureScaler_7__SHIFT 0x0
#define PM_FUSES_11__LPMLTemperatureScaler_6_MASK 0xff00
#define PM_FUSES_11__LPMLTemperatureScaler_6__SHIFT 0x8
#define PM_FUSES_11__LPMLTemperatureScaler_5_MASK 0xff0000
#define PM_FUSES_11__LPMLTemperatureScaler_5__SHIFT 0x10
#define PM_FUSES_11__LPMLTemperatureScaler_4_MASK 0xff000000
#define PM_FUSES_11__LPMLTemperatureScaler_4__SHIFT 0x18
#define PM_FUSES_12__LPMLTemperatureScaler_11_MASK 0xff
#define PM_FUSES_12__LPMLTemperatureScaler_11__SHIFT 0x0
#define PM_FUSES_12__LPMLTemperatureScaler_10_MASK 0xff00
#define PM_FUSES_12__LPMLTemperatureScaler_10__SHIFT 0x8
#define PM_FUSES_12__LPMLTemperatureScaler_9_MASK 0xff0000
#define PM_FUSES_12__LPMLTemperatureScaler_9__SHIFT 0x10
#define PM_FUSES_12__LPMLTemperatureScaler_8_MASK 0xff000000
#define PM_FUSES_12__LPMLTemperatureScaler_8__SHIFT 0x18
#define PM_FUSES_13__LPMLTemperatureScaler_15_MASK 0xff
#define PM_FUSES_13__LPMLTemperatureScaler_15__SHIFT 0x0
#define PM_FUSES_13__LPMLTemperatureScaler_14_MASK 0xff00
#define PM_FUSES_13__LPMLTemperatureScaler_14__SHIFT 0x8
#define PM_FUSES_13__LPMLTemperatureScaler_13_MASK 0xff0000
#define PM_FUSES_13__LPMLTemperatureScaler_13__SHIFT 0x10
#define PM_FUSES_13__LPMLTemperatureScaler_12_MASK 0xff000000
#define PM_FUSES_13__LPMLTemperatureScaler_12__SHIFT 0x18
#define PM_FUSES_14__GnbLPML_3_MASK 0xff
#define PM_FUSES_14__GnbLPML_3__SHIFT 0x0
#define PM_FUSES_14__GnbLPML_2_MASK 0xff00
#define PM_FUSES_14__GnbLPML_2__SHIFT 0x8
#define PM_FUSES_14__GnbLPML_1_MASK 0xff0000
#define PM_FUSES_14__GnbLPML_1__SHIFT 0x10
#define PM_FUSES_14__GnbLPML_0_MASK 0xff000000
#define PM_FUSES_14__GnbLPML_0__SHIFT 0x18
#define PM_FUSES_15__GnbLPML_7_MASK 0xff
#define PM_FUSES_15__GnbLPML_7__SHIFT 0x0
#define PM_FUSES_15__GnbLPML_6_MASK 0xff00
#define PM_FUSES_15__GnbLPML_6__SHIFT 0x8
#define PM_FUSES_15__GnbLPML_5_MASK 0xff0000
#define PM_FUSES_15__GnbLPML_5__SHIFT 0x10
#define PM_FUSES_15__GnbLPML_4_MASK 0xff000000
#define PM_FUSES_15__GnbLPML_4__SHIFT 0x18
#define PM_FUSES_16__GnbLPML_11_MASK 0xff
#define PM_FUSES_16__GnbLPML_11__SHIFT 0x0
#define PM_FUSES_16__GnbLPML_10_MASK 0xff00
#define PM_FUSES_16__GnbLPML_10__SHIFT 0x8
#define PM_FUSES_16__GnbLPML_9_MASK 0xff0000
#define PM_FUSES_16__GnbLPML_9__SHIFT 0x10
#define PM_FUSES_16__GnbLPML_8_MASK 0xff000000
#define PM_FUSES_16__GnbLPML_8__SHIFT 0x18
#define PM_FUSES_17__GnbLPML_15_MASK 0xff
#define PM_FUSES_17__GnbLPML_15__SHIFT 0x0
#define PM_FUSES_17__GnbLPML_14_MASK 0xff00
#define PM_FUSES_17__GnbLPML_14__SHIFT 0x8
#define PM_FUSES_17__GnbLPML_13_MASK 0xff0000
#define PM_FUSES_17__GnbLPML_13__SHIFT 0x10
#define PM_FUSES_17__GnbLPML_12_MASK 0xff000000
#define PM_FUSES_17__GnbLPML_12__SHIFT 0x18
#define PM_FUSES_18__Reserved1_1_MASK 0xff
#define PM_FUSES_18__Reserved1_1__SHIFT 0x0
#define PM_FUSES_18__Reserved1_0_MASK 0xff00
#define PM_FUSES_18__Reserved1_0__SHIFT 0x8
#define PM_FUSES_18__GnbLPMLMinVid_MASK 0xff0000
#define PM_FUSES_18__GnbLPMLMinVid__SHIFT 0x10
#define PM_FUSES_18__GnbLPMLMaxVid_MASK 0xff000000
#define PM_FUSES_18__GnbLPMLMaxVid__SHIFT 0x18
#define PM_FUSES_19__BapmVddCBaseLeakageLoSidd_MASK 0xffff
#define PM_FUSES_19__BapmVddCBaseLeakageLoSidd__SHIFT 0x0
#define PM_FUSES_19__BapmVddCBaseLeakageHiSidd_MASK 0xffff0000
#define PM_FUSES_19__BapmVddCBaseLeakageHiSidd__SHIFT 0x10
#define SMU_PM_STATUS_0__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_0__DATA__SHIFT 0x0
#define SMU_PM_STATUS_1__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_1__DATA__SHIFT 0x0
#define SMU_PM_STATUS_2__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_2__DATA__SHIFT 0x0
#define SMU_PM_STATUS_3__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_3__DATA__SHIFT 0x0
#define SMU_PM_STATUS_4__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_4__DATA__SHIFT 0x0
#define SMU_PM_STATUS_5__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_5__DATA__SHIFT 0x0
#define SMU_PM_STATUS_6__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_6__DATA__SHIFT 0x0
#define SMU_PM_STATUS_7__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_7__DATA__SHIFT 0x0
#define SMU_PM_STATUS_8__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_8__DATA__SHIFT 0x0
#define SMU_PM_STATUS_9__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_9__DATA__SHIFT 0x0
#define SMU_PM_STATUS_10__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_10__DATA__SHIFT 0x0
#define SMU_PM_STATUS_11__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_11__DATA__SHIFT 0x0
#define SMU_PM_STATUS_12__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_12__DATA__SHIFT 0x0
#define SMU_PM_STATUS_13__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_13__DATA__SHIFT 0x0
#define SMU_PM_STATUS_14__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_14__DATA__SHIFT 0x0
#define SMU_PM_STATUS_15__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_15__DATA__SHIFT 0x0
#define SMU_PM_STATUS_16__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_16__DATA__SHIFT 0x0
#define SMU_PM_STATUS_17__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_17__DATA__SHIFT 0x0
#define SMU_PM_STATUS_18__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_18__DATA__SHIFT 0x0
#define SMU_PM_STATUS_19__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_19__DATA__SHIFT 0x0
#define SMU_PM_STATUS_20__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_20__DATA__SHIFT 0x0
#define SMU_PM_STATUS_21__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_21__DATA__SHIFT 0x0
#define SMU_PM_STATUS_22__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_22__DATA__SHIFT 0x0
#define SMU_PM_STATUS_23__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_23__DATA__SHIFT 0x0
#define SMU_PM_STATUS_24__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_24__DATA__SHIFT 0x0
#define SMU_PM_STATUS_25__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_25__DATA__SHIFT 0x0
#define SMU_PM_STATUS_26__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_26__DATA__SHIFT 0x0
#define SMU_PM_STATUS_27__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_27__DATA__SHIFT 0x0
#define SMU_PM_STATUS_28__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_28__DATA__SHIFT 0x0
#define SMU_PM_STATUS_29__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_29__DATA__SHIFT 0x0
#define SMU_PM_STATUS_30__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_30__DATA__SHIFT 0x0
#define SMU_PM_STATUS_31__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_31__DATA__SHIFT 0x0
#define SMU_PM_STATUS_32__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_32__DATA__SHIFT 0x0
#define SMU_PM_STATUS_33__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_33__DATA__SHIFT 0x0
#define SMU_PM_STATUS_34__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_34__DATA__SHIFT 0x0
#define SMU_PM_STATUS_35__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_35__DATA__SHIFT 0x0
#define SMU_PM_STATUS_36__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_36__DATA__SHIFT 0x0
#define SMU_PM_STATUS_37__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_37__DATA__SHIFT 0x0
#define SMU_PM_STATUS_38__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_38__DATA__SHIFT 0x0
#define SMU_PM_STATUS_39__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_39__DATA__SHIFT 0x0
#define SMU_PM_STATUS_40__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_40__DATA__SHIFT 0x0
#define SMU_PM_STATUS_41__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_41__DATA__SHIFT 0x0
#define SMU_PM_STATUS_42__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_42__DATA__SHIFT 0x0
#define SMU_PM_STATUS_43__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_43__DATA__SHIFT 0x0
#define SMU_PM_STATUS_44__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_44__DATA__SHIFT 0x0
#define SMU_PM_STATUS_45__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_45__DATA__SHIFT 0x0
#define SMU_PM_STATUS_46__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_46__DATA__SHIFT 0x0
#define SMU_PM_STATUS_47__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_47__DATA__SHIFT 0x0
#define SMU_PM_STATUS_48__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_48__DATA__SHIFT 0x0
#define SMU_PM_STATUS_49__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_49__DATA__SHIFT 0x0
#define SMU_PM_STATUS_50__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_50__DATA__SHIFT 0x0
#define SMU_PM_STATUS_51__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_51__DATA__SHIFT 0x0
#define SMU_PM_STATUS_52__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_52__DATA__SHIFT 0x0
#define SMU_PM_STATUS_53__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_53__DATA__SHIFT 0x0
#define SMU_PM_STATUS_54__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_54__DATA__SHIFT 0x0
#define SMU_PM_STATUS_55__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_55__DATA__SHIFT 0x0
#define SMU_PM_STATUS_56__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_56__DATA__SHIFT 0x0
#define SMU_PM_STATUS_57__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_57__DATA__SHIFT 0x0
#define SMU_PM_STATUS_58__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_58__DATA__SHIFT 0x0
#define SMU_PM_STATUS_59__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_59__DATA__SHIFT 0x0
#define SMU_PM_STATUS_60__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_60__DATA__SHIFT 0x0
#define SMU_PM_STATUS_61__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_61__DATA__SHIFT 0x0
#define SMU_PM_STATUS_62__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_62__DATA__SHIFT 0x0
#define SMU_PM_STATUS_63__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_63__DATA__SHIFT 0x0
#define SMU_PM_STATUS_64__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_64__DATA__SHIFT 0x0
#define SMU_PM_STATUS_65__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_65__DATA__SHIFT 0x0
#define SMU_PM_STATUS_66__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_66__DATA__SHIFT 0x0
#define SMU_PM_STATUS_67__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_67__DATA__SHIFT 0x0
#define SMU_PM_STATUS_68__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_68__DATA__SHIFT 0x0
#define SMU_PM_STATUS_69__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_69__DATA__SHIFT 0x0
#define SMU_PM_STATUS_70__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_70__DATA__SHIFT 0x0
#define SMU_PM_STATUS_71__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_71__DATA__SHIFT 0x0
#define SMU_PM_STATUS_72__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_72__DATA__SHIFT 0x0
#define SMU_PM_STATUS_73__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_73__DATA__SHIFT 0x0
#define SMU_PM_STATUS_74__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_74__DATA__SHIFT 0x0
#define SMU_PM_STATUS_75__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_75__DATA__SHIFT 0x0
#define SMU_PM_STATUS_76__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_76__DATA__SHIFT 0x0
#define SMU_PM_STATUS_77__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_77__DATA__SHIFT 0x0
#define SMU_PM_STATUS_78__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_78__DATA__SHIFT 0x0
#define SMU_PM_STATUS_79__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_79__DATA__SHIFT 0x0
#define SMU_PM_STATUS_80__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_80__DATA__SHIFT 0x0
#define SMU_PM_STATUS_81__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_81__DATA__SHIFT 0x0
#define SMU_PM_STATUS_82__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_82__DATA__SHIFT 0x0
#define SMU_PM_STATUS_83__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_83__DATA__SHIFT 0x0
#define SMU_PM_STATUS_84__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_84__DATA__SHIFT 0x0
#define SMU_PM_STATUS_85__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_85__DATA__SHIFT 0x0
#define SMU_PM_STATUS_86__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_86__DATA__SHIFT 0x0
#define SMU_PM_STATUS_87__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_87__DATA__SHIFT 0x0
#define SMU_PM_STATUS_88__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_88__DATA__SHIFT 0x0
#define SMU_PM_STATUS_89__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_89__DATA__SHIFT 0x0
#define SMU_PM_STATUS_90__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_90__DATA__SHIFT 0x0
#define SMU_PM_STATUS_91__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_91__DATA__SHIFT 0x0
#define SMU_PM_STATUS_92__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_92__DATA__SHIFT 0x0
#define SMU_PM_STATUS_93__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_93__DATA__SHIFT 0x0
#define SMU_PM_STATUS_94__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_94__DATA__SHIFT 0x0
#define SMU_PM_STATUS_95__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_95__DATA__SHIFT 0x0
#define SMU_PM_STATUS_96__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_96__DATA__SHIFT 0x0
#define SMU_PM_STATUS_97__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_97__DATA__SHIFT 0x0
#define SMU_PM_STATUS_98__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_98__DATA__SHIFT 0x0
#define SMU_PM_STATUS_99__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_99__DATA__SHIFT 0x0
#define SMU_PM_STATUS_100__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_100__DATA__SHIFT 0x0
#define SMU_PM_STATUS_101__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_101__DATA__SHIFT 0x0
#define SMU_PM_STATUS_102__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_102__DATA__SHIFT 0x0
#define SMU_PM_STATUS_103__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_103__DATA__SHIFT 0x0
#define SMU_PM_STATUS_104__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_104__DATA__SHIFT 0x0
#define SMU_PM_STATUS_105__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_105__DATA__SHIFT 0x0
#define SMU_PM_STATUS_106__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_106__DATA__SHIFT 0x0
#define SMU_PM_STATUS_107__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_107__DATA__SHIFT 0x0
#define SMU_PM_STATUS_108__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_108__DATA__SHIFT 0x0
#define SMU_PM_STATUS_109__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_109__DATA__SHIFT 0x0
#define SMU_PM_STATUS_110__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_110__DATA__SHIFT 0x0
#define SMU_PM_STATUS_111__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_111__DATA__SHIFT 0x0
#define SMU_PM_STATUS_112__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_112__DATA__SHIFT 0x0
#define SMU_PM_STATUS_113__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_113__DATA__SHIFT 0x0
#define SMU_PM_STATUS_114__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_114__DATA__SHIFT 0x0
#define SMU_PM_STATUS_115__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_115__DATA__SHIFT 0x0
#define SMU_PM_STATUS_116__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_116__DATA__SHIFT 0x0
#define SMU_PM_STATUS_117__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_117__DATA__SHIFT 0x0
#define SMU_PM_STATUS_118__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_118__DATA__SHIFT 0x0
#define SMU_PM_STATUS_119__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_119__DATA__SHIFT 0x0
#define SMU_PM_STATUS_120__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_120__DATA__SHIFT 0x0
#define SMU_PM_STATUS_121__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_121__DATA__SHIFT 0x0
#define SMU_PM_STATUS_122__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_122__DATA__SHIFT 0x0
#define SMU_PM_STATUS_123__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_123__DATA__SHIFT 0x0
#define SMU_PM_STATUS_124__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_124__DATA__SHIFT 0x0
#define SMU_PM_STATUS_125__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_125__DATA__SHIFT 0x0
#define SMU_PM_STATUS_126__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_126__DATA__SHIFT 0x0
#define SMU_PM_STATUS_127__DATA_MASK 0xffffffff
#define SMU_PM_STATUS_127__DATA__SHIFT 0x0
#define CG_THERMAL_INT_ENA__THERM_INTH_SET_MASK 0x1
#define CG_THERMAL_INT_ENA__THERM_INTH_SET__SHIFT 0x0
#define CG_THERMAL_INT_ENA__THERM_INTL_SET_MASK 0x2
#define CG_THERMAL_INT_ENA__THERM_INTL_SET__SHIFT 0x1
#define CG_THERMAL_INT_ENA__THERM_TRIGGER_SET_MASK 0x4
#define CG_THERMAL_INT_ENA__THERM_TRIGGER_SET__SHIFT 0x2
#define CG_THERMAL_INT_ENA__THERM_INTH_CLR_MASK 0x8
#define CG_THERMAL_INT_ENA__THERM_INTH_CLR__SHIFT 0x3
#define CG_THERMAL_INT_ENA__THERM_INTL_CLR_MASK 0x10
#define CG_THERMAL_INT_ENA__THERM_INTL_CLR__SHIFT 0x4
#define CG_THERMAL_INT_ENA__THERM_TRIGGER_CLR_MASK 0x20
#define CG_THERMAL_INT_ENA__THERM_TRIGGER_CLR__SHIFT 0x5
#define CG_THERMAL_INT_CTRL__DIG_THERM_INTH_MASK 0xff
#define CG_THERMAL_INT_CTRL__DIG_THERM_INTH__SHIFT 0x0
#define CG_THERMAL_INT_CTRL__DIG_THERM_INTL_MASK 0xff00
#define CG_THERMAL_INT_CTRL__DIG_THERM_INTL__SHIFT 0x8
#define CG_THERMAL_INT_CTRL__GNB_TEMP_THRESHOLD_MASK 0xff0000
#define CG_THERMAL_INT_CTRL__GNB_TEMP_THRESHOLD__SHIFT 0x10
#define CG_THERMAL_INT_CTRL__THERM_INTH_MASK_MASK 0x1000000
#define CG_THERMAL_INT_CTRL__THERM_INTH_MASK__SHIFT 0x18
#define CG_THERMAL_INT_CTRL__THERM_INTL_MASK_MASK 0x2000000
#define CG_THERMAL_INT_CTRL__THERM_INTL_MASK__SHIFT 0x19
#define CG_THERMAL_INT_CTRL__THERM_TRIGGER_MASK_MASK 0x4000000
#define CG_THERMAL_INT_CTRL__THERM_TRIGGER_MASK__SHIFT 0x1a
#define CG_THERMAL_INT_CTRL__THERM_TRIGGER_CNB_MASK_MASK 0x8000000
#define CG_THERMAL_INT_CTRL__THERM_TRIGGER_CNB_MASK__SHIFT 0x1b
#define CG_THERMAL_INT_CTRL__THERM_GNB_HW_ENA_MASK 0x10000000
#define CG_THERMAL_INT_CTRL__THERM_GNB_HW_ENA__SHIFT 0x1c
#define CG_THERMAL_INT_STATUS__THERM_INTH_DETECT_MASK 0x1
#define CG_THERMAL_INT_STATUS__THERM_INTH_DETECT__SHIFT 0x0
#define CG_THERMAL_INT_STATUS__THERM_INTL_DETECT_MASK 0x2
#define CG_THERMAL_INT_STATUS__THERM_INTL_DETECT__SHIFT 0x1
#define CG_THERMAL_INT_STATUS__THERM_TRIGGER_DETECT_MASK 0x4
#define CG_THERMAL_INT_STATUS__THERM_TRIGGER_DETECT__SHIFT 0x2
#define CG_THERMAL_INT_STATUS__THERM_TRIGGER_CNB_DETECT_MASK 0x8
#define CG_THERMAL_INT_STATUS__THERM_TRIGGER_CNB_DETECT__SHIFT 0x3
#define CG_THERMAL_CTRL__DPM_EVENT_SRC_MASK 0x7
#define CG_THERMAL_CTRL__DPM_EVENT_SRC__SHIFT 0x0
#define CG_THERMAL_CTRL__THERM_INC_CLK_MASK 0x8
#define CG_THERMAL_CTRL__THERM_INC_CLK__SHIFT 0x3
#define CG_THERMAL_CTRL__SPARE_MASK 0x3ff0
#define CG_THERMAL_CTRL__SPARE__SHIFT 0x4
#define CG_THERMAL_CTRL__DIG_THERM_DPM_MASK 0x3fc000
#define CG_THERMAL_CTRL__DIG_THERM_DPM__SHIFT 0xe
#define CG_THERMAL_CTRL__RESERVED_MASK 0x1c00000
#define CG_THERMAL_CTRL__RESERVED__SHIFT 0x16
#define CG_THERMAL_CTRL__CTF_PAD_POLARITY_MASK 0x2000000
#define CG_THERMAL_CTRL__CTF_PAD_POLARITY__SHIFT 0x19
#define CG_THERMAL_CTRL__CTF_PAD_EN_MASK 0x4000000
#define CG_THERMAL_CTRL__CTF_PAD_EN__SHIFT 0x1a
#define CG_THERMAL_STATUS__SPARE_MASK 0x1ff
#define CG_THERMAL_STATUS__SPARE__SHIFT 0x0
#define CG_THERMAL_STATUS__FDO_PWM_DUTY_MASK 0x1fe00
#define CG_THERMAL_STATUS__FDO_PWM_DUTY__SHIFT 0x9
#define CG_THERMAL_STATUS__THERM_ALERT_MASK 0x20000
#define CG_THERMAL_STATUS__THERM_ALERT__SHIFT 0x11
#define CG_THERMAL_STATUS__GEN_STATUS_MASK 0x3c0000
#define CG_THERMAL_STATUS__GEN_STATUS__SHIFT 0x12
#define CG_THERMAL_INT__DIG_THERM_CTF_MASK 0xff
#define CG_THERMAL_INT__DIG_THERM_CTF__SHIFT 0x0
#define CG_THERMAL_INT__DIG_THERM_INTH_MASK 0xff00
#define CG_THERMAL_INT__DIG_THERM_INTH__SHIFT 0x8
#define CG_THERMAL_INT__DIG_THERM_INTL_MASK 0xff0000
#define CG_THERMAL_INT__DIG_THERM_INTL__SHIFT 0x10
#define CG_THERMAL_INT__THERM_INT_MASK_MASK 0xf000000
#define CG_THERMAL_INT__THERM_INT_MASK__SHIFT 0x18
#define CG_MULT_THERMAL_CTRL__TS_FILTER_MASK 0xf
#define CG_MULT_THERMAL_CTRL__TS_FILTER__SHIFT 0x0
#define CG_MULT_THERMAL_CTRL__UNUSED_MASK 0xf0
#define CG_MULT_THERMAL_CTRL__UNUSED__SHIFT 0x4
#define CG_MULT_THERMAL_CTRL__THERMAL_RANGE_RST_MASK 0x200
#define CG_MULT_THERMAL_CTRL__THERMAL_RANGE_RST__SHIFT 0x9
#define CG_MULT_THERMAL_CTRL__TEMP_SEL_MASK 0xff00000
#define CG_MULT_THERMAL_CTRL__TEMP_SEL__SHIFT 0x14
#define CG_MULT_THERMAL_STATUS__ASIC_MAX_TEMP_MASK 0x1ff
#define CG_MULT_THERMAL_STATUS__ASIC_MAX_TEMP__SHIFT 0x0
#define CG_MULT_THERMAL_STATUS__CTF_TEMP_MASK 0x3fe00
#define CG_MULT_THERMAL_STATUS__CTF_TEMP__SHIFT 0x9
#define CG_FDO_CTRL0__FDO_STATIC_DUTY_MASK 0xff
#define CG_FDO_CTRL0__FDO_STATIC_DUTY__SHIFT 0x0
#define CG_FDO_CTRL0__FAN_SPINUP_DUTY_MASK 0xff00
#define CG_FDO_CTRL0__FAN_SPINUP_DUTY__SHIFT 0x8
#define CG_FDO_CTRL0__FDO_PWM_MANUAL_MASK 0x10000
#define CG_FDO_CTRL0__FDO_PWM_MANUAL__SHIFT 0x10
#define CG_FDO_CTRL0__FDO_PWM_HYSTER_MASK 0x7e0000
#define CG_FDO_CTRL0__FDO_PWM_HYSTER__SHIFT 0x11
#define CG_FDO_CTRL0__FDO_PWM_RAMP_EN_MASK 0x800000
#define CG_FDO_CTRL0__FDO_PWM_RAMP_EN__SHIFT 0x17
#define CG_FDO_CTRL0__FDO_PWM_RAMP_MASK 0xff000000
#define CG_FDO_CTRL0__FDO_PWM_RAMP__SHIFT 0x18
#define CG_FDO_CTRL1__FMAX_DUTY100_MASK 0xff
#define CG_FDO_CTRL1__FMAX_DUTY100__SHIFT 0x0
#define CG_FDO_CTRL1__FMIN_DUTY_MASK 0xff00
#define CG_FDO_CTRL1__FMIN_DUTY__SHIFT 0x8
#define CG_FDO_CTRL1__M_MASK 0xff0000
#define CG_FDO_CTRL1__M__SHIFT 0x10
#define CG_FDO_CTRL1__RESERVED_MASK 0x3f000000
#define CG_FDO_CTRL1__RESERVED__SHIFT 0x18
#define CG_FDO_CTRL1__FDO_PWRDNB_MASK 0x40000000
#define CG_FDO_CTRL1__FDO_PWRDNB__SHIFT 0x1e
#define CG_FDO_CTRL2__TMIN_MASK 0xff
#define CG_FDO_CTRL2__TMIN__SHIFT 0x0
#define CG_FDO_CTRL2__FAN_SPINUP_TIME_MASK 0x700
#define CG_FDO_CTRL2__FAN_SPINUP_TIME__SHIFT 0x8
#define CG_FDO_CTRL2__FDO_PWM_MODE_MASK 0x3800
#define CG_FDO_CTRL2__FDO_PWM_MODE__SHIFT 0xb
#define CG_FDO_CTRL2__TMIN_HYSTER_MASK 0x1c000
#define CG_FDO_CTRL2__TMIN_HYSTER__SHIFT 0xe
#define CG_FDO_CTRL2__TMAX_MASK 0x1fe0000
#define CG_FDO_CTRL2__TMAX__SHIFT 0x11
#define CG_FDO_CTRL2__TACH_PWM_RESP_RATE_MASK 0xfe000000
#define CG_FDO_CTRL2__TACH_PWM_RESP_RATE__SHIFT 0x19
#define CG_TACH_CTRL__EDGE_PER_REV_MASK 0x7
#define CG_TACH_CTRL__EDGE_PER_REV__SHIFT 0x0
#define CG_TACH_CTRL__TARGET_PERIOD_MASK 0xfffffff8
#define CG_TACH_CTRL__TARGET_PERIOD__SHIFT 0x3
#define CG_TACH_STATUS__TACH_PERIOD_MASK 0xffffffff
#define CG_TACH_STATUS__TACH_PERIOD__SHIFT 0x0
#define CC_THM_STRAPS0__TMON0_BGADJ_MASK 0x1fe
#define CC_THM_STRAPS0__TMON0_BGADJ__SHIFT 0x1
#define CC_THM_STRAPS0__TMON1_BGADJ_MASK 0x1fe00
#define CC_THM_STRAPS0__TMON1_BGADJ__SHIFT 0x9
#define CC_THM_STRAPS0__TMON_CMON_FUSE_SEL_MASK 0x20000
#define CC_THM_STRAPS0__TMON_CMON_FUSE_SEL__SHIFT 0x11
#define CC_THM_STRAPS0__NUM_ACQ_MASK 0x1c0000
#define CC_THM_STRAPS0__NUM_ACQ__SHIFT 0x12
#define CC_THM_STRAPS0__TMON_CLK_SEL_MASK 0xe00000
#define CC_THM_STRAPS0__TMON_CLK_SEL__SHIFT 0x15
#define CC_THM_STRAPS0__TMON_CONFIG_SOURCE_MASK 0x1000000
#define CC_THM_STRAPS0__TMON_CONFIG_SOURCE__SHIFT 0x18
#define CC_THM_STRAPS0__CTF_DISABLE_MASK 0x2000000
#define CC_THM_STRAPS0__CTF_DISABLE__SHIFT 0x19
#define CC_THM_STRAPS0__TMON0_DISABLE_MASK 0x4000000
#define CC_THM_STRAPS0__TMON0_DISABLE__SHIFT 0x1a
#define CC_THM_STRAPS0__TMON1_DISABLE_MASK 0x8000000
#define CC_THM_STRAPS0__TMON1_DISABLE__SHIFT 0x1b
#define CC_THM_STRAPS0__TMON2_DISABLE_MASK 0x10000000
#define CC_THM_STRAPS0__TMON2_DISABLE__SHIFT 0x1c
#define CC_THM_STRAPS0__TMON3_DISABLE_MASK 0x20000000
#define CC_THM_STRAPS0__TMON3_DISABLE__SHIFT 0x1d
#define CC_THM_STRAPS0__UNUSED_MASK 0x80000000
#define CC_THM_STRAPS0__UNUSED__SHIFT 0x1f
#define THM_TMON0_RDIL0_DATA__Z_MASK 0x7ff
#define THM_TMON0_RDIL0_DATA__Z__SHIFT 0x0
#define THM_TMON0_RDIL0_DATA__VALID_MASK 0x800
#define THM_TMON0_RDIL0_DATA__VALID__SHIFT 0xb
#define THM_TMON0_RDIL0_DATA__TEMP_MASK 0xfff000
#define THM_TMON0_RDIL0_DATA__TEMP__SHIFT 0xc
#define THM_TMON0_RDIL1_DATA__Z_MASK 0x7ff
#define THM_TMON0_RDIL1_DATA__Z__SHIFT 0x0
#define THM_TMON0_RDIL1_DATA__VALID_MASK 0x800
#define THM_TMON0_RDIL1_DATA__VALID__SHIFT 0xb
#define THM_TMON0_RDIL1_DATA__TEMP_MASK 0xfff000
#define THM_TMON0_RDIL1_DATA__TEMP__SHIFT 0xc
#define THM_TMON0_RDIL2_DATA__Z_MASK 0x7ff
#define THM_TMON0_RDIL2_DATA__Z__SHIFT 0x0
#define THM_TMON0_RDIL2_DATA__VALID_MASK 0x800
#define THM_TMON0_RDIL2_DATA__VALID__SHIFT 0xb
#define THM_TMON0_RDIL2_DATA__TEMP_MASK 0xfff000
#define THM_TMON0_RDIL2_DATA__TEMP__SHIFT 0xc
#define THM_TMON0_RDIL3_DATA__Z_MASK 0x7ff
#define THM_TMON0_RDIL3_DATA__Z__SHIFT 0x0
#define THM_TMON0_RDIL3_DATA__VALID_MASK 0x800
#define THM_TMON0_RDIL3_DATA__VALID__SHIFT 0xb
#define THM_TMON0_RDIL3_DATA__TEMP_MASK 0xfff000
#define THM_TMON0_RDIL3_DATA__TEMP__SHIFT 0xc
#define THM_TMON0_RDIL4_DATA__Z_MASK 0x7ff
#define THM_TMON0_RDIL4_DATA__Z__SHIFT 0x0
#define THM_TMON0_RDIL4_DATA__VALID_MASK 0x800
#define THM_TMON0_RDIL4_DATA__VALID__SHIFT 0xb
#define THM_TMON0_RDIL4_DATA__TEMP_MASK 0xfff000
#define THM_TMON0_RDIL4_DATA__TEMP__SHIFT 0xc
#define THM_TMON0_RDIL5_DATA__Z_MASK 0x7ff
#define THM_TMON0_RDIL5_DATA__Z__SHIFT 0x0
#define THM_TMON0_RDIL5_DATA__VALID_MASK 0x800
#define THM_TMON0_RDIL5_DATA__VALID__SHIFT 0xb
#define THM_TMON0_RDIL5_DATA__TEMP_MASK 0xfff000
#define THM_TMON0_RDIL5_DATA__TEMP__SHIFT 0xc
#define THM_TMON0_RDIL6_DATA__Z_MASK 0x7ff
#define THM_TMON0_RDIL6_DATA__Z__SHIFT 0x0
#define THM_TMON0_RDIL6_DATA__VALID_MASK 0x800
#define THM_TMON0_RDIL6_DATA__VALID__SHIFT 0xb
#define THM_TMON0_RDIL6_DATA__TEMP_MASK 0xfff000
#define THM_TMON0_RDIL6_DATA__TEMP__SHIFT 0xc
#define THM_TMON0_RDIL7_DATA__Z_MASK 0x7ff
#define THM_TMON0_RDIL7_DATA__Z__SHIFT 0x0
#define THM_TMON0_RDIL7_DATA__VALID_MASK 0x800
#define THM_TMON0_RDIL7_DATA__VALID__SHIFT 0xb
#define THM_TMON0_RDIL7_DATA__TEMP_MASK 0xfff000
#define THM_TMON0_RDIL7_DATA__TEMP__SHIFT 0xc
#define THM_TMON0_RDIL8_DATA__Z_MASK 0x7ff
#define THM_TMON0_RDIL8_DATA__Z__SHIFT 0x0
#define THM_TMON0_RDIL8_DATA__VALID_MASK 0x800
#define THM_TMON0_RDIL8_DATA__VALID__SHIFT 0xb
#define THM_TMON0_RDIL8_DATA__TEMP_MASK 0xfff000
#define THM_TMON0_RDIL8_DATA__TEMP__SHIFT 0xc
#define THM_TMON0_RDIL9_DATA__Z_MASK 0x7ff
#define THM_TMON0_RDIL9_DATA__Z__SHIFT 0x0
#define THM_TMON0_RDIL9_DATA__VALID_MASK 0x800
#define THM_TMON0_RDIL9_DATA__VALID__SHIFT 0xb
#define THM_TMON0_RDIL9_DATA__TEMP_MASK 0xfff000
#define THM_TMON0_RDIL9_DATA__TEMP__SHIFT 0xc
#define THM_TMON0_RDIL10_DATA__Z_MASK 0x7ff
#define THM_TMON0_RDIL10_DATA__Z__SHIFT 0x0
#define THM_TMON0_RDIL10_DATA__VALID_MASK 0x800
#define THM_TMON0_RDIL10_DATA__VALID__SHIFT 0xb
#define THM_TMON0_RDIL10_DATA__TEMP_MASK 0xfff000
#define THM_TMON0_RDIL10_DATA__TEMP__SHIFT 0xc
#define THM_TMON0_RDIL11_DATA__Z_MASK 0x7ff
#define THM_TMON0_RDIL11_DATA__Z__SHIFT 0x0
#define THM_TMON0_RDIL11_DATA__VALID_MASK 0x800
#define THM_TMON0_RDIL11_DATA__VALID__SHIFT 0xb
#define THM_TMON0_RDIL11_DATA__TEMP_MASK 0xfff000
#define THM_TMON0_RDIL11_DATA__TEMP__SHIFT 0xc
#define THM_TMON0_RDIL12_DATA__Z_MASK 0x7ff
#define THM_TMON0_RDIL12_DATA__Z__SHIFT 0x0
#define THM_TMON0_RDIL12_DATA__VALID_MASK 0x800
#define THM_TMON0_RDIL12_DATA__VALID__SHIFT 0xb
#define THM_TMON0_RDIL12_DATA__TEMP_MASK 0xfff000
#define THM_TMON0_RDIL12_DATA__TEMP__SHIFT 0xc
#define THM_TMON0_RDIL13_DATA__Z_MASK 0x7ff
#define THM_TMON0_RDIL13_DATA__Z__SHIFT 0x0
#define THM_TMON0_RDIL13_DATA__VALID_MASK 0x800
#define THM_TMON0_RDIL13_DATA__VALID__SHIFT 0xb
#define THM_TMON0_RDIL13_DATA__TEMP_MASK 0xfff000
#define THM_TMON0_RDIL13_DATA__TEMP__SHIFT 0xc
#define THM_TMON0_RDIL14_DATA__Z_MASK 0x7ff
#define THM_TMON0_RDIL14_DATA__Z__SHIFT 0x0
#define THM_TMON0_RDIL14_DATA__VALID_MASK 0x800
#define THM_TMON0_RDIL14_DATA__VALID__SHIFT 0xb
#define THM_TMON0_RDIL14_DATA__TEMP_MASK 0xfff000
#define THM_TMON0_RDIL14_DATA__TEMP__SHIFT 0xc
#define THM_TMON0_RDIL15_DATA__Z_MASK 0x7ff
#define THM_TMON0_RDIL15_DATA__Z__SHIFT 0x0
#define THM_TMON0_RDIL15_DATA__VALID_MASK 0x800
#define THM_TMON0_RDIL15_DATA__VALID__SHIFT 0xb
#define THM_TMON0_RDIL15_DATA__TEMP_MASK 0xfff000
#define THM_TMON0_RDIL15_DATA__TEMP__SHIFT 0xc
#define THM_TMON0_RDIR0_DATA__Z_MASK 0x7ff
#define THM_TMON0_RDIR0_DATA__Z__SHIFT 0x0
#define THM_TMON0_RDIR0_DATA__VALID_MASK 0x800
#define THM_TMON0_RDIR0_DATA__VALID__SHIFT 0xb
#define THM_TMON0_RDIR0_DATA__TEMP_MASK 0xfff000
#define THM_TMON0_RDIR0_DATA__TEMP__SHIFT 0xc
#define THM_TMON0_RDIR1_DATA__Z_MASK 0x7ff
#define THM_TMON0_RDIR1_DATA__Z__SHIFT 0x0
#define THM_TMON0_RDIR1_DATA__VALID_MASK 0x800
#define THM_TMON0_RDIR1_DATA__VALID__SHIFT 0xb
#define THM_TMON0_RDIR1_DATA__TEMP_MASK 0xfff000
#define THM_TMON0_RDIR1_DATA__TEMP__SHIFT 0xc
#define THM_TMON0_RDIR2_DATA__Z_MASK 0x7ff
#define THM_TMON0_RDIR2_DATA__Z__SHIFT 0x0
#define THM_TMON0_RDIR2_DATA__VALID_MASK 0x800
#define THM_TMON0_RDIR2_DATA__VALID__SHIFT 0xb
#define THM_TMON0_RDIR2_DATA__TEMP_MASK 0xfff000
#define THM_TMON0_RDIR2_DATA__TEMP__SHIFT 0xc
#define THM_TMON0_RDIR3_DATA__Z_MASK 0x7ff
#define THM_TMON0_RDIR3_DATA__Z__SHIFT 0x0
#define THM_TMON0_RDIR3_DATA__VALID_MASK 0x800
#define THM_TMON0_RDIR3_DATA__VALID__SHIFT 0xb
#define THM_TMON0_RDIR3_DATA__TEMP_MASK 0xfff000
#define THM_TMON0_RDIR3_DATA__TEMP__SHIFT 0xc
#define THM_TMON0_RDIR4_DATA__Z_MASK 0x7ff
#define THM_TMON0_RDIR4_DATA__Z__SHIFT 0x0
#define THM_TMON0_RDIR4_DATA__VALID_MASK 0x800
#define THM_TMON0_RDIR4_DATA__VALID__SHIFT 0xb
#define THM_TMON0_RDIR4_DATA__TEMP_MASK 0xfff000
#define THM_TMON0_RDIR4_DATA__TEMP__SHIFT 0xc
#define THM_TMON0_RDIR5_DATA__Z_MASK 0x7ff
#define THM_TMON0_RDIR5_DATA__Z__SHIFT 0x0
#define THM_TMON0_RDIR5_DATA__VALID_MASK 0x800
#define THM_TMON0_RDIR5_DATA__VALID__SHIFT 0xb
#define THM_TMON0_RDIR5_DATA__TEMP_MASK 0xfff000
#define THM_TMON0_RDIR5_DATA__TEMP__SHIFT 0xc
#define THM_TMON0_RDIR6_DATA__Z_MASK 0x7ff
#define THM_TMON0_RDIR6_DATA__Z__SHIFT 0x0
#define THM_TMON0_RDIR6_DATA__VALID_MASK 0x800
#define THM_TMON0_RDIR6_DATA__VALID__SHIFT 0xb
#define THM_TMON0_RDIR6_DATA__TEMP_MASK 0xfff000
#define THM_TMON0_RDIR6_DATA__TEMP__SHIFT 0xc
#define THM_TMON0_RDIR7_DATA__Z_MASK 0x7ff
#define THM_TMON0_RDIR7_DATA__Z__SHIFT 0x0
#define THM_TMON0_RDIR7_DATA__VALID_MASK 0x800
#define THM_TMON0_RDIR7_DATA__VALID__SHIFT 0xb
#define THM_TMON0_RDIR7_DATA__TEMP_MASK 0xfff000
#define THM_TMON0_RDIR7_DATA__TEMP__SHIFT 0xc
#define THM_TMON0_RDIR8_DATA__Z_MASK 0x7ff
#define THM_TMON0_RDIR8_DATA__Z__SHIFT 0x0
#define THM_TMON0_RDIR8_DATA__VALID_MASK 0x800
#define THM_TMON0_RDIR8_DATA__VALID__SHIFT 0xb
#define THM_TMON0_RDIR8_DATA__TEMP_MASK 0xfff000
#define THM_TMON0_RDIR8_DATA__TEMP__SHIFT 0xc
#define THM_TMON0_RDIR9_DATA__Z_MASK 0x7ff
#define THM_TMON0_RDIR9_DATA__Z__SHIFT 0x0
#define THM_TMON0_RDIR9_DATA__VALID_MASK 0x800
#define THM_TMON0_RDIR9_DATA__VALID__SHIFT 0xb
#define THM_TMON0_RDIR9_DATA__TEMP_MASK 0xfff000
#define THM_TMON0_RDIR9_DATA__TEMP__SHIFT 0xc
#define THM_TMON0_RDIR10_DATA__Z_MASK 0x7ff
#define THM_TMON0_RDIR10_DATA__Z__SHIFT 0x0
#define THM_TMON0_RDIR10_DATA__VALID_MASK 0x800
#define THM_TMON0_RDIR10_DATA__VALID__SHIFT 0xb
#define THM_TMON0_RDIR10_DATA__TEMP_MASK 0xfff000
#define THM_TMON0_RDIR10_DATA__TEMP__SHIFT 0xc
#define THM_TMON0_RDIR11_DATA__Z_MASK 0x7ff
#define THM_TMON0_RDIR11_DATA__Z__SHIFT 0x0
#define THM_TMON0_RDIR11_DATA__VALID_MASK 0x800
#define THM_TMON0_RDIR11_DATA__VALID__SHIFT 0xb
#define THM_TMON0_RDIR11_DATA__TEMP_MASK 0xfff000
#define THM_TMON0_RDIR11_DATA__TEMP__SHIFT 0xc
#define THM_TMON0_RDIR12_DATA__Z_MASK 0x7ff
#define THM_TMON0_RDIR12_DATA__Z__SHIFT 0x0
#define THM_TMON0_RDIR12_DATA__VALID_MASK 0x800
#define THM_TMON0_RDIR12_DATA__VALID__SHIFT 0xb
#define THM_TMON0_RDIR12_DATA__TEMP_MASK 0xfff000
#define THM_TMON0_RDIR12_DATA__TEMP__SHIFT 0xc
#define THM_TMON0_RDIR13_DATA__Z_MASK 0x7ff
#define THM_TMON0_RDIR13_DATA__Z__SHIFT 0x0
#define THM_TMON0_RDIR13_DATA__VALID_MASK 0x800
#define THM_TMON0_RDIR13_DATA__VALID__SHIFT 0xb
#define THM_TMON0_RDIR13_DATA__TEMP_MASK 0xfff000
#define THM_TMON0_RDIR13_DATA__TEMP__SHIFT 0xc
#define THM_TMON0_RDIR14_DATA__Z_MASK 0x7ff
#define THM_TMON0_RDIR14_DATA__Z__SHIFT 0x0
#define THM_TMON0_RDIR14_DATA__VALID_MASK 0x800
#define THM_TMON0_RDIR14_DATA__VALID__SHIFT 0xb
#define THM_TMON0_RDIR14_DATA__TEMP_MASK 0xfff000
#define THM_TMON0_RDIR14_DATA__TEMP__SHIFT 0xc
#define THM_TMON0_RDIR15_DATA__Z_MASK 0x7ff
#define THM_TMON0_RDIR15_DATA__Z__SHIFT 0x0
#define THM_TMON0_RDIR15_DATA__VALID_MASK 0x800
#define THM_TMON0_RDIR15_DATA__VALID__SHIFT 0xb
#define THM_TMON0_RDIR15_DATA__TEMP_MASK 0xfff000
#define THM_TMON0_RDIR15_DATA__TEMP__SHIFT 0xc
#define THM_TMON0_INT_DATA__Z_MASK 0x7ff
#define THM_TMON0_INT_DATA__Z__SHIFT 0x0
#define THM_TMON0_INT_DATA__VALID_MASK 0x800
#define THM_TMON0_INT_DATA__VALID__SHIFT 0xb
#define THM_TMON0_INT_DATA__TEMP_MASK 0xfff000
#define THM_TMON0_INT_DATA__TEMP__SHIFT 0xc
#define THM_TMON0_DEBUG__DEBUG_RDI_MASK 0x1f
#define THM_TMON0_DEBUG__DEBUG_RDI__SHIFT 0x0
#define THM_TMON0_DEBUG__DEBUG_Z_MASK 0xffe0
#define THM_TMON0_DEBUG__DEBUG_Z__SHIFT 0x5
#define GENERAL_PWRMGT__GLOBAL_PWRMGT_EN_MASK 0x1
#define GENERAL_PWRMGT__GLOBAL_PWRMGT_EN__SHIFT 0x0
#define GENERAL_PWRMGT__STATIC_PM_EN_MASK 0x2
#define GENERAL_PWRMGT__STATIC_PM_EN__SHIFT 0x1
#define GENERAL_PWRMGT__THERMAL_PROTECTION_DIS_MASK 0x4
#define GENERAL_PWRMGT__THERMAL_PROTECTION_DIS__SHIFT 0x2
#define GENERAL_PWRMGT__THERMAL_PROTECTION_TYPE_MASK 0x8
#define GENERAL_PWRMGT__THERMAL_PROTECTION_TYPE__SHIFT 0x3
#define GENERAL_PWRMGT__SW_SMIO_INDEX_MASK 0x40
#define GENERAL_PWRMGT__SW_SMIO_INDEX__SHIFT 0x6
#define GENERAL_PWRMGT__LOW_VOLT_D2_ACPI_MASK 0x100
#define GENERAL_PWRMGT__LOW_VOLT_D2_ACPI__SHIFT 0x8
#define GENERAL_PWRMGT__LOW_VOLT_D3_ACPI_MASK 0x200
#define GENERAL_PWRMGT__LOW_VOLT_D3_ACPI__SHIFT 0x9
#define GENERAL_PWRMGT__VOLT_PWRMGT_EN_MASK 0x400
#define GENERAL_PWRMGT__VOLT_PWRMGT_EN__SHIFT 0xa
#define GENERAL_PWRMGT__SPARE11_MASK 0x800
#define GENERAL_PWRMGT__SPARE11__SHIFT 0xb
#define GENERAL_PWRMGT__GPU_COUNTER_ACPI_MASK 0x4000
#define GENERAL_PWRMGT__GPU_COUNTER_ACPI__SHIFT 0xe
#define GENERAL_PWRMGT__GPU_COUNTER_CLK_MASK 0x8000
#define GENERAL_PWRMGT__GPU_COUNTER_CLK__SHIFT 0xf
#define GENERAL_PWRMGT__GPU_COUNTER_OFF_MASK 0x10000
#define GENERAL_PWRMGT__GPU_COUNTER_OFF__SHIFT 0x10
#define GENERAL_PWRMGT__GPU_COUNTER_INTF_OFF_MASK 0x20000
#define GENERAL_PWRMGT__GPU_COUNTER_INTF_OFF__SHIFT 0x11
#define GENERAL_PWRMGT__SPARE18_MASK 0x40000
#define GENERAL_PWRMGT__SPARE18__SHIFT 0x12
#define GENERAL_PWRMGT__ACPI_D3_VID_MASK 0x180000
#define GENERAL_PWRMGT__ACPI_D3_VID__SHIFT 0x13
#define GENERAL_PWRMGT__DYN_SPREAD_SPECTRUM_EN_MASK 0x800000
#define GENERAL_PWRMGT__DYN_SPREAD_SPECTRUM_EN__SHIFT 0x17
#define GENERAL_PWRMGT__SPARE27_MASK 0x8000000
#define GENERAL_PWRMGT__SPARE27__SHIFT 0x1b
#define GENERAL_PWRMGT__SPARE_MASK 0xf0000000
#define GENERAL_PWRMGT__SPARE__SHIFT 0x1c
#define CNB_PWRMGT_CNTL__GNB_SLOW_MODE_MASK 0x3
#define CNB_PWRMGT_CNTL__GNB_SLOW_MODE__SHIFT 0x0
#define CNB_PWRMGT_CNTL__GNB_SLOW_MASK 0x4
#define CNB_PWRMGT_CNTL__GNB_SLOW__SHIFT 0x2
#define CNB_PWRMGT_CNTL__FORCE_NB_PS1_MASK 0x8
#define CNB_PWRMGT_CNTL__FORCE_NB_PS1__SHIFT 0x3
#define CNB_PWRMGT_CNTL__DPM_ENABLED_MASK 0x10
#define CNB_PWRMGT_CNTL__DPM_ENABLED__SHIFT 0x4
#define CNB_PWRMGT_CNTL__SPARE_MASK 0xffffffe0
#define CNB_PWRMGT_CNTL__SPARE__SHIFT 0x5
#define SCLK_PWRMGT_CNTL__SCLK_PWRMGT_OFF_MASK 0x1
#define SCLK_PWRMGT_CNTL__SCLK_PWRMGT_OFF__SHIFT 0x0
#define SCLK_PWRMGT_CNTL__SCLK_LOW_D1_MASK 0x2
#define SCLK_PWRMGT_CNTL__SCLK_LOW_D1__SHIFT 0x1
#define SCLK_PWRMGT_CNTL__DYN_PWR_DOWN_EN_MASK 0x4
#define SCLK_PWRMGT_CNTL__DYN_PWR_DOWN_EN__SHIFT 0x2
#define SCLK_PWRMGT_CNTL__RESET_BUSY_CNT_MASK 0x10
#define SCLK_PWRMGT_CNTL__RESET_BUSY_CNT__SHIFT 0x4
#define SCLK_PWRMGT_CNTL__RESET_SCLK_CNT_MASK 0x20
#define SCLK_PWRMGT_CNTL__RESET_SCLK_CNT__SHIFT 0x5
#define SCLK_PWRMGT_CNTL__RESERVED_0_MASK 0x40
#define SCLK_PWRMGT_CNTL__RESERVED_0__SHIFT 0x6
#define SCLK_PWRMGT_CNTL__DYN_GFX_CLK_OFF_EN_MASK 0x80
#define SCLK_PWRMGT_CNTL__DYN_GFX_CLK_OFF_EN__SHIFT 0x7
#define SCLK_PWRMGT_CNTL__GFX_CLK_FORCE_ON_MASK 0x100
#define SCLK_PWRMGT_CNTL__GFX_CLK_FORCE_ON__SHIFT 0x8
#define SCLK_PWRMGT_CNTL__GFX_CLK_REQUEST_OFF_MASK 0x200
#define SCLK_PWRMGT_CNTL__GFX_CLK_REQUEST_OFF__SHIFT 0x9
#define SCLK_PWRMGT_CNTL__GFX_CLK_FORCE_OFF_MASK 0x400
#define SCLK_PWRMGT_CNTL__GFX_CLK_FORCE_OFF__SHIFT 0xa
#define SCLK_PWRMGT_CNTL__GFX_CLK_OFF_ACPI_D1_MASK 0x800
#define SCLK_PWRMGT_CNTL__GFX_CLK_OFF_ACPI_D1__SHIFT 0xb
#define SCLK_PWRMGT_CNTL__GFX_CLK_OFF_ACPI_D2_MASK 0x1000
#define SCLK_PWRMGT_CNTL__GFX_CLK_OFF_ACPI_D2__SHIFT 0xc
#define SCLK_PWRMGT_CNTL__GFX_CLK_OFF_ACPI_D3_MASK 0x2000
#define SCLK_PWRMGT_CNTL__GFX_CLK_OFF_ACPI_D3__SHIFT 0xd
#define SCLK_PWRMGT_CNTL__DYN_LIGHT_SLEEP_EN_MASK 0x4000
#define SCLK_PWRMGT_CNTL__DYN_LIGHT_SLEEP_EN__SHIFT 0xe
#define SCLK_PWRMGT_CNTL__AUTO_SCLK_PULSE_SKIP_MASK 0x8000
#define SCLK_PWRMGT_CNTL__AUTO_SCLK_PULSE_SKIP__SHIFT 0xf
#define SCLK_PWRMGT_CNTL__LIGHT_SLEEP_COUNTER_MASK 0x1f0000
#define SCLK_PWRMGT_CNTL__LIGHT_SLEEP_COUNTER__SHIFT 0x10
#define SCLK_PWRMGT_CNTL__DYNAMIC_PM_EN_MASK 0x200000
#define SCLK_PWRMGT_CNTL__DYNAMIC_PM_EN__SHIFT 0x15
#define SCLK_PWRMGT_CNTL__DPM_DYN_PWR_DOWN_CNTL_MASK 0x400000
#define SCLK_PWRMGT_CNTL__DPM_DYN_PWR_DOWN_CNTL__SHIFT 0x16
#define SCLK_PWRMGT_CNTL__DPM_DYN_PWR_DOWN_EN_MASK 0x800000
#define SCLK_PWRMGT_CNTL__DPM_DYN_PWR_DOWN_EN__SHIFT 0x17
#define SCLK_PWRMGT_CNTL__RESERVED_3_MASK 0x1000000
#define SCLK_PWRMGT_CNTL__RESERVED_3__SHIFT 0x18
#define SCLK_PWRMGT_CNTL__VOLTAGE_UPDATE_EN_MASK 0x2000000
#define SCLK_PWRMGT_CNTL__VOLTAGE_UPDATE_EN__SHIFT 0x19
#define SCLK_PWRMGT_CNTL__FORCE_PM0_INTERRUPT_MASK 0x10000000
#define SCLK_PWRMGT_CNTL__FORCE_PM0_INTERRUPT__SHIFT 0x1c
#define SCLK_PWRMGT_CNTL__FORCE_PM1_INTERRUPT_MASK 0x20000000
#define SCLK_PWRMGT_CNTL__FORCE_PM1_INTERRUPT__SHIFT 0x1d
#define SCLK_PWRMGT_CNTL__GFX_VOLTAGE_CHANGE_EN_MASK 0x40000000
#define SCLK_PWRMGT_CNTL__GFX_VOLTAGE_CHANGE_EN__SHIFT 0x1e
#define SCLK_PWRMGT_CNTL__GFX_VOLTAGE_CHANGE_MODE_MASK 0x80000000
#define SCLK_PWRMGT_CNTL__GFX_VOLTAGE_CHANGE_MODE__SHIFT 0x1f
#define TARGET_AND_CURRENT_PROFILE_INDEX__TARGET_STATE_MASK 0xf
#define TARGET_AND_CURRENT_PROFILE_INDEX__TARGET_STATE__SHIFT 0x0
#define TARGET_AND_CURRENT_PROFILE_INDEX__CURRENT_STATE_MASK 0xf0
#define TARGET_AND_CURRENT_PROFILE_INDEX__CURRENT_STATE__SHIFT 0x4
#define TARGET_AND_CURRENT_PROFILE_INDEX__CURR_MCLK_INDEX_MASK 0xf00
#define TARGET_AND_CURRENT_PROFILE_INDEX__CURR_MCLK_INDEX__SHIFT 0x8
#define TARGET_AND_CURRENT_PROFILE_INDEX__TARG_MCLK_INDEX_MASK 0xf000
#define TARGET_AND_CURRENT_PROFILE_INDEX__TARG_MCLK_INDEX__SHIFT 0xc
#define TARGET_AND_CURRENT_PROFILE_INDEX__CURR_SCLK_INDEX_MASK 0x1f0000
#define TARGET_AND_CURRENT_PROFILE_INDEX__CURR_SCLK_INDEX__SHIFT 0x10
#define TARGET_AND_CURRENT_PROFILE_INDEX__TARG_SCLK_INDEX_MASK 0x3e00000
#define TARGET_AND_CURRENT_PROFILE_INDEX__TARG_SCLK_INDEX__SHIFT 0x15
#define TARGET_AND_CURRENT_PROFILE_INDEX__CURR_LCLK_INDEX_MASK 0x1c000000
#define TARGET_AND_CURRENT_PROFILE_INDEX__CURR_LCLK_INDEX__SHIFT 0x1a
#define TARGET_AND_CURRENT_PROFILE_INDEX__TARG_LCLK_INDEX_MASK 0xe0000000
#define TARGET_AND_CURRENT_PROFILE_INDEX__TARG_LCLK_INDEX__SHIFT 0x1d
#define CG_FREQ_TRAN_VOTING_0__BIF_FREQ_THROTTLING_VOTE_EN_MASK 0x1
#define CG_FREQ_TRAN_VOTING_0__BIF_FREQ_THROTTLING_VOTE_EN__SHIFT 0x0
#define CG_FREQ_TRAN_VOTING_0__HDP_FREQ_THROTTLING_VOTE_EN_MASK 0x2
#define CG_FREQ_TRAN_VOTING_0__HDP_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1
#define CG_FREQ_TRAN_VOTING_0__ROM_FREQ_THROTTLING_VOTE_EN_MASK 0x4
#define CG_FREQ_TRAN_VOTING_0__ROM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x2
#define CG_FREQ_TRAN_VOTING_0__IH_SEM_FREQ_THROTTLING_VOTE_EN_MASK 0x8
#define CG_FREQ_TRAN_VOTING_0__IH_SEM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x3
#define CG_FREQ_TRAN_VOTING_0__PDMA_FREQ_THROTTLING_VOTE_EN_MASK 0x10
#define CG_FREQ_TRAN_VOTING_0__PDMA_FREQ_THROTTLING_VOTE_EN__SHIFT 0x4
#define CG_FREQ_TRAN_VOTING_0__DRM_FREQ_THROTTLING_VOTE_EN_MASK 0x20
#define CG_FREQ_TRAN_VOTING_0__DRM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x5
#define CG_FREQ_TRAN_VOTING_0__IDCT_FREQ_THROTTLING_VOTE_EN_MASK 0x40
#define CG_FREQ_TRAN_VOTING_0__IDCT_FREQ_THROTTLING_VOTE_EN__SHIFT 0x6
#define CG_FREQ_TRAN_VOTING_0__ACP_FREQ_THROTTLING_VOTE_EN_MASK 0x80
#define CG_FREQ_TRAN_VOTING_0__ACP_FREQ_THROTTLING_VOTE_EN__SHIFT 0x7
#define CG_FREQ_TRAN_VOTING_0__SDMA_FREQ_THROTTLING_VOTE_EN_MASK 0x100
#define CG_FREQ_TRAN_VOTING_0__SDMA_FREQ_THROTTLING_VOTE_EN__SHIFT 0x8
#define CG_FREQ_TRAN_VOTING_0__UVD_FREQ_THROTTLING_VOTE_EN_MASK 0x200
#define CG_FREQ_TRAN_VOTING_0__UVD_FREQ_THROTTLING_VOTE_EN__SHIFT 0x9
#define CG_FREQ_TRAN_VOTING_0__VCE_FREQ_THROTTLING_VOTE_EN_MASK 0x400
#define CG_FREQ_TRAN_VOTING_0__VCE_FREQ_THROTTLING_VOTE_EN__SHIFT 0xa
#define CG_FREQ_TRAN_VOTING_0__DC_AZ_FREQ_THROTTLING_VOTE_EN_MASK 0x800
#define CG_FREQ_TRAN_VOTING_0__DC_AZ_FREQ_THROTTLING_VOTE_EN__SHIFT 0xb
#define CG_FREQ_TRAN_VOTING_0__SAM_FREQ_THROTTLING_VOTE_EN_MASK 0x1000
#define CG_FREQ_TRAN_VOTING_0__SAM_FREQ_THROTTLING_VOTE_EN__SHIFT 0xc
#define CG_FREQ_TRAN_VOTING_0__AVP_FREQ_THROTTLING_VOTE_EN_MASK 0x2000
#define CG_FREQ_TRAN_VOTING_0__AVP_FREQ_THROTTLING_VOTE_EN__SHIFT 0xd
#define CG_FREQ_TRAN_VOTING_0__GRBM_0_FREQ_THROTTLING_VOTE_EN_MASK 0x4000
#define CG_FREQ_TRAN_VOTING_0__GRBM_0_FREQ_THROTTLING_VOTE_EN__SHIFT 0xe
#define CG_FREQ_TRAN_VOTING_0__GRBM_1_FREQ_THROTTLING_VOTE_EN_MASK 0x8000
#define CG_FREQ_TRAN_VOTING_0__GRBM_1_FREQ_THROTTLING_VOTE_EN__SHIFT 0xf
#define CG_FREQ_TRAN_VOTING_0__GRBM_2_FREQ_THROTTLING_VOTE_EN_MASK 0x10000
#define CG_FREQ_TRAN_VOTING_0__GRBM_2_FREQ_THROTTLING_VOTE_EN__SHIFT 0x10
#define CG_FREQ_TRAN_VOTING_0__GRBM_3_FREQ_THROTTLING_VOTE_EN_MASK 0x20000
#define CG_FREQ_TRAN_VOTING_0__GRBM_3_FREQ_THROTTLING_VOTE_EN__SHIFT 0x11
#define CG_FREQ_TRAN_VOTING_0__GRBM_4_FREQ_THROTTLING_VOTE_EN_MASK 0x40000
#define CG_FREQ_TRAN_VOTING_0__GRBM_4_FREQ_THROTTLING_VOTE_EN__SHIFT 0x12
#define CG_FREQ_TRAN_VOTING_0__GRBM_5_FREQ_THROTTLING_VOTE_EN_MASK 0x80000
#define CG_FREQ_TRAN_VOTING_0__GRBM_5_FREQ_THROTTLING_VOTE_EN__SHIFT 0x13
#define CG_FREQ_TRAN_VOTING_0__GRBM_6_FREQ_THROTTLING_VOTE_EN_MASK 0x100000
#define CG_FREQ_TRAN_VOTING_0__GRBM_6_FREQ_THROTTLING_VOTE_EN__SHIFT 0x14
#define CG_FREQ_TRAN_VOTING_0__GRBM_7_FREQ_THROTTLING_VOTE_EN_MASK 0x200000
#define CG_FREQ_TRAN_VOTING_0__GRBM_7_FREQ_THROTTLING_VOTE_EN__SHIFT 0x15
#define CG_FREQ_TRAN_VOTING_0__GRBM_8_FREQ_THROTTLING_VOTE_EN_MASK 0x400000
#define CG_FREQ_TRAN_VOTING_0__GRBM_8_FREQ_THROTTLING_VOTE_EN__SHIFT 0x16
#define CG_FREQ_TRAN_VOTING_0__GRBM_9_FREQ_THROTTLING_VOTE_EN_MASK 0x800000
#define CG_FREQ_TRAN_VOTING_0__GRBM_9_FREQ_THROTTLING_VOTE_EN__SHIFT 0x17
#define CG_FREQ_TRAN_VOTING_0__GRBM_10_FREQ_THROTTLING_VOTE_EN_MASK 0x1000000
#define CG_FREQ_TRAN_VOTING_0__GRBM_10_FREQ_THROTTLING_VOTE_EN__SHIFT 0x18
#define CG_FREQ_TRAN_VOTING_0__GRBM_11_FREQ_THROTTLING_VOTE_EN_MASK 0x2000000
#define CG_FREQ_TRAN_VOTING_0__GRBM_11_FREQ_THROTTLING_VOTE_EN__SHIFT 0x19
#define CG_FREQ_TRAN_VOTING_0__GRBM_12_FREQ_THROTTLING_VOTE_EN_MASK 0x4000000
#define CG_FREQ_TRAN_VOTING_0__GRBM_12_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1a
#define CG_FREQ_TRAN_VOTING_0__GRBM_13_FREQ_THROTTLING_VOTE_EN_MASK 0x8000000
#define CG_FREQ_TRAN_VOTING_0__GRBM_13_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1b
#define CG_FREQ_TRAN_VOTING_0__GRBM_14_FREQ_THROTTLING_VOTE_EN_MASK 0x10000000
#define CG_FREQ_TRAN_VOTING_0__GRBM_14_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1c
#define CG_FREQ_TRAN_VOTING_0__GRBM_15_FREQ_THROTTLING_VOTE_EN_MASK 0x20000000
#define CG_FREQ_TRAN_VOTING_0__GRBM_15_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1d
#define CG_FREQ_TRAN_VOTING_0__RLC_FREQ_THROTTLING_VOTE_EN_MASK 0x40000000
#define CG_FREQ_TRAN_VOTING_0__RLC_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1e
#define CG_FREQ_TRAN_VOTING_1__BIF_FREQ_THROTTLING_VOTE_EN_MASK 0x1
#define CG_FREQ_TRAN_VOTING_1__BIF_FREQ_THROTTLING_VOTE_EN__SHIFT 0x0
#define CG_FREQ_TRAN_VOTING_1__HDP_FREQ_THROTTLING_VOTE_EN_MASK 0x2
#define CG_FREQ_TRAN_VOTING_1__HDP_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1
#define CG_FREQ_TRAN_VOTING_1__ROM_FREQ_THROTTLING_VOTE_EN_MASK 0x4
#define CG_FREQ_TRAN_VOTING_1__ROM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x2
#define CG_FREQ_TRAN_VOTING_1__IH_SEM_FREQ_THROTTLING_VOTE_EN_MASK 0x8
#define CG_FREQ_TRAN_VOTING_1__IH_SEM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x3
#define CG_FREQ_TRAN_VOTING_1__PDMA_FREQ_THROTTLING_VOTE_EN_MASK 0x10
#define CG_FREQ_TRAN_VOTING_1__PDMA_FREQ_THROTTLING_VOTE_EN__SHIFT 0x4
#define CG_FREQ_TRAN_VOTING_1__DRM_FREQ_THROTTLING_VOTE_EN_MASK 0x20
#define CG_FREQ_TRAN_VOTING_1__DRM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x5
#define CG_FREQ_TRAN_VOTING_1__IDCT_FREQ_THROTTLING_VOTE_EN_MASK 0x40
#define CG_FREQ_TRAN_VOTING_1__IDCT_FREQ_THROTTLING_VOTE_EN__SHIFT 0x6
#define CG_FREQ_TRAN_VOTING_1__ACP_FREQ_THROTTLING_VOTE_EN_MASK 0x80
#define CG_FREQ_TRAN_VOTING_1__ACP_FREQ_THROTTLING_VOTE_EN__SHIFT 0x7
#define CG_FREQ_TRAN_VOTING_1__SDMA_FREQ_THROTTLING_VOTE_EN_MASK 0x100
#define CG_FREQ_TRAN_VOTING_1__SDMA_FREQ_THROTTLING_VOTE_EN__SHIFT 0x8
#define CG_FREQ_TRAN_VOTING_1__UVD_FREQ_THROTTLING_VOTE_EN_MASK 0x200
#define CG_FREQ_TRAN_VOTING_1__UVD_FREQ_THROTTLING_VOTE_EN__SHIFT 0x9
#define CG_FREQ_TRAN_VOTING_1__VCE_FREQ_THROTTLING_VOTE_EN_MASK 0x400
#define CG_FREQ_TRAN_VOTING_1__VCE_FREQ_THROTTLING_VOTE_EN__SHIFT 0xa
#define CG_FREQ_TRAN_VOTING_1__DC_AZ_FREQ_THROTTLING_VOTE_EN_MASK 0x800
#define CG_FREQ_TRAN_VOTING_1__DC_AZ_FREQ_THROTTLING_VOTE_EN__SHIFT 0xb
#define CG_FREQ_TRAN_VOTING_1__SAM_FREQ_THROTTLING_VOTE_EN_MASK 0x1000
#define CG_FREQ_TRAN_VOTING_1__SAM_FREQ_THROTTLING_VOTE_EN__SHIFT 0xc
#define CG_FREQ_TRAN_VOTING_1__AVP_FREQ_THROTTLING_VOTE_EN_MASK 0x2000
#define CG_FREQ_TRAN_VOTING_1__AVP_FREQ_THROTTLING_VOTE_EN__SHIFT 0xd
#define CG_FREQ_TRAN_VOTING_1__GRBM_0_FREQ_THROTTLING_VOTE_EN_MASK 0x4000
#define CG_FREQ_TRAN_VOTING_1__GRBM_0_FREQ_THROTTLING_VOTE_EN__SHIFT 0xe
#define CG_FREQ_TRAN_VOTING_1__GRBM_1_FREQ_THROTTLING_VOTE_EN_MASK 0x8000
#define CG_FREQ_TRAN_VOTING_1__GRBM_1_FREQ_THROTTLING_VOTE_EN__SHIFT 0xf
#define CG_FREQ_TRAN_VOTING_1__GRBM_2_FREQ_THROTTLING_VOTE_EN_MASK 0x10000
#define CG_FREQ_TRAN_VOTING_1__GRBM_2_FREQ_THROTTLING_VOTE_EN__SHIFT 0x10
#define CG_FREQ_TRAN_VOTING_1__GRBM_3_FREQ_THROTTLING_VOTE_EN_MASK 0x20000
#define CG_FREQ_TRAN_VOTING_1__GRBM_3_FREQ_THROTTLING_VOTE_EN__SHIFT 0x11
#define CG_FREQ_TRAN_VOTING_1__GRBM_4_FREQ_THROTTLING_VOTE_EN_MASK 0x40000
#define CG_FREQ_TRAN_VOTING_1__GRBM_4_FREQ_THROTTLING_VOTE_EN__SHIFT 0x12
#define CG_FREQ_TRAN_VOTING_1__GRBM_5_FREQ_THROTTLING_VOTE_EN_MASK 0x80000
#define CG_FREQ_TRAN_VOTING_1__GRBM_5_FREQ_THROTTLING_VOTE_EN__SHIFT 0x13
#define CG_FREQ_TRAN_VOTING_1__GRBM_6_FREQ_THROTTLING_VOTE_EN_MASK 0x100000
#define CG_FREQ_TRAN_VOTING_1__GRBM_6_FREQ_THROTTLING_VOTE_EN__SHIFT 0x14
#define CG_FREQ_TRAN_VOTING_1__GRBM_7_FREQ_THROTTLING_VOTE_EN_MASK 0x200000
#define CG_FREQ_TRAN_VOTING_1__GRBM_7_FREQ_THROTTLING_VOTE_EN__SHIFT 0x15
#define CG_FREQ_TRAN_VOTING_1__GRBM_8_FREQ_THROTTLING_VOTE_EN_MASK 0x400000
#define CG_FREQ_TRAN_VOTING_1__GRBM_8_FREQ_THROTTLING_VOTE_EN__SHIFT 0x16
#define CG_FREQ_TRAN_VOTING_1__GRBM_9_FREQ_THROTTLING_VOTE_EN_MASK 0x800000
#define CG_FREQ_TRAN_VOTING_1__GRBM_9_FREQ_THROTTLING_VOTE_EN__SHIFT 0x17
#define CG_FREQ_TRAN_VOTING_1__GRBM_10_FREQ_THROTTLING_VOTE_EN_MASK 0x1000000
#define CG_FREQ_TRAN_VOTING_1__GRBM_10_FREQ_THROTTLING_VOTE_EN__SHIFT 0x18
#define CG_FREQ_TRAN_VOTING_1__GRBM_11_FREQ_THROTTLING_VOTE_EN_MASK 0x2000000
#define CG_FREQ_TRAN_VOTING_1__GRBM_11_FREQ_THROTTLING_VOTE_EN__SHIFT 0x19
#define CG_FREQ_TRAN_VOTING_1__GRBM_12_FREQ_THROTTLING_VOTE_EN_MASK 0x4000000
#define CG_FREQ_TRAN_VOTING_1__GRBM_12_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1a
#define CG_FREQ_TRAN_VOTING_1__GRBM_13_FREQ_THROTTLING_VOTE_EN_MASK 0x8000000
#define CG_FREQ_TRAN_VOTING_1__GRBM_13_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1b
#define CG_FREQ_TRAN_VOTING_1__GRBM_14_FREQ_THROTTLING_VOTE_EN_MASK 0x10000000
#define CG_FREQ_TRAN_VOTING_1__GRBM_14_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1c
#define CG_FREQ_TRAN_VOTING_1__GRBM_15_FREQ_THROTTLING_VOTE_EN_MASK 0x20000000
#define CG_FREQ_TRAN_VOTING_1__GRBM_15_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1d
#define CG_FREQ_TRAN_VOTING_1__RLC_FREQ_THROTTLING_VOTE_EN_MASK 0x40000000
#define CG_FREQ_TRAN_VOTING_1__RLC_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1e
#define CG_FREQ_TRAN_VOTING_2__BIF_FREQ_THROTTLING_VOTE_EN_MASK 0x1
#define CG_FREQ_TRAN_VOTING_2__BIF_FREQ_THROTTLING_VOTE_EN__SHIFT 0x0
#define CG_FREQ_TRAN_VOTING_2__HDP_FREQ_THROTTLING_VOTE_EN_MASK 0x2
#define CG_FREQ_TRAN_VOTING_2__HDP_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1
#define CG_FREQ_TRAN_VOTING_2__ROM_FREQ_THROTTLING_VOTE_EN_MASK 0x4
#define CG_FREQ_TRAN_VOTING_2__ROM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x2
#define CG_FREQ_TRAN_VOTING_2__IH_SEM_FREQ_THROTTLING_VOTE_EN_MASK 0x8
#define CG_FREQ_TRAN_VOTING_2__IH_SEM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x3
#define CG_FREQ_TRAN_VOTING_2__PDMA_FREQ_THROTTLING_VOTE_EN_MASK 0x10
#define CG_FREQ_TRAN_VOTING_2__PDMA_FREQ_THROTTLING_VOTE_EN__SHIFT 0x4
#define CG_FREQ_TRAN_VOTING_2__DRM_FREQ_THROTTLING_VOTE_EN_MASK 0x20
#define CG_FREQ_TRAN_VOTING_2__DRM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x5
#define CG_FREQ_TRAN_VOTING_2__IDCT_FREQ_THROTTLING_VOTE_EN_MASK 0x40
#define CG_FREQ_TRAN_VOTING_2__IDCT_FREQ_THROTTLING_VOTE_EN__SHIFT 0x6
#define CG_FREQ_TRAN_VOTING_2__ACP_FREQ_THROTTLING_VOTE_EN_MASK 0x80
#define CG_FREQ_TRAN_VOTING_2__ACP_FREQ_THROTTLING_VOTE_EN__SHIFT 0x7
#define CG_FREQ_TRAN_VOTING_2__SDMA_FREQ_THROTTLING_VOTE_EN_MASK 0x100
#define CG_FREQ_TRAN_VOTING_2__SDMA_FREQ_THROTTLING_VOTE_EN__SHIFT 0x8
#define CG_FREQ_TRAN_VOTING_2__UVD_FREQ_THROTTLING_VOTE_EN_MASK 0x200
#define CG_FREQ_TRAN_VOTING_2__UVD_FREQ_THROTTLING_VOTE_EN__SHIFT 0x9
#define CG_FREQ_TRAN_VOTING_2__VCE_FREQ_THROTTLING_VOTE_EN_MASK 0x400
#define CG_FREQ_TRAN_VOTING_2__VCE_FREQ_THROTTLING_VOTE_EN__SHIFT 0xa
#define CG_FREQ_TRAN_VOTING_2__DC_AZ_FREQ_THROTTLING_VOTE_EN_MASK 0x800
#define CG_FREQ_TRAN_VOTING_2__DC_AZ_FREQ_THROTTLING_VOTE_EN__SHIFT 0xb
#define CG_FREQ_TRAN_VOTING_2__SAM_FREQ_THROTTLING_VOTE_EN_MASK 0x1000
#define CG_FREQ_TRAN_VOTING_2__SAM_FREQ_THROTTLING_VOTE_EN__SHIFT 0xc
#define CG_FREQ_TRAN_VOTING_2__AVP_FREQ_THROTTLING_VOTE_EN_MASK 0x2000
#define CG_FREQ_TRAN_VOTING_2__AVP_FREQ_THROTTLING_VOTE_EN__SHIFT 0xd
#define CG_FREQ_TRAN_VOTING_2__GRBM_0_FREQ_THROTTLING_VOTE_EN_MASK 0x4000
#define CG_FREQ_TRAN_VOTING_2__GRBM_0_FREQ_THROTTLING_VOTE_EN__SHIFT 0xe
#define CG_FREQ_TRAN_VOTING_2__GRBM_1_FREQ_THROTTLING_VOTE_EN_MASK 0x8000
#define CG_FREQ_TRAN_VOTING_2__GRBM_1_FREQ_THROTTLING_VOTE_EN__SHIFT 0xf
#define CG_FREQ_TRAN_VOTING_2__GRBM_2_FREQ_THROTTLING_VOTE_EN_MASK 0x10000
#define CG_FREQ_TRAN_VOTING_2__GRBM_2_FREQ_THROTTLING_VOTE_EN__SHIFT 0x10
#define CG_FREQ_TRAN_VOTING_2__GRBM_3_FREQ_THROTTLING_VOTE_EN_MASK 0x20000
#define CG_FREQ_TRAN_VOTING_2__GRBM_3_FREQ_THROTTLING_VOTE_EN__SHIFT 0x11
#define CG_FREQ_TRAN_VOTING_2__GRBM_4_FREQ_THROTTLING_VOTE_EN_MASK 0x40000
#define CG_FREQ_TRAN_VOTING_2__GRBM_4_FREQ_THROTTLING_VOTE_EN__SHIFT 0x12
#define CG_FREQ_TRAN_VOTING_2__GRBM_5_FREQ_THROTTLING_VOTE_EN_MASK 0x80000
#define CG_FREQ_TRAN_VOTING_2__GRBM_5_FREQ_THROTTLING_VOTE_EN__SHIFT 0x13
#define CG_FREQ_TRAN_VOTING_2__GRBM_6_FREQ_THROTTLING_VOTE_EN_MASK 0x100000
#define CG_FREQ_TRAN_VOTING_2__GRBM_6_FREQ_THROTTLING_VOTE_EN__SHIFT 0x14
#define CG_FREQ_TRAN_VOTING_2__GRBM_7_FREQ_THROTTLING_VOTE_EN_MASK 0x200000
#define CG_FREQ_TRAN_VOTING_2__GRBM_7_FREQ_THROTTLING_VOTE_EN__SHIFT 0x15
#define CG_FREQ_TRAN_VOTING_2__GRBM_8_FREQ_THROTTLING_VOTE_EN_MASK 0x400000
#define CG_FREQ_TRAN_VOTING_2__GRBM_8_FREQ_THROTTLING_VOTE_EN__SHIFT 0x16
#define CG_FREQ_TRAN_VOTING_2__GRBM_9_FREQ_THROTTLING_VOTE_EN_MASK 0x800000
#define CG_FREQ_TRAN_VOTING_2__GRBM_9_FREQ_THROTTLING_VOTE_EN__SHIFT 0x17
#define CG_FREQ_TRAN_VOTING_2__GRBM_10_FREQ_THROTTLING_VOTE_EN_MASK 0x1000000
#define CG_FREQ_TRAN_VOTING_2__GRBM_10_FREQ_THROTTLING_VOTE_EN__SHIFT 0x18
#define CG_FREQ_TRAN_VOTING_2__GRBM_11_FREQ_THROTTLING_VOTE_EN_MASK 0x2000000
#define CG_FREQ_TRAN_VOTING_2__GRBM_11_FREQ_THROTTLING_VOTE_EN__SHIFT 0x19
#define CG_FREQ_TRAN_VOTING_2__GRBM_12_FREQ_THROTTLING_VOTE_EN_MASK 0x4000000
#define CG_FREQ_TRAN_VOTING_2__GRBM_12_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1a
#define CG_FREQ_TRAN_VOTING_2__GRBM_13_FREQ_THROTTLING_VOTE_EN_MASK 0x8000000
#define CG_FREQ_TRAN_VOTING_2__GRBM_13_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1b
#define CG_FREQ_TRAN_VOTING_2__GRBM_14_FREQ_THROTTLING_VOTE_EN_MASK 0x10000000
#define CG_FREQ_TRAN_VOTING_2__GRBM_14_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1c
#define CG_FREQ_TRAN_VOTING_2__GRBM_15_FREQ_THROTTLING_VOTE_EN_MASK 0x20000000
#define CG_FREQ_TRAN_VOTING_2__GRBM_15_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1d
#define CG_FREQ_TRAN_VOTING_2__RLC_FREQ_THROTTLING_VOTE_EN_MASK 0x40000000
#define CG_FREQ_TRAN_VOTING_2__RLC_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1e
#define CG_FREQ_TRAN_VOTING_3__BIF_FREQ_THROTTLING_VOTE_EN_MASK 0x1
#define CG_FREQ_TRAN_VOTING_3__BIF_FREQ_THROTTLING_VOTE_EN__SHIFT 0x0
#define CG_FREQ_TRAN_VOTING_3__HDP_FREQ_THROTTLING_VOTE_EN_MASK 0x2
#define CG_FREQ_TRAN_VOTING_3__HDP_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1
#define CG_FREQ_TRAN_VOTING_3__ROM_FREQ_THROTTLING_VOTE_EN_MASK 0x4
#define CG_FREQ_TRAN_VOTING_3__ROM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x2
#define CG_FREQ_TRAN_VOTING_3__IH_SEM_FREQ_THROTTLING_VOTE_EN_MASK 0x8
#define CG_FREQ_TRAN_VOTING_3__IH_SEM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x3
#define CG_FREQ_TRAN_VOTING_3__PDMA_FREQ_THROTTLING_VOTE_EN_MASK 0x10
#define CG_FREQ_TRAN_VOTING_3__PDMA_FREQ_THROTTLING_VOTE_EN__SHIFT 0x4
#define CG_FREQ_TRAN_VOTING_3__DRM_FREQ_THROTTLING_VOTE_EN_MASK 0x20
#define CG_FREQ_TRAN_VOTING_3__DRM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x5
#define CG_FREQ_TRAN_VOTING_3__IDCT_FREQ_THROTTLING_VOTE_EN_MASK 0x40
#define CG_FREQ_TRAN_VOTING_3__IDCT_FREQ_THROTTLING_VOTE_EN__SHIFT 0x6
#define CG_FREQ_TRAN_VOTING_3__ACP_FREQ_THROTTLING_VOTE_EN_MASK 0x80
#define CG_FREQ_TRAN_VOTING_3__ACP_FREQ_THROTTLING_VOTE_EN__SHIFT 0x7
#define CG_FREQ_TRAN_VOTING_3__SDMA_FREQ_THROTTLING_VOTE_EN_MASK 0x100
#define CG_FREQ_TRAN_VOTING_3__SDMA_FREQ_THROTTLING_VOTE_EN__SHIFT 0x8
#define CG_FREQ_TRAN_VOTING_3__UVD_FREQ_THROTTLING_VOTE_EN_MASK 0x200
#define CG_FREQ_TRAN_VOTING_3__UVD_FREQ_THROTTLING_VOTE_EN__SHIFT 0x9
#define CG_FREQ_TRAN_VOTING_3__VCE_FREQ_THROTTLING_VOTE_EN_MASK 0x400
#define CG_FREQ_TRAN_VOTING_3__VCE_FREQ_THROTTLING_VOTE_EN__SHIFT 0xa
#define CG_FREQ_TRAN_VOTING_3__DC_AZ_FREQ_THROTTLING_VOTE_EN_MASK 0x800
#define CG_FREQ_TRAN_VOTING_3__DC_AZ_FREQ_THROTTLING_VOTE_EN__SHIFT 0xb
#define CG_FREQ_TRAN_VOTING_3__SAM_FREQ_THROTTLING_VOTE_EN_MASK 0x1000
#define CG_FREQ_TRAN_VOTING_3__SAM_FREQ_THROTTLING_VOTE_EN__SHIFT 0xc
#define CG_FREQ_TRAN_VOTING_3__AVP_FREQ_THROTTLING_VOTE_EN_MASK 0x2000
#define CG_FREQ_TRAN_VOTING_3__AVP_FREQ_THROTTLING_VOTE_EN__SHIFT 0xd
#define CG_FREQ_TRAN_VOTING_3__GRBM_0_FREQ_THROTTLING_VOTE_EN_MASK 0x4000
#define CG_FREQ_TRAN_VOTING_3__GRBM_0_FREQ_THROTTLING_VOTE_EN__SHIFT 0xe
#define CG_FREQ_TRAN_VOTING_3__GRBM_1_FREQ_THROTTLING_VOTE_EN_MASK 0x8000
#define CG_FREQ_TRAN_VOTING_3__GRBM_1_FREQ_THROTTLING_VOTE_EN__SHIFT 0xf
#define CG_FREQ_TRAN_VOTING_3__GRBM_2_FREQ_THROTTLING_VOTE_EN_MASK 0x10000
#define CG_FREQ_TRAN_VOTING_3__GRBM_2_FREQ_THROTTLING_VOTE_EN__SHIFT 0x10
#define CG_FREQ_TRAN_VOTING_3__GRBM_3_FREQ_THROTTLING_VOTE_EN_MASK 0x20000
#define CG_FREQ_TRAN_VOTING_3__GRBM_3_FREQ_THROTTLING_VOTE_EN__SHIFT 0x11
#define CG_FREQ_TRAN_VOTING_3__GRBM_4_FREQ_THROTTLING_VOTE_EN_MASK 0x40000
#define CG_FREQ_TRAN_VOTING_3__GRBM_4_FREQ_THROTTLING_VOTE_EN__SHIFT 0x12
#define CG_FREQ_TRAN_VOTING_3__GRBM_5_FREQ_THROTTLING_VOTE_EN_MASK 0x80000
#define CG_FREQ_TRAN_VOTING_3__GRBM_5_FREQ_THROTTLING_VOTE_EN__SHIFT 0x13
#define CG_FREQ_TRAN_VOTING_3__GRBM_6_FREQ_THROTTLING_VOTE_EN_MASK 0x100000
#define CG_FREQ_TRAN_VOTING_3__GRBM_6_FREQ_THROTTLING_VOTE_EN__SHIFT 0x14
#define CG_FREQ_TRAN_VOTING_3__GRBM_7_FREQ_THROTTLING_VOTE_EN_MASK 0x200000
#define CG_FREQ_TRAN_VOTING_3__GRBM_7_FREQ_THROTTLING_VOTE_EN__SHIFT 0x15
#define CG_FREQ_TRAN_VOTING_3__GRBM_8_FREQ_THROTTLING_VOTE_EN_MASK 0x400000
#define CG_FREQ_TRAN_VOTING_3__GRBM_8_FREQ_THROTTLING_VOTE_EN__SHIFT 0x16
#define CG_FREQ_TRAN_VOTING_3__GRBM_9_FREQ_THROTTLING_VOTE_EN_MASK 0x800000
#define CG_FREQ_TRAN_VOTING_3__GRBM_9_FREQ_THROTTLING_VOTE_EN__SHIFT 0x17
#define CG_FREQ_TRAN_VOTING_3__GRBM_10_FREQ_THROTTLING_VOTE_EN_MASK 0x1000000
#define CG_FREQ_TRAN_VOTING_3__GRBM_10_FREQ_THROTTLING_VOTE_EN__SHIFT 0x18
#define CG_FREQ_TRAN_VOTING_3__GRBM_11_FREQ_THROTTLING_VOTE_EN_MASK 0x2000000
#define CG_FREQ_TRAN_VOTING_3__GRBM_11_FREQ_THROTTLING_VOTE_EN__SHIFT 0x19
#define CG_FREQ_TRAN_VOTING_3__GRBM_12_FREQ_THROTTLING_VOTE_EN_MASK 0x4000000
#define CG_FREQ_TRAN_VOTING_3__GRBM_12_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1a
#define CG_FREQ_TRAN_VOTING_3__GRBM_13_FREQ_THROTTLING_VOTE_EN_MASK 0x8000000
#define CG_FREQ_TRAN_VOTING_3__GRBM_13_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1b
#define CG_FREQ_TRAN_VOTING_3__GRBM_14_FREQ_THROTTLING_VOTE_EN_MASK 0x10000000
#define CG_FREQ_TRAN_VOTING_3__GRBM_14_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1c
#define CG_FREQ_TRAN_VOTING_3__GRBM_15_FREQ_THROTTLING_VOTE_EN_MASK 0x20000000
#define CG_FREQ_TRAN_VOTING_3__GRBM_15_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1d
#define CG_FREQ_TRAN_VOTING_3__RLC_FREQ_THROTTLING_VOTE_EN_MASK 0x40000000
#define CG_FREQ_TRAN_VOTING_3__RLC_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1e
#define CG_FREQ_TRAN_VOTING_4__BIF_FREQ_THROTTLING_VOTE_EN_MASK 0x1
#define CG_FREQ_TRAN_VOTING_4__BIF_FREQ_THROTTLING_VOTE_EN__SHIFT 0x0
#define CG_FREQ_TRAN_VOTING_4__HDP_FREQ_THROTTLING_VOTE_EN_MASK 0x2
#define CG_FREQ_TRAN_VOTING_4__HDP_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1
#define CG_FREQ_TRAN_VOTING_4__ROM_FREQ_THROTTLING_VOTE_EN_MASK 0x4
#define CG_FREQ_TRAN_VOTING_4__ROM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x2
#define CG_FREQ_TRAN_VOTING_4__IH_SEM_FREQ_THROTTLING_VOTE_EN_MASK 0x8
#define CG_FREQ_TRAN_VOTING_4__IH_SEM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x3
#define CG_FREQ_TRAN_VOTING_4__PDMA_FREQ_THROTTLING_VOTE_EN_MASK 0x10
#define CG_FREQ_TRAN_VOTING_4__PDMA_FREQ_THROTTLING_VOTE_EN__SHIFT 0x4
#define CG_FREQ_TRAN_VOTING_4__DRM_FREQ_THROTTLING_VOTE_EN_MASK 0x20
#define CG_FREQ_TRAN_VOTING_4__DRM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x5
#define CG_FREQ_TRAN_VOTING_4__IDCT_FREQ_THROTTLING_VOTE_EN_MASK 0x40
#define CG_FREQ_TRAN_VOTING_4__IDCT_FREQ_THROTTLING_VOTE_EN__SHIFT 0x6
#define CG_FREQ_TRAN_VOTING_4__ACP_FREQ_THROTTLING_VOTE_EN_MASK 0x80
#define CG_FREQ_TRAN_VOTING_4__ACP_FREQ_THROTTLING_VOTE_EN__SHIFT 0x7
#define CG_FREQ_TRAN_VOTING_4__SDMA_FREQ_THROTTLING_VOTE_EN_MASK 0x100
#define CG_FREQ_TRAN_VOTING_4__SDMA_FREQ_THROTTLING_VOTE_EN__SHIFT 0x8
#define CG_FREQ_TRAN_VOTING_4__UVD_FREQ_THROTTLING_VOTE_EN_MASK 0x200
#define CG_FREQ_TRAN_VOTING_4__UVD_FREQ_THROTTLING_VOTE_EN__SHIFT 0x9
#define CG_FREQ_TRAN_VOTING_4__VCE_FREQ_THROTTLING_VOTE_EN_MASK 0x400
#define CG_FREQ_TRAN_VOTING_4__VCE_FREQ_THROTTLING_VOTE_EN__SHIFT 0xa
#define CG_FREQ_TRAN_VOTING_4__DC_AZ_FREQ_THROTTLING_VOTE_EN_MASK 0x800
#define CG_FREQ_TRAN_VOTING_4__DC_AZ_FREQ_THROTTLING_VOTE_EN__SHIFT 0xb
#define CG_FREQ_TRAN_VOTING_4__SAM_FREQ_THROTTLING_VOTE_EN_MASK 0x1000
#define CG_FREQ_TRAN_VOTING_4__SAM_FREQ_THROTTLING_VOTE_EN__SHIFT 0xc
#define CG_FREQ_TRAN_VOTING_4__AVP_FREQ_THROTTLING_VOTE_EN_MASK 0x2000
#define CG_FREQ_TRAN_VOTING_4__AVP_FREQ_THROTTLING_VOTE_EN__SHIFT 0xd
#define CG_FREQ_TRAN_VOTING_4__GRBM_0_FREQ_THROTTLING_VOTE_EN_MASK 0x4000
#define CG_FREQ_TRAN_VOTING_4__GRBM_0_FREQ_THROTTLING_VOTE_EN__SHIFT 0xe
#define CG_FREQ_TRAN_VOTING_4__GRBM_1_FREQ_THROTTLING_VOTE_EN_MASK 0x8000
#define CG_FREQ_TRAN_VOTING_4__GRBM_1_FREQ_THROTTLING_VOTE_EN__SHIFT 0xf
#define CG_FREQ_TRAN_VOTING_4__GRBM_2_FREQ_THROTTLING_VOTE_EN_MASK 0x10000
#define CG_FREQ_TRAN_VOTING_4__GRBM_2_FREQ_THROTTLING_VOTE_EN__SHIFT 0x10
#define CG_FREQ_TRAN_VOTING_4__GRBM_3_FREQ_THROTTLING_VOTE_EN_MASK 0x20000
#define CG_FREQ_TRAN_VOTING_4__GRBM_3_FREQ_THROTTLING_VOTE_EN__SHIFT 0x11
#define CG_FREQ_TRAN_VOTING_4__GRBM_4_FREQ_THROTTLING_VOTE_EN_MASK 0x40000
#define CG_FREQ_TRAN_VOTING_4__GRBM_4_FREQ_THROTTLING_VOTE_EN__SHIFT 0x12
#define CG_FREQ_TRAN_VOTING_4__GRBM_5_FREQ_THROTTLING_VOTE_EN_MASK 0x80000
#define CG_FREQ_TRAN_VOTING_4__GRBM_5_FREQ_THROTTLING_VOTE_EN__SHIFT 0x13
#define CG_FREQ_TRAN_VOTING_4__GRBM_6_FREQ_THROTTLING_VOTE_EN_MASK 0x100000
#define CG_FREQ_TRAN_VOTING_4__GRBM_6_FREQ_THROTTLING_VOTE_EN__SHIFT 0x14
#define CG_FREQ_TRAN_VOTING_4__GRBM_7_FREQ_THROTTLING_VOTE_EN_MASK 0x200000
#define CG_FREQ_TRAN_VOTING_4__GRBM_7_FREQ_THROTTLING_VOTE_EN__SHIFT 0x15
#define CG_FREQ_TRAN_VOTING_4__GRBM_8_FREQ_THROTTLING_VOTE_EN_MASK 0x400000
#define CG_FREQ_TRAN_VOTING_4__GRBM_8_FREQ_THROTTLING_VOTE_EN__SHIFT 0x16
#define CG_FREQ_TRAN_VOTING_4__GRBM_9_FREQ_THROTTLING_VOTE_EN_MASK 0x800000
#define CG_FREQ_TRAN_VOTING_4__GRBM_9_FREQ_THROTTLING_VOTE_EN__SHIFT 0x17
#define CG_FREQ_TRAN_VOTING_4__GRBM_10_FREQ_THROTTLING_VOTE_EN_MASK 0x1000000
#define CG_FREQ_TRAN_VOTING_4__GRBM_10_FREQ_THROTTLING_VOTE_EN__SHIFT 0x18
#define CG_FREQ_TRAN_VOTING_4__GRBM_11_FREQ_THROTTLING_VOTE_EN_MASK 0x2000000
#define CG_FREQ_TRAN_VOTING_4__GRBM_11_FREQ_THROTTLING_VOTE_EN__SHIFT 0x19
#define CG_FREQ_TRAN_VOTING_4__GRBM_12_FREQ_THROTTLING_VOTE_EN_MASK 0x4000000
#define CG_FREQ_TRAN_VOTING_4__GRBM_12_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1a
#define CG_FREQ_TRAN_VOTING_4__GRBM_13_FREQ_THROTTLING_VOTE_EN_MASK 0x8000000
#define CG_FREQ_TRAN_VOTING_4__GRBM_13_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1b
#define CG_FREQ_TRAN_VOTING_4__GRBM_14_FREQ_THROTTLING_VOTE_EN_MASK 0x10000000
#define CG_FREQ_TRAN_VOTING_4__GRBM_14_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1c
#define CG_FREQ_TRAN_VOTING_4__GRBM_15_FREQ_THROTTLING_VOTE_EN_MASK 0x20000000
#define CG_FREQ_TRAN_VOTING_4__GRBM_15_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1d
#define CG_FREQ_TRAN_VOTING_4__RLC_FREQ_THROTTLING_VOTE_EN_MASK 0x40000000
#define CG_FREQ_TRAN_VOTING_4__RLC_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1e
#define CG_FREQ_TRAN_VOTING_5__BIF_FREQ_THROTTLING_VOTE_EN_MASK 0x1
#define CG_FREQ_TRAN_VOTING_5__BIF_FREQ_THROTTLING_VOTE_EN__SHIFT 0x0
#define CG_FREQ_TRAN_VOTING_5__HDP_FREQ_THROTTLING_VOTE_EN_MASK 0x2
#define CG_FREQ_TRAN_VOTING_5__HDP_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1
#define CG_FREQ_TRAN_VOTING_5__ROM_FREQ_THROTTLING_VOTE_EN_MASK 0x4
#define CG_FREQ_TRAN_VOTING_5__ROM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x2
#define CG_FREQ_TRAN_VOTING_5__IH_SEM_FREQ_THROTTLING_VOTE_EN_MASK 0x8
#define CG_FREQ_TRAN_VOTING_5__IH_SEM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x3
#define CG_FREQ_TRAN_VOTING_5__PDMA_FREQ_THROTTLING_VOTE_EN_MASK 0x10
#define CG_FREQ_TRAN_VOTING_5__PDMA_FREQ_THROTTLING_VOTE_EN__SHIFT 0x4
#define CG_FREQ_TRAN_VOTING_5__DRM_FREQ_THROTTLING_VOTE_EN_MASK 0x20
#define CG_FREQ_TRAN_VOTING_5__DRM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x5
#define CG_FREQ_TRAN_VOTING_5__IDCT_FREQ_THROTTLING_VOTE_EN_MASK 0x40
#define CG_FREQ_TRAN_VOTING_5__IDCT_FREQ_THROTTLING_VOTE_EN__SHIFT 0x6
#define CG_FREQ_TRAN_VOTING_5__ACP_FREQ_THROTTLING_VOTE_EN_MASK 0x80
#define CG_FREQ_TRAN_VOTING_5__ACP_FREQ_THROTTLING_VOTE_EN__SHIFT 0x7
#define CG_FREQ_TRAN_VOTING_5__SDMA_FREQ_THROTTLING_VOTE_EN_MASK 0x100
#define CG_FREQ_TRAN_VOTING_5__SDMA_FREQ_THROTTLING_VOTE_EN__SHIFT 0x8
#define CG_FREQ_TRAN_VOTING_5__UVD_FREQ_THROTTLING_VOTE_EN_MASK 0x200
#define CG_FREQ_TRAN_VOTING_5__UVD_FREQ_THROTTLING_VOTE_EN__SHIFT 0x9
#define CG_FREQ_TRAN_VOTING_5__VCE_FREQ_THROTTLING_VOTE_EN_MASK 0x400
#define CG_FREQ_TRAN_VOTING_5__VCE_FREQ_THROTTLING_VOTE_EN__SHIFT 0xa
#define CG_FREQ_TRAN_VOTING_5__DC_AZ_FREQ_THROTTLING_VOTE_EN_MASK 0x800
#define CG_FREQ_TRAN_VOTING_5__DC_AZ_FREQ_THROTTLING_VOTE_EN__SHIFT 0xb
#define CG_FREQ_TRAN_VOTING_5__SAM_FREQ_THROTTLING_VOTE_EN_MASK 0x1000
#define CG_FREQ_TRAN_VOTING_5__SAM_FREQ_THROTTLING_VOTE_EN__SHIFT 0xc
#define CG_FREQ_TRAN_VOTING_5__AVP_FREQ_THROTTLING_VOTE_EN_MASK 0x2000
#define CG_FREQ_TRAN_VOTING_5__AVP_FREQ_THROTTLING_VOTE_EN__SHIFT 0xd
#define CG_FREQ_TRAN_VOTING_5__GRBM_0_FREQ_THROTTLING_VOTE_EN_MASK 0x4000
#define CG_FREQ_TRAN_VOTING_5__GRBM_0_FREQ_THROTTLING_VOTE_EN__SHIFT 0xe
#define CG_FREQ_TRAN_VOTING_5__GRBM_1_FREQ_THROTTLING_VOTE_EN_MASK 0x8000
#define CG_FREQ_TRAN_VOTING_5__GRBM_1_FREQ_THROTTLING_VOTE_EN__SHIFT 0xf
#define CG_FREQ_TRAN_VOTING_5__GRBM_2_FREQ_THROTTLING_VOTE_EN_MASK 0x10000
#define CG_FREQ_TRAN_VOTING_5__GRBM_2_FREQ_THROTTLING_VOTE_EN__SHIFT 0x10
#define CG_FREQ_TRAN_VOTING_5__GRBM_3_FREQ_THROTTLING_VOTE_EN_MASK 0x20000
#define CG_FREQ_TRAN_VOTING_5__GRBM_3_FREQ_THROTTLING_VOTE_EN__SHIFT 0x11
#define CG_FREQ_TRAN_VOTING_5__GRBM_4_FREQ_THROTTLING_VOTE_EN_MASK 0x40000
#define CG_FREQ_TRAN_VOTING_5__GRBM_4_FREQ_THROTTLING_VOTE_EN__SHIFT 0x12
#define CG_FREQ_TRAN_VOTING_5__GRBM_5_FREQ_THROTTLING_VOTE_EN_MASK 0x80000
#define CG_FREQ_TRAN_VOTING_5__GRBM_5_FREQ_THROTTLING_VOTE_EN__SHIFT 0x13
#define CG_FREQ_TRAN_VOTING_5__GRBM_6_FREQ_THROTTLING_VOTE_EN_MASK 0x100000
#define CG_FREQ_TRAN_VOTING_5__GRBM_6_FREQ_THROTTLING_VOTE_EN__SHIFT 0x14
#define CG_FREQ_TRAN_VOTING_5__GRBM_7_FREQ_THROTTLING_VOTE_EN_MASK 0x200000
#define CG_FREQ_TRAN_VOTING_5__GRBM_7_FREQ_THROTTLING_VOTE_EN__SHIFT 0x15
#define CG_FREQ_TRAN_VOTING_5__GRBM_8_FREQ_THROTTLING_VOTE_EN_MASK 0x400000
#define CG_FREQ_TRAN_VOTING_5__GRBM_8_FREQ_THROTTLING_VOTE_EN__SHIFT 0x16
#define CG_FREQ_TRAN_VOTING_5__GRBM_9_FREQ_THROTTLING_VOTE_EN_MASK 0x800000
#define CG_FREQ_TRAN_VOTING_5__GRBM_9_FREQ_THROTTLING_VOTE_EN__SHIFT 0x17
#define CG_FREQ_TRAN_VOTING_5__GRBM_10_FREQ_THROTTLING_VOTE_EN_MASK 0x1000000
#define CG_FREQ_TRAN_VOTING_5__GRBM_10_FREQ_THROTTLING_VOTE_EN__SHIFT 0x18
#define CG_FREQ_TRAN_VOTING_5__GRBM_11_FREQ_THROTTLING_VOTE_EN_MASK 0x2000000
#define CG_FREQ_TRAN_VOTING_5__GRBM_11_FREQ_THROTTLING_VOTE_EN__SHIFT 0x19
#define CG_FREQ_TRAN_VOTING_5__GRBM_12_FREQ_THROTTLING_VOTE_EN_MASK 0x4000000
#define CG_FREQ_TRAN_VOTING_5__GRBM_12_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1a
#define CG_FREQ_TRAN_VOTING_5__GRBM_13_FREQ_THROTTLING_VOTE_EN_MASK 0x8000000
#define CG_FREQ_TRAN_VOTING_5__GRBM_13_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1b
#define CG_FREQ_TRAN_VOTING_5__GRBM_14_FREQ_THROTTLING_VOTE_EN_MASK 0x10000000
#define CG_FREQ_TRAN_VOTING_5__GRBM_14_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1c
#define CG_FREQ_TRAN_VOTING_5__GRBM_15_FREQ_THROTTLING_VOTE_EN_MASK 0x20000000
#define CG_FREQ_TRAN_VOTING_5__GRBM_15_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1d
#define CG_FREQ_TRAN_VOTING_5__RLC_FREQ_THROTTLING_VOTE_EN_MASK 0x40000000
#define CG_FREQ_TRAN_VOTING_5__RLC_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1e
#define CG_FREQ_TRAN_VOTING_6__BIF_FREQ_THROTTLING_VOTE_EN_MASK 0x1
#define CG_FREQ_TRAN_VOTING_6__BIF_FREQ_THROTTLING_VOTE_EN__SHIFT 0x0
#define CG_FREQ_TRAN_VOTING_6__HDP_FREQ_THROTTLING_VOTE_EN_MASK 0x2
#define CG_FREQ_TRAN_VOTING_6__HDP_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1
#define CG_FREQ_TRAN_VOTING_6__ROM_FREQ_THROTTLING_VOTE_EN_MASK 0x4
#define CG_FREQ_TRAN_VOTING_6__ROM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x2
#define CG_FREQ_TRAN_VOTING_6__IH_SEM_FREQ_THROTTLING_VOTE_EN_MASK 0x8
#define CG_FREQ_TRAN_VOTING_6__IH_SEM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x3
#define CG_FREQ_TRAN_VOTING_6__PDMA_FREQ_THROTTLING_VOTE_EN_MASK 0x10
#define CG_FREQ_TRAN_VOTING_6__PDMA_FREQ_THROTTLING_VOTE_EN__SHIFT 0x4
#define CG_FREQ_TRAN_VOTING_6__DRM_FREQ_THROTTLING_VOTE_EN_MASK 0x20
#define CG_FREQ_TRAN_VOTING_6__DRM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x5
#define CG_FREQ_TRAN_VOTING_6__IDCT_FREQ_THROTTLING_VOTE_EN_MASK 0x40
#define CG_FREQ_TRAN_VOTING_6__IDCT_FREQ_THROTTLING_VOTE_EN__SHIFT 0x6
#define CG_FREQ_TRAN_VOTING_6__ACP_FREQ_THROTTLING_VOTE_EN_MASK 0x80
#define CG_FREQ_TRAN_VOTING_6__ACP_FREQ_THROTTLING_VOTE_EN__SHIFT 0x7
#define CG_FREQ_TRAN_VOTING_6__SDMA_FREQ_THROTTLING_VOTE_EN_MASK 0x100
#define CG_FREQ_TRAN_VOTING_6__SDMA_FREQ_THROTTLING_VOTE_EN__SHIFT 0x8
#define CG_FREQ_TRAN_VOTING_6__UVD_FREQ_THROTTLING_VOTE_EN_MASK 0x200
#define CG_FREQ_TRAN_VOTING_6__UVD_FREQ_THROTTLING_VOTE_EN__SHIFT 0x9
#define CG_FREQ_TRAN_VOTING_6__VCE_FREQ_THROTTLING_VOTE_EN_MASK 0x400
#define CG_FREQ_TRAN_VOTING_6__VCE_FREQ_THROTTLING_VOTE_EN__SHIFT 0xa
#define CG_FREQ_TRAN_VOTING_6__DC_AZ_FREQ_THROTTLING_VOTE_EN_MASK 0x800
#define CG_FREQ_TRAN_VOTING_6__DC_AZ_FREQ_THROTTLING_VOTE_EN__SHIFT 0xb
#define CG_FREQ_TRAN_VOTING_6__SAM_FREQ_THROTTLING_VOTE_EN_MASK 0x1000
#define CG_FREQ_TRAN_VOTING_6__SAM_FREQ_THROTTLING_VOTE_EN__SHIFT 0xc
#define CG_FREQ_TRAN_VOTING_6__AVP_FREQ_THROTTLING_VOTE_EN_MASK 0x2000
#define CG_FREQ_TRAN_VOTING_6__AVP_FREQ_THROTTLING_VOTE_EN__SHIFT 0xd
#define CG_FREQ_TRAN_VOTING_6__GRBM_0_FREQ_THROTTLING_VOTE_EN_MASK 0x4000
#define CG_FREQ_TRAN_VOTING_6__GRBM_0_FREQ_THROTTLING_VOTE_EN__SHIFT 0xe
#define CG_FREQ_TRAN_VOTING_6__GRBM_1_FREQ_THROTTLING_VOTE_EN_MASK 0x8000
#define CG_FREQ_TRAN_VOTING_6__GRBM_1_FREQ_THROTTLING_VOTE_EN__SHIFT 0xf
#define CG_FREQ_TRAN_VOTING_6__GRBM_2_FREQ_THROTTLING_VOTE_EN_MASK 0x10000
#define CG_FREQ_TRAN_VOTING_6__GRBM_2_FREQ_THROTTLING_VOTE_EN__SHIFT 0x10
#define CG_FREQ_TRAN_VOTING_6__GRBM_3_FREQ_THROTTLING_VOTE_EN_MASK 0x20000
#define CG_FREQ_TRAN_VOTING_6__GRBM_3_FREQ_THROTTLING_VOTE_EN__SHIFT 0x11
#define CG_FREQ_TRAN_VOTING_6__GRBM_4_FREQ_THROTTLING_VOTE_EN_MASK 0x40000
#define CG_FREQ_TRAN_VOTING_6__GRBM_4_FREQ_THROTTLING_VOTE_EN__SHIFT 0x12
#define CG_FREQ_TRAN_VOTING_6__GRBM_5_FREQ_THROTTLING_VOTE_EN_MASK 0x80000
#define CG_FREQ_TRAN_VOTING_6__GRBM_5_FREQ_THROTTLING_VOTE_EN__SHIFT 0x13
#define CG_FREQ_TRAN_VOTING_6__GRBM_6_FREQ_THROTTLING_VOTE_EN_MASK 0x100000
#define CG_FREQ_TRAN_VOTING_6__GRBM_6_FREQ_THROTTLING_VOTE_EN__SHIFT 0x14
#define CG_FREQ_TRAN_VOTING_6__GRBM_7_FREQ_THROTTLING_VOTE_EN_MASK 0x200000
#define CG_FREQ_TRAN_VOTING_6__GRBM_7_FREQ_THROTTLING_VOTE_EN__SHIFT 0x15
#define CG_FREQ_TRAN_VOTING_6__GRBM_8_FREQ_THROTTLING_VOTE_EN_MASK 0x400000
#define CG_FREQ_TRAN_VOTING_6__GRBM_8_FREQ_THROTTLING_VOTE_EN__SHIFT 0x16
#define CG_FREQ_TRAN_VOTING_6__GRBM_9_FREQ_THROTTLING_VOTE_EN_MASK 0x800000
#define CG_FREQ_TRAN_VOTING_6__GRBM_9_FREQ_THROTTLING_VOTE_EN__SHIFT 0x17
#define CG_FREQ_TRAN_VOTING_6__GRBM_10_FREQ_THROTTLING_VOTE_EN_MASK 0x1000000
#define CG_FREQ_TRAN_VOTING_6__GRBM_10_FREQ_THROTTLING_VOTE_EN__SHIFT 0x18
#define CG_FREQ_TRAN_VOTING_6__GRBM_11_FREQ_THROTTLING_VOTE_EN_MASK 0x2000000
#define CG_FREQ_TRAN_VOTING_6__GRBM_11_FREQ_THROTTLING_VOTE_EN__SHIFT 0x19
#define CG_FREQ_TRAN_VOTING_6__GRBM_12_FREQ_THROTTLING_VOTE_EN_MASK 0x4000000
#define CG_FREQ_TRAN_VOTING_6__GRBM_12_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1a
#define CG_FREQ_TRAN_VOTING_6__GRBM_13_FREQ_THROTTLING_VOTE_EN_MASK 0x8000000
#define CG_FREQ_TRAN_VOTING_6__GRBM_13_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1b
#define CG_FREQ_TRAN_VOTING_6__GRBM_14_FREQ_THROTTLING_VOTE_EN_MASK 0x10000000
#define CG_FREQ_TRAN_VOTING_6__GRBM_14_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1c
#define CG_FREQ_TRAN_VOTING_6__GRBM_15_FREQ_THROTTLING_VOTE_EN_MASK 0x20000000
#define CG_FREQ_TRAN_VOTING_6__GRBM_15_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1d
#define CG_FREQ_TRAN_VOTING_6__RLC_FREQ_THROTTLING_VOTE_EN_MASK 0x40000000
#define CG_FREQ_TRAN_VOTING_6__RLC_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1e
#define CG_FREQ_TRAN_VOTING_7__BIF_FREQ_THROTTLING_VOTE_EN_MASK 0x1
#define CG_FREQ_TRAN_VOTING_7__BIF_FREQ_THROTTLING_VOTE_EN__SHIFT 0x0
#define CG_FREQ_TRAN_VOTING_7__HDP_FREQ_THROTTLING_VOTE_EN_MASK 0x2
#define CG_FREQ_TRAN_VOTING_7__HDP_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1
#define CG_FREQ_TRAN_VOTING_7__ROM_FREQ_THROTTLING_VOTE_EN_MASK 0x4
#define CG_FREQ_TRAN_VOTING_7__ROM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x2
#define CG_FREQ_TRAN_VOTING_7__IH_SEM_FREQ_THROTTLING_VOTE_EN_MASK 0x8
#define CG_FREQ_TRAN_VOTING_7__IH_SEM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x3
#define CG_FREQ_TRAN_VOTING_7__PDMA_FREQ_THROTTLING_VOTE_EN_MASK 0x10
#define CG_FREQ_TRAN_VOTING_7__PDMA_FREQ_THROTTLING_VOTE_EN__SHIFT 0x4
#define CG_FREQ_TRAN_VOTING_7__DRM_FREQ_THROTTLING_VOTE_EN_MASK 0x20
#define CG_FREQ_TRAN_VOTING_7__DRM_FREQ_THROTTLING_VOTE_EN__SHIFT 0x5
#define CG_FREQ_TRAN_VOTING_7__IDCT_FREQ_THROTTLING_VOTE_EN_MASK 0x40
#define CG_FREQ_TRAN_VOTING_7__IDCT_FREQ_THROTTLING_VOTE_EN__SHIFT 0x6
#define CG_FREQ_TRAN_VOTING_7__ACP_FREQ_THROTTLING_VOTE_EN_MASK 0x80
#define CG_FREQ_TRAN_VOTING_7__ACP_FREQ_THROTTLING_VOTE_EN__SHIFT 0x7
#define CG_FREQ_TRAN_VOTING_7__SDMA_FREQ_THROTTLING_VOTE_EN_MASK 0x100
#define CG_FREQ_TRAN_VOTING_7__SDMA_FREQ_THROTTLING_VOTE_EN__SHIFT 0x8
#define CG_FREQ_TRAN_VOTING_7__UVD_FREQ_THROTTLING_VOTE_EN_MASK 0x200
#define CG_FREQ_TRAN_VOTING_7__UVD_FREQ_THROTTLING_VOTE_EN__SHIFT 0x9
#define CG_FREQ_TRAN_VOTING_7__VCE_FREQ_THROTTLING_VOTE_EN_MASK 0x400
#define CG_FREQ_TRAN_VOTING_7__VCE_FREQ_THROTTLING_VOTE_EN__SHIFT 0xa
#define CG_FREQ_TRAN_VOTING_7__DC_AZ_FREQ_THROTTLING_VOTE_EN_MASK 0x800
#define CG_FREQ_TRAN_VOTING_7__DC_AZ_FREQ_THROTTLING_VOTE_EN__SHIFT 0xb
#define CG_FREQ_TRAN_VOTING_7__SAM_FREQ_THROTTLING_VOTE_EN_MASK 0x1000
#define CG_FREQ_TRAN_VOTING_7__SAM_FREQ_THROTTLING_VOTE_EN__SHIFT 0xc
#define CG_FREQ_TRAN_VOTING_7__AVP_FREQ_THROTTLING_VOTE_EN_MASK 0x2000
#define CG_FREQ_TRAN_VOTING_7__AVP_FREQ_THROTTLING_VOTE_EN__SHIFT 0xd
#define CG_FREQ_TRAN_VOTING_7__GRBM_0_FREQ_THROTTLING_VOTE_EN_MASK 0x4000
#define CG_FREQ_TRAN_VOTING_7__GRBM_0_FREQ_THROTTLING_VOTE_EN__SHIFT 0xe
#define CG_FREQ_TRAN_VOTING_7__GRBM_1_FREQ_THROTTLING_VOTE_EN_MASK 0x8000
#define CG_FREQ_TRAN_VOTING_7__GRBM_1_FREQ_THROTTLING_VOTE_EN__SHIFT 0xf
#define CG_FREQ_TRAN_VOTING_7__GRBM_2_FREQ_THROTTLING_VOTE_EN_MASK 0x10000
#define CG_FREQ_TRAN_VOTING_7__GRBM_2_FREQ_THROTTLING_VOTE_EN__SHIFT 0x10
#define CG_FREQ_TRAN_VOTING_7__GRBM_3_FREQ_THROTTLING_VOTE_EN_MASK 0x20000
#define CG_FREQ_TRAN_VOTING_7__GRBM_3_FREQ_THROTTLING_VOTE_EN__SHIFT 0x11
#define CG_FREQ_TRAN_VOTING_7__GRBM_4_FREQ_THROTTLING_VOTE_EN_MASK 0x40000
#define CG_FREQ_TRAN_VOTING_7__GRBM_4_FREQ_THROTTLING_VOTE_EN__SHIFT 0x12
#define CG_FREQ_TRAN_VOTING_7__GRBM_5_FREQ_THROTTLING_VOTE_EN_MASK 0x80000
#define CG_FREQ_TRAN_VOTING_7__GRBM_5_FREQ_THROTTLING_VOTE_EN__SHIFT 0x13
#define CG_FREQ_TRAN_VOTING_7__GRBM_6_FREQ_THROTTLING_VOTE_EN_MASK 0x100000
#define CG_FREQ_TRAN_VOTING_7__GRBM_6_FREQ_THROTTLING_VOTE_EN__SHIFT 0x14
#define CG_FREQ_TRAN_VOTING_7__GRBM_7_FREQ_THROTTLING_VOTE_EN_MASK 0x200000
#define CG_FREQ_TRAN_VOTING_7__GRBM_7_FREQ_THROTTLING_VOTE_EN__SHIFT 0x15
#define CG_FREQ_TRAN_VOTING_7__GRBM_8_FREQ_THROTTLING_VOTE_EN_MASK 0x400000
#define CG_FREQ_TRAN_VOTING_7__GRBM_8_FREQ_THROTTLING_VOTE_EN__SHIFT 0x16
#define CG_FREQ_TRAN_VOTING_7__GRBM_9_FREQ_THROTTLING_VOTE_EN_MASK 0x800000
#define CG_FREQ_TRAN_VOTING_7__GRBM_9_FREQ_THROTTLING_VOTE_EN__SHIFT 0x17
#define CG_FREQ_TRAN_VOTING_7__GRBM_10_FREQ_THROTTLING_VOTE_EN_MASK 0x1000000
#define CG_FREQ_TRAN_VOTING_7__GRBM_10_FREQ_THROTTLING_VOTE_EN__SHIFT 0x18
#define CG_FREQ_TRAN_VOTING_7__GRBM_11_FREQ_THROTTLING_VOTE_EN_MASK 0x2000000
#define CG_FREQ_TRAN_VOTING_7__GRBM_11_FREQ_THROTTLING_VOTE_EN__SHIFT 0x19
#define CG_FREQ_TRAN_VOTING_7__GRBM_12_FREQ_THROTTLING_VOTE_EN_MASK 0x4000000
#define CG_FREQ_TRAN_VOTING_7__GRBM_12_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1a
#define CG_FREQ_TRAN_VOTING_7__GRBM_13_FREQ_THROTTLING_VOTE_EN_MASK 0x8000000
#define CG_FREQ_TRAN_VOTING_7__GRBM_13_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1b
#define CG_FREQ_TRAN_VOTING_7__GRBM_14_FREQ_THROTTLING_VOTE_EN_MASK 0x10000000
#define CG_FREQ_TRAN_VOTING_7__GRBM_14_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1c
#define CG_FREQ_TRAN_VOTING_7__GRBM_15_FREQ_THROTTLING_VOTE_EN_MASK 0x20000000
#define CG_FREQ_TRAN_VOTING_7__GRBM_15_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1d
#define CG_FREQ_TRAN_VOTING_7__RLC_FREQ_THROTTLING_VOTE_EN_MASK 0x40000000
#define CG_FREQ_TRAN_VOTING_7__RLC_FREQ_THROTTLING_VOTE_EN__SHIFT 0x1e
#define PLL_TEST_CNTL__TST_SRC_SEL_MASK 0xf
#define PLL_TEST_CNTL__TST_SRC_SEL__SHIFT 0x0
#define PLL_TEST_CNTL__TST_REF_SEL_MASK 0xf0
#define PLL_TEST_CNTL__TST_REF_SEL__SHIFT 0x4
#define PLL_TEST_CNTL__REF_TEST_COUNT_MASK 0x7f00
#define PLL_TEST_CNTL__REF_TEST_COUNT__SHIFT 0x8
#define PLL_TEST_CNTL__TST_RESET_MASK 0x8000
#define PLL_TEST_CNTL__TST_RESET__SHIFT 0xf
#define PLL_TEST_CNTL__TEST_COUNT_MASK 0xfffe0000
#define PLL_TEST_CNTL__TEST_COUNT__SHIFT 0x11
#define CG_STATIC_SCREEN_PARAMETER__STATIC_SCREEN_THRESHOLD_MASK 0xffff
#define CG_STATIC_SCREEN_PARAMETER__STATIC_SCREEN_THRESHOLD__SHIFT 0x0
#define CG_STATIC_SCREEN_PARAMETER__STATIC_SCREEN_THRESHOLD_UNIT_MASK 0xf0000
#define CG_STATIC_SCREEN_PARAMETER__STATIC_SCREEN_THRESHOLD_UNIT__SHIFT 0x10
#define CG_DISPLAY_GAP_CNTL__DISP_GAP_MASK 0x3
#define CG_DISPLAY_GAP_CNTL__DISP_GAP__SHIFT 0x0
#define CG_DISPLAY_GAP_CNTL__VBI_TIMER_COUNT_MASK 0x3fff0
#define CG_DISPLAY_GAP_CNTL__VBI_TIMER_COUNT__SHIFT 0x4
#define CG_DISPLAY_GAP_CNTL__VBI_TIMER_UNIT_MASK 0x700000
#define CG_DISPLAY_GAP_CNTL__VBI_TIMER_UNIT__SHIFT 0x14
#define CG_DISPLAY_GAP_CNTL__DISP_GAP_MCHG_MASK 0x3000000
#define CG_DISPLAY_GAP_CNTL__DISP_GAP_MCHG__SHIFT 0x18
#define CG_DISPLAY_GAP_CNTL__VBI_TIMER_DISABLE_MASK 0x10000000
#define CG_DISPLAY_GAP_CNTL__VBI_TIMER_DISABLE__SHIFT 0x1c
#define CG_DISPLAY_GAP_CNTL2__VBI_PREDICTION_MASK 0xffffffff
#define CG_DISPLAY_GAP_CNTL2__VBI_PREDICTION__SHIFT 0x0
#define CG_ACPI_CNTL__SCLK_ACPI_DIV_MASK 0x7f
#define CG_ACPI_CNTL__SCLK_ACPI_DIV__SHIFT 0x0
#define CG_ACPI_CNTL__SCLK_CHANGE_SKIP_MASK 0x80
#define CG_ACPI_CNTL__SCLK_CHANGE_SKIP__SHIFT 0x7
#define SCLK_DEEP_SLEEP_CNTL__DIV_ID_MASK 0x7
#define SCLK_DEEP_SLEEP_CNTL__DIV_ID__SHIFT 0x0
#define SCLK_DEEP_SLEEP_CNTL__RAMP_DIS_MASK 0x8
#define SCLK_DEEP_SLEEP_CNTL__RAMP_DIS__SHIFT 0x3
#define SCLK_DEEP_SLEEP_CNTL__HYSTERESIS_MASK 0xfff0
#define SCLK_DEEP_SLEEP_CNTL__HYSTERESIS__SHIFT 0x4
#define SCLK_DEEP_SLEEP_CNTL__SCLK_RUNNING_MASK_MASK 0x10000
#define SCLK_DEEP_SLEEP_CNTL__SCLK_RUNNING_MASK__SHIFT 0x10
#define SCLK_DEEP_SLEEP_CNTL__SELF_REFRESH_MASK_MASK 0x20000
#define SCLK_DEEP_SLEEP_CNTL__SELF_REFRESH_MASK__SHIFT 0x11
#define SCLK_DEEP_SLEEP_CNTL__ALLOW_NBPSTATE_MASK_MASK 0x40000
#define SCLK_DEEP_SLEEP_CNTL__ALLOW_NBPSTATE_MASK__SHIFT 0x12
#define SCLK_DEEP_SLEEP_CNTL__BIF_BUSY_MASK_MASK 0x80000
#define SCLK_DEEP_SLEEP_CNTL__BIF_BUSY_MASK__SHIFT 0x13
#define SCLK_DEEP_SLEEP_CNTL__UVD_BUSY_MASK_MASK 0x100000
#define SCLK_DEEP_SLEEP_CNTL__UVD_BUSY_MASK__SHIFT 0x14
#define SCLK_DEEP_SLEEP_CNTL__MC0SRBM_BUSY_MASK_MASK 0x200000
#define SCLK_DEEP_SLEEP_CNTL__MC0SRBM_BUSY_MASK__SHIFT 0x15
#define SCLK_DEEP_SLEEP_CNTL__MC1SRBM_BUSY_MASK_MASK 0x400000
#define SCLK_DEEP_SLEEP_CNTL__MC1SRBM_BUSY_MASK__SHIFT 0x16
#define SCLK_DEEP_SLEEP_CNTL__MC_ALLOW_MASK_MASK 0x800000
#define SCLK_DEEP_SLEEP_CNTL__MC_ALLOW_MASK__SHIFT 0x17
#define SCLK_DEEP_SLEEP_CNTL__SMU_BUSY_MASK_MASK 0x1000000
#define SCLK_DEEP_SLEEP_CNTL__SMU_BUSY_MASK__SHIFT 0x18
#define SCLK_DEEP_SLEEP_CNTL__SELF_REFRESH_NLC_MASK_MASK 0x2000000
#define SCLK_DEEP_SLEEP_CNTL__SELF_REFRESH_NLC_MASK__SHIFT 0x19
#define SCLK_DEEP_SLEEP_CNTL__FAST_EXIT_REQ_NBPSTATE_MASK 0x4000000
#define SCLK_DEEP_SLEEP_CNTL__FAST_EXIT_REQ_NBPSTATE__SHIFT 0x1a
#define SCLK_DEEP_SLEEP_CNTL__DEEP_SLEEP_ENTRY_MODE_MASK 0x8000000
#define SCLK_DEEP_SLEEP_CNTL__DEEP_SLEEP_ENTRY_MODE__SHIFT 0x1b
#define SCLK_DEEP_SLEEP_CNTL__MBUS2_ACTIVE_MASK_MASK 0x10000000
#define SCLK_DEEP_SLEEP_CNTL__MBUS2_ACTIVE_MASK__SHIFT 0x1c
#define SCLK_DEEP_SLEEP_CNTL__VCE_BUSY_MASK_MASK 0x20000000
#define SCLK_DEEP_SLEEP_CNTL__VCE_BUSY_MASK__SHIFT 0x1d
#define SCLK_DEEP_SLEEP_CNTL__AZ_BUSY_MASK_MASK 0x40000000
#define SCLK_DEEP_SLEEP_CNTL__AZ_BUSY_MASK__SHIFT 0x1e
#define SCLK_DEEP_SLEEP_CNTL__ENABLE_DS_MASK 0x80000000
#define SCLK_DEEP_SLEEP_CNTL__ENABLE_DS__SHIFT 0x1f
#define SCLK_DEEP_SLEEP_CNTL2__RLC_BUSY_MASK_MASK 0x1
#define SCLK_DEEP_SLEEP_CNTL2__RLC_BUSY_MASK__SHIFT 0x0
#define SCLK_DEEP_SLEEP_CNTL2__HDP_BUSY_MASK_MASK 0x2
#define SCLK_DEEP_SLEEP_CNTL2__HDP_BUSY_MASK__SHIFT 0x1
#define SCLK_DEEP_SLEEP_CNTL2__ROM_BUSY_MASK_MASK 0x4
#define SCLK_DEEP_SLEEP_CNTL2__ROM_BUSY_MASK__SHIFT 0x2
#define SCLK_DEEP_SLEEP_CNTL2__IH_SEM_BUSY_MASK_MASK 0x8
#define SCLK_DEEP_SLEEP_CNTL2__IH_SEM_BUSY_MASK__SHIFT 0x3
#define SCLK_DEEP_SLEEP_CNTL2__PDMA_BUSY_MASK_MASK 0x10
#define SCLK_DEEP_SLEEP_CNTL2__PDMA_BUSY_MASK__SHIFT 0x4
#define SCLK_DEEP_SLEEP_CNTL2__IDCT_BUSY_MASK_MASK 0x40
#define SCLK_DEEP_SLEEP_CNTL2__IDCT_BUSY_MASK__SHIFT 0x6
#define SCLK_DEEP_SLEEP_CNTL2__SDMA_BUSY_MASK_MASK 0x80
#define SCLK_DEEP_SLEEP_CNTL2__SDMA_BUSY_MASK__SHIFT 0x7
#define SCLK_DEEP_SLEEP_CNTL2__DC_AZ_BUSY_MASK_MASK 0x100
#define SCLK_DEEP_SLEEP_CNTL2__DC_AZ_BUSY_MASK__SHIFT 0x8
#define SCLK_DEEP_SLEEP_CNTL2__ACP_SMU_ALLOW_DSLEEP_STUTTER_MASK_MASK 0x200
#define SCLK_DEEP_SLEEP_CNTL2__ACP_SMU_ALLOW_DSLEEP_STUTTER_MASK__SHIFT 0x9
#define SCLK_DEEP_SLEEP_CNTL2__UVD_CG_MC_STAT_BUSY_MASK_MASK 0x400
#define SCLK_DEEP_SLEEP_CNTL2__UVD_CG_MC_STAT_BUSY_MASK__SHIFT 0xa
#define SCLK_DEEP_SLEEP_CNTL2__VCE_CG_MC_STAT_BUSY_MASK_MASK 0x800
#define SCLK_DEEP_SLEEP_CNTL2__VCE_CG_MC_STAT_BUSY_MASK__SHIFT 0xb
#define SCLK_DEEP_SLEEP_CNTL2__SAM_CG_MC_STAT_BUSY_MASK_MASK 0x1000
#define SCLK_DEEP_SLEEP_CNTL2__SAM_CG_MC_STAT_BUSY_MASK__SHIFT 0xc
#define SCLK_DEEP_SLEEP_CNTL2__SAM_CG_STATUS_BUSY_MASK_MASK 0x2000
#define SCLK_DEEP_SLEEP_CNTL2__SAM_CG_STATUS_BUSY_MASK__SHIFT 0xd
#define SCLK_DEEP_SLEEP_CNTL2__RLC_SMU_GFXCLK_OFF_MASK_MASK 0x4000
#define SCLK_DEEP_SLEEP_CNTL2__RLC_SMU_GFXCLK_OFF_MASK__SHIFT 0xe
#define SCLK_DEEP_SLEEP_CNTL2__SHALLOW_DIV_ID_MASK 0xe00000
#define SCLK_DEEP_SLEEP_CNTL2__SHALLOW_DIV_ID__SHIFT 0x15
#define SCLK_DEEP_SLEEP_CNTL2__INOUT_CUSHION_MASK 0xff000000
#define SCLK_DEEP_SLEEP_CNTL2__INOUT_CUSHION__SHIFT 0x18
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_0_SMU_BUSY_MASK_MASK 0x1
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_0_SMU_BUSY_MASK__SHIFT 0x0
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_1_SMU_BUSY_MASK_MASK 0x2
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_1_SMU_BUSY_MASK__SHIFT 0x1
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_2_SMU_BUSY_MASK_MASK 0x4
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_2_SMU_BUSY_MASK__SHIFT 0x2
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_3_SMU_BUSY_MASK_MASK 0x8
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_3_SMU_BUSY_MASK__SHIFT 0x3
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_4_SMU_BUSY_MASK_MASK 0x10
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_4_SMU_BUSY_MASK__SHIFT 0x4
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_5_SMU_BUSY_MASK_MASK 0x20
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_5_SMU_BUSY_MASK__SHIFT 0x5
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_6_SMU_BUSY_MASK_MASK 0x40
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_6_SMU_BUSY_MASK__SHIFT 0x6
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_7_SMU_BUSY_MASK_MASK 0x80
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_7_SMU_BUSY_MASK__SHIFT 0x7
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_8_SMU_BUSY_MASK_MASK 0x100
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_8_SMU_BUSY_MASK__SHIFT 0x8
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_9_SMU_BUSY_MASK_MASK 0x200
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_9_SMU_BUSY_MASK__SHIFT 0x9
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_10_SMU_BUSY_MASK_MASK 0x400
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_10_SMU_BUSY_MASK__SHIFT 0xa
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_11_SMU_BUSY_MASK_MASK 0x800
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_11_SMU_BUSY_MASK__SHIFT 0xb
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_12_SMU_BUSY_MASK_MASK 0x1000
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_12_SMU_BUSY_MASK__SHIFT 0xc
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_13_SMU_BUSY_MASK_MASK 0x2000
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_13_SMU_BUSY_MASK__SHIFT 0xd
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_14_SMU_BUSY_MASK_MASK 0x4000
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_14_SMU_BUSY_MASK__SHIFT 0xe
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_15_SMU_BUSY_MASK_MASK 0x8000
#define SCLK_DEEP_SLEEP_CNTL3__GRBM_15_SMU_BUSY_MASK__SHIFT 0xf
#define SCLK_DEEP_SLEEP_MISC_CNTL__DPM_DS_DIV_ID_MASK 0x7
#define SCLK_DEEP_SLEEP_MISC_CNTL__DPM_DS_DIV_ID__SHIFT 0x0
#define SCLK_DEEP_SLEEP_MISC_CNTL__DPM_SS_DIV_ID_MASK 0x38
#define SCLK_DEEP_SLEEP_MISC_CNTL__DPM_SS_DIV_ID__SHIFT 0x3
#define SCLK_DEEP_SLEEP_MISC_CNTL__OCP_ENABLE_MASK 0x10000
#define SCLK_DEEP_SLEEP_MISC_CNTL__OCP_ENABLE__SHIFT 0x10
#define SCLK_DEEP_SLEEP_MISC_CNTL__OCP_DS_DIV_ID_MASK 0xe0000
#define SCLK_DEEP_SLEEP_MISC_CNTL__OCP_DS_DIV_ID__SHIFT 0x11
#define SCLK_DEEP_SLEEP_MISC_CNTL__OCP_SS_DIV_ID_MASK 0x700000
#define SCLK_DEEP_SLEEP_MISC_CNTL__OCP_SS_DIV_ID__SHIFT 0x14
#define LCLK_DEEP_SLEEP_CNTL__DIV_ID_MASK 0x7
#define LCLK_DEEP_SLEEP_CNTL__DIV_ID__SHIFT 0x0
#define LCLK_DEEP_SLEEP_CNTL__RAMP_DIS_MASK 0x8
#define LCLK_DEEP_SLEEP_CNTL__RAMP_DIS__SHIFT 0x3
#define LCLK_DEEP_SLEEP_CNTL__HYSTERESIS_MASK 0xfff0
#define LCLK_DEEP_SLEEP_CNTL__HYSTERESIS__SHIFT 0x4
#define LCLK_DEEP_SLEEP_CNTL__RESERVED_MASK 0x7fff0000
#define LCLK_DEEP_SLEEP_CNTL__RESERVED__SHIFT 0x10
#define LCLK_DEEP_SLEEP_CNTL__ENABLE_DS_MASK 0x80000000
#define LCLK_DEEP_SLEEP_CNTL__ENABLE_DS__SHIFT 0x1f
#define LCLK_DEEP_SLEEP_CNTL2__RFE_BUSY_MASK_MASK 0x1
#define LCLK_DEEP_SLEEP_CNTL2__RFE_BUSY_MASK__SHIFT 0x0
#define LCLK_DEEP_SLEEP_CNTL2__BIF_CG_LCLK_BUSY_MASK_MASK 0x2
#define LCLK_DEEP_SLEEP_CNTL2__BIF_CG_LCLK_BUSY_MASK__SHIFT 0x1
#define LCLK_DEEP_SLEEP_CNTL2__L1IMU_SMU_IDLE_MASK_MASK 0x4
#define LCLK_DEEP_SLEEP_CNTL2__L1IMU_SMU_IDLE_MASK__SHIFT 0x2
#define LCLK_DEEP_SLEEP_CNTL2__RESERVED_BIT3_MASK 0x8
#define LCLK_DEEP_SLEEP_CNTL2__RESERVED_BIT3__SHIFT 0x3
#define LCLK_DEEP_SLEEP_CNTL2__SCLK_RUNNING_MASK_MASK 0x10
#define LCLK_DEEP_SLEEP_CNTL2__SCLK_RUNNING_MASK__SHIFT 0x4
#define LCLK_DEEP_SLEEP_CNTL2__SMU_BUSY_MASK_MASK 0x20
#define LCLK_DEEP_SLEEP_CNTL2__SMU_BUSY_MASK__SHIFT 0x5
#define LCLK_DEEP_SLEEP_CNTL2__PCIE_LCLK_IDLE1_MASK_MASK 0x40
#define LCLK_DEEP_SLEEP_CNTL2__PCIE_LCLK_IDLE1_MASK__SHIFT 0x6
#define LCLK_DEEP_SLEEP_CNTL2__PCIE_LCLK_IDLE2_MASK_MASK 0x80
#define LCLK_DEEP_SLEEP_CNTL2__PCIE_LCLK_IDLE2_MASK__SHIFT 0x7
#define LCLK_DEEP_SLEEP_CNTL2__PCIE_LCLK_IDLE3_MASK_MASK 0x100
#define LCLK_DEEP_SLEEP_CNTL2__PCIE_LCLK_IDLE3_MASK__SHIFT 0x8
#define LCLK_DEEP_SLEEP_CNTL2__PCIE_LCLK_IDLE4_MASK_MASK 0x200
#define LCLK_DEEP_SLEEP_CNTL2__PCIE_LCLK_IDLE4_MASK__SHIFT 0x9
#define LCLK_DEEP_SLEEP_CNTL2__L1IMUGPP_IDLE_MASK_MASK 0x400
#define LCLK_DEEP_SLEEP_CNTL2__L1IMUGPP_IDLE_MASK__SHIFT 0xa
#define LCLK_DEEP_SLEEP_CNTL2__L1IMUGPPSB_IDLE_MASK_MASK 0x800
#define LCLK_DEEP_SLEEP_CNTL2__L1IMUGPPSB_IDLE_MASK__SHIFT 0xb
#define LCLK_DEEP_SLEEP_CNTL2__L1IMUBIF_IDLE_MASK_MASK 0x1000
#define LCLK_DEEP_SLEEP_CNTL2__L1IMUBIF_IDLE_MASK__SHIFT 0xc
#define LCLK_DEEP_SLEEP_CNTL2__L1IMUINTGEN_IDLE_MASK_MASK 0x2000
#define LCLK_DEEP_SLEEP_CNTL2__L1IMUINTGEN_IDLE_MASK__SHIFT 0xd
#define LCLK_DEEP_SLEEP_CNTL2__L2IMU_IDLE_MASK_MASK 0x4000
#define LCLK_DEEP_SLEEP_CNTL2__L2IMU_IDLE_MASK__SHIFT 0xe
#define LCLK_DEEP_SLEEP_CNTL2__ORB_IDLE_MASK_MASK 0x8000
#define LCLK_DEEP_SLEEP_CNTL2__ORB_IDLE_MASK__SHIFT 0xf
#define LCLK_DEEP_SLEEP_CNTL2__ON_INB_WAKE_MASK_MASK 0x10000
#define LCLK_DEEP_SLEEP_CNTL2__ON_INB_WAKE_MASK__SHIFT 0x10
#define LCLK_DEEP_SLEEP_CNTL2__ON_INB_WAKE_ACK_MASK_MASK 0x20000
#define LCLK_DEEP_SLEEP_CNTL2__ON_INB_WAKE_ACK_MASK__SHIFT 0x11
#define LCLK_DEEP_SLEEP_CNTL2__ON_OUTB_WAKE_MASK_MASK 0x40000
#define LCLK_DEEP_SLEEP_CNTL2__ON_OUTB_WAKE_MASK__SHIFT 0x12
#define LCLK_DEEP_SLEEP_CNTL2__ON_OUTB_WAKE_ACK_MASK_MASK 0x80000
#define LCLK_DEEP_SLEEP_CNTL2__ON_OUTB_WAKE_ACK_MASK__SHIFT 0x13
#define LCLK_DEEP_SLEEP_CNTL2__DMAACTIVE_MASK_MASK 0x100000
#define LCLK_DEEP_SLEEP_CNTL2__DMAACTIVE_MASK__SHIFT 0x14
#define LCLK_DEEP_SLEEP_CNTL2__RLC_SMU_GFXCLK_OFF_MASK_MASK 0x200000
#define LCLK_DEEP_SLEEP_CNTL2__RLC_SMU_GFXCLK_OFF_MASK__SHIFT 0x15
#define LCLK_DEEP_SLEEP_CNTL2__RESERVED_MASK 0xffc00000
#define LCLK_DEEP_SLEEP_CNTL2__RESERVED__SHIFT 0x16
#define TARGET_AND_CURRENT_PROFILE_INDEX_1__CURR_VDDCI_INDEX_MASK 0xf
#define TARGET_AND_CURRENT_PROFILE_INDEX_1__CURR_VDDCI_INDEX__SHIFT 0x0
#define TARGET_AND_CURRENT_PROFILE_INDEX_1__TARG_VDDCI_INDEX_MASK 0xf0
#define TARGET_AND_CURRENT_PROFILE_INDEX_1__TARG_VDDCI_INDEX__SHIFT 0x4
#define TARGET_AND_CURRENT_PROFILE_INDEX_1__CURR_MVDD_INDEX_MASK 0xf00
#define TARGET_AND_CURRENT_PROFILE_INDEX_1__CURR_MVDD_INDEX__SHIFT 0x8
#define TARGET_AND_CURRENT_PROFILE_INDEX_1__TARG_MVDD_INDEX_MASK 0xf000
#define TARGET_AND_CURRENT_PROFILE_INDEX_1__TARG_MVDD_INDEX__SHIFT 0xc
#define TARGET_AND_CURRENT_PROFILE_INDEX_1__CURR_VDDC_INDEX_MASK 0xf0000
#define TARGET_AND_CURRENT_PROFILE_INDEX_1__CURR_VDDC_INDEX__SHIFT 0x10
#define TARGET_AND_CURRENT_PROFILE_INDEX_1__TARG_VDDC_INDEX_MASK 0xf00000
#define TARGET_AND_CURRENT_PROFILE_INDEX_1__TARG_VDDC_INDEX__SHIFT 0x14
#define TARGET_AND_CURRENT_PROFILE_INDEX_1__CURR_PCIE_INDEX_MASK 0xf000000
#define TARGET_AND_CURRENT_PROFILE_INDEX_1__CURR_PCIE_INDEX__SHIFT 0x18
#define TARGET_AND_CURRENT_PROFILE_INDEX_1__TARG_PCIE_INDEX_MASK 0xf0000000
#define TARGET_AND_CURRENT_PROFILE_INDEX_1__TARG_PCIE_INDEX__SHIFT 0x1c
#define CG_ULV_PARAMETER__ULV_THRESHOLD_MASK 0xffff
#define CG_ULV_PARAMETER__ULV_THRESHOLD__SHIFT 0x0
#define CG_ULV_PARAMETER__ULV_THRESHOLD_UNIT_MASK 0xf0000
#define CG_ULV_PARAMETER__ULV_THRESHOLD_UNIT__SHIFT 0x10
#define SCLK_MIN_DIV__FRACV_MASK 0xfff
#define SCLK_MIN_DIV__FRACV__SHIFT 0x0
#define SCLK_MIN_DIV__INTV_MASK 0x7f000
#define SCLK_MIN_DIV__INTV__SHIFT 0xc
#define LCAC_SX0_CNTL__SX0_ENABLE_MASK 0x1
#define LCAC_SX0_CNTL__SX0_ENABLE__SHIFT 0x0
#define LCAC_SX0_CNTL__SX0_THRESHOLD_MASK 0x1fffe
#define LCAC_SX0_CNTL__SX0_THRESHOLD__SHIFT 0x1
#define LCAC_SX0_CNTL__SX0_BLOCK_ID_MASK 0x3e0000
#define LCAC_SX0_CNTL__SX0_BLOCK_ID__SHIFT 0x11
#define LCAC_SX0_CNTL__SX0_SIGNAL_ID_MASK 0x3fc00000
#define LCAC_SX0_CNTL__SX0_SIGNAL_ID__SHIFT 0x16
#define LCAC_SX0_OVR_SEL__SX0_OVR_SEL_MASK 0xffffffff
#define LCAC_SX0_OVR_SEL__SX0_OVR_SEL__SHIFT 0x0
#define LCAC_SX0_OVR_VAL__SX0_OVR_VAL_MASK 0xffffffff
#define LCAC_SX0_OVR_VAL__SX0_OVR_VAL__SHIFT 0x0
#define LCAC_MC0_CNTL__MC0_ENABLE_MASK 0x1
#define LCAC_MC0_CNTL__MC0_ENABLE__SHIFT 0x0
#define LCAC_MC0_CNTL__MC0_THRESHOLD_MASK 0x1fffe
#define LCAC_MC0_CNTL__MC0_THRESHOLD__SHIFT 0x1
#define LCAC_MC0_CNTL__MC0_BLOCK_ID_MASK 0x3e0000
#define LCAC_MC0_CNTL__MC0_BLOCK_ID__SHIFT 0x11
#define LCAC_MC0_CNTL__MC0_SIGNAL_ID_MASK 0x3fc00000
#define LCAC_MC0_CNTL__MC0_SIGNAL_ID__SHIFT 0x16
#define LCAC_MC0_OVR_SEL__MC0_OVR_SEL_MASK 0xffffffff
#define LCAC_MC0_OVR_SEL__MC0_OVR_SEL__SHIFT 0x0
#define LCAC_MC0_OVR_VAL__MC0_OVR_VAL_MASK 0xffffffff
#define LCAC_MC0_OVR_VAL__MC0_OVR_VAL__SHIFT 0x0
#define LCAC_MC1_CNTL__MC1_ENABLE_MASK 0x1
#define LCAC_MC1_CNTL__MC1_ENABLE__SHIFT 0x0
#define LCAC_MC1_CNTL__MC1_THRESHOLD_MASK 0x1fffe
#define LCAC_MC1_CNTL__MC1_THRESHOLD__SHIFT 0x1
#define LCAC_MC1_CNTL__MC1_BLOCK_ID_MASK 0x3e0000
#define LCAC_MC1_CNTL__MC1_BLOCK_ID__SHIFT 0x11
#define LCAC_MC1_CNTL__MC1_SIGNAL_ID_MASK 0x3fc00000
#define LCAC_MC1_CNTL__MC1_SIGNAL_ID__SHIFT 0x16
#define LCAC_MC1_OVR_SEL__MC1_OVR_SEL_MASK 0xffffffff
#define LCAC_MC1_OVR_SEL__MC1_OVR_SEL__SHIFT 0x0
#define LCAC_MC1_OVR_VAL__MC1_OVR_VAL_MASK 0xffffffff
#define LCAC_MC1_OVR_VAL__MC1_OVR_VAL__SHIFT 0x0
#define LCAC_MC2_CNTL__MC2_ENABLE_MASK 0x1
#define LCAC_MC2_CNTL__MC2_ENABLE__SHIFT 0x0
#define LCAC_MC2_CNTL__MC2_THRESHOLD_MASK 0x1fffe
#define LCAC_MC2_CNTL__MC2_THRESHOLD__SHIFT 0x1
#define LCAC_MC2_CNTL__MC2_BLOCK_ID_MASK 0x3e0000
#define LCAC_MC2_CNTL__MC2_BLOCK_ID__SHIFT 0x11
#define LCAC_MC2_CNTL__MC2_SIGNAL_ID_MASK 0x3fc00000
#define LCAC_MC2_CNTL__MC2_SIGNAL_ID__SHIFT 0x16
#define LCAC_MC2_OVR_SEL__MC2_OVR_SEL_MASK 0xffffffff
#define LCAC_MC2_OVR_SEL__MC2_OVR_SEL__SHIFT 0x0
#define LCAC_MC2_OVR_VAL__MC2_OVR_VAL_MASK 0xffffffff
#define LCAC_MC2_OVR_VAL__MC2_OVR_VAL__SHIFT 0x0
#define LCAC_MC3_CNTL__MC3_ENABLE_MASK 0x1
#define LCAC_MC3_CNTL__MC3_ENABLE__SHIFT 0x0
#define LCAC_MC3_CNTL__MC3_THRESHOLD_MASK 0x1fffe
#define LCAC_MC3_CNTL__MC3_THRESHOLD__SHIFT 0x1
#define LCAC_MC3_CNTL__MC3_BLOCK_ID_MASK 0x3e0000
#define LCAC_MC3_CNTL__MC3_BLOCK_ID__SHIFT 0x11
#define LCAC_MC3_CNTL__MC3_SIGNAL_ID_MASK 0x3fc00000
#define LCAC_MC3_CNTL__MC3_SIGNAL_ID__SHIFT 0x16
#define LCAC_MC3_OVR_SEL__MC3_OVR_SEL_MASK 0xffffffff
#define LCAC_MC3_OVR_SEL__MC3_OVR_SEL__SHIFT 0x0
#define LCAC_MC3_OVR_VAL__MC3_OVR_VAL_MASK 0xffffffff
#define LCAC_MC3_OVR_VAL__MC3_OVR_VAL__SHIFT 0x0
#define LCAC_CPL_CNTL__CPL_ENABLE_MASK 0x1
#define LCAC_CPL_CNTL__CPL_ENABLE__SHIFT 0x0
#define LCAC_CPL_CNTL__CPL_THRESHOLD_MASK 0x1fffe
#define LCAC_CPL_CNTL__CPL_THRESHOLD__SHIFT 0x1
#define LCAC_CPL_CNTL__CPL_BLOCK_ID_MASK 0x3e0000
#define LCAC_CPL_CNTL__CPL_BLOCK_ID__SHIFT 0x11
#define LCAC_CPL_CNTL__CPL_SIGNAL_ID_MASK 0x3fc00000
#define LCAC_CPL_CNTL__CPL_SIGNAL_ID__SHIFT 0x16
#define LCAC_CPL_OVR_SEL__CPL_OVR_SEL_MASK 0xffffffff
#define LCAC_CPL_OVR_SEL__CPL_OVR_SEL__SHIFT 0x0
#define LCAC_CPL_OVR_VAL__CPL_OVR_VAL_MASK 0xffffffff
#define LCAC_CPL_OVR_VAL__CPL_OVR_VAL__SHIFT 0x0
#define ROM_SMC_IND_INDEX__SMC_IND_ADDR_MASK 0xffffffff
#define ROM_SMC_IND_INDEX__SMC_IND_ADDR__SHIFT 0x0
#define ROM_SMC_IND_DATA__SMC_IND_DATA_MASK 0xffffffff
#define ROM_SMC_IND_DATA__SMC_IND_DATA__SHIFT 0x0
#define ROM_CNTL__SCK_OVERWRITE_MASK 0x2
#define ROM_CNTL__SCK_OVERWRITE__SHIFT 0x1
#define ROM_CNTL__CLOCK_GATING_EN_MASK 0x4
#define ROM_CNTL__CLOCK_GATING_EN__SHIFT 0x2
#define ROM_CNTL__CSB_ACTIVE_TO_SCK_SETUP_TIME_MASK 0xff00
#define ROM_CNTL__CSB_ACTIVE_TO_SCK_SETUP_TIME__SHIFT 0x8
#define ROM_CNTL__CSB_ACTIVE_TO_SCK_HOLD_TIME_MASK 0xff0000
#define ROM_CNTL__CSB_ACTIVE_TO_SCK_HOLD_TIME__SHIFT 0x10
#define ROM_CNTL__SCK_PRESCALE_REFCLK_MASK 0xf000000
#define ROM_CNTL__SCK_PRESCALE_REFCLK__SHIFT 0x18
#define ROM_CNTL__SCK_PRESCALE_CRYSTAL_CLK_MASK 0xf0000000
#define ROM_CNTL__SCK_PRESCALE_CRYSTAL_CLK__SHIFT 0x1c
#define PAGE_MIRROR_CNTL__PAGE_MIRROR_BASE_ADDR_MASK 0xffffff
#define PAGE_MIRROR_CNTL__PAGE_MIRROR_BASE_ADDR__SHIFT 0x0
#define PAGE_MIRROR_CNTL__PAGE_MIRROR_INVALIDATE_MASK 0x1000000
#define PAGE_MIRROR_CNTL__PAGE_MIRROR_INVALIDATE__SHIFT 0x18
#define PAGE_MIRROR_CNTL__PAGE_MIRROR_ENABLE_MASK 0x2000000
#define PAGE_MIRROR_CNTL__PAGE_MIRROR_ENABLE__SHIFT 0x19
#define PAGE_MIRROR_CNTL__PAGE_MIRROR_USAGE_MASK 0xc000000
#define PAGE_MIRROR_CNTL__PAGE_MIRROR_USAGE__SHIFT 0x1a
#define ROM_STATUS__ROM_BUSY_MASK 0x1
#define ROM_STATUS__ROM_BUSY__SHIFT 0x0
#define CGTT_ROM_CLK_CTRL0__ON_DELAY_MASK 0xf
#define CGTT_ROM_CLK_CTRL0__ON_DELAY__SHIFT 0x0
#define CGTT_ROM_CLK_CTRL0__OFF_HYSTERESIS_MASK 0xff0
#define CGTT_ROM_CLK_CTRL0__OFF_HYSTERESIS__SHIFT 0x4
#define CGTT_ROM_CLK_CTRL0__SOFT_OVERRIDE1_MASK 0x40000000
#define CGTT_ROM_CLK_CTRL0__SOFT_OVERRIDE1__SHIFT 0x1e
#define CGTT_ROM_CLK_CTRL0__SOFT_OVERRIDE0_MASK 0x80000000
#define CGTT_ROM_CLK_CTRL0__SOFT_OVERRIDE0__SHIFT 0x1f
#define ROM_INDEX__ROM_INDEX_MASK 0xffffff
#define ROM_INDEX__ROM_INDEX__SHIFT 0x0
#define ROM_DATA__ROM_DATA_MASK 0xffffffff
#define ROM_DATA__ROM_DATA__SHIFT 0x0
#define ROM_START__ROM_START_MASK 0xffffff
#define ROM_START__ROM_START__SHIFT 0x0
#define ROM_SW_CNTL__DATA_SIZE_MASK 0xffff
#define ROM_SW_CNTL__DATA_SIZE__SHIFT 0x0
#define ROM_SW_CNTL__COMMAND_SIZE_MASK 0x30000
#define ROM_SW_CNTL__COMMAND_SIZE__SHIFT 0x10
#define ROM_SW_CNTL__ROM_SW_RETURN_DATA_ENABLE_MASK 0x40000
#define ROM_SW_CNTL__ROM_SW_RETURN_DATA_ENABLE__SHIFT 0x12
#define ROM_SW_STATUS__ROM_SW_DONE_MASK 0x1
#define ROM_SW_STATUS__ROM_SW_DONE__SHIFT 0x0
#define ROM_SW_COMMAND__ROM_SW_INSTRUCTION_MASK 0xff
#define ROM_SW_COMMAND__ROM_SW_INSTRUCTION__SHIFT 0x0
#define ROM_SW_COMMAND__ROM_SW_ADDRESS_MASK 0xffffff00
#define ROM_SW_COMMAND__ROM_SW_ADDRESS__SHIFT 0x8
#define ROM_SW_DATA_1__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_1__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_2__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_2__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_3__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_3__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_4__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_4__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_5__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_5__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_6__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_6__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_7__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_7__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_8__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_8__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_9__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_9__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_10__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_10__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_11__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_11__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_12__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_12__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_13__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_13__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_14__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_14__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_15__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_15__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_16__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_16__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_17__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_17__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_18__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_18__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_19__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_19__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_20__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_20__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_21__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_21__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_22__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_22__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_23__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_23__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_24__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_24__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_25__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_25__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_26__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_26__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_27__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_27__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_28__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_28__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_29__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_29__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_30__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_30__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_31__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_31__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_32__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_32__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_33__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_33__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_34__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_34__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_35__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_35__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_36__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_36__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_37__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_37__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_38__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_38__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_39__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_39__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_40__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_40__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_41__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_41__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_42__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_42__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_43__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_43__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_44__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_44__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_45__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_45__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_46__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_46__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_47__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_47__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_48__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_48__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_49__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_49__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_50__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_50__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_51__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_51__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_52__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_52__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_53__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_53__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_54__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_54__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_55__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_55__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_56__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_56__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_57__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_57__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_58__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_58__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_59__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_59__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_60__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_60__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_61__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_61__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_62__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_62__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_63__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_63__ROM_SW_DATA__SHIFT 0x0
#define ROM_SW_DATA_64__ROM_SW_DATA_MASK 0xffffffff
#define ROM_SW_DATA_64__ROM_SW_DATA__SHIFT 0x0
#define CURRENT_PG_STATUS__VCE_PG_STATUS_MASK 0x00000002
#define CURRENT_PG_STATUS__UVD_PG_STATUS_MASK 0x00000004
#define SMC_SYSCON_MISC_CNTL__pre_fetcher_en_MASK  0x1
#define SMC_SYSCON_MISC_CNTL__pre_fetcher_en__SHIFT 0

#endif /* SMU_7_0_1_SH_MASK_H */
