/* $NetBSD: tegra_apbreg.h,v 1.1 2015/03/29 10:41:59 jmcneill Exp $ */

/*-
 * Copyright (c) 2015 Jared D. McNeill <jmcneill@invisible.ca>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef _ARM_TEGRA_APBREG_H
#define _ARM_TEGRA_APBREG_H

#define APB_MISC_PP_CONFIG_CTL_0_REG		0x24
#define APB_MISC_PP_PINMUX_GLOBAL_0_0_REG	0x40
#define APB_MISC_PP_PULLUPDOWN_REG_C_0_REG	0xa8
#define APB_MISC_SC1X_PADS_VIP_VCLKCTRL_0_REG	0x428
#define APB_MISC_GP_HIDREV_0_REG		0x804
#define APB_MISC_GP_MIPI_PAD_CTRL_0_REG		0x820
#define APB_MISC_GP_AOCFG1PADCTRL_0_REG		0x868
#define APB_MISC_GP_AOCFG2PADCTRL_0_REG		0x86c
#define APB_MISC_GP_ATCFG1PADCTRL_0_REG		0x870
#define APB_MISC_GP_ATCFG2PADCTRL_0_REG		0x874
#define APB_MISC_GP_ATCFG3PADCTRL_0_REG		0x878
#define APB_MISC_GP_ATCFG4PADCTRL_0_REG		0x87c
#define APB_MISC_GP_ATCFG5PADCTRL_0_REG		0x880
#define APB_MISC_GP_CDEV1CFGPADCTRL_0_REG	0x884
#define APB_MISC_GP_CDEV2CFGPADCTRL_0_REG	0x888
#define APB_MISC_GP_DAP1CFGPADCTRL_0_REG	0x890
#define APB_MISC_GP_DAP2CFGPADCTRL_0_REG	0x894
#define APB_MISC_GP_DAP3CFGPADCTRL_0_REG	0x898
#define APB_MISC_GP_DAP4CFGPADCTRL_0_REG	0x89c
#define APB_MISC_GP_DBGCFGPADCTRL_0_REG		0x8a0
#define APB_MISC_GP_SDIO3CFGPADCTRL_0_REG	0x8b0
#define APB_MISC_GP_SPICFGPADCTRL_0_REG		0x8b4
#define APB_MISC_GP_UAACFGPADCTRL_0_REG		0x8b8
#define APB_MISC_GP_UABCFGPADCTRL_0_REG		0x8bc
#define APB_MISC_GP_UART2CFGPADCTRL_0_REG	0x8c0
#define APB_MISC_GP_UART3CFGPADCTRL_0_REG	0x8c4
#define APB_MISC_GP_SDIO1CFGPADCTRL_0_REG	0x8ec
#define APB_MISC_GP_DDCCFGPADCTRL_0_REG		0x8fc
#define APB_MISC_GP_GMCAFGPADCTRL_0_REG		0x900
#define APB_MISC_GP_GMECFGPADCTRL_0_REG		0x910
#define APB_MISC_GP_GMFCFGPADCTRL_0_REG		0x914
#define APB_MISC_GP_GMGCFGPADCTRL_0_REG		0x918
#define APB_MISC_GP_GMHCFGPADCTRL_0_REG		0x91c
#define APB_MISC_GP_OWRCFGPADCTRL_0_REG		0x920
#define APB_MISC_GP_UADCFGPADCTRL_0_REG		0x924
#define APB_MISC_GP_GPVCFGPADCTRL_0_REG		0x928
#define APB_MISC_GP_DEV3CFGPADCTRL_0_REG	0x92c
#define APB_MISC_GP_CECCFGPADCTRL_0_REG		0x938
#define APB_MISC_GP_ATCFG6PADCTRL_0_REG		0x994
#define APB_MISC_GP_DAP5CFGPADCTRL_0_REG	0x998
#define APB_MISC_GP_USB_VBUS_EN_CFGPADCTRL_0_REG 0x99c
#define APB_MISC_GP_AOCFG3PADCTRL_0_REG		0x9a8
#define APB_MISC_GP_AOCFG0PADCTRL_0_REG		0x9b0
#define APB_MISC_GP_HVCFG0PADCTRL_0_REG		0x9b4
#define APB_MISC_GP_SDIO4CFGPADCTRL_0_REG	0x9c4
#define APB_MISC_GP_AOCFG4PADCTRL_0_REG		0x9c8
#define APB_MISC_SECURE_REGS_APB_SLAVE_SECURITY_ENABLE_REG0_0_REG 0xc00
#define APB_MISC_SECURE_REGS_APB_SLAVE_SECURITY_ENABLE_REG1_0_REG 0xc04
#define APB_MISC_SECURE_REGS_APB_SLAVE_SECURITY_ENABLE_REG2_0_REG 0xc08

#define APB_MISC_GP_HIDREV_0_MINORREV	__BITS(19,16)
#define APB_MISC_GP_HIDREV_0_CHIPID	__BITS(15,8)
#define APB_MISC_GP_HIDREV_0_MAJORREV	__BITS(7,4)
#define APB_MISC_GP_HIDREV_0_HIDFAM	__BITS(3,0)

#endif /* _ARM_TEGRA_APBREG_H */
