/* $NetBSD: gcpad_rdesc.h,v 1.1 2025/12/08 23:00:22 jmcneill Exp $ */

/*-
 * Copyright (c) 2025 Jared McNeill <jmcneill@invisible.ca>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

static uint8_t gcpad_report_descr[] = {
    0x05, 0x01,          // UsagePage(Generic Desktop[0x0001])
    0x09, 0x05,          // UsageId(Gamepad[0x0005])
    0xA1, 0x01,          // Collection(Application)
    0x85, 0x01,          //     ReportId(1)
    0x05, 0x09,          //     UsagePage(Button[0x0009])
    0x09, 0x03,          //     UsageId(Button 3[0x0003])
    0x09, 0x01,          //     UsageId(Button 1[0x0001])
    0x09, 0x02,          //     UsageId(Button 2[0x0002])
    0x09, 0x04,          //     UsageId(Button 4[0x0004])
    0x09, 0x0B,          //     UsageId(Button 11[0x000B])
    0x09, 0x0C,          //     UsageId(Button 12[0x000C])
    0x15, 0x00,          //     LogicalMinimum(0)
    0x25, 0x01,          //     LogicalMaximum(1)
    0x95, 0x06,          //     ReportCount(6)
    0x75, 0x01,          //     ReportSize(1)
    0x81, 0x02,          //     Input(Data, Variable, Absolute, NoWrap, Linear, PreferredState, NoNullPosition, BitField)
    0x95, 0x01,          //     ReportCount(1)
    0x81, 0x03,          //     Input(Constant, Variable, Absolute, NoWrap, Linear, PreferredState, NoNullPosition, BitField)
    0x09, 0x0A,          //     UsageId(Button 10[0x000A])
    0x81, 0x02,          //     Input(Data, Variable, Absolute, NoWrap, Linear, PreferredState, NoNullPosition, BitField)
    0x81, 0x03,          //     Input(Constant, Variable, Absolute, NoWrap, Linear, PreferredState, NoNullPosition, BitField)
    0x09, 0x09,          //     UsageId(Button 9[0x0009])
    0x81, 0x02,          //     Input(Data, Variable, Absolute, NoWrap, Linear, PreferredState, NoNullPosition, BitField)
    0x75, 0x02,          //     ReportSize(2)
    0x81, 0x03,          //     Input(Constant, Variable, Absolute, NoWrap, Linear, PreferredState, NoNullPosition, BitField)
    0x09, 0x08,          //     UsageId(Button 8[0x0008])
    0x09, 0x06,          //     UsageId(Button 6[0x0006])
    0x09, 0x07,          //     UsageId(Button 7[0x0007])
    0x09, 0x05,          //     UsageId(Button 5[0x0005])
    0x95, 0x04,          //     ReportCount(4)
    0x75, 0x01,          //     ReportSize(1)
    0x81, 0x02,          //     Input(Data, Variable, Absolute, NoWrap, Linear, PreferredState, NoNullPosition, BitField)
    0x05, 0x01,          //     UsagePage(Generic Desktop[0x0001])
    0x09, 0x01,          //     UsageId(Pointer[0x0001])
    0xA1, 0x00,          //     Collection(Physical)
    0x09, 0x30,          //         UsageId(X[0x0030])
    0x09, 0x31,          //         UsageId(Y[0x0031])
    0x26, 0xFF, 0x00,    //         LogicalMaximum(255)
    0x95, 0x02,          //         ReportCount(2)
    0x75, 0x08,          //         ReportSize(8)
    0x81, 0x02,          //         Input(Data, Variable, Absolute, NoWrap, Linear, PreferredState, NoNullPosition, BitField)
    0xC0,                //     EndCollection()
    0x09, 0x01,          //     UsageId(Pointer[0x0001])
    0xA1, 0x00,          //     Collection(Physical)
    0x09, 0x32,          //         UsageId(Z[0x0032])
    0x09, 0x35,          //         UsageId(Rz[0x0035])
    0x81, 0x02,          //         Input(Data, Variable, Absolute, NoWrap, Linear, PreferredState, NoNullPosition, BitField)
    0xC0,                //     EndCollection()
    0x09, 0x33,          //     UsageId(Rx[0x0033])
    0x09, 0x34,          //     UsageId(Ry[0x0034])
    0x81, 0x02,          //     Input(Data, Variable, Absolute, NoWrap, Linear, PreferredState, NoNullPosition, BitField)
    0x95, 0x01,          //     ReportCount(1)
    0x81, 0x03,          //     Input(Constant, Variable, Absolute, NoWrap, Linear, PreferredState, NoNullPosition, BitField)
    0x85, 0x02,          //     ReportId(2)
    0x05, 0x09,          //     UsagePage(Button[0x0009])
    0x09, 0x03,          //     UsageId(Button 3[0x0003])
    0x09, 0x01,          //     UsageId(Button 1[0x0001])
    0x09, 0x02,          //     UsageId(Button 2[0x0002])
    0x09, 0x04,          //     UsageId(Button 4[0x0004])
    0x09, 0x0B,          //     UsageId(Button 11[0x000B])
    0x09, 0x0C,          //     UsageId(Button 12[0x000C])
    0x25, 0x01,          //     LogicalMaximum(1)
    0x95, 0x06,          //     ReportCount(6)
    0x75, 0x01,          //     ReportSize(1)
    0x81, 0x02,          //     Input(Data, Variable, Absolute, NoWrap, Linear, PreferredState, NoNullPosition, BitField)
    0x95, 0x01,          //     ReportCount(1)
    0x81, 0x03,          //     Input(Constant, Variable, Absolute, NoWrap, Linear, PreferredState, NoNullPosition, BitField)
    0x09, 0x0A,          //     UsageId(Button 10[0x000A])
    0x81, 0x02,          //     Input(Data, Variable, Absolute, NoWrap, Linear, PreferredState, NoNullPosition, BitField)
    0x81, 0x03,          //     Input(Constant, Variable, Absolute, NoWrap, Linear, PreferredState, NoNullPosition, BitField)
    0x09, 0x09,          //     UsageId(Button 9[0x0009])
    0x81, 0x02,          //     Input(Data, Variable, Absolute, NoWrap, Linear, PreferredState, NoNullPosition, BitField)
    0x75, 0x02,          //     ReportSize(2)
    0x81, 0x03,          //     Input(Constant, Variable, Absolute, NoWrap, Linear, PreferredState, NoNullPosition, BitField)
    0x09, 0x08,          //     UsageId(Button 8[0x0008])
    0x09, 0x06,          //     UsageId(Button 6[0x0006])
    0x09, 0x07,          //     UsageId(Button 7[0x0007])
    0x09, 0x05,          //     UsageId(Button 5[0x0005])
    0x95, 0x04,          //     ReportCount(4)
    0x75, 0x01,          //     ReportSize(1)
    0x81, 0x02,          //     Input(Data, Variable, Absolute, NoWrap, Linear, PreferredState, NoNullPosition, BitField)
    0x05, 0x01,          //     UsagePage(Generic Desktop[0x0001])
    0x09, 0x01,          //     UsageId(Pointer[0x0001])
    0xA1, 0x00,          //     Collection(Physical)
    0x09, 0x30,          //         UsageId(X[0x0030])
    0x09, 0x31,          //         UsageId(Y[0x0031])
    0x26, 0xFF, 0x00,    //         LogicalMaximum(255)
    0x95, 0x02,          //         ReportCount(2)
    0x75, 0x08,          //         ReportSize(8)
    0x81, 0x02,          //         Input(Data, Variable, Absolute, NoWrap, Linear, PreferredState, NoNullPosition, BitField)
    0xC0,                //     EndCollection()
    0x09, 0x01,          //     UsageId(Pointer[0x0001])
    0xA1, 0x00,          //     Collection(Physical)
    0x09, 0x32,          //         UsageId(Z[0x0032])
    0x09, 0x35,          //         UsageId(Rz[0x0035])
    0x81, 0x02,          //         Input(Data, Variable, Absolute, NoWrap, Linear, PreferredState, NoNullPosition, BitField)
    0xC0,                //     EndCollection()
    0x09, 0x33,          //     UsageId(Rx[0x0033])
    0x09, 0x34,          //     UsageId(Ry[0x0034])
    0x81, 0x02,          //     Input(Data, Variable, Absolute, NoWrap, Linear, PreferredState, NoNullPosition, BitField)
    0x95, 0x01,          //     ReportCount(1)
    0x81, 0x03,          //     Input(Constant, Variable, Absolute, NoWrap, Linear, PreferredState, NoNullPosition, BitField)
    0x85, 0x03,          //     ReportId(3)
    0x05, 0x09,          //     UsagePage(Button[0x0009])
    0x09, 0x03,          //     UsageId(Button 3[0x0003])
    0x09, 0x01,          //     UsageId(Button 1[0x0001])
    0x09, 0x02,          //     UsageId(Button 2[0x0002])
    0x09, 0x04,          //     UsageId(Button 4[0x0004])
    0x09, 0x0B,          //     UsageId(Button 11[0x000B])
    0x09, 0x0C,          //     UsageId(Button 12[0x000C])
    0x25, 0x01,          //     LogicalMaximum(1)
    0x95, 0x06,          //     ReportCount(6)
    0x75, 0x01,          //     ReportSize(1)
    0x81, 0x02,          //     Input(Data, Variable, Absolute, NoWrap, Linear, PreferredState, NoNullPosition, BitField)
    0x95, 0x01,          //     ReportCount(1)
    0x81, 0x03,          //     Input(Constant, Variable, Absolute, NoWrap, Linear, PreferredState, NoNullPosition, BitField)
    0x09, 0x0A,          //     UsageId(Button 10[0x000A])
    0x81, 0x02,          //     Input(Data, Variable, Absolute, NoWrap, Linear, PreferredState, NoNullPosition, BitField)
    0x81, 0x03,          //     Input(Constant, Variable, Absolute, NoWrap, Linear, PreferredState, NoNullPosition, BitField)
    0x09, 0x09,          //     UsageId(Button 9[0x0009])
    0x81, 0x02,          //     Input(Data, Variable, Absolute, NoWrap, Linear, PreferredState, NoNullPosition, BitField)
    0x75, 0x02,          //     ReportSize(2)
    0x81, 0x03,          //     Input(Constant, Variable, Absolute, NoWrap, Linear, PreferredState, NoNullPosition, BitField)
    0x09, 0x08,          //     UsageId(Button 8[0x0008])
    0x09, 0x06,          //     UsageId(Button 6[0x0006])
    0x09, 0x07,          //     UsageId(Button 7[0x0007])
    0x09, 0x05,          //     UsageId(Button 5[0x0005])
    0x95, 0x04,          //     ReportCount(4)
    0x75, 0x01,          //     ReportSize(1)
    0x81, 0x02,          //     Input(Data, Variable, Absolute, NoWrap, Linear, PreferredState, NoNullPosition, BitField)
    0x05, 0x01,          //     UsagePage(Generic Desktop[0x0001])
    0x09, 0x01,          //     UsageId(Pointer[0x0001])
    0xA1, 0x00,          //     Collection(Physical)
    0x09, 0x30,          //         UsageId(X[0x0030])
    0x09, 0x31,          //         UsageId(Y[0x0031])
    0x26, 0xFF, 0x00,    //         LogicalMaximum(255)
    0x95, 0x02,          //         ReportCount(2)
    0x75, 0x08,          //         ReportSize(8)
    0x81, 0x02,          //         Input(Data, Variable, Absolute, NoWrap, Linear, PreferredState, NoNullPosition, BitField)
    0xC0,                //     EndCollection()
    0x09, 0x01,          //     UsageId(Pointer[0x0001])
    0xA1, 0x00,          //     Collection(Physical)
    0x09, 0x32,          //         UsageId(Z[0x0032])
    0x09, 0x35,          //         UsageId(Rz[0x0035])
    0x81, 0x02,          //         Input(Data, Variable, Absolute, NoWrap, Linear, PreferredState, NoNullPosition, BitField)
    0xC0,                //     EndCollection()
    0x09, 0x33,          //     UsageId(Rx[0x0033])
    0x09, 0x34,          //     UsageId(Ry[0x0034])
    0x81, 0x02,          //     Input(Data, Variable, Absolute, NoWrap, Linear, PreferredState, NoNullPosition, BitField)
    0x95, 0x01,          //     ReportCount(1)
    0x81, 0x03,          //     Input(Constant, Variable, Absolute, NoWrap, Linear, PreferredState, NoNullPosition, BitField)
    0x85, 0x04,          //     ReportId(4)
    0x05, 0x09,          //     UsagePage(Button[0x0009])
    0x09, 0x03,          //     UsageId(Button 3[0x0003])
    0x09, 0x01,          //     UsageId(Button 1[0x0001])
    0x09, 0x02,          //     UsageId(Button 2[0x0002])
    0x09, 0x04,          //     UsageId(Button 4[0x0004])
    0x09, 0x0B,          //     UsageId(Button 11[0x000B])
    0x09, 0x0C,          //     UsageId(Button 12[0x000C])
    0x25, 0x01,          //     LogicalMaximum(1)
    0x95, 0x06,          //     ReportCount(6)
    0x75, 0x01,          //     ReportSize(1)
    0x81, 0x02,          //     Input(Data, Variable, Absolute, NoWrap, Linear, PreferredState, NoNullPosition, BitField)
    0x95, 0x01,          //     ReportCount(1)
    0x81, 0x03,          //     Input(Constant, Variable, Absolute, NoWrap, Linear, PreferredState, NoNullPosition, BitField)
    0x09, 0x0A,          //     UsageId(Button 10[0x000A])
    0x81, 0x02,          //     Input(Data, Variable, Absolute, NoWrap, Linear, PreferredState, NoNullPosition, BitField)
    0x81, 0x03,          //     Input(Constant, Variable, Absolute, NoWrap, Linear, PreferredState, NoNullPosition, BitField)
    0x09, 0x09,          //     UsageId(Button 9[0x0009])
    0x81, 0x02,          //     Input(Data, Variable, Absolute, NoWrap, Linear, PreferredState, NoNullPosition, BitField)
    0x75, 0x02,          //     ReportSize(2)
    0x81, 0x03,          //     Input(Constant, Variable, Absolute, NoWrap, Linear, PreferredState, NoNullPosition, BitField)
    0x09, 0x08,          //     UsageId(Button 8[0x0008])
    0x09, 0x06,          //     UsageId(Button 6[0x0006])
    0x09, 0x07,          //     UsageId(Button 7[0x0007])
    0x09, 0x05,          //     UsageId(Button 5[0x0005])
    0x95, 0x04,          //     ReportCount(4)
    0x75, 0x01,          //     ReportSize(1)
    0x81, 0x02,          //     Input(Data, Variable, Absolute, NoWrap, Linear, PreferredState, NoNullPosition, BitField)
    0x05, 0x01,          //     UsagePage(Generic Desktop[0x0001])
    0x09, 0x01,          //     UsageId(Pointer[0x0001])
    0xA1, 0x00,          //     Collection(Physical)
    0x09, 0x30,          //         UsageId(X[0x0030])
    0x09, 0x31,          //         UsageId(Y[0x0031])
    0x26, 0xFF, 0x00,    //         LogicalMaximum(255)
    0x95, 0x02,          //         ReportCount(2)
    0x75, 0x08,          //         ReportSize(8)
    0x81, 0x02,          //         Input(Data, Variable, Absolute, NoWrap, Linear, PreferredState, NoNullPosition, BitField)
    0xC0,                //     EndCollection()
    0x09, 0x01,          //     UsageId(Pointer[0x0001])
    0xA1, 0x00,          //     Collection(Physical)
    0x09, 0x32,          //         UsageId(Z[0x0032])
    0x09, 0x35,          //         UsageId(Rz[0x0035])
    0x81, 0x02,          //         Input(Data, Variable, Absolute, NoWrap, Linear, PreferredState, NoNullPosition, BitField)
    0xC0,                //     EndCollection()
    0x09, 0x33,          //     UsageId(Rx[0x0033])
    0x09, 0x34,          //     UsageId(Ry[0x0034])
    0x81, 0x02,          //     Input(Data, Variable, Absolute, NoWrap, Linear, PreferredState, NoNullPosition, BitField)
    0x95, 0x01,          //     ReportCount(1)
    0x81, 0x03,          //     Input(Constant, Variable, Absolute, NoWrap, Linear, PreferredState, NoNullPosition, BitField)
    0xC0,                // EndCollection()
};
