/* This file is autogenerated by sid_tables.py from sid.h. Do not edit directly. */

/*
 * Copyright 2015-2019 Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * on the rights to use, copy, modify, merge, publish, distribute, sub
 * license, and/or sell copies of the Software, and to permit persons to whom
 * the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHOR(S) AND/OR THEIR SUPPLIERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
 * USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 */

#ifndef SID_TABLES_H
#define SID_TABLES_H

struct si_field {
        unsigned name_offset;
        unsigned mask;
        unsigned num_values;
        unsigned values_offset; /* offset into sid_strings_offsets */
};

struct si_reg {
        unsigned name_offset;
        unsigned offset;
        unsigned num_fields;
        unsigned fields_offset;
};

struct si_packet3 {
        unsigned name_offset;
        unsigned op;
};

static const struct si_packet3 packet3_table[] = {
	{0, PKT3_NOP},
	{4, PKT3_SET_BASE},
	{13, PKT3_CLEAR_STATE},
	{25, PKT3_INDEX_BUFFER_SIZE},
	{43, PKT3_DISPATCH_DIRECT},
	{59, PKT3_DISPATCH_INDIRECT},
	{77, PKT3_OCCLUSION_QUERY},
	{93, PKT3_SET_PREDICATION},
	{109, PKT3_COND_EXEC},
	{119, PKT3_PRED_EXEC},
	{129, PKT3_DRAW_INDIRECT},
	{143, PKT3_DRAW_INDEX_INDIRECT},
	{163, PKT3_INDEX_BASE},
	{174, PKT3_DRAW_INDEX_2},
	{187, PKT3_CONTEXT_CONTROL},
	{203, PKT3_INDEX_TYPE},
	{214, PKT3_DRAW_INDIRECT_MULTI},
	{234, PKT3_DRAW_INDEX_AUTO},
	{250, PKT3_DRAW_INDEX_IMMD},
	{266, PKT3_NUM_INSTANCES},
	{280, PKT3_DRAW_INDEX_MULTI_AUTO},
	{302, PKT3_INDIRECT_BUFFER_SI},
	{321, PKT3_INDIRECT_BUFFER_CONST},
	{343, PKT3_STRMOUT_BUFFER_UPDATE},
	{365, PKT3_DRAW_INDEX_OFFSET_2},
	{385, PKT3_WRITE_DATA},
	{396, PKT3_DRAW_INDEX_INDIRECT_MULTI},
	{422, PKT3_MEM_SEMAPHORE},
	{436, PKT3_MPEG_INDEX},
	{447, PKT3_WAIT_REG_MEM},
	{460, PKT3_MEM_WRITE},
	{470, PKT3_INDIRECT_BUFFER_CIK},
	{490, PKT3_COPY_DATA},
	{500, PKT3_PFP_SYNC_ME},
	{512, PKT3_SURFACE_SYNC},
	{525, PKT3_ME_INITIALIZE},
	{539, PKT3_COND_WRITE},
	{550, PKT3_EVENT_WRITE},
	{562, PKT3_EVENT_WRITE_EOP},
	{578, PKT3_EVENT_WRITE_EOS},
	{594, PKT3_RELEASE_MEM},
	{606, PKT3_CONTEXT_REG_RMW},
	{622, PKT3_ONE_REG_WRITE},
	{636, PKT3_ACQUIRE_MEM},
	{648, PKT3_REWIND},
	{655, PKT3_LOAD_UCONFIG_REG},
	{672, PKT3_LOAD_SH_REG},
	{684, PKT3_LOAD_CONTEXT_REG},
	{701, PKT3_SET_CONFIG_REG},
	{716, PKT3_SET_CONTEXT_REG},
	{732, PKT3_SET_SH_REG},
	{743, PKT3_SET_SH_REG_OFFSET},
	{761, PKT3_SET_UCONFIG_REG},
	{777, PKT3_SET_UCONFIG_REG_INDEX},
	{799, PKT3_LOAD_CONST_RAM},
	{814, PKT3_WRITE_CONST_RAM},
	{830, PKT3_DUMP_CONST_RAM},
	{845, PKT3_INCREMENT_CE_COUNTER},
	{866, PKT3_INCREMENT_DE_COUNTER},
	{887, PKT3_WAIT_ON_CE_COUNTER},
	{906, PKT3_SET_SH_REG_INDEX},
	{923, PKT3_LOAD_CONTEXT_REG_INDEX},
	{946, PKT3_IT_OPCODE_C},
	{958, PKT3_CP_DMA},
	{965, PKT3_DMA_DATA},
};

static const struct si_reg gfx10_reg_table[] = {
	{974, 1028, 10, 0},
	{987, 1032, 20, 10},
	{1002, 1036, 10, 30},
	{1018, 1040, 12, 40},
	{1039, 1044, 4, 52},
	{1057, 1048, 3, 56},
	{1075, 1052, 11, 59},
	{1090, 1056},
	{1104, 1060, 1, 70},
	{1118, 1064},
	{1135, 1076, 9, 71},
	{1151, 1080},
	{1168, 1116, 5, 80},
	{1183, 1120, 7, 85},
	{1198, 1124, 2, 92},
	{1218, 1128, 1, 94},
	{1237, 1132, 4, 95},
	{1257, 1136, 7, 99},
	{1273, 2480},
	{1287, 2484},
	{1301, 2488},
	{1315, 2492},
	{1329, 2496},
	{1343, 2500},
	{1357, 2504},
	{1371, 2508},
	{1385, 2512},
	{1399, 2516},
	{1413, 2520},
	{1428, 2524},
	{1443, 2528},
	{1458, 2532},
	{1473, 2536},
	{1488, 2540},
	{1503, 2544},
	{1514, 2552},
	{1530, 2556},
	{1546, 2560},
	{1570, 2564},
	{1594, 2568},
	{1618, 32776, 27, 106},
	{1631, 32784, 21, 133},
	{1643, 32788, 14, 154},
	{1659, 32792, 14, 154},
	{1675, 32796, 15, 168},
	{1688, 32824, 14, 154},
	{1704, 32828, 14, 154},
	{1720, 33296, 21, 183},
	{1734, 33300, 28, 204},
	{1751, 33304, 15, 232},
	{1772, 33308, 28, 247},
	{1786, 33312, 32, 275},
	{1803, 33316, 13, 307},
	{1824, 33320, 9, 320},
	{1842, 33324, 1, 329},
	{1865, 33344, 2, 330},
	{1886, 33348},
	{1906, 33352, 1, 332},
	{1929, 33356, 9, 333},
	{1947, 33436, 1, 342},
	{1970, 36096},
	{1996, 36100, 2, 343},
	{2022, 36104},
	{2048, 36108, 2, 343},
	{2074, 36112, 2, 345},
	{2095, 36116, 4, 347},
	{2116, 36120, 4, 351},
	{2143, 36124, 17, 355},
	{2164, 36128, 6, 372},
	{2187, 36132},
	{2216, 36140},
	{2246, 36144},
	{2278, 36148},
	{2309, 36152},
	{2342, 36348, 5, 378},
	{2351, 36608},
	{2369, 36612, 4, 383},
	{2387, 36616},
	{2405, 36620, 10, 387},
	{2423, 36656, 14, 397},
	{2441, 36660, 4, 411},
	{2459, 36664, 12, 415},
	{2477, 36668, 2, 427},
	{2495, 37120, 9, 429},
	{2511, 39160, 5, 438},
	{2526, 39184, 5, 443},
	{2540, 39188, 5, 443},
	{2554, 39192, 5, 443},
	{2568, 39196, 5, 443},
	{2582, 39200, 5, 443},
	{2596, 39204, 5, 443},
	{2610, 39208, 5, 443},
	{2624, 39212, 5, 443},
	{2638, 39216, 5, 443},
	{2652, 39220, 5, 443},
	{2666, 39224, 5, 443},
	{2681, 39228, 5, 443},
	{2696, 39232, 5, 443},
	{2711, 39236, 5, 443},
	{2726, 39240, 5, 443},
	{2741, 39244, 5, 443},
	{2756, 39248, 5, 443},
	{2771, 39252, 5, 443},
	{2786, 39256, 5, 443},
	{2801, 39260, 5, 443},
	{2816, 39264, 5, 443},
	{2831, 39268, 5, 443},
	{2846, 39272, 5, 443},
	{2861, 39276, 5, 443},
	{2876, 39280, 5, 443},
	{2891, 39284, 5, 443},
	{2906, 39288, 5, 443},
	{2921, 39292, 5, 443},
	{2936, 39296, 5, 443},
	{2951, 39300, 5, 443},
	{2966, 39304, 5, 443},
	{2981, 39308, 5, 443},
	{2996, 39312, 4, 448},
	{3015, 39316, 4, 448},
	{3034, 39320, 4, 448},
	{3053, 39324, 4, 448},
	{3072, 39328, 4, 448},
	{3091, 39332, 4, 448},
	{3110, 39336, 4, 448},
	{3129, 39340, 4, 448},
	{3148, 39344, 4, 448},
	{3167, 39348, 4, 448},
	{3186, 39352, 4, 448},
	{3206, 39356, 4, 448},
	{3226, 39360, 4, 448},
	{3246, 39364, 4, 448},
	{3266, 39368, 4, 448},
	{3286, 39372, 4, 448},
	{3306, 40960},
	{3324, 40964, 4, 452},
	{3342, 40968, 3, 456},
	{3360, 40972, 9, 459},
	{3378, 40976, 2, 468},
	{3396, 40980, 7, 470},
	{3414, 40984, 10, 477},
	{3432, 40988},
	{3450, 45060, 1, 487},
	{3474, 45080},
	{3499, 45084, 3, 488},
	{3523, 45088},
	{3544, 45092, 1, 491},
	{3565, 45096, 11, 492},
	{3589, 45100, 10, 503},
	{3613, 45104},
	{3639, 45108},
	{3665, 45112},
	{3691, 45116},
	{3717, 45120},
	{3743, 45124},
	{3769, 45128},
	{3795, 45132},
	{3821, 45136},
	{3847, 45140},
	{3873, 45144},
	{3900, 45148},
	{3927, 45152},
	{3954, 45156},
	{3981, 45160},
	{4008, 45164},
	{4035, 45168},
	{4062, 45172},
	{4089, 45176},
	{4116, 45180},
	{4143, 45184},
	{4170, 45188},
	{4197, 45192},
	{4224, 45196},
	{4251, 45200},
	{4278, 45204},
	{4305, 45208},
	{4332, 45212},
	{4359, 45216},
	{4386, 45220},
	{4413, 45224},
	{4440, 45228},
	{4467, 45248, 8, 513},
	{4490, 45252, 5, 521},
	{4523, 45256, 1, 526},
	{4550, 45260, 1, 526},
	{4577, 45264, 1, 526},
	{4604, 45268, 1, 526},
	{4631, 45316, 1, 487},
	{4655, 45332},
	{4680, 45336, 3, 488},
	{4704, 45340, 1, 527},
	{4729, 45344},
	{4750, 45348, 1, 491},
	{4771, 45352, 12, 528},
	{4795, 45356, 14, 540},
	{4819, 45360},
	{4845, 45364},
	{4871, 45368},
	{4897, 45372},
	{4923, 45376},
	{4949, 45380},
	{4975, 45384},
	{5001, 45388},
	{5027, 45392},
	{5053, 45396},
	{5079, 45400},
	{5106, 45404},
	{5133, 45408},
	{5160, 45412},
	{5187, 45416},
	{5214, 45420},
	{5241, 45424},
	{5268, 45428},
	{5295, 45432},
	{5322, 45436},
	{5349, 45440},
	{5376, 45444},
	{5403, 45448},
	{5430, 45452},
	{5457, 45456},
	{5484, 45460},
	{5511, 45464},
	{5538, 45468},
	{5565, 45472},
	{5592, 45476},
	{5619, 45480},
	{5646, 45484},
	{5673, 45504, 8, 513},
	{5696, 45508, 5, 521},
	{5729, 45512, 1, 526},
	{5756, 45516, 1, 526},
	{5783, 45520, 1, 526},
	{5810, 45524, 1, 526},
	{5837, 45548, 9, 554},
	{5864, 45552, 6, 563},
	{5891, 45556, 5, 569},
	{5918, 45568},
	{5943, 45572, 2, 574},
	{5967, 45576},
	{5999, 45580},
	{6031, 45584},
	{6055, 45588, 1, 491},
	{6079, 45596, 4, 576},
	{6103, 45600},
	{6124, 45604, 1, 491},
	{6145, 45608, 13, 580},
	{6169, 45612, 9, 593},
	{6193, 45616},
	{6219, 45620},
	{6245, 45624},
	{6271, 45628},
	{6297, 45632},
	{6323, 45636},
	{6349, 45640},
	{6375, 45644},
	{6401, 45648},
	{6427, 45652},
	{6453, 45656},
	{6480, 45660},
	{6507, 45664},
	{6534, 45668},
	{6561, 45672},
	{6588, 45676},
	{6615, 45680},
	{6642, 45684},
	{6669, 45688},
	{6696, 45692},
	{6723, 45696},
	{6750, 45700},
	{6777, 45704},
	{6804, 45708},
	{6831, 45712},
	{6858, 45716},
	{6885, 45720},
	{6912, 45724},
	{6939, 45728},
	{6966, 45732},
	{6993, 45736},
	{7020, 45740},
	{7047, 45760, 8, 513},
	{7072, 45764, 5, 521},
	{7107, 45768, 1, 526},
	{7136, 45772, 1, 526},
	{7165, 45776, 1, 526},
	{7194, 45780, 1, 526},
	{7223, 45808, 6, 563},
	{7250, 45852, 4, 576},
	{7274, 45856},
	{7295, 45860, 1, 491},
	{7316, 45864, 10, 602},
	{7340, 45868, 6, 563},
	{7364, 45872},
	{7390, 45876},
	{7416, 45880},
	{7442, 45884},
	{7468, 45888},
	{7494, 45892},
	{7520, 45896},
	{7546, 45900},
	{7572, 45904},
	{7598, 45908},
	{7624, 45912},
	{7651, 45916},
	{7678, 45920},
	{7705, 45924},
	{7732, 45928},
	{7759, 45932},
	{7786, 46068, 5, 569},
	{7813, 46080},
	{7838, 46084, 1, 487},
	{7862, 46088},
	{7894, 46092},
	{7926, 46096},
	{7950, 46100, 1, 491},
	{7974, 46108, 4, 612},
	{7998, 46112},
	{8019, 46116, 1, 491},
	{8040, 46120, 12, 616},
	{8064, 46124, 9, 628},
	{8088, 46128},
	{8114, 46132},
	{8140, 46136},
	{8166, 46140},
	{8192, 46144},
	{8218, 46148},
	{8244, 46152},
	{8270, 46156},
	{8296, 46160},
	{8322, 46164},
	{8348, 46168},
	{8375, 46172},
	{8402, 46176},
	{8429, 46180},
	{8456, 46184},
	{8483, 46188},
	{8510, 46192},
	{8537, 46196},
	{8564, 46200},
	{8591, 46204},
	{8618, 46208},
	{8645, 46212},
	{8672, 46216},
	{8699, 46220},
	{8726, 46224},
	{8753, 46228},
	{8780, 46232},
	{8807, 46236},
	{8834, 46240},
	{8861, 46244},
	{8888, 46248},
	{8915, 46252},
	{8942, 46272, 8, 513},
	{8967, 46276, 5, 521},
	{9002, 46280, 1, 526},
	{9031, 46284, 1, 526},
	{9060, 46288, 1, 526},
	{9089, 46292, 1, 526},
	{9118, 46324, 5, 569},
	{9145, 46364, 4, 576},
	{9169, 46368},
	{9190, 46372, 1, 491},
	{9211, 46376, 9, 637},
	{9235, 46380, 5, 569},
	{9259, 46384},
	{9285, 46388},
	{9311, 46392},
	{9337, 46396},
	{9363, 46400},
	{9389, 46404},
	{9415, 46408},
	{9441, 46412},
	{9467, 46416},
	{9493, 46420},
	{9519, 46424},
	{9546, 46428},
	{9573, 46432},
	{9600, 46436},
	{9627, 46440},
	{9654, 46444},
	{9681, 47104, 13, 646},
	{9708, 47108},
	{9722, 47112},
	{9736, 47116},
	{9750, 47120},
	{9766, 47124},
	{9782, 47128},
	{9798, 47132, 2, 659},
	{9819, 47136, 2, 659},
	{9840, 47140, 2, 659},
	{9861, 47144, 1, 661},
	{9889, 47148, 1, 662},
	{9914, 47152},
	{9929, 47156, 1, 663},
	{9944, 47160},
	{9973, 47164, 1, 663},
	{10002, 47168},
	{10035, 47172, 1, 663},
	{10068, 47176, 12, 664},
	{10086, 47180, 11, 676},
	{10104, 47184, 1, 687},
	{10117, 47188, 6, 688},
	{10141, 47192},
	{10168, 47196},
	{10195, 47200, 2, 694},
	{10216, 47204},
	{10243, 47208},
	{10270, 47212},
	{10288, 47216},
	{10306, 47220},
	{10324, 47224, 1, 696},
	{10352, 47228, 5, 697},
	{10374, 47232},
	{10394, 47236},
	{10417, 47240, 9, 702},
	{10434, 47248, 1, 526},
	{10455, 47252, 1, 526},
	{10476, 47256, 1, 526},
	{10497, 47260, 1, 526},
	{10518, 47264, 1, 711},
	{10536, 47268, 1, 712},
	{10555, 47272},
	{10577, 47276, 3, 713},
	{10594, 47280},
	{10623, 47284, 1, 716},
	{10652, 47288, 3, 713},
	{10670, 47360},
	{10690, 47364},
	{10710, 47368},
	{10730, 47372},
	{10750, 47376},
	{10770, 47380},
	{10790, 47384},
	{10810, 47388},
	{10830, 47392},
	{10850, 47396},
	{10870, 47400},
	{10891, 47404},
	{10912, 47408},
	{10933, 47412},
	{10954, 47416},
	{10975, 47420},
	{10996, 47604, 2, 717},
	{11020, 47608},
	{11041, 47612},
	{11057, 163840, 10, 719},
	{11075, 163844, 11, 729},
	{11092, 163848, 7, 740},
	{11106, 163852, 23, 747},
	{11125, 163856, 16, 770},
	{11145, 163860},
	{11164, 163868, 2, 786},
	{11181, 163872},
	{11201, 163876},
	{11221, 163880, 1, 788},
	{11238, 163884},
	{11253, 163888, 2, 789},
	{11277, 163892, 2, 791},
	{11301, 163896, 3, 793},
	{11317, 163900, 8, 796},
	{11335, 163904, 14, 804},
	{11345, 163908, 9, 818},
	{11361, 163912},
	{11376, 163916},
	{11397, 163920},
	{11413, 163924},
	{11435, 163928, 2, 827},
	{11453, 163932, 1, 829},
	{11471, 163944, 1, 830},
	{11489, 163948, 1, 830},
	{11513, 163952, 1, 830},
	{11532, 163956, 1, 830},
	{11557, 163960, 1, 830},
	{11579, 163964, 9, 831},
	{11603, 163968},
	{11619, 163972, 1, 840},
	{11638, 164328, 1, 841},
	{11659, 164332, 1, 841},
	{11680, 164336, 1, 841},
	{11701, 164340, 1, 841},
	{11722, 164344},
	{11740, 164348},
	{11758, 164352, 2, 842},
	{11778, 164356, 3, 844},
	{11802, 164360, 2, 847},
	{11826, 164364, 1, 849},
	{11846, 164368, 2, 844},
	{11866, 164372, 2, 847},
	{11886, 164376, 2, 844},
	{11906, 164380, 2, 847},
	{11926, 164384, 2, 844},
	{11946, 164388, 2, 847},
	{11966, 164392, 2, 844},
	{11986, 164396, 2, 847},
	{12006, 164400, 7, 850},
	{12021, 164404, 2, 857},
	{12050, 164408, 8, 859},
	{12065, 164412, 8, 867},
	{12080, 164416, 3, 844},
	{12105, 164420, 2, 847},
	{12130, 164424},
	{12148, 164428},
	{12166, 164432, 3, 844},
	{12191, 164436, 2, 847},
	{12216, 164440, 3, 844},
	{12241, 164444, 2, 847},
	{12266, 164448, 3, 844},
	{12291, 164452, 2, 847},
	{12316, 164456, 3, 844},
	{12341, 164460, 2, 847},
	{12366, 164464, 3, 844},
	{12391, 164468, 2, 847},
	{12416, 164472, 3, 844},
	{12441, 164476, 2, 847},
	{12466, 164480, 3, 844},
	{12491, 164484, 2, 847},
	{12516, 164488, 3, 844},
	{12541, 164492, 2, 847},
	{12566, 164496, 3, 844},
	{12591, 164500, 2, 847},
	{12616, 164504, 3, 844},
	{12641, 164508, 2, 847},
	{12666, 164512, 3, 844},
	{12692, 164516, 2, 847},
	{12718, 164520, 3, 844},
	{12744, 164524, 2, 847},
	{12770, 164528, 3, 844},
	{12796, 164532, 2, 847},
	{12822, 164536, 3, 844},
	{12848, 164540, 2, 847},
	{12874, 164544, 3, 844},
	{12900, 164548, 2, 847},
	{12926, 164552, 3, 844},
	{12952, 164556, 2, 847},
	{12978, 164560},
	{12997, 164564},
	{13016, 164568},
	{13035, 164572},
	{13054, 164576},
	{13073, 164580},
	{13092, 164584},
	{13111, 164588},
	{13130, 164592},
	{13149, 164596},
	{13168, 164600},
	{13187, 164604},
	{13206, 164608},
	{13225, 164612},
	{13244, 164616},
	{13263, 164620},
	{13282, 164624},
	{13301, 164628},
	{13320, 164632},
	{13339, 164636},
	{13358, 164640},
	{13378, 164644},
	{13398, 164648},
	{13418, 164652},
	{13438, 164656},
	{13458, 164660},
	{13478, 164664},
	{13498, 164668},
	{13518, 164672},
	{13538, 164676},
	{13558, 164680},
	{13578, 164684},
	{13598, 164688, 15, 875},
	{13618, 164692, 3, 890},
	{13640, 164696, 2, 893},
	{13668, 164700, 7, 895},
	{13697, 164704, 1, 902},
	{13718, 164708, 1, 903},
	{13728, 164712, 1, 904},
	{13736, 164768, 4, 905},
	{13758, 164772, 4, 905},
	{13779, 164776, 4, 909},
	{13796, 164864},
	{13813, 164868},
	{13830, 164872},
	{13846, 164876},
	{13875, 164880, 10, 913},
	{13900, 164884},
	{13913, 164888},
	{13928, 164892},
	{13942, 164896},
	{13957, 164900, 8, 923},
	{13972, 164904, 4, 931},
	{13996, 164908, 6, 935},
	{14015, 164912, 4, 941},
	{14033, 164916, 4, 945},
	{14054, 164924},
	{14073, 164928},
	{14093, 164932},
	{14112, 164936},
	{14132, 164940},
	{14151, 164944},
	{14171, 164948},
	{14192, 164952},
	{14214, 164956},
	{14235, 164960},
	{14257, 164964},
	{14278, 164968},
	{14300, 164972},
	{14321, 164976},
	{14343, 164980},
	{14364, 164984},
	{14386, 164988},
	{14407, 164992},
	{14429, 164996},
	{14450, 165000},
	{14472, 165004},
	{14493, 165008},
	{14515, 165012},
	{14536, 165016},
	{14558, 165020},
	{14579, 165024},
	{14601, 165028},
	{14622, 165032},
	{14644, 165036},
	{14665, 165040},
	{14687, 165044},
	{14708, 165048},
	{14730, 165052},
	{14751, 165056},
	{14773, 165060},
	{14794, 165064},
	{14816, 165068},
	{14837, 165072},
	{14859, 165076},
	{14880, 165080},
	{14902, 165084},
	{14923, 165088},
	{14945, 165092},
	{14966, 165096},
	{14988, 165100},
	{15009, 165104},
	{15031, 165108},
	{15052, 165112},
	{15074, 165116},
	{15095, 165120},
	{15117, 165124},
	{15138, 165128},
	{15160, 165132},
	{15181, 165136},
	{15203, 165140},
	{15224, 165144},
	{15246, 165148},
	{15267, 165152},
	{15289, 165156},
	{15310, 165160},
	{15332, 165164},
	{15354, 165168},
	{15377, 165172},
	{15399, 165176},
	{15422, 165180},
	{15444, 165184},
	{15467, 165188},
	{15489, 165192},
	{15512, 165196},
	{15534, 165200},
	{15557, 165204},
	{15579, 165208},
	{15602, 165212},
	{15624, 165216},
	{15647, 165220},
	{15669, 165224},
	{15692, 165228},
	{15714, 165232},
	{15737, 165236},
	{15759, 165240},
	{15782, 165244},
	{15804, 165248},
	{15827, 165252},
	{15849, 165256},
	{15872, 165260},
	{15894, 165264},
	{15917, 165268},
	{15939, 165272},
	{15962, 165276},
	{15984, 165280},
	{16007, 165284},
	{16029, 165288},
	{16052, 165292},
	{16074, 165296},
	{16097, 165300},
	{16119, 165304},
	{16142, 165308},
	{16156, 165312},
	{16170, 165316},
	{16184, 165320},
	{16198, 165324},
	{16212, 165328},
	{16226, 165332},
	{16240, 165336},
	{16254, 165340},
	{16268, 165344},
	{16282, 165348},
	{16296, 165352},
	{16310, 165356},
	{16324, 165360},
	{16338, 165364},
	{16352, 165368},
	{16366, 165372},
	{16380, 165376},
	{16394, 165380},
	{16408, 165384},
	{16422, 165388},
	{16436, 165392},
	{16450, 165396},
	{16464, 165400},
	{16478, 165404},
	{16501, 165444, 12, 949},
	{16521, 165448, 12, 949},
	{16541, 165452, 12, 949},
	{16561, 165456, 12, 949},
	{16581, 165460, 12, 949},
	{16601, 165464, 12, 949},
	{16621, 165468, 12, 949},
	{16641, 165472, 12, 949},
	{16661, 165476, 12, 949},
	{16681, 165480, 12, 949},
	{16701, 165484, 12, 949},
	{16722, 165488, 12, 949},
	{16743, 165492, 12, 949},
	{16764, 165496, 12, 949},
	{16785, 165500, 12, 949},
	{16806, 165504, 12, 949},
	{16827, 165508, 12, 949},
	{16848, 165512, 12, 949},
	{16869, 165516, 12, 949},
	{16890, 165520, 12, 949},
	{16911, 165524, 9, 961},
	{16932, 165528, 9, 961},
	{16953, 165532, 9, 961},
	{16974, 165536, 9, 961},
	{16995, 165540, 9, 961},
	{17016, 165544, 9, 961},
	{17037, 165548, 9, 961},
	{17058, 165552, 9, 961},
	{17079, 165556, 9, 961},
	{17100, 165560, 9, 961},
	{17121, 165564, 9, 961},
	{17142, 165568, 9, 961},
	{17163, 165572, 3, 970},
	{17181, 165580, 16, 973},
	{17198, 165584, 16, 973},
	{17216, 165588, 7, 989},
	{17237, 165592, 6, 996},
	{17255, 165600, 7, 1002},
	{17270, 165608, 2, 694},
	{17287, 165640, 1, 1009},
	{17309, 165644, 5, 1010},
	{17331, 165648, 1, 1015},
	{17351, 165652, 8, 1016},
	{17373, 165716, 8, 1024},
	{17391, 165720, 8, 1032},
	{17412, 165724, 17, 1040},
	{17433, 165728, 6, 1057},
	{17451, 165732, 6, 1057},
	{17469, 165736, 6, 1057},
	{17487, 165740, 6, 1057},
	{17505, 165744, 6, 1057},
	{17523, 165748, 6, 1057},
	{17541, 165752, 6, 1057},
	{17559, 165756, 6, 1057},
	{17577, 165760, 9, 1063},
	{17595, 165764, 9, 1063},
	{17613, 165768, 9, 1063},
	{17631, 165772, 9, 1063},
	{17649, 165776, 9, 1063},
	{17667, 165780, 9, 1063},
	{17685, 165784, 9, 1063},
	{17703, 165788, 9, 1063},
	{17721, 165836, 1, 1072},
	{17735, 165840, 1, 1072},
	{17750, 165844},
	{17768, 165848},
	{17786, 165852},
	{17803, 165856},
	{17824, 165860, 1, 1073},
	{17840, 165864},
	{17853, 165872, 8, 1074},
	{17872, 165876},
	{17887, 165880, 1, 1082},
	{17909, 165884, 1, 1083},
	{17936, 165888, 10, 1084},
	{17953, 165892, 12, 1094},
	{17961, 165896, 4, 1106},
	{17978, 165900, 17, 1110},
	{17996, 165904, 20, 1127},
	{18012, 165908, 16, 1147},
	{18031, 165912, 10, 1163},
	{18046, 165916, 28, 1173},
	{18064, 165920, 16, 1201},
	{18082, 165924, 4, 1217},
	{18106, 165928},
	{18131, 165932, 11, 1221},
	{18154, 165936, 7, 1232},
	{18183, 165940, 2, 1239},
	{18205, 165944, 2, 1241},
	{18220, 165948, 5, 1243},
	{18250, 165952, 5, 1248},
	{18265, 165956},
	{18283, 166400, 2, 1253},
	{18300, 166404, 2, 1255},
	{18319, 166408, 1, 1257},
	{18335, 166412, 4, 1258},
	{18354, 166416, 1, 1262},
	{18375, 166420, 1, 1263},
	{18388, 166424},
	{18411, 166428},
	{18434, 166432, 1, 1264},
	{18454, 166436, 4, 1265},
	{18474, 166440, 1, 1269},
	{18495, 166444, 1, 1270},
	{18510, 166448, 6, 1271},
	{18532, 166452, 6, 1271},
	{18554, 166456, 8, 1277},
	{18580, 166460, 8, 1277},
	{18606, 166464, 15, 1285},
	{18618, 166468, 3, 1300},
	{18637, 166472, 7, 1303},
	{18655, 166476, 24, 1310},
	{18673, 166480},
	{18685, 166484, 1, 1334},
	{18699, 166488, 1, 1335},
	{18713, 166492, 1, 1336},
	{18727, 166496, 1, 1337},
	{18750, 166500, 1, 1337},
	{18773, 166504, 1, 1337},
	{18796, 166508, 5, 1338},
	{18817, 166512},
	{18828, 166516},
	{18841, 166520},
	{18858, 166524, 8, 1343},
	{18877, 166528},
	{18888, 166532, 3, 1351},
	{18907, 166536},
	{18929, 166540},
	{18951, 166544, 3, 1354},
	{18971, 166548, 2, 1357},
	{18998, 166552, 5, 1359},
	{19020, 166560},
	{19045, 166564},
	{19070, 166568, 6, 1364},
	{19089, 166572, 1, 1370},
	{19112, 166576, 1, 1370},
	{19135, 166580, 1, 1371},
	{19149, 166584, 1, 1372},
	{19164, 166588, 9, 1373},
	{19181, 166592, 4, 1382},
	{19208, 166596, 4, 1386},
	{19235, 166600, 4, 1390},
	{19254, 166608},
	{19280, 166612, 1, 1394},
	{19305, 166620},
	{19333, 166624},
	{19359, 166628, 1, 1394},
	{19384, 166636},
	{19412, 166640},
	{19438, 166644, 1, 1394},
	{19463, 166652},
	{19491, 166656},
	{19517, 166660, 1, 1394},
	{19542, 166668},
	{19570, 166696},
	{19601, 166700},
	{19644, 166704, 1, 1395},
	{19682, 166712, 1, 1396},
	{19702, 166732, 2, 1397},
	{19721, 166736, 5, 1399},
	{19743, 166740, 19, 1404},
	{19764, 166744, 3, 1423},
	{19781, 166748, 1, 1370},
	{19802, 166752, 1, 1370},
	{19825, 166756, 1, 1370},
	{19848, 166760, 1, 1370},
	{19871, 166764, 12, 1426},
	{19884, 166768, 6, 1438},
	{19901, 166772},
	{19925, 166776, 2, 1444},
	{19955, 166780},
	{19979, 166784},
	{20009, 166788},
	{20040, 166792},
	{20069, 166796},
	{20099, 166800, 3, 1446},
	{20119, 166804, 8, 1449},
	{20138, 166808, 4, 1457},
	{20164, 166812, 3, 1354},
	{20188, 166868, 8, 1461},
	{20214, 166872, 8, 1469},
	{20240, 166876, 5, 1477},
	{20256, 166880, 6, 1482},
	{20272, 166884, 3, 1488},
	{20287, 166888},
	{20310, 166892},
	{20333, 166896},
	{20356, 166900},
	{20379, 166904, 8, 1491},
	{20413, 166908, 8, 1499},
	{20447, 166912, 8, 1507},
	{20481, 166916, 8, 1515},
	{20515, 166920, 8, 1491},
	{20549, 166924, 8, 1499},
	{20583, 166928, 8, 1507},
	{20617, 166932, 8, 1515},
	{20651, 166936, 8, 1491},
	{20685, 166940, 8, 1499},
	{20719, 166944, 8, 1507},
	{20753, 166948, 8, 1515},
	{20787, 166952, 8, 1491},
	{20821, 166956, 8, 1499},
	{20855, 166960, 8, 1507},
	{20889, 166964, 8, 1515},
	{20923, 166968, 2, 1523},
	{20947, 166972, 2, 1525},
	{20971, 166976, 4, 1527},
	{20992, 166980, 12, 1531},
	{21012, 166984, 2, 1543},
	{21032, 166988, 20, 1545},
	{21070, 166992, 2, 1565},
	{21090, 167000, 1, 1567},
	{21118, 167004, 1, 1568},
	{21139, 167008},
	{21154, 167012, 2, 1569},
	{21170, 167016, 1, 1571},
	{21186, 167020, 3, 1572},
	{21201, 167024, 19, 1575},
	{21216, 167028, 8, 1594},
	{21233, 167032, 12, 1602},
	{21255, 167036},
	{21271, 167040, 1, 1614},
	{21293, 167044},
	{21309, 167048, 1, 1571},
	{21331, 167052},
	{21353, 167056},
	{21375, 167060},
	{21394, 167068},
	{21409, 167072, 2, 1569},
	{21425, 167076, 1, 1571},
	{21441, 167080, 3, 1572},
	{21456, 167084, 19, 1575},
	{21471, 167088, 8, 1594},
	{21488, 167092, 12, 1602},
	{21510, 167096},
	{21526, 167100, 1, 1614},
	{21548, 167104},
	{21564, 167108, 1, 1571},
	{21586, 167112},
	{21608, 167116},
	{21630, 167120},
	{21649, 167128},
	{21664, 167132, 2, 1569},
	{21680, 167136, 1, 1571},
	{21696, 167140, 3, 1572},
	{21711, 167144, 19, 1575},
	{21726, 167148, 8, 1594},
	{21743, 167152, 12, 1602},
	{21765, 167156},
	{21781, 167160, 1, 1614},
	{21803, 167164},
	{21819, 167168, 1, 1571},
	{21841, 167172},
	{21863, 167176},
	{21885, 167180},
	{21904, 167188},
	{21919, 167192, 2, 1569},
	{21935, 167196, 1, 1571},
	{21951, 167200, 3, 1572},
	{21966, 167204, 19, 1575},
	{21981, 167208, 8, 1594},
	{21998, 167212, 12, 1602},
	{22020, 167216},
	{22036, 167220, 1, 1614},
	{22058, 167224},
	{22074, 167228, 1, 1571},
	{22096, 167232},
	{22118, 167236},
	{22140, 167240},
	{22159, 167248},
	{22174, 167252, 2, 1569},
	{22190, 167256, 1, 1571},
	{22206, 167260, 3, 1572},
	{22221, 167264, 19, 1575},
	{22236, 167268, 8, 1594},
	{22253, 167272, 12, 1602},
	{22275, 167276},
	{22291, 167280, 1, 1614},
	{22313, 167284},
	{22329, 167288, 1, 1571},
	{22351, 167292},
	{22373, 167296},
	{22395, 167300},
	{22414, 167308},
	{22429, 167312, 2, 1569},
	{22445, 167316, 1, 1571},
	{22461, 167320, 3, 1572},
	{22476, 167324, 19, 1575},
	{22491, 167328, 8, 1594},
	{22508, 167332, 12, 1602},
	{22530, 167336},
	{22546, 167340, 1, 1614},
	{22568, 167344},
	{22584, 167348, 1, 1571},
	{22606, 167352},
	{22628, 167356},
	{22650, 167360},
	{22669, 167368},
	{22684, 167372, 2, 1569},
	{22700, 167376, 1, 1571},
	{22716, 167380, 3, 1572},
	{22731, 167384, 19, 1575},
	{22746, 167388, 8, 1594},
	{22763, 167392, 12, 1602},
	{22785, 167396},
	{22801, 167400, 1, 1614},
	{22823, 167404},
	{22839, 167408, 1, 1571},
	{22861, 167412},
	{22883, 167416},
	{22905, 167420},
	{22924, 167428},
	{22939, 167432, 2, 1569},
	{22955, 167436, 1, 1571},
	{22971, 167440, 3, 1572},
	{22986, 167444, 19, 1575},
	{23001, 167448, 8, 1594},
	{23018, 167452, 12, 1602},
	{23040, 167456},
	{23056, 167460, 1, 1614},
	{23078, 167464},
	{23094, 167468, 1, 1571},
	{23116, 167472},
	{23138, 167476},
	{23160, 167480},
	{23179, 167488, 1, 1615},
	{23198, 167492, 1, 1615},
	{23217, 167496, 1, 1615},
	{23236, 167500, 1, 1615},
	{23255, 167504, 1, 1615},
	{23274, 167508, 1, 1615},
	{23293, 167512, 1, 1615},
	{23312, 167516, 1, 1615},
	{23331, 167520, 1, 1615},
	{23356, 167524, 1, 1615},
	{23381, 167528, 1, 1615},
	{23406, 167532, 1, 1615},
	{23431, 167536, 1, 1615},
	{23456, 167540, 1, 1615},
	{23481, 167544, 1, 1615},
	{23506, 167548, 1, 1615},
	{23531, 167552, 1, 1615},
	{23556, 167556, 1, 1615},
	{23581, 167560, 1, 1615},
	{23606, 167564, 1, 1615},
	{23631, 167568, 1, 1615},
	{23656, 167572, 1, 1615},
	{23681, 167576, 1, 1615},
	{23706, 167580, 1, 1615},
	{23731, 167584, 1, 1615},
	{23754, 167588, 1, 1615},
	{23777, 167592, 1, 1615},
	{23800, 167596, 1, 1615},
	{23823, 167600, 1, 1615},
	{23846, 167604, 1, 1615},
	{23869, 167608, 1, 1615},
	{23892, 167612, 1, 1615},
	{23915, 167616, 3, 1616},
	{23933, 167620, 3, 1616},
	{23951, 167624, 3, 1616},
	{23969, 167628, 3, 1616},
	{23987, 167632, 3, 1616},
	{24005, 167636, 3, 1616},
	{24023, 167640, 3, 1616},
	{24041, 167644, 3, 1616},
	{24059, 167648, 8, 1619},
	{24077, 167652, 8, 1619},
	{24095, 167656, 8, 1619},
	{24113, 167660, 8, 1619},
	{24131, 167664, 8, 1619},
	{24149, 167668, 8, 1619},
	{24167, 167672, 8, 1619},
	{24185, 167676, 8, 1619},
	{24203, 196608, 1, 1627},
	{24223, 196612, 1, 1628},
	{24243, 196616},
	{24263, 196620},
	{24283, 196624},
	{24304, 196628},
	{24325, 196632, 1, 1629},
	{24347, 196636, 1, 1630},
	{24369, 196640},
	{24399, 196644},
	{24429, 196648},
	{24458, 196652},
	{24487, 196656},
	{24517, 196660},
	{24547, 196664},
	{24576, 196668},
	{24605, 196672},
	{24635, 196676},
	{24665, 196680},
	{24694, 196684},
	{24723, 196688},
	{24753, 196692},
	{24783, 196696},
	{24812, 196700},
	{24841, 196704, 1, 1631},
	{24863, 196708, 1, 1632},
	{24885, 196712},
	{24908, 196716},
	{24931, 196720},
	{24954, 196724},
	{24977, 196728},
	{25000, 196732},
	{25023, 196736},
	{25047, 196740},
	{25071, 196744},
	{25095, 196748},
	{25119, 196752},
	{25143, 196756},
	{25167, 196760},
	{25191, 196764},
	{25215, 196768},
	{25237, 196772},
	{25259, 196776},
	{25280, 196780},
	{25301, 196784},
	{25325, 196788},
	{25349, 196792},
	{25373, 196796},
	{25397, 196800},
	{25421, 196804},
	{25445, 196808, 1, 1633},
	{25466, 196812, 1, 1633},
	{25489, 196816, 1, 1633},
	{25505, 196852, 1, 1634},
	{25527, 196856, 1, 1634},
	{25549, 196860, 1, 1635},
	{25565, 196864},
	{25578, 196868},
	{25591, 196872},
	{25604, 196876},
	{25617, 196880},
	{25630, 196884},
	{25643, 196888},
	{25656, 196892},
	{25669, 196896, 1, 1633},
	{25692, 196908, 1, 663},
	{25711, 196912},
	{25729, 196916},
	{25756, 196920},
	{25783, 196928, 2, 1636},
	{25796, 196932},
	{25809, 196936},
	{25832, 196940},
	{25855, 196944},
	{25883, 196948},
	{25911, 196952},
	{25939, 196956},
	{25967, 196960, 1, 1638},
	{25985, 196964, 4, 1639},
	{26003, 196968},
	{26018, 196972},
	{26042, 196976},
	{26066, 196980},
	{26085, 196984},
	{26104, 196988},
	{26128, 196992},
	{26152, 196996},
	{26176, 197000},
	{26200, 197028, 1, 1643},
	{26218, 197032, 2, 1644},
	{26236, 197036},
	{26254, 197040},
	{26272, 197044, 1, 1646},
	{26290, 197048, 2, 1647},
	{26308, 197052},
	{26326, 197056, 2, 1649},
	{26345, 197060, 5, 1651},
	{26364, 197072},
	{26388, 197076, 2, 1649},
	{26408, 197080, 5, 1651},
	{26428, 197084, 7, 1656},
	{26447, 197088, 7, 1656},
	{26465, 197092, 1, 1663},
	{26482, 197100, 1, 1664},
	{26503, 197104, 13, 1665},
	{26517, 197108},
	{26531, 197112},
	{26545, 197116, 2, 1678},
	{26561, 197120},
	{26580, 197124, 1, 1680},
	{26602, 197128},
	{26621, 197132, 1, 1681},
	{26643, 197136, 7, 1682},
	{26661, 197140},
	{26681, 197144, 1, 1680},
	{26704, 197148},
	{26724, 197152, 1, 1681},
	{26747, 197156, 7, 1682},
	{26766, 197160, 7, 1689},
	{26778, 197164, 2, 1696},
	{26795, 197168, 1, 1698},
	{26812, 197172, 1, 1699},
	{26830, 197176, 4, 1700},
	{26850, 197180, 2, 1704},
	{26867, 197184},
	{26883, 197188, 1, 1706},
	{26896, 197192, 1, 1707},
	{26910, 197196, 1, 1708},
	{26924, 197200, 1, 1709},
	{26946, 197204, 1, 1710},
	{26966, 197208, 1, 1711},
	{26988, 197212, 1, 1712},
	{27008, 197216, 1, 1707},
	{27025, 197220, 1, 1708},
	{27042, 197224},
	{27056, 197232, 2, 1713},
	{27078, 197236, 2, 1715},
	{27100, 197240, 2, 1713},
	{27123, 197244, 2, 1715},
	{27146, 197248, 2, 1713},
	{27168, 197252, 2, 1715},
	{27190, 197364, 1, 1717},
	{27211, 197368, 1, 1718},
	{27231, 197372, 1, 1719},
	{27251, 197376, 1, 1718},
	{27268, 197380, 1, 1719},
	{27285, 197384, 1, 1720},
	{27301, 197388, 1, 1721},
	{27320, 197392, 1, 1722},
	{27339, 197396, 1, 1723},
	{27356, 197400, 1, 1724},
	{27374, 197404, 1, 1725},
	{27392, 197408, 1, 1726},
	{27408, 197412, 1, 1727},
	{27426, 197416, 1, 1728},
	{27444, 197420, 1, 1729},
	{27460, 197424, 1, 1724},
	{27475, 197428, 1, 1725},
	{27490, 197432, 1, 1726},
	{27503, 197436, 1, 1727},
	{27518, 197440, 1, 1728},
	{27533, 197444, 1, 1729},
	{27546, 197448, 1, 1730},
	{27560, 197452, 1, 1731},
	{27574, 197456, 1, 1732},
	{27586, 197460, 4, 1733},
	{27609, 197464, 3, 1737},
	{27631, 197468, 1, 1740},
	{27651, 197472, 1, 1741},
	{27665, 197476, 1, 1742},
	{27679, 197480, 1, 1743},
	{27691, 197484, 1, 1744},
	{27707, 197488, 1, 1741},
	{27724, 197492, 1, 1742},
	{27741, 197496, 1, 1743},
	{27756, 197500, 1, 1744},
	{27775, 197552, 1, 1745},
	{27800, 197556, 1, 1745},
	{27824, 197560, 1, 1746},
	{27844, 197568},
	{27870, 197572, 1, 1628},
	{27899, 197576},
	{27924, 197580, 1, 1628},
	{27952, 197584},
	{27975, 197588, 1, 1628},
	{28001, 197592},
	{28023, 197596, 1, 1628},
	{28048, 197600},
	{28067, 197604, 1, 1628},
	{28089, 197608, 1, 1343},
	{28103, 197612},
	{28120, 197616, 1, 1628},
	{28140, 197620, 8, 1747},
	{28157, 197624, 13, 1755},
	{28174, 197628},
	{28191, 197632, 1, 1698},
	{28211, 197636},
	{28228, 197640, 1, 1663},
	{28248, 197644, 2, 1768},
	{28267, 197888, 8, 1770},
	{28288, 197892, 8, 1770},
	{28309, 198656, 6, 1778},
	{28324, 198912},
	{28347, 198916},
	{28370, 198920, 1, 1784},
	{28389, 198924, 1, 1343},
	{28404, 198928},
	{28437, 198932},
	{28470, 198936},
	{28503, 198940},
	{28536, 198948},
	{28552, 198952},
	{28567, 198956, 2, 1357},
	{28593, 198960},
	{28609, 198964},
	{28627, 198968, 1, 1785},
	{28648, 198972, 2, 1786},
	{28673, 198976},
	{28696, 198980},
	{28715, 198984},
	{28731, 198988, 1, 830},
	{28750, 198992},
	{28770, 198996, 1, 830},
	{28793, 199000},
	{28811, 199004, 1, 830},
	{28832, 199008, 9, 1788},
	{28857, 199012},
	{28873, 199016},
	{28894, 199020, 4, 1797},
	{28902, 199024},
	{28916, 199028},
	{28930, 199032},
	{28944, 199036, 3, 1801},
	{28959, 199040, 2, 1804},
	{28971, 199044, 1, 830},
	{28997, 199048, 3, 1806},
	{29013, 199168, 1, 1809},
	{29038, 199172, 2, 1810},
	{29063, 199184, 2, 1812},
	{29089, 199188, 2, 1812},
	{29115, 199192, 2, 1812},
	{29141, 199212, 2, 1812},
	{29167, 199296, 2, 1814},
	{29195, 199300, 1, 1816},
	{29219, 199304, 1, 1817},
	{29243, 199308, 1, 1818},
	{29276, 199312, 1, 1818},
	{29304, 199328, 2, 1814},
	{29333, 199332, 1, 1816},
	{29358, 199336, 1, 1817},
	{29383, 199340, 1, 1818},
	{29417, 199344, 1, 1818},
	{29446, 199360, 2, 1814},
	{29470, 199364, 1, 1816},
	{29490, 199368, 1, 1817},
	{29510, 199372, 1, 1818},
	{29539, 199376, 1, 1818},
	{29563, 199936},
	{29590, 199940},
	{29617, 199944},
	{29644, 199948},
	{29671, 199952},
	{29698, 199956},
	{29725, 199960},
	{29752, 199964},
	{29779, 199968, 7, 1819},
	{29790, 199972, 2, 1826},
	{29804, 200192},
	{29823, 200196, 1, 840},
	{29845, 200448},
	{29869, 200452, 1, 1828},
	{29892, 200456},
	{29916, 200460, 1, 1828},
	{29939, 200464},
	{29963, 200468, 1, 1828},
	{29986, 200472},
	{30010, 200476, 1, 1828},
	{30033, 200696},
	{30052, 200700, 1, 1828},
	{30070, 200704},
	{30082, 200708},
	{30094, 200712},
	{30112, 200716},
	{30131, 200720},
	{30149, 200724},
	{30161, 200728},
	{30173, 200732},
	{30191, 200736},
	{30209, 200740},
	{30228, 200744, 4, 1829},
	{30242, 200748, 2, 1833},
	{30260, 200752, 2, 1835},
	{30274, 200756, 2, 1837},
	{30288, 200760, 2, 1839},
	{30305, 200764, 2, 1841},
	{30322, 200768},
	{30335, 200772, 2, 1843},
	{30347, 200776},
	{30361, 200780},
	{30377, 200784},
	{30391, 200788},
	{30407, 200792},
	{30422, 200796},
	{30439, 200800},
	{30454, 200804},
	{30471, 200808, 2, 1845},
	{30493, 200812, 10, 1847},
	{30510, 200816, 2, 1857},
	{30531, 200820, 2, 1859},
	{30543, 200824},
	{30558, 200828, 6, 1861},
	{30573, 200832, 2, 1867},
	{30587, 200836},
	{30604, 200960},
	{30626, 200964},
	{30650, 200968},
	{30674, 200972},
	{30700, 212992},
	{30720, 212996},
	{30740, 213000},
	{30760, 213004},
	{30780, 213008},
	{30800, 213012},
	{30820, 213016},
	{30840, 213020},
	{30860, 213024},
	{30880, 213028},
	{30900, 213032},
	{30920, 213036},
	{30940, 213040},
	{30963, 213044},
	{30986, 213048},
	{31009, 213248},
	{31030, 213252},
	{31051, 213260},
	{31072, 213264},
	{31093, 213268},
	{31117, 213272},
	{31141, 213276},
	{31165, 213280},
	{31189, 213284},
	{31213, 213288},
	{31237, 213292},
	{31261, 213296},
	{31285, 213504},
	{31304, 213508},
	{31323, 213512},
	{31342, 213516},
	{31361, 213520},
	{31380, 213524},
	{31399, 213528},
	{31418, 213532},
	{31437, 213536},
	{31456, 213540},
	{31475, 213544},
	{31494, 213548},
	{31513, 213552},
	{31532, 213556},
	{31551, 213560},
	{31570, 213564},
	{31589, 213568},
	{31608, 213572},
	{31627, 213576},
	{31646, 213580},
	{31665, 213584},
	{31685, 213588},
	{31705, 213592},
	{31725, 213596},
	{31745, 214016},
	{31767, 214020, 1, 1869},
	{31789, 214024},
	{31811, 214028, 1, 1869},
	{31833, 214032},
	{31855, 214036, 1, 1869},
	{31877, 214040},
	{31899, 214044, 1, 1869},
	{31921, 214272},
	{31943, 214276},
	{31965, 214280},
	{31987, 214284},
	{32009, 214288},
	{32031, 214292},
	{32053, 214296},
	{32075, 214300},
	{32097, 214304},
	{32119, 214308},
	{32141, 214312},
	{32163, 214316},
	{32185, 214320},
	{32207, 214324},
	{32229, 214328},
	{32251, 214332},
	{32273, 214528},
	{32293, 214532},
	{32313, 214536},
	{32333, 214540},
	{32353, 214544},
	{32373, 214548},
	{32393, 214552},
	{32413, 214556},
	{32433, 214560},
	{32453, 214564},
	{32473, 214568},
	{32493, 214572},
	{32513, 214784},
	{32532, 214788},
	{32551, 214792},
	{32570, 214796},
	{32589, 214800},
	{32608, 214804},
	{32627, 214808},
	{32646, 214812},
	{32665, 214816},
	{32684, 214820},
	{32703, 214824},
	{32722, 214828},
	{32741, 214832},
	{32760, 214836},
	{32779, 214840},
	{32798, 214844},
	{32817, 214848},
	{32836, 214852},
	{32855, 214856},
	{32874, 214860},
	{32893, 214864},
	{32913, 214868},
	{32933, 214872},
	{32953, 214876},
	{32973, 214880},
	{32993, 214884},
	{33013, 214888},
	{33033, 214892},
	{33053, 214896},
	{33073, 214900},
	{33093, 214904},
	{33113, 214908},
	{33133, 215296},
	{33152, 215300},
	{33171, 215304},
	{33190, 215308},
	{33209, 215312},
	{33228, 215316},
	{33247, 215320},
	{33266, 215324},
	{33285, 215424},
	{33306, 215428},
	{33327, 215552},
	{33347, 215556},
	{33367, 215560},
	{33387, 215564},
	{33407, 215568},
	{33427, 215572},
	{33447, 215576},
	{33467, 215580},
	{33487, 215808},
	{33506, 215812},
	{33525, 215816},
	{33544, 215820},
	{33563, 216064},
	{33582, 216068},
	{33601, 216072},
	{33620, 216076},
	{33639, 216320},
	{33659, 216324},
	{33679, 216328},
	{33699, 216332},
	{33719, 216336},
	{33739, 216340},
	{33759, 216344},
	{33779, 216348},
	{33799, 216576},
	{33820, 216580},
	{33841, 216584},
	{33862, 216588},
	{33883, 216592},
	{33904, 216596},
	{33925, 216600},
	{33946, 216604},
	{33967, 216640},
	{33988, 216644},
	{34009, 216648},
	{34030, 216652},
	{34051, 216656},
	{34072, 216660},
	{34093, 216664},
	{34114, 216668},
	{34135, 216704},
	{34156, 216708},
	{34177, 216712},
	{34198, 216716},
	{34219, 216720},
	{34240, 216724},
	{34261, 216728},
	{34282, 216732},
	{34303, 216832},
	{34323, 216836},
	{34343, 216840},
	{34363, 216844},
	{34383, 216848},
	{34403, 216852},
	{34423, 216856},
	{34443, 216860},
	{34463, 216864},
	{34484, 216868},
	{34505, 216872},
	{34526, 216876},
	{34547, 216880},
	{34568, 216884},
	{34589, 216888},
	{34610, 216892},
	{34631, 217112},
	{34650, 217116},
	{34669, 217120},
	{34688, 217124},
	{34707, 217128},
	{34726, 217132},
	{34745, 217136},
	{34764, 217140},
	{34783, 217344},
	{34802, 217348},
	{34821, 217352},
	{34840, 217356},
	{34859, 217360},
	{34878, 217364},
	{34897, 217368},
	{34916, 217372},
	{34935, 217600},
	{34955, 217604},
	{34975, 217608},
	{34995, 217612},
	{35015, 217856},
	{35035, 217860},
	{35055, 217864},
	{35075, 217868},
	{35095, 217872},
	{35115, 217876},
	{35135, 217880},
	{35155, 217884},
	{35175, 217984},
	{35200, 217988, 2, 1870},
	{35225, 218016},
	{35251, 218020, 2, 1870},
	{35277, 218080},
	{35302, 218084},
	{35327, 218088},
	{35352, 218092},
	{35377, 218096},
	{35403, 218100},
	{35429, 218224},
	{35451, 218228},
	{35473, 218232},
	{35495, 218236},
	{35517, 218240},
	{35537, 218244},
	{35557, 218248},
	{35577, 218252},
	{35597, 218624},
	{35619, 218628},
	{35641, 218632},
	{35663, 218636},
	{35685, 218640},
	{35707, 218644},
	{35729, 218648},
	{35751, 218652},
	{35773, 218656},
	{35795, 218660},
	{35817, 218664},
	{35839, 218668},
	{35861, 218672},
	{35883, 218676},
	{35905, 218680},
	{35927, 218684},
	{35949, 218880},
	{35970, 218884},
	{35991, 218888},
	{36012, 218892},
	{36033, 218896},
	{36054, 218900},
	{36075, 218904},
	{36096, 218908},
	{36117, 219136},
	{36137, 219140},
	{36157, 219144},
	{36177, 219148},
	{36197, 219152},
	{36217, 219156},
	{36237, 219160},
	{36257, 219164},
	{36277, 219392},
	{36297, 219396},
	{36317, 221184, 5, 1872},
	{36341, 221188, 4, 1877},
	{36366, 221192, 5, 1872},
	{36390, 221196, 5, 1872},
	{36414, 221200, 4, 1877},
	{36439, 221204, 5, 1872},
	{36463, 221208, 4, 1877},
	{36488, 221212, 5, 1872},
	{36512, 221216, 4, 1881},
	{36528, 221220, 5, 1872},
	{36552, 221224, 3, 1885},
	{36586, 221228, 3, 1888},
	{36620, 221232, 3, 1891},
	{36645, 221236, 3, 1894},
	{36670, 221240, 3, 1891},
	{36695, 221248},
	{36710, 221252, 1, 1818},
	{36733, 221256},
	{36756, 221260},
	{36774, 221264, 2, 1897},
	{36792, 221268, 4, 1899},
	{36812, 221440, 20, 1903},
	{36837, 221444, 20, 1903},
	{36862, 221448, 15, 1923},
	{36890, 221452, 15, 1923},
	{36918, 221456, 15, 1923},
	{36946, 221460, 15, 1923},
	{36974, 221492, 8, 1938},
	{37002, 221496, 8, 1938},
	{37030, 221696, 5, 1946},
	{37053, 221700, 4, 1951},
	{37077, 221704, 5, 1946},
	{37100, 221708, 4, 1951},
	{37124, 221712, 5, 1946},
	{37147, 221716, 4, 1951},
	{37171, 221720, 5, 1946},
	{37194, 221724, 4, 1951},
	{37218, 221728, 2, 1955},
	{37241, 221736, 2, 1955},
	{37264, 221744, 2, 1955},
	{37287, 221752, 2, 1955},
	{37310, 221760, 2, 1955},
	{37333, 221768, 2, 1955},
	{37356, 221776, 2, 1955},
	{37380, 221784, 2, 1955},
	{37404, 222208, 5, 1957},
	{37430, 222212, 4, 1962},
	{37457, 222216, 5, 1957},
	{37483, 222220, 4, 1962},
	{37510, 222224, 5, 1957},
	{37536, 222228, 4, 1962},
	{37563, 222232, 5, 1957},
	{37589, 222236, 4, 1962},
	{37616, 222464, 5, 1957},
	{37642, 222468, 4, 1962},
	{37669, 222472, 1, 1872},
	{37695, 222476, 1, 1872},
	{37721, 222480, 1, 1872},
	{37747, 222484, 1, 1872},
	{37773, 222488, 1, 1872},
	{37799, 222492, 1, 1872},
	{37825, 222496, 1, 1872},
	{37851, 222720, 5, 1957},
	{37875, 222724, 5, 1957},
	{37899, 222728, 5, 1957},
	{37923, 222732, 5, 1957},
	{37947, 222736, 4, 1962},
	{37972, 222740, 4, 1962},
	{37997, 222744, 4, 1962},
	{38022, 222748, 4, 1962},
	{38047, 222752, 1, 1872},
	{38071, 222756, 1, 1872},
	{38095, 222760, 8, 1966},
	{38116, 222976, 4, 1974},
	{38139, 222980, 4, 1974},
	{38162, 222984, 4, 1974},
	{38185, 222988, 4, 1974},
	{38208, 222992, 4, 1974},
	{38231, 222996, 4, 1974},
	{38254, 223000, 4, 1974},
	{38277, 223004, 4, 1974},
	{38300, 223008, 4, 1974},
	{38323, 223012, 4, 1974},
	{38346, 223016, 4, 1974},
	{38370, 223020, 4, 1974},
	{38394, 223024, 4, 1974},
	{38418, 223028, 4, 1974},
	{38442, 223032, 4, 1974},
	{38466, 223036, 4, 1974},
	{38490, 223104, 9, 1978},
	{38510, 223112, 1, 1987},
	{38531, 223232, 5, 1957},
	{38556, 223236, 4, 1962},
	{38582, 223240, 8, 1988},
	{38605, 223488, 3, 1996},
	{38628, 223492, 3, 1996},
	{38651, 223496, 3, 1996},
	{38674, 223500, 3, 1996},
	{38697, 223504, 2, 1999},
	{38721, 223508, 2, 1999},
	{38745, 223744, 5, 1957},
	{38769, 223748, 5, 1957},
	{38793, 223752, 5, 1957},
	{38817, 223756, 5, 1957},
	{38841, 223760, 4, 1962},
	{38866, 224000, 5, 2001},
	{38889, 224004, 4, 2006},
	{38913, 224008, 3, 2010},
	{38936, 224256, 5, 2001},
	{38959, 224260, 4, 2006},
	{38983, 224264, 3, 2010},
	{39006, 224512, 5, 1957},
	{39030, 224516, 4, 1962},
	{39055, 224520, 5, 1957},
	{39079, 224524, 4, 1962},
	{39104, 224528, 3, 2013},
	{39128, 224532, 3, 2013},
	{39152, 224768, 5, 1957},
	{39177, 224772, 4, 1951},
	{39203, 224776, 5, 1957},
	{39228, 224780, 4, 1951},
	{39254, 224784, 3, 2013},
	{39279, 224788, 3, 2013},
	{39304, 224832, 5, 1957},
	{39329, 224836, 4, 1951},
	{39355, 224840, 5, 1957},
	{39380, 224844, 4, 1951},
	{39406, 224848, 3, 2013},
	{39431, 224852, 3, 2013},
	{39456, 224896, 5, 1957},
	{39481, 224900, 4, 1951},
	{39507, 224904, 3, 2013},
	{39532, 224908, 3, 2013},
	{39557, 224912, 3, 2013},
	{39582, 225024, 5, 1957},
	{39606, 225028, 4, 1951},
	{39631, 225032, 3, 2013},
	{39655, 225036, 3, 2013},
	{39679, 225040, 3, 2013},
	{39703, 225048, 5, 1957},
	{39728, 225052, 4, 1951},
	{39754, 225056, 3, 2013},
	{39779, 225060, 3, 2013},
	{39804, 225064, 3, 2013},
	{39829, 225280, 12, 2016},
	{39851, 225284, 5, 2028},
	{39874, 225288, 4, 2033},
	{39898, 225292, 2, 2037},
	{39921, 225296, 2, 2037},
	{39944, 225300, 2, 2037},
	{39967, 225536, 5, 1957},
	{39990, 225540, 4, 1962},
	{40014, 225544, 5, 1957},
	{40037, 225548, 4, 1962},
	{40061, 225552, 5, 1957},
	{40084, 225560, 5, 1957},
	{40107, 225792, 4, 2039},
	{40128, 225796},
	{40157, 225800, 2, 2043},
	{40186, 225804},
	{40212, 225808, 7, 2045},
	{40241, 225812},
	{40260, 225816, 2, 2052},
	{40286, 225820, 2, 2054},
	{40309, 225824},
	{40332, 225828, 2, 2056},
	{40359, 225832},
	{40386, 225836, 2, 2058},
	{40411, 225840, 2, 2060},
	{40439, 225844, 2, 2062},
	{40467, 225848, 2, 2064},
	{40490, 225852, 2, 2066},
	{40513, 225856},
	{40546, 225860, 2, 2068},
	{40579, 225864},
	{40611, 225868, 2, 2068},
	{40643, 225872, 2, 2070},
	{40662, 225876, 2, 2072},
	{40689, 225880},
	{40716, 225884, 2, 2074},
	{40743, 225888, 2, 2076},
	{40770, 225892, 10, 2078},
	{40791, 225896, 8, 2088},
	{40810, 225900, 8, 2096},
	{40829, 225904, 2, 2104},
	{40853, 225908, 2, 2106},
	{40885, 225912, 2, 2108},
	{40915, 225916, 4, 2110},
	{40951, 225920, 3, 2114},
	{40984, 225924, 1, 2117},
	{41002, 225932, 1, 2118},
	{41022, 226048, 2, 2119},
	{41039, 226052, 1, 2121},
	{41063, 226056, 1, 2121},
	{41087, 226060, 4, 2122},
	{41113, 226064, 3, 2126},
	{41142, 226068, 1, 687},
	{41171, 226072, 3, 2126},
	{41200, 226076, 1, 687},
	{41229, 226192, 1, 2129},
	{41250, 226196, 1, 2129},
	{41277, 226304, 5, 2028},
	{41301, 226308, 4, 2033},
	{41326, 226312, 2, 2037},
	{41350, 226316, 5, 2028},
	{41374, 226320, 4, 2033},
	{41399, 226324, 2, 2037},
	{41423, 226328, 10, 2130},
	{41445, 226432, 5, 2140},
	{41472, 226436, 5, 2140},
	{41499, 226440, 6, 2145},
	{41531, 226480, 5, 2140},
	{41559, 226484, 5, 2140},
	{41587, 226488, 5, 2140},
	{41615, 226492, 5, 2140},
	{41643, 226496, 5, 2140},
	{41671, 226500, 5, 2140},
	{41699, 226504, 5, 2140},
	{41727, 226508, 5, 2140},
	{41755, 226512, 6, 2145},
	{41788, 226544, 5, 1957},
	{41817, 226548, 5, 1957},
	{41846, 226552, 4, 1962},
	{41876, 226556, 4, 1962},
	{41906, 226560, 8, 1988},
	{41933, 226564, 8, 1988},
	{41960, 226608, 5, 1957},
	{41990, 226612, 4, 1962},
	{42021, 226616, 8, 1988},
	{42049, 226688, 5, 2028},
	{42073, 226692, 4, 2033},
	{42098, 226696, 3, 2151},
	{42122, 226700, 2, 2154},
	{42148, 226704, 2, 2154},
	{42174, 226816, 5, 1957},
	{42200, 226820, 4, 1962},
	{42227, 226824, 5, 1957},
	{42253, 226828, 5, 1957},
	{42279, 226832, 5, 1957},
	{42305, 226836, 1, 1872},
	{42331, 226840, 1, 1872},
	{42357, 226844, 1, 1872},
	{42383, 226848, 1, 1872},
	{42409, 226880, 4, 1962},
	{42436, 226884, 4, 1962},
	{42463, 226888, 4, 1962},
	{42490, 227072, 5, 1957},
	{42515, 227076, 4, 1951},
	{42541, 227080, 3, 2013},
	{42566, 227084, 3, 2013},
	{42591, 227088, 3, 2013},
	{42616, 227200, 5, 1957},
	{42640, 227204, 4, 1951},
	{42665, 227208, 3, 2013},
	{42689, 227212, 3, 2013},
	{42713, 227216, 3, 2013},
	{42737, 227328, 5, 1957},
	{42761, 227332, 4, 1962},
	{42786, 227336, 8, 1988},
	{195, 880, 4, 2156},
	{42808, 881},
	{26631, 882},
	{42820, 1008},
	{42831, 1009},
	{26819, 1010, 3, 2160},
	{42842, 1040, 1, 2163},
	{42855, 1041, 5, 2164},
	{42868, 1042, 1, 2169},
	{42881, 1043, 1, 1681},
	{26653, 1045, 7, 2170},
	{42894, 1168, 12, 2177},
	{42909, 1280, 6, 2189},
	{42924, 1281},
	{26590, 1282},
	{42808, 1283},
	{26631, 1284},
	{42936, 1414, 15, 2195},
};

static const struct si_reg gfx103_reg_table[] = {
	{42945, 40, 1, 2210},
	{42960, 44, 1, 2210},
	{974, 1028, 8, 0},
	{987, 1032, 20, 10},
	{1002, 1036, 10, 2211},
	{1018, 1040, 12, 40},
	{1039, 1044, 4, 52},
	{1057, 1048, 3, 56},
	{1075, 1052, 8, 2221},
	{1090, 1056},
	{1104, 1060, 1, 70},
	{1118, 1064},
	{1135, 1076, 2, 78},
	{1151, 1080},
	{1546, 1104},
	{1570, 1108},
	{1168, 1116, 5, 80},
	{1183, 1120, 6, 85},
	{1198, 1124, 2, 92},
	{1218, 1128, 1, 94},
	{1237, 1132, 4, 95},
	{1257, 1136, 5, 99},
	{42983, 1140, 1, 2229},
	{1273, 2480},
	{1287, 2484},
	{1301, 2488},
	{1315, 2492},
	{1329, 2496},
	{1343, 2500},
	{1357, 2504},
	{1371, 2508},
	{1385, 2512},
	{1399, 2516},
	{1413, 2520},
	{1428, 2524},
	{1443, 2528},
	{1458, 2532},
	{1473, 2536},
	{1488, 2540},
	{1503, 2544},
	{1514, 2552},
	{1530, 2556},
	{1618, 32776, 29, 2230},
	{1631, 32784, 20, 2259},
	{1643, 32788, 14, 154},
	{1659, 32792, 14, 154},
	{1675, 32796, 15, 168},
	{1688, 32824, 14, 154},
	{1704, 32828, 14, 154},
	{1720, 33296, 21, 183},
	{1734, 33300, 28, 204},
	{1751, 33304, 15, 232},
	{1772, 33308, 28, 247},
	{1786, 33312, 32, 275},
	{1803, 33316, 13, 307},
	{1824, 33320, 9, 320},
	{1842, 33324, 1, 329},
	{43005, 33328, 1, 2279},
	{1865, 33344, 2, 330},
	{1886, 33348},
	{1906, 33352, 1, 332},
	{1929, 33356, 9, 333},
	{1947, 33436, 1, 342},
	{1970, 36096},
	{1996, 36100, 2, 343},
	{2022, 36104},
	{2048, 36108, 2, 343},
	{2074, 36112, 2, 345},
	{2095, 36116, 4, 347},
	{2116, 36120, 6, 2280},
	{2143, 36124, 20, 2286},
	{2164, 36128, 7, 2306},
	{2187, 36132},
	{2216, 36140},
	{2246, 36144},
	{2278, 36148},
	{2309, 36152},
	{43032, 36156, 3, 2313},
	{2342, 36348, 5, 378},
	{2351, 36608},
	{2369, 36612, 4, 383},
	{2387, 36616},
	{2405, 36620, 11, 2316},
	{2423, 36656, 14, 397},
	{2441, 36660, 4, 411},
	{2459, 36664, 12, 415},
	{2477, 36668, 2, 427},
	{2495, 37168, 9, 2327},
	{2511, 39160, 6, 2336},
	{3306, 40960},
	{3324, 40964, 4, 452},
	{3342, 40968, 3, 456},
	{3360, 40972, 9, 459},
	{3378, 40976, 3, 2342},
	{3396, 40980, 8, 2345},
	{3414, 40984, 11, 2353},
	{3432, 40988},
	{3450, 45060, 1, 487},
	{3474, 45080},
	{3499, 45084, 3, 488},
	{3523, 45088},
	{3544, 45092, 1, 491},
	{3565, 45096, 12, 2364},
	{3589, 45100, 10, 503},
	{3613, 45104},
	{3639, 45108},
	{3665, 45112},
	{3691, 45116},
	{3717, 45120},
	{3743, 45124},
	{3769, 45128},
	{3795, 45132},
	{3821, 45136},
	{3847, 45140},
	{3873, 45144},
	{3900, 45148},
	{3927, 45152},
	{3954, 45156},
	{3981, 45160},
	{4008, 45164},
	{4035, 45168},
	{4062, 45172},
	{4089, 45176},
	{4116, 45180},
	{4143, 45184},
	{4170, 45188},
	{4197, 45192},
	{4224, 45196},
	{4251, 45200},
	{4278, 45204},
	{4305, 45208},
	{4332, 45212},
	{4359, 45216},
	{4386, 45220},
	{4413, 45224},
	{4440, 45228},
	{4467, 45248, 8, 513},
	{4523, 45256, 1, 526},
	{4550, 45260, 1, 526},
	{4577, 45264, 1, 526},
	{4604, 45268, 1, 526},
	{4631, 45316, 1, 487},
	{4655, 45332},
	{4680, 45336, 3, 488},
	{4704, 45340, 1, 527},
	{4729, 45344},
	{4750, 45348, 1, 491},
	{4771, 45352, 12, 528},
	{4795, 45356, 14, 540},
	{4819, 45360},
	{4845, 45364},
	{4871, 45368},
	{4897, 45372},
	{4923, 45376},
	{4949, 45380},
	{4975, 45384},
	{5001, 45388},
	{5027, 45392},
	{5053, 45396},
	{5079, 45400},
	{5106, 45404},
	{5133, 45408},
	{5160, 45412},
	{5187, 45416},
	{5214, 45420},
	{5241, 45424},
	{5268, 45428},
	{5295, 45432},
	{5322, 45436},
	{5349, 45440},
	{5376, 45444},
	{5403, 45448},
	{5430, 45452},
	{5457, 45456},
	{5484, 45460},
	{5511, 45464},
	{5538, 45468},
	{5565, 45472},
	{5592, 45476},
	{5619, 45480},
	{5646, 45484},
	{5673, 45504, 8, 513},
	{5729, 45512, 1, 526},
	{5756, 45516, 1, 526},
	{5783, 45520, 1, 526},
	{5810, 45524, 1, 526},
	{5837, 45548, 9, 554},
	{5918, 45568},
	{5943, 45572, 2, 574},
	{5967, 45576},
	{5999, 45580},
	{6031, 45584},
	{6055, 45588, 1, 491},
	{6079, 45596, 4, 576},
	{6103, 45600},
	{6124, 45604, 1, 491},
	{6145, 45608, 13, 580},
	{6169, 45612, 9, 593},
	{6193, 45616},
	{6219, 45620},
	{6245, 45624},
	{6271, 45628},
	{6297, 45632},
	{6323, 45636},
	{6349, 45640},
	{6375, 45644},
	{6401, 45648},
	{6427, 45652},
	{6453, 45656},
	{6480, 45660},
	{6507, 45664},
	{6534, 45668},
	{6561, 45672},
	{6588, 45676},
	{6615, 45680},
	{6642, 45684},
	{6669, 45688},
	{6696, 45692},
	{6723, 45696},
	{6750, 45700},
	{6777, 45704},
	{6804, 45708},
	{6831, 45712},
	{6858, 45716},
	{6885, 45720},
	{6912, 45724},
	{6939, 45728},
	{6966, 45732},
	{6993, 45736},
	{7020, 45740},
	{7047, 45760, 8, 513},
	{7107, 45768, 1, 526},
	{7136, 45772, 1, 526},
	{7165, 45776, 1, 526},
	{7194, 45780, 1, 526},
	{7274, 45856},
	{7295, 45860, 1, 491},
	{7813, 46080},
	{7838, 46084, 1, 487},
	{7862, 46088},
	{7894, 46092},
	{7926, 46096},
	{7950, 46100, 1, 491},
	{7974, 46108, 4, 612},
	{7998, 46112},
	{8019, 46116, 1, 491},
	{8040, 46120, 12, 616},
	{8064, 46124, 9, 628},
	{8088, 46128},
	{8114, 46132},
	{8140, 46136},
	{8166, 46140},
	{8192, 46144},
	{8218, 46148},
	{8244, 46152},
	{8270, 46156},
	{8296, 46160},
	{8322, 46164},
	{8348, 46168},
	{8375, 46172},
	{8402, 46176},
	{8429, 46180},
	{8456, 46184},
	{8483, 46188},
	{8510, 46192},
	{8537, 46196},
	{8564, 46200},
	{8591, 46204},
	{8618, 46208},
	{8645, 46212},
	{8672, 46216},
	{8699, 46220},
	{8726, 46224},
	{8753, 46228},
	{8780, 46232},
	{8807, 46236},
	{8834, 46240},
	{8861, 46244},
	{8888, 46248},
	{8915, 46252},
	{8942, 46272, 8, 513},
	{9002, 46280, 1, 526},
	{9031, 46284, 1, 526},
	{9060, 46288, 1, 526},
	{9089, 46292, 1, 526},
	{9169, 46368},
	{9190, 46372, 1, 491},
	{9681, 47104, 13, 646},
	{9708, 47108},
	{9722, 47112},
	{9736, 47116},
	{9750, 47120},
	{9766, 47124},
	{9782, 47128},
	{9798, 47132, 2, 659},
	{9819, 47136, 2, 659},
	{9840, 47140, 2, 659},
	{9861, 47144, 1, 661},
	{9889, 47148, 1, 662},
	{9914, 47152},
	{9929, 47156, 1, 663},
	{9944, 47160},
	{9973, 47164, 1, 663},
	{10002, 47168},
	{10035, 47172, 1, 663},
	{10068, 47176, 12, 664},
	{10086, 47180, 11, 676},
	{10104, 47184, 1, 687},
	{10117, 47188, 6, 688},
	{10141, 47192},
	{10168, 47196},
	{10195, 47200, 2, 694},
	{10216, 47204},
	{10243, 47208},
	{10270, 47212},
	{10288, 47216},
	{10306, 47220},
	{10324, 47224, 1, 696},
	{10352, 47228, 5, 697},
	{10374, 47232},
	{10394, 47236},
	{10417, 47240, 9, 702},
	{10434, 47248, 1, 526},
	{10455, 47252, 1, 526},
	{10476, 47256, 1, 526},
	{10497, 47260, 1, 526},
	{10518, 47264, 1, 711},
	{10536, 47268, 1, 712},
	{10555, 47272},
	{10577, 47276, 3, 713},
	{10594, 47280},
	{10623, 47284, 1, 716},
	{10652, 47288, 3, 713},
	{10670, 47360},
	{10690, 47364},
	{10710, 47368},
	{10730, 47372},
	{10750, 47376},
	{10770, 47380},
	{10790, 47384},
	{10810, 47388},
	{10830, 47392},
	{10850, 47396},
	{10870, 47400},
	{10891, 47404},
	{10912, 47408},
	{10933, 47412},
	{10954, 47416},
	{10975, 47420},
	{10996, 47604, 2, 717},
	{11020, 47608},
	{11041, 47612},
	{43056, 47616},
	{43073, 47620},
	{11057, 163840, 11, 2376},
	{11075, 163844, 11, 729},
	{11092, 163848, 7, 740},
	{11106, 163852, 23, 747},
	{11125, 163856, 18, 2387},
	{11145, 163860},
	{11164, 163868, 2, 786},
	{11181, 163872},
	{11201, 163876},
	{11221, 163880, 1, 788},
	{11238, 163884},
	{11253, 163888, 2, 789},
	{11277, 163892, 2, 791},
	{11301, 163896, 3, 793},
	{11317, 163900, 8, 796},
	{11335, 163904, 14, 804},
	{11345, 163908, 9, 818},
	{11361, 163912},
	{11376, 163916},
	{11397, 163920},
	{11413, 163924},
	{11435, 163928, 2, 827},
	{11453, 163932, 1, 829},
	{43090, 163940, 3, 2405},
	{11471, 163944, 1, 830},
	{11489, 163948, 1, 830},
	{11513, 163952, 1, 830},
	{11532, 163956, 1, 830},
	{11557, 163960, 1, 830},
	{11579, 163964, 13, 2408},
	{11603, 163968},
	{11619, 163972, 1, 840},
	{11638, 164328, 1, 841},
	{11659, 164332, 1, 841},
	{11680, 164336, 1, 841},
	{11701, 164340, 1, 841},
	{11722, 164344},
	{11740, 164348},
	{11758, 164352, 2, 842},
	{11778, 164356, 3, 844},
	{11802, 164360, 2, 847},
	{11826, 164364, 1, 849},
	{11846, 164368, 2, 844},
	{11866, 164372, 2, 847},
	{11886, 164376, 2, 844},
	{11906, 164380, 2, 847},
	{11926, 164384, 2, 844},
	{11946, 164388, 2, 847},
	{11966, 164392, 2, 844},
	{11986, 164396, 2, 847},
	{12006, 164400, 7, 850},
	{12021, 164404, 2, 857},
	{12050, 164408, 8, 859},
	{12065, 164412, 8, 867},
	{12080, 164416, 3, 844},
	{12105, 164420, 2, 847},
	{12130, 164424},
	{12148, 164428},
	{12166, 164432, 3, 844},
	{12191, 164436, 2, 847},
	{12216, 164440, 3, 844},
	{12241, 164444, 2, 847},
	{12266, 164448, 3, 844},
	{12291, 164452, 2, 847},
	{12316, 164456, 3, 844},
	{12341, 164460, 2, 847},
	{12366, 164464, 3, 844},
	{12391, 164468, 2, 847},
	{12416, 164472, 3, 844},
	{12441, 164476, 2, 847},
	{12466, 164480, 3, 844},
	{12491, 164484, 2, 847},
	{12516, 164488, 3, 844},
	{12541, 164492, 2, 847},
	{12566, 164496, 3, 844},
	{12591, 164500, 2, 847},
	{12616, 164504, 3, 844},
	{12641, 164508, 2, 847},
	{12666, 164512, 3, 844},
	{12692, 164516, 2, 847},
	{12718, 164520, 3, 844},
	{12744, 164524, 2, 847},
	{12770, 164528, 3, 844},
	{12796, 164532, 2, 847},
	{12822, 164536, 3, 844},
	{12848, 164540, 2, 847},
	{12874, 164544, 3, 844},
	{12900, 164548, 2, 847},
	{12926, 164552, 3, 844},
	{12952, 164556, 2, 847},
	{12978, 164560},
	{12997, 164564},
	{13016, 164568},
	{13035, 164572},
	{13054, 164576},
	{13073, 164580},
	{13092, 164584},
	{13111, 164588},
	{13130, 164592},
	{13149, 164596},
	{13168, 164600},
	{13187, 164604},
	{13206, 164608},
	{13225, 164612},
	{13244, 164616},
	{13263, 164620},
	{13282, 164624},
	{13301, 164628},
	{13320, 164632},
	{13339, 164636},
	{13358, 164640},
	{13378, 164644},
	{13398, 164648},
	{13418, 164652},
	{13438, 164656},
	{13458, 164660},
	{13478, 164664},
	{13498, 164668},
	{13518, 164672},
	{13538, 164676},
	{13558, 164680},
	{13578, 164684},
	{13598, 164688, 15, 875},
	{13618, 164692, 3, 890},
	{13640, 164696, 2, 893},
	{13668, 164700, 6, 2421},
	{13697, 164704, 1, 902},
	{13718, 164708, 1, 903},
	{13728, 164712, 1, 904},
	{43111, 164716},
	{43133, 164720},
	{13796, 164864},
	{13813, 164868},
	{13830, 164872},
	{13846, 164876},
	{13875, 164880, 14, 2427},
	{13900, 164884},
	{13913, 164888},
	{13928, 164892},
	{13942, 164896},
	{13957, 164900, 8, 923},
	{13972, 164904, 4, 931},
	{13996, 164908, 6, 935},
	{14015, 164912, 4, 941},
	{14033, 164916, 4, 945},
	{14054, 164924},
	{14073, 164928},
	{14093, 164932},
	{14112, 164936},
	{14132, 164940},
	{14151, 164944},
	{14171, 164948},
	{14192, 164952},
	{14214, 164956},
	{14235, 164960},
	{14257, 164964},
	{14278, 164968},
	{14300, 164972},
	{14321, 164976},
	{14343, 164980},
	{14364, 164984},
	{14386, 164988},
	{14407, 164992},
	{14429, 164996},
	{14450, 165000},
	{14472, 165004},
	{14493, 165008},
	{14515, 165012},
	{14536, 165016},
	{14558, 165020},
	{14579, 165024},
	{14601, 165028},
	{14622, 165032},
	{14644, 165036},
	{14665, 165040},
	{14687, 165044},
	{14708, 165048},
	{14730, 165052},
	{14751, 165056},
	{14773, 165060},
	{14794, 165064},
	{14816, 165068},
	{14837, 165072},
	{14859, 165076},
	{14880, 165080},
	{14902, 165084},
	{14923, 165088},
	{14945, 165092},
	{14966, 165096},
	{14988, 165100},
	{15009, 165104},
	{15031, 165108},
	{15052, 165112},
	{15074, 165116},
	{15095, 165120},
	{15117, 165124},
	{15138, 165128},
	{15160, 165132},
	{15181, 165136},
	{15203, 165140},
	{15224, 165144},
	{15246, 165148},
	{15267, 165152},
	{15289, 165156},
	{15310, 165160},
	{15332, 165164},
	{15354, 165168},
	{15377, 165172},
	{15399, 165176},
	{15422, 165180},
	{15444, 165184},
	{15467, 165188},
	{15489, 165192},
	{15512, 165196},
	{15534, 165200},
	{15557, 165204},
	{15579, 165208},
	{15602, 165212},
	{15624, 165216},
	{15647, 165220},
	{15669, 165224},
	{15692, 165228},
	{15714, 165232},
	{15737, 165236},
	{15759, 165240},
	{15782, 165244},
	{15804, 165248},
	{15827, 165252},
	{15849, 165256},
	{15872, 165260},
	{15894, 165264},
	{15917, 165268},
	{15939, 165272},
	{15962, 165276},
	{15984, 165280},
	{16007, 165284},
	{16029, 165288},
	{16052, 165292},
	{16074, 165296},
	{16097, 165300},
	{16119, 165304},
	{16142, 165308},
	{16156, 165312},
	{16170, 165316},
	{16184, 165320},
	{16198, 165324},
	{16212, 165328},
	{16226, 165332},
	{16240, 165336},
	{16254, 165340},
	{16268, 165344},
	{16282, 165348},
	{16296, 165352},
	{16310, 165356},
	{16324, 165360},
	{16338, 165364},
	{16352, 165368},
	{16366, 165372},
	{16380, 165376},
	{16394, 165380},
	{16408, 165384},
	{16422, 165388},
	{16436, 165392},
	{16450, 165396},
	{16464, 165400},
	{16478, 165404},
	{16501, 165444, 13, 2441},
	{16521, 165448, 13, 2441},
	{16541, 165452, 13, 2441},
	{16561, 165456, 13, 2441},
	{16581, 165460, 13, 2441},
	{16601, 165464, 13, 2441},
	{16621, 165468, 13, 2441},
	{16641, 165472, 13, 2441},
	{16661, 165476, 13, 2441},
	{16681, 165480, 13, 2441},
	{16701, 165484, 13, 2441},
	{16722, 165488, 13, 2441},
	{16743, 165492, 13, 2441},
	{16764, 165496, 13, 2441},
	{16785, 165500, 13, 2441},
	{16806, 165504, 13, 2441},
	{16827, 165508, 13, 2441},
	{16848, 165512, 13, 2441},
	{16869, 165516, 13, 2441},
	{16890, 165520, 13, 2441},
	{16911, 165524, 10, 2454},
	{16932, 165528, 10, 2454},
	{16953, 165532, 10, 2454},
	{16974, 165536, 10, 2454},
	{16995, 165540, 10, 2454},
	{17016, 165544, 10, 2454},
	{17037, 165548, 10, 2454},
	{17058, 165552, 10, 2454},
	{17079, 165556, 10, 2454},
	{17100, 165560, 10, 2454},
	{17121, 165564, 10, 2454},
	{17142, 165568, 10, 2454},
	{17163, 165572, 4, 2464},
	{17181, 165580, 16, 973},
	{17198, 165584, 16, 973},
	{17216, 165588, 7, 989},
	{17237, 165592, 6, 2468},
	{17255, 165600, 7, 1002},
	{17270, 165608, 2, 694},
	{17287, 165640, 1, 1009},
	{17309, 165644, 5, 1010},
	{17331, 165648, 1, 1015},
	{17351, 165652, 8, 1016},
	{43155, 165712, 8, 2474},
	{17373, 165716, 8, 2482},
	{17391, 165720, 8, 1032},
	{17412, 165724, 17, 1040},
	{17433, 165728, 6, 1057},
	{17451, 165732, 6, 1057},
	{17469, 165736, 6, 1057},
	{17487, 165740, 6, 1057},
	{17505, 165744, 6, 1057},
	{17523, 165748, 6, 1057},
	{17541, 165752, 6, 1057},
	{17559, 165756, 6, 1057},
	{17577, 165760, 9, 1063},
	{17595, 165764, 9, 1063},
	{17613, 165768, 9, 1063},
	{17631, 165772, 9, 1063},
	{17649, 165776, 9, 1063},
	{17667, 165780, 9, 1063},
	{17685, 165784, 9, 1063},
	{17703, 165788, 9, 1063},
	{17721, 165836, 1, 1072},
	{17735, 165840, 1, 1072},
	{17750, 165844},
	{17768, 165848},
	{17786, 165852},
	{17803, 165856},
	{17824, 165860, 1, 1073},
	{17840, 165864},
	{17853, 165872, 6, 2490},
	{17872, 165876},
	{17887, 165880, 1, 1082},
	{17909, 165884, 1, 1083},
	{17936, 165888, 10, 1084},
	{17953, 165892, 12, 1094},
	{17961, 165896, 5, 2496},
	{17978, 165900, 17, 1110},
	{17996, 165904, 20, 1127},
	{18012, 165908, 16, 1147},
	{18031, 165912, 10, 1163},
	{18046, 165916, 30, 2501},
	{18064, 165920, 16, 1201},
	{18082, 165924, 4, 1217},
	{18106, 165928},
	{18131, 165932, 11, 1221},
	{18154, 165936, 5, 1232},
	{18205, 165944, 3, 2531},
	{18220, 165948, 5, 1243},
	{18250, 165952, 5, 1248},
	{18265, 165956},
	{43181, 165960, 6, 2534},
	{18283, 166400, 2, 1253},
	{18300, 166404, 2, 1255},
	{18319, 166408, 1, 1257},
	{18335, 166412, 4, 1258},
	{18354, 166416, 1, 1262},
	{18375, 166420, 1, 1263},
	{18388, 166424},
	{18411, 166428},
	{18434, 166432, 1, 1264},
	{18454, 166436, 4, 1265},
	{18474, 166440, 1, 1269},
	{18495, 166444, 1, 1270},
	{18510, 166448, 6, 1271},
	{18532, 166452, 6, 1271},
	{18554, 166456, 8, 1277},
	{18580, 166460, 8, 1277},
	{18606, 166464, 15, 1285},
	{18618, 166468, 3, 1300},
	{18637, 166472, 6, 2540},
	{18655, 166476, 24, 1310},
	{18673, 166480},
	{18685, 166484, 1, 1334},
	{18699, 166488, 1, 1335},
	{18713, 166492, 1, 1336},
	{18727, 166496, 1, 1337},
	{18750, 166500, 1, 1337},
	{18773, 166504, 1, 1337},
	{18796, 166508, 5, 1338},
	{18817, 166512},
	{18828, 166516},
	{18841, 166520},
	{18858, 166524, 9, 2546},
	{18877, 166528},
	{18888, 166532, 3, 1351},
	{18907, 166536},
	{18929, 166540},
	{18951, 166544, 3, 1354},
	{18971, 166548, 2, 1357},
	{18998, 166552, 4, 2555},
	{19020, 166560},
	{19045, 166564},
	{19070, 166568, 6, 1364},
	{19089, 166572, 1, 1370},
	{19112, 166576, 1, 1370},
	{19135, 166580, 1, 1371},
	{19149, 166584, 1, 1372},
	{19164, 166588, 10, 2559},
	{19181, 166592, 4, 1382},
	{19208, 166596, 4, 1386},
	{19235, 166600, 4, 1390},
	{19254, 166608},
	{19280, 166612, 1, 1394},
	{19305, 166620},
	{19333, 166624},
	{19359, 166628, 1, 1394},
	{19384, 166636},
	{19412, 166640},
	{19438, 166644, 1, 1394},
	{19463, 166652},
	{19491, 166656},
	{19517, 166660, 1, 1394},
	{19542, 166668},
	{19570, 166696},
	{19601, 166700},
	{19644, 166704, 1, 1395},
	{19682, 166712, 1, 1396},
	{19702, 166732, 2, 1397},
	{19721, 166736, 5, 1399},
	{19743, 166740, 20, 2569},
	{19764, 166744, 3, 1423},
	{19781, 166748, 1, 1370},
	{19802, 166752, 1, 1370},
	{19825, 166756, 1, 1370},
	{19848, 166760, 1, 1370},
	{19871, 166764, 12, 1426},
	{19884, 166768, 6, 1438},
	{19901, 166772},
	{19925, 166776, 2, 1444},
	{19955, 166780},
	{19979, 166784},
	{20009, 166788},
	{20040, 166792},
	{20069, 166796},
	{20099, 166800, 3, 1446},
	{20119, 166804, 8, 1449},
	{20138, 166808, 4, 1457},
	{20164, 166812, 3, 1354},
	{20188, 166868, 8, 1461},
	{20214, 166872, 8, 1469},
	{20240, 166876, 5, 1477},
	{20256, 166880, 8, 2589},
	{20272, 166884, 3, 1488},
	{20287, 166888},
	{20310, 166892},
	{20333, 166896},
	{20356, 166900},
	{20379, 166904, 8, 1491},
	{20413, 166908, 8, 1499},
	{20447, 166912, 8, 1507},
	{20481, 166916, 8, 1515},
	{20515, 166920, 8, 1491},
	{20549, 166924, 8, 1499},
	{20583, 166928, 8, 1507},
	{20617, 166932, 8, 1515},
	{20651, 166936, 8, 1491},
	{20685, 166940, 8, 1499},
	{20719, 166944, 8, 1507},
	{20753, 166948, 8, 1515},
	{20787, 166952, 8, 1491},
	{20821, 166956, 8, 1499},
	{20855, 166960, 8, 1507},
	{20889, 166964, 8, 1515},
	{20923, 166968, 2, 1523},
	{20947, 166972, 2, 1525},
	{20971, 166976, 4, 1527},
	{20992, 166980, 12, 1531},
	{21012, 166984, 2, 1543},
	{21032, 166988, 20, 1545},
	{21070, 166992, 2, 1565},
	{21090, 167000, 1, 1567},
	{21118, 167004, 1, 1568},
	{21139, 167008},
	{21154, 167012, 2, 1569},
	{21170, 167016, 1, 1571},
	{21186, 167020, 3, 1572},
	{21201, 167024, 19, 2597},
	{21216, 167028, 8, 1594},
	{21233, 167032, 14, 2616},
	{21255, 167036},
	{21271, 167040, 1, 1614},
	{21293, 167044},
	{21309, 167048, 1, 1571},
	{21331, 167052},
	{21353, 167056},
	{21375, 167060},
	{21394, 167068},
	{21409, 167072, 2, 1569},
	{21425, 167076, 1, 1571},
	{21441, 167080, 3, 1572},
	{21456, 167084, 19, 2597},
	{21471, 167088, 8, 1594},
	{21488, 167092, 14, 2616},
	{21510, 167096},
	{21526, 167100, 1, 1614},
	{21548, 167104},
	{21564, 167108, 1, 1571},
	{21586, 167112},
	{21608, 167116},
	{21630, 167120},
	{21649, 167128},
	{21664, 167132, 2, 1569},
	{21680, 167136, 1, 1571},
	{21696, 167140, 3, 1572},
	{21711, 167144, 19, 2597},
	{21726, 167148, 8, 1594},
	{21743, 167152, 14, 2616},
	{21765, 167156},
	{21781, 167160, 1, 1614},
	{21803, 167164},
	{21819, 167168, 1, 1571},
	{21841, 167172},
	{21863, 167176},
	{21885, 167180},
	{21904, 167188},
	{21919, 167192, 2, 1569},
	{21935, 167196, 1, 1571},
	{21951, 167200, 3, 1572},
	{21966, 167204, 19, 2597},
	{21981, 167208, 8, 1594},
	{21998, 167212, 14, 2616},
	{22020, 167216},
	{22036, 167220, 1, 1614},
	{22058, 167224},
	{22074, 167228, 1, 1571},
	{22096, 167232},
	{22118, 167236},
	{22140, 167240},
	{22159, 167248},
	{22174, 167252, 2, 1569},
	{22190, 167256, 1, 1571},
	{22206, 167260, 3, 1572},
	{22221, 167264, 19, 2597},
	{22236, 167268, 8, 1594},
	{22253, 167272, 14, 2616},
	{22275, 167276},
	{22291, 167280, 1, 1614},
	{22313, 167284},
	{22329, 167288, 1, 1571},
	{22351, 167292},
	{22373, 167296},
	{22395, 167300},
	{22414, 167308},
	{22429, 167312, 2, 1569},
	{22445, 167316, 1, 1571},
	{22461, 167320, 3, 1572},
	{22476, 167324, 19, 2597},
	{22491, 167328, 8, 1594},
	{22508, 167332, 14, 2616},
	{22530, 167336},
	{22546, 167340, 1, 1614},
	{22568, 167344},
	{22584, 167348, 1, 1571},
	{22606, 167352},
	{22628, 167356},
	{22650, 167360},
	{22669, 167368},
	{22684, 167372, 2, 1569},
	{22700, 167376, 1, 1571},
	{22716, 167380, 3, 1572},
	{22731, 167384, 19, 2597},
	{22746, 167388, 8, 1594},
	{22763, 167392, 14, 2616},
	{22785, 167396},
	{22801, 167400, 1, 1614},
	{22823, 167404},
	{22839, 167408, 1, 1571},
	{22861, 167412},
	{22883, 167416},
	{22905, 167420},
	{22924, 167428},
	{22939, 167432, 2, 1569},
	{22955, 167436, 1, 1571},
	{22971, 167440, 3, 1572},
	{22986, 167444, 19, 2597},
	{23001, 167448, 8, 1594},
	{23018, 167452, 14, 2616},
	{23040, 167456},
	{23056, 167460, 1, 1614},
	{23078, 167464},
	{23094, 167468, 1, 1571},
	{23116, 167472},
	{23138, 167476},
	{23160, 167480},
	{23179, 167488, 1, 1615},
	{23198, 167492, 1, 1615},
	{23217, 167496, 1, 1615},
	{23236, 167500, 1, 1615},
	{23255, 167504, 1, 1615},
	{23274, 167508, 1, 1615},
	{23293, 167512, 1, 1615},
	{23312, 167516, 1, 1615},
	{23331, 167520, 1, 1615},
	{23356, 167524, 1, 1615},
	{23381, 167528, 1, 1615},
	{23406, 167532, 1, 1615},
	{23431, 167536, 1, 1615},
	{23456, 167540, 1, 1615},
	{23481, 167544, 1, 1615},
	{23506, 167548, 1, 1615},
	{23531, 167552, 1, 1615},
	{23556, 167556, 1, 1615},
	{23581, 167560, 1, 1615},
	{23606, 167564, 1, 1615},
	{23631, 167568, 1, 1615},
	{23656, 167572, 1, 1615},
	{23681, 167576, 1, 1615},
	{23706, 167580, 1, 1615},
	{23731, 167584, 1, 1615},
	{23754, 167588, 1, 1615},
	{23777, 167592, 1, 1615},
	{23800, 167596, 1, 1615},
	{23823, 167600, 1, 1615},
	{23846, 167604, 1, 1615},
	{23869, 167608, 1, 1615},
	{23892, 167612, 1, 1615},
	{23915, 167616, 3, 1616},
	{23933, 167620, 3, 1616},
	{23951, 167624, 3, 1616},
	{23969, 167628, 3, 1616},
	{23987, 167632, 3, 1616},
	{24005, 167636, 3, 1616},
	{24023, 167640, 3, 1616},
	{24041, 167644, 3, 1616},
	{24059, 167648, 9, 2630},
	{24077, 167652, 9, 2630},
	{24095, 167656, 9, 2630},
	{24113, 167660, 9, 2630},
	{24131, 167664, 9, 2630},
	{24149, 167668, 9, 2630},
	{24167, 167672, 9, 2630},
	{24185, 167676, 9, 2630},
	{24203, 196608, 1, 1627},
	{24223, 196612, 1, 1628},
	{24243, 196616},
	{24263, 196620},
	{24283, 196624},
	{24304, 196628},
	{24325, 196632, 1, 1629},
	{24347, 196636, 1, 1630},
	{24369, 196640},
	{24399, 196644},
	{24429, 196648},
	{24458, 196652},
	{24487, 196656},
	{24517, 196660},
	{24547, 196664},
	{24576, 196668},
	{24605, 196672},
	{24635, 196676},
	{24665, 196680},
	{24694, 196684},
	{24723, 196688},
	{24753, 196692},
	{24783, 196696},
	{24812, 196700},
	{24841, 196704, 1, 1631},
	{24863, 196708, 1, 1632},
	{24885, 196712},
	{24908, 196716},
	{24931, 196720},
	{24954, 196724},
	{24977, 196728},
	{25000, 196732},
	{25023, 196736},
	{25047, 196740},
	{25071, 196744},
	{25095, 196748},
	{25119, 196752},
	{25143, 196756},
	{25167, 196760},
	{25191, 196764},
	{25215, 196768},
	{25237, 196772},
	{25259, 196776},
	{25280, 196780},
	{25301, 196784},
	{25325, 196788},
	{25349, 196792},
	{25373, 196796},
	{25397, 196800},
	{25421, 196804},
	{25505, 196852, 1, 1634},
	{25527, 196856, 1, 1634},
	{25549, 196860, 1, 1635},
	{25565, 196864},
	{25578, 196868},
	{25591, 196872},
	{25604, 196876},
	{25617, 196880},
	{25630, 196884},
	{25643, 196888},
	{25656, 196892},
	{43196, 196896, 5, 2639},
	{25692, 196908, 1, 663},
	{25711, 196912},
	{25729, 196916},
	{25756, 196920},
	{25783, 196928, 2, 1636},
	{25796, 196932},
	{25809, 196936},
	{25832, 196940},
	{25855, 196944},
	{25883, 196948},
	{25911, 196952},
	{25939, 196956},
	{25967, 196960, 1, 1638},
	{25985, 196964, 4, 1639},
	{26003, 196968},
	{26018, 196972},
	{26042, 196976},
	{26066, 196980},
	{26085, 196984},
	{26104, 196988},
	{26128, 196992},
	{26152, 196996},
	{26176, 197000},
	{26200, 197028, 1, 1643},
	{26218, 197032, 2, 1644},
	{26236, 197036},
	{26254, 197040},
	{26272, 197044, 1, 1646},
	{26290, 197048, 2, 1647},
	{26308, 197052},
	{26326, 197056, 2, 2644},
	{26345, 197060, 5, 1651},
	{26364, 197072},
	{26388, 197076, 2, 2644},
	{26408, 197080, 5, 1651},
	{26428, 197084, 7, 1656},
	{26447, 197088, 7, 1656},
	{26465, 197092, 1, 1663},
	{26482, 197100, 1, 1664},
	{26503, 197104, 13, 1665},
	{26517, 197108},
	{26531, 197112},
	{26545, 197116, 2, 1678},
	{26561, 197120},
	{26580, 197124, 1, 1680},
	{26602, 197128},
	{26621, 197132, 1, 1681},
	{26643, 197136, 7, 1682},
	{26661, 197140},
	{26681, 197144, 1, 1680},
	{26704, 197148},
	{26724, 197152, 1, 1681},
	{26747, 197156, 7, 1682},
	{26766, 197160, 7, 1689},
	{26778, 197164, 2, 1696},
	{26795, 197168, 1, 1698},
	{26812, 197172, 1, 1699},
	{26830, 197176, 5, 2646},
	{26850, 197180, 2, 330},
	{26867, 197184},
	{26883, 197188, 1, 1706},
	{26910, 197196, 1, 1708},
	{26966, 197208, 1, 1711},
	{26988, 197212, 1, 1712},
	{27008, 197216, 1, 1707},
	{27025, 197220, 1, 1708},
	{27042, 197224},
	{27056, 197232, 2, 1713},
	{27078, 197236, 2, 1715},
	{27100, 197240, 2, 1713},
	{27123, 197244, 2, 1715},
	{27146, 197248, 2, 1713},
	{27168, 197252, 2, 1715},
	{43215, 197256},
	{43237, 197260},
	{43259, 197280},
	{43281, 197284},
	{43303, 197288},
	{43330, 197292},
	{43357, 197296},
	{43384, 197300},
	{27190, 197364, 1, 1717},
	{27211, 197368, 1, 1718},
	{27231, 197372, 1, 1719},
	{27268, 197380, 1, 1719},
	{27285, 197384, 1, 1720},
	{27301, 197388, 1, 1721},
	{27320, 197392, 1, 1722},
	{27339, 197396, 1, 1723},
	{27356, 197400, 1, 1724},
	{27374, 197404, 1, 1725},
	{27392, 197408, 1, 1726},
	{27408, 197412, 1, 1727},
	{27426, 197416, 1, 1728},
	{27444, 197420, 1, 1729},
	{27460, 197424, 1, 1724},
	{27475, 197428, 1, 1725},
	{27490, 197432, 1, 1726},
	{27503, 197436, 1, 1727},
	{27518, 197440, 1, 1728},
	{27533, 197444, 1, 1729},
	{27546, 197448, 1, 1730},
	{27560, 197452, 1, 1731},
	{27574, 197456, 1, 1732},
	{27586, 197460, 4, 1733},
	{27609, 197464, 5, 2651},
	{27631, 197468, 1, 1740},
	{27651, 197472, 1, 1741},
	{27665, 197476, 1, 1742},
	{27679, 197480, 1, 1743},
	{27691, 197484, 1, 1744},
	{27707, 197488, 1, 1741},
	{27724, 197492, 1, 1742},
	{27741, 197496, 1, 1743},
	{27756, 197500, 1, 1744},
	{27775, 197552, 1, 1745},
	{27800, 197556, 1, 1745},
	{27824, 197560, 1, 1746},
	{27844, 197568},
	{27870, 197572, 1, 1628},
	{27899, 197576},
	{27924, 197580, 1, 1628},
	{27952, 197584},
	{27975, 197588, 1, 1628},
	{28001, 197592},
	{28023, 197596, 1, 1628},
	{28048, 197600},
	{28067, 197604, 1, 1628},
	{28089, 197608, 1, 1343},
	{28103, 197612},
	{28120, 197616, 1, 1628},
	{28140, 197620, 8, 1747},
	{28157, 197624, 13, 1755},
	{28174, 197628},
	{28191, 197632, 1, 1698},
	{28211, 197636},
	{28228, 197640, 1, 1663},
	{28248, 197644, 2, 1768},
	{28267, 197888, 8, 1770},
	{28288, 197892, 8, 1770},
	{28309, 198656, 6, 1778},
	{28324, 198912},
	{28347, 198916},
	{28370, 198920, 1, 1784},
	{28389, 198924, 2, 2656},
	{28404, 198928},
	{28437, 198932},
	{28470, 198936},
	{28503, 198940},
	{28536, 198948},
	{28552, 198952},
	{28567, 198956, 2, 1357},
	{28593, 198960},
	{28609, 198964},
	{28627, 198968, 1, 1785},
	{28648, 198972, 2, 2658},
	{28673, 198976},
	{28696, 198980},
	{28715, 198984},
	{28731, 198988, 1, 830},
	{28750, 198992},
	{28770, 198996, 1, 830},
	{28793, 199000},
	{28811, 199004, 1, 830},
	{28832, 199008, 9, 1788},
	{28857, 199012},
	{28873, 199016},
	{28894, 199020, 4, 1797},
	{28902, 199024},
	{28916, 199028},
	{28930, 199032},
	{28944, 199036, 3, 1801},
	{28959, 199040, 2, 1804},
	{28971, 199044, 1, 830},
	{28997, 199048, 3, 1806},
	{43411, 199052, 2, 2660},
	{29013, 199168, 1, 1809},
	{29038, 199172, 2, 1810},
	{29063, 199184, 2, 1812},
	{29089, 199188, 2, 1812},
	{29115, 199192, 2, 1812},
	{29141, 199212, 2, 1812},
	{29167, 199296, 2, 1814},
	{29195, 199300, 1, 1816},
	{29219, 199304, 1, 1817},
	{29243, 199308, 1, 1818},
	{29276, 199312, 1, 1818},
	{29304, 199328, 2, 1814},
	{29333, 199332, 1, 1816},
	{29358, 199336, 1, 1817},
	{29383, 199340, 1, 1818},
	{29417, 199344, 1, 1818},
	{29446, 199360, 2, 1814},
	{29470, 199364, 1, 1816},
	{29490, 199368, 1, 1817},
	{29510, 199372, 1, 1818},
	{29539, 199376, 1, 1818},
	{29563, 199936},
	{29590, 199940},
	{29617, 199944},
	{29644, 199948},
	{29671, 199952},
	{29698, 199956},
	{29725, 199960},
	{29752, 199964},
	{29779, 199968, 5, 2662},
	{29804, 200192},
	{29823, 200196, 1, 840},
	{29845, 200448},
	{29869, 200452, 1, 1828},
	{29892, 200456},
	{29916, 200460, 1, 1828},
	{29939, 200464},
	{29963, 200468, 1, 1828},
	{29986, 200472},
	{30010, 200476, 1, 1828},
	{30033, 200696},
	{30052, 200700, 1, 1828},
	{30070, 200704},
	{30082, 200708},
	{30094, 200712},
	{30112, 200716},
	{30131, 200720},
	{30149, 200724},
	{30161, 200728},
	{30173, 200732},
	{30191, 200736},
	{30209, 200740},
	{30228, 200744, 4, 1829},
	{30242, 200748, 2, 1833},
	{30260, 200752, 2, 1835},
	{30274, 200756, 2, 1837},
	{30288, 200760, 2, 1839},
	{30305, 200764, 2, 1841},
	{30322, 200768},
	{30335, 200772, 2, 1843},
	{30347, 200776},
	{30361, 200780},
	{30377, 200784},
	{30391, 200788},
	{30407, 200792},
	{30422, 200796},
	{30439, 200800},
	{30454, 200804},
	{30471, 200808, 2, 1845},
	{30493, 200812, 11, 2667},
	{30510, 200816, 2, 1857},
	{30531, 200820, 2, 1859},
	{30543, 200824},
	{30558, 200828, 6, 1861},
	{30573, 200832, 2, 1867},
	{30587, 200836},
	{30604, 200960},
	{30626, 200964},
	{30650, 200968},
	{30674, 200972},
	{30700, 212992},
	{30720, 212996},
	{30740, 213000},
	{30760, 213004},
	{30780, 213008},
	{30800, 213012},
	{30820, 213016},
	{30840, 213020},
	{30860, 213024},
	{30880, 213028},
	{30900, 213032},
	{30920, 213036},
	{30940, 213040},
	{30963, 213044},
	{30986, 213048},
	{31009, 213248},
	{31030, 213252},
	{31051, 213260},
	{31072, 213264},
	{31093, 213268},
	{31117, 213272},
	{31141, 213276},
	{31165, 213280},
	{31189, 213284},
	{31213, 213288},
	{31237, 213292},
	{31261, 213296},
	{43423, 213648},
	{43443, 213652},
	{43463, 213656},
	{43483, 213660},
	{43503, 213664},
	{43523, 213668},
	{43543, 213672},
	{43563, 213676},
	{43583, 213680},
	{43608, 213684},
	{43633, 213688},
	{43658, 213692},
	{43683, 213696},
	{43708, 213700},
	{43733, 213704},
	{43758, 213708},
	{43783, 213712},
	{43806, 213716},
	{43829, 213720},
	{43852, 213724},
	{43875, 213728},
	{43898, 213732},
	{43921, 213736},
	{43944, 213740},
	{31745, 214016},
	{31767, 214020, 1, 1869},
	{31789, 214024},
	{31811, 214028, 1, 1869},
	{31833, 214032},
	{31855, 214036, 1, 1869},
	{31877, 214040},
	{31899, 214044, 1, 1869},
	{31921, 214272},
	{31943, 214276},
	{31965, 214280},
	{31987, 214284},
	{32009, 214288},
	{32031, 214292},
	{32053, 214296},
	{32075, 214300},
	{32097, 214304},
	{32119, 214308},
	{32141, 214312},
	{32163, 214316},
	{32185, 214320},
	{32207, 214324},
	{32229, 214328},
	{32251, 214332},
	{32273, 214528},
	{32293, 214532},
	{32313, 214536},
	{32333, 214540},
	{32353, 214544},
	{32373, 214548},
	{32393, 214552},
	{32413, 214556},
	{32433, 214560},
	{32453, 214564},
	{32473, 214568},
	{32493, 214572},
	{32513, 214784},
	{32532, 214788},
	{32551, 214792},
	{32570, 214796},
	{32589, 214800},
	{32608, 214804},
	{32627, 214808},
	{32646, 214812},
	{32665, 214816},
	{32684, 214820},
	{32703, 214824},
	{32722, 214828},
	{32741, 214832},
	{32760, 214836},
	{32779, 214840},
	{32798, 214844},
	{32817, 214848},
	{32836, 214852},
	{32855, 214856},
	{32874, 214860},
	{32893, 214864},
	{32913, 214868},
	{32933, 214872},
	{32953, 214876},
	{32973, 214880},
	{32993, 214884},
	{33013, 214888},
	{33033, 214892},
	{33053, 214896},
	{33073, 214900},
	{33093, 214904},
	{33113, 214908},
	{33133, 215296},
	{33152, 215300},
	{33171, 215304},
	{33190, 215308},
	{33209, 215312},
	{33228, 215316},
	{33247, 215320},
	{33266, 215324},
	{33285, 215424},
	{33306, 215428},
	{43967, 215432},
	{43987, 215436, 2, 1870},
	{33327, 215552},
	{33347, 215556},
	{33367, 215560},
	{33387, 215564},
	{33407, 215568},
	{33427, 215572},
	{33447, 215576},
	{33467, 215580},
	{33487, 215808},
	{33506, 215812},
	{33525, 215816},
	{33544, 215820},
	{33563, 216064},
	{33582, 216068},
	{33601, 216072},
	{33620, 216076},
	{33639, 216320},
	{33659, 216324},
	{33679, 216328},
	{33699, 216332},
	{33719, 216336},
	{33739, 216340},
	{33759, 216344},
	{33779, 216348},
	{33799, 216576},
	{33820, 216580},
	{33841, 216584},
	{33862, 216588},
	{33883, 216592},
	{33904, 216596},
	{33925, 216600},
	{33946, 216604},
	{33967, 216640},
	{33988, 216644},
	{34009, 216648},
	{34030, 216652},
	{34051, 216656},
	{34072, 216660},
	{34093, 216664},
	{34114, 216668},
	{34135, 216704},
	{34156, 216708},
	{34177, 216712},
	{34198, 216716},
	{34219, 216720},
	{34240, 216724},
	{34261, 216728},
	{34282, 216732},
	{34303, 216832},
	{34323, 216836},
	{34343, 216840},
	{34363, 216844},
	{34383, 216848},
	{34403, 216852},
	{34423, 216856},
	{34443, 216860},
	{34463, 216864},
	{34484, 216868},
	{34505, 216872},
	{34526, 216876},
	{34547, 216880},
	{34568, 216884},
	{34589, 216888},
	{34610, 216892},
	{34631, 217112},
	{34650, 217116},
	{34669, 217120},
	{34688, 217124},
	{34707, 217128},
	{34726, 217132},
	{34745, 217136},
	{34764, 217140},
	{34783, 217344},
	{34802, 217348},
	{34821, 217352},
	{34840, 217356},
	{34859, 217360},
	{34878, 217364},
	{34897, 217368},
	{34916, 217372},
	{34935, 217600},
	{34955, 217604},
	{34975, 217608},
	{34995, 217612},
	{35015, 217856},
	{35035, 217860},
	{35055, 217864},
	{35075, 217868},
	{35095, 217872},
	{35115, 217876},
	{35135, 217880},
	{35155, 217884},
	{35225, 218016},
	{35251, 218020, 2, 1870},
	{44007, 218024},
	{44030, 218028, 2, 1870},
	{35277, 218080},
	{35302, 218084},
	{35327, 218088},
	{35352, 218092},
	{35429, 218224},
	{35451, 218228},
	{35473, 218232},
	{35495, 218236},
	{35517, 218240},
	{35537, 218244},
	{35557, 218248},
	{35577, 218252},
	{35597, 218624},
	{35619, 218628},
	{35641, 218632},
	{35663, 218636},
	{35685, 218640},
	{35707, 218644},
	{35729, 218648},
	{35751, 218652},
	{35773, 218656},
	{35795, 218660},
	{35817, 218664},
	{35839, 218668},
	{35861, 218672},
	{35883, 218676},
	{35905, 218680},
	{35927, 218684},
	{35949, 218880},
	{35970, 218884},
	{35991, 218888},
	{36012, 218892},
	{36033, 218896},
	{36054, 218900},
	{36075, 218904},
	{36096, 218908},
	{36117, 219136},
	{36137, 219140},
	{36157, 219144},
	{36177, 219148},
	{36197, 219152},
	{36217, 219156},
	{36237, 219160},
	{36257, 219164},
	{36277, 219392},
	{36297, 219396},
	{44053, 219400},
	{44072, 219404, 2, 1870},
	{44091, 219520},
	{44120, 219524, 2, 1870},
	{44149, 219528},
	{44171, 219532},
	{44193, 219536},
	{44215, 219540},
	{44237, 219568},
	{44266, 219572, 2, 1870},
	{44295, 219576},
	{44317, 219580},
	{44339, 219584},
	{44361, 219588},
	{44383, 219616},
	{44412, 219620, 2, 1870},
	{44441, 219624},
	{44463, 219628},
	{44485, 219632},
	{44507, 219636},
	{44529, 219664},
	{44558, 219668, 2, 1870},
	{44587, 219672},
	{44609, 219676},
	{44631, 219680},
	{44653, 219684},
	{36317, 221184, 5, 1872},
	{36341, 221188, 4, 1877},
	{36366, 221192, 5, 1872},
	{36390, 221196, 5, 1872},
	{36414, 221200, 4, 1877},
	{36439, 221204, 5, 1872},
	{36463, 221208, 4, 1877},
	{36488, 221212, 5, 1872},
	{36512, 221216, 4, 1881},
	{36528, 221220, 5, 1872},
	{36552, 221224, 3, 1885},
	{36586, 221228, 3, 1888},
	{36620, 221232, 3, 1891},
	{36645, 221236, 3, 1894},
	{36670, 221240, 3, 1891},
	{36695, 221248},
	{36710, 221252, 1, 1818},
	{36733, 221256},
	{36756, 221260},
	{36774, 221264, 2, 1897},
	{36792, 221268, 4, 1899},
	{36812, 221440, 20, 1903},
	{36837, 221444, 20, 1903},
	{36862, 221448, 15, 1923},
	{36890, 221452, 15, 1923},
	{36918, 221456, 15, 1923},
	{36946, 221460, 15, 1923},
	{36974, 221492, 8, 1938},
	{37002, 221496, 8, 1938},
	{44675, 221840, 5, 1946},
	{44699, 221844, 4, 1951},
	{44724, 221848, 5, 1946},
	{44748, 221852, 4, 1951},
	{44773, 221856, 5, 1946},
	{44797, 221860, 4, 1951},
	{44822, 221864, 5, 1946},
	{44846, 221868, 4, 1951},
	{44871, 221872, 5, 1946},
	{44900, 221876, 4, 1951},
	{44930, 221880, 5, 1946},
	{44959, 221884, 4, 1951},
	{44989, 221888, 5, 1946},
	{45018, 221892, 4, 1951},
	{45048, 221896, 5, 1946},
	{45077, 221900, 4, 1951},
	{45107, 221904, 5, 1946},
	{45134, 221908, 4, 1951},
	{45162, 221912, 5, 1946},
	{45189, 221916, 4, 1951},
	{45217, 221920, 5, 1946},
	{45244, 221924, 4, 1951},
	{45272, 221928, 5, 1946},
	{45299, 221932, 4, 1951},
	{37404, 222208, 5, 1957},
	{37430, 222212, 4, 1962},
	{37457, 222216, 5, 1957},
	{37483, 222220, 4, 1962},
	{37510, 222224, 5, 1957},
	{37536, 222228, 4, 1962},
	{37563, 222232, 5, 1957},
	{37589, 222236, 4, 1962},
	{37616, 222464, 5, 1957},
	{37642, 222468, 4, 1962},
	{37669, 222472, 1, 1872},
	{37695, 222476, 1, 1872},
	{37721, 222480, 1, 1872},
	{37747, 222484, 1, 1872},
	{37773, 222488, 1, 1872},
	{37799, 222492, 1, 1872},
	{37825, 222496, 1, 1872},
	{37851, 222720, 5, 1957},
	{37875, 222724, 5, 1957},
	{37899, 222728, 5, 1957},
	{37923, 222732, 5, 1957},
	{37947, 222736, 4, 1962},
	{37972, 222740, 4, 1962},
	{37997, 222744, 4, 1962},
	{38022, 222748, 4, 1962},
	{38047, 222752, 1, 1872},
	{38071, 222756, 1, 1872},
	{38095, 222760, 8, 1966},
	{38116, 222976, 3, 2678},
	{38139, 222980, 3, 2678},
	{38162, 222984, 3, 2678},
	{38185, 222988, 3, 2678},
	{38208, 222992, 3, 2678},
	{38231, 222996, 3, 2678},
	{38254, 223000, 3, 2678},
	{38277, 223004, 3, 2678},
	{38300, 223008, 3, 2678},
	{38323, 223012, 3, 2678},
	{38346, 223016, 3, 2678},
	{38370, 223020, 3, 2678},
	{38394, 223024, 3, 2678},
	{38418, 223028, 3, 2678},
	{38442, 223032, 3, 2678},
	{38466, 223036, 3, 2678},
	{38490, 223104, 15, 2681},
	{38510, 223112, 1, 1987},
	{38531, 223232, 5, 1957},
	{38556, 223236, 4, 1962},
	{38582, 223240, 8, 1988},
	{45327, 223244, 5, 2140},
	{45349, 223248, 5, 2140},
	{45371, 223252, 6, 2145},
	{38605, 223488, 5, 1957},
	{38628, 223492, 5, 1957},
	{38651, 223496, 3, 2013},
	{38674, 223500, 3, 2013},
	{38697, 223504, 4, 1962},
	{38721, 223508, 4, 1962},
	{38745, 223744, 5, 1957},
	{38769, 223748, 5, 1957},
	{38793, 223752, 5, 1957},
	{38817, 223756, 5, 1957},
	{38841, 223760, 4, 1962},
	{45398, 223764, 4, 1962},
	{45423, 223768, 4, 1962},
	{45448, 223772, 4, 1962},
	{38866, 224000, 5, 1957},
	{38889, 224004, 4, 1962},
	{38913, 224008, 3, 2013},
	{38936, 224256, 5, 1957},
	{38959, 224260, 4, 1962},
	{38983, 224264, 3, 2013},
	{39006, 224512, 5, 1957},
	{39030, 224516, 4, 1962},
	{39055, 224520, 5, 1957},
	{39079, 224524, 4, 1962},
	{39104, 224528, 3, 2013},
	{39128, 224532, 3, 2013},
	{39152, 224768, 5, 1957},
	{39177, 224772, 4, 1951},
	{39203, 224776, 5, 1957},
	{39228, 224780, 4, 1951},
	{39254, 224784, 3, 2013},
	{39279, 224788, 3, 2013},
	{39304, 224832, 5, 1957},
	{39329, 224836, 4, 1951},
	{39355, 224840, 5, 1957},
	{39380, 224844, 4, 1951},
	{39406, 224848, 3, 2013},
	{39431, 224852, 3, 2013},
	{39456, 224896, 5, 1957},
	{39481, 224900, 4, 1951},
	{39507, 224904, 3, 2013},
	{39532, 224908, 3, 2013},
	{39557, 224912, 3, 2013},
	{39582, 225024, 5, 1957},
	{39606, 225028, 4, 1951},
	{39631, 225032, 3, 2013},
	{39655, 225036, 3, 2013},
	{39679, 225040, 3, 2013},
	{39703, 225048, 5, 1957},
	{39728, 225052, 4, 1951},
	{39754, 225056, 3, 2013},
	{39779, 225060, 3, 2013},
	{39804, 225064, 3, 2013},
	{39829, 225280, 12, 2016},
	{39851, 225284, 5, 2028},
	{39874, 225288, 4, 2033},
	{39898, 225292, 2, 2037},
	{39921, 225296, 2, 2037},
	{39944, 225300, 2, 2037},
	{39967, 225536, 5, 1957},
	{39990, 225540, 4, 1962},
	{40014, 225544, 5, 1957},
	{40037, 225548, 4, 1962},
	{40061, 225552, 5, 1957},
	{40084, 225560, 5, 1957},
	{40107, 225792, 4, 2039},
	{40128, 225796},
	{40157, 225800, 2, 2043},
	{40186, 225804},
	{40212, 225808, 7, 2045},
	{40241, 225812},
	{40260, 225816, 2, 2052},
	{40286, 225820, 2, 2054},
	{40309, 225824},
	{40332, 225828, 2, 2056},
	{40359, 225832},
	{40386, 225836, 2, 2058},
	{40411, 225840, 2, 2060},
	{40439, 225844, 2, 2062},
	{40467, 225848, 2, 2064},
	{40490, 225852, 2, 2066},
	{40513, 225856},
	{40546, 225860, 2, 2068},
	{40579, 225864},
	{40611, 225868, 2, 2068},
	{40643, 225872, 2, 2070},
	{40662, 225876, 2, 2072},
	{40689, 225880},
	{40716, 225884, 2, 2696},
	{40743, 225888, 2, 2076},
	{40770, 225892, 17, 2698},
	{40791, 225896, 9, 2715},
	{40810, 225900, 19, 2724},
	{40829, 225904, 1, 2104},
	{40853, 225908, 1, 2106},
	{40885, 225912, 2, 2108},
	{40915, 225916, 4, 2110},
	{40951, 225920, 3, 2114},
	{40984, 225924, 1, 2117},
	{45473, 225928, 7, 2045},
	{41002, 225932, 1, 2118},
	{45506, 225936},
	{45533, 225940},
	{45559, 225944, 4, 2110},
	{45599, 225948, 2, 2743},
	{45633, 225952, 2, 2743},
	{45663, 225956, 2, 2072},
	{45694, 225960},
	{45725, 225964, 4, 2745},
	{45759, 225968, 3, 2114},
	{45796, 225972, 3, 2749},
	{41022, 226048, 2, 2119},
	{41039, 226052, 1, 2121},
	{41063, 226056, 1, 2121},
	{41087, 226060, 4, 2122},
	{41113, 226064, 3, 2126},
	{41142, 226068, 1, 687},
	{41171, 226072, 3, 2126},
	{41200, 226076, 1, 687},
	{41229, 226192, 1, 2129},
	{41277, 226304, 5, 2028},
	{41301, 226308, 4, 2033},
	{41326, 226312, 2, 2037},
	{41350, 226316, 5, 2028},
	{41374, 226320, 4, 2033},
	{41399, 226324, 2, 2037},
	{41423, 226328, 10, 2130},
	{41531, 226480, 5, 2140},
	{41559, 226484, 5, 2140},
	{41587, 226488, 5, 2140},
	{41615, 226492, 5, 2140},
	{41643, 226496, 5, 2140},
	{41671, 226500, 5, 2140},
	{41699, 226504, 5, 2140},
	{41727, 226508, 5, 2140},
	{41755, 226512, 6, 2145},
	{45837, 226516, 5, 2140},
	{45862, 226520, 5, 2140},
	{45887, 226524, 5, 2140},
	{45912, 226528, 5, 2140},
	{45937, 226532, 6, 2145},
	{41788, 226544, 5, 1957},
	{41817, 226548, 5, 1957},
	{41846, 226552, 4, 1962},
	{41876, 226556, 4, 1962},
	{41906, 226560, 8, 1988},
	{41933, 226564, 8, 1988},
	{42049, 226688, 5, 2028},
	{42073, 226692, 4, 2033},
	{42098, 226696, 3, 2151},
	{42122, 226700, 2, 2154},
	{42148, 226704, 2, 2154},
	{42174, 226816, 5, 1957},
	{42200, 226820, 4, 1962},
	{42227, 226824, 5, 1957},
	{42253, 226828, 5, 1957},
	{42279, 226832, 5, 1957},
	{42305, 226836, 1, 1872},
	{42331, 226840, 1, 1872},
	{42357, 226844, 1, 1872},
	{42383, 226848, 1, 1872},
	{42409, 226880, 4, 1962},
	{42436, 226884, 4, 1962},
	{42463, 226888, 4, 1962},
	{42490, 227072, 5, 1957},
	{42515, 227076, 4, 1951},
	{42541, 227080, 3, 2013},
	{42566, 227084, 3, 2013},
	{42591, 227088, 3, 2013},
	{42616, 227200, 5, 1957},
	{42640, 227204, 4, 1951},
	{42665, 227208, 3, 2013},
	{42689, 227212, 3, 2013},
	{42713, 227216, 3, 2013},
	{42737, 227328, 5, 1957},
	{42761, 227332, 4, 1962},
	{42786, 227336, 8, 1988},
	{45967, 227340, 5, 2140},
	{45988, 227344, 5, 2140},
	{46009, 227348, 6, 2145},
	{46035, 227456, 5, 2140},
	{46066, 227460, 5, 2140},
	{46097, 227464, 6, 2145},
	{46133, 227468, 1, 2752},
	{46157, 227472, 5, 1957},
	{46183, 227476, 4, 1962},
	{46210, 227480, 5, 1957},
	{46236, 227484, 4, 1962},
	{46263, 227504, 5, 2140},
	{46294, 227508, 5, 2140},
	{46325, 227512, 6, 2145},
	{46361, 227516, 1, 2752},
	{46385, 227520, 5, 1957},
	{46411, 227524, 4, 1962},
	{46438, 227528, 5, 1957},
	{46464, 227532, 4, 1962},
	{46491, 227552, 5, 2140},
	{46522, 227556, 5, 2140},
	{46553, 227560, 6, 2145},
	{46589, 227564, 1, 2752},
	{46613, 227568, 5, 1957},
	{46639, 227572, 4, 1962},
	{46666, 227576, 5, 1957},
	{46692, 227580, 4, 1962},
	{46719, 227600, 5, 2140},
	{46750, 227604, 5, 2140},
	{46781, 227608, 6, 2145},
	{46817, 227612, 1, 2752},
	{46841, 227616, 5, 1957},
	{46867, 227620, 4, 1962},
	{46894, 227624, 5, 1957},
	{46920, 227628, 4, 1962},
	{195, 880, 4, 2156},
	{42808, 881},
	{26631, 882},
	{42820, 1008},
	{42831, 1009},
	{26819, 1010, 3, 2160},
	{42842, 1040, 1, 2163},
	{42855, 1041, 5, 2164},
	{42868, 1042, 1, 2169},
	{42881, 1043, 1, 1681},
	{26653, 1045, 7, 2170},
	{42894, 1168, 12, 2177},
	{42909, 1280, 6, 2189},
	{42924, 1281},
	{26590, 1282},
	{42808, 1283},
	{26631, 1284},
	{42936, 1414, 15, 2195},
};

static const struct si_reg gfx6_reg_table[] = {
	{974, 68, 9, 2753},
	{987, 72, 24, 2762},
	{1002, 76, 3, 2786},
	{46947, 80, 11, 2789},
	{1039, 84, 4, 2800},
	{1057, 88, 2, 2804},
	{1075, 92, 4, 2806},
	{1090, 96},
	{1104, 100, 1, 2810},
	{1118, 104},
	{46961, 108},
	{46978, 112, 13, 2811},
	{46994, 2480},
	{47009, 2484, 1, 2824},
	{47024, 2488},
	{47039, 2492, 1, 2824},
	{1273, 2496},
	{1287, 2500},
	{1301, 2504},
	{1315, 2508},
	{1329, 2512},
	{1343, 2516},
	{1357, 2520},
	{1371, 2524},
	{1385, 2528},
	{1399, 2532},
	{1413, 2536},
	{1428, 2540},
	{1503, 2544},
	{1514, 2552},
	{1530, 2556},
	{47054, 3660, 21, 2825},
	{47067, 3664, 20, 2846},
	{47079, 3668, 16, 2866},
	{47092, 32768, 1, 2882},
	{47102, 32772, 2, 2883},
	{1618, 32776, 17, 2885},
	{47117, 32780, 2, 2902},
	{1631, 32784, 24, 2904},
	{1643, 32788, 11, 2928},
	{1659, 32792, 11, 2928},
	{47131, 32800, 6, 2939},
	{47147, 32804, 1, 2945},
	{47163, 32808},
	{28309, 32812, 6, 2946},
	{47179, 32816, 2, 2952},
	{47199, 32820, 1, 2954},
	{47221, 32848, 6, 2955},
	{47232, 32852, 22, 2961},
	{47252, 32856, 4, 2983},
	{47268, 32864, 2, 2987},
	{36812, 32880, 19, 2989},
	{36837, 32884, 19, 2989},
	{31009, 32888},
	{31030, 32892},
	{31051, 32896},
	{31072, 32900},
	{36862, 32920, 12, 3008},
	{36890, 32924, 12, 3008},
	{31093, 32936},
	{31117, 32940},
	{31141, 32944},
	{31165, 32948},
	{47282, 33008, 1, 3020},
	{47168, 33012},
	{47294, 33020},
	{47307, 33024},
	{47325, 33028},
	{47343, 33032},
	{47361, 33036},
	{47379, 33040},
	{47397, 33044},
	{47415, 33048},
	{47433, 33052},
	{47451, 33536, 10, 3021},
	{24203, 33792, 2, 3031},
	{24223, 33796, 1, 1628},
	{24243, 33800},
	{24263, 33804},
	{24283, 33808},
	{24304, 33812},
	{24325, 33816, 2, 3033},
	{24347, 33820},
	{24369, 33824},
	{24399, 33828},
	{24429, 33832},
	{24458, 33836},
	{24487, 33840},
	{24517, 33844},
	{24547, 33848},
	{24576, 33852},
	{24605, 33856},
	{24635, 33860},
	{24665, 33864},
	{24694, 33868},
	{24723, 33872},
	{24753, 33876},
	{24783, 33880},
	{24812, 33884},
	{24841, 33888, 2, 3035},
	{24863, 33892},
	{24885, 33896},
	{24908, 33900},
	{24931, 33904},
	{24954, 33908},
	{24977, 33912},
	{25000, 33916},
	{25023, 33920},
	{25047, 33924},
	{25071, 33928},
	{25095, 33932},
	{25119, 33936},
	{25143, 33940},
	{25167, 33944},
	{25191, 33948},
	{25215, 33952},
	{25237, 33956},
	{25259, 33960},
	{25280, 33964},
	{25301, 33968},
	{25325, 33972},
	{25349, 33976},
	{25373, 33980},
	{25397, 33984},
	{25421, 33988},
	{25549, 34044, 1, 1635},
	{25565, 34048},
	{25578, 34052},
	{25591, 34056},
	{25604, 34060},
	{25617, 34064},
	{25630, 34068},
	{25643, 34072},
	{25656, 34076},
	{25783, 34112, 2, 1636},
	{25796, 34116},
	{25967, 34144, 1, 1638},
	{25985, 34148, 3, 3037},
	{26003, 34152},
	{26018, 34156},
	{26042, 34160},
	{26066, 34164},
	{26085, 34168},
	{26104, 34172},
	{26128, 34176},
	{26152, 34180},
	{26176, 34184},
	{26200, 34212, 2, 3040},
	{26218, 34216, 1, 3042},
	{26236, 34220},
	{26254, 34224},
	{26272, 34228, 2, 3043},
	{26290, 34232, 1, 3045},
	{26308, 34236},
	{26326, 34240, 2, 1649},
	{26345, 34244, 5, 3046},
	{26364, 34256},
	{26388, 34260, 2, 1649},
	{26408, 34264, 5, 3046},
	{26482, 34284, 1, 1664},
	{26503, 34288, 23, 3051},
	{26517, 34292},
	{26531, 34296},
	{26545, 34300, 4, 3074},
	{26561, 34304},
	{26580, 34308, 1, 3078},
	{26602, 34312},
	{26621, 34316, 1, 3079},
	{26643, 34320, 9, 3080},
	{26661, 34324},
	{26681, 34328, 1, 3078},
	{26704, 34332},
	{26724, 34336, 1, 3079},
	{26747, 34340, 9, 3080},
	{26766, 34344, 5, 3089},
	{26778, 34348, 2, 1696},
	{26812, 34356, 1, 3094},
	{26830, 34360, 5, 2646},
	{26850, 34364, 1, 1704},
	{26867, 34368},
	{26883, 34372, 1, 1706},
	{26896, 34376, 1, 1707},
	{26910, 34380, 1, 1708},
	{26924, 34384, 1, 1709},
	{26946, 34388, 1, 1710},
	{26966, 34392, 1, 1711},
	{26988, 34396, 1, 1712},
	{47474, 34416, 15, 3095},
	{47491, 34420, 18, 3110},
	{47508, 34424, 31, 3128},
	{47525, 34428, 16, 3159},
	{47538, 34432, 24, 3175},
	{47546, 34436},
	{47564, 34440},
	{47583, 34444, 3, 3199},
	{47602, 34448},
	{47620, 34460, 1, 3202},
	{47641, 34512, 2, 3203},
	{47653, 34516, 1, 3205},
	{47665, 34520, 9, 3206},
	{47676, 34528, 4, 3215},
	{47689, 34532, 1, 3219},
	{47706, 34552, 1, 3220},
	{47718, 34556, 1, 3220},
	{47730, 34560, 1, 3220},
	{47742, 34564, 2, 3221},
	{47759, 34568, 2, 3223},
	{27301, 34572, 1, 1721},
	{27320, 34576, 1, 3225},
	{27339, 34580, 1, 1723},
	{27356, 34584, 1, 1724},
	{27374, 34588, 1, 3226},
	{27392, 34592, 1, 1726},
	{27408, 34596, 1, 1727},
	{27426, 34600, 1, 3227},
	{27444, 34604, 1, 1729},
	{27460, 34608, 1, 1724},
	{27475, 34612, 1, 3226},
	{27490, 34616, 1, 1726},
	{27503, 34620, 1, 1727},
	{27518, 34624, 1, 3227},
	{27533, 34628, 1, 1729},
	{27546, 34632, 1, 1730},
	{27560, 34636, 1, 3228},
	{27574, 34640, 1, 1732},
	{47780, 34644, 4, 3229},
	{47799, 34648, 4, 3233},
	{47818, 34652, 3, 3237},
	{47836, 34656, 2, 3240},
	{47856, 34660, 2, 3242},
	{47874, 34664, 2, 3244},
	{47887, 34668, 1, 3246},
	{47900, 34672, 1, 3247},
	{47914, 34676, 1, 3248},
	{47927, 34680, 3, 3249},
	{47940, 34684},
	{47952, 34688, 2, 3252},
	{47967, 34692, 2, 3254},
	{47983, 34696, 2, 3256},
	{47999, 34700, 1, 3258},
	{48011, 34708, 2, 3259},
	{48023, 34712, 2, 3261},
	{48037, 34716, 1, 3263},
	{48051, 34720, 2, 3264},
	{48069, 34724, 2, 3266},
	{48088, 34728, 2, 3268},
	{48107, 34780, 12, 3270},
	{36512, 34812, 4, 1881},
	{48125, 34944, 5, 3282},
	{48148, 34948, 2, 3287},
	{48171, 34952, 2, 3287},
	{48194, 34956, 2, 3287},
	{48217, 34960},
	{48236, 34964},
	{48255, 34968},
	{48274, 34972},
	{48293, 34976},
	{48312, 34980},
	{48331, 34984},
	{48350, 34988},
	{48369, 34992, 1, 3289},
	{48392, 34996, 1, 3290},
	{48416, 35000, 1, 3291},
	{48439, 35004, 1, 3292},
	{48464, 35008, 2, 3293},
	{48484, 35012, 8, 3295},
	{48507, 35016},
	{48526, 35020},
	{48545, 35024, 4, 3303},
	{48561, 35028, 1, 3307},
	{48581, 35032, 1, 3308},
	{48597, 35036, 5, 3309},
	{48612, 35040, 2, 3314},
	{48627, 35044},
	{48642, 35048, 2, 3316},
	{48656, 35052},
	{48670, 35056, 10, 3318},
	{48686, 35100, 1, 3328},
	{48712, 35104, 5, 3282},
	{48736, 35108, 5, 3282},
	{48760, 35112, 2, 3287},
	{48784, 35116, 2, 3287},
	{48808, 35120},
	{48828, 35124},
	{48848, 35128},
	{48868, 35132},
	{48888, 35136},
	{48908, 35140},
	{48928, 35144},
	{48948, 35148},
	{28370, 35160, 1, 3329},
	{28389, 35164, 1, 3330},
	{28404, 35168},
	{28437, 35172},
	{28470, 35176},
	{28503, 35180},
	{28593, 35184},
	{28609, 35188},
	{48968, 35196, 10, 3331},
	{48986, 35200, 2, 3341},
	{49003, 35204, 10, 3343},
	{49020, 35208, 1, 1785},
	{49037, 35212, 3, 3353},
	{49052, 35248, 2, 3356},
	{49073, 35256},
	{49092, 35260, 4, 3358},
	{49118, 35264, 4, 3358},
	{49146, 35328, 1, 3362},
	{49163, 35332},
	{49180, 35344, 1, 3363},
	{49198, 35348, 9, 3364},
	{49212, 35352, 10, 3373},
	{37404, 35360, 3, 3282},
	{37457, 35364, 3, 3282},
	{37510, 35368, 2, 2010},
	{37563, 35372, 2, 2010},
	{31745, 35376},
	{31767, 35380, 1, 1869},
	{31789, 35384},
	{31811, 35388, 1, 1869},
	{31833, 35392},
	{31855, 35396, 1, 1869},
	{31877, 35400},
	{31899, 35404, 1, 1869},
	{49229, 35408, 1, 3383},
	{49247, 35412, 1, 3384},
	{29013, 35424, 1, 1809},
	{37616, 35456, 3, 3385},
	{37669, 35460, 1, 1974},
	{37695, 35464, 1, 1974},
	{37721, 35468, 1, 1974},
	{37747, 35472, 1, 1974},
	{37773, 35476, 1, 1974},
	{37799, 35480, 1, 1974},
	{37825, 35484, 1, 1974},
	{31921, 35488},
	{31943, 35492},
	{31965, 35496},
	{31987, 35500},
	{32009, 35504},
	{32031, 35508},
	{32053, 35512},
	{32075, 35516},
	{32097, 35520},
	{32119, 35524},
	{32141, 35528},
	{32163, 35532},
	{32185, 35536},
	{32207, 35540},
	{32229, 35544},
	{32251, 35548},
	{29038, 35600, 2, 1810},
	{49269, 35620, 2, 3388},
	{49294, 35624, 10, 3390},
	{49311, 35788, 4, 3400},
	{49327, 35796, 4, 3404},
	{49346, 35800, 1, 3408},
	{49363, 35804},
	{49380, 35824, 26, 3409},
	{49394, 35840, 9, 3435},
	{49404, 35844, 9, 3444},
	{29779, 35848, 3, 3453},
	{49415, 35852, 3, 3456},
	{49434, 35856, 6, 3459},
	{49449, 35860, 4, 3465},
	{38490, 35864, 9, 3469},
	{49463, 35868, 4, 3478},
	{49483, 35872, 4, 3478},
	{49505, 35876, 4, 3482},
	{32513, 35968},
	{32532, 35972},
	{32551, 35976},
	{32570, 35980},
	{32589, 35984},
	{32608, 35988},
	{32627, 35992},
	{32646, 35996},
	{32665, 36000},
	{32684, 36004},
	{32703, 36008},
	{32722, 36012},
	{32741, 36016},
	{32760, 36020},
	{32779, 36024},
	{32798, 36028},
	{32817, 36032},
	{32836, 36036},
	{32855, 36040},
	{32874, 36044},
	{32893, 36048},
	{32913, 36052},
	{32933, 36056},
	{32953, 36060},
	{32973, 36064},
	{32993, 36068},
	{33013, 36072},
	{33033, 36076},
	{33053, 36080},
	{33073, 36084},
	{33093, 36088},
	{33113, 36092},
	{38116, 36096, 6, 3486},
	{38139, 36100, 6, 3486},
	{38162, 36104, 6, 3486},
	{38185, 36108, 6, 3486},
	{38208, 36112, 6, 3486},
	{38231, 36116, 6, 3486},
	{38254, 36120, 6, 3486},
	{38277, 36124, 6, 3486},
	{38300, 36128, 6, 3486},
	{38323, 36132, 6, 3486},
	{38346, 36136, 6, 3486},
	{38370, 36140, 6, 3486},
	{38394, 36144, 6, 3486},
	{38418, 36148, 6, 3486},
	{38442, 36152, 6, 3486},
	{38466, 36156, 6, 3486},
	{49525, 36224, 2, 3492},
	{49541, 36228, 2, 3492},
	{49557, 36232, 4, 3494},
	{49574, 36236, 4, 3494},
	{49592, 36320, 8, 3498},
	{49605, 36324},
	{49617, 36336},
	{49628, 36340},
	{49639, 36352},
	{49660, 36356, 1, 3506},
	{2095, 36360, 8, 3507},
	{2116, 36364, 3, 3515},
	{49681, 36368, 2, 3518},
	{29563, 36384},
	{29590, 36388},
	{29617, 36392},
	{29644, 36396},
	{2074, 36400, 2, 3520},
	{2164, 36404, 5, 3522},
	{49707, 36408, 15, 3527},
	{2143, 36412, 1, 3542},
	{49728, 36416},
	{49749, 36424, 1, 3543},
	{49773, 36440, 3, 3544},
	{49791, 36444, 4, 3547},
	{49810, 36448, 3, 3551},
	{49825, 36452},
	{49847, 36456},
	{49869, 36460},
	{49891, 36464},
	{49913, 36480, 4, 3554},
	{49928, 36484, 3, 3558},
	{49939, 36488, 3, 3561},
	{49950, 36492, 4, 3564},
	{2351, 36608},
	{2369, 36612, 4, 383},
	{2387, 36616},
	{2405, 36620, 14, 3568},
	{3306, 36624},
	{3324, 36628, 5, 3582},
	{3342, 36632, 4, 3587},
	{3360, 36636, 11, 3591},
	{3378, 36640, 2, 3602},
	{3396, 36644, 2, 3604},
	{3414, 36648, 4, 3606},
	{3432, 36652},
	{2423, 36656, 13, 3610},
	{2441, 36660, 4, 411},
	{2459, 36664, 9, 3623},
	{2477, 36668, 3, 3632},
	{2495, 37120, 6, 429},
	{29804, 38156},
	{2511, 39160, 9, 3635},
	{2526, 39184, 6, 3644},
	{2540, 39188, 5, 3645},
	{2554, 39192, 5, 3645},
	{2568, 39196, 5, 3645},
	{2582, 39200, 5, 3645},
	{2596, 39204, 5, 3645},
	{2610, 39208, 5, 3645},
	{2624, 39212, 5, 3645},
	{2638, 39216, 5, 3645},
	{2652, 39220, 5, 3645},
	{2666, 39224, 5, 3645},
	{2681, 39228, 5, 3645},
	{2696, 39232, 5, 3645},
	{2711, 39236, 5, 3645},
	{2726, 39240, 5, 3645},
	{2741, 39244, 5, 3645},
	{2756, 39248, 5, 3645},
	{2771, 39252, 5, 3645},
	{2786, 39256, 5, 3645},
	{2801, 39260, 5, 3645},
	{2816, 39264, 5, 3645},
	{2831, 39268, 5, 3645},
	{2846, 39272, 5, 3645},
	{2861, 39276, 5, 3645},
	{2876, 39280, 5, 3645},
	{2891, 39284, 5, 3645},
	{2906, 39288, 5, 3645},
	{2921, 39292, 5, 3645},
	{2936, 39296, 5, 3645},
	{2951, 39300, 5, 3645},
	{2966, 39304, 5, 3645},
	{2981, 39308, 5, 3645},
	{49962, 45056},
	{49983, 45060, 1, 491},
	{50004, 45064},
	{50025, 45068, 1, 491},
	{3523, 45088},
	{3544, 45092, 1, 491},
	{3565, 45096, 11, 3650},
	{3589, 45100, 6, 3661},
	{3613, 45104},
	{3639, 45108},
	{3665, 45112},
	{3691, 45116},
	{3717, 45120},
	{3743, 45124},
	{3769, 45128},
	{3795, 45132},
	{3821, 45136},
	{3847, 45140},
	{3873, 45144},
	{3900, 45148},
	{3927, 45152},
	{3954, 45156},
	{3981, 45160},
	{4008, 45164},
	{50046, 45312},
	{50067, 45316, 1, 491},
	{50088, 45320},
	{50109, 45324, 1, 491},
	{4729, 45344},
	{4750, 45348, 1, 491},
	{4771, 45352, 12, 3667},
	{4795, 45356, 10, 3679},
	{4819, 45360},
	{4845, 45364},
	{4871, 45368},
	{4897, 45372},
	{4923, 45376},
	{4949, 45380},
	{4975, 45384},
	{5001, 45388},
	{5027, 45392},
	{5053, 45396},
	{5079, 45400},
	{5106, 45404},
	{5133, 45408},
	{5160, 45412},
	{5187, 45416},
	{5214, 45420},
	{50130, 45568},
	{50151, 45572, 1, 491},
	{50172, 45576},
	{50193, 45580, 1, 491},
	{6103, 45600},
	{6124, 45604, 1, 491},
	{6145, 45608, 11, 3689},
	{6169, 45612, 4, 3700},
	{6193, 45616},
	{6219, 45620},
	{6245, 45624},
	{6271, 45628},
	{6297, 45632},
	{6323, 45636},
	{6349, 45640},
	{6375, 45644},
	{6401, 45648},
	{6427, 45652},
	{6453, 45656},
	{6480, 45660},
	{6507, 45664},
	{6534, 45668},
	{6561, 45672},
	{6588, 45676},
	{50214, 45824},
	{50235, 45828, 1, 491},
	{50256, 45832},
	{50277, 45836, 1, 491},
	{7274, 45856},
	{7295, 45860, 1, 491},
	{7316, 45864, 12, 3667},
	{7340, 45868, 6, 3704},
	{7364, 45872},
	{7390, 45876},
	{7416, 45880},
	{7442, 45884},
	{7468, 45888},
	{7494, 45892},
	{7520, 45896},
	{7546, 45900},
	{7572, 45904},
	{7598, 45908},
	{7624, 45912},
	{7651, 45916},
	{7678, 45920},
	{7705, 45924},
	{7732, 45928},
	{7759, 45932},
	{50298, 46080},
	{50319, 46084, 1, 491},
	{50340, 46088},
	{50361, 46092, 1, 491},
	{7998, 46112},
	{8019, 46116, 1, 491},
	{8040, 46120, 10, 3710},
	{8064, 46124, 6, 3720},
	{8088, 46128},
	{8114, 46132},
	{8140, 46136},
	{8166, 46140},
	{8192, 46144},
	{8218, 46148},
	{8244, 46152},
	{8270, 46156},
	{8296, 46160},
	{8322, 46164},
	{8348, 46168},
	{8375, 46172},
	{8402, 46176},
	{8429, 46180},
	{8456, 46184},
	{8483, 46188},
	{50382, 46336},
	{50403, 46340, 1, 491},
	{50424, 46344},
	{50445, 46348, 1, 491},
	{9169, 46368},
	{9190, 46372, 1, 491},
	{9211, 46376, 11, 3726},
	{9235, 46380, 5, 3737},
	{9259, 46384},
	{9285, 46388},
	{9311, 46392},
	{9337, 46396},
	{9363, 46400},
	{9389, 46404},
	{9415, 46408},
	{9441, 46412},
	{9467, 46416},
	{9493, 46420},
	{9519, 46424},
	{9546, 46428},
	{9573, 46432},
	{9600, 46436},
	{9627, 46440},
	{9654, 46444},
	{9681, 47104, 12, 3742},
	{9708, 47108},
	{9722, 47112},
	{9736, 47116},
	{9750, 47120},
	{9766, 47124},
	{9782, 47128},
	{9798, 47132, 2, 659},
	{9819, 47136, 2, 659},
	{9840, 47140, 2, 659},
	{50466, 47148, 1, 3754},
	{9914, 47152},
	{9929, 47156, 2, 3755},
	{50486, 47160},
	{50501, 47164, 1, 663},
	{50516, 47168},
	{50531, 47172, 1, 663},
	{10068, 47176, 10, 3757},
	{10086, 47180, 11, 676},
	{10104, 47184, 1, 687},
	{10117, 47188, 7, 3767},
	{50546, 47192, 2, 3774},
	{50577, 47196, 2, 3774},
	{10195, 47200, 2, 694},
	{10670, 47360},
	{10690, 47364},
	{10710, 47368},
	{10730, 47372},
	{10750, 47376},
	{10770, 47380},
	{10790, 47384},
	{10810, 47388},
	{10830, 47392},
	{10850, 47396},
	{10870, 47400},
	{10891, 47404},
	{10912, 47408},
	{10933, 47412},
	{10954, 47416},
	{10975, 47420},
	{50608, 53300, 29, 3776},
	{50625, 55348, 29, 3776},
	{11057, 163840, 9, 719},
	{11075, 163844, 9, 3805},
	{11092, 163848, 4, 3814},
	{11106, 163852, 23, 747},
	{11125, 163856, 15, 770},
	{11145, 163860},
	{11181, 163872},
	{11201, 163876},
	{11221, 163880, 1, 788},
	{11238, 163884},
	{11253, 163888, 2, 789},
	{11277, 163892, 2, 791},
	{50642, 163900, 7, 3818},
	{11335, 163904, 8, 3825},
	{11345, 163908, 5, 3833},
	{11361, 163912},
	{11376, 163916},
	{11397, 163920},
	{11413, 163924},
	{50656, 163928, 2, 3838},
	{50670, 163932, 1, 3840},
	{11603, 163968},
	{11722, 164344},
	{11740, 164348},
	{11758, 164352, 2, 842},
	{11778, 164356, 3, 844},
	{11802, 164360, 2, 847},
	{11826, 164364, 1, 849},
	{11846, 164368, 2, 844},
	{11866, 164372, 2, 847},
	{11886, 164376, 2, 844},
	{11906, 164380, 2, 847},
	{11926, 164384, 2, 844},
	{11946, 164388, 2, 847},
	{11966, 164392, 2, 844},
	{11986, 164396, 2, 847},
	{12006, 164400, 7, 850},
	{12021, 164404, 2, 857},
	{12050, 164408, 8, 859},
	{12065, 164412, 8, 867},
	{12080, 164416, 3, 844},
	{12105, 164420, 2, 847},
	{12130, 164424},
	{12148, 164428},
	{12166, 164432, 3, 844},
	{12191, 164436, 2, 847},
	{12216, 164440, 3, 844},
	{12241, 164444, 2, 847},
	{12266, 164448, 3, 844},
	{12291, 164452, 2, 847},
	{12316, 164456, 3, 844},
	{12341, 164460, 2, 847},
	{12366, 164464, 3, 844},
	{12391, 164468, 2, 847},
	{12416, 164472, 3, 844},
	{12441, 164476, 2, 847},
	{12466, 164480, 3, 844},
	{12491, 164484, 2, 847},
	{12516, 164488, 3, 844},
	{12541, 164492, 2, 847},
	{12566, 164496, 3, 844},
	{12591, 164500, 2, 847},
	{12616, 164504, 3, 844},
	{12641, 164508, 2, 847},
	{12666, 164512, 3, 844},
	{12692, 164516, 2, 847},
	{12718, 164520, 3, 844},
	{12744, 164524, 2, 847},
	{12770, 164528, 3, 844},
	{12796, 164532, 2, 847},
	{12822, 164536, 3, 844},
	{12848, 164540, 2, 847},
	{12874, 164544, 3, 844},
	{12900, 164548, 2, 847},
	{12926, 164552, 3, 844},
	{12952, 164556, 2, 847},
	{12978, 164560},
	{12997, 164564},
	{13016, 164568},
	{13035, 164572},
	{13054, 164576},
	{13073, 164580},
	{13092, 164584},
	{13111, 164588},
	{13130, 164592},
	{13149, 164596},
	{13168, 164600},
	{13187, 164604},
	{13206, 164608},
	{13225, 164612},
	{13244, 164616},
	{13263, 164620},
	{13282, 164624},
	{13301, 164628},
	{13320, 164632},
	{13339, 164636},
	{13358, 164640},
	{13378, 164644},
	{13398, 164648},
	{13418, 164652},
	{13438, 164656},
	{13458, 164660},
	{13478, 164664},
	{13498, 164668},
	{13518, 164672},
	{13538, 164676},
	{13558, 164680},
	{13578, 164684},
	{13598, 164688, 15, 875},
	{13697, 164704, 1, 902},
	{50685, 164708, 1, 3841},
	{13728, 164712, 1, 904},
	{13796, 164864},
	{13813, 164868},
	{13830, 164872},
	{13846, 164876},
	{13900, 164884},
	{13913, 164888},
	{13928, 164892},
	{13942, 164896},
	{13996, 164908, 6, 935},
	{14015, 164912, 4, 941},
	{14033, 164916, 4, 945},
	{14054, 164924},
	{14073, 164928},
	{14093, 164932},
	{14112, 164936},
	{14132, 164940},
	{14151, 164944},
	{14171, 164948},
	{14192, 164952},
	{14214, 164956},
	{14235, 164960},
	{14257, 164964},
	{14278, 164968},
	{14300, 164972},
	{14321, 164976},
	{14343, 164980},
	{14364, 164984},
	{14386, 164988},
	{14407, 164992},
	{14429, 164996},
	{14450, 165000},
	{14472, 165004},
	{14493, 165008},
	{14515, 165012},
	{14536, 165016},
	{14558, 165020},
	{14579, 165024},
	{14601, 165028},
	{14622, 165032},
	{14644, 165036},
	{14665, 165040},
	{14687, 165044},
	{14708, 165048},
	{14730, 165052},
	{14751, 165056},
	{14773, 165060},
	{14794, 165064},
	{14816, 165068},
	{14837, 165072},
	{14859, 165076},
	{14880, 165080},
	{14902, 165084},
	{14923, 165088},
	{14945, 165092},
	{14966, 165096},
	{14988, 165100},
	{15009, 165104},
	{15031, 165108},
	{15052, 165112},
	{15074, 165116},
	{15095, 165120},
	{15117, 165124},
	{15138, 165128},
	{15160, 165132},
	{15181, 165136},
	{15203, 165140},
	{15224, 165144},
	{15246, 165148},
	{15267, 165152},
	{15289, 165156},
	{15310, 165160},
	{15332, 165164},
	{15354, 165168},
	{15377, 165172},
	{15399, 165176},
	{15422, 165180},
	{15444, 165184},
	{15467, 165188},
	{15489, 165192},
	{15512, 165196},
	{15534, 165200},
	{15557, 165204},
	{15579, 165208},
	{15602, 165212},
	{15624, 165216},
	{15647, 165220},
	{15669, 165224},
	{15692, 165228},
	{15714, 165232},
	{15737, 165236},
	{15759, 165240},
	{15782, 165244},
	{15804, 165248},
	{15827, 165252},
	{15849, 165256},
	{15872, 165260},
	{15894, 165264},
	{15917, 165268},
	{15939, 165272},
	{15962, 165276},
	{15984, 165280},
	{16007, 165284},
	{16029, 165288},
	{16052, 165292},
	{16074, 165296},
	{16097, 165300},
	{16119, 165304},
	{16142, 165308},
	{16156, 165312},
	{16170, 165316},
	{16184, 165320},
	{16198, 165324},
	{16212, 165328},
	{16226, 165332},
	{16240, 165336},
	{16254, 165340},
	{16268, 165344},
	{16282, 165348},
	{16296, 165352},
	{16310, 165356},
	{16324, 165360},
	{16338, 165364},
	{16352, 165368},
	{16366, 165372},
	{16380, 165376},
	{16394, 165380},
	{16408, 165384},
	{16422, 165388},
	{16436, 165392},
	{16450, 165396},
	{16464, 165400},
	{16501, 165444, 6, 949},
	{16521, 165448, 6, 949},
	{16541, 165452, 6, 949},
	{16561, 165456, 6, 949},
	{16581, 165460, 6, 949},
	{16601, 165464, 6, 949},
	{16621, 165468, 6, 949},
	{16641, 165472, 6, 949},
	{16661, 165476, 6, 949},
	{16681, 165480, 6, 949},
	{16701, 165484, 6, 949},
	{16722, 165488, 6, 949},
	{16743, 165492, 6, 949},
	{16764, 165496, 6, 949},
	{16785, 165500, 6, 949},
	{16806, 165504, 6, 949},
	{16827, 165508, 6, 949},
	{16848, 165512, 6, 949},
	{16869, 165516, 6, 949},
	{16890, 165520, 6, 949},
	{16911, 165524, 4, 961},
	{16932, 165528, 4, 961},
	{16953, 165532, 4, 961},
	{16974, 165536, 4, 961},
	{16995, 165540, 4, 961},
	{17016, 165544, 4, 961},
	{17037, 165548, 4, 961},
	{17058, 165552, 4, 961},
	{17079, 165556, 4, 961},
	{17100, 165560, 4, 961},
	{17121, 165564, 4, 961},
	{17142, 165568, 4, 961},
	{17163, 165572, 2, 970},
	{17181, 165580, 16, 973},
	{17198, 165584, 16, 973},
	{17216, 165588, 7, 989},
	{17237, 165592, 3, 3842},
	{17255, 165600, 7, 1002},
	{17270, 165608, 2, 694},
	{17309, 165644, 4, 1010},
	{17331, 165648, 1, 1015},
	{17351, 165652, 8, 1016},
	{17577, 165760, 9, 1063},
	{17595, 165764, 9, 1063},
	{17613, 165768, 9, 1063},
	{17631, 165772, 9, 1063},
	{17649, 165776, 9, 1063},
	{17667, 165780, 9, 1063},
	{17685, 165784, 9, 1063},
	{17703, 165788, 9, 1063},
	{17721, 165836, 1, 1072},
	{17735, 165840, 1, 1072},
	{17750, 165844},
	{17768, 165848},
	{17786, 165852},
	{17803, 165856},
	{17824, 165860, 1, 3845},
	{17840, 165864},
	{17853, 165872, 5, 1074},
	{17872, 165876},
	{17887, 165880, 1, 1082},
	{17936, 165888, 10, 1084},
	{17953, 165892, 12, 1094},
	{17961, 165896, 3, 3846},
	{17978, 165900, 12, 1110},
	{17996, 165904, 19, 1127},
	{18012, 165908, 13, 1147},
	{18031, 165912, 10, 1163},
	{18046, 165916, 26, 1173},
	{18064, 165920, 16, 1201},
	{18082, 165924, 4, 1217},
	{18106, 165928},
	{18131, 165932, 11, 1221},
	{18283, 166400, 2, 1253},
	{18300, 166404, 2, 1255},
	{18319, 166408, 1, 1257},
	{18335, 166412, 4, 1258},
	{18354, 166416, 1, 1262},
	{18375, 166420, 1, 1263},
	{18388, 166424},
	{18411, 166428},
	{18434, 166432, 1, 1264},
	{18454, 166436, 4, 3849},
	{18474, 166440, 1, 1269},
	{18495, 166444, 1, 1270},
	{18510, 166448, 6, 1271},
	{18532, 166452, 6, 1271},
	{18554, 166456, 8, 1277},
	{18580, 166460, 8, 1277},
	{18606, 166464, 15, 1285},
	{18637, 166472, 4, 1303},
	{18655, 166476, 24, 1310},
	{18673, 166480},
	{18685, 166484, 1, 1334},
	{18699, 166488, 1, 1335},
	{18713, 166492, 1, 1336},
	{18727, 166496, 1, 1337},
	{18750, 166500, 1, 1337},
	{18773, 166504, 1, 1337},
	{18796, 166508, 5, 3853},
	{18817, 166512},
	{18828, 166516},
	{18841, 166520},
	{18858, 166524, 7, 3858},
	{18888, 166532, 2, 1351},
	{18907, 166536},
	{18929, 166540},
	{18951, 166544, 3, 3865},
	{18971, 166548, 1, 1357},
	{19020, 166560},
	{19045, 166564},
	{19070, 166568, 6, 1364},
	{19089, 166572, 1, 1370},
	{19112, 166576, 1, 1370},
	{19135, 166580, 1, 1371},
	{19149, 166584, 1, 1372},
	{19164, 166588, 7, 3868},
	{19181, 166592, 4, 1382},
	{19208, 166596, 4, 1386},
	{19235, 166600, 4, 1390},
	{19254, 166608},
	{19280, 166612, 1, 1394},
	{19305, 166620},
	{19333, 166624},
	{19359, 166628, 1, 1394},
	{19384, 166636},
	{19412, 166640},
	{19438, 166644, 1, 1394},
	{19463, 166652},
	{19491, 166656},
	{19517, 166660, 1, 1394},
	{19542, 166668},
	{19570, 166696},
	{19601, 166700},
	{19644, 166704, 1, 1395},
	{19682, 166712, 1, 1396},
	{19743, 166740, 6, 1404},
	{19764, 166744, 3, 1423},
	{19781, 166748, 1, 1370},
	{19802, 166752, 1, 1370},
	{19825, 166756, 1, 1370},
	{19848, 166760, 1, 1370},
	{19871, 166764, 8, 3875},
	{19884, 166768, 6, 1438},
	{19925, 166776, 2, 1444},
	{19955, 166780},
	{19979, 166784},
	{20009, 166788},
	{20040, 166792},
	{20069, 166796},
	{20099, 166800, 2, 1446},
	{20119, 166804, 7, 3883},
	{20138, 166808, 4, 1457},
	{20188, 166868, 8, 1461},
	{20214, 166872, 8, 1469},
	{20240, 166876, 4, 1477},
	{20256, 166880, 5, 1482},
	{20272, 166884, 3, 1488},
	{20287, 166888},
	{20310, 166892},
	{20333, 166896},
	{20356, 166900},
	{20379, 166904, 8, 1491},
	{20413, 166908, 8, 1499},
	{20447, 166912, 8, 1507},
	{20481, 166916, 8, 1515},
	{20515, 166920, 8, 1491},
	{20549, 166924, 8, 1499},
	{20583, 166928, 8, 1507},
	{20617, 166932, 8, 1515},
	{20651, 166936, 8, 1491},
	{20685, 166940, 8, 1499},
	{20719, 166944, 8, 1507},
	{20753, 166948, 8, 1515},
	{20787, 166952, 8, 1491},
	{20821, 166956, 8, 1499},
	{20855, 166960, 8, 1507},
	{20889, 166964, 8, 1515},
	{20923, 166968, 2, 1523},
	{20947, 166972, 2, 1525},
	{21090, 167000, 1, 1567},
	{21118, 167004, 1, 1568},
	{21139, 167008},
	{21154, 167012, 2, 1569},
	{21170, 167016, 1, 1571},
	{21186, 167020, 2, 3814},
	{21201, 167024, 15, 3890},
	{21216, 167028, 6, 1594},
	{21255, 167036},
	{21271, 167040, 1, 1614},
	{21293, 167044},
	{21309, 167048, 1, 1571},
	{21331, 167052},
	{21353, 167056},
	{21394, 167068},
	{21409, 167072, 2, 1569},
	{21425, 167076, 1, 1571},
	{21441, 167080, 2, 3814},
	{21456, 167084, 15, 3890},
	{21471, 167088, 6, 1594},
	{21510, 167096},
	{21526, 167100, 1, 1614},
	{21548, 167104},
	{21564, 167108, 1, 1571},
	{21586, 167112},
	{21608, 167116},
	{21649, 167128},
	{21664, 167132, 2, 1569},
	{21680, 167136, 1, 1571},
	{21696, 167140, 2, 3814},
	{21711, 167144, 15, 3890},
	{21726, 167148, 6, 1594},
	{21765, 167156},
	{21781, 167160, 1, 1614},
	{21803, 167164},
	{21819, 167168, 1, 1571},
	{21841, 167172},
	{21863, 167176},
	{21904, 167188},
	{21919, 167192, 2, 1569},
	{21935, 167196, 1, 1571},
	{21951, 167200, 2, 3814},
	{21966, 167204, 15, 3890},
	{21981, 167208, 6, 1594},
	{22020, 167216},
	{22036, 167220, 1, 1614},
	{22058, 167224},
	{22074, 167228, 1, 1571},
	{22096, 167232},
	{22118, 167236},
	{22159, 167248},
	{22174, 167252, 2, 1569},
	{22190, 167256, 1, 1571},
	{22206, 167260, 2, 3814},
	{22221, 167264, 15, 3890},
	{22236, 167268, 6, 1594},
	{22275, 167276},
	{22291, 167280, 1, 1614},
	{22313, 167284},
	{22329, 167288, 1, 1571},
	{22351, 167292},
	{22373, 167296},
	{22414, 167308},
	{22429, 167312, 2, 1569},
	{22445, 167316, 1, 1571},
	{22461, 167320, 2, 3814},
	{22476, 167324, 15, 3890},
	{22491, 167328, 6, 1594},
	{22530, 167336},
	{22546, 167340, 1, 1614},
	{22568, 167344},
	{22584, 167348, 1, 1571},
	{22606, 167352},
	{22628, 167356},
	{22669, 167368},
	{22684, 167372, 2, 1569},
	{22700, 167376, 1, 1571},
	{22716, 167380, 2, 3814},
	{22731, 167384, 15, 3890},
	{22746, 167388, 6, 1594},
	{22785, 167396},
	{22801, 167400, 1, 1614},
	{22823, 167404},
	{22839, 167408, 1, 1571},
	{22861, 167412},
	{22883, 167416},
	{22924, 167428},
	{22939, 167432, 2, 1569},
	{22955, 167436, 1, 1571},
	{22971, 167440, 2, 3814},
	{22986, 167444, 15, 3890},
	{23001, 167448, 6, 1594},
	{23040, 167456},
	{23056, 167460, 1, 1614},
	{23078, 167464},
	{23094, 167468, 1, 1571},
	{23116, 167472},
	{23138, 167476},
	{195, 880, 4, 3905},
	{42808, 881},
	{26631, 882},
	{42820, 1008},
	{42831, 1009},
	{26819, 1010, 3, 2160},
	{42842, 1040, 1, 2163},
	{42855, 1041, 5, 3909},
	{42868, 1042, 1, 2169},
	{42881, 1043, 1, 1681},
	{26653, 1045, 9, 3914},
	{42909, 1280, 4, 3923},
	{42924, 1281},
	{26590, 1282},
	{42808, 1283},
	{26631, 1284},
};

static const struct si_reg gfx7_reg_table[] = {
	{974, 68, 9, 3927},
	{987, 72, 24, 2762},
	{1002, 76, 3, 3936},
	{46947, 80, 11, 3939},
	{1039, 84, 4, 2800},
	{1057, 88, 2, 2804},
	{1075, 92, 4, 3950},
	{1090, 96},
	{1104, 100, 1, 2810},
	{1118, 104},
	{46961, 108},
	{46978, 112, 13, 2811},
	{46994, 2480},
	{47009, 2484, 1, 2824},
	{47024, 2488},
	{47039, 2492, 1, 2824},
	{1273, 2496},
	{1287, 2500},
	{1301, 2504},
	{1315, 2508},
	{1329, 2512},
	{1343, 2516},
	{1357, 2520},
	{1371, 2524},
	{1385, 2528},
	{1399, 2532},
	{1413, 2536},
	{1428, 2540},
	{1503, 2544},
	{1514, 2552},
	{1530, 2556},
	{47054, 3660, 21, 2825},
	{47067, 3664, 20, 2846},
	{47079, 3668, 16, 2866},
	{1618, 32776, 17, 3954},
	{1631, 32784, 24, 2904},
	{1643, 32788, 11, 2928},
	{1659, 32792, 11, 2928},
	{1688, 32824, 11, 2928},
	{1704, 32828, 11, 2928},
	{1720, 33296, 16, 3971},
	{1734, 33300, 28, 204},
	{1751, 33304, 17, 3987},
	{1772, 33308, 18, 4004},
	{1786, 33312, 31, 4022},
	{1803, 33316, 7, 4053},
	{50695, 33320, 1, 3202},
	{1842, 33324, 1, 329},
	{1865, 33344, 1, 1704},
	{1886, 33348},
	{1947, 33436, 1, 342},
	{49639, 36352},
	{49660, 36356, 1, 3506},
	{2095, 36360, 9, 4060},
	{2116, 36364, 3, 3515},
	{49681, 36368, 2, 3518},
	{50710, 36372, 2, 4069},
	{50732, 36376, 1, 4071},
	{2074, 36400, 2, 3520},
	{2164, 36404, 5, 4072},
	{49707, 36408, 15, 3527},
	{2143, 36412, 1, 3542},
	{49728, 36416},
	{49749, 36424, 1, 3543},
	{2351, 36608},
	{2369, 36612, 4, 383},
	{2387, 36616},
	{2405, 36620, 14, 3568},
	{3306, 36624},
	{3324, 36628, 5, 3582},
	{3342, 36632, 4, 3587},
	{3360, 36636, 11, 3591},
	{3378, 36640, 2, 3602},
	{3396, 36644, 2, 3604},
	{3414, 36648, 4, 3606},
	{3432, 36652},
	{2423, 36656, 13, 3610},
	{2441, 36660, 4, 411},
	{2459, 36664, 9, 3623},
	{2477, 36668, 3, 3632},
	{2495, 37120, 6, 429},
	{2511, 39160, 9, 3635},
	{2526, 39184, 5, 3645},
	{2540, 39188, 5, 3645},
	{2554, 39192, 5, 3645},
	{2568, 39196, 5, 3645},
	{2582, 39200, 5, 3645},
	{2596, 39204, 5, 3645},
	{2610, 39208, 5, 3645},
	{2624, 39212, 5, 3645},
	{2638, 39216, 5, 3645},
	{2652, 39220, 5, 3645},
	{2666, 39224, 5, 3645},
	{2681, 39228, 5, 3645},
	{2696, 39232, 5, 3645},
	{2711, 39236, 5, 3645},
	{2726, 39240, 5, 3645},
	{2741, 39244, 5, 3645},
	{2756, 39248, 5, 3645},
	{2771, 39252, 5, 3645},
	{2786, 39256, 5, 3645},
	{2801, 39260, 5, 3645},
	{2816, 39264, 5, 3645},
	{2831, 39268, 5, 3645},
	{2846, 39272, 5, 3645},
	{2861, 39276, 5, 3645},
	{2876, 39280, 5, 3645},
	{2891, 39284, 5, 3645},
	{2906, 39288, 5, 3645},
	{2921, 39292, 5, 3645},
	{2936, 39296, 5, 3645},
	{2951, 39300, 5, 3645},
	{2966, 39304, 5, 3645},
	{2981, 39308, 5, 3645},
	{2996, 39312, 4, 448},
	{3015, 39316, 4, 448},
	{3034, 39320, 4, 448},
	{3053, 39324, 4, 448},
	{3072, 39328, 4, 448},
	{3091, 39332, 4, 448},
	{3110, 39336, 4, 448},
	{3129, 39340, 4, 448},
	{3148, 39344, 4, 448},
	{3167, 39348, 4, 448},
	{3186, 39352, 4, 448},
	{3206, 39356, 4, 448},
	{3226, 39360, 4, 448},
	{3246, 39364, 4, 448},
	{3266, 39368, 4, 448},
	{3286, 39372, 4, 448},
	{49962, 45056},
	{49983, 45060, 1, 491},
	{50004, 45064},
	{50025, 45068, 1, 491},
	{3499, 45084, 3, 488},
	{3523, 45088},
	{3544, 45092, 1, 491},
	{3565, 45096, 11, 3650},
	{3589, 45100, 6, 503},
	{3613, 45104},
	{3639, 45108},
	{3665, 45112},
	{3691, 45116},
	{3717, 45120},
	{3743, 45124},
	{3769, 45128},
	{3795, 45132},
	{3821, 45136},
	{3847, 45140},
	{3873, 45144},
	{3900, 45148},
	{3927, 45152},
	{3954, 45156},
	{3981, 45160},
	{4008, 45164},
	{50046, 45312},
	{50067, 45316, 1, 491},
	{50088, 45320},
	{50109, 45324, 1, 491},
	{4680, 45336, 3, 488},
	{4704, 45340, 1, 527},
	{4729, 45344},
	{4750, 45348, 1, 491},
	{4771, 45352, 12, 3667},
	{4795, 45356, 10, 540},
	{4819, 45360},
	{4845, 45364},
	{4871, 45368},
	{4897, 45372},
	{4923, 45376},
	{4949, 45380},
	{4975, 45384},
	{5001, 45388},
	{5027, 45392},
	{5053, 45396},
	{5079, 45400},
	{5106, 45404},
	{5133, 45408},
	{5160, 45412},
	{5187, 45416},
	{5214, 45420},
	{5864, 45552, 6, 563},
	{5891, 45556, 5, 569},
	{50130, 45568},
	{50151, 45572, 1, 491},
	{50172, 45576},
	{50193, 45580, 1, 491},
	{6079, 45596, 3, 488},
	{6103, 45600},
	{6124, 45604, 1, 491},
	{6145, 45608, 11, 3689},
	{6169, 45612, 4, 554},
	{6193, 45616},
	{6219, 45620},
	{6245, 45624},
	{6271, 45628},
	{6297, 45632},
	{6323, 45636},
	{6349, 45640},
	{6375, 45644},
	{6401, 45648},
	{6427, 45652},
	{6453, 45656},
	{6480, 45660},
	{6507, 45664},
	{6534, 45668},
	{6561, 45672},
	{6588, 45676},
	{7223, 45808, 6, 563},
	{50214, 45824},
	{50235, 45828, 1, 491},
	{50256, 45832},
	{50277, 45836, 1, 491},
	{7250, 45852, 3, 488},
	{7274, 45856},
	{7295, 45860, 1, 491},
	{7316, 45864, 12, 3667},
	{7340, 45868, 6, 563},
	{7364, 45872},
	{7390, 45876},
	{7416, 45880},
	{7442, 45884},
	{7468, 45888},
	{7494, 45892},
	{7520, 45896},
	{7546, 45900},
	{7572, 45904},
	{7598, 45908},
	{7624, 45912},
	{7651, 45916},
	{7678, 45920},
	{7705, 45924},
	{7732, 45928},
	{7759, 45932},
	{7786, 46068, 5, 569},
	{50298, 46080},
	{50319, 46084, 1, 491},
	{50340, 46088},
	{50361, 46092, 1, 491},
	{7974, 46108, 2, 612},
	{7998, 46112},
	{8019, 46116, 1, 491},
	{8040, 46120, 10, 3710},
	{8064, 46124, 6, 628},
	{8088, 46128},
	{8114, 46132},
	{8140, 46136},
	{8166, 46140},
	{8192, 46144},
	{8218, 46148},
	{8244, 46152},
	{8270, 46156},
	{8296, 46160},
	{8322, 46164},
	{8348, 46168},
	{8375, 46172},
	{8402, 46176},
	{8429, 46180},
	{8456, 46184},
	{8483, 46188},
	{9118, 46324, 5, 569},
	{50382, 46336},
	{50403, 46340, 1, 491},
	{50424, 46344},
	{50445, 46348, 1, 491},
	{9145, 46364, 3, 488},
	{9169, 46368},
	{9190, 46372, 1, 491},
	{9211, 46376, 11, 3726},
	{9235, 46380, 5, 569},
	{9259, 46384},
	{9285, 46388},
	{9311, 46392},
	{9337, 46396},
	{9363, 46400},
	{9389, 46404},
	{9415, 46408},
	{9441, 46412},
	{9467, 46416},
	{9493, 46420},
	{9519, 46424},
	{9546, 46428},
	{9573, 46432},
	{9600, 46436},
	{9627, 46440},
	{9654, 46444},
	{9681, 47104, 12, 3742},
	{9708, 47108},
	{9722, 47112},
	{9736, 47116},
	{9750, 47120},
	{9766, 47124},
	{9782, 47128},
	{9798, 47132, 2, 659},
	{9819, 47136, 2, 659},
	{9840, 47140, 2, 659},
	{9861, 47144, 1, 661},
	{9889, 47148, 1, 662},
	{9914, 47152},
	{9929, 47156, 2, 3755},
	{50486, 47160},
	{50501, 47164, 1, 663},
	{50516, 47168},
	{50531, 47172, 1, 663},
	{10068, 47176, 10, 3757},
	{10086, 47180, 11, 676},
	{10104, 47184, 1, 687},
	{10117, 47188, 6, 688},
	{50546, 47192, 2, 3774},
	{50577, 47196, 2, 3774},
	{10195, 47200, 2, 694},
	{50760, 47204, 2, 3774},
	{50791, 47208, 2, 3774},
	{10270, 47212},
	{10288, 47216},
	{10306, 47220},
	{10324, 47224, 1, 696},
	{10352, 47228, 4, 697},
	{10670, 47360},
	{10690, 47364},
	{10710, 47368},
	{10730, 47372},
	{10750, 47376},
	{10770, 47380},
	{10790, 47384},
	{10810, 47388},
	{10830, 47392},
	{10850, 47396},
	{10870, 47400},
	{10891, 47404},
	{10912, 47408},
	{10933, 47412},
	{10954, 47416},
	{10975, 47420},
	{50608, 53300, 29, 3776},
	{50625, 55348, 29, 3776},
	{11057, 163840, 9, 719},
	{11075, 163844, 9, 3805},
	{11092, 163848, 4, 3814},
	{11106, 163852, 23, 747},
	{11125, 163856, 15, 770},
	{11145, 163860},
	{11181, 163872},
	{11201, 163876},
	{11221, 163880, 1, 788},
	{11238, 163884},
	{11253, 163888, 2, 789},
	{11277, 163892, 2, 791},
	{50642, 163900, 7, 3818},
	{11335, 163904, 8, 3825},
	{11345, 163908, 5, 3833},
	{11361, 163912},
	{11376, 163916},
	{11397, 163920},
	{11413, 163924},
	{50656, 163928, 2, 3838},
	{50670, 163932, 1, 3840},
	{11603, 163968},
	{11619, 163972, 1, 840},
	{11638, 164328, 1, 841},
	{11659, 164332, 1, 841},
	{11680, 164336, 1, 841},
	{11701, 164340, 1, 841},
	{11722, 164344},
	{11740, 164348},
	{11758, 164352, 2, 842},
	{11778, 164356, 3, 844},
	{11802, 164360, 2, 847},
	{11826, 164364, 1, 849},
	{11846, 164368, 2, 844},
	{11866, 164372, 2, 847},
	{11886, 164376, 2, 844},
	{11906, 164380, 2, 847},
	{11926, 164384, 2, 844},
	{11946, 164388, 2, 847},
	{11966, 164392, 2, 844},
	{11986, 164396, 2, 847},
	{12006, 164400, 7, 850},
	{12021, 164404, 2, 857},
	{12050, 164408, 8, 859},
	{12065, 164412, 8, 867},
	{12080, 164416, 3, 844},
	{12105, 164420, 2, 847},
	{12130, 164424},
	{12148, 164428},
	{12166, 164432, 3, 844},
	{12191, 164436, 2, 847},
	{12216, 164440, 3, 844},
	{12241, 164444, 2, 847},
	{12266, 164448, 3, 844},
	{12291, 164452, 2, 847},
	{12316, 164456, 3, 844},
	{12341, 164460, 2, 847},
	{12366, 164464, 3, 844},
	{12391, 164468, 2, 847},
	{12416, 164472, 3, 844},
	{12441, 164476, 2, 847},
	{12466, 164480, 3, 844},
	{12491, 164484, 2, 847},
	{12516, 164488, 3, 844},
	{12541, 164492, 2, 847},
	{12566, 164496, 3, 844},
	{12591, 164500, 2, 847},
	{12616, 164504, 3, 844},
	{12641, 164508, 2, 847},
	{12666, 164512, 3, 844},
	{12692, 164516, 2, 847},
	{12718, 164520, 3, 844},
	{12744, 164524, 2, 847},
	{12770, 164528, 3, 844},
	{12796, 164532, 2, 847},
	{12822, 164536, 3, 844},
	{12848, 164540, 2, 847},
	{12874, 164544, 3, 844},
	{12900, 164548, 2, 847},
	{12926, 164552, 3, 844},
	{12952, 164556, 2, 847},
	{12978, 164560},
	{12997, 164564},
	{13016, 164568},
	{13035, 164572},
	{13054, 164576},
	{13073, 164580},
	{13092, 164584},
	{13111, 164588},
	{13130, 164592},
	{13149, 164596},
	{13168, 164600},
	{13187, 164604},
	{13206, 164608},
	{13225, 164612},
	{13244, 164616},
	{13263, 164620},
	{13282, 164624},
	{13301, 164628},
	{13320, 164632},
	{13339, 164636},
	{13358, 164640},
	{13378, 164644},
	{13398, 164648},
	{13418, 164652},
	{13438, 164656},
	{13458, 164660},
	{13478, 164664},
	{13498, 164668},
	{13518, 164672},
	{13538, 164676},
	{13558, 164680},
	{13578, 164684},
	{13598, 164688, 15, 875},
	{13618, 164692, 3, 890},
	{13640, 164696, 2, 893},
	{13697, 164704, 1, 902},
	{50685, 164708, 1, 3841},
	{13728, 164712, 1, 904},
	{13796, 164864},
	{13813, 164868},
	{13830, 164872},
	{13846, 164876},
	{13900, 164884},
	{13913, 164888},
	{13928, 164892},
	{13942, 164896},
	{13996, 164908, 6, 935},
	{14015, 164912, 4, 941},
	{14033, 164916, 4, 945},
	{14054, 164924},
	{14073, 164928},
	{14093, 164932},
	{14112, 164936},
	{14132, 164940},
	{14151, 164944},
	{14171, 164948},
	{14192, 164952},
	{14214, 164956},
	{14235, 164960},
	{14257, 164964},
	{14278, 164968},
	{14300, 164972},
	{14321, 164976},
	{14343, 164980},
	{14364, 164984},
	{14386, 164988},
	{14407, 164992},
	{14429, 164996},
	{14450, 165000},
	{14472, 165004},
	{14493, 165008},
	{14515, 165012},
	{14536, 165016},
	{14558, 165020},
	{14579, 165024},
	{14601, 165028},
	{14622, 165032},
	{14644, 165036},
	{14665, 165040},
	{14687, 165044},
	{14708, 165048},
	{14730, 165052},
	{14751, 165056},
	{14773, 165060},
	{14794, 165064},
	{14816, 165068},
	{14837, 165072},
	{14859, 165076},
	{14880, 165080},
	{14902, 165084},
	{14923, 165088},
	{14945, 165092},
	{14966, 165096},
	{14988, 165100},
	{15009, 165104},
	{15031, 165108},
	{15052, 165112},
	{15074, 165116},
	{15095, 165120},
	{15117, 165124},
	{15138, 165128},
	{15160, 165132},
	{15181, 165136},
	{15203, 165140},
	{15224, 165144},
	{15246, 165148},
	{15267, 165152},
	{15289, 165156},
	{15310, 165160},
	{15332, 165164},
	{15354, 165168},
	{15377, 165172},
	{15399, 165176},
	{15422, 165180},
	{15444, 165184},
	{15467, 165188},
	{15489, 165192},
	{15512, 165196},
	{15534, 165200},
	{15557, 165204},
	{15579, 165208},
	{15602, 165212},
	{15624, 165216},
	{15647, 165220},
	{15669, 165224},
	{15692, 165228},
	{15714, 165232},
	{15737, 165236},
	{15759, 165240},
	{15782, 165244},
	{15804, 165248},
	{15827, 165252},
	{15849, 165256},
	{15872, 165260},
	{15894, 165264},
	{15917, 165268},
	{15939, 165272},
	{15962, 165276},
	{15984, 165280},
	{16007, 165284},
	{16029, 165288},
	{16052, 165292},
	{16074, 165296},
	{16097, 165300},
	{16119, 165304},
	{16142, 165308},
	{16156, 165312},
	{16170, 165316},
	{16184, 165320},
	{16198, 165324},
	{16212, 165328},
	{16226, 165332},
	{16240, 165336},
	{16254, 165340},
	{16268, 165344},
	{16282, 165348},
	{16296, 165352},
	{16310, 165356},
	{16324, 165360},
	{16338, 165364},
	{16352, 165368},
	{16366, 165372},
	{16380, 165376},
	{16394, 165380},
	{16408, 165384},
	{16422, 165388},
	{16436, 165392},
	{16450, 165396},
	{16464, 165400},
	{16501, 165444, 6, 949},
	{16521, 165448, 6, 949},
	{16541, 165452, 6, 949},
	{16561, 165456, 6, 949},
	{16581, 165460, 6, 949},
	{16601, 165464, 6, 949},
	{16621, 165468, 6, 949},
	{16641, 165472, 6, 949},
	{16661, 165476, 6, 949},
	{16681, 165480, 6, 949},
	{16701, 165484, 6, 949},
	{16722, 165488, 6, 949},
	{16743, 165492, 6, 949},
	{16764, 165496, 6, 949},
	{16785, 165500, 6, 949},
	{16806, 165504, 6, 949},
	{16827, 165508, 6, 949},
	{16848, 165512, 6, 949},
	{16869, 165516, 6, 949},
	{16890, 165520, 6, 949},
	{16911, 165524, 4, 961},
	{16932, 165528, 4, 961},
	{16953, 165532, 4, 961},
	{16974, 165536, 4, 961},
	{16995, 165540, 4, 961},
	{17016, 165544, 4, 961},
	{17037, 165548, 4, 961},
	{17058, 165552, 4, 961},
	{17079, 165556, 4, 961},
	{17100, 165560, 4, 961},
	{17121, 165564, 4, 961},
	{17142, 165568, 4, 961},
	{17163, 165572, 2, 970},
	{17181, 165580, 16, 973},
	{17198, 165584, 16, 973},
	{17216, 165588, 7, 989},
	{17237, 165592, 3, 3842},
	{17255, 165600, 7, 1002},
	{17270, 165608, 2, 694},
	{17309, 165644, 4, 1010},
	{17331, 165648, 1, 1015},
	{17351, 165652, 8, 1016},
	{17577, 165760, 9, 1063},
	{17595, 165764, 9, 1063},
	{17613, 165768, 9, 1063},
	{17631, 165772, 9, 1063},
	{17649, 165776, 9, 1063},
	{17667, 165780, 9, 1063},
	{17685, 165784, 9, 1063},
	{17703, 165788, 9, 1063},
	{17721, 165836, 1, 1072},
	{17735, 165840, 1, 1072},
	{17750, 165844},
	{17768, 165848},
	{17786, 165852},
	{17803, 165856},
	{17824, 165860, 1, 3845},
	{17840, 165864},
	{17853, 165872, 5, 1074},
	{17872, 165876},
	{17887, 165880, 1, 1082},
	{17936, 165888, 10, 1084},
	{17953, 165892, 12, 1094},
	{17961, 165896, 3, 3846},
	{17978, 165900, 12, 1110},
	{17996, 165904, 19, 1127},
	{18012, 165908, 13, 1147},
	{18031, 165912, 10, 1163},
	{18046, 165916, 26, 1173},
	{18064, 165920, 16, 1201},
	{18082, 165924, 4, 1217},
	{18106, 165928},
	{18131, 165932, 11, 1221},
	{18283, 166400, 2, 1253},
	{18300, 166404, 2, 1255},
	{18319, 166408, 1, 1257},
	{18335, 166412, 4, 1258},
	{18354, 166416, 1, 1262},
	{18375, 166420, 1, 1263},
	{18388, 166424},
	{18411, 166428},
	{18434, 166432, 1, 1264},
	{18454, 166436, 4, 3849},
	{18474, 166440, 1, 1269},
	{18495, 166444, 1, 1270},
	{18510, 166448, 6, 1271},
	{18532, 166452, 6, 1271},
	{18554, 166456, 8, 1277},
	{18580, 166460, 8, 1277},
	{18606, 166464, 15, 1285},
	{18618, 166468, 2, 1300},
	{18637, 166472, 4, 1303},
	{18655, 166476, 24, 1310},
	{18673, 166480},
	{18685, 166484, 1, 1334},
	{18699, 166488, 1, 1335},
	{18713, 166492, 1, 1336},
	{18727, 166496, 1, 1337},
	{18750, 166500, 1, 1337},
	{18773, 166504, 1, 1337},
	{18796, 166508, 5, 3853},
	{18817, 166512},
	{18828, 166516},
	{18841, 166520},
	{18858, 166524, 7, 3858},
	{18877, 166528},
	{18888, 166532, 2, 1351},
	{18907, 166536},
	{18929, 166540},
	{18951, 166544, 3, 3865},
	{18971, 166548, 1, 1357},
	{19020, 166560},
	{19045, 166564},
	{19070, 166568, 6, 1364},
	{19089, 166572, 1, 1370},
	{19112, 166576, 1, 1370},
	{19135, 166580, 1, 1371},
	{19149, 166584, 1, 1372},
	{19164, 166588, 7, 3868},
	{19181, 166592, 4, 1382},
	{19208, 166596, 4, 1386},
	{19235, 166600, 4, 1390},
	{19254, 166608},
	{19280, 166612, 1, 1394},
	{19305, 166620},
	{19333, 166624},
	{19359, 166628, 1, 1394},
	{19384, 166636},
	{19412, 166640},
	{19438, 166644, 1, 1394},
	{19463, 166652},
	{19491, 166656},
	{19517, 166660, 1, 1394},
	{19542, 166668},
	{19570, 166696},
	{19601, 166700},
	{19644, 166704, 1, 1395},
	{19682, 166712, 1, 1396},
	{19743, 166740, 6, 1404},
	{19764, 166744, 3, 1423},
	{19781, 166748, 1, 1370},
	{19802, 166752, 1, 1370},
	{19825, 166756, 1, 1370},
	{19848, 166760, 1, 1370},
	{19871, 166764, 8, 3875},
	{19884, 166768, 6, 1438},
	{19901, 166772},
	{19925, 166776, 2, 1444},
	{19955, 166780},
	{19979, 166784},
	{20009, 166788},
	{20040, 166792},
	{20069, 166796},
	{20099, 166800, 2, 1446},
	{20119, 166804, 7, 3883},
	{20138, 166808, 4, 1457},
	{20188, 166868, 8, 1461},
	{20214, 166872, 8, 1469},
	{20240, 166876, 4, 1477},
	{20256, 166880, 5, 1482},
	{20272, 166884, 3, 1488},
	{20287, 166888},
	{20310, 166892},
	{20333, 166896},
	{20356, 166900},
	{20379, 166904, 8, 1491},
	{20413, 166908, 8, 1499},
	{20447, 166912, 8, 1507},
	{20481, 166916, 8, 1515},
	{20515, 166920, 8, 1491},
	{20549, 166924, 8, 1499},
	{20583, 166928, 8, 1507},
	{20617, 166932, 8, 1515},
	{20651, 166936, 8, 1491},
	{20685, 166940, 8, 1499},
	{20719, 166944, 8, 1507},
	{20753, 166948, 8, 1515},
	{20787, 166952, 8, 1491},
	{20821, 166956, 8, 1499},
	{20855, 166960, 8, 1507},
	{20889, 166964, 8, 1515},
	{20923, 166968, 2, 1523},
	{20947, 166972, 2, 1525},
	{21090, 167000, 1, 1567},
	{21118, 167004, 1, 1568},
	{21139, 167008},
	{21154, 167012, 2, 1569},
	{21170, 167016, 1, 1571},
	{21186, 167020, 2, 3814},
	{21201, 167024, 15, 3890},
	{21216, 167028, 6, 1594},
	{21255, 167036},
	{21271, 167040, 1, 1614},
	{21293, 167044},
	{21309, 167048, 1, 1571},
	{21331, 167052},
	{21353, 167056},
	{21394, 167068},
	{21409, 167072, 2, 1569},
	{21425, 167076, 1, 1571},
	{21441, 167080, 2, 3814},
	{21456, 167084, 15, 3890},
	{21471, 167088, 6, 1594},
	{21510, 167096},
	{21526, 167100, 1, 1614},
	{21548, 167104},
	{21564, 167108, 1, 1571},
	{21586, 167112},
	{21608, 167116},
	{21649, 167128},
	{21664, 167132, 2, 1569},
	{21680, 167136, 1, 1571},
	{21696, 167140, 2, 3814},
	{21711, 167144, 15, 3890},
	{21726, 167148, 6, 1594},
	{21765, 167156},
	{21781, 167160, 1, 1614},
	{21803, 167164},
	{21819, 167168, 1, 1571},
	{21841, 167172},
	{21863, 167176},
	{21904, 167188},
	{21919, 167192, 2, 1569},
	{21935, 167196, 1, 1571},
	{21951, 167200, 2, 3814},
	{21966, 167204, 15, 3890},
	{21981, 167208, 6, 1594},
	{22020, 167216},
	{22036, 167220, 1, 1614},
	{22058, 167224},
	{22074, 167228, 1, 1571},
	{22096, 167232},
	{22118, 167236},
	{22159, 167248},
	{22174, 167252, 2, 1569},
	{22190, 167256, 1, 1571},
	{22206, 167260, 2, 3814},
	{22221, 167264, 15, 3890},
	{22236, 167268, 6, 1594},
	{22275, 167276},
	{22291, 167280, 1, 1614},
	{22313, 167284},
	{22329, 167288, 1, 1571},
	{22351, 167292},
	{22373, 167296},
	{22414, 167308},
	{22429, 167312, 2, 1569},
	{22445, 167316, 1, 1571},
	{22461, 167320, 2, 3814},
	{22476, 167324, 15, 3890},
	{22491, 167328, 6, 1594},
	{22530, 167336},
	{22546, 167340, 1, 1614},
	{22568, 167344},
	{22584, 167348, 1, 1571},
	{22606, 167352},
	{22628, 167356},
	{22669, 167368},
	{22684, 167372, 2, 1569},
	{22700, 167376, 1, 1571},
	{22716, 167380, 2, 3814},
	{22731, 167384, 15, 3890},
	{22746, 167388, 6, 1594},
	{22785, 167396},
	{22801, 167400, 1, 1614},
	{22823, 167404},
	{22839, 167408, 1, 1571},
	{22861, 167412},
	{22883, 167416},
	{22924, 167428},
	{22939, 167432, 2, 1569},
	{22955, 167436, 1, 1571},
	{22971, 167440, 2, 3814},
	{22986, 167444, 15, 3890},
	{23001, 167448, 6, 1594},
	{23040, 167456},
	{23056, 167460, 1, 1614},
	{23078, 167464},
	{23094, 167468, 1, 1571},
	{23116, 167472},
	{23138, 167476},
	{24203, 196608, 2, 3031},
	{24223, 196612, 1, 1628},
	{24243, 196616},
	{24263, 196620},
	{24283, 196624},
	{24304, 196628},
	{24325, 196632, 2, 3033},
	{24347, 196636, 1, 1630},
	{24369, 196640},
	{24399, 196644},
	{24429, 196648},
	{24458, 196652},
	{24487, 196656},
	{24517, 196660},
	{24547, 196664},
	{24576, 196668},
	{24605, 196672},
	{24635, 196676},
	{24665, 196680},
	{24694, 196684},
	{24723, 196688},
	{24753, 196692},
	{24783, 196696},
	{24812, 196700},
	{24841, 196704, 2, 3035},
	{24863, 196708, 1, 1632},
	{24885, 196712},
	{24908, 196716},
	{24931, 196720},
	{24954, 196724},
	{24977, 196728},
	{25000, 196732},
	{25023, 196736},
	{25047, 196740},
	{25071, 196744},
	{25095, 196748},
	{25119, 196752},
	{25143, 196756},
	{25167, 196760},
	{25191, 196764},
	{25215, 196768},
	{25237, 196772},
	{25259, 196776},
	{25280, 196780},
	{25301, 196784},
	{25325, 196788},
	{25349, 196792},
	{25373, 196796},
	{25397, 196800},
	{25421, 196804},
	{25549, 196860, 1, 1635},
	{25565, 196864},
	{25578, 196868},
	{25591, 196872},
	{25604, 196876},
	{25617, 196880},
	{25630, 196884},
	{25643, 196888},
	{25656, 196892},
	{25783, 196928, 2, 1636},
	{25796, 196932},
	{25809, 196936},
	{25832, 196940},
	{25855, 196944},
	{25883, 196948},
	{25911, 196952},
	{25939, 196956},
	{25967, 196960, 1, 1638},
	{25985, 196964, 3, 4077},
	{26003, 196968},
	{26018, 196972},
	{26042, 196976},
	{26066, 196980},
	{26085, 196984},
	{26104, 196988},
	{26128, 196992},
	{26152, 196996},
	{26176, 197000},
	{26200, 197028, 2, 3040},
	{26218, 197032, 1, 1644},
	{26236, 197036},
	{26254, 197040},
	{26272, 197044, 2, 3043},
	{26290, 197048, 1, 1647},
	{26308, 197052},
	{26326, 197056, 2, 1649},
	{26345, 197060, 5, 1651},
	{26364, 197072},
	{26388, 197076, 2, 1649},
	{26408, 197080, 5, 1651},
	{26428, 197084, 8, 4080},
	{26447, 197088, 8, 4080},
	{26465, 197092, 1, 1663},
	{26482, 197100, 1, 1664},
	{26503, 197104, 23, 3051},
	{26517, 197108},
	{26531, 197112},
	{26545, 197116, 4, 3074},
	{26561, 197120},
	{26580, 197124, 1, 1680},
	{26602, 197128},
	{26621, 197132, 1, 1681},
	{26643, 197136, 9, 3080},
	{26661, 197140},
	{26681, 197144, 1, 1680},
	{26704, 197148},
	{26724, 197152, 1, 1681},
	{26747, 197156, 9, 3080},
	{26766, 197160, 5, 3089},
	{26778, 197164, 2, 1696},
	{26795, 197168, 1, 1698},
	{26812, 197172, 1, 1699},
	{26830, 197176, 5, 2646},
	{26850, 197180, 1, 1704},
	{26867, 197184},
	{26883, 197188, 1, 1706},
	{26896, 197192, 1, 1707},
	{26910, 197196, 1, 1708},
	{26924, 197200, 1, 1709},
	{26946, 197204, 1, 1710},
	{26966, 197208, 1, 1711},
	{26988, 197212, 1, 1712},
	{27008, 197216, 1, 1707},
	{27025, 197220, 1, 1708},
	{27042, 197224},
	{27301, 197388, 1, 1721},
	{27320, 197392, 1, 1722},
	{27339, 197396, 1, 1723},
	{27356, 197400, 1, 1724},
	{27374, 197404, 1, 1725},
	{27392, 197408, 1, 1726},
	{27408, 197412, 1, 1727},
	{27426, 197416, 1, 1728},
	{27444, 197420, 1, 1729},
	{27460, 197424, 1, 1724},
	{27475, 197428, 1, 1725},
	{27490, 197432, 1, 1726},
	{27503, 197436, 1, 1727},
	{27518, 197440, 1, 1728},
	{27533, 197444, 1, 1729},
	{27546, 197448, 1, 1730},
	{27560, 197452, 1, 1731},
	{27574, 197456, 1, 1732},
	{27586, 197460, 4, 4088},
	{27609, 197464, 4, 4092},
	{28309, 198656, 6, 2946},
	{48507, 198912},
	{48526, 198916},
	{28370, 198920, 1, 3329},
	{28389, 198924, 1, 3330},
	{28404, 198928},
	{28437, 198932},
	{28470, 198936},
	{28503, 198940},
	{28593, 198960},
	{28609, 198964},
	{49020, 198968, 1, 1785},
	{49052, 198972, 2, 1786},
	{49073, 198976},
	{29013, 199168, 1, 1809},
	{29038, 199172, 2, 1810},
	{29063, 199184, 2, 1812},
	{29089, 199188, 2, 1812},
	{29115, 199192, 2, 1812},
	{29141, 199212, 2, 1812},
	{29167, 199296, 2, 1814},
	{29195, 199300, 1, 1816},
	{29219, 199304, 1, 1817},
	{29243, 199308, 1, 1818},
	{29276, 199312, 1, 1818},
	{29304, 199328, 2, 1814},
	{29333, 199332, 1, 1816},
	{29358, 199336, 1, 1817},
	{29383, 199340, 1, 1818},
	{29417, 199344, 1, 1818},
	{29446, 199360, 2, 1814},
	{29470, 199364, 1, 1816},
	{29490, 199368, 1, 1817},
	{29510, 199372, 1, 1818},
	{29539, 199376, 1, 1818},
	{29563, 199936},
	{29590, 199940},
	{29617, 199944},
	{29644, 199948},
	{29779, 199968, 3, 3453},
	{29804, 200192},
	{29823, 200196, 1, 840},
	{29845, 200448},
	{29869, 200452, 1, 1828},
	{29892, 200456},
	{29916, 200460, 1, 1828},
	{29939, 200464},
	{29963, 200468, 1, 1828},
	{29986, 200472},
	{30010, 200476, 1, 1828},
	{30033, 200696},
	{30052, 200700, 1, 1828},
	{30070, 200704},
	{30082, 200708},
	{30094, 200712},
	{30112, 200716},
	{30131, 200720},
	{30149, 200724},
	{30161, 200728},
	{30173, 200732},
	{30191, 200736},
	{30209, 200740},
	{30228, 200744, 4, 4096},
	{30242, 200748, 2, 1833},
	{30260, 200752, 2, 1835},
	{30274, 200756, 2, 1837},
	{30288, 200760, 2, 1839},
	{30305, 200764, 2, 1841},
	{30322, 200768},
	{30335, 200772, 2, 1843},
	{30347, 200776},
	{30361, 200780},
	{30377, 200784},
	{30391, 200788},
	{30407, 200792},
	{30422, 200796},
	{30439, 200800},
	{30454, 200804},
	{30471, 200808, 2, 1845},
	{30493, 200812, 9, 4100},
	{30510, 200816, 2, 1857},
	{30531, 200820, 2, 1859},
	{30543, 200824},
	{30558, 200828, 6, 1861},
	{30573, 200832, 2, 1867},
	{30587, 200836},
	{30700, 212992},
	{30720, 212996},
	{30740, 213000},
	{30760, 213004},
	{30780, 213008},
	{30800, 213012},
	{30820, 213016},
	{30840, 213020},
	{30860, 213024},
	{30880, 213028},
	{30900, 213032},
	{30920, 213036},
	{31009, 213248},
	{31030, 213252},
	{31051, 213260},
	{31072, 213264},
	{31093, 213268},
	{31117, 213272},
	{31141, 213276},
	{31165, 213280},
	{31189, 213284},
	{31213, 213288},
	{31237, 213292},
	{31261, 213296},
	{50822, 213504},
	{50841, 213508},
	{50860, 213512},
	{50879, 213516},
	{50898, 213520},
	{50917, 213524},
	{50936, 213528},
	{50955, 213532},
	{48217, 213536},
	{48236, 213540},
	{48255, 213544},
	{48274, 213548},
	{48293, 213552},
	{48312, 213556},
	{48331, 213560},
	{48350, 213564},
	{48808, 213568},
	{48828, 213572},
	{48848, 213576},
	{48868, 213580},
	{48888, 213584},
	{48908, 213588},
	{48928, 213592},
	{48948, 213596},
	{31745, 214016},
	{31767, 214020, 1, 1869},
	{31789, 214024},
	{31811, 214028, 1, 1869},
	{31833, 214032},
	{31855, 214036, 1, 1869},
	{31877, 214040},
	{31899, 214044, 1, 1869},
	{31921, 214272},
	{31943, 214276},
	{31965, 214280},
	{31987, 214284},
	{32009, 214288},
	{32031, 214292},
	{32053, 214296},
	{32075, 214300},
	{32097, 214304},
	{32119, 214308},
	{32141, 214312},
	{32163, 214316},
	{32185, 214320},
	{32207, 214324},
	{32229, 214328},
	{32251, 214332},
	{32273, 214528},
	{32293, 214532},
	{32313, 214536},
	{32333, 214540},
	{32353, 214544},
	{32373, 214548},
	{32393, 214552},
	{32413, 214556},
	{32433, 214560},
	{32453, 214564},
	{32473, 214568},
	{32493, 214572},
	{32513, 214784},
	{32532, 214788},
	{32551, 214792},
	{32570, 214796},
	{32589, 214800},
	{32608, 214804},
	{32627, 214808},
	{32646, 214812},
	{32665, 214816},
	{32684, 214820},
	{32703, 214824},
	{32722, 214828},
	{32741, 214832},
	{32760, 214836},
	{32779, 214840},
	{32798, 214844},
	{32817, 214848},
	{32836, 214852},
	{32855, 214856},
	{32874, 214860},
	{32893, 214864},
	{32913, 214868},
	{32933, 214872},
	{32953, 214876},
	{32973, 214880},
	{32993, 214884},
	{33013, 214888},
	{33033, 214892},
	{33053, 214896},
	{33073, 214900},
	{33093, 214904},
	{33113, 214908},
	{33133, 215296},
	{33152, 215300},
	{33171, 215304},
	{33190, 215308},
	{33209, 215312},
	{33228, 215316},
	{33247, 215320},
	{33266, 215324},
	{33327, 215552},
	{33347, 215556},
	{33367, 215560},
	{33387, 215564},
	{33407, 215568},
	{33427, 215572},
	{33447, 215576},
	{33467, 215580},
	{33487, 215808},
	{33506, 215812},
	{33525, 215816},
	{33544, 215820},
	{33563, 216064},
	{33582, 216068},
	{33601, 216072},
	{33620, 216076},
	{33639, 216320},
	{33659, 216324},
	{33679, 216328},
	{33699, 216332},
	{33719, 216336},
	{33739, 216340},
	{33759, 216344},
	{33779, 216348},
	{50974, 216576},
	{50994, 216580},
	{51014, 216584},
	{51034, 216588},
	{51054, 216592},
	{51074, 216596},
	{51094, 216600},
	{51114, 216604},
	{51134, 216640},
	{51154, 216644},
	{51174, 216648},
	{51194, 216652},
	{51214, 216656},
	{51234, 216660},
	{51254, 216664},
	{51274, 216668},
	{51294, 216704},
	{51314, 216708},
	{51334, 216712},
	{51354, 216716},
	{51374, 216720},
	{51394, 216724},
	{51414, 216728},
	{51434, 216732},
	{34631, 217112},
	{34650, 217116},
	{34669, 217120},
	{34688, 217124},
	{34707, 217128},
	{34726, 217132},
	{34745, 217136},
	{34764, 217140},
	{34783, 217344},
	{34802, 217348},
	{34821, 217352},
	{34840, 217356},
	{34859, 217360},
	{34878, 217364},
	{34897, 217368},
	{34916, 217372},
	{34935, 217600},
	{34955, 217604},
	{34975, 217608},
	{34995, 217612},
	{36317, 221184, 1, 1903},
	{36341, 221188, 2, 4109},
	{36366, 221192, 3, 4111},
	{36390, 221196, 1, 1903},
	{36414, 221200, 2, 4109},
	{36439, 221204, 1, 1903},
	{36463, 221208, 2, 4109},
	{36488, 221212, 3, 4111},
	{36512, 221216, 4, 1881},
	{36528, 221220, 3, 4111},
	{36695, 221248},
	{36710, 221252, 1, 1818},
	{36733, 221256},
	{36756, 221260},
	{36774, 221264, 2, 1897},
	{36792, 221268, 4, 1899},
	{36812, 221440, 19, 2989},
	{36837, 221444, 19, 2989},
	{36862, 221448, 12, 3008},
	{36890, 221452, 12, 3008},
	{36918, 221456, 12, 3008},
	{36946, 221460, 12, 3008},
	{51454, 221696, 2, 3287},
	{51477, 221700, 2, 3287},
	{51500, 221704, 2, 3287},
	{51523, 221708, 2, 3287},
	{48125, 221712, 5, 1957},
	{48148, 221716, 2, 3287},
	{48171, 221720, 2, 3287},
	{48194, 221724, 2, 3287},
	{51546, 221728, 4, 1962},
	{48712, 221744, 5, 1957},
	{48736, 221748, 5, 1957},
	{48760, 221752, 2, 3287},
	{48784, 221756, 2, 3287},
	{51570, 221760, 4, 1962},
	{51595, 221764, 4, 1962},
	{48686, 221776, 1, 3328},
	{37404, 222208, 3, 1957},
	{37430, 222212, 2, 1877},
	{37457, 222216, 3, 1957},
	{37483, 222220, 2, 1877},
	{37510, 222224, 2, 2013},
	{37563, 222228, 2, 2013},
	{37616, 222464, 3, 1957},
	{37642, 222468, 2, 1877},
	{37669, 222472, 1, 1872},
	{37695, 222476, 1, 1872},
	{37721, 222480, 1, 1872},
	{37747, 222484, 1, 1872},
	{37773, 222488, 1, 1872},
	{37799, 222492, 1, 1872},
	{37825, 222496, 1, 1872},
	{37851, 222720, 3, 1957},
	{37875, 222724, 3, 1957},
	{37899, 222728, 3, 1957},
	{37923, 222732, 3, 1957},
	{37947, 222736, 2, 1877},
	{37972, 222740, 2, 1877},
	{37997, 222744, 2, 1877},
	{38022, 222748, 2, 1877},
	{38047, 222752, 1, 2001},
	{38071, 222756, 1, 2001},
	{38095, 222760, 8, 1966},
	{38116, 222976, 6, 4114},
	{38139, 222980, 6, 4114},
	{38162, 222984, 6, 4114},
	{38185, 222988, 6, 4114},
	{38208, 222992, 6, 4114},
	{38231, 222996, 6, 4114},
	{38254, 223000, 6, 4114},
	{38277, 223004, 6, 4114},
	{38300, 223008, 6, 4114},
	{38323, 223012, 6, 4114},
	{38346, 223016, 6, 4114},
	{38370, 223020, 6, 4114},
	{38394, 223024, 6, 4114},
	{38418, 223028, 6, 4114},
	{38442, 223032, 6, 4114},
	{38466, 223036, 6, 4114},
	{38490, 223104, 9, 3469},
	{51620, 223108, 2, 3518},
	{38510, 223112, 1, 1987},
	{38605, 223488, 3, 1996},
	{38628, 223492, 3, 1996},
	{38651, 223496, 3, 1996},
	{38674, 223500, 3, 1996},
	{38697, 223504, 2, 1999},
	{38721, 223508, 2, 1999},
	{38745, 223744, 3, 1996},
	{38769, 223748, 3, 1996},
	{38793, 223752, 3, 1996},
	{38817, 223756, 3, 1996},
	{38841, 223760, 2, 1999},
	{38866, 224000, 5, 2001},
	{38889, 224004, 4, 2006},
	{38913, 224008, 5, 2001},
	{38936, 224256, 5, 2001},
	{38959, 224260, 4, 2006},
	{38983, 224264, 5, 2001},
	{39006, 224512, 5, 1957},
	{39030, 224516, 4, 1962},
	{39055, 224520, 5, 1957},
	{39079, 224524, 4, 1962},
	{39104, 224528, 3, 2013},
	{39128, 224532, 3, 2013},
	{51640, 224768, 5, 1957},
	{51664, 224772, 4, 1951},
	{51689, 224776, 5, 1957},
	{51713, 224780, 4, 1951},
	{51738, 224784, 3, 2013},
	{51762, 224788, 3, 2013},
	{51786, 224832, 5, 1957},
	{51810, 224836, 4, 1951},
	{51835, 224840, 5, 1957},
	{51859, 224844, 4, 1951},
	{51884, 224848, 3, 2013},
	{51908, 224852, 3, 2013},
	{51932, 224896, 5, 1957},
	{51956, 224900, 4, 1951},
	{51981, 224904, 3, 2013},
	{52005, 224908, 3, 2013},
	{52029, 224912, 3, 2013},
	{39829, 225280, 12, 2016},
	{39851, 225284, 5, 2028},
	{39874, 225288, 4, 2033},
	{39898, 225292, 2, 2037},
	{39921, 225296, 2, 2037},
	{39944, 225300, 2, 2037},
	{39967, 225536, 5, 1957},
	{39990, 225540, 4, 1962},
	{40014, 225544, 5, 1957},
	{40037, 225548, 4, 1962},
	{40061, 225552, 5, 1957},
	{40084, 225560, 5, 1957},
	{40107, 225792, 4, 2039},
	{40128, 225796},
	{40157, 225800, 2, 2043},
	{40186, 225804},
	{40212, 225808, 7, 2045},
	{40286, 225812},
	{40309, 225816},
	{52053, 225820, 2, 4120},
	{52086, 225824, 2, 4120},
	{52119, 225828, 2, 4120},
	{52152, 225832, 2, 4120},
	{52184, 225836, 2, 4120},
	{52216, 225840, 2, 4120},
	{52248, 225844, 2, 4120},
	{52281, 225848, 2, 4120},
	{52313, 225856, 2, 4120},
	{52345, 225860, 2, 4120},
	{52378, 225864, 2, 4120},
	{52411, 225868, 2, 4120},
	{52444, 225872, 2, 4120},
	{52476, 225876, 2, 4120},
	{52508, 225880, 2, 4120},
	{52541, 225884, 2, 4120},
	{52574, 225888, 2, 4120},
	{52607, 225892, 2, 4120},
	{52640, 225896, 2, 4120},
	{40332, 225900},
	{40359, 225904},
	{40241, 225908},
	{40260, 225912},
	{52672, 225916, 2, 4120},
	{52706, 225920, 2, 4120},
	{52740, 225924, 2, 4120},
	{52774, 225928, 2, 4120},
	{41022, 226048, 2, 2119},
	{41039, 226052, 1, 2121},
	{41063, 226056, 1, 2121},
	{195, 880, 4, 2156},
	{42808, 881},
	{26631, 882},
	{42820, 1008},
	{42831, 1009},
	{26819, 1010, 3, 2160},
	{42842, 1040, 1, 2163},
	{42855, 1041, 5, 4122},
	{42868, 1042, 1, 2169},
	{42881, 1043, 1, 1681},
	{26653, 1045, 9, 3914},
	{42909, 1280, 6, 4127},
	{42924, 1281},
	{26590, 1282},
	{42808, 1283},
	{26631, 1284},
};

static const struct si_reg gfx8_reg_table[] = {
	{974, 68, 10, 4133},
	{987, 72, 23, 4143},
	{1002, 76, 4, 4166},
	{46947, 80, 11, 3939},
	{1039, 84, 4, 2800},
	{1057, 88, 2, 2804},
	{1075, 92, 6, 4170},
	{1090, 96},
	{1104, 100, 1, 2810},
	{1118, 104},
	{46961, 108},
	{46978, 112, 13, 4176},
	{1135, 116, 5, 4189},
	{46994, 2480},
	{47009, 2484, 1, 2824},
	{47024, 2488},
	{47039, 2492, 1, 2824},
	{1273, 2496},
	{1287, 2500},
	{1301, 2504},
	{1315, 2508},
	{1329, 2512},
	{1343, 2516},
	{1357, 2520},
	{1371, 2524},
	{1385, 2528},
	{1399, 2532},
	{1413, 2536},
	{1428, 2540},
	{1503, 2544},
	{1514, 2552},
	{1530, 2556},
	{47054, 3660, 21, 2825},
	{47067, 3664, 20, 2846},
	{47079, 3668, 16, 2866},
	{1618, 32776, 18, 4194},
	{1631, 32784, 24, 2904},
	{1643, 32788, 11, 2928},
	{1659, 32792, 11, 2928},
	{1688, 32824, 11, 2928},
	{1704, 32828, 11, 2928},
	{1720, 33296, 15, 4212},
	{1734, 33300, 28, 204},
	{1751, 33304, 14, 4227},
	{1772, 33308, 21, 4241},
	{1786, 33312, 31, 4022},
	{1803, 33316, 9, 4262},
	{1842, 33324, 1, 329},
	{1865, 33344, 1, 330},
	{1886, 33348},
	{1947, 33436, 1, 342},
	{49728, 36416},
	{2351, 36608},
	{2369, 36612, 4, 383},
	{2387, 36616},
	{2405, 36620, 14, 4271},
	{3306, 36624},
	{3324, 36628, 5, 4285},
	{3342, 36632, 4, 3587},
	{3360, 36636, 11, 3591},
	{3378, 36640, 2, 3602},
	{3396, 36644, 2, 3604},
	{3414, 36648, 8, 4290},
	{3432, 36652},
	{2423, 36656, 14, 4298},
	{2441, 36660, 4, 411},
	{2459, 36664, 10, 4312},
	{2477, 36668, 3, 3632},
	{2495, 37120, 6, 429},
	{2511, 39160, 9, 3635},
	{2526, 39184, 5, 3645},
	{2540, 39188, 5, 3645},
	{2554, 39192, 5, 3645},
	{2568, 39196, 5, 3645},
	{2582, 39200, 5, 3645},
	{2596, 39204, 5, 3645},
	{2610, 39208, 5, 3645},
	{2624, 39212, 5, 3645},
	{2638, 39216, 5, 3645},
	{2652, 39220, 5, 3645},
	{2666, 39224, 5, 3645},
	{2681, 39228, 5, 3645},
	{2696, 39232, 5, 3645},
	{2711, 39236, 5, 3645},
	{2726, 39240, 5, 3645},
	{2741, 39244, 5, 3645},
	{2756, 39248, 5, 3645},
	{2771, 39252, 5, 3645},
	{2786, 39256, 5, 3645},
	{2801, 39260, 5, 3645},
	{2816, 39264, 5, 3645},
	{2831, 39268, 5, 3645},
	{2846, 39272, 5, 3645},
	{2861, 39276, 5, 3645},
	{2876, 39280, 5, 3645},
	{2891, 39284, 5, 3645},
	{2906, 39288, 5, 3645},
	{2921, 39292, 5, 3645},
	{2936, 39296, 5, 3645},
	{2951, 39300, 5, 3645},
	{2966, 39304, 5, 3645},
	{2981, 39308, 5, 3645},
	{2996, 39312, 4, 448},
	{3015, 39316, 4, 448},
	{3034, 39320, 4, 448},
	{3053, 39324, 4, 448},
	{3072, 39328, 4, 448},
	{3091, 39332, 4, 448},
	{3110, 39336, 4, 448},
	{3129, 39340, 4, 448},
	{3148, 39344, 4, 448},
	{3167, 39348, 4, 448},
	{3186, 39352, 4, 448},
	{3206, 39356, 4, 448},
	{3226, 39360, 4, 448},
	{3246, 39364, 4, 448},
	{3266, 39368, 4, 448},
	{3286, 39372, 4, 448},
	{49962, 45056},
	{49983, 45060, 1, 491},
	{50004, 45064},
	{50025, 45068, 1, 491},
	{3499, 45084, 3, 488},
	{3523, 45088},
	{3544, 45092, 1, 491},
	{3565, 45096, 11, 3650},
	{3589, 45100, 6, 503},
	{3613, 45104},
	{3639, 45108},
	{3665, 45112},
	{3691, 45116},
	{3717, 45120},
	{3743, 45124},
	{3769, 45128},
	{3795, 45132},
	{3821, 45136},
	{3847, 45140},
	{3873, 45144},
	{3900, 45148},
	{3927, 45152},
	{3954, 45156},
	{3981, 45160},
	{4008, 45164},
	{50046, 45312},
	{50067, 45316, 1, 491},
	{50088, 45320},
	{50109, 45324, 1, 491},
	{4680, 45336, 3, 488},
	{4704, 45340, 1, 527},
	{4729, 45344},
	{4750, 45348, 1, 491},
	{4771, 45352, 12, 3667},
	{4795, 45356, 11, 4322},
	{4819, 45360},
	{4845, 45364},
	{4871, 45368},
	{4897, 45372},
	{4923, 45376},
	{4949, 45380},
	{4975, 45384},
	{5001, 45388},
	{5027, 45392},
	{5053, 45396},
	{5079, 45400},
	{5106, 45404},
	{5133, 45408},
	{5160, 45412},
	{5187, 45416},
	{5214, 45420},
	{5864, 45552, 6, 563},
	{5891, 45556, 5, 569},
	{50130, 45568},
	{50151, 45572, 1, 491},
	{50172, 45576},
	{50193, 45580, 1, 491},
	{6079, 45596, 4, 576},
	{6103, 45600},
	{6124, 45604, 1, 491},
	{6145, 45608, 11, 3689},
	{6169, 45612, 4, 554},
	{6193, 45616},
	{6219, 45620},
	{6245, 45624},
	{6271, 45628},
	{6297, 45632},
	{6323, 45636},
	{6349, 45640},
	{6375, 45644},
	{6401, 45648},
	{6427, 45652},
	{6453, 45656},
	{6480, 45660},
	{6507, 45664},
	{6534, 45668},
	{6561, 45672},
	{6588, 45676},
	{7223, 45808, 6, 563},
	{50214, 45824},
	{50235, 45828, 1, 491},
	{50256, 45832},
	{50277, 45836, 1, 491},
	{7250, 45852, 4, 576},
	{7274, 45856},
	{7295, 45860, 1, 491},
	{7316, 45864, 12, 3667},
	{7340, 45868, 6, 563},
	{7364, 45872},
	{7390, 45876},
	{7416, 45880},
	{7442, 45884},
	{7468, 45888},
	{7494, 45892},
	{7520, 45896},
	{7546, 45900},
	{7572, 45904},
	{7598, 45908},
	{7624, 45912},
	{7651, 45916},
	{7678, 45920},
	{7705, 45924},
	{7732, 45928},
	{7759, 45932},
	{7786, 46068, 5, 569},
	{50298, 46080},
	{50319, 46084, 1, 491},
	{50340, 46088},
	{50361, 46092, 1, 491},
	{7974, 46108, 3, 612},
	{7998, 46112},
	{8019, 46116, 1, 491},
	{8040, 46120, 10, 3710},
	{8064, 46124, 6, 628},
	{8088, 46128},
	{8114, 46132},
	{8140, 46136},
	{8166, 46140},
	{8192, 46144},
	{8218, 46148},
	{8244, 46152},
	{8270, 46156},
	{8296, 46160},
	{8322, 46164},
	{8348, 46168},
	{8375, 46172},
	{8402, 46176},
	{8429, 46180},
	{8456, 46184},
	{8483, 46188},
	{9118, 46324, 5, 569},
	{50382, 46336},
	{50403, 46340, 1, 491},
	{50424, 46344},
	{50445, 46348, 1, 491},
	{9145, 46364, 4, 576},
	{9169, 46368},
	{9190, 46372, 1, 491},
	{9211, 46376, 11, 3726},
	{9235, 46380, 5, 569},
	{9259, 46384},
	{9285, 46388},
	{9311, 46392},
	{9337, 46396},
	{9363, 46400},
	{9389, 46404},
	{9415, 46408},
	{9441, 46412},
	{9467, 46416},
	{9493, 46420},
	{9519, 46424},
	{9546, 46428},
	{9573, 46432},
	{9600, 46436},
	{9627, 46440},
	{9654, 46444},
	{9681, 47104, 12, 3742},
	{9708, 47108},
	{9722, 47112},
	{9736, 47116},
	{9750, 47120},
	{9766, 47124},
	{9782, 47128},
	{9798, 47132, 2, 659},
	{9819, 47136, 2, 659},
	{9840, 47140, 2, 659},
	{9861, 47144, 1, 661},
	{9889, 47148, 1, 662},
	{9914, 47152},
	{9929, 47156, 2, 3755},
	{50486, 47160},
	{50501, 47164, 1, 663},
	{50516, 47168},
	{50531, 47172, 1, 663},
	{10068, 47176, 10, 3757},
	{10086, 47180, 11, 676},
	{10104, 47184, 1, 687},
	{10117, 47188, 6, 688},
	{50546, 47192, 2, 3774},
	{50577, 47196, 2, 3774},
	{10195, 47200, 2, 694},
	{50760, 47204, 2, 3774},
	{50791, 47208, 2, 3774},
	{10270, 47212},
	{10288, 47216},
	{10306, 47220},
	{10324, 47224, 1, 696},
	{10352, 47228, 5, 697},
	{10374, 47232},
	{10394, 47236},
	{10577, 47240, 3, 713},
	{10594, 47244},
	{10623, 47248, 1, 716},
	{52808, 47252, 2, 4333},
	{10670, 47360},
	{10690, 47364},
	{10710, 47368},
	{10730, 47372},
	{10750, 47376},
	{10770, 47380},
	{10790, 47384},
	{10810, 47388},
	{10830, 47392},
	{10850, 47396},
	{10870, 47400},
	{10891, 47404},
	{10912, 47408},
	{10933, 47412},
	{10954, 47416},
	{10975, 47420},
	{11041, 47612},
	{50608, 53300, 29, 3776},
	{50625, 55348, 29, 3776},
	{11057, 163840, 10, 719},
	{11075, 163844, 9, 3805},
	{11092, 163848, 4, 3814},
	{11106, 163852, 23, 747},
	{11125, 163856, 15, 770},
	{11145, 163860},
	{11181, 163872},
	{11201, 163876},
	{11221, 163880, 1, 788},
	{11238, 163884},
	{11253, 163888, 2, 789},
	{11277, 163892, 2, 791},
	{50642, 163900, 7, 3818},
	{11335, 163904, 10, 4335},
	{11345, 163908, 6, 4345},
	{11361, 163912},
	{11376, 163916},
	{11397, 163920},
	{11413, 163924},
	{50656, 163928, 2, 3838},
	{50670, 163932, 1, 3840},
	{11603, 163968},
	{11619, 163972, 1, 840},
	{11638, 164328, 1, 841},
	{11659, 164332, 1, 841},
	{11680, 164336, 1, 841},
	{11701, 164340, 1, 841},
	{11722, 164344},
	{11740, 164348},
	{11758, 164352, 2, 842},
	{11778, 164356, 3, 844},
	{11802, 164360, 2, 847},
	{11826, 164364, 1, 849},
	{11846, 164368, 2, 844},
	{11866, 164372, 2, 847},
	{11886, 164376, 2, 844},
	{11906, 164380, 2, 847},
	{11926, 164384, 2, 844},
	{11946, 164388, 2, 847},
	{11966, 164392, 2, 844},
	{11986, 164396, 2, 847},
	{12006, 164400, 7, 850},
	{12021, 164404, 2, 857},
	{12050, 164408, 8, 859},
	{12065, 164412, 8, 867},
	{12080, 164416, 3, 844},
	{12105, 164420, 2, 847},
	{12130, 164424},
	{12148, 164428},
	{12166, 164432, 3, 844},
	{12191, 164436, 2, 847},
	{12216, 164440, 3, 844},
	{12241, 164444, 2, 847},
	{12266, 164448, 3, 844},
	{12291, 164452, 2, 847},
	{12316, 164456, 3, 844},
	{12341, 164460, 2, 847},
	{12366, 164464, 3, 844},
	{12391, 164468, 2, 847},
	{12416, 164472, 3, 844},
	{12441, 164476, 2, 847},
	{12466, 164480, 3, 844},
	{12491, 164484, 2, 847},
	{12516, 164488, 3, 844},
	{12541, 164492, 2, 847},
	{12566, 164496, 3, 844},
	{12591, 164500, 2, 847},
	{12616, 164504, 3, 844},
	{12641, 164508, 2, 847},
	{12666, 164512, 3, 844},
	{12692, 164516, 2, 847},
	{12718, 164520, 3, 844},
	{12744, 164524, 2, 847},
	{12770, 164528, 3, 844},
	{12796, 164532, 2, 847},
	{12822, 164536, 3, 844},
	{12848, 164540, 2, 847},
	{12874, 164544, 3, 844},
	{12900, 164548, 2, 847},
	{12926, 164552, 3, 844},
	{12952, 164556, 2, 847},
	{12978, 164560},
	{12997, 164564},
	{13016, 164568},
	{13035, 164572},
	{13054, 164576},
	{13073, 164580},
	{13092, 164584},
	{13111, 164588},
	{13130, 164592},
	{13149, 164596},
	{13168, 164600},
	{13187, 164604},
	{13206, 164608},
	{13225, 164612},
	{13244, 164616},
	{13263, 164620},
	{13282, 164624},
	{13301, 164628},
	{13320, 164632},
	{13339, 164636},
	{13358, 164640},
	{13378, 164644},
	{13398, 164648},
	{13418, 164652},
	{13438, 164656},
	{13458, 164660},
	{13478, 164664},
	{13498, 164668},
	{13518, 164672},
	{13538, 164676},
	{13558, 164680},
	{13578, 164684},
	{13598, 164688, 15, 875},
	{13618, 164692, 3, 890},
	{13640, 164696, 2, 893},
	{13697, 164704, 1, 902},
	{50685, 164708, 1, 3841},
	{13728, 164712, 1, 904},
	{13796, 164864},
	{13813, 164868},
	{13830, 164872},
	{13846, 164876},
	{13900, 164884},
	{13913, 164888},
	{13928, 164892},
	{13942, 164896},
	{13957, 164900, 3, 4351},
	{13996, 164908, 6, 935},
	{14015, 164912, 4, 941},
	{14033, 164916, 4, 945},
	{14054, 164924},
	{14073, 164928},
	{14093, 164932},
	{14112, 164936},
	{14132, 164940},
	{14151, 164944},
	{14171, 164948},
	{14192, 164952},
	{14214, 164956},
	{14235, 164960},
	{14257, 164964},
	{14278, 164968},
	{14300, 164972},
	{14321, 164976},
	{14343, 164980},
	{14364, 164984},
	{14386, 164988},
	{14407, 164992},
	{14429, 164996},
	{14450, 165000},
	{14472, 165004},
	{14493, 165008},
	{14515, 165012},
	{14536, 165016},
	{14558, 165020},
	{14579, 165024},
	{14601, 165028},
	{14622, 165032},
	{14644, 165036},
	{14665, 165040},
	{14687, 165044},
	{14708, 165048},
	{14730, 165052},
	{14751, 165056},
	{14773, 165060},
	{14794, 165064},
	{14816, 165068},
	{14837, 165072},
	{14859, 165076},
	{14880, 165080},
	{14902, 165084},
	{14923, 165088},
	{14945, 165092},
	{14966, 165096},
	{14988, 165100},
	{15009, 165104},
	{15031, 165108},
	{15052, 165112},
	{15074, 165116},
	{15095, 165120},
	{15117, 165124},
	{15138, 165128},
	{15160, 165132},
	{15181, 165136},
	{15203, 165140},
	{15224, 165144},
	{15246, 165148},
	{15267, 165152},
	{15289, 165156},
	{15310, 165160},
	{15332, 165164},
	{15354, 165168},
	{15377, 165172},
	{15399, 165176},
	{15422, 165180},
	{15444, 165184},
	{15467, 165188},
	{15489, 165192},
	{15512, 165196},
	{15534, 165200},
	{15557, 165204},
	{15579, 165208},
	{15602, 165212},
	{15624, 165216},
	{15647, 165220},
	{15669, 165224},
	{15692, 165228},
	{15714, 165232},
	{15737, 165236},
	{15759, 165240},
	{15782, 165244},
	{15804, 165248},
	{15827, 165252},
	{15849, 165256},
	{15872, 165260},
	{15894, 165264},
	{15917, 165268},
	{15939, 165272},
	{15962, 165276},
	{15984, 165280},
	{16007, 165284},
	{16029, 165288},
	{16052, 165292},
	{16074, 165296},
	{16097, 165300},
	{16119, 165304},
	{16142, 165308},
	{16156, 165312},
	{16170, 165316},
	{16184, 165320},
	{16198, 165324},
	{16212, 165328},
	{16226, 165332},
	{16240, 165336},
	{16254, 165340},
	{16268, 165344},
	{16282, 165348},
	{16296, 165352},
	{16310, 165356},
	{16324, 165360},
	{16338, 165364},
	{16352, 165368},
	{16366, 165372},
	{16380, 165376},
	{16394, 165380},
	{16408, 165384},
	{16422, 165388},
	{16436, 165392},
	{16450, 165396},
	{16464, 165400},
	{16501, 165444, 12, 949},
	{16521, 165448, 12, 949},
	{16541, 165452, 12, 949},
	{16561, 165456, 12, 949},
	{16581, 165460, 12, 949},
	{16601, 165464, 12, 949},
	{16621, 165468, 12, 949},
	{16641, 165472, 12, 949},
	{16661, 165476, 12, 949},
	{16681, 165480, 12, 949},
	{16701, 165484, 12, 949},
	{16722, 165488, 12, 949},
	{16743, 165492, 12, 949},
	{16764, 165496, 12, 949},
	{16785, 165500, 12, 949},
	{16806, 165504, 12, 949},
	{16827, 165508, 12, 949},
	{16848, 165512, 12, 949},
	{16869, 165516, 12, 949},
	{16890, 165520, 12, 949},
	{16911, 165524, 9, 961},
	{16932, 165528, 9, 961},
	{16953, 165532, 9, 961},
	{16974, 165536, 9, 961},
	{16995, 165540, 9, 961},
	{17016, 165544, 9, 961},
	{17037, 165548, 9, 961},
	{17058, 165552, 9, 961},
	{17079, 165556, 9, 961},
	{17100, 165560, 9, 961},
	{17121, 165564, 9, 961},
	{17142, 165568, 9, 961},
	{17163, 165572, 2, 970},
	{17181, 165580, 16, 973},
	{17198, 165584, 16, 973},
	{17216, 165588, 7, 989},
	{17237, 165592, 3, 3842},
	{17255, 165600, 7, 1002},
	{17270, 165608, 2, 694},
	{17309, 165644, 4, 1010},
	{17331, 165648, 1, 1015},
	{17351, 165652, 8, 1016},
	{17577, 165760, 9, 1063},
	{17595, 165764, 9, 1063},
	{17613, 165768, 9, 1063},
	{17631, 165772, 9, 1063},
	{17649, 165776, 9, 1063},
	{17667, 165780, 9, 1063},
	{17685, 165784, 9, 1063},
	{17703, 165788, 9, 1063},
	{17721, 165836, 1, 1072},
	{17735, 165840, 1, 1072},
	{17750, 165844},
	{17768, 165848},
	{17786, 165852},
	{17803, 165856},
	{17824, 165860, 1, 3845},
	{17840, 165864},
	{17853, 165872, 5, 1074},
	{17872, 165876},
	{17887, 165880, 1, 1082},
	{17936, 165888, 10, 1084},
	{17953, 165892, 12, 1094},
	{17961, 165896, 3, 4354},
	{17978, 165900, 12, 1110},
	{17996, 165904, 19, 1127},
	{18012, 165908, 13, 1147},
	{18031, 165912, 10, 1163},
	{18046, 165916, 27, 4357},
	{18064, 165920, 16, 1201},
	{18082, 165924, 4, 1217},
	{18106, 165928},
	{18131, 165932, 11, 1221},
	{18283, 166400, 2, 1253},
	{18300, 166404, 2, 1255},
	{18319, 166408, 1, 1257},
	{18335, 166412, 4, 1258},
	{18354, 166416, 1, 1262},
	{18375, 166420, 1, 1263},
	{18388, 166424},
	{18411, 166428},
	{18434, 166432, 1, 1264},
	{18454, 166436, 4, 3849},
	{18474, 166440, 1, 1269},
	{18495, 166444, 1, 1270},
	{18510, 166448, 6, 1271},
	{18532, 166452, 6, 1271},
	{18554, 166456, 8, 1277},
	{18580, 166460, 8, 1277},
	{18606, 166464, 15, 4384},
	{18618, 166468, 2, 1300},
	{18637, 166472, 4, 1303},
	{18655, 166476, 24, 1310},
	{18673, 166480},
	{18685, 166484, 1, 1334},
	{18699, 166488, 1, 1335},
	{18713, 166492, 1, 1336},
	{18727, 166496, 1, 1337},
	{18750, 166500, 1, 1337},
	{18773, 166504, 1, 1337},
	{18796, 166508, 5, 3853},
	{18817, 166512},
	{18828, 166516},
	{18841, 166520},
	{18858, 166524, 7, 4399},
	{18877, 166528},
	{18888, 166532, 2, 1351},
	{18907, 166536},
	{18929, 166540},
	{18951, 166544, 3, 4406},
	{18971, 166548, 1, 1357},
	{19020, 166560},
	{19045, 166564},
	{19070, 166568, 7, 4409},
	{19089, 166572, 1, 1370},
	{19112, 166576, 1, 1370},
	{19135, 166580, 1, 1371},
	{19149, 166584, 1, 1372},
	{19164, 166588, 8, 4416},
	{19181, 166592, 4, 1382},
	{19208, 166596, 4, 1386},
	{19235, 166600, 4, 1390},
	{19254, 166608},
	{19280, 166612, 1, 1394},
	{19305, 166620},
	{19333, 166624},
	{19359, 166628, 1, 1394},
	{19384, 166636},
	{19412, 166640},
	{19438, 166644, 1, 1394},
	{19463, 166652},
	{19491, 166656},
	{19517, 166660, 1, 1394},
	{19542, 166668},
	{19570, 166696},
	{19601, 166700},
	{19644, 166704, 1, 1395},
	{19682, 166712, 1, 1396},
	{19721, 166736, 3, 1399},
	{19743, 166740, 10, 1404},
	{19764, 166744, 3, 1423},
	{19781, 166748, 1, 1370},
	{19802, 166752, 1, 1370},
	{19825, 166756, 1, 1370},
	{19848, 166760, 1, 1370},
	{19871, 166764, 10, 4424},
	{19884, 166768, 6, 1438},
	{19901, 166772},
	{19925, 166776, 2, 1444},
	{19955, 166780},
	{19979, 166784},
	{20009, 166788},
	{20040, 166792},
	{20069, 166796},
	{20099, 166800, 2, 1446},
	{20119, 166804, 7, 3883},
	{20138, 166808, 4, 1457},
	{20188, 166868, 8, 1461},
	{20214, 166872, 8, 1469},
	{20240, 166876, 4, 1477},
	{20256, 166880, 5, 1482},
	{20272, 166884, 3, 1488},
	{20287, 166888},
	{20310, 166892},
	{20333, 166896},
	{20356, 166900},
	{20379, 166904, 8, 1491},
	{20413, 166908, 8, 1499},
	{20447, 166912, 8, 1507},
	{20481, 166916, 8, 1515},
	{20515, 166920, 8, 1491},
	{20549, 166924, 8, 1499},
	{20583, 166928, 8, 1507},
	{20617, 166932, 8, 1515},
	{20651, 166936, 8, 1491},
	{20685, 166940, 8, 1499},
	{20719, 166944, 8, 1507},
	{20753, 166948, 8, 1515},
	{20787, 166952, 8, 1491},
	{20821, 166956, 8, 1499},
	{20855, 166960, 8, 1507},
	{20889, 166964, 8, 1515},
	{20923, 166968, 2, 1523},
	{20947, 166972, 2, 1525},
	{21090, 167000, 1, 1567},
	{21118, 167004, 1, 1568},
	{21139, 167008},
	{21154, 167012, 2, 1569},
	{21170, 167016, 1, 1571},
	{21186, 167020, 2, 3814},
	{21201, 167024, 18, 4434},
	{21216, 167028, 6, 1594},
	{21233, 167032, 9, 1602},
	{21255, 167036},
	{21271, 167040, 1, 1614},
	{21293, 167044},
	{21309, 167048, 1, 1571},
	{21331, 167052},
	{21353, 167056},
	{21375, 167060},
	{21394, 167068},
	{21409, 167072, 2, 1569},
	{21425, 167076, 1, 1571},
	{21441, 167080, 2, 3814},
	{21456, 167084, 18, 4434},
	{21471, 167088, 6, 1594},
	{21488, 167092, 9, 1602},
	{21510, 167096},
	{21526, 167100, 1, 1614},
	{21548, 167104},
	{21564, 167108, 1, 1571},
	{21586, 167112},
	{21608, 167116},
	{21630, 167120},
	{21649, 167128},
	{21664, 167132, 2, 1569},
	{21680, 167136, 1, 1571},
	{21696, 167140, 2, 3814},
	{21711, 167144, 18, 4434},
	{21726, 167148, 6, 1594},
	{21743, 167152, 9, 1602},
	{21765, 167156},
	{21781, 167160, 1, 1614},
	{21803, 167164},
	{21819, 167168, 1, 1571},
	{21841, 167172},
	{21863, 167176},
	{21885, 167180},
	{21904, 167188},
	{21919, 167192, 2, 1569},
	{21935, 167196, 1, 1571},
	{21951, 167200, 2, 3814},
	{21966, 167204, 18, 4434},
	{21981, 167208, 6, 1594},
	{21998, 167212, 9, 1602},
	{22020, 167216},
	{22036, 167220, 1, 1614},
	{22058, 167224},
	{22074, 167228, 1, 1571},
	{22096, 167232},
	{22118, 167236},
	{22140, 167240},
	{22159, 167248},
	{22174, 167252, 2, 1569},
	{22190, 167256, 1, 1571},
	{22206, 167260, 2, 3814},
	{22221, 167264, 18, 4434},
	{22236, 167268, 6, 1594},
	{22253, 167272, 9, 1602},
	{22275, 167276},
	{22291, 167280, 1, 1614},
	{22313, 167284},
	{22329, 167288, 1, 1571},
	{22351, 167292},
	{22373, 167296},
	{22395, 167300},
	{22414, 167308},
	{22429, 167312, 2, 1569},
	{22445, 167316, 1, 1571},
	{22461, 167320, 2, 3814},
	{22476, 167324, 18, 4434},
	{22491, 167328, 6, 1594},
	{22508, 167332, 9, 1602},
	{22530, 167336},
	{22546, 167340, 1, 1614},
	{22568, 167344},
	{22584, 167348, 1, 1571},
	{22606, 167352},
	{22628, 167356},
	{22650, 167360},
	{22669, 167368},
	{22684, 167372, 2, 1569},
	{22700, 167376, 1, 1571},
	{22716, 167380, 2, 3814},
	{22731, 167384, 18, 4434},
	{22746, 167388, 6, 1594},
	{22763, 167392, 9, 1602},
	{22785, 167396},
	{22801, 167400, 1, 1614},
	{22823, 167404},
	{22839, 167408, 1, 1571},
	{22861, 167412},
	{22883, 167416},
	{22905, 167420},
	{22924, 167428},
	{22939, 167432, 2, 1569},
	{22955, 167436, 1, 1571},
	{22971, 167440, 2, 3814},
	{22986, 167444, 18, 4434},
	{23001, 167448, 6, 1594},
	{23018, 167452, 9, 1602},
	{23040, 167456},
	{23056, 167460, 1, 1614},
	{23078, 167464},
	{23094, 167468, 1, 1571},
	{23116, 167472},
	{23138, 167476},
	{23160, 167480},
	{24203, 196608, 1, 1627},
	{24223, 196612, 1, 1628},
	{24243, 196616},
	{24263, 196620},
	{24283, 196624},
	{24304, 196628},
	{24325, 196632, 1, 1629},
	{24347, 196636, 1, 1630},
	{24369, 196640},
	{24399, 196644},
	{24429, 196648},
	{24458, 196652},
	{24487, 196656},
	{24517, 196660},
	{24547, 196664},
	{24576, 196668},
	{24605, 196672},
	{24635, 196676},
	{24665, 196680},
	{24694, 196684},
	{24723, 196688},
	{24753, 196692},
	{24783, 196696},
	{24812, 196700},
	{24841, 196704, 1, 1631},
	{24863, 196708, 1, 1632},
	{24885, 196712},
	{24908, 196716},
	{24931, 196720},
	{24954, 196724},
	{24977, 196728},
	{25000, 196732},
	{25023, 196736},
	{25047, 196740},
	{25071, 196744},
	{25095, 196748},
	{25119, 196752},
	{25143, 196756},
	{25167, 196760},
	{25191, 196764},
	{25215, 196768},
	{25237, 196772},
	{25259, 196776},
	{25280, 196780},
	{25301, 196784},
	{25325, 196788},
	{25349, 196792},
	{25373, 196796},
	{25397, 196800},
	{25421, 196804},
	{25505, 196852, 2, 4452},
	{25527, 196856, 2, 4452},
	{25549, 196860, 1, 1635},
	{25565, 196864},
	{25578, 196868},
	{25591, 196872},
	{25604, 196876},
	{25617, 196880},
	{25630, 196884},
	{25643, 196888},
	{25656, 196892},
	{25783, 196928, 2, 1636},
	{25796, 196932},
	{25809, 196936},
	{25832, 196940},
	{25855, 196944},
	{25883, 196948},
	{25911, 196952},
	{25939, 196956},
	{25967, 196960, 1, 1638},
	{25985, 196964, 5, 4454},
	{26003, 196968},
	{26018, 196972},
	{26042, 196976},
	{26066, 196980},
	{26085, 196984},
	{26104, 196988},
	{26128, 196992},
	{26152, 196996},
	{26176, 197000},
	{26200, 197028, 2, 3040},
	{26218, 197032, 3, 4459},
	{26236, 197036},
	{26254, 197040},
	{26272, 197044, 2, 3043},
	{26290, 197048, 3, 4462},
	{26308, 197052},
	{26326, 197056, 2, 1649},
	{26345, 197060, 5, 1651},
	{26364, 197072},
	{26388, 197076, 2, 1649},
	{26408, 197080, 5, 1651},
	{26428, 197084, 8, 4465},
	{26447, 197088, 8, 4465},
	{26465, 197092, 1, 1663},
	{26482, 197100, 1, 1664},
	{26503, 197104, 26, 4473},
	{26517, 197108},
	{26531, 197112},
	{26545, 197116, 4, 3074},
	{26561, 197120},
	{26580, 197124, 1, 1680},
	{26602, 197128},
	{26621, 197132, 1, 1681},
	{26643, 197136, 9, 3080},
	{26661, 197140},
	{26681, 197144, 1, 1680},
	{26704, 197148},
	{26724, 197152, 1, 1681},
	{26747, 197156, 9, 3080},
	{26766, 197160, 5, 3089},
	{26778, 197164, 2, 1696},
	{26795, 197168, 1, 1698},
	{26812, 197172, 1, 1699},
	{26830, 197176, 4, 1700},
	{26850, 197180, 1, 1704},
	{26867, 197184},
	{26883, 197188, 1, 1706},
	{26896, 197192, 1, 1707},
	{26910, 197196, 1, 1708},
	{26924, 197200, 1, 1709},
	{26946, 197204, 1, 1710},
	{26966, 197208, 1, 1711},
	{26988, 197212, 1, 1712},
	{27008, 197216, 1, 1707},
	{27025, 197220, 1, 1708},
	{27042, 197224},
	{52837, 197228, 1, 1706},
	{27301, 197388, 1, 1721},
	{27320, 197392, 1, 1722},
	{27339, 197396, 1, 1723},
	{27356, 197400, 1, 1724},
	{27374, 197404, 1, 1725},
	{27392, 197408, 1, 1726},
	{27408, 197412, 1, 1727},
	{27426, 197416, 1, 1728},
	{27444, 197420, 1, 1729},
	{27460, 197424, 1, 1724},
	{27475, 197428, 1, 1725},
	{27490, 197432, 1, 1726},
	{27503, 197436, 1, 1727},
	{27518, 197440, 1, 1728},
	{27533, 197444, 1, 1729},
	{27546, 197448, 1, 1730},
	{27560, 197452, 1, 1731},
	{27574, 197456, 1, 1732},
	{27586, 197460, 4, 4499},
	{27609, 197464, 4, 4092},
	{27631, 197468, 1, 1740},
	{27775, 197552, 1, 1745},
	{27800, 197556, 1, 1745},
	{27824, 197560, 1, 1746},
	{27844, 197568},
	{27870, 197572, 1, 1628},
	{27899, 197576},
	{27924, 197580, 1, 1628},
	{27952, 197584},
	{27975, 197588, 1, 1628},
	{28001, 197592},
	{28023, 197596, 1, 1628},
	{28048, 197600},
	{28067, 197604, 1, 1628},
	{28089, 197608, 1, 1343},
	{28103, 197612},
	{28120, 197616, 1, 1628},
	{28140, 197620, 8, 1747},
	{28309, 198656, 6, 2946},
	{48507, 198912},
	{48526, 198916},
	{28370, 198920, 1, 3329},
	{28389, 198924, 1, 1343},
	{28404, 198928},
	{28437, 198932},
	{28470, 198936},
	{28503, 198940},
	{28593, 198960},
	{28609, 198964},
	{49020, 198968, 1, 1785},
	{49052, 198972, 2, 1786},
	{49073, 198976},
	{29013, 199168, 1, 1809},
	{29038, 199172, 2, 1810},
	{29063, 199184, 2, 1812},
	{29089, 199188, 2, 1812},
	{29115, 199192, 2, 1812},
	{29141, 199212, 2, 1812},
	{29167, 199296, 2, 1814},
	{29195, 199300, 1, 1816},
	{29219, 199304, 1, 1817},
	{29243, 199308, 1, 1818},
	{29276, 199312, 1, 1818},
	{29304, 199328, 2, 1814},
	{29333, 199332, 1, 1816},
	{29358, 199336, 1, 1817},
	{29383, 199340, 1, 1818},
	{29417, 199344, 1, 1818},
	{29446, 199360, 2, 1814},
	{29470, 199364, 1, 1816},
	{29490, 199368, 1, 1817},
	{29510, 199372, 1, 1818},
	{29539, 199376, 1, 1818},
	{49639, 199872},
	{49660, 199876, 1, 3506},
	{2095, 199880, 8, 4060},
	{2116, 199884, 3, 3515},
	{49681, 199888, 2, 3518},
	{2143, 199892, 1, 3542},
	{49707, 199896, 15, 3527},
	{50710, 199900, 1, 4069},
	{50732, 199904},
	{2074, 199908, 2, 3520},
	{2164, 199912, 5, 4072},
	{49749, 199916, 1, 3543},
	{29563, 199936},
	{29590, 199940},
	{29617, 199944},
	{29644, 199948},
	{29779, 199968, 6, 1819},
	{29790, 199972, 2, 1826},
	{29804, 200192},
	{29823, 200196, 1, 840},
	{29845, 200448},
	{29869, 200452, 1, 1828},
	{29892, 200456},
	{29916, 200460, 1, 1828},
	{29939, 200464},
	{29963, 200468, 1, 1828},
	{29986, 200472},
	{30010, 200476, 1, 1828},
	{30033, 200696},
	{30052, 200700, 1, 1828},
	{30070, 200704},
	{30082, 200708},
	{30094, 200712},
	{30112, 200716},
	{30131, 200720},
	{30149, 200724},
	{30161, 200728},
	{30173, 200732},
	{30191, 200736},
	{30209, 200740},
	{30228, 200744, 4, 1829},
	{30242, 200748, 2, 1833},
	{30260, 200752, 2, 1835},
	{30274, 200756, 2, 1837},
	{30288, 200760, 2, 1839},
	{30305, 200764, 2, 1841},
	{30322, 200768},
	{30335, 200772, 2, 1843},
	{30347, 200776},
	{30361, 200780},
	{30377, 200784},
	{30391, 200788},
	{30407, 200792},
	{30422, 200796},
	{30439, 200800},
	{30454, 200804},
	{30471, 200808, 2, 1845},
	{30493, 200812, 9, 4100},
	{30510, 200816, 2, 1857},
	{30531, 200820, 2, 1859},
	{30543, 200824},
	{30558, 200828, 6, 4503},
	{30573, 200832, 2, 1867},
	{30587, 200836},
	{30700, 212992},
	{30720, 212996},
	{30740, 213000},
	{30760, 213004},
	{30780, 213008},
	{30800, 213012},
	{30820, 213016},
	{30840, 213020},
	{30860, 213024},
	{30880, 213028},
	{30900, 213032},
	{30920, 213036},
	{31009, 213248},
	{31030, 213252},
	{31051, 213260},
	{31072, 213264},
	{31093, 213268},
	{31117, 213272},
	{31141, 213276},
	{31165, 213280},
	{31189, 213284},
	{31213, 213288},
	{31237, 213292},
	{31261, 213296},
	{50822, 213504},
	{50841, 213508},
	{50860, 213512},
	{50879, 213516},
	{50898, 213520},
	{50917, 213524},
	{50936, 213528},
	{50955, 213532},
	{48217, 213536},
	{48236, 213540},
	{48255, 213544},
	{48274, 213548},
	{48293, 213552},
	{48312, 213556},
	{48331, 213560},
	{48350, 213564},
	{48808, 213568},
	{48828, 213572},
	{48848, 213576},
	{48868, 213580},
	{48888, 213584},
	{48908, 213588},
	{48928, 213592},
	{48948, 213596},
	{31745, 214016},
	{31767, 214020, 1, 1869},
	{31789, 214024},
	{31811, 214028, 1, 1869},
	{31833, 214032},
	{31855, 214036, 1, 1869},
	{31877, 214040},
	{31899, 214044, 1, 1869},
	{31921, 214272},
	{31943, 214276},
	{31965, 214280},
	{31987, 214284},
	{32009, 214288},
	{32031, 214292},
	{32053, 214296},
	{32075, 214300},
	{32097, 214304},
	{32119, 214308},
	{32141, 214312},
	{32163, 214316},
	{32185, 214320},
	{32207, 214324},
	{32229, 214328},
	{32251, 214332},
	{32273, 214528},
	{32293, 214532},
	{32313, 214536},
	{32333, 214540},
	{32353, 214544},
	{32373, 214548},
	{32393, 214552},
	{32413, 214556},
	{32433, 214560},
	{32453, 214564},
	{32473, 214568},
	{32493, 214572},
	{32513, 214784},
	{32532, 214788},
	{32551, 214792},
	{32570, 214796},
	{32589, 214800},
	{32608, 214804},
	{32627, 214808},
	{32646, 214812},
	{32665, 214816},
	{32684, 214820},
	{32703, 214824},
	{32722, 214828},
	{32741, 214832},
	{32760, 214836},
	{32779, 214840},
	{32798, 214844},
	{32817, 214848},
	{32836, 214852},
	{32855, 214856},
	{32874, 214860},
	{32893, 214864},
	{32913, 214868},
	{32933, 214872},
	{32953, 214876},
	{32973, 214880},
	{32993, 214884},
	{33013, 214888},
	{33033, 214892},
	{33053, 214896},
	{33073, 214900},
	{33093, 214904},
	{33113, 214908},
	{33133, 215296},
	{33152, 215300},
	{33171, 215304},
	{33190, 215308},
	{33209, 215312},
	{33228, 215316},
	{33247, 215320},
	{33266, 215324},
	{33327, 215552},
	{33347, 215556},
	{33367, 215560},
	{33387, 215564},
	{33407, 215568},
	{33427, 215572},
	{33447, 215576},
	{33467, 215580},
	{33487, 215808},
	{33506, 215812},
	{33525, 215816},
	{33544, 215820},
	{33563, 216064},
	{33582, 216068},
	{33601, 216072},
	{33620, 216076},
	{33639, 216320},
	{33659, 216324},
	{33679, 216328},
	{33699, 216332},
	{33719, 216336},
	{33739, 216340},
	{33759, 216344},
	{33779, 216348},
	{50974, 216576},
	{50994, 216580},
	{51014, 216584},
	{51034, 216588},
	{51054, 216592},
	{51074, 216596},
	{51094, 216600},
	{51114, 216604},
	{51134, 216640},
	{51154, 216644},
	{51174, 216648},
	{51194, 216652},
	{51214, 216656},
	{51234, 216660},
	{51254, 216664},
	{51274, 216668},
	{34631, 217112},
	{34650, 217116},
	{34669, 217120},
	{34688, 217124},
	{34707, 217128},
	{34726, 217132},
	{34745, 217136},
	{34764, 217140},
	{34783, 217344},
	{34802, 217348},
	{34821, 217352},
	{34840, 217356},
	{34859, 217360},
	{34878, 217364},
	{34897, 217368},
	{34916, 217372},
	{34935, 217600},
	{34955, 217604},
	{34975, 217608},
	{34995, 217612},
	{36317, 221184, 1, 1903},
	{36341, 221188, 2, 4109},
	{36366, 221192, 3, 4111},
	{36390, 221196, 1, 1903},
	{36414, 221200, 2, 4109},
	{36439, 221204, 1, 1903},
	{36463, 221208, 2, 4109},
	{36488, 221212, 3, 4111},
	{36512, 221216, 4, 1881},
	{36528, 221220, 3, 4111},
	{36695, 221248},
	{36710, 221252, 1, 1818},
	{36733, 221256},
	{36756, 221260},
	{36774, 221264, 2, 1897},
	{36792, 221268, 4, 1899},
	{36812, 221440, 19, 2989},
	{36837, 221444, 19, 2989},
	{36862, 221448, 12, 3008},
	{36890, 221452, 12, 3008},
	{36918, 221456, 12, 3008},
	{36946, 221460, 12, 3008},
	{51454, 221696, 2, 3287},
	{51477, 221700, 2, 3287},
	{51500, 221704, 2, 3287},
	{51523, 221708, 2, 3287},
	{48125, 221712, 5, 1957},
	{48148, 221716, 2, 3287},
	{48171, 221720, 2, 3287},
	{48194, 221724, 2, 3287},
	{51546, 221728, 4, 1962},
	{48712, 221744, 5, 1957},
	{48736, 221748, 5, 1957},
	{48760, 221752, 2, 3287},
	{48784, 221756, 2, 3287},
	{51570, 221760, 4, 1962},
	{51595, 221764, 4, 1962},
	{48686, 221776, 1, 3328},
	{37404, 222208, 3, 1957},
	{37430, 222212, 2, 1877},
	{37457, 222216, 3, 1957},
	{37483, 222220, 2, 1877},
	{37510, 222224, 2, 2013},
	{37563, 222228, 2, 2013},
	{37616, 222464, 3, 1957},
	{37642, 222468, 2, 1877},
	{37669, 222472, 1, 1872},
	{37695, 222476, 1, 1872},
	{37721, 222480, 1, 1872},
	{37747, 222484, 1, 1872},
	{37773, 222488, 1, 1872},
	{37799, 222492, 1, 1872},
	{37825, 222496, 1, 1872},
	{37851, 222720, 3, 1957},
	{37875, 222724, 3, 1957},
	{37899, 222728, 3, 1957},
	{37923, 222732, 3, 1957},
	{37947, 222736, 2, 1877},
	{37972, 222740, 2, 1877},
	{37997, 222744, 2, 1877},
	{38022, 222748, 2, 1877},
	{38047, 222752, 1, 2001},
	{38071, 222756, 1, 2001},
	{38095, 222760, 8, 1966},
	{38116, 222976, 6, 3486},
	{38139, 222980, 6, 3486},
	{38162, 222984, 6, 3486},
	{38185, 222988, 6, 3486},
	{38208, 222992, 6, 3486},
	{38231, 222996, 6, 3486},
	{38254, 223000, 6, 3486},
	{38277, 223004, 6, 3486},
	{38300, 223008, 6, 3486},
	{38323, 223012, 6, 3486},
	{38346, 223016, 6, 3486},
	{38370, 223020, 6, 3486},
	{38394, 223024, 6, 3486},
	{38418, 223028, 6, 3486},
	{38442, 223032, 6, 3486},
	{38466, 223036, 6, 3486},
	{38490, 223104, 9, 3469},
	{51620, 223108, 2, 3518},
	{38510, 223112, 1, 1987},
	{38605, 223488, 3, 1996},
	{38628, 223492, 3, 1996},
	{38651, 223496, 3, 1996},
	{38674, 223500, 3, 1996},
	{38697, 223504, 2, 1999},
	{38721, 223508, 2, 1999},
	{38745, 223744, 3, 1996},
	{38769, 223748, 3, 1996},
	{38793, 223752, 3, 1996},
	{38817, 223756, 3, 1996},
	{38841, 223760, 2, 1999},
	{38866, 224000, 5, 2001},
	{38889, 224004, 4, 2006},
	{38913, 224008, 5, 2001},
	{38936, 224256, 5, 2001},
	{38959, 224260, 4, 2006},
	{38983, 224264, 5, 2001},
	{39006, 224512, 5, 1957},
	{39030, 224516, 4, 1962},
	{39055, 224520, 5, 1957},
	{39079, 224524, 4, 1962},
	{39104, 224528, 3, 2013},
	{39128, 224532, 3, 2013},
	{51640, 224768, 5, 1957},
	{51664, 224772, 4, 1951},
	{51689, 224776, 5, 1957},
	{51713, 224780, 4, 1951},
	{51738, 224784, 3, 2013},
	{51762, 224788, 3, 2013},
	{51786, 224832, 5, 1957},
	{51810, 224836, 4, 1951},
	{51835, 224840, 5, 1957},
	{51859, 224844, 4, 1951},
	{51884, 224848, 3, 2013},
	{51908, 224852, 3, 2013},
	{39829, 225280, 12, 2016},
	{39851, 225284, 5, 2028},
	{39874, 225288, 4, 2033},
	{39898, 225292, 2, 2037},
	{39921, 225296, 2, 2037},
	{39944, 225300, 2, 2037},
	{39967, 225536, 5, 1957},
	{39990, 225540, 4, 1962},
	{40014, 225544, 5, 1957},
	{40037, 225548, 4, 1962},
	{40061, 225552, 5, 1957},
	{40084, 225560, 5, 1957},
	{40107, 225792, 4, 2039},
	{40128, 225796},
	{40157, 225800, 2, 2043},
	{40186, 225804},
	{40212, 225808, 7, 2045},
	{40286, 225812},
	{40309, 225816},
	{52053, 225820, 2, 4120},
	{52086, 225824, 2, 4120},
	{52119, 225828, 2, 4120},
	{52152, 225832, 2, 4120},
	{52184, 225836, 2, 4120},
	{52216, 225840, 2, 4120},
	{52248, 225844, 2, 4120},
	{52281, 225848, 2, 4120},
	{52313, 225856, 2, 4120},
	{52345, 225860, 2, 4120},
	{52378, 225864, 2, 4120},
	{52411, 225868, 2, 4120},
	{52444, 225872, 2, 4120},
	{52476, 225876, 2, 4120},
	{52508, 225880, 2, 4120},
	{52541, 225884, 2, 4120},
	{52574, 225888, 2, 4120},
	{52640, 225896, 2, 4120},
	{40332, 225900},
	{40359, 225904},
	{40241, 225908},
	{40260, 225912},
	{52672, 225916, 2, 4120},
	{52706, 225920, 2, 4120},
	{52740, 225924, 2, 4120},
	{52774, 225928, 2, 4120},
	{41229, 226044, 1, 2129},
	{41022, 226048, 2, 2119},
	{41039, 226052, 1, 2121},
	{41063, 226056, 1, 2121},
	{195, 880, 4, 2156},
	{42808, 881},
	{26631, 882},
	{42820, 1008},
	{42831, 1009},
	{26819, 1010, 3, 2160},
	{42842, 1040, 1, 2163},
	{42855, 1041, 5, 4122},
	{42868, 1042, 1, 2169},
	{42881, 1043, 1, 1681},
	{26653, 1045, 9, 3914},
	{42909, 1280, 6, 4127},
	{42924, 1281},
	{26590, 1282},
	{42808, 1283},
	{26631, 1284},
};

static const struct si_reg gfx81_reg_table[] = {
	{974, 68, 10, 4133},
	{987, 72, 23, 4143},
	{1002, 76, 4, 4166},
	{46947, 80, 11, 3939},
	{1039, 84, 4, 2800},
	{1057, 88, 2, 2804},
	{1075, 92, 6, 4170},
	{1090, 96},
	{1104, 100, 1, 70},
	{1118, 104},
	{46961, 108},
	{46978, 112, 13, 4176},
	{1135, 116, 5, 4189},
	{46994, 2480},
	{47009, 2484, 1, 2824},
	{47024, 2488},
	{47039, 2492, 1, 2824},
	{1273, 2496},
	{1287, 2500},
	{1301, 2504},
	{1315, 2508},
	{1329, 2512},
	{1343, 2516},
	{1357, 2520},
	{1371, 2524},
	{1385, 2528},
	{1399, 2532},
	{1413, 2536},
	{1428, 2540},
	{1503, 2544},
	{1514, 2552},
	{1530, 2556},
	{47054, 3660, 21, 2825},
	{47067, 3664, 20, 2846},
	{47079, 3668, 16, 2866},
	{1618, 32776, 18, 4194},
	{1631, 32784, 24, 2904},
	{1643, 32788, 11, 2928},
	{1659, 32792, 11, 2928},
	{1688, 32824, 11, 2928},
	{1704, 32828, 11, 2928},
	{1720, 33296, 15, 4212},
	{1734, 33300, 28, 204},
	{1751, 33304, 14, 4227},
	{1772, 33308, 21, 4241},
	{1786, 33312, 31, 4022},
	{1803, 33316, 9, 4262},
	{1842, 33324, 1, 329},
	{1865, 33344, 1, 330},
	{1886, 33348},
	{1947, 33436, 1, 342},
	{49728, 36416},
	{2351, 36608},
	{2369, 36612, 4, 383},
	{2387, 36616},
	{2405, 36620, 14, 4271},
	{3306, 36624},
	{3324, 36628, 5, 4509},
	{3342, 36632, 4, 3587},
	{3360, 36636, 11, 3591},
	{3378, 36640, 2, 3602},
	{3396, 36644, 2, 3604},
	{3414, 36648, 8, 4290},
	{3432, 36652},
	{2423, 36656, 14, 4298},
	{2441, 36660, 4, 411},
	{2459, 36664, 10, 4312},
	{2477, 36668, 3, 3632},
	{2495, 37120, 6, 429},
	{2511, 39160, 9, 3635},
	{2526, 39184, 5, 3645},
	{2540, 39188, 5, 3645},
	{2554, 39192, 5, 3645},
	{2568, 39196, 5, 3645},
	{2582, 39200, 5, 3645},
	{2596, 39204, 5, 3645},
	{2610, 39208, 5, 3645},
	{2624, 39212, 5, 3645},
	{2638, 39216, 5, 3645},
	{2652, 39220, 5, 3645},
	{2666, 39224, 5, 3645},
	{2681, 39228, 5, 3645},
	{2696, 39232, 5, 3645},
	{2711, 39236, 5, 3645},
	{2726, 39240, 5, 3645},
	{2741, 39244, 5, 3645},
	{2756, 39248, 5, 3645},
	{2771, 39252, 5, 3645},
	{2786, 39256, 5, 3645},
	{2801, 39260, 5, 3645},
	{2816, 39264, 5, 3645},
	{2831, 39268, 5, 3645},
	{2846, 39272, 5, 3645},
	{2861, 39276, 5, 3645},
	{2876, 39280, 5, 3645},
	{2891, 39284, 5, 3645},
	{2906, 39288, 5, 3645},
	{2921, 39292, 5, 3645},
	{2936, 39296, 5, 3645},
	{2951, 39300, 5, 3645},
	{2966, 39304, 5, 3645},
	{2981, 39308, 5, 3645},
	{2996, 39312, 4, 448},
	{3015, 39316, 4, 448},
	{3034, 39320, 4, 448},
	{3053, 39324, 4, 448},
	{3072, 39328, 4, 448},
	{3091, 39332, 4, 448},
	{3110, 39336, 4, 448},
	{3129, 39340, 4, 448},
	{3148, 39344, 4, 448},
	{3167, 39348, 4, 448},
	{3186, 39352, 4, 448},
	{3206, 39356, 4, 448},
	{3226, 39360, 4, 448},
	{3246, 39364, 4, 448},
	{3266, 39368, 4, 448},
	{3286, 39372, 4, 448},
	{49962, 45056},
	{49983, 45060, 1, 491},
	{50004, 45064},
	{50025, 45068, 1, 491},
	{3499, 45084, 3, 488},
	{3523, 45088},
	{3544, 45092, 1, 491},
	{3565, 45096, 11, 3650},
	{3589, 45100, 6, 503},
	{3613, 45104},
	{3639, 45108},
	{3665, 45112},
	{3691, 45116},
	{3717, 45120},
	{3743, 45124},
	{3769, 45128},
	{3795, 45132},
	{3821, 45136},
	{3847, 45140},
	{3873, 45144},
	{3900, 45148},
	{3927, 45152},
	{3954, 45156},
	{3981, 45160},
	{4008, 45164},
	{50046, 45312},
	{50067, 45316, 1, 491},
	{50088, 45320},
	{50109, 45324, 1, 491},
	{4680, 45336, 3, 488},
	{4704, 45340, 1, 527},
	{4729, 45344},
	{4750, 45348, 1, 491},
	{4771, 45352, 12, 3667},
	{4795, 45356, 11, 4322},
	{4819, 45360},
	{4845, 45364},
	{4871, 45368},
	{4897, 45372},
	{4923, 45376},
	{4949, 45380},
	{4975, 45384},
	{5001, 45388},
	{5027, 45392},
	{5053, 45396},
	{5079, 45400},
	{5106, 45404},
	{5133, 45408},
	{5160, 45412},
	{5187, 45416},
	{5214, 45420},
	{5864, 45552, 6, 563},
	{5891, 45556, 5, 569},
	{50130, 45568},
	{50151, 45572, 1, 491},
	{50172, 45576},
	{50193, 45580, 1, 491},
	{6079, 45596, 4, 576},
	{6103, 45600},
	{6124, 45604, 1, 491},
	{6145, 45608, 11, 3689},
	{6169, 45612, 4, 554},
	{6193, 45616},
	{6219, 45620},
	{6245, 45624},
	{6271, 45628},
	{6297, 45632},
	{6323, 45636},
	{6349, 45640},
	{6375, 45644},
	{6401, 45648},
	{6427, 45652},
	{6453, 45656},
	{6480, 45660},
	{6507, 45664},
	{6534, 45668},
	{6561, 45672},
	{6588, 45676},
	{7223, 45808, 6, 563},
	{50214, 45824},
	{50235, 45828, 1, 491},
	{50256, 45832},
	{50277, 45836, 1, 491},
	{7250, 45852, 4, 576},
	{7274, 45856},
	{7295, 45860, 1, 491},
	{7316, 45864, 12, 3667},
	{7340, 45868, 6, 563},
	{7364, 45872},
	{7390, 45876},
	{7416, 45880},
	{7442, 45884},
	{7468, 45888},
	{7494, 45892},
	{7520, 45896},
	{7546, 45900},
	{7572, 45904},
	{7598, 45908},
	{7624, 45912},
	{7651, 45916},
	{7678, 45920},
	{7705, 45924},
	{7732, 45928},
	{7759, 45932},
	{7786, 46068, 5, 569},
	{50298, 46080},
	{50319, 46084, 1, 491},
	{50340, 46088},
	{50361, 46092, 1, 491},
	{7974, 46108, 3, 612},
	{7998, 46112},
	{8019, 46116, 1, 491},
	{8040, 46120, 10, 3710},
	{8064, 46124, 6, 628},
	{8088, 46128},
	{8114, 46132},
	{8140, 46136},
	{8166, 46140},
	{8192, 46144},
	{8218, 46148},
	{8244, 46152},
	{8270, 46156},
	{8296, 46160},
	{8322, 46164},
	{8348, 46168},
	{8375, 46172},
	{8402, 46176},
	{8429, 46180},
	{8456, 46184},
	{8483, 46188},
	{9118, 46324, 5, 569},
	{50382, 46336},
	{50403, 46340, 1, 491},
	{50424, 46344},
	{50445, 46348, 1, 491},
	{9145, 46364, 4, 576},
	{9169, 46368},
	{9190, 46372, 1, 491},
	{9211, 46376, 11, 3726},
	{9235, 46380, 5, 569},
	{9259, 46384},
	{9285, 46388},
	{9311, 46392},
	{9337, 46396},
	{9363, 46400},
	{9389, 46404},
	{9415, 46408},
	{9441, 46412},
	{9467, 46416},
	{9493, 46420},
	{9519, 46424},
	{9546, 46428},
	{9573, 46432},
	{9600, 46436},
	{9627, 46440},
	{9654, 46444},
	{9681, 47104, 12, 3742},
	{9708, 47108},
	{9722, 47112},
	{9736, 47116},
	{9750, 47120},
	{9766, 47124},
	{9782, 47128},
	{9798, 47132, 2, 659},
	{9819, 47136, 2, 659},
	{9840, 47140, 2, 659},
	{9861, 47144, 1, 661},
	{9889, 47148, 1, 662},
	{9914, 47152},
	{9929, 47156, 2, 3755},
	{50486, 47160},
	{50501, 47164, 1, 663},
	{50516, 47168},
	{50531, 47172, 1, 663},
	{10068, 47176, 10, 3757},
	{10086, 47180, 11, 676},
	{10104, 47184, 1, 687},
	{10117, 47188, 6, 688},
	{50546, 47192, 2, 3774},
	{50577, 47196, 2, 3774},
	{10195, 47200, 2, 694},
	{50760, 47204, 2, 3774},
	{50791, 47208, 2, 3774},
	{10270, 47212},
	{10288, 47216},
	{10306, 47220},
	{10324, 47224, 1, 696},
	{10352, 47228, 5, 697},
	{10374, 47232},
	{10394, 47236},
	{10577, 47240, 3, 713},
	{10594, 47244},
	{10623, 47248, 1, 716},
	{52808, 47252, 2, 4333},
	{10670, 47360},
	{10690, 47364},
	{10710, 47368},
	{10730, 47372},
	{10750, 47376},
	{10770, 47380},
	{10790, 47384},
	{10810, 47388},
	{10830, 47392},
	{10850, 47396},
	{10870, 47400},
	{10891, 47404},
	{10912, 47408},
	{10933, 47412},
	{10954, 47416},
	{10975, 47420},
	{11041, 47612},
	{50608, 53300, 29, 3776},
	{50625, 55348, 29, 3776},
	{11057, 163840, 10, 719},
	{11075, 163844, 9, 3805},
	{11092, 163848, 4, 3814},
	{11106, 163852, 23, 747},
	{11125, 163856, 15, 770},
	{11145, 163860},
	{11181, 163872},
	{11201, 163876},
	{11221, 163880, 1, 788},
	{11238, 163884},
	{11253, 163888, 2, 789},
	{11277, 163892, 2, 791},
	{50642, 163900, 7, 3818},
	{11335, 163904, 10, 4335},
	{11345, 163908, 6, 4345},
	{11361, 163912},
	{11376, 163916},
	{11397, 163920},
	{11413, 163924},
	{50656, 163928, 2, 3838},
	{50670, 163932, 1, 3840},
	{11603, 163968},
	{11619, 163972, 1, 840},
	{11638, 164328, 1, 841},
	{11659, 164332, 1, 841},
	{11680, 164336, 1, 841},
	{11701, 164340, 1, 841},
	{11722, 164344},
	{11740, 164348},
	{11758, 164352, 2, 842},
	{11778, 164356, 3, 844},
	{11802, 164360, 2, 847},
	{11826, 164364, 1, 849},
	{11846, 164368, 2, 844},
	{11866, 164372, 2, 847},
	{11886, 164376, 2, 844},
	{11906, 164380, 2, 847},
	{11926, 164384, 2, 844},
	{11946, 164388, 2, 847},
	{11966, 164392, 2, 844},
	{11986, 164396, 2, 847},
	{12006, 164400, 7, 850},
	{12021, 164404, 2, 857},
	{12050, 164408, 8, 859},
	{12065, 164412, 8, 867},
	{12080, 164416, 3, 844},
	{12105, 164420, 2, 847},
	{12130, 164424},
	{12148, 164428},
	{12166, 164432, 3, 844},
	{12191, 164436, 2, 847},
	{12216, 164440, 3, 844},
	{12241, 164444, 2, 847},
	{12266, 164448, 3, 844},
	{12291, 164452, 2, 847},
	{12316, 164456, 3, 844},
	{12341, 164460, 2, 847},
	{12366, 164464, 3, 844},
	{12391, 164468, 2, 847},
	{12416, 164472, 3, 844},
	{12441, 164476, 2, 847},
	{12466, 164480, 3, 844},
	{12491, 164484, 2, 847},
	{12516, 164488, 3, 844},
	{12541, 164492, 2, 847},
	{12566, 164496, 3, 844},
	{12591, 164500, 2, 847},
	{12616, 164504, 3, 844},
	{12641, 164508, 2, 847},
	{12666, 164512, 3, 844},
	{12692, 164516, 2, 847},
	{12718, 164520, 3, 844},
	{12744, 164524, 2, 847},
	{12770, 164528, 3, 844},
	{12796, 164532, 2, 847},
	{12822, 164536, 3, 844},
	{12848, 164540, 2, 847},
	{12874, 164544, 3, 844},
	{12900, 164548, 2, 847},
	{12926, 164552, 3, 844},
	{12952, 164556, 2, 847},
	{12978, 164560},
	{12997, 164564},
	{13016, 164568},
	{13035, 164572},
	{13054, 164576},
	{13073, 164580},
	{13092, 164584},
	{13111, 164588},
	{13130, 164592},
	{13149, 164596},
	{13168, 164600},
	{13187, 164604},
	{13206, 164608},
	{13225, 164612},
	{13244, 164616},
	{13263, 164620},
	{13282, 164624},
	{13301, 164628},
	{13320, 164632},
	{13339, 164636},
	{13358, 164640},
	{13378, 164644},
	{13398, 164648},
	{13418, 164652},
	{13438, 164656},
	{13458, 164660},
	{13478, 164664},
	{13498, 164668},
	{13518, 164672},
	{13538, 164676},
	{13558, 164680},
	{13578, 164684},
	{13598, 164688, 15, 875},
	{13618, 164692, 3, 890},
	{13640, 164696, 2, 893},
	{13697, 164704, 1, 902},
	{50685, 164708, 1, 3841},
	{13728, 164712, 1, 904},
	{13796, 164864},
	{13813, 164868},
	{13830, 164872},
	{13846, 164876},
	{13900, 164884},
	{13913, 164888},
	{13928, 164892},
	{13942, 164896},
	{13957, 164900, 3, 4351},
	{13996, 164908, 6, 935},
	{14015, 164912, 4, 941},
	{14033, 164916, 4, 945},
	{14054, 164924},
	{14073, 164928},
	{14093, 164932},
	{14112, 164936},
	{14132, 164940},
	{14151, 164944},
	{14171, 164948},
	{14192, 164952},
	{14214, 164956},
	{14235, 164960},
	{14257, 164964},
	{14278, 164968},
	{14300, 164972},
	{14321, 164976},
	{14343, 164980},
	{14364, 164984},
	{14386, 164988},
	{14407, 164992},
	{14429, 164996},
	{14450, 165000},
	{14472, 165004},
	{14493, 165008},
	{14515, 165012},
	{14536, 165016},
	{14558, 165020},
	{14579, 165024},
	{14601, 165028},
	{14622, 165032},
	{14644, 165036},
	{14665, 165040},
	{14687, 165044},
	{14708, 165048},
	{14730, 165052},
	{14751, 165056},
	{14773, 165060},
	{14794, 165064},
	{14816, 165068},
	{14837, 165072},
	{14859, 165076},
	{14880, 165080},
	{14902, 165084},
	{14923, 165088},
	{14945, 165092},
	{14966, 165096},
	{14988, 165100},
	{15009, 165104},
	{15031, 165108},
	{15052, 165112},
	{15074, 165116},
	{15095, 165120},
	{15117, 165124},
	{15138, 165128},
	{15160, 165132},
	{15181, 165136},
	{15203, 165140},
	{15224, 165144},
	{15246, 165148},
	{15267, 165152},
	{15289, 165156},
	{15310, 165160},
	{15332, 165164},
	{15354, 165168},
	{15377, 165172},
	{15399, 165176},
	{15422, 165180},
	{15444, 165184},
	{15467, 165188},
	{15489, 165192},
	{15512, 165196},
	{15534, 165200},
	{15557, 165204},
	{15579, 165208},
	{15602, 165212},
	{15624, 165216},
	{15647, 165220},
	{15669, 165224},
	{15692, 165228},
	{15714, 165232},
	{15737, 165236},
	{15759, 165240},
	{15782, 165244},
	{15804, 165248},
	{15827, 165252},
	{15849, 165256},
	{15872, 165260},
	{15894, 165264},
	{15917, 165268},
	{15939, 165272},
	{15962, 165276},
	{15984, 165280},
	{16007, 165284},
	{16029, 165288},
	{16052, 165292},
	{16074, 165296},
	{16097, 165300},
	{16119, 165304},
	{16142, 165308},
	{16156, 165312},
	{16170, 165316},
	{16184, 165320},
	{16198, 165324},
	{16212, 165328},
	{16226, 165332},
	{16240, 165336},
	{16254, 165340},
	{16268, 165344},
	{16282, 165348},
	{16296, 165352},
	{16310, 165356},
	{16324, 165360},
	{16338, 165364},
	{16352, 165368},
	{16366, 165372},
	{16380, 165376},
	{16394, 165380},
	{16408, 165384},
	{16422, 165388},
	{16436, 165392},
	{16450, 165396},
	{16464, 165400},
	{16501, 165444, 12, 949},
	{16521, 165448, 12, 949},
	{16541, 165452, 12, 949},
	{16561, 165456, 12, 949},
	{16581, 165460, 12, 949},
	{16601, 165464, 12, 949},
	{16621, 165468, 12, 949},
	{16641, 165472, 12, 949},
	{16661, 165476, 12, 949},
	{16681, 165480, 12, 949},
	{16701, 165484, 12, 949},
	{16722, 165488, 12, 949},
	{16743, 165492, 12, 949},
	{16764, 165496, 12, 949},
	{16785, 165500, 12, 949},
	{16806, 165504, 12, 949},
	{16827, 165508, 12, 949},
	{16848, 165512, 12, 949},
	{16869, 165516, 12, 949},
	{16890, 165520, 12, 949},
	{16911, 165524, 9, 961},
	{16932, 165528, 9, 961},
	{16953, 165532, 9, 961},
	{16974, 165536, 9, 961},
	{16995, 165540, 9, 961},
	{17016, 165544, 9, 961},
	{17037, 165548, 9, 961},
	{17058, 165552, 9, 961},
	{17079, 165556, 9, 961},
	{17100, 165560, 9, 961},
	{17121, 165564, 9, 961},
	{17142, 165568, 9, 961},
	{17163, 165572, 2, 970},
	{17181, 165580, 16, 973},
	{17198, 165584, 16, 973},
	{17216, 165588, 7, 989},
	{17237, 165592, 3, 3842},
	{17255, 165600, 7, 1002},
	{17270, 165608, 2, 694},
	{17309, 165644, 4, 1010},
	{17331, 165648, 1, 1015},
	{17351, 165652, 8, 1016},
	{17373, 165716, 8, 1024},
	{17391, 165720, 8, 1032},
	{17412, 165724, 17, 1040},
	{17433, 165728, 6, 1057},
	{17451, 165732, 6, 1057},
	{17469, 165736, 6, 1057},
	{17487, 165740, 6, 1057},
	{17505, 165744, 6, 1057},
	{17523, 165748, 6, 1057},
	{17541, 165752, 6, 1057},
	{17559, 165756, 6, 1057},
	{17577, 165760, 9, 1063},
	{17595, 165764, 9, 1063},
	{17613, 165768, 9, 1063},
	{17631, 165772, 9, 1063},
	{17649, 165776, 9, 1063},
	{17667, 165780, 9, 1063},
	{17685, 165784, 9, 1063},
	{17703, 165788, 9, 1063},
	{17721, 165836, 1, 1072},
	{17735, 165840, 1, 1072},
	{17750, 165844},
	{17768, 165848},
	{17786, 165852},
	{17803, 165856},
	{17824, 165860, 1, 3845},
	{17840, 165864},
	{17853, 165872, 5, 1074},
	{17872, 165876},
	{17887, 165880, 1, 1082},
	{17936, 165888, 10, 1084},
	{17953, 165892, 12, 1094},
	{17961, 165896, 4, 4514},
	{17978, 165900, 13, 1110},
	{17996, 165904, 19, 1127},
	{18012, 165908, 13, 1147},
	{18031, 165912, 10, 1163},
	{18046, 165916, 27, 4357},
	{18064, 165920, 16, 1201},
	{18082, 165924, 4, 1217},
	{18106, 165928},
	{18131, 165932, 11, 1221},
	{18283, 166400, 2, 1253},
	{18300, 166404, 2, 1255},
	{18319, 166408, 1, 1257},
	{18335, 166412, 4, 1258},
	{18354, 166416, 1, 1262},
	{18375, 166420, 1, 1263},
	{18388, 166424},
	{18411, 166428},
	{18434, 166432, 1, 1264},
	{18454, 166436, 4, 3849},
	{18474, 166440, 1, 1269},
	{18495, 166444, 1, 1270},
	{18510, 166448, 6, 1271},
	{18532, 166452, 6, 1271},
	{18554, 166456, 8, 1277},
	{18580, 166460, 8, 1277},
	{18606, 166464, 15, 4384},
	{18618, 166468, 2, 1300},
	{18637, 166472, 4, 1303},
	{18655, 166476, 24, 1310},
	{18673, 166480},
	{18685, 166484, 1, 1334},
	{18699, 166488, 1, 1335},
	{18713, 166492, 1, 1336},
	{18727, 166496, 1, 1337},
	{18750, 166500, 1, 1337},
	{18773, 166504, 1, 1337},
	{18796, 166508, 5, 3853},
	{18817, 166512},
	{18828, 166516},
	{18841, 166520},
	{18858, 166524, 7, 4399},
	{18877, 166528},
	{18888, 166532, 2, 1351},
	{18907, 166536},
	{18929, 166540},
	{18951, 166544, 3, 4406},
	{18971, 166548, 1, 1357},
	{19020, 166560},
	{19045, 166564},
	{19070, 166568, 7, 4409},
	{19089, 166572, 1, 1370},
	{19112, 166576, 1, 1370},
	{19135, 166580, 1, 1371},
	{19149, 166584, 1, 1372},
	{19164, 166588, 8, 4416},
	{19181, 166592, 4, 1382},
	{19208, 166596, 4, 1386},
	{19235, 166600, 4, 1390},
	{19254, 166608},
	{19280, 166612, 1, 1394},
	{19305, 166620},
	{19333, 166624},
	{19359, 166628, 1, 1394},
	{19384, 166636},
	{19412, 166640},
	{19438, 166644, 1, 1394},
	{19463, 166652},
	{19491, 166656},
	{19517, 166660, 1, 1394},
	{19542, 166668},
	{19570, 166696},
	{19601, 166700},
	{19644, 166704, 1, 1395},
	{19682, 166712, 1, 1396},
	{19721, 166736, 4, 4518},
	{19743, 166740, 10, 1404},
	{19764, 166744, 3, 1423},
	{19781, 166748, 1, 1370},
	{19802, 166752, 1, 1370},
	{19825, 166756, 1, 1370},
	{19848, 166760, 1, 1370},
	{19871, 166764, 10, 4424},
	{19884, 166768, 6, 1438},
	{19901, 166772},
	{19925, 166776, 2, 1444},
	{19955, 166780},
	{19979, 166784},
	{20009, 166788},
	{20040, 166792},
	{20069, 166796},
	{20099, 166800, 2, 1446},
	{20119, 166804, 7, 3883},
	{20138, 166808, 4, 1457},
	{20188, 166868, 8, 1461},
	{20214, 166872, 8, 1469},
	{20240, 166876, 4, 1477},
	{20256, 166880, 5, 1482},
	{20272, 166884, 3, 1488},
	{20287, 166888},
	{20310, 166892},
	{20333, 166896},
	{20356, 166900},
	{20379, 166904, 8, 1491},
	{20413, 166908, 8, 1499},
	{20447, 166912, 8, 1507},
	{20481, 166916, 8, 1515},
	{20515, 166920, 8, 1491},
	{20549, 166924, 8, 1499},
	{20583, 166928, 8, 1507},
	{20617, 166932, 8, 1515},
	{20651, 166936, 8, 1491},
	{20685, 166940, 8, 1499},
	{20719, 166944, 8, 1507},
	{20753, 166948, 8, 1515},
	{20787, 166952, 8, 1491},
	{20821, 166956, 8, 1499},
	{20855, 166960, 8, 1507},
	{20889, 166964, 8, 1515},
	{20923, 166968, 2, 1523},
	{20947, 166972, 2, 1525},
	{20971, 166976, 1, 1527},
	{21090, 167000, 1, 1567},
	{21118, 167004, 1, 1568},
	{21139, 167008},
	{21154, 167012, 2, 1569},
	{21170, 167016, 1, 1571},
	{21186, 167020, 2, 3814},
	{21201, 167024, 18, 4522},
	{21216, 167028, 6, 1594},
	{21233, 167032, 9, 1602},
	{21255, 167036},
	{21271, 167040, 1, 1614},
	{21293, 167044},
	{21309, 167048, 1, 1571},
	{21331, 167052},
	{21353, 167056},
	{21375, 167060},
	{21394, 167068},
	{21409, 167072, 2, 1569},
	{21425, 167076, 1, 1571},
	{21441, 167080, 2, 3814},
	{21456, 167084, 18, 4522},
	{21471, 167088, 6, 1594},
	{21488, 167092, 9, 1602},
	{21510, 167096},
	{21526, 167100, 1, 1614},
	{21548, 167104},
	{21564, 167108, 1, 1571},
	{21586, 167112},
	{21608, 167116},
	{21630, 167120},
	{21649, 167128},
	{21664, 167132, 2, 1569},
	{21680, 167136, 1, 1571},
	{21696, 167140, 2, 3814},
	{21711, 167144, 18, 4522},
	{21726, 167148, 6, 1594},
	{21743, 167152, 9, 1602},
	{21765, 167156},
	{21781, 167160, 1, 1614},
	{21803, 167164},
	{21819, 167168, 1, 1571},
	{21841, 167172},
	{21863, 167176},
	{21885, 167180},
	{21904, 167188},
	{21919, 167192, 2, 1569},
	{21935, 167196, 1, 1571},
	{21951, 167200, 2, 3814},
	{21966, 167204, 18, 4522},
	{21981, 167208, 6, 1594},
	{21998, 167212, 9, 1602},
	{22020, 167216},
	{22036, 167220, 1, 1614},
	{22058, 167224},
	{22074, 167228, 1, 1571},
	{22096, 167232},
	{22118, 167236},
	{22140, 167240},
	{22159, 167248},
	{22174, 167252, 2, 1569},
	{22190, 167256, 1, 1571},
	{22206, 167260, 2, 3814},
	{22221, 167264, 18, 4522},
	{22236, 167268, 6, 1594},
	{22253, 167272, 9, 1602},
	{22275, 167276},
	{22291, 167280, 1, 1614},
	{22313, 167284},
	{22329, 167288, 1, 1571},
	{22351, 167292},
	{22373, 167296},
	{22395, 167300},
	{22414, 167308},
	{22429, 167312, 2, 1569},
	{22445, 167316, 1, 1571},
	{22461, 167320, 2, 3814},
	{22476, 167324, 18, 4522},
	{22491, 167328, 6, 1594},
	{22508, 167332, 9, 1602},
	{22530, 167336},
	{22546, 167340, 1, 1614},
	{22568, 167344},
	{22584, 167348, 1, 1571},
	{22606, 167352},
	{22628, 167356},
	{22650, 167360},
	{22669, 167368},
	{22684, 167372, 2, 1569},
	{22700, 167376, 1, 1571},
	{22716, 167380, 2, 3814},
	{22731, 167384, 18, 4522},
	{22746, 167388, 6, 1594},
	{22763, 167392, 9, 1602},
	{22785, 167396},
	{22801, 167400, 1, 1614},
	{22823, 167404},
	{22839, 167408, 1, 1571},
	{22861, 167412},
	{22883, 167416},
	{22905, 167420},
	{22924, 167428},
	{22939, 167432, 2, 1569},
	{22955, 167436, 1, 1571},
	{22971, 167440, 2, 3814},
	{22986, 167444, 18, 4522},
	{23001, 167448, 6, 1594},
	{23018, 167452, 9, 1602},
	{23040, 167456},
	{23056, 167460, 1, 1614},
	{23078, 167464},
	{23094, 167468, 1, 1571},
	{23116, 167472},
	{23138, 167476},
	{23160, 167480},
	{24203, 196608, 1, 1627},
	{24223, 196612, 1, 1628},
	{24243, 196616},
	{24263, 196620},
	{24283, 196624},
	{24304, 196628},
	{24325, 196632, 1, 1629},
	{24347, 196636, 1, 1630},
	{24369, 196640},
	{24399, 196644},
	{24429, 196648},
	{24458, 196652},
	{24487, 196656},
	{24517, 196660},
	{24547, 196664},
	{24576, 196668},
	{24605, 196672},
	{24635, 196676},
	{24665, 196680},
	{24694, 196684},
	{24723, 196688},
	{24753, 196692},
	{24783, 196696},
	{24812, 196700},
	{24841, 196704, 1, 1631},
	{24863, 196708, 1, 1632},
	{24885, 196712},
	{24908, 196716},
	{24931, 196720},
	{24954, 196724},
	{24977, 196728},
	{25000, 196732},
	{25023, 196736},
	{25047, 196740},
	{25071, 196744},
	{25095, 196748},
	{25119, 196752},
	{25143, 196756},
	{25167, 196760},
	{25191, 196764},
	{25215, 196768},
	{25237, 196772},
	{25259, 196776},
	{25280, 196780},
	{25301, 196784},
	{25325, 196788},
	{25349, 196792},
	{25373, 196796},
	{25397, 196800},
	{25421, 196804},
	{25505, 196852, 2, 4452},
	{25527, 196856, 2, 4452},
	{25549, 196860, 1, 1635},
	{25565, 196864},
	{25578, 196868},
	{25591, 196872},
	{25604, 196876},
	{25617, 196880},
	{25630, 196884},
	{25643, 196888},
	{25656, 196892},
	{25783, 196928, 2, 1636},
	{25796, 196932},
	{25809, 196936},
	{25832, 196940},
	{25855, 196944},
	{25883, 196948},
	{25911, 196952},
	{25939, 196956},
	{25967, 196960, 1, 1638},
	{25985, 196964, 5, 4454},
	{26003, 196968},
	{26018, 196972},
	{26042, 196976},
	{26066, 196980},
	{26085, 196984},
	{26104, 196988},
	{26128, 196992},
	{26152, 196996},
	{26176, 197000},
	{26200, 197028, 2, 3040},
	{26218, 197032, 3, 4459},
	{26236, 197036},
	{26254, 197040},
	{26272, 197044, 2, 3043},
	{26290, 197048, 3, 4462},
	{26308, 197052},
	{26326, 197056, 2, 1649},
	{26345, 197060, 5, 1651},
	{26364, 197072},
	{26388, 197076, 2, 1649},
	{26408, 197080, 5, 1651},
	{26428, 197084, 8, 4465},
	{26447, 197088, 8, 4465},
	{26465, 197092, 1, 1663},
	{26482, 197100, 1, 1664},
	{26503, 197104, 26, 4473},
	{26517, 197108},
	{26531, 197112},
	{26545, 197116, 4, 3074},
	{26561, 197120},
	{26580, 197124, 1, 1680},
	{26602, 197128},
	{26621, 197132, 1, 1681},
	{26643, 197136, 9, 3080},
	{26661, 197140},
	{26681, 197144, 1, 1680},
	{26704, 197148},
	{26724, 197152, 1, 1681},
	{26747, 197156, 9, 3080},
	{26766, 197160, 5, 3089},
	{26778, 197164, 2, 1696},
	{26795, 197168, 1, 1698},
	{26812, 197172, 1, 1699},
	{26830, 197176, 4, 1700},
	{26850, 197180, 1, 1704},
	{26867, 197184},
	{26883, 197188, 1, 1706},
	{26896, 197192, 1, 1707},
	{26910, 197196, 1, 1708},
	{26924, 197200, 1, 1709},
	{26946, 197204, 1, 1710},
	{26966, 197208, 1, 1711},
	{26988, 197212, 1, 1712},
	{27008, 197216, 1, 1707},
	{27025, 197220, 1, 1708},
	{27042, 197224},
	{52837, 197228, 1, 1706},
	{27301, 197388, 1, 1721},
	{27320, 197392, 1, 1722},
	{27339, 197396, 1, 1723},
	{27356, 197400, 1, 1724},
	{27374, 197404, 1, 1725},
	{27392, 197408, 1, 1726},
	{27408, 197412, 1, 1727},
	{27426, 197416, 1, 1728},
	{27444, 197420, 1, 1729},
	{27460, 197424, 1, 1724},
	{27475, 197428, 1, 1725},
	{27490, 197432, 1, 1726},
	{27503, 197436, 1, 1727},
	{27518, 197440, 1, 1728},
	{27533, 197444, 1, 1729},
	{27546, 197448, 1, 1730},
	{27560, 197452, 1, 1731},
	{27574, 197456, 1, 1732},
	{27586, 197460, 4, 4499},
	{27609, 197464, 4, 4092},
	{27631, 197468, 1, 1740},
	{27775, 197552, 1, 1745},
	{27800, 197556, 1, 1745},
	{27824, 197560, 1, 1746},
	{27844, 197568},
	{27870, 197572, 1, 1628},
	{27899, 197576},
	{27924, 197580, 1, 1628},
	{27952, 197584},
	{27975, 197588, 1, 1628},
	{28001, 197592},
	{28023, 197596, 1, 1628},
	{28048, 197600},
	{28067, 197604, 1, 1628},
	{28089, 197608, 1, 1343},
	{28103, 197612},
	{28120, 197616, 1, 1628},
	{28140, 197620, 8, 1747},
	{28309, 198656, 6, 2946},
	{48507, 198912},
	{48526, 198916},
	{28370, 198920, 1, 3329},
	{28389, 198924, 1, 1343},
	{28404, 198928},
	{28437, 198932},
	{28470, 198936},
	{28503, 198940},
	{28593, 198960},
	{28609, 198964},
	{49020, 198968, 1, 1785},
	{49052, 198972, 2, 1786},
	{49073, 198976},
	{29013, 199168, 1, 1809},
	{29038, 199172, 2, 1810},
	{29063, 199184, 2, 1812},
	{29089, 199188, 2, 1812},
	{29115, 199192, 2, 1812},
	{29141, 199212, 2, 1812},
	{29167, 199296, 2, 1814},
	{29195, 199300, 1, 1816},
	{29219, 199304, 1, 1817},
	{29243, 199308, 1, 1818},
	{29276, 199312, 1, 1818},
	{29304, 199328, 2, 1814},
	{29333, 199332, 1, 1816},
	{29358, 199336, 1, 1817},
	{29383, 199340, 1, 1818},
	{29417, 199344, 1, 1818},
	{29446, 199360, 2, 1814},
	{29470, 199364, 1, 1816},
	{29490, 199368, 1, 1817},
	{29510, 199372, 1, 1818},
	{29539, 199376, 1, 1818},
	{49639, 199872},
	{49660, 199876, 1, 3506},
	{2095, 199880, 8, 4060},
	{2116, 199884, 3, 3515},
	{49681, 199888, 2, 3518},
	{2143, 199892, 1, 3542},
	{49707, 199896, 15, 3527},
	{50710, 199900, 1, 4069},
	{50732, 199904},
	{2074, 199908, 2, 3520},
	{2164, 199912, 5, 4072},
	{49749, 199916, 1, 3543},
	{29563, 199936},
	{29590, 199940},
	{29617, 199944},
	{29644, 199948},
	{29779, 199968, 6, 1819},
	{29790, 199972, 2, 1826},
	{29804, 200192},
	{29823, 200196, 1, 840},
	{29845, 200448},
	{29869, 200452, 1, 1828},
	{29892, 200456},
	{29916, 200460, 1, 1828},
	{29939, 200464},
	{29963, 200468, 1, 1828},
	{29986, 200472},
	{30010, 200476, 1, 1828},
	{30033, 200696},
	{30052, 200700, 1, 1828},
	{30070, 200704},
	{30082, 200708},
	{30094, 200712},
	{30112, 200716},
	{30131, 200720},
	{30149, 200724},
	{30161, 200728},
	{30173, 200732},
	{30191, 200736},
	{30209, 200740},
	{30228, 200744, 4, 1829},
	{30242, 200748, 2, 1833},
	{30260, 200752, 2, 1835},
	{30274, 200756, 2, 1837},
	{30288, 200760, 2, 1839},
	{30305, 200764, 2, 1841},
	{30322, 200768},
	{30335, 200772, 2, 1843},
	{30347, 200776},
	{30361, 200780},
	{30377, 200784},
	{30391, 200788},
	{30407, 200792},
	{30422, 200796},
	{30439, 200800},
	{30454, 200804},
	{30471, 200808, 2, 1845},
	{30493, 200812, 9, 4540},
	{30510, 200816, 2, 1857},
	{30531, 200820, 2, 1859},
	{30543, 200824},
	{30558, 200828, 6, 4503},
	{30573, 200832, 2, 1867},
	{30587, 200836},
	{30700, 212992},
	{30720, 212996},
	{30740, 213000},
	{30760, 213004},
	{30780, 213008},
	{30800, 213012},
	{30820, 213016},
	{30840, 213020},
	{30860, 213024},
	{30880, 213028},
	{30900, 213032},
	{30920, 213036},
	{31009, 213248},
	{31030, 213252},
	{31051, 213260},
	{31072, 213264},
	{31093, 213268},
	{31117, 213272},
	{31141, 213276},
	{31165, 213280},
	{31189, 213284},
	{31213, 213288},
	{31237, 213292},
	{31261, 213296},
	{50822, 213504},
	{50841, 213508},
	{50860, 213512},
	{50879, 213516},
	{50898, 213520},
	{50917, 213524},
	{50936, 213528},
	{50955, 213532},
	{48217, 213536},
	{48236, 213540},
	{48255, 213544},
	{48274, 213548},
	{48293, 213552},
	{48312, 213556},
	{48331, 213560},
	{48350, 213564},
	{48808, 213568},
	{48828, 213572},
	{48848, 213576},
	{48868, 213580},
	{48888, 213584},
	{48908, 213588},
	{48928, 213592},
	{48948, 213596},
	{31745, 214016},
	{31767, 214020, 1, 1869},
	{31789, 214024},
	{31811, 214028, 1, 1869},
	{31833, 214032},
	{31855, 214036, 1, 1869},
	{31877, 214040},
	{31899, 214044, 1, 1869},
	{31921, 214272},
	{31943, 214276},
	{31965, 214280},
	{31987, 214284},
	{32009, 214288},
	{32031, 214292},
	{32053, 214296},
	{32075, 214300},
	{32097, 214304},
	{32119, 214308},
	{32141, 214312},
	{32163, 214316},
	{32185, 214320},
	{32207, 214324},
	{32229, 214328},
	{32251, 214332},
	{32273, 214528},
	{32293, 214532},
	{32313, 214536},
	{32333, 214540},
	{32353, 214544},
	{32373, 214548},
	{32393, 214552},
	{32413, 214556},
	{32433, 214560},
	{32453, 214564},
	{32473, 214568},
	{32493, 214572},
	{32513, 214784},
	{32532, 214788},
	{32551, 214792},
	{32570, 214796},
	{32589, 214800},
	{32608, 214804},
	{32627, 214808},
	{32646, 214812},
	{32665, 214816},
	{32684, 214820},
	{32703, 214824},
	{32722, 214828},
	{32741, 214832},
	{32760, 214836},
	{32779, 214840},
	{32798, 214844},
	{32817, 214848},
	{32836, 214852},
	{32855, 214856},
	{32874, 214860},
	{32893, 214864},
	{32913, 214868},
	{32933, 214872},
	{32953, 214876},
	{32973, 214880},
	{32993, 214884},
	{33013, 214888},
	{33033, 214892},
	{33053, 214896},
	{33073, 214900},
	{33093, 214904},
	{33113, 214908},
	{33133, 215296},
	{33152, 215300},
	{33171, 215304},
	{33190, 215308},
	{33209, 215312},
	{33228, 215316},
	{33247, 215320},
	{33266, 215324},
	{33327, 215552},
	{33347, 215556},
	{33367, 215560},
	{33387, 215564},
	{33407, 215568},
	{33427, 215572},
	{33447, 215576},
	{33467, 215580},
	{33487, 215808},
	{33506, 215812},
	{33525, 215816},
	{33544, 215820},
	{33563, 216064},
	{33582, 216068},
	{33601, 216072},
	{33620, 216076},
	{33639, 216320},
	{33659, 216324},
	{33679, 216328},
	{33699, 216332},
	{33719, 216336},
	{33739, 216340},
	{33759, 216344},
	{33779, 216348},
	{50974, 216576},
	{50994, 216580},
	{51014, 216584},
	{51034, 216588},
	{51054, 216592},
	{51074, 216596},
	{51094, 216600},
	{51114, 216604},
	{51134, 216640},
	{51154, 216644},
	{51174, 216648},
	{51194, 216652},
	{51214, 216656},
	{51234, 216660},
	{51254, 216664},
	{51274, 216668},
	{34631, 217112},
	{34650, 217116},
	{34669, 217120},
	{34688, 217124},
	{34707, 217128},
	{34726, 217132},
	{34745, 217136},
	{34764, 217140},
	{34783, 217344},
	{34802, 217348},
	{34821, 217352},
	{34840, 217356},
	{34859, 217360},
	{34878, 217364},
	{34897, 217368},
	{34916, 217372},
	{34935, 217600},
	{34955, 217604},
	{34975, 217608},
	{34995, 217612},
	{36317, 221184, 1, 1903},
	{36341, 221188, 2, 4109},
	{36366, 221192, 3, 4111},
	{36390, 221196, 1, 1903},
	{36414, 221200, 2, 4109},
	{36439, 221204, 1, 1903},
	{36463, 221208, 2, 4109},
	{36488, 221212, 3, 4111},
	{36512, 221216, 4, 1881},
	{36528, 221220, 3, 4111},
	{36695, 221248},
	{36710, 221252, 1, 1818},
	{36733, 221256},
	{36756, 221260},
	{36774, 221264, 2, 1897},
	{36792, 221268, 4, 1899},
	{36812, 221440, 19, 2989},
	{36837, 221444, 19, 2989},
	{36862, 221448, 12, 3008},
	{36890, 221452, 12, 3008},
	{36918, 221456, 12, 3008},
	{36946, 221460, 12, 3008},
	{51454, 221696, 2, 3287},
	{51477, 221700, 2, 3287},
	{51500, 221704, 2, 3287},
	{51523, 221708, 2, 3287},
	{48125, 221712, 5, 1957},
	{48148, 221716, 2, 3287},
	{48171, 221720, 2, 3287},
	{48194, 221724, 2, 3287},
	{51546, 221728, 4, 1962},
	{48712, 221744, 5, 1957},
	{48736, 221748, 5, 1957},
	{48760, 221752, 2, 3287},
	{48784, 221756, 2, 3287},
	{51570, 221760, 4, 1962},
	{51595, 221764, 4, 1962},
	{48686, 221776, 1, 3328},
	{37404, 222208, 3, 1957},
	{37430, 222212, 2, 1877},
	{37457, 222216, 3, 1957},
	{37483, 222220, 2, 1877},
	{37510, 222224, 2, 2013},
	{37563, 222228, 2, 2013},
	{37616, 222464, 3, 1957},
	{37642, 222468, 2, 1877},
	{37669, 222472, 1, 1872},
	{37695, 222476, 1, 1872},
	{37721, 222480, 1, 1872},
	{37747, 222484, 1, 1872},
	{37773, 222488, 1, 1872},
	{37799, 222492, 1, 1872},
	{37825, 222496, 1, 1872},
	{37851, 222720, 3, 1957},
	{37875, 222724, 3, 1957},
	{37899, 222728, 3, 1957},
	{37923, 222732, 3, 1957},
	{37947, 222736, 2, 1877},
	{37972, 222740, 2, 1877},
	{37997, 222744, 2, 1877},
	{38022, 222748, 2, 1877},
	{38047, 222752, 1, 2001},
	{38071, 222756, 1, 2001},
	{38095, 222760, 8, 1966},
	{38116, 222976, 6, 3486},
	{38139, 222980, 6, 3486},
	{38162, 222984, 6, 3486},
	{38185, 222988, 6, 3486},
	{38208, 222992, 6, 3486},
	{38231, 222996, 6, 3486},
	{38254, 223000, 6, 3486},
	{38277, 223004, 6, 3486},
	{38300, 223008, 6, 3486},
	{38323, 223012, 6, 3486},
	{38346, 223016, 6, 3486},
	{38370, 223020, 6, 3486},
	{38394, 223024, 6, 3486},
	{38418, 223028, 6, 3486},
	{38442, 223032, 6, 3486},
	{38466, 223036, 6, 3486},
	{38490, 223104, 9, 3469},
	{51620, 223108, 2, 3518},
	{38510, 223112, 1, 1987},
	{38605, 223488, 3, 1996},
	{38628, 223492, 3, 1996},
	{38651, 223496, 3, 1996},
	{38674, 223500, 3, 1996},
	{38697, 223504, 2, 1999},
	{38721, 223508, 2, 1999},
	{38745, 223744, 3, 1996},
	{38769, 223748, 3, 1996},
	{38793, 223752, 3, 1996},
	{38817, 223756, 3, 1996},
	{38841, 223760, 2, 1999},
	{38866, 224000, 5, 2001},
	{38889, 224004, 4, 2006},
	{38913, 224008, 5, 2001},
	{38936, 224256, 5, 2001},
	{38959, 224260, 4, 2006},
	{38983, 224264, 5, 2001},
	{39006, 224512, 5, 1957},
	{39030, 224516, 4, 1962},
	{39055, 224520, 5, 1957},
	{39079, 224524, 4, 1962},
	{39104, 224528, 3, 2013},
	{39128, 224532, 3, 2013},
	{51640, 224768, 5, 1957},
	{51664, 224772, 4, 1951},
	{51689, 224776, 5, 1957},
	{51713, 224780, 4, 1951},
	{51738, 224784, 3, 2013},
	{51762, 224788, 3, 2013},
	{51786, 224832, 5, 1957},
	{51810, 224836, 4, 1951},
	{51835, 224840, 5, 1957},
	{51859, 224844, 4, 1951},
	{51884, 224848, 3, 2013},
	{51908, 224852, 3, 2013},
	{39829, 225280, 12, 2016},
	{39851, 225284, 5, 2028},
	{39874, 225288, 4, 2033},
	{39898, 225292, 2, 2037},
	{39921, 225296, 2, 2037},
	{39944, 225300, 2, 2037},
	{39967, 225536, 5, 1957},
	{39990, 225540, 4, 1962},
	{40014, 225544, 5, 1957},
	{40037, 225548, 4, 1962},
	{40061, 225552, 5, 1957},
	{40084, 225560, 5, 1957},
	{40107, 225792, 4, 2039},
	{40128, 225796},
	{40157, 225800, 2, 2043},
	{40186, 225804},
	{40212, 225808, 7, 2045},
	{40286, 225812},
	{40309, 225816},
	{52053, 225820, 2, 4120},
	{52086, 225824, 2, 4120},
	{52119, 225828, 2, 4120},
	{52152, 225832, 2, 4120},
	{52184, 225836, 2, 4120},
	{52216, 225840, 2, 4120},
	{52248, 225844, 2, 4120},
	{52281, 225848, 2, 4120},
	{52313, 225856, 2, 4120},
	{52345, 225860, 2, 4120},
	{52378, 225864, 2, 4120},
	{52411, 225868, 2, 4120},
	{52444, 225872, 2, 4120},
	{52476, 225876, 2, 4120},
	{52508, 225880, 2, 4120},
	{52541, 225884, 2, 4120},
	{52574, 225888, 2, 4120},
	{52640, 225896, 2, 4120},
	{40332, 225900},
	{40359, 225904},
	{40241, 225908},
	{40260, 225912},
	{41229, 226044, 1, 2129},
	{41022, 226048, 2, 2119},
	{41039, 226052, 1, 2121},
	{41063, 226056, 1, 2121},
	{195, 880, 4, 2156},
	{42808, 881},
	{26631, 882},
	{42820, 1008},
	{42831, 1009},
	{26819, 1010, 3, 2160},
	{42842, 1040, 1, 2163},
	{42855, 1041, 5, 4122},
	{42868, 1042, 1, 2169},
	{42881, 1043, 1, 1681},
	{26653, 1045, 9, 3914},
	{42909, 1280, 6, 4127},
	{42924, 1281},
	{26590, 1282},
	{42808, 1283},
	{26631, 1284},
};

static const struct si_reg gfx9_reg_table[] = {
	{974, 68, 14, 4549},
	{987, 72, 23, 4563},
	{1002, 76, 7, 4586},
	{46947, 80, 11, 3939},
	{1039, 84, 4, 2800},
	{1057, 88, 2, 2804},
	{1075, 92, 7, 4593},
	{1090, 96},
	{1104, 100, 1, 70},
	{1118, 104},
	{46961, 108},
	{46978, 112, 13, 4600},
	{1135, 116, 7, 4613},
	{1151, 120},
	{1273, 2480},
	{1287, 2484},
	{1301, 2488},
	{1315, 2492},
	{1329, 2496},
	{1343, 2500},
	{1357, 2504},
	{1371, 2508},
	{1385, 2512},
	{1399, 2516},
	{1413, 2520},
	{1428, 2524},
	{1443, 2528},
	{1458, 2532},
	{1473, 2536},
	{1488, 2540},
	{1503, 2544},
	{1514, 2552},
	{1530, 2556},
	{1618, 32776, 25, 4620},
	{1631, 32784, 24, 4645},
	{1643, 32788, 12, 4669},
	{1659, 32792, 12, 4669},
	{1688, 32824, 12, 4669},
	{1704, 32828, 12, 4669},
	{1720, 33296, 16, 4681},
	{1734, 33300, 28, 204},
	{1751, 33304, 14, 232},
	{1772, 33308, 21, 4697},
	{1786, 33312, 31, 4022},
	{1803, 33316, 11, 307},
	{1842, 33324, 1, 329},
	{1865, 33344, 1, 330},
	{1886, 33348},
	{1906, 33352, 1, 332},
	{1947, 33436, 1, 342},
	{2351, 36608},
	{2369, 36612, 4, 383},
	{2387, 36616},
	{2405, 36620, 12, 4718},
	{3306, 36624},
	{3324, 36628, 8, 4730},
	{3342, 36632, 3, 3587},
	{3360, 36636, 8, 4738},
	{3378, 36640, 3, 4746},
	{3396, 36644, 7, 4749},
	{3414, 36648, 8, 4290},
	{3432, 36652},
	{2423, 36656, 14, 4298},
	{2441, 36660, 4, 411},
	{2459, 36664, 10, 4756},
	{2477, 36668, 3, 4766},
	{2511, 39160, 13, 4769},
	{2526, 39184, 5, 3645},
	{2540, 39188, 5, 3645},
	{2554, 39192, 5, 3645},
	{2568, 39196, 5, 3645},
	{2582, 39200, 5, 3645},
	{2596, 39204, 5, 3645},
	{2610, 39208, 5, 3645},
	{2624, 39212, 5, 3645},
	{2638, 39216, 5, 3645},
	{2652, 39220, 5, 3645},
	{2666, 39224, 5, 3645},
	{2681, 39228, 5, 3645},
	{2696, 39232, 5, 3645},
	{2711, 39236, 5, 3645},
	{2726, 39240, 5, 3645},
	{2741, 39244, 5, 3645},
	{2756, 39248, 5, 3645},
	{2771, 39252, 5, 3645},
	{2786, 39256, 5, 3645},
	{2801, 39260, 5, 3645},
	{2816, 39264, 5, 3645},
	{2831, 39268, 5, 3645},
	{2846, 39272, 5, 3645},
	{2861, 39276, 5, 3645},
	{2876, 39280, 5, 3645},
	{2891, 39284, 5, 3645},
	{2906, 39288, 5, 3645},
	{2921, 39292, 5, 3645},
	{2936, 39296, 5, 3645},
	{2951, 39300, 5, 3645},
	{2966, 39304, 5, 3645},
	{2981, 39308, 5, 3645},
	{2996, 39312, 4, 448},
	{3015, 39316, 4, 448},
	{3034, 39320, 4, 448},
	{3053, 39324, 4, 448},
	{3072, 39328, 4, 448},
	{3091, 39332, 4, 448},
	{3110, 39336, 4, 448},
	{3129, 39340, 4, 448},
	{3148, 39344, 4, 448},
	{3167, 39348, 4, 448},
	{3186, 39352, 4, 448},
	{3206, 39356, 4, 448},
	{3226, 39360, 4, 448},
	{3246, 39364, 4, 448},
	{3266, 39368, 4, 448},
	{3286, 39372, 4, 448},
	{3499, 45084, 4, 4782},
	{3523, 45088},
	{3544, 45092, 1, 491},
	{3565, 45096, 11, 4786},
	{3589, 45100, 10, 4797},
	{3613, 45104},
	{3639, 45108},
	{3665, 45112},
	{3691, 45116},
	{3717, 45120},
	{3743, 45124},
	{3769, 45128},
	{3795, 45132},
	{3821, 45136},
	{3847, 45140},
	{3873, 45144},
	{3900, 45148},
	{3927, 45152},
	{3954, 45156},
	{3981, 45160},
	{4008, 45164},
	{4035, 45168},
	{4062, 45172},
	{4089, 45176},
	{4116, 45180},
	{4143, 45184},
	{4170, 45188},
	{4197, 45192},
	{4224, 45196},
	{4251, 45200},
	{4278, 45204},
	{4305, 45208},
	{4332, 45212},
	{4359, 45216},
	{4386, 45220},
	{4413, 45224},
	{4440, 45228},
	{4680, 45336, 4, 4782},
	{4704, 45340, 1, 527},
	{4729, 45344},
	{4750, 45348, 1, 491},
	{4771, 45352, 12, 4807},
	{4795, 45356, 14, 4819},
	{4819, 45360},
	{4845, 45364},
	{4871, 45368},
	{4897, 45372},
	{4923, 45376},
	{4949, 45380},
	{4975, 45384},
	{5001, 45388},
	{5027, 45392},
	{5053, 45396},
	{5079, 45400},
	{5106, 45404},
	{5133, 45408},
	{5160, 45412},
	{5187, 45416},
	{5214, 45420},
	{5241, 45424},
	{5268, 45428},
	{5295, 45432},
	{5322, 45436},
	{5349, 45440},
	{5376, 45444},
	{5403, 45448},
	{5430, 45452},
	{5457, 45456},
	{5484, 45460},
	{5511, 45464},
	{5538, 45468},
	{5565, 45472},
	{5592, 45476},
	{5619, 45480},
	{5646, 45484},
	{5837, 45552, 9, 554},
	{5943, 45572, 2, 4833},
	{5967, 45576},
	{5999, 45580},
	{7274, 45584},
	{7295, 45588, 1, 491},
	{6079, 45596, 4, 4782},
	{6103, 45600},
	{6124, 45604, 1, 491},
	{6145, 45608, 12, 4835},
	{6169, 45612, 9, 4847},
	{7364, 45872},
	{7390, 45876},
	{7416, 45880},
	{7442, 45884},
	{7468, 45888},
	{7494, 45892},
	{7520, 45896},
	{7546, 45900},
	{7572, 45904},
	{7598, 45908},
	{7624, 45912},
	{7651, 45916},
	{7678, 45920},
	{7705, 45924},
	{7732, 45928},
	{7759, 45932},
	{52853, 45936},
	{52880, 45940},
	{52907, 45944},
	{52934, 45948},
	{52961, 45952},
	{52988, 45956},
	{53015, 45960},
	{53042, 45964},
	{53069, 45968},
	{53096, 45972},
	{53123, 45976},
	{53150, 45980},
	{53177, 45984},
	{53204, 45988},
	{53231, 45992},
	{53258, 45996},
	{7838, 46084, 1, 4833},
	{7862, 46088},
	{7894, 46092},
	{9169, 46096},
	{9190, 46100, 1, 491},
	{7974, 46108, 4, 4856},
	{7998, 46112},
	{8019, 46116, 1, 491},
	{8040, 46120, 11, 4860},
	{8064, 46124, 7, 4871},
	{9259, 46128},
	{9285, 46132},
	{9311, 46136},
	{9337, 46140},
	{9363, 46144},
	{9389, 46148},
	{9415, 46152},
	{9441, 46156},
	{9467, 46160},
	{9493, 46164},
	{9519, 46168},
	{9546, 46172},
	{9573, 46176},
	{9600, 46180},
	{9627, 46184},
	{9654, 46188},
	{53285, 46192},
	{53312, 46196},
	{53339, 46200},
	{53366, 46204},
	{53393, 46208},
	{53420, 46212},
	{53447, 46216},
	{53474, 46220},
	{53501, 46224},
	{53528, 46228},
	{53555, 46232},
	{53582, 46236},
	{53609, 46240},
	{53636, 46244},
	{53663, 46248},
	{53690, 46252},
	{53717, 46384},
	{53747, 46388},
	{53777, 46392},
	{53807, 46396},
	{53837, 46400},
	{53867, 46404},
	{53897, 46408},
	{53927, 46412},
	{53957, 46416},
	{53987, 46420},
	{54017, 46424},
	{54048, 46428},
	{54079, 46432},
	{54110, 46436},
	{54141, 46440},
	{54172, 46444},
	{54203, 46448},
	{54234, 46452},
	{54265, 46456},
	{54296, 46460},
	{54327, 46464},
	{54358, 46468},
	{54389, 46472},
	{54420, 46476},
	{54451, 46480},
	{54482, 46484},
	{54513, 46488},
	{54544, 46492},
	{54575, 46496},
	{54606, 46500},
	{54637, 46504},
	{54668, 46508},
	{9681, 47104, 11, 4878},
	{9708, 47108},
	{9722, 47112},
	{9736, 47116},
	{9750, 47120},
	{9766, 47124},
	{9782, 47128},
	{9798, 47132, 2, 659},
	{9819, 47136, 2, 659},
	{9840, 47140, 2, 659},
	{9861, 47144, 1, 661},
	{9889, 47148, 1, 662},
	{9914, 47152},
	{9929, 47156, 1, 663},
	{9944, 47160},
	{9973, 47164, 1, 663},
	{10002, 47168},
	{10035, 47172, 1, 663},
	{10068, 47176, 11, 4889},
	{10086, 47180, 12, 4900},
	{10104, 47184, 1, 687},
	{10117, 47188, 7, 4912},
	{50546, 47192, 2, 3774},
	{50577, 47196, 2, 3774},
	{10195, 47200, 2, 694},
	{50760, 47204, 2, 3774},
	{50791, 47208, 2, 3774},
	{10270, 47212},
	{10288, 47216},
	{10306, 47220},
	{10324, 47224, 1, 696},
	{10352, 47228, 5, 697},
	{10374, 47232},
	{10394, 47236},
	{10577, 47240, 3, 713},
	{10594, 47244},
	{10623, 47248, 1, 716},
	{10555, 47252},
	{10670, 47360},
	{10690, 47364},
	{10710, 47368},
	{10730, 47372},
	{10750, 47376},
	{10770, 47380},
	{10790, 47384},
	{10810, 47388},
	{10830, 47392},
	{10850, 47396},
	{10870, 47400},
	{10891, 47404},
	{10912, 47408},
	{10933, 47412},
	{10954, 47416},
	{10975, 47420},
	{11020, 47608},
	{11041, 47612},
	{11057, 163840, 10, 719},
	{11075, 163844, 9, 3805},
	{11092, 163848, 5, 4919},
	{11106, 163852, 23, 747},
	{11125, 163856, 16, 770},
	{11145, 163860},
	{11557, 163864, 1, 830},
	{50656, 163868, 2, 786},
	{11181, 163872},
	{11201, 163876},
	{11221, 163880, 1, 788},
	{11238, 163884},
	{11253, 163888, 2, 789},
	{11277, 163892, 2, 791},
	{11335, 163896, 13, 4924},
	{11345, 163900, 8, 4937},
	{11361, 163904},
	{11471, 163908, 1, 830},
	{11376, 163912},
	{11489, 163916, 1, 830},
	{11397, 163920},
	{11513, 163924, 1, 830},
	{11413, 163928},
	{11532, 163932, 1, 830},
	{11301, 163936, 3, 793},
	{54699, 163944, 1, 4945},
	{54710, 163948, 1, 4945},
	{11603, 163968},
	{11619, 163972, 1, 840},
	{11638, 164328, 1, 841},
	{11659, 164332, 1, 841},
	{11680, 164336, 1, 841},
	{11701, 164340, 1, 841},
	{11722, 164344},
	{11740, 164348},
	{11758, 164352, 2, 842},
	{11778, 164356, 3, 844},
	{11802, 164360, 2, 847},
	{11826, 164364, 1, 849},
	{11846, 164368, 2, 844},
	{11866, 164372, 2, 847},
	{11886, 164376, 2, 844},
	{11906, 164380, 2, 847},
	{11926, 164384, 2, 844},
	{11946, 164388, 2, 847},
	{11966, 164392, 2, 844},
	{11986, 164396, 2, 847},
	{12006, 164400, 7, 850},
	{12021, 164404, 2, 857},
	{12050, 164408, 8, 859},
	{12065, 164412, 8, 867},
	{12080, 164416, 3, 844},
	{12105, 164420, 2, 847},
	{12130, 164424},
	{12148, 164428},
	{12166, 164432, 3, 844},
	{12191, 164436, 2, 847},
	{12216, 164440, 3, 844},
	{12241, 164444, 2, 847},
	{12266, 164448, 3, 844},
	{12291, 164452, 2, 847},
	{12316, 164456, 3, 844},
	{12341, 164460, 2, 847},
	{12366, 164464, 3, 844},
	{12391, 164468, 2, 847},
	{12416, 164472, 3, 844},
	{12441, 164476, 2, 847},
	{12466, 164480, 3, 844},
	{12491, 164484, 2, 847},
	{12516, 164488, 3, 844},
	{12541, 164492, 2, 847},
	{12566, 164496, 3, 844},
	{12591, 164500, 2, 847},
	{12616, 164504, 3, 844},
	{12641, 164508, 2, 847},
	{12666, 164512, 3, 844},
	{12692, 164516, 2, 847},
	{12718, 164520, 3, 844},
	{12744, 164524, 2, 847},
	{12770, 164528, 3, 844},
	{12796, 164532, 2, 847},
	{12822, 164536, 3, 844},
	{12848, 164540, 2, 847},
	{12874, 164544, 3, 844},
	{12900, 164548, 2, 847},
	{12926, 164552, 3, 844},
	{12952, 164556, 2, 847},
	{12978, 164560},
	{12997, 164564},
	{13016, 164568},
	{13035, 164572},
	{13054, 164576},
	{13073, 164580},
	{13092, 164584},
	{13111, 164588},
	{13130, 164592},
	{13149, 164596},
	{13168, 164600},
	{13187, 164604},
	{13206, 164608},
	{13225, 164612},
	{13244, 164616},
	{13263, 164620},
	{13282, 164624},
	{13301, 164628},
	{13320, 164632},
	{13339, 164636},
	{13358, 164640},
	{13378, 164644},
	{13398, 164648},
	{13418, 164652},
	{13438, 164656},
	{13458, 164660},
	{13478, 164664},
	{13498, 164668},
	{13518, 164672},
	{13538, 164676},
	{13558, 164680},
	{13578, 164684},
	{13598, 164688, 15, 4946},
	{13618, 164692, 3, 4961},
	{13640, 164696, 2, 893},
	{13668, 164700, 3, 895},
	{13697, 164704, 1, 902},
	{13718, 164708, 1, 903},
	{13728, 164712, 1, 904},
	{13736, 164768, 4, 905},
	{13758, 164772, 4, 905},
	{13779, 164776, 4, 909},
	{13846, 164876},
	{13900, 164884},
	{13913, 164888},
	{13928, 164892},
	{13942, 164896},
	{13957, 164900, 9, 4964},
	{13996, 164908, 6, 935},
	{14015, 164912, 4, 941},
	{14033, 164916, 4, 945},
	{14054, 164924},
	{14073, 164928},
	{14093, 164932},
	{14112, 164936},
	{14132, 164940},
	{14151, 164944},
	{14171, 164948},
	{14192, 164952},
	{14214, 164956},
	{14235, 164960},
	{14257, 164964},
	{14278, 164968},
	{14300, 164972},
	{14321, 164976},
	{14343, 164980},
	{14364, 164984},
	{14386, 164988},
	{14407, 164992},
	{14429, 164996},
	{14450, 165000},
	{14472, 165004},
	{14493, 165008},
	{14515, 165012},
	{14536, 165016},
	{14558, 165020},
	{14579, 165024},
	{14601, 165028},
	{14622, 165032},
	{14644, 165036},
	{14665, 165040},
	{14687, 165044},
	{14708, 165048},
	{14730, 165052},
	{14751, 165056},
	{14773, 165060},
	{14794, 165064},
	{14816, 165068},
	{14837, 165072},
	{14859, 165076},
	{14880, 165080},
	{14902, 165084},
	{14923, 165088},
	{14945, 165092},
	{14966, 165096},
	{14988, 165100},
	{15009, 165104},
	{15031, 165108},
	{15052, 165112},
	{15074, 165116},
	{15095, 165120},
	{15117, 165124},
	{15138, 165128},
	{15160, 165132},
	{15181, 165136},
	{15203, 165140},
	{15224, 165144},
	{15246, 165148},
	{15267, 165152},
	{15289, 165156},
	{15310, 165160},
	{15332, 165164},
	{15354, 165168},
	{15377, 165172},
	{15399, 165176},
	{15422, 165180},
	{15444, 165184},
	{15467, 165188},
	{15489, 165192},
	{15512, 165196},
	{15534, 165200},
	{15557, 165204},
	{15579, 165208},
	{15602, 165212},
	{15624, 165216},
	{15647, 165220},
	{15669, 165224},
	{15692, 165228},
	{15714, 165232},
	{15737, 165236},
	{15759, 165240},
	{15782, 165244},
	{15804, 165248},
	{15827, 165252},
	{15849, 165256},
	{15872, 165260},
	{15894, 165264},
	{15917, 165268},
	{15939, 165272},
	{15962, 165276},
	{15984, 165280},
	{16007, 165284},
	{16029, 165288},
	{16052, 165292},
	{16074, 165296},
	{16097, 165300},
	{16119, 165304},
	{16142, 165308},
	{16156, 165312},
	{16170, 165316},
	{16184, 165320},
	{16198, 165324},
	{16212, 165328},
	{16226, 165332},
	{16240, 165336},
	{16254, 165340},
	{16268, 165344},
	{16282, 165348},
	{16296, 165352},
	{16310, 165356},
	{16324, 165360},
	{16338, 165364},
	{16352, 165368},
	{16366, 165372},
	{16380, 165376},
	{16394, 165380},
	{16408, 165384},
	{16422, 165388},
	{16436, 165392},
	{16450, 165396},
	{16464, 165400},
	{16478, 165404},
	{16501, 165444, 12, 949},
	{16521, 165448, 12, 949},
	{16541, 165452, 12, 949},
	{16561, 165456, 12, 949},
	{16581, 165460, 12, 949},
	{16601, 165464, 12, 949},
	{16621, 165468, 12, 949},
	{16641, 165472, 12, 949},
	{16661, 165476, 12, 949},
	{16681, 165480, 12, 949},
	{16701, 165484, 12, 949},
	{16722, 165488, 12, 949},
	{16743, 165492, 12, 949},
	{16764, 165496, 12, 949},
	{16785, 165500, 12, 949},
	{16806, 165504, 12, 949},
	{16827, 165508, 12, 949},
	{16848, 165512, 12, 949},
	{16869, 165516, 12, 949},
	{16890, 165520, 12, 949},
	{16911, 165524, 9, 961},
	{16932, 165528, 9, 961},
	{16953, 165532, 9, 961},
	{16974, 165536, 9, 961},
	{16995, 165540, 9, 961},
	{17016, 165544, 9, 961},
	{17037, 165548, 9, 961},
	{17058, 165552, 9, 961},
	{17079, 165556, 9, 961},
	{17100, 165560, 9, 961},
	{17121, 165564, 9, 961},
	{17142, 165568, 9, 961},
	{17163, 165572, 2, 970},
	{17181, 165580, 16, 973},
	{17198, 165584, 16, 973},
	{17216, 165588, 7, 989},
	{17237, 165592, 5, 996},
	{17255, 165600, 7, 1002},
	{17270, 165608, 2, 694},
	{17309, 165644, 4, 1010},
	{17331, 165648, 1, 1015},
	{17351, 165652, 8, 1016},
	{17373, 165716, 8, 1024},
	{17391, 165720, 8, 1032},
	{17412, 165724, 17, 1040},
	{17433, 165728, 6, 1057},
	{17451, 165732, 6, 1057},
	{17469, 165736, 6, 1057},
	{17487, 165740, 6, 1057},
	{17505, 165744, 6, 1057},
	{17523, 165748, 6, 1057},
	{17541, 165752, 6, 1057},
	{17559, 165756, 6, 1057},
	{17577, 165760, 9, 1063},
	{17595, 165764, 9, 1063},
	{17613, 165768, 9, 1063},
	{17631, 165772, 9, 1063},
	{17649, 165776, 9, 1063},
	{17667, 165780, 9, 1063},
	{17685, 165784, 9, 1063},
	{17703, 165788, 9, 1063},
	{54727, 165792, 1, 4945},
	{54742, 165796, 1, 4945},
	{54757, 165800, 1, 4945},
	{54772, 165804, 1, 4945},
	{54787, 165808, 1, 4945},
	{54802, 165812, 1, 4945},
	{54817, 165816, 1, 4945},
	{54832, 165820, 1, 4945},
	{17721, 165836, 1, 1072},
	{17735, 165840, 1, 1072},
	{17750, 165844},
	{17768, 165848},
	{17786, 165852},
	{17803, 165856},
	{17824, 165860, 1, 1073},
	{17840, 165864},
	{17853, 165872, 8, 1074},
	{17872, 165876},
	{17887, 165880, 1, 1082},
	{17936, 165888, 10, 1084},
	{17953, 165892, 12, 1094},
	{17961, 165896, 4, 4514},
	{17978, 165900, 16, 1110},
	{17996, 165904, 20, 1127},
	{18012, 165908, 15, 1147},
	{18031, 165912, 10, 1163},
	{18046, 165916, 28, 4973},
	{18064, 165920, 16, 1201},
	{18082, 165924, 4, 1217},
	{18106, 165928},
	{18131, 165932, 11, 1221},
	{18154, 165936, 6, 5001},
	{18183, 165940, 3, 5007},
	{18205, 165944, 2, 1241},
	{18220, 165948, 5, 1243},
	{18250, 165952, 6, 5010},
	{18283, 166400, 2, 1253},
	{18300, 166404, 2, 1255},
	{18319, 166408, 1, 1257},
	{18335, 166412, 4, 1258},
	{18354, 166416, 1, 1262},
	{18375, 166420, 1, 1263},
	{18388, 166424},
	{18411, 166428},
	{18434, 166432, 1, 1264},
	{18454, 166436, 4, 1265},
	{18474, 166440, 1, 1269},
	{18495, 166444, 1, 1270},
	{18510, 166448, 6, 1271},
	{18532, 166452, 6, 1271},
	{18554, 166456, 8, 1277},
	{18580, 166460, 8, 1277},
	{18606, 166464, 15, 4384},
	{18618, 166468, 3, 1300},
	{18637, 166472, 7, 1303},
	{18655, 166476, 24, 1310},
	{18673, 166480},
	{18685, 166484, 1, 1334},
	{18699, 166488, 1, 1335},
	{18713, 166492, 1, 1336},
	{18727, 166496, 1, 1337},
	{18750, 166500, 1, 1337},
	{18773, 166504, 1, 1337},
	{18796, 166508, 5, 1338},
	{18817, 166512},
	{18828, 166516},
	{18841, 166520},
	{18858, 166524, 7, 5016},
	{18877, 166528},
	{18888, 166532, 3, 1351},
	{18907, 166536},
	{18929, 166540},
	{18951, 166544, 3, 5023},
	{54847, 166548, 1, 5026},
	{18998, 166552, 4, 5027},
	{19020, 166560},
	{19045, 166564},
	{19089, 166572, 1, 1370},
	{19112, 166576, 1, 1370},
	{19135, 166580, 1, 1371},
	{19149, 166584, 1, 1372},
	{19164, 166588, 8, 5031},
	{19181, 166592, 4, 1382},
	{19208, 166596, 4, 1386},
	{19235, 166600, 4, 1390},
	{19254, 166608},
	{19280, 166612, 1, 1394},
	{19305, 166620},
	{19333, 166624},
	{19359, 166628, 1, 1394},
	{19384, 166636},
	{19412, 166640},
	{19438, 166644, 1, 1394},
	{19463, 166652},
	{19491, 166656},
	{19517, 166660, 1, 1394},
	{19542, 166668},
	{19570, 166696},
	{19601, 166700},
	{19644, 166704, 1, 1395},
	{19682, 166712, 1, 1396},
	{19721, 166736, 5, 1399},
	{19743, 166740, 13, 5039},
	{19764, 166744, 3, 1423},
	{19781, 166748, 1, 1370},
	{19802, 166752, 1, 1370},
	{19825, 166756, 1, 1370},
	{19848, 166760, 1, 1370},
	{19871, 166764, 8, 5052},
	{19884, 166768, 6, 1438},
	{19901, 166772},
	{19925, 166776, 2, 1444},
	{19955, 166780},
	{19979, 166784},
	{20009, 166788},
	{20040, 166792},
	{20069, 166796},
	{20099, 166800, 2, 1446},
	{20119, 166804, 8, 1449},
	{20138, 166808, 4, 1457},
	{20164, 166812, 3, 5023},
	{20188, 166868, 8, 1461},
	{20214, 166872, 8, 1469},
	{20240, 166876, 5, 1477},
	{20256, 166880, 6, 1482},
	{20272, 166884, 3, 1488},
	{20287, 166888},
	{20310, 166892},
	{20333, 166896},
	{20356, 166900},
	{20379, 166904, 8, 1491},
	{20413, 166908, 8, 1499},
	{20447, 166912, 8, 1507},
	{20481, 166916, 8, 1515},
	{20515, 166920, 8, 1491},
	{20549, 166924, 8, 1499},
	{20583, 166928, 8, 1507},
	{20617, 166932, 8, 1515},
	{20651, 166936, 8, 1491},
	{20685, 166940, 8, 1499},
	{20719, 166944, 8, 1507},
	{20753, 166948, 8, 1515},
	{20787, 166952, 8, 1491},
	{20821, 166956, 8, 1499},
	{20855, 166960, 8, 1507},
	{20889, 166964, 8, 1515},
	{20923, 166968, 2, 1523},
	{20947, 166972, 2, 1525},
	{20971, 166976, 3, 1527},
	{20992, 166980, 11, 5060},
	{21012, 166984, 2, 1543},
	{21032, 166988, 18, 5071},
	{21070, 166992, 1, 1565},
	{21090, 167000, 1, 1567},
	{21118, 167004, 1, 1568},
	{21139, 167008},
	{23179, 167012, 1, 1615},
	{23915, 167016, 3, 1616},
	{21186, 167020, 3, 5089},
	{21201, 167024, 16, 5092},
	{21216, 167028, 10, 5108},
	{21233, 167032, 11, 1602},
	{21255, 167036},
	{23331, 167040, 1, 1615},
	{21293, 167044},
	{23531, 167048, 1, 1615},
	{21331, 167052},
	{21353, 167056},
	{21375, 167060},
	{23731, 167064, 1, 1615},
	{21394, 167068},
	{23198, 167072, 1, 1615},
	{23933, 167076, 3, 1616},
	{21441, 167080, 3, 5089},
	{21456, 167084, 16, 5092},
	{21471, 167088, 10, 5108},
	{21488, 167092, 11, 1602},
	{21510, 167096},
	{23356, 167100, 1, 1615},
	{21548, 167104},
	{23556, 167108, 1, 1615},
	{21586, 167112},
	{21608, 167116},
	{21630, 167120},
	{23754, 167124, 1, 1615},
	{21649, 167128},
	{23217, 167132, 1, 1615},
	{23951, 167136, 3, 1616},
	{21696, 167140, 3, 5089},
	{21711, 167144, 16, 5092},
	{21726, 167148, 10, 5108},
	{21743, 167152, 11, 1602},
	{21765, 167156},
	{23381, 167160, 1, 1615},
	{21803, 167164},
	{23581, 167168, 1, 1615},
	{21841, 167172},
	{21863, 167176},
	{21885, 167180},
	{23777, 167184, 1, 1615},
	{21904, 167188},
	{23236, 167192, 1, 1615},
	{23969, 167196, 3, 1616},
	{21951, 167200, 3, 5089},
	{21966, 167204, 16, 5092},
	{21981, 167208, 10, 5108},
	{21998, 167212, 11, 1602},
	{22020, 167216},
	{23406, 167220, 1, 1615},
	{22058, 167224},
	{23606, 167228, 1, 1615},
	{22096, 167232},
	{22118, 167236},
	{22140, 167240},
	{23800, 167244, 1, 1615},
	{22159, 167248},
	{23255, 167252, 1, 1615},
	{23987, 167256, 3, 1616},
	{22206, 167260, 3, 5089},
	{22221, 167264, 16, 5092},
	{22236, 167268, 10, 5108},
	{22253, 167272, 11, 1602},
	{22275, 167276},
	{23431, 167280, 1, 1615},
	{22313, 167284},
	{23631, 167288, 1, 1615},
	{22351, 167292},
	{22373, 167296},
	{22395, 167300},
	{23823, 167304, 1, 1615},
	{22414, 167308},
	{23274, 167312, 1, 1615},
	{24005, 167316, 3, 1616},
	{22461, 167320, 3, 5089},
	{22476, 167324, 16, 5092},
	{22491, 167328, 10, 5108},
	{22508, 167332, 11, 1602},
	{22530, 167336},
	{23456, 167340, 1, 1615},
	{22568, 167344},
	{23656, 167348, 1, 1615},
	{22606, 167352},
	{22628, 167356},
	{22650, 167360},
	{23846, 167364, 1, 1615},
	{22669, 167368},
	{23293, 167372, 1, 1615},
	{24023, 167376, 3, 1616},
	{22716, 167380, 3, 5089},
	{22731, 167384, 16, 5092},
	{22746, 167388, 10, 5108},
	{22763, 167392, 11, 1602},
	{22785, 167396},
	{23481, 167400, 1, 1615},
	{22823, 167404},
	{23681, 167408, 1, 1615},
	{22861, 167412},
	{22883, 167416},
	{22905, 167420},
	{23869, 167424, 1, 1615},
	{22924, 167428},
	{23312, 167432, 1, 1615},
	{24041, 167436, 3, 1616},
	{22971, 167440, 3, 5089},
	{22986, 167444, 16, 5092},
	{23001, 167448, 10, 5108},
	{23018, 167452, 11, 1602},
	{23040, 167456},
	{23506, 167460, 1, 1615},
	{23078, 167464},
	{23706, 167468, 1, 1615},
	{23116, 167472},
	{23138, 167476},
	{23160, 167480},
	{23892, 167484, 1, 1615},
	{24203, 196608, 1, 1627},
	{24223, 196612, 1, 1628},
	{24243, 196616},
	{24263, 196620},
	{24283, 196624},
	{24304, 196628},
	{24325, 196632, 1, 1629},
	{24347, 196636, 1, 1630},
	{24369, 196640},
	{24399, 196644},
	{24429, 196648},
	{24458, 196652},
	{24487, 196656},
	{24517, 196660},
	{24547, 196664},
	{24576, 196668},
	{24605, 196672},
	{24635, 196676},
	{24665, 196680},
	{24694, 196684},
	{24723, 196688},
	{24753, 196692},
	{24783, 196696},
	{24812, 196700},
	{24841, 196704, 1, 1631},
	{24863, 196708, 1, 1632},
	{24885, 196712},
	{24908, 196716},
	{24931, 196720},
	{24954, 196724},
	{24977, 196728},
	{25000, 196732},
	{25023, 196736},
	{25047, 196740},
	{25071, 196744},
	{25095, 196748},
	{25119, 196752},
	{25143, 196756},
	{25167, 196760},
	{25191, 196764},
	{25215, 196768},
	{25237, 196772},
	{25259, 196776},
	{25280, 196780},
	{25301, 196784},
	{25325, 196788},
	{25349, 196792},
	{25373, 196796},
	{25397, 196800},
	{25421, 196804},
	{25505, 196852, 1, 4456},
	{25527, 196856, 1, 4456},
	{25549, 196860, 1, 1635},
	{25565, 196864},
	{25578, 196868},
	{25591, 196872},
	{25604, 196876},
	{25617, 196880},
	{25630, 196884},
	{25643, 196888},
	{25656, 196892},
	{25711, 196912},
	{25729, 196916},
	{25756, 196920},
	{25783, 196928, 2, 1636},
	{25796, 196932},
	{25809, 196936},
	{25832, 196940},
	{25855, 196944},
	{25883, 196948},
	{25911, 196952},
	{25939, 196956},
	{25967, 196960, 1, 1638},
	{25985, 196964, 4, 5118},
	{54877, 196968},
	{54895, 196972},
	{54922, 196976},
	{26066, 196980},
	{26085, 196984},
	{26104, 196988},
	{26128, 196992},
	{26152, 196996},
	{26176, 197000},
	{26200, 197028, 1, 1643},
	{26218, 197032, 2, 5122},
	{26236, 197036},
	{26254, 197040},
	{26272, 197044, 1, 1646},
	{26290, 197048, 2, 5124},
	{26308, 197052},
	{26326, 197056, 2, 1649},
	{26345, 197060, 5, 1651},
	{26364, 197072},
	{26388, 197076, 2, 1649},
	{26408, 197080, 5, 1651},
	{26428, 197084, 5, 5126},
	{26447, 197088, 5, 5126},
	{26465, 197092, 1, 1663},
	{26482, 197100, 1, 1664},
	{26503, 197104, 13, 1665},
	{26517, 197108},
	{26531, 197112},
	{26545, 197116, 2, 1678},
	{26561, 197120},
	{26580, 197124, 1, 1680},
	{26602, 197128},
	{26621, 197132, 1, 1681},
	{26643, 197136, 7, 1682},
	{26661, 197140},
	{26681, 197144, 1, 1680},
	{26704, 197148},
	{26724, 197152, 1, 1681},
	{26747, 197156, 7, 1682},
	{26766, 197160, 6, 5131},
	{26778, 197164, 2, 1696},
	{26795, 197168, 1, 1698},
	{26812, 197172, 1, 1699},
	{26830, 197176, 4, 1700},
	{26850, 197180, 1, 1704},
	{26867, 197184},
	{26883, 197188, 1, 1706},
	{26896, 197192, 1, 1707},
	{26910, 197196, 1, 1708},
	{26924, 197200, 1, 1709},
	{26946, 197204, 1, 1710},
	{26966, 197208, 1, 1711},
	{26988, 197212, 1, 1712},
	{27008, 197216, 1, 1707},
	{27025, 197220, 1, 1708},
	{27042, 197224},
	{52837, 197228, 1, 1706},
	{27190, 197364, 1, 1717},
	{27211, 197368, 1, 1718},
	{27231, 197372, 1, 1719},
	{27251, 197376, 1, 1718},
	{27268, 197380, 1, 1719},
	{27285, 197384, 1, 1720},
	{27301, 197388, 1, 1721},
	{27320, 197392, 1, 1722},
	{27339, 197396, 1, 1723},
	{27356, 197400, 1, 1724},
	{27374, 197404, 1, 1725},
	{27392, 197408, 1, 1726},
	{27408, 197412, 1, 1727},
	{27426, 197416, 1, 1728},
	{27444, 197420, 1, 1729},
	{27460, 197424, 1, 1724},
	{27475, 197428, 1, 1725},
	{27490, 197432, 1, 1726},
	{27503, 197436, 1, 1727},
	{27518, 197440, 1, 1728},
	{27533, 197444, 1, 1729},
	{27546, 197448, 1, 1730},
	{27560, 197452, 1, 1731},
	{27574, 197456, 1, 1732},
	{27586, 197460, 4, 5137},
	{27609, 197464, 3, 1737},
	{27631, 197468, 1, 1740},
	{27775, 197552, 1, 1745},
	{27800, 197556, 1, 1745},
	{27824, 197560, 1, 1746},
	{27844, 197568},
	{27870, 197572, 1, 1628},
	{27899, 197576},
	{27924, 197580, 1, 1628},
	{27952, 197584},
	{27975, 197588, 1, 1628},
	{28001, 197592},
	{28023, 197596, 1, 1628},
	{28048, 197600},
	{28067, 197604, 1, 1628},
	{28089, 197608, 1, 1343},
	{28103, 197612},
	{28120, 197616, 1, 1628},
	{28140, 197620, 8, 1747},
	{28157, 197624, 13, 1755},
	{28174, 197628},
	{28191, 197632, 1, 1698},
	{28211, 197636},
	{28228, 197640, 1, 1663},
	{28248, 197644, 2, 1768},
	{28267, 197888, 8, 5141},
	{28288, 197892, 8, 5141},
	{28309, 198656, 6, 2946},
	{48526, 198916},
	{28370, 198920, 1, 1784},
	{28389, 198924, 2, 5149},
	{28404, 198928},
	{28437, 198932},
	{28470, 198936},
	{28503, 198940},
	{13796, 198944},
	{13813, 198948},
	{13830, 198952},
	{18971, 198956, 2, 1357},
	{28593, 198960},
	{28609, 198964},
	{49020, 198968, 1, 1785},
	{49052, 198972, 2, 1786},
	{49073, 198976},
	{54949, 198980, 1, 830},
	{28715, 198984},
	{28731, 198988, 1, 830},
	{28750, 198992},
	{28770, 198996, 1, 830},
	{28793, 199000},
	{28811, 199004, 1, 830},
	{19070, 199008, 9, 1788},
	{28873, 199016},
	{29013, 199168, 1, 1809},
	{29038, 199172, 2, 1810},
	{29063, 199184, 2, 1812},
	{29089, 199188, 2, 1812},
	{29115, 199192, 2, 1812},
	{29141, 199212, 2, 1812},
	{29167, 199296, 2, 1814},
	{29195, 199300, 1, 1816},
	{29219, 199304, 1, 1817},
	{29243, 199308, 1, 1818},
	{29276, 199312, 1, 1818},
	{29304, 199328, 2, 1814},
	{29333, 199332, 1, 1816},
	{29358, 199336, 1, 1817},
	{29383, 199340, 1, 1818},
	{29417, 199344, 1, 1818},
	{29446, 199360, 2, 1814},
	{29470, 199364, 1, 1816},
	{29490, 199368, 1, 1817},
	{29510, 199372, 1, 1818},
	{29539, 199376, 1, 1818},
	{18265, 199380},
	{49639, 199872},
	{49660, 199876, 1, 3506},
	{2095, 199880, 7, 4060},
	{2116, 199884, 3, 3515},
	{49681, 199888, 2, 3518},
	{2143, 199892, 1, 3542},
	{49707, 199896, 15, 5151},
	{50710, 199900, 1, 4069},
	{50732, 199904},
	{2074, 199908, 2, 3520},
	{2164, 199912, 6, 5166},
	{49749, 199916, 1, 3543},
	{49728, 199920},
	{29563, 199936},
	{29590, 199940},
	{29617, 199944},
	{29644, 199948},
	{29779, 199968, 6, 1819},
	{29790, 199972, 2, 1826},
	{29804, 200192},
	{29823, 200196, 1, 840},
	{29845, 200448},
	{29869, 200452, 1, 1828},
	{29892, 200456},
	{29916, 200460, 1, 1828},
	{29939, 200464},
	{29963, 200468, 1, 1828},
	{29986, 200472},
	{30010, 200476, 1, 1828},
	{30033, 200696},
	{30052, 200700, 1, 1828},
	{30070, 200704},
	{30082, 200708},
	{30094, 200712},
	{30112, 200716},
	{30131, 200720},
	{30149, 200724},
	{30161, 200728},
	{30173, 200732},
	{30191, 200736},
	{30209, 200740},
	{30228, 200744, 4, 1829},
	{30242, 200748, 2, 1833},
	{30260, 200752, 2, 1835},
	{30274, 200756, 2, 1837},
	{30288, 200760, 2, 1839},
	{30305, 200764, 2, 1841},
	{30322, 200768},
	{30335, 200772, 2, 1843},
	{30347, 200776},
	{30361, 200780},
	{30377, 200784},
	{30391, 200788},
	{30407, 200792},
	{30422, 200796},
	{30439, 200800},
	{30454, 200804},
	{30471, 200808, 2, 1845},
	{30493, 200812, 10, 5172},
	{30510, 200816, 2, 1857},
	{30531, 200820, 2, 1859},
	{30543, 200824},
	{30558, 200828, 6, 4503},
	{30573, 200832, 2, 1867},
	{30587, 200836},
	{2495, 200960, 9, 429},
	{54971, 200964, 11, 5182},
	{54989, 200968, 2, 5193},
	{55007, 200972, 4, 5195},
	{30700, 212992},
	{30720, 212996},
	{30740, 213000},
	{30760, 213004},
	{30780, 213008},
	{30800, 213012},
	{30820, 213016},
	{30840, 213020},
	{30860, 213024},
	{30880, 213028},
	{30900, 213032},
	{30920, 213036},
	{30940, 213040},
	{30963, 213044},
	{30986, 213048},
	{31009, 213248},
	{31030, 213252},
	{31051, 213260},
	{31072, 213264},
	{31093, 213268},
	{31117, 213272},
	{31141, 213276},
	{31165, 213280},
	{31189, 213284},
	{31213, 213288},
	{31237, 213292},
	{31261, 213296},
	{50822, 213504},
	{50841, 213508},
	{50860, 213512},
	{50879, 213516},
	{50898, 213520},
	{50917, 213524},
	{50936, 213528},
	{50955, 213532},
	{48217, 213536},
	{48236, 213540},
	{48255, 213544},
	{48274, 213548},
	{48293, 213552},
	{48312, 213556},
	{48331, 213560},
	{48350, 213564},
	{48808, 213568},
	{48828, 213572},
	{48848, 213576},
	{48868, 213580},
	{48888, 213584},
	{48908, 213588},
	{48928, 213592},
	{48948, 213596},
	{31745, 214016},
	{31767, 214020, 1, 1869},
	{31789, 214024},
	{31811, 214028, 1, 1869},
	{31833, 214032},
	{31855, 214036, 1, 1869},
	{31877, 214040},
	{31899, 214044, 1, 1869},
	{31921, 214272},
	{31943, 214276},
	{31965, 214280},
	{31987, 214284},
	{32009, 214288},
	{32031, 214292},
	{32053, 214296},
	{32075, 214300},
	{32097, 214304},
	{32119, 214308},
	{32141, 214312},
	{32163, 214316},
	{32185, 214320},
	{32207, 214324},
	{32229, 214328},
	{32251, 214332},
	{32273, 214528},
	{32293, 214532},
	{32313, 214536},
	{32333, 214540},
	{32353, 214544},
	{32373, 214548},
	{32393, 214552},
	{32413, 214556},
	{32433, 214560},
	{32453, 214564},
	{32473, 214568},
	{32493, 214572},
	{32513, 214784},
	{32532, 214788},
	{32551, 214792},
	{32570, 214796},
	{32589, 214800},
	{32608, 214804},
	{32627, 214808},
	{32646, 214812},
	{32665, 214816},
	{32684, 214820},
	{32703, 214824},
	{32722, 214828},
	{32741, 214832},
	{32760, 214836},
	{32779, 214840},
	{32798, 214844},
	{32817, 214848},
	{32836, 214852},
	{32855, 214856},
	{32874, 214860},
	{32893, 214864},
	{32913, 214868},
	{32933, 214872},
	{32953, 214876},
	{32973, 214880},
	{32993, 214884},
	{33013, 214888},
	{33033, 214892},
	{33053, 214896},
	{33073, 214900},
	{33093, 214904},
	{33113, 214908},
	{33133, 215296},
	{33152, 215300},
	{33171, 215304},
	{33190, 215308},
	{33209, 215312},
	{33228, 215316},
	{33247, 215320},
	{33266, 215324},
	{33327, 215552},
	{33347, 215556},
	{33367, 215560},
	{33387, 215564},
	{33407, 215568},
	{33427, 215572},
	{33447, 215576},
	{33467, 215580},
	{33487, 215808},
	{33506, 215812},
	{33525, 215816},
	{33544, 215820},
	{33563, 216064},
	{33582, 216068},
	{33601, 216072},
	{33620, 216076},
	{33639, 216320},
	{33659, 216324},
	{33679, 216328},
	{33699, 216332},
	{33719, 216336},
	{33739, 216340},
	{33759, 216344},
	{33779, 216348},
	{50974, 216576},
	{50994, 216580},
	{51014, 216584},
	{51034, 216588},
	{51054, 216592},
	{51074, 216596},
	{51094, 216600},
	{51114, 216604},
	{51134, 216640},
	{51154, 216644},
	{51174, 216648},
	{51194, 216652},
	{51214, 216656},
	{51234, 216660},
	{51254, 216664},
	{51274, 216668},
	{34631, 217112},
	{34650, 217116},
	{34669, 217120},
	{34688, 217124},
	{34707, 217128},
	{34726, 217132},
	{34745, 217136},
	{34764, 217140},
	{34783, 217344},
	{34802, 217348},
	{34821, 217352},
	{34840, 217356},
	{34859, 217360},
	{34878, 217364},
	{34897, 217368},
	{34916, 217372},
	{34935, 217600},
	{34955, 217604},
	{34975, 217608},
	{34995, 217612},
	{35015, 217856},
	{35035, 217860},
	{35055, 217864},
	{35075, 217868},
	{35095, 217872},
	{35115, 217876},
	{35135, 217880},
	{35155, 217884},
	{35178, 218112},
	{35203, 218116, 2, 1870},
	{35227, 218144},
	{35253, 218148, 2, 1870},
	{36317, 221184, 5, 5199},
	{36341, 221188, 4, 5204},
	{36366, 221192, 5, 5199},
	{36390, 221196, 5, 5199},
	{36414, 221200, 4, 5204},
	{36439, 221204, 5, 5199},
	{36463, 221208, 4, 5204},
	{36488, 221212, 5, 5199},
	{36512, 221216, 4, 1881},
	{36528, 221220, 5, 5199},
	{36552, 221224, 3, 1885},
	{36586, 221228, 3, 1888},
	{36620, 221232, 3, 1891},
	{36645, 221236, 3, 1894},
	{36670, 221240, 3, 5208},
	{36695, 221248},
	{36710, 221252, 1, 1818},
	{36733, 221256},
	{36756, 221260},
	{36774, 221264, 2, 1897},
	{36792, 221268, 4, 1899},
	{36812, 221440, 22, 5211},
	{36837, 221444, 22, 5211},
	{36862, 221448, 13, 5233},
	{36890, 221452, 13, 5233},
	{36918, 221456, 13, 5233},
	{36946, 221460, 13, 5233},
	{51454, 221696, 2, 3287},
	{51477, 221700, 2, 3287},
	{51500, 221704, 2, 3287},
	{51523, 221708, 2, 3287},
	{48125, 221712, 5, 1957},
	{48148, 221716, 2, 3287},
	{48171, 221720, 2, 3287},
	{48194, 221724, 2, 3287},
	{51546, 221728, 4, 1962},
	{48712, 221744, 5, 1957},
	{48736, 221748, 5, 1957},
	{48760, 221752, 2, 3287},
	{48784, 221756, 2, 3287},
	{51570, 221760, 4, 1962},
	{51595, 221764, 4, 1962},
	{48686, 221776, 1, 3328},
	{37404, 222208, 5, 1957},
	{37430, 222212, 4, 1962},
	{37457, 222216, 5, 1957},
	{37483, 222220, 4, 1962},
	{37510, 222224, 3, 2013},
	{37563, 222228, 3, 2013},
	{37616, 222464, 5, 1957},
	{37642, 222468, 4, 1962},
	{37669, 222472, 1, 1872},
	{37695, 222476, 1, 1872},
	{37721, 222480, 1, 1872},
	{37747, 222484, 1, 1872},
	{37773, 222488, 1, 1872},
	{37799, 222492, 1, 1872},
	{37825, 222496, 1, 1872},
	{37851, 222720, 5, 1957},
	{37875, 222724, 5, 1957},
	{37899, 222728, 5, 1957},
	{37923, 222732, 5, 1957},
	{37947, 222736, 4, 1962},
	{37972, 222740, 4, 1962},
	{37997, 222744, 4, 1962},
	{38022, 222748, 4, 1962},
	{38047, 222752, 1, 2001},
	{38071, 222756, 1, 2001},
	{38095, 222760, 8, 1966},
	{38116, 222976, 6, 3486},
	{38139, 222980, 6, 3486},
	{38162, 222984, 6, 3486},
	{38185, 222988, 6, 3486},
	{38208, 222992, 6, 3486},
	{38231, 222996, 6, 3486},
	{38254, 223000, 6, 3486},
	{38277, 223004, 6, 3486},
	{38300, 223008, 6, 3486},
	{38323, 223012, 6, 3486},
	{38346, 223016, 6, 3486},
	{38370, 223020, 6, 3486},
	{38394, 223024, 6, 3486},
	{38418, 223028, 6, 3486},
	{38442, 223032, 6, 3486},
	{38466, 223036, 6, 3486},
	{38490, 223104, 9, 3469},
	{51620, 223108, 2, 3518},
	{38510, 223112, 1, 1987},
	{38605, 223488, 5, 1957},
	{38628, 223492, 5, 1957},
	{38651, 223496, 3, 2013},
	{38674, 223500, 3, 2013},
	{38697, 223504, 4, 1962},
	{38721, 223508, 4, 1962},
	{38745, 223744, 5, 1957},
	{38769, 223748, 5, 1957},
	{38793, 223752, 5, 1957},
	{38817, 223756, 5, 1957},
	{38841, 223760, 4, 1962},
	{38866, 224000, 5, 2001},
	{38889, 224004, 4, 2006},
	{38913, 224008, 3, 2010},
	{38936, 224256, 5, 2001},
	{38959, 224260, 4, 2006},
	{38983, 224264, 3, 2010},
	{39006, 224512, 5, 1957},
	{39030, 224516, 4, 1962},
	{39055, 224520, 5, 1957},
	{39079, 224524, 4, 1962},
	{39104, 224528, 3, 2013},
	{39128, 224532, 3, 2013},
	{51640, 224768, 5, 1957},
	{51664, 224772, 4, 1951},
	{51689, 224776, 5, 1957},
	{51713, 224780, 4, 1951},
	{51738, 224784, 3, 2013},
	{51762, 224788, 3, 2013},
	{51786, 224832, 5, 1957},
	{51810, 224836, 4, 1951},
	{51835, 224840, 5, 1957},
	{51859, 224844, 4, 1951},
	{51884, 224848, 3, 2013},
	{51908, 224852, 3, 2013},
	{39829, 225280, 12, 2016},
	{39851, 225284, 5, 2028},
	{39874, 225288, 4, 2033},
	{39898, 225292, 2, 2037},
	{39921, 225296, 2, 2037},
	{39944, 225300, 2, 2037},
	{39967, 225536, 5, 1957},
	{39990, 225540, 4, 1962},
	{40014, 225544, 5, 1957},
	{40037, 225548, 4, 1962},
	{40061, 225552, 5, 1957},
	{40084, 225560, 5, 1957},
	{40107, 225792, 4, 2039},
	{40128, 225796},
	{40157, 225800, 2, 2043},
	{40186, 225804},
	{40212, 225808, 7, 2045},
	{40286, 225812},
	{40309, 225816},
	{52053, 225820, 2, 4120},
	{52086, 225824, 2, 4120},
	{52119, 225828, 2, 4120},
	{52152, 225832, 2, 4120},
	{52184, 225836, 2, 4120},
	{52216, 225840, 2, 4120},
	{52248, 225844, 2, 4120},
	{52281, 225848, 2, 4120},
	{52313, 225856, 2, 4120},
	{52345, 225860, 2, 4120},
	{52378, 225864, 2, 4120},
	{52411, 225868, 2, 4120},
	{52444, 225872, 2, 4120},
	{52476, 225876, 2, 4120},
	{52508, 225880, 2, 4120},
	{52541, 225884, 2, 4120},
	{52574, 225888, 2, 4120},
	{52640, 225896, 2, 4120},
	{40332, 225900},
	{40359, 225904},
	{40241, 225908},
	{40260, 225912},
	{55027, 225932, 2, 4120},
	{55060, 225936, 2, 5246},
	{41250, 226040, 1, 2129},
	{41229, 226044, 1, 2129},
	{41022, 226048, 2, 2119},
	{41039, 226052, 1, 2121},
	{41063, 226056, 1, 2121},
	{41087, 226060, 4, 2122},
	{41113, 226064, 3, 2126},
	{41142, 226068, 1, 687},
	{41171, 226072, 3, 2126},
	{41200, 226076, 1, 687},
	{41277, 226304, 5, 2028},
	{41301, 226308, 4, 2033},
	{41326, 226312, 2, 2037},
	{41350, 226316, 5, 2028},
	{41374, 226320, 4, 2033},
	{41399, 226324, 2, 2037},
	{41423, 226328, 10, 2130},
	{41448, 226560, 5, 2140},
	{41475, 226564, 5, 2140},
	{41502, 226568, 6, 2145},
	{41533, 226608, 5, 2140},
	{41561, 226612, 5, 2140},
	{41589, 226616, 5, 2140},
	{41617, 226620, 5, 2140},
	{41645, 226624, 5, 2140},
	{41673, 226628, 5, 2140},
	{41701, 226632, 5, 2140},
	{41729, 226636, 5, 2140},
	{41757, 226640, 6, 2145},
	{195, 880, 4, 2156},
	{42808, 881},
	{26631, 882},
	{42820, 1008},
	{42831, 1009},
	{26819, 1010, 3, 2160},
	{42842, 1040, 1, 2163},
	{42855, 1041, 5, 2164},
	{42868, 1042, 1, 2169},
	{42881, 1043, 1, 1681},
	{26653, 1045, 7, 2170},
	{42909, 1280, 6, 2189},
	{42924, 1281},
	{26590, 1282},
	{42808, 1283},
	{26631, 1284},
};

static const struct si_field sid_fields_table[] = {
	/* 0 */
	{55093, 0xF},
	{55102, 0xF0},
	{55112, 0x100},
	{55123, 0x200},
	{55128, 0x400},
	{55255, 0x1FF000, 257, 0},
	{55263, 0x800000},
	{55273, 0x8000000},
	{55286, 0x10000000},
	{55292, 0xE0000000},
	/* 10 */
	{55296, 0x1},
	{55300, 0x6},
	{55309, 0x18},
	{55319, 0x20},
	{55324, 0x40},
	{55332, 0x80},
	{55342, 0x100},
	{55353, 0x200},
	{55359, 0x400},
	{55364, 0x800},
	{55370, 0x1000},
	{55381, 0x2000},
	{55386, 0x4000},
	{55391, 0x8000},
	{55142, 0x10000},
	{55406, 0x20000},
	{55414, 0x40000},
	{55426, 0x80000},
	{55434, 0x800000},
	{55445, 0x8000000},
	/* 30 */
	{55457, 0x1FF, 257, 0},
	{55462, 0x400},
	{55470, 0x800},
	{55483, 0x7000},
	{55491, 0x8000},
	{55502, 0xF0000},
	{55513, 0xF00000},
	{55529, 0x1000000},
	{55543, 0x10000000},
	{55555, 0xE0000000},
	/* 40 */
	{50478, 0xF},
	{55563, 0x30},
	{55571, 0xC0},
	{55579, 0xF00},
	{55585, 0x1000},
	{28888, 0x6000},
	{55591, 0x8000},
	{55603, 0xF0000},
	{55609, 0xF00000},
	{55615, 0x7000000},
	{55624, 0x38000000},
	{55633, 0xC0000000},
	/* 52 */
	{55639, 0xFF},
	{55649, 0xFF00},
	{55659, 0xFF0000},
	{55669, 0xF000000},
	/* 56 */
	{55679, 0x1FF},
	{55688, 0x1FF000},
	{55697, 0xF000000},
	/* 59 */
	{55714, 0xF},
	{55721, 0x70},
	{55729, 0x80},
	{55743, 0xF00},
	{55752, 0x7000},
	{55761, 0x8000},
	{55774, 0x3F0000},
	{55779, 0xC00000},
	{55789, 0x1000000},
	{55803, 0x2000000},
	{55815, 0xFC000000},
	/* 70 */
	{1112, 0xFFFF},
	/* 71 */
	{55543, 0x1},
	{55822, 0x2},
	{55828, 0x4},
	{55842, 0x8},
	{55857, 0x3F0},
	{55862, 0x1F800},
	{55774, 0xFC0000},
	{55867, 0x1000000},
	{55877, 0xFE000000},
	/* 80 */
	{50478, 0x1F},
	{55563, 0x300},
	{55886, 0x3C00},
	{55893, 0x10000},
	{28888, 0xC0000},
	/* 85 */
	{55615, 0xF},
	{55571, 0x30},
	{55633, 0x300},
	{55624, 0x7000},
	{55899, 0x1F0000},
	{55609, 0xF000000},
	{55905, 0x60000000},
	/* 92 */
	{55918, 0x1},
	{55926, 0x6},
	/* 94 */
	{55941, 0x3},
	/* 95 */
	{30356, 0x3F},
	{10081, 0xFC0},
	{10099, 0x3F000},
	{30331, 0xFC0000},
	/* 99 */
	{55950, 0x3},
	{55964, 0x80},
	{55982, 0x300},
	{55992, 0x400},
	{56005, 0x800},
	{55534, 0x1000},
	{56012, 0x2000},
	/* 106 */
	{56022, 0xF},
	{56045, 0x10},
	{56068, 0x20},
	{56091, 0x40},
	{56111, 0x80},
	{56131, 0x100},
	{56151, 0x200},
	{56171, 0x400},
	{56191, 0x800},
	{56211, 0x1000},
	{56231, 0x2000},
	{56251, 0x4000},
	{56266, 0x8000},
	{56277, 0x10000},
	{56285, 0x20000},
	{56294, 0x40000},
	{56311, 0x80000},
	{56326, 0x100000},
	{56339, 0x200000},
	{56349, 0x400000},
	{56366, 0x800000},
	{56383, 0x1000000},
	{56392, 0x2000000},
	{56401, 0x10000000},
	{56410, 0x20000000},
	{56419, 0x40000000},
	{56428, 0x80000000},
	/* 133 */
	{56439, 0xF},
	{56462, 0x20},
	{56478, 0x80},
	{56501, 0x100},
	{56524, 0x200},
	{56543, 0x1000},
	{56552, 0x2000},
	{56561, 0x4000},
	{56569, 0x8000},
	{56578, 0x10000},
	{56593, 0x100000},
	{56601, 0x200000},
	{56609, 0x400000},
	{56618, 0x800000},
	{56627, 0x1000000},
	{56635, 0x2000000},
	{56643, 0x4000000},
	{56651, 0x10000000},
	{56393, 0x20000000},
	{56669, 0x40000000},
	{56677, 0x80000000},
	/* 154 */
	{56543, 0x2},
	{56552, 0x4},
	{56688, 0x8},
	{56392, 0x10},
	{56699, 0x20},
	{56285, 0x200000},
	{56618, 0x400000},
	{56635, 0x1000000},
	{56561, 0x2000000},
	{56593, 0x4000000},
	{56609, 0x8000000},
	{56627, 0x20000000},
	{56643, 0x40000000},
	{56669, 0x80000000},
	/* 168 */
	{56710, 0x20},
	{56739, 0x40},
	{56770, 0x80},
	{56799, 0x100},
	{56819, 0x200},
	{56839, 0x400},
	{56859, 0x800},
	{56879, 0x2000},
	{56887, 0x4000},
	{56895, 0x8000},
	{56699, 0x10000},
	{56906, 0x10000000},
	{56920, 0x20000000},
	{56688, 0x40000000},
	{56929, 0x80000000},
	/* 183 */
	{56938, 0x1},
	{56948, 0x2},
	{56958, 0x4},
	{56967, 0x8},
	{56976, 0x10},
	{56987, 0x20},
	{56998, 0x40},
	{57008, 0x80},
	{57018, 0x400},
	{57028, 0x800},
	{57045, 0x1000},
	{57053, 0x2000},
	{57066, 0x4000},
	{57084, 0x8000},
	{57095, 0x10000},
	{57104, 0x20000},
	{57125, 0x40000},
	{57136, 0x80000},
	{57163, 0x20000000},
	{57176, 0x40000000},
	{56410, 0x80000000},
	/* 204 */
	{57189, 0x1},
	{57204, 0x2},
	{57224, 0x4},
	{57240, 0x8},
	{57258, 0x10},
	{57278, 0x20},
	{57297, 0x40},
	{57316, 0x80},
	{57329, 0x100},
	{57343, 0x200},
	{57367, 0x400},
	{57383, 0x800},
	{57399, 0x1000},
	{57415, 0x2000},
	{57431, 0x10000},
	{57446, 0x20000},
	{57466, 0x40000},
	{57482, 0x80000},
	{57500, 0x100000},
	{57520, 0x200000},
	{57539, 0x400000},
	{57558, 0x800000},
	{57571, 0x1000000},
	{57585, 0x2000000},
	{57609, 0x4000000},
	{57625, 0x8000000},
	{57641, 0x10000000},
	{57657, 0x20000000},
	/* 232 */
	{57673, 0x8},
	{57692, 0x10},
	{57712, 0x40},
	{57731, 0x100},
	{57752, 0x200},
	{57770, 0x400},
	{57793, 0x2000},
	{57815, 0x10000},
	{57836, 0x20000},
	{57854, 0x40000},
	{57877, 0x200000},
	{57899, 0x400000},
	{57923, 0x800000},
	{57947, 0x1000000},
	{57970, 0x2000000},
	/* 247 */
	{57992, 0x1},
	{58011, 0x2},
	{58020, 0x10},
	{58035, 0x20},
	{58049, 0x40},
	{58068, 0x80},
	{58087, 0x100},
	{58102, 0x200},
	{58119, 0x400},
	{58141, 0x800},
	{58163, 0x1000},
	{58178, 0x2000},
	{57018, 0x4000},
	{58193, 0x8000},
	{58202, 0x10000},
	{57053, 0x20000},
	{58211, 0x40000},
	{58221, 0x80000},
	{58235, 0x100000},
	{58249, 0x200000},
	{58263, 0x400000},
	{57084, 0x800000},
	{58280, 0x1000000},
	{58293, 0x4000000},
	{58306, 0x8000000},
	{58319, 0x30000000},
	{58338, 0x40000000},
	{56401, 0x80000000},
	/* 275 */
	{58351, 0x1},
	{58369, 0x2},
	{58383, 0x4},
	{58402, 0x8},
	{58421, 0x10},
	{58436, 0x20},
	{58454, 0x40},
	{58472, 0x80},
	{58489, 0x100},
	{58504, 0x200},
	{58518, 0x400},
	{58535, 0x800},
	{58559, 0x1000},
	{58577, 0x2000},
	{58595, 0x4000},
	{58616, 0x8000},
	{58640, 0x10000},
	{58666, 0x20000},
	{58683, 0x40000},
	{58703, 0x80000},
	{58723, 0x100000},
	{58743, 0x200000},
	{58764, 0x400000},
	{58787, 0x800000},
	{58808, 0x1000000},
	{58827, 0x2000000},
	{58844, 0x4000000},
	{58860, 0x8000000},
	{58876, 0x10000000},
	{58892, 0x20000000},
	{58911, 0x40000000},
	{58923, 0x80000000},
	/* 307 */
	{58935, 0x1},
	{58954, 0x2},
	{58974, 0x4},
	{58994, 0x8},
	{59014, 0x20},
	{59035, 0x40},
	{57899, 0x80},
	{57923, 0x100},
	{59056, 0x200},
	{59083, 0x400},
	{59110, 0x800},
	{59131, 0x1000},
	{59150, 0x2000},
	/* 320 */
	{59169, 0x1},
	{59183, 0x4},
	{59198, 0x8},
	{59215, 0x80},
	{59227, 0x100},
	{59240, 0x400},
	{59255, 0x800},
	{59270, 0x1000},
	{59285, 0x2000},
	/* 329 */
	{1854, 0x3F},
	/* 330 */
	{1872, 0x1FF},
	{59300, 0x80000000},
	/* 332 */
	{1854, 0x7},
	/* 333 */
	{59325, 0x1000},
	{59347, 0x4000},
	{59372, 0x20000},
	{59393, 0x40000},
	{59417, 0x400000},
	{59444, 0x800000},
	{59469, 0x1000000},
	{59492, 0x8000000},
	{59512, 0x40000000},
	/* 342 */
	{1859, 0xF},
	/* 343 */
	{10060, 0xF},
	{38, 0x3FFFFF00},
	/* 345 */
	{754, 0x1FFFFFFF},
	{59528, 0x80000000},
	/* 347 */
	{59538, 0x3},
	{59547, 0xF0},
	{59555, 0x200},
	{59562, 0x1FC00},
	/* 351 */
	{59833, 0xFFF, 2049, 257},
	{59995, 0xFF0000, 129, 2306},
	{60007, 0x3000000},
	{60020, 0x80000000},
	/* 355 */
	{982, 0x3},
	{60035, 0x4},
	{60044, 0x8},
	{60055, 0x10},
	{60068, 0x20},
	{49765, 0x1C0},
	{60082, 0x200},
	{60095, 0x400},
	{60108, 0x800},
	{60120, 0x1000},
	{60138, 0x2000},
	{60149, 0xC000},
	{60164, 0x30000},
	{60172, 0x40000},
	{60191, 0x80000},
	{60208, 0x40000000},
	{60220, 0x80000000},
	/* 372 */
	{60234, 0xFFF},
	{60249, 0xFFF000},
	{60261, 0x1000000},
	{56272, 0x2000000},
	{60269, 0x4000000},
	{60289, 0x8000000},
	/* 378 */
	{13925, 0xF},
	{60377, 0x3F0, 33, 2435},
	{60381, 0x400},
	{60256, 0x800},
	{60387, 0x1000},
	/* 383 */
	{60390, 0xFFFF},
	{19675, 0x3FFF0000},
	{60406, 0x40000000},
	{60420, 0x80000000},
	/* 387 */
	{60435, 0x7},
	{60445, 0x38},
	{60455, 0x1C0},
	{60465, 0xE00},
	{17302, 0x7F000, 293, 2468},
	{64702, 0x600000},
	{64715, 0x800000},
	{64730, 0x1000000},
	{64836, 0x30000000, 4, 2761},
	{209, 0xC0000000},
	/* 397 */
	{64847, 0x7},
	{64855, 0x38},
	{64863, 0x1C0},
	{64871, 0xE00},
	{64887, 0x7000},
	{64906, 0x8000},
	{64925, 0x70000},
	{64941, 0x80000},
	{64956, 0x100000},
	{64970, 0x7E00000},
	{64981, 0x8000000},
	{64993, 0x10000000},
	{65011, 0x60000000},
	{65023, 0x80000000},
	/* 411 */
	{65036, 0xFFF},
	{65044, 0xFFF000},
	{65052, 0xF000000},
	{65061, 0xF0000000},
	/* 415 */
	{65068, 0x3FFF},
	{65077, 0xFFF},
	{65094, 0x3000},
	{65112, 0xFC000},
	{65125, 0x300000},
	{65139, 0xC00000},
	{65153, 0x3000000},
	{65162, 0xC000000},
	{65173, 0x10000000},
	{65192, 0x20000000},
	{65207, 0x40000000},
	{65222, 0x80000000},
	/* 427 */
	{65077, 0xFFF},
	{65094, 0xC0000000},
	/* 429 */
	{65238, 0x1FFFFF},
	{65257, 0xE00000},
	{65276, 0x1000000},
	{65298, 0x2000000},
	{65320, 0x4000000},
	{65336, 0x8000000},
	{65353, 0x10000000},
	{65371, 0x20000000},
	{65387, 0xC0000000},
	/* 438 */
	{65408, 0x7},
	{65418, 0x38},
	{65439, 0xC0},
	{65460, 0x180000},
	{65479, 0xC000000},
	/* 443 */
	{65849, 0x3C, 16, 2765},
	{66277, 0x7C0, 19, 2781},
	{66467, 0x3800, 7, 2800},
	{66626, 0x1C00000, 5, 2807},
	{66646, 0x6000000},
	/* 448 */
	{66751, 0x3, 4, 2812},
	{66858, 0xC, 4, 2816},
	{66970, 0x30, 4, 2820},
	{67057, 0xC0, 4, 2824},
	/* 452 */
	{60390, 0xFF},
	{65036, 0xFFF00},
	{17302, 0x1FF00000, 293, 2468},
	{67067, 0xC0000000},
	/* 456 */
	{67076, 0xFFF},
	{66863, 0xFFFC000},
	{64730, 0x80000000},
	/* 459 */
	{60435, 0x7},
	{60445, 0x38},
	{60455, 0x1C0},
	{60465, 0xE00},
	{67085, 0xF000},
	{67096, 0xF0000},
	{67107, 0x1F00000},
	{67211, 0xE000000, 6, 2828},
	{209, 0xF0000000},
	/* 468 */
	{18448, 0x1FFF},
	{67222, 0x1FFF0000},
	/* 470 */
	{67233, 0xF},
	{67245, 0xF0},
	{67253, 0xFFF00},
	{67266, 0x700000},
	{67275, 0x800000},
	{67290, 0x2000000},
	{67305, 0x4000000},
	/* 477 */
	{67317, 0xFF},
	{67333, 0x400},
	{67345, 0x18000},
	{67373, 0x60000},
	{67399, 0x80000},
	{67417, 0x100000},
	{67439, 0x200000},
	{67454, 0x400000},
	{67470, 0x800000},
	{67486, 0xFF000000},
	/* 487 */
	{67507, 0xFFFF},
	/* 488 */
	{67507, 0xFFFF},
	{67513, 0x3F0000},
	{67524, 0x3C00000},
	/* 491 */
	{67543, 0xFF},
	/* 492 */
	{67552, 0x3F},
	{67558, 0x3C0},
	{65248, 0xC00},
	{67607, 0xFF000, 241, 2834},
	{55319, 0x100000},
	{55112, 0x200000},
	{67618, 0x800000},
	{67628, 0x1000000},
	{67645, 0x2000000},
	{55992, 0x4000000},
	{55263, 0x20000000},
	/* 503 */
	{67657, 0x1},
	{67668, 0x3E},
	{67678, 0x40},
	{67691, 0x80},
	{67703, 0xFF00},
	{55255, 0x1FF0000, 257, 0},
	{67718, 0x2000000},
	{67740, 0x4000000},
	{67765, 0x8000000},
	{67779, 0xF0000000},
	/* 513 */
	{67795, 0x1},
	{67812, 0x1E},
	{67838, 0x1E0},
	{67871, 0x200},
	{67892, 0x7C00},
	{67916, 0x8000},
	{67941, 0x10000},
	{67960, 0xE0000},
	/* 521 */
	{67997, 0x7},
	{68026, 0x38},
	{68058, 0x40},
	{68074, 0xFF00},
	{68103, 0xFF0000},
	/* 526 */
	{68135, 0x7F},
	/* 527 */
	{67518, 0x3F},
	/* 528 */
	{67552, 0x3F},
	{67558, 0x3C0},
	{65248, 0xC00},
	{67607, 0xFF000, 241, 2834},
	{55319, 0x100000},
	{55112, 0x200000},
	{67618, 0x800000},
	{68148, 0x3000000},
	{68162, 0x4000000},
	{67645, 0x8000000},
	{55992, 0x10000000},
	{55263, 0x80000000},
	/* 540 */
	{67657, 0x1},
	{67668, 0x3E},
	{67678, 0x40},
	{68178, 0x80},
	{68188, 0x100},
	{68200, 0x200},
	{68212, 0x400},
	{68224, 0x800},
	{68236, 0x1000},
	{55255, 0x3FE000, 257, 0},
	{68242, 0x400000},
	{68253, 0x1000000},
	{67765, 0x8000000},
	{67779, 0xF0000000},
	/* 554 */
	{67657, 0x1},
	{67668, 0x3E},
	{67678, 0x40},
	{55255, 0xFF80, 257, 0},
	{68148, 0x30000},
	{68178, 0x40000},
	{55688, 0x7F80000},
	{68270, 0x8000000},
	{67765, 0x10000000},
	/* 563 */
	{67657, 0x1},
	{67668, 0x3E},
	{67678, 0x40},
	{68178, 0x80},
	{55255, 0x1FF00, 257, 0},
	{55688, 0x1FF00000},
	/* 569 */
	{67657, 0x1},
	{67668, 0x3E},
	{67678, 0x40},
	{55688, 0xFF80},
	{55255, 0x1FF0000, 257, 0},
	/* 574 */
	{67507, 0xFFFF},
	{68282, 0x7F0000},
	/* 576 */
	{67507, 0xFFFF},
	{67513, 0x3F0000},
	{67524, 0x3C00000},
	{68307, 0xFC000000},
	/* 580 */
	{67552, 0x3F},
	{67558, 0x3C0},
	{65248, 0xC00},
	{67607, 0xFF000, 241, 2834},
	{55319, 0x100000},
	{55112, 0x200000},
	{67618, 0x800000},
	{68162, 0x1000000},
	{67645, 0x2000000},
	{55992, 0x4000000},
	{68324, 0x8000000},
	{68333, 0x60000000},
	{55263, 0x80000000},
	/* 593 */
	{67657, 0x1},
	{67668, 0x3E},
	{67678, 0x40},
	{55255, 0xFF80, 257, 0},
	{68350, 0x30000},
	{68178, 0x40000},
	{55688, 0x7F80000},
	{67765, 0x8000000},
	{67779, 0xF0000000},
	/* 602 */
	{67552, 0x3F},
	{67558, 0x3C0},
	{65248, 0xC00},
	{67607, 0xFF000, 241, 2834},
	{55319, 0x100000},
	{55112, 0x200000},
	{67618, 0x800000},
	{68148, 0x3000000},
	{68162, 0x4000000},
	{55263, 0x80000000},
	/* 612 */
	{67513, 0x3F},
	{67524, 0x3C0},
	{68307, 0xFC00},
	{67507, 0xFFFF0000},
	/* 616 */
	{67552, 0x3F},
	{67558, 0x3C0},
	{65248, 0xC00},
	{67607, 0xFF000, 241, 2834},
	{55319, 0x100000},
	{55112, 0x200000},
	{67618, 0x800000},
	{67645, 0x1000000},
	{55992, 0x2000000},
	{68324, 0x4000000},
	{68367, 0x30000000},
	{55263, 0x40000000},
	/* 628 */
	{67657, 0x1},
	{67668, 0x3E},
	{67678, 0x40},
	{68178, 0x80},
	{68384, 0x100},
	{55255, 0x3FE00, 257, 0},
	{55688, 0x7FC0000},
	{67765, 0x8000000},
	{67779, 0xF0000000},
	/* 637 */
	{67552, 0x3F},
	{67558, 0x3C0},
	{65248, 0xC00},
	{67607, 0xFF000, 241, 2834},
	{55319, 0x100000},
	{55112, 0x200000},
	{67618, 0x800000},
	{68148, 0x3000000},
	{55263, 0x40000000},
	/* 646 */
	{68395, 0x1},
	{68413, 0x2},
	{68427, 0x4},
	{68446, 0x8},
	{68466, 0x10},
	{68486, 0x20},
	{68508, 0x40},
	{68519, 0x400},
	{68537, 0x800},
	{10365, 0x1000},
	{68555, 0x2000},
	{68569, 0x4000},
	{68577, 0x8000},
	/* 659 */
	{68587, 0xFFFF},
	{68603, 0xFFFF0000},
	/* 661 */
	{9869, 0x1},
	/* 662 */
	{9897, 0x1},
	/* 663 */
	{391, 0xFF},
	/* 664 */
	{67552, 0x3F},
	{67558, 0x3C0},
	{65248, 0xC00},
	{67607, 0xFF000, 241, 2834},
	{55319, 0x100000},
	{55112, 0x200000},
	{67618, 0x800000},
	{68622, 0x1000000},
	{55263, 0x4000000},
	{68324, 0x20000000},
	{67645, 0x40000000},
	{55992, 0x80000000},
	/* 676 */
	{67657, 0x1},
	{67668, 0x3E},
	{67678, 0x40},
	{68628, 0x80},
	{68638, 0x100},
	{68648, 0x200},
	{68384, 0x400},
	{68658, 0x1800},
	{68673, 0x6000},
	{55688, 0xFF8000},
	{55255, 0x7F000000, 257, 0},
	/* 687 */
	{391, 0xF},
	/* 688 */
	{68685, 0x3FF},
	{68698, 0xF000},
	{68708, 0x3F0000},
	{68723, 0x400000},
	{68738, 0x800000},
	{68754, 0x7000000},
	/* 694 */
	{68769, 0xFFF},
	{68775, 0x1FFF000},
	/* 696 */
	{10332, 0x1},
	/* 697 */
	{68784, 0x3},
	{65932, 0x4},
	{68794, 0x8},
	{68804, 0x10},
	{68814, 0x1FFE0},
	/* 702 */
	{67795, 0x1},
	{67812, 0x1E},
	{67838, 0x1E0},
	{67871, 0x200},
	{67892, 0x7C00},
	{67916, 0x8000},
	{67941, 0x10000},
	{67960, 0xE0000},
	{68827, 0x7F00000},
	/* 711 */
	{67779, 0xF},
	/* 712 */
	{441, 0x7FF},
	/* 713 */
	{68864, 0x3FFFFFFF},
	{68872, 0x40000000},
	{68881, 0x80000000},
	/* 716 */
	{11614, 0xFFFF},
	/* 717 */
	{68890, 0x3FF},
	{59701, 0x400},
	/* 719 */
	{68900, 0x1},
	{68919, 0x2},
	{68940, 0x4},
	{68951, 0x8},
	{68964, 0x10},
	{68983, 0x20},
	{69008, 0x40},
	{69031, 0x80},
	{69045, 0xF00},
	{69057, 0x1000},
	/* 729 */
	{69075, 0x1},
	{69099, 0x2},
	{69120, 0x4},
	{69154, 0x8},
	{69189, 0x70},
	{69201, 0xF00},
	{69214, 0xF000},
	{69227, 0xF0000},
	{69240, 0xF00000},
	{69254, 0xF000000},
	{69272, 0xF0000000},
	/* 740 */
	{69289, 0x7FF},
	{69301, 0x1800},
	{69316, 0xFFE000},
	{69326, 0x1000000},
	{69338, 0x2000000},
	{69356, 0x3C000000},
	{69362, 0xC0000000},
	/* 747 */
	{69427, 0x3, 4, 3075},
	{69444, 0xC, 4, 3075},
	{69462, 0x30, 4, 3075},
	{69480, 0x40},
	{69501, 0x80},
	{69516, 0x100},
	{69537, 0x200},
	{69555, 0x400},
	{69572, 0x800},
	{69585, 0x1000},
	{69604, 0x6000, 4, 3075},
	{69623, 0x8000},
	{69647, 0x10000},
	{69670, 0x20000},
	{69687, 0x40000},
	{69772, 0x180000, 4, 3079},
	{69791, 0x3E00000},
	{69808, 0x4000000},
	{69832, 0x8000000},
	{69846, 0x10000000},
	{69866, 0x20000000},
	{69880, 0x40000000},
	{69900, 0x80000000},
	/* 770 */
	{69974, 0x3, 4, 3083},
	{70003, 0x1C},
	{70034, 0x20},
	{70070, 0x40},
	{70105, 0x80},
	{70133, 0x100},
	{70155, 0x200},
	{70173, 0x400},
	{70205, 0x800},
	{70326, 0x7000, 8, 3087},
	{70336, 0x38000},
	{70349, 0x1C0000},
	{70362, 0x200000},
	{70378, 0x400000},
	{70396, 0x800000},
	{70414, 0x2000000},
	/* 786 */
	{70442, 0x3FFF},
	{55087, 0x3FFF0000},
	/* 788 */
	{11232, 0xFF},
	/* 789 */
	{70448, 0xFFFF},
	{70453, 0xFFFF0000},
	/* 791 */
	{70458, 0xFFFF},
	{70463, 0xFFFF0000},
	/* 793 */
	{70477, 0x3, 4, 3095},
	{70491, 0x4},
	{70516, 0x8},
	/* 796 */
	{70534, 0xF},
	{70542, 0xF0},
	{70550, 0x1F00},
	{70558, 0x6000},
	{70566, 0x18000},
	{70574, 0x60000},
	{70582, 0x180000},
	{64730, 0xF0000000},
	/* 804 */
	{17302, 0x3, 4, 3099},
	{70621, 0xC},
	{67107, 0x1F0},
	{70676, 0x600, 4, 3103},
	{70691, 0x800},
	{70705, 0x1000},
	{70724, 0xE000},
	{70741, 0xF0000},
	{67333, 0x100000},
	{70748, 0x7800000},
	{70772, 0x8000000},
	{70787, 0x10000000},
	{70797, 0x20000000},
	{70817, 0x80000000},
	/* 818 */
	{17302, 0x1, 2, 3107},
	{67107, 0x1F0},
	{70676, 0x600, 4, 3103},
	{70691, 0x800},
	{70705, 0x1000},
	{70724, 0xE000},
	{67333, 0x100000},
	{70772, 0x8000000},
	{70860, 0x20000000},
	/* 827 */
	{70534, 0x7FF},
	{70542, 0x3FF800},
	/* 829 */
	{70534, 0x3FFFFF},
	/* 830 */
	{10060, 0xFF},
	/* 831 */
	{70932, 0x3, 4, 3109},
	{70944, 0xC, 4, 3109},
	{70956, 0x30, 4, 3109},
	{70972, 0xC0, 4, 3109},
	{71042, 0x30000, 4, 3113},
	{71054, 0xC0000, 4, 3113},
	{71066, 0x300000, 4, 3113},
	{71082, 0x1000000},
	{71093, 0x2000000},
	/* 840 */
	{30565, 0xFF},
	/* 841 */
	{71104, 0xFF},
	/* 842 */
	{71122, 0xFFFF},
	{71138, 0xFFFF0000},
	/* 844 */
	{70448, 0x7FFF},
	{70453, 0x7FFF0000},
	{71154, 0x80000000},
	/* 847 */
	{70458, 0x7FFF},
	{70463, 0x7FFF0000},
	/* 849 */
	{71242, 0xFFFF, 32769, 3117},
	/* 850 */
	{71252, 0xF},
	{71259, 0xF0},
	{71268, 0xF00},
	{71276, 0x3F000},
	{71287, 0xFC0000},
	{71298, 0xF000000},
	{71309, 0xF0000000},
	/* 857 */
	{71320, 0x1FF},
	{71339, 0x1FF0000},
	/* 859 */
	{71358, 0xF},
	{71373, 0xF0},
	{71388, 0xF00},
	{71403, 0xF000},
	{71418, 0xF0000},
	{71433, 0xF00000},
	{71448, 0xF000000},
	{71463, 0xF0000000},
	/* 867 */
	{71478, 0xF},
	{71493, 0xF0},
	{71508, 0xF00},
	{71523, 0xF000},
	{71538, 0xF0000},
	{71553, 0xF00000},
	{71568, 0xF000000},
	{71583, 0xF0000000},
	/* 875 */
	{71690, 0x3, 4, 35886},
	{71702, 0xC, 4, 35886},
	{71814, 0x30, 4, 35890},
	{71871, 0x40, 2, 35894},
	{71927, 0x80, 2, 35896},
	{72031, 0x300, 4, 35898},
	{72139, 0xC00, 4, 35902},
	{72248, 0x3000, 4, 35906},
	{72361, 0xC000, 4, 35910},
	{72463, 0x30000, 4, 35914},
	{72609, 0xC0000, 4, 35918},
	{72756, 0x300000, 4, 35922},
	{72856, 0x3000000, 4, 35926},
	{73002, 0xC000000, 4, 35930},
	{73149, 0x30000000, 4, 35934},
	/* 890 */
	{73269, 0x3, 4, 35938},
	{73440, 0xC, 4, 35942},
	{73612, 0x30, 4, 35946},
	/* 893 */
	{69254, 0x3},
	{69272, 0xC},
	/* 895 */
	{9882, 0x1},
	{73625, 0x6},
	{65479, 0x60},
	{73632, 0x100},
	{73667, 0x3000},
	{73674, 0x30000},
	{73688, 0x100000},
	/* 902 */
	{73706, 0x80000000},
	/* 903 */
	{55571, 0x3},
	/* 904 */
	{10112, 0xF},
	/* 905 */
	{73721, 0xFF},
	{73730, 0xFF00},
	{73740, 0xFF0000},
	{73751, 0xFF000000},
	/* 909 */
	{73761, 0xFF},
	{73769, 0xFF00},
	{73778, 0xFF0000},
	{73787, 0xFF000000},
	/* 913 */
	{73795, 0x3, 4, 3109},
	{73811, 0xC, 4, 3109},
	{73827, 0x30, 4, 3109},
	{73841, 0xC0, 4, 3109},
	{73857, 0x30000, 4, 3113},
	{73873, 0xC0000, 4, 3113},
	{73889, 0x300000, 4, 3113},
	{73903, 0xC00000, 4, 3113},
	{73919, 0x40000000},
	{73934, 0x80000000},
	/* 923 */
	{73949, 0x1},
	{73976, 0x7C},
	{74005, 0x100},
	{74034, 0x200},
	{74065, 0x400},
	{74093, 0x1000},
	{74121, 0x2000},
	{74151, 0x4000},
	/* 931 */
	{74177, 0x1},
	{74197, 0xE},
	{74214, 0x30},
	{74235, 0xF00},
	/* 935 */
	{74493, 0xF, 16, 35950},
	{74505, 0xF0, 16, 35950},
	{74518, 0xF00, 16, 35950},
	{74531, 0xF000, 16, 35950},
	{74546, 0xF0000, 16, 35950},
	{74562, 0xF00000, 16, 35950},
	/* 941 */
	{74578, 0xFF},
	{74593, 0xFF00},
	{74605, 0xFF0000},
	{74622, 0xFF000000},
	/* 945 */
	{74635, 0xFF},
	{74653, 0xFF00},
	{74668, 0xFF0000},
	{74688, 0xFF000000},
	/* 949 */
	{754, 0x3F},
	{74704, 0x300},
	{74716, 0x400},
	{74727, 0x1E000},
	{74736, 0x20000},
	{74750, 0x40000},
	{74754, 0x80000},
	{74771, 0x100000},
	{74789, 0x600000},
	{74807, 0x800000},
	{74827, 0x1000000},
	{74839, 0x2000000},
	/* 961 */
	{754, 0x3F},
	{74704, 0x300},
	{74716, 0x400},
	{74750, 0x40000},
	{74754, 0x80000},
	{74771, 0x100000},
	{74789, 0x600000},
	{74827, 0x1000000},
	{74839, 0x2000000},
	/* 970 */
	{74851, 0x3E},
	{74867, 0x40},
	{74880, 0x80},
	/* 973 */
	{74893, 0x1},
	{74910, 0x2},
	{74927, 0x4},
	{74946, 0x8},
	{74967, 0x10},
	{74985, 0x20},
	{75003, 0x40},
	{75023, 0x80},
	{75044, 0x100},
	{75060, 0x200},
	{75076, 0x400},
	{75092, 0x800},
	{75108, 0x1000},
	{75123, 0x2000},
	{75137, 0x4000},
	{75157, 0x8000},
	/* 989 */
	{75174, 0x1},
	{75189, 0x2},
	{75312, 0x1C, 5, 35966},
	{75330, 0xE0, 5, 35966},
	{75348, 0x700, 5, 35966},
	{75366, 0x3800, 5, 35966},
	{75384, 0x4000},
	/* 996 */
	{75401, 0x3F},
	{75412, 0x40},
	{75422, 0x80},
	{75439, 0x100},
	{75455, 0x4000},
	{75475, 0x8000},
	/* 1002 */
	{75485, 0x1},
	{75503, 0x10},
	{75523, 0x100},
	{75542, 0x1000},
	{75563, 0x30000},
	{75582, 0x100000},
	{75596, 0x1000000},
	/* 1009 */
	{75704, 0xF, 5, 35971},
	/* 1010 */
	{75723, 0xF, 5, 35971},
	{75742, 0xF0, 5, 35971},
	{75761, 0xF00, 5, 35971},
	{75780, 0xF000, 5, 35971},
	{75799, 0xF0000, 5, 35971},
	/* 1015 */
	{76018, 0xF, 10, 35976},
	/* 1016 */
	{76034, 0xF, 10, 35976},
	{76053, 0xF0, 10, 35976},
	{76072, 0xF00, 10, 35976},
	{76091, 0xF000, 10, 35976},
	{76110, 0xF0000, 10, 35976},
	{76129, 0xF00000, 10, 35976},
	{76148, 0xF000000, 10, 35976},
	{76167, 0xF0000000, 10, 35976},
	/* 1024 */
	{76421, 0xF, 11, 35986},
	{76426, 0xF0, 11, 35986},
	{76431, 0xF00, 11, 35986},
	{76436, 0xF000, 11, 35986},
	{76441, 0xF0000, 11, 35986},
	{76446, 0xF00000, 11, 35986},
	{76451, 0xF000000, 11, 35986},
	{76456, 0xF0000000, 11, 35986},
	/* 1032 */
	{76535, 0xF, 16, 35997},
	{76548, 0xF0},
	{76561, 0xF00},
	{76574, 0xF000},
	{76587, 0xF0000},
	{76600, 0xF00000},
	{76613, 0xF000000},
	{76626, 0xF0000000},
	/* 1040 */
	{76639, 0x1},
	{76662, 0x2},
	{76685, 0x10},
	{76708, 0x20},
	{76731, 0x100},
	{76754, 0x200},
	{76777, 0x1000},
	{76800, 0x2000},
	{76823, 0x10000},
	{76846, 0x20000},
	{76869, 0x100000},
	{76892, 0x200000},
	{76915, 0x1000000},
	{76938, 0x2000000},
	{76961, 0x10000000},
	{76984, 0x20000000},
	{77007, 0x80000000},
	/* 1057 */
	{77298, 0x7, 8, 36013},
	{77312, 0x70, 8, 36013},
	{77460, 0x700, 8, 36021},
	{77475, 0x70000, 8, 36013},
	{77489, 0x700000, 8, 36013},
	{77503, 0x7000000, 8, 36021},
	/* 1063 */
	{77958, 0x1F, 21, 36029},
	{77460, 0xE0, 5, 36050},
	{78063, 0x1F00, 21, 36029},
	{78079, 0x1F0000, 21, 36029},
	{77503, 0xE00000, 5, 36050},
	{78094, 0x1F000000, 21, 36029},
	{78110, 0x20000000},
	{9882, 0x40000000},
	{78131, 0x80000000},
	/* 1072 */
	{78144, 0x7},
	/* 1073 */
	{11609, 0xFFFF},
	/* 1074 */
	{78235, 0x3, 4, 36055},
	{78281, 0xC, 2, 36059},
	{78292, 0x10},
	{78307, 0x20},
	{78315, 0x40},
	{78326, 0x80},
	{78340, 0x100},
	{78357, 0xE0000000},
	/* 1082 */
	{78370, 0xFFFFFFF},
	/* 1083 */
	{78382, 0x3FF},
	/* 1084 */
	{78405, 0x1},
	{69435, 0x2},
	{78420, 0x4},
	{78435, 0x8},
	{70330, 0x70, 8, 3087},
	{78455, 0x80},
	{78471, 0x700, 8, 3087},
	{78483, 0x700000, 8, 3087},
	{78498, 0x40000000},
	{78532, 0x80000000},
	/* 1094 */
	{78567, 0x7},
	{78586, 0x70},
	{78602, 0x700},
	{78626, 0x7000},
	{78652, 0x10000},
	{78679, 0x20000},
	{78701, 0x40000},
	{78720, 0x80000},
	{78738, 0x100000},
	{78765, 0x200000},
	{78792, 0x7000000},
	{78817, 0x8000000},
	/* 1106 */
	{78848, 0x1},
	{78866, 0x8},
	{982, 0x70, 8, 36061},
	{78139, 0xFF0000, 256, 36069},
	/* 1110 */
	{79286, 0x1},
	{79302, 0x2},
	{79333, 0x4},
	{69493, 0x30, 4, 36325},
	{79412, 0x40},
	{79424, 0x80},
	{79448, 0x100},
	{79467, 0x200},
	{79485, 0x400},
	{79498, 0x800},
	{79520, 0x1000},
	{79610, 0x6000, 4, 36329},
	{79632, 0x8000},
	{79650, 0x10000},
	{79681, 0x20000},
	{79700, 0x700000},
	{79725, 0x800000},
	/* 1127 */
	{79758, 0x1},
	{79768, 0x2},
	{79778, 0x4},
	{79788, 0x8},
	{79798, 0x10},
	{79808, 0x20},
	{79818, 0x2000},
	{79837, 0xC000},
	{79849, 0x10000},
	{79862, 0x20000},
	{79880, 0x40000},
	{79903, 0x80000},
	{79921, 0x100000},
	{79941, 0x200000},
	{79953, 0x400000},
	{79975, 0x1000000},
	{79999, 0x2000000},
	{80025, 0x4000000},
	{80044, 0x8000000},
	{80062, 0x10000000},
	/* 1147 */
	{80082, 0x1},
	{80093, 0x2},
	{19176, 0x4},
	{80113, 0x18, 2, 36333},
	{80179, 0xE0, 3, 36335},
	{80200, 0x700, 3, 36335},
	{80220, 0x800},
	{80245, 0x1000},
	{80269, 0x2000},
	{80293, 0x10000},
	{80318, 0x80000},
	{80337, 0x100000},
	{80352, 0x200000},
	{80370, 0x400000},
	{80408, 0x800000},
	{80431, 0x1000000},
	/* 1163 */
	{80452, 0x1},
	{80470, 0x2},
	{80489, 0x4},
	{80507, 0x8},
	{80526, 0x10},
	{80544, 0x20},
	{80563, 0x100},
	{80574, 0x200},
	{80584, 0x400},
	{80595, 0x800},
	/* 1173 */
	{80611, 0x1},
	{80627, 0x2},
	{80643, 0x4},
	{80659, 0x8},
	{80675, 0x10},
	{80691, 0x20},
	{80707, 0x40},
	{80723, 0x80},
	{80739, 0x100},
	{80755, 0x200},
	{80771, 0x400},
	{80787, 0x800},
	{80803, 0x1000},
	{80819, 0x2000},
	{80835, 0x4000},
	{80851, 0x8000},
	{80867, 0x10000},
	{80886, 0x20000},
	{80904, 0x40000},
	{80931, 0x80000},
	{80953, 0x100000},
	{80971, 0x200000},
	{80991, 0x400000},
	{81014, 0x800000},
	{81037, 0x1000000},
	{81062, 0x2000000},
	{81082, 0x4000000},
	{81105, 0x8000000},
	/* 1201 */
	{81124, 0x1},
	{81143, 0x2},
	{81161, 0x4},
	{81179, 0x8},
	{81197, 0x10},
	{81215, 0x20},
	{81232, 0x40},
	{81249, 0x80},
	{81270, 0x100},
	{81287, 0x200},
	{81304, 0x400},
	{81320, 0x800},
	{81336, 0x1000},
	{81352, 0x2000},
	{81368, 0x4000},
	{81393, 0x100000},
	/* 1217 */
	{81413, 0x3},
	{81432, 0x4},
	{81451, 0x8},
	{81468, 0x10},
	/* 1221 */
	{81483, 0x1},
	{81507, 0x2},
	{81527, 0x4},
	{81548, 0x8},
	{81573, 0x10},
	{81593, 0x20},
	{81609, 0x40},
	{81626, 0x80},
	{81647, 0xFF00},
	{81668, 0x40000000},
	{81689, 0x80000000},
	/* 1232 */
	{81711, 0x1},
	{81483, 0x2},
	{81507, 0x4},
	{81527, 0x8},
	{81548, 0x10},
	{81736, 0x20},
	{81749, 0x40},
	/* 1239 */
	{81778, 0x1},
	{81789, 0x2},
	/* 1241 */
	{81807, 0x1},
	{81824, 0x2},
	/* 1243 */
	{81848, 0x1},
	{81873, 0x2},
	{81894, 0x4},
	{81916, 0x8},
	{81942, 0x10},
	/* 1248 */
	{81959, 0x1E},
	{81971, 0xE0},
	{81985, 0xF00},
	{82001, 0x70000},
	{82012, 0x780000},
	/* 1253 */
	{66863, 0xFFFF},
	{66756, 0xFFFF0000},
	/* 1255 */
	{82025, 0xFFFF},
	{18849, 0xFFFF0000},
	/* 1257 */
	{66756, 0xFFFF},
	/* 1258 */
	{82034, 0xFFFF},
	{82047, 0xFF0000},
	{82060, 0x10000000},
	{82078, 0x60000000},
	/* 1262 */
	{82094, 0x7},
	/* 1263 */
	{82106, 0x3},
	/* 1264 */
	{18442, 0xFF},
	/* 1265 */
	{18464, 0x1F, 22, 36338},
	{82465, 0x4000},
	{82478, 0x8000},
	{82491, 0x70000},
	/* 1269 */
	{18484, 0xF},
	/* 1270 */
	{18490, 0xF},
	/* 1271 */
	{82502, 0x1},
	{82512, 0x2},
	{82522, 0x4},
	{82532, 0x8},
	{19675, 0xFF00},
	{82542, 0xFF0000},
	/* 1277 */
	{82548, 0xF},
	{13837, 0xF0},
	{82555, 0xF00},
	{71145, 0xF000},
	{82562, 0xF0000},
	{82569, 0xF00000},
	{82578, 0xF000000},
	{11769, 0xF0000000},
	/* 1285 */
	{982, 0x7, 6, 36360},
	{82658, 0x8},
	{82714, 0x30, 4, 36366},
	{82723, 0x7C0},
	{82734, 0x800},
	{82747, 0x1000},
	{82758, 0x2000},
	{82770, 0x4000},
	{82783, 0x8000},
	{82801, 0x10000},
	{82817, 0x20000},
	{82836, 0x40000},
	{82850, 0x80000},
	{82868, 0x100000},
	{82886, 0x600000},
	/* 1300 */
	{82893, 0x7FF},
	{82913, 0x3FF800},
	{82933, 0xFFC00000},
	/* 1303 */
	{82957, 0x1},
	{82969, 0x2},
	{82990, 0x4},
	{83010, 0x8},
	{83035, 0x10},
	{83056, 0x20},
	{83079, 0x40},
	/* 1310 */
	{83109, 0x1},
	{83119, 0x2},
	{83134, 0x4},
	{83159, 0x8},
	{83177, 0x70},
	{83193, 0x80},
	{83198, 0x100},
	{83221, 0x200},
	{83240, 0x400},
	{83262, 0x800},
	{83278, 0x1000},
	{83294, 0x2000},
	{83310, 0x4000},
	{83329, 0x8000},
	{83355, 0x10000},
	{83370, 0x20000},
	{83410, 0x40000},
	{83437, 0x80000},
	{83460, 0xF00000},
	{83476, 0x1000000},
	{83506, 0x2000000},
	{83530, 0x4000000},
	{83551, 0x8000000},
	{83581, 0x70000000},
	/* 1334 */
	{18689, 0x7FF},
	/* 1335 */
	{18703, 0x7FF},
	/* 1336 */
	{18717, 0xF},
	/* 1337 */
	{754, 0x7FFF},
	/* 1338 */
	{83605, 0x3F, 4, 36370},
	{83618, 0x3F00, 4, 36370},
	{83633, 0x3F0000, 4, 36370},
	{83648, 0xFC00000, 4, 36370},
	{83663, 0x80000000},
	/* 1343 */
	{203, 0x3, 3, 36374},
	{83800, 0xC, 4, 36377},
	{83880, 0x30, 4, 36381},
	{83940, 0xC0, 3, 36385},
	{83953, 0x100},
	{78307, 0x200},
	{83957, 0x400},
	{83966, 0x3800},
	/* 1351 */
	{18892, 0x1},
	{83972, 0x2},
	{83993, 0x4},
	/* 1354 */
	{85176, 0x3F, 64, 36388},
	{60395, 0x7FFFC00},
	{85187, 0x8000000},
	/* 1357 */
	{18989, 0x1},
	{85202, 0x2},
	/* 1359 */
	{85217, 0x1},
	{85231, 0x2},
	{85247, 0x4},
	{85265, 0x8},
	{85281, 0x10},
	/* 1364 */
	{85292, 0xFFFF},
	{85307, 0x10000},
	{85326, 0x20000},
	{85340, 0x40000},
	{85359, 0x80000},
	{85373, 0x100000},
	/* 1370 */
	{19103, 0x7FFF},
	/* 1371 */
	{19139, 0x1},
	/* 1372 */
	{19153, 0x1},
	/* 1373 */
	{70724, 0x1},
	{85390, 0x2},
	{85401, 0x4},
	{85418, 0x8},
	{85435, 0x3F0},
	{85452, 0xFC00},
	{85469, 0x10000},
	{85493, 0x20000},
	{67404, 0x40000},
	/* 1382 */
	{85510, 0x7, 8, 3087},
	{85523, 0xFF0},
	{85537, 0xFF000},
	{69454, 0x1000000},
	/* 1386 */
	{85550, 0x7, 8, 3087},
	{85563, 0xFF0},
	{85577, 0xFF000},
	{69472, 0x1000000},
	/* 1390 */
	{9758, 0xFF},
	{9774, 0xFF00},
	{85590, 0xFF0000},
	{85596, 0xFF000000},
	/* 1394 */
	{19675, 0x3FF},
	/* 1395 */
	{19668, 0x1FF},
	/* 1396 */
	{19689, 0x7FF},
	/* 1397 */
	{85602, 0x1FF},
	{85618, 0x3FE00},
	/* 1399 */
	{85634, 0xFF},
	{85648, 0xFF00},
	{85658, 0xFF0000},
	{85669, 0x1F000000},
	{85681, 0xE0000000},
	/* 1404 */
	{85741, 0x3, 4, 36452},
	{85772, 0x4, 2, 36456},
	{19758, 0x18, 4, 36458},
	{85854, 0x20, 2, 36462},
	{85919, 0xC0, 4, 36464},
	{85925, 0x100},
	{68253, 0x200},
	{85936, 0x400},
	{85956, 0x800},
	{85976, 0x1000},
	{85990, 0x2000},
	{86001, 0x4000},
	{86017, 0x78000},
	{86037, 0x180000},
	{86052, 0x200000},
	{86062, 0x400000},
	{86072, 0x800000},
	{86082, 0x1000000},
	{86097, 0x2000000},
	/* 1423 */
	{86117, 0xFF},
	{86129, 0x3F00},
	{86145, 0xFC000},
	/* 1426 */
	{209, 0x3, 3, 36468},
	{86251, 0x1C, 4, 36471},
	{86328, 0xE0, 4, 36475},
	{86337, 0x100},
	{86357, 0x200},
	{86368, 0x3C00},
	{86390, 0x4000},
	{83940, 0x18000, 3, 36385},
	{86424, 0x60000, 4, 36479},
	{86483, 0x80000, 3, 36483},
	{86535, 0x100000, 3, 36486},
	{83966, 0x3800000},
	/* 1438 */
	{86547, 0x1},
	{86568, 0x300},
	{86590, 0xC00},
	{86612, 0x3000},
	{86634, 0xC000},
	{86656, 0x10000},
	/* 1444 */
	{86669, 0xFF},
	{86697, 0x100},
	/* 1446 */
	{9882, 0x1},
	{20115, 0x1FC},
	{86725, 0x80000000},
	/* 1449 */
	{86757, 0x1},
	{86772, 0x2},
	{86787, 0x4},
	{86802, 0x8},
	{86817, 0x70},
	{86829, 0x80},
	{86849, 0xF00},
	{86866, 0x80000000},
	/* 1457 */
	{86887, 0xF},
	{86906, 0xF0},
	{86925, 0xF00},
	{86944, 0xF000},
	/* 1461 */
	{86963, 0xF},
	{86974, 0xF0},
	{86985, 0xF00},
	{86996, 0xF000},
	{87007, 0xF0000},
	{87018, 0xF00000},
	{87029, 0xF000000},
	{87040, 0xF0000000},
	/* 1469 */
	{87051, 0xF},
	{87062, 0xF0},
	{87073, 0xF00},
	{87085, 0xF000},
	{87097, 0xF0000},
	{87109, 0xF00000},
	{87121, 0xF000000},
	{87133, 0xF0000000},
	/* 1477 */
	{87145, 0x200},
	{87163, 0x400},
	{87174, 0x800},
	{87199, 0x1000},
	{87221, 0x2000},
	/* 1482 */
	{87243, 0x7},
	{87260, 0x10},
	{87282, 0x1E000},
	{87298, 0x700000},
	{87319, 0x3000000},
	{87399, 0xC000000, 4, 36489},
	/* 1488 */
	{87425, 0x1},
	{87486, 0x6, 4, 36493},
	{87702, 0x38, 8, 36497},
	/* 1491 */
	{87713, 0xF},
	{87718, 0xF0},
	{87723, 0xF00},
	{87728, 0xF000},
	{87733, 0xF0000},
	{87738, 0xF00000},
	{87743, 0xF000000},
	{87748, 0xF0000000},
	/* 1499 */
	{87753, 0xF},
	{87758, 0xF0},
	{87763, 0xF00},
	{87768, 0xF000},
	{87773, 0xF0000},
	{87778, 0xF00000},
	{87783, 0xF000000},
	{87788, 0xF0000000},
	/* 1507 */
	{87793, 0xF},
	{87798, 0xF0},
	{87803, 0xF00},
	{87808, 0xF000},
	{87813, 0xF0000},
	{87819, 0xF00000},
	{87825, 0xF000000},
	{87831, 0xF0000000},
	/* 1515 */
	{87837, 0xF},
	{87843, 0xF0},
	{87849, 0xF00},
	{87855, 0xF000},
	{87861, 0xF0000},
	{87867, 0xF00000},
	{87873, 0xF000000},
	{87879, 0xF0000000},
	/* 1523 */
	{87885, 0xFFFF},
	{87898, 0xFFFF0000},
	/* 1525 */
	{87911, 0xFFFF},
	{87924, 0xFFFF0000},
	/* 1527 */
	{87937, 0x3},
	{67718, 0x4},
	{67740, 0x8},
	{87966, 0x60},
	/* 1531 */
	{88079, 0x3, 4, 36505},
	{88092, 0x4},
	{88103, 0x8},
	{88212, 0x70, 5, 36509},
	{88230, 0x380, 5, 36509},
	{88248, 0x1C00},
	{88271, 0x3E000},
	{88297, 0x40000},
	{88319, 0x7F80000},
	{88335, 0x8000000},
	{88357, 0x10000000},
	{88444, 0x60000000, 3, 36514},
	/* 1543 */
	{88461, 0xFFFF},
	{88477, 0xFFFF0000},
	/* 1545 */
	{88496, 0x1},
	{88513, 0x1E},
	{88537, 0x20},
	{88555, 0x3C0},
	{88580, 0x400},
	{88610, 0x800},
	{88625, 0x1000},
	{88640, 0x2000},
	{88675, 0x4000},
	{88711, 0x8000},
	{88801, 0x30000, 3, 36517},
	{88825, 0x40000},
	{88861, 0x80000},
	{88897, 0x100000},
	{88923, 0x200000},
	{88947, 0x400000},
	{88967, 0x800000},
	{88988, 0x1000000},
	{89013, 0x6000000},
	{89037, 0x18000000},
	/* 1565 */
	{89065, 0x7FF},
	{89086, 0xFF0000},
	/* 1567 */
	{89104, 0xFF},
	/* 1568 */
	{89120, 0x7F},
	/* 1569 */
	{89133, 0x7FF},
	{89142, 0x7FF00000},
	/* 1571 */
	{89133, 0x3FFFFF},
	/* 1572 */
	{69289, 0x1FFF},
	{69316, 0x3FFE000},
	{89157, 0x3C000000},
	/* 1575 */
	{89218, 0x3, 4, 36520},
	{17302, 0x7C, 32, 36524},
	{65499, 0x80},
	{89816, 0x700, 8, 36556},
	{89872, 0x1800, 4, 36564},
	{78915, 0x2000},
	{69909, 0x4000},
	{89882, 0x8000},
	{89894, 0x10000},
	{89907, 0x20000},
	{87486, 0x40000},
	{89920, 0x80000},
	{90147, 0x700000, 8, 36568},
	{90169, 0x3800000, 8, 36568},
	{90193, 0x4000000},
	{90219, 0x8000000},
	{90245, 0x10000000},
	{90313, 0x60000000, 3, 36576},
	{90329, 0x80000000},
	/* 1594 */
	{90343, 0x1F},
	{90359, 0x3E0},
	{90381, 0xC00},
	{70621, 0x7000},
	{90399, 0x18000},
	{90413, 0x20000},
	{90431, 0x40000},
	{90457, 0x80000},
	/* 1602 */
	{73949, 0x1},
	{90487, 0x2},
	{67345, 0xC, 3, 36579},
	{90601, 0x10, 2, 36582},
	{67373, 0x60},
	{67470, 0x180},
	{90627, 0x200},
	{90650, 0x3C00},
	{90670, 0x3C000},
	{74065, 0x40000},
	{90692, 0x80000},
	{90725, 0x100000},
	/* 1614 */
	{89133, 0x3FFF},
	/* 1615 */
	{90749, 0xFF},
	/* 1616 */
	{90759, 0x3FFF},
	{90771, 0xFFFC000},
	{67245, 0xF0000000},
	/* 1619 */
	{90782, 0x1FFF},
	{90793, 0x2000},
	{90805, 0x7C000},
	{90819, 0xF80000},
	{90833, 0x3000000},
	{90847, 0x4000000},
	{64730, 0x38000000},
	{90866, 0x40000000},
	/* 1627 */
	{9965, 0xFFFFFFFC},
	/* 1628 */
	{9994, 0xFFFF},
	/* 1629 */
	{24328, 0xFFFFFFFC},
	/* 1630 */
	{24350, 0xFFFF},
	/* 1631 */
	{24844, 0xFFFFFFFC},
	/* 1632 */
	{24866, 0xFFFF},
	/* 1633 */
	{90883, 0xFFFFFFC},
	/* 1634 */
	{90899, 0x6000000},
	/* 1635 */
	{90912, 0x1},
	/* 1636 */
	{90931, 0xFF},
	{90945, 0x30000},
	/* 1638 */
	{90959, 0xFFFFFFFC},
	/* 1639 */
	{90971, 0xFFFF},
	{90983, 0x10000},
	{90899, 0x6000000},
	{26653, 0xE0000000},
	/* 1643 */
	{26203, 0xFFFFFFFC},
	/* 1644 */
	{26221, 0xFFFF},
	{90899, 0xC00000},
	/* 1646 */
	{26275, 0xFFFFFFFC},
	/* 1647 */
	{26293, 0xFFFF},
	{90899, 0xC00000},
	/* 1649 */
	{90993, 0x3},
	{26333, 0xFFFFFFF8},
	/* 1651 */
	{26352, 0xFFFF},
	{91007, 0x10000},
	{91023, 0x100000},
	{91039, 0x3000000},
	{91055, 0xE0000000},
	/* 1656 */
	{91066, 0x400},
	{91079, 0x6000},
	{91096, 0x8000},
	{91108, 0x300000},
	{91119, 0x6000000},
	{91136, 0x8000000},
	{91148, 0x60000000},
	/* 1663 */
	{91159, 0xFF},
	/* 1664 */
	{91178, 0x3F},
	/* 1665 */
	{91196, 0x8},
	{91213, 0x10},
	{91230, 0x20},
	{91257, 0x8000},
	{91277, 0x40000},
	{91294, 0x400000},
	{91310, 0x800000},
	{91324, 0x2000000},
	{91338, 0x4000000},
	{91352, 0x8000000},
	{91373, 0x10000000},
	{91398, 0x20000000},
	{91419, 0x40000000},
	/* 1678 */
	{91443, 0x3000000},
	{995, 0x80000000},
	/* 1680 */
	{26590, 0xFFFF},
	/* 1681 */
	{26631, 0xFFFF},
	/* 1682 */
	{91448, 0x3FFFFFF},
	{91459, 0x4000000},
	{91463, 0x8000000},
	{91467, 0x10000000},
	{91472, 0x20000000},
	{91477, 0x40000000},
	{91486, 0x80000000},
	/* 1689 */
	{91493, 0x1},
	{91513, 0x2},
	{91527, 0x30},
	{91539, 0x1FF0000},
	{91552, 0x10000000},
	{91567, 0x20000000},
	{91581, 0xC0000000},
	/* 1696 */
	{91591, 0x3FFFFFF},
	{91604, 0x10000000},
	/* 1698 */
	{91623, 0xFF},
	/* 1699 */
	{91642, 0xFF},
	/* 1700 */
	{91648, 0x1},
	{91662, 0x2},
	{91674, 0x10000},
	{91688, 0x1000000},
	/* 1704 */
	{1872, 0xFF},
	{59300, 0x80000000},
	/* 1706 */
	{26886, 0xFFFFF},
	/* 1707 */
	{26899, 0xFFFFF},
	/* 1708 */
	{26913, 0xFFFFF},
	/* 1709 */
	{26927, 0xFFFFF},
	/* 1710 */
	{26949, 0xFFFFF},
	/* 1711 */
	{26969, 0xFFFFF},
	/* 1712 */
	{26991, 0xFFFFF},
	/* 1713 */
	{91701, 0x3},
	{9965, 0xFFFFFFFC},
	/* 1715 */
	{9994, 0xFFFF},
	{91701, 0xFFFF0000},
	/* 1717 */
	{91706, 0xFFF},
	/* 1718 */
	{91721, 0xFFFFF},
	/* 1719 */
	{91735, 0xFFFFF},
	/* 1720 */
	{91749, 0xFFFFF},
	/* 1721 */
	{27307, 0xFFFFFFE0},
	/* 1722 */
	{27326, 0xFFFF},
	/* 1723 */
	{27345, 0xFFF},
	/* 1724 */
	{27362, 0xFFFFFFFC},
	/* 1725 */
	{27380, 0xFFFF},
	/* 1726 */
	{27398, 0xFFFFF},
	/* 1727 */
	{27414, 0xFFFFFFFC},
	/* 1728 */
	{27432, 0xFFFF},
	/* 1729 */
	{27450, 0xFFFFF},
	/* 1730 */
	{27549, 0xFFFFFFFC},
	/* 1731 */
	{27563, 0xFFFF},
	/* 1732 */
	{27577, 0xFFFFF},
	/* 1733 */
	{42936, 0xFFF000},
	{90899, 0x6000000},
	{91762, 0x8000000},
	{91775, 0x10000000},
	/* 1737 */
	{91783, 0x30000},
	{91791, 0x7000000},
	{91799, 0xE0000000},
	/* 1740 */
	{27643, 0xFFFFFFF},
	/* 1741 */
	{27654, 0xFFFFFFFC},
	/* 1742 */
	{27668, 0xFFFF},
	/* 1743 */
	{27682, 0xFFFFF},
	/* 1744 */
	{91808, 0xFFFFF},
	/* 1745 */
	{995, 0x3},
	/* 1746 */
	{27832, 0x1},
	/* 1747 */
	{91821, 0x1},
	{91835, 0x2},
	{91852, 0x4},
	{91868, 0x8},
	{91883, 0x10},
	{91902, 0x20},
	{91920, 0x40},
	{91941, 0x80},
	/* 1755 */
	{91962, 0x1},
	{91978, 0x2},
	{91994, 0x40},
	{92012, 0x80},
	{92030, 0x100},
	{92048, 0x200},
	{92066, 0x400},
	{92084, 0x800},
	{92102, 0x1000},
	{92120, 0x2000},
	{92138, 0x4000},
	{92155, 0x80000},
	{92171, 0x200000},
	/* 1768 */
	{92187, 0xFF},
	{995, 0x80000000},
	/* 1770 */
	{92205, 0xF},
	{92217, 0xF0},
	{92226, 0xF00},
	{92235, 0xF000},
	{92245, 0x30000},
	{92255, 0xC0000},
	{9882, 0x100000},
	{10365, 0xFFE00000},
	/* 1778 */
	{92262, 0xFF},
	{92226, 0xFF00},
	{92217, 0xFF0000},
	{92277, 0x20000000},
	{92297, 0x40000000},
	{92323, 0x80000000},
	/* 1784 */
	{18464, 0x3F, 22, 36338},
	/* 1785 */
	{38, 0xFFFF},
	/* 1786 */
	{92343, 0x1FF},
	{92409, 0x600, 4, 36584},
	/* 1788 */
	{85292, 0xFFFF},
	{85307, 0x10000},
	{85326, 0x20000},
	{85340, 0x40000},
	{85359, 0x80000},
	{85373, 0x100000},
	{92429, 0x200000},
	{92447, 0x400000},
	{92463, 0x800000},
	/* 1797 */
	{92475, 0x1FF},
	{92489, 0x3FE00},
	{92503, 0x40000},
	{92521, 0x80000},
	/* 1801 */
	{92538, 0x7},
	{92547, 0x78},
	{92556, 0x100},
	/* 1804 */
	{92566, 0x1},
	{92577, 0x7FE},
	/* 1806 */
	{92590, 0x1},
	{92604, 0x2},
	{92618, 0x4},
	/* 1809 */
	{29019, 0xFFFFFF},
	/* 1810 */
	{92632, 0xF},
	{92644, 0xFF00},
	/* 1812 */
	{445, 0xFFFF},
	{91, 0xFFFF0000},
	/* 1814 */
	{92658, 0x1},
	{92679, 0x2},
	/* 1816 */
	{92707, 0x3FFF},
	/* 1817 */
	{92715, 0x3FFF},
	/* 1818 */
	{1859, 0xFFFF},
	/* 1819 */
	{92723, 0x1},
	{92735, 0x2},
	{92747, 0x4},
	{29794, 0x8},
	{68533, 0x10},
	{30219, 0x10000},
	{92758, 0x60000},
	/* 1826 */
	{92771, 0x1},
	{69840, 0x2},
	/* 1828 */
	{24922, 0x7FFFFFFF},
	/* 1829 */
	{92775, 0x3F},
	{92780, 0xC0},
	{92788, 0x300},
	{92794, 0xFFFFFC00},
	/* 1833 */
	{30219, 0x1},
	{92255, 0xFFFFFFFE},
	/* 1835 */
	{8, 0xFFFF},
	{92255, 0xFFFF0000},
	/* 1837 */
	{38, 0xFFFF},
	{92255, 0xFFFF0000},
	/* 1839 */
	{30297, 0xFF},
	{92255, 0xFFFFFF00},
	/* 1841 */
	{30314, 0xFF},
	{92255, 0xFFFFFF00},
	/* 1843 */
	{1, 0xFF},
	{92255, 0xFFFFFF00},
	/* 1845 */
	{441, 0x3F},
	{92255, 0xFFFFFFC0},
	/* 1847 */
	{80899, 0x1},
	{858, 0x1FFE},
	{209, 0x2000},
	{88780, 0x4000},
	{92802, 0x8000},
	{92814, 0x7FF0000},
	{92825, 0x8000000},
	{92836, 0x10000000},
	{92846, 0x20000000},
	{92780, 0xC0000000},
	/* 1857 */
	{30518, 0xFFFF},
	{92255, 0xFFFF0000},
	/* 1859 */
	{441, 0xF},
	{92255, 0xFFFFFFF0},
	/* 1861 */
	{92853, 0xFFFF},
	{92864, 0xF0000},
	{92877, 0xF00000},
	{92255, 0x3F000000},
	{92885, 0x40000000},
	{9882, 0x80000000},
	/* 1867 */
	{29032, 0x7FFFFFFF},
	{30580, 0x80000000},
	/* 1869 */
	{31126, 0xFFFF},
	/* 1870 */
	{31130, 0xFFFF},
	{92894, 0xFFFF0000},
	/* 1872 */
	{92908, 0x3FF},
	{92917, 0xFFC00},
	{92927, 0xF00000},
	{92936, 0xF000000},
	{92947, 0xF0000000},
	/* 1877 */
	{92958, 0x3FF},
	{92968, 0xFFC00},
	{92978, 0xF000000},
	{92989, 0xF0000000},
	/* 1881 */
	{93209, 0xF, 6, 36588},
	{93444, 0xF0, 6, 36594},
	{93617, 0x300, 4, 36600},
	{93637, 0x400},
	/* 1885 */
	{441, 0x7},
	{70319, 0x40000000},
	{9882, 0x80000000},
	/* 1888 */
	{441, 0x1F},
	{70319, 0x40000000},
	{9882, 0x80000000},
	/* 1891 */
	{441, 0xF},
	{11232, 0x40000000},
	{9882, 0x80000000},
	/* 1894 */
	{441, 0x1F},
	{11232, 0x40000000},
	{9882, 0x80000000},
	/* 1897 */
	{11197, 0xFFFF},
	{11217, 0xFFFF0000},
	/* 1899 */
	{93659, 0x1},
	{93686, 0x2},
	{93713, 0x4},
	{982, 0x100},
	/* 1903 */
	{92908, 0x3F},
	{93736, 0x400},
	{93763, 0x800},
	{93790, 0x2000},
	{93816, 0x4000},
	{93842, 0x10000},
	{93869, 0x20000},
	{93895, 0x40000},
	{93921, 0x80000},
	{93949, 0x100000},
	{93975, 0x200000},
	{94001, 0x400000},
	{94027, 0x1000000},
	{94054, 0x2000000},
	{94081, 0x4000000},
	{94108, 0x8000000},
	{94135, 0x10000000},
	{94161, 0x20000000},
	{94190, 0x40000000},
	{94216, 0x80000000},
	/* 1923 */
	{92908, 0x3F},
	{93736, 0x400},
	{93763, 0x800},
	{93790, 0x1000},
	{93816, 0x2000},
	{93842, 0x8000},
	{93869, 0x10000},
	{93949, 0x20000},
	{93975, 0x40000},
	{93895, 0x100000},
	{94054, 0x200000},
	{94216, 0x400000},
	{94243, 0x800000},
	{94108, 0x1000000},
	{94272, 0x2000000},
	/* 1938 */
	{94243, 0x2},
	{94301, 0x4},
	{94330, 0x8},
	{94358, 0x10},
	{94384, 0x20},
	{94410, 0x40},
	{94437, 0x80},
	{94272, 0x100},
	/* 1946 */
	{94464, 0x3FF},
	{92917, 0xFFC00},
	{94474, 0xF00000},
	{94484, 0xF000000},
	{94495, 0xF0000000},
	/* 1951 */
	{92958, 0x3FF},
	{92968, 0xFFC00},
	{94506, 0xF000000},
	{94517, 0xF0000000},
	/* 1955 */
	{94464, 0x3FF},
	{94528, 0xF0000000},
	/* 1957 */
	{92908, 0x3FF},
	{92917, 0xFFC00},
	{94474, 0xF00000},
	{94495, 0xF000000},
	{94528, 0xF0000000},
	/* 1962 */
	{92958, 0x3FF},
	{92968, 0xFFC00},
	{94517, 0xF000000},
	{94506, 0xF0000000},
	/* 1966 */
	{94538, 0xF},
	{94547, 0xF0},
	{94556, 0xF00},
	{94565, 0xF000},
	{94574, 0xF0000},
	{94583, 0xF00000},
	{94592, 0xF000000},
	{94601, 0xF0000000},
	/* 1974 */
	{92908, 0x1FF},
	{94610, 0xF000},
	{92927, 0xF00000},
	{94528, 0xF0000000},
	/* 1978 */
	{55920, 0x1},
	{85919, 0x2, 4, 36464},
	{85854, 0x4, 2, 36462},
	{19758, 0x8, 4, 36458},
	{85772, 0x10, 2, 36456},
	{85741, 0x20, 4, 36452},
	{94624, 0x40},
	{94630, 0x300},
	{94640, 0x2000},
	/* 1987 */
	{94654, 0x1},
	/* 1988 */
	{94663, 0x3},
	{94677, 0xC},
	{94691, 0x30},
	{94705, 0xC0},
	{94719, 0xF00},
	{94734, 0xF000},
	{94749, 0xF0000},
	{94764, 0xF00000},
	/* 1996 */
	{36871, 0x3FF},
	{94779, 0xFFC00},
	{94474, 0xF00000},
	/* 1999 */
	{94799, 0x3FF},
	{94819, 0xFFC00},
	/* 2001 */
	{92908, 0xFF},
	{92917, 0x3FC00},
	{94474, 0xF00000},
	{94495, 0xF000000},
	{94528, 0xF0000000},
	/* 2006 */
	{92958, 0xFF},
	{92968, 0x3FC00},
	{94517, 0xF000000},
	{94506, 0xF0000000},
	/* 2010 */
	{92908, 0xFF},
	{94474, 0xF00000},
	{94528, 0xF0000000},
	/* 2013 */
	{92908, 0x3FF},
	{94474, 0xF00000},
	{94528, 0xF0000000},
	/* 2016 */
	{94839, 0x1},
	{95074, 0xE, 6, 36604},
	{95088, 0x10},
	{95109, 0x3E0},
	{95127, 0x400},
	{95212, 0x800, 2, 36610},
	{95229, 0x1000},
	{95247, 0xE000},
	{95262, 0x20000},
	{95288, 0x1C0000},
	{95311, 0x200000},
	{95339, 0xC00000},
	/* 2028 */
	{92908, 0x1FF},
	{92917, 0x7FC00},
	{94474, 0xF00000},
	{94495, 0xF000000},
	{94528, 0xF0000000},
	/* 2033 */
	{92958, 0x1FF},
	{92968, 0x7FC00},
	{94517, 0xF000000},
	{94506, 0xF0000000},
	/* 2037 */
	{92908, 0x1FF},
	{94528, 0xF0000000},
	/* 2039 */
	{65909, 0xFFF},
	{95364, 0x3000},
	{10365, 0xC000},
	{95382, 0xFFFF0000},
	/* 2043 */
	{40173, 0xFFFF},
	{10365, 0xFFFF0000},
	/* 2045 */
	{40220, 0xFF},
	{65909, 0x700},
	{95406, 0xF800},
	{95422, 0x1F0000},
	{95435, 0x3E00000},
	{95448, 0x7C000000},
	{10365, 0x80000000},
	/* 2052 */
	{95461, 0xFF},
	{10365, 0xFFFFFF00},
	/* 2054 */
	{95483, 0x1FF},
	{10365, 0xFFFFFE00},
	/* 2056 */
	{95483, 0xFF},
	{10365, 0xFFFFFF00},
	/* 2058 */
	{40394, 0x7F},
	{10365, 0xFFFFFF80},
	/* 2060 */
	{40419, 0x7F},
	{10365, 0xFFFFFF80},
	/* 2062 */
	{40447, 0x7F},
	{10365, 0xFFFFFF80},
	/* 2064 */
	{40475, 0x7F},
	{10365, 0xFFFFFF80},
	/* 2066 */
	{40498, 0x7F},
	{10365, 0xFFFFFF80},
	/* 2068 */
	{95500, 0x7F},
	{10365, 0xFFFFFF80},
	/* 2070 */
	{10365, 0x1F},
	{95505, 0xFFFFFFE0},
	/* 2072 */
	{95524, 0x7F},
	{10365, 0xFFFFFF80},
	/* 2074 */
	{95524, 0x1FF},
	{10365, 0xFFFFFE00},
	/* 2076 */
	{95500, 0xFF},
	{10365, 0xFFFFFF00},
	/* 2078 */
	{95529, 0xFF},
	{95550, 0x100},
	{95560, 0x200},
	{95568, 0x400},
	{95582, 0x800},
	{95593, 0x1000},
	{95612, 0x2000},
	{95636, 0x4000},
	{95650, 0x8000},
	{10365, 0xFFFF0000},
	/* 2088 */
	{95660, 0x1},
	{95684, 0x2},
	{95708, 0x4},
	{95725, 0x8},
	{95742, 0x10},
	{95761, 0x20},
	{95778, 0x3C0},
	{10365, 0xFFFFFC00},
	/* 2096 */
	{95793, 0x1},
	{95805, 0x2},
	{95817, 0x4},
	{95827, 0x8},
	{95848, 0x10},
	{95865, 0x20},
	{95882, 0x40},
	{10365, 0xFFFFFF80},
	/* 2104 */
	{95906, 0xFFFF},
	{10365, 0xFFFF0000},
	/* 2106 */
	{95916, 0xFF},
	{10365, 0xFFFFFF00},
	/* 2108 */
	{95933, 0x7FFFF},
	{10365, 0xFFF80000},
	/* 2110 */
	{95422, 0xFF},
	{95435, 0xFF00},
	{95448, 0xFF0000},
	{95948, 0xFF000000},
	/* 2114 */
	{40220, 0xFF},
	{95406, 0xFF00},
	{10365, 0xFFFF0000},
	/* 2117 */
	{95961, 0x1},
	/* 2118 */
	{95985, 0x1},
	/* 2119 */
	{93209, 0x7, 6, 36588},
	{93637, 0x400},
	/* 2121 */
	{36871, 0xFF},
	/* 2122 */
	{9882, 0x1},
	{96003, 0x2},
	{18945, 0x4},
	{10365, 0xFFFFFFF8},
	/* 2126 */
	{96015, 0xF},
	{96020, 0x30},
	{10365, 0xFFFFFFC0},
	/* 2129 */
	{96027, 0x1},
	/* 2130 */
	{96047, 0x3},
	{96071, 0xC},
	{96095, 0x30},
	{96110, 0xC0},
	{96134, 0x300},
	{96158, 0x3C00},
	{96175, 0x7C000},
	{96193, 0x1F80000},
	{96229, 0x2000000},
	{96245, 0x4000000},
	/* 2140 */
	{92908, 0xFF},
	{96263, 0xFF00},
	{94528, 0xF000000},
	{9882, 0x10000000},
	{11232, 0x20000000},
	/* 2145 */
	{96276, 0xF},
	{96296, 0xFF00},
	{96310, 0xFF0000},
	{96323, 0x1000000},
	{96334, 0x2000000},
	{96344, 0x4000000},
	/* 2151 */
	{92908, 0x1FF},
	{94528, 0xF000000},
	{96365, 0xF0000000},
	/* 2154 */
	{92908, 0x3FF},
	{96375, 0xF0000000},
	/* 2156 */
	{91783, 0xF00, 6, 36612},
	{96427, 0x10000},
	{96439, 0x100000},
	{96454, 0xC0000000, 4, 36618},
	/* 2160 */
	{96465, 0xFFFFF},
	{96473, 0x100000},
	{55142, 0x800000},
	/* 2163 */
	{42924, 0xFFFFFFFF},
	/* 2164 */
	{26590, 0xFFFF},
	{91783, 0x300000, 4, 36622},
	{96494, 0x8000000, 2, 36618},
	{96516, 0x60000000, 4, 36626},
	{96524, 0x80000000},
	/* 2169 */
	{42808, 0xFFFFFFFF},
	/* 2170 */
	{91448, 0x3FFFFFF},
	{91459, 0x4000000, 2, 36630},
	{91463, 0x8000000, 2, 36630},
	{91467, 0x10000000, 2, 36632},
	{91472, 0x20000000, 2, 36632},
	{91477, 0x40000000},
	{96562, 0x80000000},
	/* 2177 */
	{85176, 0x3F},
	{96581, 0xF00},
	{96593, 0x1000},
	{96600, 0x2000},
	{96608, 0x4000},
	{96616, 0x8000},
	{96624, 0x10000},
	{96647, 0x60000, 4, 36634},
	{96672, 0x80000},
	{96684, 0x100000},
	{96692, 0x200000},
	{96736, 0xC00000, 3, 36638},
	/* 2189 */
	{96494, 0x1, 2, 36618},
	{91079, 0x6000},
	{91783, 0x300000, 4, 36622},
	{91119, 0x6000000},
	{96516, 0x60000000, 4, 36626},
	{96524, 0x80000000},
	/* 2195 */
	{96781, 0x3, 4, 36641},
	{96797, 0xC, 4, 36645},
	{96593, 0x10},
	{96600, 0x20},
	{96822, 0x40},
	{96829, 0x80},
	{96608, 0x100},
	{96616, 0x200},
	{96624, 0x400},
	{96647, 0x1800, 4, 36634},
	{96672, 0x2000},
	{96684, 0x4000},
	{96692, 0x8000},
	{96736, 0x30000, 3, 36638},
	{96837, 0x40000},
	/* 2210 */
	{96849, 0xFFFFF},
	/* 2211 */
	{55457, 0x1FF, 257, 0},
	{55462, 0x400},
	{55470, 0x800},
	{55483, 0x7000},
	{55491, 0x8000},
	{55502, 0xF0000},
	{55513, 0xF00000},
	{55529, 0x1000000},
	{96859, 0x10000000},
	{55555, 0xE0000000},
	/* 2221 */
	{55714, 0xF},
	{55721, 0x70},
	{55729, 0x80},
	{55743, 0xF00},
	{55752, 0x7000},
	{55779, 0xC00000},
	{55789, 0x1000000},
	{55815, 0xFC000000},
	/* 2229 */
	{42998, 0xFFFFF},
	/* 2230 */
	{56022, 0xF},
	{56045, 0x10},
	{56068, 0x20},
	{56091, 0x40},
	{56111, 0x80},
	{56131, 0x100},
	{56151, 0x200},
	{56171, 0x400},
	{56191, 0x800},
	{56211, 0x1000},
	{56231, 0x2000},
	{56251, 0x4000},
	{56266, 0x8000},
	{56277, 0x10000},
	{56285, 0x20000},
	{56294, 0x40000},
	{96869, 0x80000},
	{56326, 0x100000},
	{56339, 0x200000},
	{56349, 0x400000},
	{56366, 0x800000},
	{96889, 0x1000000},
	{96906, 0x2000000},
	{56383, 0x4000000},
	{56392, 0x8000000},
	{56401, 0x10000000},
	{56410, 0x20000000},
	{56419, 0x40000000},
	{56428, 0x80000000},
	/* 2259 */
	{56439, 0xF},
	{56478, 0x80},
	{56501, 0x100},
	{56524, 0x200},
	{56543, 0x1000},
	{56552, 0x2000},
	{56561, 0x4000},
	{56569, 0x8000},
	{56578, 0x10000},
	{56593, 0x100000},
	{56601, 0x200000},
	{56609, 0x400000},
	{56618, 0x800000},
	{56627, 0x1000000},
	{56635, 0x2000000},
	{56643, 0x4000000},
	{56651, 0x10000000},
	{56393, 0x20000000},
	{56669, 0x40000000},
	{56677, 0x80000000},
	/* 2279 */
	{43012, 0xFFFF},
	/* 2280 */
	{59833, 0x7FF, 2049, 257},
	{96923, 0x1000},
	{59995, 0xFF0000, 129, 2306},
	{60007, 0x3000000},
	{96948, 0x1C000000},
	{60020, 0x80000000},
	/* 2286 */
	{982, 0x3},
	{60035, 0x4},
	{60044, 0x8},
	{60055, 0x10},
	{60068, 0x20},
	{49765, 0x1C0},
	{60082, 0x200},
	{60095, 0x400},
	{60108, 0x800},
	{60120, 0x1000},
	{60138, 0x2000},
	{60149, 0xC000},
	{60164, 0x30000},
	{60172, 0x40000},
	{60191, 0x80000},
	{96960, 0x700000},
	{96975, 0x10000000},
	{96998, 0x20000000},
	{60208, 0x40000000},
	{60220, 0x80000000},
	/* 2306 */
	{60234, 0xFFF},
	{60249, 0xFFF000},
	{60261, 0x1000000},
	{56272, 0x2000000},
	{60269, 0x4000000},
	{60289, 0x8000000},
	{97014, 0xF0000000},
	/* 2313 */
	{97025, 0x1},
	{97035, 0x2},
	{97045, 0x10},
	/* 2316 */
	{60435, 0x7},
	{60445, 0x38},
	{60455, 0x1C0},
	{60465, 0xE00},
	{17302, 0x7F000, 293, 2468},
	{64702, 0x600000},
	{64715, 0x800000},
	{64730, 0x1000000},
	{97073, 0xC000000},
	{64836, 0x30000000, 4, 2761},
	{209, 0xC0000000},
	/* 2327 */
	{65238, 0x1FFFFF},
	{65257, 0xE00000},
	{65276, 0x1000000},
	{65298, 0x2000000},
	{97085, 0x4000000},
	{65336, 0x8000000},
	{65353, 0x10000000},
	{65371, 0x20000000},
	{65387, 0xC0000000},
	/* 2336 */
	{65408, 0x7},
	{65418, 0x38},
	{65439, 0xC0},
	{97108, 0x700},
	{65460, 0x180000},
	{65479, 0xC000000},
	/* 2342 */
	{18448, 0x1FFF},
	{21164, 0x3FFF},
	{67222, 0x1FFF0000},
	/* 2345 */
	{67233, 0xF},
	{67245, 0xF0},
	{67253, 0xFFF00},
	{67266, 0x700000},
	{67275, 0x800000},
	{67290, 0x2000000},
	{67305, 0x4000000},
	{71084, 0x80000000},
	/* 2353 */
	{67317, 0xFF},
	{97073, 0x300},
	{67333, 0x400},
	{67345, 0x18000},
	{67373, 0x60000},
	{67399, 0x80000},
	{67417, 0x100000},
	{67439, 0x200000},
	{67454, 0x400000},
	{67470, 0x800000},
	{67486, 0xFF000000},
	/* 2364 */
	{67552, 0x3F},
	{67558, 0x3C0},
	{65248, 0xC00},
	{67607, 0xFF000, 241, 2834},
	{55319, 0x100000},
	{55112, 0x200000},
	{67618, 0x800000},
	{67628, 0x1000000},
	{67645, 0x2000000},
	{55992, 0x4000000},
	{97117, 0x8000000},
	{55263, 0x20000000},
	/* 2376 */
	{68900, 0x1},
	{68919, 0x2},
	{68940, 0x4},
	{68951, 0x8},
	{68964, 0x10},
	{68983, 0x20},
	{69008, 0x40},
	{69031, 0x80},
	{69045, 0xF00},
	{69057, 0x1000},
	{97136, 0x2000},
	/* 2387 */
	{69974, 0x3, 4, 3083},
	{70003, 0x1C},
	{70034, 0x20},
	{70070, 0x40},
	{70105, 0x80},
	{70133, 0x100},
	{70155, 0x200},
	{70173, 0x400},
	{70205, 0x800},
	{70326, 0x7000, 8, 3087},
	{70336, 0x38000},
	{70349, 0x1C0000},
	{70362, 0x200000},
	{70378, 0x400000},
	{70396, 0x800000},
	{70414, 0x2000000},
	{97154, 0x4000000},
	{97174, 0x18000000},
	/* 2405 */
	{97305, 0x7, 5, 36649},
	{97337, 0x30},
	{97357, 0xC0},
	/* 2408 */
	{70932, 0x3, 4, 3109},
	{70944, 0xC, 4, 3109},
	{70956, 0x30, 4, 3109},
	{70972, 0xC0, 4, 3109},
	{71042, 0x30000, 4, 3113},
	{71054, 0xC0000, 4, 3113},
	{71066, 0x300000, 4, 3113},
	{71082, 0x1000000},
	{71093, 0x2000000},
	{97377, 0x4000000},
	{97387, 0x8000000},
	{97397, 0x10000000},
	{97411, 0x20000000},
	/* 2421 */
	{9882, 0x1},
	{73625, 0x6},
	{65479, 0x60},
	{73667, 0x3000},
	{73674, 0x30000},
	{73688, 0x300000},
	/* 2427 */
	{73795, 0x3, 4, 3109},
	{73811, 0xC, 4, 3109},
	{73827, 0x30, 4, 3109},
	{73841, 0xC0, 4, 3109},
	{73857, 0x30000, 4, 3113},
	{73873, 0xC0000, 4, 3113},
	{73889, 0x300000, 4, 3113},
	{73903, 0xC00000, 4, 3113},
	{97426, 0x1000000},
	{97442, 0x2000000},
	{97458, 0x4000000},
	{97472, 0x8000000},
	{73919, 0x40000000},
	{73934, 0x80000000},
	/* 2441 */
	{754, 0x3F},
	{74704, 0x300},
	{74716, 0x400},
	{97488, 0x800},
	{74727, 0x1E000},
	{74736, 0x20000},
	{74750, 0x40000},
	{74754, 0x80000},
	{74771, 0x100000},
	{74789, 0x600000},
	{74807, 0x800000},
	{74827, 0x1000000},
	{74839, 0x2000000},
	/* 2454 */
	{754, 0x3F},
	{74704, 0x300},
	{74716, 0x400},
	{97488, 0x800},
	{74750, 0x40000},
	{74754, 0x80000},
	{74771, 0x100000},
	{74789, 0x600000},
	{74827, 0x1000000},
	{74839, 0x2000000},
	/* 2464 */
	{74851, 0x3E},
	{74867, 0x40},
	{74880, 0x80},
	{97502, 0x1F00},
	/* 2468 */
	{75401, 0x3F},
	{75422, 0x80},
	{75439, 0x100},
	{97520, 0x3E00},
	{75455, 0x4000},
	{75475, 0x8000},
	/* 2474 */
	{97536, 0x1},
	{97561, 0x2},
	{97586, 0x4},
	{97611, 0x8},
	{97636, 0x10},
	{97661, 0x20},
	{97686, 0x40},
	{97711, 0x80},
	/* 2482 */
	{76421, 0xF, 12, 36654},
	{76426, 0xF0, 12, 36654},
	{76431, 0xF00, 12, 36654},
	{76436, 0xF000, 12, 36654},
	{76441, 0xF0000, 12, 36654},
	{76446, 0xF00000, 12, 36654},
	{76451, 0xF000000, 12, 36654},
	{76456, 0xF0000000, 12, 36654},
	/* 2490 */
	{78235, 0x3, 4, 36055},
	{78281, 0xC, 2, 36059},
	{78292, 0x10},
	{78307, 0x20},
	{78315, 0x40},
	{78357, 0xE0000000},
	/* 2496 */
	{78848, 0x1},
	{97758, 0x2},
	{78866, 0x8},
	{982, 0x70, 8, 36061},
	{78139, 0xFF0000, 256, 36069},
	/* 2501 */
	{80611, 0x1},
	{80627, 0x2},
	{80643, 0x4},
	{80659, 0x8},
	{80675, 0x10},
	{80691, 0x20},
	{80707, 0x40},
	{80723, 0x80},
	{80739, 0x100},
	{80755, 0x200},
	{80771, 0x400},
	{80787, 0x800},
	{80803, 0x1000},
	{80819, 0x2000},
	{80835, 0x4000},
	{80851, 0x8000},
	{80867, 0x10000},
	{80886, 0x20000},
	{80904, 0x40000},
	{80931, 0x80000},
	{80953, 0x100000},
	{80971, 0x200000},
	{80991, 0x400000},
	{81014, 0x800000},
	{81037, 0x1000000},
	{81062, 0x2000000},
	{81105, 0x8000000},
	{97781, 0x10000000},
	{97798, 0x20000000},
	{97823, 0x40000000},
	/* 2531 */
	{81807, 0x1},
	{81824, 0x2},
	{97849, 0x3FC},
	/* 2534 */
	{97868, 0x7, 5, 36649},
	{97894, 0x38, 5, 36649},
	{97923, 0x1C0, 5, 36649},
	{97948, 0xE00, 5, 36649},
	{97974, 0x2000},
	{97997, 0x4000},
	/* 2540 */
	{82957, 0x1},
	{82969, 0x2},
	{82990, 0x4},
	{83010, 0x8},
	{83056, 0x20},
	{83079, 0x40},
	/* 2546 */
	{203, 0x3, 3, 36374},
	{83800, 0xC, 4, 36377},
	{83880, 0x30, 4, 36381},
	{83940, 0xC0, 3, 36385},
	{83953, 0x100},
	{78307, 0x200},
	{83957, 0x400},
	{83966, 0x3800},
	{98024, 0x4000},
	/* 2555 */
	{85231, 0x2},
	{85265, 0x8},
	{85281, 0x10},
	{98049, 0x40},
	/* 2559 */
	{70724, 0x1},
	{85390, 0x2},
	{85401, 0x4},
	{85418, 0x8},
	{85435, 0x3F0},
	{85452, 0xFC00},
	{85469, 0x10000},
	{85493, 0x20000},
	{67404, 0x40000},
	{98127, 0x180000, 3, 36666},
	/* 2569 */
	{85741, 0x3, 4, 36452},
	{85772, 0x4, 2, 36456},
	{19758, 0x18, 4, 36458},
	{85854, 0x20, 2, 36462},
	{85919, 0xC0, 4, 36464},
	{85925, 0x100},
	{68253, 0x200},
	{85936, 0x400},
	{85956, 0x800},
	{85976, 0x1000},
	{85990, 0x2000},
	{86001, 0x4000},
	{86017, 0x78000},
	{86037, 0x180000},
	{86052, 0x200000},
	{86062, 0x400000},
	{86072, 0x800000},
	{86082, 0x1000000},
	{86097, 0x2000000},
	{98146, 0x4000000},
	/* 2589 */
	{87243, 0x7},
	{87260, 0x10},
	{87282, 0x1E000},
	{87298, 0x700000},
	{87319, 0x3000000},
	{87399, 0xC000000, 4, 36489},
	{98170, 0x10000000},
	{98195, 0x20000000},
	/* 2597 */
	{89218, 0x3, 4, 36520},
	{17302, 0x7C, 25, 36669},
	{65499, 0x80},
	{89816, 0x700, 8, 36556},
	{89872, 0x1800, 4, 36564},
	{78915, 0x2000},
	{69909, 0x4000},
	{89882, 0x8000},
	{89894, 0x10000},
	{89907, 0x20000},
	{87486, 0x40000},
	{89920, 0x80000},
	{90147, 0x700000, 8, 36568},
	{90169, 0x3800000, 8, 36568},
	{90193, 0x4000000},
	{90219, 0x8000000},
	{90245, 0x10000000},
	{90313, 0x60000000, 3, 36576},
	{98236, 0x80000000},
	/* 2616 */
	{73949, 0x1},
	{90487, 0x2},
	{67345, 0xC, 3, 36579},
	{90601, 0x10, 2, 36582},
	{67373, 0x60},
	{67470, 0x180},
	{90627, 0x200},
	{90650, 0x3C00},
	{90670, 0x3C000},
	{74065, 0x40000},
	{90692, 0x80000},
	{90725, 0x100000},
	{98247, 0x200000},
	{98267, 0x400000},
	/* 2630 */
	{90782, 0x1FFF},
	{90793, 0x2000},
	{90805, 0x7C000},
	{90819, 0xF80000},
	{90833, 0x3000000},
	{90847, 0x4000000},
	{64730, 0x38000000},
	{90866, 0x40000000},
	{98288, 0x80000000},
	/* 2639 */
	{98309, 0xFFFFFF},
	{10114, 0x7000000},
	{98315, 0x8000000},
	{1, 0x70000000},
	{98326, 0x80000000},
	/* 2644 */
	{98337, 0x1},
	{26333, 0xFFFFFFF8},
	/* 2646 */
	{91648, 0x1},
	{91662, 0x2},
	{98346, 0x8000},
	{91674, 0x10000},
	{91688, 0x1000000},
	/* 2651 */
	{91783, 0x30000},
	{98361, 0x300000},
	{98376, 0xC00000},
	{91791, 0x7000000},
	{91799, 0xE0000000},
	/* 2656 */
	{203, 0x3, 3, 36374},
	{98024, 0x4000},
	/* 2658 */
	{92343, 0x3FF},
	{92409, 0xC00, 4, 36584},
	/* 2660 */
	{97350, 0x3},
	{97370, 0x30},
	/* 2662 */
	{92723, 0x1},
	{92735, 0x2},
	{92747, 0x4},
	{30219, 0x10000},
	{92758, 0x60000},
	/* 2667 */
	{80899, 0x1},
	{858, 0x1FFE},
	{209, 0x2000},
	{88780, 0x4000},
	{92802, 0x8000},
	{92814, 0x7FF0000},
	{92825, 0x8000000},
	{92836, 0x10000000},
	{92846, 0x20000000},
	{98386, 0x40000000},
	{92780, 0x80000000},
	/* 2678 */
	{92908, 0x1FF},
	{92927, 0xF00000},
	{94528, 0xF0000000},
	/* 2681 */
	{55920, 0x1},
	{85919, 0x2, 4, 36464},
	{85854, 0x4, 2, 36462},
	{19758, 0x8, 4, 36458},
	{85772, 0x10, 2, 36456},
	{85741, 0x20, 4, 36452},
	{94624, 0x40},
	{94630, 0x300},
	{94640, 0x2000},
	{98398, 0x4000},
	{98420, 0x8000},
	{98442, 0x10000},
	{98464, 0x20000},
	{98486, 0x40000},
	{98508, 0x80000},
	/* 2696 */
	{95524, 0x7FF},
	{10365, 0xFFFFF800},
	/* 2698 */
	{95529, 0xFF},
	{95550, 0x100},
	{95560, 0x200},
	{95568, 0x400},
	{95582, 0x800},
	{95593, 0x1000},
	{95612, 0x2000},
	{95636, 0x4000},
	{95650, 0x8000},
	{98530, 0x10000},
	{98543, 0x20000},
	{98554, 0x40000},
	{98571, 0x80000},
	{98585, 0x100000},
	{98597, 0x200000},
	{98613, 0x400000},
	{10365, 0xFF800000},
	/* 2715 */
	{95660, 0x1},
	{95684, 0x2},
	{95708, 0x4},
	{98629, 0x8},
	{95778, 0xF0},
	{98649, 0x100},
	{98669, 0x200},
	{98684, 0x400},
	{10365, 0xFFFFF800},
	/* 2724 */
	{95793, 0x1},
	{98709, 0x2},
	{98732, 0x4},
	{95882, 0x8},
	{98746, 0x10},
	{95805, 0x20},
	{98773, 0x40},
	{95817, 0x80},
	{98788, 0x100},
	{95827, 0x200},
	{98801, 0x400},
	{95848, 0x800},
	{98825, 0x1000},
	{95865, 0x2000},
	{98845, 0x4000},
	{98865, 0x8000},
	{98882, 0x10000},
	{98902, 0x20000},
	{98919, 0x40000},
	/* 2743 */
	{754, 0xFFFF},
	{10365, 0xFFFF0000},
	/* 2745 */
	{98939, 0xFF},
	{98953, 0xFF00},
	{98976, 0xFF0000},
	{10365, 0xFF000000},
	/* 2749 */
	{99003, 0xFF},
	{99019, 0xFF00},
	{10365, 0xFFFF0000},
	/* 2752 */
	{99035, 0xFFFF},
	/* 2753 */
	{55093, 0xF},
	{55102, 0xF0},
	{55112, 0x100},
	{55123, 0x200},
	{55128, 0x400},
	{99042, 0x800},
	{55255, 0x7F000, 257, 0},
	{55286, 0x10000000},
	{55292, 0xE0000000},
	/* 2762 */
	{55296, 0x1},
	{55300, 0x6},
	{99051, 0x18},
	{55319, 0x20},
	{55324, 0x40},
	{55332, 0x80},
	{55342, 0x100},
	{55353, 0x200},
	{55359, 0x400},
	{55364, 0x800},
	{55370, 0x1000},
	{55381, 0x2000},
	{55386, 0x4000},
	{99061, 0x8000},
	{55142, 0x10000},
	{55406, 0x20000},
	{55414, 0x40000},
	{55426, 0x80000},
	{99074, 0x100000},
	{99088, 0x200000},
	{99101, 0x400000},
	{99110, 0x800000},
	{99119, 0x7000000},
	{55445, 0x8000000},
	/* 2786 */
	{55457, 0x7F, 257, 0},
	{55502, 0x3F0000},
	{55555, 0xE0000000},
	/* 2789 */
	{50478, 0xF},
	{55563, 0x30},
	{55571, 0xC0},
	{55579, 0xF00},
	{55585, 0x1000},
	{28888, 0x2000},
	{55603, 0xF0000},
	{55609, 0xF00000},
	{55615, 0x7000000},
	{55624, 0x38000000},
	{55633, 0xC0000000},
	/* 2800 */
	{55639, 0x3F},
	{55649, 0x3F00},
	{55659, 0x3F0000},
	{55669, 0xF000000},
	/* 2804 */
	{55679, 0xFF},
	{55688, 0x1FF000},
	/* 2806 */
	{55714, 0xF},
	{55721, 0x70},
	{55743, 0x1F00},
	{55752, 0xE000},
	/* 2810 */
	{1112, 0xFF},
	/* 2811 */
	{99139, 0x7},
	{99147, 0x8},
	{99158, 0x10},
	{99171, 0xE0},
	{99187, 0x300},
	{99197, 0xC00},
	{99207, 0x70000},
	{55877, 0x380000},
	{99219, 0xC00000},
	{99226, 0x1000000},
	{99233, 0x6000000},
	{69567, 0x8000000},
	{99241, 0x10000000},
	/* 2824 */
	{9994, 0xFF},
	/* 2825 */
	{99258, 0x1},
	{99274, 0x2},
	{56366, 0x4},
	{99289, 0x8},
	{99305, 0x10},
	{56339, 0x20},
	{99314, 0x40},
	{99325, 0x80},
	{99335, 0x100},
	{99345, 0x200},
	{99355, 0x400},
	{99366, 0x800},
	{99377, 0x1000},
	{99389, 0x2000},
	{99398, 0x4000},
	{99408, 0x8000},
	{96889, 0x10000},
	{96906, 0x20000},
	{99417, 0x40000},
	{99435, 0x80000},
	{99450, 0x100000},
	/* 2846 */
	{99466, 0x2},
	{99481, 0x4},
	{99499, 0x8},
	{56463, 0x10},
	{99514, 0x20},
	{99530, 0x40},
	{99544, 0x100},
	{99553, 0x200},
	{99562, 0x400},
	{99583, 0x800},
	{99592, 0x1000},
	{99601, 0x2000},
	{99611, 0x4000},
	{99620, 0x10000},
	{99629, 0x20000},
	{99637, 0x80000},
	{99646, 0x100000},
	{99658, 0x200000},
	{99671, 0x400000},
	{99684, 0x20000000},
	/* 2866 */
	{99693, 0x1},
	{99703, 0x2},
	{99713, 0x4},
	{99723, 0x8},
	{99733, 0x10},
	{99743, 0x20},
	{99753, 0x40},
	{99763, 0x80},
	{99773, 0x100},
	{99783, 0x200},
	{99793, 0x400},
	{99803, 0x800},
	{99813, 0x1000},
	{99823, 0x2000},
	{99833, 0x4000},
	{99843, 0x8000},
	/* 2882 */
	{99853, 0xFF},
	/* 2883 */
	{99866, 0x3F},
	{99885, 0xFC0},
	/* 2885 */
	{56022, 0xF},
	{56251, 0x1},
	{56045, 0x10},
	{56068, 0x20},
	{56091, 0x40},
	{56111, 0x80},
	{56131, 0x100},
	{56383, 0x100},
	{56151, 0x200},
	{57321, 0x200},
	{56171, 0x400},
	{56191, 0x800},
	{56211, 0x1000},
	{56231, 0x2000},
	{56401, 0x10000000},
	{56410, 0x20000000},
	{56419, 0x40000000},
	/* 2902 */
	{99896, 0xF},
	{99905, 0xF0},
	/* 2904 */
	{56439, 0xF},
	{99914, 0x20},
	{56478, 0x80},
	{56501, 0x100},
	{56524, 0x200},
	{56543, 0x1000},
	{56552, 0x2000},
	{56561, 0x4000},
	{56569, 0x8000},
	{99930, 0x10000},
	{99945, 0x20000},
	{99954, 0x40000},
	{99969, 0x80000},
	{56593, 0x100000},
	{99977, 0x200000},
	{56609, 0x400000},
	{56618, 0x800000},
	{56627, 0x1000000},
	{56635, 0x2000000},
	{56643, 0x4000000},
	{56651, 0x10000000},
	{56393, 0x20000000},
	{56669, 0x40000000},
	{56677, 0x80000000},
	/* 2928 */
	{56543, 0x2},
	{56552, 0x4},
	{56618, 0x400000},
	{99945, 0x800000},
	{56635, 0x1000000},
	{56561, 0x2000000},
	{56593, 0x4000000},
	{56609, 0x8000000},
	{56627, 0x20000000},
	{56643, 0x40000000},
	{56669, 0x80000000},
	/* 2939 */
	{99985, 0x1},
	{99999, 0x4},
	{100014, 0x10000},
	{100029, 0x20000},
	{100044, 0x40000},
	{100059, 0x80000},
	/* 2945 */
	{100074, 0x3F},
	/* 2946 */
	{92262, 0xFF},
	{100091, 0xFF00},
	{92217, 0xFF0000},
	{100100, 0x20000000},
	{92297, 0x40000000},
	{92323, 0x80000000},
	/* 2952 */
	{100120, 0xF},
	{100137, 0x1F00},
	/* 2954 */
	{47204, 0xFF},
	/* 2955 */
	{100152, 0x2},
	{100163, 0x20},
	{100174, 0x40},
	{100195, 0x80},
	{100215, 0xF00},
	{100237, 0x1000},
	/* 2961 */
	{100263, 0x1},
	{100271, 0x2},
	{100279, 0x2},
	{100288, 0x8},
	{100304, 0x10},
	{100320, 0x40},
	{100341, 0x80},
	{100362, 0x100},
	{100383, 0x200},
	{100391, 0x200},
	{100412, 0x400},
	{100433, 0x800},
	{100454, 0x1000},
	{100475, 0x2000},
	{100496, 0x4000},
	{100517, 0x8000},
	{100538, 0x10000},
	{100559, 0x20000},
	{100580, 0x40000},
	{100601, 0x80000},
	{100622, 0x100000},
	{100643, 0x200000},
	/* 2983 */
	{100664, 0x3FFFC},
	{100677, 0x300000},
	{100689, 0xC00000},
	{47257, 0x80000000},
	/* 2987 */
	{100699, 0x1},
	{100716, 0x80000},
	/* 2989 */
	{92908, 0x3F},
	{93736, 0x400},
	{93763, 0x800},
	{100736, 0x1000},
	{93790, 0x2000},
	{93816, 0x4000},
	{93842, 0x10000},
	{93869, 0x20000},
	{93895, 0x40000},
	{93921, 0x80000},
	{93949, 0x100000},
	{93975, 0x200000},
	{94001, 0x400000},
	{100763, 0x800000},
	{94027, 0x1000000},
	{94054, 0x2000000},
	{94081, 0x4000000},
	{100789, 0x8000000},
	{100815, 0x10000000},
	/* 3008 */
	{92908, 0x3F},
	{93736, 0x400},
	{93763, 0x800},
	{93790, 0x1000},
	{93816, 0x2000},
	{93842, 0x8000},
	{93869, 0x10000},
	{93949, 0x20000},
	{93975, 0x40000},
	{100736, 0x80000},
	{93895, 0x100000},
	{94054, 0x200000},
	/* 3020 */
	{47282, 0x3FFFF},
	/* 3021 */
	{100841, 0x1},
	{100854, 0x2},
	{100858, 0x4},
	{100880, 0x8},
	{100894, 0x10},
	{100908, 0x20},
	{100926, 0x40},
	{100944, 0x80},
	{28888, 0x2000000},
	{98094, 0xC000000},
	/* 3031 */
	{90997, 0x3},
	{9965, 0xFFFFFFFC},
	/* 3033 */
	{100959, 0x3},
	{24328, 0xFFFFFFFC},
	/* 3035 */
	{100980, 0x3},
	{24844, 0xFFFFFFFC},
	/* 3037 */
	{90971, 0xFF},
	{90983, 0x30000},
	{26653, 0xE0000000},
	/* 3040 */
	{101001, 0x3},
	{26203, 0xFFFFFFFC},
	/* 3042 */
	{26221, 0xFF},
	/* 3043 */
	{101018, 0x3},
	{26275, 0xFFFFFFFC},
	/* 3045 */
	{26293, 0xFF},
	/* 3046 */
	{26352, 0xFF},
	{91007, 0x10000},
	{91023, 0x100000},
	{91039, 0x3000000},
	{91055, 0xE0000000},
	/* 3051 */
	{91962, 0x1},
	{91978, 0x2},
	{91994, 0x40},
	{92012, 0x80},
	{92030, 0x100},
	{92048, 0x200},
	{92066, 0x400},
	{92084, 0x800},
	{92102, 0x1000},
	{92120, 0x2000},
	{92138, 0x4000},
	{91257, 0x8000},
	{101035, 0x10000},
	{91277, 0x40000},
	{92155, 0x80000},
	{92171, 0x200000},
	{91294, 0x400000},
	{91310, 0x800000},
	{91324, 0x2000000},
	{91338, 0x4000000},
	{91352, 0x8000000},
	{91373, 0x10000000},
	{91398, 0x20000000},
	/* 3074 */
	{92187, 0xFF},
	{91443, 0x3000000},
	{101053, 0x40000000},
	{995, 0x80000000},
	/* 3078 */
	{26590, 0xFF},
	/* 3079 */
	{26631, 0xFF},
	/* 3080 */
	{91448, 0x1FFFFF},
	{91486, 0x200000},
	{101067, 0xC00000},
	{101076, 0x3000000},
	{91459, 0x4000000},
	{91463, 0x8000000},
	{91467, 0x10000000},
	{91472, 0x20000000},
	{91477, 0x40000000},
	/* 3089 */
	{91527, 0x30},
	{91539, 0xF0000},
	{91552, 0x10000000},
	{91567, 0x20000000},
	{91581, 0xC0000000},
	/* 3094 */
	{91642, 0x1},
	/* 3095 */
	{101085, 0x1},
	{101110, 0x2},
	{101148, 0x4},
	{101189, 0x8},
	{101212, 0x10},
	{101235, 0x20},
	{101259, 0x40},
	{101289, 0x80},
	{101318, 0x100},
	{101349, 0x400},
	{101375, 0x800},
	{101404, 0x1000},
	{101429, 0x2000},
	{59014, 0x4000},
	{59035, 0x8000},
	/* 3110 */
	{101464, 0x1},
	{101491, 0x4},
	{101518, 0x10},
	{101547, 0x400},
	{101576, 0x800},
	{101605, 0x1000},
	{101633, 0x2000},
	{101663, 0x4000},
	{101690, 0x8000},
	{101718, 0x10000},
	{101744, 0x20000},
	{101770, 0x800000},
	{101795, 0x1000000},
	{101821, 0x2000000},
	{101846, 0x4000000},
	{101870, 0x8000000},
	{101895, 0x10000000},
	{101924, 0x10000000},
	/* 3128 */
	{101952, 0x1},
	{101978, 0x2},
	{102004, 0x4},
	{102031, 0x10},
	{102057, 0x20},
	{102079, 0x40},
	{102100, 0x80},
	{102132, 0x100},
	{102159, 0x200},
	{102181, 0x400},
	{102205, 0x800},
	{102230, 0x1000},
	{102253, 0x2000},
	{102280, 0x4000},
	{102305, 0x8000},
	{102333, 0x10000},
	{102358, 0x20000},
	{102383, 0x40000},
	{102408, 0x80000},
	{102437, 0x100000},
	{102468, 0x200000},
	{102496, 0x400000},
	{102523, 0x800000},
	{102553, 0x1000000},
	{102580, 0x2000000},
	{102607, 0x4000000},
	{102634, 0x8000000},
	{102660, 0x10000000},
	{102684, 0x20000000},
	{102716, 0x40000000},
	{102743, 0x80000000},
	/* 3159 */
	{58351, 0x1},
	{102769, 0x40},
	{102788, 0x80},
	{102808, 0x100},
	{102827, 0x200},
	{102841, 0x400},
	{102854, 0x1000},
	{102876, 0x2000},
	{102899, 0x4000},
	{102920, 0x8000},
	{102937, 0x20000},
	{102952, 0x40000},
	{102966, 0x80000},
	{102980, 0x100000},
	{102996, 0x200000},
	{103009, 0x400000},
	/* 3175 */
	{103028, 0x80},
	{103043, 0x100},
	{58035, 0x200},
	{58049, 0x400},
	{58068, 0x800},
	{58087, 0x1000},
	{103058, 0x2000},
	{102832, 0x8000},
	{103066, 0x10000},
	{102846, 0x20000},
	{103075, 0x40000},
	{58163, 0x80000},
	{58178, 0x100000},
	{103086, 0x200000},
	{56340, 0x400000},
	{58211, 0x800000},
	{57028, 0x1000000},
	{103104, 0x2000000},
	{103001, 0x4000000},
	{57018, 0x8000000},
	{58102, 0x10000000},
	{58119, 0x20000000},
	{58141, 0x40000000},
	{56393, 0x80000000},
	/* 3199 */
	{1854, 0x3F},
	{103117, 0x3F00},
	{103132, 0x3F0000},
	/* 3202 */
	{47626, 0x1F},
	/* 3203 */
	{103147, 0xF},
	{103170, 0x3F00},
	/* 3205 */
	{103191, 0xF},
	/* 3206 */
	{103210, 0x10},
	{103231, 0x40},
	{103253, 0x100},
	{103274, 0x1000000},
	{103282, 0x2000000},
	{103290, 0x4000000},
	{103299, 0x8000000},
	{103308, 0x10000000},
	{103316, 0x20000000},
	/* 3215 */
	{103324, 0xFF},
	{103345, 0x700},
	{103366, 0xFF00000},
	{103386, 0x70000000},
	/* 3219 */
	{103406, 0x1},
	/* 3220 */
	{103427, 0xFFFFF},
	/* 3221 */
	{103435, 0xFFFFFFF},
	{103451, 0xF0000000},
	/* 3223 */
	{103467, 0xFFFF},
	{103482, 0xFFFF0000},
	/* 3225 */
	{27326, 0xFF},
	/* 3226 */
	{27380, 0xFF},
	/* 3227 */
	{27432, 0xFF},
	/* 3228 */
	{27563, 0xFF},
	/* 3229 */
	{103498, 0xFF},
	{103508, 0xFF00},
	{103518, 0xFF0000},
	{103531, 0xFF000000},
	/* 3233 */
	{103544, 0xFF},
	{103557, 0xFF00},
	{103570, 0xFF0000},
	{103583, 0xFF000000},
	/* 3237 */
	{103596, 0xFF},
	{103607, 0xFF00},
	{103618, 0xFF0000},
	/* 3240 */
	{103629, 0x3F},
	{103643, 0x3F00},
	/* 3242 */
	{103657, 0xFF},
	{103668, 0xFF00},
	/* 3244 */
	{103679, 0x7FF},
	{103692, 0x7FF0000},
	/* 3246 */
	{103704, 0x1FF},
	/* 3247 */
	{103712, 0x7FF},
	/* 3248 */
	{103724, 0x3FF},
	/* 3249 */
	{47930, 0x7FF},
	{103732, 0x3000},
	{103743, 0x30000},
	/* 3252 */
	{103757, 0x3FF},
	{103774, 0x3FF0000},
	/* 3254 */
	{103791, 0x3FF},
	{103810, 0x3FF0000},
	/* 3256 */
	{103829, 0x3FF},
	{103848, 0x3FF0000},
	/* 3258 */
	{103867, 0x3FF},
	/* 3259 */
	{103876, 0x3FF},
	{103885, 0x3FF0000},
	/* 3261 */
	{103894, 0x7FF},
	{103907, 0x7FF0000},
	/* 3263 */
	{103919, 0x7FF},
	/* 3264 */
	{103931, 0x3FF},
	{103948, 0x3FF0000},
	/* 3266 */
	{103965, 0x3FF},
	{103984, 0x3FF0000},
	/* 3268 */
	{104003, 0x3FF},
	{104022, 0x3FF0000},
	/* 3270 */
	{104041, 0x4000},
	{104067, 0x20000},
	{104097, 0x80000},
	{104120, 0x100000},
	{104144, 0x400000},
	{104168, 0x800000},
	{104190, 0x1000000},
	{104216, 0x4000000},
	{104240, 0x8000000},
	{104272, 0x20000000},
	{104294, 0x40000000},
	{104316, 0x80000000},
	/* 3282 */
	{92908, 0xFF},
	{92917, 0xFFC00},
	{94474, 0xF00000},
	{94495, 0xF000000},
	{94528, 0xF0000000},
	/* 3287 */
	{92908, 0xFF},
	{94528, 0xF0000000},
	/* 3289 */
	{104338, 0x3FF},
	/* 3290 */
	{48396, 0x1FF},
	/* 3291 */
	{48420, 0x3F},
	/* 3292 */
	{48443, 0x3F},
	/* 3293 */
	{78144, 0x7},
	{104349, 0x70000},
	/* 3295 */
	{48488, 0x3},
	{104362, 0x20},
	{104381, 0xC0},
	{104395, 0x200},
	{104407, 0x800},
	{104428, 0x1000},
	{104445, 0x2000},
	{104466, 0x1F0000},
	/* 3303 */
	{104475, 0x7F},
	{82658, 0x80},
	{104496, 0x3FFF00},
	{82723, 0xFFC00000},
	/* 3307 */
	{104513, 0x1F},
	/* 3308 */
	{104524, 0x3},
	/* 3309 */
	{99969, 0x1},
	{104542, 0x2},
	{104554, 0x4},
	{104570, 0x8},
	{104582, 0x10},
	/* 3314 */
	{104594, 0x3F},
	{104609, 0x40},
	/* 3316 */
	{104629, 0x3F},
	{104643, 0x40},
	/* 3318 */
	{99945, 0x1},
	{104662, 0x2},
	{104680, 0x4},
	{104693, 0x8},
	{104705, 0x10},
	{104717, 0x20},
	{104729, 0x40},
	{104741, 0x80},
	{104753, 0x100},
	{104765, 0x200},
	/* 3328 */
	{104779, 0xFF},
	/* 3329 */
	{18464, 0x3F, 29, 36694},
	/* 3330 */
	{203, 0x3, 2, 36374},
	/* 3331 */
	{104987, 0xF},
	{104996, 0xFF0},
	{105011, 0x1000000},
	{105026, 0x2000000},
	{105038, 0x4000000},
	{105049, 0x8000000},
	{105064, 0x10000000},
	{105079, 0x20000000},
	{105091, 0x40000000},
	{105105, 0x80000000},
	/* 3341 */
	{9882, 0x1},
	{10112, 0x1E},
	/* 3343 */
	{104987, 0xF},
	{104996, 0xFF0},
	{105011, 0x1000000},
	{105026, 0x2000000},
	{105038, 0x4000000},
	{105049, 0x8000000},
	{105064, 0x10000000},
	{105091, 0x20000000},
	{105118, 0x20000000},
	{105105, 0x80000000},
	/* 3353 */
	{105133, 0x1},
	{105146, 0x7E},
	{105163, 0x80},
	/* 3356 */
	{92343, 0x7F},
	{92409, 0x600, 4, 36584},
	/* 3358 */
	{105188, 0x6},
	{105198, 0x8},
	{105218, 0x10},
	{105227, 0xFFFF0000},
	/* 3362 */
	{105240, 0x1F},
	/* 3363 */
	{105254, 0x80000000},
	/* 3364 */
	{105262, 0x1},
	{105283, 0x6},
	{105296, 0x8},
	{105319, 0x10},
	{105339, 0x20},
	{105358, 0x10000000},
	{105369, 0x20000000},
	{105380, 0x40000000},
	{105391, 0x80000000},
	/* 3373 */
	{104987, 0xF},
	{104996, 0xFF0},
	{105011, 0x1000000},
	{105402, 0x2000000},
	{105417, 0x4000000},
	{105049, 0x8000000},
	{105064, 0x10000000},
	{105432, 0x20000000},
	{105448, 0x40000000},
	{105464, 0x80000000},
	/* 3383 */
	{105481, 0x80000000},
	/* 3384 */
	{18448, 0xFF},
	/* 3385 */
	{92908, 0x1FF},
	{92917, 0xFFC00},
	{94474, 0xF00000},
	/* 3388 */
	{105489, 0xFFFF},
	{105511, 0xFFFF0000},
	/* 3390 */
	{104987, 0xF},
	{104996, 0xFF0},
	{105011, 0x1000000},
	{105402, 0x2000000},
	{105417, 0x4000000},
	{105049, 0x8000000},
	{105064, 0x10000000},
	{105118, 0x20000000},
	{105533, 0x40000000},
	{105548, 0x80000000},
	/* 3400 */
	{105563, 0x3F},
	{105590, 0x7FC0},
	{105616, 0x1F8000},
	{105638, 0xFF800000},
	/* 3404 */
	{105663, 0x3F},
	{105687, 0xFC0},
	{105711, 0x3F000},
	{105731, 0xFC0000},
	/* 3408 */
	{105751, 0x3F},
	/* 3409 */
	{105765, 0x1},
	{105791, 0x2},
	{105814, 0x4},
	{105839, 0x8},
	{105870, 0x10},
	{105904, 0x20},
	{105924, 0xC0},
	{105951, 0x100},
	{105979, 0x200},
	{106014, 0x400},
	{106044, 0x800},
	{106079, 0x1000},
	{106109, 0x2000},
	{106132, 0x4000},
	{106171, 0x8000},
	{106203, 0x10000},
	{106239, 0x20000},
	{106269, 0x40000},
	{106315, 0x80000},
	{106356, 0x100000},
	{106406, 0x200000},
	{106456, 0x400000},
	{106507, 0x800000},
	{106555, 0x1000000},
	{105380, 0x40000000},
	{105391, 0x80000000},
	/* 3435 */
	{92255, 0xFF},
	{99042, 0x100},
	{106601, 0x200},
	{106620, 0x400},
	{106641, 0x800},
	{106660, 0x1000},
	{106682, 0x2000},
	{106703, 0x4000},
	{106726, 0x8000},
	/* 3444 */
	{106756, 0x3},
	{106772, 0xC},
	{106788, 0x30},
	{106804, 0x40},
	{106819, 0x80},
	{106837, 0x100},
	{106852, 0x200},
	{106871, 0x400},
	{106889, 0x800},
	/* 3453 */
	{106910, 0x1},
	{106926, 0x2},
	{106942, 0x4},
	/* 3456 */
	{106962, 0x7F},
	{106966, 0x380},
	{106970, 0x1FFC00},
	/* 3459 */
	{106974, 0x3F},
	{106987, 0xF00},
	{106999, 0x10000000},
	{107008, 0x20000000},
	{100944, 0x40000000},
	{100913, 0x80000000},
	/* 3465 */
	{107022, 0xF},
	{107042, 0xF00},
	{107059, 0x30000},
	{107075, 0xC0000},
	/* 3469 */
	{55920, 0x1},
	{85919, 0x2, 4, 36464},
	{85854, 0x4, 2, 36462},
	{19758, 0x8, 4, 36458},
	{85772, 0x10, 2, 36456},
	{85741, 0x20, 4, 36452},
	{94624, 0x40},
	{94630, 0x1F00},
	{94640, 0x2000},
	/* 3478 */
	{107095, 0xF0000},
	{107113, 0xF00000},
	{107131, 0xF000000},
	{107149, 0xF0000000},
	/* 3482 */
	{56272, 0x1},
	{107167, 0x2},
	{107186, 0xFFF0},
	{107201, 0xFFF0000},
	/* 3486 */
	{92908, 0x1FF},
	{94610, 0xF000},
	{107216, 0xF0000},
	{92927, 0xF00000},
	{107232, 0xF000000},
	{94528, 0xF0000000},
	/* 3492 */
	{107242, 0xFFFF},
	{107258, 0xFFFF0000},
	/* 3494 */
	{104987, 0xF},
	{104996, 0xFF0},
	{105091, 0x40000000},
	{105105, 0x80000000},
	/* 3498 */
	{50478, 0xF},
	{55563, 0x30},
	{107274, 0xFC0},
	{107284, 0x1000},
	{107294, 0x2000},
	{99853, 0x4000},
	{107305, 0x8000},
	{441, 0xFFFF0000},
	/* 3506 */
	{38, 0x3FFFFF},
	/* 3507 */
	{107315, 0x1F},
	{107322, 0x20},
	{60082, 0x80},
	{107329, 0x3000},
	{60095, 0x4000},
	{60108, 0x8000},
	{107340, 0xFFFF0000},
	{107340, 0xFFFF0000},
	/* 3515 */
	{2132, 0xFFFF},
	{107352, 0xFF0000},
	{60120, 0x1000000},
	/* 3518 */
	{107361, 0xFFFF},
	{107370, 0xFFFF0000},
	/* 3520 */
	{2090, 0x3FFFFFFF},
	{107379, 0xC0000000},
	/* 3522 */
	{60234, 0x7},
	{60249, 0x70000},
	{107391, 0x20000000},
	{56272, 0x40000000},
	{68598, 0x80000000},
	/* 3527 */
	{107399, 0x7},
	{107407, 0x38},
	{107415, 0x1C0},
	{107423, 0xE00},
	{107431, 0x7000},
	{107439, 0x38000},
	{107447, 0x1C0000},
	{982, 0x600000},
	{107455, 0x1800000},
	{107468, 0x2000000},
	{55319, 0x4000000},
	{107481, 0x18000000},
	{107492, 0x20000000},
	{60055, 0x40000000},
	{65006, 0x80000000},
	/* 3542 */
	{107502, 0x80000000},
	/* 3543 */
	{49765, 0x7},
	/* 3544 */
	{107515, 0x3FFF},
	{107525, 0x3FFF0000},
	{107535, 0xC0000000},
	/* 3547 */
	{107548, 0x3FFF},
	{107564, 0x3FF0000},
	{107589, 0x78000000},
	{107614, 0x80000000},
	/* 3551 */
	{69295, 0x1},
	{68867, 0x2},
	{11232, 0x4},
	/* 3554 */
	{107628, 0xFF},
	{107637, 0xFF00},
	{107646, 0xFF0000},
	{107655, 0xFF000000},
	/* 3558 */
	{107664, 0x3F},
	{107672, 0x1F00},
	{107681, 0x1FF0000},
	/* 3561 */
	{107690, 0x3F},
	{107698, 0x1F00},
	{107707, 0x1FF0000},
	/* 3564 */
	{50478, 0xF},
	{55563, 0x30},
	{30503, 0x1C0},
	{55609, 0x1E00},
	/* 3568 */
	{60435, 0x7, 8, 36723},
	{60445, 0x38, 8, 36723},
	{60455, 0x1C0, 8, 36723},
	{60465, 0xE00, 8, 36723},
	{107980, 0x7000, 8, 36731},
	{108372, 0x78000, 16, 36739},
	{108384, 0x180000},
	{64702, 0x600000},
	{64715, 0x800000},
	{83953, 0x1000000},
	{108397, 0x2000000},
	{108409, 0x4000000},
	{83966, 0x38000000},
	{209, 0xC0000000, 4, 36755},
	/* 3582 */
	{60390, 0xFF},
	{65036, 0xFFF00},
	{108372, 0x3F00000, 64, 36759},
	{107980, 0x3C000000, 16, 36823},
	{83966, 0xC0000000},
	/* 3587 */
	{66756, 0x3FFF},
	{66863, 0xFFFC000},
	{67266, 0x70000000},
	{110467, 0x80000000},
	/* 3591 */
	{60435, 0x7, 8, 36723},
	{60445, 0x38, 8, 36723},
	{60455, 0x1C0, 8, 36723},
	{60465, 0xE00, 8, 36723},
	{67085, 0xF000},
	{67096, 0xF0000},
	{110478, 0x1F00000},
	{110491, 0x2000000},
	{83966, 0x4000000},
	{83953, 0x8000000},
	{209, 0xF0000000, 16, 36839},
	/* 3602 */
	{18448, 0x1FFF},
	{21164, 0x7FFE000},
	/* 3604 */
	{67222, 0x1FFF},
	{110802, 0x3FFE000},
	/* 3606 */
	{67253, 0xFFF},
	{67317, 0xFF000},
	{67290, 0x100000},
	{110813, 0xFFE00000},
	/* 3610 */
	{64847, 0x7, 8, 36855},
	{64855, 0x38, 8, 36855},
	{64863, 0x1C0, 8, 36855},
	{64871, 0xE00},
	{64887, 0x7000, 8, 36863},
	{64906, 0x8000},
	{64925, 0x70000},
	{64941, 0x80000},
	{64956, 0x100000},
	{64970, 0x7E00000},
	{64981, 0x8000000},
	{64993, 0x10000000},
	{65011, 0x60000000, 3, 36871},
	/* 3623 */
	{65068, 0x3FFF},
	{65112, 0xFC000},
	{65125, 0x300000, 4, 36874},
	{65139, 0xC00000, 4, 36874},
	{65153, 0x3000000, 3, 36878},
	{65162, 0xC000000, 3, 36881},
	{65173, 0x10000000},
	{111554, 0x20000000},
	{111571, 0x40000000},
	/* 3632 */
	{65077, 0xFFF},
	{111587, 0x20000000},
	{65094, 0xC0000000, 4, 36884},
	/* 3635 */
	{65408, 0x7},
	{65418, 0x70},
	{111729, 0x700},
	{65460, 0x3000},
	{111750, 0x70000},
	{111774, 0x700000},
	{111783, 0x3000000},
	{111803, 0x30000000},
	{111812, 0x40000000},
	/* 3644 */
	{111862, 0x3, 4, 36888},
	{65849, 0x3C, 16, 2765},
	{66277, 0x7C0, 18, 2781},
	{66467, 0x3800, 7, 2800},
	{66626, 0x1C00000, 5, 2807},
	{66646, 0x6000000},
	/* 3650 */
	{67552, 0x3F},
	{67558, 0x3C0},
	{65248, 0xC00},
	{67607, 0xFF000, 241, 2834},
	{55319, 0x100000},
	{55112, 0x200000},
	{111878, 0x400000},
	{67618, 0x800000},
	{67628, 0x1000000},
	{111889, 0xE000000},
	{111899, 0x10000000},
	/* 3661 */
	{67657, 0x1},
	{67668, 0x3E},
	{67678, 0x40},
	{67691, 0x80},
	{67703, 0xFF00},
	{55255, 0x7F0000, 257, 0},
	/* 3667 */
	{67552, 0x3F},
	{67558, 0x3C0},
	{65248, 0xC00},
	{67607, 0xFF000, 241, 2834},
	{55319, 0x100000},
	{55112, 0x200000},
	{111878, 0x400000},
	{67618, 0x800000},
	{68148, 0x3000000},
	{68162, 0x4000000},
	{111889, 0x38000000},
	{111899, 0x40000000},
	/* 3679 */
	{67657, 0x1},
	{67668, 0x3E},
	{67678, 0x40},
	{68178, 0x80},
	{68188, 0x100},
	{68200, 0x200},
	{68212, 0x400},
	{68224, 0x800},
	{68236, 0x1000},
	{55255, 0xFE000, 257, 0},
	/* 3689 */
	{67552, 0x3F},
	{67558, 0x3C0},
	{65248, 0xC00},
	{67607, 0xFF000, 241, 2834},
	{55319, 0x100000},
	{55112, 0x200000},
	{111878, 0x400000},
	{67618, 0x800000},
	{68162, 0x1000000},
	{111889, 0xE000000},
	{111899, 0x10000000},
	/* 3700 */
	{67657, 0x1},
	{67668, 0x3E},
	{67678, 0x40},
	{55255, 0x3F80, 257, 0},
	/* 3704 */
	{67657, 0x1},
	{67668, 0x3E},
	{67678, 0x40},
	{68178, 0x80},
	{55255, 0x7F00, 257, 0},
	{55688, 0x1FF00000},
	/* 3710 */
	{67552, 0x3F},
	{67558, 0x3C0},
	{65248, 0xC00},
	{67607, 0xFF000, 241, 2834},
	{55319, 0x100000},
	{55112, 0x200000},
	{111878, 0x400000},
	{67618, 0x800000},
	{111889, 0x7000000},
	{111899, 0x8000000},
	/* 3720 */
	{67657, 0x1},
	{67668, 0x3E},
	{67678, 0x40},
	{68178, 0x80},
	{68384, 0x100},
	{55255, 0xFE00, 257, 0},
	/* 3726 */
	{67552, 0x3F},
	{67558, 0x3C0},
	{65248, 0xC00},
	{67607, 0xFF000, 241, 2834},
	{55319, 0x100000},
	{55112, 0x200000},
	{111878, 0x400000},
	{67618, 0x800000},
	{68148, 0x3000000},
	{111889, 0x1C000000},
	{111899, 0x20000000},
	/* 3737 */
	{67657, 0x1},
	{67668, 0x3E},
	{67678, 0x40},
	{55688, 0xFF80},
	{55255, 0x7F0000, 257, 0},
	/* 3742 */
	{68395, 0x1},
	{68413, 0x2},
	{68427, 0x4},
	{68446, 0x8},
	{68466, 0x10},
	{68486, 0x20},
	{68508, 0x40},
	{111909, 0x380},
	{68519, 0x400},
	{68537, 0x800},
	{99101, 0x1000},
	{68569, 0x4000},
	/* 3754 */
	{50474, 0xFFF},
	/* 3755 */
	{391, 0xFF},
	{99110, 0x100},
	/* 3757 */
	{67552, 0x3F},
	{67558, 0x3C0},
	{65248, 0xC00},
	{67607, 0xFF000, 241, 2834},
	{55319, 0x100000},
	{55112, 0x200000},
	{111878, 0x400000},
	{67618, 0x800000},
	{68622, 0x1000000},
	{111899, 0x2000000},
	/* 3767 */
	{68685, 0x3F},
	{111929, 0x3F},
	{68698, 0xF000},
	{68708, 0x3F0000},
	{68723, 0x400000},
	{68738, 0x800000},
	{68754, 0x7000000},
	/* 3774 */
	{111947, 0xFFFF},
	{111957, 0xFFFF0000},
	/* 3776 */
	{42978, 0x1},
	{111967, 0x2},
	{111976, 0x4},
	{111985, 0x8},
	{111993, 0x10},
	{112005, 0x20},
	{112017, 0x40},
	{112029, 0x80},
	{112041, 0x100},
	{112052, 0x200},
	{112062, 0x400},
	{112070, 0x800},
	{112096, 0x1000},
	{112109, 0x2000},
	{112120, 0x4000},
	{112130, 0x8000},
	{112144, 0x10000},
	{112160, 0x20000},
	{112176, 0x40000},
	{112192, 0x80000},
	{112203, 0x100000},
	{112220, 0x200000},
	{112236, 0x400000},
	{112255, 0x2000000},
	{112269, 0x4000000},
	{112278, 0x8000000},
	{112292, 0x30000000},
	{112307, 0x40000000},
	{112316, 0x80000000},
	/* 3805 */
	{69075, 0x1},
	{69099, 0x2},
	{69189, 0x70},
	{69201, 0xF00},
	{69214, 0xF000},
	{69227, 0xF0000},
	{69240, 0xF00000},
	{69254, 0xF000000},
	{69272, 0xF0000000},
	/* 3814 */
	{69289, 0x7FF},
	{69316, 0xFFE000},
	{69326, 0x1000000},
	{69338, 0x2000000},
	/* 3818 */
	{112330, 0xF},
	{65849, 0xF0, 16, 2765},
	{66277, 0x1F00, 18, 2781},
	{66751, 0x6000, 4, 2812},
	{66858, 0x18000, 4, 2816},
	{66970, 0x60000, 4, 2820},
	{67057, 0x180000, 4, 2824},
	/* 3825 */
	{17302, 0x3, 4, 3099},
	{70621, 0xC},
	{66467, 0xE000, 7, 2800},
	{90343, 0x700000},
	{70772, 0x8000000},
	{70787, 0x10000000},
	{70797, 0x20000000},
	{70817, 0x80000000},
	/* 3833 */
	{17302, 0x1, 2, 3107},
	{66467, 0xE000, 7, 2800},
	{90343, 0x700000},
	{70772, 0x8000000},
	{70860, 0x20000000},
	/* 3838 */
	{112349, 0x7FF},
	{112364, 0x3FF800},
	/* 3840 */
	{112380, 0x3FFFFF},
	/* 3841 */
	{50688, 0x3},
	/* 3842 */
	{75401, 0x3F},
	{75412, 0x40},
	{75455, 0x4000},
	/* 3845 */
	{11609, 0xFF},
	/* 3846 */
	{78866, 0x8},
	{982, 0x70, 6, 36061},
	{78139, 0xFF0000, 256, 36069},
	/* 3849 */
	{18464, 0x1F, 29, 36694},
	{82465, 0x4000},
	{82478, 0x8000},
	{82491, 0x70000},
	/* 3853 */
	{83605, 0x3F, 3, 36370},
	{83618, 0x3F00, 3, 36370},
	{83633, 0x3F0000, 3, 36370},
	{83648, 0xFC00000, 3, 36370},
	{83663, 0x80000000},
	/* 3858 */
	{203, 0x3, 2, 36374},
	{83800, 0xC, 4, 36377},
	{83880, 0x30, 3, 36381},
	{83940, 0xC0, 4, 36892},
	{83953, 0x100},
	{78307, 0x200},
	{83957, 0x400},
	/* 3865 */
	{85176, 0x3F, 60, 36896},
	{60395, 0x7FC0000},
	{85187, 0x8000000},
	/* 3868 */
	{89929, 0x1},
	{85390, 0x2},
	{112522, 0x4},
	{112545, 0x8},
	{112553, 0x3F0},
	{112568, 0xFC00},
	{85469, 0x10000},
	/* 3875 */
	{209, 0x3, 3, 36468},
	{86251, 0x1C, 4, 36471},
	{86328, 0xE0, 4, 36475},
	{86337, 0x100},
	{86357, 0x200},
	{86368, 0x3C00},
	{86390, 0x4000},
	{83940, 0x18000, 4, 36892},
	/* 3883 */
	{86757, 0x1},
	{86772, 0x2},
	{86787, 0x4},
	{86802, 0x8},
	{86817, 0x70},
	{86849, 0xF00},
	{86866, 0x80000000},
	/* 3890 */
	{89218, 0x3, 4, 36520},
	{17302, 0x7C, 24, 36524},
	{65499, 0x80},
	{89816, 0x700, 8, 36556},
	{89872, 0x1800, 4, 36564},
	{78915, 0x2000},
	{69909, 0x4000},
	{89882, 0x8000},
	{89894, 0x10000},
	{89907, 0x20000},
	{87486, 0x40000},
	{89920, 0x80000},
	{90147, 0x700000, 8, 36568},
	{90169, 0x3800000, 8, 36568},
	{90193, 0x4000000},
	/* 3905 */
	{91783, 0xF00, 5, 36612},
	{96427, 0x10000},
	{96439, 0x100000},
	{96454, 0xC0000000, 4, 36618},
	/* 3909 */
	{26590, 0xFFFF},
	{91783, 0x300000, 2, 36622},
	{96494, 0x8000000, 2, 36618},
	{96516, 0x60000000, 3, 36626},
	{96524, 0x80000000},
	/* 3914 */
	{91448, 0x1FFFFF},
	{96562, 0x200000},
	{101067, 0xC00000, 4, 36956},
	{101076, 0x3000000, 4, 36956},
	{91459, 0x4000000, 2, 36630},
	{91463, 0x8000000, 2, 36630},
	{91467, 0x10000000, 2, 36632},
	{91472, 0x20000000, 2, 36632},
	{91477, 0x40000000},
	/* 3923 */
	{96494, 0x1, 2, 36618},
	{91783, 0x300000, 2, 36622},
	{96516, 0x60000000, 3, 36626},
	{96524, 0x80000000},
	/* 3927 */
	{55093, 0xF},
	{55102, 0xF0},
	{55112, 0x100},
	{55123, 0x200},
	{55128, 0x400},
	{99042, 0x800},
	{55255, 0x1FF000, 257, 0},
	{55286, 0x10000000},
	{55292, 0xE0000000},
	/* 3936 */
	{55457, 0x1FF, 257, 0},
	{55502, 0x3F0000},
	{55555, 0xE0000000},
	/* 3939 */
	{50478, 0xF},
	{55563, 0x30},
	{55571, 0xC0},
	{55579, 0xF00},
	{55585, 0x1000},
	{28888, 0x6000},
	{55603, 0xF0000},
	{55609, 0xF00000},
	{55615, 0x7000000},
	{55624, 0x38000000},
	{55633, 0xC0000000},
	/* 3950 */
	{55714, 0xF},
	{55721, 0x70},
	{55743, 0xF00},
	{55752, 0x7000},
	/* 3954 */
	{56022, 0xF},
	{56045, 0x10},
	{56068, 0x20},
	{56091, 0x40},
	{56111, 0x80},
	{56131, 0x100},
	{56151, 0x200},
	{56171, 0x400},
	{56191, 0x800},
	{56211, 0x1000},
	{56231, 0x2000},
	{56251, 0x4000},
	{56383, 0x1000000},
	{57321, 0x2000000},
	{56401, 0x10000000},
	{56410, 0x20000000},
	{56419, 0x40000000},
	/* 3971 */
	{56938, 0x1},
	{56948, 0x2},
	{56958, 0x4},
	{56967, 0x8},
	{56976, 0x10},
	{56987, 0x20},
	{56998, 0x40},
	{57008, 0x80},
	{103028, 0x100},
	{103043, 0x200},
	{57018, 0x400},
	{57028, 0x800},
	{57045, 0x1000},
	{57163, 0x20000000},
	{57176, 0x40000000},
	{56410, 0x80000000},
	/* 3987 */
	{112608, 0x1},
	{112629, 0x2},
	{57673, 0x8},
	{57692, 0x10},
	{57712, 0x40},
	{57731, 0x100},
	{57752, 0x200},
	{57770, 0x400},
	{112650, 0x800},
	{112671, 0x1000},
	{57793, 0x2000},
	{57815, 0x10000},
	{57836, 0x20000},
	{57854, 0x40000},
	{112694, 0x80000},
	{112715, 0x100000},
	{57877, 0x200000},
	/* 4004 */
	{57992, 0x1},
	{58011, 0x2},
	{103028, 0x4},
	{103043, 0x8},
	{58020, 0x10},
	{58035, 0x20},
	{58049, 0x40},
	{58068, 0x80},
	{58087, 0x100},
	{58102, 0x200},
	{58119, 0x400},
	{58141, 0x800},
	{58163, 0x1000},
	{58178, 0x2000},
	{57018, 0x4000},
	{58193, 0x8000},
	{58338, 0x40000000},
	{56401, 0x80000000},
	/* 4022 */
	{58351, 0x1},
	{58369, 0x2},
	{58383, 0x4},
	{58402, 0x8},
	{58421, 0x10},
	{58436, 0x20},
	{58454, 0x40},
	{58472, 0x80},
	{58489, 0x100},
	{112738, 0x200},
	{58535, 0x800},
	{58559, 0x1000},
	{58577, 0x2000},
	{58595, 0x4000},
	{58616, 0x8000},
	{58640, 0x10000},
	{58666, 0x20000},
	{58683, 0x40000},
	{58703, 0x80000},
	{58723, 0x100000},
	{58743, 0x200000},
	{58764, 0x400000},
	{58787, 0x800000},
	{58808, 0x1000000},
	{58827, 0x2000000},
	{58844, 0x4000000},
	{58860, 0x8000000},
	{58876, 0x10000000},
	{58892, 0x20000000},
	{58911, 0x40000000},
	{58923, 0x80000000},
	/* 4053 */
	{58935, 0x1},
	{58954, 0x2},
	{58974, 0x4},
	{58994, 0x8},
	{101718, 0x10},
	{59014, 0x20},
	{59035, 0x40},
	/* 4060 */
	{107315, 0x1F},
	{107322, 0x20},
	{60082, 0x80},
	{55398, 0xF00},
	{107329, 0x3000},
	{60095, 0x4000},
	{60108, 0x8000},
	{107340, 0xFFFF0000},
	{107340, 0xFFFF0000},
	/* 4069 */
	{9994, 0xF},
	{83953, 0x10},
	/* 4071 */
	{112760, 0xFFFF},
	/* 4072 */
	{60234, 0x3FF},
	{60249, 0x3FF0000},
	{107391, 0x20000000},
	{56272, 0x40000000},
	{68598, 0x80000000},
	/* 4077 */
	{90971, 0xFFFF},
	{90983, 0x10000},
	{26653, 0xE0000000},
	/* 4080 */
	{112770, 0x1000},
	{91079, 0x6000},
	{112778, 0x8000},
	{91108, 0x300000},
	{112791, 0x1000000},
	{91119, 0x6000000},
	{112799, 0x8000000},
	{91148, 0x60000000},
	/* 4088 */
	{112812, 0x7F},
	{112824, 0x3F000},
	{11589, 0x6000000},
	{91762, 0x8000000},
	/* 4092 */
	{27643, 0xFFFF},
	{91783, 0x30000},
	{91791, 0x7000000},
	{91799, 0xE0000000},
	/* 4096 */
	{92775, 0x3F},
	{92780, 0xC0},
	{92788, 0x100},
	{92794, 0xFFFFFE00},
	/* 4100 */
	{80899, 0x1},
	{858, 0x1FFE},
	{209, 0x2000},
	{88780, 0x4000},
	{92802, 0x8000},
	{92814, 0x7FF0000},
	{92825, 0x8000000},
	{92836, 0x10000000},
	{92780, 0xE0000000},
	/* 4109 */
	{92958, 0x3F},
	{92968, 0xFC00},
	/* 4111 */
	{92908, 0x3F},
	{92917, 0xFC00},
	{94474, 0xF00000},
	/* 4114 */
	{92908, 0xFF},
	{94610, 0xF000},
	{107216, 0xF0000},
	{92927, 0xF00000},
	{107232, 0xF000000},
	{94528, 0xF0000000},
	/* 4120 */
	{52065, 0xFF},
	{10365, 0xFFFFFF00},
	/* 4122 */
	{26590, 0xFFFF},
	{91783, 0x300000, 4, 36960},
	{96494, 0x8000000, 2, 36618},
	{96516, 0x60000000, 4, 36626},
	{96524, 0x80000000},
	/* 4127 */
	{96494, 0x1, 2, 36618},
	{91079, 0x6000},
	{91783, 0x300000, 4, 36960},
	{91119, 0x6000000},
	{96516, 0x60000000, 4, 36626},
	{96524, 0x80000000},
	/* 4133 */
	{55093, 0xF},
	{55102, 0xF0},
	{55112, 0x100},
	{55123, 0x200},
	{55128, 0x400},
	{99042, 0x800},
	{55255, 0x1FF000, 257, 0},
	{112841, 0x8000000},
	{55286, 0x10000000},
	{55292, 0xE0000000},
	/* 4143 */
	{55296, 0x1},
	{55300, 0x6},
	{55309, 0x18},
	{55319, 0x20},
	{55324, 0x40},
	{55332, 0x80},
	{55342, 0x100},
	{55353, 0x200},
	{55359, 0x400},
	{55364, 0x800},
	{55370, 0x1000},
	{55381, 0x2000},
	{55386, 0x4000},
	{99061, 0x8000},
	{55142, 0x10000},
	{55406, 0x20000},
	{55414, 0x40000},
	{55426, 0x80000},
	{99074, 0x100000},
	{99088, 0x200000},
	{112852, 0x400000},
	{99110, 0x800000},
	{55445, 0x8000000},
	/* 4166 */
	{55457, 0x1FF, 257, 0},
	{55462, 0x400},
	{55502, 0x3F0000},
	{55555, 0xE0000000},
	/* 4170 */
	{55714, 0xF},
	{55721, 0x70},
	{55743, 0xF00},
	{55752, 0x7000},
	{55761, 0x8000},
	{55774, 0xF0000},
	/* 4176 */
	{99139, 0x7},
	{99147, 0x8},
	{99158, 0x10},
	{99171, 0xE0},
	{99187, 0x300},
	{99197, 0xC00},
	{99207, 0xF0000},
	{55877, 0xF00000},
	{99219, 0x3000000},
	{99226, 0x4000000},
	{99233, 0x18000000},
	{69567, 0x20000000},
	{99241, 0x40000000},
	/* 4189 */
	{112865, 0x1},
	{55822, 0x2},
	{55828, 0x4},
	{55857, 0xF0},
	{55862, 0xF00},
	/* 4194 */
	{56022, 0xF},
	{56045, 0x10},
	{56068, 0x20},
	{56091, 0x40},
	{56111, 0x80},
	{56131, 0x100},
	{56151, 0x200},
	{56171, 0x400},
	{56191, 0x800},
	{56211, 0x1000},
	{56231, 0x2000},
	{56251, 0x4000},
	{56383, 0x1000000},
	{57321, 0x2000000},
	{112872, 0x4000000},
	{56401, 0x10000000},
	{56410, 0x20000000},
	{56419, 0x40000000},
	/* 4212 */
	{56938, 0x1},
	{56948, 0x2},
	{56958, 0x4},
	{56967, 0x8},
	{56976, 0x10},
	{56987, 0x20},
	{56998, 0x40},
	{57008, 0x80},
	{57018, 0x400},
	{57028, 0x800},
	{57045, 0x1000},
	{112888, 0x2000},
	{57163, 0x20000000},
	{57176, 0x40000000},
	{56410, 0x80000000},
	/* 4227 */
	{57673, 0x8},
	{57692, 0x10},
	{57712, 0x40},
	{57731, 0x100},
	{57752, 0x200},
	{57770, 0x400},
	{57793, 0x2000},
	{57815, 0x10000},
	{57836, 0x20000},
	{57854, 0x40000},
	{57877, 0x200000},
	{112901, 0x400000},
	{112925, 0x800000},
	{112949, 0x1000000},
	/* 4241 */
	{57992, 0x1},
	{58011, 0x2},
	{58020, 0x10},
	{58035, 0x20},
	{58049, 0x40},
	{58068, 0x80},
	{58087, 0x100},
	{58102, 0x200},
	{58119, 0x400},
	{58141, 0x800},
	{58163, 0x1000},
	{58178, 0x2000},
	{57018, 0x4000},
	{58193, 0x8000},
	{58202, 0x10000},
	{112888, 0x20000},
	{58293, 0x4000000},
	{58306, 0x8000000},
	{58319, 0x30000000},
	{58338, 0x40000000},
	{56401, 0x80000000},
	/* 4262 */
	{58935, 0x1},
	{58954, 0x2},
	{58974, 0x4},
	{58994, 0x8},
	{59014, 0x20},
	{59035, 0x40},
	{112901, 0x80},
	{112925, 0x100},
	{112949, 0x200},
	/* 4271 */
	{60435, 0x7, 8, 36723},
	{60445, 0x38, 8, 36723},
	{60455, 0x1C0, 8, 36723},
	{60465, 0xE00, 8, 36723},
	{107980, 0x7000, 8, 36964},
	{108372, 0x78000, 16, 36739},
	{108384, 0x180000},
	{64702, 0x600000},
	{64715, 0x800000},
	{83953, 0x1000000},
	{108397, 0x2000000},
	{108409, 0x4000000},
	{83966, 0x38000000},
	{209, 0xC0000000, 4, 36755},
	/* 4285 */
	{60390, 0xFF},
	{65036, 0xFFF00},
	{108372, 0x3F00000, 64, 36759},
	{107980, 0x3C000000, 16, 36972},
	{83966, 0xC0000000},
	/* 4290 */
	{67253, 0xFFF},
	{67317, 0xFF000},
	{67290, 0x100000},
	{67439, 0x200000},
	{67454, 0x400000},
	{67470, 0x800000},
	{113132, 0xF000000},
	{113148, 0xF0000000},
	/* 4298 */
	{64847, 0x7, 8, 36855},
	{64855, 0x38, 8, 36855},
	{64863, 0x1C0, 8, 36855},
	{64871, 0xE00},
	{64887, 0x7000, 8, 36863},
	{64906, 0x8000},
	{64925, 0x70000},
	{64941, 0x80000},
	{64956, 0x100000},
	{64970, 0x7E00000},
	{64981, 0x8000000},
	{64993, 0x10000000},
	{65011, 0x60000000, 3, 36871},
	{113164, 0x80000000},
	/* 4312 */
	{65068, 0x3FFF},
	{65112, 0xFC000},
	{65125, 0x300000, 4, 36874},
	{65139, 0xC00000, 4, 36874},
	{65153, 0x3000000, 3, 36878},
	{65162, 0xC000000, 4, 36988},
	{65173, 0x10000000},
	{111554, 0x20000000},
	{111571, 0x40000000},
	{65192, 0x80000000},
	/* 4322 */
	{67657, 0x1},
	{67668, 0x3E},
	{67678, 0x40},
	{68178, 0x80},
	{68188, 0x100},
	{68200, 0x200},
	{68212, 0x400},
	{68224, 0x800},
	{68236, 0x1000},
	{55255, 0x3FE000, 257, 0},
	{68253, 0x1000000},
	/* 4333 */
	{83953, 0x1},
	{83966, 0x6},
	/* 4335 */
	{17302, 0x3, 4, 3099},
	{70621, 0xC},
	{66467, 0xE000, 7, 2800},
	{90343, 0x700000},
	{70748, 0x7800000},
	{70772, 0x8000000},
	{70787, 0x10000000},
	{70797, 0x20000000},
	{113210, 0x40000000},
	{70817, 0x80000000},
	/* 4345 */
	{17302, 0x1, 2, 3107},
	{66467, 0xE000, 7, 2800},
	{90343, 0x700000},
	{70772, 0x8000000},
	{70860, 0x20000000},
	{113210, 0x40000000},
	/* 4351 */
	{73949, 0x1},
	{113227, 0x2},
	{73976, 0x7C},
	/* 4354 */
	{78866, 0x8},
	{982, 0x70, 7, 36061},
	{78139, 0xFF0000, 256, 36069},
	/* 4357 */
	{80611, 0x1},
	{80627, 0x2},
	{80643, 0x4},
	{80659, 0x8},
	{80675, 0x10},
	{80691, 0x20},
	{80707, 0x40},
	{80723, 0x80},
	{80739, 0x100},
	{80755, 0x200},
	{80771, 0x400},
	{80787, 0x800},
	{80803, 0x1000},
	{80819, 0x2000},
	{80835, 0x4000},
	{80851, 0x8000},
	{80867, 0x10000},
	{80886, 0x20000},
	{80904, 0x40000},
	{80931, 0x80000},
	{80953, 0x100000},
	{80971, 0x200000},
	{80991, 0x400000},
	{81014, 0x800000},
	{81037, 0x1000000},
	{81062, 0x2000000},
	{81105, 0x4000000},
	/* 4384 */
	{982, 0x7, 6, 36360},
	{82658, 0x8},
	{82714, 0x30, 4, 36366},
	{82723, 0x7C0},
	{82734, 0x800},
	{82747, 0x1000},
	{82758, 0x2000},
	{93115, 0x4000},
	{113266, 0x8000},
	{113277, 0x10000},
	{82817, 0x20000},
	{82836, 0x40000},
	{82850, 0x80000},
	{82868, 0x100000},
	{82886, 0x600000},
	/* 4399 */
	{203, 0x3, 3, 36374},
	{83800, 0xC, 4, 36377},
	{83880, 0x30, 4, 36381},
	{83940, 0x40, 2, 36385},
	{78307, 0x200},
	{83957, 0x400},
	{83966, 0x1800},
	/* 4406 */
	{85176, 0x3F, 61, 36992},
	{60395, 0x7FC0000},
	{85187, 0x8000000},
	/* 4409 */
	{85292, 0xFFFF},
	{85307, 0x10000},
	{85326, 0x20000},
	{85340, 0x40000},
	{85359, 0x80000},
	{85373, 0x100000},
	{86017, 0xF0000000},
	/* 4416 */
	{89929, 0x1},
	{85390, 0x2},
	{112522, 0x4},
	{112545, 0x8},
	{112553, 0x3F0},
	{112568, 0xFC00},
	{85469, 0x10000},
	{113288, 0x20000},
	/* 4424 */
	{209, 0x3, 3, 36468},
	{86251, 0x1C, 4, 36471},
	{86328, 0xE0, 4, 36475},
	{86337, 0x100},
	{86357, 0x200},
	{86368, 0x3C00},
	{86390, 0x4000},
	{83940, 0x8000, 2, 36385},
	{86424, 0x60000, 3, 36479},
	{83966, 0x180000},
	/* 4434 */
	{89218, 0x3, 4, 36520},
	{17302, 0x7C, 24, 36524},
	{65499, 0x80},
	{89816, 0x700, 8, 36556},
	{89872, 0x1800, 4, 36564},
	{78915, 0x2000},
	{69909, 0x4000},
	{89882, 0x8000},
	{89894, 0x10000},
	{89907, 0x20000},
	{87486, 0x40000},
	{89920, 0x80000},
	{90147, 0x700000, 8, 36568},
	{90169, 0x3800000, 8, 36568},
	{90193, 0x4000000},
	{90219, 0x8000000},
	{90245, 0x10000000},
	{90313, 0x60000000, 3, 36576},
	/* 4452 */
	{11589, 0x2000000},
	{83966, 0x18000000},
	/* 4454 */
	{90971, 0xFFFF},
	{90983, 0x10000},
	{90899, 0x2000000},
	{83966, 0x18000000},
	{26653, 0xE0000000},
	/* 4459 */
	{26221, 0xFFFF},
	{83966, 0x300000},
	{90899, 0x400000},
	/* 4462 */
	{26293, 0xFFFF},
	{83966, 0x300000},
	{90899, 0x400000},
	/* 4465 */
	{113302, 0xC00},
	{112770, 0x1000},
	{91079, 0x2000},
	{91108, 0x300000},
	{113312, 0xC00000},
	{112791, 0x1000000},
	{91119, 0x2000000},
	{91148, 0x60000000},
	/* 4473 */
	{91962, 0x1},
	{91978, 0x2},
	{113322, 0x4},
	{91196, 0x8},
	{91994, 0x40},
	{92012, 0x80},
	{92030, 0x100},
	{92048, 0x200},
	{92066, 0x400},
	{92084, 0x800},
	{92102, 0x1000},
	{92120, 0x2000},
	{92138, 0x4000},
	{91257, 0x8000},
	{91277, 0x40000},
	{92155, 0x80000},
	{92171, 0x200000},
	{91294, 0x400000},
	{91310, 0x800000},
	{91324, 0x2000000},
	{91338, 0x4000000},
	{91352, 0x8000000},
	{91373, 0x10000000},
	{91398, 0x20000000},
	{91419, 0x40000000},
	{113339, 0x80000000},
	/* 4499 */
	{112812, 0x7F},
	{112824, 0x3F000},
	{11589, 0x2000000},
	{83966, 0x18000000},
	/* 4503 */
	{92853, 0xFFFF},
	{92877, 0xF0000},
	{92864, 0x300000},
	{92255, 0x3FC00000},
	{92885, 0x40000000},
	{9882, 0x80000000},
	/* 4509 */
	{60390, 0xFF},
	{65036, 0xFFF00},
	{108372, 0x3F00000, 64, 37053},
	{107980, 0x3C000000, 16, 36972},
	{83966, 0xC0000000},
	/* 4514 */
	{78848, 0x1},
	{78866, 0x8},
	{982, 0x70, 7, 36061},
	{78139, 0xFF0000, 256, 36069},
	/* 4518 */
	{85634, 0xFF},
	{85648, 0xFF00},
	{85658, 0xFF0000},
	{85669, 0xFF000000},
	/* 4522 */
	{89218, 0x3, 4, 36520},
	{17302, 0x7C, 31, 36524},
	{65499, 0x80},
	{89816, 0x700, 8, 36556},
	{89872, 0x1800, 4, 36564},
	{78915, 0x2000},
	{69909, 0x4000},
	{89882, 0x8000},
	{89894, 0x10000},
	{89907, 0x20000},
	{87486, 0x40000},
	{89920, 0x80000},
	{90147, 0x700000, 8, 36568},
	{90169, 0x3800000, 8, 36568},
	{90193, 0x4000000},
	{90219, 0x8000000},
	{90245, 0x10000000},
	{90313, 0x60000000, 3, 36576},
	/* 4540 */
	{80899, 0x1},
	{858, 0x1FFE},
	{209, 0x2000},
	{88780, 0x4000},
	{92802, 0x8000},
	{92814, 0xFFF0000},
	{92825, 0x10000000},
	{92836, 0x20000000},
	{92780, 0xC0000000},
	/* 4549 */
	{55093, 0xF},
	{55102, 0xF0},
	{55112, 0x100},
	{55123, 0x200},
	{55128, 0x400},
	{99042, 0x800},
	{55255, 0x1FF000, 257, 0},
	{55263, 0x800000},
	{113657, 0x1000000},
	{113670, 0x2000000},
	{55273, 0x4000000},
	{112841, 0x8000000},
	{55286, 0x10000000},
	{55292, 0xE0000000},
	/* 4563 */
	{55296, 0x1},
	{55300, 0x6},
	{55309, 0x18},
	{55319, 0x20},
	{55324, 0x40},
	{55332, 0x80},
	{55342, 0x100},
	{55353, 0x200},
	{55359, 0x400},
	{55364, 0x800},
	{55370, 0x1000},
	{55381, 0x2000},
	{55386, 0x4000},
	{99061, 0x8000},
	{55142, 0x10000},
	{55406, 0x20000},
	{55414, 0x40000},
	{55426, 0x80000},
	{99074, 0x100000},
	{99088, 0x200000},
	{112852, 0x400000},
	{55434, 0x800000},
	{55445, 0x8000000},
	/* 4586 */
	{55457, 0x1FF, 257, 0},
	{55462, 0x400},
	{55470, 0x800},
	{55483, 0x7000},
	{55502, 0x3F0000},
	{55543, 0x10000000},
	{55555, 0xE0000000},
	/* 4593 */
	{55714, 0xF},
	{55721, 0x70},
	{55743, 0xF00},
	{55752, 0x7000},
	{55761, 0x8000},
	{55774, 0x1F0000},
	{55779, 0xC00000},
	/* 4600 */
	{99139, 0x7},
	{99147, 0x8},
	{99158, 0x10},
	{99171, 0xE0},
	{99187, 0x300},
	{99197, 0xC00},
	{99207, 0xF0000},
	{99219, 0x3000000},
	{99226, 0x4000000},
	{99233, 0x18000000},
	{69567, 0x20000000},
	{99241, 0x40000000},
	{113683, 0x80000000},
	/* 4613 */
	{112865, 0x1},
	{55822, 0x2},
	{55828, 0x4},
	{55857, 0x1F0},
	{55862, 0xF800},
	{55774, 0x7C0000},
	{55877, 0xFE000000},
	/* 4620 */
	{56022, 0xF},
	{56045, 0x10},
	{56068, 0x20},
	{56091, 0x40},
	{56111, 0x80},
	{56131, 0x100},
	{56151, 0x200},
	{56171, 0x400},
	{56191, 0x800},
	{56211, 0x1000},
	{56231, 0x2000},
	{56251, 0x4000},
	{56266, 0x8000},
	{56277, 0x10000},
	{56285, 0x20000},
	{56294, 0x40000},
	{56311, 0x80000},
	{56326, 0x100000},
	{56383, 0x1000000},
	{57321, 0x2000000},
	{112872, 0x4000000},
	{56401, 0x10000000},
	{56410, 0x20000000},
	{56419, 0x40000000},
	{56428, 0x80000000},
	/* 4645 */
	{56439, 0xF},
	{56462, 0x20},
	{56478, 0x80},
	{56501, 0x100},
	{56524, 0x200},
	{56543, 0x1000},
	{56552, 0x2000},
	{56561, 0x4000},
	{56569, 0x8000},
	{99930, 0x10000},
	{99945, 0x20000},
	{99954, 0x40000},
	{99969, 0x80000},
	{56593, 0x100000},
	{99977, 0x200000},
	{56609, 0x400000},
	{56618, 0x800000},
	{56627, 0x1000000},
	{56635, 0x2000000},
	{56643, 0x4000000},
	{56651, 0x10000000},
	{56393, 0x20000000},
	{56669, 0x40000000},
	{56677, 0x80000000},
	/* 4669 */
	{56543, 0x2},
	{56552, 0x4},
	{56285, 0x200000},
	{56618, 0x400000},
	{99945, 0x800000},
	{56635, 0x1000000},
	{56561, 0x2000000},
	{56593, 0x4000000},
	{56609, 0x8000000},
	{56627, 0x20000000},
	{56643, 0x40000000},
	{56669, 0x80000000},
	/* 4681 */
	{56938, 0x1},
	{56948, 0x2},
	{56958, 0x4},
	{56967, 0x8},
	{56976, 0x10},
	{56987, 0x20},
	{56998, 0x40},
	{57008, 0x80},
	{57018, 0x400},
	{57028, 0x800},
	{57045, 0x1000},
	{57053, 0x2000},
	{57066, 0x4000},
	{57163, 0x20000000},
	{57176, 0x40000000},
	{56410, 0x80000000},
	/* 4697 */
	{57992, 0x1},
	{58011, 0x2},
	{58020, 0x10},
	{58035, 0x20},
	{58049, 0x40},
	{58068, 0x80},
	{58087, 0x100},
	{58102, 0x200},
	{58119, 0x400},
	{58141, 0x800},
	{58163, 0x1000},
	{58178, 0x2000},
	{57018, 0x4000},
	{58193, 0x8000},
	{58202, 0x10000},
	{57053, 0x20000},
	{58293, 0x4000000},
	{58306, 0x8000000},
	{58319, 0x30000000},
	{58338, 0x40000000},
	{56401, 0x80000000},
	/* 4718 */
	{60435, 0x7, 8, 36723},
	{60445, 0x38, 8, 36723},
	{60455, 0x1C0, 8, 36723},
	{60465, 0xE00, 8, 36723},
	{107980, 0x7000, 8, 37117},
	{108372, 0x78000, 16, 36739},
	{113728, 0x80000},
	{113743, 0x100000},
	{64702, 0x600000},
	{64715, 0x800000},
	{82552, 0x8000000},
	{209, 0xC0000000, 4, 36755},
	/* 4730 */
	{60390, 0xFF},
	{65036, 0xFFF00},
	{108372, 0x3F00000, 64, 37125},
	{114227, 0x3F00000, 61, 37189},
	{107980, 0x3C000000, 16, 37250},
	{114734, 0x3C000000, 16, 37266},
	{82552, 0x40000000},
	{114751, 0x80000000},
	/* 4738 */
	{60435, 0x7, 8, 36723},
	{60445, 0x38, 8, 36723},
	{60455, 0x1C0, 8, 36723},
	{60465, 0xE00, 8, 36723},
	{67085, 0xF000},
	{67096, 0xF0000},
	{67107, 0x1F00000},
	{209, 0xF0000000, 16, 36839},
	/* 4746 */
	{18448, 0x1FFF},
	{21164, 0x1FFFE000},
	{67211, 0xE0000000, 6, 2828},
	/* 4749 */
	{67222, 0x1FFF},
	{67233, 0x1E000},
	{114763, 0x1FE0000},
	{90793, 0x2000000},
	{67399, 0x4000000},
	{114781, 0x8000000},
	{67245, 0xF0000000},
	/* 4756 */
	{65068, 0x3FFF},
	{65112, 0xFC000},
	{65125, 0x300000, 4, 36874},
	{65139, 0xC00000, 4, 36874},
	{65153, 0x3000000, 3, 36878},
	{65162, 0xC000000, 4, 36988},
	{65173, 0x10000000},
	{65207, 0x20000000},
	{111571, 0x40000000},
	{65192, 0x80000000},
	/* 4766 */
	{65077, 0xFFF},
	{65023, 0x1000},
	{65094, 0xC0000000, 4, 36884},
	/* 4769 */
	{65408, 0x7},
	{65418, 0x38},
	{65439, 0xC0},
	{111729, 0x700},
	{67057, 0x7000, 4, 2824},
	{111750, 0x70000},
	{65460, 0x180000},
	{111774, 0xE00000},
	{111783, 0x3000000},
	{65479, 0xC000000},
	{111803, 0x30000000},
	{111812, 0x40000000},
	{114797, 0x80000000},
	/* 4782 */
	{67507, 0xFFFF},
	{67513, 0x3F0000},
	{67524, 0x3C00000},
	{114807, 0x3C000000},
	/* 4786 */
	{67552, 0x3F},
	{67558, 0x3C0},
	{65248, 0xC00},
	{67607, 0xFF000, 241, 2834},
	{55319, 0x100000},
	{55112, 0x200000},
	{111878, 0x400000},
	{67618, 0x800000},
	{67628, 0x1000000},
	{111899, 0x10000000},
	{55263, 0x20000000},
	/* 4797 */
	{67657, 0x1},
	{67668, 0x3E},
	{67678, 0x40},
	{67691, 0x80},
	{67703, 0xFF00},
	{55255, 0x1FF0000, 257, 0},
	{67718, 0x2000000},
	{67740, 0x4000000},
	{68270, 0x8000000},
	{67765, 0x10000000},
	/* 4807 */
	{67552, 0x3F},
	{67558, 0x3C0},
	{65248, 0xC00},
	{67607, 0xFF000, 241, 2834},
	{55319, 0x100000},
	{55112, 0x200000},
	{111878, 0x400000},
	{67618, 0x800000},
	{68148, 0x3000000},
	{68162, 0x4000000},
	{111899, 0x40000000},
	{55263, 0x80000000},
	/* 4819 */
	{67657, 0x1},
	{67668, 0x3E},
	{67678, 0x40},
	{68178, 0x80},
	{68188, 0x100},
	{68200, 0x200},
	{68212, 0x400},
	{68224, 0x800},
	{68236, 0x1000},
	{55255, 0x3FE000, 257, 0},
	{68242, 0x400000},
	{68253, 0x1000000},
	{68270, 0x8000000},
	{67765, 0x10000000},
	/* 4833 */
	{68307, 0x7F},
	{68282, 0x3F80},
	/* 4835 */
	{67552, 0x3F},
	{67558, 0x3C0},
	{65248, 0xC00},
	{67607, 0xFF000, 241, 2834},
	{55319, 0x100000},
	{55112, 0x200000},
	{111878, 0x400000},
	{67618, 0x800000},
	{68162, 0x1000000},
	{111899, 0x10000000},
	{68333, 0x60000000},
	{55263, 0x80000000},
	/* 4847 */
	{67657, 0x1},
	{67668, 0x3E},
	{67678, 0x40},
	{55255, 0xFF80, 257, 0},
	{68350, 0x30000},
	{68178, 0x40000},
	{55688, 0x7F80000},
	{68270, 0x8000000},
	{67765, 0x10000000},
	/* 4856 */
	{67513, 0x3F},
	{67524, 0x3C0},
	{114807, 0x3C00},
	{67507, 0xFFFF0000},
	/* 4860 */
	{67552, 0x3F},
	{67558, 0x3C0},
	{65248, 0xC00},
	{67607, 0xFF000, 241, 2834},
	{55319, 0x100000},
	{55112, 0x200000},
	{111878, 0x400000},
	{67618, 0x800000},
	{111899, 0x8000000},
	{68367, 0x30000000},
	{55263, 0x40000000},
	/* 4871 */
	{67657, 0x1},
	{67668, 0x3E},
	{67678, 0x40},
	{55255, 0xFF80, 257, 0},
	{55688, 0x1FF0000},
	{68270, 0x8000000},
	{67765, 0x10000000},
	/* 4878 */
	{68395, 0x1},
	{68413, 0x2},
	{68427, 0x4},
	{68446, 0x8},
	{68466, 0x10},
	{68486, 0x20},
	{68508, 0x40},
	{68519, 0x400},
	{68537, 0x800},
	{10365, 0x1000},
	{68569, 0x4000},
	/* 4889 */
	{67552, 0x3F},
	{67558, 0x3C0},
	{65248, 0xC00},
	{67607, 0xFF000, 241, 2834},
	{55319, 0x100000},
	{55112, 0x200000},
	{111878, 0x400000},
	{67618, 0x800000},
	{68622, 0x1000000},
	{111899, 0x2000000},
	{55263, 0x4000000},
	/* 4900 */
	{67657, 0x1},
	{67668, 0x3E},
	{67678, 0x40},
	{68628, 0x80},
	{68638, 0x100},
	{68648, 0x200},
	{68384, 0x400},
	{68658, 0x1800},
	{68673, 0x6000},
	{55688, 0xFF8000},
	{55255, 0x7F000000, 257, 0},
	{68270, 0x80000000},
	/* 4912 */
	{68685, 0x3FF},
	{68698, 0xF000},
	{68708, 0x3F0000},
	{68723, 0x400000},
	{68738, 0x800000},
	{68754, 0x7000000},
	{114807, 0x78000000},
	/* 4919 */
	{69289, 0x7FF},
	{69316, 0xFFE000},
	{69326, 0x1000000},
	{69338, 0x2000000},
	{69356, 0x3C000000},
	/* 4924 */
	{17302, 0x3, 4, 3099},
	{70621, 0xC},
	{67107, 0x1F0},
	{70705, 0x1000},
	{70676, 0x6000, 4, 3103},
	{70691, 0x8000},
	{70741, 0xF0000},
	{70748, 0x7800000},
	{70772, 0x8000000},
	{70787, 0x10000000},
	{70797, 0x20000000},
	{113210, 0x40000000},
	{70817, 0x80000000},
	/* 4937 */
	{17302, 0x1, 2, 3107},
	{67107, 0x1F0},
	{70705, 0x1000},
	{70676, 0x6000, 4, 3103},
	{70691, 0x8000},
	{70772, 0x8000000},
	{70860, 0x20000000},
	{113210, 0x40000000},
	/* 4945 */
	{54735, 0xFFFF},
	/* 4946 */
	{71690, 0x3, 4, 35886},
	{71702, 0xC, 4, 35886},
	{71814, 0x30, 4, 35890},
	{71871, 0x40, 2, 35894},
	{71927, 0x80, 2, 35896},
	{72031, 0x300, 4, 35898},
	{72139, 0xC00, 4, 35902},
	{72248, 0x3000, 4, 35906},
	{72361, 0xC000, 4, 35910},
	{72463, 0x30000, 4, 35914},
	{72609, 0xC0000, 4, 35918},
	{72756, 0x300000, 4, 35922},
	{72856, 0x3000000, 4, 35926},
	{73002, 0x1C000000, 5, 37282},
	{73149, 0xE0000000, 5, 37287},
	/* 4961 */
	{73269, 0x3, 4, 35938},
	{73440, 0x1C, 5, 37292},
	{73612, 0xE0, 5, 37297},
	/* 4964 */
	{73949, 0x1},
	{113227, 0x2},
	{73976, 0x7C},
	{74005, 0x100},
	{74034, 0x200},
	{74065, 0x400},
	{74093, 0x1000},
	{74121, 0x2000},
	{74151, 0x4000},
	/* 4973 */
	{80611, 0x1},
	{80627, 0x2},
	{80643, 0x4},
	{80659, 0x8},
	{80675, 0x10},
	{80691, 0x20},
	{80707, 0x40},
	{80723, 0x80},
	{80739, 0x100},
	{80755, 0x200},
	{80771, 0x400},
	{80787, 0x800},
	{80803, 0x1000},
	{80819, 0x2000},
	{80835, 0x4000},
	{80851, 0x8000},
	{80867, 0x10000},
	{80886, 0x20000},
	{80904, 0x40000},
	{80931, 0x80000},
	{80953, 0x100000},
	{80971, 0x200000},
	{80991, 0x400000},
	{81014, 0x800000},
	{81037, 0x1000000},
	{81062, 0x2000000},
	{81105, 0x4000000},
	{81082, 0x8000000},
	/* 5001 */
	{81711, 0x1},
	{81483, 0x2},
	{81507, 0x4},
	{81527, 0x8},
	{81548, 0x10},
	{81749, 0x40},
	/* 5007 */
	{81778, 0x1},
	{81789, 0x2},
	{114974, 0x4},
	/* 5010 */
	{92556, 0x1},
	{81959, 0x1E},
	{81971, 0xE0},
	{81985, 0x300},
	{82001, 0x1C00},
	{82012, 0x1E000},
	/* 5016 */
	{203, 0x3, 3, 36374},
	{83800, 0xC, 4, 36377},
	{83880, 0x30, 4, 36381},
	{83940, 0x40, 2, 36385},
	{85990, 0x100},
	{78307, 0x200},
	{83957, 0x400},
	/* 5023 */
	{85176, 0x3F, 64, 37302},
	{60395, 0x7FFFC00},
	{85187, 0x8000000},
	/* 5026 */
	{54854, 0xFFFF},
	/* 5027 */
	{85217, 0x1},
	{85231, 0x2},
	{115037, 0x4},
	{85247, 0x8},
	/* 5031 */
	{85390, 0x2},
	{112522, 0x4},
	{112545, 0x8},
	{112553, 0x3F0},
	{112568, 0xFC00},
	{85469, 0x10000},
	{67404, 0x40000},
	{114786, 0x80000},
	/* 5039 */
	{85741, 0x3, 4, 36452},
	{85772, 0x4, 2, 36456},
	{19758, 0x18, 4, 36458},
	{85854, 0x20, 2, 36462},
	{85919, 0xC0, 4, 36464},
	{68253, 0x200},
	{85936, 0x400},
	{85956, 0x800},
	{85976, 0x1000},
	{85990, 0x2000},
	{86001, 0x4000},
	{86017, 0x78000},
	{86037, 0x180000},
	/* 5052 */
	{209, 0x3, 3, 36468},
	{86251, 0x1C, 4, 36471},
	{86328, 0xE0, 4, 36475},
	{86337, 0x100},
	{86357, 0x200},
	{86390, 0x4000},
	{83940, 0x8000, 2, 36385},
	{86424, 0x60000, 4, 36479},
	/* 5060 */
	{88079, 0x3, 4, 36505},
	{88092, 0x4},
	{88103, 0x8},
	{88212, 0x70},
	{88230, 0x380},
	{88248, 0x1C00},
	{88271, 0x3E000},
	{88297, 0x40000},
	{88319, 0x7F80000},
	{88335, 0x8000000},
	{88357, 0x10000000},
	/* 5071 */
	{88496, 0x1},
	{88513, 0x1E},
	{88537, 0x20},
	{88555, 0x3C0},
	{88580, 0x400},
	{88610, 0x800},
	{88625, 0x1000},
	{88640, 0x2000},
	{88675, 0x4000},
	{88711, 0x8000},
	{88801, 0x30000},
	{88825, 0x40000},
	{88861, 0x80000},
	{88897, 0x100000},
	{88923, 0x200000},
	{88947, 0x400000},
	{88967, 0x800000},
	{88988, 0x1000000},
	/* 5089 */
	{69289, 0x7FF},
	{69316, 0xFFE000},
	{89157, 0xF000000},
	/* 5092 */
	{89218, 0x3, 4, 36520},
	{17302, 0x7C, 32, 36524},
	{89816, 0x700, 8, 36556},
	{89872, 0x1800, 4, 36564},
	{78915, 0x2000},
	{69909, 0x4000},
	{89882, 0x8000},
	{89894, 0x10000},
	{89907, 0x20000},
	{87486, 0x40000},
	{90147, 0x700000, 8, 36568},
	{90169, 0x3800000, 8, 36568},
	{90193, 0x4000000},
	{90219, 0x8000000},
	{90245, 0x10000000},
	{90313, 0x60000000, 3, 36576},
	/* 5108 */
	{90782, 0x7FF},
	{90793, 0x800},
	{70621, 0x7000},
	{90399, 0x18000},
	{90413, 0x20000},
	{90805, 0x7C0000},
	{90819, 0xF800000},
	{90833, 0x30000000},
	{114786, 0x40000000},
	{67404, 0x80000000},
	/* 5118 */
	{90971, 0xFFFF},
	{90983, 0x10000},
	{90899, 0x2000000},
	{26653, 0xE0000000},
	/* 5122 */
	{26221, 0xFFFF},
	{90899, 0x400000},
	/* 5124 */
	{26293, 0xFFFF},
	{90899, 0x400000},
	/* 5126 */
	{91066, 0x400},
	{91079, 0x2000},
	{91108, 0x300000},
	{91119, 0x2000000},
	{91148, 0x60000000},
	/* 5131 */
	{91493, 0x1},
	{91527, 0x30},
	{91539, 0xF0000},
	{91552, 0x10000000},
	{91567, 0x20000000},
	{91581, 0xC0000000},
	/* 5137 */
	{112812, 0x7F},
	{112824, 0x3F000},
	{90899, 0x2000000},
	{91775, 0x10000000},
	/* 5141 */
	{92205, 0xF},
	{92217, 0xF0},
	{100091, 0xF00},
	{115056, 0xF000},
	{92245, 0x30000},
	{92255, 0xC0000},
	{9882, 0x100000},
	{10365, 0xFFE00000},
	/* 5149 */
	{203, 0x3, 3, 36374},
	{85990, 0x100},
	/* 5151 */
	{107399, 0x7},
	{107407, 0x38},
	{107415, 0x1C0},
	{107423, 0xE00},
	{107431, 0x7000},
	{107439, 0x38000},
	{107447, 0x1C0000},
	{982, 0x600000},
	{107455, 0x1800000},
	{107468, 0x2000000},
	{115065, 0x4000000},
	{107481, 0x18000000},
	{107492, 0x20000000},
	{60055, 0x40000000},
	{65006, 0x80000000},
	/* 5166 */
	{60234, 0x3FF},
	{60249, 0x3FF0000},
	{96859, 0x10000000},
	{107391, 0x20000000},
	{56272, 0x40000000},
	{68598, 0x80000000},
	/* 5172 */
	{80899, 0x1},
	{858, 0x1FFE},
	{209, 0x2000},
	{88780, 0x4000},
	{92802, 0x8000},
	{92814, 0xFFF0000},
	{92825, 0x10000000},
	{92836, 0x20000000},
	{92846, 0x40000000},
	{92780, 0x80000000},
	/* 5182 */
	{115076, 0xF},
	{115091, 0x10},
	{115115, 0x20},
	{115135, 0x40},
	{115151, 0x80},
	{115167, 0x100},
	{115193, 0x200},
	{115210, 0x3C00},
	{115226, 0x4000},
	{115247, 0x8000},
	{115268, 0xFFFF0000},
	/* 5193 */
	{115282, 0xF},
	{115323, 0xF0},
	/* 5195 */
	{115362, 0x3},
	{115375, 0xC},
	{115388, 0x30},
	{115401, 0xC0},
	/* 5199 */
	{115414, 0x3FF},
	{115424, 0xFFC00},
	{92927, 0xF00000},
	{92936, 0xF000000},
	{92947, 0xF0000000},
	/* 5204 */
	{115434, 0x3FF},
	{115444, 0xFFC00},
	{92978, 0xF000000},
	{92989, 0xF0000000},
	/* 5208 */
	{441, 0x7},
	{11232, 0x40000000},
	{9882, 0x80000000},
	/* 5211 */
	{92908, 0x3F},
	{93736, 0x400},
	{93763, 0x800},
	{100736, 0x1000},
	{93790, 0x2000},
	{93816, 0x4000},
	{93842, 0x10000},
	{93869, 0x20000},
	{93895, 0x40000},
	{93921, 0x80000},
	{93949, 0x100000},
	{93975, 0x200000},
	{94001, 0x400000},
	{100763, 0x800000},
	{94027, 0x1000000},
	{94054, 0x2000000},
	{94081, 0x4000000},
	{100789, 0x8000000},
	{100815, 0x10000000},
	{94161, 0x20000000},
	{94190, 0x40000000},
	{94216, 0x80000000},
	/* 5233 */
	{92908, 0x3F},
	{93736, 0x400},
	{93763, 0x800},
	{93790, 0x1000},
	{93816, 0x2000},
	{93842, 0x8000},
	{93869, 0x10000},
	{93949, 0x20000},
	{93975, 0x40000},
	{100736, 0x80000},
	{93895, 0x100000},
	{94054, 0x200000},
	{94216, 0x400000},
	/* 5246 */
	{115454, 0xFF},
	{10365, 0xFFFFFF00},
};

static const char sid_strings[] = {
	'N', 'O', 'P', '\0', /* NOP (0, 1) */
	'S', 'E', 'T', '_', 'B', 'A', 'S', 'E', '\0', /* SET_BASE (4, 8) */
	'C', 'L', 'E', 'A', 'R', '_', 'S', 'T', 'A', 'T', 'E', '\0', /* CLEAR_STATE (13) */
	'I', 'N', 'D', 'E', 'X', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'S', 'I', 'Z', 'E', '\0', /* INDEX_BUFFER_SIZE (25, 38) */
	'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'D', 'I', 'R', 'E', 'C', 'T', '\0', /* DISPATCH_DIRECT (43) */
	'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '\0', /* DISPATCH_INDIRECT (59) */
	'O', 'C', 'C', 'L', 'U', 'S', 'I', 'O', 'N', '_', 'Q', 'U', 'E', 'R', 'Y', '\0', /* OCCLUSION_QUERY (77, 91) */
	'S', 'E', 'T', '_', 'P', 'R', 'E', 'D', 'I', 'C', 'A', 'T', 'I', 'O', 'N', '\0', /* SET_PREDICATION (93) */
	'C', 'O', 'N', 'D', '_', 'E', 'X', 'E', 'C', '\0', /* COND_EXEC (109) */
	'P', 'R', 'E', 'D', '_', 'E', 'X', 'E', 'C', '\0', /* PRED_EXEC (119) */
	'D', 'R', 'A', 'W', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '\0', /* DRAW_INDIRECT (129) */
	'D', 'R', 'A', 'W', '_', 'I', 'N', 'D', 'E', 'X', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '\0', /* DRAW_INDEX_INDIRECT (143) */
	'I', 'N', 'D', 'E', 'X', '_', 'B', 'A', 'S', 'E', '\0', /* INDEX_BASE (163) */
	'D', 'R', 'A', 'W', '_', 'I', 'N', 'D', 'E', 'X', '_', '2', '\0', /* DRAW_INDEX_2 (174) */
	'C', 'O', 'N', 'T', 'E', 'X', 'T', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CONTEXT_CONTROL (187, 195) */
	'I', 'N', 'D', 'E', 'X', '_', 'T', 'Y', 'P', 'E', '\0', /* INDEX_TYPE (203, 209) */
	'D', 'R', 'A', 'W', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '_', 'M', 'U', 'L', 'T', 'I', '\0', /* DRAW_INDIRECT_MULTI (214) */
	'D', 'R', 'A', 'W', '_', 'I', 'N', 'D', 'E', 'X', '_', 'A', 'U', 'T', 'O', '\0', /* DRAW_INDEX_AUTO (234, 245) */
	'D', 'R', 'A', 'W', '_', 'I', 'N', 'D', 'E', 'X', '_', 'I', 'M', 'M', 'D', '\0', /* DRAW_INDEX_IMMD (250) */
	'N', 'U', 'M', '_', 'I', 'N', 'S', 'T', 'A', 'N', 'C', 'E', 'S', '\0', /* NUM_INSTANCES (266) */
	'D', 'R', 'A', 'W', '_', 'I', 'N', 'D', 'E', 'X', '_', 'M', 'U', 'L', 'T', 'I', '_', 'A', 'U', 'T', 'O', '\0', /* DRAW_INDEX_MULTI_AUTO (280) */
	'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'S', 'I', '\0', /* INDIRECT_BUFFER_SI (302) */
	'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'C', 'O', 'N', 'S', 'T', '\0', /* INDIRECT_BUFFER_CONST (321) */
	'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'U', 'P', 'D', 'A', 'T', 'E', '\0', /* STRMOUT_BUFFER_UPDATE (343) */
	'D', 'R', 'A', 'W', '_', 'I', 'N', 'D', 'E', 'X', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', '2', '\0', /* DRAW_INDEX_OFFSET_2 (365) */
	'W', 'R', 'I', 'T', 'E', '_', 'D', 'A', 'T', 'A', '\0', /* WRITE_DATA (385, 391) */
	'D', 'R', 'A', 'W', '_', 'I', 'N', 'D', 'E', 'X', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '_', 'M', 'U', 'L', 'T', 'I', '\0', /* DRAW_INDEX_INDIRECT_MULTI (396) */
	'M', 'E', 'M', '_', 'S', 'E', 'M', 'A', 'P', 'H', 'O', 'R', 'E', '\0', /* MEM_SEMAPHORE (422) */
	'M', 'P', 'E', 'G', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* MPEG_INDEX (436, 441, 445) */
	'W', 'A', 'I', 'T', '_', 'R', 'E', 'G', '_', 'M', 'E', 'M', '\0', /* WAIT_REG_MEM (447, 456) */
	'M', 'E', 'M', '_', 'W', 'R', 'I', 'T', 'E', '\0', /* MEM_WRITE (460) */
	'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'C', 'I', 'K', '\0', /* INDIRECT_BUFFER_CIK (470) */
	'C', 'O', 'P', 'Y', '_', 'D', 'A', 'T', 'A', '\0', /* COPY_DATA (490) */
	'P', 'F', 'P', '_', 'S', 'Y', 'N', 'C', '_', 'M', 'E', '\0', /* PFP_SYNC_ME (500, 509) */
	'S', 'U', 'R', 'F', 'A', 'C', 'E', '_', 'S', 'Y', 'N', 'C', '\0', /* SURFACE_SYNC (512) */
	'M', 'E', '_', 'I', 'N', 'I', 'T', 'I', 'A', 'L', 'I', 'Z', 'E', '\0', /* ME_INITIALIZE (525) */
	'C', 'O', 'N', 'D', '_', 'W', 'R', 'I', 'T', 'E', '\0', /* COND_WRITE (539) */
	'E', 'V', 'E', 'N', 'T', '_', 'W', 'R', 'I', 'T', 'E', '\0', /* EVENT_WRITE (550) */
	'E', 'V', 'E', 'N', 'T', '_', 'W', 'R', 'I', 'T', 'E', '_', 'E', 'O', 'P', '\0', /* EVENT_WRITE_EOP (562) */
	'E', 'V', 'E', 'N', 'T', '_', 'W', 'R', 'I', 'T', 'E', '_', 'E', 'O', 'S', '\0', /* EVENT_WRITE_EOS (578) */
	'R', 'E', 'L', 'E', 'A', 'S', 'E', '_', 'M', 'E', 'M', '\0', /* RELEASE_MEM (594) */
	'C', 'O', 'N', 'T', 'E', 'X', 'T', '_', 'R', 'E', 'G', '_', 'R', 'M', 'W', '\0', /* CONTEXT_REG_RMW (606) */
	'O', 'N', 'E', '_', 'R', 'E', 'G', '_', 'W', 'R', 'I', 'T', 'E', '\0', /* ONE_REG_WRITE (622) */
	'A', 'C', 'Q', 'U', 'I', 'R', 'E', '_', 'M', 'E', 'M', '\0', /* ACQUIRE_MEM (636) */
	'R', 'E', 'W', 'I', 'N', 'D', '\0', /* REWIND (648) */
	'L', 'O', 'A', 'D', '_', 'U', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'E', 'G', '\0', /* LOAD_UCONFIG_REG (655) */
	'L', 'O', 'A', 'D', '_', 'S', 'H', '_', 'R', 'E', 'G', '\0', /* LOAD_SH_REG (672) */
	'L', 'O', 'A', 'D', '_', 'C', 'O', 'N', 'T', 'E', 'X', 'T', '_', 'R', 'E', 'G', '\0', /* LOAD_CONTEXT_REG (684) */
	'S', 'E', 'T', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'E', 'G', '\0', /* SET_CONFIG_REG (701) */
	'S', 'E', 'T', '_', 'C', 'O', 'N', 'T', 'E', 'X', 'T', '_', 'R', 'E', 'G', '\0', /* SET_CONTEXT_REG (716) */
	'S', 'E', 'T', '_', 'S', 'H', '_', 'R', 'E', 'G', '\0', /* SET_SH_REG (732) */
	'S', 'E', 'T', '_', 'S', 'H', '_', 'R', 'E', 'G', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* SET_SH_REG_OFFSET (743, 754) */
	'S', 'E', 'T', '_', 'U', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'E', 'G', '\0', /* SET_UCONFIG_REG (761) */
	'S', 'E', 'T', '_', 'U', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'E', 'G', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* SET_UCONFIG_REG_INDEX (777) */
	'L', 'O', 'A', 'D', '_', 'C', 'O', 'N', 'S', 'T', '_', 'R', 'A', 'M', '\0', /* LOAD_CONST_RAM (799) */
	'W', 'R', 'I', 'T', 'E', '_', 'C', 'O', 'N', 'S', 'T', '_', 'R', 'A', 'M', '\0', /* WRITE_CONST_RAM (814) */
	'D', 'U', 'M', 'P', '_', 'C', 'O', 'N', 'S', 'T', '_', 'R', 'A', 'M', '\0', /* DUMP_CONST_RAM (830) */
	'I', 'N', 'C', 'R', 'E', 'M', 'E', 'N', 'T', '_', 'C', 'E', '_', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '\0', /* INCREMENT_CE_COUNTER (845, 858) */
	'I', 'N', 'C', 'R', 'E', 'M', 'E', 'N', 'T', '_', 'D', 'E', '_', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '\0', /* INCREMENT_DE_COUNTER (866) */
	'W', 'A', 'I', 'T', '_', 'O', 'N', '_', 'C', 'E', '_', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '\0', /* WAIT_ON_CE_COUNTER (887) */
	'S', 'E', 'T', '_', 'S', 'H', '_', 'R', 'E', 'G', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* SET_SH_REG_INDEX (906) */
	'L', 'O', 'A', 'D', '_', 'C', 'O', 'N', 'T', 'E', 'X', 'T', '_', 'R', 'E', 'G', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* LOAD_CONTEXT_REG_INDEX (923) */
	'I', 'T', '_', 'O', 'P', 'C', 'O', 'D', 'E', '_', 'C', '\0', /* IT_OPCODE_C (946) */
	'C', 'P', '_', 'D', 'M', 'A', '\0', /* CP_DMA (958) */
	'D', 'M', 'A', '_', 'D', 'A', 'T', 'A', '\0', /* DMA_DATA (965) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'M', 'O', 'D', 'E', '\0', /* SQ_WAVE_MODE (974, 982, 984) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* SQ_WAVE_STATUS (987, 995) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'R', 'A', 'P', 'S', 'T', 'S', '\0', /* SQ_WAVE_TRAPSTS (1002) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'H', 'W', '_', 'I', 'D', '_', 'L', 'E', 'G', 'A', 'C', 'Y', '\0', /* SQ_WAVE_HW_ID_LEGACY (1018) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'G', 'P', 'R', '_', 'A', 'L', 'L', 'O', 'C', '\0', /* SQ_WAVE_GPR_ALLOC (1039) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'L', 'D', 'S', '_', 'A', 'L', 'L', 'O', 'C', '\0', /* SQ_WAVE_LDS_ALLOC (1057) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'I', 'B', '_', 'S', 'T', 'S', '\0', /* SQ_WAVE_IB_STS (1075) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'P', 'C', '_', 'L', 'O', '\0', /* SQ_WAVE_PC_LO (1090) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'P', 'C', '_', 'H', 'I', '\0', /* SQ_WAVE_PC_HI (1104, 1112) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'I', 'N', 'S', 'T', '_', 'D', 'W', '0', '\0', /* SQ_WAVE_INST_DW0 (1118) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'I', 'B', '_', 'D', 'B', 'G', '1', '\0', /* SQ_WAVE_IB_DBG1 (1135) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'F', 'L', 'U', 'S', 'H', '_', 'I', 'B', '\0', /* SQ_WAVE_FLUSH_IB (1151) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'H', 'W', '_', 'I', 'D', '1', '\0', /* SQ_WAVE_HW_ID1 (1168) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'H', 'W', '_', 'I', 'D', '2', '\0', /* SQ_WAVE_HW_ID2 (1183) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'P', 'O', 'P', 'S', '_', 'P', 'A', 'C', 'K', 'E', 'R', '\0', /* SQ_WAVE_POPS_PACKER (1198) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'S', 'C', 'H', 'E', 'D', '_', 'M', 'O', 'D', 'E', '\0', /* SQ_WAVE_SCHED_MODE (1218) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'V', 'G', 'P', 'R', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* SQ_WAVE_VGPR_OFFSET (1237) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'I', 'B', '_', 'S', 'T', 'S', '2', '\0', /* SQ_WAVE_IB_STS2 (1257) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '0', '\0', /* SQ_WAVE_TTMP0 (1273) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '1', '\0', /* SQ_WAVE_TTMP1 (1287) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '2', '\0', /* SQ_WAVE_TTMP2 (1301) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '3', '\0', /* SQ_WAVE_TTMP3 (1315) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '4', '\0', /* SQ_WAVE_TTMP4 (1329) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '5', '\0', /* SQ_WAVE_TTMP5 (1343) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '6', '\0', /* SQ_WAVE_TTMP6 (1357) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '7', '\0', /* SQ_WAVE_TTMP7 (1371) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '8', '\0', /* SQ_WAVE_TTMP8 (1385) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '9', '\0', /* SQ_WAVE_TTMP9 (1399) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '1', '0', '\0', /* SQ_WAVE_TTMP10 (1413) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '1', '1', '\0', /* SQ_WAVE_TTMP11 (1428) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '1', '2', '\0', /* SQ_WAVE_TTMP12 (1443) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '1', '3', '\0', /* SQ_WAVE_TTMP13 (1458) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '1', '4', '\0', /* SQ_WAVE_TTMP14 (1473) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '1', '5', '\0', /* SQ_WAVE_TTMP15 (1488) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'M', '0', '\0', /* SQ_WAVE_M0 (1503) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'E', 'X', 'E', 'C', '_', 'L', 'O', '\0', /* SQ_WAVE_EXEC_LO (1514) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'E', 'X', 'E', 'C', '_', 'H', 'I', '\0', /* SQ_WAVE_EXEC_HI (1530) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'F', 'L', 'A', 'T', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'L', 'O', '\0', /* SQ_WAVE_FLAT_SCRATCH_LO (1546) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'F', 'L', 'A', 'T', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'H', 'I', '\0', /* SQ_WAVE_FLAT_SCRATCH_HI (1570) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'F', 'L', 'A', 'T', '_', 'X', 'N', 'A', 'C', 'K', '_', 'M', 'A', 'S', 'K', '\0', /* SQ_WAVE_FLAT_XNACK_MASK (1594) */
	'G', 'R', 'B', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '2', '\0', /* GRBM_STATUS2 (1618) */
	'G', 'R', 'B', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* GRBM_STATUS (1631) */
	'G', 'R', 'B', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '_', 'S', 'E', '0', '\0', /* GRBM_STATUS_SE0 (1643) */
	'G', 'R', 'B', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '_', 'S', 'E', '1', '\0', /* GRBM_STATUS_SE1 (1659) */
	'G', 'R', 'B', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '3', '\0', /* GRBM_STATUS3 (1675) */
	'G', 'R', 'B', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '_', 'S', 'E', '2', '\0', /* GRBM_STATUS_SE2 (1688) */
	'G', 'R', 'B', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '_', 'S', 'E', '3', '\0', /* GRBM_STATUS_SE3 (1704) */
	'C', 'P', '_', 'C', 'P', 'C', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* CP_CPC_STATUS (1720) */
	'C', 'P', '_', 'C', 'P', 'C', '_', 'B', 'U', 'S', 'Y', '_', 'S', 'T', 'A', 'T', '\0', /* CP_CPC_BUSY_STAT (1734) */
	'C', 'P', '_', 'C', 'P', 'C', '_', 'S', 'T', 'A', 'L', 'L', 'E', 'D', '_', 'S', 'T', 'A', 'T', '1', '\0', /* CP_CPC_STALLED_STAT1 (1751) */
	'C', 'P', '_', 'C', 'P', 'F', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* CP_CPF_STATUS (1772) */
	'C', 'P', '_', 'C', 'P', 'F', '_', 'B', 'U', 'S', 'Y', '_', 'S', 'T', 'A', 'T', '\0', /* CP_CPF_BUSY_STAT (1786) */
	'C', 'P', '_', 'C', 'P', 'F', '_', 'S', 'T', 'A', 'L', 'L', 'E', 'D', '_', 'S', 'T', 'A', 'T', '1', '\0', /* CP_CPF_STALLED_STAT1 (1803) */
	'C', 'P', '_', 'C', 'P', 'C', '_', 'B', 'U', 'S', 'Y', '_', 'S', 'T', 'A', 'T', '2', '\0', /* CP_CPC_BUSY_STAT2 (1824) */
	'C', 'P', '_', 'C', 'P', 'C', '_', 'G', 'R', 'B', 'M', '_', 'F', 'R', 'E', 'E', '_', 'C', 'O', 'U', 'N', 'T', '\0', /* CP_CPC_GRBM_FREE_COUNT (1842, 1854, 1859) */
	'C', 'P', '_', 'C', 'P', 'C', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* CP_CPC_SCRATCH_INDEX (1865, 1872) */
	'C', 'P', '_', 'C', 'P', 'C', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'D', 'A', 'T', 'A', '\0', /* CP_CPC_SCRATCH_DATA (1886) */
	'C', 'P', '_', 'C', 'P', 'F', '_', 'G', 'R', 'B', 'M', '_', 'F', 'R', 'E', 'E', '_', 'C', 'O', 'U', 'N', 'T', '\0', /* CP_CPF_GRBM_FREE_COUNT (1906) */
	'C', 'P', '_', 'C', 'P', 'F', '_', 'B', 'U', 'S', 'Y', '_', 'S', 'T', 'A', 'T', '2', '\0', /* CP_CPF_BUSY_STAT2 (1929) */
	'C', 'P', '_', 'C', 'P', 'C', '_', 'H', 'A', 'L', 'T', '_', 'H', 'Y', 'S', 'T', '_', 'C', 'O', 'U', 'N', 'T', '\0', /* CP_CPC_HALT_HYST_COUNT (1947) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'B', 'U', 'F', '0', '_', 'B', 'A', 'S', 'E', '\0', /* SQ_THREAD_TRACE_BUF0_BASE (1970) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'B', 'U', 'F', '0', '_', 'S', 'I', 'Z', 'E', '\0', /* SQ_THREAD_TRACE_BUF0_SIZE (1996) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'B', 'U', 'F', '1', '_', 'B', 'A', 'S', 'E', '\0', /* SQ_THREAD_TRACE_BUF1_BASE (2022) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'B', 'U', 'F', '1', '_', 'S', 'I', 'Z', 'E', '\0', /* SQ_THREAD_TRACE_BUF1_SIZE (2048) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'W', 'P', 'T', 'R', '\0', /* SQ_THREAD_TRACE_WPTR (2074, 2090) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'M', 'A', 'S', 'K', '\0', /* SQ_THREAD_TRACE_MASK (2095) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'T', 'O', 'K', 'E', 'N', '_', 'M', 'A', 'S', 'K', '\0', /* SQ_THREAD_TRACE_TOKEN_MASK (2116, 2132) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'C', 'T', 'R', 'L', '\0', /* SQ_THREAD_TRACE_CTRL (2143) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* SQ_THREAD_TRACE_STATUS (2164) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'D', 'R', 'O', 'P', 'P', 'E', 'D', '_', 'C', 'N', 'T', 'R', '\0', /* SQ_THREAD_TRACE_DROPPED_CNTR (2187) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'G', 'F', 'X', '_', 'D', 'R', 'A', 'W', '_', 'C', 'N', 'T', 'R', '\0', /* SQ_THREAD_TRACE_GFX_DRAW_CNTR (2216) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'G', 'F', 'X', '_', 'M', 'A', 'R', 'K', 'E', 'R', '_', 'C', 'N', 'T', 'R', '\0', /* SQ_THREAD_TRACE_GFX_MARKER_CNTR (2246) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'H', 'P', '3', 'D', '_', 'D', 'R', 'A', 'W', '_', 'C', 'N', 'T', 'R', '\0', /* SQ_THREAD_TRACE_HP3D_DRAW_CNTR (2278) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'H', 'P', '3', 'D', '_', 'M', 'A', 'R', 'K', 'E', 'R', '_', 'C', 'N', 'T', 'R', '\0', /* SQ_THREAD_TRACE_HP3D_MARKER_CNTR (2309) */
	'S', 'Q', '_', 'E', 'X', 'P', '_', '0', '\0', /* SQ_EXP_0 (2342) */
	'S', 'Q', '_', 'B', 'U', 'F', '_', 'R', 'S', 'R', 'C', '_', 'W', 'O', 'R', 'D', '0', '\0', /* SQ_BUF_RSRC_WORD0 (2351) */
	'S', 'Q', '_', 'B', 'U', 'F', '_', 'R', 'S', 'R', 'C', '_', 'W', 'O', 'R', 'D', '1', '\0', /* SQ_BUF_RSRC_WORD1 (2369) */
	'S', 'Q', '_', 'B', 'U', 'F', '_', 'R', 'S', 'R', 'C', '_', 'W', 'O', 'R', 'D', '2', '\0', /* SQ_BUF_RSRC_WORD2 (2387) */
	'S', 'Q', '_', 'B', 'U', 'F', '_', 'R', 'S', 'R', 'C', '_', 'W', 'O', 'R', 'D', '3', '\0', /* SQ_BUF_RSRC_WORD3 (2405) */
	'S', 'Q', '_', 'I', 'M', 'G', '_', 'S', 'A', 'M', 'P', '_', 'W', 'O', 'R', 'D', '0', '\0', /* SQ_IMG_SAMP_WORD0 (2423) */
	'S', 'Q', '_', 'I', 'M', 'G', '_', 'S', 'A', 'M', 'P', '_', 'W', 'O', 'R', 'D', '1', '\0', /* SQ_IMG_SAMP_WORD1 (2441) */
	'S', 'Q', '_', 'I', 'M', 'G', '_', 'S', 'A', 'M', 'P', '_', 'W', 'O', 'R', 'D', '2', '\0', /* SQ_IMG_SAMP_WORD2 (2459) */
	'S', 'Q', '_', 'I', 'M', 'G', '_', 'S', 'A', 'M', 'P', '_', 'W', 'O', 'R', 'D', '3', '\0', /* SQ_IMG_SAMP_WORD3 (2477) */
	'S', 'P', 'I', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'C', 'N', 'T', 'L', '\0', /* SPI_CONFIG_CNTL (2495) */
	'G', 'B', '_', 'A', 'D', 'D', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* GB_ADDR_CONFIG (2511) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '0', '\0', /* GB_TILE_MODE0 (2526) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '\0', /* GB_TILE_MODE1 (2540) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '2', '\0', /* GB_TILE_MODE2 (2554) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '3', '\0', /* GB_TILE_MODE3 (2568) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '4', '\0', /* GB_TILE_MODE4 (2582) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '5', '\0', /* GB_TILE_MODE5 (2596) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '6', '\0', /* GB_TILE_MODE6 (2610) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '7', '\0', /* GB_TILE_MODE7 (2624) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '8', '\0', /* GB_TILE_MODE8 (2638) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '9', '\0', /* GB_TILE_MODE9 (2652) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '0', '\0', /* GB_TILE_MODE10 (2666) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '1', '\0', /* GB_TILE_MODE11 (2681) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '2', '\0', /* GB_TILE_MODE12 (2696) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '3', '\0', /* GB_TILE_MODE13 (2711) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '4', '\0', /* GB_TILE_MODE14 (2726) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '5', '\0', /* GB_TILE_MODE15 (2741) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '6', '\0', /* GB_TILE_MODE16 (2756) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '7', '\0', /* GB_TILE_MODE17 (2771) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '8', '\0', /* GB_TILE_MODE18 (2786) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '9', '\0', /* GB_TILE_MODE19 (2801) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '2', '0', '\0', /* GB_TILE_MODE20 (2816) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '2', '1', '\0', /* GB_TILE_MODE21 (2831) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '2', '2', '\0', /* GB_TILE_MODE22 (2846) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '2', '3', '\0', /* GB_TILE_MODE23 (2861) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '2', '4', '\0', /* GB_TILE_MODE24 (2876) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '2', '5', '\0', /* GB_TILE_MODE25 (2891) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '2', '6', '\0', /* GB_TILE_MODE26 (2906) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '2', '7', '\0', /* GB_TILE_MODE27 (2921) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '2', '8', '\0', /* GB_TILE_MODE28 (2936) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '2', '9', '\0', /* GB_TILE_MODE29 (2951) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '3', '0', '\0', /* GB_TILE_MODE30 (2966) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '3', '1', '\0', /* GB_TILE_MODE31 (2981) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '0', '\0', /* GB_MACROTILE_MODE0 (2996) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '\0', /* GB_MACROTILE_MODE1 (3015) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '2', '\0', /* GB_MACROTILE_MODE2 (3034) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '3', '\0', /* GB_MACROTILE_MODE3 (3053) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '4', '\0', /* GB_MACROTILE_MODE4 (3072) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '5', '\0', /* GB_MACROTILE_MODE5 (3091) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '6', '\0', /* GB_MACROTILE_MODE6 (3110) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '7', '\0', /* GB_MACROTILE_MODE7 (3129) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '8', '\0', /* GB_MACROTILE_MODE8 (3148) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '9', '\0', /* GB_MACROTILE_MODE9 (3167) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '0', '\0', /* GB_MACROTILE_MODE10 (3186) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '1', '\0', /* GB_MACROTILE_MODE11 (3206) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '2', '\0', /* GB_MACROTILE_MODE12 (3226) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '3', '\0', /* GB_MACROTILE_MODE13 (3246) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '4', '\0', /* GB_MACROTILE_MODE14 (3266) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '5', '\0', /* GB_MACROTILE_MODE15 (3286) */
	'S', 'Q', '_', 'I', 'M', 'G', '_', 'R', 'S', 'R', 'C', '_', 'W', 'O', 'R', 'D', '0', '\0', /* SQ_IMG_RSRC_WORD0 (3306) */
	'S', 'Q', '_', 'I', 'M', 'G', '_', 'R', 'S', 'R', 'C', '_', 'W', 'O', 'R', 'D', '1', '\0', /* SQ_IMG_RSRC_WORD1 (3324) */
	'S', 'Q', '_', 'I', 'M', 'G', '_', 'R', 'S', 'R', 'C', '_', 'W', 'O', 'R', 'D', '2', '\0', /* SQ_IMG_RSRC_WORD2 (3342) */
	'S', 'Q', '_', 'I', 'M', 'G', '_', 'R', 'S', 'R', 'C', '_', 'W', 'O', 'R', 'D', '3', '\0', /* SQ_IMG_RSRC_WORD3 (3360) */
	'S', 'Q', '_', 'I', 'M', 'G', '_', 'R', 'S', 'R', 'C', '_', 'W', 'O', 'R', 'D', '4', '\0', /* SQ_IMG_RSRC_WORD4 (3378) */
	'S', 'Q', '_', 'I', 'M', 'G', '_', 'R', 'S', 'R', 'C', '_', 'W', 'O', 'R', 'D', '5', '\0', /* SQ_IMG_RSRC_WORD5 (3396) */
	'S', 'Q', '_', 'I', 'M', 'G', '_', 'R', 'S', 'R', 'C', '_', 'W', 'O', 'R', 'D', '6', '\0', /* SQ_IMG_RSRC_WORD6 (3414) */
	'S', 'Q', '_', 'I', 'M', 'G', '_', 'R', 'S', 'R', 'C', '_', 'W', 'O', 'R', 'D', '7', '\0', /* SQ_IMG_RSRC_WORD7 (3432) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '4', '_', 'P', 'S', '\0', /* SPI_SHADER_PGM_RSRC4_PS (3450) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'C', 'H', 'K', 'S', 'U', 'M', '_', 'P', 'S', '\0', /* SPI_SHADER_PGM_CHKSUM_PS (3474) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '3', '_', 'P', 'S', '\0', /* SPI_SHADER_PGM_RSRC3_PS (3499) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'L', 'O', '_', 'P', 'S', '\0', /* SPI_SHADER_PGM_LO_PS (3523) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'H', 'I', '_', 'P', 'S', '\0', /* SPI_SHADER_PGM_HI_PS (3544) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '1', '_', 'P', 'S', '\0', /* SPI_SHADER_PGM_RSRC1_PS (3565) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '_', 'P', 'S', '\0', /* SPI_SHADER_PGM_RSRC2_PS (3589) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '0', '\0', /* SPI_SHADER_USER_DATA_PS_0 (3613) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '1', '\0', /* SPI_SHADER_USER_DATA_PS_1 (3639) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '2', '\0', /* SPI_SHADER_USER_DATA_PS_2 (3665) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '3', '\0', /* SPI_SHADER_USER_DATA_PS_3 (3691) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '4', '\0', /* SPI_SHADER_USER_DATA_PS_4 (3717) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '5', '\0', /* SPI_SHADER_USER_DATA_PS_5 (3743) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '6', '\0', /* SPI_SHADER_USER_DATA_PS_6 (3769) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '7', '\0', /* SPI_SHADER_USER_DATA_PS_7 (3795) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '8', '\0', /* SPI_SHADER_USER_DATA_PS_8 (3821) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '9', '\0', /* SPI_SHADER_USER_DATA_PS_9 (3847) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '1', '0', '\0', /* SPI_SHADER_USER_DATA_PS_10 (3873) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '1', '1', '\0', /* SPI_SHADER_USER_DATA_PS_11 (3900) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '1', '2', '\0', /* SPI_SHADER_USER_DATA_PS_12 (3927) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '1', '3', '\0', /* SPI_SHADER_USER_DATA_PS_13 (3954) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '1', '4', '\0', /* SPI_SHADER_USER_DATA_PS_14 (3981) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '1', '5', '\0', /* SPI_SHADER_USER_DATA_PS_15 (4008) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '1', '6', '\0', /* SPI_SHADER_USER_DATA_PS_16 (4035) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '1', '7', '\0', /* SPI_SHADER_USER_DATA_PS_17 (4062) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '1', '8', '\0', /* SPI_SHADER_USER_DATA_PS_18 (4089) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '1', '9', '\0', /* SPI_SHADER_USER_DATA_PS_19 (4116) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '2', '0', '\0', /* SPI_SHADER_USER_DATA_PS_20 (4143) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '2', '1', '\0', /* SPI_SHADER_USER_DATA_PS_21 (4170) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '2', '2', '\0', /* SPI_SHADER_USER_DATA_PS_22 (4197) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '2', '3', '\0', /* SPI_SHADER_USER_DATA_PS_23 (4224) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '2', '4', '\0', /* SPI_SHADER_USER_DATA_PS_24 (4251) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '2', '5', '\0', /* SPI_SHADER_USER_DATA_PS_25 (4278) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '2', '6', '\0', /* SPI_SHADER_USER_DATA_PS_26 (4305) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '2', '7', '\0', /* SPI_SHADER_USER_DATA_PS_27 (4332) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '2', '8', '\0', /* SPI_SHADER_USER_DATA_PS_28 (4359) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '2', '9', '\0', /* SPI_SHADER_USER_DATA_PS_29 (4386) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '3', '0', '\0', /* SPI_SHADER_USER_DATA_PS_30 (4413) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '3', '1', '\0', /* SPI_SHADER_USER_DATA_PS_31 (4440) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'R', 'E', 'Q', '_', 'C', 'T', 'R', 'L', '_', 'P', 'S', '\0', /* SPI_SHADER_REQ_CTRL_PS (4467) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'R', 'E', 'F', '_', 'P', 'R', 'I', '_', 'C', 'N', 'T', 'R', '_', 'C', 'T', 'R', 'L', '_', 'P', 'S', '\0', /* SPI_SHADER_PREF_PRI_CNTR_CTRL_PS (4490) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'P', 'S', '_', '0', '\0', /* SPI_SHADER_USER_ACCUM_PS_0 (4523) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'P', 'S', '_', '1', '\0', /* SPI_SHADER_USER_ACCUM_PS_1 (4550) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'P', 'S', '_', '2', '\0', /* SPI_SHADER_USER_ACCUM_PS_2 (4577) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'P', 'S', '_', '3', '\0', /* SPI_SHADER_USER_ACCUM_PS_3 (4604) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '4', '_', 'V', 'S', '\0', /* SPI_SHADER_PGM_RSRC4_VS (4631) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'C', 'H', 'K', 'S', 'U', 'M', '_', 'V', 'S', '\0', /* SPI_SHADER_PGM_CHKSUM_VS (4655) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '3', '_', 'V', 'S', '\0', /* SPI_SHADER_PGM_RSRC3_VS (4680) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'L', 'A', 'T', 'E', '_', 'A', 'L', 'L', 'O', 'C', '_', 'V', 'S', '\0', /* SPI_SHADER_LATE_ALLOC_VS (4704) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'L', 'O', '_', 'V', 'S', '\0', /* SPI_SHADER_PGM_LO_VS (4729) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'H', 'I', '_', 'V', 'S', '\0', /* SPI_SHADER_PGM_HI_VS (4750) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '1', '_', 'V', 'S', '\0', /* SPI_SHADER_PGM_RSRC1_VS (4771) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '_', 'V', 'S', '\0', /* SPI_SHADER_PGM_RSRC2_VS (4795) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '0', '\0', /* SPI_SHADER_USER_DATA_VS_0 (4819) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '1', '\0', /* SPI_SHADER_USER_DATA_VS_1 (4845) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '2', '\0', /* SPI_SHADER_USER_DATA_VS_2 (4871) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '3', '\0', /* SPI_SHADER_USER_DATA_VS_3 (4897) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '4', '\0', /* SPI_SHADER_USER_DATA_VS_4 (4923) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '5', '\0', /* SPI_SHADER_USER_DATA_VS_5 (4949) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '6', '\0', /* SPI_SHADER_USER_DATA_VS_6 (4975) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '7', '\0', /* SPI_SHADER_USER_DATA_VS_7 (5001) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '8', '\0', /* SPI_SHADER_USER_DATA_VS_8 (5027) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '9', '\0', /* SPI_SHADER_USER_DATA_VS_9 (5053) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '1', '0', '\0', /* SPI_SHADER_USER_DATA_VS_10 (5079) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '1', '1', '\0', /* SPI_SHADER_USER_DATA_VS_11 (5106) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '1', '2', '\0', /* SPI_SHADER_USER_DATA_VS_12 (5133) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '1', '3', '\0', /* SPI_SHADER_USER_DATA_VS_13 (5160) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '1', '4', '\0', /* SPI_SHADER_USER_DATA_VS_14 (5187) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '1', '5', '\0', /* SPI_SHADER_USER_DATA_VS_15 (5214) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '1', '6', '\0', /* SPI_SHADER_USER_DATA_VS_16 (5241) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '1', '7', '\0', /* SPI_SHADER_USER_DATA_VS_17 (5268) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '1', '8', '\0', /* SPI_SHADER_USER_DATA_VS_18 (5295) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '1', '9', '\0', /* SPI_SHADER_USER_DATA_VS_19 (5322) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '2', '0', '\0', /* SPI_SHADER_USER_DATA_VS_20 (5349) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '2', '1', '\0', /* SPI_SHADER_USER_DATA_VS_21 (5376) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '2', '2', '\0', /* SPI_SHADER_USER_DATA_VS_22 (5403) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '2', '3', '\0', /* SPI_SHADER_USER_DATA_VS_23 (5430) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '2', '4', '\0', /* SPI_SHADER_USER_DATA_VS_24 (5457) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '2', '5', '\0', /* SPI_SHADER_USER_DATA_VS_25 (5484) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '2', '6', '\0', /* SPI_SHADER_USER_DATA_VS_26 (5511) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '2', '7', '\0', /* SPI_SHADER_USER_DATA_VS_27 (5538) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '2', '8', '\0', /* SPI_SHADER_USER_DATA_VS_28 (5565) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '2', '9', '\0', /* SPI_SHADER_USER_DATA_VS_29 (5592) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '3', '0', '\0', /* SPI_SHADER_USER_DATA_VS_30 (5619) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '3', '1', '\0', /* SPI_SHADER_USER_DATA_VS_31 (5646) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'R', 'E', 'Q', '_', 'C', 'T', 'R', 'L', '_', 'V', 'S', '\0', /* SPI_SHADER_REQ_CTRL_VS (5673) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'R', 'E', 'F', '_', 'P', 'R', 'I', '_', 'C', 'N', 'T', 'R', '_', 'C', 'T', 'R', 'L', '_', 'V', 'S', '\0', /* SPI_SHADER_PREF_PRI_CNTR_CTRL_VS (5696) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'V', 'S', '_', '0', '\0', /* SPI_SHADER_USER_ACCUM_VS_0 (5729) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'V', 'S', '_', '1', '\0', /* SPI_SHADER_USER_ACCUM_VS_1 (5756) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'V', 'S', '_', '2', '\0', /* SPI_SHADER_USER_ACCUM_VS_2 (5783) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'V', 'S', '_', '3', '\0', /* SPI_SHADER_USER_ACCUM_VS_3 (5810) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '_', 'G', 'S', '_', 'V', 'S', '\0', /* SPI_SHADER_PGM_RSRC2_GS_VS (5837) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '_', 'E', 'S', '_', 'V', 'S', '\0', /* SPI_SHADER_PGM_RSRC2_ES_VS (5864) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '_', 'L', 'S', '_', 'V', 'S', '\0', /* SPI_SHADER_PGM_RSRC2_LS_VS (5891) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'C', 'H', 'K', 'S', 'U', 'M', '_', 'G', 'S', '\0', /* SPI_SHADER_PGM_CHKSUM_GS (5918) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '4', '_', 'G', 'S', '\0', /* SPI_SHADER_PGM_RSRC4_GS (5943) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '_', 'G', 'S', '\0', /* SPI_SHADER_USER_DATA_ADDR_LO_GS (5967) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '_', 'G', 'S', '\0', /* SPI_SHADER_USER_DATA_ADDR_HI_GS (5999) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'L', 'O', '_', 'E', 'S', '_', 'G', 'S', '\0', /* SPI_SHADER_PGM_LO_ES_GS (6031) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'H', 'I', '_', 'E', 'S', '_', 'G', 'S', '\0', /* SPI_SHADER_PGM_HI_ES_GS (6055) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '3', '_', 'G', 'S', '\0', /* SPI_SHADER_PGM_RSRC3_GS (6079) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'L', 'O', '_', 'G', 'S', '\0', /* SPI_SHADER_PGM_LO_GS (6103) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'H', 'I', '_', 'G', 'S', '\0', /* SPI_SHADER_PGM_HI_GS (6124) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '1', '_', 'G', 'S', '\0', /* SPI_SHADER_PGM_RSRC1_GS (6145) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '_', 'G', 'S', '\0', /* SPI_SHADER_PGM_RSRC2_GS (6169) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '0', '\0', /* SPI_SHADER_USER_DATA_GS_0 (6193) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '1', '\0', /* SPI_SHADER_USER_DATA_GS_1 (6219) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '2', '\0', /* SPI_SHADER_USER_DATA_GS_2 (6245) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '3', '\0', /* SPI_SHADER_USER_DATA_GS_3 (6271) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '4', '\0', /* SPI_SHADER_USER_DATA_GS_4 (6297) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '5', '\0', /* SPI_SHADER_USER_DATA_GS_5 (6323) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '6', '\0', /* SPI_SHADER_USER_DATA_GS_6 (6349) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '7', '\0', /* SPI_SHADER_USER_DATA_GS_7 (6375) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '8', '\0', /* SPI_SHADER_USER_DATA_GS_8 (6401) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '9', '\0', /* SPI_SHADER_USER_DATA_GS_9 (6427) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '1', '0', '\0', /* SPI_SHADER_USER_DATA_GS_10 (6453) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '1', '1', '\0', /* SPI_SHADER_USER_DATA_GS_11 (6480) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '1', '2', '\0', /* SPI_SHADER_USER_DATA_GS_12 (6507) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '1', '3', '\0', /* SPI_SHADER_USER_DATA_GS_13 (6534) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '1', '4', '\0', /* SPI_SHADER_USER_DATA_GS_14 (6561) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '1', '5', '\0', /* SPI_SHADER_USER_DATA_GS_15 (6588) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '1', '6', '\0', /* SPI_SHADER_USER_DATA_GS_16 (6615) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '1', '7', '\0', /* SPI_SHADER_USER_DATA_GS_17 (6642) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '1', '8', '\0', /* SPI_SHADER_USER_DATA_GS_18 (6669) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '1', '9', '\0', /* SPI_SHADER_USER_DATA_GS_19 (6696) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '2', '0', '\0', /* SPI_SHADER_USER_DATA_GS_20 (6723) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '2', '1', '\0', /* SPI_SHADER_USER_DATA_GS_21 (6750) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '2', '2', '\0', /* SPI_SHADER_USER_DATA_GS_22 (6777) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '2', '3', '\0', /* SPI_SHADER_USER_DATA_GS_23 (6804) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '2', '4', '\0', /* SPI_SHADER_USER_DATA_GS_24 (6831) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '2', '5', '\0', /* SPI_SHADER_USER_DATA_GS_25 (6858) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '2', '6', '\0', /* SPI_SHADER_USER_DATA_GS_26 (6885) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '2', '7', '\0', /* SPI_SHADER_USER_DATA_GS_27 (6912) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '2', '8', '\0', /* SPI_SHADER_USER_DATA_GS_28 (6939) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '2', '9', '\0', /* SPI_SHADER_USER_DATA_GS_29 (6966) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '3', '0', '\0', /* SPI_SHADER_USER_DATA_GS_30 (6993) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '3', '1', '\0', /* SPI_SHADER_USER_DATA_GS_31 (7020) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'R', 'E', 'Q', '_', 'C', 'T', 'R', 'L', '_', 'E', 'S', 'G', 'S', '\0', /* SPI_SHADER_REQ_CTRL_ESGS (7047) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'R', 'E', 'F', '_', 'P', 'R', 'I', '_', 'C', 'N', 'T', 'R', '_', 'C', 'T', 'R', 'L', '_', 'E', 'S', 'G', 'S', '\0', /* SPI_SHADER_PREF_PRI_CNTR_CTRL_ESGS (7072) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'E', 'S', 'G', 'S', '_', '0', '\0', /* SPI_SHADER_USER_ACCUM_ESGS_0 (7107) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'E', 'S', 'G', 'S', '_', '1', '\0', /* SPI_SHADER_USER_ACCUM_ESGS_1 (7136) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'E', 'S', 'G', 'S', '_', '2', '\0', /* SPI_SHADER_USER_ACCUM_ESGS_2 (7165) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'E', 'S', 'G', 'S', '_', '3', '\0', /* SPI_SHADER_USER_ACCUM_ESGS_3 (7194) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '_', 'E', 'S', '_', 'G', 'S', '\0', /* SPI_SHADER_PGM_RSRC2_ES_GS (7223) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '3', '_', 'E', 'S', '\0', /* SPI_SHADER_PGM_RSRC3_ES (7250) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'L', 'O', '_', 'E', 'S', '\0', /* SPI_SHADER_PGM_LO_ES (7274) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'H', 'I', '_', 'E', 'S', '\0', /* SPI_SHADER_PGM_HI_ES (7295) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '1', '_', 'E', 'S', '\0', /* SPI_SHADER_PGM_RSRC1_ES (7316) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '_', 'E', 'S', '\0', /* SPI_SHADER_PGM_RSRC2_ES (7340) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '0', '\0', /* SPI_SHADER_USER_DATA_ES_0 (7364) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '1', '\0', /* SPI_SHADER_USER_DATA_ES_1 (7390) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '2', '\0', /* SPI_SHADER_USER_DATA_ES_2 (7416) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '3', '\0', /* SPI_SHADER_USER_DATA_ES_3 (7442) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '4', '\0', /* SPI_SHADER_USER_DATA_ES_4 (7468) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '5', '\0', /* SPI_SHADER_USER_DATA_ES_5 (7494) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '6', '\0', /* SPI_SHADER_USER_DATA_ES_6 (7520) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '7', '\0', /* SPI_SHADER_USER_DATA_ES_7 (7546) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '8', '\0', /* SPI_SHADER_USER_DATA_ES_8 (7572) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '9', '\0', /* SPI_SHADER_USER_DATA_ES_9 (7598) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '1', '0', '\0', /* SPI_SHADER_USER_DATA_ES_10 (7624) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '1', '1', '\0', /* SPI_SHADER_USER_DATA_ES_11 (7651) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '1', '2', '\0', /* SPI_SHADER_USER_DATA_ES_12 (7678) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '1', '3', '\0', /* SPI_SHADER_USER_DATA_ES_13 (7705) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '1', '4', '\0', /* SPI_SHADER_USER_DATA_ES_14 (7732) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '1', '5', '\0', /* SPI_SHADER_USER_DATA_ES_15 (7759) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '_', 'L', 'S', '_', 'E', 'S', '\0', /* SPI_SHADER_PGM_RSRC2_LS_ES (7786) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'C', 'H', 'K', 'S', 'U', 'M', '_', 'H', 'S', '\0', /* SPI_SHADER_PGM_CHKSUM_HS (7813) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '4', '_', 'H', 'S', '\0', /* SPI_SHADER_PGM_RSRC4_HS (7838) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '_', 'H', 'S', '\0', /* SPI_SHADER_USER_DATA_ADDR_LO_HS (7862) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '_', 'H', 'S', '\0', /* SPI_SHADER_USER_DATA_ADDR_HI_HS (7894) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'L', 'O', '_', 'L', 'S', '_', 'H', 'S', '\0', /* SPI_SHADER_PGM_LO_LS_HS (7926) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'H', 'I', '_', 'L', 'S', '_', 'H', 'S', '\0', /* SPI_SHADER_PGM_HI_LS_HS (7950) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '3', '_', 'H', 'S', '\0', /* SPI_SHADER_PGM_RSRC3_HS (7974) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'L', 'O', '_', 'H', 'S', '\0', /* SPI_SHADER_PGM_LO_HS (7998) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'H', 'I', '_', 'H', 'S', '\0', /* SPI_SHADER_PGM_HI_HS (8019) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '1', '_', 'H', 'S', '\0', /* SPI_SHADER_PGM_RSRC1_HS (8040) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '_', 'H', 'S', '\0', /* SPI_SHADER_PGM_RSRC2_HS (8064) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '0', '\0', /* SPI_SHADER_USER_DATA_HS_0 (8088) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '1', '\0', /* SPI_SHADER_USER_DATA_HS_1 (8114) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '2', '\0', /* SPI_SHADER_USER_DATA_HS_2 (8140) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '3', '\0', /* SPI_SHADER_USER_DATA_HS_3 (8166) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '4', '\0', /* SPI_SHADER_USER_DATA_HS_4 (8192) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '5', '\0', /* SPI_SHADER_USER_DATA_HS_5 (8218) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '6', '\0', /* SPI_SHADER_USER_DATA_HS_6 (8244) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '7', '\0', /* SPI_SHADER_USER_DATA_HS_7 (8270) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '8', '\0', /* SPI_SHADER_USER_DATA_HS_8 (8296) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '9', '\0', /* SPI_SHADER_USER_DATA_HS_9 (8322) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '1', '0', '\0', /* SPI_SHADER_USER_DATA_HS_10 (8348) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '1', '1', '\0', /* SPI_SHADER_USER_DATA_HS_11 (8375) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '1', '2', '\0', /* SPI_SHADER_USER_DATA_HS_12 (8402) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '1', '3', '\0', /* SPI_SHADER_USER_DATA_HS_13 (8429) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '1', '4', '\0', /* SPI_SHADER_USER_DATA_HS_14 (8456) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '1', '5', '\0', /* SPI_SHADER_USER_DATA_HS_15 (8483) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '1', '6', '\0', /* SPI_SHADER_USER_DATA_HS_16 (8510) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '1', '7', '\0', /* SPI_SHADER_USER_DATA_HS_17 (8537) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '1', '8', '\0', /* SPI_SHADER_USER_DATA_HS_18 (8564) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '1', '9', '\0', /* SPI_SHADER_USER_DATA_HS_19 (8591) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '2', '0', '\0', /* SPI_SHADER_USER_DATA_HS_20 (8618) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '2', '1', '\0', /* SPI_SHADER_USER_DATA_HS_21 (8645) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '2', '2', '\0', /* SPI_SHADER_USER_DATA_HS_22 (8672) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '2', '3', '\0', /* SPI_SHADER_USER_DATA_HS_23 (8699) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '2', '4', '\0', /* SPI_SHADER_USER_DATA_HS_24 (8726) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '2', '5', '\0', /* SPI_SHADER_USER_DATA_HS_25 (8753) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '2', '6', '\0', /* SPI_SHADER_USER_DATA_HS_26 (8780) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '2', '7', '\0', /* SPI_SHADER_USER_DATA_HS_27 (8807) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '2', '8', '\0', /* SPI_SHADER_USER_DATA_HS_28 (8834) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '2', '9', '\0', /* SPI_SHADER_USER_DATA_HS_29 (8861) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '3', '0', '\0', /* SPI_SHADER_USER_DATA_HS_30 (8888) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '3', '1', '\0', /* SPI_SHADER_USER_DATA_HS_31 (8915) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'R', 'E', 'Q', '_', 'C', 'T', 'R', 'L', '_', 'L', 'S', 'H', 'S', '\0', /* SPI_SHADER_REQ_CTRL_LSHS (8942) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'R', 'E', 'F', '_', 'P', 'R', 'I', '_', 'C', 'N', 'T', 'R', '_', 'C', 'T', 'R', 'L', '_', 'L', 'S', 'H', 'S', '\0', /* SPI_SHADER_PREF_PRI_CNTR_CTRL_LSHS (8967) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'L', 'S', 'H', 'S', '_', '0', '\0', /* SPI_SHADER_USER_ACCUM_LSHS_0 (9002) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'L', 'S', 'H', 'S', '_', '1', '\0', /* SPI_SHADER_USER_ACCUM_LSHS_1 (9031) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'L', 'S', 'H', 'S', '_', '2', '\0', /* SPI_SHADER_USER_ACCUM_LSHS_2 (9060) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'L', 'S', 'H', 'S', '_', '3', '\0', /* SPI_SHADER_USER_ACCUM_LSHS_3 (9089) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '_', 'L', 'S', '_', 'H', 'S', '\0', /* SPI_SHADER_PGM_RSRC2_LS_HS (9118) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '3', '_', 'L', 'S', '\0', /* SPI_SHADER_PGM_RSRC3_LS (9145) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'L', 'O', '_', 'L', 'S', '\0', /* SPI_SHADER_PGM_LO_LS (9169) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'H', 'I', '_', 'L', 'S', '\0', /* SPI_SHADER_PGM_HI_LS (9190) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '1', '_', 'L', 'S', '\0', /* SPI_SHADER_PGM_RSRC1_LS (9211) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '_', 'L', 'S', '\0', /* SPI_SHADER_PGM_RSRC2_LS (9235) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '0', '\0', /* SPI_SHADER_USER_DATA_LS_0 (9259) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '1', '\0', /* SPI_SHADER_USER_DATA_LS_1 (9285) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '2', '\0', /* SPI_SHADER_USER_DATA_LS_2 (9311) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '3', '\0', /* SPI_SHADER_USER_DATA_LS_3 (9337) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '4', '\0', /* SPI_SHADER_USER_DATA_LS_4 (9363) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '5', '\0', /* SPI_SHADER_USER_DATA_LS_5 (9389) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '6', '\0', /* SPI_SHADER_USER_DATA_LS_6 (9415) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '7', '\0', /* SPI_SHADER_USER_DATA_LS_7 (9441) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '8', '\0', /* SPI_SHADER_USER_DATA_LS_8 (9467) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '9', '\0', /* SPI_SHADER_USER_DATA_LS_9 (9493) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '1', '0', '\0', /* SPI_SHADER_USER_DATA_LS_10 (9519) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '1', '1', '\0', /* SPI_SHADER_USER_DATA_LS_11 (9546) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '1', '2', '\0', /* SPI_SHADER_USER_DATA_LS_12 (9573) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '1', '3', '\0', /* SPI_SHADER_USER_DATA_LS_13 (9600) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '1', '4', '\0', /* SPI_SHADER_USER_DATA_LS_14 (9627) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '1', '5', '\0', /* SPI_SHADER_USER_DATA_LS_15 (9654) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'I', 'N', 'I', 'T', 'I', 'A', 'T', 'O', 'R', '\0', /* COMPUTE_DISPATCH_INITIATOR (9681) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'I', 'M', '_', 'X', '\0', /* COMPUTE_DIM_X (9708) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'I', 'M', '_', 'Y', '\0', /* COMPUTE_DIM_Y (9722) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'I', 'M', '_', 'Z', '\0', /* COMPUTE_DIM_Z (9736) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'S', 'T', 'A', 'R', 'T', '_', 'X', '\0', /* COMPUTE_START_X (9750, 9758) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'S', 'T', 'A', 'R', 'T', '_', 'Y', '\0', /* COMPUTE_START_Y (9766, 9774) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'S', 'T', 'A', 'R', 'T', '_', 'Z', '\0', /* COMPUTE_START_Z (9782) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'N', 'U', 'M', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'X', '\0', /* COMPUTE_NUM_THREAD_X (9798) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'N', 'U', 'M', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'Y', '\0', /* COMPUTE_NUM_THREAD_Y (9819) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'N', 'U', 'M', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'Z', '\0', /* COMPUTE_NUM_THREAD_Z (9840) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'P', 'I', 'P', 'E', 'L', 'I', 'N', 'E', 'S', 'T', 'A', 'T', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* COMPUTE_PIPELINESTAT_ENABLE (9861, 9869, 9882) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* COMPUTE_PERFCOUNT_ENABLE (9889, 9897) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'P', 'G', 'M', '_', 'L', 'O', '\0', /* COMPUTE_PGM_LO (9914) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'P', 'G', 'M', '_', 'H', 'I', '\0', /* COMPUTE_PGM_HI (9929) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'P', 'K', 'T', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* COMPUTE_DISPATCH_PKT_ADDR_LO (9944, 9965) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'P', 'K', 'T', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* COMPUTE_DISPATCH_PKT_ADDR_HI (9973, 9994) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'B', 'A', 'S', 'E', '_', 'L', 'O', '\0', /* COMPUTE_DISPATCH_SCRATCH_BASE_LO (10002) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* COMPUTE_DISPATCH_SCRATCH_BASE_HI (10035, 10060) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '1', '\0', /* COMPUTE_PGM_RSRC1 (10068, 10081) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '\0', /* COMPUTE_PGM_RSRC2 (10086, 10099) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'V', 'M', 'I', 'D', '\0', /* COMPUTE_VMID (10104, 10112, 10114) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'R', 'E', 'S', 'O', 'U', 'R', 'C', 'E', '_', 'L', 'I', 'M', 'I', 'T', 'S', '\0', /* COMPUTE_RESOURCE_LIMITS (10117) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'E', 'S', 'T', 'I', 'N', 'A', 'T', 'I', 'O', 'N', '_', 'E', 'N', '_', 'S', 'E', '0', '\0', /* COMPUTE_DESTINATION_EN_SE0 (10141) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'E', 'S', 'T', 'I', 'N', 'A', 'T', 'I', 'O', 'N', '_', 'E', 'N', '_', 'S', 'E', '1', '\0', /* COMPUTE_DESTINATION_EN_SE1 (10168) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'T', 'M', 'P', 'R', 'I', 'N', 'G', '_', 'S', 'I', 'Z', 'E', '\0', /* COMPUTE_TMPRING_SIZE (10195) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'E', 'S', 'T', 'I', 'N', 'A', 'T', 'I', 'O', 'N', '_', 'E', 'N', '_', 'S', 'E', '2', '\0', /* COMPUTE_DESTINATION_EN_SE2 (10216) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'E', 'S', 'T', 'I', 'N', 'A', 'T', 'I', 'O', 'N', '_', 'E', 'N', '_', 'S', 'E', '3', '\0', /* COMPUTE_DESTINATION_EN_SE3 (10243) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'R', 'E', 'S', 'T', 'A', 'R', 'T', '_', 'X', '\0', /* COMPUTE_RESTART_X (10270) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'R', 'E', 'S', 'T', 'A', 'R', 'T', '_', 'Y', '\0', /* COMPUTE_RESTART_Y (10288) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'R', 'E', 'S', 'T', 'A', 'R', 'T', '_', 'Z', '\0', /* COMPUTE_RESTART_Z (10306) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* COMPUTE_THREAD_TRACE_ENABLE (10324, 10332) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'M', 'I', 'S', 'C', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '\0', /* COMPUTE_MISC_RESERVED (10352, 10365) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'I', 'D', '\0', /* COMPUTE_DISPATCH_ID (10374) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'T', 'H', 'R', 'E', 'A', 'D', 'G', 'R', 'O', 'U', 'P', '_', 'I', 'D', '\0', /* COMPUTE_THREADGROUP_ID (10394) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'R', 'E', 'Q', '_', 'C', 'T', 'R', 'L', '\0', /* COMPUTE_REQ_CTRL (10417) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', '0', '\0', /* COMPUTE_USER_ACCUM_0 (10434) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', '1', '\0', /* COMPUTE_USER_ACCUM_1 (10455) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', '2', '\0', /* COMPUTE_USER_ACCUM_2 (10476) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', '3', '\0', /* COMPUTE_USER_ACCUM_3 (10497) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '3', '\0', /* COMPUTE_PGM_RSRC3 (10518) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'D', 'I', 'D', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* COMPUTE_DDID_INDEX (10536) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'C', 'H', 'K', 'S', 'U', 'M', '\0', /* COMPUTE_SHADER_CHKSUM (10555) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'R', 'E', 'L', 'A', 'U', 'N', 'C', 'H', '\0', /* COMPUTE_RELAUNCH (10577) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'W', 'A', 'V', 'E', '_', 'R', 'E', 'S', 'T', 'O', 'R', 'E', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* COMPUTE_WAVE_RESTORE_ADDR_LO (10594) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'W', 'A', 'V', 'E', '_', 'R', 'E', 'S', 'T', 'O', 'R', 'E', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* COMPUTE_WAVE_RESTORE_ADDR_HI (10623) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'R', 'E', 'L', 'A', 'U', 'N', 'C', 'H', '2', '\0', /* COMPUTE_RELAUNCH2 (10652) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '0', '\0', /* COMPUTE_USER_DATA_0 (10670) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '1', '\0', /* COMPUTE_USER_DATA_1 (10690) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '2', '\0', /* COMPUTE_USER_DATA_2 (10710) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '3', '\0', /* COMPUTE_USER_DATA_3 (10730) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '4', '\0', /* COMPUTE_USER_DATA_4 (10750) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '5', '\0', /* COMPUTE_USER_DATA_5 (10770) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '6', '\0', /* COMPUTE_USER_DATA_6 (10790) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '7', '\0', /* COMPUTE_USER_DATA_7 (10810) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '8', '\0', /* COMPUTE_USER_DATA_8 (10830) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '9', '\0', /* COMPUTE_USER_DATA_9 (10850) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '1', '0', '\0', /* COMPUTE_USER_DATA_10 (10870) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '1', '1', '\0', /* COMPUTE_USER_DATA_11 (10891) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '1', '2', '\0', /* COMPUTE_USER_DATA_12 (10912) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '1', '3', '\0', /* COMPUTE_USER_DATA_13 (10933) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '1', '4', '\0', /* COMPUTE_USER_DATA_14 (10954) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '1', '5', '\0', /* COMPUTE_USER_DATA_15 (10975) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'T', 'U', 'N', 'N', 'E', 'L', '\0', /* COMPUTE_DISPATCH_TUNNEL (10996) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'E', 'N', 'D', '\0', /* COMPUTE_DISPATCH_END (11020) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'N', 'O', 'W', 'H', 'E', 'R', 'E', '\0', /* COMPUTE_NOWHERE (11041, 11049) */
	'D', 'B', '_', 'R', 'E', 'N', 'D', 'E', 'R', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* DB_RENDER_CONTROL (11057) */
	'D', 'B', '_', 'C', 'O', 'U', 'N', 'T', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* DB_COUNT_CONTROL (11075) */
	'D', 'B', '_', 'D', 'E', 'P', 'T', 'H', '_', 'V', 'I', 'E', 'W', '\0', /* DB_DEPTH_VIEW (11092) */
	'D', 'B', '_', 'R', 'E', 'N', 'D', 'E', 'R', '_', 'O', 'V', 'E', 'R', 'R', 'I', 'D', 'E', '\0', /* DB_RENDER_OVERRIDE (11106) */
	'D', 'B', '_', 'R', 'E', 'N', 'D', 'E', 'R', '_', 'O', 'V', 'E', 'R', 'R', 'I', 'D', 'E', '2', '\0', /* DB_RENDER_OVERRIDE2 (11125) */
	'D', 'B', '_', 'H', 'T', 'I', 'L', 'E', '_', 'D', 'A', 'T', 'A', '_', 'B', 'A', 'S', 'E', '\0', /* DB_HTILE_DATA_BASE (11145) */
	'D', 'B', '_', 'D', 'E', 'P', 'T', 'H', '_', 'S', 'I', 'Z', 'E', '_', 'X', 'Y', '\0', /* DB_DEPTH_SIZE_XY (11164) */
	'D', 'B', '_', 'D', 'E', 'P', 'T', 'H', '_', 'B', 'O', 'U', 'N', 'D', 'S', '_', 'M', 'I', 'N', '\0', /* DB_DEPTH_BOUNDS_MIN (11181, 11197) */
	'D', 'B', '_', 'D', 'E', 'P', 'T', 'H', '_', 'B', 'O', 'U', 'N', 'D', 'S', '_', 'M', 'A', 'X', '\0', /* DB_DEPTH_BOUNDS_MAX (11201, 11217) */
	'D', 'B', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'C', 'L', 'E', 'A', 'R', '\0', /* DB_STENCIL_CLEAR (11221, 11232) */
	'D', 'B', '_', 'D', 'E', 'P', 'T', 'H', '_', 'C', 'L', 'E', 'A', 'R', '\0', /* DB_DEPTH_CLEAR (11238) */
	'P', 'A', '_', 'S', 'C', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', 'T', 'L', '\0', /* PA_SC_SCREEN_SCISSOR_TL (11253) */
	'P', 'A', '_', 'S', 'C', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', 'B', 'R', '\0', /* PA_SC_SCREEN_SCISSOR_BR (11277) */
	'D', 'B', '_', 'D', 'F', 'S', 'M', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* DB_DFSM_CONTROL (11301) */
	'D', 'B', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', 'R', 'E', 'G', '_', '2', '\0', /* DB_RESERVED_REG_2 (11317) */
	'D', 'B', '_', 'Z', '_', 'I', 'N', 'F', 'O', '\0', /* DB_Z_INFO (11335) */
	'D', 'B', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'I', 'N', 'F', 'O', '\0', /* DB_STENCIL_INFO (11345) */
	'D', 'B', '_', 'Z', '_', 'R', 'E', 'A', 'D', '_', 'B', 'A', 'S', 'E', '\0', /* DB_Z_READ_BASE (11361) */
	'D', 'B', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'R', 'E', 'A', 'D', '_', 'B', 'A', 'S', 'E', '\0', /* DB_STENCIL_READ_BASE (11376) */
	'D', 'B', '_', 'Z', '_', 'W', 'R', 'I', 'T', 'E', '_', 'B', 'A', 'S', 'E', '\0', /* DB_Z_WRITE_BASE (11397) */
	'D', 'B', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'W', 'R', 'I', 'T', 'E', '_', 'B', 'A', 'S', 'E', '\0', /* DB_STENCIL_WRITE_BASE (11413) */
	'D', 'B', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', 'R', 'E', 'G', '_', '1', '\0', /* DB_RESERVED_REG_1 (11435) */
	'D', 'B', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', 'R', 'E', 'G', '_', '3', '\0', /* DB_RESERVED_REG_3 (11453) */
	'D', 'B', '_', 'Z', '_', 'R', 'E', 'A', 'D', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* DB_Z_READ_BASE_HI (11471) */
	'D', 'B', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'R', 'E', 'A', 'D', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* DB_STENCIL_READ_BASE_HI (11489) */
	'D', 'B', '_', 'Z', '_', 'W', 'R', 'I', 'T', 'E', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* DB_Z_WRITE_BASE_HI (11513) */
	'D', 'B', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'W', 'R', 'I', 'T', 'E', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* DB_STENCIL_WRITE_BASE_HI (11532) */
	'D', 'B', '_', 'H', 'T', 'I', 'L', 'E', '_', 'D', 'A', 'T', 'A', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* DB_HTILE_DATA_BASE_HI (11557) */
	'D', 'B', '_', 'R', 'M', 'I', '_', 'L', '2', '_', 'C', 'A', 'C', 'H', 'E', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* DB_RMI_L2_CACHE_CONTROL (11579, 11589) */
	'T', 'A', '_', 'B', 'C', '_', 'B', 'A', 'S', 'E', '_', 'A', 'D', 'D', 'R', '\0', /* TA_BC_BASE_ADDR (11603, 11609, 11614) */
	'T', 'A', '_', 'B', 'C', '_', 'B', 'A', 'S', 'E', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* TA_BC_BASE_ADDR_HI (11619) */
	'C', 'O', 'H', 'E', 'R', '_', 'D', 'E', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '_', '0', '\0', /* COHER_DEST_BASE_HI_0 (11638) */
	'C', 'O', 'H', 'E', 'R', '_', 'D', 'E', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '_', '1', '\0', /* COHER_DEST_BASE_HI_1 (11659) */
	'C', 'O', 'H', 'E', 'R', '_', 'D', 'E', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '_', '2', '\0', /* COHER_DEST_BASE_HI_2 (11680) */
	'C', 'O', 'H', 'E', 'R', '_', 'D', 'E', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '_', '3', '\0', /* COHER_DEST_BASE_HI_3 (11701) */
	'C', 'O', 'H', 'E', 'R', '_', 'D', 'E', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', '2', '\0', /* COHER_DEST_BASE_2 (11722) */
	'C', 'O', 'H', 'E', 'R', '_', 'D', 'E', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', '3', '\0', /* COHER_DEST_BASE_3 (11740) */
	'P', 'A', '_', 'S', 'C', '_', 'W', 'I', 'N', 'D', 'O', 'W', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* PA_SC_WINDOW_OFFSET (11758, 11769) */
	'P', 'A', '_', 'S', 'C', '_', 'W', 'I', 'N', 'D', 'O', 'W', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', 'T', 'L', '\0', /* PA_SC_WINDOW_SCISSOR_TL (11778) */
	'P', 'A', '_', 'S', 'C', '_', 'W', 'I', 'N', 'D', 'O', 'W', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', 'B', 'R', '\0', /* PA_SC_WINDOW_SCISSOR_BR (11802) */
	'P', 'A', '_', 'S', 'C', '_', 'C', 'L', 'I', 'P', 'R', 'E', 'C', 'T', '_', 'R', 'U', 'L', 'E', '\0', /* PA_SC_CLIPRECT_RULE (11826) */
	'P', 'A', '_', 'S', 'C', '_', 'C', 'L', 'I', 'P', 'R', 'E', 'C', 'T', '_', '0', '_', 'T', 'L', '\0', /* PA_SC_CLIPRECT_0_TL (11846) */
	'P', 'A', '_', 'S', 'C', '_', 'C', 'L', 'I', 'P', 'R', 'E', 'C', 'T', '_', '0', '_', 'B', 'R', '\0', /* PA_SC_CLIPRECT_0_BR (11866) */
	'P', 'A', '_', 'S', 'C', '_', 'C', 'L', 'I', 'P', 'R', 'E', 'C', 'T', '_', '1', '_', 'T', 'L', '\0', /* PA_SC_CLIPRECT_1_TL (11886) */
	'P', 'A', '_', 'S', 'C', '_', 'C', 'L', 'I', 'P', 'R', 'E', 'C', 'T', '_', '1', '_', 'B', 'R', '\0', /* PA_SC_CLIPRECT_1_BR (11906) */
	'P', 'A', '_', 'S', 'C', '_', 'C', 'L', 'I', 'P', 'R', 'E', 'C', 'T', '_', '2', '_', 'T', 'L', '\0', /* PA_SC_CLIPRECT_2_TL (11926) */
	'P', 'A', '_', 'S', 'C', '_', 'C', 'L', 'I', 'P', 'R', 'E', 'C', 'T', '_', '2', '_', 'B', 'R', '\0', /* PA_SC_CLIPRECT_2_BR (11946) */
	'P', 'A', '_', 'S', 'C', '_', 'C', 'L', 'I', 'P', 'R', 'E', 'C', 'T', '_', '3', '_', 'T', 'L', '\0', /* PA_SC_CLIPRECT_3_TL (11966) */
	'P', 'A', '_', 'S', 'C', '_', 'C', 'L', 'I', 'P', 'R', 'E', 'C', 'T', '_', '3', '_', 'B', 'R', '\0', /* PA_SC_CLIPRECT_3_BR (11986) */
	'P', 'A', '_', 'S', 'C', '_', 'E', 'D', 'G', 'E', 'R', 'U', 'L', 'E', '\0', /* PA_SC_EDGERULE (12006) */
	'P', 'A', '_', 'S', 'U', '_', 'H', 'A', 'R', 'D', 'W', 'A', 'R', 'E', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* PA_SU_HARDWARE_SCREEN_OFFSET (12021) */
	'C', 'B', '_', 'T', 'A', 'R', 'G', 'E', 'T', '_', 'M', 'A', 'S', 'K', '\0', /* CB_TARGET_MASK (12050) */
	'C', 'B', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'M', 'A', 'S', 'K', '\0', /* CB_SHADER_MASK (12065) */
	'P', 'A', '_', 'S', 'C', '_', 'G', 'E', 'N', 'E', 'R', 'I', 'C', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', 'T', 'L', '\0', /* PA_SC_GENERIC_SCISSOR_TL (12080) */
	'P', 'A', '_', 'S', 'C', '_', 'G', 'E', 'N', 'E', 'R', 'I', 'C', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', 'B', 'R', '\0', /* PA_SC_GENERIC_SCISSOR_BR (12105) */
	'C', 'O', 'H', 'E', 'R', '_', 'D', 'E', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', '0', '\0', /* COHER_DEST_BASE_0 (12130) */
	'C', 'O', 'H', 'E', 'R', '_', 'D', 'E', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', '1', '\0', /* COHER_DEST_BASE_1 (12148) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '0', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_0_TL (12166) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '0', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_0_BR (12191) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_1_TL (12216) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_1_BR (12241) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '2', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_2_TL (12266) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '2', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_2_BR (12291) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '3', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_3_TL (12316) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '3', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_3_BR (12341) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '4', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_4_TL (12366) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '4', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_4_BR (12391) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '5', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_5_TL (12416) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '5', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_5_BR (12441) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '6', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_6_TL (12466) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '6', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_6_BR (12491) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '7', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_7_TL (12516) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '7', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_7_BR (12541) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '8', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_8_TL (12566) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '8', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_8_BR (12591) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '9', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_9_TL (12616) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '9', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_9_BR (12641) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '0', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_10_TL (12666) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '0', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_10_BR (12692) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '1', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_11_TL (12718) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '1', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_11_BR (12744) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '2', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_12_TL (12770) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '2', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_12_BR (12796) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '3', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_13_TL (12822) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '3', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_13_BR (12848) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '4', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_14_TL (12874) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '4', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_14_BR (12900) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '5', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_15_TL (12926) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '5', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_15_BR (12952) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '0', '\0', /* PA_SC_VPORT_ZMIN_0 (12978, 12992) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '0', '\0', /* PA_SC_VPORT_ZMAX_0 (12997) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '1', '\0', /* PA_SC_VPORT_ZMIN_1 (13016, 13030) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '1', '\0', /* PA_SC_VPORT_ZMAX_1 (13035) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '2', '\0', /* PA_SC_VPORT_ZMIN_2 (13054, 13068) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '2', '\0', /* PA_SC_VPORT_ZMAX_2 (13073) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '3', '\0', /* PA_SC_VPORT_ZMIN_3 (13092, 13106) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '3', '\0', /* PA_SC_VPORT_ZMAX_3 (13111) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '4', '\0', /* PA_SC_VPORT_ZMIN_4 (13130) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '4', '\0', /* PA_SC_VPORT_ZMAX_4 (13149) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '5', '\0', /* PA_SC_VPORT_ZMIN_5 (13168) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '5', '\0', /* PA_SC_VPORT_ZMAX_5 (13187) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '6', '\0', /* PA_SC_VPORT_ZMIN_6 (13206) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '6', '\0', /* PA_SC_VPORT_ZMAX_6 (13225) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '7', '\0', /* PA_SC_VPORT_ZMIN_7 (13244) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '7', '\0', /* PA_SC_VPORT_ZMAX_7 (13263) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '8', '\0', /* PA_SC_VPORT_ZMIN_8 (13282) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '8', '\0', /* PA_SC_VPORT_ZMAX_8 (13301) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '9', '\0', /* PA_SC_VPORT_ZMIN_9 (13320) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '9', '\0', /* PA_SC_VPORT_ZMAX_9 (13339) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '1', '0', '\0', /* PA_SC_VPORT_ZMIN_10 (13358, 13372) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '1', '0', '\0', /* PA_SC_VPORT_ZMAX_10 (13378) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '1', '1', '\0', /* PA_SC_VPORT_ZMIN_11 (13398) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '1', '1', '\0', /* PA_SC_VPORT_ZMAX_11 (13418) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '1', '2', '\0', /* PA_SC_VPORT_ZMIN_12 (13438) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '1', '2', '\0', /* PA_SC_VPORT_ZMAX_12 (13458) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '1', '3', '\0', /* PA_SC_VPORT_ZMIN_13 (13478) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '1', '3', '\0', /* PA_SC_VPORT_ZMAX_13 (13498) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '1', '4', '\0', /* PA_SC_VPORT_ZMIN_14 (13518) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '1', '4', '\0', /* PA_SC_VPORT_ZMAX_14 (13538) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '1', '5', '\0', /* PA_SC_VPORT_ZMIN_15 (13558) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '1', '5', '\0', /* PA_SC_VPORT_ZMAX_15 (13578) */
	'P', 'A', '_', 'S', 'C', '_', 'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* PA_SC_RASTER_CONFIG (13598) */
	'P', 'A', '_', 'S', 'C', '_', 'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', '1', '\0', /* PA_SC_RASTER_CONFIG_1 (13618) */
	'P', 'A', '_', 'S', 'C', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'E', 'X', 'T', 'E', 'N', 'T', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* PA_SC_SCREEN_EXTENT_CONTROL (13640) */
	'P', 'A', '_', 'S', 'C', '_', 'T', 'I', 'L', 'E', '_', 'S', 'T', 'E', 'E', 'R', 'I', 'N', 'G', '_', 'O', 'V', 'E', 'R', 'R', 'I', 'D', 'E', '\0', /* PA_SC_TILE_STEERING_OVERRIDE (13668) */
	'C', 'P', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'C', 'N', 'T', 'X', '_', 'C', 'N', 'T', 'L', '\0', /* CP_PERFMON_CNTX_CNTL (13697) */
	'C', 'P', '_', 'P', 'I', 'P', 'E', 'I', 'D', '\0', /* CP_PIPEID (13718) */
	'C', 'P', '_', 'V', 'M', 'I', 'D', '\0', /* CP_VMID (13728) */
	'P', 'A', '_', 'S', 'C', '_', 'R', 'I', 'G', 'H', 'T', '_', 'V', 'E', 'R', 'T', '_', 'G', 'R', 'I', 'D', '\0', /* PA_SC_RIGHT_VERT_GRID (13736) */
	'P', 'A', '_', 'S', 'C', '_', 'L', 'E', 'F', 'T', '_', 'V', 'E', 'R', 'T', '_', 'G', 'R', 'I', 'D', '\0', /* PA_SC_LEFT_VERT_GRID (13758) */
	'P', 'A', '_', 'S', 'C', '_', 'H', 'O', 'R', 'I', 'Z', '_', 'G', 'R', 'I', 'D', '\0', /* PA_SC_HORIZ_GRID (13779) */
	'V', 'G', 'T', '_', 'M', 'A', 'X', '_', 'V', 'T', 'X', '_', 'I', 'N', 'D', 'X', '\0', /* VGT_MAX_VTX_INDX (13796) */
	'V', 'G', 'T', '_', 'M', 'I', 'N', '_', 'V', 'T', 'X', '_', 'I', 'N', 'D', 'X', '\0', /* VGT_MIN_VTX_INDX (13813) */
	'V', 'G', 'T', '_', 'I', 'N', 'D', 'X', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* VGT_INDX_OFFSET (13830, 13837) */
	'V', 'G', 'T', '_', 'M', 'U', 'L', 'T', 'I', '_', 'P', 'R', 'I', 'M', '_', 'I', 'B', '_', 'R', 'E', 'S', 'E', 'T', '_', 'I', 'N', 'D', 'X', '\0', /* VGT_MULTI_PRIM_IB_RESET_INDX (13846) */
	'C', 'B', '_', 'R', 'M', 'I', '_', 'G', 'L', '2', '_', 'C', 'A', 'C', 'H', 'E', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_RMI_GL2_CACHE_CONTROL (13875) */
	'C', 'B', '_', 'B', 'L', 'E', 'N', 'D', '_', 'R', 'E', 'D', '\0', /* CB_BLEND_RED (13900) */
	'C', 'B', '_', 'B', 'L', 'E', 'N', 'D', '_', 'G', 'R', 'E', 'E', 'N', '\0', /* CB_BLEND_GREEN (13913, 13925) */
	'C', 'B', '_', 'B', 'L', 'E', 'N', 'D', '_', 'B', 'L', 'U', 'E', '\0', /* CB_BLEND_BLUE (13928) */
	'C', 'B', '_', 'B', 'L', 'E', 'N', 'D', '_', 'A', 'L', 'P', 'H', 'A', '\0', /* CB_BLEND_ALPHA (13942) */
	'C', 'B', '_', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_DCC_CONTROL (13957) */
	'C', 'B', '_', 'C', 'O', 'V', 'E', 'R', 'A', 'G', 'E', '_', 'O', 'U', 'T', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COVERAGE_OUT_CONTROL (13972) */
	'D', 'B', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* DB_STENCIL_CONTROL (13996) */
	'D', 'B', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', 'R', 'E', 'F', 'M', 'A', 'S', 'K', '\0', /* DB_STENCILREFMASK (14015) */
	'D', 'B', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', 'R', 'E', 'F', 'M', 'A', 'S', 'K', '_', 'B', 'F', '\0', /* DB_STENCILREFMASK_BF (14033) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '\0', /* PA_CL_VPORT_XSCALE (14054) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* PA_CL_VPORT_XOFFSET (14073) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '\0', /* PA_CL_VPORT_YSCALE (14093) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* PA_CL_VPORT_YOFFSET (14112) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '\0', /* PA_CL_VPORT_ZSCALE (14132) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* PA_CL_VPORT_ZOFFSET (14151) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '1', '\0', /* PA_CL_VPORT_XSCALE_1 (14171) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '\0', /* PA_CL_VPORT_XOFFSET_1 (14192) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '1', '\0', /* PA_CL_VPORT_YSCALE_1 (14214) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '\0', /* PA_CL_VPORT_YOFFSET_1 (14235) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '1', '\0', /* PA_CL_VPORT_ZSCALE_1 (14257) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '\0', /* PA_CL_VPORT_ZOFFSET_1 (14278) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '2', '\0', /* PA_CL_VPORT_XSCALE_2 (14300) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '2', '\0', /* PA_CL_VPORT_XOFFSET_2 (14321) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '2', '\0', /* PA_CL_VPORT_YSCALE_2 (14343) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '2', '\0', /* PA_CL_VPORT_YOFFSET_2 (14364) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '2', '\0', /* PA_CL_VPORT_ZSCALE_2 (14386) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '2', '\0', /* PA_CL_VPORT_ZOFFSET_2 (14407) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '3', '\0', /* PA_CL_VPORT_XSCALE_3 (14429) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '3', '\0', /* PA_CL_VPORT_XOFFSET_3 (14450) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '3', '\0', /* PA_CL_VPORT_YSCALE_3 (14472) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '3', '\0', /* PA_CL_VPORT_YOFFSET_3 (14493) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '3', '\0', /* PA_CL_VPORT_ZSCALE_3 (14515) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '3', '\0', /* PA_CL_VPORT_ZOFFSET_3 (14536) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '4', '\0', /* PA_CL_VPORT_XSCALE_4 (14558) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '4', '\0', /* PA_CL_VPORT_XOFFSET_4 (14579) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '4', '\0', /* PA_CL_VPORT_YSCALE_4 (14601) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '4', '\0', /* PA_CL_VPORT_YOFFSET_4 (14622) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '4', '\0', /* PA_CL_VPORT_ZSCALE_4 (14644) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '4', '\0', /* PA_CL_VPORT_ZOFFSET_4 (14665) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '5', '\0', /* PA_CL_VPORT_XSCALE_5 (14687) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '5', '\0', /* PA_CL_VPORT_XOFFSET_5 (14708) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '5', '\0', /* PA_CL_VPORT_YSCALE_5 (14730) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '5', '\0', /* PA_CL_VPORT_YOFFSET_5 (14751) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '5', '\0', /* PA_CL_VPORT_ZSCALE_5 (14773) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '5', '\0', /* PA_CL_VPORT_ZOFFSET_5 (14794) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '6', '\0', /* PA_CL_VPORT_XSCALE_6 (14816) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '6', '\0', /* PA_CL_VPORT_XOFFSET_6 (14837) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '6', '\0', /* PA_CL_VPORT_YSCALE_6 (14859) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '6', '\0', /* PA_CL_VPORT_YOFFSET_6 (14880) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '6', '\0', /* PA_CL_VPORT_ZSCALE_6 (14902) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '6', '\0', /* PA_CL_VPORT_ZOFFSET_6 (14923) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '7', '\0', /* PA_CL_VPORT_XSCALE_7 (14945) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '7', '\0', /* PA_CL_VPORT_XOFFSET_7 (14966) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '7', '\0', /* PA_CL_VPORT_YSCALE_7 (14988) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '7', '\0', /* PA_CL_VPORT_YOFFSET_7 (15009) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '7', '\0', /* PA_CL_VPORT_ZSCALE_7 (15031) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '7', '\0', /* PA_CL_VPORT_ZOFFSET_7 (15052) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '8', '\0', /* PA_CL_VPORT_XSCALE_8 (15074) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '8', '\0', /* PA_CL_VPORT_XOFFSET_8 (15095) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '8', '\0', /* PA_CL_VPORT_YSCALE_8 (15117) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '8', '\0', /* PA_CL_VPORT_YOFFSET_8 (15138) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '8', '\0', /* PA_CL_VPORT_ZSCALE_8 (15160) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '8', '\0', /* PA_CL_VPORT_ZOFFSET_8 (15181) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '9', '\0', /* PA_CL_VPORT_XSCALE_9 (15203) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '9', '\0', /* PA_CL_VPORT_XOFFSET_9 (15224) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '9', '\0', /* PA_CL_VPORT_YSCALE_9 (15246) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '9', '\0', /* PA_CL_VPORT_YOFFSET_9 (15267) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '9', '\0', /* PA_CL_VPORT_ZSCALE_9 (15289) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '9', '\0', /* PA_CL_VPORT_ZOFFSET_9 (15310) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '1', '0', '\0', /* PA_CL_VPORT_XSCALE_10 (15332) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '0', '\0', /* PA_CL_VPORT_XOFFSET_10 (15354) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '1', '0', '\0', /* PA_CL_VPORT_YSCALE_10 (15377) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '0', '\0', /* PA_CL_VPORT_YOFFSET_10 (15399) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '1', '0', '\0', /* PA_CL_VPORT_ZSCALE_10 (15422) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '0', '\0', /* PA_CL_VPORT_ZOFFSET_10 (15444) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '1', '1', '\0', /* PA_CL_VPORT_XSCALE_11 (15467) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '1', '\0', /* PA_CL_VPORT_XOFFSET_11 (15489) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '1', '1', '\0', /* PA_CL_VPORT_YSCALE_11 (15512) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '1', '\0', /* PA_CL_VPORT_YOFFSET_11 (15534) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '1', '1', '\0', /* PA_CL_VPORT_ZSCALE_11 (15557) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '1', '\0', /* PA_CL_VPORT_ZOFFSET_11 (15579) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '1', '2', '\0', /* PA_CL_VPORT_XSCALE_12 (15602) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '2', '\0', /* PA_CL_VPORT_XOFFSET_12 (15624) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '1', '2', '\0', /* PA_CL_VPORT_YSCALE_12 (15647) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '2', '\0', /* PA_CL_VPORT_YOFFSET_12 (15669) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '1', '2', '\0', /* PA_CL_VPORT_ZSCALE_12 (15692) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '2', '\0', /* PA_CL_VPORT_ZOFFSET_12 (15714) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '1', '3', '\0', /* PA_CL_VPORT_XSCALE_13 (15737) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '3', '\0', /* PA_CL_VPORT_XOFFSET_13 (15759) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '1', '3', '\0', /* PA_CL_VPORT_YSCALE_13 (15782) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '3', '\0', /* PA_CL_VPORT_YOFFSET_13 (15804) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '1', '3', '\0', /* PA_CL_VPORT_ZSCALE_13 (15827) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '3', '\0', /* PA_CL_VPORT_ZOFFSET_13 (15849) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '1', '4', '\0', /* PA_CL_VPORT_XSCALE_14 (15872) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '4', '\0', /* PA_CL_VPORT_XOFFSET_14 (15894) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '1', '4', '\0', /* PA_CL_VPORT_YSCALE_14 (15917) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '4', '\0', /* PA_CL_VPORT_YOFFSET_14 (15939) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '1', '4', '\0', /* PA_CL_VPORT_ZSCALE_14 (15962) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '4', '\0', /* PA_CL_VPORT_ZOFFSET_14 (15984) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '1', '5', '\0', /* PA_CL_VPORT_XSCALE_15 (16007) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '5', '\0', /* PA_CL_VPORT_XOFFSET_15 (16029) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '1', '5', '\0', /* PA_CL_VPORT_YSCALE_15 (16052) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '5', '\0', /* PA_CL_VPORT_YOFFSET_15 (16074) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '1', '5', '\0', /* PA_CL_VPORT_ZSCALE_15 (16097) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '5', '\0', /* PA_CL_VPORT_ZOFFSET_15 (16119) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '0', '_', 'X', '\0', /* PA_CL_UCP_0_X (16142) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '0', '_', 'Y', '\0', /* PA_CL_UCP_0_Y (16156) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '0', '_', 'Z', '\0', /* PA_CL_UCP_0_Z (16170) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '0', '_', 'W', '\0', /* PA_CL_UCP_0_W (16184) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '1', '_', 'X', '\0', /* PA_CL_UCP_1_X (16198) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '1', '_', 'Y', '\0', /* PA_CL_UCP_1_Y (16212) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '1', '_', 'Z', '\0', /* PA_CL_UCP_1_Z (16226) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '1', '_', 'W', '\0', /* PA_CL_UCP_1_W (16240) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '2', '_', 'X', '\0', /* PA_CL_UCP_2_X (16254) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '2', '_', 'Y', '\0', /* PA_CL_UCP_2_Y (16268) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '2', '_', 'Z', '\0', /* PA_CL_UCP_2_Z (16282) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '2', '_', 'W', '\0', /* PA_CL_UCP_2_W (16296) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '3', '_', 'X', '\0', /* PA_CL_UCP_3_X (16310) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '3', '_', 'Y', '\0', /* PA_CL_UCP_3_Y (16324) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '3', '_', 'Z', '\0', /* PA_CL_UCP_3_Z (16338) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '3', '_', 'W', '\0', /* PA_CL_UCP_3_W (16352) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '4', '_', 'X', '\0', /* PA_CL_UCP_4_X (16366) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '4', '_', 'Y', '\0', /* PA_CL_UCP_4_Y (16380) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '4', '_', 'Z', '\0', /* PA_CL_UCP_4_Z (16394) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '4', '_', 'W', '\0', /* PA_CL_UCP_4_W (16408) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '5', '_', 'X', '\0', /* PA_CL_UCP_5_X (16422) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '5', '_', 'Y', '\0', /* PA_CL_UCP_5_Y (16436) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '5', '_', 'Z', '\0', /* PA_CL_UCP_5_Z (16450) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '5', '_', 'W', '\0', /* PA_CL_UCP_5_W (16464) */
	'P', 'A', '_', 'C', 'L', '_', 'P', 'R', 'O', 'G', '_', 'N', 'E', 'A', 'R', '_', 'C', 'L', 'I', 'P', '_', 'Z', '\0', /* PA_CL_PROG_NEAR_CLIP_Z (16478) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '0', '\0', /* SPI_PS_INPUT_CNTL_0 (16501) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '1', '\0', /* SPI_PS_INPUT_CNTL_1 (16521) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '2', '\0', /* SPI_PS_INPUT_CNTL_2 (16541) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '3', '\0', /* SPI_PS_INPUT_CNTL_3 (16561) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '4', '\0', /* SPI_PS_INPUT_CNTL_4 (16581) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '5', '\0', /* SPI_PS_INPUT_CNTL_5 (16601) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '6', '\0', /* SPI_PS_INPUT_CNTL_6 (16621) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '7', '\0', /* SPI_PS_INPUT_CNTL_7 (16641) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '8', '\0', /* SPI_PS_INPUT_CNTL_8 (16661) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '9', '\0', /* SPI_PS_INPUT_CNTL_9 (16681) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '1', '0', '\0', /* SPI_PS_INPUT_CNTL_10 (16701) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '1', '1', '\0', /* SPI_PS_INPUT_CNTL_11 (16722) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '1', '2', '\0', /* SPI_PS_INPUT_CNTL_12 (16743) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '1', '3', '\0', /* SPI_PS_INPUT_CNTL_13 (16764) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '1', '4', '\0', /* SPI_PS_INPUT_CNTL_14 (16785) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '1', '5', '\0', /* SPI_PS_INPUT_CNTL_15 (16806) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '1', '6', '\0', /* SPI_PS_INPUT_CNTL_16 (16827) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '1', '7', '\0', /* SPI_PS_INPUT_CNTL_17 (16848) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '1', '8', '\0', /* SPI_PS_INPUT_CNTL_18 (16869) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '1', '9', '\0', /* SPI_PS_INPUT_CNTL_19 (16890) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '2', '0', '\0', /* SPI_PS_INPUT_CNTL_20 (16911) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '2', '1', '\0', /* SPI_PS_INPUT_CNTL_21 (16932) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '2', '2', '\0', /* SPI_PS_INPUT_CNTL_22 (16953) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '2', '3', '\0', /* SPI_PS_INPUT_CNTL_23 (16974) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '2', '4', '\0', /* SPI_PS_INPUT_CNTL_24 (16995) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '2', '5', '\0', /* SPI_PS_INPUT_CNTL_25 (17016) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '2', '6', '\0', /* SPI_PS_INPUT_CNTL_26 (17037) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '2', '7', '\0', /* SPI_PS_INPUT_CNTL_27 (17058) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '2', '8', '\0', /* SPI_PS_INPUT_CNTL_28 (17079) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '2', '9', '\0', /* SPI_PS_INPUT_CNTL_29 (17100) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '3', '0', '\0', /* SPI_PS_INPUT_CNTL_30 (17121) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '3', '1', '\0', /* SPI_PS_INPUT_CNTL_31 (17142) */
	'S', 'P', 'I', '_', 'V', 'S', '_', 'O', 'U', 'T', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* SPI_VS_OUT_CONFIG (17163) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'E', 'N', 'A', '\0', /* SPI_PS_INPUT_ENA (17181) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'A', 'D', 'D', 'R', '\0', /* SPI_PS_INPUT_ADDR (17198) */
	'S', 'P', 'I', '_', 'I', 'N', 'T', 'E', 'R', 'P', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '_', '0', '\0', /* SPI_INTERP_CONTROL_0 (17216) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* SPI_PS_IN_CONTROL (17237) */
	'S', 'P', 'I', '_', 'B', 'A', 'R', 'Y', 'C', '_', 'C', 'N', 'T', 'L', '\0', /* SPI_BARYC_CNTL (17255) */
	'S', 'P', 'I', '_', 'T', 'M', 'P', 'R', 'I', 'N', 'G', '_', 'S', 'I', 'Z', 'E', '\0', /* SPI_TMPRING_SIZE (17270) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'I', 'D', 'X', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* SPI_SHADER_IDX_FORMAT (17287, 17302) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'O', 'S', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* SPI_SHADER_POS_FORMAT (17309) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'Z', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* SPI_SHADER_Z_FORMAT (17331) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'C', 'O', 'L', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* SPI_SHADER_COL_FORMAT (17351) */
	'S', 'X', '_', 'P', 'S', '_', 'D', 'O', 'W', 'N', 'C', 'O', 'N', 'V', 'E', 'R', 'T', '\0', /* SX_PS_DOWNCONVERT (17373) */
	'S', 'X', '_', 'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '_', 'E', 'P', 'S', 'I', 'L', 'O', 'N', '\0', /* SX_BLEND_OPT_EPSILON (17391) */
	'S', 'X', '_', 'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* SX_BLEND_OPT_CONTROL (17412) */
	'S', 'X', '_', 'M', 'R', 'T', '0', '_', 'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '\0', /* SX_MRT0_BLEND_OPT (17433) */
	'S', 'X', '_', 'M', 'R', 'T', '1', '_', 'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '\0', /* SX_MRT1_BLEND_OPT (17451) */
	'S', 'X', '_', 'M', 'R', 'T', '2', '_', 'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '\0', /* SX_MRT2_BLEND_OPT (17469) */
	'S', 'X', '_', 'M', 'R', 'T', '3', '_', 'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '\0', /* SX_MRT3_BLEND_OPT (17487) */
	'S', 'X', '_', 'M', 'R', 'T', '4', '_', 'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '\0', /* SX_MRT4_BLEND_OPT (17505) */
	'S', 'X', '_', 'M', 'R', 'T', '5', '_', 'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '\0', /* SX_MRT5_BLEND_OPT (17523) */
	'S', 'X', '_', 'M', 'R', 'T', '6', '_', 'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '\0', /* SX_MRT6_BLEND_OPT (17541) */
	'S', 'X', '_', 'M', 'R', 'T', '7', '_', 'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '\0', /* SX_MRT7_BLEND_OPT (17559) */
	'C', 'B', '_', 'B', 'L', 'E', 'N', 'D', '0', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_BLEND0_CONTROL (17577) */
	'C', 'B', '_', 'B', 'L', 'E', 'N', 'D', '1', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_BLEND1_CONTROL (17595) */
	'C', 'B', '_', 'B', 'L', 'E', 'N', 'D', '2', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_BLEND2_CONTROL (17613) */
	'C', 'B', '_', 'B', 'L', 'E', 'N', 'D', '3', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_BLEND3_CONTROL (17631) */
	'C', 'B', '_', 'B', 'L', 'E', 'N', 'D', '4', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_BLEND4_CONTROL (17649) */
	'C', 'B', '_', 'B', 'L', 'E', 'N', 'D', '5', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_BLEND5_CONTROL (17667) */
	'C', 'B', '_', 'B', 'L', 'E', 'N', 'D', '6', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_BLEND6_CONTROL (17685) */
	'C', 'B', '_', 'B', 'L', 'E', 'N', 'D', '7', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_BLEND7_CONTROL (17703) */
	'C', 'S', '_', 'C', 'O', 'P', 'Y', '_', 'S', 'T', 'A', 'T', 'E', '\0', /* CS_COPY_STATE (17721) */
	'G', 'F', 'X', '_', 'C', 'O', 'P', 'Y', '_', 'S', 'T', 'A', 'T', 'E', '\0', /* GFX_COPY_STATE (17735) */
	'P', 'A', '_', 'C', 'L', '_', 'P', 'O', 'I', 'N', 'T', '_', 'X', '_', 'R', 'A', 'D', '\0', /* PA_CL_POINT_X_RAD (17750) */
	'P', 'A', '_', 'C', 'L', '_', 'P', 'O', 'I', 'N', 'T', '_', 'Y', '_', 'R', 'A', 'D', '\0', /* PA_CL_POINT_Y_RAD (17768) */
	'P', 'A', '_', 'C', 'L', '_', 'P', 'O', 'I', 'N', 'T', '_', 'S', 'I', 'Z', 'E', '\0', /* PA_CL_POINT_SIZE (17786) */
	'P', 'A', '_', 'C', 'L', '_', 'P', 'O', 'I', 'N', 'T', '_', 'C', 'U', 'L', 'L', '_', 'R', 'A', 'D', '\0', /* PA_CL_POINT_CULL_RAD (17803) */
	'V', 'G', 'T', '_', 'D', 'M', 'A', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* VGT_DMA_BASE_HI (17824) */
	'V', 'G', 'T', '_', 'D', 'M', 'A', '_', 'B', 'A', 'S', 'E', '\0', /* VGT_DMA_BASE (17840) */
	'V', 'G', 'T', '_', 'D', 'R', 'A', 'W', '_', 'I', 'N', 'I', 'T', 'I', 'A', 'T', 'O', 'R', '\0', /* VGT_DRAW_INITIATOR (17853) */
	'V', 'G', 'T', '_', 'I', 'M', 'M', 'E', 'D', '_', 'D', 'A', 'T', 'A', '\0', /* VGT_IMMED_DATA (17872) */
	'V', 'G', 'T', '_', 'E', 'V', 'E', 'N', 'T', '_', 'A', 'D', 'D', 'R', 'E', 'S', 'S', '_', 'R', 'E', 'G', '\0', /* VGT_EVENT_ADDRESS_REG (17887) */
	'G', 'E', '_', 'M', 'A', 'X', '_', 'O', 'U', 'T', 'P', 'U', 'T', '_', 'P', 'E', 'R', '_', 'S', 'U', 'B', 'G', 'R', 'O', 'U', 'P', '\0', /* GE_MAX_OUTPUT_PER_SUBGROUP (17909) */
	'D', 'B', '_', 'D', 'E', 'P', 'T', 'H', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* DB_DEPTH_CONTROL (17936) */
	'D', 'B', '_', 'E', 'Q', 'A', 'A', '\0', /* DB_EQAA (17953) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR_CONTROL (17961) */
	'D', 'B', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* DB_SHADER_CONTROL (17978) */
	'P', 'A', '_', 'C', 'L', '_', 'C', 'L', 'I', 'P', '_', 'C', 'N', 'T', 'L', '\0', /* PA_CL_CLIP_CNTL (17996) */
	'P', 'A', '_', 'S', 'U', '_', 'S', 'C', '_', 'M', 'O', 'D', 'E', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SU_SC_MODE_CNTL (18012) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'T', 'E', '_', 'C', 'N', 'T', 'L', '\0', /* PA_CL_VTE_CNTL (18031) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'S', '_', 'O', 'U', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* PA_CL_VS_OUT_CNTL (18046) */
	'P', 'A', '_', 'C', 'L', '_', 'N', 'A', 'N', 'I', 'N', 'F', '_', 'C', 'N', 'T', 'L', '\0', /* PA_CL_NANINF_CNTL (18064) */
	'P', 'A', '_', 'S', 'U', '_', 'L', 'I', 'N', 'E', '_', 'S', 'T', 'I', 'P', 'P', 'L', 'E', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SU_LINE_STIPPLE_CNTL (18082) */
	'P', 'A', '_', 'S', 'U', '_', 'L', 'I', 'N', 'E', '_', 'S', 'T', 'I', 'P', 'P', 'L', 'E', '_', 'S', 'C', 'A', 'L', 'E', '\0', /* PA_SU_LINE_STIPPLE_SCALE (18106) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'R', 'I', 'M', '_', 'F', 'I', 'L', 'T', 'E', 'R', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SU_PRIM_FILTER_CNTL (18131) */
	'P', 'A', '_', 'S', 'U', '_', 'S', 'M', 'A', 'L', 'L', '_', 'P', 'R', 'I', 'M', '_', 'F', 'I', 'L', 'T', 'E', 'R', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SU_SMALL_PRIM_FILTER_CNTL (18154) */
	'P', 'A', '_', 'C', 'L', '_', 'O', 'B', 'J', 'P', 'R', 'I', 'M', '_', 'I', 'D', '_', 'C', 'N', 'T', 'L', '\0', /* PA_CL_OBJPRIM_ID_CNTL (18183) */
	'P', 'A', '_', 'C', 'L', '_', 'N', 'G', 'G', '_', 'C', 'N', 'T', 'L', '\0', /* PA_CL_NGG_CNTL (18205) */
	'P', 'A', '_', 'S', 'U', '_', 'O', 'V', 'E', 'R', '_', 'R', 'A', 'S', 'T', 'E', 'R', 'I', 'Z', 'A', 'T', 'I', 'O', 'N', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SU_OVER_RASTERIZATION_CNTL (18220) */
	'P', 'A', '_', 'S', 'T', 'E', 'R', 'E', 'O', '_', 'C', 'N', 'T', 'L', '\0', /* PA_STEREO_CNTL (18250) */
	'P', 'A', '_', 'S', 'T', 'A', 'T', 'E', '_', 'S', 'T', 'E', 'R', 'E', 'O', '_', 'X', '\0', /* PA_STATE_STEREO_X (18265) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'O', 'I', 'N', 'T', '_', 'S', 'I', 'Z', 'E', '\0', /* PA_SU_POINT_SIZE (18283) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'O', 'I', 'N', 'T', '_', 'M', 'I', 'N', 'M', 'A', 'X', '\0', /* PA_SU_POINT_MINMAX (18300) */
	'P', 'A', '_', 'S', 'U', '_', 'L', 'I', 'N', 'E', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SU_LINE_CNTL (18319) */
	'P', 'A', '_', 'S', 'C', '_', 'L', 'I', 'N', 'E', '_', 'S', 'T', 'I', 'P', 'P', 'L', 'E', '\0', /* PA_SC_LINE_STIPPLE (18335) */
	'V', 'G', 'T', '_', 'O', 'U', 'T', 'P', 'U', 'T', '_', 'P', 'A', 'T', 'H', '_', 'C', 'N', 'T', 'L', '\0', /* VGT_OUTPUT_PATH_CNTL (18354) */
	'V', 'G', 'T', '_', 'H', 'O', 'S', '_', 'C', 'N', 'T', 'L', '\0', /* VGT_HOS_CNTL (18375) */
	'V', 'G', 'T', '_', 'H', 'O', 'S', '_', 'M', 'A', 'X', '_', 'T', 'E', 'S', 'S', '_', 'L', 'E', 'V', 'E', 'L', '\0', /* VGT_HOS_MAX_TESS_LEVEL (18388) */
	'V', 'G', 'T', '_', 'H', 'O', 'S', '_', 'M', 'I', 'N', '_', 'T', 'E', 'S', 'S', '_', 'L', 'E', 'V', 'E', 'L', '\0', /* VGT_HOS_MIN_TESS_LEVEL (18411) */
	'V', 'G', 'T', '_', 'H', 'O', 'S', '_', 'R', 'E', 'U', 'S', 'E', '_', 'D', 'E', 'P', 'T', 'H', '\0', /* VGT_HOS_REUSE_DEPTH (18434, 18442, 18448) */
	'V', 'G', 'T', '_', 'G', 'R', 'O', 'U', 'P', '_', 'P', 'R', 'I', 'M', '_', 'T', 'Y', 'P', 'E', '\0', /* VGT_GROUP_PRIM_TYPE (18454, 18464) */
	'V', 'G', 'T', '_', 'G', 'R', 'O', 'U', 'P', '_', 'F', 'I', 'R', 'S', 'T', '_', 'D', 'E', 'C', 'R', '\0', /* VGT_GROUP_FIRST_DECR (18474, 18484, 18490) */
	'V', 'G', 'T', '_', 'G', 'R', 'O', 'U', 'P', '_', 'D', 'E', 'C', 'R', '\0', /* VGT_GROUP_DECR (18495) */
	'V', 'G', 'T', '_', 'G', 'R', 'O', 'U', 'P', '_', 'V', 'E', 'C', 'T', '_', '0', '_', 'C', 'N', 'T', 'L', '\0', /* VGT_GROUP_VECT_0_CNTL (18510) */
	'V', 'G', 'T', '_', 'G', 'R', 'O', 'U', 'P', '_', 'V', 'E', 'C', 'T', '_', '1', '_', 'C', 'N', 'T', 'L', '\0', /* VGT_GROUP_VECT_1_CNTL (18532) */
	'V', 'G', 'T', '_', 'G', 'R', 'O', 'U', 'P', '_', 'V', 'E', 'C', 'T', '_', '0', '_', 'F', 'M', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* VGT_GROUP_VECT_0_FMT_CNTL (18554) */
	'V', 'G', 'T', '_', 'G', 'R', 'O', 'U', 'P', '_', 'V', 'E', 'C', 'T', '_', '1', '_', 'F', 'M', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* VGT_GROUP_VECT_1_FMT_CNTL (18580) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'M', 'O', 'D', 'E', '\0', /* VGT_GS_MODE (18606) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'O', 'N', 'C', 'H', 'I', 'P', '_', 'C', 'N', 'T', 'L', '\0', /* VGT_GS_ONCHIP_CNTL (18618) */
	'P', 'A', '_', 'S', 'C', '_', 'M', 'O', 'D', 'E', '_', 'C', 'N', 'T', 'L', '_', '0', '\0', /* PA_SC_MODE_CNTL_0 (18637) */
	'P', 'A', '_', 'S', 'C', '_', 'M', 'O', 'D', 'E', '_', 'C', 'N', 'T', 'L', '_', '1', '\0', /* PA_SC_MODE_CNTL_1 (18655) */
	'V', 'G', 'T', '_', 'E', 'N', 'H', 'A', 'N', 'C', 'E', '\0', /* VGT_ENHANCE (18673, 18682) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'P', 'E', 'R', '_', 'E', 'S', '\0', /* VGT_GS_PER_ES (18685, 18689) */
	'V', 'G', 'T', '_', 'E', 'S', '_', 'P', 'E', 'R', '_', 'G', 'S', '\0', /* VGT_ES_PER_GS (18699, 18703) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'P', 'E', 'R', '_', 'V', 'S', '\0', /* VGT_GS_PER_VS (18713, 18717) */
	'V', 'G', 'T', '_', 'G', 'S', 'V', 'S', '_', 'R', 'I', 'N', 'G', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '\0', /* VGT_GSVS_RING_OFFSET_1 (18727) */
	'V', 'G', 'T', '_', 'G', 'S', 'V', 'S', '_', 'R', 'I', 'N', 'G', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', '2', '\0', /* VGT_GSVS_RING_OFFSET_2 (18750) */
	'V', 'G', 'T', '_', 'G', 'S', 'V', 'S', '_', 'R', 'I', 'N', 'G', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', '3', '\0', /* VGT_GSVS_RING_OFFSET_3 (18773) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'O', 'U', 'T', '_', 'P', 'R', 'I', 'M', '_', 'T', 'Y', 'P', 'E', '\0', /* VGT_GS_OUT_PRIM_TYPE (18796) */
	'I', 'A', '_', 'E', 'N', 'H', 'A', 'N', 'C', 'E', '\0', /* IA_ENHANCE (18817) */
	'V', 'G', 'T', '_', 'D', 'M', 'A', '_', 'S', 'I', 'Z', 'E', '\0', /* VGT_DMA_SIZE (18828) */
	'V', 'G', 'T', '_', 'D', 'M', 'A', '_', 'M', 'A', 'X', '_', 'S', 'I', 'Z', 'E', '\0', /* VGT_DMA_MAX_SIZE (18841, 18849) */
	'V', 'G', 'T', '_', 'D', 'M', 'A', '_', 'I', 'N', 'D', 'E', 'X', '_', 'T', 'Y', 'P', 'E', '\0', /* VGT_DMA_INDEX_TYPE (18858) */
	'W', 'D', '_', 'E', 'N', 'H', 'A', 'N', 'C', 'E', '\0', /* WD_ENHANCE (18877) */
	'V', 'G', 'T', '_', 'P', 'R', 'I', 'M', 'I', 'T', 'I', 'V', 'E', 'I', 'D', '_', 'E', 'N', '\0', /* VGT_PRIMITIVEID_EN (18888, 18892) */
	'V', 'G', 'T', '_', 'D', 'M', 'A', '_', 'N', 'U', 'M', '_', 'I', 'N', 'S', 'T', 'A', 'N', 'C', 'E', 'S', '\0', /* VGT_DMA_NUM_INSTANCES (18907) */
	'V', 'G', 'T', '_', 'P', 'R', 'I', 'M', 'I', 'T', 'I', 'V', 'E', 'I', 'D', '_', 'R', 'E', 'S', 'E', 'T', '\0', /* VGT_PRIMITIVEID_RESET (18929, 18945) */
	'V', 'G', 'T', '_', 'E', 'V', 'E', 'N', 'T', '_', 'I', 'N', 'I', 'T', 'I', 'A', 'T', 'O', 'R', '\0', /* VGT_EVENT_INITIATOR (18951) */
	'V', 'G', 'T', '_', 'M', 'U', 'L', 'T', 'I', '_', 'P', 'R', 'I', 'M', '_', 'I', 'B', '_', 'R', 'E', 'S', 'E', 'T', '_', 'E', 'N', '\0', /* VGT_MULTI_PRIM_IB_RESET_EN (18971, 18989) */
	'V', 'G', 'T', '_', 'D', 'R', 'A', 'W', '_', 'P', 'A', 'Y', 'L', 'O', 'A', 'D', '_', 'C', 'N', 'T', 'L', '\0', /* VGT_DRAW_PAYLOAD_CNTL (18998) */
	'V', 'G', 'T', '_', 'I', 'N', 'S', 'T', 'A', 'N', 'C', 'E', '_', 'S', 'T', 'E', 'P', '_', 'R', 'A', 'T', 'E', '_', '0', '\0', /* VGT_INSTANCE_STEP_RATE_0 (19020) */
	'V', 'G', 'T', '_', 'I', 'N', 'S', 'T', 'A', 'N', 'C', 'E', '_', 'S', 'T', 'E', 'P', '_', 'R', 'A', 'T', 'E', '_', '1', '\0', /* VGT_INSTANCE_STEP_RATE_1 (19045) */
	'I', 'A', '_', 'M', 'U', 'L', 'T', 'I', '_', 'V', 'G', 'T', '_', 'P', 'A', 'R', 'A', 'M', '\0', /* IA_MULTI_VGT_PARAM (19070) */
	'V', 'G', 'T', '_', 'E', 'S', 'G', 'S', '_', 'R', 'I', 'N', 'G', '_', 'I', 'T', 'E', 'M', 'S', 'I', 'Z', 'E', '\0', /* VGT_ESGS_RING_ITEMSIZE (19089, 19103) */
	'V', 'G', 'T', '_', 'G', 'S', 'V', 'S', '_', 'R', 'I', 'N', 'G', '_', 'I', 'T', 'E', 'M', 'S', 'I', 'Z', 'E', '\0', /* VGT_GSVS_RING_ITEMSIZE (19112) */
	'V', 'G', 'T', '_', 'R', 'E', 'U', 'S', 'E', '_', 'O', 'F', 'F', '\0', /* VGT_REUSE_OFF (19135, 19139) */
	'V', 'G', 'T', '_', 'V', 'T', 'X', '_', 'C', 'N', 'T', '_', 'E', 'N', '\0', /* VGT_VTX_CNT_EN (19149, 19153) */
	'D', 'B', '_', 'H', 'T', 'I', 'L', 'E', '_', 'S', 'U', 'R', 'F', 'A', 'C', 'E', '\0', /* DB_HTILE_SURFACE (19164, 19176) */
	'D', 'B', '_', 'S', 'R', 'E', 'S', 'U', 'L', 'T', 'S', '_', 'C', 'O', 'M', 'P', 'A', 'R', 'E', '_', 'S', 'T', 'A', 'T', 'E', '0', '\0', /* DB_SRESULTS_COMPARE_STATE0 (19181) */
	'D', 'B', '_', 'S', 'R', 'E', 'S', 'U', 'L', 'T', 'S', '_', 'C', 'O', 'M', 'P', 'A', 'R', 'E', '_', 'S', 'T', 'A', 'T', 'E', '1', '\0', /* DB_SRESULTS_COMPARE_STATE1 (19208) */
	'D', 'B', '_', 'P', 'R', 'E', 'L', 'O', 'A', 'D', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* DB_PRELOAD_CONTROL (19235) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'S', 'I', 'Z', 'E', '_', '0', '\0', /* VGT_STRMOUT_BUFFER_SIZE_0 (19254) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'V', 'T', 'X', '_', 'S', 'T', 'R', 'I', 'D', 'E', '_', '0', '\0', /* VGT_STRMOUT_VTX_STRIDE_0 (19280) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', '0', '\0', /* VGT_STRMOUT_BUFFER_OFFSET_0 (19305) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'S', 'I', 'Z', 'E', '_', '1', '\0', /* VGT_STRMOUT_BUFFER_SIZE_1 (19333) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'V', 'T', 'X', '_', 'S', 'T', 'R', 'I', 'D', 'E', '_', '1', '\0', /* VGT_STRMOUT_VTX_STRIDE_1 (19359) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '\0', /* VGT_STRMOUT_BUFFER_OFFSET_1 (19384) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'S', 'I', 'Z', 'E', '_', '2', '\0', /* VGT_STRMOUT_BUFFER_SIZE_2 (19412) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'V', 'T', 'X', '_', 'S', 'T', 'R', 'I', 'D', 'E', '_', '2', '\0', /* VGT_STRMOUT_VTX_STRIDE_2 (19438) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', '2', '\0', /* VGT_STRMOUT_BUFFER_OFFSET_2 (19463) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'S', 'I', 'Z', 'E', '_', '3', '\0', /* VGT_STRMOUT_BUFFER_SIZE_3 (19491) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'V', 'T', 'X', '_', 'S', 'T', 'R', 'I', 'D', 'E', '_', '3', '\0', /* VGT_STRMOUT_VTX_STRIDE_3 (19517) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', '3', '\0', /* VGT_STRMOUT_BUFFER_OFFSET_3 (19542) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'D', 'R', 'A', 'W', '_', 'O', 'P', 'A', 'Q', 'U', 'E', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* VGT_STRMOUT_DRAW_OPAQUE_OFFSET (19570) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'D', 'R', 'A', 'W', '_', 'O', 'P', 'A', 'Q', 'U', 'E', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'F', 'I', 'L', 'L', 'E', 'D', '_', 'S', 'I', 'Z', 'E', '\0', /* VGT_STRMOUT_DRAW_OPAQUE_BUFFER_FILLED_SIZE (19601) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'D', 'R', 'A', 'W', '_', 'O', 'P', 'A', 'Q', 'U', 'E', '_', 'V', 'E', 'R', 'T', 'E', 'X', '_', 'S', 'T', 'R', 'I', 'D', 'E', '\0', /* VGT_STRMOUT_DRAW_OPAQUE_VERTEX_STRIDE (19644, 19668, 19675) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'M', 'A', 'X', '_', 'V', 'E', 'R', 'T', '_', 'O', 'U', 'T', '\0', /* VGT_GS_MAX_VERT_OUT (19682, 19689, 19698) */
	'G', 'E', '_', 'N', 'G', 'G', '_', 'S', 'U', 'B', 'G', 'R', 'P', '_', 'C', 'N', 'T', 'L', '\0', /* GE_NGG_SUBGRP_CNTL (19702) */
	'V', 'G', 'T', '_', 'T', 'E', 'S', 'S', '_', 'D', 'I', 'S', 'T', 'R', 'I', 'B', 'U', 'T', 'I', 'O', 'N', '\0', /* VGT_TESS_DISTRIBUTION (19721) */
	'V', 'G', 'T', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'S', 'T', 'A', 'G', 'E', 'S', '_', 'E', 'N', '\0', /* VGT_SHADER_STAGES_EN (19743, 19758) */
	'V', 'G', 'T', '_', 'L', 'S', '_', 'H', 'S', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* VGT_LS_HS_CONFIG (19764) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'V', 'E', 'R', 'T', '_', 'I', 'T', 'E', 'M', 'S', 'I', 'Z', 'E', '\0', /* VGT_GS_VERT_ITEMSIZE (19781) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'V', 'E', 'R', 'T', '_', 'I', 'T', 'E', 'M', 'S', 'I', 'Z', 'E', '_', '1', '\0', /* VGT_GS_VERT_ITEMSIZE_1 (19802) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'V', 'E', 'R', 'T', '_', 'I', 'T', 'E', 'M', 'S', 'I', 'Z', 'E', '_', '2', '\0', /* VGT_GS_VERT_ITEMSIZE_2 (19825) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'V', 'E', 'R', 'T', '_', 'I', 'T', 'E', 'M', 'S', 'I', 'Z', 'E', '_', '3', '\0', /* VGT_GS_VERT_ITEMSIZE_3 (19848) */
	'V', 'G', 'T', '_', 'T', 'F', '_', 'P', 'A', 'R', 'A', 'M', '\0', /* VGT_TF_PARAM (19871) */
	'D', 'B', '_', 'A', 'L', 'P', 'H', 'A', '_', 'T', 'O', '_', 'M', 'A', 'S', 'K', '\0', /* DB_ALPHA_TO_MASK (19884) */
	'V', 'G', 'T', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'D', 'R', 'A', 'W', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* VGT_DISPATCH_DRAW_INDEX (19901) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'O', 'L', 'Y', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', 'D', 'B', '_', 'F', 'M', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SU_POLY_OFFSET_DB_FMT_CNTL (19925) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'O', 'L', 'Y', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', 'C', 'L', 'A', 'M', 'P', '\0', /* PA_SU_POLY_OFFSET_CLAMP (19955) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'O', 'L', 'Y', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', 'F', 'R', 'O', 'N', 'T', '_', 'S', 'C', 'A', 'L', 'E', '\0', /* PA_SU_POLY_OFFSET_FRONT_SCALE (19979) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'O', 'L', 'Y', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', 'F', 'R', 'O', 'N', 'T', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* PA_SU_POLY_OFFSET_FRONT_OFFSET (20009) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'O', 'L', 'Y', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', 'B', 'A', 'C', 'K', '_', 'S', 'C', 'A', 'L', 'E', '\0', /* PA_SU_POLY_OFFSET_BACK_SCALE (20040) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'O', 'L', 'Y', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', 'B', 'A', 'C', 'K', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* PA_SU_POLY_OFFSET_BACK_OFFSET (20069) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'I', 'N', 'S', 'T', 'A', 'N', 'C', 'E', '_', 'C', 'N', 'T', '\0', /* VGT_GS_INSTANCE_CNT (20099, 20115) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* VGT_STRMOUT_CONFIG (20119) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* VGT_STRMOUT_BUFFER_CONFIG (20138) */
	'V', 'G', 'T', '_', 'D', 'M', 'A', '_', 'E', 'V', 'E', 'N', 'T', '_', 'I', 'N', 'I', 'T', 'I', 'A', 'T', 'O', 'R', '\0', /* VGT_DMA_EVENT_INITIATOR (20164) */
	'P', 'A', '_', 'S', 'C', '_', 'C', 'E', 'N', 'T', 'R', 'O', 'I', 'D', '_', 'P', 'R', 'I', 'O', 'R', 'I', 'T', 'Y', '_', '0', '\0', /* PA_SC_CENTROID_PRIORITY_0 (20188) */
	'P', 'A', '_', 'S', 'C', '_', 'C', 'E', 'N', 'T', 'R', 'O', 'I', 'D', '_', 'P', 'R', 'I', 'O', 'R', 'I', 'T', 'Y', '_', '1', '\0', /* PA_SC_CENTROID_PRIORITY_1 (20214) */
	'P', 'A', '_', 'S', 'C', '_', 'L', 'I', 'N', 'E', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SC_LINE_CNTL (20240) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* PA_SC_AA_CONFIG (20256) */
	'P', 'A', '_', 'S', 'U', '_', 'V', 'T', 'X', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SU_VTX_CNTL (20272) */
	'P', 'A', '_', 'C', 'L', '_', 'G', 'B', '_', 'V', 'E', 'R', 'T', '_', 'C', 'L', 'I', 'P', '_', 'A', 'D', 'J', '\0', /* PA_CL_GB_VERT_CLIP_ADJ (20287) */
	'P', 'A', '_', 'C', 'L', '_', 'G', 'B', '_', 'V', 'E', 'R', 'T', '_', 'D', 'I', 'S', 'C', '_', 'A', 'D', 'J', '\0', /* PA_CL_GB_VERT_DISC_ADJ (20310) */
	'P', 'A', '_', 'C', 'L', '_', 'G', 'B', '_', 'H', 'O', 'R', 'Z', '_', 'C', 'L', 'I', 'P', '_', 'A', 'D', 'J', '\0', /* PA_CL_GB_HORZ_CLIP_ADJ (20333) */
	'P', 'A', '_', 'C', 'L', '_', 'G', 'B', '_', 'H', 'O', 'R', 'Z', '_', 'D', 'I', 'S', 'C', '_', 'A', 'D', 'J', '\0', /* PA_CL_GB_HORZ_DISC_ADJ (20356) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '0', 'Y', '0', '_', '0', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_0 (20379) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '0', 'Y', '0', '_', '1', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_1 (20413) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '0', 'Y', '0', '_', '2', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_2 (20447) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '0', 'Y', '0', '_', '3', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_3 (20481) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '1', 'Y', '0', '_', '0', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_0 (20515) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '1', 'Y', '0', '_', '1', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_1 (20549) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '1', 'Y', '0', '_', '2', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_2 (20583) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '1', 'Y', '0', '_', '3', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_3 (20617) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '0', 'Y', '1', '_', '0', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_0 (20651) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '0', 'Y', '1', '_', '1', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_1 (20685) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '0', 'Y', '1', '_', '2', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_2 (20719) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '0', 'Y', '1', '_', '3', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_3 (20753) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '1', 'Y', '1', '_', '0', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_0 (20787) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '1', 'Y', '1', '_', '1', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_1 (20821) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '1', 'Y', '1', '_', '2', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_2 (20855) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '1', 'Y', '1', '_', '3', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_3 (20889) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'M', 'A', 'S', 'K', '_', 'X', '0', 'Y', '0', '_', 'X', '1', 'Y', '0', '\0', /* PA_SC_AA_MASK_X0Y0_X1Y0 (20923) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'M', 'A', 'S', 'K', '_', 'X', '0', 'Y', '1', '_', 'X', '1', 'Y', '1', '\0', /* PA_SC_AA_MASK_X0Y1_X1Y1 (20947) */
	'P', 'A', '_', 'S', 'C', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* PA_SC_SHADER_CONTROL (20971) */
	'P', 'A', '_', 'S', 'C', '_', 'B', 'I', 'N', 'N', 'E', 'R', '_', 'C', 'N', 'T', 'L', '_', '0', '\0', /* PA_SC_BINNER_CNTL_0 (20992) */
	'P', 'A', '_', 'S', 'C', '_', 'B', 'I', 'N', 'N', 'E', 'R', '_', 'C', 'N', 'T', 'L', '_', '1', '\0', /* PA_SC_BINNER_CNTL_1 (21012) */
	'P', 'A', '_', 'S', 'C', '_', 'C', 'O', 'N', 'S', 'E', 'R', 'V', 'A', 'T', 'I', 'V', 'E', '_', 'R', 'A', 'S', 'T', 'E', 'R', 'I', 'Z', 'A', 'T', 'I', 'O', 'N', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SC_CONSERVATIVE_RASTERIZATION_CNTL (21032) */
	'P', 'A', '_', 'S', 'C', '_', 'N', 'G', 'G', '_', 'M', 'O', 'D', 'E', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SC_NGG_MODE_CNTL (21070) */
	'V', 'G', 'T', '_', 'V', 'E', 'R', 'T', 'E', 'X', '_', 'R', 'E', 'U', 'S', 'E', '_', 'B', 'L', 'O', 'C', 'K', '_', 'C', 'N', 'T', 'L', '\0', /* VGT_VERTEX_REUSE_BLOCK_CNTL (21090) */
	'V', 'G', 'T', '_', 'O', 'U', 'T', '_', 'D', 'E', 'A', 'L', 'L', 'O', 'C', '_', 'C', 'N', 'T', 'L', '\0', /* VGT_OUT_DEALLOC_CNTL (21118) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR0_BASE (21139) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_COLOR0_PITCH (21154, 21164) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR0_SLICE (21170) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'V', 'I', 'E', 'W', '\0', /* CB_COLOR0_VIEW (21186) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'I', 'N', 'F', 'O', '\0', /* CB_COLOR0_INFO (21201) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'A', 'T', 'T', 'R', 'I', 'B', '\0', /* CB_COLOR0_ATTRIB (21216) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR0_DCC_CONTROL (21233) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'C', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR0_CMASK (21255) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'C', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR0_CMASK_SLICE (21271) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'F', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR0_FMASK (21293) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'F', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR0_FMASK_SLICE (21309) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '0', '\0', /* CB_COLOR0_CLEAR_WORD0 (21331) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '1', '\0', /* CB_COLOR0_CLEAR_WORD1 (21353) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR0_DCC_BASE (21375) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR1_BASE (21394) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_COLOR1_PITCH (21409) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR1_SLICE (21425) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'V', 'I', 'E', 'W', '\0', /* CB_COLOR1_VIEW (21441) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'I', 'N', 'F', 'O', '\0', /* CB_COLOR1_INFO (21456) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'A', 'T', 'T', 'R', 'I', 'B', '\0', /* CB_COLOR1_ATTRIB (21471) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR1_DCC_CONTROL (21488) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'C', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR1_CMASK (21510) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'C', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR1_CMASK_SLICE (21526) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'F', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR1_FMASK (21548) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'F', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR1_FMASK_SLICE (21564) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '0', '\0', /* CB_COLOR1_CLEAR_WORD0 (21586) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '1', '\0', /* CB_COLOR1_CLEAR_WORD1 (21608) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR1_DCC_BASE (21630) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR2_BASE (21649) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_COLOR2_PITCH (21664) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR2_SLICE (21680) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'V', 'I', 'E', 'W', '\0', /* CB_COLOR2_VIEW (21696) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'I', 'N', 'F', 'O', '\0', /* CB_COLOR2_INFO (21711) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'A', 'T', 'T', 'R', 'I', 'B', '\0', /* CB_COLOR2_ATTRIB (21726) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR2_DCC_CONTROL (21743) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'C', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR2_CMASK (21765) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'C', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR2_CMASK_SLICE (21781) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'F', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR2_FMASK (21803) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'F', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR2_FMASK_SLICE (21819) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '0', '\0', /* CB_COLOR2_CLEAR_WORD0 (21841) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '1', '\0', /* CB_COLOR2_CLEAR_WORD1 (21863) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR2_DCC_BASE (21885) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR3_BASE (21904) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_COLOR3_PITCH (21919) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR3_SLICE (21935) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'V', 'I', 'E', 'W', '\0', /* CB_COLOR3_VIEW (21951) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'I', 'N', 'F', 'O', '\0', /* CB_COLOR3_INFO (21966) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'A', 'T', 'T', 'R', 'I', 'B', '\0', /* CB_COLOR3_ATTRIB (21981) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR3_DCC_CONTROL (21998) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'C', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR3_CMASK (22020) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'C', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR3_CMASK_SLICE (22036) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'F', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR3_FMASK (22058) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'F', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR3_FMASK_SLICE (22074) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '0', '\0', /* CB_COLOR3_CLEAR_WORD0 (22096) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '1', '\0', /* CB_COLOR3_CLEAR_WORD1 (22118) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR3_DCC_BASE (22140) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR4_BASE (22159) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_COLOR4_PITCH (22174) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR4_SLICE (22190) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'V', 'I', 'E', 'W', '\0', /* CB_COLOR4_VIEW (22206) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'I', 'N', 'F', 'O', '\0', /* CB_COLOR4_INFO (22221) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'A', 'T', 'T', 'R', 'I', 'B', '\0', /* CB_COLOR4_ATTRIB (22236) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR4_DCC_CONTROL (22253) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'C', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR4_CMASK (22275) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'C', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR4_CMASK_SLICE (22291) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'F', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR4_FMASK (22313) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'F', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR4_FMASK_SLICE (22329) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '0', '\0', /* CB_COLOR4_CLEAR_WORD0 (22351) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '1', '\0', /* CB_COLOR4_CLEAR_WORD1 (22373) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR4_DCC_BASE (22395) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR5_BASE (22414) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_COLOR5_PITCH (22429) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR5_SLICE (22445) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'V', 'I', 'E', 'W', '\0', /* CB_COLOR5_VIEW (22461) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'I', 'N', 'F', 'O', '\0', /* CB_COLOR5_INFO (22476) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'A', 'T', 'T', 'R', 'I', 'B', '\0', /* CB_COLOR5_ATTRIB (22491) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR5_DCC_CONTROL (22508) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'C', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR5_CMASK (22530) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'C', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR5_CMASK_SLICE (22546) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'F', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR5_FMASK (22568) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'F', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR5_FMASK_SLICE (22584) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '0', '\0', /* CB_COLOR5_CLEAR_WORD0 (22606) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '1', '\0', /* CB_COLOR5_CLEAR_WORD1 (22628) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR5_DCC_BASE (22650) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR6_BASE (22669) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_COLOR6_PITCH (22684) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR6_SLICE (22700) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'V', 'I', 'E', 'W', '\0', /* CB_COLOR6_VIEW (22716) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'I', 'N', 'F', 'O', '\0', /* CB_COLOR6_INFO (22731) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'A', 'T', 'T', 'R', 'I', 'B', '\0', /* CB_COLOR6_ATTRIB (22746) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR6_DCC_CONTROL (22763) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'C', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR6_CMASK (22785) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'C', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR6_CMASK_SLICE (22801) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'F', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR6_FMASK (22823) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'F', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR6_FMASK_SLICE (22839) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '0', '\0', /* CB_COLOR6_CLEAR_WORD0 (22861) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '1', '\0', /* CB_COLOR6_CLEAR_WORD1 (22883) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR6_DCC_BASE (22905) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR7_BASE (22924) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_COLOR7_PITCH (22939) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR7_SLICE (22955) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'V', 'I', 'E', 'W', '\0', /* CB_COLOR7_VIEW (22971) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'I', 'N', 'F', 'O', '\0', /* CB_COLOR7_INFO (22986) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'A', 'T', 'T', 'R', 'I', 'B', '\0', /* CB_COLOR7_ATTRIB (23001) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR7_DCC_CONTROL (23018) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'C', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR7_CMASK (23040) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'C', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR7_CMASK_SLICE (23056) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'F', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR7_FMASK (23078) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'F', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR7_FMASK_SLICE (23094) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '0', '\0', /* CB_COLOR7_CLEAR_WORD0 (23116) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '1', '\0', /* CB_COLOR7_CLEAR_WORD1 (23138) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR7_DCC_BASE (23160) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR0_BASE_EXT (23179) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR1_BASE_EXT (23198) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR2_BASE_EXT (23217) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR3_BASE_EXT (23236) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR4_BASE_EXT (23255) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR5_BASE_EXT (23274) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR6_BASE_EXT (23293) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR7_BASE_EXT (23312) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'C', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR0_CMASK_BASE_EXT (23331) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'C', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR1_CMASK_BASE_EXT (23356) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'C', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR2_CMASK_BASE_EXT (23381) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'C', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR3_CMASK_BASE_EXT (23406) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'C', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR4_CMASK_BASE_EXT (23431) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'C', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR5_CMASK_BASE_EXT (23456) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'C', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR6_CMASK_BASE_EXT (23481) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'C', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR7_CMASK_BASE_EXT (23506) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'F', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR0_FMASK_BASE_EXT (23531) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'F', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR1_FMASK_BASE_EXT (23556) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'F', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR2_FMASK_BASE_EXT (23581) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'F', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR3_FMASK_BASE_EXT (23606) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'F', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR4_FMASK_BASE_EXT (23631) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'F', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR5_FMASK_BASE_EXT (23656) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'F', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR6_FMASK_BASE_EXT (23681) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'F', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR7_FMASK_BASE_EXT (23706) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR0_DCC_BASE_EXT (23731) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR1_DCC_BASE_EXT (23754) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR2_DCC_BASE_EXT (23777) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR3_DCC_BASE_EXT (23800) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR4_DCC_BASE_EXT (23823) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR5_DCC_BASE_EXT (23846) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR6_DCC_BASE_EXT (23869) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR7_DCC_BASE_EXT (23892) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'A', 'T', 'T', 'R', 'I', 'B', '2', '\0', /* CB_COLOR0_ATTRIB2 (23915) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'A', 'T', 'T', 'R', 'I', 'B', '2', '\0', /* CB_COLOR1_ATTRIB2 (23933) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'A', 'T', 'T', 'R', 'I', 'B', '2', '\0', /* CB_COLOR2_ATTRIB2 (23951) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'A', 'T', 'T', 'R', 'I', 'B', '2', '\0', /* CB_COLOR3_ATTRIB2 (23969) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'A', 'T', 'T', 'R', 'I', 'B', '2', '\0', /* CB_COLOR4_ATTRIB2 (23987) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'A', 'T', 'T', 'R', 'I', 'B', '2', '\0', /* CB_COLOR5_ATTRIB2 (24005) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'A', 'T', 'T', 'R', 'I', 'B', '2', '\0', /* CB_COLOR6_ATTRIB2 (24023) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'A', 'T', 'T', 'R', 'I', 'B', '2', '\0', /* CB_COLOR7_ATTRIB2 (24041) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'A', 'T', 'T', 'R', 'I', 'B', '3', '\0', /* CB_COLOR0_ATTRIB3 (24059) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'A', 'T', 'T', 'R', 'I', 'B', '3', '\0', /* CB_COLOR1_ATTRIB3 (24077) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'A', 'T', 'T', 'R', 'I', 'B', '3', '\0', /* CB_COLOR2_ATTRIB3 (24095) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'A', 'T', 'T', 'R', 'I', 'B', '3', '\0', /* CB_COLOR3_ATTRIB3 (24113) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'A', 'T', 'T', 'R', 'I', 'B', '3', '\0', /* CB_COLOR4_ATTRIB3 (24131) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'A', 'T', 'T', 'R', 'I', 'B', '3', '\0', /* CB_COLOR5_ATTRIB3 (24149) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'A', 'T', 'T', 'R', 'I', 'B', '3', '\0', /* CB_COLOR6_ATTRIB3 (24167) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'A', 'T', 'T', 'R', 'I', 'B', '3', '\0', /* CB_COLOR7_ATTRIB3 (24185) */
	'C', 'P', '_', 'E', 'O', 'P', '_', 'D', 'O', 'N', 'E', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* CP_EOP_DONE_ADDR_LO (24203) */
	'C', 'P', '_', 'E', 'O', 'P', '_', 'D', 'O', 'N', 'E', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_EOP_DONE_ADDR_HI (24223) */
	'C', 'P', '_', 'E', 'O', 'P', '_', 'D', 'O', 'N', 'E', '_', 'D', 'A', 'T', 'A', '_', 'L', 'O', '\0', /* CP_EOP_DONE_DATA_LO (24243) */
	'C', 'P', '_', 'E', 'O', 'P', '_', 'D', 'O', 'N', 'E', '_', 'D', 'A', 'T', 'A', '_', 'H', 'I', '\0', /* CP_EOP_DONE_DATA_HI (24263) */
	'C', 'P', '_', 'E', 'O', 'P', '_', 'L', 'A', 'S', 'T', '_', 'F', 'E', 'N', 'C', 'E', '_', 'L', 'O', '\0', /* CP_EOP_LAST_FENCE_LO (24283) */
	'C', 'P', '_', 'E', 'O', 'P', '_', 'L', 'A', 'S', 'T', '_', 'F', 'E', 'N', 'C', 'E', '_', 'H', 'I', '\0', /* CP_EOP_LAST_FENCE_HI (24304) */
	'C', 'P', '_', 'S', 'T', 'R', 'E', 'A', 'M', '_', 'O', 'U', 'T', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* CP_STREAM_OUT_ADDR_LO (24325, 24328) */
	'C', 'P', '_', 'S', 'T', 'R', 'E', 'A', 'M', '_', 'O', 'U', 'T', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_STREAM_OUT_ADDR_HI (24347, 24350) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', 'C', 'O', 'U', 'N', 'T', '0', '_', 'L', 'O', '\0', /* CP_NUM_PRIM_WRITTEN_COUNT0_LO (24369) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', 'C', 'O', 'U', 'N', 'T', '0', '_', 'H', 'I', '\0', /* CP_NUM_PRIM_WRITTEN_COUNT0_HI (24399) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', 'C', 'O', 'U', 'N', 'T', '0', '_', 'L', 'O', '\0', /* CP_NUM_PRIM_NEEDED_COUNT0_LO (24429) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', 'C', 'O', 'U', 'N', 'T', '0', '_', 'H', 'I', '\0', /* CP_NUM_PRIM_NEEDED_COUNT0_HI (24458) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', 'C', 'O', 'U', 'N', 'T', '1', '_', 'L', 'O', '\0', /* CP_NUM_PRIM_WRITTEN_COUNT1_LO (24487) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', 'C', 'O', 'U', 'N', 'T', '1', '_', 'H', 'I', '\0', /* CP_NUM_PRIM_WRITTEN_COUNT1_HI (24517) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', 'C', 'O', 'U', 'N', 'T', '1', '_', 'L', 'O', '\0', /* CP_NUM_PRIM_NEEDED_COUNT1_LO (24547) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', 'C', 'O', 'U', 'N', 'T', '1', '_', 'H', 'I', '\0', /* CP_NUM_PRIM_NEEDED_COUNT1_HI (24576) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', 'C', 'O', 'U', 'N', 'T', '2', '_', 'L', 'O', '\0', /* CP_NUM_PRIM_WRITTEN_COUNT2_LO (24605) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', 'C', 'O', 'U', 'N', 'T', '2', '_', 'H', 'I', '\0', /* CP_NUM_PRIM_WRITTEN_COUNT2_HI (24635) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', 'C', 'O', 'U', 'N', 'T', '2', '_', 'L', 'O', '\0', /* CP_NUM_PRIM_NEEDED_COUNT2_LO (24665) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', 'C', 'O', 'U', 'N', 'T', '2', '_', 'H', 'I', '\0', /* CP_NUM_PRIM_NEEDED_COUNT2_HI (24694) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', 'C', 'O', 'U', 'N', 'T', '3', '_', 'L', 'O', '\0', /* CP_NUM_PRIM_WRITTEN_COUNT3_LO (24723) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', 'C', 'O', 'U', 'N', 'T', '3', '_', 'H', 'I', '\0', /* CP_NUM_PRIM_WRITTEN_COUNT3_HI (24753) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', 'C', 'O', 'U', 'N', 'T', '3', '_', 'L', 'O', '\0', /* CP_NUM_PRIM_NEEDED_COUNT3_LO (24783) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', 'C', 'O', 'U', 'N', 'T', '3', '_', 'H', 'I', '\0', /* CP_NUM_PRIM_NEEDED_COUNT3_HI (24812) */
	'C', 'P', '_', 'P', 'I', 'P', 'E', '_', 'S', 'T', 'A', 'T', 'S', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* CP_PIPE_STATS_ADDR_LO (24841, 24844) */
	'C', 'P', '_', 'P', 'I', 'P', 'E', '_', 'S', 'T', 'A', 'T', 'S', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_PIPE_STATS_ADDR_HI (24863, 24866) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'I', 'A', 'V', 'E', 'R', 'T', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', '\0', /* CP_VGT_IAVERT_COUNT_LO (24885) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'I', 'A', 'V', 'E', 'R', 'T', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* CP_VGT_IAVERT_COUNT_HI (24908, 24922) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'I', 'A', 'P', 'R', 'I', 'M', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', '\0', /* CP_VGT_IAPRIM_COUNT_LO (24931) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'I', 'A', 'P', 'R', 'I', 'M', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* CP_VGT_IAPRIM_COUNT_HI (24954) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'G', 'S', 'P', 'R', 'I', 'M', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', '\0', /* CP_VGT_GSPRIM_COUNT_LO (24977) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'G', 'S', 'P', 'R', 'I', 'M', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* CP_VGT_GSPRIM_COUNT_HI (25000) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'V', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', '\0', /* CP_VGT_VSINVOC_COUNT_LO (25023) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'V', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* CP_VGT_VSINVOC_COUNT_HI (25047) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'G', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', '\0', /* CP_VGT_GSINVOC_COUNT_LO (25071) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'G', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* CP_VGT_GSINVOC_COUNT_HI (25095) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'H', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', '\0', /* CP_VGT_HSINVOC_COUNT_LO (25119) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'H', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* CP_VGT_HSINVOC_COUNT_HI (25143) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'D', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', '\0', /* CP_VGT_DSINVOC_COUNT_LO (25167) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'D', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* CP_VGT_DSINVOC_COUNT_HI (25191) */
	'C', 'P', '_', 'P', 'A', '_', 'C', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', '\0', /* CP_PA_CINVOC_COUNT_LO (25215) */
	'C', 'P', '_', 'P', 'A', '_', 'C', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* CP_PA_CINVOC_COUNT_HI (25237) */
	'C', 'P', '_', 'P', 'A', '_', 'C', 'P', 'R', 'I', 'M', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', '\0', /* CP_PA_CPRIM_COUNT_LO (25259) */
	'C', 'P', '_', 'P', 'A', '_', 'C', 'P', 'R', 'I', 'M', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* CP_PA_CPRIM_COUNT_HI (25280) */
	'C', 'P', '_', 'S', 'C', '_', 'P', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '0', '_', 'L', 'O', '\0', /* CP_SC_PSINVOC_COUNT0_LO (25301) */
	'C', 'P', '_', 'S', 'C', '_', 'P', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '0', '_', 'H', 'I', '\0', /* CP_SC_PSINVOC_COUNT0_HI (25325) */
	'C', 'P', '_', 'S', 'C', '_', 'P', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '1', '_', 'L', 'O', '\0', /* CP_SC_PSINVOC_COUNT1_LO (25349) */
	'C', 'P', '_', 'S', 'C', '_', 'P', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '1', '_', 'H', 'I', '\0', /* CP_SC_PSINVOC_COUNT1_HI (25373) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'C', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', '\0', /* CP_VGT_CSINVOC_COUNT_LO (25397) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'C', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* CP_VGT_CSINVOC_COUNT_HI (25421) */
	'C', 'P', '_', 'E', 'O', 'P', '_', 'D', 'O', 'N', 'E', '_', 'D', 'O', 'O', 'R', 'B', 'E', 'L', 'L', '\0', /* CP_EOP_DONE_DOORBELL (25445) */
	'C', 'P', '_', 'S', 'T', 'R', 'E', 'A', 'M', '_', 'O', 'U', 'T', '_', 'D', 'O', 'O', 'R', 'B', 'E', 'L', 'L', '\0', /* CP_STREAM_OUT_DOORBELL (25466) */
	'C', 'P', '_', 'S', 'E', 'M', '_', 'D', 'O', 'O', 'R', 'B', 'E', 'L', 'L', '\0', /* CP_SEM_DOORBELL (25489) */
	'C', 'P', '_', 'P', 'I', 'P', 'E', '_', 'S', 'T', 'A', 'T', 'S', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CP_PIPE_STATS_CONTROL (25505) */
	'C', 'P', '_', 'S', 'T', 'R', 'E', 'A', 'M', '_', 'O', 'U', 'T', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CP_STREAM_OUT_CONTROL (25527) */
	'C', 'P', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* CP_STRMOUT_CNTL (25549) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '0', '\0', /* SCRATCH_REG0 (25565) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '1', '\0', /* SCRATCH_REG1 (25578) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '2', '\0', /* SCRATCH_REG2 (25591) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '3', '\0', /* SCRATCH_REG3 (25604) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '4', '\0', /* SCRATCH_REG4 (25617) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '5', '\0', /* SCRATCH_REG5 (25630) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '6', '\0', /* SCRATCH_REG6 (25643) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '7', '\0', /* SCRATCH_REG7 (25656) */
	'C', 'P', '_', 'P', 'I', 'P', 'E', '_', 'S', 'T', 'A', 'T', 'S', '_', 'D', 'O', 'O', 'R', 'B', 'E', 'L', 'L', '\0', /* CP_PIPE_STATS_DOORBELL (25669) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'D', 'D', 'I', 'D', '_', 'C', 'N', 'T', '\0', /* CP_APPEND_DDID_CNT (25692) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'D', 'A', 'T', 'A', '_', 'H', 'I', '\0', /* CP_APPEND_DATA_HI (25711) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'L', 'A', 'S', 'T', '_', 'C', 'S', '_', 'F', 'E', 'N', 'C', 'E', '_', 'H', 'I', '\0', /* CP_APPEND_LAST_CS_FENCE_HI (25729) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'L', 'A', 'S', 'T', '_', 'P', 'S', '_', 'F', 'E', 'N', 'C', 'E', '_', 'H', 'I', '\0', /* CP_APPEND_LAST_PS_FENCE_HI (25756) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'U', 'M', 'S', 'K', '\0', /* SCRATCH_UMSK (25783) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'A', 'D', 'D', 'R', '\0', /* SCRATCH_ADDR (25796) */
	'C', 'P', '_', 'P', 'F', 'P', '_', 'A', 'T', 'O', 'M', 'I', 'C', '_', 'P', 'R', 'E', 'O', 'P', '_', 'L', 'O', '\0', /* CP_PFP_ATOMIC_PREOP_LO (25809) */
	'C', 'P', '_', 'P', 'F', 'P', '_', 'A', 'T', 'O', 'M', 'I', 'C', '_', 'P', 'R', 'E', 'O', 'P', '_', 'H', 'I', '\0', /* CP_PFP_ATOMIC_PREOP_HI (25832) */
	'C', 'P', '_', 'P', 'F', 'P', '_', 'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', 'I', 'C', '0', '_', 'P', 'R', 'E', 'O', 'P', '_', 'L', 'O', '\0', /* CP_PFP_GDS_ATOMIC0_PREOP_LO (25855) */
	'C', 'P', '_', 'P', 'F', 'P', '_', 'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', 'I', 'C', '0', '_', 'P', 'R', 'E', 'O', 'P', '_', 'H', 'I', '\0', /* CP_PFP_GDS_ATOMIC0_PREOP_HI (25883) */
	'C', 'P', '_', 'P', 'F', 'P', '_', 'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', 'I', 'C', '1', '_', 'P', 'R', 'E', 'O', 'P', '_', 'L', 'O', '\0', /* CP_PFP_GDS_ATOMIC1_PREOP_LO (25911) */
	'C', 'P', '_', 'P', 'F', 'P', '_', 'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', 'I', 'C', '1', '_', 'P', 'R', 'E', 'O', 'P', '_', 'H', 'I', '\0', /* CP_PFP_GDS_ATOMIC1_PREOP_HI (25939) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* CP_APPEND_ADDR_LO (25967) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_APPEND_ADDR_HI (25985) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'D', 'A', 'T', 'A', '\0', /* CP_APPEND_DATA (26003) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'L', 'A', 'S', 'T', '_', 'C', 'S', '_', 'F', 'E', 'N', 'C', 'E', '\0', /* CP_APPEND_LAST_CS_FENCE (26018) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'L', 'A', 'S', 'T', '_', 'P', 'S', '_', 'F', 'E', 'N', 'C', 'E', '\0', /* CP_APPEND_LAST_PS_FENCE (26042) */
	'C', 'P', '_', 'A', 'T', 'O', 'M', 'I', 'C', '_', 'P', 'R', 'E', 'O', 'P', '_', 'L', 'O', '\0', /* CP_ATOMIC_PREOP_LO (26066) */
	'C', 'P', '_', 'A', 'T', 'O', 'M', 'I', 'C', '_', 'P', 'R', 'E', 'O', 'P', '_', 'H', 'I', '\0', /* CP_ATOMIC_PREOP_HI (26085) */
	'C', 'P', '_', 'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', 'I', 'C', '0', '_', 'P', 'R', 'E', 'O', 'P', '_', 'L', 'O', '\0', /* CP_GDS_ATOMIC0_PREOP_LO (26104) */
	'C', 'P', '_', 'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', 'I', 'C', '0', '_', 'P', 'R', 'E', 'O', 'P', '_', 'H', 'I', '\0', /* CP_GDS_ATOMIC0_PREOP_HI (26128) */
	'C', 'P', '_', 'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', 'I', 'C', '1', '_', 'P', 'R', 'E', 'O', 'P', '_', 'L', 'O', '\0', /* CP_GDS_ATOMIC1_PREOP_LO (26152) */
	'C', 'P', '_', 'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', 'I', 'C', '1', '_', 'P', 'R', 'E', 'O', 'P', '_', 'H', 'I', '\0', /* CP_GDS_ATOMIC1_PREOP_HI (26176) */
	'C', 'P', '_', 'M', 'E', '_', 'M', 'C', '_', 'W', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* CP_ME_MC_WADDR_LO (26200, 26203) */
	'C', 'P', '_', 'M', 'E', '_', 'M', 'C', '_', 'W', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_ME_MC_WADDR_HI (26218, 26221) */
	'C', 'P', '_', 'M', 'E', '_', 'M', 'C', '_', 'W', 'D', 'A', 'T', 'A', '_', 'L', 'O', '\0', /* CP_ME_MC_WDATA_LO (26236) */
	'C', 'P', '_', 'M', 'E', '_', 'M', 'C', '_', 'W', 'D', 'A', 'T', 'A', '_', 'H', 'I', '\0', /* CP_ME_MC_WDATA_HI (26254) */
	'C', 'P', '_', 'M', 'E', '_', 'M', 'C', '_', 'R', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* CP_ME_MC_RADDR_LO (26272, 26275) */
	'C', 'P', '_', 'M', 'E', '_', 'M', 'C', '_', 'R', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_ME_MC_RADDR_HI (26290, 26293) */
	'C', 'P', '_', 'S', 'E', 'M', '_', 'W', 'A', 'I', 'T', '_', 'T', 'I', 'M', 'E', 'R', '\0', /* CP_SEM_WAIT_TIMER (26308) */
	'C', 'P', '_', 'S', 'I', 'G', '_', 'S', 'E', 'M', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* CP_SIG_SEM_ADDR_LO (26326, 26333) */
	'C', 'P', '_', 'S', 'I', 'G', '_', 'S', 'E', 'M', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_SIG_SEM_ADDR_HI (26345, 26352) */
	'C', 'P', '_', 'W', 'A', 'I', 'T', '_', 'R', 'E', 'G', '_', 'M', 'E', 'M', '_', 'T', 'I', 'M', 'E', 'O', 'U', 'T', '\0', /* CP_WAIT_REG_MEM_TIMEOUT (26364) */
	'C', 'P', '_', 'W', 'A', 'I', 'T', '_', 'S', 'E', 'M', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* CP_WAIT_SEM_ADDR_LO (26388) */
	'C', 'P', '_', 'W', 'A', 'I', 'T', '_', 'S', 'E', 'M', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_WAIT_SEM_ADDR_HI (26408) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'P', 'F', 'P', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CP_DMA_PFP_CONTROL (26428) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'M', 'E', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CP_DMA_ME_CONTROL (26447) */
	'C', 'P', '_', 'C', 'O', 'H', 'E', 'R', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* CP_COHER_BASE_HI (26465) */
	'C', 'P', '_', 'C', 'O', 'H', 'E', 'R', '_', 'S', 'T', 'A', 'R', 'T', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* CP_COHER_START_DELAY (26482) */
	'C', 'P', '_', 'C', 'O', 'H', 'E', 'R', '_', 'C', 'N', 'T', 'L', '\0', /* CP_COHER_CNTL (26503) */
	'C', 'P', '_', 'C', 'O', 'H', 'E', 'R', '_', 'S', 'I', 'Z', 'E', '\0', /* CP_COHER_SIZE (26517) */
	'C', 'P', '_', 'C', 'O', 'H', 'E', 'R', '_', 'B', 'A', 'S', 'E', '\0', /* CP_COHER_BASE (26531) */
	'C', 'P', '_', 'C', 'O', 'H', 'E', 'R', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* CP_COHER_STATUS (26545) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'M', 'E', '_', 'S', 'R', 'C', '_', 'A', 'D', 'D', 'R', '\0', /* CP_DMA_ME_SRC_ADDR (26561, 26571) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'M', 'E', '_', 'S', 'R', 'C', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_DMA_ME_SRC_ADDR_HI (26580, 26590) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'M', 'E', '_', 'D', 'S', 'T', '_', 'A', 'D', 'D', 'R', '\0', /* CP_DMA_ME_DST_ADDR (26602, 26612) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'M', 'E', '_', 'D', 'S', 'T', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_DMA_ME_DST_ADDR_HI (26621, 26631) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'M', 'E', '_', 'C', 'O', 'M', 'M', 'A', 'N', 'D', '\0', /* CP_DMA_ME_COMMAND (26643, 26653) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'P', 'F', 'P', '_', 'S', 'R', 'C', '_', 'A', 'D', 'D', 'R', '\0', /* CP_DMA_PFP_SRC_ADDR (26661) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'P', 'F', 'P', '_', 'S', 'R', 'C', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_DMA_PFP_SRC_ADDR_HI (26681) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'P', 'F', 'P', '_', 'D', 'S', 'T', '_', 'A', 'D', 'D', 'R', '\0', /* CP_DMA_PFP_DST_ADDR (26704) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'P', 'F', 'P', '_', 'D', 'S', 'T', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_DMA_PFP_DST_ADDR_HI (26724) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'P', 'F', 'P', '_', 'C', 'O', 'M', 'M', 'A', 'N', 'D', '\0', /* CP_DMA_PFP_COMMAND (26747) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'C', 'N', 'T', 'L', '\0', /* CP_DMA_CNTL (26766) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'R', 'E', 'A', 'D', '_', 'T', 'A', 'G', 'S', '\0', /* CP_DMA_READ_TAGS (26778) */
	'C', 'P', '_', 'C', 'O', 'H', 'E', 'R', '_', 'S', 'I', 'Z', 'E', '_', 'H', 'I', '\0', /* CP_COHER_SIZE_HI (26795) */
	'C', 'P', '_', 'P', 'F', 'P', '_', 'I', 'B', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CP_PFP_IB_CONTROL (26812, 26819) */
	'C', 'P', '_', 'P', 'F', 'P', '_', 'L', 'O', 'A', 'D', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CP_PFP_LOAD_CONTROL (26830) */
	'C', 'P', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* CP_SCRATCH_INDEX (26850) */
	'C', 'P', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'D', 'A', 'T', 'A', '\0', /* CP_SCRATCH_DATA (26867) */
	'C', 'P', '_', 'R', 'B', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* CP_RB_OFFSET (26883, 26886) */
	'C', 'P', '_', 'I', 'B', '1', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* CP_IB1_OFFSET (26896, 26899) */
	'C', 'P', '_', 'I', 'B', '2', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* CP_IB2_OFFSET (26910, 26913) */
	'C', 'P', '_', 'I', 'B', '1', '_', 'P', 'R', 'E', 'A', 'M', 'B', 'L', 'E', '_', 'B', 'E', 'G', 'I', 'N', '\0', /* CP_IB1_PREAMBLE_BEGIN (26924, 26927) */
	'C', 'P', '_', 'I', 'B', '1', '_', 'P', 'R', 'E', 'A', 'M', 'B', 'L', 'E', '_', 'E', 'N', 'D', '\0', /* CP_IB1_PREAMBLE_END (26946, 26949) */
	'C', 'P', '_', 'I', 'B', '2', '_', 'P', 'R', 'E', 'A', 'M', 'B', 'L', 'E', '_', 'B', 'E', 'G', 'I', 'N', '\0', /* CP_IB2_PREAMBLE_BEGIN (26966, 26969) */
	'C', 'P', '_', 'I', 'B', '2', '_', 'P', 'R', 'E', 'A', 'M', 'B', 'L', 'E', '_', 'E', 'N', 'D', '\0', /* CP_IB2_PREAMBLE_END (26988, 26991) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'B', '1', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* CP_CE_IB1_OFFSET (27008) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'B', '2', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* CP_CE_IB2_OFFSET (27025) */
	'C', 'P', '_', 'C', 'E', '_', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '\0', /* CP_CE_COUNTER (27042) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'M', 'E', '_', 'C', 'M', 'D', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* CP_DMA_ME_CMD_ADDR_LO (27056) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'M', 'E', '_', 'C', 'M', 'D', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_DMA_ME_CMD_ADDR_HI (27078) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'P', 'F', 'P', '_', 'C', 'M', 'D', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* CP_DMA_PFP_CMD_ADDR_LO (27100) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'P', 'F', 'P', '_', 'C', 'M', 'D', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_DMA_PFP_CMD_ADDR_HI (27123) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'C', 'M', 'D', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* CP_APPEND_CMD_ADDR_LO (27146) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'C', 'M', 'D', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_APPEND_CMD_ADDR_HI (27168) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'N', 'I', 'T', '_', 'C', 'M', 'D', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_CE_INIT_CMD_BUFSZ (27190) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'B', '1', '_', 'C', 'M', 'D', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_CE_IB1_CMD_BUFSZ (27211) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'B', '2', '_', 'C', 'M', 'D', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_CE_IB2_CMD_BUFSZ (27231) */
	'C', 'P', '_', 'I', 'B', '1', '_', 'C', 'M', 'D', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_IB1_CMD_BUFSZ (27251) */
	'C', 'P', '_', 'I', 'B', '2', '_', 'C', 'M', 'D', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_IB2_CMD_BUFSZ (27268) */
	'C', 'P', '_', 'S', 'T', '_', 'C', 'M', 'D', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_ST_CMD_BUFSZ (27285) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'N', 'I', 'T', '_', 'B', 'A', 'S', 'E', '_', 'L', 'O', '\0', /* CP_CE_INIT_BASE_LO (27301, 27307) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'N', 'I', 'T', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* CP_CE_INIT_BASE_HI (27320, 27326) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'N', 'I', 'T', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_CE_INIT_BUFSZ (27339, 27345) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'B', '1', '_', 'B', 'A', 'S', 'E', '_', 'L', 'O', '\0', /* CP_CE_IB1_BASE_LO (27356, 27362) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'B', '1', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* CP_CE_IB1_BASE_HI (27374, 27380) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'B', '1', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_CE_IB1_BUFSZ (27392, 27398) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'B', '2', '_', 'B', 'A', 'S', 'E', '_', 'L', 'O', '\0', /* CP_CE_IB2_BASE_LO (27408, 27414) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'B', '2', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* CP_CE_IB2_BASE_HI (27426, 27432) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'B', '2', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_CE_IB2_BUFSZ (27444, 27450) */
	'C', 'P', '_', 'I', 'B', '1', '_', 'B', 'A', 'S', 'E', '_', 'L', 'O', '\0', /* CP_IB1_BASE_LO (27460) */
	'C', 'P', '_', 'I', 'B', '1', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* CP_IB1_BASE_HI (27475) */
	'C', 'P', '_', 'I', 'B', '1', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_IB1_BUFSZ (27490) */
	'C', 'P', '_', 'I', 'B', '2', '_', 'B', 'A', 'S', 'E', '_', 'L', 'O', '\0', /* CP_IB2_BASE_LO (27503) */
	'C', 'P', '_', 'I', 'B', '2', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* CP_IB2_BASE_HI (27518) */
	'C', 'P', '_', 'I', 'B', '2', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_IB2_BUFSZ (27533) */
	'C', 'P', '_', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', 'L', 'O', '\0', /* CP_ST_BASE_LO (27546, 27549) */
	'C', 'P', '_', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* CP_ST_BASE_HI (27560, 27563) */
	'C', 'P', '_', 'S', 'T', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_ST_BUFSZ (27574, 27577) */
	'C', 'P', '_', 'E', 'O', 'P', '_', 'D', 'O', 'N', 'E', '_', 'E', 'V', 'E', 'N', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* CP_EOP_DONE_EVENT_CNTL (27586) */
	'C', 'P', '_', 'E', 'O', 'P', '_', 'D', 'O', 'N', 'E', '_', 'D', 'A', 'T', 'A', '_', 'C', 'N', 'T', 'L', '\0', /* CP_EOP_DONE_DATA_CNTL (27609) */
	'C', 'P', '_', 'E', 'O', 'P', '_', 'D', 'O', 'N', 'E', '_', 'C', 'N', 'T', 'X', '_', 'I', 'D', '\0', /* CP_EOP_DONE_CNTX_ID (27631, 27643) */
	'C', 'P', '_', 'D', 'B', '_', 'B', 'A', 'S', 'E', '_', 'L', 'O', '\0', /* CP_DB_BASE_LO (27651, 27654) */
	'C', 'P', '_', 'D', 'B', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* CP_DB_BASE_HI (27665, 27668) */
	'C', 'P', '_', 'D', 'B', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_DB_BUFSZ (27679, 27682) */
	'C', 'P', '_', 'D', 'B', '_', 'C', 'M', 'D', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_DB_CMD_BUFSZ (27691) */
	'C', 'P', '_', 'C', 'E', '_', 'D', 'B', '_', 'B', 'A', 'S', 'E', '_', 'L', 'O', '\0', /* CP_CE_DB_BASE_LO (27707) */
	'C', 'P', '_', 'C', 'E', '_', 'D', 'B', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* CP_CE_DB_BASE_HI (27724) */
	'C', 'P', '_', 'C', 'E', '_', 'D', 'B', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_CE_DB_BUFSZ (27741) */
	'C', 'P', '_', 'C', 'E', '_', 'D', 'B', '_', 'C', 'M', 'D', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_CE_DB_CMD_BUFSZ (27756) */
	'C', 'P', '_', 'P', 'F', 'P', '_', 'C', 'O', 'M', 'P', 'L', 'E', 'T', 'I', 'O', 'N', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* CP_PFP_COMPLETION_STATUS (27775) */
	'C', 'P', '_', 'C', 'E', '_', 'C', 'O', 'M', 'P', 'L', 'E', 'T', 'I', 'O', 'N', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* CP_CE_COMPLETION_STATUS (27800) */
	'C', 'P', '_', 'P', 'R', 'E', 'D', '_', 'N', 'O', 'T', '_', 'V', 'I', 'S', 'I', 'B', 'L', 'E', '\0', /* CP_PRED_NOT_VISIBLE (27824, 27832) */
	'C', 'P', '_', 'P', 'F', 'P', '_', 'M', 'E', 'T', 'A', 'D', 'A', 'T', 'A', '_', 'B', 'A', 'S', 'E', '_', 'A', 'D', 'D', 'R', '\0', /* CP_PFP_METADATA_BASE_ADDR (27844) */
	'C', 'P', '_', 'P', 'F', 'P', '_', 'M', 'E', 'T', 'A', 'D', 'A', 'T', 'A', '_', 'B', 'A', 'S', 'E', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_PFP_METADATA_BASE_ADDR_HI (27870) */
	'C', 'P', '_', 'C', 'E', '_', 'M', 'E', 'T', 'A', 'D', 'A', 'T', 'A', '_', 'B', 'A', 'S', 'E', '_', 'A', 'D', 'D', 'R', '\0', /* CP_CE_METADATA_BASE_ADDR (27899) */
	'C', 'P', '_', 'C', 'E', '_', 'M', 'E', 'T', 'A', 'D', 'A', 'T', 'A', '_', 'B', 'A', 'S', 'E', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_CE_METADATA_BASE_ADDR_HI (27924) */
	'C', 'P', '_', 'D', 'R', 'A', 'W', '_', 'I', 'N', 'D', 'X', '_', 'I', 'N', 'D', 'R', '_', 'A', 'D', 'D', 'R', '\0', /* CP_DRAW_INDX_INDR_ADDR (27952) */
	'C', 'P', '_', 'D', 'R', 'A', 'W', '_', 'I', 'N', 'D', 'X', '_', 'I', 'N', 'D', 'R', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_DRAW_INDX_INDR_ADDR_HI (27975) */
	'C', 'P', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'I', 'N', 'D', 'R', '_', 'A', 'D', 'D', 'R', '\0', /* CP_DISPATCH_INDR_ADDR (28001) */
	'C', 'P', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'I', 'N', 'D', 'R', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_DISPATCH_INDR_ADDR_HI (28023) */
	'C', 'P', '_', 'I', 'N', 'D', 'E', 'X', '_', 'B', 'A', 'S', 'E', '_', 'A', 'D', 'D', 'R', '\0', /* CP_INDEX_BASE_ADDR (28048) */
	'C', 'P', '_', 'I', 'N', 'D', 'E', 'X', '_', 'B', 'A', 'S', 'E', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_INDEX_BASE_ADDR_HI (28067) */
	'C', 'P', '_', 'I', 'N', 'D', 'E', 'X', '_', 'T', 'Y', 'P', 'E', '\0', /* CP_INDEX_TYPE (28089) */
	'C', 'P', '_', 'G', 'D', 'S', '_', 'B', 'K', 'U', 'P', '_', 'A', 'D', 'D', 'R', '\0', /* CP_GDS_BKUP_ADDR (28103) */
	'C', 'P', '_', 'G', 'D', 'S', '_', 'B', 'K', 'U', 'P', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_GDS_BKUP_ADDR_HI (28120) */
	'C', 'P', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* CP_SAMPLE_STATUS (28140) */
	'C', 'P', '_', 'M', 'E', '_', 'C', 'O', 'H', 'E', 'R', '_', 'C', 'N', 'T', 'L', '\0', /* CP_ME_COHER_CNTL (28157) */
	'C', 'P', '_', 'M', 'E', '_', 'C', 'O', 'H', 'E', 'R', '_', 'S', 'I', 'Z', 'E', '\0', /* CP_ME_COHER_SIZE (28174) */
	'C', 'P', '_', 'M', 'E', '_', 'C', 'O', 'H', 'E', 'R', '_', 'S', 'I', 'Z', 'E', '_', 'H', 'I', '\0', /* CP_ME_COHER_SIZE_HI (28191) */
	'C', 'P', '_', 'M', 'E', '_', 'C', 'O', 'H', 'E', 'R', '_', 'B', 'A', 'S', 'E', '\0', /* CP_ME_COHER_BASE (28211) */
	'C', 'P', '_', 'M', 'E', '_', 'C', 'O', 'H', 'E', 'R', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* CP_ME_COHER_BASE_HI (28228) */
	'C', 'P', '_', 'M', 'E', '_', 'C', 'O', 'H', 'E', 'R', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* CP_ME_COHER_STATUS (28248) */
	'R', 'L', 'C', '_', 'G', 'P', 'M', '_', 'P', 'E', 'R', 'F', '_', 'C', 'O', 'U', 'N', 'T', '_', '0', '\0', /* RLC_GPM_PERF_COUNT_0 (28267) */
	'R', 'L', 'C', '_', 'G', 'P', 'M', '_', 'P', 'E', 'R', 'F', '_', 'C', 'O', 'U', 'N', 'T', '_', '1', '\0', /* RLC_GPM_PERF_COUNT_1 (28288) */
	'G', 'R', 'B', 'M', '_', 'G', 'F', 'X', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* GRBM_GFX_INDEX (28309) */
	'V', 'G', 'T', '_', 'E', 'S', 'G', 'S', '_', 'R', 'I', 'N', 'G', '_', 'S', 'I', 'Z', 'E', '_', 'U', 'M', 'D', '\0', /* VGT_ESGS_RING_SIZE_UMD (28324) */
	'V', 'G', 'T', '_', 'G', 'S', 'V', 'S', '_', 'R', 'I', 'N', 'G', '_', 'S', 'I', 'Z', 'E', '_', 'U', 'M', 'D', '\0', /* VGT_GSVS_RING_SIZE_UMD (28347) */
	'V', 'G', 'T', '_', 'P', 'R', 'I', 'M', 'I', 'T', 'I', 'V', 'E', '_', 'T', 'Y', 'P', 'E', '\0', /* VGT_PRIMITIVE_TYPE (28370) */
	'V', 'G', 'T', '_', 'I', 'N', 'D', 'E', 'X', '_', 'T', 'Y', 'P', 'E', '\0', /* VGT_INDEX_TYPE (28389) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'F', 'I', 'L', 'L', 'E', 'D', '_', 'S', 'I', 'Z', 'E', '_', '0', '\0', /* VGT_STRMOUT_BUFFER_FILLED_SIZE_0 (28404) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'F', 'I', 'L', 'L', 'E', 'D', '_', 'S', 'I', 'Z', 'E', '_', '1', '\0', /* VGT_STRMOUT_BUFFER_FILLED_SIZE_1 (28437) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'F', 'I', 'L', 'L', 'E', 'D', '_', 'S', 'I', 'Z', 'E', '_', '2', '\0', /* VGT_STRMOUT_BUFFER_FILLED_SIZE_2 (28470) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'F', 'I', 'L', 'L', 'E', 'D', '_', 'S', 'I', 'Z', 'E', '_', '3', '\0', /* VGT_STRMOUT_BUFFER_FILLED_SIZE_3 (28503) */
	'G', 'E', '_', 'M', 'I', 'N', '_', 'V', 'T', 'X', '_', 'I', 'N', 'D', 'X', '\0', /* GE_MIN_VTX_INDX (28536) */
	'G', 'E', '_', 'I', 'N', 'D', 'X', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* GE_INDX_OFFSET (28552) */
	'G', 'E', '_', 'M', 'U', 'L', 'T', 'I', '_', 'P', 'R', 'I', 'M', '_', 'I', 'B', '_', 'R', 'E', 'S', 'E', 'T', '_', 'E', 'N', '\0', /* GE_MULTI_PRIM_IB_RESET_EN (28567) */
	'V', 'G', 'T', '_', 'N', 'U', 'M', '_', 'I', 'N', 'D', 'I', 'C', 'E', 'S', '\0', /* VGT_NUM_INDICES (28593) */
	'V', 'G', 'T', '_', 'N', 'U', 'M', '_', 'I', 'N', 'S', 'T', 'A', 'N', 'C', 'E', 'S', '\0', /* VGT_NUM_INSTANCES (28609) */
	'V', 'G', 'T', '_', 'T', 'F', '_', 'R', 'I', 'N', 'G', '_', 'S', 'I', 'Z', 'E', '_', 'U', 'M', 'D', '\0', /* VGT_TF_RING_SIZE_UMD (28627) */
	'V', 'G', 'T', '_', 'H', 'S', '_', 'O', 'F', 'F', 'C', 'H', 'I', 'P', '_', 'P', 'A', 'R', 'A', 'M', '_', 'U', 'M', 'D', '\0', /* VGT_HS_OFFCHIP_PARAM_UMD (28648) */
	'V', 'G', 'T', '_', 'T', 'F', '_', 'M', 'E', 'M', 'O', 'R', 'Y', '_', 'B', 'A', 'S', 'E', '_', 'U', 'M', 'D', '\0', /* VGT_TF_MEMORY_BASE_UMD (28673) */
	'G', 'E', '_', 'D', 'M', 'A', '_', 'F', 'I', 'R', 'S', 'T', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* GE_DMA_FIRST_INDEX (28696) */
	'W', 'D', '_', 'P', 'O', 'S', '_', 'B', 'U', 'F', '_', 'B', 'A', 'S', 'E', '\0', /* WD_POS_BUF_BASE (28715) */
	'W', 'D', '_', 'P', 'O', 'S', '_', 'B', 'U', 'F', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* WD_POS_BUF_BASE_HI (28731) */
	'W', 'D', '_', 'C', 'N', 'T', 'L', '_', 'S', 'B', '_', 'B', 'U', 'F', '_', 'B', 'A', 'S', 'E', '\0', /* WD_CNTL_SB_BUF_BASE (28750) */
	'W', 'D', '_', 'C', 'N', 'T', 'L', '_', 'S', 'B', '_', 'B', 'U', 'F', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* WD_CNTL_SB_BUF_BASE_HI (28770) */
	'W', 'D', '_', 'I', 'N', 'D', 'E', 'X', '_', 'B', 'U', 'F', '_', 'B', 'A', 'S', 'E', '\0', /* WD_INDEX_BUF_BASE (28793) */
	'W', 'D', '_', 'I', 'N', 'D', 'E', 'X', '_', 'B', 'U', 'F', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* WD_INDEX_BUF_BASE_HI (28811) */
	'I', 'A', '_', 'M', 'U', 'L', 'T', 'I', '_', 'V', 'G', 'T', '_', 'P', 'A', 'R', 'A', 'M', '_', 'P', 'I', 'P', 'E', 'D', '\0', /* IA_MULTI_VGT_PARAM_PIPED (28832) */
	'G', 'E', '_', 'M', 'A', 'X', '_', 'V', 'T', 'X', '_', 'I', 'N', 'D', 'X', '\0', /* GE_MAX_VTX_INDX (28857) */
	'V', 'G', 'T', '_', 'I', 'N', 'S', 'T', 'A', 'N', 'C', 'E', '_', 'B', 'A', 'S', 'E', '_', 'I', 'D', '\0', /* VGT_INSTANCE_BASE_ID (28873, 28888) */
	'G', 'E', '_', 'C', 'N', 'T', 'L', '\0', /* GE_CNTL (28894) */
	'G', 'E', '_', 'U', 'S', 'E', 'R', '_', 'V', 'G', 'P', 'R', '1', '\0', /* GE_USER_VGPR1 (28902) */
	'G', 'E', '_', 'U', 'S', 'E', 'R', '_', 'V', 'G', 'P', 'R', '2', '\0', /* GE_USER_VGPR2 (28916) */
	'G', 'E', '_', 'U', 'S', 'E', 'R', '_', 'V', 'G', 'P', 'R', '3', '\0', /* GE_USER_VGPR3 (28930) */
	'G', 'E', '_', 'S', 'T', 'E', 'R', 'E', 'O', '_', 'C', 'N', 'T', 'L', '\0', /* GE_STEREO_CNTL (28944) */
	'G', 'E', '_', 'P', 'C', '_', 'A', 'L', 'L', 'O', 'C', '\0', /* GE_PC_ALLOC (28959) */
	'V', 'G', 'T', '_', 'T', 'F', '_', 'M', 'E', 'M', 'O', 'R', 'Y', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '_', 'U', 'M', 'D', '\0', /* VGT_TF_MEMORY_BASE_HI_UMD (28971) */
	'G', 'E', '_', 'U', 'S', 'E', 'R', '_', 'V', 'G', 'P', 'R', '_', 'E', 'N', '\0', /* GE_USER_VGPR_EN (28997) */
	'P', 'A', '_', 'S', 'U', '_', 'L', 'I', 'N', 'E', '_', 'S', 'T', 'I', 'P', 'P', 'L', 'E', '_', 'V', 'A', 'L', 'U', 'E', '\0', /* PA_SU_LINE_STIPPLE_VALUE (29013, 29019, 29032) */
	'P', 'A', '_', 'S', 'C', '_', 'L', 'I', 'N', 'E', '_', 'S', 'T', 'I', 'P', 'P', 'L', 'E', '_', 'S', 'T', 'A', 'T', 'E', '\0', /* PA_SC_LINE_STIPPLE_STATE (29038) */
	'P', 'A', '_', 'S', 'C', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'E', 'X', 'T', 'E', 'N', 'T', '_', 'M', 'I', 'N', '_', '0', '\0', /* PA_SC_SCREEN_EXTENT_MIN_0 (29063) */
	'P', 'A', '_', 'S', 'C', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'E', 'X', 'T', 'E', 'N', 'T', '_', 'M', 'A', 'X', '_', '0', '\0', /* PA_SC_SCREEN_EXTENT_MAX_0 (29089) */
	'P', 'A', '_', 'S', 'C', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'E', 'X', 'T', 'E', 'N', 'T', '_', 'M', 'I', 'N', '_', '1', '\0', /* PA_SC_SCREEN_EXTENT_MIN_1 (29115) */
	'P', 'A', '_', 'S', 'C', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'E', 'X', 'T', 'E', 'N', 'T', '_', 'M', 'A', 'X', '_', '1', '\0', /* PA_SC_SCREEN_EXTENT_MAX_1 (29141) */
	'P', 'A', '_', 'S', 'C', '_', 'P', '3', 'D', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'H', 'V', '_', 'E', 'N', '\0', /* PA_SC_P3D_TRAP_SCREEN_HV_EN (29167) */
	'P', 'A', '_', 'S', 'C', '_', 'P', '3', 'D', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'H', '\0', /* PA_SC_P3D_TRAP_SCREEN_H (29195) */
	'P', 'A', '_', 'S', 'C', '_', 'P', '3', 'D', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'V', '\0', /* PA_SC_P3D_TRAP_SCREEN_V (29219) */
	'P', 'A', '_', 'S', 'C', '_', 'P', '3', 'D', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'O', 'C', 'C', 'U', 'R', 'R', 'E', 'N', 'C', 'E', '\0', /* PA_SC_P3D_TRAP_SCREEN_OCCURRENCE (29243) */
	'P', 'A', '_', 'S', 'C', '_', 'P', '3', 'D', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'C', 'O', 'U', 'N', 'T', '\0', /* PA_SC_P3D_TRAP_SCREEN_COUNT (29276) */
	'P', 'A', '_', 'S', 'C', '_', 'H', 'P', '3', 'D', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'H', 'V', '_', 'E', 'N', '\0', /* PA_SC_HP3D_TRAP_SCREEN_HV_EN (29304) */
	'P', 'A', '_', 'S', 'C', '_', 'H', 'P', '3', 'D', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'H', '\0', /* PA_SC_HP3D_TRAP_SCREEN_H (29333) */
	'P', 'A', '_', 'S', 'C', '_', 'H', 'P', '3', 'D', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'V', '\0', /* PA_SC_HP3D_TRAP_SCREEN_V (29358) */
	'P', 'A', '_', 'S', 'C', '_', 'H', 'P', '3', 'D', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'O', 'C', 'C', 'U', 'R', 'R', 'E', 'N', 'C', 'E', '\0', /* PA_SC_HP3D_TRAP_SCREEN_OCCURRENCE (29383) */
	'P', 'A', '_', 'S', 'C', '_', 'H', 'P', '3', 'D', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'C', 'O', 'U', 'N', 'T', '\0', /* PA_SC_HP3D_TRAP_SCREEN_COUNT (29417) */
	'P', 'A', '_', 'S', 'C', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'H', 'V', '_', 'E', 'N', '\0', /* PA_SC_TRAP_SCREEN_HV_EN (29446) */
	'P', 'A', '_', 'S', 'C', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'H', '\0', /* PA_SC_TRAP_SCREEN_H (29470) */
	'P', 'A', '_', 'S', 'C', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'V', '\0', /* PA_SC_TRAP_SCREEN_V (29490) */
	'P', 'A', '_', 'S', 'C', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'O', 'C', 'C', 'U', 'R', 'R', 'E', 'N', 'C', 'E', '\0', /* PA_SC_TRAP_SCREEN_OCCURRENCE (29510) */
	'P', 'A', '_', 'S', 'C', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'C', 'O', 'U', 'N', 'T', '\0', /* PA_SC_TRAP_SCREEN_COUNT (29539) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'U', 'S', 'E', 'R', 'D', 'A', 'T', 'A', '_', '0', '\0', /* SQ_THREAD_TRACE_USERDATA_0 (29563) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'U', 'S', 'E', 'R', 'D', 'A', 'T', 'A', '_', '1', '\0', /* SQ_THREAD_TRACE_USERDATA_1 (29590) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'U', 'S', 'E', 'R', 'D', 'A', 'T', 'A', '_', '2', '\0', /* SQ_THREAD_TRACE_USERDATA_2 (29617) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'U', 'S', 'E', 'R', 'D', 'A', 'T', 'A', '_', '3', '\0', /* SQ_THREAD_TRACE_USERDATA_3 (29644) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'U', 'S', 'E', 'R', 'D', 'A', 'T', 'A', '_', '4', '\0', /* SQ_THREAD_TRACE_USERDATA_4 (29671) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'U', 'S', 'E', 'R', 'D', 'A', 'T', 'A', '_', '5', '\0', /* SQ_THREAD_TRACE_USERDATA_5 (29698) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'U', 'S', 'E', 'R', 'D', 'A', 'T', 'A', '_', '6', '\0', /* SQ_THREAD_TRACE_USERDATA_6 (29725) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'U', 'S', 'E', 'R', 'D', 'A', 'T', 'A', '_', '7', '\0', /* SQ_THREAD_TRACE_USERDATA_7 (29752) */
	'S', 'Q', 'C', '_', 'C', 'A', 'C', 'H', 'E', 'S', '\0', /* SQC_CACHES (29779) */
	'S', 'Q', 'C', '_', 'W', 'R', 'I', 'T', 'E', 'B', 'A', 'C', 'K', '\0', /* SQC_WRITEBACK (29790, 29794) */
	'T', 'A', '_', 'C', 'S', '_', 'B', 'C', '_', 'B', 'A', 'S', 'E', '_', 'A', 'D', 'D', 'R', '\0', /* TA_CS_BC_BASE_ADDR (29804) */
	'T', 'A', '_', 'C', 'S', '_', 'B', 'C', '_', 'B', 'A', 'S', 'E', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* TA_CS_BC_BASE_ADDR_HI (29823) */
	'D', 'B', '_', 'O', 'C', 'C', 'L', 'U', 'S', 'I', 'O', 'N', '_', 'C', 'O', 'U', 'N', 'T', '0', '_', 'L', 'O', 'W', '\0', /* DB_OCCLUSION_COUNT0_LOW (29845) */
	'D', 'B', '_', 'O', 'C', 'C', 'L', 'U', 'S', 'I', 'O', 'N', '_', 'C', 'O', 'U', 'N', 'T', '0', '_', 'H', 'I', '\0', /* DB_OCCLUSION_COUNT0_HI (29869) */
	'D', 'B', '_', 'O', 'C', 'C', 'L', 'U', 'S', 'I', 'O', 'N', '_', 'C', 'O', 'U', 'N', 'T', '1', '_', 'L', 'O', 'W', '\0', /* DB_OCCLUSION_COUNT1_LOW (29892) */
	'D', 'B', '_', 'O', 'C', 'C', 'L', 'U', 'S', 'I', 'O', 'N', '_', 'C', 'O', 'U', 'N', 'T', '1', '_', 'H', 'I', '\0', /* DB_OCCLUSION_COUNT1_HI (29916) */
	'D', 'B', '_', 'O', 'C', 'C', 'L', 'U', 'S', 'I', 'O', 'N', '_', 'C', 'O', 'U', 'N', 'T', '2', '_', 'L', 'O', 'W', '\0', /* DB_OCCLUSION_COUNT2_LOW (29939) */
	'D', 'B', '_', 'O', 'C', 'C', 'L', 'U', 'S', 'I', 'O', 'N', '_', 'C', 'O', 'U', 'N', 'T', '2', '_', 'H', 'I', '\0', /* DB_OCCLUSION_COUNT2_HI (29963) */
	'D', 'B', '_', 'O', 'C', 'C', 'L', 'U', 'S', 'I', 'O', 'N', '_', 'C', 'O', 'U', 'N', 'T', '3', '_', 'L', 'O', 'W', '\0', /* DB_OCCLUSION_COUNT3_LOW (29986) */
	'D', 'B', '_', 'O', 'C', 'C', 'L', 'U', 'S', 'I', 'O', 'N', '_', 'C', 'O', 'U', 'N', 'T', '3', '_', 'H', 'I', '\0', /* DB_OCCLUSION_COUNT3_HI (30010) */
	'D', 'B', '_', 'Z', 'P', 'A', 'S', 'S', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', 'W', '\0', /* DB_ZPASS_COUNT_LOW (30033) */
	'D', 'B', '_', 'Z', 'P', 'A', 'S', 'S', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* DB_ZPASS_COUNT_HI (30052) */
	'G', 'D', 'S', '_', 'R', 'D', '_', 'A', 'D', 'D', 'R', '\0', /* GDS_RD_ADDR (30070) */
	'G', 'D', 'S', '_', 'R', 'D', '_', 'D', 'A', 'T', 'A', '\0', /* GDS_RD_DATA (30082) */
	'G', 'D', 'S', '_', 'R', 'D', '_', 'B', 'U', 'R', 'S', 'T', '_', 'A', 'D', 'D', 'R', '\0', /* GDS_RD_BURST_ADDR (30094) */
	'G', 'D', 'S', '_', 'R', 'D', '_', 'B', 'U', 'R', 'S', 'T', '_', 'C', 'O', 'U', 'N', 'T', '\0', /* GDS_RD_BURST_COUNT (30112) */
	'G', 'D', 'S', '_', 'R', 'D', '_', 'B', 'U', 'R', 'S', 'T', '_', 'D', 'A', 'T', 'A', '\0', /* GDS_RD_BURST_DATA (30131) */
	'G', 'D', 'S', '_', 'W', 'R', '_', 'A', 'D', 'D', 'R', '\0', /* GDS_WR_ADDR (30149) */
	'G', 'D', 'S', '_', 'W', 'R', '_', 'D', 'A', 'T', 'A', '\0', /* GDS_WR_DATA (30161) */
	'G', 'D', 'S', '_', 'W', 'R', '_', 'B', 'U', 'R', 'S', 'T', '_', 'A', 'D', 'D', 'R', '\0', /* GDS_WR_BURST_ADDR (30173) */
	'G', 'D', 'S', '_', 'W', 'R', '_', 'B', 'U', 'R', 'S', 'T', '_', 'D', 'A', 'T', 'A', '\0', /* GDS_WR_BURST_DATA (30191) */
	'G', 'D', 'S', '_', 'W', 'R', 'I', 'T', 'E', '_', 'C', 'O', 'M', 'P', 'L', 'E', 'T', 'E', '\0', /* GDS_WRITE_COMPLETE (30209, 30219) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'C', 'N', 'T', 'L', '\0', /* GDS_ATOM_CNTL (30228) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'C', 'O', 'M', 'P', 'L', 'E', 'T', 'E', '\0', /* GDS_ATOM_COMPLETE (30242) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'B', 'A', 'S', 'E', '\0', /* GDS_ATOM_BASE (30260) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'S', 'I', 'Z', 'E', '\0', /* GDS_ATOM_SIZE (30274) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'O', 'F', 'F', 'S', 'E', 'T', '0', '\0', /* GDS_ATOM_OFFSET0 (30288, 30297) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'O', 'F', 'F', 'S', 'E', 'T', '1', '\0', /* GDS_ATOM_OFFSET1 (30305, 30314) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'D', 'S', 'T', '\0', /* GDS_ATOM_DST (30322, 30331) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'O', 'P', '\0', /* GDS_ATOM_OP (30335) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'S', 'R', 'C', '0', '\0', /* GDS_ATOM_SRC0 (30347, 30356) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'S', 'R', 'C', '0', '_', 'U', '\0', /* GDS_ATOM_SRC0_U (30361) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'S', 'R', 'C', '1', '\0', /* GDS_ATOM_SRC1 (30377) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'S', 'R', 'C', '1', '_', 'U', '\0', /* GDS_ATOM_SRC1_U (30391) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'R', 'E', 'A', 'D', '0', '\0', /* GDS_ATOM_READ0 (30407) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'R', 'E', 'A', 'D', '0', '_', 'U', '\0', /* GDS_ATOM_READ0_U (30422) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'R', 'E', 'A', 'D', '1', '\0', /* GDS_ATOM_READ1 (30439) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'R', 'E', 'A', 'D', '1', '_', 'U', '\0', /* GDS_ATOM_READ1_U (30454) */
	'G', 'D', 'S', '_', 'G', 'W', 'S', '_', 'R', 'E', 'S', 'O', 'U', 'R', 'C', 'E', '_', 'C', 'N', 'T', 'L', '\0', /* GDS_GWS_RESOURCE_CNTL (30471) */
	'G', 'D', 'S', '_', 'G', 'W', 'S', '_', 'R', 'E', 'S', 'O', 'U', 'R', 'C', 'E', '\0', /* GDS_GWS_RESOURCE (30493, 30503) */
	'G', 'D', 'S', '_', 'G', 'W', 'S', '_', 'R', 'E', 'S', 'O', 'U', 'R', 'C', 'E', '_', 'C', 'N', 'T', '\0', /* GDS_GWS_RESOURCE_CNT (30510, 30518) */
	'G', 'D', 'S', '_', 'O', 'A', '_', 'C', 'N', 'T', 'L', '\0', /* GDS_OA_CNTL (30531) */
	'G', 'D', 'S', '_', 'O', 'A', '_', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '\0', /* GDS_OA_COUNTER (30543) */
	'G', 'D', 'S', '_', 'O', 'A', '_', 'A', 'D', 'D', 'R', 'E', 'S', 'S', '\0', /* GDS_OA_ADDRESS (30558, 30565) */
	'G', 'D', 'S', '_', 'O', 'A', '_', 'I', 'N', 'C', 'D', 'E', 'C', '\0', /* GDS_OA_INCDEC (30573, 30580) */
	'G', 'D', 'S', '_', 'O', 'A', '_', 'R', 'I', 'N', 'G', '_', 'S', 'I', 'Z', 'E', '\0', /* GDS_OA_RING_SIZE (30587) */
	'S', 'P', 'I', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'C', 'N', 'T', 'L', '_', 'R', 'E', 'M', 'A', 'P', '\0', /* SPI_CONFIG_CNTL_REMAP (30604) */
	'S', 'P', 'I', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'C', 'N', 'T', 'L', '_', '1', '_', 'R', 'E', 'M', 'A', 'P', '\0', /* SPI_CONFIG_CNTL_1_REMAP (30626) */
	'S', 'P', 'I', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'C', 'N', 'T', 'L', '_', '2', '_', 'R', 'E', 'M', 'A', 'P', '\0', /* SPI_CONFIG_CNTL_2_REMAP (30650) */
	'S', 'P', 'I', '_', 'W', 'A', 'V', 'E', '_', 'L', 'I', 'M', 'I', 'T', '_', 'C', 'N', 'T', 'L', '_', 'R', 'E', 'M', 'A', 'P', '\0', /* SPI_WAVE_LIMIT_CNTL_REMAP (30674) */
	'C', 'P', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* CPG_PERFCOUNTER1_LO (30700) */
	'C', 'P', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* CPG_PERFCOUNTER1_HI (30720) */
	'C', 'P', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* CPG_PERFCOUNTER0_LO (30740) */
	'C', 'P', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* CPG_PERFCOUNTER0_HI (30760) */
	'C', 'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* CPC_PERFCOUNTER1_LO (30780) */
	'C', 'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* CPC_PERFCOUNTER1_HI (30800) */
	'C', 'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* CPC_PERFCOUNTER0_LO (30820) */
	'C', 'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* CPC_PERFCOUNTER0_HI (30840) */
	'C', 'P', 'F', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* CPF_PERFCOUNTER1_LO (30860) */
	'C', 'P', 'F', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* CPF_PERFCOUNTER1_HI (30880) */
	'C', 'P', 'F', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* CPF_PERFCOUNTER0_LO (30900) */
	'C', 'P', 'F', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* CPF_PERFCOUNTER0_HI (30920) */
	'C', 'P', 'F', '_', 'L', 'A', 'T', 'E', 'N', 'C', 'Y', '_', 'S', 'T', 'A', 'T', 'S', '_', 'D', 'A', 'T', 'A', '\0', /* CPF_LATENCY_STATS_DATA (30940) */
	'C', 'P', 'G', '_', 'L', 'A', 'T', 'E', 'N', 'C', 'Y', '_', 'S', 'T', 'A', 'T', 'S', '_', 'D', 'A', 'T', 'A', '\0', /* CPG_LATENCY_STATS_DATA (30963) */
	'C', 'P', 'C', '_', 'L', 'A', 'T', 'E', 'N', 'C', 'Y', '_', 'S', 'T', 'A', 'T', 'S', '_', 'D', 'A', 'T', 'A', '\0', /* CPC_LATENCY_STATS_DATA (30986) */
	'G', 'R', 'B', 'M', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* GRBM_PERFCOUNTER0_LO (31009) */
	'G', 'R', 'B', 'M', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* GRBM_PERFCOUNTER0_HI (31030) */
	'G', 'R', 'B', 'M', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* GRBM_PERFCOUNTER1_LO (31051) */
	'G', 'R', 'B', 'M', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* GRBM_PERFCOUNTER1_HI (31072) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '0', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* GRBM_SE0_PERFCOUNTER_LO (31093) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '0', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* GRBM_SE0_PERFCOUNTER_HI (31117, 31126, 31130) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* GRBM_SE1_PERFCOUNTER_LO (31141) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* GRBM_SE1_PERFCOUNTER_HI (31165) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* GRBM_SE2_PERFCOUNTER_LO (31189) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* GRBM_SE2_PERFCOUNTER_HI (31213) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '3', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* GRBM_SE3_PERFCOUNTER_LO (31237) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '3', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* GRBM_SE3_PERFCOUNTER_HI (31261) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* GE_PERFCOUNTER0_LO (31285) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* GE_PERFCOUNTER0_HI (31304) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* GE_PERFCOUNTER1_LO (31323) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* GE_PERFCOUNTER1_HI (31342) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GE_PERFCOUNTER2_LO (31361) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GE_PERFCOUNTER2_HI (31380) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* GE_PERFCOUNTER3_LO (31399) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* GE_PERFCOUNTER3_HI (31418) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'L', 'O', '\0', /* GE_PERFCOUNTER4_LO (31437) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'H', 'I', '\0', /* GE_PERFCOUNTER4_HI (31456) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'L', 'O', '\0', /* GE_PERFCOUNTER5_LO (31475) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'H', 'I', '\0', /* GE_PERFCOUNTER5_HI (31494) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'L', 'O', '\0', /* GE_PERFCOUNTER6_LO (31513) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'H', 'I', '\0', /* GE_PERFCOUNTER6_HI (31532) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'L', 'O', '\0', /* GE_PERFCOUNTER7_LO (31551) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'H', 'I', '\0', /* GE_PERFCOUNTER7_HI (31570) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '8', '_', 'L', 'O', '\0', /* GE_PERFCOUNTER8_LO (31589) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '8', '_', 'H', 'I', '\0', /* GE_PERFCOUNTER8_HI (31608) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '9', '_', 'L', 'O', '\0', /* GE_PERFCOUNTER9_LO (31627) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '9', '_', 'H', 'I', '\0', /* GE_PERFCOUNTER9_HI (31646) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '0', '_', 'L', 'O', '\0', /* GE_PERFCOUNTER10_LO (31665) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '0', '_', 'H', 'I', '\0', /* GE_PERFCOUNTER10_HI (31685) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '1', '_', 'L', 'O', '\0', /* GE_PERFCOUNTER11_LO (31705) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '1', '_', 'H', 'I', '\0', /* GE_PERFCOUNTER11_HI (31725) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* PA_SU_PERFCOUNTER0_LO (31745) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* PA_SU_PERFCOUNTER0_HI (31767) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* PA_SU_PERFCOUNTER1_LO (31789) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* PA_SU_PERFCOUNTER1_HI (31811) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* PA_SU_PERFCOUNTER2_LO (31833) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* PA_SU_PERFCOUNTER2_HI (31855) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* PA_SU_PERFCOUNTER3_LO (31877) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* PA_SU_PERFCOUNTER3_HI (31899) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* PA_SC_PERFCOUNTER0_LO (31921) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* PA_SC_PERFCOUNTER0_HI (31943) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* PA_SC_PERFCOUNTER1_LO (31965) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* PA_SC_PERFCOUNTER1_HI (31987) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* PA_SC_PERFCOUNTER2_LO (32009) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* PA_SC_PERFCOUNTER2_HI (32031) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* PA_SC_PERFCOUNTER3_LO (32053) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* PA_SC_PERFCOUNTER3_HI (32075) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'L', 'O', '\0', /* PA_SC_PERFCOUNTER4_LO (32097) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'H', 'I', '\0', /* PA_SC_PERFCOUNTER4_HI (32119) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'L', 'O', '\0', /* PA_SC_PERFCOUNTER5_LO (32141) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'H', 'I', '\0', /* PA_SC_PERFCOUNTER5_HI (32163) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'L', 'O', '\0', /* PA_SC_PERFCOUNTER6_LO (32185) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'H', 'I', '\0', /* PA_SC_PERFCOUNTER6_HI (32207) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'L', 'O', '\0', /* PA_SC_PERFCOUNTER7_LO (32229) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'H', 'I', '\0', /* PA_SC_PERFCOUNTER7_HI (32251) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* SPI_PERFCOUNTER0_HI (32273) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* SPI_PERFCOUNTER0_LO (32293) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* SPI_PERFCOUNTER1_HI (32313) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* SPI_PERFCOUNTER1_LO (32333) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* SPI_PERFCOUNTER2_HI (32353) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* SPI_PERFCOUNTER2_LO (32373) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* SPI_PERFCOUNTER3_HI (32393) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* SPI_PERFCOUNTER3_LO (32413) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'H', 'I', '\0', /* SPI_PERFCOUNTER4_HI (32433) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'L', 'O', '\0', /* SPI_PERFCOUNTER4_LO (32453) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'H', 'I', '\0', /* SPI_PERFCOUNTER5_HI (32473) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'L', 'O', '\0', /* SPI_PERFCOUNTER5_LO (32493) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER0_LO (32513) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER0_HI (32532) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER1_LO (32551) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER1_HI (32570) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER2_LO (32589) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER2_HI (32608) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER3_LO (32627) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER3_HI (32646) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER4_LO (32665) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER4_HI (32684) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER5_LO (32703) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER5_HI (32722) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER6_LO (32741) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER6_HI (32760) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER7_LO (32779) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER7_HI (32798) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '8', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER8_LO (32817) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '8', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER8_HI (32836) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '9', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER9_LO (32855) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '9', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER9_HI (32874) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '0', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER10_LO (32893) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '0', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER10_HI (32913) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '1', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER11_LO (32933) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '1', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER11_HI (32953) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '2', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER12_LO (32973) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '2', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER12_HI (32993) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '3', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER13_LO (33013) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '3', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER13_HI (33033) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '4', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER14_LO (33053) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '4', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER14_HI (33073) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '5', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER15_LO (33093) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '5', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER15_HI (33113) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* SX_PERFCOUNTER0_LO (33133) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* SX_PERFCOUNTER0_HI (33152) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* SX_PERFCOUNTER1_LO (33171) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* SX_PERFCOUNTER1_HI (33190) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* SX_PERFCOUNTER2_LO (33209) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* SX_PERFCOUNTER2_HI (33228) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* SX_PERFCOUNTER3_LO (33247) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* SX_PERFCOUNTER3_HI (33266) */
	'G', 'C', 'E', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GCEA_PERFCOUNTER2_LO (33285) */
	'G', 'C', 'E', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GCEA_PERFCOUNTER2_HI (33306) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* GDS_PERFCOUNTER0_LO (33327) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* GDS_PERFCOUNTER0_HI (33347) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* GDS_PERFCOUNTER1_LO (33367) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* GDS_PERFCOUNTER1_HI (33387) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GDS_PERFCOUNTER2_LO (33407) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GDS_PERFCOUNTER2_HI (33427) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* GDS_PERFCOUNTER3_LO (33447) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* GDS_PERFCOUNTER3_HI (33467) */
	'T', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* TA_PERFCOUNTER0_LO (33487) */
	'T', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* TA_PERFCOUNTER0_HI (33506) */
	'T', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* TA_PERFCOUNTER1_LO (33525) */
	'T', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* TA_PERFCOUNTER1_HI (33544) */
	'T', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* TD_PERFCOUNTER0_LO (33563) */
	'T', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* TD_PERFCOUNTER0_HI (33582) */
	'T', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* TD_PERFCOUNTER1_LO (33601) */
	'T', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* TD_PERFCOUNTER1_HI (33620) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* TCP_PERFCOUNTER0_LO (33639) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* TCP_PERFCOUNTER0_HI (33659) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* TCP_PERFCOUNTER1_LO (33679) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* TCP_PERFCOUNTER1_HI (33699) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* TCP_PERFCOUNTER2_LO (33719) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* TCP_PERFCOUNTER2_HI (33739) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* TCP_PERFCOUNTER3_LO (33759) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* TCP_PERFCOUNTER3_HI (33779) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* GL2C_PERFCOUNTER0_LO (33799) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* GL2C_PERFCOUNTER0_HI (33820) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* GL2C_PERFCOUNTER1_LO (33841) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* GL2C_PERFCOUNTER1_HI (33862) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GL2C_PERFCOUNTER2_LO (33883) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GL2C_PERFCOUNTER2_HI (33904) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* GL2C_PERFCOUNTER3_LO (33925) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* GL2C_PERFCOUNTER3_HI (33946) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* GL2A_PERFCOUNTER0_LO (33967) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* GL2A_PERFCOUNTER0_HI (33988) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* GL2A_PERFCOUNTER1_LO (34009) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* GL2A_PERFCOUNTER1_HI (34030) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GL2A_PERFCOUNTER2_LO (34051) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GL2A_PERFCOUNTER2_HI (34072) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* GL2A_PERFCOUNTER3_LO (34093) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* GL2A_PERFCOUNTER3_HI (34114) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* GL1C_PERFCOUNTER0_LO (34135) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* GL1C_PERFCOUNTER0_HI (34156) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* GL1C_PERFCOUNTER1_LO (34177) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* GL1C_PERFCOUNTER1_HI (34198) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GL1C_PERFCOUNTER2_LO (34219) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GL1C_PERFCOUNTER2_HI (34240) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* GL1C_PERFCOUNTER3_LO (34261) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* GL1C_PERFCOUNTER3_HI (34282) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* CHC_PERFCOUNTER0_LO (34303) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* CHC_PERFCOUNTER0_HI (34323) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* CHC_PERFCOUNTER1_LO (34343) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* CHC_PERFCOUNTER1_HI (34363) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* CHC_PERFCOUNTER2_LO (34383) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* CHC_PERFCOUNTER2_HI (34403) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* CHC_PERFCOUNTER3_LO (34423) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* CHC_PERFCOUNTER3_HI (34443) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* CHCG_PERFCOUNTER0_LO (34463) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* CHCG_PERFCOUNTER0_HI (34484) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* CHCG_PERFCOUNTER1_LO (34505) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* CHCG_PERFCOUNTER1_HI (34526) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* CHCG_PERFCOUNTER2_LO (34547) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* CHCG_PERFCOUNTER2_HI (34568) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* CHCG_PERFCOUNTER3_LO (34589) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* CHCG_PERFCOUNTER3_HI (34610) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* CB_PERFCOUNTER0_LO (34631) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* CB_PERFCOUNTER0_HI (34650) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* CB_PERFCOUNTER1_LO (34669) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* CB_PERFCOUNTER1_HI (34688) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* CB_PERFCOUNTER2_LO (34707) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* CB_PERFCOUNTER2_HI (34726) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* CB_PERFCOUNTER3_LO (34745) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* CB_PERFCOUNTER3_HI (34764) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* DB_PERFCOUNTER0_LO (34783) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* DB_PERFCOUNTER0_HI (34802) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* DB_PERFCOUNTER1_LO (34821) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* DB_PERFCOUNTER1_HI (34840) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* DB_PERFCOUNTER2_LO (34859) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* DB_PERFCOUNTER2_HI (34878) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* DB_PERFCOUNTER3_LO (34897) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* DB_PERFCOUNTER3_HI (34916) */
	'R', 'L', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* RLC_PERFCOUNTER0_LO (34935) */
	'R', 'L', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* RLC_PERFCOUNTER0_HI (34955) */
	'R', 'L', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* RLC_PERFCOUNTER1_LO (34975) */
	'R', 'L', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* RLC_PERFCOUNTER1_HI (34995) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* RMI_PERFCOUNTER0_LO (35015) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* RMI_PERFCOUNTER0_HI (35035) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* RMI_PERFCOUNTER1_LO (35055) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* RMI_PERFCOUNTER1_HI (35075) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* RMI_PERFCOUNTER2_LO (35095) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* RMI_PERFCOUNTER2_HI (35115) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* RMI_PERFCOUNTER3_LO (35135) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* RMI_PERFCOUNTER3_HI (35155) */
	'G', 'C', '_', 'A', 'T', 'C', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* GC_ATC_L2_PERFCOUNTER_LO (35175, 35178) */
	'G', 'C', '_', 'A', 'T', 'C', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* GC_ATC_L2_PERFCOUNTER_HI (35200, 35203) */
	'G', 'C', 'M', 'C', '_', 'V', 'M', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* GCMC_VM_L2_PERFCOUNTER_LO (35225, 35227) */
	'G', 'C', 'M', 'C', '_', 'V', 'M', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* GCMC_VM_L2_PERFCOUNTER_HI (35251, 35253) */
	'G', 'C', 'V', 'M', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', '0', '_', 'L', 'O', '\0', /* GCVML2_PERFCOUNTER2_0_LO (35277) */
	'G', 'C', 'V', 'M', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', '1', '_', 'L', 'O', '\0', /* GCVML2_PERFCOUNTER2_1_LO (35302) */
	'G', 'C', 'V', 'M', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', '0', '_', 'H', 'I', '\0', /* GCVML2_PERFCOUNTER2_0_HI (35327) */
	'G', 'C', 'V', 'M', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', '1', '_', 'H', 'I', '\0', /* GCVML2_PERFCOUNTER2_1_HI (35352) */
	'G', 'C', '_', 'A', 'T', 'C', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GC_ATC_L2_PERFCOUNTER2_LO (35377) */
	'G', 'C', '_', 'A', 'T', 'C', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GC_ATC_L2_PERFCOUNTER2_HI (35403) */
	'U', 'T', 'C', 'L', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* UTCL1_PERFCOUNTER0_LO (35429) */
	'U', 'T', 'C', 'L', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* UTCL1_PERFCOUNTER0_HI (35451) */
	'U', 'T', 'C', 'L', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* UTCL1_PERFCOUNTER1_LO (35473) */
	'U', 'T', 'C', 'L', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* UTCL1_PERFCOUNTER1_HI (35495) */
	'G', 'C', 'R', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* GCR_PERFCOUNTER0_LO (35517) */
	'G', 'C', 'R', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* GCR_PERFCOUNTER0_HI (35537) */
	'G', 'C', 'R', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* GCR_PERFCOUNTER1_LO (35557) */
	'G', 'C', 'R', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* GCR_PERFCOUNTER1_HI (35577) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* PA_PH_PERFCOUNTER0_LO (35597) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* PA_PH_PERFCOUNTER0_HI (35619) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* PA_PH_PERFCOUNTER1_LO (35641) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* PA_PH_PERFCOUNTER1_HI (35663) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* PA_PH_PERFCOUNTER2_LO (35685) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* PA_PH_PERFCOUNTER2_HI (35707) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* PA_PH_PERFCOUNTER3_LO (35729) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* PA_PH_PERFCOUNTER3_HI (35751) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'L', 'O', '\0', /* PA_PH_PERFCOUNTER4_LO (35773) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'H', 'I', '\0', /* PA_PH_PERFCOUNTER4_HI (35795) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'L', 'O', '\0', /* PA_PH_PERFCOUNTER5_LO (35817) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'H', 'I', '\0', /* PA_PH_PERFCOUNTER5_HI (35839) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'L', 'O', '\0', /* PA_PH_PERFCOUNTER6_LO (35861) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'H', 'I', '\0', /* PA_PH_PERFCOUNTER6_HI (35883) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'L', 'O', '\0', /* PA_PH_PERFCOUNTER7_LO (35905) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'H', 'I', '\0', /* PA_PH_PERFCOUNTER7_HI (35927) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* GL1A_PERFCOUNTER0_LO (35949) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* GL1A_PERFCOUNTER0_HI (35970) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* GL1A_PERFCOUNTER1_LO (35991) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* GL1A_PERFCOUNTER1_HI (36012) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GL1A_PERFCOUNTER2_LO (36033) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GL1A_PERFCOUNTER2_HI (36054) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* GL1A_PERFCOUNTER3_LO (36075) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* GL1A_PERFCOUNTER3_HI (36096) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* CHA_PERFCOUNTER0_LO (36117) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* CHA_PERFCOUNTER0_HI (36137) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* CHA_PERFCOUNTER1_LO (36157) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* CHA_PERFCOUNTER1_HI (36177) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* CHA_PERFCOUNTER2_LO (36197) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* CHA_PERFCOUNTER2_HI (36217) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* CHA_PERFCOUNTER3_LO (36237) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* CHA_PERFCOUNTER3_HI (36257) */
	'G', 'U', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GUS_PERFCOUNTER2_LO (36277) */
	'G', 'U', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GUS_PERFCOUNTER2_HI (36297) */
	'C', 'P', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CPG_PERFCOUNTER1_SELECT (36317) */
	'C', 'P', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* CPG_PERFCOUNTER0_SELECT1 (36341) */
	'C', 'P', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CPG_PERFCOUNTER0_SELECT (36366) */
	'C', 'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CPC_PERFCOUNTER1_SELECT (36390) */
	'C', 'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* CPC_PERFCOUNTER0_SELECT1 (36414) */
	'C', 'P', 'F', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CPF_PERFCOUNTER1_SELECT (36439) */
	'C', 'P', 'F', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* CPF_PERFCOUNTER0_SELECT1 (36463) */
	'C', 'P', 'F', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CPF_PERFCOUNTER0_SELECT (36488) */
	'C', 'P', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'C', 'N', 'T', 'L', '\0', /* CP_PERFMON_CNTL (36512) */
	'C', 'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CPC_PERFCOUNTER0_SELECT (36528) */
	'C', 'P', 'F', '_', 'T', 'C', '_', 'P', 'E', 'R', 'F', '_', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'W', 'I', 'N', 'D', 'O', 'W', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CPF_TC_PERF_COUNTER_WINDOW_SELECT (36552) */
	'C', 'P', 'G', '_', 'T', 'C', '_', 'P', 'E', 'R', 'F', '_', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'W', 'I', 'N', 'D', 'O', 'W', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CPG_TC_PERF_COUNTER_WINDOW_SELECT (36586) */
	'C', 'P', 'F', '_', 'L', 'A', 'T', 'E', 'N', 'C', 'Y', '_', 'S', 'T', 'A', 'T', 'S', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CPF_LATENCY_STATS_SELECT (36620) */
	'C', 'P', 'G', '_', 'L', 'A', 'T', 'E', 'N', 'C', 'Y', '_', 'S', 'T', 'A', 'T', 'S', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CPG_LATENCY_STATS_SELECT (36645) */
	'C', 'P', 'C', '_', 'L', 'A', 'T', 'E', 'N', 'C', 'Y', '_', 'S', 'T', 'A', 'T', 'S', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CPC_LATENCY_STATS_SELECT (36670) */
	'C', 'P', '_', 'D', 'R', 'A', 'W', '_', 'O', 'B', 'J', 'E', 'C', 'T', '\0', /* CP_DRAW_OBJECT (36695) */
	'C', 'P', '_', 'D', 'R', 'A', 'W', '_', 'O', 'B', 'J', 'E', 'C', 'T', '_', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '\0', /* CP_DRAW_OBJECT_COUNTER (36710) */
	'C', 'P', '_', 'D', 'R', 'A', 'W', '_', 'W', 'I', 'N', 'D', 'O', 'W', '_', 'M', 'A', 'S', 'K', '_', 'H', 'I', '\0', /* CP_DRAW_WINDOW_MASK_HI (36733) */
	'C', 'P', '_', 'D', 'R', 'A', 'W', '_', 'W', 'I', 'N', 'D', 'O', 'W', '_', 'H', 'I', '\0', /* CP_DRAW_WINDOW_HI (36756) */
	'C', 'P', '_', 'D', 'R', 'A', 'W', '_', 'W', 'I', 'N', 'D', 'O', 'W', '_', 'L', 'O', '\0', /* CP_DRAW_WINDOW_LO (36774) */
	'C', 'P', '_', 'D', 'R', 'A', 'W', '_', 'W', 'I', 'N', 'D', 'O', 'W', '_', 'C', 'N', 'T', 'L', '\0', /* CP_DRAW_WINDOW_CNTL (36792) */
	'G', 'R', 'B', 'M', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GRBM_PERFCOUNTER0_SELECT (36812) */
	'G', 'R', 'B', 'M', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GRBM_PERFCOUNTER1_SELECT (36837) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '0', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GRBM_SE0_PERFCOUNTER_SELECT (36862, 36871) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GRBM_SE1_PERFCOUNTER_SELECT (36890) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GRBM_SE2_PERFCOUNTER_SELECT (36918) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '3', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GRBM_SE3_PERFCOUNTER_SELECT (36946) */
	'G', 'R', 'B', 'M', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '_', 'H', 'I', '\0', /* GRBM_PERFCOUNTER0_SELECT_HI (36974) */
	'G', 'R', 'B', 'M', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '_', 'H', 'I', '\0', /* GRBM_PERFCOUNTER1_SELECT_HI (37002) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE_PERFCOUNTER0_SELECT (37030) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE_PERFCOUNTER0_SELECT1 (37053) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE_PERFCOUNTER1_SELECT (37077) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE_PERFCOUNTER1_SELECT1 (37100) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE_PERFCOUNTER2_SELECT (37124) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE_PERFCOUNTER2_SELECT1 (37147) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE_PERFCOUNTER3_SELECT (37171) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE_PERFCOUNTER3_SELECT1 (37194) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE_PERFCOUNTER4_SELECT (37218) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE_PERFCOUNTER5_SELECT (37241) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE_PERFCOUNTER6_SELECT (37264) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE_PERFCOUNTER7_SELECT (37287) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '8', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE_PERFCOUNTER8_SELECT (37310) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '9', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE_PERFCOUNTER9_SELECT (37333) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE_PERFCOUNTER10_SELECT (37356) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE_PERFCOUNTER11_SELECT (37380) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_SU_PERFCOUNTER0_SELECT (37404) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* PA_SU_PERFCOUNTER0_SELECT1 (37430) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_SU_PERFCOUNTER1_SELECT (37457) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* PA_SU_PERFCOUNTER1_SELECT1 (37483) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_SU_PERFCOUNTER2_SELECT (37510) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* PA_SU_PERFCOUNTER2_SELECT1 (37536) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_SU_PERFCOUNTER3_SELECT (37563) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* PA_SU_PERFCOUNTER3_SELECT1 (37589) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_SC_PERFCOUNTER0_SELECT (37616) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* PA_SC_PERFCOUNTER0_SELECT1 (37642) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_SC_PERFCOUNTER1_SELECT (37669) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_SC_PERFCOUNTER2_SELECT (37695) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_SC_PERFCOUNTER3_SELECT (37721) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_SC_PERFCOUNTER4_SELECT (37747) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_SC_PERFCOUNTER5_SELECT (37773) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_SC_PERFCOUNTER6_SELECT (37799) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_SC_PERFCOUNTER7_SELECT (37825) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SPI_PERFCOUNTER0_SELECT (37851) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SPI_PERFCOUNTER1_SELECT (37875) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SPI_PERFCOUNTER2_SELECT (37899) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SPI_PERFCOUNTER3_SELECT (37923) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SPI_PERFCOUNTER0_SELECT1 (37947) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SPI_PERFCOUNTER1_SELECT1 (37972) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SPI_PERFCOUNTER2_SELECT1 (37997) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SPI_PERFCOUNTER3_SELECT1 (38022) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SPI_PERFCOUNTER4_SELECT (38047) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SPI_PERFCOUNTER5_SELECT (38071) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'B', 'I', 'N', 'S', '\0', /* SPI_PERFCOUNTER_BINS (38095) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER0_SELECT (38116) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER1_SELECT (38139) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER2_SELECT (38162) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER3_SELECT (38185) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER4_SELECT (38208) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER5_SELECT (38231) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER6_SELECT (38254) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER7_SELECT (38277) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '8', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER8_SELECT (38300) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '9', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER9_SELECT (38323) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER10_SELECT (38346) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER11_SELECT (38370) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER12_SELECT (38394) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER13_SELECT (38418) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '4', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER14_SELECT (38442) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '5', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER15_SELECT (38466) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'C', 'T', 'R', 'L', '\0', /* SQ_PERFCOUNTER_CTRL (38490) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'C', 'T', 'R', 'L', '2', '\0', /* SQ_PERFCOUNTER_CTRL2 (38510) */
	'G', 'C', 'E', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GCEA_PERFCOUNTER2_SELECT (38531) */
	'G', 'C', 'E', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GCEA_PERFCOUNTER2_SELECT1 (38556) */
	'G', 'C', 'E', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'M', 'O', 'D', 'E', '\0', /* GCEA_PERFCOUNTER2_MODE (38582) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SX_PERFCOUNTER0_SELECT (38605) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SX_PERFCOUNTER1_SELECT (38628) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SX_PERFCOUNTER2_SELECT (38651) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SX_PERFCOUNTER3_SELECT (38674) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SX_PERFCOUNTER0_SELECT1 (38697) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SX_PERFCOUNTER1_SELECT1 (38721) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GDS_PERFCOUNTER0_SELECT (38745) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GDS_PERFCOUNTER1_SELECT (38769) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GDS_PERFCOUNTER2_SELECT (38793) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GDS_PERFCOUNTER3_SELECT (38817) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GDS_PERFCOUNTER0_SELECT1 (38841) */
	'T', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TA_PERFCOUNTER0_SELECT (38866) */
	'T', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* TA_PERFCOUNTER0_SELECT1 (38889) */
	'T', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TA_PERFCOUNTER1_SELECT (38913) */
	'T', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TD_PERFCOUNTER0_SELECT (38936) */
	'T', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* TD_PERFCOUNTER0_SELECT1 (38959) */
	'T', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TD_PERFCOUNTER1_SELECT (38983) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCP_PERFCOUNTER0_SELECT (39006) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* TCP_PERFCOUNTER0_SELECT1 (39030) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCP_PERFCOUNTER1_SELECT (39055) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* TCP_PERFCOUNTER1_SELECT1 (39079) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCP_PERFCOUNTER2_SELECT (39104) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCP_PERFCOUNTER3_SELECT (39128) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL2C_PERFCOUNTER0_SELECT (39152) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GL2C_PERFCOUNTER0_SELECT1 (39177) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL2C_PERFCOUNTER1_SELECT (39203) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GL2C_PERFCOUNTER1_SELECT1 (39228) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL2C_PERFCOUNTER2_SELECT (39254) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL2C_PERFCOUNTER3_SELECT (39279) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL2A_PERFCOUNTER0_SELECT (39304) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GL2A_PERFCOUNTER0_SELECT1 (39329) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL2A_PERFCOUNTER1_SELECT (39355) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GL2A_PERFCOUNTER1_SELECT1 (39380) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL2A_PERFCOUNTER2_SELECT (39406) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL2A_PERFCOUNTER3_SELECT (39431) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL1C_PERFCOUNTER0_SELECT (39456) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GL1C_PERFCOUNTER0_SELECT1 (39481) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL1C_PERFCOUNTER1_SELECT (39507) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL1C_PERFCOUNTER2_SELECT (39532) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL1C_PERFCOUNTER3_SELECT (39557) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CHC_PERFCOUNTER0_SELECT (39582) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* CHC_PERFCOUNTER0_SELECT1 (39606) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CHC_PERFCOUNTER1_SELECT (39631) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CHC_PERFCOUNTER2_SELECT (39655) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CHC_PERFCOUNTER3_SELECT (39679) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CHCG_PERFCOUNTER0_SELECT (39703) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* CHCG_PERFCOUNTER0_SELECT1 (39728) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CHCG_PERFCOUNTER1_SELECT (39754) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CHCG_PERFCOUNTER2_SELECT (39779) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CHCG_PERFCOUNTER3_SELECT (39804) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'F', 'I', 'L', 'T', 'E', 'R', '\0', /* CB_PERFCOUNTER_FILTER (39829) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CB_PERFCOUNTER0_SELECT (39851) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* CB_PERFCOUNTER0_SELECT1 (39874) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CB_PERFCOUNTER1_SELECT (39898) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CB_PERFCOUNTER2_SELECT (39921) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CB_PERFCOUNTER3_SELECT (39944) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* DB_PERFCOUNTER0_SELECT (39967) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* DB_PERFCOUNTER0_SELECT1 (39990) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* DB_PERFCOUNTER1_SELECT (40014) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* DB_PERFCOUNTER1_SELECT1 (40037) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* DB_PERFCOUNTER2_SELECT (40061) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* DB_PERFCOUNTER3_SELECT (40084) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'C', 'N', 'T', 'L', '\0', /* RLC_SPM_PERFMON_CNTL (40107) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'R', 'I', 'N', 'G', '_', 'B', 'A', 'S', 'E', '_', 'L', 'O', '\0', /* RLC_SPM_PERFMON_RING_BASE_LO (40128) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'R', 'I', 'N', 'G', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* RLC_SPM_PERFMON_RING_BASE_HI (40157, 40173) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'R', 'I', 'N', 'G', '_', 'S', 'I', 'Z', 'E', '\0', /* RLC_SPM_PERFMON_RING_SIZE (40186) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'E', 'G', 'M', 'E', 'N', 'T', '_', 'S', 'I', 'Z', 'E', '\0', /* RLC_SPM_PERFMON_SEGMENT_SIZE (40212, 40220) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'R', 'I', 'N', 'G', '_', 'R', 'D', 'P', 'T', 'R', '\0', /* RLC_SPM_RING_RDPTR (40241) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'E', 'G', 'M', 'E', 'N', 'T', '_', 'T', 'H', 'R', 'E', 'S', 'H', 'O', 'L', 'D', '\0', /* RLC_SPM_SEGMENT_THRESHOLD (40260) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'E', '_', 'M', 'U', 'X', 'S', 'E', 'L', '_', 'A', 'D', 'D', 'R', '\0', /* RLC_SPM_SE_MUXSEL_ADDR (40286) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'E', '_', 'M', 'U', 'X', 'S', 'E', 'L', '_', 'D', 'A', 'T', 'A', '\0', /* RLC_SPM_SE_MUXSEL_DATA (40309) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'G', 'L', 'O', 'B', 'A', 'L', '_', 'M', 'U', 'X', 'S', 'E', 'L', '_', 'A', 'D', 'D', 'R', '\0', /* RLC_SPM_GLOBAL_MUXSEL_ADDR (40332) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'G', 'L', 'O', 'B', 'A', 'L', '_', 'M', 'U', 'X', 'S', 'E', 'L', '_', 'D', 'A', 'T', 'A', '\0', /* RLC_SPM_GLOBAL_MUXSEL_DATA (40359) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'D', 'E', 'S', 'E', 'R', '_', 'S', 'T', 'A', 'R', 'T', '_', 'S', 'K', 'E', 'W', '\0', /* RLC_SPM_DESER_START_SKEW (40386, 40394) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'G', 'L', 'O', 'B', 'A', 'L', 'S', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'S', 'K', 'E', 'W', '\0', /* RLC_SPM_GLOBALS_SAMPLE_SKEW (40411, 40419) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'G', 'L', 'O', 'B', 'A', 'L', 'S', '_', 'M', 'U', 'X', 'S', 'E', 'L', '_', 'S', 'K', 'E', 'W', '\0', /* RLC_SPM_GLOBALS_MUXSEL_SKEW (40439, 40447) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'E', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'S', 'K', 'E', 'W', '\0', /* RLC_SPM_SE_SAMPLE_SKEW (40467, 40475) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'E', '_', 'M', 'U', 'X', 'S', 'E', 'L', '_', 'S', 'K', 'E', 'W', '\0', /* RLC_SPM_SE_MUXSEL_SKEW (40490, 40498) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'G', 'L', 'B', '_', 'S', 'A', 'M', 'P', 'L', 'E', 'D', 'E', 'L', 'A', 'Y', '_', 'I', 'N', 'D', '_', 'A', 'D', 'D', 'R', '\0', /* RLC_SPM_GLB_SAMPLEDELAY_IND_ADDR (40513) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'G', 'L', 'B', '_', 'S', 'A', 'M', 'P', 'L', 'E', 'D', 'E', 'L', 'A', 'Y', '_', 'I', 'N', 'D', '_', 'D', 'A', 'T', 'A', '\0', /* RLC_SPM_GLB_SAMPLEDELAY_IND_DATA (40546) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'E', '_', 'S', 'A', 'M', 'P', 'L', 'E', 'D', 'E', 'L', 'A', 'Y', '_', 'I', 'N', 'D', '_', 'A', 'D', 'D', 'R', '\0', /* RLC_SPM_SE_SAMPLEDELAY_IND_ADDR (40579) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'E', '_', 'S', 'A', 'M', 'P', 'L', 'E', 'D', 'E', 'L', 'A', 'Y', '_', 'I', 'N', 'D', '_', 'D', 'A', 'T', 'A', '\0', /* RLC_SPM_SE_SAMPLEDELAY_IND_DATA (40611) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'R', 'I', 'N', 'G', '_', 'W', 'R', 'P', 'T', 'R', '\0', /* RLC_SPM_RING_WRPTR (40643) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'D', 'A', 'T', 'A', 'R', 'A', 'M', '_', 'A', 'D', 'D', 'R', '\0', /* RLC_SPM_ACCUM_DATARAM_ADDR (40662) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'D', 'A', 'T', 'A', 'R', 'A', 'M', '_', 'D', 'A', 'T', 'A', '\0', /* RLC_SPM_ACCUM_DATARAM_DATA (40689) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'C', 'T', 'R', 'L', 'R', 'A', 'M', '_', 'A', 'D', 'D', 'R', '\0', /* RLC_SPM_ACCUM_CTRLRAM_ADDR (40716) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'C', 'T', 'R', 'L', 'R', 'A', 'M', '_', 'D', 'A', 'T', 'A', '\0', /* RLC_SPM_ACCUM_CTRLRAM_DATA (40743) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* RLC_SPM_ACCUM_STATUS (40770) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'C', 'T', 'R', 'L', '\0', /* RLC_SPM_ACCUM_CTRL (40791) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'M', 'O', 'D', 'E', '\0', /* RLC_SPM_ACCUM_MODE (40810) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'T', 'H', 'R', 'E', 'S', 'H', 'O', 'L', 'D', '\0', /* RLC_SPM_ACCUM_THRESHOLD (40829) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'S', 'A', 'M', 'P', 'L', 'E', 'S', '_', 'R', 'E', 'Q', 'U', 'E', 'S', 'T', 'E', 'D', '\0', /* RLC_SPM_ACCUM_SAMPLES_REQUESTED (40853) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'D', 'A', 'T', 'A', 'R', 'A', 'M', '_', 'W', 'R', 'C', 'O', 'U', 'N', 'T', '\0', /* RLC_SPM_ACCUM_DATARAM_WRCOUNT (40885) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'E', '3', 'T', 'O', '0', '_', 'S', 'E', 'G', 'M', 'E', 'N', 'T', '_', 'S', 'I', 'Z', 'E', '\0', /* RLC_SPM_PERFMON_SE3TO0_SEGMENT_SIZE (40915) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'G', 'L', 'B', '_', 'S', 'E', 'G', 'M', 'E', 'N', 'T', '_', 'S', 'I', 'Z', 'E', '\0', /* RLC_SPM_PERFMON_GLB_SEGMENT_SIZE (40951) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'V', 'I', 'R', 'T', '_', 'C', 'T', 'R', 'L', '\0', /* RLC_SPM_VIRT_CTRL (40984) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'V', 'I', 'R', 'T', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* RLC_SPM_VIRT_STATUS (41002) */
	'R', 'L', 'C', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'C', 'N', 'T', 'L', '\0', /* RLC_PERFMON_CNTL (41022) */
	'R', 'L', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* RLC_PERFCOUNTER0_SELECT (41039) */
	'R', 'L', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* RLC_PERFCOUNTER1_SELECT (41063) */
	'R', 'L', 'C', '_', 'G', 'P', 'U', '_', 'I', 'O', 'V', '_', 'P', 'E', 'R', 'F', '_', 'C', 'N', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* RLC_GPU_IOV_PERF_CNT_CNTL (41087) */
	'R', 'L', 'C', '_', 'G', 'P', 'U', '_', 'I', 'O', 'V', '_', 'P', 'E', 'R', 'F', '_', 'C', 'N', 'T', '_', 'W', 'R', '_', 'A', 'D', 'D', 'R', '\0', /* RLC_GPU_IOV_PERF_CNT_WR_ADDR (41113) */
	'R', 'L', 'C', '_', 'G', 'P', 'U', '_', 'I', 'O', 'V', '_', 'P', 'E', 'R', 'F', '_', 'C', 'N', 'T', '_', 'W', 'R', '_', 'D', 'A', 'T', 'A', '\0', /* RLC_GPU_IOV_PERF_CNT_WR_DATA (41142) */
	'R', 'L', 'C', '_', 'G', 'P', 'U', '_', 'I', 'O', 'V', '_', 'P', 'E', 'R', 'F', '_', 'C', 'N', 'T', '_', 'R', 'D', '_', 'A', 'D', 'D', 'R', '\0', /* RLC_GPU_IOV_PERF_CNT_RD_ADDR (41171) */
	'R', 'L', 'C', '_', 'G', 'P', 'U', '_', 'I', 'O', 'V', '_', 'P', 'E', 'R', 'F', '_', 'C', 'N', 'T', '_', 'R', 'D', '_', 'D', 'A', 'T', 'A', '\0', /* RLC_GPU_IOV_PERF_CNT_RD_DATA (41200) */
	'R', 'L', 'C', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'C', 'L', 'K', '_', 'C', 'N', 'T', 'L', '\0', /* RLC_PERFMON_CLK_CNTL (41229) */
	'R', 'L', 'C', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'C', 'L', 'K', '_', 'C', 'N', 'T', 'L', '_', 'U', 'C', 'O', 'D', 'E', '\0', /* RLC_PERFMON_CLK_CNTL_UCODE (41250) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* RMI_PERFCOUNTER0_SELECT (41277) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* RMI_PERFCOUNTER0_SELECT1 (41301) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* RMI_PERFCOUNTER1_SELECT (41326) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* RMI_PERFCOUNTER2_SELECT (41350) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* RMI_PERFCOUNTER2_SELECT1 (41374) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* RMI_PERFCOUNTER3_SELECT (41399) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', '_', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'C', 'N', 'T', 'L', '\0', /* RMI_PERF_COUNTER_CNTL (41423) */
	'G', 'C', '_', 'A', 'T', 'C', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'C', 'F', 'G', '\0', /* GC_ATC_L2_PERFCOUNTER0_CFG (41445, 41448) */
	'G', 'C', '_', 'A', 'T', 'C', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'C', 'F', 'G', '\0', /* GC_ATC_L2_PERFCOUNTER1_CFG (41472, 41475) */
	'G', 'C', '_', 'A', 'T', 'C', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'R', 'S', 'L', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* GC_ATC_L2_PERFCOUNTER_RSLT_CNTL (41499, 41502) */
	'G', 'C', 'M', 'C', '_', 'V', 'M', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'C', 'F', 'G', '\0', /* GCMC_VM_L2_PERFCOUNTER0_CFG (41531, 41533) */
	'G', 'C', 'M', 'C', '_', 'V', 'M', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'C', 'F', 'G', '\0', /* GCMC_VM_L2_PERFCOUNTER1_CFG (41559, 41561) */
	'G', 'C', 'M', 'C', '_', 'V', 'M', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'C', 'F', 'G', '\0', /* GCMC_VM_L2_PERFCOUNTER2_CFG (41587, 41589) */
	'G', 'C', 'M', 'C', '_', 'V', 'M', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'C', 'F', 'G', '\0', /* GCMC_VM_L2_PERFCOUNTER3_CFG (41615, 41617) */
	'G', 'C', 'M', 'C', '_', 'V', 'M', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'C', 'F', 'G', '\0', /* GCMC_VM_L2_PERFCOUNTER4_CFG (41643, 41645) */
	'G', 'C', 'M', 'C', '_', 'V', 'M', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'C', 'F', 'G', '\0', /* GCMC_VM_L2_PERFCOUNTER5_CFG (41671, 41673) */
	'G', 'C', 'M', 'C', '_', 'V', 'M', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'C', 'F', 'G', '\0', /* GCMC_VM_L2_PERFCOUNTER6_CFG (41699, 41701) */
	'G', 'C', 'M', 'C', '_', 'V', 'M', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'C', 'F', 'G', '\0', /* GCMC_VM_L2_PERFCOUNTER7_CFG (41727, 41729) */
	'G', 'C', 'M', 'C', '_', 'V', 'M', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'R', 'S', 'L', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* GCMC_VM_L2_PERFCOUNTER_RSLT_CNTL (41755, 41757) */
	'G', 'C', 'V', 'M', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GCVML2_PERFCOUNTER2_0_SELECT (41788) */
	'G', 'C', 'V', 'M', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GCVML2_PERFCOUNTER2_1_SELECT (41817) */
	'G', 'C', 'V', 'M', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GCVML2_PERFCOUNTER2_0_SELECT1 (41846) */
	'G', 'C', 'V', 'M', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GCVML2_PERFCOUNTER2_1_SELECT1 (41876) */
	'G', 'C', 'V', 'M', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', '0', '_', 'M', 'O', 'D', 'E', '\0', /* GCVML2_PERFCOUNTER2_0_MODE (41906) */
	'G', 'C', 'V', 'M', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', '1', '_', 'M', 'O', 'D', 'E', '\0', /* GCVML2_PERFCOUNTER2_1_MODE (41933) */
	'G', 'C', '_', 'A', 'T', 'C', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GC_ATC_L2_PERFCOUNTER2_SELECT (41960) */
	'G', 'C', '_', 'A', 'T', 'C', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GC_ATC_L2_PERFCOUNTER2_SELECT1 (41990) */
	'G', 'C', '_', 'A', 'T', 'C', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'M', 'O', 'D', 'E', '\0', /* GC_ATC_L2_PERFCOUNTER2_MODE (42021) */
	'G', 'C', 'R', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GCR_PERFCOUNTER0_SELECT (42049) */
	'G', 'C', 'R', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GCR_PERFCOUNTER0_SELECT1 (42073) */
	'G', 'C', 'R', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GCR_PERFCOUNTER1_SELECT (42098) */
	'U', 'T', 'C', 'L', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* UTCL1_PERFCOUNTER0_SELECT (42122) */
	'U', 'T', 'C', 'L', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* UTCL1_PERFCOUNTER1_SELECT (42148) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_PH_PERFCOUNTER0_SELECT (42174) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* PA_PH_PERFCOUNTER0_SELECT1 (42200) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_PH_PERFCOUNTER1_SELECT (42227) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_PH_PERFCOUNTER2_SELECT (42253) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_PH_PERFCOUNTER3_SELECT (42279) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_PH_PERFCOUNTER4_SELECT (42305) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_PH_PERFCOUNTER5_SELECT (42331) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_PH_PERFCOUNTER6_SELECT (42357) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_PH_PERFCOUNTER7_SELECT (42383) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* PA_PH_PERFCOUNTER1_SELECT1 (42409) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* PA_PH_PERFCOUNTER2_SELECT1 (42436) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* PA_PH_PERFCOUNTER3_SELECT1 (42463) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL1A_PERFCOUNTER0_SELECT (42490) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GL1A_PERFCOUNTER0_SELECT1 (42515) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL1A_PERFCOUNTER1_SELECT (42541) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL1A_PERFCOUNTER2_SELECT (42566) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL1A_PERFCOUNTER3_SELECT (42591) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CHA_PERFCOUNTER0_SELECT (42616) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* CHA_PERFCOUNTER0_SELECT1 (42640) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CHA_PERFCOUNTER1_SELECT (42665) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CHA_PERFCOUNTER2_SELECT (42689) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CHA_PERFCOUNTER3_SELECT (42713) */
	'G', 'U', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GUS_PERFCOUNTER2_SELECT (42737) */
	'G', 'U', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GUS_PERFCOUNTER2_SELECT1 (42761) */
	'G', 'U', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'M', 'O', 'D', 'E', '\0', /* GUS_PERFCOUNTER2_MODE (42786) */
	'D', 'S', 'T', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* DST_ADDR_LO (42808) */
	'I', 'B', '_', 'B', 'A', 'S', 'E', '_', 'L', 'O', '\0', /* IB_BASE_LO (42820) */
	'I', 'B', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* IB_BASE_HI (42831) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'W', 'O', 'R', 'D', '0', '\0', /* CP_DMA_WORD0 (42842) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'W', 'O', 'R', 'D', '1', '\0', /* CP_DMA_WORD1 (42855) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'W', 'O', 'R', 'D', '2', '\0', /* CP_DMA_WORD2 (42868) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'W', 'O', 'R', 'D', '3', '\0', /* CP_DMA_WORD3 (42881) */
	'R', 'E', 'L', 'E', 'A', 'S', 'E', '_', 'M', 'E', 'M', '_', 'O', 'P', '\0', /* RELEASE_MEM_OP (42894) */
	'D', 'M', 'A', '_', 'D', 'A', 'T', 'A', '_', 'W', 'O', 'R', 'D', '0', '\0', /* DMA_DATA_WORD0 (42909) */
	'S', 'R', 'C', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* SRC_ADDR_LO (42924) */
	'G', 'C', 'R', '_', 'C', 'N', 'T', 'L', '\0', /* GCR_CNTL (42936) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'A', 'C', 'T', 'I', 'V', 'E', '\0', /* SQ_WAVE_ACTIVE (42945) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'V', 'A', 'L', 'I', 'D', '_', 'A', 'N', 'D', '_', 'I', 'D', 'L', 'E', '\0', /* SQ_WAVE_VALID_AND_IDLE (42960, 42978) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'C', 'Y', 'C', 'L', 'E', 'S', '\0', /* SQ_WAVE_SHADER_CYCLES (42983, 42998) */
	'C', 'P', '_', 'C', 'P', 'C', '_', 'P', 'R', 'I', 'V', '_', 'V', 'I', 'O', 'L', 'A', 'T', 'I', 'O', 'N', '_', 'A', 'D', 'D', 'R', '\0', /* CP_CPC_PRIV_VIOLATION_ADDR (43005, 43012) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'S', 'T', 'A', 'T', 'U', 'S', '2', '\0', /* SQ_THREAD_TRACE_STATUS2 (43032) */
	'S', 'H', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', 'R', 'E', 'G', '0', '\0', /* SH_RESERVED_REG0 (43056) */
	'S', 'H', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', 'R', 'E', 'G', '1', '\0', /* SH_RESERVED_REG1 (43073) */
	'D', 'B', '_', 'V', 'R', 'S', '_', 'O', 'V', 'E', 'R', 'R', 'I', 'D', 'E', '_', 'C', 'N', 'T', 'L', '\0', /* DB_VRS_OVERRIDE_CNTL (43090) */
	'C', 'O', 'N', 'T', 'E', 'X', 'T', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', 'R', 'E', 'G', '0', '\0', /* CONTEXT_RESERVED_REG0 (43111) */
	'C', 'O', 'N', 'T', 'E', 'X', 'T', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', 'R', 'E', 'G', '1', '\0', /* CONTEXT_RESERVED_REG1 (43133) */
	'S', 'X', '_', 'P', 'S', '_', 'D', 'O', 'W', 'N', 'C', 'O', 'N', 'V', 'E', 'R', 'T', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* SX_PS_DOWNCONVERT_CONTROL (43155) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'R', 'S', '_', 'C', 'N', 'T', 'L', '\0', /* PA_CL_VRS_CNTL (43181) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '_', 'A', 'T', 'O', 'M', 'I', 'C', '\0', /* SCRATCH_REG_ATOMIC (43196) */
	'U', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', 'R', 'E', 'G', '0', '\0', /* UCONFIG_RESERVED_REG0 (43215) */
	'U', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', 'R', 'E', 'G', '1', '\0', /* UCONFIG_RESERVED_REG1 (43237) */
	'C', 'P', '_', 'C', 'E', '_', 'A', 'T', 'O', 'M', 'I', 'C', '_', 'P', 'R', 'E', 'O', 'P', '_', 'L', 'O', '\0', /* CP_CE_ATOMIC_PREOP_LO (43259) */
	'C', 'P', '_', 'C', 'E', '_', 'A', 'T', 'O', 'M', 'I', 'C', '_', 'P', 'R', 'E', 'O', 'P', '_', 'H', 'I', '\0', /* CP_CE_ATOMIC_PREOP_HI (43281) */
	'C', 'P', '_', 'C', 'E', '_', 'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', 'I', 'C', '0', '_', 'P', 'R', 'E', 'O', 'P', '_', 'L', 'O', '\0', /* CP_CE_GDS_ATOMIC0_PREOP_LO (43303) */
	'C', 'P', '_', 'C', 'E', '_', 'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', 'I', 'C', '0', '_', 'P', 'R', 'E', 'O', 'P', '_', 'H', 'I', '\0', /* CP_CE_GDS_ATOMIC0_PREOP_HI (43330) */
	'C', 'P', '_', 'C', 'E', '_', 'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', 'I', 'C', '1', '_', 'P', 'R', 'E', 'O', 'P', '_', 'L', 'O', '\0', /* CP_CE_GDS_ATOMIC1_PREOP_LO (43357) */
	'C', 'P', '_', 'C', 'E', '_', 'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', 'I', 'C', '1', '_', 'P', 'R', 'E', 'O', 'P', '_', 'H', 'I', '\0', /* CP_CE_GDS_ATOMIC1_PREOP_HI (43384) */
	'G', 'E', '_', 'V', 'R', 'S', '_', 'R', 'A', 'T', 'E', '\0', /* GE_VRS_RATE (43411) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* GE1_PERFCOUNTER0_LO (43423) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* GE1_PERFCOUNTER0_HI (43443) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* GE1_PERFCOUNTER1_LO (43463) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* GE1_PERFCOUNTER1_HI (43483) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GE1_PERFCOUNTER2_LO (43503) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GE1_PERFCOUNTER2_HI (43523) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* GE1_PERFCOUNTER3_LO (43543) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* GE1_PERFCOUNTER3_HI (43563) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* GE2_DIST_PERFCOUNTER0_LO (43583) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* GE2_DIST_PERFCOUNTER0_HI (43608) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* GE2_DIST_PERFCOUNTER1_LO (43633) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* GE2_DIST_PERFCOUNTER1_HI (43658) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GE2_DIST_PERFCOUNTER2_LO (43683) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GE2_DIST_PERFCOUNTER2_HI (43708) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* GE2_DIST_PERFCOUNTER3_LO (43733) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* GE2_DIST_PERFCOUNTER3_HI (43758) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* GE2_SE_PERFCOUNTER0_LO (43783) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* GE2_SE_PERFCOUNTER0_HI (43806) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* GE2_SE_PERFCOUNTER1_LO (43829) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* GE2_SE_PERFCOUNTER1_HI (43852) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GE2_SE_PERFCOUNTER2_LO (43875) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GE2_SE_PERFCOUNTER2_HI (43898) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* GE2_SE_PERFCOUNTER3_LO (43921) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* GE2_SE_PERFCOUNTER3_HI (43944) */
	'G', 'C', 'E', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* GCEA_PERFCOUNTER_LO (43967) */
	'G', 'C', 'E', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* GCEA_PERFCOUNTER_HI (43987) */
	'G', 'C', 'U', 'T', 'C', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* GCUTCL2_PERFCOUNTER_LO (44007) */
	'G', 'C', 'U', 'T', 'C', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* GCUTCL2_PERFCOUNTER_HI (44030) */
	'G', 'U', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* GUS_PERFCOUNTER_LO (44053) */
	'G', 'U', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* GUS_PERFCOUNTER_HI (44072) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* SDMA0_PERFCNT_PERFCOUNTER_LO (44091) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* SDMA0_PERFCNT_PERFCOUNTER_HI (44120) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* SDMA0_PERFCOUNTER0_LO (44149) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* SDMA0_PERFCOUNTER0_HI (44171) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* SDMA0_PERFCOUNTER1_LO (44193) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* SDMA0_PERFCOUNTER1_HI (44215) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* SDMA1_PERFCNT_PERFCOUNTER_LO (44237) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* SDMA1_PERFCNT_PERFCOUNTER_HI (44266) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* SDMA1_PERFCOUNTER0_LO (44295) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* SDMA1_PERFCOUNTER0_HI (44317) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* SDMA1_PERFCOUNTER1_LO (44339) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* SDMA1_PERFCOUNTER1_HI (44361) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* SDMA2_PERFCNT_PERFCOUNTER_LO (44383) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* SDMA2_PERFCNT_PERFCOUNTER_HI (44412) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* SDMA2_PERFCOUNTER0_LO (44441) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* SDMA2_PERFCOUNTER0_HI (44463) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* SDMA2_PERFCOUNTER1_LO (44485) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* SDMA2_PERFCOUNTER1_HI (44507) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* SDMA3_PERFCNT_PERFCOUNTER_LO (44529) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* SDMA3_PERFCNT_PERFCOUNTER_HI (44558) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* SDMA3_PERFCOUNTER0_LO (44587) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* SDMA3_PERFCOUNTER0_HI (44609) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* SDMA3_PERFCOUNTER1_LO (44631) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* SDMA3_PERFCOUNTER1_HI (44653) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE1_PERFCOUNTER0_SELECT (44675) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE1_PERFCOUNTER0_SELECT1 (44699) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE1_PERFCOUNTER1_SELECT (44724) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE1_PERFCOUNTER1_SELECT1 (44748) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE1_PERFCOUNTER2_SELECT (44773) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE1_PERFCOUNTER2_SELECT1 (44797) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE1_PERFCOUNTER3_SELECT (44822) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE1_PERFCOUNTER3_SELECT1 (44846) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE2_DIST_PERFCOUNTER0_SELECT (44871) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE2_DIST_PERFCOUNTER0_SELECT1 (44900) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE2_DIST_PERFCOUNTER1_SELECT (44930) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE2_DIST_PERFCOUNTER1_SELECT1 (44959) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE2_DIST_PERFCOUNTER2_SELECT (44989) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE2_DIST_PERFCOUNTER2_SELECT1 (45018) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE2_DIST_PERFCOUNTER3_SELECT (45048) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE2_DIST_PERFCOUNTER3_SELECT1 (45077) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE2_SE_PERFCOUNTER0_SELECT (45107) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE2_SE_PERFCOUNTER0_SELECT1 (45134) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE2_SE_PERFCOUNTER1_SELECT (45162) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE2_SE_PERFCOUNTER1_SELECT1 (45189) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE2_SE_PERFCOUNTER2_SELECT (45217) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE2_SE_PERFCOUNTER2_SELECT1 (45244) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE2_SE_PERFCOUNTER3_SELECT (45272) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE2_SE_PERFCOUNTER3_SELECT1 (45299) */
	'G', 'C', 'E', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'C', 'F', 'G', '\0', /* GCEA_PERFCOUNTER0_CFG (45327) */
	'G', 'C', 'E', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'C', 'F', 'G', '\0', /* GCEA_PERFCOUNTER1_CFG (45349) */
	'G', 'C', 'E', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'R', 'S', 'L', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* GCEA_PERFCOUNTER_RSLT_CNTL (45371) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GDS_PERFCOUNTER1_SELECT1 (45398) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GDS_PERFCOUNTER2_SELECT1 (45423) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GDS_PERFCOUNTER3_SELECT1 (45448) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'W', 'A', '_', 'S', 'E', 'G', 'M', 'E', 'N', 'T', '_', 'S', 'I', 'Z', 'E', '\0', /* RLC_SPM_PERFMON_SWA_SEGMENT_SIZE (45473) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'G', 'F', 'X', 'C', 'L', 'O', 'C', 'K', '_', 'H', 'I', 'G', 'H', 'C', 'O', 'U', 'N', 'T', '\0', /* RLC_SPM_GFXCLOCK_HIGHCOUNT (45506) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'G', 'F', 'X', 'C', 'L', 'O', 'C', 'K', '_', 'L', 'O', 'W', 'C', 'O', 'U', 'N', 'T', '\0', /* RLC_SPM_GFXCLOCK_LOWCOUNT (45533) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'W', 'A', '_', 'S', 'E', '3', 'T', 'O', '0', '_', 'S', 'E', 'G', 'M', 'E', 'N', 'T', '_', 'S', 'I', 'Z', 'E', '\0', /* RLC_SPM_PERFMON_SWA_SE3TO0_SEGMENT_SIZE (45559) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'G', 'L', 'O', 'B', 'A', 'L', '_', 'M', 'U', 'X', 'S', 'E', 'L', '_', 'A', 'D', 'D', 'R', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* RLC_SPM_GLOBAL_MUXSEL_ADDR_OFFSET (45599) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'E', '_', 'M', 'U', 'X', 'S', 'E', 'L', '_', 'A', 'D', 'D', 'R', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* RLC_SPM_SE_MUXSEL_ADDR_OFFSET (45633) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'S', 'W', 'A', '_', 'D', 'A', 'T', 'A', 'R', 'A', 'M', '_', 'A', 'D', 'D', 'R', '\0', /* RLC_SPM_ACCUM_SWA_DATARAM_ADDR (45663) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'S', 'W', 'A', '_', 'D', 'A', 'T', 'A', 'R', 'A', 'M', '_', 'D', 'A', 'T', 'A', '\0', /* RLC_SPM_ACCUM_SWA_DATARAM_DATA (45694) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'C', 'T', 'R', 'L', 'R', 'A', 'M', '_', 'A', 'D', 'D', 'R', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* RLC_SPM_ACCUM_CTRLRAM_ADDR_OFFSET (45725) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'W', 'A', '_', 'G', 'L', 'B', '_', 'S', 'E', 'G', 'M', 'E', 'N', 'T', '_', 'S', 'I', 'Z', 'E', '\0', /* RLC_SPM_PERFMON_SWA_GLB_SEGMENT_SIZE (45759) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'D', 'A', 'T', 'A', 'R', 'A', 'M', '_', '3', '2', 'B', 'I', 'T', 'C', 'N', 'T', 'R', 'S', '_', 'R', 'E', 'G', 'I', 'O', 'N', 'S', '\0', /* RLC_SPM_ACCUM_DATARAM_32BITCNTRS_REGIONS (45796) */
	'G', 'C', 'U', 'T', 'C', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'C', 'F', 'G', '\0', /* GCUTCL2_PERFCOUNTER0_CFG (45837) */
	'G', 'C', 'U', 'T', 'C', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'C', 'F', 'G', '\0', /* GCUTCL2_PERFCOUNTER1_CFG (45862) */
	'G', 'C', 'U', 'T', 'C', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'C', 'F', 'G', '\0', /* GCUTCL2_PERFCOUNTER2_CFG (45887) */
	'G', 'C', 'U', 'T', 'C', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'C', 'F', 'G', '\0', /* GCUTCL2_PERFCOUNTER3_CFG (45912) */
	'G', 'C', 'U', 'T', 'C', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'R', 'S', 'L', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* GCUTCL2_PERFCOUNTER_RSLT_CNTL (45937) */
	'G', 'U', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'C', 'F', 'G', '\0', /* GUS_PERFCOUNTER0_CFG (45967) */
	'G', 'U', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'C', 'F', 'G', '\0', /* GUS_PERFCOUNTER1_CFG (45988) */
	'G', 'U', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'R', 'S', 'L', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* GUS_PERFCOUNTER_RSLT_CNTL (46009) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'C', 'F', 'G', '\0', /* SDMA0_PERFCNT_PERFCOUNTER0_CFG (46035) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'C', 'F', 'G', '\0', /* SDMA0_PERFCNT_PERFCOUNTER1_CFG (46066) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'R', 'S', 'L', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* SDMA0_PERFCNT_PERFCOUNTER_RSLT_CNTL (46097) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'M', 'I', 'S', 'C', '_', 'C', 'N', 'T', 'L', '\0', /* SDMA0_PERFCNT_MISC_CNTL (46133) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SDMA0_PERFCOUNTER0_SELECT (46157) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SDMA0_PERFCOUNTER0_SELECT1 (46183) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SDMA0_PERFCOUNTER1_SELECT (46210) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SDMA0_PERFCOUNTER1_SELECT1 (46236) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'C', 'F', 'G', '\0', /* SDMA1_PERFCNT_PERFCOUNTER0_CFG (46263) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'C', 'F', 'G', '\0', /* SDMA1_PERFCNT_PERFCOUNTER1_CFG (46294) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'R', 'S', 'L', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* SDMA1_PERFCNT_PERFCOUNTER_RSLT_CNTL (46325) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'M', 'I', 'S', 'C', '_', 'C', 'N', 'T', 'L', '\0', /* SDMA1_PERFCNT_MISC_CNTL (46361) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SDMA1_PERFCOUNTER0_SELECT (46385) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SDMA1_PERFCOUNTER0_SELECT1 (46411) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SDMA1_PERFCOUNTER1_SELECT (46438) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SDMA1_PERFCOUNTER1_SELECT1 (46464) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'C', 'F', 'G', '\0', /* SDMA2_PERFCNT_PERFCOUNTER0_CFG (46491) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'C', 'F', 'G', '\0', /* SDMA2_PERFCNT_PERFCOUNTER1_CFG (46522) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'R', 'S', 'L', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* SDMA2_PERFCNT_PERFCOUNTER_RSLT_CNTL (46553) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'M', 'I', 'S', 'C', '_', 'C', 'N', 'T', 'L', '\0', /* SDMA2_PERFCNT_MISC_CNTL (46589) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SDMA2_PERFCOUNTER0_SELECT (46613) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SDMA2_PERFCOUNTER0_SELECT1 (46639) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SDMA2_PERFCOUNTER1_SELECT (46666) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SDMA2_PERFCOUNTER1_SELECT1 (46692) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'C', 'F', 'G', '\0', /* SDMA3_PERFCNT_PERFCOUNTER0_CFG (46719) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'C', 'F', 'G', '\0', /* SDMA3_PERFCNT_PERFCOUNTER1_CFG (46750) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'R', 'S', 'L', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* SDMA3_PERFCNT_PERFCOUNTER_RSLT_CNTL (46781) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'M', 'I', 'S', 'C', '_', 'C', 'N', 'T', 'L', '\0', /* SDMA3_PERFCNT_MISC_CNTL (46817) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SDMA3_PERFCOUNTER0_SELECT (46841) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SDMA3_PERFCOUNTER0_SELECT1 (46867) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SDMA3_PERFCOUNTER1_SELECT (46894) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SDMA3_PERFCOUNTER1_SELECT1 (46920) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'H', 'W', '_', 'I', 'D', '\0', /* SQ_WAVE_HW_ID (46947) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'I', 'N', 'S', 'T', '_', 'D', 'W', '1', '\0', /* SQ_WAVE_INST_DW1 (46961) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'I', 'B', '_', 'D', 'B', 'G', '0', '\0', /* SQ_WAVE_IB_DBG0 (46978) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'B', 'A', '_', 'L', 'O', '\0', /* SQ_WAVE_TBA_LO (46994) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'B', 'A', '_', 'H', 'I', '\0', /* SQ_WAVE_TBA_HI (47009) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'M', 'A', '_', 'L', 'O', '\0', /* SQ_WAVE_TMA_LO (47024) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'M', 'A', '_', 'H', 'I', '\0', /* SQ_WAVE_TMA_HI (47039) */
	'S', 'R', 'B', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '2', '\0', /* SRBM_STATUS2 (47054) */
	'S', 'R', 'B', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* SRBM_STATUS (47067) */
	'S', 'R', 'B', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '3', '\0', /* SRBM_STATUS3 (47079) */
	'G', 'R', 'B', 'M', '_', 'C', 'N', 'T', 'L', '\0', /* GRBM_CNTL (47092) */
	'G', 'R', 'B', 'M', '_', 'S', 'K', 'E', 'W', '_', 'C', 'N', 'T', 'L', '\0', /* GRBM_SKEW_CNTL (47102) */
	'G', 'R', 'B', 'M', '_', 'P', 'W', 'R', '_', 'C', 'N', 'T', 'L', '\0', /* GRBM_PWR_CNTL (47117) */
	'G', 'R', 'B', 'M', '_', 'S', 'O', 'F', 'T', '_', 'R', 'E', 'S', 'E', 'T', '\0', /* GRBM_SOFT_RESET (47131) */
	'G', 'R', 'B', 'M', '_', 'D', 'E', 'B', 'U', 'G', '_', 'C', 'N', 'T', 'L', '\0', /* GRBM_DEBUG_CNTL (47147) */
	'G', 'R', 'B', 'M', '_', 'D', 'E', 'B', 'U', 'G', '_', 'D', 'A', 'T', 'A', '\0', /* GRBM_DEBUG_DATA (47163, 47168) */
	'G', 'R', 'B', 'M', '_', 'G', 'F', 'X', '_', 'C', 'L', 'K', 'E', 'N', '_', 'C', 'N', 'T', 'L', '\0', /* GRBM_GFX_CLKEN_CNTL (47179) */
	'G', 'R', 'B', 'M', '_', 'W', 'A', 'I', 'T', '_', 'I', 'D', 'L', 'E', '_', 'C', 'L', 'O', 'C', 'K', 'S', '\0', /* GRBM_WAIT_IDLE_CLOCKS (47199, 47204) */
	'G', 'R', 'B', 'M', '_', 'D', 'E', 'B', 'U', 'G', '\0', /* GRBM_DEBUG (47221) */
	'G', 'R', 'B', 'M', '_', 'D', 'E', 'B', 'U', 'G', '_', 'S', 'N', 'A', 'P', 'S', 'H', 'O', 'T', '\0', /* GRBM_DEBUG_SNAPSHOT (47232) */
	'G', 'R', 'B', 'M', '_', 'R', 'E', 'A', 'D', '_', 'E', 'R', 'R', 'O', 'R', '\0', /* GRBM_READ_ERROR (47252, 47257) */
	'G', 'R', 'B', 'M', '_', 'I', 'N', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* GRBM_INT_CNTL (47268) */
	'D', 'E', 'B', 'U', 'G', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* DEBUG_INDEX (47282) */
	'G', 'R', 'B', 'M', '_', 'N', 'O', 'W', 'H', 'E', 'R', 'E', '\0', /* GRBM_NOWHERE (47294) */
	'G', 'R', 'B', 'M', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '0', '\0', /* GRBM_SCRATCH_REG0 (47307) */
	'G', 'R', 'B', 'M', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '1', '\0', /* GRBM_SCRATCH_REG1 (47325) */
	'G', 'R', 'B', 'M', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '2', '\0', /* GRBM_SCRATCH_REG2 (47343) */
	'G', 'R', 'B', 'M', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '3', '\0', /* GRBM_SCRATCH_REG3 (47361) */
	'G', 'R', 'B', 'M', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '4', '\0', /* GRBM_SCRATCH_REG4 (47379) */
	'G', 'R', 'B', 'M', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '5', '\0', /* GRBM_SCRATCH_REG5 (47397) */
	'G', 'R', 'B', 'M', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '6', '\0', /* GRBM_SCRATCH_REG6 (47415) */
	'G', 'R', 'B', 'M', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '7', '\0', /* GRBM_SCRATCH_REG7 (47433) */
	'S', 'Q', '_', 'I', 'N', 'T', 'E', 'R', 'R', 'U', 'P', 'T', '_', 'W', 'O', 'R', 'D', '_', 'A', 'U', 'T', 'O', '\0', /* SQ_INTERRUPT_WORD_AUTO (47451) */
	'C', 'P', '_', 'S', 'T', 'A', 'L', 'L', 'E', 'D', '_', 'S', 'T', 'A', 'T', '3', '\0', /* CP_STALLED_STAT3 (47474) */
	'C', 'P', '_', 'S', 'T', 'A', 'L', 'L', 'E', 'D', '_', 'S', 'T', 'A', 'T', '1', '\0', /* CP_STALLED_STAT1 (47491) */
	'C', 'P', '_', 'S', 'T', 'A', 'L', 'L', 'E', 'D', '_', 'S', 'T', 'A', 'T', '2', '\0', /* CP_STALLED_STAT2 (47508) */
	'C', 'P', '_', 'B', 'U', 'S', 'Y', '_', 'S', 'T', 'A', 'T', '\0', /* CP_BUSY_STAT (47525) */
	'C', 'P', '_', 'S', 'T', 'A', 'T', '\0', /* CP_STAT (47538) */
	'C', 'P', '_', 'M', 'E', '_', 'H', 'E', 'A', 'D', 'E', 'R', '_', 'D', 'U', 'M', 'P', '\0', /* CP_ME_HEADER_DUMP (47546) */
	'C', 'P', '_', 'P', 'F', 'P', '_', 'H', 'E', 'A', 'D', 'E', 'R', '_', 'D', 'U', 'M', 'P', '\0', /* CP_PFP_HEADER_DUMP (47564) */
	'C', 'P', '_', 'G', 'R', 'B', 'M', '_', 'F', 'R', 'E', 'E', '_', 'C', 'O', 'U', 'N', 'T', '\0', /* CP_GRBM_FREE_COUNT (47583) */
	'C', 'P', '_', 'C', 'E', '_', 'H', 'E', 'A', 'D', 'E', 'R', '_', 'D', 'U', 'M', 'P', '\0', /* CP_CE_HEADER_DUMP (47602) */
	'C', 'P', '_', 'M', 'C', '_', 'P', 'A', 'C', 'K', '_', 'D', 'E', 'L', 'A', 'Y', '_', 'C', 'N', 'T', '\0', /* CP_MC_PACK_DELAY_CNT (47620, 47626) */
	'C', 'P', '_', 'C', 'S', 'F', '_', 'S', 'T', 'A', 'T', '\0', /* CP_CSF_STAT (47641) */
	'C', 'P', '_', 'C', 'S', 'F', '_', 'C', 'N', 'T', 'L', '\0', /* CP_CSF_CNTL (47653) */
	'C', 'P', '_', 'M', 'E', '_', 'C', 'N', 'T', 'L', '\0', /* CP_ME_CNTL (47665) */
	'C', 'P', '_', 'C', 'N', 'T', 'X', '_', 'S', 'T', 'A', 'T', '\0', /* CP_CNTX_STAT (47676) */
	'C', 'P', '_', 'M', 'E', '_', 'P', 'R', 'E', 'E', 'M', 'P', 'T', 'I', 'O', 'N', '\0', /* CP_ME_PREEMPTION (47689) */
	'C', 'P', '_', 'R', 'B', '2', '_', 'R', 'P', 'T', 'R', '\0', /* CP_RB2_RPTR (47706) */
	'C', 'P', '_', 'R', 'B', '1', '_', 'R', 'P', 'T', 'R', '\0', /* CP_RB1_RPTR (47718) */
	'C', 'P', '_', 'R', 'B', '0', '_', 'R', 'P', 'T', 'R', '\0', /* CP_RB0_RPTR (47730) */
	'C', 'P', '_', 'R', 'B', '_', 'W', 'P', 'T', 'R', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* CP_RB_WPTR_DELAY (47742) */
	'C', 'P', '_', 'R', 'B', '_', 'W', 'P', 'T', 'R', '_', 'P', 'O', 'L', 'L', '_', 'C', 'N', 'T', 'L', '\0', /* CP_RB_WPTR_POLL_CNTL (47759) */
	'C', 'P', '_', 'R', 'O', 'Q', '1', '_', 'T', 'H', 'R', 'E', 'S', 'H', 'O', 'L', 'D', 'S', '\0', /* CP_ROQ1_THRESHOLDS (47780) */
	'C', 'P', '_', 'R', 'O', 'Q', '2', '_', 'T', 'H', 'R', 'E', 'S', 'H', 'O', 'L', 'D', 'S', '\0', /* CP_ROQ2_THRESHOLDS (47799) */
	'C', 'P', '_', 'S', 'T', 'Q', '_', 'T', 'H', 'R', 'E', 'S', 'H', 'O', 'L', 'D', 'S', '\0', /* CP_STQ_THRESHOLDS (47818) */
	'C', 'P', '_', 'Q', 'U', 'E', 'U', 'E', '_', 'T', 'H', 'R', 'E', 'S', 'H', 'O', 'L', 'D', 'S', '\0', /* CP_QUEUE_THRESHOLDS (47836) */
	'C', 'P', '_', 'M', 'E', 'Q', '_', 'T', 'H', 'R', 'E', 'S', 'H', 'O', 'L', 'D', 'S', '\0', /* CP_MEQ_THRESHOLDS (47856) */
	'C', 'P', '_', 'R', 'O', 'Q', '_', 'A', 'V', 'A', 'I', 'L', '\0', /* CP_ROQ_AVAIL (47874) */
	'C', 'P', '_', 'S', 'T', 'Q', '_', 'A', 'V', 'A', 'I', 'L', '\0', /* CP_STQ_AVAIL (47887) */
	'C', 'P', '_', 'R', 'O', 'Q', '2', '_', 'A', 'V', 'A', 'I', 'L', '\0', /* CP_ROQ2_AVAIL (47900) */
	'C', 'P', '_', 'M', 'E', 'Q', '_', 'A', 'V', 'A', 'I', 'L', '\0', /* CP_MEQ_AVAIL (47914) */
	'C', 'P', '_', 'C', 'M', 'D', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* CP_CMD_INDEX (47927, 47930) */
	'C', 'P', '_', 'C', 'M', 'D', '_', 'D', 'A', 'T', 'A', '\0', /* CP_CMD_DATA (47940) */
	'C', 'P', '_', 'R', 'O', 'Q', '_', 'R', 'B', '_', 'S', 'T', 'A', 'T', '\0', /* CP_ROQ_RB_STAT (47952) */
	'C', 'P', '_', 'R', 'O', 'Q', '_', 'I', 'B', '1', '_', 'S', 'T', 'A', 'T', '\0', /* CP_ROQ_IB1_STAT (47967) */
	'C', 'P', '_', 'R', 'O', 'Q', '_', 'I', 'B', '2', '_', 'S', 'T', 'A', 'T', '\0', /* CP_ROQ_IB2_STAT (47983) */
	'C', 'P', '_', 'S', 'T', 'Q', '_', 'S', 'T', 'A', 'T', '\0', /* CP_STQ_STAT (47999) */
	'C', 'P', '_', 'M', 'E', 'Q', '_', 'S', 'T', 'A', 'T', '\0', /* CP_MEQ_STAT (48011) */
	'C', 'P', '_', 'C', 'E', 'Q', '1', '_', 'A', 'V', 'A', 'I', 'L', '\0', /* CP_CEQ1_AVAIL (48023) */
	'C', 'P', '_', 'C', 'E', 'Q', '2', '_', 'A', 'V', 'A', 'I', 'L', '\0', /* CP_CEQ2_AVAIL (48037) */
	'C', 'P', '_', 'C', 'E', '_', 'R', 'O', 'Q', '_', 'R', 'B', '_', 'S', 'T', 'A', 'T', '\0', /* CP_CE_ROQ_RB_STAT (48051) */
	'C', 'P', '_', 'C', 'E', '_', 'R', 'O', 'Q', '_', 'I', 'B', '1', '_', 'S', 'T', 'A', 'T', '\0', /* CP_CE_ROQ_IB1_STAT (48069) */
	'C', 'P', '_', 'C', 'E', '_', 'R', 'O', 'Q', '_', 'I', 'B', '2', '_', 'S', 'T', 'A', 'T', '\0', /* CP_CE_ROQ_IB2_STAT (48088) */
	'C', 'P', '_', 'I', 'N', 'T', '_', 'S', 'T', 'A', 'T', '_', 'D', 'E', 'B', 'U', 'G', '\0', /* CP_INT_STAT_DEBUG (48107) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* IA_PERFCOUNTER0_SELECT (48125) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* IA_PERFCOUNTER1_SELECT (48148) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* IA_PERFCOUNTER2_SELECT (48171) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* IA_PERFCOUNTER3_SELECT (48194) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* IA_PERFCOUNTER0_LO (48217) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* IA_PERFCOUNTER0_HI (48236) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* IA_PERFCOUNTER1_LO (48255) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* IA_PERFCOUNTER1_HI (48274) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* IA_PERFCOUNTER2_LO (48293) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* IA_PERFCOUNTER2_HI (48312) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* IA_PERFCOUNTER3_LO (48331) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* IA_PERFCOUNTER3_HI (48350) */
	'V', 'G', 'T', '_', 'V', 'T', 'X', '_', 'V', 'E', 'C', 'T', '_', 'E', 'J', 'E', 'C', 'T', '_', 'R', 'E', 'G', '\0', /* VGT_VTX_VECT_EJECT_REG (48369) */
	'V', 'G', 'T', '_', 'D', 'M', 'A', '_', 'D', 'A', 'T', 'A', '_', 'F', 'I', 'F', 'O', '_', 'D', 'E', 'P', 'T', 'H', '\0', /* VGT_DMA_DATA_FIFO_DEPTH (48392, 48396) */
	'V', 'G', 'T', '_', 'D', 'M', 'A', '_', 'R', 'E', 'Q', '_', 'F', 'I', 'F', 'O', '_', 'D', 'E', 'P', 'T', 'H', '\0', /* VGT_DMA_REQ_FIFO_DEPTH (48416, 48420) */
	'V', 'G', 'T', '_', 'D', 'R', 'A', 'W', '_', 'I', 'N', 'I', 'T', '_', 'F', 'I', 'F', 'O', '_', 'D', 'E', 'P', 'T', 'H', '\0', /* VGT_DRAW_INIT_FIFO_DEPTH (48439, 48443) */
	'V', 'G', 'T', '_', 'L', 'A', 'S', 'T', '_', 'C', 'O', 'P', 'Y', '_', 'S', 'T', 'A', 'T', 'E', '\0', /* VGT_LAST_COPY_STATE (48464) */
	'V', 'G', 'T', '_', 'C', 'A', 'C', 'H', 'E', '_', 'I', 'N', 'V', 'A', 'L', 'I', 'D', 'A', 'T', 'I', 'O', 'N', '\0', /* VGT_CACHE_INVALIDATION (48484, 48488) */
	'V', 'G', 'T', '_', 'E', 'S', 'G', 'S', '_', 'R', 'I', 'N', 'G', '_', 'S', 'I', 'Z', 'E', '\0', /* VGT_ESGS_RING_SIZE (48507) */
	'V', 'G', 'T', '_', 'G', 'S', 'V', 'S', '_', 'R', 'I', 'N', 'G', '_', 'S', 'I', 'Z', 'E', '\0', /* VGT_GSVS_RING_SIZE (48526) */
	'V', 'G', 'T', '_', 'F', 'I', 'F', 'O', '_', 'D', 'E', 'P', 'T', 'H', 'S', '\0', /* VGT_FIFO_DEPTHS (48545) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'V', 'E', 'R', 'T', 'E', 'X', '_', 'R', 'E', 'U', 'S', 'E', '\0', /* VGT_GS_VERTEX_REUSE (48561) */
	'V', 'G', 'T', '_', 'M', 'C', '_', 'L', 'A', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* VGT_MC_LAT_CNTL (48581) */
	'I', 'A', '_', 'C', 'N', 'T', 'L', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* IA_CNTL_STATUS (48597) */
	'V', 'G', 'T', '_', 'D', 'E', 'B', 'U', 'G', '_', 'C', 'N', 'T', 'L', '\0', /* VGT_DEBUG_CNTL (48612) */
	'V', 'G', 'T', '_', 'D', 'E', 'B', 'U', 'G', '_', 'D', 'A', 'T', 'A', '\0', /* VGT_DEBUG_DATA (48627) */
	'I', 'A', '_', 'D', 'E', 'B', 'U', 'G', '_', 'C', 'N', 'T', 'L', '\0', /* IA_DEBUG_CNTL (48642) */
	'I', 'A', '_', 'D', 'E', 'B', 'U', 'G', '_', 'D', 'A', 'T', 'A', '\0', /* IA_DEBUG_DATA (48656) */
	'V', 'G', 'T', '_', 'C', 'N', 'T', 'L', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* VGT_CNTL_STATUS (48670) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'S', 'E', 'I', 'D', '_', 'M', 'A', 'S', 'K', '\0', /* VGT_PERFCOUNTER_SEID_MASK (48686) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* VGT_PERFCOUNTER0_SELECT (48712) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* VGT_PERFCOUNTER1_SELECT (48736) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* VGT_PERFCOUNTER2_SELECT (48760) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* VGT_PERFCOUNTER3_SELECT (48784) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* VGT_PERFCOUNTER0_LO (48808) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* VGT_PERFCOUNTER0_HI (48828) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* VGT_PERFCOUNTER1_LO (48848) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* VGT_PERFCOUNTER1_HI (48868) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* VGT_PERFCOUNTER2_LO (48888) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* VGT_PERFCOUNTER2_HI (48908) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* VGT_PERFCOUNTER3_LO (48928) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* VGT_PERFCOUNTER3_HI (48948) */
	'C', 'G', 'T', 'T', '_', 'V', 'G', 'T', '_', 'C', 'L', 'K', '_', 'C', 'T', 'R', 'L', '\0', /* CGTT_VGT_CLK_CTRL (48968) */
	'I', 'A', '_', 'V', 'M', 'I', 'D', '_', 'O', 'V', 'E', 'R', 'R', 'I', 'D', 'E', '\0', /* IA_VMID_OVERRIDE (48986) */
	'C', 'G', 'T', 'T', '_', 'I', 'A', '_', 'C', 'L', 'K', '_', 'C', 'T', 'R', 'L', '\0', /* CGTT_IA_CLK_CTRL (49003) */
	'V', 'G', 'T', '_', 'T', 'F', '_', 'R', 'I', 'N', 'G', '_', 'S', 'I', 'Z', 'E', '\0', /* VGT_TF_RING_SIZE (49020) */
	'V', 'G', 'T', '_', 'S', 'Y', 'S', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* VGT_SYS_CONFIG (49037) */
	'V', 'G', 'T', '_', 'H', 'S', '_', 'O', 'F', 'F', 'C', 'H', 'I', 'P', '_', 'P', 'A', 'R', 'A', 'M', '\0', /* VGT_HS_OFFCHIP_PARAM (49052) */
	'V', 'G', 'T', '_', 'T', 'F', '_', 'M', 'E', 'M', 'O', 'R', 'Y', '_', 'B', 'A', 'S', 'E', '\0', /* VGT_TF_MEMORY_BASE (49073) */
	'C', 'C', '_', 'G', 'C', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'A', 'R', 'R', 'A', 'Y', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* CC_GC_SHADER_ARRAY_CONFIG (49092) */
	'G', 'C', '_', 'U', 'S', 'E', 'R', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'A', 'R', 'R', 'A', 'Y', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* GC_USER_SHADER_ARRAY_CONFIG (49118) */
	'P', 'A', '_', 'S', 'U', '_', 'D', 'E', 'B', 'U', 'G', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SU_DEBUG_CNTL (49146) */
	'P', 'A', '_', 'S', 'U', '_', 'D', 'E', 'B', 'U', 'G', '_', 'D', 'A', 'T', 'A', '\0', /* PA_SU_DEBUG_DATA (49163) */
	'P', 'A', '_', 'C', 'L', '_', 'C', 'N', 'T', 'L', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* PA_CL_CNTL_STATUS (49180) */
	'P', 'A', '_', 'C', 'L', '_', 'E', 'N', 'H', 'A', 'N', 'C', 'E', '\0', /* PA_CL_ENHANCE (49198) */
	'C', 'G', 'T', 'T', '_', 'P', 'A', '_', 'C', 'L', 'K', '_', 'C', 'T', 'R', 'L', '\0', /* CGTT_PA_CLK_CTRL (49212) */
	'P', 'A', '_', 'S', 'U', '_', 'C', 'N', 'T', 'L', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* PA_SU_CNTL_STATUS (49229) */
	'P', 'A', '_', 'S', 'C', '_', 'F', 'I', 'F', 'O', '_', 'D', 'E', 'P', 'T', 'H', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SC_FIFO_DEPTH_CNTL (49247) */
	'P', 'A', '_', 'S', 'C', '_', 'F', 'O', 'R', 'C', 'E', '_', 'E', 'O', 'V', '_', 'M', 'A', 'X', '_', 'C', 'N', 'T', 'S', '\0', /* PA_SC_FORCE_EOV_MAX_CNTS (49269) */
	'C', 'G', 'T', 'T', '_', 'S', 'C', '_', 'C', 'L', 'K', '_', 'C', 'T', 'R', 'L', '\0', /* CGTT_SC_CLK_CTRL (49294) */
	'P', 'A', '_', 'S', 'C', '_', 'F', 'I', 'F', 'O', '_', 'S', 'I', 'Z', 'E', '\0', /* PA_SC_FIFO_SIZE (49311) */
	'P', 'A', '_', 'S', 'C', '_', 'I', 'F', '_', 'F', 'I', 'F', 'O', '_', 'S', 'I', 'Z', 'E', '\0', /* PA_SC_IF_FIFO_SIZE (49327) */
	'P', 'A', '_', 'S', 'C', '_', 'D', 'E', 'B', 'U', 'G', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SC_DEBUG_CNTL (49346) */
	'P', 'A', '_', 'S', 'C', '_', 'D', 'E', 'B', 'U', 'G', '_', 'D', 'A', 'T', 'A', '\0', /* PA_SC_DEBUG_DATA (49363) */
	'P', 'A', '_', 'S', 'C', '_', 'E', 'N', 'H', 'A', 'N', 'C', 'E', '\0', /* PA_SC_ENHANCE (49380) */
	'S', 'Q', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* SQ_CONFIG (49394) */
	'S', 'Q', 'C', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* SQC_CONFIG (49404) */
	'S', 'Q', '_', 'R', 'A', 'N', 'D', 'O', 'M', '_', 'W', 'A', 'V', 'E', '_', 'P', 'R', 'I', '\0', /* SQ_RANDOM_WAVE_PRI (49415) */
	'S', 'Q', '_', 'R', 'E', 'G', '_', 'C', 'R', 'E', 'D', 'I', 'T', 'S', '\0', /* SQ_REG_CREDITS (49434) */
	'S', 'Q', '_', 'F', 'I', 'F', 'O', '_', 'S', 'I', 'Z', 'E', 'S', '\0', /* SQ_FIFO_SIZES (49449) */
	'C', 'C', '_', 'S', 'Q', 'C', '_', 'B', 'A', 'N', 'K', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* CC_SQC_BANK_DISABLE (49463) */
	'U', 'S', 'E', 'R', '_', 'S', 'Q', 'C', '_', 'B', 'A', 'N', 'K', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* USER_SQC_BANK_DISABLE (49483) */
	'S', 'Q', '_', 'D', 'E', 'B', 'U', 'G', '_', 'S', 'T', 'S', '_', 'G', 'L', 'O', 'B', 'A', 'L', '\0', /* SQ_DEBUG_STS_GLOBAL (49505) */
	'S', 'Q', '_', 'A', 'L', 'U', '_', 'C', 'L', 'K', '_', 'C', 'T', 'R', 'L', '\0', /* SQ_ALU_CLK_CTRL (49525) */
	'S', 'Q', '_', 'T', 'E', 'X', '_', 'C', 'L', 'K', '_', 'C', 'T', 'R', 'L', '\0', /* SQ_TEX_CLK_CTRL (49541) */
	'C', 'G', 'T', 'T', '_', 'S', 'Q', '_', 'C', 'L', 'K', '_', 'C', 'T', 'R', 'L', '\0', /* CGTT_SQ_CLK_CTRL (49557) */
	'C', 'G', 'T', 'T', '_', 'S', 'Q', 'G', '_', 'C', 'L', 'K', '_', 'C', 'T', 'R', 'L', '\0', /* CGTT_SQG_CLK_CTRL (49574) */
	'S', 'Q', '_', 'I', 'N', 'D', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* SQ_IND_INDEX (49592) */
	'S', 'Q', '_', 'I', 'N', 'D', '_', 'D', 'A', 'T', 'A', '\0', /* SQ_IND_DATA (49605) */
	'S', 'Q', '_', 'T', 'I', 'M', 'E', '_', 'H', 'I', '\0', /* SQ_TIME_HI (49617) */
	'S', 'Q', '_', 'T', 'I', 'M', 'E', '_', 'L', 'O', '\0', /* SQ_TIME_LO (49628) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'B', 'A', 'S', 'E', '\0', /* SQ_THREAD_TRACE_BASE (49639) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'S', 'I', 'Z', 'E', '\0', /* SQ_THREAD_TRACE_SIZE (49660) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'P', 'E', 'R', 'F', '_', 'M', 'A', 'S', 'K', '\0', /* SQ_THREAD_TRACE_PERF_MASK (49681) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'M', 'O', 'D', 'E', '\0', /* SQ_THREAD_TRACE_MODE (49707) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'C', 'N', 'T', 'R', '\0', /* SQ_THREAD_TRACE_CNTR (49728) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'H', 'I', 'W', 'A', 'T', 'E', 'R', '\0', /* SQ_THREAD_TRACE_HIWATER (49749, 49765) */
	'S', 'Q', '_', 'P', 'O', 'W', 'E', 'R', '_', 'T', 'H', 'R', 'O', 'T', 'T', 'L', 'E', '\0', /* SQ_POWER_THROTTLE (49773) */
	'S', 'Q', '_', 'P', 'O', 'W', 'E', 'R', '_', 'T', 'H', 'R', 'O', 'T', 'T', 'L', 'E', '2', '\0', /* SQ_POWER_THROTTLE2 (49791) */
	'S', 'Q', '_', 'L', 'B', '_', 'C', 'T', 'R', '_', 'C', 'T', 'R', 'L', '\0', /* SQ_LB_CTR_CTRL (49810) */
	'S', 'Q', '_', 'L', 'B', '_', 'D', 'A', 'T', 'A', '_', 'A', 'L', 'U', '_', 'C', 'Y', 'C', 'L', 'E', 'S', '\0', /* SQ_LB_DATA_ALU_CYCLES (49825) */
	'S', 'Q', '_', 'L', 'B', '_', 'D', 'A', 'T', 'A', '_', 'T', 'E', 'X', '_', 'C', 'Y', 'C', 'L', 'E', 'S', '\0', /* SQ_LB_DATA_TEX_CYCLES (49847) */
	'S', 'Q', '_', 'L', 'B', '_', 'D', 'A', 'T', 'A', '_', 'A', 'L', 'U', '_', 'S', 'T', 'A', 'L', 'L', 'S', '\0', /* SQ_LB_DATA_ALU_STALLS (49869) */
	'S', 'Q', '_', 'L', 'B', '_', 'D', 'A', 'T', 'A', '_', 'T', 'E', 'X', '_', 'S', 'T', 'A', 'L', 'L', 'S', '\0', /* SQ_LB_DATA_TEX_STALLS (49891) */
	'S', 'Q', 'C', '_', 'S', 'E', 'C', 'D', 'E', 'D', '_', 'C', 'N', 'T', '\0', /* SQC_SECDED_CNT (49913) */
	'S', 'Q', '_', 'S', 'E', 'C', '_', 'C', 'N', 'T', '\0', /* SQ_SEC_CNT (49928) */
	'S', 'Q', '_', 'D', 'E', 'D', '_', 'C', 'N', 'T', '\0', /* SQ_DED_CNT (49939) */
	'S', 'Q', '_', 'D', 'E', 'D', '_', 'I', 'N', 'F', 'O', '\0', /* SQ_DED_INFO (49950) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'B', 'A', '_', 'L', 'O', '_', 'P', 'S', '\0', /* SPI_SHADER_TBA_LO_PS (49962) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'B', 'A', '_', 'H', 'I', '_', 'P', 'S', '\0', /* SPI_SHADER_TBA_HI_PS (49983) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'M', 'A', '_', 'L', 'O', '_', 'P', 'S', '\0', /* SPI_SHADER_TMA_LO_PS (50004) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'M', 'A', '_', 'H', 'I', '_', 'P', 'S', '\0', /* SPI_SHADER_TMA_HI_PS (50025) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'B', 'A', '_', 'L', 'O', '_', 'V', 'S', '\0', /* SPI_SHADER_TBA_LO_VS (50046) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'B', 'A', '_', 'H', 'I', '_', 'V', 'S', '\0', /* SPI_SHADER_TBA_HI_VS (50067) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'M', 'A', '_', 'L', 'O', '_', 'V', 'S', '\0', /* SPI_SHADER_TMA_LO_VS (50088) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'M', 'A', '_', 'H', 'I', '_', 'V', 'S', '\0', /* SPI_SHADER_TMA_HI_VS (50109) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'B', 'A', '_', 'L', 'O', '_', 'G', 'S', '\0', /* SPI_SHADER_TBA_LO_GS (50130) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'B', 'A', '_', 'H', 'I', '_', 'G', 'S', '\0', /* SPI_SHADER_TBA_HI_GS (50151) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'M', 'A', '_', 'L', 'O', '_', 'G', 'S', '\0', /* SPI_SHADER_TMA_LO_GS (50172) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'M', 'A', '_', 'H', 'I', '_', 'G', 'S', '\0', /* SPI_SHADER_TMA_HI_GS (50193) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'B', 'A', '_', 'L', 'O', '_', 'E', 'S', '\0', /* SPI_SHADER_TBA_LO_ES (50214) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'B', 'A', '_', 'H', 'I', '_', 'E', 'S', '\0', /* SPI_SHADER_TBA_HI_ES (50235) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'M', 'A', '_', 'L', 'O', '_', 'E', 'S', '\0', /* SPI_SHADER_TMA_LO_ES (50256) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'M', 'A', '_', 'H', 'I', '_', 'E', 'S', '\0', /* SPI_SHADER_TMA_HI_ES (50277) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'B', 'A', '_', 'L', 'O', '_', 'H', 'S', '\0', /* SPI_SHADER_TBA_LO_HS (50298) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'B', 'A', '_', 'H', 'I', '_', 'H', 'S', '\0', /* SPI_SHADER_TBA_HI_HS (50319) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'M', 'A', '_', 'L', 'O', '_', 'H', 'S', '\0', /* SPI_SHADER_TMA_LO_HS (50340) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'M', 'A', '_', 'H', 'I', '_', 'H', 'S', '\0', /* SPI_SHADER_TMA_HI_HS (50361) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'B', 'A', '_', 'L', 'O', '_', 'L', 'S', '\0', /* SPI_SHADER_TBA_LO_LS (50382) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'B', 'A', '_', 'H', 'I', '_', 'L', 'S', '\0', /* SPI_SHADER_TBA_HI_LS (50403) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'M', 'A', '_', 'L', 'O', '_', 'L', 'S', '\0', /* SPI_SHADER_TMA_LO_LS (50424) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'M', 'A', '_', 'H', 'I', '_', 'L', 'S', '\0', /* SPI_SHADER_TMA_HI_LS (50445) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'M', 'A', 'X', '_', 'W', 'A', 'V', 'E', '_', 'I', 'D', '\0', /* COMPUTE_MAX_WAVE_ID (50466, 50474, 50478) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'T', 'B', 'A', '_', 'L', 'O', '\0', /* COMPUTE_TBA_LO (50486) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'T', 'B', 'A', '_', 'H', 'I', '\0', /* COMPUTE_TBA_HI (50501) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'T', 'M', 'A', '_', 'L', 'O', '\0', /* COMPUTE_TMA_LO (50516) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'T', 'M', 'A', '_', 'H', 'I', '\0', /* COMPUTE_TMA_HI (50531) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'S', 'T', 'A', 'T', 'I', 'C', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'M', 'G', 'M', 'T', '_', 'S', 'E', '0', '\0', /* COMPUTE_STATIC_THREAD_MGMT_SE0 (50546) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'S', 'T', 'A', 'T', 'I', 'C', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'M', 'G', 'M', 'T', '_', 'S', 'E', '1', '\0', /* COMPUTE_STATIC_THREAD_MGMT_SE1 (50577) */
	'S', 'D', 'M', 'A', '0', '_', 'S', 'T', 'A', 'T', 'U', 'S', '_', 'R', 'E', 'G', '\0', /* SDMA0_STATUS_REG (50608) */
	'S', 'D', 'M', 'A', '1', '_', 'S', 'T', 'A', 'T', 'U', 'S', '_', 'R', 'E', 'G', '\0', /* SDMA1_STATUS_REG (50625) */
	'D', 'B', '_', 'D', 'E', 'P', 'T', 'H', '_', 'I', 'N', 'F', 'O', '\0', /* DB_DEPTH_INFO (50642) */
	'D', 'B', '_', 'D', 'E', 'P', 'T', 'H', '_', 'S', 'I', 'Z', 'E', '\0', /* DB_DEPTH_SIZE (50656) */
	'D', 'B', '_', 'D', 'E', 'P', 'T', 'H', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* DB_DEPTH_SLICE (50670) */
	'C', 'P', '_', 'R', 'I', 'N', 'G', 'I', 'D', '\0', /* CP_RINGID (50685, 50688) */
	'C', 'P', '_', 'C', 'P', 'C', '_', 'M', 'C', '_', 'C', 'N', 'T', 'L', '\0', /* CP_CPC_MC_CNTL (50695) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'B', 'A', 'S', 'E', '2', '\0', /* SQ_THREAD_TRACE_BASE2 (50710) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'T', 'O', 'K', 'E', 'N', '_', 'M', 'A', 'S', 'K', '2', '\0', /* SQ_THREAD_TRACE_TOKEN_MASK2 (50732) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'S', 'T', 'A', 'T', 'I', 'C', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'M', 'G', 'M', 'T', '_', 'S', 'E', '2', '\0', /* COMPUTE_STATIC_THREAD_MGMT_SE2 (50760) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'S', 'T', 'A', 'T', 'I', 'C', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'M', 'G', 'M', 'T', '_', 'S', 'E', '3', '\0', /* COMPUTE_STATIC_THREAD_MGMT_SE3 (50791) */
	'W', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* WD_PERFCOUNTER0_LO (50822) */
	'W', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* WD_PERFCOUNTER0_HI (50841) */
	'W', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* WD_PERFCOUNTER1_LO (50860) */
	'W', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* WD_PERFCOUNTER1_HI (50879) */
	'W', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* WD_PERFCOUNTER2_LO (50898) */
	'W', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* WD_PERFCOUNTER2_HI (50917) */
	'W', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* WD_PERFCOUNTER3_LO (50936) */
	'W', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* WD_PERFCOUNTER3_HI (50955) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* TCC_PERFCOUNTER0_LO (50974) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* TCC_PERFCOUNTER0_HI (50994) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* TCC_PERFCOUNTER1_LO (51014) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* TCC_PERFCOUNTER1_HI (51034) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* TCC_PERFCOUNTER2_LO (51054) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* TCC_PERFCOUNTER2_HI (51074) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* TCC_PERFCOUNTER3_LO (51094) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* TCC_PERFCOUNTER3_HI (51114) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* TCA_PERFCOUNTER0_LO (51134) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* TCA_PERFCOUNTER0_HI (51154) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* TCA_PERFCOUNTER1_LO (51174) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* TCA_PERFCOUNTER1_HI (51194) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* TCA_PERFCOUNTER2_LO (51214) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* TCA_PERFCOUNTER2_HI (51234) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* TCA_PERFCOUNTER3_LO (51254) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* TCA_PERFCOUNTER3_HI (51274) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* TCS_PERFCOUNTER0_LO (51294) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* TCS_PERFCOUNTER0_HI (51314) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* TCS_PERFCOUNTER1_LO (51334) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* TCS_PERFCOUNTER1_HI (51354) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* TCS_PERFCOUNTER2_LO (51374) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* TCS_PERFCOUNTER2_HI (51394) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* TCS_PERFCOUNTER3_LO (51414) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* TCS_PERFCOUNTER3_HI (51434) */
	'W', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* WD_PERFCOUNTER0_SELECT (51454) */
	'W', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* WD_PERFCOUNTER1_SELECT (51477) */
	'W', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* WD_PERFCOUNTER2_SELECT (51500) */
	'W', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* WD_PERFCOUNTER3_SELECT (51523) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* IA_PERFCOUNTER0_SELECT1 (51546) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* VGT_PERFCOUNTER0_SELECT1 (51570) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* VGT_PERFCOUNTER1_SELECT1 (51595) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'M', 'A', 'S', 'K', '\0', /* SQ_PERFCOUNTER_MASK (51620) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCC_PERFCOUNTER0_SELECT (51640) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* TCC_PERFCOUNTER0_SELECT1 (51664) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCC_PERFCOUNTER1_SELECT (51689) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* TCC_PERFCOUNTER1_SELECT1 (51713) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCC_PERFCOUNTER2_SELECT (51738) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCC_PERFCOUNTER3_SELECT (51762) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCA_PERFCOUNTER0_SELECT (51786) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* TCA_PERFCOUNTER0_SELECT1 (51810) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCA_PERFCOUNTER1_SELECT (51835) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* TCA_PERFCOUNTER1_SELECT1 (51859) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCA_PERFCOUNTER2_SELECT (51884) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCA_PERFCOUNTER3_SELECT (51908) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCS_PERFCOUNTER0_SELECT (51932) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* TCS_PERFCOUNTER0_SELECT1 (51956) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCS_PERFCOUNTER1_SELECT (51981) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCS_PERFCOUNTER2_SELECT (52005) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCS_PERFCOUNTER3_SELECT (52029) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'C', 'P', 'G', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_CPG_PERFMON_SAMPLE_DELAY (52053, 52065) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'C', 'P', 'C', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_CPC_PERFMON_SAMPLE_DELAY (52086) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'C', 'P', 'F', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_CPF_PERFMON_SAMPLE_DELAY (52119) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'C', 'B', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_CB_PERFMON_SAMPLE_DELAY (52152) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'D', 'B', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_DB_PERFMON_SAMPLE_DELAY (52184) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'P', 'A', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_PA_PERFMON_SAMPLE_DELAY (52216) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_GDS_PERFMON_SAMPLE_DELAY (52248) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'I', 'A', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_IA_PERFMON_SAMPLE_DELAY (52281) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_SC_PERFMON_SAMPLE_DELAY (52313) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_TCC_PERFMON_SAMPLE_DELAY (52345) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_TCA_PERFMON_SAMPLE_DELAY (52378) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_TCP_PERFMON_SAMPLE_DELAY (52411) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'T', 'A', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_TA_PERFMON_SAMPLE_DELAY (52444) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'T', 'D', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_TD_PERFMON_SAMPLE_DELAY (52476) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_VGT_PERFMON_SAMPLE_DELAY (52508) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_SPI_PERFMON_SAMPLE_DELAY (52541) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_SQG_PERFMON_SAMPLE_DELAY (52574) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_TCS_PERFMON_SAMPLE_DELAY (52607) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'X', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_SX_PERFMON_SAMPLE_DELAY (52640) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'D', 'B', 'R', '0', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_DBR0_PERFMON_SAMPLE_DELAY (52672) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'D', 'B', 'R', '1', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_DBR1_PERFMON_SAMPLE_DELAY (52706) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'C', 'B', 'R', '0', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_CBR0_PERFMON_SAMPLE_DELAY (52740) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'C', 'B', 'R', '1', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_CBR1_PERFMON_SAMPLE_DELAY (52774) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'W', 'A', 'V', 'E', '_', 'R', 'E', 'S', 'T', 'O', 'R', 'E', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* COMPUTE_WAVE_RESTORE_CONTROL (52808) */
	'C', 'P', '_', 'C', 'E', '_', 'R', 'B', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* CP_CE_RB_OFFSET (52837) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '1', '6', '\0', /* SPI_SHADER_USER_DATA_ES_16 (52853) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '1', '7', '\0', /* SPI_SHADER_USER_DATA_ES_17 (52880) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '1', '8', '\0', /* SPI_SHADER_USER_DATA_ES_18 (52907) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '1', '9', '\0', /* SPI_SHADER_USER_DATA_ES_19 (52934) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '2', '0', '\0', /* SPI_SHADER_USER_DATA_ES_20 (52961) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '2', '1', '\0', /* SPI_SHADER_USER_DATA_ES_21 (52988) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '2', '2', '\0', /* SPI_SHADER_USER_DATA_ES_22 (53015) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '2', '3', '\0', /* SPI_SHADER_USER_DATA_ES_23 (53042) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '2', '4', '\0', /* SPI_SHADER_USER_DATA_ES_24 (53069) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '2', '5', '\0', /* SPI_SHADER_USER_DATA_ES_25 (53096) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '2', '6', '\0', /* SPI_SHADER_USER_DATA_ES_26 (53123) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '2', '7', '\0', /* SPI_SHADER_USER_DATA_ES_27 (53150) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '2', '8', '\0', /* SPI_SHADER_USER_DATA_ES_28 (53177) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '2', '9', '\0', /* SPI_SHADER_USER_DATA_ES_29 (53204) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '3', '0', '\0', /* SPI_SHADER_USER_DATA_ES_30 (53231) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '3', '1', '\0', /* SPI_SHADER_USER_DATA_ES_31 (53258) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '1', '6', '\0', /* SPI_SHADER_USER_DATA_LS_16 (53285) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '1', '7', '\0', /* SPI_SHADER_USER_DATA_LS_17 (53312) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '1', '8', '\0', /* SPI_SHADER_USER_DATA_LS_18 (53339) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '1', '9', '\0', /* SPI_SHADER_USER_DATA_LS_19 (53366) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '2', '0', '\0', /* SPI_SHADER_USER_DATA_LS_20 (53393) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '2', '1', '\0', /* SPI_SHADER_USER_DATA_LS_21 (53420) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '2', '2', '\0', /* SPI_SHADER_USER_DATA_LS_22 (53447) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '2', '3', '\0', /* SPI_SHADER_USER_DATA_LS_23 (53474) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '2', '4', '\0', /* SPI_SHADER_USER_DATA_LS_24 (53501) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '2', '5', '\0', /* SPI_SHADER_USER_DATA_LS_25 (53528) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '2', '6', '\0', /* SPI_SHADER_USER_DATA_LS_26 (53555) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '2', '7', '\0', /* SPI_SHADER_USER_DATA_LS_27 (53582) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '2', '8', '\0', /* SPI_SHADER_USER_DATA_LS_28 (53609) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '2', '9', '\0', /* SPI_SHADER_USER_DATA_LS_29 (53636) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '3', '0', '\0', /* SPI_SHADER_USER_DATA_LS_30 (53663) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '3', '1', '\0', /* SPI_SHADER_USER_DATA_LS_31 (53690) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '0', '\0', /* SPI_SHADER_USER_DATA_COMMON_0 (53717) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '1', '\0', /* SPI_SHADER_USER_DATA_COMMON_1 (53747) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '2', '\0', /* SPI_SHADER_USER_DATA_COMMON_2 (53777) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '3', '\0', /* SPI_SHADER_USER_DATA_COMMON_3 (53807) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '4', '\0', /* SPI_SHADER_USER_DATA_COMMON_4 (53837) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '5', '\0', /* SPI_SHADER_USER_DATA_COMMON_5 (53867) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '6', '\0', /* SPI_SHADER_USER_DATA_COMMON_6 (53897) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '7', '\0', /* SPI_SHADER_USER_DATA_COMMON_7 (53927) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '8', '\0', /* SPI_SHADER_USER_DATA_COMMON_8 (53957) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '9', '\0', /* SPI_SHADER_USER_DATA_COMMON_9 (53987) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '1', '0', '\0', /* SPI_SHADER_USER_DATA_COMMON_10 (54017) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '1', '1', '\0', /* SPI_SHADER_USER_DATA_COMMON_11 (54048) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '1', '2', '\0', /* SPI_SHADER_USER_DATA_COMMON_12 (54079) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '1', '3', '\0', /* SPI_SHADER_USER_DATA_COMMON_13 (54110) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '1', '4', '\0', /* SPI_SHADER_USER_DATA_COMMON_14 (54141) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '1', '5', '\0', /* SPI_SHADER_USER_DATA_COMMON_15 (54172) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '1', '6', '\0', /* SPI_SHADER_USER_DATA_COMMON_16 (54203) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '1', '7', '\0', /* SPI_SHADER_USER_DATA_COMMON_17 (54234) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '1', '8', '\0', /* SPI_SHADER_USER_DATA_COMMON_18 (54265) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '1', '9', '\0', /* SPI_SHADER_USER_DATA_COMMON_19 (54296) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '2', '0', '\0', /* SPI_SHADER_USER_DATA_COMMON_20 (54327) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '2', '1', '\0', /* SPI_SHADER_USER_DATA_COMMON_21 (54358) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '2', '2', '\0', /* SPI_SHADER_USER_DATA_COMMON_22 (54389) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '2', '3', '\0', /* SPI_SHADER_USER_DATA_COMMON_23 (54420) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '2', '4', '\0', /* SPI_SHADER_USER_DATA_COMMON_24 (54451) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '2', '5', '\0', /* SPI_SHADER_USER_DATA_COMMON_25 (54482) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '2', '6', '\0', /* SPI_SHADER_USER_DATA_COMMON_26 (54513) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '2', '7', '\0', /* SPI_SHADER_USER_DATA_COMMON_27 (54544) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '2', '8', '\0', /* SPI_SHADER_USER_DATA_COMMON_28 (54575) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '2', '9', '\0', /* SPI_SHADER_USER_DATA_COMMON_29 (54606) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '3', '0', '\0', /* SPI_SHADER_USER_DATA_COMMON_30 (54637) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '3', '1', '\0', /* SPI_SHADER_USER_DATA_COMMON_31 (54668) */
	'D', 'B', '_', 'Z', '_', 'I', 'N', 'F', 'O', '2', '\0', /* DB_Z_INFO2 (54699) */
	'D', 'B', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'I', 'N', 'F', 'O', '2', '\0', /* DB_STENCIL_INFO2 (54710) */
	'C', 'B', '_', 'M', 'R', 'T', '0', '_', 'E', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_MRT0_EPITCH (54727, 54735) */
	'C', 'B', '_', 'M', 'R', 'T', '1', '_', 'E', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_MRT1_EPITCH (54742) */
	'C', 'B', '_', 'M', 'R', 'T', '2', '_', 'E', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_MRT2_EPITCH (54757) */
	'C', 'B', '_', 'M', 'R', 'T', '3', '_', 'E', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_MRT3_EPITCH (54772) */
	'C', 'B', '_', 'M', 'R', 'T', '4', '_', 'E', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_MRT4_EPITCH (54787) */
	'C', 'B', '_', 'M', 'R', 'T', '5', '_', 'E', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_MRT5_EPITCH (54802) */
	'C', 'B', '_', 'M', 'R', 'T', '6', '_', 'E', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_MRT6_EPITCH (54817) */
	'C', 'B', '_', 'M', 'R', 'T', '7', '_', 'E', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_MRT7_EPITCH (54832) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'M', 'A', 'X', '_', 'P', 'R', 'I', 'M', 'S', '_', 'P', 'E', 'R', '_', 'S', 'U', 'B', 'G', 'R', 'O', 'U', 'P', '\0', /* VGT_GS_MAX_PRIMS_PER_SUBGROUP (54847, 54854) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'D', 'A', 'T', 'A', '_', 'L', 'O', '\0', /* CP_APPEND_DATA_LO (54877) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'L', 'A', 'S', 'T', '_', 'C', 'S', '_', 'F', 'E', 'N', 'C', 'E', '_', 'L', 'O', '\0', /* CP_APPEND_LAST_CS_FENCE_LO (54895) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'L', 'A', 'S', 'T', '_', 'P', 'S', '_', 'F', 'E', 'N', 'C', 'E', '_', 'L', 'O', '\0', /* CP_APPEND_LAST_PS_FENCE_LO (54922) */
	'V', 'G', 'T', '_', 'T', 'F', '_', 'M', 'E', 'M', 'O', 'R', 'Y', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* VGT_TF_MEMORY_BASE_HI (54949) */
	'S', 'P', 'I', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'C', 'N', 'T', 'L', '_', '1', '\0', /* SPI_CONFIG_CNTL_1 (54971) */
	'S', 'P', 'I', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'C', 'N', 'T', 'L', '_', '2', '\0', /* SPI_CONFIG_CNTL_2 (54989) */
	'S', 'P', 'I', '_', 'W', 'A', 'V', 'E', '_', 'L', 'I', 'M', 'I', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* SPI_WAVE_LIMIT_CNTL (55007) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_RMI_PERFMON_SAMPLE_DELAY (55027) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '_', 'M', 'A', 'X', '\0', /* RLC_SPM_PERFMON_SAMPLE_DELAY_MAX (55060, 55087) */
	'F', 'P', '_', 'R', 'O', 'U', 'N', 'D', '\0', /* FP_ROUND (55093) */
	'F', 'P', '_', 'D', 'E', 'N', 'O', 'R', 'M', '\0', /* FP_DENORM (55102) */
	'D', 'X', '1', '0', '_', 'C', 'L', 'A', 'M', 'P', '\0', /* DX10_CLAMP (55112) */
	'I', 'E', 'E', 'E', '\0', /* IEEE (55123) */
	'L', 'O', 'D', '_', 'C', 'L', 'A', 'M', 'P', 'E', 'D', '\0', /* LOD_CLAMPED (55128) */
	'I', 'N', 'V', 'A', 'L', 'I', 'D', '\0', /* INVALID (55140, 55142) */
	'I', 'N', 'P', 'U', 'T', '_', 'D', 'E', 'N', 'O', 'R', 'M', 'A', 'L', '\0', /* INPUT_DENORMAL (55148) */
	'D', 'I', 'V', 'I', 'D', 'E', '_', 'B', 'Y', '_', 'Z', 'E', 'R', 'O', '\0', /* DIVIDE_BY_ZERO (55163) */
	'O', 'V', 'E', 'R', 'F', 'L', 'O', 'W', '\0', /* OVERFLOW (55178) */
	'U', 'N', 'D', 'E', 'R', 'F', 'L', 'O', 'W', '\0', /* UNDERFLOW (55187) */
	'I', 'N', 'E', 'X', 'A', 'C', 'T', '\0', /* INEXACT (55197, 55199) */
	'I', 'N', 'T', '_', 'D', 'I', 'V', 'I', 'D', 'E', '_', 'B', 'Y', '_', 'Z', 'E', 'R', 'O', '\0', /* INT_DIVIDE_BY_ZERO (55205) */
	'A', 'D', 'D', 'R', 'E', 'S', 'S', '_', 'W', 'A', 'T', 'C', 'H', '\0', /* ADDRESS_WATCH (55224) */
	'M', 'E', 'M', 'O', 'R', 'Y', '_', 'V', 'I', 'O', 'L', 'A', 'T', 'I', 'O', 'N', '\0', /* MEMORY_VIOLATION (55238) */
	'E', 'X', 'C', 'P', '_', 'E', 'N', '\0', /* EXCP_EN (55255) */
	'F', 'P', '1', '6', '_', 'O', 'V', 'F', 'L', '\0', /* FP16_OVFL (55263) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'P', 'E', 'R', 'F', '\0', /* DISABLE_PERF (55273) */
	'V', 'S', 'K', 'I', 'P', '\0', /* VSKIP (55286) */
	'C', 'S', 'P', '\0', /* CSP (55292) */
	'S', 'C', 'C', '\0', /* SCC (55296) */
	'S', 'P', 'I', '_', 'P', 'R', 'I', 'O', '\0', /* SPI_PRIO (55300) */
	'U', 'S', 'E', 'R', '_', 'P', 'R', 'I', 'O', '\0', /* USER_PRIO (55309) */
	'P', 'R', 'I', 'V', '\0', /* PRIV (55319) */
	'T', 'R', 'A', 'P', '_', 'E', 'N', '\0', /* TRAP_EN (55324) */
	'T', 'T', 'R', 'A', 'C', 'E', '_', 'E', 'N', '\0', /* TTRACE_EN (55332) */
	'E', 'X', 'P', 'O', 'R', 'T', '_', 'R', 'D', 'Y', '\0', /* EXPORT_RDY (55342) */
	'E', 'X', 'E', 'C', 'Z', '\0', /* EXECZ (55353) */
	'V', 'C', 'C', 'Z', '\0', /* VCCZ (55359) */
	'I', 'N', '_', 'T', 'G', '\0', /* IN_TG (55364) */
	'I', 'N', '_', 'B', 'A', 'R', 'R', 'I', 'E', 'R', '\0', /* IN_BARRIER (55370) */
	'H', 'A', 'L', 'T', '\0', /* HALT (55381) */
	'T', 'R', 'A', 'P', '\0', /* TRAP (55386) */
	'T', 'T', 'R', 'A', 'C', 'E', '_', 'S', 'I', 'M', 'D', '_', 'E', 'N', '\0', /* TTRACE_SIMD_EN (55391, 55398) */
	'E', 'C', 'C', '_', 'E', 'R', 'R', '\0', /* ECC_ERR (55406) */
	'S', 'K', 'I', 'P', '_', 'E', 'X', 'P', 'O', 'R', 'T', '\0', /* SKIP_EXPORT (55414) */
	'P', 'E', 'R', 'F', '_', 'E', 'N', '\0', /* PERF_EN (55426) */
	'F', 'A', 'T', 'A', 'L', '_', 'H', 'A', 'L', 'T', '\0', /* FATAL_HALT (55434) */
	'M', 'U', 'S', 'T', '_', 'E', 'X', 'P', 'O', 'R', 'T', '\0', /* MUST_EXPORT (55445) */
	'E', 'X', 'C', 'P', '\0', /* EXCP (55457) */
	'S', 'A', 'V', 'E', 'C', 'T', 'X', '\0', /* SAVECTX (55462) */
	'I', 'L', 'L', 'E', 'G', 'A', 'L', '_', 'I', 'N', 'S', 'T', '\0', /* ILLEGAL_INST (55470) */
	'E', 'X', 'C', 'P', '_', 'H', 'I', '\0', /* EXCP_HI (55483) */
	'B', 'U', 'F', 'F', 'E', 'R', '_', 'O', 'O', 'B', '\0', /* BUFFER_OOB (55491) */
	'E', 'X', 'C', 'P', '_', 'C', 'Y', 'C', 'L', 'E', '\0', /* EXCP_CYCLE (55502) */
	'E', 'X', 'C', 'P', '_', 'G', 'R', 'O', 'U', 'P', '_', 'M', 'A', 'S', 'K', '\0', /* EXCP_GROUP_MASK (55513) */
	'E', 'X', 'C', 'P', '_', 'W', 'A', 'V', 'E', '6', '4', 'H', 'I', '\0', /* EXCP_WAVE64HI (55529, 55534) */
	'X', 'N', 'A', 'C', 'K', '_', 'E', 'R', 'R', 'O', 'R', '\0', /* XNACK_ERROR (55543) */
	'D', 'P', '_', 'R', 'A', 'T', 'E', '\0', /* DP_RATE (55555) */
	'S', 'I', 'M', 'D', '_', 'I', 'D', '\0', /* SIMD_ID (55563) */
	'P', 'I', 'P', 'E', '_', 'I', 'D', '\0', /* PIPE_ID (55571) */
	'C', 'U', '_', 'I', 'D', '\0', /* CU_ID (55579) */
	'S', 'H', '_', 'I', 'D', '\0', /* SH_ID (55585) */
	'W', 'A', 'V', 'E', '_', 'I', 'D', '_', 'M', 'S', 'B', '\0', /* WAVE_ID_MSB (55591) */
	'T', 'G', '_', 'I', 'D', '\0', /* TG_ID (55603) */
	'V', 'M', '_', 'I', 'D', '\0', /* VM_ID (55609) */
	'Q', 'U', 'E', 'U', 'E', '_', 'I', 'D', '\0', /* QUEUE_ID (55615) */
	'S', 'T', 'A', 'T', 'E', '_', 'I', 'D', '\0', /* STATE_ID (55624) */
	'M', 'E', '_', 'I', 'D', '\0', /* ME_ID (55633) */
	'V', 'G', 'P', 'R', '_', 'B', 'A', 'S', 'E', '\0', /* VGPR_BASE (55639) */
	'V', 'G', 'P', 'R', '_', 'S', 'I', 'Z', 'E', '\0', /* VGPR_SIZE (55649) */
	'S', 'G', 'P', 'R', '_', 'B', 'A', 'S', 'E', '\0', /* SGPR_BASE (55659) */
	'S', 'G', 'P', 'R', '_', 'S', 'I', 'Z', 'E', '\0', /* SGPR_SIZE (55669) */
	'L', 'D', 'S', '_', 'B', 'A', 'S', 'E', '\0', /* LDS_BASE (55679) */
	'L', 'D', 'S', '_', 'S', 'I', 'Z', 'E', '\0', /* LDS_SIZE (55688) */
	'V', 'G', 'P', 'R', '_', 'S', 'H', 'A', 'R', 'E', 'D', '_', 'S', 'I', 'Z', 'E', '\0', /* VGPR_SHARED_SIZE (55697) */
	'V', 'M', '_', 'C', 'N', 'T', '\0', /* VM_CNT (55714) */
	'E', 'X', 'P', '_', 'C', 'N', 'T', '\0', /* EXP_CNT (55721) */
	'L', 'G', 'K', 'M', '_', 'C', 'N', 'T', '_', 'B', 'I', 'T', '4', '\0', /* LGKM_CNT_BIT4 (55729) */
	'L', 'G', 'K', 'M', '_', 'C', 'N', 'T', '\0', /* LGKM_CNT (55743) */
	'V', 'A', 'L', 'U', '_', 'C', 'N', 'T', '\0', /* VALU_CNT (55752) */
	'F', 'I', 'R', 'S', 'T', '_', 'R', 'E', 'P', 'L', 'A', 'Y', '\0', /* FIRST_REPLAY (55761) */
	'R', 'C', 'N', 'T', '\0', /* RCNT (55774) */
	'V', 'M', '_', 'C', 'N', 'T', '_', 'H', 'I', '\0', /* VM_CNT_HI (55779) */
	'L', 'G', 'K', 'M', '_', 'C', 'N', 'T', '_', 'B', 'I', 'T', '5', '\0', /* LGKM_CNT_BIT5 (55789) */
	'R', 'E', 'P', 'L', 'A', 'Y', '_', 'W', '6', '4', 'H', '\0', /* REPLAY_W64H (55803) */
	'V', 'S', '_', 'C', 'N', 'T', '\0', /* VS_CNT (55815) */
	'X', 'N', 'A', 'C', 'K', '\0', /* XNACK (55822) */
	'T', 'A', '_', 'N', 'E', 'E', 'D', '_', 'R', 'E', 'S', 'E', 'T', '\0', /* TA_NEED_RESET (55828) */
	'X', 'N', 'A', 'C', 'K', '_', 'O', 'V', 'E', 'R', 'R', 'I', 'D', 'E', '\0', /* XNACK_OVERRIDE (55842) */
	'X', 'C', 'N', 'T', '\0', /* XCNT (55857) */
	'Q', 'C', 'N', 'T', '\0', /* QCNT (55862) */
	'W', 'A', 'V', 'E', '_', 'I', 'D', 'L', 'E', '\0', /* WAVE_IDLE (55867) */
	'M', 'I', 'S', 'C', '_', 'C', 'N', 'T', '\0', /* MISC_CNT (55877) */
	'W', 'G', 'P', '_', 'I', 'D', '\0', /* WGP_ID (55886) */
	'S', 'A', '_', 'I', 'D', '\0', /* SA_ID (55893) */
	'W', 'G', '_', 'I', 'D', '\0', /* WG_ID (55899) */
	'C', 'O', 'M', 'P', 'A', 'T', '_', 'L', 'E', 'V', 'E', 'L', '\0', /* COMPAT_LEVEL (55905) */
	'P', 'O', 'P', 'S', '_', 'E', 'N', '\0', /* POPS_EN (55918, 55920) */
	'P', 'O', 'P', 'S', '_', 'P', 'A', 'C', 'K', 'E', 'R', '_', 'I', 'D', '\0', /* POPS_PACKER_ID (55926) */
	'D', 'E', 'P', '_', 'M', 'O', 'D', 'E', '\0', /* DEP_MODE (55941) */
	'I', 'N', 'S', 'T', '_', 'P', 'R', 'E', 'F', 'E', 'T', 'C', 'H', '\0', /* INST_PREFETCH (55950) */
	'R', 'E', 'S', 'O', 'U', 'R', 'C', 'E', '_', 'O', 'V', 'E', 'R', 'R', 'I', 'D', 'E', '\0', /* RESOURCE_OVERRIDE (55964) */
	'M', 'E', 'M', '_', 'O', 'R', 'D', 'E', 'R', '\0', /* MEM_ORDER (55982) */
	'F', 'W', 'D', '_', 'P', 'R', 'O', 'G', 'R', 'E', 'S', 'S', '\0', /* FWD_PROGRESS (55992) */
	'W', 'A', 'V', 'E', '6', '4', '\0', /* WAVE64 (56005) */
	'S', 'U', 'B', 'V', '_', 'L', 'O', 'O', 'P', '\0', /* SUBV_LOOP (56012) */
	'M', 'E', '0', 'P', 'I', 'P', 'E', '1', '_', 'C', 'M', 'D', 'F', 'I', 'F', 'O', '_', 'A', 'V', 'A', 'I', 'L', '\0', /* ME0PIPE1_CMDFIFO_AVAIL (56022) */
	'M', 'E', '0', 'P', 'I', 'P', 'E', '1', '_', 'C', 'F', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* ME0PIPE1_CF_RQ_PENDING (56045) */
	'M', 'E', '0', 'P', 'I', 'P', 'E', '1', '_', 'P', 'F', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* ME0PIPE1_PF_RQ_PENDING (56068) */
	'M', 'E', '1', 'P', 'I', 'P', 'E', '0', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* ME1PIPE0_RQ_PENDING (56091) */
	'M', 'E', '1', 'P', 'I', 'P', 'E', '1', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* ME1PIPE1_RQ_PENDING (56111) */
	'M', 'E', '1', 'P', 'I', 'P', 'E', '2', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* ME1PIPE2_RQ_PENDING (56131) */
	'M', 'E', '1', 'P', 'I', 'P', 'E', '3', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* ME1PIPE3_RQ_PENDING (56151) */
	'M', 'E', '2', 'P', 'I', 'P', 'E', '0', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* ME2PIPE0_RQ_PENDING (56171) */
	'M', 'E', '2', 'P', 'I', 'P', 'E', '1', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* ME2PIPE1_RQ_PENDING (56191) */
	'M', 'E', '2', 'P', 'I', 'P', 'E', '2', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* ME2PIPE2_RQ_PENDING (56211) */
	'M', 'E', '2', 'P', 'I', 'P', 'E', '3', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* ME2PIPE3_RQ_PENDING (56231) */
	'R', 'L', 'C', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* RLC_RQ_PENDING (56251) */
	'U', 'T', 'C', 'L', '2', '_', 'B', 'U', 'S', 'Y', '\0', /* UTCL2_BUSY (56266, 56272) */
	'E', 'A', '_', 'B', 'U', 'S', 'Y', '\0', /* EA_BUSY (56277) */
	'R', 'M', 'I', '_', 'B', 'U', 'S', 'Y', '\0', /* RMI_BUSY (56285) */
	'U', 'T', 'C', 'L', '2', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* UTCL2_RQ_PENDING (56294) */
	'C', 'P', 'F', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* CPF_RQ_PENDING (56311) */
	'E', 'A', '_', 'L', 'I', 'N', 'K', '_', 'B', 'U', 'S', 'Y', '\0', /* EA_LINK_BUSY (56326) */
	'S', 'D', 'M', 'A', '_', 'B', 'U', 'S', 'Y', '\0', /* SDMA_BUSY (56339, 56340) */
	'S', 'D', 'M', 'A', '0', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* SDMA0_RQ_PENDING (56349) */
	'S', 'D', 'M', 'A', '1', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* SDMA1_RQ_PENDING (56366) */
	'R', 'L', 'C', '_', 'B', 'U', 'S', 'Y', '\0', /* RLC_BUSY (56383) */
	'T', 'C', 'P', '_', 'B', 'U', 'S', 'Y', '\0', /* TCP_BUSY (56392, 56393) */
	'C', 'P', 'F', '_', 'B', 'U', 'S', 'Y', '\0', /* CPF_BUSY (56401) */
	'C', 'P', 'C', '_', 'B', 'U', 'S', 'Y', '\0', /* CPC_BUSY (56410) */
	'C', 'P', 'G', '_', 'B', 'U', 'S', 'Y', '\0', /* CPG_BUSY (56419) */
	'C', 'P', 'A', 'X', 'I', '_', 'B', 'U', 'S', 'Y', '\0', /* CPAXI_BUSY (56428) */
	'M', 'E', '0', 'P', 'I', 'P', 'E', '0', '_', 'C', 'M', 'D', 'F', 'I', 'F', 'O', '_', 'A', 'V', 'A', 'I', 'L', '\0', /* ME0PIPE0_CMDFIFO_AVAIL (56439) */
	'R', 'S', 'M', 'U', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* RSMU_RQ_PENDING (56462, 56463) */
	'M', 'E', '0', 'P', 'I', 'P', 'E', '0', '_', 'C', 'F', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* ME0PIPE0_CF_RQ_PENDING (56478) */
	'M', 'E', '0', 'P', 'I', 'P', 'E', '0', '_', 'P', 'F', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* ME0PIPE0_PF_RQ_PENDING (56501) */
	'G', 'D', 'S', '_', 'D', 'M', 'A', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* GDS_DMA_RQ_PENDING (56524) */
	'D', 'B', '_', 'C', 'L', 'E', 'A', 'N', '\0', /* DB_CLEAN (56543) */
	'C', 'B', '_', 'C', 'L', 'E', 'A', 'N', '\0', /* CB_CLEAN (56552) */
	'T', 'A', '_', 'B', 'U', 'S', 'Y', '\0', /* TA_BUSY (56561) */
	'G', 'D', 'S', '_', 'B', 'U', 'S', 'Y', '\0', /* GDS_BUSY (56569) */
	'G', 'E', '_', 'B', 'U', 'S', 'Y', '_', 'N', 'O', '_', 'D', 'M', 'A', '\0', /* GE_BUSY_NO_DMA (56578) */
	'S', 'X', '_', 'B', 'U', 'S', 'Y', '\0', /* SX_BUSY (56593) */
	'G', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* GE_BUSY (56601) */
	'S', 'P', 'I', '_', 'B', 'U', 'S', 'Y', '\0', /* SPI_BUSY (56609) */
	'B', 'C', 'I', '_', 'B', 'U', 'S', 'Y', '\0', /* BCI_BUSY (56618) */
	'S', 'C', '_', 'B', 'U', 'S', 'Y', '\0', /* SC_BUSY (56627) */
	'P', 'A', '_', 'B', 'U', 'S', 'Y', '\0', /* PA_BUSY (56635) */
	'D', 'B', '_', 'B', 'U', 'S', 'Y', '\0', /* DB_BUSY (56643) */
	'C', 'P', '_', 'C', 'O', 'H', 'E', 'R', 'E', 'N', 'C', 'Y', '_', 'B', 'U', 'S', 'Y', '\0', /* CP_COHERENCY_BUSY (56651) */
	'C', 'B', '_', 'B', 'U', 'S', 'Y', '\0', /* CB_BUSY (56669) */
	'G', 'U', 'I', '_', 'A', 'C', 'T', 'I', 'V', 'E', '\0', /* GUI_ACTIVE (56677) */
	'U', 'T', 'C', 'L', '1', '_', 'B', 'U', 'S', 'Y', '\0', /* UTCL1_BUSY (56688) */
	'G', 'L', '1', 'C', 'C', '_', 'B', 'U', 'S', 'Y', '\0', /* GL1CC_BUSY (56699) */
	'G', 'R', 'B', 'M', '_', 'R', 'L', 'C', '_', 'I', 'N', 'T', 'R', '_', 'C', 'R', 'E', 'D', 'I', 'T', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* GRBM_RLC_INTR_CREDIT_PENDING (56710) */
	'G', 'R', 'B', 'M', '_', 'U', 'T', 'C', 'L', '2', '_', 'I', 'N', 'T', 'R', '_', 'C', 'R', 'E', 'D', 'I', 'T', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* GRBM_UTCL2_INTR_CREDIT_PENDING (56739) */
	'G', 'R', 'B', 'M', '_', 'C', 'P', 'F', '_', 'I', 'N', 'T', 'R', '_', 'C', 'R', 'E', 'D', 'I', 'T', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* GRBM_CPF_INTR_CREDIT_PENDING (56770) */
	'M', 'E', 'S', 'P', 'I', 'P', 'E', '0', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* MESPIPE0_RQ_PENDING (56799) */
	'M', 'E', 'S', 'P', 'I', 'P', 'E', '1', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* MESPIPE1_RQ_PENDING (56819) */
	'M', 'E', 'S', 'P', 'I', 'P', 'E', '2', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* MESPIPE2_RQ_PENDING (56839) */
	'M', 'E', 'S', 'P', 'I', 'P', 'E', '3', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* MESPIPE3_RQ_PENDING (56859) */
	'P', 'H', '_', 'B', 'U', 'S', 'Y', '\0', /* PH_BUSY (56879) */
	'C', 'H', '_', 'B', 'U', 'S', 'Y', '\0', /* CH_BUSY (56887) */
	'G', 'L', '2', 'C', 'C', '_', 'B', 'U', 'S', 'Y', '\0', /* GL2CC_BUSY (56895) */
	'G', 'U', 'S', '_', 'L', 'I', 'N', 'K', '_', 'B', 'U', 'S', 'Y', '\0', /* GUS_LINK_BUSY (56906) */
	'G', 'U', 'S', '_', 'B', 'U', 'S', 'Y', '\0', /* GUS_BUSY (56920) */
	'P', 'M', 'M', '_', 'B', 'U', 'S', 'Y', '\0', /* PMM_BUSY (56929) */
	'M', 'E', 'C', '1', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_BUSY (56938) */
	'M', 'E', 'C', '2', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_BUSY (56948) */
	'D', 'C', '0', '_', 'B', 'U', 'S', 'Y', '\0', /* DC0_BUSY (56958) */
	'D', 'C', '1', '_', 'B', 'U', 'S', 'Y', '\0', /* DC1_BUSY (56967) */
	'R', 'C', 'I', 'U', '1', '_', 'B', 'U', 'S', 'Y', '\0', /* RCIU1_BUSY (56976) */
	'R', 'C', 'I', 'U', '2', '_', 'B', 'U', 'S', 'Y', '\0', /* RCIU2_BUSY (56987) */
	'R', 'O', 'Q', '1', '_', 'B', 'U', 'S', 'Y', '\0', /* ROQ1_BUSY (56998) */
	'R', 'O', 'Q', '2', '_', 'B', 'U', 'S', 'Y', '\0', /* ROQ2_BUSY (57008) */
	'T', 'C', 'I', 'U', '_', 'B', 'U', 'S', 'Y', '\0', /* TCIU_BUSY (57018) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'A', 'M', '_', 'B', 'U', 'S', 'Y', '\0', /* SCRATCH_RAM_BUSY (57028) */
	'Q', 'U', '_', 'B', 'U', 'S', 'Y', '\0', /* QU_BUSY (57045) */
	'U', 'T', 'C', 'L', '2', 'I', 'U', '_', 'B', 'U', 'S', 'Y', '\0', /* UTCL2IU_BUSY (57053) */
	'S', 'A', 'V', 'E', '_', 'R', 'E', 'S', 'T', 'O', 'R', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* SAVE_RESTORE_BUSY (57066) */
	'G', 'C', 'R', 'I', 'U', '_', 'B', 'U', 'S', 'Y', '\0', /* GCRIU_BUSY (57084) */
	'M', 'E', 'S', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_BUSY (57095) */
	'M', 'E', 'S', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'A', 'M', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_SCRATCH_RAM_BUSY (57104) */
	'R', 'C', 'I', 'U', '3', '_', 'B', 'U', 'S', 'Y', '\0', /* RCIU3_BUSY (57125) */
	'M', 'E', 'S', '_', 'I', 'N', 'S', 'T', 'R', 'U', 'C', 'T', 'I', 'O', 'N', '_', 'C', 'A', 'C', 'H', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_INSTRUCTION_CACHE_BUSY (57136) */
	'C', 'P', 'G', '_', 'C', 'P', 'C', '_', 'B', 'U', 'S', 'Y', '\0', /* CPG_CPC_BUSY (57163) */
	'C', 'P', 'F', '_', 'C', 'P', 'C', '_', 'B', 'U', 'S', 'Y', '\0', /* CPF_CPC_BUSY (57176) */
	'M', 'E', 'C', '1', '_', 'L', 'O', 'A', 'D', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_LOAD_BUSY (57189) */
	'M', 'E', 'C', '1', '_', 'S', 'E', 'M', 'A', 'P', 'O', 'H', 'R', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_SEMAPOHRE_BUSY (57204) */
	'M', 'E', 'C', '1', '_', 'M', 'U', 'T', 'E', 'X', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_MUTEX_BUSY (57224) */
	'M', 'E', 'C', '1', '_', 'M', 'E', 'S', 'S', 'A', 'G', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_MESSAGE_BUSY (57240) */
	'M', 'E', 'C', '1', '_', 'E', 'O', 'P', '_', 'Q', 'U', 'E', 'U', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_EOP_QUEUE_BUSY (57258) */
	'M', 'E', 'C', '1', '_', 'I', 'Q', '_', 'Q', 'U', 'E', 'U', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_IQ_QUEUE_BUSY (57278) */
	'M', 'E', 'C', '1', '_', 'I', 'B', '_', 'Q', 'U', 'E', 'U', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_IB_QUEUE_BUSY (57297) */
	'M', 'E', 'C', '1', '_', 'T', 'C', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_TC_BUSY (57316, 57321) */
	'M', 'E', 'C', '1', '_', 'D', 'M', 'A', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_DMA_BUSY (57329) */
	'M', 'E', 'C', '1', '_', 'P', 'A', 'R', 'T', 'I', 'A', 'L', '_', 'F', 'L', 'U', 'S', 'H', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_PARTIAL_FLUSH_BUSY (57343) */
	'M', 'E', 'C', '1', '_', 'P', 'I', 'P', 'E', '0', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_PIPE0_BUSY (57367) */
	'M', 'E', 'C', '1', '_', 'P', 'I', 'P', 'E', '1', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_PIPE1_BUSY (57383) */
	'M', 'E', 'C', '1', '_', 'P', 'I', 'P', 'E', '2', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_PIPE2_BUSY (57399) */
	'M', 'E', 'C', '1', '_', 'P', 'I', 'P', 'E', '3', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_PIPE3_BUSY (57415) */
	'M', 'E', 'C', '2', '_', 'L', 'O', 'A', 'D', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_LOAD_BUSY (57431) */
	'M', 'E', 'C', '2', '_', 'S', 'E', 'M', 'A', 'P', 'O', 'H', 'R', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_SEMAPOHRE_BUSY (57446) */
	'M', 'E', 'C', '2', '_', 'M', 'U', 'T', 'E', 'X', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_MUTEX_BUSY (57466) */
	'M', 'E', 'C', '2', '_', 'M', 'E', 'S', 'S', 'A', 'G', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_MESSAGE_BUSY (57482) */
	'M', 'E', 'C', '2', '_', 'E', 'O', 'P', '_', 'Q', 'U', 'E', 'U', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_EOP_QUEUE_BUSY (57500) */
	'M', 'E', 'C', '2', '_', 'I', 'Q', '_', 'Q', 'U', 'E', 'U', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_IQ_QUEUE_BUSY (57520) */
	'M', 'E', 'C', '2', '_', 'I', 'B', '_', 'Q', 'U', 'E', 'U', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_IB_QUEUE_BUSY (57539) */
	'M', 'E', 'C', '2', '_', 'T', 'C', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_TC_BUSY (57558) */
	'M', 'E', 'C', '2', '_', 'D', 'M', 'A', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_DMA_BUSY (57571) */
	'M', 'E', 'C', '2', '_', 'P', 'A', 'R', 'T', 'I', 'A', 'L', '_', 'F', 'L', 'U', 'S', 'H', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_PARTIAL_FLUSH_BUSY (57585) */
	'M', 'E', 'C', '2', '_', 'P', 'I', 'P', 'E', '0', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_PIPE0_BUSY (57609) */
	'M', 'E', 'C', '2', '_', 'P', 'I', 'P', 'E', '1', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_PIPE1_BUSY (57625) */
	'M', 'E', 'C', '2', '_', 'P', 'I', 'P', 'E', '2', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_PIPE2_BUSY (57641) */
	'M', 'E', 'C', '2', '_', 'P', 'I', 'P', 'E', '3', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_PIPE3_BUSY (57657) */
	'R', 'C', 'I', 'U', '_', 'T', 'X', '_', 'F', 'R', 'E', 'E', '_', 'S', 'T', 'A', 'L', 'L', '\0', /* RCIU_TX_FREE_STALL (57673) */
	'R', 'C', 'I', 'U', '_', 'P', 'R', 'I', 'V', '_', 'V', 'I', 'O', 'L', 'A', 'T', 'I', 'O', 'N', '\0', /* RCIU_PRIV_VIOLATION (57692) */
	'T', 'C', 'I', 'U', '_', 'T', 'X', '_', 'F', 'R', 'E', 'E', '_', 'S', 'T', 'A', 'L', 'L', '\0', /* TCIU_TX_FREE_STALL (57712) */
	'M', 'E', 'C', '1', '_', 'D', 'E', 'C', 'O', 'D', 'I', 'N', 'G', '_', 'P', 'A', 'C', 'K', 'E', 'T', '\0', /* MEC1_DECODING_PACKET (57731) */
	'M', 'E', 'C', '1', '_', 'W', 'A', 'I', 'T', '_', 'O', 'N', '_', 'R', 'C', 'I', 'U', '\0', /* MEC1_WAIT_ON_RCIU (57752) */
	'M', 'E', 'C', '1', '_', 'W', 'A', 'I', 'T', '_', 'O', 'N', '_', 'R', 'C', 'I', 'U', '_', 'R', 'E', 'A', 'D', '\0', /* MEC1_WAIT_ON_RCIU_READ (57770) */
	'M', 'E', 'C', '1', '_', 'W', 'A', 'I', 'T', '_', 'O', 'N', '_', 'R', 'O', 'Q', '_', 'D', 'A', 'T', 'A', '\0', /* MEC1_WAIT_ON_ROQ_DATA (57793) */
	'M', 'E', 'C', '2', '_', 'D', 'E', 'C', 'O', 'D', 'I', 'N', 'G', '_', 'P', 'A', 'C', 'K', 'E', 'T', '\0', /* MEC2_DECODING_PACKET (57815) */
	'M', 'E', 'C', '2', '_', 'W', 'A', 'I', 'T', '_', 'O', 'N', '_', 'R', 'C', 'I', 'U', '\0', /* MEC2_WAIT_ON_RCIU (57836) */
	'M', 'E', 'C', '2', '_', 'W', 'A', 'I', 'T', '_', 'O', 'N', '_', 'R', 'C', 'I', 'U', '_', 'R', 'E', 'A', 'D', '\0', /* MEC2_WAIT_ON_RCIU_READ (57854) */
	'M', 'E', 'C', '2', '_', 'W', 'A', 'I', 'T', '_', 'O', 'N', '_', 'R', 'O', 'Q', '_', 'D', 'A', 'T', 'A', '\0', /* MEC2_WAIT_ON_ROQ_DATA (57877) */
	'U', 'T', 'C', 'L', '2', 'I', 'U', '_', 'W', 'A', 'I', 'T', 'I', 'N', 'G', '_', 'O', 'N', '_', 'F', 'R', 'E', 'E', '\0', /* UTCL2IU_WAITING_ON_FREE (57899) */
	'U', 'T', 'C', 'L', '2', 'I', 'U', '_', 'W', 'A', 'I', 'T', 'I', 'N', 'G', '_', 'O', 'N', '_', 'T', 'A', 'G', 'S', '\0', /* UTCL2IU_WAITING_ON_TAGS (57923) */
	'U', 'T', 'C', 'L', '1', '_', 'W', 'A', 'I', 'T', 'I', 'N', 'G', '_', 'O', 'N', '_', 'T', 'R', 'A', 'N', 'S', '\0', /* UTCL1_WAITING_ON_TRANS (57947) */
	'G', 'C', 'R', 'I', 'U', '_', 'W', 'A', 'I', 'T', 'I', 'N', 'G', '_', 'O', 'N', '_', 'F', 'R', 'E', 'E', '\0', /* GCRIU_WAITING_ON_FREE (57970) */
	'P', 'O', 'S', 'T', '_', 'W', 'P', 'T', 'R', '_', 'G', 'F', 'X', '_', 'B', 'U', 'S', 'Y', '\0', /* POST_WPTR_GFX_BUSY (57992) */
	'C', 'S', 'F', '_', 'B', 'U', 'S', 'Y', '\0', /* CSF_BUSY (58011) */
	'R', 'O', 'Q', '_', 'A', 'L', 'I', 'G', 'N', '_', 'B', 'U', 'S', 'Y', '\0', /* ROQ_ALIGN_BUSY (58020) */
	'R', 'O', 'Q', '_', 'R', 'I', 'N', 'G', '_', 'B', 'U', 'S', 'Y', '\0', /* ROQ_RING_BUSY (58035) */
	'R', 'O', 'Q', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '1', '_', 'B', 'U', 'S', 'Y', '\0', /* ROQ_INDIRECT1_BUSY (58049) */
	'R', 'O', 'Q', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '2', '_', 'B', 'U', 'S', 'Y', '\0', /* ROQ_INDIRECT2_BUSY (58068) */
	'R', 'O', 'Q', '_', 'S', 'T', 'A', 'T', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* ROQ_STATE_BUSY (58087) */
	'R', 'O', 'Q', '_', 'C', 'E', '_', 'R', 'I', 'N', 'G', '_', 'B', 'U', 'S', 'Y', '\0', /* ROQ_CE_RING_BUSY (58102) */
	'R', 'O', 'Q', '_', 'C', 'E', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '1', '_', 'B', 'U', 'S', 'Y', '\0', /* ROQ_CE_INDIRECT1_BUSY (58119) */
	'R', 'O', 'Q', '_', 'C', 'E', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '2', '_', 'B', 'U', 'S', 'Y', '\0', /* ROQ_CE_INDIRECT2_BUSY (58141) */
	'S', 'E', 'M', 'A', 'P', 'H', 'O', 'R', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* SEMAPHORE_BUSY (58163) */
	'I', 'N', 'T', 'E', 'R', 'R', 'U', 'P', 'T', '_', 'B', 'U', 'S', 'Y', '\0', /* INTERRUPT_BUSY (58178) */
	'H', 'Q', 'D', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_BUSY (58193) */
	'P', 'R', 'T', '_', 'B', 'U', 'S', 'Y', '\0', /* PRT_BUSY (58202) */
	'R', 'C', 'I', 'U', '_', 'B', 'U', 'S', 'Y', '\0', /* RCIU_BUSY (58211) */
	'R', 'C', 'I', 'U', '_', 'G', 'F', 'X', '_', 'B', 'U', 'S', 'Y', '\0', /* RCIU_GFX_BUSY (58221) */
	'R', 'C', 'I', 'U', '_', 'C', 'M', 'P', '_', 'B', 'U', 'S', 'Y', '\0', /* RCIU_CMP_BUSY (58235) */
	'R', 'O', 'Q', '_', 'D', 'A', 'T', 'A', '_', 'B', 'U', 'S', 'Y', '\0', /* ROQ_DATA_BUSY (58249) */
	'R', 'O', 'Q', '_', 'C', 'E', '_', 'D', 'A', 'T', 'A', '_', 'B', 'U', 'S', 'Y', '\0', /* ROQ_CE_DATA_BUSY (58263) */
	'M', 'E', 'S', '_', 'H', 'Q', 'D', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_HQD_BUSY (58280) */
	'C', 'P', 'F', '_', 'G', 'F', 'X', '_', 'B', 'U', 'S', 'Y', '\0', /* CPF_GFX_BUSY (58293) */
	'C', 'P', 'F', '_', 'C', 'M', 'P', '_', 'B', 'U', 'S', 'Y', '\0', /* CPF_CMP_BUSY (58306) */
	'G', 'R', 'B', 'M', '_', 'C', 'P', 'F', '_', 'S', 'T', 'A', 'T', '_', 'B', 'U', 'S', 'Y', '\0', /* GRBM_CPF_STAT_BUSY (58319) */
	'C', 'P', 'C', '_', 'C', 'P', 'F', '_', 'B', 'U', 'S', 'Y', '\0', /* CPC_CPF_BUSY (58338) */
	'R', 'E', 'G', '_', 'B', 'U', 'S', '_', 'F', 'I', 'F', 'O', '_', 'B', 'U', 'S', 'Y', '\0', /* REG_BUS_FIFO_BUSY (58351) */
	'C', 'S', 'F', '_', 'R', 'I', 'N', 'G', '_', 'B', 'U', 'S', 'Y', '\0', /* CSF_RING_BUSY (58369) */
	'C', 'S', 'F', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '1', '_', 'B', 'U', 'S', 'Y', '\0', /* CSF_INDIRECT1_BUSY (58383) */
	'C', 'S', 'F', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '2', '_', 'B', 'U', 'S', 'Y', '\0', /* CSF_INDIRECT2_BUSY (58402) */
	'C', 'S', 'F', '_', 'S', 'T', 'A', 'T', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* CSF_STATE_BUSY (58421) */
	'C', 'S', 'F', '_', 'C', 'E', '_', 'I', 'N', 'D', 'R', '1', '_', 'B', 'U', 'S', 'Y', '\0', /* CSF_CE_INDR1_BUSY (58436) */
	'C', 'S', 'F', '_', 'C', 'E', '_', 'I', 'N', 'D', 'R', '2', '_', 'B', 'U', 'S', 'Y', '\0', /* CSF_CE_INDR2_BUSY (58454) */
	'C', 'S', 'F', '_', 'A', 'R', 'B', 'I', 'T', 'E', 'R', '_', 'B', 'U', 'S', 'Y', '\0', /* CSF_ARBITER_BUSY (58472) */
	'C', 'S', 'F', '_', 'I', 'N', 'P', 'U', 'T', '_', 'B', 'U', 'S', 'Y', '\0', /* CSF_INPUT_BUSY (58489) */
	'C', 'S', 'F', '_', 'D', 'A', 'T', 'A', '_', 'B', 'U', 'S', 'Y', '\0', /* CSF_DATA_BUSY (58504) */
	'C', 'S', 'F', '_', 'C', 'E', '_', 'D', 'A', 'T', 'A', '_', 'B', 'U', 'S', 'Y', '\0', /* CSF_CE_DATA_BUSY (58518) */
	'H', 'P', 'D', '_', 'P', 'R', 'O', 'C', 'E', 'S', 'S', 'I', 'N', 'G', '_', 'E', 'O', 'P', '_', 'B', 'U', 'S', 'Y', '\0', /* HPD_PROCESSING_EOP_BUSY (58535) */
	'H', 'Q', 'D', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_DISPATCH_BUSY (58559) */
	'H', 'Q', 'D', '_', 'I', 'Q', '_', 'T', 'I', 'M', 'E', 'R', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_IQ_TIMER_BUSY (58577) */
	'H', 'Q', 'D', '_', 'D', 'M', 'A', '_', 'O', 'F', 'F', 'L', 'O', 'A', 'D', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_DMA_OFFLOAD_BUSY (58595) */
	'H', 'Q', 'D', '_', 'W', 'A', 'I', 'T', '_', 'S', 'E', 'M', 'A', 'P', 'H', 'O', 'R', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_WAIT_SEMAPHORE_BUSY (58616) */
	'H', 'Q', 'D', '_', 'S', 'I', 'G', 'N', 'A', 'L', '_', 'S', 'E', 'M', 'A', 'P', 'H', 'O', 'R', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_SIGNAL_SEMAPHORE_BUSY (58640) */
	'H', 'Q', 'D', '_', 'M', 'E', 'S', 'S', 'A', 'G', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_MESSAGE_BUSY (58666) */
	'H', 'Q', 'D', '_', 'P', 'Q', '_', 'F', 'E', 'T', 'C', 'H', 'E', 'R', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_PQ_FETCHER_BUSY (58683) */
	'H', 'Q', 'D', '_', 'I', 'B', '_', 'F', 'E', 'T', 'C', 'H', 'E', 'R', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_IB_FETCHER_BUSY (58703) */
	'H', 'Q', 'D', '_', 'I', 'Q', '_', 'F', 'E', 'T', 'C', 'H', 'E', 'R', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_IQ_FETCHER_BUSY (58723) */
	'H', 'Q', 'D', '_', 'E', 'O', 'P', '_', 'F', 'E', 'T', 'C', 'H', 'E', 'R', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_EOP_FETCHER_BUSY (58743) */
	'H', 'Q', 'D', '_', 'C', 'O', 'N', 'S', 'U', 'M', 'E', 'D', '_', 'R', 'P', 'T', 'R', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_CONSUMED_RPTR_BUSY (58764) */
	'H', 'Q', 'D', '_', 'F', 'E', 'T', 'C', 'H', 'E', 'R', '_', 'A', 'R', 'B', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_FETCHER_ARB_BUSY (58787) */
	'H', 'Q', 'D', '_', 'R', 'O', 'Q', '_', 'A', 'L', 'I', 'G', 'N', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_ROQ_ALIGN_BUSY (58808) */
	'H', 'Q', 'D', '_', 'R', 'O', 'Q', '_', 'E', 'O', 'P', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_ROQ_EOP_BUSY (58827) */
	'H', 'Q', 'D', '_', 'R', 'O', 'Q', '_', 'I', 'Q', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_ROQ_IQ_BUSY (58844) */
	'H', 'Q', 'D', '_', 'R', 'O', 'Q', '_', 'P', 'Q', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_ROQ_PQ_BUSY (58860) */
	'H', 'Q', 'D', '_', 'R', 'O', 'Q', '_', 'I', 'B', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_ROQ_IB_BUSY (58876) */
	'H', 'Q', 'D', '_', 'W', 'P', 'T', 'R', '_', 'P', 'O', 'L', 'L', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_WPTR_POLL_BUSY (58892) */
	'H', 'Q', 'D', '_', 'P', 'Q', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_PQ_BUSY (58911) */
	'H', 'Q', 'D', '_', 'I', 'B', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_IB_BUSY (58923) */
	'R', 'I', 'N', 'G', '_', 'F', 'E', 'T', 'C', 'H', 'I', 'N', 'G', '_', 'D', 'A', 'T', 'A', '\0', /* RING_FETCHING_DATA (58935) */
	'I', 'N', 'D', 'R', '1', '_', 'F', 'E', 'T', 'C', 'H', 'I', 'N', 'G', '_', 'D', 'A', 'T', 'A', '\0', /* INDR1_FETCHING_DATA (58954) */
	'I', 'N', 'D', 'R', '2', '_', 'F', 'E', 'T', 'C', 'H', 'I', 'N', 'G', '_', 'D', 'A', 'T', 'A', '\0', /* INDR2_FETCHING_DATA (58974) */
	'S', 'T', 'A', 'T', 'E', '_', 'F', 'E', 'T', 'C', 'H', 'I', 'N', 'G', '_', 'D', 'A', 'T', 'A', '\0', /* STATE_FETCHING_DATA (58994) */
	'T', 'C', 'I', 'U', '_', 'W', 'A', 'I', 'T', 'I', 'N', 'G', '_', 'O', 'N', '_', 'F', 'R', 'E', 'E', '\0', /* TCIU_WAITING_ON_FREE (59014) */
	'T', 'C', 'I', 'U', '_', 'W', 'A', 'I', 'T', 'I', 'N', 'G', '_', 'O', 'N', '_', 'T', 'A', 'G', 'S', '\0', /* TCIU_WAITING_ON_TAGS (59035) */
	'G', 'F', 'X', '_', 'U', 'T', 'C', 'L', '1', '_', 'W', 'A', 'I', 'T', 'I', 'N', 'G', '_', 'O', 'N', '_', 'T', 'R', 'A', 'N', 'S', '\0', /* GFX_UTCL1_WAITING_ON_TRANS (59056) */
	'C', 'M', 'P', '_', 'U', 'T', 'C', 'L', '1', '_', 'W', 'A', 'I', 'T', 'I', 'N', 'G', '_', 'O', 'N', '_', 'T', 'R', 'A', 'N', 'S', '\0', /* CMP_UTCL1_WAITING_ON_TRANS (59083) */
	'R', 'C', 'I', 'U', '_', 'W', 'A', 'I', 'T', 'I', 'N', 'G', '_', 'O', 'N', '_', 'F', 'R', 'E', 'E', '\0', /* RCIU_WAITING_ON_FREE (59110) */
	'D', 'A', 'T', 'A', '_', 'F', 'E', 'T', 'C', 'H', 'I', 'N', 'G', '_', 'D', 'A', 'T', 'A', '\0', /* DATA_FETCHING_DATA (59131) */
	'G', 'C', 'R', 'I', 'U', '_', 'W', 'A', 'I', 'T', '_', 'O', 'N', '_', 'F', 'R', 'E', 'E', '\0', /* GCRIU_WAIT_ON_FREE (59150) */
	'M', 'E', 'S', '_', 'L', 'O', 'A', 'D', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_LOAD_BUSY (59169) */
	'M', 'E', 'S', '_', 'M', 'U', 'T', 'E', 'X', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_MUTEX_BUSY (59183) */
	'M', 'E', 'S', '_', 'M', 'E', 'S', 'S', 'A', 'G', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_MESSAGE_BUSY (59198) */
	'M', 'E', 'S', '_', 'T', 'C', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_TC_BUSY (59215) */
	'M', 'E', 'S', '_', 'D', 'M', 'A', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_DMA_BUSY (59227) */
	'M', 'E', 'S', '_', 'P', 'I', 'P', 'E', '0', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_PIPE0_BUSY (59240) */
	'M', 'E', 'S', '_', 'P', 'I', 'P', 'E', '1', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_PIPE1_BUSY (59255) */
	'M', 'E', 'S', '_', 'P', 'I', 'P', 'E', '2', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_PIPE2_BUSY (59270) */
	'M', 'E', 'S', '_', 'P', 'I', 'P', 'E', '3', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_PIPE3_BUSY (59285) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'I', 'N', 'D', 'E', 'X', '_', '6', '4', 'B', 'I', 'T', '_', 'M', 'O', 'D', 'E', '\0', /* SCRATCH_INDEX_64BIT_MODE (59300) */
	'M', 'E', 'S', '_', 'H', 'Q', 'D', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_HQD_DISPATCH_BUSY (59325) */
	'M', 'E', 'S', '_', 'H', 'Q', 'D', '_', 'D', 'M', 'A', '_', 'O', 'F', 'F', 'L', 'O', 'A', 'D', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_HQD_DMA_OFFLOAD_BUSY (59347) */
	'M', 'E', 'S', '_', 'H', 'Q', 'D', '_', 'M', 'E', 'S', 'S', 'A', 'G', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_HQD_MESSAGE_BUSY (59372) */
	'M', 'E', 'S', '_', 'H', 'Q', 'D', '_', 'P', 'Q', '_', 'F', 'E', 'T', 'C', 'H', 'E', 'R', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_HQD_PQ_FETCHER_BUSY (59393) */
	'M', 'E', 'S', '_', 'H', 'Q', 'D', '_', 'C', 'O', 'N', 'S', 'U', 'M', 'E', 'D', '_', 'R', 'P', 'T', 'R', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_HQD_CONSUMED_RPTR_BUSY (59417) */
	'M', 'E', 'S', '_', 'H', 'Q', 'D', '_', 'F', 'E', 'T', 'C', 'H', 'E', 'R', '_', 'A', 'R', 'B', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_HQD_FETCHER_ARB_BUSY (59444) */
	'M', 'E', 'S', '_', 'H', 'Q', 'D', '_', 'R', 'O', 'Q', '_', 'A', 'L', 'I', 'G', 'N', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_HQD_ROQ_ALIGN_BUSY (59469) */
	'M', 'E', 'S', '_', 'H', 'Q', 'D', '_', 'R', 'O', 'Q', '_', 'P', 'Q', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_HQD_ROQ_PQ_BUSY (59492) */
	'M', 'E', 'S', '_', 'H', 'Q', 'D', '_', 'P', 'Q', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_HQD_PQ_BUSY (59512) */
	'B', 'U', 'F', 'F', 'E', 'R', '_', 'I', 'D', '\0', /* BUFFER_ID (59528) */
	'S', 'I', 'M', 'D', '_', 'S', 'E', 'L', '\0', /* SIMD_SEL (59538) */
	'W', 'G', 'P', '_', 'S', 'E', 'L', '\0', /* WGP_SEL (59547) */
	'S', 'A', '_', 'S', 'E', 'L', '\0', /* SA_SEL (59555) */
	'W', 'T', 'Y', 'P', 'E', '_', 'I', 'N', 'C', 'L', 'U', 'D', 'E', '\0', /* WTYPE_INCLUDE (59562) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '_', 'V', 'M', 'E', 'M', 'E', 'X', 'E', 'C', '\0', /* TOKEN_EXCLUDE_VMEMEXEC (59576) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '_', 'A', 'L', 'U', 'E', 'X', 'E', 'C', '\0', /* TOKEN_EXCLUDE_ALUEXEC (59599) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '_', 'V', 'A', 'L', 'U', 'I', 'N', 'S', 'T', '\0', /* TOKEN_EXCLUDE_VALUINST (59621) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '_', 'W', 'A', 'V', 'E', 'R', 'D', 'Y', '\0', /* TOKEN_EXCLUDE_WAVERDY (59644) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '_', 'I', 'M', 'M', 'E', 'D', '1', '\0', /* TOKEN_EXCLUDE_IMMED1 (59666) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '_', 'I', 'M', 'M', 'E', 'D', 'I', 'A', 'T', 'E', '\0', /* TOKEN_EXCLUDE_IMMEDIATE (59687, 59701) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '_', 'R', 'E', 'G', '\0', /* TOKEN_EXCLUDE_REG (59711) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '_', 'E', 'V', 'E', 'N', 'T', '\0', /* TOKEN_EXCLUDE_EVENT (59729) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '_', 'I', 'N', 'S', 'T', '\0', /* TOKEN_EXCLUDE_INST (59749) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '_', 'U', 'T', 'I', 'L', 'C', 'T', 'R', '\0', /* TOKEN_EXCLUDE_UTILCTR (59768) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '_', 'W', 'A', 'V', 'E', 'A', 'L', 'L', 'O', 'C', '\0', /* TOKEN_EXCLUDE_WAVEALLOC (59790) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '_', 'P', 'E', 'R', 'F', '\0', /* TOKEN_EXCLUDE_PERF (59814) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '\0', /* TOKEN_EXCLUDE (59833) */
	'R', 'E', 'G', '_', 'I', 'N', 'C', 'L', 'U', 'D', 'E', '_', 'S', 'Q', 'D', 'E', 'C', '\0', /* REG_INCLUDE_SQDEC (59847) */
	'R', 'E', 'G', '_', 'I', 'N', 'C', 'L', 'U', 'D', 'E', '_', 'S', 'H', 'D', 'E', 'C', '\0', /* REG_INCLUDE_SHDEC (59865) */
	'R', 'E', 'G', '_', 'I', 'N', 'C', 'L', 'U', 'D', 'E', '_', 'G', 'F', 'X', 'U', 'D', 'E', 'C', '\0', /* REG_INCLUDE_GFXUDEC (59883) */
	'R', 'E', 'G', '_', 'I', 'N', 'C', 'L', 'U', 'D', 'E', '_', 'C', 'O', 'M', 'P', '\0', /* REG_INCLUDE_COMP (59903) */
	'R', 'E', 'G', '_', 'I', 'N', 'C', 'L', 'U', 'D', 'E', '_', 'C', 'O', 'N', 'T', 'E', 'X', 'T', '\0', /* REG_INCLUDE_CONTEXT (59920) */
	'R', 'E', 'G', '_', 'I', 'N', 'C', 'L', 'U', 'D', 'E', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* REG_INCLUDE_CONFIG (59940) */
	'R', 'E', 'G', '_', 'I', 'N', 'C', 'L', 'U', 'D', 'E', '_', 'O', 'T', 'H', 'E', 'R', '\0', /* REG_INCLUDE_OTHER (59959) */
	'R', 'E', 'G', '_', 'I', 'N', 'C', 'L', 'U', 'D', 'E', '_', 'R', 'E', 'A', 'D', 'S', '\0', /* REG_INCLUDE_READS (59977) */
	'R', 'E', 'G', '_', 'I', 'N', 'C', 'L', 'U', 'D', 'E', '\0', /* REG_INCLUDE (59995) */
	'I', 'N', 'S', 'T', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '\0', /* INST_EXCLUDE (60007) */
	'R', 'E', 'G', '_', 'D', 'E', 'T', 'A', 'I', 'L', '_', 'A', 'L', 'L', '\0', /* REG_DETAIL_ALL (60020) */
	'A', 'L', 'L', '_', 'V', 'M', 'I', 'D', '\0', /* ALL_VMID (60035) */
	'C', 'H', '_', 'P', 'E', 'R', 'F', '_', 'E', 'N', '\0', /* CH_PERF_EN (60044) */
	'I', 'N', 'T', 'E', 'R', 'R', 'U', 'P', 'T', '_', 'E', 'N', '\0', /* INTERRUPT_EN (60055) */
	'D', 'O', 'U', 'B', 'L', 'E', '_', 'B', 'U', 'F', 'F', 'E', 'R', '\0', /* DOUBLE_BUFFER (60068) */
	'R', 'E', 'G', '_', 'S', 'T', 'A', 'L', 'L', '_', 'E', 'N', '\0', /* REG_STALL_EN (60082) */
	'S', 'P', 'I', '_', 'S', 'T', 'A', 'L', 'L', '_', 'E', 'N', '\0', /* SPI_STALL_EN (60095) */
	'S', 'Q', '_', 'S', 'T', 'A', 'L', 'L', '_', 'E', 'N', '\0', /* SQ_STALL_EN (60108) */
	'R', 'E', 'G', '_', 'D', 'R', 'O', 'P', '_', 'O', 'N', '_', 'S', 'T', 'A', 'L', 'L', '\0', /* REG_DROP_ON_STALL (60120) */
	'U', 'T', 'I', 'L', '_', 'T', 'I', 'M', 'E', 'R', '\0', /* UTIL_TIMER (60138) */
	'W', 'A', 'V', 'E', 'S', 'T', 'A', 'R', 'T', '_', 'M', 'O', 'D', 'E', '\0', /* WAVESTART_MODE (60149) */
	'R', 'T', '_', 'F', 'R', 'E', 'Q', '\0', /* RT_FREQ (60164) */
	'S', 'Y', 'N', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'M', 'A', 'R', 'K', 'E', 'R', 'S', '\0', /* SYNC_COUNT_MARKERS (60172) */
	'S', 'Y', 'N', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'D', 'R', 'A', 'W', 'S', '\0', /* SYNC_COUNT_DRAWS (60191) */
	'C', 'A', 'P', 'T', 'U', 'R', 'E', '_', 'A', 'L', 'L', '\0', /* CAPTURE_ALL (60208) */
	'D', 'R', 'A', 'W', '_', 'E', 'V', 'E', 'N', 'T', '_', 'E', 'N', '\0', /* DRAW_EVENT_EN (60220) */
	'F', 'I', 'N', 'I', 'S', 'H', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* FINISH_PENDING (60234) */
	'F', 'I', 'N', 'I', 'S', 'H', '_', 'D', 'O', 'N', 'E', '\0', /* FINISH_DONE (60249, 60256) */
	'U', 'T', 'C', '_', 'E', 'R', 'R', '\0', /* UTC_ERR (60261) */
	'E', 'V', 'E', 'N', 'T', '_', 'C', 'N', 'T', 'R', '_', 'O', 'V', 'E', 'R', 'F', 'L', 'O', 'W', '\0', /* EVENT_CNTR_OVERFLOW (60269) */
	'E', 'V', 'E', 'N', 'T', '_', 'C', 'N', 'T', 'R', '_', 'S', 'T', 'A', 'L', 'L', '\0', /* EVENT_CNTR_STALL (60289) */
	'S', 'Q', '_', 'E', 'X', 'P', '_', 'M', 'R', 'T', '\0', /* SQ_EXP_MRT (60306) */
	'S', 'Q', '_', 'E', 'X', 'P', '_', 'M', 'R', 'T', 'Z', '\0', /* SQ_EXP_MRTZ (60317) */
	'S', 'Q', '_', 'E', 'X', 'P', '_', 'N', 'U', 'L', 'L', '\0', /* SQ_EXP_NULL (60329) */
	'S', 'Q', '_', 'E', 'X', 'P', '_', 'P', 'O', 'S', '\0', /* SQ_EXP_POS (60341) */
	'S', 'Q', '_', 'E', 'X', 'P', '_', 'P', 'R', 'I', 'M', '\0', /* SQ_EXP_PRIM (60352) */
	'S', 'Q', '_', 'E', 'X', 'P', '_', 'P', 'A', 'R', 'A', 'M', '\0', /* SQ_EXP_PARAM (60364) */
	'T', 'G', 'T', '\0', /* TGT (60377) */
	'C', 'O', 'M', 'P', 'R', '\0', /* COMPR (60381) */
	'V', 'M', '\0', /* VM (60387) */
	'B', 'A', 'S', 'E', '_', 'A', 'D', 'D', 'R', 'E', 'S', 'S', '_', 'H', 'I', '\0', /* BASE_ADDRESS_HI (60390, 60395) */
	'C', 'A', 'C', 'H', 'E', '_', 'S', 'W', 'I', 'Z', 'Z', 'L', 'E', '\0', /* CACHE_SWIZZLE (60406) */
	'S', 'W', 'I', 'Z', 'Z', 'L', 'E', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* SWIZZLE_ENABLE (60420) */
	'D', 'S', 'T', '_', 'S', 'E', 'L', '_', 'X', '\0', /* DST_SEL_X (60435) */
	'D', 'S', 'T', '_', 'S', 'E', 'L', '_', 'Y', '\0', /* DST_SEL_Y (60445) */
	'D', 'S', 'T', '_', 'S', 'E', 'L', '_', 'Z', '\0', /* DST_SEL_Z (60455) */
	'D', 'S', 'T', '_', 'S', 'E', 'L', '_', 'W', '\0', /* DST_SEL_W (60465) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'I', 'N', 'V', 'A', 'L', 'I', 'D', '\0', /* GFX10_FORMAT_INVALID (60475) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_8_UNORM (60496) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_8_SNORM (60517) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', 'U', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_8_USCALED (60538) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', 'S', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_8_SSCALED (60561) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_8_UINT (60584) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', 'S', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_8_SINT (60604) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_16_UNORM (60624) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_16_SNORM (60646) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', 'U', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_16_USCALED (60668) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', 'S', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_16_SSCALED (60692) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_16_UINT (60716) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', 'S', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_16_SINT (60737) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', 'F', 'L', 'O', 'A', 'T', '\0', /* GFX10_FORMAT_16_FLOAT (60758) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '8', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_8_8_UNORM (60780) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '8', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_8_8_SNORM (60803) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '8', '_', 'U', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_8_8_USCALED (60826) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '8', '_', 'S', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_8_8_SSCALED (60851) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '8', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_8_8_UINT (60876) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '8', '_', 'S', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_8_8_SINT (60898) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '3', '2', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_32_UINT (60920) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '3', '2', '_', 'S', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_32_SINT (60941) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '3', '2', '_', 'F', 'L', 'O', 'A', 'T', '\0', /* GFX10_FORMAT_32_FLOAT (60962) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', '1', '6', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_16_16_UNORM (60984) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', '1', '6', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_16_16_SNORM (61009) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', '1', '6', '_', 'U', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_16_16_USCALED (61034) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', '1', '6', '_', 'S', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_16_16_SSCALED (61061) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', '1', '6', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_16_16_UINT (61088) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', '1', '6', '_', 'S', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_16_16_SINT (61112) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', '1', '6', '_', 'F', 'L', 'O', 'A', 'T', '\0', /* GFX10_FORMAT_16_16_FLOAT (61136) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '0', '_', '1', '1', '_', '1', '1', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_10_11_11_UNORM (61161) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '0', '_', '1', '1', '_', '1', '1', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_10_11_11_SNORM (61189) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '0', '_', '1', '1', '_', '1', '1', '_', 'U', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_10_11_11_USCALED (61217) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '0', '_', '1', '1', '_', '1', '1', '_', 'S', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_10_11_11_SSCALED (61247) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '0', '_', '1', '1', '_', '1', '1', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_10_11_11_UINT (61277) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '0', '_', '1', '1', '_', '1', '1', '_', 'S', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_10_11_11_SINT (61304) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '0', '_', '1', '1', '_', '1', '1', '_', 'F', 'L', 'O', 'A', 'T', '\0', /* GFX10_FORMAT_10_11_11_FLOAT (61331) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '1', '_', '1', '1', '_', '1', '0', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_11_11_10_UNORM (61359) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '1', '_', '1', '1', '_', '1', '0', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_11_11_10_SNORM (61387) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '1', '_', '1', '1', '_', '1', '0', '_', 'U', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_11_11_10_USCALED (61415) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '1', '_', '1', '1', '_', '1', '0', '_', 'S', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_11_11_10_SSCALED (61445) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '1', '_', '1', '1', '_', '1', '0', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_11_11_10_UINT (61475) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '1', '_', '1', '1', '_', '1', '0', '_', 'S', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_11_11_10_SINT (61502) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '1', '_', '1', '1', '_', '1', '0', '_', 'F', 'L', 'O', 'A', 'T', '\0', /* GFX10_FORMAT_11_11_10_FLOAT (61529) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '0', '_', '1', '0', '_', '1', '0', '_', '2', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_10_10_10_2_UNORM (61557) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '0', '_', '1', '0', '_', '1', '0', '_', '2', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_10_10_10_2_SNORM (61587) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '0', '_', '1', '0', '_', '1', '0', '_', '2', '_', 'U', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_10_10_10_2_USCALED (61617) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '0', '_', '1', '0', '_', '1', '0', '_', '2', '_', 'S', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_10_10_10_2_SSCALED (61649) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '0', '_', '1', '0', '_', '1', '0', '_', '2', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_10_10_10_2_UINT (61681) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '0', '_', '1', '0', '_', '1', '0', '_', '2', '_', 'S', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_10_10_10_2_SINT (61710) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '2', '_', '1', '0', '_', '1', '0', '_', '1', '0', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_2_10_10_10_UNORM (61739) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '2', '_', '1', '0', '_', '1', '0', '_', '1', '0', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_2_10_10_10_SNORM (61769) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '2', '_', '1', '0', '_', '1', '0', '_', '1', '0', '_', 'U', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_2_10_10_10_USCALED (61799) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '2', '_', '1', '0', '_', '1', '0', '_', '1', '0', '_', 'S', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_2_10_10_10_SSCALED (61831) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '2', '_', '1', '0', '_', '1', '0', '_', '1', '0', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_2_10_10_10_UINT (61863) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '2', '_', '1', '0', '_', '1', '0', '_', '1', '0', '_', 'S', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_2_10_10_10_SINT (61892) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '8', '_', '8', '_', '8', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_8_8_8_8_UNORM (61921) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '8', '_', '8', '_', '8', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_8_8_8_8_SNORM (61948) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '8', '_', '8', '_', '8', '_', 'U', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_8_8_8_8_USCALED (61975) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '8', '_', '8', '_', '8', '_', 'S', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_8_8_8_8_SSCALED (62004) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '8', '_', '8', '_', '8', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_8_8_8_8_UINT (62033) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '8', '_', '8', '_', '8', '_', 'S', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_8_8_8_8_SINT (62059) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '3', '2', '_', '3', '2', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_32_32_UINT (62085) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '3', '2', '_', '3', '2', '_', 'S', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_32_32_SINT (62109) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '3', '2', '_', '3', '2', '_', 'F', 'L', 'O', 'A', 'T', '\0', /* GFX10_FORMAT_32_32_FLOAT (62133) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_16_16_16_16_UNORM (62158) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_16_16_16_16_SNORM (62189) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', 'U', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_16_16_16_16_USCALED (62220) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', 'S', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_16_16_16_16_SSCALED (62253) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_16_16_16_16_UINT (62286) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', 'S', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_16_16_16_16_SINT (62316) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', 'F', 'L', 'O', 'A', 'T', '\0', /* GFX10_FORMAT_16_16_16_16_FLOAT (62346) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '3', '2', '_', '3', '2', '_', '3', '2', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_32_32_32_UINT (62377) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '3', '2', '_', '3', '2', '_', '3', '2', '_', 'S', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_32_32_32_SINT (62404) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '3', '2', '_', '3', '2', '_', '3', '2', '_', 'F', 'L', 'O', 'A', 'T', '\0', /* GFX10_FORMAT_32_32_32_FLOAT (62431) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '3', '2', '_', '3', '2', '_', '3', '2', '_', '3', '2', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_32_32_32_32_UINT (62459) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '3', '2', '_', '3', '2', '_', '3', '2', '_', '3', '2', '_', 'S', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_32_32_32_32_SINT (62489) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '3', '2', '_', '3', '2', '_', '3', '2', '_', '3', '2', '_', 'F', 'L', 'O', 'A', 'T', '\0', /* GFX10_FORMAT_32_32_32_32_FLOAT (62519) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', 'S', 'R', 'G', 'B', '\0', /* GFX10_FORMAT_8_SRGB (62550) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '8', '_', 'S', 'R', 'G', 'B', '\0', /* GFX10_FORMAT_8_8_SRGB (62570) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '8', '_', '8', '_', '8', '_', 'S', 'R', 'G', 'B', '\0', /* GFX10_FORMAT_8_8_8_8_SRGB (62592) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '6', 'E', '4', '_', 'F', 'L', 'O', 'A', 'T', '\0', /* GFX10_FORMAT_6E4_FLOAT (62618) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '5', '_', '9', '_', '9', '_', '9', '_', 'F', 'L', 'O', 'A', 'T', '\0', /* GFX10_FORMAT_5_9_9_9_FLOAT (62641) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '5', '_', '6', '_', '5', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_5_6_5_UNORM (62668) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '_', '5', '_', '5', '_', '5', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_1_5_5_5_UNORM (62693) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '5', '_', '5', '_', '5', '_', '1', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_5_5_5_1_UNORM (62720) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '4', '_', '4', '_', '4', '_', '4', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_4_4_4_4_UNORM (62747) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '4', '_', '4', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_4_4_UNORM (62774) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_1_UNORM (62797) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '_', 'R', 'E', 'V', 'E', 'R', 'S', 'E', 'D', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_1_REVERSED_UNORM (62818) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '3', '2', '_', 'F', 'L', 'O', 'A', 'T', '_', 'C', 'L', 'A', 'M', 'P', '\0', /* GFX10_FORMAT_32_FLOAT_CLAMP (62848) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '2', '4', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_8_24_UNORM (62876) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '2', '4', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_8_24_UINT (62900) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '2', '4', '_', '8', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_24_8_UNORM (62923) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '2', '4', '_', '8', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_24_8_UINT (62947) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'X', '2', '4', '_', '8', '_', '3', '2', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_X24_8_32_UINT (62970) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'X', '2', '4', '_', '8', '_', '3', '2', '_', 'F', 'L', 'O', 'A', 'T', '\0', /* GFX10_FORMAT_X24_8_32_FLOAT (62997) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'G', 'B', '_', 'G', 'R', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_GB_GR_UNORM (63025) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'G', 'B', '_', 'G', 'R', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_GB_GR_SNORM (63050) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'G', 'B', '_', 'G', 'R', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_GB_GR_UINT (63075) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'G', 'B', '_', 'G', 'R', '_', 'S', 'R', 'G', 'B', '\0', /* GFX10_FORMAT_GB_GR_SRGB (63099) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'G', '_', 'R', 'G', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_BG_RG_UNORM (63123) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'G', '_', 'R', 'G', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_BG_RG_SNORM (63148) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'G', '_', 'R', 'G', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_BG_RG_UINT (63173) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'G', '_', 'R', 'G', '_', 'S', 'R', 'G', 'B', '\0', /* GFX10_FORMAT_BG_RG_SRGB (63197) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'F', 'M', 'A', 'S', 'K', '8', '_', 'S', '2', '_', 'F', '1', '\0', /* GFX10_FORMAT_FMASK8_S2_F1 (63221) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'F', 'M', 'A', 'S', 'K', '8', '_', 'S', '4', '_', 'F', '1', '\0', /* GFX10_FORMAT_FMASK8_S4_F1 (63247) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'F', 'M', 'A', 'S', 'K', '8', '_', 'S', '8', '_', 'F', '1', '\0', /* GFX10_FORMAT_FMASK8_S8_F1 (63273) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'F', 'M', 'A', 'S', 'K', '8', '_', 'S', '2', '_', 'F', '2', '\0', /* GFX10_FORMAT_FMASK8_S2_F2 (63299) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'F', 'M', 'A', 'S', 'K', '8', '_', 'S', '4', '_', 'F', '2', '\0', /* GFX10_FORMAT_FMASK8_S4_F2 (63325) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'F', 'M', 'A', 'S', 'K', '8', '_', 'S', '4', '_', 'F', '4', '\0', /* GFX10_FORMAT_FMASK8_S4_F4 (63351) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'F', 'M', 'A', 'S', 'K', '1', '6', '_', 'S', '1', '6', '_', 'F', '1', '\0', /* GFX10_FORMAT_FMASK16_S16_F1 (63377) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'F', 'M', 'A', 'S', 'K', '1', '6', '_', 'S', '8', '_', 'F', '2', '\0', /* GFX10_FORMAT_FMASK16_S8_F2 (63405) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'F', 'M', 'A', 'S', 'K', '3', '2', '_', 'S', '1', '6', '_', 'F', '2', '\0', /* GFX10_FORMAT_FMASK32_S16_F2 (63432) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'F', 'M', 'A', 'S', 'K', '3', '2', '_', 'S', '8', '_', 'F', '4', '\0', /* GFX10_FORMAT_FMASK32_S8_F4 (63460) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'F', 'M', 'A', 'S', 'K', '3', '2', '_', 'S', '8', '_', 'F', '8', '\0', /* GFX10_FORMAT_FMASK32_S8_F8 (63487) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'F', 'M', 'A', 'S', 'K', '6', '4', '_', 'S', '1', '6', '_', 'F', '4', '\0', /* GFX10_FORMAT_FMASK64_S16_F4 (63514) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'F', 'M', 'A', 'S', 'K', '6', '4', '_', 'S', '1', '6', '_', 'F', '8', '\0', /* GFX10_FORMAT_FMASK64_S16_F8 (63542) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'C', '1', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_BC1_UNORM (63570) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'C', '1', '_', 'S', 'R', 'G', 'B', '\0', /* GFX10_FORMAT_BC1_SRGB (63593) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'C', '2', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_BC2_UNORM (63615) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'C', '2', '_', 'S', 'R', 'G', 'B', '\0', /* GFX10_FORMAT_BC2_SRGB (63638) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'C', '3', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_BC3_UNORM (63660) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'C', '3', '_', 'S', 'R', 'G', 'B', '\0', /* GFX10_FORMAT_BC3_SRGB (63683) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'C', '4', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_BC4_UNORM (63705) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'C', '4', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_BC4_SNORM (63728) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'C', '5', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_BC5_UNORM (63751) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'C', '5', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_BC5_SNORM (63774) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'C', '6', '_', 'U', 'F', 'L', 'O', 'A', 'T', '\0', /* GFX10_FORMAT_BC6_UFLOAT (63797) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'C', '6', '_', 'S', 'F', 'L', 'O', 'A', 'T', '\0', /* GFX10_FORMAT_BC6_SFLOAT (63821) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'C', '7', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_BC7_UNORM (63845) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'C', '7', '_', 'S', 'R', 'G', 'B', '\0', /* GFX10_FORMAT_BC7_SRGB (63868) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '8', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_MM_8_UNORM (63890) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '8', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_MM_8_UINT (63914) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '8', '_', '8', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_MM_8_8_UNORM (63937) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '8', '_', '8', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_MM_8_8_UINT (63963) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '8', '_', '8', '_', '8', '_', '8', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_MM_8_8_8_8_UNORM (63988) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '8', '_', '8', '_', '8', '_', '8', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_MM_8_8_8_8_UINT (64018) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', 'V', 'Y', 'U', 'Y', '8', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_MM_VYUY8_UNORM (64047) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', 'V', 'Y', 'U', 'Y', '8', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_MM_VYUY8_UINT (64075) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '1', '0', '_', '1', '1', '_', '1', '1', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_MM_10_11_11_UNORM (64102) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '1', '0', '_', '1', '1', '_', '1', '1', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_MM_10_11_11_UINT (64133) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '2', '_', '1', '0', '_', '1', '0', '_', '1', '0', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_MM_2_10_10_10_UNORM (64163) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '2', '_', '1', '0', '_', '1', '0', '_', '1', '0', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_MM_2_10_10_10_UINT (64196) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_MM_16_16_16_16_UNORM (64228) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_MM_16_16_16_16_UINT (64262) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '1', '0', '_', 'I', 'N', '_', '1', '6', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_MM_10_IN_16_UNORM (64295) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '1', '0', '_', 'I', 'N', '_', '1', '6', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_MM_10_IN_16_UINT (64326) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '1', '0', '_', 'I', 'N', '_', '1', '6', '_', '1', '6', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_MM_10_IN_16_16_UNORM (64356) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '1', '0', '_', 'I', 'N', '_', '1', '6', '_', '1', '6', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_MM_10_IN_16_16_UINT (64390) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '1', '0', '_', 'I', 'N', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', 'U', 'N', 'O', 'R', 'M', ' ', '\0', /* GFX10_FORMAT_MM_10_IN_16_16_16_16_UNORM  (64423) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '1', '0', '_', 'I', 'N', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_MM_10_IN_16_16_16_16_UINT (64464) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '7', 'E', '3', '_', 'F', 'L', 'O', 'A', 'T', '\0', /* GFX10_FORMAT_7E3_FLOAT (64503) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'Y', 'C', 'B', 'C', 'R', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_YCBCR_UNORM (64526) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'Y', 'C', 'B', 'C', 'R', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_YCBCR_SNORM (64551) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'Y', 'C', 'B', 'C', 'R', '_', 'U', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_YCBCR_USCALED (64576) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'Y', 'C', 'B', 'C', 'R', '_', 'S', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_YCBCR_SSCALED (64603) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'Y', 'C', 'B', 'C', 'R', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_YCBCR_UINT (64630) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'Y', 'C', 'B', 'C', 'R', '_', 'S', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_YCBCR_SINT (64654) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'Y', 'C', 'B', 'C', 'R', '_', 'S', 'R', 'G', 'B', '\0', /* GFX10_FORMAT_YCBCR_SRGB (64678) */
	'I', 'N', 'D', 'E', 'X', '_', 'S', 'T', 'R', 'I', 'D', 'E', '\0', /* INDEX_STRIDE (64702) */
	'A', 'D', 'D', '_', 'T', 'I', 'D', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* ADD_TID_ENABLE (64715) */
	'R', 'E', 'S', 'O', 'U', 'R', 'C', 'E', '_', 'L', 'E', 'V', 'E', 'L', '\0', /* RESOURCE_LEVEL (64730) */
	'O', 'O', 'B', '_', 'S', 'E', 'L', 'E', 'C', 'T', '_', 'S', 'T', 'R', 'U', 'C', 'T', 'U', 'R', 'E', 'D', '_', 'W', 'I', 'T', 'H', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* OOB_SELECT_STRUCTURED_WITH_OFFSET (64745) */
	'O', 'O', 'B', '_', 'S', 'E', 'L', 'E', 'C', 'T', '_', 'S', 'T', 'R', 'U', 'C', 'T', 'U', 'R', 'E', 'D', '\0', /* OOB_SELECT_STRUCTURED (64779) */
	'O', 'O', 'B', '_', 'S', 'E', 'L', 'E', 'C', 'T', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', 'D', '\0', /* OOB_SELECT_DISABLED (64801) */
	'O', 'O', 'B', '_', 'S', 'E', 'L', 'E', 'C', 'T', '_', 'R', 'A', 'W', '\0', /* OOB_SELECT_RAW (64821, 64832) */
	'O', 'O', 'B', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* OOB_SELECT (64836) */
	'C', 'L', 'A', 'M', 'P', '_', 'X', '\0', /* CLAMP_X (64847) */
	'C', 'L', 'A', 'M', 'P', '_', 'Y', '\0', /* CLAMP_Y (64855) */
	'C', 'L', 'A', 'M', 'P', '_', 'Z', '\0', /* CLAMP_Z (64863) */
	'M', 'A', 'X', '_', 'A', 'N', 'I', 'S', 'O', '_', 'R', 'A', 'T', 'I', 'O', '\0', /* MAX_ANISO_RATIO (64871) */
	'D', 'E', 'P', 'T', 'H', '_', 'C', 'O', 'M', 'P', 'A', 'R', 'E', '_', 'F', 'U', 'N', 'C', '\0', /* DEPTH_COMPARE_FUNC (64887) */
	'F', 'O', 'R', 'C', 'E', '_', 'U', 'N', 'N', 'O', 'R', 'M', 'A', 'L', 'I', 'Z', 'E', 'D', '\0', /* FORCE_UNNORMALIZED (64906) */
	'A', 'N', 'I', 'S', 'O', '_', 'T', 'H', 'R', 'E', 'S', 'H', 'O', 'L', 'D', '\0', /* ANISO_THRESHOLD (64925) */
	'M', 'C', '_', 'C', 'O', 'O', 'R', 'D', '_', 'T', 'R', 'U', 'N', 'C', '\0', /* MC_COORD_TRUNC (64941) */
	'F', 'O', 'R', 'C', 'E', '_', 'D', 'E', 'G', 'A', 'M', 'M', 'A', '\0', /* FORCE_DEGAMMA (64956) */
	'A', 'N', 'I', 'S', 'O', '_', 'B', 'I', 'A', 'S', '\0', /* ANISO_BIAS (64970) */
	'T', 'R', 'U', 'N', 'C', '_', 'C', 'O', 'O', 'R', 'D', '\0', /* TRUNC_COORD (64981) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'C', 'U', 'B', 'E', '_', 'W', 'R', 'A', 'P', '\0', /* DISABLE_CUBE_WRAP (64993, 65006) */
	'F', 'I', 'L', 'T', 'E', 'R', '_', 'M', 'O', 'D', 'E', '\0', /* FILTER_MODE (65011) */
	'S', 'K', 'I', 'P', '_', 'D', 'E', 'G', 'A', 'M', 'M', 'A', '\0', /* SKIP_DEGAMMA (65023) */
	'M', 'I', 'N', '_', 'L', 'O', 'D', '\0', /* MIN_LOD (65036) */
	'M', 'A', 'X', '_', 'L', 'O', 'D', '\0', /* MAX_LOD (65044) */
	'P', 'E', 'R', 'F', '_', 'M', 'I', 'P', '\0', /* PERF_MIP (65052) */
	'P', 'E', 'R', 'F', '_', 'Z', '\0', /* PERF_Z (65061) */
	'L', 'O', 'D', '_', 'B', 'I', 'A', 'S', '\0', /* LOD_BIAS (65068) */
	'B', 'O', 'R', 'D', 'E', 'R', '_', 'C', 'O', 'L', 'O', 'R', '_', 'P', 'T', 'R', '\0', /* BORDER_COLOR_PTR (65077) */
	'B', 'O', 'R', 'D', 'E', 'R', '_', 'C', 'O', 'L', 'O', 'R', '_', 'T', 'Y', 'P', 'E', '\0', /* BORDER_COLOR_TYPE (65094) */
	'L', 'O', 'D', '_', 'B', 'I', 'A', 'S', '_', 'S', 'E', 'C', '\0', /* LOD_BIAS_SEC (65112) */
	'X', 'Y', '_', 'M', 'A', 'G', '_', 'F', 'I', 'L', 'T', 'E', 'R', '\0', /* XY_MAG_FILTER (65125) */
	'X', 'Y', '_', 'M', 'I', 'N', '_', 'F', 'I', 'L', 'T', 'E', 'R', '\0', /* XY_MIN_FILTER (65139) */
	'Z', '_', 'F', 'I', 'L', 'T', 'E', 'R', '\0', /* Z_FILTER (65153) */
	'M', 'I', 'P', '_', 'F', 'I', 'L', 'T', 'E', 'R', '\0', /* MIP_FILTER (65162) */
	'M', 'I', 'P', '_', 'P', 'O', 'I', 'N', 'T', '_', 'P', 'R', 'E', 'C', 'L', 'A', 'M', 'P', '\0', /* MIP_POINT_PRECLAMP (65173) */
	'A', 'N', 'I', 'S', 'O', '_', 'O', 'V', 'E', 'R', 'R', 'I', 'D', 'E', '\0', /* ANISO_OVERRIDE (65192) */
	'B', 'L', 'E', 'N', 'D', '_', 'Z', 'E', 'R', 'O', '_', 'P', 'R', 'T', '\0', /* BLEND_ZERO_PRT (65207) */
	'D', 'E', 'R', 'I', 'V', '_', 'A', 'D', 'J', 'U', 'S', 'T', '_', 'E', 'N', '\0', /* DERIV_ADJUST_EN (65222) */
	'G', 'P', 'R', '_', 'W', 'R', 'I', 'T', 'E', '_', 'P', 'R', 'I', 'O', 'R', 'I', 'T', 'Y', '\0', /* GPR_WRITE_PRIORITY (65238, 65248) */
	'E', 'X', 'P', '_', 'P', 'R', 'I', 'O', 'R', 'I', 'T', 'Y', '_', 'O', 'R', 'D', 'E', 'R', '\0', /* EXP_PRIORITY_ORDER (65257) */
	'E', 'N', 'A', 'B', 'L', 'E', '_', 'S', 'Q', 'G', '_', 'T', 'O', 'P', '_', 'E', 'V', 'E', 'N', 'T', 'S', '\0', /* ENABLE_SQG_TOP_EVENTS (65276) */
	'E', 'N', 'A', 'B', 'L', 'E', '_', 'S', 'Q', 'G', '_', 'B', 'O', 'P', '_', 'E', 'V', 'E', 'N', 'T', 'S', '\0', /* ENABLE_SQG_BOP_EVENTS (65298) */
	'R', 'S', 'R', 'C', '_', 'M', 'G', 'M', 'T', '_', 'R', 'E', 'S', 'E', 'T', '\0', /* RSRC_MGMT_RESET (65320) */
	'T', 'T', 'R', 'A', 'C', 'E', '_', 'S', 'T', 'A', 'L', 'L', '_', 'A', 'L', 'L', '\0', /* TTRACE_STALL_ALL (65336) */
	'A', 'L', 'L', 'O', 'C', '_', 'A', 'R', 'B', '_', 'L', 'R', 'U', '_', 'E', 'N', 'A', '\0', /* ALLOC_ARB_LRU_ENA (65353) */
	'E', 'X', 'P', '_', 'A', 'R', 'B', '_', 'L', 'R', 'U', '_', 'E', 'N', 'A', '\0', /* EXP_ARB_LRU_ENA (65371) */
	'P', 'S', '_', 'P', 'K', 'R', '_', 'P', 'R', 'I', 'O', 'R', 'I', 'T', 'Y', '_', 'C', 'N', 'T', 'L', '\0', /* PS_PKR_PRIORITY_CNTL (65387) */
	'N', 'U', 'M', '_', 'P', 'I', 'P', 'E', 'S', '\0', /* NUM_PIPES (65408) */
	'P', 'I', 'P', 'E', '_', 'I', 'N', 'T', 'E', 'R', 'L', 'E', 'A', 'V', 'E', '_', 'S', 'I', 'Z', 'E', '\0', /* PIPE_INTERLEAVE_SIZE (65418) */
	'M', 'A', 'X', '_', 'C', 'O', 'M', 'P', 'R', 'E', 'S', 'S', 'E', 'D', '_', 'F', 'R', 'A', 'G', 'S', '\0', /* MAX_COMPRESSED_FRAGS (65439) */
	'N', 'U', 'M', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'E', 'N', 'G', 'I', 'N', 'E', 'S', '\0', /* NUM_SHADER_ENGINES (65460) */
	'N', 'U', 'M', '_', 'R', 'B', '_', 'P', 'E', 'R', '_', 'S', 'E', '\0', /* NUM_RB_PER_SE (65479) */
	'A', 'R', 'R', 'A', 'Y', '_', 'L', 'I', 'N', 'E', 'A', 'R', '_', 'G', 'E', 'N', 'E', 'R', 'A', 'L', '\0', /* ARRAY_LINEAR_GENERAL (65493, 65499) */
	'A', 'R', 'R', 'A', 'Y', '_', 'L', 'I', 'N', 'E', 'A', 'R', '_', 'A', 'L', 'I', 'G', 'N', 'E', 'D', '\0', /* ARRAY_LINEAR_ALIGNED (65514) */
	'A', 'R', 'R', 'A', 'Y', '_', '1', 'D', '_', 'T', 'I', 'L', 'E', 'D', '_', 'T', 'H', 'I', 'N', '1', '\0', /* ARRAY_1D_TILED_THIN1 (65535) */
	'A', 'R', 'R', 'A', 'Y', '_', '1', 'D', '_', 'T', 'I', 'L', 'E', 'D', '_', 'T', 'H', 'I', 'C', 'K', '\0', /* ARRAY_1D_TILED_THICK (65556) */
	'A', 'R', 'R', 'A', 'Y', '_', '2', 'D', '_', 'T', 'I', 'L', 'E', 'D', '_', 'T', 'H', 'I', 'N', '1', '\0', /* ARRAY_2D_TILED_THIN1 (65577) */
	'A', 'R', 'R', 'A', 'Y', '_', 'P', 'R', 'T', '_', 'T', 'I', 'L', 'E', 'D', '_', 'T', 'H', 'I', 'N', '1', '\0', /* ARRAY_PRT_TILED_THIN1 (65598) */
	'A', 'R', 'R', 'A', 'Y', '_', 'P', 'R', 'T', '_', '2', 'D', '_', 'T', 'I', 'L', 'E', 'D', '_', 'T', 'H', 'I', 'N', '1', '\0', /* ARRAY_PRT_2D_TILED_THIN1 (65620) */
	'A', 'R', 'R', 'A', 'Y', '_', '2', 'D', '_', 'T', 'I', 'L', 'E', 'D', '_', 'T', 'H', 'I', 'C', 'K', '\0', /* ARRAY_2D_TILED_THICK (65645) */
	'A', 'R', 'R', 'A', 'Y', '_', '2', 'D', '_', 'T', 'I', 'L', 'E', 'D', '_', 'X', 'T', 'H', 'I', 'C', 'K', '\0', /* ARRAY_2D_TILED_XTHICK (65666) */
	'A', 'R', 'R', 'A', 'Y', '_', 'P', 'R', 'T', '_', 'T', 'I', 'L', 'E', 'D', '_', 'T', 'H', 'I', 'C', 'K', '\0', /* ARRAY_PRT_TILED_THICK (65688) */
	'A', 'R', 'R', 'A', 'Y', '_', 'P', 'R', 'T', '_', '2', 'D', '_', 'T', 'I', 'L', 'E', 'D', '_', 'T', 'H', 'I', 'C', 'K', '\0', /* ARRAY_PRT_2D_TILED_THICK (65710) */
	'A', 'R', 'R', 'A', 'Y', '_', 'P', 'R', 'T', '_', '3', 'D', '_', 'T', 'I', 'L', 'E', 'D', '_', 'T', 'H', 'I', 'N', '1', '\0', /* ARRAY_PRT_3D_TILED_THIN1 (65735) */
	'A', 'R', 'R', 'A', 'Y', '_', '3', 'D', '_', 'T', 'I', 'L', 'E', 'D', '_', 'T', 'H', 'I', 'N', '1', '\0', /* ARRAY_3D_TILED_THIN1 (65760) */
	'A', 'R', 'R', 'A', 'Y', '_', '3', 'D', '_', 'T', 'I', 'L', 'E', 'D', '_', 'T', 'H', 'I', 'C', 'K', '\0', /* ARRAY_3D_TILED_THICK (65781) */
	'A', 'R', 'R', 'A', 'Y', '_', '3', 'D', '_', 'T', 'I', 'L', 'E', 'D', '_', 'X', 'T', 'H', 'I', 'C', 'K', '\0', /* ARRAY_3D_TILED_XTHICK (65802) */
	'A', 'R', 'R', 'A', 'Y', '_', 'P', 'R', 'T', '_', '3', 'D', '_', 'T', 'I', 'L', 'E', 'D', '_', 'T', 'H', 'I', 'C', 'K', '\0', /* ARRAY_PRT_3D_TILED_THICK (65824) */
	'A', 'R', 'R', 'A', 'Y', '_', 'M', 'O', 'D', 'E', '\0', /* ARRAY_MODE (65849) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '2', '\0', /* ADDR_SURF_P2 (65860) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '2', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '0', '\0', /* ADDR_SURF_P2_RESERVED0 (65873) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '2', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '1', '\0', /* ADDR_SURF_P2_RESERVED1 (65896, 65909) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '2', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '2', '\0', /* ADDR_SURF_P2_RESERVED2 (65919, 65932) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '4', '_', '8', 'x', '1', '6', '\0', /* ADDR_SURF_P4_8x16 (65942) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '4', '_', '1', '6', 'x', '1', '6', '\0', /* ADDR_SURF_P4_16x16 (65960) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '4', '_', '1', '6', 'x', '3', '2', '\0', /* ADDR_SURF_P4_16x32 (65979) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '4', '_', '3', '2', 'x', '3', '2', '\0', /* ADDR_SURF_P4_32x32 (65998) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '8', '_', '1', '6', 'x', '1', '6', '_', '8', 'x', '1', '6', '\0', /* ADDR_SURF_P8_16x16_8x16 (66017) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '8', '_', '1', '6', 'x', '3', '2', '_', '8', 'x', '1', '6', '\0', /* ADDR_SURF_P8_16x32_8x16 (66041) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '8', '_', '3', '2', 'x', '3', '2', '_', '8', 'x', '1', '6', '\0', /* ADDR_SURF_P8_32x32_8x16 (66065) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '8', '_', '1', '6', 'x', '3', '2', '_', '1', '6', 'x', '1', '6', '\0', /* ADDR_SURF_P8_16x32_16x16 (66089) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '8', '_', '3', '2', 'x', '3', '2', '_', '1', '6', 'x', '1', '6', '\0', /* ADDR_SURF_P8_32x32_16x16 (66114) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '8', '_', '3', '2', 'x', '3', '2', '_', '1', '6', 'x', '3', '2', '\0', /* ADDR_SURF_P8_32x32_16x32 (66139) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '8', '_', '3', '2', 'x', '6', '4', '_', '3', '2', 'x', '3', '2', '\0', /* ADDR_SURF_P8_32x64_32x32 (66164) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '8', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '0', '\0', /* ADDR_SURF_P8_RESERVED0 (66189) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '1', '6', '_', '3', '2', 'x', '3', '2', '_', '8', 'x', '1', '6', '\0', /* ADDR_SURF_P16_32x32_8x16 (66212) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '1', '6', '_', '3', '2', 'x', '3', '2', '_', '1', '6', 'x', '1', '6', '\0', /* ADDR_SURF_P16_32x32_16x16 (66237) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '1', '6', '\0', /* ADDR_SURF_P16 (66263) */
	'P', 'I', 'P', 'E', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* PIPE_CONFIG (66277) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'T', 'I', 'L', 'E', '_', 'S', 'P', 'L', 'I', 'T', '_', '6', '4', 'B', '\0', /* ADDR_SURF_TILE_SPLIT_64B (66289) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'T', 'I', 'L', 'E', '_', 'S', 'P', 'L', 'I', 'T', '_', '1', '2', '8', 'B', '\0', /* ADDR_SURF_TILE_SPLIT_128B (66314) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'T', 'I', 'L', 'E', '_', 'S', 'P', 'L', 'I', 'T', '_', '2', '5', '6', 'B', '\0', /* ADDR_SURF_TILE_SPLIT_256B (66340) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'T', 'I', 'L', 'E', '_', 'S', 'P', 'L', 'I', 'T', '_', '5', '1', '2', 'B', '\0', /* ADDR_SURF_TILE_SPLIT_512B (66366) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'T', 'I', 'L', 'E', '_', 'S', 'P', 'L', 'I', 'T', '_', '1', 'K', 'B', '\0', /* ADDR_SURF_TILE_SPLIT_1KB (66392) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'T', 'I', 'L', 'E', '_', 'S', 'P', 'L', 'I', 'T', '_', '2', 'K', 'B', '\0', /* ADDR_SURF_TILE_SPLIT_2KB (66417) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'T', 'I', 'L', 'E', '_', 'S', 'P', 'L', 'I', 'T', '_', '4', 'K', 'B', '\0', /* ADDR_SURF_TILE_SPLIT_4KB (66442) */
	'T', 'I', 'L', 'E', '_', 'S', 'P', 'L', 'I', 'T', '\0', /* TILE_SPLIT (66467) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'D', 'I', 'S', 'P', 'L', 'A', 'Y', '_', 'M', 'I', 'C', 'R', 'O', '_', 'T', 'I', 'L', 'I', 'N', 'G', '\0', /* ADDR_SURF_DISPLAY_MICRO_TILING (66478) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'T', 'H', 'I', 'N', '_', 'M', 'I', 'C', 'R', 'O', '_', 'T', 'I', 'L', 'I', 'N', 'G', '\0', /* ADDR_SURF_THIN_MICRO_TILING (66509) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'D', 'E', 'P', 'T', 'H', '_', 'M', 'I', 'C', 'R', 'O', '_', 'T', 'I', 'L', 'I', 'N', 'G', '\0', /* ADDR_SURF_DEPTH_MICRO_TILING (66537) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'R', 'O', 'T', 'A', 'T', 'E', 'D', '_', 'M', 'I', 'C', 'R', 'O', '_', 'T', 'I', 'L', 'I', 'N', 'G', '\0', /* ADDR_SURF_ROTATED_MICRO_TILING (66566) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'T', 'H', 'I', 'C', 'K', '_', 'M', 'I', 'C', 'R', 'O', '_', 'T', 'I', 'L', 'I', 'N', 'G', '\0', /* ADDR_SURF_THICK_MICRO_TILING (66597) */
	'M', 'I', 'C', 'R', 'O', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '_', 'N', 'E', 'W', '\0', /* MICRO_TILE_MODE_NEW (66626) */
	'S', 'A', 'M', 'P', 'L', 'E', '_', 'S', 'P', 'L', 'I', 'T', '\0', /* SAMPLE_SPLIT (66646) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'B', 'A', 'N', 'K', '_', 'W', 'I', 'D', 'T', 'H', '_', '1', '\0', /* ADDR_SURF_BANK_WIDTH_1 (66659) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'B', 'A', 'N', 'K', '_', 'W', 'I', 'D', 'T', 'H', '_', '2', '\0', /* ADDR_SURF_BANK_WIDTH_2 (66682) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'B', 'A', 'N', 'K', '_', 'W', 'I', 'D', 'T', 'H', '_', '4', '\0', /* ADDR_SURF_BANK_WIDTH_4 (66705) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'B', 'A', 'N', 'K', '_', 'W', 'I', 'D', 'T', 'H', '_', '8', '\0', /* ADDR_SURF_BANK_WIDTH_8 (66728) */
	'B', 'A', 'N', 'K', '_', 'W', 'I', 'D', 'T', 'H', '\0', /* BANK_WIDTH (66751, 66756) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'B', 'A', 'N', 'K', '_', 'H', 'E', 'I', 'G', 'H', 'T', '_', '1', '\0', /* ADDR_SURF_BANK_HEIGHT_1 (66762) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'B', 'A', 'N', 'K', '_', 'H', 'E', 'I', 'G', 'H', 'T', '_', '2', '\0', /* ADDR_SURF_BANK_HEIGHT_2 (66786) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'B', 'A', 'N', 'K', '_', 'H', 'E', 'I', 'G', 'H', 'T', '_', '4', '\0', /* ADDR_SURF_BANK_HEIGHT_4 (66810) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'B', 'A', 'N', 'K', '_', 'H', 'E', 'I', 'G', 'H', 'T', '_', '8', '\0', /* ADDR_SURF_BANK_HEIGHT_8 (66834) */
	'B', 'A', 'N', 'K', '_', 'H', 'E', 'I', 'G', 'H', 'T', '\0', /* BANK_HEIGHT (66858, 66863) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'M', 'A', 'C', 'R', 'O', '_', 'A', 'S', 'P', 'E', 'C', 'T', '_', '1', '\0', /* ADDR_SURF_MACRO_ASPECT_1 (66870) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'M', 'A', 'C', 'R', 'O', '_', 'A', 'S', 'P', 'E', 'C', 'T', '_', '2', '\0', /* ADDR_SURF_MACRO_ASPECT_2 (66895) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'M', 'A', 'C', 'R', 'O', '_', 'A', 'S', 'P', 'E', 'C', 'T', '_', '4', '\0', /* ADDR_SURF_MACRO_ASPECT_4 (66920) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'M', 'A', 'C', 'R', 'O', '_', 'A', 'S', 'P', 'E', 'C', 'T', '_', '8', '\0', /* ADDR_SURF_MACRO_ASPECT_8 (66945) */
	'M', 'A', 'C', 'R', 'O', '_', 'T', 'I', 'L', 'E', '_', 'A', 'S', 'P', 'E', 'C', 'T', '\0', /* MACRO_TILE_ASPECT (66970) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', '2', '_', 'B', 'A', 'N', 'K', '\0', /* ADDR_SURF_2_BANK (66988) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', '4', '_', 'B', 'A', 'N', 'K', '\0', /* ADDR_SURF_4_BANK (67005) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', '8', '_', 'B', 'A', 'N', 'K', '\0', /* ADDR_SURF_8_BANK (67022) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', '1', '6', '_', 'B', 'A', 'N', 'K', '\0', /* ADDR_SURF_16_BANK (67039) */
	'N', 'U', 'M', '_', 'B', 'A', 'N', 'K', 'S', '\0', /* NUM_BANKS (67057) */
	'W', 'I', 'D', 'T', 'H', '_', 'L', 'O', '\0', /* WIDTH_LO (67067) */
	'W', 'I', 'D', 'T', 'H', '_', 'H', 'I', '\0', /* WIDTH_HI (67076) */
	'B', 'A', 'S', 'E', '_', 'L', 'E', 'V', 'E', 'L', '\0', /* BASE_LEVEL (67085) */
	'L', 'A', 'S', 'T', '_', 'L', 'E', 'V', 'E', 'L', '\0', /* LAST_LEVEL (67096) */
	'S', 'W', '_', 'M', 'O', 'D', 'E', '\0', /* SW_MODE (67107) */
	'B', 'C', '_', 'S', 'W', 'I', 'Z', 'Z', 'L', 'E', '_', 'X', 'Y', 'Z', 'W', '\0', /* BC_SWIZZLE_XYZW (67115) */
	'B', 'C', '_', 'S', 'W', 'I', 'Z', 'Z', 'L', 'E', '_', 'X', 'W', 'Y', 'Z', '\0', /* BC_SWIZZLE_XWYZ (67131) */
	'B', 'C', '_', 'S', 'W', 'I', 'Z', 'Z', 'L', 'E', '_', 'W', 'Z', 'Y', 'X', '\0', /* BC_SWIZZLE_WZYX (67147) */
	'B', 'C', '_', 'S', 'W', 'I', 'Z', 'Z', 'L', 'E', '_', 'W', 'X', 'Y', 'Z', '\0', /* BC_SWIZZLE_WXYZ (67163) */
	'B', 'C', '_', 'S', 'W', 'I', 'Z', 'Z', 'L', 'E', '_', 'Z', 'Y', 'X', 'W', '\0', /* BC_SWIZZLE_ZYXW (67179) */
	'B', 'C', '_', 'S', 'W', 'I', 'Z', 'Z', 'L', 'E', '_', 'Y', 'X', 'W', 'Z', '\0', /* BC_SWIZZLE_YXWZ (67195) */
	'B', 'C', '_', 'S', 'W', 'I', 'Z', 'Z', 'L', 'E', '\0', /* BC_SWIZZLE (67211) */
	'B', 'A', 'S', 'E', '_', 'A', 'R', 'R', 'A', 'Y', '\0', /* BASE_ARRAY (67222) */
	'A', 'R', 'R', 'A', 'Y', '_', 'P', 'I', 'T', 'C', 'H', '\0', /* ARRAY_PITCH (67233) */
	'M', 'A', 'X', '_', 'M', 'I', 'P', '\0', /* MAX_MIP (67245) */
	'M', 'I', 'N', '_', 'L', 'O', 'D', '_', 'W', 'A', 'R', 'N', '\0', /* MIN_LOD_WARN (67253) */
	'P', 'E', 'R', 'F', '_', 'M', 'O', 'D', '\0', /* PERF_MOD (67266) */
	'C', 'O', 'R', 'N', 'E', 'R', '_', 'S', 'A', 'M', 'P', 'L', 'E', 'S', '\0', /* CORNER_SAMPLES (67275) */
	'L', 'O', 'D', '_', 'H', 'D', 'W', '_', 'C', 'N', 'T', '_', 'E', 'N', '\0', /* LOD_HDW_CNT_EN (67290) */
	'P', 'R', 'T', '_', 'D', 'E', 'F', 'A', 'U', 'L', 'T', '\0', /* PRT_DEFAULT (67305) */
	'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'B', 'A', 'N', 'K', '_', 'I', 'D', '\0', /* COUNTER_BANK_ID (67317) */
	'I', 'T', 'E', 'R', 'A', 'T', 'E', '_', '2', '5', '6', '\0', /* ITERATE_256 (67333) */
	'M', 'A', 'X', '_', 'U', 'N', 'C', 'O', 'M', 'P', 'R', 'E', 'S', 'S', 'E', 'D', '_', 'B', 'L', 'O', 'C', 'K', '_', 'S', 'I', 'Z', 'E', '\0', /* MAX_UNCOMPRESSED_BLOCK_SIZE (67345) */
	'M', 'A', 'X', '_', 'C', 'O', 'M', 'P', 'R', 'E', 'S', 'S', 'E', 'D', '_', 'B', 'L', 'O', 'C', 'K', '_', 'S', 'I', 'Z', 'E', '\0', /* MAX_COMPRESSED_BLOCK_SIZE (67373) */
	'M', 'E', 'T', 'A', '_', 'P', 'I', 'P', 'E', '_', 'A', 'L', 'I', 'G', 'N', 'E', 'D', '\0', /* META_PIPE_ALIGNED (67399, 67404) */
	'W', 'R', 'I', 'T', 'E', '_', 'C', 'O', 'M', 'P', 'R', 'E', 'S', 'S', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* WRITE_COMPRESS_ENABLE (67417) */
	'C', 'O', 'M', 'P', 'R', 'E', 'S', 'S', 'I', 'O', 'N', '_', 'E', 'N', '\0', /* COMPRESSION_EN (67439) */
	'A', 'L', 'P', 'H', 'A', '_', 'I', 'S', '_', 'O', 'N', '_', 'M', 'S', 'B', '\0', /* ALPHA_IS_ON_MSB (67454) */
	'C', 'O', 'L', 'O', 'R', '_', 'T', 'R', 'A', 'N', 'S', 'F', 'O', 'R', 'M', '\0', /* COLOR_TRANSFORM (67470) */
	'M', 'E', 'T', 'A', '_', 'D', 'A', 'T', 'A', '_', 'A', 'D', 'D', 'R', 'E', 'S', 'S', '_', 'L', 'O', '\0', /* META_DATA_ADDRESS_LO (67486) */
	'C', 'U', '_', 'E', 'N', '\0', /* CU_EN (67507) */
	'W', 'A', 'V', 'E', '_', 'L', 'I', 'M', 'I', 'T', '\0', /* WAVE_LIMIT (67513, 67518) */
	'L', 'O', 'C', 'K', '_', 'L', 'O', 'W', '_', 'T', 'H', 'R', 'E', 'S', 'H', 'O', 'L', 'D', '\0', /* LOCK_LOW_THRESHOLD (67524) */
	'M', 'E', 'M', '_', 'B', 'A', 'S', 'E', '\0', /* MEM_BASE (67543) */
	'V', 'G', 'P', 'R', 'S', '\0', /* VGPRS (67552) */
	'S', 'G', 'P', 'R', 'S', '\0', /* SGPRS (67558) */
	'F', 'P', '_', '3', '2', '_', 'D', 'E', 'N', 'O', 'R', 'M', 'S', '\0', /* FP_32_DENORMS (67564) */
	'F', 'P', '_', '6', '4', '_', 'D', 'E', 'N', 'O', 'R', 'M', 'S', '\0', /* FP_64_DENORMS (67578) */
	'F', 'P', '_', 'A', 'L', 'L', '_', 'D', 'E', 'N', 'O', 'R', 'M', 'S', '\0', /* FP_ALL_DENORMS (67592) */
	'F', 'L', 'O', 'A', 'T', '_', 'M', 'O', 'D', 'E', '\0', /* FLOAT_MODE (67607) */
	'I', 'E', 'E', 'E', '_', 'M', 'O', 'D', 'E', '\0', /* IEEE_MODE (67618) */
	'C', 'U', '_', 'G', 'R', 'O', 'U', 'P', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* CU_GROUP_DISABLE (67628) */
	'M', 'E', 'M', '_', 'O', 'R', 'D', 'E', 'R', 'E', 'D', '\0', /* MEM_ORDERED (67645) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'E', 'N', '\0', /* SCRATCH_EN (67657) */
	'U', 'S', 'E', 'R', '_', 'S', 'G', 'P', 'R', '\0', /* USER_SGPR (67668) */
	'T', 'R', 'A', 'P', '_', 'P', 'R', 'E', 'S', 'E', 'N', 'T', '\0', /* TRAP_PRESENT (67678) */
	'W', 'A', 'V', 'E', '_', 'C', 'N', 'T', '_', 'E', 'N', '\0', /* WAVE_CNT_EN (67691) */
	'E', 'X', 'T', 'R', 'A', '_', 'L', 'D', 'S', '_', 'S', 'I', 'Z', 'E', '\0', /* EXTRA_LDS_SIZE (67703) */
	'L', 'O', 'A', 'D', '_', 'C', 'O', 'L', 'L', 'I', 'S', 'I', 'O', 'N', '_', 'W', 'A', 'V', 'E', 'I', 'D', '\0', /* LOAD_COLLISION_WAVEID (67718) */
	'L', 'O', 'A', 'D', '_', 'I', 'N', 'T', 'R', 'A', 'W', 'A', 'V', 'E', '_', 'C', 'O', 'L', 'L', 'I', 'S', 'I', 'O', 'N', '\0', /* LOAD_INTRAWAVE_COLLISION (67740) */
	'U', 'S', 'E', 'R', '_', 'S', 'G', 'P', 'R', '_', 'M', 'S', 'B', '\0', /* USER_SGPR_MSB (67765) */
	'S', 'H', 'A', 'R', 'E', 'D', '_', 'V', 'G', 'P', 'R', '_', 'C', 'N', 'T', '\0', /* SHARED_VGPR_CNT (67779) */
	'S', 'O', 'F', 'T', '_', 'G', 'R', 'O', 'U', 'P', 'I', 'N', 'G', '_', 'E', 'N', '\0', /* SOFT_GROUPING_EN (67795) */
	'N', 'U', 'M', 'B', 'E', 'R', '_', 'O', 'F', '_', 'R', 'E', 'Q', 'U', 'E', 'S', 'T', 'S', '_', 'P', 'E', 'R', '_', 'C', 'U', '\0', /* NUMBER_OF_REQUESTS_PER_CU (67812) */
	'S', 'O', 'F', 'T', '_', 'G', 'R', 'O', 'U', 'P', 'I', 'N', 'G', '_', 'A', 'L', 'L', 'O', 'C', 'A', 'T', 'I', 'O', 'N', '_', 'T', 'I', 'M', 'E', 'O', 'U', 'T', '\0', /* SOFT_GROUPING_ALLOCATION_TIMEOUT (67838) */
	'H', 'A', 'R', 'D', '_', 'L', 'O', 'C', 'K', '_', 'H', 'Y', 'S', 'T', 'E', 'R', 'E', 'S', 'I', 'S', '\0', /* HARD_LOCK_HYSTERESIS (67871) */
	'H', 'A', 'R', 'D', '_', 'L', 'O', 'C', 'K', '_', 'L', 'O', 'W', '_', 'T', 'H', 'R', 'E', 'S', 'H', 'O', 'L', 'D', '\0', /* HARD_LOCK_LOW_THRESHOLD (67892) */
	'P', 'R', 'O', 'D', 'U', 'C', 'E', 'R', '_', 'R', 'E', 'Q', 'U', 'E', 'S', 'T', '_', 'L', 'O', 'C', 'K', 'O', 'U', 'T', '\0', /* PRODUCER_REQUEST_LOCKOUT (67916) */
	'G', 'L', 'O', 'B', 'A', 'L', '_', 'S', 'C', 'A', 'N', 'N', 'I', 'N', 'G', '_', 'E', 'N', '\0', /* GLOBAL_SCANNING_EN (67941) */
	'A', 'L', 'L', 'O', 'C', 'A', 'T', 'I', 'O', 'N', '_', 'R', 'A', 'T', 'E', '_', 'T', 'H', 'R', 'O', 'T', 'T', 'L', 'I', 'N', 'G', '_', 'T', 'H', 'R', 'E', 'S', 'H', 'O', 'L', 'D', '\0', /* ALLOCATION_RATE_THROTTLING_THRESHOLD (67960) */
	'T', 'O', 'T', 'A', 'L', '_', 'W', 'A', 'V', 'E', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', 'E', 'R', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TOTAL_WAVE_COUNT_HIER_SELECT (67997) */
	'P', 'E', 'R', '_', 'T', 'Y', 'P', 'E', '_', 'W', 'A', 'V', 'E', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', 'E', 'R', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PER_TYPE_WAVE_COUNT_HIER_SELECT (68026) */
	'G', 'R', 'O', 'U', 'P', '_', 'U', 'P', 'D', 'A', 'T', 'E', '_', 'E', 'N', '\0', /* GROUP_UPDATE_EN (68058) */
	'T', 'O', 'T', 'A', 'L', '_', 'W', 'A', 'V', 'E', '_', 'C', 'O', 'U', 'N', 'T', '_', 'C', 'O', 'E', 'F', 'F', 'I', 'C', 'I', 'E', 'N', 'T', '\0', /* TOTAL_WAVE_COUNT_COEFFICIENT (68074) */
	'P', 'E', 'R', '_', 'T', 'Y', 'P', 'E', '_', 'W', 'A', 'V', 'E', '_', 'C', 'O', 'U', 'N', 'T', '_', 'C', 'O', 'E', 'F', 'F', 'I', 'C', 'I', 'E', 'N', 'T', '\0', /* PER_TYPE_WAVE_COUNT_COEFFICIENT (68103) */
	'C', 'O', 'N', 'T', 'R', 'I', 'B', 'U', 'T', 'I', 'O', 'N', '\0', /* CONTRIBUTION (68135) */
	'V', 'G', 'P', 'R', '_', 'C', 'O', 'M', 'P', '_', 'C', 'N', 'T', '\0', /* VGPR_COMP_CNT (68148) */
	'C', 'U', '_', 'G', 'R', 'O', 'U', 'P', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* CU_GROUP_ENABLE (68162) */
	'O', 'C', '_', 'L', 'D', 'S', '_', 'E', 'N', '\0', /* OC_LDS_EN (68178) */
	'S', 'O', '_', 'B', 'A', 'S', 'E', '0', '_', 'E', 'N', '\0', /* SO_BASE0_EN (68188) */
	'S', 'O', '_', 'B', 'A', 'S', 'E', '1', '_', 'E', 'N', '\0', /* SO_BASE1_EN (68200) */
	'S', 'O', '_', 'B', 'A', 'S', 'E', '2', '_', 'E', 'N', '\0', /* SO_BASE2_EN (68212) */
	'S', 'O', '_', 'B', 'A', 'S', 'E', '3', '_', 'E', 'N', '\0', /* SO_BASE3_EN (68224) */
	'S', 'O', '_', 'E', 'N', '\0', /* SO_EN (68236) */
	'P', 'C', '_', 'B', 'A', 'S', 'E', '_', 'E', 'N', '\0', /* PC_BASE_EN (68242) */
	'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'D', 'R', 'A', 'W', '_', 'E', 'N', '\0', /* DISPATCH_DRAW_EN (68253) */
	'S', 'K', 'I', 'P', '_', 'U', 'S', 'G', 'P', 'R', '0', '\0', /* SKIP_USGPR0 (68270) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'L', 'A', 'T', 'E', '_', 'A', 'L', 'L', 'O', 'C', '_', 'G', 'S', '\0', /* SPI_SHADER_LATE_ALLOC_GS (68282) */
	'G', 'R', 'O', 'U', 'P', '_', 'F', 'I', 'F', 'O', '_', 'D', 'E', 'P', 'T', 'H', '\0', /* GROUP_FIFO_DEPTH (68307) */
	'W', 'G', 'P', '_', 'M', 'O', 'D', 'E', '\0', /* WGP_MODE (68324) */
	'G', 'S', '_', 'V', 'G', 'P', 'R', '_', 'C', 'O', 'M', 'P', '_', 'C', 'N', 'T', '\0', /* GS_VGPR_COMP_CNT (68333) */
	'E', 'S', '_', 'V', 'G', 'P', 'R', '_', 'C', 'O', 'M', 'P', '_', 'C', 'N', 'T', '\0', /* ES_VGPR_COMP_CNT (68350) */
	'L', 'S', '_', 'V', 'G', 'P', 'R', '_', 'C', 'O', 'M', 'P', '_', 'C', 'N', 'T', '\0', /* LS_VGPR_COMP_CNT (68367) */
	'T', 'G', '_', 'S', 'I', 'Z', 'E', '_', 'E', 'N', '\0', /* TG_SIZE_EN (68384) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'E', 'N', '\0', /* COMPUTE_SHADER_EN (68395) */
	'P', 'A', 'R', 'T', 'I', 'A', 'L', '_', 'T', 'G', '_', 'E', 'N', '\0', /* PARTIAL_TG_EN (68413) */
	'F', 'O', 'R', 'C', 'E', '_', 'S', 'T', 'A', 'R', 'T', '_', 'A', 'T', '_', '0', '0', '0', '\0', /* FORCE_START_AT_000 (68427) */
	'O', 'R', 'D', 'E', 'R', 'E', 'D', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'E', 'N', 'B', 'L', '\0', /* ORDERED_APPEND_ENBL (68446) */
	'O', 'R', 'D', 'E', 'R', 'E', 'D', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'M', 'O', 'D', 'E', '\0', /* ORDERED_APPEND_MODE (68466) */
	'U', 'S', 'E', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'D', 'I', 'M', 'E', 'N', 'S', 'I', 'O', 'N', 'S', '\0', /* USE_THREAD_DIMENSIONS (68486) */
	'O', 'R', 'D', 'E', 'R', '_', 'M', 'O', 'D', 'E', '\0', /* ORDER_MODE (68508) */
	'S', 'C', 'A', 'L', 'A', 'R', '_', 'L', '1', '_', 'I', 'N', 'V', '_', 'V', 'O', 'L', '\0', /* SCALAR_L1_INV_VOL (68519, 68533) */
	'V', 'E', 'C', 'T', 'O', 'R', '_', 'L', '1', '_', 'I', 'N', 'V', '_', 'V', 'O', 'L', '\0', /* VECTOR_L1_INV_VOL (68537) */
	'T', 'U', 'N', 'N', 'E', 'L', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* TUNNEL_ENABLE (68555) */
	'R', 'E', 'S', 'T', 'O', 'R', 'E', '\0', /* RESTORE (68569) */
	'C', 'S', '_', 'W', '3', '2', '_', 'E', 'N', '\0', /* CS_W32_EN (68577) */
	'N', 'U', 'M', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'F', 'U', 'L', 'L', '\0', /* NUM_THREAD_FULL (68587, 68598) */
	'N', 'U', 'M', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'P', 'A', 'R', 'T', 'I', 'A', 'L', '\0', /* NUM_THREAD_PARTIAL (68603) */
	'B', 'U', 'L', 'K', 'Y', '\0', /* BULKY (68622) */
	'T', 'G', 'I', 'D', '_', 'X', '_', 'E', 'N', '\0', /* TGID_X_EN (68628) */
	'T', 'G', 'I', 'D', '_', 'Y', '_', 'E', 'N', '\0', /* TGID_Y_EN (68638) */
	'T', 'G', 'I', 'D', '_', 'Z', '_', 'E', 'N', '\0', /* TGID_Z_EN (68648) */
	'T', 'I', 'D', 'I', 'G', '_', 'C', 'O', 'M', 'P', '_', 'C', 'N', 'T', '\0', /* TIDIG_COMP_CNT (68658) */
	'E', 'X', 'C', 'P', '_', 'E', 'N', '_', 'M', 'S', 'B', '\0', /* EXCP_EN_MSB (68673) */
	'W', 'A', 'V', 'E', 'S', '_', 'P', 'E', 'R', '_', 'S', 'H', '\0', /* WAVES_PER_SH (68685) */
	'T', 'G', '_', 'P', 'E', 'R', '_', 'C', 'U', '\0', /* TG_PER_CU (68698) */
	'L', 'O', 'C', 'K', '_', 'T', 'H', 'R', 'E', 'S', 'H', 'O', 'L', 'D', '\0', /* LOCK_THRESHOLD (68708) */
	'S', 'I', 'M', 'D', '_', 'D', 'E', 'S', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* SIMD_DEST_CNTL (68723) */
	'F', 'O', 'R', 'C', 'E', '_', 'S', 'I', 'M', 'D', '_', 'D', 'I', 'S', 'T', '\0', /* FORCE_SIMD_DIST (68738) */
	'C', 'U', '_', 'G', 'R', 'O', 'U', 'P', '_', 'C', 'O', 'U', 'N', 'T', '\0', /* CU_GROUP_COUNT (68754) */
	'W', 'A', 'V', 'E', 'S', '\0', /* WAVES (68769) */
	'W', 'A', 'V', 'E', 'S', 'I', 'Z', 'E', '\0', /* WAVESIZE (68775) */
	'S', 'E', 'N', 'D', '_', 'S', 'E', 'I', 'D', '\0', /* SEND_SEID (68784) */
	'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '3', '\0', /* RESERVED3 (68794) */
	'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '4', '\0', /* RESERVED4 (68804) */
	'W', 'A', 'V', 'E', '_', 'I', 'D', '_', 'B', 'A', 'S', 'E', '\0', /* WAVE_ID_BASE (68814) */
	'D', 'E', 'D', 'I', 'C', 'A', 'T', 'E', 'D', '_', 'P', 'R', 'E', 'A', 'L', 'L', 'O', 'C', 'A', 'T', 'I', 'O', 'N', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'L', 'I', 'M', 'I', 'T', '\0', /* DEDICATED_PREALLOCATION_BUFFER_LIMIT (68827) */
	'P', 'A', 'Y', 'L', 'O', 'A', 'D', '\0', /* PAYLOAD (68864, 68867) */
	'I', 'S', '_', 'E', 'V', 'E', 'N', 'T', '\0', /* IS_EVENT (68872) */
	'I', 'S', '_', 'S', 'T', 'A', 'T', 'E', '\0', /* IS_STATE (68881) */
	'O', 'F', 'F', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* OFF_DELAY (68890) */
	'D', 'E', 'P', 'T', 'H', '_', 'C', 'L', 'E', 'A', 'R', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* DEPTH_CLEAR_ENABLE (68900) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'C', 'L', 'E', 'A', 'R', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* STENCIL_CLEAR_ENABLE (68919) */
	'D', 'E', 'P', 'T', 'H', '_', 'C', 'O', 'P', 'Y', '\0', /* DEPTH_COPY (68940) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'C', 'O', 'P', 'Y', '\0', /* STENCIL_COPY (68951) */
	'R', 'E', 'S', 'U', 'M', 'M', 'A', 'R', 'I', 'Z', 'E', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* RESUMMARIZE_ENABLE (68964) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'C', 'O', 'M', 'P', 'R', 'E', 'S', 'S', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* STENCIL_COMPRESS_DISABLE (68983) */
	'D', 'E', 'P', 'T', 'H', '_', 'C', 'O', 'M', 'P', 'R', 'E', 'S', 'S', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* DEPTH_COMPRESS_DISABLE (69008) */
	'C', 'O', 'P', 'Y', '_', 'C', 'E', 'N', 'T', 'R', 'O', 'I', 'D', '\0', /* COPY_CENTROID (69031) */
	'C', 'O', 'P', 'Y', '_', 'S', 'A', 'M', 'P', 'L', 'E', '\0', /* COPY_SAMPLE (69045) */
	'D', 'E', 'C', 'O', 'M', 'P', 'R', 'E', 'S', 'S', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* DECOMPRESS_ENABLE (69057) */
	'Z', 'P', 'A', 'S', 'S', '_', 'I', 'N', 'C', 'R', 'E', 'M', 'E', 'N', 'T', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* ZPASS_INCREMENT_DISABLE (69075) */
	'P', 'E', 'R', 'F', 'E', 'C', 'T', '_', 'Z', 'P', 'A', 'S', 'S', '_', 'C', 'O', 'U', 'N', 'T', 'S', '\0', /* PERFECT_ZPASS_COUNTS (69099) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'C', 'O', 'N', 'S', 'E', 'R', 'V', 'A', 'T', 'I', 'V', 'E', '_', 'Z', 'P', 'A', 'S', 'S', '_', 'C', 'O', 'U', 'N', 'T', 'S', '\0', /* DISABLE_CONSERVATIVE_ZPASS_COUNTS (69120) */
	'E', 'N', 'H', 'A', 'N', 'C', 'E', 'D', '_', 'C', 'O', 'N', 'S', 'E', 'R', 'V', 'A', 'T', 'I', 'V', 'E', '_', 'Z', 'P', 'A', 'S', 'S', '_', 'C', 'O', 'U', 'N', 'T', 'S', '\0', /* ENHANCED_CONSERVATIVE_ZPASS_COUNTS (69154) */
	'S', 'A', 'M', 'P', 'L', 'E', '_', 'R', 'A', 'T', 'E', '\0', /* SAMPLE_RATE (69189) */
	'Z', 'P', 'A', 'S', 'S', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* ZPASS_ENABLE (69201) */
	'Z', 'F', 'A', 'I', 'L', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* ZFAIL_ENABLE (69214) */
	'S', 'F', 'A', 'I', 'L', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* SFAIL_ENABLE (69227) */
	'D', 'B', 'F', 'A', 'I', 'L', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* DBFAIL_ENABLE (69240) */
	'S', 'L', 'I', 'C', 'E', '_', 'E', 'V', 'E', 'N', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* SLICE_EVEN_ENABLE (69254) */
	'S', 'L', 'I', 'C', 'E', '_', 'O', 'D', 'D', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* SLICE_ODD_ENABLE (69272) */
	'S', 'L', 'I', 'C', 'E', '_', 'S', 'T', 'A', 'R', 'T', '\0', /* SLICE_START (69289, 69295) */
	'S', 'L', 'I', 'C', 'E', '_', 'S', 'T', 'A', 'R', 'T', '_', 'H', 'I', '\0', /* SLICE_START_HI (69301) */
	'S', 'L', 'I', 'C', 'E', '_', 'M', 'A', 'X', '\0', /* SLICE_MAX (69316) */
	'Z', '_', 'R', 'E', 'A', 'D', '_', 'O', 'N', 'L', 'Y', '\0', /* Z_READ_ONLY (69326) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'R', 'E', 'A', 'D', '_', 'O', 'N', 'L', 'Y', '\0', /* STENCIL_READ_ONLY (69338) */
	'M', 'I', 'P', 'I', 'D', '\0', /* MIPID (69356) */
	'S', 'L', 'I', 'C', 'E', '_', 'M', 'A', 'X', '_', 'H', 'I', '\0', /* SLICE_MAX_HI (69362) */
	'F', 'O', 'R', 'C', 'E', '_', 'O', 'F', 'F', '\0', /* FORCE_OFF (69375) */
	'F', 'O', 'R', 'C', 'E', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* FORCE_ENABLE (69385) */
	'F', 'O', 'R', 'C', 'E', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* FORCE_DISABLE (69398) */
	'F', 'O', 'R', 'C', 'E', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '\0', /* FORCE_RESERVED (69412) */
	'F', 'O', 'R', 'C', 'E', '_', 'H', 'I', 'Z', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* FORCE_HIZ_ENABLE (69427, 69435) */
	'F', 'O', 'R', 'C', 'E', '_', 'H', 'I', 'S', '_', 'E', 'N', 'A', 'B', 'L', 'E', '0', '\0', /* FORCE_HIS_ENABLE0 (69444, 69454) */
	'F', 'O', 'R', 'C', 'E', '_', 'H', 'I', 'S', '_', 'E', 'N', 'A', 'B', 'L', 'E', '1', '\0', /* FORCE_HIS_ENABLE1 (69462, 69472) */
	'F', 'O', 'R', 'C', 'E', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'Z', '_', 'O', 'R', 'D', 'E', 'R', '\0', /* FORCE_SHADER_Z_ORDER (69480, 69493) */
	'F', 'A', 'S', 'T', '_', 'Z', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* FAST_Z_DISABLE (69501) */
	'F', 'A', 'S', 'T', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* FAST_STENCIL_DISABLE (69516) */
	'N', 'O', 'O', 'P', '_', 'C', 'U', 'L', 'L', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* NOOP_CULL_DISABLE (69537) */
	'F', 'O', 'R', 'C', 'E', '_', 'C', 'O', 'L', 'O', 'R', '_', 'K', 'I', 'L', 'L', '\0', /* FORCE_COLOR_KILL (69555, 69567) */
	'F', 'O', 'R', 'C', 'E', '_', 'Z', '_', 'R', 'E', 'A', 'D', '\0', /* FORCE_Z_READ (69572) */
	'F', 'O', 'R', 'C', 'E', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'R', 'E', 'A', 'D', '\0', /* FORCE_STENCIL_READ (69585) */
	'F', 'O', 'R', 'C', 'E', '_', 'F', 'U', 'L', 'L', '_', 'Z', '_', 'R', 'A', 'N', 'G', 'E', '\0', /* FORCE_FULL_Z_RANGE (69604) */
	'F', 'O', 'R', 'C', 'E', '_', 'Q', 'C', '_', 'S', 'M', 'A', 'S', 'K', '_', 'C', 'O', 'N', 'F', 'L', 'I', 'C', 'T', '\0', /* FORCE_QC_SMASK_CONFLICT (69623) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'V', 'I', 'E', 'W', 'P', 'O', 'R', 'T', '_', 'C', 'L', 'A', 'M', 'P', '\0', /* DISABLE_VIEWPORT_CLAMP (69647) */
	'I', 'G', 'N', 'O', 'R', 'E', '_', 'S', 'C', '_', 'Z', 'R', 'A', 'N', 'G', 'E', '\0', /* IGNORE_SC_ZRANGE (69670) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'F', 'U', 'L', 'L', 'Y', '_', 'C', 'O', 'V', 'E', 'R', 'E', 'D', '\0', /* DISABLE_FULLY_COVERED (69687) */
	'F', 'O', 'R', 'C', 'E', '_', 'S', 'U', 'M', 'M', '_', 'O', 'F', 'F', '\0', /* FORCE_SUMM_OFF (69709) */
	'F', 'O', 'R', 'C', 'E', '_', 'S', 'U', 'M', 'M', '_', 'M', 'I', 'N', 'Z', '\0', /* FORCE_SUMM_MINZ (69724) */
	'F', 'O', 'R', 'C', 'E', '_', 'S', 'U', 'M', 'M', '_', 'M', 'A', 'X', 'Z', '\0', /* FORCE_SUMM_MAXZ (69740) */
	'F', 'O', 'R', 'C', 'E', '_', 'S', 'U', 'M', 'M', '_', 'B', 'O', 'T', 'H', '\0', /* FORCE_SUMM_BOTH (69756) */
	'F', 'O', 'R', 'C', 'E', '_', 'Z', '_', 'L', 'I', 'M', 'I', 'T', '_', 'S', 'U', 'M', 'M', '\0', /* FORCE_Z_LIMIT_SUMM (69772) */
	'M', 'A', 'X', '_', 'T', 'I', 'L', 'E', 'S', '_', 'I', 'N', '_', 'D', 'T', 'T', '\0', /* MAX_TILES_IN_DTT (69791) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'T', 'I', 'L', 'E', '_', 'R', 'A', 'T', 'E', '_', 'T', 'I', 'L', 'E', 'S', '\0', /* DISABLE_TILE_RATE_TILES (69808) */
	'F', 'O', 'R', 'C', 'E', '_', 'Z', '_', 'D', 'I', 'R', 'T', 'Y', '\0', /* FORCE_Z_DIRTY (69832, 69840) */
	'F', 'O', 'R', 'C', 'E', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'D', 'I', 'R', 'T', 'Y', '\0', /* FORCE_STENCIL_DIRTY (69846) */
	'F', 'O', 'R', 'C', 'E', '_', 'Z', '_', 'V', 'A', 'L', 'I', 'D', '\0', /* FORCE_Z_VALID (69866) */
	'F', 'O', 'R', 'C', 'E', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'V', 'A', 'L', 'I', 'D', '\0', /* FORCE_STENCIL_VALID (69880) */
	'P', 'R', 'E', 'S', 'E', 'R', 'V', 'E', '_', 'C', 'O', 'M', 'P', 'R', 'E', 'S', 'S', 'I', 'O', 'N', '\0', /* PRESERVE_COMPRESSION (69900, 69909) */
	'P', 'S', 'L', 'C', '_', 'A', 'U', 'T', 'O', '\0', /* PSLC_AUTO (69921) */
	'P', 'S', 'L', 'C', '_', 'O', 'N', '_', 'H', 'A', 'N', 'G', '_', 'O', 'N', 'L', 'Y', '\0', /* PSLC_ON_HANG_ONLY (69931) */
	'P', 'S', 'L', 'C', '_', 'A', 'S', 'A', 'P', '\0', /* PSLC_ASAP (69949) */
	'P', 'S', 'L', 'C', '_', 'C', 'O', 'U', 'N', 'T', 'D', 'O', 'W', 'N', '\0', /* PSLC_COUNTDOWN (69959) */
	'P', 'A', 'R', 'T', 'I', 'A', 'L', '_', 'S', 'Q', 'U', 'A', 'D', '_', 'L', 'A', 'U', 'N', 'C', 'H', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* PARTIAL_SQUAD_LAUNCH_CONTROL (69974) */
	'P', 'A', 'R', 'T', 'I', 'A', 'L', '_', 'S', 'Q', 'U', 'A', 'D', '_', 'L', 'A', 'U', 'N', 'C', 'H', '_', 'C', 'O', 'U', 'N', 'T', 'D', 'O', 'W', 'N', '\0', /* PARTIAL_SQUAD_LAUNCH_COUNTDOWN (70003) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'Z', 'M', 'A', 'S', 'K', '_', 'E', 'X', 'P', 'C', 'L', 'E', 'A', 'R', '_', 'O', 'P', 'T', 'I', 'M', 'I', 'Z', 'A', 'T', 'I', 'O', 'N', '\0', /* DISABLE_ZMASK_EXPCLEAR_OPTIMIZATION (70034) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'S', 'M', 'E', 'M', '_', 'E', 'X', 'P', 'C', 'L', 'E', 'A', 'R', '_', 'O', 'P', 'T', 'I', 'M', 'I', 'Z', 'A', 'T', 'I', 'O', 'N', '\0', /* DISABLE_SMEM_EXPCLEAR_OPTIMIZATION (70070) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'C', 'O', 'L', 'O', 'R', '_', 'O', 'N', '_', 'V', 'A', 'L', 'I', 'D', 'A', 'T', 'I', 'O', 'N', '\0', /* DISABLE_COLOR_ON_VALIDATION (70105) */
	'D', 'E', 'C', 'O', 'M', 'P', 'R', 'E', 'S', 'S', '_', 'Z', '_', 'O', 'N', '_', 'F', 'L', 'U', 'S', 'H', '\0', /* DECOMPRESS_Z_ON_FLUSH (70133) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'R', 'E', 'G', '_', 'S', 'N', 'O', 'O', 'P', '\0', /* DISABLE_REG_SNOOP (70155) */
	'D', 'E', 'P', 'T', 'H', '_', 'B', 'O', 'U', 'N', 'D', 'S', '_', 'H', 'I', 'E', 'R', '_', 'D', 'E', 'P', 'T', 'H', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* DEPTH_BOUNDS_HIER_DEPTH_DISABLE (70173) */
	'S', 'E', 'P', 'A', 'R', 'A', 'T', 'E', '_', 'H', 'I', 'Z', 'S', '_', 'F', 'U', 'N', 'C', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* SEPARATE_HIZS_FUNC_ENABLE (70205) */
	'F', 'R', 'A', 'G', '_', 'N', 'E', 'V', 'E', 'R', '\0', /* FRAG_NEVER (70231) */
	'F', 'R', 'A', 'G', '_', 'L', 'E', 'S', 'S', '\0', /* FRAG_LESS (70242) */
	'F', 'R', 'A', 'G', '_', 'E', 'Q', 'U', 'A', 'L', '\0', /* FRAG_EQUAL (70252) */
	'F', 'R', 'A', 'G', '_', 'L', 'E', 'Q', 'U', 'A', 'L', '\0', /* FRAG_LEQUAL (70263) */
	'F', 'R', 'A', 'G', '_', 'G', 'R', 'E', 'A', 'T', 'E', 'R', '\0', /* FRAG_GREATER (70275) */
	'F', 'R', 'A', 'G', '_', 'N', 'O', 'T', 'E', 'Q', 'U', 'A', 'L', '\0', /* FRAG_NOTEQUAL (70288) */
	'F', 'R', 'A', 'G', '_', 'G', 'E', 'Q', 'U', 'A', 'L', '\0', /* FRAG_GEQUAL (70302) */
	'F', 'R', 'A', 'G', '_', 'A', 'L', 'W', 'A', 'Y', 'S', '\0', /* FRAG_ALWAYS (70314, 70319) */
	'H', 'I', 'Z', '_', 'Z', 'F', 'U', 'N', 'C', '\0', /* HIZ_ZFUNC (70326, 70330) */
	'H', 'I', 'S', '_', 'S', 'F', 'U', 'N', 'C', '_', 'F', 'F', '\0', /* HIS_SFUNC_FF (70336) */
	'H', 'I', 'S', '_', 'S', 'F', 'U', 'N', 'C', '_', 'B', 'F', '\0', /* HIS_SFUNC_BF (70349) */
	'P', 'R', 'E', 'S', 'E', 'R', 'V', 'E', '_', 'Z', 'R', 'A', 'N', 'G', 'E', '\0', /* PRESERVE_ZRANGE (70362) */
	'P', 'R', 'E', 'S', 'E', 'R', 'V', 'E', '_', 'S', 'R', 'E', 'S', 'U', 'L', 'T', 'S', '\0', /* PRESERVE_SRESULTS (70378) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'F', 'A', 'S', 'T', '_', 'P', 'A', 'S', 'S', '\0', /* DISABLE_FAST_PASS (70396) */
	'A', 'L', 'L', 'O', 'W', '_', 'P', 'A', 'R', 'T', 'I', 'A', 'L', '_', 'R', 'E', 'S', '_', 'H', 'I', 'E', 'R', '_', 'K', 'I', 'L', 'L', '\0', /* ALLOW_PARTIAL_RES_HIER_KILL (70414) */
	'X', '_', 'M', 'A', 'X', '\0', /* X_MAX (70442) */
	'T', 'L', '_', 'X', '\0', /* TL_X (70448) */
	'T', 'L', '_', 'Y', '\0', /* TL_Y (70453) */
	'B', 'R', '_', 'X', '\0', /* BR_X (70458) */
	'B', 'R', '_', 'Y', '\0', /* BR_Y (70463) */
	'F', 'O', 'R', 'C', 'E', '_', 'O', 'N', '\0', /* FORCE_ON (70468) */
	'P', 'U', 'N', 'C', 'H', 'O', 'U', 'T', '_', 'M', 'O', 'D', 'E', '\0', /* PUNCHOUT_MODE (70477) */
	'P', 'O', 'P', 'S', '_', 'D', 'R', 'A', 'I', 'N', '_', 'P', 'S', '_', 'O', 'N', '_', 'O', 'V', 'E', 'R', 'L', 'A', 'P', '\0', /* POPS_DRAIN_PS_ON_OVERLAP (70491) */
	'D', 'I', 'S', 'A', 'L', 'L', 'O', 'W', '_', 'O', 'V', 'E', 'R', 'F', 'L', 'O', 'W', '\0', /* DISALLOW_OVERFLOW (70516) */
	'F', 'I', 'E', 'L', 'D', '_', '1', '\0', /* FIELD_1 (70534) */
	'F', 'I', 'E', 'L', 'D', '_', '2', '\0', /* FIELD_2 (70542) */
	'F', 'I', 'E', 'L', 'D', '_', '3', '\0', /* FIELD_3 (70550) */
	'F', 'I', 'E', 'L', 'D', '_', '4', '\0', /* FIELD_4 (70558) */
	'F', 'I', 'E', 'L', 'D', '_', '5', '\0', /* FIELD_5 (70566) */
	'F', 'I', 'E', 'L', 'D', '_', '6', '\0', /* FIELD_6 (70574) */
	'F', 'I', 'E', 'L', 'D', '_', '7', '\0', /* FIELD_7 (70582) */
	'Z', '_', 'I', 'N', 'V', 'A', 'L', 'I', 'D', '\0', /* Z_INVALID (70590) */
	'Z', '_', '1', '6', '\0', /* Z_16 (70600) */
	'Z', '_', '2', '4', '\0', /* Z_24 (70605) */
	'Z', '_', '3', '2', '_', 'F', 'L', 'O', 'A', 'T', '\0', /* Z_32_FLOAT (70610) */
	'N', 'U', 'M', '_', 'S', 'A', 'M', 'P', 'L', 'E', 'S', '\0', /* NUM_SAMPLES (70621) */
	'F', 'A', 'U', 'L', 'T', '_', 'Z', 'E', 'R', 'O', '\0', /* FAULT_ZERO (70633) */
	'F', 'A', 'U', 'L', 'T', '_', 'O', 'N', 'E', '\0', /* FAULT_ONE (70644) */
	'F', 'A', 'U', 'L', 'T', '_', 'F', 'A', 'I', 'L', '\0', /* FAULT_FAIL (70654) */
	'F', 'A', 'U', 'L', 'T', '_', 'P', 'A', 'S', 'S', '\0', /* FAULT_PASS (70665) */
	'F', 'A', 'U', 'L', 'T', '_', 'B', 'E', 'H', 'A', 'V', 'I', 'O', 'R', '\0', /* FAULT_BEHAVIOR (70676) */
	'I', 'T', 'E', 'R', 'A', 'T', 'E', '_', 'F', 'L', 'U', 'S', 'H', '\0', /* ITERATE_FLUSH (70691) */
	'P', 'A', 'R', 'T', 'I', 'A', 'L', 'L', 'Y', '_', 'R', 'E', 'S', 'I', 'D', 'E', 'N', 'T', '\0', /* PARTIALLY_RESIDENT (70705) */
	'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', 'F', 'I', 'E', 'L', 'D', '_', '1', '\0', /* RESERVED_FIELD_1 (70724) */
	'M', 'A', 'X', 'M', 'I', 'P', '\0', /* MAXMIP (70741) */
	'D', 'E', 'C', 'O', 'M', 'P', 'R', 'E', 'S', 'S', '_', 'O', 'N', '_', 'N', '_', 'Z', 'P', 'L', 'A', 'N', 'E', 'S', '\0', /* DECOMPRESS_ON_N_ZPLANES (70748) */
	'A', 'L', 'L', 'O', 'W', '_', 'E', 'X', 'P', 'C', 'L', 'E', 'A', 'R', '\0', /* ALLOW_EXPCLEAR (70772) */
	'R', 'E', 'A', 'D', '_', 'S', 'I', 'Z', 'E', '\0', /* READ_SIZE (70787) */
	'T', 'I', 'L', 'E', '_', 'S', 'U', 'R', 'F', 'A', 'C', 'E', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* TILE_SURFACE_ENABLE (70797) */
	'Z', 'R', 'A', 'N', 'G', 'E', '_', 'P', 'R', 'E', 'C', 'I', 'S', 'I', 'O', 'N', '\0', /* ZRANGE_PRECISION (70817) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'I', 'N', 'V', 'A', 'L', 'I', 'D', '\0', /* STENCIL_INVALID (70834) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', '8', '\0', /* STENCIL_8 (70850) */
	'T', 'I', 'L', 'E', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* TILE_STENCIL_DISABLE (70860) */
	'C', 'A', 'C', 'H', 'E', '_', 'L', 'R', 'U', '_', 'W', 'R', '\0', /* CACHE_LRU_WR (70881) */
	'C', 'A', 'C', 'H', 'E', '_', 'S', 'T', 'R', 'E', 'A', 'M', '\0', /* CACHE_STREAM (70894) */
	'C', 'A', 'C', 'H', 'E', '_', 'B', 'Y', 'P', 'A', 'S', 'S', '\0', /* CACHE_BYPASS (70907) */
	'U', 'N', 'C', 'A', 'C', 'H', 'E', 'D', '_', 'W', 'R', '\0', /* UNCACHED_WR (70920) */
	'Z', '_', 'W', 'R', '_', 'P', 'O', 'L', 'I', 'C', 'Y', '\0', /* Z_WR_POLICY (70932) */
	'S', '_', 'W', 'R', '_', 'P', 'O', 'L', 'I', 'C', 'Y', '\0', /* S_WR_POLICY (70944) */
	'H', 'T', 'I', 'L', 'E', '_', 'W', 'R', '_', 'P', 'O', 'L', 'I', 'C', 'Y', '\0', /* HTILE_WR_POLICY (70956) */
	'Z', 'P', 'C', 'P', 'S', 'D', '_', 'W', 'R', '_', 'P', 'O', 'L', 'I', 'C', 'Y', '\0', /* ZPCPSD_WR_POLICY (70972) */
	'C', 'A', 'C', 'H', 'E', '_', 'L', 'R', 'U', '_', 'R', 'D', '\0', /* CACHE_LRU_RD (70989) */
	'C', 'A', 'C', 'H', 'E', '_', 'N', 'O', 'A', '\0', /* CACHE_NOA (71002) */
	'U', 'N', 'C', 'A', 'C', 'H', 'E', 'D', '_', 'R', 'D', '\0', /* UNCACHED_RD (71012) */
	'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', 'R', 'D', 'P', 'O', 'L', 'I', 'C', 'Y', '\0', /* RESERVED_RDPOLICY (71024) */
	'Z', '_', 'R', 'D', '_', 'P', 'O', 'L', 'I', 'C', 'Y', '\0', /* Z_RD_POLICY (71042) */
	'S', '_', 'R', 'D', '_', 'P', 'O', 'L', 'I', 'C', 'Y', '\0', /* S_RD_POLICY (71054) */
	'H', 'T', 'I', 'L', 'E', '_', 'R', 'D', '_', 'P', 'O', 'L', 'I', 'C', 'Y', '\0', /* HTILE_RD_POLICY (71066) */
	'Z', '_', 'B', 'I', 'G', '_', 'P', 'A', 'G', 'E', '\0', /* Z_BIG_PAGE (71082, 71084) */
	'S', '_', 'B', 'I', 'G', '_', 'P', 'A', 'G', 'E', '\0', /* S_BIG_PAGE (71093) */
	'D', 'E', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '_', '2', '5', '6', 'B', '\0', /* DEST_BASE_HI_256B (71104) */
	'W', 'I', 'N', 'D', 'O', 'W', '_', 'X', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* WINDOW_X_OFFSET (71122) */
	'W', 'I', 'N', 'D', 'O', 'W', '_', 'Y', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* WINDOW_Y_OFFSET (71138, 71145) */
	'W', 'I', 'N', 'D', 'O', 'W', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* WINDOW_OFFSET_DISABLE (71154) */
	'I', 'N', '_', '2', '0', '\0', /* IN_20 (71176) */
	'I', 'N', '_', '2', '1', '\0', /* IN_21 (71182) */
	'I', 'N', '_', '2', '1', '0', '\0', /* IN_210 (71188) */
	'I', 'N', '_', '3', '0', '\0', /* IN_30 (71195) */
	'I', 'N', '_', '3', '1', '\0', /* IN_31 (71201) */
	'I', 'N', '_', '3', '1', '0', '\0', /* IN_310 (71207) */
	'I', 'N', '_', '3', '2', '\0', /* IN_32 (71214) */
	'I', 'N', '_', '3', '2', '0', '\0', /* IN_320 (71220) */
	'I', 'N', '_', '3', '2', '1', '\0', /* IN_321 (71227) */
	'I', 'N', '_', '3', '2', '1', '0', '\0', /* IN_3210 (71234) */
	'C', 'L', 'I', 'P', '_', 'R', 'U', 'L', 'E', '\0', /* CLIP_RULE (71242) */
	'E', 'R', '_', 'T', 'R', 'I', '\0', /* ER_TRI (71252) */
	'E', 'R', '_', 'P', 'O', 'I', 'N', 'T', '\0', /* ER_POINT (71259) */
	'E', 'R', '_', 'R', 'E', 'C', 'T', '\0', /* ER_RECT (71268) */
	'E', 'R', '_', 'L', 'I', 'N', 'E', '_', 'L', 'R', '\0', /* ER_LINE_LR (71276) */
	'E', 'R', '_', 'L', 'I', 'N', 'E', '_', 'R', 'L', '\0', /* ER_LINE_RL (71287) */
	'E', 'R', '_', 'L', 'I', 'N', 'E', '_', 'T', 'B', '\0', /* ER_LINE_TB (71298) */
	'E', 'R', '_', 'L', 'I', 'N', 'E', '_', 'B', 'T', '\0', /* ER_LINE_BT (71309) */
	'H', 'W', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', 'X', '\0', /* HW_SCREEN_OFFSET_X (71320) */
	'H', 'W', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', 'Y', '\0', /* HW_SCREEN_OFFSET_Y (71339) */
	'T', 'A', 'R', 'G', 'E', 'T', '0', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* TARGET0_ENABLE (71358) */
	'T', 'A', 'R', 'G', 'E', 'T', '1', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* TARGET1_ENABLE (71373) */
	'T', 'A', 'R', 'G', 'E', 'T', '2', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* TARGET2_ENABLE (71388) */
	'T', 'A', 'R', 'G', 'E', 'T', '3', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* TARGET3_ENABLE (71403) */
	'T', 'A', 'R', 'G', 'E', 'T', '4', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* TARGET4_ENABLE (71418) */
	'T', 'A', 'R', 'G', 'E', 'T', '5', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* TARGET5_ENABLE (71433) */
	'T', 'A', 'R', 'G', 'E', 'T', '6', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* TARGET6_ENABLE (71448) */
	'T', 'A', 'R', 'G', 'E', 'T', '7', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* TARGET7_ENABLE (71463) */
	'O', 'U', 'T', 'P', 'U', 'T', '0', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* OUTPUT0_ENABLE (71478) */
	'O', 'U', 'T', 'P', 'U', 'T', '1', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* OUTPUT1_ENABLE (71493) */
	'O', 'U', 'T', 'P', 'U', 'T', '2', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* OUTPUT2_ENABLE (71508) */
	'O', 'U', 'T', 'P', 'U', 'T', '3', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* OUTPUT3_ENABLE (71523) */
	'O', 'U', 'T', 'P', 'U', 'T', '4', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* OUTPUT4_ENABLE (71538) */
	'O', 'U', 'T', 'P', 'U', 'T', '5', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* OUTPUT5_ENABLE (71553) */
	'O', 'U', 'T', 'P', 'U', 'T', '6', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* OUTPUT6_ENABLE (71568) */
	'O', 'U', 'T', 'P', 'U', 'T', '7', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* OUTPUT7_ENABLE (71583) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'B', '_', 'M', 'A', 'P', '_', '0', '\0', /* RASTER_CONFIG_RB_MAP_0 (71598) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'B', '_', 'M', 'A', 'P', '_', '1', '\0', /* RASTER_CONFIG_RB_MAP_1 (71621) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'B', '_', 'M', 'A', 'P', '_', '2', '\0', /* RASTER_CONFIG_RB_MAP_2 (71644) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'B', '_', 'M', 'A', 'P', '_', '3', '\0', /* RASTER_CONFIG_RB_MAP_3 (71667) */
	'R', 'B', '_', 'M', 'A', 'P', '_', 'P', 'K', 'R', '0', '\0', /* RB_MAP_PKR0 (71690) */
	'R', 'B', '_', 'M', 'A', 'P', '_', 'P', 'K', 'R', '1', '\0', /* RB_MAP_PKR1 (71702) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'B', '_', 'X', 'S', 'E', 'L', '2', '_', '0', '\0', /* RASTER_CONFIG_RB_XSEL2_0 (71714) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'B', '_', 'X', 'S', 'E', 'L', '2', '_', '1', '\0', /* RASTER_CONFIG_RB_XSEL2_1 (71739) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'B', '_', 'X', 'S', 'E', 'L', '2', '_', '2', '\0', /* RASTER_CONFIG_RB_XSEL2_2 (71764) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'B', '_', 'X', 'S', 'E', 'L', '2', '_', '3', '\0', /* RASTER_CONFIG_RB_XSEL2_3 (71789) */
	'R', 'B', '_', 'X', 'S', 'E', 'L', '2', '\0', /* RB_XSEL2 (71814) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'B', '_', 'X', 'S', 'E', 'L', '_', '0', '\0', /* RASTER_CONFIG_RB_XSEL_0 (71823) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'B', '_', 'X', 'S', 'E', 'L', '_', '1', '\0', /* RASTER_CONFIG_RB_XSEL_1 (71847) */
	'R', 'B', '_', 'X', 'S', 'E', 'L', '\0', /* RB_XSEL (71871) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'B', '_', 'Y', 'S', 'E', 'L', '_', '0', '\0', /* RASTER_CONFIG_RB_YSEL_0 (71879) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'B', '_', 'Y', 'S', 'E', 'L', '_', '1', '\0', /* RASTER_CONFIG_RB_YSEL_1 (71903) */
	'R', 'B', '_', 'Y', 'S', 'E', 'L', '\0', /* RB_YSEL (71927) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'M', 'A', 'P', '_', '0', '\0', /* RASTER_CONFIG_PKR_MAP_0 (71935) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'M', 'A', 'P', '_', '1', '\0', /* RASTER_CONFIG_PKR_MAP_1 (71959) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'M', 'A', 'P', '_', '2', '\0', /* RASTER_CONFIG_PKR_MAP_2 (71983) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'M', 'A', 'P', '_', '3', '\0', /* RASTER_CONFIG_PKR_MAP_3 (72007) */
	'P', 'K', 'R', '_', 'M', 'A', 'P', '\0', /* PKR_MAP (72031) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'X', 'S', 'E', 'L', '_', '0', '\0', /* RASTER_CONFIG_PKR_XSEL_0 (72039) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'X', 'S', 'E', 'L', '_', '1', '\0', /* RASTER_CONFIG_PKR_XSEL_1 (72064) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'X', 'S', 'E', 'L', '_', '2', '\0', /* RASTER_CONFIG_PKR_XSEL_2 (72089) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'X', 'S', 'E', 'L', '_', '3', '\0', /* RASTER_CONFIG_PKR_XSEL_3 (72114) */
	'P', 'K', 'R', '_', 'X', 'S', 'E', 'L', '\0', /* PKR_XSEL (72139) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'Y', 'S', 'E', 'L', '_', '0', '\0', /* RASTER_CONFIG_PKR_YSEL_0 (72148) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'Y', 'S', 'E', 'L', '_', '1', '\0', /* RASTER_CONFIG_PKR_YSEL_1 (72173) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'Y', 'S', 'E', 'L', '_', '2', '\0', /* RASTER_CONFIG_PKR_YSEL_2 (72198) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'Y', 'S', 'E', 'L', '_', '3', '\0', /* RASTER_CONFIG_PKR_YSEL_3 (72223) */
	'P', 'K', 'R', '_', 'Y', 'S', 'E', 'L', '\0', /* PKR_YSEL (72248) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'X', 'S', 'E', 'L', '2', '_', '0', '\0', /* RASTER_CONFIG_PKR_XSEL2_0 (72257) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'X', 'S', 'E', 'L', '2', '_', '1', '\0', /* RASTER_CONFIG_PKR_XSEL2_1 (72283) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'X', 'S', 'E', 'L', '2', '_', '2', '\0', /* RASTER_CONFIG_PKR_XSEL2_2 (72309) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'X', 'S', 'E', 'L', '2', '_', '3', '\0', /* RASTER_CONFIG_PKR_XSEL2_3 (72335) */
	'P', 'K', 'R', '_', 'X', 'S', 'E', 'L', '2', '\0', /* PKR_XSEL2 (72361) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'C', '_', 'M', 'A', 'P', '_', '0', '\0', /* RASTER_CONFIG_SC_MAP_0 (72371) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'C', '_', 'M', 'A', 'P', '_', '1', '\0', /* RASTER_CONFIG_SC_MAP_1 (72394) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'C', '_', 'M', 'A', 'P', '_', '2', '\0', /* RASTER_CONFIG_SC_MAP_2 (72417) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'C', '_', 'M', 'A', 'P', '_', '3', '\0', /* RASTER_CONFIG_SC_MAP_3 (72440) */
	'S', 'C', '_', 'M', 'A', 'P', '\0', /* SC_MAP (72463) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'C', '_', 'X', 'S', 'E', 'L', '_', '8', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SC_XSEL_8_WIDE_TILE (72470) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'C', '_', 'X', 'S', 'E', 'L', '_', '1', '6', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SC_XSEL_16_WIDE_TILE (72504) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'C', '_', 'X', 'S', 'E', 'L', '_', '3', '2', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SC_XSEL_32_WIDE_TILE (72539) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'C', '_', 'X', 'S', 'E', 'L', '_', '6', '4', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SC_XSEL_64_WIDE_TILE (72574) */
	'S', 'C', '_', 'X', 'S', 'E', 'L', '\0', /* SC_XSEL (72609) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'C', '_', 'Y', 'S', 'E', 'L', '_', '8', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SC_YSEL_8_WIDE_TILE (72617) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'C', '_', 'Y', 'S', 'E', 'L', '_', '1', '6', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SC_YSEL_16_WIDE_TILE (72651) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'C', '_', 'Y', 'S', 'E', 'L', '_', '3', '2', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SC_YSEL_32_WIDE_TILE (72686) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'C', '_', 'Y', 'S', 'E', 'L', '_', '6', '4', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SC_YSEL_64_WIDE_TILE (72721) */
	'S', 'C', '_', 'Y', 'S', 'E', 'L', '\0', /* SC_YSEL (72756) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'M', 'A', 'P', '_', '0', '\0', /* RASTER_CONFIG_SE_MAP_0 (72764) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'M', 'A', 'P', '_', '1', '\0', /* RASTER_CONFIG_SE_MAP_1 (72787) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'M', 'A', 'P', '_', '2', '\0', /* RASTER_CONFIG_SE_MAP_2 (72810) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'M', 'A', 'P', '_', '3', '\0', /* RASTER_CONFIG_SE_MAP_3 (72833) */
	'S', 'E', '_', 'M', 'A', 'P', '\0', /* SE_MAP (72856) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'X', 'S', 'E', 'L', '_', '8', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SE_XSEL_8_WIDE_TILE (72863) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'X', 'S', 'E', 'L', '_', '1', '6', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SE_XSEL_16_WIDE_TILE (72897) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'X', 'S', 'E', 'L', '_', '3', '2', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SE_XSEL_32_WIDE_TILE (72932) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'X', 'S', 'E', 'L', '_', '6', '4', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SE_XSEL_64_WIDE_TILE (72967) */
	'S', 'E', '_', 'X', 'S', 'E', 'L', '\0', /* SE_XSEL (73002) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'Y', 'S', 'E', 'L', '_', '8', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SE_YSEL_8_WIDE_TILE (73010) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'Y', 'S', 'E', 'L', '_', '1', '6', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SE_YSEL_16_WIDE_TILE (73044) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'Y', 'S', 'E', 'L', '_', '3', '2', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SE_YSEL_32_WIDE_TILE (73079) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'Y', 'S', 'E', 'L', '_', '6', '4', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SE_YSEL_64_WIDE_TILE (73114) */
	'S', 'E', '_', 'Y', 'S', 'E', 'L', '\0', /* SE_YSEL (73149) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'P', 'A', 'I', 'R', '_', 'M', 'A', 'P', '_', '0', '\0', /* RASTER_CONFIG_SE_PAIR_MAP_0 (73157) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'P', 'A', 'I', 'R', '_', 'M', 'A', 'P', '_', '1', '\0', /* RASTER_CONFIG_SE_PAIR_MAP_1 (73185) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'P', 'A', 'I', 'R', '_', 'M', 'A', 'P', '_', '2', '\0', /* RASTER_CONFIG_SE_PAIR_MAP_2 (73213) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'P', 'A', 'I', 'R', '_', 'M', 'A', 'P', '_', '3', '\0', /* RASTER_CONFIG_SE_PAIR_MAP_3 (73241) */
	'S', 'E', '_', 'P', 'A', 'I', 'R', '_', 'M', 'A', 'P', '\0', /* SE_PAIR_MAP (73269) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'P', 'A', 'I', 'R', '_', 'X', 'S', 'E', 'L', '_', '8', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SE_PAIR_XSEL_8_WIDE_TILE (73281) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'P', 'A', 'I', 'R', '_', 'X', 'S', 'E', 'L', '_', '1', '6', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SE_PAIR_XSEL_16_WIDE_TILE (73320) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'P', 'A', 'I', 'R', '_', 'X', 'S', 'E', 'L', '_', '3', '2', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SE_PAIR_XSEL_32_WIDE_TILE (73360) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'P', 'A', 'I', 'R', '_', 'X', 'S', 'E', 'L', '_', '6', '4', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SE_PAIR_XSEL_64_WIDE_TILE (73400) */
	'S', 'E', '_', 'P', 'A', 'I', 'R', '_', 'X', 'S', 'E', 'L', '\0', /* SE_PAIR_XSEL (73440) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'P', 'A', 'I', 'R', '_', 'Y', 'S', 'E', 'L', '_', '8', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SE_PAIR_YSEL_8_WIDE_TILE (73453) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'P', 'A', 'I', 'R', '_', 'Y', 'S', 'E', 'L', '_', '1', '6', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SE_PAIR_YSEL_16_WIDE_TILE (73492) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'P', 'A', 'I', 'R', '_', 'Y', 'S', 'E', 'L', '_', '3', '2', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SE_PAIR_YSEL_32_WIDE_TILE (73532) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'P', 'A', 'I', 'R', '_', 'Y', 'S', 'E', 'L', '_', '6', '4', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SE_PAIR_YSEL_64_WIDE_TILE (73572) */
	'S', 'E', '_', 'P', 'A', 'I', 'R', '_', 'Y', 'S', 'E', 'L', '\0', /* SE_PAIR_YSEL (73612) */
	'N', 'U', 'M', '_', 'S', 'E', '\0', /* NUM_SE (73625) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'S', 'R', 'B', 'S', 'L', '_', 'D', 'B', '_', 'O', 'P', 'T', 'I', 'M', 'I', 'Z', 'E', 'D', '_', 'P', 'A', 'C', 'K', 'I', 'N', 'G', '\0', /* DISABLE_SRBSL_DB_OPTIMIZED_PACKING (73632) */
	'N', 'U', 'M', '_', 'S', 'C', '\0', /* NUM_SC (73667) */
	'N', 'U', 'M', '_', 'R', 'B', '_', 'P', 'E', 'R', '_', 'S', 'C', '\0', /* NUM_RB_PER_SC (73674) */
	'N', 'U', 'M', '_', 'P', 'A', 'C', 'K', 'E', 'R', '_', 'P', 'E', 'R', '_', 'S', 'C', '\0', /* NUM_PACKER_PER_SC (73688) */
	'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* PERFMON_ENABLE (73706) */
	'L', 'E', 'F', 'T', '_', 'Q', 'T', 'R', '\0', /* LEFT_QTR (73721) */
	'L', 'E', 'F', 'T', '_', 'H', 'A', 'L', 'F', '\0', /* LEFT_HALF (73730) */
	'R', 'I', 'G', 'H', 'T', '_', 'H', 'A', 'L', 'F', '\0', /* RIGHT_HALF (73740) */
	'R', 'I', 'G', 'H', 'T', '_', 'Q', 'T', 'R', '\0', /* RIGHT_QTR (73751) */
	'T', 'O', 'P', '_', 'Q', 'T', 'R', '\0', /* TOP_QTR (73761) */
	'T', 'O', 'P', '_', 'H', 'A', 'L', 'F', '\0', /* TOP_HALF (73769) */
	'B', 'O', 'T', '_', 'H', 'A', 'L', 'F', '\0', /* BOT_HALF (73778) */
	'B', 'O', 'T', '_', 'Q', 'T', 'R', '\0', /* BOT_QTR (73787) */
	'C', 'M', 'A', 'S', 'K', '_', 'W', 'R', '_', 'P', 'O', 'L', 'I', 'C', 'Y', '\0', /* CMASK_WR_POLICY (73795) */
	'F', 'M', 'A', 'S', 'K', '_', 'W', 'R', '_', 'P', 'O', 'L', 'I', 'C', 'Y', '\0', /* FMASK_WR_POLICY (73811) */
	'D', 'C', 'C', '_', 'W', 'R', '_', 'P', 'O', 'L', 'I', 'C', 'Y', '\0', /* DCC_WR_POLICY (73827) */
	'C', 'O', 'L', 'O', 'R', '_', 'W', 'R', '_', 'P', 'O', 'L', 'I', 'C', 'Y', '\0', /* COLOR_WR_POLICY (73841) */
	'C', 'M', 'A', 'S', 'K', '_', 'R', 'D', '_', 'P', 'O', 'L', 'I', 'C', 'Y', '\0', /* CMASK_RD_POLICY (73857) */
	'F', 'M', 'A', 'S', 'K', '_', 'R', 'D', '_', 'P', 'O', 'L', 'I', 'C', 'Y', '\0', /* FMASK_RD_POLICY (73873) */
	'D', 'C', 'C', '_', 'R', 'D', '_', 'P', 'O', 'L', 'I', 'C', 'Y', '\0', /* DCC_RD_POLICY (73889) */
	'C', 'O', 'L', 'O', 'R', '_', 'R', 'D', '_', 'P', 'O', 'L', 'I', 'C', 'Y', '\0', /* COLOR_RD_POLICY (73903) */
	'F', 'M', 'A', 'S', 'K', '_', 'B', 'I', 'G', '_', 'P', 'A', 'G', 'E', '\0', /* FMASK_BIG_PAGE (73919) */
	'C', 'O', 'L', 'O', 'R', '_', 'B', 'I', 'G', '_', 'P', 'A', 'G', 'E', '\0', /* COLOR_BIG_PAGE (73934) */
	'O', 'V', 'E', 'R', 'W', 'R', 'I', 'T', 'E', '_', 'C', 'O', 'M', 'B', 'I', 'N', 'E', 'R', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* OVERWRITE_COMBINER_DISABLE (73949) */
	'O', 'V', 'E', 'R', 'W', 'R', 'I', 'T', 'E', '_', 'C', 'O', 'M', 'B', 'I', 'N', 'E', 'R', '_', 'W', 'A', 'T', 'E', 'R', 'M', 'A', 'R', 'K', '\0', /* OVERWRITE_COMBINER_WATERMARK (73976) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'C', 'O', 'N', 'S', 'T', 'A', 'N', 'T', '_', 'E', 'N', 'C', 'O', 'D', 'E', '_', 'A', 'C', '0', '1', '\0', /* DISABLE_CONSTANT_ENCODE_AC01 (74005) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'C', 'O', 'N', 'S', 'T', 'A', 'N', 'T', '_', 'E', 'N', 'C', 'O', 'D', 'E', '_', 'S', 'I', 'N', 'G', 'L', 'E', '\0', /* DISABLE_CONSTANT_ENCODE_SINGLE (74034) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'C', 'O', 'N', 'S', 'T', 'A', 'N', 'T', '_', 'E', 'N', 'C', 'O', 'D', 'E', '_', 'R', 'E', 'G', '\0', /* DISABLE_CONSTANT_ENCODE_REG (74065) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'E', 'L', 'I', 'M', 'F', 'C', '_', 'S', 'K', 'I', 'P', '_', 'O', 'F', '_', 'A', 'C', '0', '1', '\0', /* DISABLE_ELIMFC_SKIP_OF_AC01 (74093) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'E', 'L', 'I', 'M', 'F', 'C', '_', 'S', 'K', 'I', 'P', '_', 'O', 'F', '_', 'S', 'I', 'N', 'G', 'L', 'E', '\0', /* DISABLE_ELIMFC_SKIP_OF_SINGLE (74121) */
	'E', 'N', 'A', 'B', 'L', 'E', '_', 'E', 'L', 'I', 'M', 'F', 'C', '_', 'S', 'K', 'I', 'P', '_', 'O', 'F', '_', 'R', 'E', 'G', '\0', /* ENABLE_ELIMFC_SKIP_OF_REG (74151) */
	'C', 'O', 'V', 'E', 'R', 'A', 'G', 'E', '_', 'O', 'U', 'T', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* COVERAGE_OUT_ENABLE (74177) */
	'C', 'O', 'V', 'E', 'R', 'A', 'G', 'E', '_', 'O', 'U', 'T', '_', 'M', 'R', 'T', '\0', /* COVERAGE_OUT_MRT (74197) */
	'C', 'O', 'V', 'E', 'R', 'A', 'G', 'E', '_', 'O', 'U', 'T', '_', 'C', 'H', 'A', 'N', 'N', 'E', 'L', '\0', /* COVERAGE_OUT_CHANNEL (74214) */
	'C', 'O', 'V', 'E', 'R', 'A', 'G', 'E', '_', 'O', 'U', 'T', '_', 'S', 'A', 'M', 'P', 'L', 'E', 'S', '\0', /* COVERAGE_OUT_SAMPLES (74235) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'K', 'E', 'E', 'P', '\0', /* STENCIL_KEEP (74256) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'Z', 'E', 'R', 'O', '\0', /* STENCIL_ZERO (74269) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'O', 'N', 'E', 'S', '\0', /* STENCIL_ONES (74282) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'R', 'E', 'P', 'L', 'A', 'C', 'E', '_', 'T', 'E', 'S', 'T', '\0', /* STENCIL_REPLACE_TEST (74295) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'R', 'E', 'P', 'L', 'A', 'C', 'E', '_', 'O', 'P', '\0', /* STENCIL_REPLACE_OP (74316) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'A', 'D', 'D', '_', 'C', 'L', 'A', 'M', 'P', '\0', /* STENCIL_ADD_CLAMP (74335) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'S', 'U', 'B', '_', 'C', 'L', 'A', 'M', 'P', '\0', /* STENCIL_SUB_CLAMP (74353) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'I', 'N', 'V', 'E', 'R', 'T', '\0', /* STENCIL_INVERT (74371) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'A', 'D', 'D', '_', 'W', 'R', 'A', 'P', '\0', /* STENCIL_ADD_WRAP (74386) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'S', 'U', 'B', '_', 'W', 'R', 'A', 'P', '\0', /* STENCIL_SUB_WRAP (74403) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'A', 'N', 'D', '\0', /* STENCIL_AND (74420) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'O', 'R', '\0', /* STENCIL_OR (74432) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'X', 'O', 'R', '\0', /* STENCIL_XOR (74443) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'N', 'A', 'N', 'D', '\0', /* STENCIL_NAND (74455) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'N', 'O', 'R', '\0', /* STENCIL_NOR (74468) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'X', 'N', 'O', 'R', '\0', /* STENCIL_XNOR (74480) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', 'F', 'A', 'I', 'L', '\0', /* STENCILFAIL (74493) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', 'Z', 'P', 'A', 'S', 'S', '\0', /* STENCILZPASS (74505) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', 'Z', 'F', 'A', 'I', 'L', '\0', /* STENCILZFAIL (74518) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', 'F', 'A', 'I', 'L', '_', 'B', 'F', '\0', /* STENCILFAIL_BF (74531) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', 'Z', 'P', 'A', 'S', 'S', '_', 'B', 'F', '\0', /* STENCILZPASS_BF (74546) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', 'Z', 'F', 'A', 'I', 'L', '_', 'B', 'F', '\0', /* STENCILZFAIL_BF (74562) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', 'T', 'E', 'S', 'T', 'V', 'A', 'L', '\0', /* STENCILTESTVAL (74578) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', 'M', 'A', 'S', 'K', '\0', /* STENCILMASK (74593) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', 'W', 'R', 'I', 'T', 'E', 'M', 'A', 'S', 'K', '\0', /* STENCILWRITEMASK (74605) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', 'O', 'P', 'V', 'A', 'L', '\0', /* STENCILOPVAL (74622) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', 'T', 'E', 'S', 'T', 'V', 'A', 'L', '_', 'B', 'F', '\0', /* STENCILTESTVAL_BF (74635) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', 'M', 'A', 'S', 'K', '_', 'B', 'F', '\0', /* STENCILMASK_BF (74653) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', 'W', 'R', 'I', 'T', 'E', 'M', 'A', 'S', 'K', '_', 'B', 'F', '\0', /* STENCILWRITEMASK_BF (74668) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', 'O', 'P', 'V', 'A', 'L', '_', 'B', 'F', '\0', /* STENCILOPVAL_BF (74688) */
	'D', 'E', 'F', 'A', 'U', 'L', 'T', '_', 'V', 'A', 'L', '\0', /* DEFAULT_VAL (74704) */
	'F', 'L', 'A', 'T', '_', 'S', 'H', 'A', 'D', 'E', '\0', /* FLAT_SHADE (74716) */
	'C', 'Y', 'L', '_', 'W', 'R', 'A', 'P', '\0', /* CYL_WRAP (74727) */
	'P', 'T', '_', 'S', 'P', 'R', 'I', 'T', 'E', '_', 'T', 'E', 'X', '\0', /* PT_SPRITE_TEX (74736) */
	'D', 'U', 'P', '\0', /* DUP (74750) */
	'F', 'P', '1', '6', '_', 'I', 'N', 'T', 'E', 'R', 'P', '_', 'M', 'O', 'D', 'E', '\0', /* FP16_INTERP_MODE (74754) */
	'U', 'S', 'E', '_', 'D', 'E', 'F', 'A', 'U', 'L', 'T', '_', 'A', 'T', 'T', 'R', '1', '\0', /* USE_DEFAULT_ATTR1 (74771) */
	'D', 'E', 'F', 'A', 'U', 'L', 'T', '_', 'V', 'A', 'L', '_', 'A', 'T', 'T', 'R', '1', '\0', /* DEFAULT_VAL_ATTR1 (74789) */
	'P', 'T', '_', 'S', 'P', 'R', 'I', 'T', 'E', '_', 'T', 'E', 'X', '_', 'A', 'T', 'T', 'R', '1', '\0', /* PT_SPRITE_TEX_ATTR1 (74807) */
	'A', 'T', 'T', 'R', '0', '_', 'V', 'A', 'L', 'I', 'D', '\0', /* ATTR0_VALID (74827) */
	'A', 'T', 'T', 'R', '1', '_', 'V', 'A', 'L', 'I', 'D', '\0', /* ATTR1_VALID (74839) */
	'V', 'S', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', 'C', 'O', 'U', 'N', 'T', '\0', /* VS_EXPORT_COUNT (74851) */
	'V', 'S', '_', 'H', 'A', 'L', 'F', '_', 'P', 'A', 'C', 'K', '\0', /* VS_HALF_PACK (74867) */
	'N', 'O', '_', 'P', 'C', '_', 'E', 'X', 'P', 'O', 'R', 'T', '\0', /* NO_PC_EXPORT (74880) */
	'P', 'E', 'R', 'S', 'P', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'E', 'N', 'A', '\0', /* PERSP_SAMPLE_ENA (74893) */
	'P', 'E', 'R', 'S', 'P', '_', 'C', 'E', 'N', 'T', 'E', 'R', '_', 'E', 'N', 'A', '\0', /* PERSP_CENTER_ENA (74910) */
	'P', 'E', 'R', 'S', 'P', '_', 'C', 'E', 'N', 'T', 'R', 'O', 'I', 'D', '_', 'E', 'N', 'A', '\0', /* PERSP_CENTROID_ENA (74927) */
	'P', 'E', 'R', 'S', 'P', '_', 'P', 'U', 'L', 'L', '_', 'M', 'O', 'D', 'E', 'L', '_', 'E', 'N', 'A', '\0', /* PERSP_PULL_MODEL_ENA (74946) */
	'L', 'I', 'N', 'E', 'A', 'R', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'E', 'N', 'A', '\0', /* LINEAR_SAMPLE_ENA (74967) */
	'L', 'I', 'N', 'E', 'A', 'R', '_', 'C', 'E', 'N', 'T', 'E', 'R', '_', 'E', 'N', 'A', '\0', /* LINEAR_CENTER_ENA (74985) */
	'L', 'I', 'N', 'E', 'A', 'R', '_', 'C', 'E', 'N', 'T', 'R', 'O', 'I', 'D', '_', 'E', 'N', 'A', '\0', /* LINEAR_CENTROID_ENA (75003) */
	'L', 'I', 'N', 'E', '_', 'S', 'T', 'I', 'P', 'P', 'L', 'E', '_', 'T', 'E', 'X', '_', 'E', 'N', 'A', '\0', /* LINE_STIPPLE_TEX_ENA (75023) */
	'P', 'O', 'S', '_', 'X', '_', 'F', 'L', 'O', 'A', 'T', '_', 'E', 'N', 'A', '\0', /* POS_X_FLOAT_ENA (75044) */
	'P', 'O', 'S', '_', 'Y', '_', 'F', 'L', 'O', 'A', 'T', '_', 'E', 'N', 'A', '\0', /* POS_Y_FLOAT_ENA (75060) */
	'P', 'O', 'S', '_', 'Z', '_', 'F', 'L', 'O', 'A', 'T', '_', 'E', 'N', 'A', '\0', /* POS_Z_FLOAT_ENA (75076) */
	'P', 'O', 'S', '_', 'W', '_', 'F', 'L', 'O', 'A', 'T', '_', 'E', 'N', 'A', '\0', /* POS_W_FLOAT_ENA (75092) */
	'F', 'R', 'O', 'N', 'T', '_', 'F', 'A', 'C', 'E', '_', 'E', 'N', 'A', '\0', /* FRONT_FACE_ENA (75108) */
	'A', 'N', 'C', 'I', 'L', 'L', 'A', 'R', 'Y', '_', 'E', 'N', 'A', '\0', /* ANCILLARY_ENA (75123) */
	'S', 'A', 'M', 'P', 'L', 'E', '_', 'C', 'O', 'V', 'E', 'R', 'A', 'G', 'E', '_', 'E', 'N', 'A', '\0', /* SAMPLE_COVERAGE_ENA (75137) */
	'P', 'O', 'S', '_', 'F', 'I', 'X', 'E', 'D', '_', 'P', 'T', '_', 'E', 'N', 'A', '\0', /* POS_FIXED_PT_ENA (75157) */
	'F', 'L', 'A', 'T', '_', 'S', 'H', 'A', 'D', 'E', '_', 'E', 'N', 'A', '\0', /* FLAT_SHADE_ENA (75174) */
	'P', 'N', 'T', '_', 'S', 'P', 'R', 'I', 'T', 'E', '_', 'E', 'N', 'A', '\0', /* PNT_SPRITE_ENA (75189) */
	'S', 'P', 'I', '_', 'P', 'N', 'T', '_', 'S', 'P', 'R', 'I', 'T', 'E', '_', 'S', 'E', 'L', '_', '0', '\0', /* SPI_PNT_SPRITE_SEL_0 (75204) */
	'S', 'P', 'I', '_', 'P', 'N', 'T', '_', 'S', 'P', 'R', 'I', 'T', 'E', '_', 'S', 'E', 'L', '_', '1', '\0', /* SPI_PNT_SPRITE_SEL_1 (75225) */
	'S', 'P', 'I', '_', 'P', 'N', 'T', '_', 'S', 'P', 'R', 'I', 'T', 'E', '_', 'S', 'E', 'L', '_', 'S', '\0', /* SPI_PNT_SPRITE_SEL_S (75246) */
	'S', 'P', 'I', '_', 'P', 'N', 'T', '_', 'S', 'P', 'R', 'I', 'T', 'E', '_', 'S', 'E', 'L', '_', 'T', '\0', /* SPI_PNT_SPRITE_SEL_T (75267) */
	'S', 'P', 'I', '_', 'P', 'N', 'T', '_', 'S', 'P', 'R', 'I', 'T', 'E', '_', 'S', 'E', 'L', '_', 'N', 'O', 'N', 'E', '\0', /* SPI_PNT_SPRITE_SEL_NONE (75288, 75307) */
	'P', 'N', 'T', '_', 'S', 'P', 'R', 'I', 'T', 'E', '_', 'O', 'V', 'R', 'D', '_', 'X', '\0', /* PNT_SPRITE_OVRD_X (75312) */
	'P', 'N', 'T', '_', 'S', 'P', 'R', 'I', 'T', 'E', '_', 'O', 'V', 'R', 'D', '_', 'Y', '\0', /* PNT_SPRITE_OVRD_Y (75330) */
	'P', 'N', 'T', '_', 'S', 'P', 'R', 'I', 'T', 'E', '_', 'O', 'V', 'R', 'D', '_', 'Z', '\0', /* PNT_SPRITE_OVRD_Z (75348) */
	'P', 'N', 'T', '_', 'S', 'P', 'R', 'I', 'T', 'E', '_', 'O', 'V', 'R', 'D', '_', 'W', '\0', /* PNT_SPRITE_OVRD_W (75366) */
	'P', 'N', 'T', '_', 'S', 'P', 'R', 'I', 'T', 'E', '_', 'T', 'O', 'P', '_', '1', '\0', /* PNT_SPRITE_TOP_1 (75384) */
	'N', 'U', 'M', '_', 'I', 'N', 'T', 'E', 'R', 'P', '\0', /* NUM_INTERP (75401) */
	'P', 'A', 'R', 'A', 'M', '_', 'G', 'E', 'N', '\0', /* PARAM_GEN (75412) */
	'O', 'F', 'F', 'C', 'H', 'I', 'P', '_', 'P', 'A', 'R', 'A', 'M', '_', 'E', 'N', '\0', /* OFFCHIP_PARAM_EN (75422) */
	'L', 'A', 'T', 'E', '_', 'P', 'C', '_', 'D', 'E', 'A', 'L', 'L', 'O', 'C', '\0', /* LATE_PC_DEALLOC (75439) */
	'B', 'C', '_', 'O', 'P', 'T', 'I', 'M', 'I', 'Z', 'E', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* BC_OPTIMIZE_DISABLE (75455) */
	'P', 'S', '_', 'W', '3', '2', '_', 'E', 'N', '\0', /* PS_W32_EN (75475) */
	'P', 'E', 'R', 'S', 'P', '_', 'C', 'E', 'N', 'T', 'E', 'R', '_', 'C', 'N', 'T', 'L', '\0', /* PERSP_CENTER_CNTL (75485) */
	'P', 'E', 'R', 'S', 'P', '_', 'C', 'E', 'N', 'T', 'R', 'O', 'I', 'D', '_', 'C', 'N', 'T', 'L', '\0', /* PERSP_CENTROID_CNTL (75503) */
	'L', 'I', 'N', 'E', 'A', 'R', '_', 'C', 'E', 'N', 'T', 'E', 'R', '_', 'C', 'N', 'T', 'L', '\0', /* LINEAR_CENTER_CNTL (75523) */
	'L', 'I', 'N', 'E', 'A', 'R', '_', 'C', 'E', 'N', 'T', 'R', 'O', 'I', 'D', '_', 'C', 'N', 'T', 'L', '\0', /* LINEAR_CENTROID_CNTL (75542) */
	'P', 'O', 'S', '_', 'F', 'L', 'O', 'A', 'T', '_', 'L', 'O', 'C', 'A', 'T', 'I', 'O', 'N', '\0', /* POS_FLOAT_LOCATION (75563) */
	'P', 'O', 'S', '_', 'F', 'L', 'O', 'A', 'T', '_', 'U', 'L', 'C', '\0', /* POS_FLOAT_ULC (75582) */
	'F', 'R', 'O', 'N', 'T', '_', 'F', 'A', 'C', 'E', '_', 'A', 'L', 'L', '_', 'B', 'I', 'T', 'S', '\0', /* FRONT_FACE_ALL_BITS (75596) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'N', 'O', 'N', 'E', '\0', /* SPI_SHADER_NONE (75616) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', '1', 'C', 'O', 'M', 'P', '\0', /* SPI_SHADER_1COMP (75632) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', '2', 'C', 'O', 'M', 'P', '\0', /* SPI_SHADER_2COMP (75649) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', '4', 'C', 'O', 'M', 'P', 'R', 'E', 'S', 'S', '\0', /* SPI_SHADER_4COMPRESS (75666) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', '4', 'C', 'O', 'M', 'P', '\0', /* SPI_SHADER_4COMP (75687) */
	'I', 'D', 'X', '0', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* IDX0_EXPORT_FORMAT (75704) */
	'P', 'O', 'S', '0', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* POS0_EXPORT_FORMAT (75723) */
	'P', 'O', 'S', '1', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* POS1_EXPORT_FORMAT (75742) */
	'P', 'O', 'S', '2', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* POS2_EXPORT_FORMAT (75761) */
	'P', 'O', 'S', '3', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* POS3_EXPORT_FORMAT (75780) */
	'P', 'O', 'S', '4', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* POS4_EXPORT_FORMAT (75799) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'Z', 'E', 'R', 'O', '\0', /* SPI_SHADER_ZERO (75818) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', '3', '2', '_', 'R', '\0', /* SPI_SHADER_32_R (75834) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', '3', '2', '_', 'G', 'R', '\0', /* SPI_SHADER_32_GR (75850) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', '3', '2', '_', 'A', 'R', '\0', /* SPI_SHADER_32_AR (75867) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'F', 'P', '1', '6', '_', 'A', 'B', 'G', 'R', '\0', /* SPI_SHADER_FP16_ABGR (75884) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'N', 'O', 'R', 'M', '1', '6', '_', 'A', 'B', 'G', 'R', '\0', /* SPI_SHADER_UNORM16_ABGR (75905) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'S', 'N', 'O', 'R', 'M', '1', '6', '_', 'A', 'B', 'G', 'R', '\0', /* SPI_SHADER_SNORM16_ABGR (75929) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'I', 'N', 'T', '1', '6', '_', 'A', 'B', 'G', 'R', '\0', /* SPI_SHADER_UINT16_ABGR (75953) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'S', 'I', 'N', 'T', '1', '6', '_', 'A', 'B', 'G', 'R', '\0', /* SPI_SHADER_SINT16_ABGR (75976) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', '3', '2', '_', 'A', 'B', 'G', 'R', '\0', /* SPI_SHADER_32_ABGR (75999) */
	'Z', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* Z_EXPORT_FORMAT (76018) */
	'C', 'O', 'L', '0', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* COL0_EXPORT_FORMAT (76034) */
	'C', 'O', 'L', '1', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* COL1_EXPORT_FORMAT (76053) */
	'C', 'O', 'L', '2', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* COL2_EXPORT_FORMAT (76072) */
	'C', 'O', 'L', '3', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* COL3_EXPORT_FORMAT (76091) */
	'C', 'O', 'L', '4', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* COL4_EXPORT_FORMAT (76110) */
	'C', 'O', 'L', '5', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* COL5_EXPORT_FORMAT (76129) */
	'C', 'O', 'L', '6', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* COL6_EXPORT_FORMAT (76148) */
	'C', 'O', 'L', '7', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* COL7_EXPORT_FORMAT (76167) */
	'S', 'X', '_', 'R', 'T', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', 'N', 'O', '_', 'C', 'O', 'N', 'V', 'E', 'R', 'S', 'I', 'O', 'N', '\0', /* SX_RT_EXPORT_NO_CONVERSION (76186) */
	'S', 'X', '_', 'R', 'T', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', '3', '2', '_', 'R', '\0', /* SX_RT_EXPORT_32_R (76213) */
	'S', 'X', '_', 'R', 'T', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', '3', '2', '_', 'A', '\0', /* SX_RT_EXPORT_32_A (76231) */
	'S', 'X', '_', 'R', 'T', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', '1', '0', '_', '1', '1', '_', '1', '1', '\0', /* SX_RT_EXPORT_10_11_11 (76249) */
	'S', 'X', '_', 'R', 'T', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', '2', '_', '1', '0', '_', '1', '0', '_', '1', '0', '\0', /* SX_RT_EXPORT_2_10_10_10 (76271) */
	'S', 'X', '_', 'R', 'T', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', '8', '_', '8', '_', '8', '_', '8', '\0', /* SX_RT_EXPORT_8_8_8_8 (76295) */
	'S', 'X', '_', 'R', 'T', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', '5', '_', '6', '_', '5', '\0', /* SX_RT_EXPORT_5_6_5 (76316) */
	'S', 'X', '_', 'R', 'T', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', '1', '_', '5', '_', '5', '_', '5', '\0', /* SX_RT_EXPORT_1_5_5_5 (76335) */
	'S', 'X', '_', 'R', 'T', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', '4', '_', '4', '_', '4', '_', '4', '\0', /* SX_RT_EXPORT_4_4_4_4 (76356) */
	'S', 'X', '_', 'R', 'T', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', '1', '6', '_', '1', '6', '_', 'G', 'R', '\0', /* SX_RT_EXPORT_16_16_GR (76377) */
	'S', 'X', '_', 'R', 'T', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', '1', '6', '_', '1', '6', '_', 'A', 'R', '\0', /* SX_RT_EXPORT_16_16_AR (76399) */
	'M', 'R', 'T', '0', '\0', /* MRT0 (76421) */
	'M', 'R', 'T', '1', '\0', /* MRT1 (76426) */
	'M', 'R', 'T', '2', '\0', /* MRT2 (76431) */
	'M', 'R', 'T', '3', '\0', /* MRT3 (76436) */
	'M', 'R', 'T', '4', '\0', /* MRT4 (76441) */
	'M', 'R', 'T', '5', '\0', /* MRT5 (76446) */
	'M', 'R', 'T', '6', '\0', /* MRT6 (76451) */
	'M', 'R', 'T', '7', '\0', /* MRT7 (76456) */
	'1', '1', 'B', 'I', 'T', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* 11BIT_FORMAT (76461) */
	'1', '0', 'B', 'I', 'T', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* 10BIT_FORMAT (76474) */
	'8', 'B', 'I', 'T', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* 8BIT_FORMAT (76487) */
	'6', 'B', 'I', 'T', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* 6BIT_FORMAT (76499) */
	'5', 'B', 'I', 'T', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* 5BIT_FORMAT (76511) */
	'4', 'B', 'I', 'T', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* 4BIT_FORMAT (76523) */
	'M', 'R', 'T', '0', '_', 'E', 'P', 'S', 'I', 'L', 'O', 'N', '\0', /* MRT0_EPSILON (76535) */
	'M', 'R', 'T', '1', '_', 'E', 'P', 'S', 'I', 'L', 'O', 'N', '\0', /* MRT1_EPSILON (76548) */
	'M', 'R', 'T', '2', '_', 'E', 'P', 'S', 'I', 'L', 'O', 'N', '\0', /* MRT2_EPSILON (76561) */
	'M', 'R', 'T', '3', '_', 'E', 'P', 'S', 'I', 'L', 'O', 'N', '\0', /* MRT3_EPSILON (76574) */
	'M', 'R', 'T', '4', '_', 'E', 'P', 'S', 'I', 'L', 'O', 'N', '\0', /* MRT4_EPSILON (76587) */
	'M', 'R', 'T', '5', '_', 'E', 'P', 'S', 'I', 'L', 'O', 'N', '\0', /* MRT5_EPSILON (76600) */
	'M', 'R', 'T', '6', '_', 'E', 'P', 'S', 'I', 'L', 'O', 'N', '\0', /* MRT6_EPSILON (76613) */
	'M', 'R', 'T', '7', '_', 'E', 'P', 'S', 'I', 'L', 'O', 'N', '\0', /* MRT7_EPSILON (76626) */
	'M', 'R', 'T', '0', '_', 'C', 'O', 'L', 'O', 'R', '_', 'O', 'P', 'T', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* MRT0_COLOR_OPT_DISABLE (76639) */
	'M', 'R', 'T', '0', '_', 'A', 'L', 'P', 'H', 'A', '_', 'O', 'P', 'T', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* MRT0_ALPHA_OPT_DISABLE (76662) */
	'M', 'R', 'T', '1', '_', 'C', 'O', 'L', 'O', 'R', '_', 'O', 'P', 'T', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* MRT1_COLOR_OPT_DISABLE (76685) */
	'M', 'R', 'T', '1', '_', 'A', 'L', 'P', 'H', 'A', '_', 'O', 'P', 'T', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* MRT1_ALPHA_OPT_DISABLE (76708) */
	'M', 'R', 'T', '2', '_', 'C', 'O', 'L', 'O', 'R', '_', 'O', 'P', 'T', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* MRT2_COLOR_OPT_DISABLE (76731) */
	'M', 'R', 'T', '2', '_', 'A', 'L', 'P', 'H', 'A', '_', 'O', 'P', 'T', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* MRT2_ALPHA_OPT_DISABLE (76754) */
	'M', 'R', 'T', '3', '_', 'C', 'O', 'L', 'O', 'R', '_', 'O', 'P', 'T', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* MRT3_COLOR_OPT_DISABLE (76777) */
	'M', 'R', 'T', '3', '_', 'A', 'L', 'P', 'H', 'A', '_', 'O', 'P', 'T', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* MRT3_ALPHA_OPT_DISABLE (76800) */
	'M', 'R', 'T', '4', '_', 'C', 'O', 'L', 'O', 'R', '_', 'O', 'P', 'T', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* MRT4_COLOR_OPT_DISABLE (76823) */
	'M', 'R', 'T', '4', '_', 'A', 'L', 'P', 'H', 'A', '_', 'O', 'P', 'T', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* MRT4_ALPHA_OPT_DISABLE (76846) */
	'M', 'R', 'T', '5', '_', 'C', 'O', 'L', 'O', 'R', '_', 'O', 'P', 'T', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* MRT5_COLOR_OPT_DISABLE (76869) */
	'M', 'R', 'T', '5', '_', 'A', 'L', 'P', 'H', 'A', '_', 'O', 'P', 'T', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* MRT5_ALPHA_OPT_DISABLE (76892) */
	'M', 'R', 'T', '6', '_', 'C', 'O', 'L', 'O', 'R', '_', 'O', 'P', 'T', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* MRT6_COLOR_OPT_DISABLE (76915) */
	'M', 'R', 'T', '6', '_', 'A', 'L', 'P', 'H', 'A', '_', 'O', 'P', 'T', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* MRT6_ALPHA_OPT_DISABLE (76938) */
	'M', 'R', 'T', '7', '_', 'C', 'O', 'L', 'O', 'R', '_', 'O', 'P', 'T', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* MRT7_COLOR_OPT_DISABLE (76961) */
	'M', 'R', 'T', '7', '_', 'A', 'L', 'P', 'H', 'A', '_', 'O', 'P', 'T', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* MRT7_ALPHA_OPT_DISABLE (76984) */
	'P', 'I', 'X', 'E', 'N', '_', 'Z', 'E', 'R', 'O', '_', 'O', 'P', 'T', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* PIXEN_ZERO_OPT_DISABLE (77007) */
	'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '_', 'P', 'R', 'E', 'S', 'E', 'R', 'V', 'E', '_', 'N', 'O', 'N', 'E', '_', 'I', 'G', 'N', 'O', 'R', 'E', '_', 'A', 'L', 'L', '\0', /* BLEND_OPT_PRESERVE_NONE_IGNORE_ALL (77030) */
	'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '_', 'P', 'R', 'E', 'S', 'E', 'R', 'V', 'E', '_', 'A', 'L', 'L', '_', 'I', 'G', 'N', 'O', 'R', 'E', '_', 'N', 'O', 'N', 'E', '\0', /* BLEND_OPT_PRESERVE_ALL_IGNORE_NONE (77065) */
	'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '_', 'P', 'R', 'E', 'S', 'E', 'R', 'V', 'E', '_', 'C', '1', '_', 'I', 'G', 'N', 'O', 'R', 'E', '_', 'C', '0', '\0', /* BLEND_OPT_PRESERVE_C1_IGNORE_C0 (77100) */
	'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '_', 'P', 'R', 'E', 'S', 'E', 'R', 'V', 'E', '_', 'C', '0', '_', 'I', 'G', 'N', 'O', 'R', 'E', '_', 'C', '1', '\0', /* BLEND_OPT_PRESERVE_C0_IGNORE_C1 (77132) */
	'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '_', 'P', 'R', 'E', 'S', 'E', 'R', 'V', 'E', '_', 'A', '1', '_', 'I', 'G', 'N', 'O', 'R', 'E', '_', 'A', '0', '\0', /* BLEND_OPT_PRESERVE_A1_IGNORE_A0 (77164) */
	'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '_', 'P', 'R', 'E', 'S', 'E', 'R', 'V', 'E', '_', 'A', '0', '_', 'I', 'G', 'N', 'O', 'R', 'E', '_', 'A', '1', '\0', /* BLEND_OPT_PRESERVE_A0_IGNORE_A1 (77196) */
	'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '_', 'P', 'R', 'E', 'S', 'E', 'R', 'V', 'E', '_', 'N', 'O', 'N', 'E', '_', 'I', 'G', 'N', 'O', 'R', 'E', '_', 'A', '0', '\0', /* BLEND_OPT_PRESERVE_NONE_IGNORE_A0 (77228) */
	'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '_', 'P', 'R', 'E', 'S', 'E', 'R', 'V', 'E', '_', 'N', 'O', 'N', 'E', '_', 'I', 'G', 'N', 'O', 'R', 'E', '_', 'N', 'O', 'N', 'E', '\0', /* BLEND_OPT_PRESERVE_NONE_IGNORE_NONE (77262) */
	'C', 'O', 'L', 'O', 'R', '_', 'S', 'R', 'C', '_', 'O', 'P', 'T', '\0', /* COLOR_SRC_OPT (77298) */
	'C', 'O', 'L', 'O', 'R', '_', 'D', 'S', 'T', '_', 'O', 'P', 'T', '\0', /* COLOR_DST_OPT (77312) */
	'O', 'P', 'T', '_', 'C', 'O', 'M', 'B', '_', 'N', 'O', 'N', 'E', '\0', /* OPT_COMB_NONE (77326) */
	'O', 'P', 'T', '_', 'C', 'O', 'M', 'B', '_', 'A', 'D', 'D', '\0', /* OPT_COMB_ADD (77340) */
	'O', 'P', 'T', '_', 'C', 'O', 'M', 'B', '_', 'S', 'U', 'B', 'T', 'R', 'A', 'C', 'T', '\0', /* OPT_COMB_SUBTRACT (77353) */
	'O', 'P', 'T', '_', 'C', 'O', 'M', 'B', '_', 'M', 'I', 'N', '\0', /* OPT_COMB_MIN (77371) */
	'O', 'P', 'T', '_', 'C', 'O', 'M', 'B', '_', 'M', 'A', 'X', '\0', /* OPT_COMB_MAX (77384) */
	'O', 'P', 'T', '_', 'C', 'O', 'M', 'B', '_', 'R', 'E', 'V', 'S', 'U', 'B', 'T', 'R', 'A', 'C', 'T', '\0', /* OPT_COMB_REVSUBTRACT (77397) */
	'O', 'P', 'T', '_', 'C', 'O', 'M', 'B', '_', 'B', 'L', 'E', 'N', 'D', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', 'D', '\0', /* OPT_COMB_BLEND_DISABLED (77418) */
	'O', 'P', 'T', '_', 'C', 'O', 'M', 'B', '_', 'S', 'A', 'F', 'E', '_', 'A', 'D', 'D', '\0', /* OPT_COMB_SAFE_ADD (77442) */
	'C', 'O', 'L', 'O', 'R', '_', 'C', 'O', 'M', 'B', '_', 'F', 'C', 'N', '\0', /* COLOR_COMB_FCN (77460) */
	'A', 'L', 'P', 'H', 'A', '_', 'S', 'R', 'C', '_', 'O', 'P', 'T', '\0', /* ALPHA_SRC_OPT (77475) */
	'A', 'L', 'P', 'H', 'A', '_', 'D', 'S', 'T', '_', 'O', 'P', 'T', '\0', /* ALPHA_DST_OPT (77489) */
	'A', 'L', 'P', 'H', 'A', '_', 'C', 'O', 'M', 'B', '_', 'F', 'C', 'N', '\0', /* ALPHA_COMB_FCN (77503) */
	'B', 'L', 'E', 'N', 'D', '_', 'Z', 'E', 'R', 'O', '\0', /* BLEND_ZERO (77518) */
	'B', 'L', 'E', 'N', 'D', '_', 'O', 'N', 'E', '\0', /* BLEND_ONE (77529) */
	'B', 'L', 'E', 'N', 'D', '_', 'S', 'R', 'C', '_', 'C', 'O', 'L', 'O', 'R', '\0', /* BLEND_SRC_COLOR (77539) */
	'B', 'L', 'E', 'N', 'D', '_', 'O', 'N', 'E', '_', 'M', 'I', 'N', 'U', 'S', '_', 'S', 'R', 'C', '_', 'C', 'O', 'L', 'O', 'R', '\0', /* BLEND_ONE_MINUS_SRC_COLOR (77555) */
	'B', 'L', 'E', 'N', 'D', '_', 'S', 'R', 'C', '_', 'A', 'L', 'P', 'H', 'A', '\0', /* BLEND_SRC_ALPHA (77581) */
	'B', 'L', 'E', 'N', 'D', '_', 'O', 'N', 'E', '_', 'M', 'I', 'N', 'U', 'S', '_', 'S', 'R', 'C', '_', 'A', 'L', 'P', 'H', 'A', '\0', /* BLEND_ONE_MINUS_SRC_ALPHA (77597) */
	'B', 'L', 'E', 'N', 'D', '_', 'D', 'S', 'T', '_', 'A', 'L', 'P', 'H', 'A', '\0', /* BLEND_DST_ALPHA (77623) */
	'B', 'L', 'E', 'N', 'D', '_', 'O', 'N', 'E', '_', 'M', 'I', 'N', 'U', 'S', '_', 'D', 'S', 'T', '_', 'A', 'L', 'P', 'H', 'A', '\0', /* BLEND_ONE_MINUS_DST_ALPHA (77639) */
	'B', 'L', 'E', 'N', 'D', '_', 'D', 'S', 'T', '_', 'C', 'O', 'L', 'O', 'R', '\0', /* BLEND_DST_COLOR (77665) */
	'B', 'L', 'E', 'N', 'D', '_', 'O', 'N', 'E', '_', 'M', 'I', 'N', 'U', 'S', '_', 'D', 'S', 'T', '_', 'C', 'O', 'L', 'O', 'R', '\0', /* BLEND_ONE_MINUS_DST_COLOR (77681) */
	'B', 'L', 'E', 'N', 'D', '_', 'S', 'R', 'C', '_', 'A', 'L', 'P', 'H', 'A', '_', 'S', 'A', 'T', 'U', 'R', 'A', 'T', 'E', '\0', /* BLEND_SRC_ALPHA_SATURATE (77707) */
	'B', 'L', 'E', 'N', 'D', '_', 'B', 'O', 'T', 'H', '_', 'S', 'R', 'C', '_', 'A', 'L', 'P', 'H', 'A', '\0', /* BLEND_BOTH_SRC_ALPHA (77732) */
	'B', 'L', 'E', 'N', 'D', '_', 'B', 'O', 'T', 'H', '_', 'I', 'N', 'V', '_', 'S', 'R', 'C', '_', 'A', 'L', 'P', 'H', 'A', '\0', /* BLEND_BOTH_INV_SRC_ALPHA (77753) */
	'B', 'L', 'E', 'N', 'D', '_', 'C', 'O', 'N', 'S', 'T', 'A', 'N', 'T', '_', 'C', 'O', 'L', 'O', 'R', '\0', /* BLEND_CONSTANT_COLOR (77778) */
	'B', 'L', 'E', 'N', 'D', '_', 'O', 'N', 'E', '_', 'M', 'I', 'N', 'U', 'S', '_', 'C', 'O', 'N', 'S', 'T', 'A', 'N', 'T', '_', 'C', 'O', 'L', 'O', 'R', '\0', /* BLEND_ONE_MINUS_CONSTANT_COLOR (77799) */
	'B', 'L', 'E', 'N', 'D', '_', 'S', 'R', 'C', '1', '_', 'C', 'O', 'L', 'O', 'R', '\0', /* BLEND_SRC1_COLOR (77830) */
	'B', 'L', 'E', 'N', 'D', '_', 'I', 'N', 'V', '_', 'S', 'R', 'C', '1', '_', 'C', 'O', 'L', 'O', 'R', '\0', /* BLEND_INV_SRC1_COLOR (77847) */
	'B', 'L', 'E', 'N', 'D', '_', 'S', 'R', 'C', '1', '_', 'A', 'L', 'P', 'H', 'A', '\0', /* BLEND_SRC1_ALPHA (77868) */
	'B', 'L', 'E', 'N', 'D', '_', 'I', 'N', 'V', '_', 'S', 'R', 'C', '1', '_', 'A', 'L', 'P', 'H', 'A', '\0', /* BLEND_INV_SRC1_ALPHA (77885) */
	'B', 'L', 'E', 'N', 'D', '_', 'C', 'O', 'N', 'S', 'T', 'A', 'N', 'T', '_', 'A', 'L', 'P', 'H', 'A', '\0', /* BLEND_CONSTANT_ALPHA (77906) */
	'B', 'L', 'E', 'N', 'D', '_', 'O', 'N', 'E', '_', 'M', 'I', 'N', 'U', 'S', '_', 'C', 'O', 'N', 'S', 'T', 'A', 'N', 'T', '_', 'A', 'L', 'P', 'H', 'A', '\0', /* BLEND_ONE_MINUS_CONSTANT_ALPHA (77927) */
	'C', 'O', 'L', 'O', 'R', '_', 'S', 'R', 'C', 'B', 'L', 'E', 'N', 'D', '\0', /* COLOR_SRCBLEND (77958) */
	'C', 'O', 'M', 'B', '_', 'D', 'S', 'T', '_', 'P', 'L', 'U', 'S', '_', 'S', 'R', 'C', '\0', /* COMB_DST_PLUS_SRC (77973) */
	'C', 'O', 'M', 'B', '_', 'S', 'R', 'C', '_', 'M', 'I', 'N', 'U', 'S', '_', 'D', 'S', 'T', '\0', /* COMB_SRC_MINUS_DST (77991) */
	'C', 'O', 'M', 'B', '_', 'M', 'I', 'N', '_', 'D', 'S', 'T', '_', 'S', 'R', 'C', '\0', /* COMB_MIN_DST_SRC (78010) */
	'C', 'O', 'M', 'B', '_', 'M', 'A', 'X', '_', 'D', 'S', 'T', '_', 'S', 'R', 'C', '\0', /* COMB_MAX_DST_SRC (78027) */
	'C', 'O', 'M', 'B', '_', 'D', 'S', 'T', '_', 'M', 'I', 'N', 'U', 'S', '_', 'S', 'R', 'C', '\0', /* COMB_DST_MINUS_SRC (78044) */
	'C', 'O', 'L', 'O', 'R', '_', 'D', 'E', 'S', 'T', 'B', 'L', 'E', 'N', 'D', '\0', /* COLOR_DESTBLEND (78063) */
	'A', 'L', 'P', 'H', 'A', '_', 'S', 'R', 'C', 'B', 'L', 'E', 'N', 'D', '\0', /* ALPHA_SRCBLEND (78079) */
	'A', 'L', 'P', 'H', 'A', '_', 'D', 'E', 'S', 'T', 'B', 'L', 'E', 'N', 'D', '\0', /* ALPHA_DESTBLEND (78094) */
	'S', 'E', 'P', 'A', 'R', 'A', 'T', 'E', '_', 'A', 'L', 'P', 'H', 'A', '_', 'B', 'L', 'E', 'N', 'D', '\0', /* SEPARATE_ALPHA_BLEND (78110) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'R', 'O', 'P', '3', '\0', /* DISABLE_ROP3 (78131, 78139) */
	'S', 'R', 'C', '_', 'S', 'T', 'A', 'T', 'E', '_', 'I', 'D', '\0', /* SRC_STATE_ID (78144) */
	'D', 'I', '_', 'S', 'R', 'C', '_', 'S', 'E', 'L', '_', 'D', 'M', 'A', '\0', /* DI_SRC_SEL_DMA (78157) */
	'D', 'I', '_', 'S', 'R', 'C', '_', 'S', 'E', 'L', '_', 'I', 'M', 'M', 'E', 'D', 'I', 'A', 'T', 'E', '\0', /* DI_SRC_SEL_IMMEDIATE (78172) */
	'D', 'I', '_', 'S', 'R', 'C', '_', 'S', 'E', 'L', '_', 'A', 'U', 'T', 'O', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* DI_SRC_SEL_AUTO_INDEX (78193) */
	'D', 'I', '_', 'S', 'R', 'C', '_', 'S', 'E', 'L', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '\0', /* DI_SRC_SEL_RESERVED (78215) */
	'S', 'O', 'U', 'R', 'C', 'E', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SOURCE_SELECT (78235) */
	'D', 'I', '_', 'M', 'A', 'J', 'O', 'R', '_', 'M', 'O', 'D', 'E', '_', '0', '\0', /* DI_MAJOR_MODE_0 (78249) */
	'D', 'I', '_', 'M', 'A', 'J', 'O', 'R', '_', 'M', 'O', 'D', 'E', '_', '1', '\0', /* DI_MAJOR_MODE_1 (78265) */
	'M', 'A', 'J', 'O', 'R', '_', 'M', 'O', 'D', 'E', '\0', /* MAJOR_MODE (78281) */
	'S', 'P', 'R', 'I', 'T', 'E', '_', 'E', 'N', '_', 'R', '6', 'X', 'X', '\0', /* SPRITE_EN_R6XX (78292) */
	'N', 'O', 'T', '_', 'E', 'O', 'P', '\0', /* NOT_EOP (78307) */
	'U', 'S', 'E', '_', 'O', 'P', 'A', 'Q', 'U', 'E', '\0', /* USE_OPAQUE (78315) */
	'U', 'N', 'R', 'O', 'L', 'L', 'E', 'D', '_', 'I', 'N', 'S', 'T', '\0', /* UNROLLED_INST (78326) */
	'G', 'R', 'B', 'M', '_', 'S', 'K', 'E', 'W', '_', 'N', 'O', '_', 'D', 'E', 'C', '\0', /* GRBM_SKEW_NO_DEC (78340) */
	'R', 'E', 'G', '_', 'R', 'T', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* REG_RT_INDEX (78357) */
	'A', 'D', 'D', 'R', 'E', 'S', 'S', '_', 'L', 'O', 'W', '\0', /* ADDRESS_LOW (78370) */
	'M', 'A', 'X', '_', 'V', 'E', 'R', 'T', 'S', '_', 'P', 'E', 'R', '_', 'S', 'U', 'B', 'G', 'R', 'O', 'U', 'P', '\0', /* MAX_VERTS_PER_SUBGROUP (78382) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* STENCIL_ENABLE (78405) */
	'Z', '_', 'W', 'R', 'I', 'T', 'E', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* Z_WRITE_ENABLE (78420) */
	'D', 'E', 'P', 'T', 'H', '_', 'B', 'O', 'U', 'N', 'D', 'S', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* DEPTH_BOUNDS_ENABLE (78435) */
	'B', 'A', 'C', 'K', 'F', 'A', 'C', 'E', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* BACKFACE_ENABLE (78455) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', 'F', 'U', 'N', 'C', '\0', /* STENCILFUNC (78471) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', 'F', 'U', 'N', 'C', '_', 'B', 'F', '\0', /* STENCILFUNC_BF (78483) */
	'E', 'N', 'A', 'B', 'L', 'E', '_', 'C', 'O', 'L', 'O', 'R', '_', 'W', 'R', 'I', 'T', 'E', 'S', '_', 'O', 'N', '_', 'D', 'E', 'P', 'T', 'H', '_', 'F', 'A', 'I', 'L', '\0', /* ENABLE_COLOR_WRITES_ON_DEPTH_FAIL (78498) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'C', 'O', 'L', 'O', 'R', '_', 'W', 'R', 'I', 'T', 'E', 'S', '_', 'O', 'N', '_', 'D', 'E', 'P', 'T', 'H', '_', 'P', 'A', 'S', 'S', '\0', /* DISABLE_COLOR_WRITES_ON_DEPTH_PASS (78532) */
	'M', 'A', 'X', '_', 'A', 'N', 'C', 'H', 'O', 'R', '_', 'S', 'A', 'M', 'P', 'L', 'E', 'S', '\0', /* MAX_ANCHOR_SAMPLES (78567) */
	'P', 'S', '_', 'I', 'T', 'E', 'R', '_', 'S', 'A', 'M', 'P', 'L', 'E', 'S', '\0', /* PS_ITER_SAMPLES (78586) */
	'M', 'A', 'S', 'K', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', 'N', 'U', 'M', '_', 'S', 'A', 'M', 'P', 'L', 'E', 'S', '\0', /* MASK_EXPORT_NUM_SAMPLES (78602) */
	'A', 'L', 'P', 'H', 'A', '_', 'T', 'O', '_', 'M', 'A', 'S', 'K', '_', 'N', 'U', 'M', '_', 'S', 'A', 'M', 'P', 'L', 'E', 'S', '\0', /* ALPHA_TO_MASK_NUM_SAMPLES (78626) */
	'H', 'I', 'G', 'H', '_', 'Q', 'U', 'A', 'L', 'I', 'T', 'Y', '_', 'I', 'N', 'T', 'E', 'R', 'S', 'E', 'C', 'T', 'I', 'O', 'N', 'S', '\0', /* HIGH_QUALITY_INTERSECTIONS (78652) */
	'I', 'N', 'C', 'O', 'H', 'E', 'R', 'E', 'N', 'T', '_', 'E', 'Q', 'A', 'A', '_', 'R', 'E', 'A', 'D', 'S', '\0', /* INCOHERENT_EQAA_READS (78679) */
	'I', 'N', 'T', 'E', 'R', 'P', 'O', 'L', 'A', 'T', 'E', '_', 'C', 'O', 'M', 'P', '_', 'Z', '\0', /* INTERPOLATE_COMP_Z (78701) */
	'I', 'N', 'T', 'E', 'R', 'P', 'O', 'L', 'A', 'T', 'E', '_', 'S', 'R', 'C', '_', 'Z', '\0', /* INTERPOLATE_SRC_Z (78720) */
	'S', 'T', 'A', 'T', 'I', 'C', '_', 'A', 'N', 'C', 'H', 'O', 'R', '_', 'A', 'S', 'S', 'O', 'C', 'I', 'A', 'T', 'I', 'O', 'N', 'S', '\0', /* STATIC_ANCHOR_ASSOCIATIONS (78738) */
	'A', 'L', 'P', 'H', 'A', '_', 'T', 'O', '_', 'M', 'A', 'S', 'K', '_', 'E', 'Q', 'A', 'A', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* ALPHA_TO_MASK_EQAA_DISABLE (78765) */
	'O', 'V', 'E', 'R', 'R', 'A', 'S', 'T', 'E', 'R', 'I', 'Z', 'A', 'T', 'I', 'O', 'N', '_', 'A', 'M', 'O', 'U', 'N', 'T', '\0', /* OVERRASTERIZATION_AMOUNT (78792) */
	'E', 'N', 'A', 'B', 'L', 'E', '_', 'P', 'O', 'S', 'T', 'Z', '_', 'O', 'V', 'E', 'R', 'R', 'A', 'S', 'T', 'E', 'R', 'I', 'Z', 'A', 'T', 'I', 'O', 'N', '\0', /* ENABLE_POSTZ_OVERRASTERIZATION (78817) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'D', 'U', 'A', 'L', '_', 'Q', 'U', 'A', 'D', '\0', /* DISABLE_DUAL_QUAD (78848) */
	'D', 'E', 'G', 'A', 'M', 'M', 'A', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* DEGAMMA_ENABLE (78866) */
	'C', 'B', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* CB_DISABLE (78881) */
	'C', 'B', '_', 'N', 'O', 'R', 'M', 'A', 'L', '\0', /* CB_NORMAL (78892) */
	'C', 'B', '_', 'E', 'L', 'I', 'M', 'I', 'N', 'A', 'T', 'E', '_', 'F', 'A', 'S', 'T', '_', 'C', 'L', 'E', 'A', 'R', '\0', /* CB_ELIMINATE_FAST_CLEAR (78902, 78915) */
	'C', 'B', '_', 'R', 'E', 'S', 'O', 'L', 'V', 'E', '\0', /* CB_RESOLVE (78926) */
	'C', 'B', '_', 'D', 'E', 'C', 'O', 'M', 'P', 'R', 'E', 'S', 'S', '\0', /* CB_DECOMPRESS (78937) */
	'C', 'B', '_', 'F', 'M', 'A', 'S', 'K', '_', 'D', 'E', 'C', 'O', 'M', 'P', 'R', 'E', 'S', 'S', '\0', /* CB_FMASK_DECOMPRESS (78951) */
	'C', 'B', '_', 'D', 'C', 'C', '_', 'D', 'E', 'C', 'O', 'M', 'P', 'R', 'E', 'S', 'S', '\0', /* CB_DCC_DECOMPRESS (78971) */
	'C', 'B', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '\0', /* CB_RESERVED (78989) */
	'R', 'O', 'P', '3', '_', 'C', 'L', 'E', 'A', 'R', '\0', /* ROP3_CLEAR (79001) */
	'X', '_', '0', 'X', '0', '5', '\0', /* X_0X05 (79012) */
	'X', '_', '0', 'X', '0', 'A', '\0', /* X_0X0A (79019) */
	'X', '_', '0', 'X', '0', 'F', '\0', /* X_0X0F (79026) */
	'R', 'O', 'P', '3', '_', 'N', 'O', 'R', '\0', /* ROP3_NOR (79033) */
	'R', 'O', 'P', '3', '_', 'A', 'N', 'D', '_', 'I', 'N', 'V', 'E', 'R', 'T', 'E', 'D', '\0', /* ROP3_AND_INVERTED (79042) */
	'R', 'O', 'P', '3', '_', 'C', 'O', 'P', 'Y', '_', 'I', 'N', 'V', 'E', 'R', 'T', 'E', 'D', '\0', /* ROP3_COPY_INVERTED (79060) */
	'R', 'O', 'P', '3', '_', 'A', 'N', 'D', '_', 'R', 'E', 'V', 'E', 'R', 'S', 'E', '\0', /* ROP3_AND_REVERSE (79079) */
	'X', '_', '0', 'X', '5', '0', '\0', /* X_0X50 (79096) */
	'R', 'O', 'P', '3', '_', 'I', 'N', 'V', 'E', 'R', 'T', '\0', /* ROP3_INVERT (79103) */
	'X', '_', '0', 'X', '5', 'A', '\0', /* X_0X5A (79115) */
	'X', '_', '0', 'X', '5', 'F', '\0', /* X_0X5F (79122) */
	'R', 'O', 'P', '3', '_', 'X', 'O', 'R', '\0', /* ROP3_XOR (79129) */
	'R', 'O', 'P', '3', '_', 'N', 'A', 'N', 'D', '\0', /* ROP3_NAND (79138) */
	'R', 'O', 'P', '3', '_', 'A', 'N', 'D', '\0', /* ROP3_AND (79148) */
	'R', 'O', 'P', '3', '_', 'E', 'Q', 'U', 'I', 'V', 'A', 'L', 'E', 'N', 'T', '\0', /* ROP3_EQUIVALENT (79157) */
	'X', '_', '0', 'X', 'A', '0', '\0', /* X_0XA0 (79173) */
	'X', '_', '0', 'X', 'A', '5', '\0', /* X_0XA5 (79180) */
	'R', 'O', 'P', '3', '_', 'N', 'O', '_', 'O', 'P', '\0', /* ROP3_NO_OP (79187) */
	'X', '_', '0', 'X', 'A', 'F', '\0', /* X_0XAF (79198) */
	'R', 'O', 'P', '3', '_', 'O', 'R', '_', 'I', 'N', 'V', 'E', 'R', 'T', 'E', 'D', '\0', /* ROP3_OR_INVERTED (79205) */
	'R', 'O', 'P', '3', '_', 'C', 'O', 'P', 'Y', '\0', /* ROP3_COPY (79222) */
	'R', 'O', 'P', '3', '_', 'O', 'R', '_', 'R', 'E', 'V', 'E', 'R', 'S', 'E', '\0', /* ROP3_OR_REVERSE (79232) */
	'R', 'O', 'P', '3', '_', 'O', 'R', '\0', /* ROP3_OR (79248) */
	'X', '_', '0', 'X', 'F', '0', '\0', /* X_0XF0 (79256) */
	'X', '_', '0', 'X', 'F', '5', '\0', /* X_0XF5 (79263) */
	'X', '_', '0', 'X', 'F', 'A', '\0', /* X_0XFA (79270) */
	'R', 'O', 'P', '3', '_', 'S', 'E', 'T', '\0', /* ROP3_SET (79277) */
	'Z', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* Z_EXPORT_ENABLE (79286) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'T', 'E', 'S', 'T', '_', 'V', 'A', 'L', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* STENCIL_TEST_VAL_EXPORT_ENABLE (79302) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'O', 'P', '_', 'V', 'A', 'L', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* STENCIL_OP_VAL_EXPORT_ENABLE (79333) */
	'L', 'A', 'T', 'E', '_', 'Z', '\0', /* LATE_Z (79362) */
	'E', 'A', 'R', 'L', 'Y', '_', 'Z', '_', 'T', 'H', 'E', 'N', '_', 'L', 'A', 'T', 'E', '_', 'Z', '\0', /* EARLY_Z_THEN_LATE_Z (79369) */
	'R', 'E', '_', 'Z', '\0', /* RE_Z (79389) */
	'E', 'A', 'R', 'L', 'Y', '_', 'Z', '_', 'T', 'H', 'E', 'N', '_', 'R', 'E', '_', 'Z', '\0', /* EARLY_Z_THEN_RE_Z (79394) */
	'K', 'I', 'L', 'L', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* KILL_ENABLE (79412) */
	'C', 'O', 'V', 'E', 'R', 'A', 'G', 'E', '_', 'T', 'O', '_', 'M', 'A', 'S', 'K', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* COVERAGE_TO_MASK_ENABLE (79424) */
	'M', 'A', 'S', 'K', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* MASK_EXPORT_ENABLE (79448) */
	'E', 'X', 'E', 'C', '_', 'O', 'N', '_', 'H', 'I', 'E', 'R', '_', 'F', 'A', 'I', 'L', '\0', /* EXEC_ON_HIER_FAIL (79467) */
	'E', 'X', 'E', 'C', '_', 'O', 'N', '_', 'N', 'O', 'O', 'P', '\0', /* EXEC_ON_NOOP (79485) */
	'A', 'L', 'P', 'H', 'A', '_', 'T', 'O', '_', 'M', 'A', 'S', 'K', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* ALPHA_TO_MASK_DISABLE (79498) */
	'D', 'E', 'P', 'T', 'H', '_', 'B', 'E', 'F', 'O', 'R', 'E', '_', 'S', 'H', 'A', 'D', 'E', 'R', '\0', /* DEPTH_BEFORE_SHADER (79520) */
	'E', 'X', 'P', 'O', 'R', 'T', '_', 'A', 'N', 'Y', '_', 'Z', '\0', /* EXPORT_ANY_Z (79540) */
	'E', 'X', 'P', 'O', 'R', 'T', '_', 'L', 'E', 'S', 'S', '_', 'T', 'H', 'A', 'N', '_', 'Z', '\0', /* EXPORT_LESS_THAN_Z (79553) */
	'E', 'X', 'P', 'O', 'R', 'T', '_', 'G', 'R', 'E', 'A', 'T', 'E', 'R', '_', 'T', 'H', 'A', 'N', '_', 'Z', '\0', /* EXPORT_GREATER_THAN_Z (79572) */
	'E', 'X', 'P', 'O', 'R', 'T', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '\0', /* EXPORT_RESERVED (79594) */
	'C', 'O', 'N', 'S', 'E', 'R', 'V', 'A', 'T', 'I', 'V', 'E', '_', 'Z', '_', 'E', 'X', 'P', 'O', 'R', 'T', '\0', /* CONSERVATIVE_Z_EXPORT (79610) */
	'D', 'U', 'A', 'L', '_', 'Q', 'U', 'A', 'D', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* DUAL_QUAD_DISABLE (79632) */
	'P', 'R', 'I', 'M', 'I', 'T', 'I', 'V', 'E', '_', 'O', 'R', 'D', 'E', 'R', 'E', 'D', '_', 'P', 'I', 'X', 'E', 'L', '_', 'S', 'H', 'A', 'D', 'E', 'R', '\0', /* PRIMITIVE_ORDERED_PIXEL_SHADER (79650) */
	'E', 'X', 'E', 'C', '_', 'I', 'F', '_', 'O', 'V', 'E', 'R', 'L', 'A', 'P', 'P', 'E', 'D', '\0', /* EXEC_IF_OVERLAPPED (79681) */
	'P', 'O', 'P', 'S', '_', 'O', 'V', 'E', 'R', 'L', 'A', 'P', '_', 'N', 'U', 'M', '_', 'S', 'A', 'M', 'P', 'L', 'E', 'S', '\0', /* POPS_OVERLAP_NUM_SAMPLES (79700) */
	'P', 'R', 'E', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'D', 'E', 'P', 'T', 'H', '_', 'C', 'O', 'V', 'E', 'R', 'A', 'G', 'E', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* PRE_SHADER_DEPTH_COVERAGE_ENABLE (79725) */
	'U', 'C', 'P', '_', 'E', 'N', 'A', '_', '0', '\0', /* UCP_ENA_0 (79758) */
	'U', 'C', 'P', '_', 'E', 'N', 'A', '_', '1', '\0', /* UCP_ENA_1 (79768) */
	'U', 'C', 'P', '_', 'E', 'N', 'A', '_', '2', '\0', /* UCP_ENA_2 (79778) */
	'U', 'C', 'P', '_', 'E', 'N', 'A', '_', '3', '\0', /* UCP_ENA_3 (79788) */
	'U', 'C', 'P', '_', 'E', 'N', 'A', '_', '4', '\0', /* UCP_ENA_4 (79798) */
	'U', 'C', 'P', '_', 'E', 'N', 'A', '_', '5', '\0', /* UCP_ENA_5 (79808) */
	'P', 'S', '_', 'U', 'C', 'P', '_', 'Y', '_', 'S', 'C', 'A', 'L', 'E', '_', 'N', 'E', 'G', '\0', /* PS_UCP_Y_SCALE_NEG (79818) */
	'P', 'S', '_', 'U', 'C', 'P', '_', 'M', 'O', 'D', 'E', '\0', /* PS_UCP_MODE (79837) */
	'C', 'L', 'I', 'P', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* CLIP_DISABLE (79849) */
	'U', 'C', 'P', '_', 'C', 'U', 'L', 'L', '_', 'O', 'N', 'L', 'Y', '_', 'E', 'N', 'A', '\0', /* UCP_CULL_ONLY_ENA (79862) */
	'B', 'O', 'U', 'N', 'D', 'A', 'R', 'Y', '_', 'E', 'D', 'G', 'E', '_', 'F', 'L', 'A', 'G', '_', 'E', 'N', 'A', '\0', /* BOUNDARY_EDGE_FLAG_ENA (79880) */
	'D', 'X', '_', 'C', 'L', 'I', 'P', '_', 'S', 'P', 'A', 'C', 'E', '_', 'D', 'E', 'F', '\0', /* DX_CLIP_SPACE_DEF (79903) */
	'D', 'I', 'S', '_', 'C', 'L', 'I', 'P', '_', 'E', 'R', 'R', '_', 'D', 'E', 'T', 'E', 'C', 'T', '\0', /* DIS_CLIP_ERR_DETECT (79921) */
	'V', 'T', 'X', '_', 'K', 'I', 'L', 'L', '_', 'O', 'R', '\0', /* VTX_KILL_OR (79941) */
	'D', 'X', '_', 'R', 'A', 'S', 'T', 'E', 'R', 'I', 'Z', 'A', 'T', 'I', 'O', 'N', '_', 'K', 'I', 'L', 'L', '\0', /* DX_RASTERIZATION_KILL (79953) */
	'D', 'X', '_', 'L', 'I', 'N', 'E', 'A', 'R', '_', 'A', 'T', 'T', 'R', '_', 'C', 'L', 'I', 'P', '_', 'E', 'N', 'A', '\0', /* DX_LINEAR_ATTR_CLIP_ENA (79975) */
	'V', 'T', 'E', '_', 'V', 'P', 'O', 'R', 'T', '_', 'P', 'R', 'O', 'V', 'O', 'K', 'E', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* VTE_VPORT_PROVOKE_DISABLE (79999) */
	'Z', 'C', 'L', 'I', 'P', '_', 'N', 'E', 'A', 'R', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* ZCLIP_NEAR_DISABLE (80025) */
	'Z', 'C', 'L', 'I', 'P', '_', 'F', 'A', 'R', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* ZCLIP_FAR_DISABLE (80044) */
	'Z', 'C', 'L', 'I', 'P', '_', 'P', 'R', 'O', 'G', '_', 'N', 'E', 'A', 'R', '_', 'E', 'N', 'A', '\0', /* ZCLIP_PROG_NEAR_ENA (80062) */
	'C', 'U', 'L', 'L', '_', 'F', 'R', 'O', 'N', 'T', '\0', /* CULL_FRONT (80082) */
	'C', 'U', 'L', 'L', '_', 'B', 'A', 'C', 'K', '\0', /* CULL_BACK (80093) */
	'X', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'P', 'O', 'L', 'Y', '_', 'M', 'O', 'D', 'E', '\0', /* X_DISABLE_POLY_MODE (80103, 80113) */
	'X', '_', 'D', 'U', 'A', 'L', '_', 'M', 'O', 'D', 'E', '\0', /* X_DUAL_MODE (80123) */
	'X', '_', 'D', 'R', 'A', 'W', '_', 'P', 'O', 'I', 'N', 'T', 'S', '\0', /* X_DRAW_POINTS (80135) */
	'X', '_', 'D', 'R', 'A', 'W', '_', 'L', 'I', 'N', 'E', 'S', '\0', /* X_DRAW_LINES (80149) */
	'X', '_', 'D', 'R', 'A', 'W', '_', 'T', 'R', 'I', 'A', 'N', 'G', 'L', 'E', 'S', '\0', /* X_DRAW_TRIANGLES (80162) */
	'P', 'O', 'L', 'Y', 'M', 'O', 'D', 'E', '_', 'F', 'R', 'O', 'N', 'T', '_', 'P', 'T', 'Y', 'P', 'E', '\0', /* POLYMODE_FRONT_PTYPE (80179) */
	'P', 'O', 'L', 'Y', 'M', 'O', 'D', 'E', '_', 'B', 'A', 'C', 'K', '_', 'P', 'T', 'Y', 'P', 'E', '\0', /* POLYMODE_BACK_PTYPE (80200) */
	'P', 'O', 'L', 'Y', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', 'F', 'R', 'O', 'N', 'T', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* POLY_OFFSET_FRONT_ENABLE (80220) */
	'P', 'O', 'L', 'Y', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', 'B', 'A', 'C', 'K', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* POLY_OFFSET_BACK_ENABLE (80245) */
	'P', 'O', 'L', 'Y', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', 'P', 'A', 'R', 'A', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* POLY_OFFSET_PARA_ENABLE (80269) */
	'V', 'T', 'X', '_', 'W', 'I', 'N', 'D', 'O', 'W', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* VTX_WINDOW_OFFSET_ENABLE (80293) */
	'P', 'R', 'O', 'V', 'O', 'K', 'I', 'N', 'G', '_', 'V', 'T', 'X', '_', 'L', 'A', 'S', 'T', '\0', /* PROVOKING_VTX_LAST (80318) */
	'P', 'E', 'R', 'S', 'P', '_', 'C', 'O', 'R', 'R', '_', 'D', 'I', 'S', '\0', /* PERSP_CORR_DIS (80337) */
	'M', 'U', 'L', 'T', 'I', '_', 'P', 'R', 'I', 'M', '_', 'I', 'B', '_', 'E', 'N', 'A', '\0', /* MULTI_PRIM_IB_ENA (80352) */
	'R', 'I', 'G', 'H', 'T', '_', 'T', 'R', 'I', 'A', 'N', 'G', 'L', 'E', '_', 'A', 'L', 'T', 'E', 'R', 'N', 'A', 'T', 'E', '_', 'G', 'R', 'A', 'D', 'I', 'E', 'N', 'T', '_', 'R', 'E', 'F', '\0', /* RIGHT_TRIANGLE_ALTERNATE_GRADIENT_REF (80370) */
	'N', 'E', 'W', '_', 'Q', 'U', 'A', 'D', '_', 'D', 'E', 'C', 'O', 'M', 'P', 'O', 'S', 'I', 'T', 'I', 'O', 'N', '\0', /* NEW_QUAD_DECOMPOSITION (80408) */
	'K', 'E', 'E', 'P', '_', 'T', 'O', 'G', 'E', 'T', 'H', 'E', 'R', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* KEEP_TOGETHER_ENABLE (80431) */
	'V', 'P', 'O', 'R', 'T', '_', 'X', '_', 'S', 'C', 'A', 'L', 'E', '_', 'E', 'N', 'A', '\0', /* VPORT_X_SCALE_ENA (80452) */
	'V', 'P', 'O', 'R', 'T', '_', 'X', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', 'E', 'N', 'A', '\0', /* VPORT_X_OFFSET_ENA (80470) */
	'V', 'P', 'O', 'R', 'T', '_', 'Y', '_', 'S', 'C', 'A', 'L', 'E', '_', 'E', 'N', 'A', '\0', /* VPORT_Y_SCALE_ENA (80489) */
	'V', 'P', 'O', 'R', 'T', '_', 'Y', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', 'E', 'N', 'A', '\0', /* VPORT_Y_OFFSET_ENA (80507) */
	'V', 'P', 'O', 'R', 'T', '_', 'Z', '_', 'S', 'C', 'A', 'L', 'E', '_', 'E', 'N', 'A', '\0', /* VPORT_Z_SCALE_ENA (80526) */
	'V', 'P', 'O', 'R', 'T', '_', 'Z', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', 'E', 'N', 'A', '\0', /* VPORT_Z_OFFSET_ENA (80544) */
	'V', 'T', 'X', '_', 'X', 'Y', '_', 'F', 'M', 'T', '\0', /* VTX_XY_FMT (80563) */
	'V', 'T', 'X', '_', 'Z', '_', 'F', 'M', 'T', '\0', /* VTX_Z_FMT (80574) */
	'V', 'T', 'X', '_', 'W', '0', '_', 'F', 'M', 'T', '\0', /* VTX_W0_FMT (80584) */
	'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'R', 'E', 'F', '\0', /* PERFCOUNTER_REF (80595) */
	'C', 'L', 'I', 'P', '_', 'D', 'I', 'S', 'T', '_', 'E', 'N', 'A', '_', '0', '\0', /* CLIP_DIST_ENA_0 (80611) */
	'C', 'L', 'I', 'P', '_', 'D', 'I', 'S', 'T', '_', 'E', 'N', 'A', '_', '1', '\0', /* CLIP_DIST_ENA_1 (80627) */
	'C', 'L', 'I', 'P', '_', 'D', 'I', 'S', 'T', '_', 'E', 'N', 'A', '_', '2', '\0', /* CLIP_DIST_ENA_2 (80643) */
	'C', 'L', 'I', 'P', '_', 'D', 'I', 'S', 'T', '_', 'E', 'N', 'A', '_', '3', '\0', /* CLIP_DIST_ENA_3 (80659) */
	'C', 'L', 'I', 'P', '_', 'D', 'I', 'S', 'T', '_', 'E', 'N', 'A', '_', '4', '\0', /* CLIP_DIST_ENA_4 (80675) */
	'C', 'L', 'I', 'P', '_', 'D', 'I', 'S', 'T', '_', 'E', 'N', 'A', '_', '5', '\0', /* CLIP_DIST_ENA_5 (80691) */
	'C', 'L', 'I', 'P', '_', 'D', 'I', 'S', 'T', '_', 'E', 'N', 'A', '_', '6', '\0', /* CLIP_DIST_ENA_6 (80707) */
	'C', 'L', 'I', 'P', '_', 'D', 'I', 'S', 'T', '_', 'E', 'N', 'A', '_', '7', '\0', /* CLIP_DIST_ENA_7 (80723) */
	'C', 'U', 'L', 'L', '_', 'D', 'I', 'S', 'T', '_', 'E', 'N', 'A', '_', '0', '\0', /* CULL_DIST_ENA_0 (80739) */
	'C', 'U', 'L', 'L', '_', 'D', 'I', 'S', 'T', '_', 'E', 'N', 'A', '_', '1', '\0', /* CULL_DIST_ENA_1 (80755) */
	'C', 'U', 'L', 'L', '_', 'D', 'I', 'S', 'T', '_', 'E', 'N', 'A', '_', '2', '\0', /* CULL_DIST_ENA_2 (80771) */
	'C', 'U', 'L', 'L', '_', 'D', 'I', 'S', 'T', '_', 'E', 'N', 'A', '_', '3', '\0', /* CULL_DIST_ENA_3 (80787) */
	'C', 'U', 'L', 'L', '_', 'D', 'I', 'S', 'T', '_', 'E', 'N', 'A', '_', '4', '\0', /* CULL_DIST_ENA_4 (80803) */
	'C', 'U', 'L', 'L', '_', 'D', 'I', 'S', 'T', '_', 'E', 'N', 'A', '_', '5', '\0', /* CULL_DIST_ENA_5 (80819) */
	'C', 'U', 'L', 'L', '_', 'D', 'I', 'S', 'T', '_', 'E', 'N', 'A', '_', '6', '\0', /* CULL_DIST_ENA_6 (80835) */
	'C', 'U', 'L', 'L', '_', 'D', 'I', 'S', 'T', '_', 'E', 'N', 'A', '_', '7', '\0', /* CULL_DIST_ENA_7 (80851) */
	'U', 'S', 'E', '_', 'V', 'T', 'X', '_', 'P', 'O', 'I', 'N', 'T', '_', 'S', 'I', 'Z', 'E', '\0', /* USE_VTX_POINT_SIZE (80867) */
	'U', 'S', 'E', '_', 'V', 'T', 'X', '_', 'E', 'D', 'G', 'E', '_', 'F', 'L', 'A', 'G', '\0', /* USE_VTX_EDGE_FLAG (80886, 80899) */
	'U', 'S', 'E', '_', 'V', 'T', 'X', '_', 'R', 'E', 'N', 'D', 'E', 'R', '_', 'T', 'A', 'R', 'G', 'E', 'T', '_', 'I', 'N', 'D', 'X', '\0', /* USE_VTX_RENDER_TARGET_INDX (80904) */
	'U', 'S', 'E', '_', 'V', 'T', 'X', '_', 'V', 'I', 'E', 'W', 'P', 'O', 'R', 'T', '_', 'I', 'N', 'D', 'X', '\0', /* USE_VTX_VIEWPORT_INDX (80931) */
	'U', 'S', 'E', '_', 'V', 'T', 'X', '_', 'K', 'I', 'L', 'L', '_', 'F', 'L', 'A', 'G', '\0', /* USE_VTX_KILL_FLAG (80953) */
	'V', 'S', '_', 'O', 'U', 'T', '_', 'M', 'I', 'S', 'C', '_', 'V', 'E', 'C', '_', 'E', 'N', 'A', '\0', /* VS_OUT_MISC_VEC_ENA (80971) */
	'V', 'S', '_', 'O', 'U', 'T', '_', 'C', 'C', 'D', 'I', 'S', 'T', '0', '_', 'V', 'E', 'C', '_', 'E', 'N', 'A', '\0', /* VS_OUT_CCDIST0_VEC_ENA (80991) */
	'V', 'S', '_', 'O', 'U', 'T', '_', 'C', 'C', 'D', 'I', 'S', 'T', '1', '_', 'V', 'E', 'C', '_', 'E', 'N', 'A', '\0', /* VS_OUT_CCDIST1_VEC_ENA (81014) */
	'V', 'S', '_', 'O', 'U', 'T', '_', 'M', 'I', 'S', 'C', '_', 'S', 'I', 'D', 'E', '_', 'B', 'U', 'S', '_', 'E', 'N', 'A', '\0', /* VS_OUT_MISC_SIDE_BUS_ENA (81037) */
	'U', 'S', 'E', '_', 'V', 'T', 'X', '_', 'G', 'S', '_', 'C', 'U', 'T', '_', 'F', 'L', 'A', 'G', '\0', /* USE_VTX_GS_CUT_FLAG (81062) */
	'U', 'S', 'E', '_', 'V', 'T', 'X', '_', 'S', 'H', 'D', '_', 'O', 'B', 'J', 'P', 'R', 'I', 'M', '_', 'I', 'D', '\0', /* USE_VTX_SHD_OBJPRIM_ID (81082) */
	'U', 'S', 'E', '_', 'V', 'T', 'X', '_', 'L', 'I', 'N', 'E', '_', 'W', 'I', 'D', 'T', 'H', '\0', /* USE_VTX_LINE_WIDTH (81105) */
	'V', 'T', 'E', '_', 'X', 'Y', '_', 'I', 'N', 'F', '_', 'D', 'I', 'S', 'C', 'A', 'R', 'D', '\0', /* VTE_XY_INF_DISCARD (81124) */
	'V', 'T', 'E', '_', 'Z', '_', 'I', 'N', 'F', '_', 'D', 'I', 'S', 'C', 'A', 'R', 'D', '\0', /* VTE_Z_INF_DISCARD (81143) */
	'V', 'T', 'E', '_', 'W', '_', 'I', 'N', 'F', '_', 'D', 'I', 'S', 'C', 'A', 'R', 'D', '\0', /* VTE_W_INF_DISCARD (81161) */
	'V', 'T', 'E', '_', '0', 'X', 'N', 'A', 'N', 'I', 'N', 'F', '_', 'I', 'S', '_', '0', '\0', /* VTE_0XNANINF_IS_0 (81179) */
	'V', 'T', 'E', '_', 'X', 'Y', '_', 'N', 'A', 'N', '_', 'R', 'E', 'T', 'A', 'I', 'N', '\0', /* VTE_XY_NAN_RETAIN (81197) */
	'V', 'T', 'E', '_', 'Z', '_', 'N', 'A', 'N', '_', 'R', 'E', 'T', 'A', 'I', 'N', '\0', /* VTE_Z_NAN_RETAIN (81215) */
	'V', 'T', 'E', '_', 'W', '_', 'N', 'A', 'N', '_', 'R', 'E', 'T', 'A', 'I', 'N', '\0', /* VTE_W_NAN_RETAIN (81232) */
	'V', 'T', 'E', '_', 'W', '_', 'R', 'E', 'C', 'I', 'P', '_', 'N', 'A', 'N', '_', 'I', 'S', '_', '0', '\0', /* VTE_W_RECIP_NAN_IS_0 (81249) */
	'V', 'S', '_', 'X', 'Y', '_', 'N', 'A', 'N', '_', 'T', 'O', '_', 'I', 'N', 'F', '\0', /* VS_XY_NAN_TO_INF (81270) */
	'V', 'S', '_', 'X', 'Y', '_', 'I', 'N', 'F', '_', 'R', 'E', 'T', 'A', 'I', 'N', '\0', /* VS_XY_INF_RETAIN (81287) */
	'V', 'S', '_', 'Z', '_', 'N', 'A', 'N', '_', 'T', 'O', '_', 'I', 'N', 'F', '\0', /* VS_Z_NAN_TO_INF (81304) */
	'V', 'S', '_', 'Z', '_', 'I', 'N', 'F', '_', 'R', 'E', 'T', 'A', 'I', 'N', '\0', /* VS_Z_INF_RETAIN (81320) */
	'V', 'S', '_', 'W', '_', 'N', 'A', 'N', '_', 'T', 'O', '_', 'I', 'N', 'F', '\0', /* VS_W_NAN_TO_INF (81336) */
	'V', 'S', '_', 'W', '_', 'I', 'N', 'F', '_', 'R', 'E', 'T', 'A', 'I', 'N', '\0', /* VS_W_INF_RETAIN (81352) */
	'V', 'S', '_', 'C', 'L', 'I', 'P', '_', 'D', 'I', 'S', 'T', '_', 'I', 'N', 'F', '_', 'D', 'I', 'S', 'C', 'A', 'R', 'D', '\0', /* VS_CLIP_DIST_INF_DISCARD (81368) */
	'V', 'T', 'E', '_', 'N', 'O', '_', 'O', 'U', 'T', 'P', 'U', 'T', '_', 'N', 'E', 'G', '_', '0', '\0', /* VTE_NO_OUTPUT_NEG_0 (81393) */
	'L', 'I', 'N', 'E', '_', 'S', 'T', 'I', 'P', 'P', 'L', 'E', '_', 'R', 'E', 'S', 'E', 'T', '\0', /* LINE_STIPPLE_RESET (81413) */
	'E', 'X', 'P', 'A', 'N', 'D', '_', 'F', 'U', 'L', 'L', '_', 'L', 'E', 'N', 'G', 'T', 'H', '\0', /* EXPAND_FULL_LENGTH (81432) */
	'F', 'R', 'A', 'C', 'T', 'I', 'O', 'N', 'A', 'L', '_', 'A', 'C', 'C', 'U', 'M', '\0', /* FRACTIONAL_ACCUM (81451) */
	'D', 'I', 'A', 'M', 'O', 'N', 'D', '_', 'A', 'D', 'J', 'U', 'S', 'T', '\0', /* DIAMOND_ADJUST (81468) */
	'T', 'R', 'I', 'A', 'N', 'G', 'L', 'E', '_', 'F', 'I', 'L', 'T', 'E', 'R', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* TRIANGLE_FILTER_DISABLE (81483) */
	'L', 'I', 'N', 'E', '_', 'F', 'I', 'L', 'T', 'E', 'R', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* LINE_FILTER_DISABLE (81507) */
	'P', 'O', 'I', 'N', 'T', '_', 'F', 'I', 'L', 'T', 'E', 'R', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* POINT_FILTER_DISABLE (81527) */
	'R', 'E', 'C', 'T', 'A', 'N', 'G', 'L', 'E', '_', 'F', 'I', 'L', 'T', 'E', 'R', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* RECTANGLE_FILTER_DISABLE (81548) */
	'T', 'R', 'I', 'A', 'N', 'G', 'L', 'E', '_', 'E', 'X', 'P', 'A', 'N', 'D', '_', 'E', 'N', 'A', '\0', /* TRIANGLE_EXPAND_ENA (81573) */
	'L', 'I', 'N', 'E', '_', 'E', 'X', 'P', 'A', 'N', 'D', '_', 'E', 'N', 'A', '\0', /* LINE_EXPAND_ENA (81593) */
	'P', 'O', 'I', 'N', 'T', '_', 'E', 'X', 'P', 'A', 'N', 'D', '_', 'E', 'N', 'A', '\0', /* POINT_EXPAND_ENA (81609) */
	'R', 'E', 'C', 'T', 'A', 'N', 'G', 'L', 'E', '_', 'E', 'X', 'P', 'A', 'N', 'D', '_', 'E', 'N', 'A', '\0', /* RECTANGLE_EXPAND_ENA (81626) */
	'P', 'R', 'I', 'M', '_', 'E', 'X', 'P', 'A', 'N', 'D', '_', 'C', 'O', 'N', 'S', 'T', 'A', 'N', 'T', '\0', /* PRIM_EXPAND_CONSTANT (81647) */
	'X', 'M', 'A', 'X', '_', 'R', 'I', 'G', 'H', 'T', '_', 'E', 'X', 'C', 'L', 'U', 'S', 'I', 'O', 'N', '\0', /* XMAX_RIGHT_EXCLUSION (81668) */
	'Y', 'M', 'A', 'X', '_', 'B', 'O', 'T', 'T', 'O', 'M', '_', 'E', 'X', 'C', 'L', 'U', 'S', 'I', 'O', 'N', '\0', /* YMAX_BOTTOM_EXCLUSION (81689) */
	'S', 'M', 'A', 'L', 'L', '_', 'P', 'R', 'I', 'M', '_', 'F', 'I', 'L', 'T', 'E', 'R', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* SMALL_PRIM_FILTER_ENABLE (81711) */
	'S', 'R', 'B', 'S', 'L', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* SRBSL_ENABLE (81736) */
	'S', 'C', '_', '1', 'X', 'M', 'S', 'A', 'A', '_', 'C', 'O', 'M', 'P', 'A', 'T', 'I', 'B', 'L', 'E', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* SC_1XMSAA_COMPATIBLE_DISABLE (81749) */
	'O', 'B', 'J', '_', 'I', 'D', '_', 'S', 'E', 'L', '\0', /* OBJ_ID_SEL (81778) */
	'A', 'D', 'D', '_', 'P', 'I', 'P', 'E', 'D', '_', 'P', 'R', 'I', 'M', '_', 'I', 'D', '\0', /* ADD_PIPED_PRIM_ID (81789) */
	'V', 'E', 'R', 'T', 'E', 'X', '_', 'R', 'E', 'U', 'S', 'E', '_', 'O', 'F', 'F', '\0', /* VERTEX_REUSE_OFF (81807) */
	'I', 'N', 'D', 'E', 'X', '_', 'B', 'U', 'F', '_', 'E', 'D', 'G', 'E', '_', 'F', 'L', 'A', 'G', '_', 'E', 'N', 'A', '\0', /* INDEX_BUF_EDGE_FLAG_ENA (81824) */
	'D', 'I', 'S', 'C', 'A', 'R', 'D', '_', '0', '_', 'A', 'R', 'E', 'A', '_', 'T', 'R', 'I', 'A', 'N', 'G', 'L', 'E', 'S', '\0', /* DISCARD_0_AREA_TRIANGLES (81848) */
	'D', 'I', 'S', 'C', 'A', 'R', 'D', '_', '0', '_', 'A', 'R', 'E', 'A', '_', 'L', 'I', 'N', 'E', 'S', '\0', /* DISCARD_0_AREA_LINES (81873) */
	'D', 'I', 'S', 'C', 'A', 'R', 'D', '_', '0', '_', 'A', 'R', 'E', 'A', '_', 'P', 'O', 'I', 'N', 'T', 'S', '\0', /* DISCARD_0_AREA_POINTS (81894) */
	'D', 'I', 'S', 'C', 'A', 'R', 'D', '_', '0', '_', 'A', 'R', 'E', 'A', '_', 'R', 'E', 'C', 'T', 'A', 'N', 'G', 'L', 'E', 'S', '\0', /* DISCARD_0_AREA_RECTANGLES (81916) */
	'U', 'S', 'E', '_', 'P', 'R', 'O', 'V', 'O', 'K', 'I', 'N', 'G', '_', 'Z', 'W', '\0', /* USE_PROVOKING_ZW (81942) */
	'S', 'T', 'E', 'R', 'E', 'O', '_', 'M', 'O', 'D', 'E', '\0', /* STEREO_MODE (81959) */
	'R', 'T', '_', 'S', 'L', 'I', 'C', 'E', '_', 'M', 'O', 'D', 'E', '\0', /* RT_SLICE_MODE (81971) */
	'R', 'T', '_', 'S', 'L', 'I', 'C', 'E', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* RT_SLICE_OFFSET (81985) */
	'V', 'P', '_', 'I', 'D', '_', 'M', 'O', 'D', 'E', '\0', /* VP_ID_MODE (82001) */
	'V', 'P', '_', 'I', 'D', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* VP_ID_OFFSET (82012) */
	'M', 'I', 'N', '_', 'S', 'I', 'Z', 'E', '\0', /* MIN_SIZE (82025) */
	'L', 'I', 'N', 'E', '_', 'P', 'A', 'T', 'T', 'E', 'R', 'N', '\0', /* LINE_PATTERN (82034) */
	'R', 'E', 'P', 'E', 'A', 'T', '_', 'C', 'O', 'U', 'N', 'T', '\0', /* REPEAT_COUNT (82047) */
	'P', 'A', 'T', 'T', 'E', 'R', 'N', '_', 'B', 'I', 'T', '_', 'O', 'R', 'D', 'E', 'R', '\0', /* PATTERN_BIT_ORDER (82060) */
	'A', 'U', 'T', 'O', '_', 'R', 'E', 'S', 'E', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* AUTO_RESET_CNTL (82078) */
	'P', 'A', 'T', 'H', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PATH_SELECT (82094) */
	'T', 'E', 'S', 'S', '_', 'M', 'O', 'D', 'E', '\0', /* TESS_MODE (82106) */
	'D', 'I', '_', 'P', 'T', '_', 'N', 'O', 'N', 'E', '\0', /* DI_PT_NONE (82116) */
	'D', 'I', '_', 'P', 'T', '_', 'P', 'O', 'I', 'N', 'T', 'L', 'I', 'S', 'T', '\0', /* DI_PT_POINTLIST (82127, 82133) */
	'D', 'I', '_', 'P', 'T', '_', 'L', 'I', 'N', 'E', 'L', 'I', 'S', 'T', '\0', /* DI_PT_LINELIST (82143) */
	'D', 'I', '_', 'P', 'T', '_', 'L', 'I', 'N', 'E', 'S', 'T', 'R', 'I', 'P', '\0', /* DI_PT_LINESTRIP (82158, 82164) */
	'D', 'I', '_', 'P', 'T', '_', 'T', 'R', 'I', 'L', 'I', 'S', 'T', '\0', /* DI_PT_TRILIST (82174) */
	'D', 'I', '_', 'P', 'T', '_', 'T', 'R', 'I', 'F', 'A', 'N', '\0', /* DI_PT_TRIFAN (82188) */
	'D', 'I', '_', 'P', 'T', '_', 'T', 'R', 'I', 'S', 'T', 'R', 'I', 'P', '\0', /* DI_PT_TRISTRIP (82201, 82207) */
	'D', 'I', '_', 'P', 'T', '_', '2', 'D', '_', 'R', 'E', 'C', 'T', 'A', 'N', 'G', 'L', 'E', '\0', /* DI_PT_2D_RECTANGLE (82216) */
	'D', 'I', '_', 'P', 'T', '_', 'U', 'N', 'U', 'S', 'E', 'D', '_', '1', '\0', /* DI_PT_UNUSED_1 (82235) */
	'D', 'I', '_', 'P', 'T', '_', 'P', 'A', 'T', 'C', 'H', '\0', /* DI_PT_PATCH (82250) */
	'D', 'I', '_', 'P', 'T', '_', 'L', 'I', 'N', 'E', 'L', 'I', 'S', 'T', '_', 'A', 'D', 'J', '\0', /* DI_PT_LINELIST_ADJ (82262) */
	'D', 'I', '_', 'P', 'T', '_', 'L', 'I', 'N', 'E', 'S', 'T', 'R', 'I', 'P', '_', 'A', 'D', 'J', '\0', /* DI_PT_LINESTRIP_ADJ (82281) */
	'D', 'I', '_', 'P', 'T', '_', 'T', 'R', 'I', 'L', 'I', 'S', 'T', '_', 'A', 'D', 'J', '\0', /* DI_PT_TRILIST_ADJ (82301) */
	'D', 'I', '_', 'P', 'T', '_', 'T', 'R', 'I', 'S', 'T', 'R', 'I', 'P', '_', 'A', 'D', 'J', '\0', /* DI_PT_TRISTRIP_ADJ (82319) */
	'D', 'I', '_', 'P', 'T', '_', 'U', 'N', 'U', 'S', 'E', 'D', '_', '3', '\0', /* DI_PT_UNUSED_3 (82338) */
	'D', 'I', '_', 'P', 'T', '_', 'U', 'N', 'U', 'S', 'E', 'D', '_', '4', '\0', /* DI_PT_UNUSED_4 (82353) */
	'D', 'I', '_', 'P', 'T', '_', 'T', 'R', 'I', '_', 'W', 'I', 'T', 'H', '_', 'W', 'F', 'L', 'A', 'G', 'S', '\0', /* DI_PT_TRI_WITH_WFLAGS (82368) */
	'D', 'I', '_', 'P', 'T', '_', 'R', 'E', 'C', 'T', 'L', 'I', 'S', 'T', '\0', /* DI_PT_RECTLIST (82390, 82396) */
	'D', 'I', '_', 'P', 'T', '_', 'L', 'I', 'N', 'E', 'L', 'O', 'O', 'P', '\0', /* DI_PT_LINELOOP (82405) */
	'D', 'I', '_', 'P', 'T', '_', 'Q', 'U', 'A', 'D', 'L', 'I', 'S', 'T', '\0', /* DI_PT_QUADLIST (82420) */
	'D', 'I', '_', 'P', 'T', '_', 'Q', 'U', 'A', 'D', 'S', 'T', 'R', 'I', 'P', '\0', /* DI_PT_QUADSTRIP (82435) */
	'D', 'I', '_', 'P', 'T', '_', 'P', 'O', 'L', 'Y', 'G', 'O', 'N', '\0', /* DI_PT_POLYGON (82451) */
	'R', 'E', 'T', 'A', 'I', 'N', '_', 'O', 'R', 'D', 'E', 'R', '\0', /* RETAIN_ORDER (82465) */
	'R', 'E', 'T', 'A', 'I', 'N', '_', 'Q', 'U', 'A', 'D', 'S', '\0', /* RETAIN_QUADS (82478) */
	'P', 'R', 'I', 'M', '_', 'O', 'R', 'D', 'E', 'R', '\0', /* PRIM_ORDER (82491) */
	'C', 'O', 'M', 'P', '_', 'X', '_', 'E', 'N', '\0', /* COMP_X_EN (82502) */
	'C', 'O', 'M', 'P', '_', 'Y', '_', 'E', 'N', '\0', /* COMP_Y_EN (82512) */
	'C', 'O', 'M', 'P', '_', 'Z', '_', 'E', 'N', '\0', /* COMP_Z_EN (82522) */
	'C', 'O', 'M', 'P', '_', 'W', '_', 'E', 'N', '\0', /* COMP_W_EN (82532) */
	'S', 'H', 'I', 'F', 'T', '\0', /* SHIFT (82542) */
	'X', '_', 'C', 'O', 'N', 'V', '\0', /* X_CONV (82548, 82552) */
	'Y', '_', 'C', 'O', 'N', 'V', '\0', /* Y_CONV (82555) */
	'Z', '_', 'C', 'O', 'N', 'V', '\0', /* Z_CONV (82562) */
	'Z', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* Z_OFFSET (82569) */
	'W', '_', 'C', 'O', 'N', 'V', '\0', /* W_CONV (82578) */
	'G', 'S', '_', 'O', 'F', 'F', '\0', /* GS_OFF (82585) */
	'G', 'S', '_', 'S', 'C', 'E', 'N', 'A', 'R', 'I', 'O', '_', 'A', '\0', /* GS_SCENARIO_A (82592) */
	'G', 'S', '_', 'S', 'C', 'E', 'N', 'A', 'R', 'I', 'O', '_', 'B', '\0', /* GS_SCENARIO_B (82606) */
	'G', 'S', '_', 'S', 'C', 'E', 'N', 'A', 'R', 'I', 'O', '_', 'G', '\0', /* GS_SCENARIO_G (82620) */
	'G', 'S', '_', 'S', 'C', 'E', 'N', 'A', 'R', 'I', 'O', '_', 'C', '\0', /* GS_SCENARIO_C (82634) */
	'S', 'P', 'R', 'I', 'T', 'E', '_', 'E', 'N', '\0', /* SPRITE_EN (82648) */
	'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', '0', '\0', /* RESERVED_0 (82658) */
	'G', 'S', '_', 'C', 'U', 'T', '_', '1', '0', '2', '4', '\0', /* GS_CUT_1024 (82669) */
	'G', 'S', '_', 'C', 'U', 'T', '_', '5', '1', '2', '\0', /* GS_CUT_512 (82681) */
	'G', 'S', '_', 'C', 'U', 'T', '_', '2', '5', '6', '\0', /* GS_CUT_256 (82692) */
	'G', 'S', '_', 'C', 'U', 'T', '_', '1', '2', '8', '\0', /* GS_CUT_128 (82703) */
	'C', 'U', 'T', '_', 'M', 'O', 'D', 'E', '\0', /* CUT_MODE (82714) */
	'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', '1', '\0', /* RESERVED_1 (82723) */
	'G', 'S', '_', 'C', '_', 'P', 'A', 'C', 'K', '_', 'E', 'N', '\0', /* GS_C_PACK_EN (82734) */
	'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', '2', '\0', /* RESERVED_2 (82747) */
	'E', 'S', '_', 'P', 'A', 'S', 'S', 'T', 'H', 'R', 'U', '\0', /* ES_PASSTHRU (82758) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'M', 'O', 'D', 'E', '\0', /* COMPUTE_MODE (82770) */
	'F', 'A', 'S', 'T', '_', 'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'M', 'O', 'D', 'E', '\0', /* FAST_COMPUTE_MODE (82783) */
	'E', 'L', 'E', 'M', 'E', 'N', 'T', '_', 'I', 'N', 'F', 'O', '_', 'E', 'N', '\0', /* ELEMENT_INFO_EN (82801) */
	'P', 'A', 'R', 'T', 'I', 'A', 'L', '_', 'T', 'H', 'D', '_', 'A', 'T', '_', 'E', 'O', 'I', '\0', /* PARTIAL_THD_AT_EOI (82817) */
	'S', 'U', 'P', 'P', 'R', 'E', 'S', 'S', '_', 'C', 'U', 'T', 'S', '\0', /* SUPPRESS_CUTS (82836) */
	'E', 'S', '_', 'W', 'R', 'I', 'T', 'E', '_', 'O', 'P', 'T', 'I', 'M', 'I', 'Z', 'E', '\0', /* ES_WRITE_OPTIMIZE (82850) */
	'G', 'S', '_', 'W', 'R', 'I', 'T', 'E', '_', 'O', 'P', 'T', 'I', 'M', 'I', 'Z', 'E', '\0', /* GS_WRITE_OPTIMIZE (82868) */
	'O', 'N', 'C', 'H', 'I', 'P', '\0', /* ONCHIP (82886) */
	'E', 'S', '_', 'V', 'E', 'R', 'T', 'S', '_', 'P', 'E', 'R', '_', 'S', 'U', 'B', 'G', 'R', 'P', '\0', /* ES_VERTS_PER_SUBGRP (82893) */
	'G', 'S', '_', 'P', 'R', 'I', 'M', 'S', '_', 'P', 'E', 'R', '_', 'S', 'U', 'B', 'G', 'R', 'P', '\0', /* GS_PRIMS_PER_SUBGRP (82913) */
	'G', 'S', '_', 'I', 'N', 'S', 'T', '_', 'P', 'R', 'I', 'M', 'S', '_', 'I', 'N', '_', 'S', 'U', 'B', 'G', 'R', 'P', '\0', /* GS_INST_PRIMS_IN_SUBGRP (82933) */
	'M', 'S', 'A', 'A', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* MSAA_ENABLE (82957) */
	'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* VPORT_SCISSOR_ENABLE (82969) */
	'L', 'I', 'N', 'E', '_', 'S', 'T', 'I', 'P', 'P', 'L', 'E', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* LINE_STIPPLE_ENABLE (82990) */
	'S', 'E', 'N', 'D', '_', 'U', 'N', 'L', 'I', 'T', '_', 'S', 'T', 'I', 'L', 'E', 'S', '_', 'T', 'O', '_', 'P', 'K', 'R', '\0', /* SEND_UNLIT_STILES_TO_PKR (83010) */
	'S', 'C', 'A', 'L', 'E', '_', 'L', 'I', 'N', 'E', '_', 'W', 'I', 'D', 'T', 'H', '_', 'P', 'A', 'D', '\0', /* SCALE_LINE_WIDTH_PAD (83035) */
	'A', 'L', 'T', 'E', 'R', 'N', 'A', 'T', 'E', '_', 'R', 'B', 'S', '_', 'P', 'E', 'R', '_', 'T', 'I', 'L', 'E', '\0', /* ALTERNATE_RBS_PER_TILE (83056) */
	'C', 'O', 'A', 'R', 'S', 'E', '_', 'T', 'I', 'L', 'E', '_', 'S', 'T', 'A', 'R', 'T', 'S', '_', 'O', 'N', '_', 'E', 'V', 'E', 'N', '_', 'R', 'B', '\0', /* COARSE_TILE_STARTS_ON_EVEN_RB (83079) */
	'W', 'A', 'L', 'K', '_', 'S', 'I', 'Z', 'E', '\0', /* WALK_SIZE (83109) */
	'W', 'A', 'L', 'K', '_', 'A', 'L', 'I', 'G', 'N', 'M', 'E', 'N', 'T', '\0', /* WALK_ALIGNMENT (83119) */
	'W', 'A', 'L', 'K', '_', 'A', 'L', 'I', 'G', 'N', '8', '_', 'P', 'R', 'I', 'M', '_', 'F', 'I', 'T', 'S', '_', 'S', 'T', '\0', /* WALK_ALIGN8_PRIM_FITS_ST (83134) */
	'W', 'A', 'L', 'K', '_', 'F', 'E', 'N', 'C', 'E', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* WALK_FENCE_ENABLE (83159) */
	'W', 'A', 'L', 'K', '_', 'F', 'E', 'N', 'C', 'E', '_', 'S', 'I', 'Z', 'E', '\0', /* WALK_FENCE_SIZE (83177) */
	'S', 'U', 'P', 'E', 'R', 'T', 'I', 'L', 'E', '_', 'W', 'A', 'L', 'K', '_', 'O', 'R', 'D', 'E', 'R', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* SUPERTILE_WALK_ORDER_ENABLE (83193, 83198) */
	'T', 'I', 'L', 'E', '_', 'C', 'O', 'V', 'E', 'R', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* TILE_COVER_DISABLE (83221) */
	'T', 'I', 'L', 'E', '_', 'C', 'O', 'V', 'E', 'R', '_', 'N', 'O', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '\0', /* TILE_COVER_NO_SCISSOR (83240) */
	'Z', 'M', 'M', '_', 'L', 'I', 'N', 'E', '_', 'E', 'X', 'T', 'E', 'N', 'T', '\0', /* ZMM_LINE_EXTENT (83262) */
	'Z', 'M', 'M', '_', 'L', 'I', 'N', 'E', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* ZMM_LINE_OFFSET (83278) */
	'Z', 'M', 'M', '_', 'R', 'E', 'C', 'T', '_', 'E', 'X', 'T', 'E', 'N', 'T', '\0', /* ZMM_RECT_EXTENT (83294) */
	'K', 'I', 'L', 'L', '_', 'P', 'I', 'X', '_', 'P', 'O', 'S', 'T', '_', 'H', 'I', '_', 'Z', '\0', /* KILL_PIX_POST_HI_Z (83310) */
	'K', 'I', 'L', 'L', '_', 'P', 'I', 'X', '_', 'P', 'O', 'S', 'T', '_', 'D', 'E', 'T', 'A', 'I', 'L', '_', 'M', 'A', 'S', 'K', '\0', /* KILL_PIX_POST_DETAIL_MASK (83329) */
	'P', 'S', '_', 'I', 'T', 'E', 'R', '_', 'S', 'A', 'M', 'P', 'L', 'E', '\0', /* PS_ITER_SAMPLE (83355) */
	'M', 'U', 'L', 'T', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'E', 'N', 'G', 'I', 'N', 'E', '_', 'P', 'R', 'I', 'M', '_', 'D', 'I', 'S', 'C', 'A', 'R', 'D', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* MULTI_SHADER_ENGINE_PRIM_DISCARD_ENABLE (83370) */
	'M', 'U', 'L', 'T', 'I', '_', 'G', 'P', 'U', '_', 'S', 'U', 'P', 'E', 'R', 'T', 'I', 'L', 'E', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* MULTI_GPU_SUPERTILE_ENABLE (83410) */
	'G', 'P', 'U', '_', 'I', 'D', '_', 'O', 'V', 'E', 'R', 'R', 'I', 'D', 'E', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* GPU_ID_OVERRIDE_ENABLE (83437) */
	'G', 'P', 'U', '_', 'I', 'D', '_', 'O', 'V', 'E', 'R', 'R', 'I', 'D', 'E', '\0', /* GPU_ID_OVERRIDE (83460) */
	'M', 'U', 'L', 'T', 'I', '_', 'G', 'P', 'U', '_', 'P', 'R', 'I', 'M', '_', 'D', 'I', 'S', 'C', 'A', 'R', 'D', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* MULTI_GPU_PRIM_DISCARD_ENABLE (83476) */
	'F', 'O', 'R', 'C', 'E', '_', 'E', 'O', 'V', '_', 'C', 'N', 'T', 'D', 'W', 'N', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* FORCE_EOV_CNTDWN_ENABLE (83506) */
	'F', 'O', 'R', 'C', 'E', '_', 'E', 'O', 'V', '_', 'R', 'E', 'Z', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* FORCE_EOV_REZ_ENABLE (83530) */
	'O', 'U', 'T', '_', 'O', 'F', '_', 'O', 'R', 'D', 'E', 'R', '_', 'P', 'R', 'I', 'M', 'I', 'T', 'I', 'V', 'E', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* OUT_OF_ORDER_PRIMITIVE_ENABLE (83551) */
	'O', 'U', 'T', '_', 'O', 'F', '_', 'O', 'R', 'D', 'E', 'R', '_', 'W', 'A', 'T', 'E', 'R', '_', 'M', 'A', 'R', 'K', '\0', /* OUT_OF_ORDER_WATER_MARK (83581) */
	'O', 'U', 'T', 'P', 'R', 'I', 'M', '_', 'T', 'Y', 'P', 'E', '\0', /* OUTPRIM_TYPE (83605) */
	'O', 'U', 'T', 'P', 'R', 'I', 'M', '_', 'T', 'Y', 'P', 'E', '_', '1', '\0', /* OUTPRIM_TYPE_1 (83618) */
	'O', 'U', 'T', 'P', 'R', 'I', 'M', '_', 'T', 'Y', 'P', 'E', '_', '2', '\0', /* OUTPRIM_TYPE_2 (83633) */
	'O', 'U', 'T', 'P', 'R', 'I', 'M', '_', 'T', 'Y', 'P', 'E', '_', '3', '\0', /* OUTPRIM_TYPE_3 (83648) */
	'U', 'N', 'I', 'Q', 'U', 'E', '_', 'T', 'Y', 'P', 'E', '_', 'P', 'E', 'R', '_', 'S', 'T', 'R', 'E', 'A', 'M', '\0', /* UNIQUE_TYPE_PER_STREAM (83663) */
	'V', 'G', 'T', '_', 'I', 'N', 'D', 'E', 'X', '_', '1', '6', '\0', /* VGT_INDEX_16 (83686) */
	'V', 'G', 'T', '_', 'I', 'N', 'D', 'E', 'X', '_', '3', '2', '\0', /* VGT_INDEX_32 (83699) */
	'V', 'G', 'T', '_', 'I', 'N', 'D', 'E', 'X', '_', '8', '\0', /* VGT_INDEX_8 (83712) */
	'V', 'G', 'T', '_', 'D', 'M', 'A', '_', 'S', 'W', 'A', 'P', '_', 'N', 'O', 'N', 'E', '\0', /* VGT_DMA_SWAP_NONE (83724) */
	'V', 'G', 'T', '_', 'D', 'M', 'A', '_', 'S', 'W', 'A', 'P', '_', '1', '6', '_', 'B', 'I', 'T', '\0', /* VGT_DMA_SWAP_16_BIT (83742) */
	'V', 'G', 'T', '_', 'D', 'M', 'A', '_', 'S', 'W', 'A', 'P', '_', '3', '2', '_', 'B', 'I', 'T', '\0', /* VGT_DMA_SWAP_32_BIT (83762) */
	'V', 'G', 'T', '_', 'D', 'M', 'A', '_', 'S', 'W', 'A', 'P', '_', 'W', 'O', 'R', 'D', '\0', /* VGT_DMA_SWAP_WORD (83782) */
	'S', 'W', 'A', 'P', '_', 'M', 'O', 'D', 'E', '\0', /* SWAP_MODE (83800) */
	'V', 'G', 'T', '_', 'D', 'M', 'A', '_', 'B', 'U', 'F', '_', 'M', 'E', 'M', '\0', /* VGT_DMA_BUF_MEM (83810) */
	'V', 'G', 'T', '_', 'D', 'M', 'A', '_', 'B', 'U', 'F', '_', 'R', 'I', 'N', 'G', '\0', /* VGT_DMA_BUF_RING (83826) */
	'V', 'G', 'T', '_', 'D', 'M', 'A', '_', 'B', 'U', 'F', '_', 'S', 'E', 'T', 'U', 'P', '\0', /* VGT_DMA_BUF_SETUP (83843) */
	'V', 'G', 'T', '_', 'D', 'M', 'A', '_', 'P', 'T', 'R', '_', 'U', 'P', 'D', 'A', 'T', 'E', '\0', /* VGT_DMA_PTR_UPDATE (83861) */
	'B', 'U', 'F', '_', 'T', 'Y', 'P', 'E', '\0', /* BUF_TYPE (83880) */
	'V', 'G', 'T', '_', 'P', 'O', 'L', 'I', 'C', 'Y', '_', 'L', 'R', 'U', '\0', /* VGT_POLICY_LRU (83889) */
	'V', 'G', 'T', '_', 'P', 'O', 'L', 'I', 'C', 'Y', '_', 'S', 'T', 'R', 'E', 'A', 'M', '\0', /* VGT_POLICY_STREAM (83904) */
	'V', 'G', 'T', '_', 'P', 'O', 'L', 'I', 'C', 'Y', '_', 'B', 'Y', 'P', 'A', 'S', 'S', '\0', /* VGT_POLICY_BYPASS (83922) */
	'R', 'D', 'R', 'E', 'Q', '_', 'P', 'O', 'L', 'I', 'C', 'Y', '\0', /* RDREQ_POLICY (83940) */
	'A', 'T', 'C', '\0', /* ATC (83953) */
	'R', 'E', 'Q', '_', 'P', 'A', 'T', 'H', '\0', /* REQ_PATH (83957) */
	'M', 'T', 'Y', 'P', 'E', '\0', /* MTYPE (83966) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'R', 'E', 'S', 'E', 'T', '_', 'O', 'N', '_', 'E', 'O', 'I', '\0', /* DISABLE_RESET_ON_EOI (83972) */
	'N', 'G', 'G', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'P', 'R', 'O', 'V', 'O', 'K', '_', 'R', 'E', 'U', 'S', 'E', '\0', /* NGG_DISABLE_PROVOK_REUSE (83993) */
	'R', 'e', 's', 'e', 'r', 'v', 'e', 'd', '_', '0', 'x', '0', '0', '\0', /* Reserved_0x00 (84018) */
	'S', 'A', 'M', 'P', 'L', 'E', '_', 'S', 'T', 'R', 'E', 'A', 'M', 'O', 'U', 'T', 'S', 'T', 'A', 'T', 'S', '1', '\0', /* SAMPLE_STREAMOUTSTATS1 (84032) */
	'S', 'A', 'M', 'P', 'L', 'E', '_', 'S', 'T', 'R', 'E', 'A', 'M', 'O', 'U', 'T', 'S', 'T', 'A', 'T', 'S', '2', '\0', /* SAMPLE_STREAMOUTSTATS2 (84055) */
	'S', 'A', 'M', 'P', 'L', 'E', '_', 'S', 'T', 'R', 'E', 'A', 'M', 'O', 'U', 'T', 'S', 'T', 'A', 'T', 'S', '3', '\0', /* SAMPLE_STREAMOUTSTATS3 (84078) */
	'C', 'A', 'C', 'H', 'E', '_', 'F', 'L', 'U', 'S', 'H', '_', 'T', 'S', '\0', /* CACHE_FLUSH_TS (84101) */
	'C', 'O', 'N', 'T', 'E', 'X', 'T', '_', 'D', 'O', 'N', 'E', '\0', /* CONTEXT_DONE (84116) */
	'C', 'A', 'C', 'H', 'E', '_', 'F', 'L', 'U', 'S', 'H', '\0', /* CACHE_FLUSH (84129) */
	'C', 'S', '_', 'P', 'A', 'R', 'T', 'I', 'A', 'L', '_', 'F', 'L', 'U', 'S', 'H', '\0', /* CS_PARTIAL_FLUSH (84141) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'E', 'A', 'M', 'O', 'U', 'T', '_', 'S', 'Y', 'N', 'C', '\0', /* VGT_STREAMOUT_SYNC (84158) */
	'S', 'E', 'T', '_', 'F', 'E', '_', 'I', 'D', '\0', /* SET_FE_ID (84177) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'E', 'A', 'M', 'O', 'U', 'T', '_', 'R', 'E', 'S', 'E', 'T', '\0', /* VGT_STREAMOUT_RESET (84187) */
	'E', 'N', 'D', '_', 'O', 'F', '_', 'P', 'I', 'P', 'E', '_', 'I', 'N', 'C', 'R', '_', 'D', 'E', '\0', /* END_OF_PIPE_INCR_DE (84207) */
	'E', 'N', 'D', '_', 'O', 'F', '_', 'P', 'I', 'P', 'E', '_', 'I', 'B', '_', 'E', 'N', 'D', '\0', /* END_OF_PIPE_IB_END (84227) */
	'R', 'S', 'T', '_', 'P', 'I', 'X', '_', 'C', 'N', 'T', '\0', /* RST_PIX_CNT (84246) */
	'B', 'R', 'E', 'A', 'K', '_', 'B', 'A', 'T', 'C', 'H', '\0', /* BREAK_BATCH (84258) */
	'V', 'S', '_', 'P', 'A', 'R', 'T', 'I', 'A', 'L', '_', 'F', 'L', 'U', 'S', 'H', '\0', /* VS_PARTIAL_FLUSH (84270) */
	'P', 'S', '_', 'P', 'A', 'R', 'T', 'I', 'A', 'L', '_', 'F', 'L', 'U', 'S', 'H', '\0', /* PS_PARTIAL_FLUSH (84287) */
	'F', 'L', 'U', 'S', 'H', '_', 'H', 'S', '_', 'O', 'U', 'T', 'P', 'U', 'T', '\0', /* FLUSH_HS_OUTPUT (84304) */
	'F', 'L', 'U', 'S', 'H', '_', 'D', 'F', 'S', 'M', '\0', /* FLUSH_DFSM (84320) */
	'R', 'E', 'S', 'E', 'T', '_', 'T', 'O', '_', 'L', 'O', 'W', 'E', 'S', 'T', '_', 'V', 'G', 'T', '\0', /* RESET_TO_LOWEST_VGT (84331) */
	'C', 'A', 'C', 'H', 'E', '_', 'F', 'L', 'U', 'S', 'H', '_', 'A', 'N', 'D', '_', 'I', 'N', 'V', '_', 'T', 'S', '_', 'E', 'V', 'E', 'N', 'T', '\0', /* CACHE_FLUSH_AND_INV_TS_EVENT (84351) */
	'Z', 'P', 'A', 'S', 'S', '_', 'D', 'O', 'N', 'E', '\0', /* ZPASS_DONE (84380) */
	'C', 'A', 'C', 'H', 'E', '_', 'F', 'L', 'U', 'S', 'H', '_', 'A', 'N', 'D', '_', 'I', 'N', 'V', '_', 'E', 'V', 'E', 'N', 'T', '\0', /* CACHE_FLUSH_AND_INV_EVENT (84391) */
	'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'S', 'T', 'A', 'R', 'T', '\0', /* PERFCOUNTER_START (84417) */
	'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'S', 'T', 'O', 'P', '\0', /* PERFCOUNTER_STOP (84435) */
	'P', 'I', 'P', 'E', 'L', 'I', 'N', 'E', 'S', 'T', 'A', 'T', '_', 'S', 'T', 'A', 'R', 'T', '\0', /* PIPELINESTAT_START (84452) */
	'P', 'I', 'P', 'E', 'L', 'I', 'N', 'E', 'S', 'T', 'A', 'T', '_', 'S', 'T', 'O', 'P', '\0', /* PIPELINESTAT_STOP (84471) */
	'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'S', 'A', 'M', 'P', 'L', 'E', '\0', /* PERFCOUNTER_SAMPLE (84489) */
	'F', 'L', 'U', 'S', 'H', '_', 'E', 'S', '_', 'O', 'U', 'T', 'P', 'U', 'T', '\0', /* FLUSH_ES_OUTPUT (84508) */
	'B', 'I', 'N', '_', 'C', 'O', 'N', 'F', '_', 'O', 'V', 'E', 'R', 'R', 'I', 'D', 'E', '_', 'C', 'H', 'E', 'C', 'K', '\0', /* BIN_CONF_OVERRIDE_CHECK (84524) */
	'S', 'A', 'M', 'P', 'L', 'E', '_', 'P', 'I', 'P', 'E', 'L', 'I', 'N', 'E', 'S', 'T', 'A', 'T', '\0', /* SAMPLE_PIPELINESTAT (84548) */
	'S', 'O', '_', 'V', 'G', 'T', 'S', 'T', 'R', 'E', 'A', 'M', 'O', 'U', 'T', '_', 'F', 'L', 'U', 'S', 'H', '\0', /* SO_VGTSTREAMOUT_FLUSH (84568) */
	'S', 'A', 'M', 'P', 'L', 'E', '_', 'S', 'T', 'R', 'E', 'A', 'M', 'O', 'U', 'T', 'S', 'T', 'A', 'T', 'S', '\0', /* SAMPLE_STREAMOUTSTATS (84590) */
	'R', 'E', 'S', 'E', 'T', '_', 'V', 'T', 'X', '_', 'C', 'N', 'T', '\0', /* RESET_VTX_CNT (84612) */
	'B', 'L', 'O', 'C', 'K', '_', 'C', 'O', 'N', 'T', 'E', 'X', 'T', '_', 'D', 'O', 'N', 'E', '\0', /* BLOCK_CONTEXT_DONE (84626) */
	'C', 'S', '_', 'C', 'O', 'N', 'T', 'E', 'X', 'T', '_', 'D', 'O', 'N', 'E', '\0', /* CS_CONTEXT_DONE (84645) */
	'V', 'G', 'T', '_', 'F', 'L', 'U', 'S', 'H', '\0', /* VGT_FLUSH (84661) */
	'T', 'G', 'I', 'D', '_', 'R', 'O', 'L', 'L', 'O', 'V', 'E', 'R', '\0', /* TGID_ROLLOVER (84671) */
	'S', 'Q', '_', 'N', 'O', 'N', '_', 'E', 'V', 'E', 'N', 'T', '\0', /* SQ_NON_EVENT (84685) */
	'S', 'C', '_', 'S', 'E', 'N', 'D', '_', 'D', 'B', '_', 'V', 'P', 'Z', '\0', /* SC_SEND_DB_VPZ (84698) */
	'B', 'O', 'T', 'T', 'O', 'M', '_', 'O', 'F', '_', 'P', 'I', 'P', 'E', '_', 'T', 'S', '\0', /* BOTTOM_OF_PIPE_TS (84713) */
	'F', 'L', 'U', 'S', 'H', '_', 'S', 'X', '_', 'T', 'S', '\0', /* FLUSH_SX_TS (84731) */
	'D', 'B', '_', 'C', 'A', 'C', 'H', 'E', '_', 'F', 'L', 'U', 'S', 'H', '_', 'A', 'N', 'D', '_', 'I', 'N', 'V', '\0', /* DB_CACHE_FLUSH_AND_INV (84743) */
	'F', 'L', 'U', 'S', 'H', '_', 'A', 'N', 'D', '_', 'I', 'N', 'V', '_', 'D', 'B', '_', 'D', 'A', 'T', 'A', '_', 'T', 'S', '\0', /* FLUSH_AND_INV_DB_DATA_TS (84766) */
	'F', 'L', 'U', 'S', 'H', '_', 'A', 'N', 'D', '_', 'I', 'N', 'V', '_', 'D', 'B', '_', 'M', 'E', 'T', 'A', '\0', /* FLUSH_AND_INV_DB_META (84791) */
	'F', 'L', 'U', 'S', 'H', '_', 'A', 'N', 'D', '_', 'I', 'N', 'V', '_', 'C', 'B', '_', 'D', 'A', 'T', 'A', '_', 'T', 'S', '\0', /* FLUSH_AND_INV_CB_DATA_TS (84813) */
	'F', 'L', 'U', 'S', 'H', '_', 'A', 'N', 'D', '_', 'I', 'N', 'V', '_', 'C', 'B', '_', 'M', 'E', 'T', 'A', '\0', /* FLUSH_AND_INV_CB_META (84838) */
	'C', 'S', '_', 'D', 'O', 'N', 'E', '\0', /* CS_DONE (84860) */
	'P', 'S', '_', 'D', 'O', 'N', 'E', '\0', /* PS_DONE (84868) */
	'F', 'L', 'U', 'S', 'H', '_', 'A', 'N', 'D', '_', 'I', 'N', 'V', '_', 'C', 'B', '_', 'P', 'I', 'X', 'E', 'L', '_', 'D', 'A', 'T', 'A', '\0', /* FLUSH_AND_INV_CB_PIXEL_DATA (84876) */
	'S', 'X', '_', 'C', 'B', '_', 'R', 'A', 'T', '_', 'A', 'C', 'K', '_', 'R', 'E', 'Q', 'U', 'E', 'S', 'T', '\0', /* SX_CB_RAT_ACK_REQUEST (84904) */
	'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'S', 'T', 'A', 'R', 'T', '\0', /* THREAD_TRACE_START (84926) */
	'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'S', 'T', 'O', 'P', '\0', /* THREAD_TRACE_STOP (84945) */
	'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'M', 'A', 'R', 'K', 'E', 'R', '\0', /* THREAD_TRACE_MARKER (84963) */
	'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'D', 'R', 'A', 'W', '\0', /* THREAD_TRACE_DRAW (84983) */
	'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'F', 'I', 'N', 'I', 'S', 'H', '\0', /* THREAD_TRACE_FINISH (85001) */
	'P', 'I', 'X', 'E', 'L', '_', 'P', 'I', 'P', 'E', '_', 'S', 'T', 'A', 'T', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* PIXEL_PIPE_STAT_CONTROL (85021) */
	'P', 'I', 'X', 'E', 'L', '_', 'P', 'I', 'P', 'E', '_', 'S', 'T', 'A', 'T', '_', 'D', 'U', 'M', 'P', '\0', /* PIXEL_PIPE_STAT_DUMP (85045) */
	'P', 'I', 'X', 'E', 'L', '_', 'P', 'I', 'P', 'E', '_', 'S', 'T', 'A', 'T', '_', 'R', 'E', 'S', 'E', 'T', '\0', /* PIXEL_PIPE_STAT_RESET (85066) */
	'C', 'O', 'N', 'T', 'E', 'X', 'T', '_', 'S', 'U', 'S', 'P', 'E', 'N', 'D', '\0', /* CONTEXT_SUSPEND (85088) */
	'O', 'F', 'F', 'C', 'H', 'I', 'P', '_', 'H', 'S', '_', 'D', 'E', 'A', 'L', 'L', 'O', 'C', '\0', /* OFFCHIP_HS_DEALLOC (85104) */
	'E', 'N', 'A', 'B', 'L', 'E', '_', 'N', 'G', 'G', '_', 'P', 'I', 'P', 'E', 'L', 'I', 'N', 'E', '\0', /* ENABLE_NGG_PIPELINE (85123) */
	'E', 'N', 'A', 'B', 'L', 'E', '_', 'L', 'E', 'G', 'A', 'C', 'Y', '_', 'P', 'I', 'P', 'E', 'L', 'I', 'N', 'E', '\0', /* ENABLE_LEGACY_PIPELINE (85143) */
	'D', 'R', 'A', 'W', '_', 'D', 'O', 'N', 'E', '\0', /* DRAW_DONE (85166) */
	'E', 'V', 'E', 'N', 'T', '_', 'T', 'Y', 'P', 'E', '\0', /* EVENT_TYPE (85176) */
	'E', 'X', 'T', 'E', 'N', 'D', 'E', 'D', '_', 'E', 'V', 'E', 'N', 'T', '\0', /* EXTENDED_EVENT (85187) */
	'M', 'A', 'T', 'C', 'H', '_', 'A', 'L', 'L', '_', 'B', 'I', 'T', 'S', '\0', /* MATCH_ALL_BITS (85202) */
	'O', 'B', 'J', 'P', 'R', 'I', 'M', '_', 'I', 'D', '_', 'E', 'N', '\0', /* OBJPRIM_ID_EN (85217) */
	'E', 'N', '_', 'R', 'E', 'G', '_', 'R', 'T', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* EN_REG_RT_INDEX (85231) */
	'O', 'B', 'J', 'E', 'C', 'T', '_', 'I', 'D', '_', 'I', 'N', 'S', 'T', '_', 'E', 'N', '\0', /* OBJECT_ID_INST_EN (85247) */
	'E', 'N', '_', 'P', 'R', 'I', 'M', '_', 'P', 'A', 'Y', 'L', 'O', 'A', 'D', '\0', /* EN_PRIM_PAYLOAD (85265) */
	'E', 'N', '_', 'D', 'R', 'A', 'W', '_', 'V', 'P', '\0', /* EN_DRAW_VP (85281) */
	'P', 'R', 'I', 'M', 'G', 'R', 'O', 'U', 'P', '_', 'S', 'I', 'Z', 'E', '\0', /* PRIMGROUP_SIZE (85292) */
	'P', 'A', 'R', 'T', 'I', 'A', 'L', '_', 'V', 'S', '_', 'W', 'A', 'V', 'E', '_', 'O', 'N', '\0', /* PARTIAL_VS_WAVE_ON (85307) */
	'S', 'W', 'I', 'T', 'C', 'H', '_', 'O', 'N', '_', 'E', 'O', 'P', '\0', /* SWITCH_ON_EOP (85326) */
	'P', 'A', 'R', 'T', 'I', 'A', 'L', '_', 'E', 'S', '_', 'W', 'A', 'V', 'E', '_', 'O', 'N', '\0', /* PARTIAL_ES_WAVE_ON (85340) */
	'S', 'W', 'I', 'T', 'C', 'H', '_', 'O', 'N', '_', 'E', 'O', 'I', '\0', /* SWITCH_ON_EOI (85359) */
	'W', 'D', '_', 'S', 'W', 'I', 'T', 'C', 'H', '_', 'O', 'N', '_', 'E', 'O', 'P', '\0', /* WD_SWITCH_ON_EOP (85373) */
	'F', 'U', 'L', 'L', '_', 'C', 'A', 'C', 'H', 'E', '\0', /* FULL_CACHE (85390) */
	'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', 'F', 'I', 'E', 'L', 'D', '_', '2', '\0', /* RESERVED_FIELD_2 (85401) */
	'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', 'F', 'I', 'E', 'L', 'D', '_', '3', '\0', /* RESERVED_FIELD_3 (85418) */
	'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', 'F', 'I', 'E', 'L', 'D', '_', '4', '\0', /* RESERVED_FIELD_4 (85435) */
	'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', 'F', 'I', 'E', 'L', 'D', '_', '5', '\0', /* RESERVED_FIELD_5 (85452) */
	'D', 'S', 'T', '_', 'O', 'U', 'T', 'S', 'I', 'D', 'E', '_', 'Z', 'E', 'R', 'O', '_', 'T', 'O', '_', 'O', 'N', 'E', '\0', /* DST_OUTSIDE_ZERO_TO_ONE (85469) */
	'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', 'F', 'I', 'E', 'L', 'D', '_', '6', '\0', /* RESERVED_FIELD_6 (85493) */
	'C', 'O', 'M', 'P', 'A', 'R', 'E', 'F', 'U', 'N', 'C', '0', '\0', /* COMPAREFUNC0 (85510) */
	'C', 'O', 'M', 'P', 'A', 'R', 'E', 'V', 'A', 'L', 'U', 'E', '0', '\0', /* COMPAREVALUE0 (85523) */
	'C', 'O', 'M', 'P', 'A', 'R', 'E', 'M', 'A', 'S', 'K', '0', '\0', /* COMPAREMASK0 (85537) */
	'C', 'O', 'M', 'P', 'A', 'R', 'E', 'F', 'U', 'N', 'C', '1', '\0', /* COMPAREFUNC1 (85550) */
	'C', 'O', 'M', 'P', 'A', 'R', 'E', 'V', 'A', 'L', 'U', 'E', '1', '\0', /* COMPAREVALUE1 (85563) */
	'C', 'O', 'M', 'P', 'A', 'R', 'E', 'M', 'A', 'S', 'K', '1', '\0', /* COMPAREMASK1 (85577) */
	'M', 'A', 'X', '_', 'X', '\0', /* MAX_X (85590) */
	'M', 'A', 'X', '_', 'Y', '\0', /* MAX_Y (85596) */
	'P', 'R', 'I', 'M', '_', 'A', 'M', 'P', '_', 'F', 'A', 'C', 'T', 'O', 'R', '\0', /* PRIM_AMP_FACTOR (85602) */
	'T', 'H', 'D', 'S', '_', 'P', 'E', 'R', '_', 'S', 'U', 'B', 'G', 'R', 'P', '\0', /* THDS_PER_SUBGRP (85618) */
	'A', 'C', 'C', 'U', 'M', '_', 'I', 'S', 'O', 'L', 'I', 'N', 'E', '\0', /* ACCUM_ISOLINE (85634) */
	'A', 'C', 'C', 'U', 'M', '_', 'T', 'R', 'I', '\0', /* ACCUM_TRI (85648) */
	'A', 'C', 'C', 'U', 'M', '_', 'Q', 'U', 'A', 'D', '\0', /* ACCUM_QUAD (85658) */
	'D', 'O', 'N', 'U', 'T', '_', 'S', 'P', 'L', 'I', 'T', '\0', /* DONUT_SPLIT (85669) */
	'T', 'R', 'A', 'P', '_', 'S', 'P', 'L', 'I', 'T', '\0', /* TRAP_SPLIT (85681) */
	'L', 'S', '_', 'S', 'T', 'A', 'G', 'E', '_', 'O', 'F', 'F', '\0', /* LS_STAGE_OFF (85692) */
	'L', 'S', '_', 'S', 'T', 'A', 'G', 'E', '_', 'O', 'N', '\0', /* LS_STAGE_ON (85705) */
	'C', 'S', '_', 'S', 'T', 'A', 'G', 'E', '_', 'O', 'N', '\0', /* CS_STAGE_ON (85717) */
	'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', 'L', 'S', '\0', /* RESERVED_LS (85729) */
	'L', 'S', '_', 'E', 'N', '\0', /* LS_EN (85741) */
	'H', 'S', '_', 'S', 'T', 'A', 'G', 'E', '_', 'O', 'F', 'F', '\0', /* HS_STAGE_OFF (85747) */
	'H', 'S', '_', 'S', 'T', 'A', 'G', 'E', '_', 'O', 'N', '\0', /* HS_STAGE_ON (85760) */
	'H', 'S', '_', 'E', 'N', '\0', /* HS_EN (85772) */
	'E', 'S', '_', 'S', 'T', 'A', 'G', 'E', '_', 'O', 'F', 'F', '\0', /* ES_STAGE_OFF (85778) */
	'E', 'S', '_', 'S', 'T', 'A', 'G', 'E', '_', 'D', 'S', '\0', /* ES_STAGE_DS (85791) */
	'E', 'S', '_', 'S', 'T', 'A', 'G', 'E', '_', 'R', 'E', 'A', 'L', '\0', /* ES_STAGE_REAL (85803) */
	'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', 'E', 'S', '\0', /* RESERVED_ES (85817) */
	'G', 'S', '_', 'S', 'T', 'A', 'G', 'E', '_', 'O', 'F', 'F', '\0', /* GS_STAGE_OFF (85829) */
	'G', 'S', '_', 'S', 'T', 'A', 'G', 'E', '_', 'O', 'N', '\0', /* GS_STAGE_ON (85842) */
	'G', 'S', '_', 'E', 'N', '\0', /* GS_EN (85854) */
	'V', 'S', '_', 'S', 'T', 'A', 'G', 'E', '_', 'R', 'E', 'A', 'L', '\0', /* VS_STAGE_REAL (85860) */
	'V', 'S', '_', 'S', 'T', 'A', 'G', 'E', '_', 'D', 'S', '\0', /* VS_STAGE_DS (85874) */
	'V', 'S', '_', 'S', 'T', 'A', 'G', 'E', '_', 'C', 'O', 'P', 'Y', '_', 'S', 'H', 'A', 'D', 'E', 'R', '\0', /* VS_STAGE_COPY_SHADER (85886) */
	'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', 'V', 'S', '\0', /* RESERVED_VS (85907) */
	'V', 'S', '_', 'E', 'N', '\0', /* VS_EN (85919) */
	'D', 'Y', 'N', 'A', 'M', 'I', 'C', '_', 'H', 'S', '\0', /* DYNAMIC_HS (85925) */
	'D', 'I', 'S', '_', 'D', 'E', 'A', 'L', 'L', 'O', 'C', '_', 'A', 'C', 'C', 'U', 'M', '_', '0', '\0', /* DIS_DEALLOC_ACCUM_0 (85936) */
	'D', 'I', 'S', '_', 'D', 'E', 'A', 'L', 'L', 'O', 'C', '_', 'A', 'C', 'C', 'U', 'M', '_', '1', '\0', /* DIS_DEALLOC_ACCUM_1 (85956) */
	'V', 'S', '_', 'W', 'A', 'V', 'E', '_', 'I', 'D', '_', 'E', 'N', '\0', /* VS_WAVE_ID_EN (85976) */
	'P', 'R', 'I', 'M', 'G', 'E', 'N', '_', 'E', 'N', '\0', /* PRIMGEN_EN (85990) */
	'O', 'R', 'D', 'E', 'R', 'E', 'D', '_', 'I', 'D', '_', 'M', 'O', 'D', 'E', '\0', /* ORDERED_ID_MODE (86001) */
	'M', 'A', 'X', '_', 'P', 'R', 'I', 'M', 'G', 'R', 'P', '_', 'I', 'N', '_', 'W', 'A', 'V', 'E', '\0', /* MAX_PRIMGRP_IN_WAVE (86017) */
	'G', 'S', '_', 'F', 'A', 'S', 'T', '_', 'L', 'A', 'U', 'N', 'C', 'H', '\0', /* GS_FAST_LAUNCH (86037) */
	'H', 'S', '_', 'W', '3', '2', '_', 'E', 'N', '\0', /* HS_W32_EN (86052) */
	'G', 'S', '_', 'W', '3', '2', '_', 'E', 'N', '\0', /* GS_W32_EN (86062) */
	'V', 'S', '_', 'W', '3', '2', '_', 'E', 'N', '\0', /* VS_W32_EN (86072) */
	'N', 'G', 'G', '_', 'W', 'A', 'V', 'E', '_', 'I', 'D', '_', 'E', 'N', '\0', /* NGG_WAVE_ID_EN (86082) */
	'P', 'R', 'I', 'M', 'G', 'E', 'N', '_', 'P', 'A', 'S', 'S', 'T', 'H', 'R', 'U', '_', 'E', 'N', '\0', /* PRIMGEN_PASSTHRU_EN (86097) */
	'N', 'U', 'M', '_', 'P', 'A', 'T', 'C', 'H', 'E', 'S', '\0', /* NUM_PATCHES (86117, 86121) */
	'H', 'S', '_', 'N', 'U', 'M', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'P', '\0', /* HS_NUM_INPUT_CP (86129) */
	'H', 'S', '_', 'N', 'U', 'M', '_', 'O', 'U', 'T', 'P', 'U', 'T', '_', 'C', 'P', '\0', /* HS_NUM_OUTPUT_CP (86145) */
	'T', 'E', 'S', 'S', '_', 'I', 'S', 'O', 'L', 'I', 'N', 'E', '\0', /* TESS_ISOLINE (86162) */
	'T', 'E', 'S', 'S', '_', 'T', 'R', 'I', 'A', 'N', 'G', 'L', 'E', '\0', /* TESS_TRIANGLE (86175) */
	'T', 'E', 'S', 'S', '_', 'Q', 'U', 'A', 'D', '\0', /* TESS_QUAD (86189) */
	'P', 'A', 'R', 'T', '_', 'I', 'N', 'T', 'E', 'G', 'E', 'R', '\0', /* PART_INTEGER (86199) */
	'P', 'A', 'R', 'T', '_', 'P', 'O', 'W', '2', '\0', /* PART_POW2 (86212) */
	'P', 'A', 'R', 'T', '_', 'F', 'R', 'A', 'C', '_', 'O', 'D', 'D', '\0', /* PART_FRAC_ODD (86222) */
	'P', 'A', 'R', 'T', '_', 'F', 'R', 'A', 'C', '_', 'E', 'V', 'E', 'N', '\0', /* PART_FRAC_EVEN (86236) */
	'P', 'A', 'R', 'T', 'I', 'T', 'I', 'O', 'N', 'I', 'N', 'G', '\0', /* PARTITIONING (86251) */
	'O', 'U', 'T', 'P', 'U', 'T', '_', 'P', 'O', 'I', 'N', 'T', '\0', /* OUTPUT_POINT (86264) */
	'O', 'U', 'T', 'P', 'U', 'T', '_', 'L', 'I', 'N', 'E', '\0', /* OUTPUT_LINE (86277) */
	'O', 'U', 'T', 'P', 'U', 'T', '_', 'T', 'R', 'I', 'A', 'N', 'G', 'L', 'E', '_', 'C', 'W', '\0', /* OUTPUT_TRIANGLE_CW (86289) */
	'O', 'U', 'T', 'P', 'U', 'T', '_', 'T', 'R', 'I', 'A', 'N', 'G', 'L', 'E', '_', 'C', 'C', 'W', '\0', /* OUTPUT_TRIANGLE_CCW (86308) */
	'T', 'O', 'P', 'O', 'L', 'O', 'G', 'Y', '\0', /* TOPOLOGY (86328) */
	'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', 'R', 'E', 'D', 'U', 'C', '_', 'A', 'X', 'I', 'S', '\0', /* RESERVED_REDUC_AXIS (86337) */
	'D', 'E', 'P', 'R', 'E', 'C', 'A', 'T', 'E', 'D', '\0', /* DEPRECATED (86357) */
	'N', 'U', 'M', '_', 'D', 'S', '_', 'W', 'A', 'V', 'E', 'S', '_', 'P', 'E', 'R', '_', 'S', 'I', 'M', 'D', '\0', /* NUM_DS_WAVES_PER_SIMD (86368) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'D', 'O', 'N', 'U', 'T', 'S', '\0', /* DISABLE_DONUTS (86390, 86398) */
	'N', 'O', '_', 'D', 'I', 'S', 'T', '\0', /* NO_DIST (86405) */
	'T', 'R', 'A', 'P', 'E', 'Z', 'O', 'I', 'D', 'S', '\0', /* TRAPEZOIDS (86413) */
	'D', 'I', 'S', 'T', 'R', 'I', 'B', 'U', 'T', 'I', 'O', 'N', '_', 'M', 'O', 'D', 'E', '\0', /* DISTRIBUTION_MODE (86424) */
	'P', 'R', 'E', '_', 'C', 'L', 'A', 'M', 'P', '_', 'T', 'F', '1', '\0', /* PRE_CLAMP_TF1 (86442) */
	'P', 'O', 'S', 'T', '_', 'C', 'L', 'A', 'M', 'P', '_', 'T', 'F', '1', '\0', /* POST_CLAMP_TF1 (86456) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'T', 'F', '1', '\0', /* DISABLE_TF1 (86471) */
	'D', 'E', 'T', 'E', 'C', 'T', '_', 'O', 'N', 'E', '\0', /* DETECT_ONE (86483) */
	'P', 'R', 'E', '_', 'C', 'L', 'A', 'M', 'P', '_', 'T', 'F', '0', '\0', /* PRE_CLAMP_TF0 (86494) */
	'P', 'O', 'S', 'T', '_', 'C', 'L', 'A', 'M', 'P', '_', 'T', 'F', '0', '\0', /* POST_CLAMP_TF0 (86508) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'T', 'F', '0', '\0', /* DISABLE_TF0 (86523) */
	'D', 'E', 'T', 'E', 'C', 'T', '_', 'Z', 'E', 'R', 'O', '\0', /* DETECT_ZERO (86535) */
	'A', 'L', 'P', 'H', 'A', '_', 'T', 'O', '_', 'M', 'A', 'S', 'K', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* ALPHA_TO_MASK_ENABLE (86547) */
	'A', 'L', 'P', 'H', 'A', '_', 'T', 'O', '_', 'M', 'A', 'S', 'K', '_', 'O', 'F', 'F', 'S', 'E', 'T', '0', '\0', /* ALPHA_TO_MASK_OFFSET0 (86568) */
	'A', 'L', 'P', 'H', 'A', '_', 'T', 'O', '_', 'M', 'A', 'S', 'K', '_', 'O', 'F', 'F', 'S', 'E', 'T', '1', '\0', /* ALPHA_TO_MASK_OFFSET1 (86590) */
	'A', 'L', 'P', 'H', 'A', '_', 'T', 'O', '_', 'M', 'A', 'S', 'K', '_', 'O', 'F', 'F', 'S', 'E', 'T', '2', '\0', /* ALPHA_TO_MASK_OFFSET2 (86612) */
	'A', 'L', 'P', 'H', 'A', '_', 'T', 'O', '_', 'M', 'A', 'S', 'K', '_', 'O', 'F', 'F', 'S', 'E', 'T', '3', '\0', /* ALPHA_TO_MASK_OFFSET3 (86634) */
	'O', 'F', 'F', 'S', 'E', 'T', '_', 'R', 'O', 'U', 'N', 'D', '\0', /* OFFSET_ROUND (86656) */
	'P', 'O', 'L', 'Y', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', 'N', 'E', 'G', '_', 'N', 'U', 'M', '_', 'D', 'B', '_', 'B', 'I', 'T', 'S', '\0', /* POLY_OFFSET_NEG_NUM_DB_BITS (86669) */
	'P', 'O', 'L', 'Y', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', 'D', 'B', '_', 'I', 'S', '_', 'F', 'L', 'O', 'A', 'T', '_', 'F', 'M', 'T', '\0', /* POLY_OFFSET_DB_IS_FLOAT_FMT (86697) */
	'E', 'N', '_', 'M', 'A', 'X', '_', 'V', 'E', 'R', 'T', '_', 'O', 'U', 'T', '_', 'P', 'E', 'R', '_', 'G', 'S', '_', 'I', 'N', 'S', 'T', 'A', 'N', 'C', 'E', '\0', /* EN_MAX_VERT_OUT_PER_GS_INSTANCE (86725) */
	'S', 'T', 'R', 'E', 'A', 'M', 'O', 'U', 'T', '_', '0', '_', 'E', 'N', '\0', /* STREAMOUT_0_EN (86757) */
	'S', 'T', 'R', 'E', 'A', 'M', 'O', 'U', 'T', '_', '1', '_', 'E', 'N', '\0', /* STREAMOUT_1_EN (86772) */
	'S', 'T', 'R', 'E', 'A', 'M', 'O', 'U', 'T', '_', '2', '_', 'E', 'N', '\0', /* STREAMOUT_2_EN (86787) */
	'S', 'T', 'R', 'E', 'A', 'M', 'O', 'U', 'T', '_', '3', '_', 'E', 'N', '\0', /* STREAMOUT_3_EN (86802) */
	'R', 'A', 'S', 'T', '_', 'S', 'T', 'R', 'E', 'A', 'M', '\0', /* RAST_STREAM (86817) */
	'E', 'N', '_', 'P', 'R', 'I', 'M', 'S', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', 'C', 'N', 'T', '\0', /* EN_PRIMS_NEEDED_CNT (86829) */
	'R', 'A', 'S', 'T', '_', 'S', 'T', 'R', 'E', 'A', 'M', '_', 'M', 'A', 'S', 'K', '\0', /* RAST_STREAM_MASK (86849) */
	'U', 'S', 'E', '_', 'R', 'A', 'S', 'T', '_', 'S', 'T', 'R', 'E', 'A', 'M', '_', 'M', 'A', 'S', 'K', '\0', /* USE_RAST_STREAM_MASK (86866) */
	'S', 'T', 'R', 'E', 'A', 'M', '_', '0', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'E', 'N', '\0', /* STREAM_0_BUFFER_EN (86887) */
	'S', 'T', 'R', 'E', 'A', 'M', '_', '1', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'E', 'N', '\0', /* STREAM_1_BUFFER_EN (86906) */
	'S', 'T', 'R', 'E', 'A', 'M', '_', '2', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'E', 'N', '\0', /* STREAM_2_BUFFER_EN (86925) */
	'S', 'T', 'R', 'E', 'A', 'M', '_', '3', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'E', 'N', '\0', /* STREAM_3_BUFFER_EN (86944) */
	'D', 'I', 'S', 'T', 'A', 'N', 'C', 'E', '_', '0', '\0', /* DISTANCE_0 (86963) */
	'D', 'I', 'S', 'T', 'A', 'N', 'C', 'E', '_', '1', '\0', /* DISTANCE_1 (86974) */
	'D', 'I', 'S', 'T', 'A', 'N', 'C', 'E', '_', '2', '\0', /* DISTANCE_2 (86985) */
	'D', 'I', 'S', 'T', 'A', 'N', 'C', 'E', '_', '3', '\0', /* DISTANCE_3 (86996) */
	'D', 'I', 'S', 'T', 'A', 'N', 'C', 'E', '_', '4', '\0', /* DISTANCE_4 (87007) */
	'D', 'I', 'S', 'T', 'A', 'N', 'C', 'E', '_', '5', '\0', /* DISTANCE_5 (87018) */
	'D', 'I', 'S', 'T', 'A', 'N', 'C', 'E', '_', '6', '\0', /* DISTANCE_6 (87029) */
	'D', 'I', 'S', 'T', 'A', 'N', 'C', 'E', '_', '7', '\0', /* DISTANCE_7 (87040) */
	'D', 'I', 'S', 'T', 'A', 'N', 'C', 'E', '_', '8', '\0', /* DISTANCE_8 (87051) */
	'D', 'I', 'S', 'T', 'A', 'N', 'C', 'E', '_', '9', '\0', /* DISTANCE_9 (87062) */
	'D', 'I', 'S', 'T', 'A', 'N', 'C', 'E', '_', '1', '0', '\0', /* DISTANCE_10 (87073) */
	'D', 'I', 'S', 'T', 'A', 'N', 'C', 'E', '_', '1', '1', '\0', /* DISTANCE_11 (87085) */
	'D', 'I', 'S', 'T', 'A', 'N', 'C', 'E', '_', '1', '2', '\0', /* DISTANCE_12 (87097) */
	'D', 'I', 'S', 'T', 'A', 'N', 'C', 'E', '_', '1', '3', '\0', /* DISTANCE_13 (87109) */
	'D', 'I', 'S', 'T', 'A', 'N', 'C', 'E', '_', '1', '4', '\0', /* DISTANCE_14 (87121) */
	'D', 'I', 'S', 'T', 'A', 'N', 'C', 'E', '_', '1', '5', '\0', /* DISTANCE_15 (87133) */
	'E', 'X', 'P', 'A', 'N', 'D', '_', 'L', 'I', 'N', 'E', '_', 'W', 'I', 'D', 'T', 'H', '\0', /* EXPAND_LINE_WIDTH (87145) */
	'L', 'A', 'S', 'T', '_', 'P', 'I', 'X', 'E', 'L', '\0', /* LAST_PIXEL (87163) */
	'P', 'E', 'R', 'P', 'E', 'N', 'D', 'I', 'C', 'U', 'L', 'A', 'R', '_', 'E', 'N', 'D', 'C', 'A', 'P', '_', 'E', 'N', 'A', '\0', /* PERPENDICULAR_ENDCAP_ENA (87174) */
	'D', 'X', '1', '0', '_', 'D', 'I', 'A', 'M', 'O', 'N', 'D', '_', 'T', 'E', 'S', 'T', '_', 'E', 'N', 'A', '\0', /* DX10_DIAMOND_TEST_ENA (87199) */
	'E', 'X', 'T', 'R', 'A', '_', 'D', 'X', '_', 'D', 'Y', '_', 'P', 'R', 'E', 'C', 'I', 'S', 'I', 'O', 'N', '\0', /* EXTRA_DX_DY_PRECISION (87221) */
	'M', 'S', 'A', 'A', '_', 'N', 'U', 'M', '_', 'S', 'A', 'M', 'P', 'L', 'E', 'S', '\0', /* MSAA_NUM_SAMPLES (87243) */
	'A', 'A', '_', 'M', 'A', 'S', 'K', '_', 'C', 'E', 'N', 'T', 'R', 'O', 'I', 'D', '_', 'D', 'T', 'M', 'N', '\0', /* AA_MASK_CENTROID_DTMN (87260) */
	'M', 'A', 'X', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'I', 'S', 'T', '\0', /* MAX_SAMPLE_DIST (87282) */
	'M', 'S', 'A', 'A', '_', 'E', 'X', 'P', 'O', 'S', 'E', 'D', '_', 'S', 'A', 'M', 'P', 'L', 'E', 'S', '\0', /* MSAA_EXPOSED_SAMPLES (87298) */
	'D', 'E', 'T', 'A', 'I', 'L', '_', 'T', 'O', '_', 'E', 'X', 'P', 'O', 'S', 'E', 'D', '_', 'M', 'O', 'D', 'E', '\0', /* DETAIL_TO_EXPOSED_MODE (87319) */
	'I', 'N', 'P', 'U', 'T', '_', 'C', 'O', 'V', 'E', 'R', 'A', 'G', 'E', '\0', /* INPUT_COVERAGE (87342) */
	'I', 'N', 'P', 'U', 'T', '_', 'I', 'N', 'N', 'E', 'R', '_', 'C', 'O', 'V', 'E', 'R', 'A', 'G', 'E', '\0', /* INPUT_INNER_COVERAGE (87357) */
	'I', 'N', 'P', 'U', 'T', '_', 'D', 'E', 'P', 'T', 'H', '_', 'C', 'O', 'V', 'E', 'R', 'A', 'G', 'E', '\0', /* INPUT_DEPTH_COVERAGE (87378) */
	'C', 'O', 'V', 'E', 'R', 'A', 'G', 'E', '_', 'T', 'O', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* COVERAGE_TO_SHADER_SELECT (87399) */
	'P', 'I', 'X', '_', 'C', 'E', 'N', 'T', 'E', 'R', '\0', /* PIX_CENTER (87425) */
	'X', '_', 'T', 'R', 'U', 'N', 'C', 'A', 'T', 'E', '\0', /* X_TRUNCATE (87436) */
	'X', '_', 'R', 'O', 'U', 'N', 'D', '\0', /* X_ROUND (87447) */
	'X', '_', 'R', 'O', 'U', 'N', 'D', '_', 'T', 'O', '_', 'E', 'V', 'E', 'N', '\0', /* X_ROUND_TO_EVEN (87455) */
	'X', '_', 'R', 'O', 'U', 'N', 'D', '_', 'T', 'O', '_', 'O', 'D', 'D', '\0', /* X_ROUND_TO_ODD (87471) */
	'R', 'O', 'U', 'N', 'D', '_', 'M', 'O', 'D', 'E', '\0', /* ROUND_MODE (87486) */
	'X', '_', '1', '6', '_', '8', '_', 'F', 'I', 'X', 'E', 'D', '_', 'P', 'O', 'I', 'N', 'T', '_', '1', '_', '1', '6', 'T', 'H', '\0', /* X_16_8_FIXED_POINT_1_16TH (87497) */
	'X', '_', '1', '6', '_', '8', '_', 'F', 'I', 'X', 'E', 'D', '_', 'P', 'O', 'I', 'N', 'T', '_', '1', '_', '8', 'T', 'H', '\0', /* X_16_8_FIXED_POINT_1_8TH (87523) */
	'X', '_', '1', '6', '_', '8', '_', 'F', 'I', 'X', 'E', 'D', '_', 'P', 'O', 'I', 'N', 'T', '_', '1', '_', '4', 'T', 'H', '\0', /* X_16_8_FIXED_POINT_1_4TH (87548) */
	'X', '_', '1', '6', '_', '8', '_', 'F', 'I', 'X', 'E', 'D', '_', 'P', 'O', 'I', 'N', 'T', '_', '1', '_', '2', '\0', /* X_16_8_FIXED_POINT_1_2 (87573) */
	'X', '_', '1', '6', '_', '8', '_', 'F', 'I', 'X', 'E', 'D', '_', 'P', 'O', 'I', 'N', 'T', '_', '1', '\0', /* X_16_8_FIXED_POINT_1 (87596) */
	'X', '_', '1', '6', '_', '8', '_', 'F', 'I', 'X', 'E', 'D', '_', 'P', 'O', 'I', 'N', 'T', '_', '1', '_', '2', '5', '6', 'T', 'H', '\0', /* X_16_8_FIXED_POINT_1_256TH (87617) */
	'X', '_', '1', '4', '_', '1', '0', '_', 'F', 'I', 'X', 'E', 'D', '_', 'P', 'O', 'I', 'N', 'T', '_', '1', '_', '1', '0', '2', '4', 'T', 'H', '\0', /* X_14_10_FIXED_POINT_1_1024TH (87644) */
	'X', '_', '1', '2', '_', '1', '2', '_', 'F', 'I', 'X', 'E', 'D', '_', 'P', 'O', 'I', 'N', 'T', '_', '1', '_', '4', '0', '9', '6', 'T', 'H', '\0', /* X_12_12_FIXED_POINT_1_4096TH (87673) */
	'Q', 'U', 'A', 'N', 'T', '_', 'M', 'O', 'D', 'E', '\0', /* QUANT_MODE (87702) */
	'S', '0', '_', 'X', '\0', /* S0_X (87713) */
	'S', '0', '_', 'Y', '\0', /* S0_Y (87718) */
	'S', '1', '_', 'X', '\0', /* S1_X (87723) */
	'S', '1', '_', 'Y', '\0', /* S1_Y (87728) */
	'S', '2', '_', 'X', '\0', /* S2_X (87733) */
	'S', '2', '_', 'Y', '\0', /* S2_Y (87738) */
	'S', '3', '_', 'X', '\0', /* S3_X (87743) */
	'S', '3', '_', 'Y', '\0', /* S3_Y (87748) */
	'S', '4', '_', 'X', '\0', /* S4_X (87753) */
	'S', '4', '_', 'Y', '\0', /* S4_Y (87758) */
	'S', '5', '_', 'X', '\0', /* S5_X (87763) */
	'S', '5', '_', 'Y', '\0', /* S5_Y (87768) */
	'S', '6', '_', 'X', '\0', /* S6_X (87773) */
	'S', '6', '_', 'Y', '\0', /* S6_Y (87778) */
	'S', '7', '_', 'X', '\0', /* S7_X (87783) */
	'S', '7', '_', 'Y', '\0', /* S7_Y (87788) */
	'S', '8', '_', 'X', '\0', /* S8_X (87793) */
	'S', '8', '_', 'Y', '\0', /* S8_Y (87798) */
	'S', '9', '_', 'X', '\0', /* S9_X (87803) */
	'S', '9', '_', 'Y', '\0', /* S9_Y (87808) */
	'S', '1', '0', '_', 'X', '\0', /* S10_X (87813) */
	'S', '1', '0', '_', 'Y', '\0', /* S10_Y (87819) */
	'S', '1', '1', '_', 'X', '\0', /* S11_X (87825) */
	'S', '1', '1', '_', 'Y', '\0', /* S11_Y (87831) */
	'S', '1', '2', '_', 'X', '\0', /* S12_X (87837) */
	'S', '1', '2', '_', 'Y', '\0', /* S12_Y (87843) */
	'S', '1', '3', '_', 'X', '\0', /* S13_X (87849) */
	'S', '1', '3', '_', 'Y', '\0', /* S13_Y (87855) */
	'S', '1', '4', '_', 'X', '\0', /* S14_X (87861) */
	'S', '1', '4', '_', 'Y', '\0', /* S14_Y (87867) */
	'S', '1', '5', '_', 'X', '\0', /* S15_X (87873) */
	'S', '1', '5', '_', 'Y', '\0', /* S15_Y (87879) */
	'A', 'A', '_', 'M', 'A', 'S', 'K', '_', 'X', '0', 'Y', '0', '\0', /* AA_MASK_X0Y0 (87885) */
	'A', 'A', '_', 'M', 'A', 'S', 'K', '_', 'X', '1', 'Y', '0', '\0', /* AA_MASK_X1Y0 (87898) */
	'A', 'A', '_', 'M', 'A', 'S', 'K', '_', 'X', '0', 'Y', '1', '\0', /* AA_MASK_X0Y1 (87911) */
	'A', 'A', '_', 'M', 'A', 'S', 'K', '_', 'X', '1', 'Y', '1', '\0', /* AA_MASK_X1Y1 (87924) */
	'R', 'E', 'A', 'L', 'I', 'G', 'N', '_', 'D', 'Q', 'U', 'A', 'D', 'S', '_', 'A', 'F', 'T', 'E', 'R', '_', 'N', '_', 'W', 'A', 'V', 'E', 'S', '\0', /* REALIGN_DQUADS_AFTER_N_WAVES (87937) */
	'W', 'A', 'V', 'E', '_', 'B', 'R', 'E', 'A', 'K', '_', 'R', 'E', 'G', 'I', 'O', 'N', '_', 'S', 'I', 'Z', 'E', '\0', /* WAVE_BREAK_REGION_SIZE (87966) */
	'B', 'I', 'N', 'N', 'I', 'N', 'G', '_', 'A', 'L', 'L', 'O', 'W', 'E', 'D', '\0', /* BINNING_ALLOWED (87989) */
	'F', 'O', 'R', 'C', 'E', '_', 'B', 'I', 'N', 'N', 'I', 'N', 'G', '_', 'O', 'N', '\0', /* FORCE_BINNING_ON (88005) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'B', 'I', 'N', 'N', 'I', 'N', 'G', '_', 'U', 'S', 'E', '_', 'N', 'E', 'W', '_', 'S', 'C', '\0', /* DISABLE_BINNING_USE_NEW_SC (88022) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'B', 'I', 'N', 'N', 'I', 'N', 'G', '_', 'U', 'S', 'E', '_', 'L', 'E', 'G', 'A', 'C', 'Y', '_', 'S', 'C', '\0', /* DISABLE_BINNING_USE_LEGACY_SC (88049) */
	'B', 'I', 'N', 'N', 'I', 'N', 'G', '_', 'M', 'O', 'D', 'E', '\0', /* BINNING_MODE (88079) */
	'B', 'I', 'N', '_', 'S', 'I', 'Z', 'E', '_', 'X', '\0', /* BIN_SIZE_X (88092) */
	'B', 'I', 'N', '_', 'S', 'I', 'Z', 'E', '_', 'Y', '\0', /* BIN_SIZE_Y (88103) */
	'B', 'I', 'N', '_', 'S', 'I', 'Z', 'E', '_', '3', '2', '_', 'P', 'I', 'X', 'E', 'L', 'S', '\0', /* BIN_SIZE_32_PIXELS (88114) */
	'B', 'I', 'N', '_', 'S', 'I', 'Z', 'E', '_', '6', '4', '_', 'P', 'I', 'X', 'E', 'L', 'S', '\0', /* BIN_SIZE_64_PIXELS (88133) */
	'B', 'I', 'N', '_', 'S', 'I', 'Z', 'E', '_', '1', '2', '8', '_', 'P', 'I', 'X', 'E', 'L', 'S', '\0', /* BIN_SIZE_128_PIXELS (88152) */
	'B', 'I', 'N', '_', 'S', 'I', 'Z', 'E', '_', '2', '5', '6', '_', 'P', 'I', 'X', 'E', 'L', 'S', '\0', /* BIN_SIZE_256_PIXELS (88172) */
	'B', 'I', 'N', '_', 'S', 'I', 'Z', 'E', '_', '5', '1', '2', '_', 'P', 'I', 'X', 'E', 'L', 'S', '\0', /* BIN_SIZE_512_PIXELS (88192) */
	'B', 'I', 'N', '_', 'S', 'I', 'Z', 'E', '_', 'X', '_', 'E', 'X', 'T', 'E', 'N', 'D', '\0', /* BIN_SIZE_X_EXTEND (88212) */
	'B', 'I', 'N', '_', 'S', 'I', 'Z', 'E', '_', 'Y', '_', 'E', 'X', 'T', 'E', 'N', 'D', '\0', /* BIN_SIZE_Y_EXTEND (88230) */
	'C', 'O', 'N', 'T', 'E', 'X', 'T', '_', 'S', 'T', 'A', 'T', 'E', 'S', '_', 'P', 'E', 'R', '_', 'B', 'I', 'N', '\0', /* CONTEXT_STATES_PER_BIN (88248) */
	'P', 'E', 'R', 'S', 'I', 'S', 'T', 'E', 'N', 'T', '_', 'S', 'T', 'A', 'T', 'E', 'S', '_', 'P', 'E', 'R', '_', 'B', 'I', 'N', '\0', /* PERSISTENT_STATES_PER_BIN (88271) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'S', 'T', 'A', 'R', 'T', '_', 'O', 'F', '_', 'P', 'R', 'I', 'M', '\0', /* DISABLE_START_OF_PRIM (88297) */
	'F', 'P', 'O', 'V', 'S', '_', 'P', 'E', 'R', '_', 'B', 'A', 'T', 'C', 'H', '\0', /* FPOVS_PER_BATCH (88319) */
	'O', 'P', 'T', 'I', 'M', 'A', 'L', '_', 'B', 'I', 'N', '_', 'S', 'E', 'L', 'E', 'C', 'T', 'I', 'O', 'N', '\0', /* OPTIMAL_BIN_SELECTION (88335) */
	'F', 'L', 'U', 'S', 'H', '_', 'O', 'N', '_', 'B', 'I', 'N', 'N', 'I', 'N', 'G', '_', 'T', 'R', 'A', 'N', 'S', 'I', 'T', 'I', 'O', 'N', '\0', /* FLUSH_ON_BINNING_TRANSITION (88357) */
	'B', 'I', 'N', '_', 'M', 'A', 'P', '_', 'M', 'O', 'D', 'E', '_', 'N', 'O', 'N', 'E', '\0', /* BIN_MAP_MODE_NONE (88385) */
	'B', 'I', 'N', '_', 'M', 'A', 'P', '_', 'M', 'O', 'D', 'E', '_', 'R', 'T', 'A', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* BIN_MAP_MODE_RTA_INDEX (88403) */
	'B', 'I', 'N', '_', 'M', 'A', 'P', '_', 'M', 'O', 'D', 'E', '_', 'P', 'O', 'P', 'S', '\0', /* BIN_MAP_MODE_POPS (88426) */
	'B', 'I', 'N', '_', 'M', 'A', 'P', 'P', 'I', 'N', 'G', '_', 'M', 'O', 'D', 'E', '\0', /* BIN_MAPPING_MODE (88444) */
	'M', 'A', 'X', '_', 'A', 'L', 'L', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '\0', /* MAX_ALLOC_COUNT (88461) */
	'M', 'A', 'X', '_', 'P', 'R', 'I', 'M', '_', 'P', 'E', 'R', '_', 'B', 'A', 'T', 'C', 'H', '\0', /* MAX_PRIM_PER_BATCH (88477) */
	'O', 'V', 'E', 'R', '_', 'R', 'A', 'S', 'T', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* OVER_RAST_ENABLE (88496) */
	'O', 'V', 'E', 'R', '_', 'R', 'A', 'S', 'T', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* OVER_RAST_SAMPLE_SELECT (88513) */
	'U', 'N', 'D', 'E', 'R', '_', 'R', 'A', 'S', 'T', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* UNDER_RAST_ENABLE (88537) */
	'U', 'N', 'D', 'E', 'R', '_', 'R', 'A', 'S', 'T', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* UNDER_RAST_SAMPLE_SELECT (88555) */
	'P', 'B', 'B', '_', 'U', 'N', 'C', 'E', 'R', 'T', 'A', 'I', 'N', 'T', 'Y', '_', 'R', 'E', 'G', 'I', 'O', 'N', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* PBB_UNCERTAINTY_REGION_ENABLE (88580) */
	'Z', 'M', 'M', '_', 'T', 'R', 'I', '_', 'E', 'X', 'T', 'E', 'N', 'T', '\0', /* ZMM_TRI_EXTENT (88610) */
	'Z', 'M', 'M', '_', 'T', 'R', 'I', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* ZMM_TRI_OFFSET (88625) */
	'O', 'V', 'E', 'R', 'R', 'I', 'D', 'E', '_', 'O', 'V', 'E', 'R', '_', 'R', 'A', 'S', 'T', '_', 'I', 'N', 'N', 'E', 'R', '_', 'T', 'O', '_', 'N', 'O', 'R', 'M', 'A', 'L', '\0', /* OVERRIDE_OVER_RAST_INNER_TO_NORMAL (88640) */
	'O', 'V', 'E', 'R', 'R', 'I', 'D', 'E', '_', 'U', 'N', 'D', 'E', 'R', '_', 'R', 'A', 'S', 'T', '_', 'I', 'N', 'N', 'E', 'R', '_', 'T', 'O', '_', 'N', 'O', 'R', 'M', 'A', 'L', '\0', /* OVERRIDE_UNDER_RAST_INNER_TO_NORMAL (88675) */
	'D', 'E', 'G', 'E', 'N', 'E', 'R', 'A', 'T', 'E', '_', 'O', 'V', 'E', 'R', 'R', 'I', 'D', 'E', '_', 'I', 'N', 'N', 'E', 'R', '_', 'T', 'O', '_', 'N', 'O', 'R', 'M', 'A', 'L', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* DEGENERATE_OVERRIDE_INNER_TO_NORMAL_DISABLE (88711) */
	'S', 'C', '_', 'H', 'A', 'L', 'F', '_', 'L', 'S', 'B', '\0', /* SC_HALF_LSB (88755) */
	'S', 'C', '_', 'L', 'S', 'B', '_', 'O', 'N', 'E', '_', 'S', 'I', 'D', 'E', 'D', '\0', /* SC_LSB_ONE_SIDED (88767, 88780) */
	'S', 'C', '_', 'L', 'S', 'B', '_', 'T', 'W', 'O', '_', 'S', 'I', 'D', 'E', 'D', '\0', /* SC_LSB_TWO_SIDED (88784) */
	'U', 'N', 'C', 'E', 'R', 'T', 'A', 'I', 'N', 'T', 'Y', '_', 'R', 'E', 'G', 'I', 'O', 'N', '_', 'M', 'O', 'D', 'E', '\0', /* UNCERTAINTY_REGION_MODE (88801) */
	'O', 'U', 'T', 'E', 'R', '_', 'U', 'N', 'C', 'E', 'R', 'T', 'A', 'I', 'N', 'T', 'Y', '_', 'E', 'D', 'G', 'E', 'R', 'U', 'L', 'E', '_', 'O', 'V', 'E', 'R', 'R', 'I', 'D', 'E', '\0', /* OUTER_UNCERTAINTY_EDGERULE_OVERRIDE (88825) */
	'I', 'N', 'N', 'E', 'R', '_', 'U', 'N', 'C', 'E', 'R', 'T', 'A', 'I', 'N', 'T', 'Y', '_', 'E', 'D', 'G', 'E', 'R', 'U', 'L', 'E', '_', 'O', 'V', 'E', 'R', 'R', 'I', 'D', 'E', '\0', /* INNER_UNCERTAINTY_EDGERULE_OVERRIDE (88861) */
	'N', 'U', 'L', 'L', '_', 'S', 'Q', 'U', 'A', 'D', '_', 'A', 'A', '_', 'M', 'A', 'S', 'K', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* NULL_SQUAD_AA_MASK_ENABLE (88897) */
	'C', 'O', 'V', 'E', 'R', 'A', 'G', 'E', '_', 'A', 'A', '_', 'M', 'A', 'S', 'K', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* COVERAGE_AA_MASK_ENABLE (88923) */
	'P', 'R', 'E', 'Z', '_', 'A', 'A', '_', 'M', 'A', 'S', 'K', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* PREZ_AA_MASK_ENABLE (88947) */
	'P', 'O', 'S', 'T', 'Z', '_', 'A', 'A', '_', 'M', 'A', 'S', 'K', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* POSTZ_AA_MASK_ENABLE (88967) */
	'C', 'E', 'N', 'T', 'R', 'O', 'I', 'D', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'O', 'V', 'E', 'R', 'R', 'I', 'D', 'E', '\0', /* CENTROID_SAMPLE_OVERRIDE (88988) */
	'U', 'N', 'C', 'E', 'R', 'T', 'A', 'I', 'N', 'T', 'Y', '_', 'R', 'E', 'G', 'I', 'O', 'N', '_', 'M', 'U', 'L', 'T', '\0', /* UNCERTAINTY_REGION_MULT (89013) */
	'U', 'N', 'C', 'E', 'R', 'T', 'A', 'I', 'N', 'T', 'Y', '_', 'R', 'E', 'G', 'I', 'O', 'N', '_', 'P', 'B', 'B', '_', 'M', 'U', 'L', 'T', '\0', /* UNCERTAINTY_REGION_PBB_MULT (89037) */
	'M', 'A', 'X', '_', 'D', 'E', 'A', 'L', 'L', 'O', 'C', 'S', '_', 'I', 'N', '_', 'W', 'A', 'V', 'E', '\0', /* MAX_DEALLOCS_IN_WAVE (89065) */
	'M', 'A', 'X', '_', 'F', 'P', 'O', 'V', 'S', '_', 'I', 'N', '_', 'W', 'A', 'V', 'E', '\0', /* MAX_FPOVS_IN_WAVE (89086) */
	'V', 'T', 'X', '_', 'R', 'E', 'U', 'S', 'E', '_', 'D', 'E', 'P', 'T', 'H', '\0', /* VTX_REUSE_DEPTH (89104) */
	'D', 'E', 'A', 'L', 'L', 'O', 'C', '_', 'D', 'I', 'S', 'T', '\0', /* DEALLOC_DIST (89120) */
	'T', 'I', 'L', 'E', '_', 'M', 'A', 'X', '\0', /* TILE_MAX (89133) */
	'F', 'M', 'A', 'S', 'K', '_', 'T', 'I', 'L', 'E', '_', 'M', 'A', 'X', '\0', /* FMASK_TILE_MAX (89142) */
	'M', 'I', 'P', '_', 'L', 'E', 'V', 'E', 'L', '\0', /* MIP_LEVEL (89157) */
	'E', 'N', 'D', 'I', 'A', 'N', '_', 'N', 'O', 'N', 'E', '\0', /* ENDIAN_NONE (89167) */
	'E', 'N', 'D', 'I', 'A', 'N', '_', '8', 'I', 'N', '1', '6', '\0', /* ENDIAN_8IN16 (89179) */
	'E', 'N', 'D', 'I', 'A', 'N', '_', '8', 'I', 'N', '3', '2', '\0', /* ENDIAN_8IN32 (89192) */
	'E', 'N', 'D', 'I', 'A', 'N', '_', '8', 'I', 'N', '6', '4', '\0', /* ENDIAN_8IN64 (89205) */
	'E', 'N', 'D', 'I', 'A', 'N', '\0', /* ENDIAN (89218) */
	'C', 'O', 'L', 'O', 'R', '_', 'I', 'N', 'V', 'A', 'L', 'I', 'D', '\0', /* COLOR_INVALID (89225) */
	'C', 'O', 'L', 'O', 'R', '_', '8', '\0', /* COLOR_8 (89239) */
	'C', 'O', 'L', 'O', 'R', '_', '1', '6', '\0', /* COLOR_16 (89247) */
	'C', 'O', 'L', 'O', 'R', '_', '8', '_', '8', '\0', /* COLOR_8_8 (89256) */
	'C', 'O', 'L', 'O', 'R', '_', '3', '2', '\0', /* COLOR_32 (89266) */
	'C', 'O', 'L', 'O', 'R', '_', '1', '6', '_', '1', '6', '\0', /* COLOR_16_16 (89275) */
	'C', 'O', 'L', 'O', 'R', '_', '1', '0', '_', '1', '1', '_', '1', '1', '\0', /* COLOR_10_11_11 (89287) */
	'C', 'O', 'L', 'O', 'R', '_', '1', '1', '_', '1', '1', '_', '1', '0', '\0', /* COLOR_11_11_10 (89302) */
	'C', 'O', 'L', 'O', 'R', '_', '1', '0', '_', '1', '0', '_', '1', '0', '_', '2', '\0', /* COLOR_10_10_10_2 (89317) */
	'C', 'O', 'L', 'O', 'R', '_', '2', '_', '1', '0', '_', '1', '0', '_', '1', '0', '\0', /* COLOR_2_10_10_10 (89334) */
	'C', 'O', 'L', 'O', 'R', '_', '8', '_', '8', '_', '8', '_', '8', '\0', /* COLOR_8_8_8_8 (89351) */
	'C', 'O', 'L', 'O', 'R', '_', '3', '2', '_', '3', '2', '\0', /* COLOR_32_32 (89365) */
	'C', 'O', 'L', 'O', 'R', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', '1', '6', '\0', /* COLOR_16_16_16_16 (89377) */
	'C', 'O', 'L', 'O', 'R', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', '1', '3', '\0', /* COLOR_RESERVED_13 (89395) */
	'C', 'O', 'L', 'O', 'R', '_', '3', '2', '_', '3', '2', '_', '3', '2', '_', '3', '2', '\0', /* COLOR_32_32_32_32 (89413) */
	'C', 'O', 'L', 'O', 'R', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', '1', '5', '\0', /* COLOR_RESERVED_15 (89431) */
	'C', 'O', 'L', 'O', 'R', '_', '5', '_', '6', '_', '5', '\0', /* COLOR_5_6_5 (89449) */
	'C', 'O', 'L', 'O', 'R', '_', '1', '_', '5', '_', '5', '_', '5', '\0', /* COLOR_1_5_5_5 (89461) */
	'C', 'O', 'L', 'O', 'R', '_', '5', '_', '5', '_', '5', '_', '1', '\0', /* COLOR_5_5_5_1 (89475) */
	'C', 'O', 'L', 'O', 'R', '_', '4', '_', '4', '_', '4', '_', '4', '\0', /* COLOR_4_4_4_4 (89489) */
	'C', 'O', 'L', 'O', 'R', '_', '8', '_', '2', '4', '\0', /* COLOR_8_24 (89503) */
	'C', 'O', 'L', 'O', 'R', '_', '2', '4', '_', '8', '\0', /* COLOR_24_8 (89514) */
	'C', 'O', 'L', 'O', 'R', '_', 'X', '2', '4', '_', '8', '_', '3', '2', '_', 'F', 'L', 'O', 'A', 'T', '\0', /* COLOR_X24_8_32_FLOAT (89525) */
	'C', 'O', 'L', 'O', 'R', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', '2', '3', '\0', /* COLOR_RESERVED_23 (89546) */
	'C', 'O', 'L', 'O', 'R', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', '2', '4', '\0', /* COLOR_RESERVED_24 (89564) */
	'C', 'O', 'L', 'O', 'R', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', '2', '5', '\0', /* COLOR_RESERVED_25 (89582) */
	'C', 'O', 'L', 'O', 'R', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', '2', '6', '\0', /* COLOR_RESERVED_26 (89600) */
	'C', 'O', 'L', 'O', 'R', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', '2', '7', '\0', /* COLOR_RESERVED_27 (89618) */
	'C', 'O', 'L', 'O', 'R', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', '2', '8', '\0', /* COLOR_RESERVED_28 (89636) */
	'C', 'O', 'L', 'O', 'R', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', '2', '9', '\0', /* COLOR_RESERVED_29 (89654) */
	'C', 'O', 'L', 'O', 'R', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', '3', '0', '\0', /* COLOR_RESERVED_30 (89672) */
	'C', 'O', 'L', 'O', 'R', '_', '2', '_', '1', '0', '_', '1', '0', '_', '1', '0', '_', '6', 'E', '4', '\0', /* COLOR_2_10_10_10_6E4 (89690) */
	'N', 'U', 'M', 'B', 'E', 'R', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* NUMBER_UNORM (89711) */
	'N', 'U', 'M', 'B', 'E', 'R', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* NUMBER_SNORM (89724) */
	'N', 'U', 'M', 'B', 'E', 'R', '_', 'U', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* NUMBER_USCALED (89737) */
	'N', 'U', 'M', 'B', 'E', 'R', '_', 'S', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* NUMBER_SSCALED (89752) */
	'N', 'U', 'M', 'B', 'E', 'R', '_', 'U', 'I', 'N', 'T', '\0', /* NUMBER_UINT (89767) */
	'N', 'U', 'M', 'B', 'E', 'R', '_', 'S', 'I', 'N', 'T', '\0', /* NUMBER_SINT (89779) */
	'N', 'U', 'M', 'B', 'E', 'R', '_', 'S', 'R', 'G', 'B', '\0', /* NUMBER_SRGB (89791) */
	'N', 'U', 'M', 'B', 'E', 'R', '_', 'F', 'L', 'O', 'A', 'T', '\0', /* NUMBER_FLOAT (89803) */
	'N', 'U', 'M', 'B', 'E', 'R', '_', 'T', 'Y', 'P', 'E', '\0', /* NUMBER_TYPE (89816) */
	'S', 'W', 'A', 'P', '_', 'S', 'T', 'D', '\0', /* SWAP_STD (89828) */
	'S', 'W', 'A', 'P', '_', 'A', 'L', 'T', '\0', /* SWAP_ALT (89837) */
	'S', 'W', 'A', 'P', '_', 'S', 'T', 'D', '_', 'R', 'E', 'V', '\0', /* SWAP_STD_REV (89846) */
	'S', 'W', 'A', 'P', '_', 'A', 'L', 'T', '_', 'R', 'E', 'V', '\0', /* SWAP_ALT_REV (89859) */
	'C', 'O', 'M', 'P', '_', 'S', 'W', 'A', 'P', '\0', /* COMP_SWAP (89872) */
	'B', 'L', 'E', 'N', 'D', '_', 'C', 'L', 'A', 'M', 'P', '\0', /* BLEND_CLAMP (89882) */
	'B', 'L', 'E', 'N', 'D', '_', 'B', 'Y', 'P', 'A', 'S', 'S', '\0', /* BLEND_BYPASS (89894) */
	'S', 'I', 'M', 'P', 'L', 'E', '_', 'F', 'L', 'O', 'A', 'T', '\0', /* SIMPLE_FLOAT (89907) */
	'C', 'M', 'A', 'S', 'K', '_', 'I', 'S', '_', 'L', 'I', 'N', 'E', 'A', 'R', '\0', /* CMASK_IS_LINEAR (89920, 89929) */
	'F', 'O', 'R', 'C', 'E', '_', 'O', 'P', 'T', '_', 'A', 'U', 'T', 'O', '\0', /* FORCE_OPT_AUTO (89936) */
	'F', 'O', 'R', 'C', 'E', '_', 'O', 'P', 'T', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* FORCE_OPT_DISABLE (89951) */
	'F', 'O', 'R', 'C', 'E', '_', 'O', 'P', 'T', '_', 'E', 'N', 'A', 'B', 'L', 'E', '_', 'I', 'F', '_', 'S', 'R', 'C', '_', 'A', '_', '0', '\0', /* FORCE_OPT_ENABLE_IF_SRC_A_0 (89969) */
	'F', 'O', 'R', 'C', 'E', '_', 'O', 'P', 'T', '_', 'E', 'N', 'A', 'B', 'L', 'E', '_', 'I', 'F', '_', 'S', 'R', 'C', '_', 'R', 'G', 'B', '_', '0', '\0', /* FORCE_OPT_ENABLE_IF_SRC_RGB_0 (89997) */
	'F', 'O', 'R', 'C', 'E', '_', 'O', 'P', 'T', '_', 'E', 'N', 'A', 'B', 'L', 'E', '_', 'I', 'F', '_', 'S', 'R', 'C', '_', 'A', 'R', 'G', 'B', '_', '0', '\0', /* FORCE_OPT_ENABLE_IF_SRC_ARGB_0 (90027) */
	'F', 'O', 'R', 'C', 'E', '_', 'O', 'P', 'T', '_', 'E', 'N', 'A', 'B', 'L', 'E', '_', 'I', 'F', '_', 'S', 'R', 'C', '_', 'A', '_', '1', '\0', /* FORCE_OPT_ENABLE_IF_SRC_A_1 (90058) */
	'F', 'O', 'R', 'C', 'E', '_', 'O', 'P', 'T', '_', 'E', 'N', 'A', 'B', 'L', 'E', '_', 'I', 'F', '_', 'S', 'R', 'C', '_', 'R', 'G', 'B', '_', '1', '\0', /* FORCE_OPT_ENABLE_IF_SRC_RGB_1 (90086) */
	'F', 'O', 'R', 'C', 'E', '_', 'O', 'P', 'T', '_', 'E', 'N', 'A', 'B', 'L', 'E', '_', 'I', 'F', '_', 'S', 'R', 'C', '_', 'A', 'R', 'G', 'B', '_', '1', '\0', /* FORCE_OPT_ENABLE_IF_SRC_ARGB_1 (90116) */
	'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '_', 'D', 'O', 'N', 'T', '_', 'R', 'D', '_', 'D', 'S', 'T', '\0', /* BLEND_OPT_DONT_RD_DST (90147) */
	'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '_', 'D', 'I', 'S', 'C', 'A', 'R', 'D', '_', 'P', 'I', 'X', 'E', 'L', '\0', /* BLEND_OPT_DISCARD_PIXEL (90169) */
	'F', 'M', 'A', 'S', 'K', '_', 'C', 'O', 'M', 'P', 'R', 'E', 'S', 'S', 'I', 'O', 'N', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* FMASK_COMPRESSION_DISABLE (90193) */
	'F', 'M', 'A', 'S', 'K', '_', 'C', 'O', 'M', 'P', 'R', 'E', 'S', 'S', '_', '1', 'F', 'R', 'A', 'G', '_', 'O', 'N', 'L', 'Y', '\0', /* FMASK_COMPRESS_1FRAG_ONLY (90219) */
	'D', 'C', 'C', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* DCC_ENABLE (90245) */
	'C', 'M', 'A', 'S', 'K', '_', 'A', 'D', 'D', 'R', '_', 'T', 'I', 'L', 'E', 'D', '\0', /* CMASK_ADDR_TILED (90256) */
	'C', 'M', 'A', 'S', 'K', '_', 'A', 'D', 'D', 'R', '_', 'L', 'I', 'N', 'E', 'A', 'R', '\0', /* CMASK_ADDR_LINEAR (90273) */
	'C', 'M', 'A', 'S', 'K', '_', 'A', 'D', 'D', 'R', '_', 'C', 'O', 'M', 'P', 'A', 'T', 'I', 'B', 'L', 'E', '\0', /* CMASK_ADDR_COMPATIBLE (90291) */
	'C', 'M', 'A', 'S', 'K', '_', 'A', 'D', 'D', 'R', '_', 'T', 'Y', 'P', 'E', '\0', /* CMASK_ADDR_TYPE (90313) */
	'A', 'L', 'T', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '\0', /* ALT_TILE_MODE (90329) */
	'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* TILE_MODE_INDEX (90343) */
	'F', 'M', 'A', 'S', 'K', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* FMASK_TILE_MODE_INDEX (90359) */
	'F', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'N', 'K', '_', 'H', 'E', 'I', 'G', 'H', 'T', '\0', /* FMASK_BANK_HEIGHT (90381) */
	'N', 'U', 'M', '_', 'F', 'R', 'A', 'G', 'M', 'E', 'N', 'T', 'S', '\0', /* NUM_FRAGMENTS (90399) */
	'F', 'O', 'R', 'C', 'E', '_', 'D', 'S', 'T', '_', 'A', 'L', 'P', 'H', 'A', '_', '1', '\0', /* FORCE_DST_ALPHA_1 (90413) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'F', 'M', 'A', 'S', 'K', '_', 'N', 'O', 'F', 'E', 'T', 'C', 'H', '_', 'O', 'P', 'T', '\0', /* DISABLE_FMASK_NOFETCH_OPT (90431) */
	'L', 'I', 'M', 'I', 'T', '_', 'C', 'O', 'L', 'O', 'R', '_', 'F', 'E', 'T', 'C', 'H', '_', 'T', 'O', '_', '2', '5', '6', 'B', '_', 'M', 'A', 'X', '\0', /* LIMIT_COLOR_FETCH_TO_256B_MAX (90457) */
	'K', 'E', 'Y', '_', 'C', 'L', 'E', 'A', 'R', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* KEY_CLEAR_ENABLE (90487) */
	'M', 'A', 'X', '_', 'B', 'L', 'O', 'C', 'K', '_', 'S', 'I', 'Z', 'E', '_', '6', '4', 'B', '\0', /* MAX_BLOCK_SIZE_64B (90504) */
	'M', 'A', 'X', '_', 'B', 'L', 'O', 'C', 'K', '_', 'S', 'I', 'Z', 'E', '_', '1', '2', '8', 'B', '\0', /* MAX_BLOCK_SIZE_128B (90523) */
	'M', 'A', 'X', '_', 'B', 'L', 'O', 'C', 'K', '_', 'S', 'I', 'Z', 'E', '_', '2', '5', '6', 'B', '\0', /* MAX_BLOCK_SIZE_256B (90543) */
	'M', 'I', 'N', '_', 'B', 'L', 'O', 'C', 'K', '_', 'S', 'I', 'Z', 'E', '_', '3', '2', 'B', '\0', /* MIN_BLOCK_SIZE_32B (90563) */
	'M', 'I', 'N', '_', 'B', 'L', 'O', 'C', 'K', '_', 'S', 'I', 'Z', 'E', '_', '6', '4', 'B', '\0', /* MIN_BLOCK_SIZE_64B (90582) */
	'M', 'I', 'N', '_', 'C', 'O', 'M', 'P', 'R', 'E', 'S', 'S', 'E', 'D', '_', 'B', 'L', 'O', 'C', 'K', '_', 'S', 'I', 'Z', 'E', '\0', /* MIN_COMPRESSED_BLOCK_SIZE (90601) */
	'I', 'N', 'D', 'E', 'P', 'E', 'N', 'D', 'E', 'N', 'T', '_', '6', '4', 'B', '_', 'B', 'L', 'O', 'C', 'K', 'S', '\0', /* INDEPENDENT_64B_BLOCKS (90627) */
	'L', 'O', 'S', 'S', 'Y', '_', 'R', 'G', 'B', '_', 'P', 'R', 'E', 'C', 'I', 'S', 'I', 'O', 'N', '\0', /* LOSSY_RGB_PRECISION (90650) */
	'L', 'O', 'S', 'S', 'Y', '_', 'A', 'L', 'P', 'H', 'A', '_', 'P', 'R', 'E', 'C', 'I', 'S', 'I', 'O', 'N', '\0', /* LOSSY_ALPHA_PRECISION (90670) */
	'E', 'N', 'A', 'B', 'L', 'E', '_', 'C', 'O', 'N', 'S', 'T', 'A', 'N', 'T', '_', 'E', 'N', 'C', 'O', 'D', 'E', '_', 'R', 'E', 'G', '_', 'W', 'R', 'I', 'T', 'E', '\0', /* ENABLE_CONSTANT_ENCODE_REG_WRITE (90692) */
	'I', 'N', 'D', 'E', 'P', 'E', 'N', 'D', 'E', 'N', 'T', '_', '1', '2', '8', 'B', '_', 'B', 'L', 'O', 'C', 'K', 'S', '\0', /* INDEPENDENT_128B_BLOCKS (90725) */
	'B', 'A', 'S', 'E', '_', '2', '5', '6', 'B', '\0', /* BASE_256B (90749) */
	'M', 'I', 'P', '0', '_', 'H', 'E', 'I', 'G', 'H', 'T', '\0', /* MIP0_HEIGHT (90759) */
	'M', 'I', 'P', '0', '_', 'W', 'I', 'D', 'T', 'H', '\0', /* MIP0_WIDTH (90771) */
	'M', 'I', 'P', '0', '_', 'D', 'E', 'P', 'T', 'H', '\0', /* MIP0_DEPTH (90782) */
	'M', 'E', 'T', 'A', '_', 'L', 'I', 'N', 'E', 'A', 'R', '\0', /* META_LINEAR (90793) */
	'C', 'O', 'L', 'O', 'R', '_', 'S', 'W', '_', 'M', 'O', 'D', 'E', '\0', /* COLOR_SW_MODE (90805) */
	'F', 'M', 'A', 'S', 'K', '_', 'S', 'W', '_', 'M', 'O', 'D', 'E', '\0', /* FMASK_SW_MODE (90819) */
	'R', 'E', 'S', 'O', 'U', 'R', 'C', 'E', '_', 'T', 'Y', 'P', 'E', '\0', /* RESOURCE_TYPE (90833) */
	'C', 'M', 'A', 'S', 'K', '_', 'P', 'I', 'P', 'E', '_', 'A', 'L', 'I', 'G', 'N', 'E', 'D', '\0', /* CMASK_PIPE_ALIGNED (90847) */
	'D', 'C', 'C', '_', 'P', 'I', 'P', 'E', '_', 'A', 'L', 'I', 'G', 'N', 'E', 'D', '\0', /* DCC_PIPE_ALIGNED (90866) */
	'D', 'O', 'O', 'R', 'B', 'E', 'L', 'L', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* DOORBELL_OFFSET (90883) */
	'C', 'A', 'C', 'H', 'E', '_', 'P', 'O', 'L', 'I', 'C', 'Y', '\0', /* CACHE_POLICY (90899) */
	'O', 'F', 'F', 'S', 'E', 'T', '_', 'U', 'P', 'D', 'A', 'T', 'E', '_', 'D', 'O', 'N', 'E', '\0', /* OFFSET_UPDATE_DONE (90912) */
	'O', 'B', 'S', 'O', 'L', 'E', 'T', 'E', '_', 'U', 'M', 'S', 'K', '\0', /* OBSOLETE_UMSK (90931) */
	'O', 'B', 'S', 'O', 'L', 'E', 'T', 'E', '_', 'S', 'W', 'A', 'P', '\0', /* OBSOLETE_SWAP (90945) */
	'M', 'E', 'M', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* MEM_ADDR_LO (90959) */
	'M', 'E', 'M', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* MEM_ADDR_HI (90971) */
	'C', 'S', '_', 'P', 'S', '_', 'S', 'E', 'L', '\0', /* CS_PS_SEL (90983) */
	'S', 'E', 'M', '_', 'A', 'D', 'D', 'R', '_', 'S', 'W', 'A', 'P', '\0', /* SEM_ADDR_SWAP (90993, 90997) */
	'S', 'E', 'M', '_', 'U', 'S', 'E', '_', 'M', 'A', 'I', 'L', 'B', 'O', 'X', '\0', /* SEM_USE_MAILBOX (91007) */
	'S', 'E', 'M', '_', 'S', 'I', 'G', 'N', 'A', 'L', '_', 'T', 'Y', 'P', 'E', '\0', /* SEM_SIGNAL_TYPE (91023) */
	'S', 'E', 'M', '_', 'C', 'L', 'I', 'E', 'N', 'T', '_', 'C', 'O', 'D', 'E', '\0', /* SEM_CLIENT_CODE (91039) */
	'S', 'E', 'M', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SEM_SELECT (91055) */
	'M', 'E', 'M', 'L', 'O', 'G', '_', 'C', 'L', 'E', 'A', 'R', '\0', /* MEMLOG_CLEAR (91066) */
	'S', 'R', 'C', '_', 'C', 'A', 'C', 'H', 'E', '_', 'P', 'O', 'L', 'I', 'C', 'Y', '\0', /* SRC_CACHE_POLICY (91079) */
	'S', 'R', 'C', '_', 'V', 'O', 'L', 'A', 'T', 'L', 'E', '\0', /* SRC_VOLATLE (91096) */
	'D', 'S', 'T', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* DST_SELECT (91108) */
	'D', 'S', 'T', '_', 'C', 'A', 'C', 'H', 'E', '_', 'P', 'O', 'L', 'I', 'C', 'Y', '\0', /* DST_CACHE_POLICY (91119) */
	'D', 'S', 'T', '_', 'V', 'O', 'L', 'A', 'T', 'L', 'E', '\0', /* DST_VOLATLE (91136) */
	'S', 'R', 'C', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SRC_SELECT (91148) */
	'C', 'O', 'H', 'E', 'R', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '_', '2', '5', '6', 'B', '\0', /* COHER_BASE_HI_256B (91159) */
	'S', 'T', 'A', 'R', 'T', '_', 'D', 'E', 'L', 'A', 'Y', '_', 'C', 'O', 'U', 'N', 'T', '\0', /* START_DELAY_COUNT (91178) */
	'T', 'C', '_', 'N', 'C', '_', 'A', 'C', 'T', 'I', 'O', 'N', '_', 'E', 'N', 'A', '\0', /* TC_NC_ACTION_ENA (91196) */
	'T', 'C', '_', 'W', 'C', '_', 'A', 'C', 'T', 'I', 'O', 'N', '_', 'E', 'N', 'A', '\0', /* TC_WC_ACTION_ENA (91213) */
	'T', 'C', '_', 'I', 'N', 'V', '_', 'M', 'E', 'T', 'A', 'D', 'A', 'T', 'A', '_', 'A', 'C', 'T', 'I', 'O', 'N', '_', 'E', 'N', 'A', '\0', /* TC_INV_METADATA_ACTION_ENA (91230) */
	'T', 'C', 'L', '1', '_', 'V', 'O', 'L', '_', 'A', 'C', 'T', 'I', 'O', 'N', '_', 'E', 'N', 'A', '\0', /* TCL1_VOL_ACTION_ENA (91257) */
	'T', 'C', '_', 'W', 'B', '_', 'A', 'C', 'T', 'I', 'O', 'N', '_', 'E', 'N', 'A', '\0', /* TC_WB_ACTION_ENA (91277) */
	'T', 'C', 'L', '1', '_', 'A', 'C', 'T', 'I', 'O', 'N', '_', 'E', 'N', 'A', '\0', /* TCL1_ACTION_ENA (91294) */
	'T', 'C', '_', 'A', 'C', 'T', 'I', 'O', 'N', '_', 'E', 'N', 'A', '\0', /* TC_ACTION_ENA (91310) */
	'C', 'B', '_', 'A', 'C', 'T', 'I', 'O', 'N', '_', 'E', 'N', 'A', '\0', /* CB_ACTION_ENA (91324) */
	'D', 'B', '_', 'A', 'C', 'T', 'I', 'O', 'N', '_', 'E', 'N', 'A', '\0', /* DB_ACTION_ENA (91338) */
	'S', 'H', '_', 'K', 'C', 'A', 'C', 'H', 'E', '_', 'A', 'C', 'T', 'I', 'O', 'N', '_', 'E', 'N', 'A', '\0', /* SH_KCACHE_ACTION_ENA (91352) */
	'S', 'H', '_', 'K', 'C', 'A', 'C', 'H', 'E', '_', 'V', 'O', 'L', '_', 'A', 'C', 'T', 'I', 'O', 'N', '_', 'E', 'N', 'A', '\0', /* SH_KCACHE_VOL_ACTION_ENA (91373) */
	'S', 'H', '_', 'I', 'C', 'A', 'C', 'H', 'E', '_', 'A', 'C', 'T', 'I', 'O', 'N', '_', 'E', 'N', 'A', '\0', /* SH_ICACHE_ACTION_ENA (91398) */
	'S', 'H', '_', 'K', 'C', 'A', 'C', 'H', 'E', '_', 'W', 'B', '_', 'A', 'C', 'T', 'I', 'O', 'N', '_', 'E', 'N', 'A', '\0', /* SH_KCACHE_WB_ACTION_ENA (91419) */
	'M', 'E', 'I', 'D', '\0', /* MEID (91443) */
	'B', 'Y', 'T', 'E', '_', 'C', 'O', 'U', 'N', 'T', '\0', /* BYTE_COUNT (91448) */
	'S', 'A', 'S', '\0', /* SAS (91459) */
	'D', 'A', 'S', '\0', /* DAS (91463) */
	'S', 'A', 'I', 'C', '\0', /* SAIC (91467) */
	'D', 'A', 'I', 'C', '\0', /* DAIC (91472) */
	'R', 'A', 'W', '_', 'W', 'A', 'I', 'T', '\0', /* RAW_WAIT (91477) */
	'D', 'I', 'S', '_', 'W', 'C', '\0', /* DIS_WC (91486) */
	'U', 'T', 'C', 'L', '1', '_', 'F', 'A', 'U', 'L', 'T', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* UTCL1_FAULT_CONTROL (91493) */
	'W', 'A', 'T', 'C', 'H', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* WATCH_CONTROL (91513) */
	'M', 'I', 'N', '_', 'A', 'V', 'A', 'I', 'L', 'S', 'Z', '\0', /* MIN_AVAILSZ (91527) */
	'B', 'U', 'F', 'F', 'E', 'R', '_', 'D', 'E', 'P', 'T', 'H', '\0', /* BUFFER_DEPTH (91539) */
	'P', 'I', 'O', '_', 'F', 'I', 'F', 'O', '_', 'E', 'M', 'P', 'T', 'Y', '\0', /* PIO_FIFO_EMPTY (91552) */
	'P', 'I', 'O', '_', 'F', 'I', 'F', 'O', '_', 'F', 'U', 'L', 'L', '\0', /* PIO_FIFO_FULL (91567) */
	'P', 'I', 'O', '_', 'C', 'O', 'U', 'N', 'T', '\0', /* PIO_COUNT (91581) */
	'D', 'M', 'A', '_', 'R', 'E', 'A', 'D', '_', 'T', 'A', 'G', '\0', /* DMA_READ_TAG (91591) */
	'D', 'M', 'A', '_', 'R', 'E', 'A', 'D', '_', 'T', 'A', 'G', '_', 'V', 'A', 'L', 'I', 'D', '\0', /* DMA_READ_TAG_VALID (91604) */
	'C', 'O', 'H', 'E', 'R', '_', 'S', 'I', 'Z', 'E', '_', 'H', 'I', '_', '2', '5', '6', 'B', '\0', /* COHER_SIZE_HI_256B (91623) */
	'I', 'B', '_', 'E', 'N', '\0', /* IB_EN (91642) */
	'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'E', 'G', '_', 'E', 'N', '\0', /* CONFIG_REG_EN (91648) */
	'C', 'N', 'T', 'X', '_', 'R', 'E', 'G', '_', 'E', 'N', '\0', /* CNTX_REG_EN (91662) */
	'S', 'H', '_', 'G', 'F', 'X', '_', 'R', 'E', 'G', '_', 'E', 'N', '\0', /* SH_GFX_REG_EN (91674) */
	'S', 'H', '_', 'C', 'S', '_', 'R', 'E', 'G', '_', 'E', 'N', '\0', /* SH_CS_REG_EN (91688) */
	'R', 'S', 'V', 'D', '\0', /* RSVD (91701) */
	'I', 'N', 'I', 'T', '_', 'C', 'M', 'D', '_', 'R', 'E', 'Q', 'S', 'Z', '\0', /* INIT_CMD_REQSZ (91706) */
	'I', 'B', '1', '_', 'C', 'M', 'D', '_', 'R', 'E', 'Q', 'S', 'Z', '\0', /* IB1_CMD_REQSZ (91721) */
	'I', 'B', '2', '_', 'C', 'M', 'D', '_', 'R', 'E', 'Q', 'S', 'Z', '\0', /* IB2_CMD_REQSZ (91735) */
	'S', 'T', '_', 'C', 'M', 'D', '_', 'R', 'E', 'Q', 'S', 'Z', '\0', /* ST_CMD_REQSZ (91749) */
	'E', 'O', 'P', '_', 'V', 'O', 'L', 'A', 'T', 'I', 'L', 'E', '\0', /* EOP_VOLATILE (91762) */
	'E', 'X', 'E', 'C', 'U', 'T', 'E', '\0', /* EXECUTE (91775) */
	'D', 'S', 'T', '_', 'S', 'E', 'L', '\0', /* DST_SEL (91783) */
	'I', 'N', 'T', '_', 'S', 'E', 'L', '\0', /* INT_SEL (91791) */
	'D', 'A', 'T', 'A', '_', 'S', 'E', 'L', '\0', /* DATA_SEL (91799) */
	'D', 'B', '_', 'C', 'M', 'D', '_', 'R', 'E', 'Q', 'S', 'Z', '\0', /* DB_CMD_REQSZ (91808) */
	'Z', '_', 'P', 'A', 'S', 'S', '_', 'A', 'C', 'I', 'T', 'V', 'E', '\0', /* Z_PASS_ACITVE (91821) */
	'S', 'T', 'R', 'E', 'A', 'M', 'O', 'U', 'T', '_', 'A', 'C', 'T', 'I', 'V', 'E', '\0', /* STREAMOUT_ACTIVE (91835) */
	'P', 'I', 'P', 'E', 'L', 'I', 'N', 'E', '_', 'A', 'C', 'T', 'I', 'V', 'E', '\0', /* PIPELINE_ACTIVE (91852) */
	'S', 'T', 'I', 'P', 'P', 'L', 'E', '_', 'A', 'C', 'T', 'I', 'V', 'E', '\0', /* STIPPLE_ACTIVE (91868) */
	'V', 'G', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', 'S', '_', 'A', 'C', 'T', 'I', 'V', 'E', '\0', /* VGT_BUFFERS_ACTIVE (91883) */
	'S', 'C', 'R', 'E', 'E', 'N', '_', 'E', 'X', 'T', '_', 'A', 'C', 'T', 'I', 'V', 'E', '\0', /* SCREEN_EXT_ACTIVE (91902) */
	'D', 'R', 'A', 'W', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '_', 'A', 'C', 'T', 'I', 'V', 'E', '\0', /* DRAW_INDIRECT_ACTIVE (91920) */
	'D', 'I', 'S', 'P', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '_', 'A', 'C', 'T', 'I', 'V', 'E', '\0', /* DISP_INDIRECT_ACTIVE (91941) */
	'D', 'E', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', '0', '_', 'E', 'N', 'A', '\0', /* DEST_BASE_0_ENA (91962) */
	'D', 'E', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', '1', '_', 'E', 'N', 'A', '\0', /* DEST_BASE_1_ENA (91978) */
	'C', 'B', '0', '_', 'D', 'E', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', 'E', 'N', 'A', '\0', /* CB0_DEST_BASE_ENA (91994) */
	'C', 'B', '1', '_', 'D', 'E', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', 'E', 'N', 'A', '\0', /* CB1_DEST_BASE_ENA (92012) */
	'C', 'B', '2', '_', 'D', 'E', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', 'E', 'N', 'A', '\0', /* CB2_DEST_BASE_ENA (92030) */
	'C', 'B', '3', '_', 'D', 'E', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', 'E', 'N', 'A', '\0', /* CB3_DEST_BASE_ENA (92048) */
	'C', 'B', '4', '_', 'D', 'E', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', 'E', 'N', 'A', '\0', /* CB4_DEST_BASE_ENA (92066) */
	'C', 'B', '5', '_', 'D', 'E', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', 'E', 'N', 'A', '\0', /* CB5_DEST_BASE_ENA (92084) */
	'C', 'B', '6', '_', 'D', 'E', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', 'E', 'N', 'A', '\0', /* CB6_DEST_BASE_ENA (92102) */
	'C', 'B', '7', '_', 'D', 'E', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', 'E', 'N', 'A', '\0', /* CB7_DEST_BASE_ENA (92120) */
	'D', 'B', '_', 'D', 'E', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', 'E', 'N', 'A', '\0', /* DB_DEST_BASE_ENA (92138) */
	'D', 'E', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', '2', '_', 'E', 'N', 'A', '\0', /* DEST_BASE_2_ENA (92155) */
	'D', 'E', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', '3', '_', 'E', 'N', 'A', '\0', /* DEST_BASE_3_ENA (92171) */
	'M', 'A', 'T', 'C', 'H', 'I', 'N', 'G', '_', 'G', 'F', 'X', '_', 'C', 'N', 'T', 'X', '\0', /* MATCHING_GFX_CNTX (92187) */
	'F', 'E', 'A', 'T', 'U', 'R', 'E', '_', 'S', 'E', 'L', '\0', /* FEATURE_SEL (92205) */
	'S', 'E', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* SE_INDEX (92217) */
	'S', 'A', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* SA_INDEX (92226) */
	'W', 'G', 'P', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* WGP_INDEX (92235) */
	'E', 'V', 'E', 'N', 'T', '_', 'S', 'E', 'L', '\0', /* EVENT_SEL (92245) */
	'U', 'N', 'U', 'S', 'E', 'D', '\0', /* UNUSED (92255) */
	'I', 'N', 'S', 'T', 'A', 'N', 'C', 'E', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* INSTANCE_INDEX (92262) */
	'S', 'A', '_', 'B', 'R', 'O', 'A', 'D', 'C', 'A', 'S', 'T', '_', 'W', 'R', 'I', 'T', 'E', 'S', '\0', /* SA_BROADCAST_WRITES (92277) */
	'I', 'N', 'S', 'T', 'A', 'N', 'C', 'E', '_', 'B', 'R', 'O', 'A', 'D', 'C', 'A', 'S', 'T', '_', 'W', 'R', 'I', 'T', 'E', 'S', '\0', /* INSTANCE_BROADCAST_WRITES (92297) */
	'S', 'E', '_', 'B', 'R', 'O', 'A', 'D', 'C', 'A', 'S', 'T', '_', 'W', 'R', 'I', 'T', 'E', 'S', '\0', /* SE_BROADCAST_WRITES (92323) */
	'O', 'F', 'F', 'C', 'H', 'I', 'P', '_', 'B', 'U', 'F', 'F', 'E', 'R', 'I', 'N', 'G', '\0', /* OFFCHIP_BUFFERING (92343) */
	'X', '_', '8', 'K', '_', 'D', 'W', 'O', 'R', 'D', 'S', '\0', /* X_8K_DWORDS (92361) */
	'X', '_', '4', 'K', '_', 'D', 'W', 'O', 'R', 'D', 'S', '\0', /* X_4K_DWORDS (92373) */
	'X', '_', '2', 'K', '_', 'D', 'W', 'O', 'R', 'D', 'S', '\0', /* X_2K_DWORDS (92385) */
	'X', '_', '1', 'K', '_', 'D', 'W', 'O', 'R', 'D', 'S', '\0', /* X_1K_DWORDS (92397) */
	'O', 'F', 'F', 'C', 'H', 'I', 'P', '_', 'G', 'R', 'A', 'N', 'U', 'L', 'A', 'R', 'I', 'T', 'Y', '\0', /* OFFCHIP_GRANULARITY (92409) */
	'E', 'N', '_', 'I', 'N', 'S', 'T', '_', 'O', 'P', 'T', '_', 'B', 'A', 'S', 'I', 'C', '\0', /* EN_INST_OPT_BASIC (92429) */
	'E', 'N', '_', 'I', 'N', 'S', 'T', '_', 'O', 'P', 'T', '_', 'A', 'D', 'V', '\0', /* EN_INST_OPT_ADV (92447) */
	'H', 'W', '_', 'U', 'S', 'E', '_', 'O', 'N', 'L', 'Y', '\0', /* HW_USE_ONLY (92463) */
	'P', 'R', 'I', 'M', '_', 'G', 'R', 'P', '_', 'S', 'I', 'Z', 'E', '\0', /* PRIM_GRP_SIZE (92475) */
	'V', 'E', 'R', 'T', '_', 'G', 'R', 'P', '_', 'S', 'I', 'Z', 'E', '\0', /* VERT_GRP_SIZE (92489) */
	'B', 'R', 'E', 'A', 'K', '_', 'W', 'A', 'V', 'E', '_', 'A', 'T', '_', 'E', 'O', 'I', '\0', /* BREAK_WAVE_AT_EOI (92503) */
	'P', 'A', 'C', 'K', 'E', 'T', '_', 'T', 'O', '_', 'O', 'N', 'E', '_', 'P', 'A', '\0', /* PACKET_TO_ONE_PA (92521) */
	'R', 'T', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* RT_SLICE (92538) */
	'V', 'I', 'E', 'W', 'P', 'O', 'R', 'T', '\0', /* VIEWPORT (92547) */
	'E', 'N', '_', 'S', 'T', 'E', 'R', 'E', 'O', '\0', /* EN_STEREO (92556) */
	'O', 'V', 'E', 'R', 'S', 'U', 'B', '_', 'E', 'N', '\0', /* OVERSUB_EN (92566) */
	'N', 'U', 'M', '_', 'P', 'C', '_', 'L', 'I', 'N', 'E', 'S', '\0', /* NUM_PC_LINES (92577) */
	'E', 'N', '_', 'U', 'S', 'E', 'R', '_', 'V', 'G', 'P', 'R', '1', '\0', /* EN_USER_VGPR1 (92590) */
	'E', 'N', '_', 'U', 'S', 'E', 'R', '_', 'V', 'G', 'P', 'R', '2', '\0', /* EN_USER_VGPR2 (92604) */
	'E', 'N', '_', 'U', 'S', 'E', 'R', '_', 'V', 'G', 'P', 'R', '3', '\0', /* EN_USER_VGPR3 (92618) */
	'C', 'U', 'R', 'R', 'E', 'N', 'T', '_', 'P', 'T', 'R', '\0', /* CURRENT_PTR (92632) */
	'C', 'U', 'R', 'R', 'E', 'N', 'T', '_', 'C', 'O', 'U', 'N', 'T', '\0', /* CURRENT_COUNT (92644) */
	'E', 'N', 'A', 'B', 'L', 'E', '_', 'H', 'V', '_', 'P', 'R', 'E', '_', 'S', 'H', 'A', 'D', 'E', 'R', '\0', /* ENABLE_HV_PRE_SHADER (92658) */
	'F', 'O', 'R', 'C', 'E', '_', 'P', 'R', 'E', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'A', 'L', 'L', '_', 'P', 'I', 'X', 'E', 'L', 'S', '\0', /* FORCE_PRE_SHADER_ALL_PIXELS (92679) */
	'X', '_', 'C', 'O', 'O', 'R', 'D', '\0', /* X_COORD (92707) */
	'Y', '_', 'C', 'O', 'O', 'R', 'D', '\0', /* Y_COORD (92715) */
	'T', 'A', 'R', 'G', 'E', 'T', '_', 'I', 'N', 'S', 'T', '\0', /* TARGET_INST (92723) */
	'T', 'A', 'R', 'G', 'E', 'T', '_', 'D', 'A', 'T', 'A', '\0', /* TARGET_DATA (92735) */
	'I', 'N', 'V', 'A', 'L', 'I', 'D', 'A', 'T', 'E', '\0', /* INVALIDATE (92747) */
	'L', '2', '_', 'W', 'B', '_', 'P', 'O', 'L', 'I', 'C', 'Y', '\0', /* L2_WB_POLICY (92758) */
	'D', 'W', 'B', '\0', /* DWB (92771) */
	'A', 'I', 'N', 'C', '\0', /* AINC (92775) */
	'U', 'N', 'U', 'S', 'E', 'D', '1', '\0', /* UNUSED1 (92780) */
	'D', 'M', 'O', 'D', 'E', '\0', /* DMODE (92788) */
	'U', 'N', 'U', 'S', 'E', 'D', '2', '\0', /* UNUSED2 (92794) */
	'R', 'E', 'L', 'E', 'A', 'S', 'E', '_', 'A', 'L', 'L', '\0', /* RELEASE_ALL (92802) */
	'H', 'E', 'A', 'D', '_', 'Q', 'U', 'E', 'U', 'E', '\0', /* HEAD_QUEUE (92814) */
	'H', 'E', 'A', 'D', '_', 'V', 'A', 'L', 'I', 'D', '\0', /* HEAD_VALID (92825) */
	'H', 'E', 'A', 'D', '_', 'F', 'L', 'A', 'G', '\0', /* HEAD_FLAG (92836) */
	'H', 'A', 'L', 'T', 'E', 'D', '\0', /* HALTED (92846) */
	'D', 'S', '_', 'A', 'D', 'D', 'R', 'E', 'S', 'S', '\0', /* DS_ADDRESS (92853) */
	'C', 'R', 'A', 'W', 'L', 'E', 'R', '_', 'T', 'Y', 'P', 'E', '\0', /* CRAWLER_TYPE (92864) */
	'C', 'R', 'A', 'W', 'L', 'E', 'R', '\0', /* CRAWLER (92877) */
	'N', 'O', '_', 'A', 'L', 'L', 'O', 'C', '\0', /* NO_ALLOC (92885) */
	'C', 'O', 'M', 'P', 'A', 'R', 'E', '_', 'V', 'A', 'L', 'U', 'E', '\0', /* COMPARE_VALUE (92894) */
	'P', 'E', 'R', 'F', '_', 'S', 'E', 'L', '\0', /* PERF_SEL (92908) */
	'P', 'E', 'R', 'F', '_', 'S', 'E', 'L', '1', '\0', /* PERF_SEL1 (92917) */
	'S', 'P', 'M', '_', 'M', 'O', 'D', 'E', '\0', /* SPM_MODE (92927) */
	'C', 'N', 'T', 'R', '_', 'M', 'O', 'D', 'E', '1', '\0', /* CNTR_MODE1 (92936) */
	'C', 'N', 'T', 'R', '_', 'M', 'O', 'D', 'E', '0', '\0', /* CNTR_MODE0 (92947) */
	'P', 'E', 'R', 'F', '_', 'S', 'E', 'L', '2', '\0', /* PERF_SEL2 (92958) */
	'P', 'E', 'R', 'F', '_', 'S', 'E', 'L', '3', '\0', /* PERF_SEL3 (92968) */
	'C', 'N', 'T', 'R', '_', 'M', 'O', 'D', 'E', '3', '\0', /* CNTR_MODE3 (92978) */
	'C', 'N', 'T', 'R', '_', 'M', 'O', 'D', 'E', '2', '\0', /* CNTR_MODE2 (92989) */
	'C', 'P', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'T', 'A', 'T', 'E', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'A', 'N', 'D', '_', 'R', 'E', 'S', 'E', 'T', '\0', /* CP_PERFMON_STATE_DISABLE_AND_RESET (93000) */
	'C', 'P', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'T', 'A', 