#!/bin/sh

INSTDIR=`pwd`
KERNELS="vmlinux-nfsroot.gz vmlinux.gz vmlinux_RAQ.gz vmlinux_raq-2800.gz"

copy_spec()
{
	( cd $1; tar cpf - etc ) | tar vxpf -
	( cd $1; tar cpf - var ) | tar vxpf -
	( cd $1; tar cpf - dev ) | tar vxpf -
	( cd $1; tar cpf - mnt ) | tar vxpf -
	( cd $1; tar cpf - stand ) | tar vxpf -

	( cd $INSTDIR/install/files/$2; tar cpf - * ) | tar vxpf -

#	cd dev && ./MAKEDEV all
#	cd ..

	mv var altvar

	mkdir altroot
	mkdir home
	mkdir root
	mkdir var
	mkdir tmp

	cp $INSTDIR/install/files/common/.cshrc root/
}

copy_files()
{
	# Copy all necessary files
	( cd $1; tar cpfT - $INSTDIR/install/data/files.$2 ) | tar vxpf -

	# Fix the tree
	copy_spec $1 $2
}

fix_boot()
{
	cd cobaltcd/nfsroot/boot

	for i in $KERNELS; do
		ln -s netbsd.gz $i
	done

	cd ../../../
}

create_cddir()
{
	rm -rf cobaltcd
	mkdir cobaltcd
	cd cobaltcd

	# Copy files
	copy_files $1 $3

	mkdir nfsroot
	cd nfsroot
	copy_files $2 $4

	# Create the LCD device node
	mknod dev/lcd c 34 0

	cd ../../

	# Fix cobalt's boot directory
	fix_boot
}

create_cd()
{
	create_cddir $1 $2 $3 $4

	rm -f image.iso

	mkisofs -o image.iso -b i386/installation/floppy/boot-big.fs \
		-c boot.catalog -l -J -r -L cobaltcd
}

usage()
{
	echo $#
	echo "Usage:"
	echo "$0 <boot_dist> <inst_dist> <boot_arch> <inst_arch>"
	echo ""
	echo "    <boot_dist>: full distro of the architecture to boot"
	echo "    <inst_dist>: full distro of the architecture to install"
	echo "    <boot_dist>: architecture used to boot (e.g. i386)"
	echo "    <boot_dist>: architecture to install (e.g. cobalt)"
	echo ""
	exit 1
}

if [ $# -ne 4 ]; then
	usage
fi

create_cd $1 $2 $3 $4
