
/*--------------------------------------------------------------------*/
/*--- NetBSD-specific syscalls stuff.        priv_syswrap-netbsd.h ---*/
/*--------------------------------------------------------------------*/

/*
   This file is part of Valgrind, a dynamic binary instrumentation
   framework.

   Copyright (C) 2000-2005 Nicholas Nethercote
      njn@valgrind.org

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307, USA.

   The GNU General Public License is contained in the file COPYING.
*/

#ifndef __PRIV_SYSWRAP_NETBSD_H
#define __PRIV_SYSWRAP_NETBSD_H

/* requires #include "priv_types_n_macros.h" */

// Clone-related functions
extern Word ML_(start_thread_NORETURN) ( void* arg );
extern Addr ML_(allocstack)            ( ThreadId tid );
extern void ML_(call_on_new_stack_0_1) ( Addr stack, Addr retaddr,
			                 void (*f)(Word), Word arg1 );
extern SysRes ML_(do_fork_clone) ( ThreadId tid, UInt flags,
                                   Int* parent_tidptr, Int* child_tidptr );

extern VgSchedReturnCode ML_(thread_wrapper)(Word /*ThreadId*/ tid);
DECL_TEMPLATE(netbsd, sys_set_tid_address);
DECL_TEMPLATE(netbsd, sys_exit_group);
DECL_TEMPLATE(netbsd, sys_mount);
DECL_TEMPLATE(netbsd, sys_unmount);
DECL_TEMPLATE(netbsd, sys_setfsuid16);
DECL_TEMPLATE(netbsd, sys_setfsuid);
DECL_TEMPLATE(netbsd, sys_setfsgid16);
DECL_TEMPLATE(netbsd, sys_setfsgid);
DECL_TEMPLATE(netbsd, sys_setresuid16);
DECL_TEMPLATE(netbsd, sys_setresuid);
DECL_TEMPLATE(netbsd, sys_getresuid16);
DECL_TEMPLATE(netbsd, sys_getresuid);
DECL_TEMPLATE(netbsd, sys_setresgid16);
DECL_TEMPLATE(netbsd, sys_setresgid);
DECL_TEMPLATE(netbsd, sys_getresgid16);
DECL_TEMPLATE(netbsd, sys_getresgid);
DECL_TEMPLATE(netbsd, sys_ioperm);
DECL_TEMPLATE(netbsd, sys_syslog);
DECL_TEMPLATE(netbsd, sys_vhangup);
DECL_TEMPLATE(netbsd, sys_sysinfo);
DECL_TEMPLATE(netbsd, sys_personality);
DECL_TEMPLATE(netbsd, sys_sysctl);
DECL_TEMPLATE(netbsd, sys_prctl);
DECL_TEMPLATE(netbsd, sys_io_setup);
DECL_TEMPLATE(netbsd, sys_io_destroy);
DECL_TEMPLATE(netbsd, sys_io_getevents);
DECL_TEMPLATE(netbsd, sys_io_submit);
DECL_TEMPLATE(netbsd, sys_io_cancel);
DECL_TEMPLATE(netbsd, sys_getfsstat);
DECL_TEMPLATE(netbsd, sys_chflags);
DECL_TEMPLATE(netbsd, sys_fchflags);
DECL_TEMPLATE(netbsd, sys_compat_stat);
DECL_TEMPLATE(netbsd, sys_compat_fstat);
DECL_TEMPLATE(netbsd, sys_compat_lstat);
DECL_TEMPLATE(netbsd, sys_compat_sigaction);
DECL_TEMPLATE(netbsd, sys_compat_sigprocmask);
DECL_TEMPLATE(netbsd, sys_compat_sigpending);
DECL_TEMPLATE(netbsd, sys_compat_sigaltstack);
DECL_TEMPLATE(netbsd, sys_getlogin);
DECL_TEMPLATE(netbsd, sys_setlogin);
DECL_TEMPLATE(netbsd, sys_revoke);
DECL_TEMPLATE(netbsd, sys_compat_uname);
DECL_TEMPLATE(netbsd, sys_recvmsg);
DECL_TEMPLATE(netbsd, sys_compat_orecvmsg);
DECL_TEMPLATE(netbsd, sys_sendmsg);
DECL_TEMPLATE(netbsd, sys_compat_osendmsg);
DECL_TEMPLATE(netbsd, sys_accept);
DECL_TEMPLATE(netbsd, sys_socket);
DECL_TEMPLATE(netbsd, sys_connect);
DECL_TEMPLATE(netbsd, sys_bind);
DECL_TEMPLATE(netbsd, sys_setsockopt);
DECL_TEMPLATE(netbsd, sys_getsockopt);
DECL_TEMPLATE(netbsd, sys_listen);
DECL_TEMPLATE(netbsd, sys_compat_oaccept);
DECL_TEMPLATE(netbsd, sys_compat_osend);
DECL_TEMPLATE(netbsd, sys_compat_orecv);
DECL_TEMPLATE(netbsd, sys_getpeername);
DECL_TEMPLATE(netbsd, sys_getsockname);
DECL_TEMPLATE(netbsd, sys_compat_ogetsockname);
DECL_TEMPLATE(netbsd, sys_ni_syscall);
DECL_TEMPLATE(netbsd, sys_vfork);
DECL_TEMPLATE(netbsd, sys_munmap);
DECL_TEMPLATE(netbsd, sys_mprotect);
DECL_TEMPLATE(netbsd, sys_madvise);
DECL_TEMPLATE(netbsd, sys_recvfrom);
DECL_TEMPLATE(netbsd, sys_socketpair);
DECL_TEMPLATE(netbsd, sys_compat_orecvfrom);
DECL_TEMPLATE(netbsd, sys_compat_owait);
DECL_TEMPLATE(netbsd, sys_compat_oswapon);
DECL_TEMPLATE(netbsd, sys_compat_ogethostname);
DECL_TEMPLATE(netbsd, sys_compat_osethostname);
DECL_TEMPLATE(netbsd, sys_compat_ogetdtablesize);
DECL_TEMPLATE(netbsd, sys_compat_otruncate);
DECL_TEMPLATE(netbsd, sys_compat_oftruncate);
DECL_TEMPLATE(netbsd, sys_mkfifo);
DECL_TEMPLATE(netbsd, sys_sendto);
DECL_TEMPLATE(netbsd, sys_shutdown);
DECL_TEMPLATE(netbsd, sys_adjtime);
DECL_TEMPLATE(netbsd, sys_compat_ogetpeername);
DECL_TEMPLATE(netbsd, sys_compat_ogethostid);
DECL_TEMPLATE(netbsd, sys_compat_osethostid);
DECL_TEMPLATE(netbsd, sys_compat_okillpg);
DECL_TEMPLATE(netbsd, sys_compat_oquota);
DECL_TEMPLATE(netbsd, sys_nfssvc);
DECL_TEMPLATE(netbsd, sys_compat_ogetdirentries);
DECL_TEMPLATE(netbsd, sys_compat_getdirentries);
DECL_TEMPLATE(netbsd, sys_getfh);
DECL_TEMPLATE(netbsd, sys_compat_ogetdomainname);
DECL_TEMPLATE(netbsd, sys_compat_osetdomainname);
DECL_TEMPLATE(netbsd, sys_sysarch);
DECL_TEMPLATE(netbsd, sys_pread);
DECL_TEMPLATE(netbsd, sys_pwrite);
DECL_TEMPLATE(netbsd, sys_ntp_gettime);
DECL_TEMPLATE(netbsd, sys_ntp_adjtime);
DECL_TEMPLATE(netbsd, sys_setegid);
DECL_TEMPLATE(netbsd, sys_seteuid);
DECL_TEMPLATE(netbsd, sys_lfs_bmapv);
DECL_TEMPLATE(netbsd, sys_lfs_markv);
DECL_TEMPLATE(netbsd, sys_lfs_segclean);
DECL_TEMPLATE(netbsd, sys_lfs_segwait);
DECL_TEMPLATE(netbsd, sys_pathconf);
DECL_TEMPLATE(netbsd, sys_fpathconf);
DECL_TEMPLATE(netbsd, sys_undelete);
DECL_TEMPLATE(netbsd, sys_futimes);
DECL_TEMPLATE(netbsd, sys_swapctl);
DECL_TEMPLATE(netbsd, sys_preadv);
DECL_TEMPLATE(netbsd, sys_pwritev);
DECL_TEMPLATE(netbsd, sys_fchroot);
DECL_TEMPLATE(netbsd, sys_fhopen);
DECL_TEMPLATE(netbsd, sys_fhstat);
DECL_TEMPLATE(netbsd, sys_fhstatfs);
DECL_TEMPLATE(netbsd, sys_issetugid);
DECL_TEMPLATE(netbsd, sys_kqueue);
DECL_TEMPLATE(netbsd, sys_kevent);
DECL_TEMPLATE(netbsd, sys_fsync_range);
DECL_TEMPLATE(netbsd, sys_uuidgen);
DECL_TEMPLATE(netbsd, sys_fstatvfs1);
DECL_TEMPLATE(netbsd, sys_pipe);
DECL_TEMPLATE(netbsd, sys_lseek);
DECL_TEMPLATE(netbsd, sys_ioctl);
DECL_TEMPLATE(netbsd, sys_sigaction_sigtramp);
DECL_TEMPLATE(netbsd, sys_sigprocmask);
#endif   // __PRIV_SYSWRAP_NETBSD_H

/*--------------------------------------------------------------------*/
/*--- end                                                          ---*/
/*--------------------------------------------------------------------*/
