/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.sqlj;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.postgresql.pljava.internal.Backend;
import org.postgresql.pljava.internal.Oid;
import org.postgresql.pljava.jdbc.SQLUtils;
import org.postgresql.pljava.sqlj.EntryStreamHandler;

public class Loader
extends ClassLoader {
    private static final Logger s_logger = Logger.getLogger(Loader.class.getName());
    private static final String PUBLIC_SCHEMA = "public";
    private static final Map s_schemaLoaders = new HashMap();
    private static final Map s_typeMap = new HashMap();
    private final Map m_entries;

    public static void clearSchemaLoaders() {
        s_schemaLoaders.clear();
        s_typeMap.clear();
        Backend.clearFunctionCache();
    }

    public static ClassLoader getCurrentLoader() throws SQLException {
        String schema;
        Statement stmt = SQLUtils.getDefaultConnection().createStatement();
        ResultSet rs = null;
        try {
            rs = stmt.executeQuery("SELECT current_schema()");
            if (!rs.next()) {
                throw new SQLException("Unable to determine current schema");
            }
            schema = rs.getString(1);
        }
        finally {
            SQLUtils.close(rs);
            SQLUtils.close(stmt);
        }
        return Loader.getSchemaLoader(schema);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassLoader getSchemaLoader(String schemaName) throws SQLException {
        ClassLoader loader = (ClassLoader)s_schemaLoaders.get(schemaName = schemaName == null || schemaName.length() == 0 ? PUBLIC_SCHEMA : schemaName.toLowerCase());
        if (loader != null) {
            return loader;
        }
        HashMap<String, int[]> classImages = new HashMap<String, int[]>();
        Connection conn = SQLUtils.getDefaultConnection();
        PreparedStatement outer = null;
        PreparedStatement inner = null;
        try {
            outer = conn.prepareStatement("SELECT r.jarId FROM sqlj.jar_repository r INNER JOIN sqlj.classpath_entry c ON r.jarId = c.jarId WHERE c.schemaName = ? ORDER BY c.ordinal DESC");
            inner = conn.prepareStatement("SELECT entryId, entryName FROM sqlj.jar_entry WHERE jarId = ?");
            outer.setString(1, schemaName);
            ResultSet rs = outer.executeQuery();
            try {
                while (rs.next()) {
                    inner.setInt(1, rs.getInt(1));
                    ResultSet rs2 = inner.executeQuery();
                    try {
                        while (rs2.next()) {
                            int entryId = rs2.getInt(1);
                            String entryName = rs2.getString(2);
                            int[] oldEntry = (int[])classImages.get(entryName);
                            if (oldEntry == null) {
                                classImages.put(entryName, new int[]{entryId});
                                continue;
                            }
                            int last = oldEntry.length;
                            int[] newEntry = new int[last + 1];
                            newEntry[0] = entryId;
                            System.arraycopy(oldEntry, 0, newEntry, 1, last);
                            classImages.put(entryName, newEntry);
                        }
                    }
                    finally {
                        SQLUtils.close(rs2);
                    }
                }
            }
            finally {
                SQLUtils.close(rs);
            }
        }
        catch (Throwable throwable) {
            SQLUtils.close(outer);
            SQLUtils.close(inner);
            throw throwable;
        }
        SQLUtils.close(outer);
        SQLUtils.close(inner);
        ClassLoader parent = ClassLoader.getSystemClassLoader();
        loader = classImages.size() == 0 ? (schemaName.equals(PUBLIC_SCHEMA) ? parent : Loader.getSchemaLoader(PUBLIC_SCHEMA)) : new Loader(classImages, parent);
        s_schemaLoaders.put(schemaName, loader);
        return loader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map getTypeMap(final String schema) throws SQLException {
        Map typesForSchema = (Map)s_typeMap.get(schema);
        if (typesForSchema != null) {
            return typesForSchema;
        }
        s_logger.fine("Creating typeMappings for schema " + schema);
        typesForSchema = new HashMap(){

            @Override
            public Object get(Object key) {
                s_logger.fine("Obtaining type mapping for OID " + key + " for schema " + schema);
                return super.get(key);
            }
        };
        ClassLoader loader = Loader.getSchemaLoader(schema);
        Statement stmt = SQLUtils.getDefaultConnection().createStatement();
        ResultSet rs = null;
        try {
            rs = stmt.executeQuery("SELECT javaName, sqlName FROM sqlj.typemap_entry");
            while (rs.next()) {
                try {
                    String javaClassName = rs.getString(1);
                    String sqlName = rs.getString(2);
                    Class<?> cls = loader.loadClass(javaClassName);
                    if (!SQLData.class.isAssignableFrom(cls)) {
                        throw new SQLException("Class " + javaClassName + " does not implement java.sql.SQLData");
                    }
                    Oid typeOid = Oid.forTypeName(sqlName);
                    typesForSchema.put(typeOid, cls);
                    s_logger.fine("Adding type mapping for OID " + typeOid + " -> class " + cls.getName() + " for schema " + schema);
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
            if (typesForSchema.isEmpty()) {
                typesForSchema = Collections.EMPTY_MAP;
            }
            s_typeMap.put(schema, typesForSchema);
            Map map = typesForSchema;
            return map;
        }
        finally {
            SQLUtils.close(rs);
            SQLUtils.close(stmt);
        }
    }

    private static URL entryURL(int entryId) {
        try {
            return new URL("dbf", "localhost", -1, "/" + entryId, EntryStreamHandler.getInstance());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    Loader(Map entries, ClassLoader parent) {
        super(parent);
        this.m_entries = entries;
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        String path = name.replace('.', '/').concat(".class");
        int[] entryId = (int[])this.m_entries.get(path);
        if (entryId != null) {
            ResultSet rs;
            PreparedStatement stmt;
            block5: {
                Class<?> clazz;
                stmt = null;
                rs = null;
                try {
                    stmt = SQLUtils.getDefaultConnection().prepareStatement("SELECT entryImage FROM sqlj.jar_entry WHERE entryId = ?");
                    stmt.setInt(1, entryId[0]);
                    rs = stmt.executeQuery();
                    if (!rs.next()) break block5;
                    byte[] img = rs.getBytes(1);
                    rs.close();
                    rs = null;
                    clazz = this.defineClass(name, img, 0, img.length);
                }
                catch (SQLException e) {
                    try {
                        Logger.getAnonymousLogger().log(Level.INFO, "Failed to load class", e);
                        throw new ClassNotFoundException(name + " due to: " + e.getMessage());
                    }
                    catch (Throwable throwable) {
                        SQLUtils.close(rs);
                        SQLUtils.close(stmt);
                        throw throwable;
                    }
                }
                SQLUtils.close(rs);
                SQLUtils.close(stmt);
                return clazz;
            }
            SQLUtils.close(rs);
            SQLUtils.close(stmt);
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    protected URL findResource(String name) {
        int[] entryIds = (int[])this.m_entries.get(name);
        if (entryIds == null) {
            return null;
        }
        return Loader.entryURL(entryIds[0]);
    }

    protected Enumeration findResources(String name) throws IOException {
        int[] entryIds = (int[])this.m_entries.get(name);
        if (entryIds == null) {
            entryIds = new int[]{};
        }
        return new EntryEnumeration(entryIds);
    }

    static class EntryEnumeration
    implements Enumeration {
        private final int[] m_entryIds;
        private int m_top = 0;

        EntryEnumeration(int[] entryIds) {
            this.m_entryIds = entryIds;
        }

        @Override
        public boolean hasMoreElements() {
            return this.m_top < this.m_entryIds.length;
        }

        public Object nextElement() throws NoSuchElementException {
            if (this.m_top >= this.m_entryIds.length) {
                throw new NoSuchElementException();
            }
            return Loader.entryURL(this.m_entryIds[this.m_top++]);
        }
    }
}

