/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.example;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.logging.Logger;
import org.postgresql.pljava.ResultSetProvider;

public class MetaDataInts
implements ResultSetProvider {
    String[] methodNames;
    Integer[] methodResults;

    public static ResultSetProvider getDatabaseMetaDataInts() throws SQLException {
        try {
            return new MetaDataInts();
        }
        catch (SQLException e) {
            throw new SQLException("Error reading DatabaseMetaData", e.getMessage());
        }
    }

    public MetaDataInts() throws SQLException {
        Logger log = Logger.getAnonymousLogger();
        Connection conn = DriverManager.getConnection("jdbc:default:connection");
        DatabaseMetaData md = conn.getMetaData();
        Method[] m = DatabaseMetaData.class.getMethods();
        class MethodComparator
        implements Comparator<Method> {
            MethodComparator() {
            }

            @Override
            public int compare(Method a, Method b) {
                return a.getName().compareTo(b.getName());
            }
        }
        Arrays.sort(m, new MethodComparator());
        Object[] args = new Object[]{};
        Integer result = null;
        ArrayList<String> mn = new ArrayList<String>();
        ArrayList<Integer> mr = new ArrayList<Integer>();
        for (int i = 0; i < m.length; ++i) {
            Class<?> returntype;
            Class<?>[] prototype = m[i].getParameterTypes();
            if (prototype.length > 0 || !(returntype = m[i].getReturnType()).equals(Integer.TYPE)) continue;
            try {
                result = (Integer)m[i].invoke((Object)md, args);
            }
            catch (InvocationTargetException e) {
                log.info("Method: " + m[i].getName() + " => " + e.getTargetException().getMessage());
                result = new Integer(-1);
            }
            catch (Exception e) {
                log.info("Method: " + m[i].getName() + " => " + e.getMessage());
                result = new Integer(-1);
            }
            mn.add(m[i].getName());
            mr.add(result);
        }
        this.methodNames = mn.toArray(new String[mn.size()]);
        this.methodResults = mr.toArray(new Integer[mr.size()]);
    }

    public boolean assignRowValues(ResultSet receiver, int currentRow) throws SQLException {
        if (currentRow < this.methodNames.length) {
            receiver.updateString(1, this.methodNames[currentRow]);
            receiver.updateInt(2, (int)this.methodResults[currentRow]);
            return true;
        }
        return false;
    }

    public void close() {
    }
}

