/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.example;

import java.util.logging.Level;
import java.util.logging.Logger;

public class Threads {
    private static final String s_lockOne = "lock number one";
    private static final String s_lockTwo = "lock number two";

    public static void forceDeadlock() {
        Locker x = new Locker("x", s_lockOne, s_lockTwo);
        Locker y = new Locker("y", s_lockTwo, s_lockOne);
        x.start();
        y.start();
        try {
            Logger.getAnonymousLogger().log(Level.INFO, "Main thread sleeps a while");
            Thread.sleep(1000L);
        }
        catch (Exception e) {
            Logger.getAnonymousLogger().log(Level.INFO, "Main thread interrupted while sleeping: ", e);
        }
    }

    static class Locker
    extends Thread {
        private final String m_name;
        private final String m_first;
        private final String m_second;

        Locker(String name, String first, String second) {
            this.m_name = name;
            this.m_first = first;
            this.m_second = second;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Logger log = Logger.getAnonymousLogger();
            try {
                log.info("Thread " + this.m_name + " wants " + this.m_first);
                String string = this.m_first;
                synchronized (string) {
                    log.info("Thread " + this.m_name + " got " + this.m_first);
                    Thread.sleep(100L);
                    log.info("Thread " + this.m_name + " wants " + this.m_second);
                    String string2 = this.m_second;
                    synchronized (string2) {
                        log.info("Thread " + this.m_name + " got " + this.m_second);
                    }
                }
            }
            catch (Exception e) {
                log.log(Level.INFO, "Thread " + this.m_name + " got exception: ", e);
            }
        }
    }
}

