/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar;

import com.github.maven_nar.AbstractGnuMojo;
import com.github.maven_nar.NarUtil;
import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="nar-gnu-make", requiresProject=true, defaultPhase=LifecyclePhase.COMPILE)
public class NarGnuMakeMojo
extends AbstractGnuMojo {
    @Parameter(defaultValue="")
    private String gnuMakeArgs;
    @Parameter(defaultValue="")
    private String gnuMakeEnv;
    @Parameter
    private boolean gnuMakeInstallSkip;

    @Override
    public final void narExecute() throws MojoExecutionException, MojoFailureException {
        if (!this.useGnu()) {
            return;
        }
        File srcDir = this.getGnuAOLSourceDirectory();
        if (srcDir.exists()) {
            String[] args = null;
            String[] env = null;
            if (this.gnuMakeArgs != null) {
                args = this.gnuMakeArgs.split(" ");
            }
            if (this.gnuMakeEnv != null) {
                env = this.gnuMakeEnv.split(",");
            }
            this.getLog().info((CharSequence)"Running GNU make");
            int result = NarUtil.runCommand("make", args, srcDir, env, this.getLog());
            if (result != 0) {
                throw new MojoExecutionException("'make' errorcode: " + result);
            }
            if (!this.gnuMakeInstallSkip) {
                this.getLog().info((CharSequence)"Running make install");
                if (args != null) {
                    this.gnuMakeArgs = this.gnuMakeArgs + " install";
                    args = this.gnuMakeArgs.split(" ");
                } else {
                    args = new String[]{"install"};
                }
                result = NarUtil.runCommand("make", args, srcDir, null, this.getLog());
                if (result != 0) {
                    throw new MojoExecutionException("'make install' errorcode: " + result);
                }
            }
        }
    }
}

