/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.tasks;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.tools.ant.BuildException;
import org.postgresql.pljava.tasks.PLJavaTask;

public class JarLoaderTask
extends PLJavaTask {
    private boolean m_deploy = true;
    private boolean m_reload = false;
    private File m_file;
    private String m_name;
    private String m_schema;

    public void execute() throws BuildException {
        byte[] image;
        if (this.m_file == null) {
            throw new BuildException("file must be set", this.getLocation());
        }
        if (this.m_name == null) {
            throw new BuildException("name must be set", this.getLocation());
        }
        FileInputStream in = null;
        try {
            int count;
            in = new FileInputStream(this.m_file);
            ByteArrayOutputStream bld = new ByteArrayOutputStream();
            byte[] buf = new byte[4096];
            while ((count = ((InputStream)in).read(buf)) > 0) {
                bld.write(buf, 0, count);
            }
            image = bld.toByteArray();
        }
        catch (IOException e) {
            throw new BuildException("Unable to read file " + this.m_file, (Throwable)e, this.getLocation());
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException iOException) {}
            }
        }
        ResultSet rs = null;
        PreparedStatement stmt = null;
        Connection conn = this.getConnection();
        try {
            stmt = conn.prepareStatement(this.m_reload ? "SELECT sqlj.replace_jar(?, ?, ?)" : "SELECT sqlj.install_jar(?, ?, ?)");
            stmt.setBytes(1, image);
            stmt.setString(2, this.m_name);
            stmt.setBoolean(3, this.m_deploy);
            stmt.executeQuery().close();
            if (this.m_schema != null) {
                boolean found = false;
                stmt.close();
                stmt = null;
                stmt = conn.prepareStatement("SELECT sqlj.get_classpath(?)");
                stmt.setString(1, this.m_schema);
                rs = stmt.executeQuery();
                String path = null;
                if (!rs.next() && (path = rs.getString(1)) != null) {
                    String[] jars = path.split(":");
                    int idx = jars.length;
                    while (--idx >= 0) {
                        if (!jars[idx].equals(this.m_name)) continue;
                        found = true;
                        break;
                    }
                }
                rs.close();
                rs = null;
                if (!found) {
                    path = path != null && path.length() > 0 ? path + ":" + this.m_name : this.m_name;
                    stmt.close();
                    stmt = null;
                    stmt = conn.prepareStatement("SELECT sqlj.set_classpath(?, ?)");
                    stmt.setString(1, this.m_schema);
                    stmt.setString(2, path);
                    stmt.executeQuery().close();
                }
            }
            conn.commit();
        }
        catch (SQLException e) {
            try {
                conn.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw new BuildException("Unable to do install_jar: " + e.getMessage(), (Throwable)e, this.getLocation());
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
            }
            try {
                conn.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    public final boolean isDeploy() {
        return this.m_deploy;
    }

    public final void setDeploy(boolean deploy) {
        this.m_deploy = deploy;
    }

    public final File getFile() {
        return this.m_file;
    }

    public final void setFile(File file) {
        this.m_file = file;
    }

    public final String getName() {
        return this.m_name;
    }

    public final void setName(String name) {
        this.m_name = name;
    }

    public final boolean isReload() {
        return this.m_reload;
    }

    public final void setReload(boolean reload) {
        this.m_reload = reload;
    }

    public final String getSchema() {
        return this.m_schema;
    }

    public final void setSchema(String schema) {
        this.m_schema = schema;
    }
}

