/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.booter;

import java.io.File;
import java.io.FileInputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.maven.surefire.booter.BaseProviderFactory;
import org.apache.maven.surefire.booter.BooterDeserializer;
import org.apache.maven.surefire.booter.ClasspathConfiguration;
import org.apache.maven.surefire.booter.Command;
import org.apache.maven.surefire.booter.ForkingRunListener;
import org.apache.maven.surefire.booter.LazyTestsToRun;
import org.apache.maven.surefire.booter.MasterProcessListener;
import org.apache.maven.surefire.booter.MasterProcessReader;
import org.apache.maven.surefire.booter.ProviderConfiguration;
import org.apache.maven.surefire.booter.Shutdown;
import org.apache.maven.surefire.booter.StartupConfiguration;
import org.apache.maven.surefire.booter.SurefireExecutionException;
import org.apache.maven.surefire.booter.SurefireReflector;
import org.apache.maven.surefire.booter.SystemPropertyManager;
import org.apache.maven.surefire.booter.TypeEncodedValue;
import org.apache.maven.surefire.providerapi.ProviderParameters;
import org.apache.maven.surefire.providerapi.SurefireProvider;
import org.apache.maven.surefire.report.LegacyPojoStackTraceWriter;
import org.apache.maven.surefire.report.ReporterFactory;
import org.apache.maven.surefire.report.StackTraceWriter;
import org.apache.maven.surefire.suite.RunResult;
import org.apache.maven.surefire.testset.TestSetFailedException;
import org.apache.maven.surefire.util.ReflectionUtils;
import org.apache.maven.surefire.util.internal.DaemonThreadFactory;
import org.apache.maven.surefire.util.internal.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ForkedBooter {
    private static final long SYSTEM_EXIT_TIMEOUT_IN_SECONDS = 30L;
    private static final long PING_TIMEOUT_IN_SECONDS = 20L;
    private static final ScheduledExecutorService JVM_TERMINATOR = ForkedBooter.createJvmTerminator();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String ... args) {
        MasterProcessReader reader = ForkedBooter.startupMasterProcessReader();
        ScheduledFuture<?> pingScheduler = ForkedBooter.listenToShutdownCommands(reader);
        PrintStream originalOut = System.out;
        try {
            File surefirePropertiesFile;
            if (args.length > 1) {
                SystemPropertyManager.setSystemProperties(new File(args[1]));
            }
            FileInputStream stream = (surefirePropertiesFile = new File(args[0])).exists() ? new FileInputStream(surefirePropertiesFile) : null;
            BooterDeserializer booterDeserializer = new BooterDeserializer(stream);
            ProviderConfiguration providerConfiguration = booterDeserializer.deserialize();
            StartupConfiguration startupConfiguration = booterDeserializer.getProviderConfiguration();
            TypeEncodedValue forkedTestSet = providerConfiguration.getTestForFork();
            boolean readTestsFromInputStream = providerConfiguration.isReadTestsFromInStream();
            ClasspathConfiguration classpathConfiguration = startupConfiguration.getClasspathConfiguration();
            if (startupConfiguration.isManifestOnlyJarRequestedAndUsable()) {
                classpathConfiguration.trickClassPathWhenManifestOnlyClasspath();
            }
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            classLoader.setDefaultAssertionStatus(classpathConfiguration.isEnableAssertions());
            startupConfiguration.writeSurefireTestClasspathProperty();
            Object testSet = forkedTestSet != null ? forkedTestSet.getDecodedValue(classLoader) : (readTestsFromInputStream ? new LazyTestsToRun(originalOut) : null);
            try {
                ForkedBooter.runSuitesInProcess(testSet, startupConfiguration, providerConfiguration, originalOut);
            }
            catch (InvocationTargetException t) {
                LegacyPojoStackTraceWriter stackTraceWriter = new LegacyPojoStackTraceWriter("test subystem", "no method", t.getTargetException());
                StringBuilder stringBuilder = new StringBuilder();
                ForkingRunListener.encode((StringBuilder)stringBuilder, (StackTraceWriter)stackTraceWriter, (boolean)false);
                ForkedBooter.encodeAndWriteToOutput("X,0," + stringBuilder + "\n", originalOut);
            }
            catch (Throwable t) {
                LegacyPojoStackTraceWriter stackTraceWriter = new LegacyPojoStackTraceWriter("test subystem", "no method", t);
                StringBuilder stringBuilder = new StringBuilder();
                ForkingRunListener.encode((StringBuilder)stringBuilder, (StackTraceWriter)stackTraceWriter, (boolean)false);
                ForkedBooter.encodeAndWriteToOutput("X,0," + stringBuilder + "\n", originalOut);
            }
            ForkedBooter.encodeAndWriteToOutput("Z,0,BYE!\n", originalOut);
            originalOut.flush();
            ForkedBooter.exit(0, Shutdown.EXIT, reader);
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
            ForkedBooter.exit(1, Shutdown.EXIT, reader);
        }
        finally {
            pingScheduler.cancel(true);
        }
    }

    private static MasterProcessReader startupMasterProcessReader() {
        return MasterProcessReader.getReader();
    }

    private static ScheduledFuture<?> listenToShutdownCommands(MasterProcessReader reader) {
        reader.addShutdownListener(ForkedBooter.createExitHandler(reader));
        AtomicBoolean pingDone = new AtomicBoolean(true);
        reader.addNoopListener(ForkedBooter.createPingHandler(pingDone));
        return JVM_TERMINATOR.scheduleAtFixedRate(ForkedBooter.createPingJob(pingDone, reader), 0L, 20L, TimeUnit.SECONDS);
    }

    private static MasterProcessListener createPingHandler(final AtomicBoolean pingDone) {
        return new MasterProcessListener(){

            public void update(Command command) {
                pingDone.set(true);
            }
        };
    }

    private static MasterProcessListener createExitHandler(final MasterProcessReader reader) {
        return new MasterProcessListener(){

            public void update(Command command) {
                ForkedBooter.exit(1, command.toShutdownData(), reader);
            }
        };
    }

    private static Runnable createPingJob(final AtomicBoolean pingDone, final MasterProcessReader reader) {
        return new Runnable(){

            public void run() {
                boolean hasPing = pingDone.getAndSet(false);
                if (!hasPing) {
                    ForkedBooter.exit(1, Shutdown.KILL, reader);
                }
            }
        };
    }

    private static void encodeAndWriteToOutput(String string, PrintStream out) {
        byte[] encodeBytes = StringUtils.encodeStringForForkCommunication((String)string);
        out.write(encodeBytes, 0, encodeBytes.length);
    }

    private static void exit(int returnCode, Shutdown shutdownType, MasterProcessReader reader) {
        switch (shutdownType) {
            case KILL: {
                reader.stop();
                Runtime.getRuntime().halt(returnCode);
            }
            case EXIT: {
                reader.stop();
                ForkedBooter.launchLastDitchDaemonShutdownThread(returnCode);
                System.exit(returnCode);
            }
        }
    }

    private static RunResult runSuitesInProcess(Object testSet, StartupConfiguration startupConfiguration, ProviderConfiguration providerConfiguration, PrintStream originalSystemOut) throws SurefireExecutionException, TestSetFailedException, InvocationTargetException {
        ReporterFactory factory = ForkedBooter.createForkingReporterFactory(providerConfiguration, originalSystemOut);
        return ForkedBooter.invokeProviderInSameClassLoader(testSet, factory, providerConfiguration, true, startupConfiguration, false);
    }

    private static ReporterFactory createForkingReporterFactory(ProviderConfiguration providerConfiguration, PrintStream originalSystemOut) {
        boolean trimStackTrace = providerConfiguration.getReporterConfiguration().isTrimStackTrace();
        return SurefireReflector.createForkingReporterFactoryInCurrentClassLoader((boolean)trimStackTrace, (PrintStream)originalSystemOut);
    }

    private static ScheduledExecutorService createJvmTerminator() {
        ThreadFactory threadFactory = DaemonThreadFactory.newDaemonThreadFactory((String)"last-ditch-daemon-shutdown-thread-30sec");
        return Executors.newScheduledThreadPool(1, threadFactory);
    }

    private static void launchLastDitchDaemonShutdownThread(final int returnCode) {
        JVM_TERMINATOR.schedule(new Runnable(){

            public void run() {
                Runtime.getRuntime().halt(returnCode);
            }
        }, 30L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static RunResult invokeProviderInSameClassLoader(Object testSet, Object factory, ProviderConfiguration providerConfiguration, boolean insideFork, StartupConfiguration startupConfig, boolean restoreStreams) throws TestSetFailedException, InvocationTargetException {
        PrintStream orgSystemOut = System.out;
        PrintStream orgSystemErr = System.err;
        try {
            RunResult runResult = ForkedBooter.createProviderInCurrentClassloader(startupConfig, insideFork, providerConfiguration, factory).invoke(testSet);
            return runResult;
        }
        finally {
            if (restoreStreams && System.getSecurityManager() == null) {
                System.setOut(orgSystemOut);
                System.setErr(orgSystemErr);
            }
        }
    }

    private static SurefireProvider createProviderInCurrentClassloader(StartupConfiguration startupConfiguration1, boolean isInsideFork, ProviderConfiguration providerConfiguration, Object reporterManagerFactory1) {
        BaseProviderFactory bpf = new BaseProviderFactory((ReporterFactory)reporterManagerFactory1, isInsideFork);
        bpf.setTestRequest(providerConfiguration.getTestSuiteDefinition());
        bpf.setReporterConfiguration(providerConfiguration.getReporterConfiguration());
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        bpf.setClassLoaders(classLoader);
        bpf.setTestArtifactInfo(providerConfiguration.getTestArtifact());
        bpf.setProviderProperties(providerConfiguration.getProviderProperties());
        bpf.setRunOrderParameters(providerConfiguration.getRunOrderParameters());
        bpf.setDirectoryScannerParameters(providerConfiguration.getDirScannerParams());
        bpf.setMainCliOptions(providerConfiguration.getMainCliOptions());
        bpf.setSkipAfterFailureCount(providerConfiguration.getSkipAfterFailureCount());
        bpf.setShutdown(providerConfiguration.getShutdown());
        String providerClass = startupConfiguration1.getActualClassName();
        return (SurefireProvider)ReflectionUtils.instantiateOneArg((ClassLoader)classLoader, (String)providerClass, ProviderParameters.class, (Object)bpf);
    }
}

