/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.booter;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import org.apache.maven.surefire.booter.Command;
import org.apache.maven.surefire.booter.MasterProcessCommand;
import org.apache.maven.surefire.booter.MasterProcessListener;
import org.apache.maven.surefire.booter.Shutdown;
import org.apache.maven.surefire.booter.TwoPropertiesWrapper;
import org.apache.maven.surefire.testset.TestSetFailedException;
import org.apache.maven.surefire.util.internal.DaemonThreadFactory;
import org.apache.maven.surefire.util.internal.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MasterProcessReader {
    private static final MasterProcessReader READER = new MasterProcessReader();
    private final Queue<TwoPropertiesWrapper<MasterProcessCommand, MasterProcessListener>> listeners = new ConcurrentLinkedQueue<TwoPropertiesWrapper<MasterProcessCommand, MasterProcessListener>>();
    private final Thread commandThread = DaemonThreadFactory.newDaemonThread(new CommandRunnable(), "surefire-forkedjvm-command-thread");
    private final AtomicReference<Thread.State> state = new AtomicReference<Thread.State>(Thread.State.NEW);
    private final Queue<Thread> waiters = new ConcurrentLinkedQueue<Thread>();
    private final CountDownLatch startMonitor = new CountDownLatch(1);
    private final Node headTestClassQueue;
    private volatile Node tailTestClassQueue = this.headTestClassQueue = new Node();
    private volatile Shutdown shutdown;

    public static MasterProcessReader getReader() {
        MasterProcessReader reader = READER;
        if (reader.state.compareAndSet(Thread.State.NEW, Thread.State.RUNNABLE)) {
            reader.commandThread.start();
        }
        return reader;
    }

    public MasterProcessReader setShutdown(Shutdown shutdown) {
        this.shutdown = shutdown;
        return this;
    }

    public boolean awaitStarted() throws TestSetFailedException {
        if (this.state.get() == Thread.State.RUNNABLE) {
            try {
                this.startMonitor.await();
                return true;
            }
            catch (InterruptedException e) {
                throw new TestSetFailedException(e.getLocalizedMessage());
            }
        }
        return false;
    }

    public void addListener(MasterProcessListener listener) {
        this.listeners.add(new TwoPropertiesWrapper<Object, MasterProcessListener>(null, listener));
    }

    public void addTestListener(MasterProcessListener listener) {
        this.addListener(MasterProcessCommand.RUN_CLASS, listener);
    }

    public void addTestsFinishedListener(MasterProcessListener listener) {
        this.addListener(MasterProcessCommand.TEST_SET_FINISHED, listener);
    }

    public void addSkipNextListener(MasterProcessListener listener) {
        this.addListener(MasterProcessCommand.SKIP_SINCE_NEXT_TEST, listener);
    }

    public void addShutdownListener(MasterProcessListener listener) {
        this.addListener(MasterProcessCommand.SHUTDOWN, listener);
    }

    public void addNoopListener(MasterProcessListener listener) {
        this.addListener(MasterProcessCommand.NOOP, listener);
    }

    private void addListener(MasterProcessCommand cmd, MasterProcessListener listener) {
        this.listeners.add(new TwoPropertiesWrapper<MasterProcessCommand, MasterProcessListener>(cmd, listener));
    }

    public void removeListener(MasterProcessListener listener) {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            TwoPropertiesWrapper listenerWrapper = (TwoPropertiesWrapper)it.next();
            if (listener != listenerWrapper.getP2()) continue;
            it.remove();
        }
    }

    Iterable<String> getIterableClasses(PrintStream originalOutStream) {
        return new ClassesIterable(this.headTestClassQueue, originalOutStream);
    }

    public void stop() {
        if (this.state.compareAndSet(Thread.State.NEW, Thread.State.TERMINATED) || this.state.compareAndSet(Thread.State.RUNNABLE, Thread.State.TERMINATED)) {
            this.makeQueueFull();
            this.listeners.clear();
            this.commandThread.interrupt();
        }
    }

    private boolean isStopped() {
        return this.state.get() == Thread.State.TERMINATED;
    }

    private static boolean isLastNode(Node current) {
        return current.successor.get() == current;
    }

    private boolean isQueueFull() {
        return MasterProcessReader.isLastNode(this.tailTestClassQueue);
    }

    private boolean addTestClassToQueue(String item) {
        if (this.tailTestClassQueue.item == null) {
            this.tailTestClassQueue.item = item;
            Node newNode = new Node();
            this.tailTestClassQueue.successor.set(newNode);
            this.tailTestClassQueue = newNode;
            return true;
        }
        return false;
    }

    public void makeQueueFull() {
        Node tail = this.tailTestClassQueue;
        while (!tail.successor.compareAndSet(null, tail) && tail.successor.get() != tail) {
            tail = tail.successor.get();
        }
    }

    private void insertToQueue(Command cmd) {
        MasterProcessCommand expectedCommandType = cmd.getCommandType();
        switch (expectedCommandType) {
            case RUN_CLASS: {
                this.addTestClassToQueue(cmd.getData());
                break;
            }
            case TEST_SET_FINISHED: {
                this.makeQueueFull();
                break;
            }
        }
    }

    private void insertToListeners(Command cmd) {
        MasterProcessCommand expectedCommandType = cmd.getCommandType();
        for (TwoPropertiesWrapper twoPropertiesWrapper : this.listeners) {
            MasterProcessCommand commandType = (MasterProcessCommand)((Object)twoPropertiesWrapper.getP1());
            MasterProcessListener listener = (MasterProcessListener)twoPropertiesWrapper.getP2();
            if (commandType != null && commandType != expectedCommandType) continue;
            listener.update(cmd);
        }
    }

    private void insert(Command cmd) {
        this.insertToQueue(cmd);
        this.insertToListeners(cmd);
    }

    private Command read(DataInputStream stdIn) throws IOException {
        Command command = MasterProcessCommand.decode(stdIn);
        if (command != null) {
            this.insertToQueue(command);
        }
        return command;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void await() {
        Thread currentThread = Thread.currentThread();
        try {
            this.waiters.add(currentThread);
            LockSupport.park();
        }
        finally {
            this.waiters.remove(currentThread);
        }
    }

    private void wakeupWaiters() {
        for (Thread waiter : this.waiters) {
            LockSupport.unpark(waiter);
        }
    }

    private final class CommandRunnable
    implements Runnable {
        private CommandRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            MasterProcessReader.this.startMonitor.countDown();
            DataInputStream stdIn = new DataInputStream(System.in);
            boolean isTestSetFinished = false;
            try {
                while (MasterProcessReader.this.state.get() == Thread.State.RUNNABLE) {
                    Command command = MasterProcessReader.this.read(stdIn);
                    if (command == null) {
                        System.err.println("[SUREFIRE] std/in stream corrupted: first sequence not recognized");
                        break;
                    }
                    switch (command.getCommandType()) {
                        case TEST_SET_FINISHED: {
                            isTestSetFinished = true;
                            MasterProcessReader.this.wakeupWaiters();
                            break;
                        }
                        case RUN_CLASS: {
                            MasterProcessReader.this.wakeupWaiters();
                            break;
                        }
                        case SHUTDOWN: {
                            MasterProcessReader.this.insertToQueue(Command.TEST_SET_FINISHED);
                            MasterProcessReader.this.wakeupWaiters();
                            break;
                        }
                    }
                    MasterProcessReader.this.insertToListeners(command);
                }
            }
            catch (EOFException e) {
                MasterProcessReader.this.state.set(Thread.State.TERMINATED);
                if (!isTestSetFinished) {
                    this.exitByConfiguration();
                }
            }
            catch (IOException e) {
                MasterProcessReader.this.state.set(Thread.State.TERMINATED);
                if (!(e.getCause() instanceof InterruptedException)) {
                    System.err.println("[SUREFIRE] std/in stream corrupted");
                    e.printStackTrace();
                }
            }
            finally {
                if (!isTestSetFinished) {
                    MasterProcessReader.this.insert(Command.TEST_SET_FINISHED);
                }
                MasterProcessReader.this.wakeupWaiters();
            }
        }

        private void exitByConfiguration() {
            Shutdown shutdown = MasterProcessReader.this.shutdown;
            if (shutdown != null) {
                MasterProcessReader.this.insert(Command.TEST_SET_FINISHED);
                MasterProcessReader.this.wakeupWaiters();
                MasterProcessReader.this.insertToListeners(Command.toShutdown(shutdown));
                switch (shutdown) {
                    case EXIT: {
                        System.exit(1);
                    }
                    case KILL: {
                        Runtime.getRuntime().halt(1);
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ClassesIterator
    implements Iterator<String> {
        private final PrintStream originalOutStream;
        private Node current;
        private String clazz;

        private ClassesIterator(Node current, PrintStream originalOutStream) {
            this.current = current;
            this.originalOutStream = originalOutStream;
        }

        @Override
        public boolean hasNext() {
            this.popUnread();
            return StringUtils.isNotBlank(this.clazz);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String next() {
            this.popUnread();
            try {
                if (StringUtils.isBlank(this.clazz)) {
                    throw new NoSuchElementException();
                }
                String string = this.clazz;
                return string;
            }
            finally {
                this.clazz = null;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void popUnread() {
            if (MasterProcessReader.this.isStopped()) {
                this.clazz = null;
                return;
            }
            if (StringUtils.isBlank(this.clazz)) {
                do {
                    this.requestNextTest();
                    if (MasterProcessReader.isLastNode(this.current)) {
                        this.clazz = null;
                        continue;
                    }
                    if (this.current.item == null) {
                        do {
                            MasterProcessReader.this.await();
                            if (!MasterProcessReader.this.isStopped()) continue;
                            this.clazz = null;
                            return;
                        } while (this.current.item == null && !MasterProcessReader.isLastNode(this.current));
                        this.clazz = this.current.item;
                        this.current = this.current.successor.get();
                        continue;
                    }
                    this.clazz = this.current.item;
                    this.current = this.current.successor.get();
                } while (this.tryNullWhiteClass());
            }
            if (MasterProcessReader.this.isStopped()) {
                this.clazz = null;
            }
        }

        private boolean tryNullWhiteClass() {
            if (this.clazz != null && StringUtils.isBlank(this.clazz)) {
                this.clazz = null;
                return true;
            }
            return false;
        }

        private void requestNextTest() {
            byte[] encoded = StringUtils.encodeStringForForkCommunication("N,0,want more!\n");
            this.originalOutStream.write(encoded, 0, encoded.length);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ClassesIterable
    implements Iterable<String> {
        private final Node head;
        private final PrintStream originalOutStream;

        ClassesIterable(Node head, PrintStream originalOutStream) {
            this.head = head;
            this.originalOutStream = originalOutStream;
        }

        @Override
        public Iterator<String> iterator() {
            return new ClassesIterator(this.head, this.originalOutStream);
        }
    }

    private static class Node {
        final AtomicReference<Node> successor = new AtomicReference();
        volatile String item;

        private Node() {
        }
    }
}

