/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.core;

import org.xerial.core.ErrorCode;
import org.xerial.core.ExceptionHelper;
import org.xerial.core.XerialErrorCode;

public class XerialException
extends Exception {
    private static final long serialVersionUID = 1L;
    protected final ErrorCode errorCode;

    public XerialException(XerialException xerialException) {
        super(xerialException.getErrorMessage());
        this.errorCode = xerialException.errorCode;
    }

    public static XerialException convert(Exception exception) {
        if (XerialException.class.isInstance(exception)) {
            XerialException xerialException = (XerialException)XerialException.class.cast(exception);
            return xerialException;
        }
        return new XerialException((ErrorCode)XerialErrorCode.INHERITED, (Throwable)exception);
    }

    public XerialException(ErrorCode errorCode) {
        this.errorCode = errorCode;
    }

    public XerialException(ErrorCode errorCode, String string, Throwable throwable) {
        super(string, throwable);
        this.errorCode = errorCode;
    }

    public XerialException(ErrorCode errorCode, String string) {
        super(string);
        this.errorCode = errorCode;
    }

    public XerialException(ErrorCode errorCode, Throwable throwable) {
        super(throwable);
        this.errorCode = errorCode;
    }

    public <T> T getErrorCode() {
        return (T)this.errorCode;
    }

    @Override
    public String getMessage() {
        return ExceptionHelper.getMessage(this.errorCode, super.getMessage());
    }

    private String getErrorMessage() {
        return super.getMessage();
    }
}

