/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.xerial.util.StringUtil;

public class IndexedSet<T>
implements Set<T> {
    public static final int INVALID_ID = -1;
    private int elementCount = 0;
    private HashMap<T, Integer> elementToID = new HashMap();
    private ArrayList<T> elementArray = new ArrayList();

    public Collection<Integer> getIDSet() {
        return this.elementToID.values();
    }

    public boolean containsID(int n) {
        return n < this.elementArray.size() && this.getByID(n) != null;
    }

    public int getID(T t) {
        Integer n = this.elementToID.get(t);
        return n == null ? -1 : n;
    }

    public int getIDwithAddition(T t) {
        if (this.contains(t)) {
            return this.getID(t);
        }
        return this.addNewElement(t);
    }

    public T getByID(int n) {
        return this.elementArray.get(n);
    }

    public T set(int n, T t) {
        T t2 = this.elementArray.set(n, t);
        this.elementToID.put(t, n);
        return t2;
    }

    private int addNewElement(T t) {
        assert (!this.elementToID.containsKey(t));
        int n = this.elementCount++;
        this.elementToID.put(t, n);
        this.elementArray.add(t);
        return n;
    }

    @Override
    public boolean add(T t) {
        if (this.elementToID.containsKey(t)) {
            return false;
        }
        this.addNewElement(t);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        boolean bl = false;
        for (T t : collection) {
            bl |= this.add(t);
        }
        return bl;
    }

    @Override
    public void clear() {
        this.elementToID.clear();
        this.elementArray.clear();
        this.elementCount = 0;
    }

    @Override
    public boolean contains(Object object) {
        return this.elementToID.containsKey(object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        for (Object obj : collection) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.elementToID.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            int next = 0;

            @Override
            public boolean hasNext() {
                return this.next < IndexedSet.this.size();
            }

            @Override
            public T next() {
                return IndexedSet.this.getByID(this.next++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }
        };
    }

    @Override
    public boolean remove(Object object) {
        int n = this.getID(object);
        if (n == -1) {
            return false;
        }
        this.elementToID.remove(object);
        this.elementArray.set(n, null);
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean bl = false;
        for (Object obj : collection) {
            bl |= this.remove(obj);
        }
        return bl;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException("retainAll");
    }

    @Override
    public int size() {
        return this.elementToID.size();
    }

    @Override
    public Object[] toArray() {
        return this.elementToID.keySet().toArray();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return this.elementToID.keySet().toArray(TArray);
    }

    public String toString() {
        ArrayList<String> arrayList = new ArrayList<String>();
        TreeSet<Integer> treeSet = new TreeSet<Integer>(this.getIDSet());
        for (int n : treeSet) {
            arrayList.add(String.format("%d:%s", n, this.getByID(n)));
        }
        return String.format("{%s}", StringUtil.join(arrayList, ", "));
    }
}

