/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.util;

import java.io.File;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import org.xerial.core.ErrorCode;
import org.xerial.core.XerialErrorCode;
import org.xerial.core.XerialException;
import org.xerial.util.TypeInfo;

public class TypeConverter {
    public static <T> T convertType(Class<T> clazz, Object object) throws XerialException {
        if (clazz.isAssignableFrom(object.getClass()) || clazz == Object.class) {
            return (T)object;
        }
        return (T)TypeConverter.convertToBasicType(clazz, object);
    }

    public static <T extends Enum<T>> T convertToEnum(Class<T> clazz, Object object) {
        assert (clazz.isEnum());
        String string = object.toString();
        try {
            return Enum.valueOf(clazz, string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Enum.valueOf(clazz, string.toString().toUpperCase());
        }
    }

    public static Object convertToBasicType(Class<?> clazz, Object object) throws XerialException {
        assert (TypeInfo.isBasicType(clazz));
        if (clazz.isEnum()) {
            return TypeConverter.convertToEnum(clazz, object);
        }
        try {
            String string = object.toString();
            if (clazz == String.class) {
                return string;
            }
            if (clazz == Integer.TYPE || clazz == Integer.class) {
                return new Integer(string);
            }
            if (clazz == Long.TYPE || clazz == Long.class) {
                return new Long(string);
            }
            if (clazz == Double.TYPE || clazz == Double.class) {
                return new Double(string);
            }
            if (clazz == Float.TYPE || clazz == Float.class) {
                return new Float(string);
            }
            if (clazz == Short.TYPE || clazz == Short.class) {
                return new Short(string);
            }
            if (clazz == Byte.TYPE || clazz == Byte.class) {
                return new Byte(string);
            }
            if (clazz == Boolean.TYPE || clazz == Boolean.class) {
                return new Boolean(string);
            }
            if ((clazz == Character.TYPE || clazz == Character.class) && string.length() == 1) {
                return new Character(string.charAt(0));
            }
            if (clazz == Date.class) {
                return DateFormat.getDateTimeInstance().parse(string);
            }
            if (clazz == File.class) {
                return new File(string);
            }
            throw new XerialException((ErrorCode)XerialErrorCode.InvalidBeanClass, String.format("%s is not a basic type", clazz.getSimpleName()));
        }
        catch (NumberFormatException numberFormatException) {
            throw new XerialException((ErrorCode)XerialErrorCode.InvalidFormat, String.format("%s %s", clazz.getName(), numberFormatException.getMessage()));
        }
        catch (ParseException parseException) {
            throw new XerialException((ErrorCode)XerialErrorCode.InvalidDateFormat, (Throwable)parseException);
        }
    }
}

