/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.util.bean;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.xerial.core.XerialErrorCode;
import org.xerial.core.XerialException;
import org.xerial.util.TypeInfo;
import org.xerial.util.tree.TreeNode;
import org.xerial.util.tree.TreeVisitor;
import org.xerial.util.tree.TreeWalker;

public class MapWalker
implements TreeWalker {
    private final Map<?, ?> map;
    private Object currentKey;

    public MapWalker(Map<?, ?> map) {
        if (map == null) {
            throw new NullPointerException("map cannot be null");
        }
        this.map = map;
    }

    @Override
    public TreeNode getSubTree() throws XerialException {
        if (this.currentKey != null) {
            Object obj = this.map.get(this.currentKey);
            return new SingleTreeNode(this.currentKey.toString(), obj != null ? obj.toString() : null);
        }
        throw new XerialException(XerialErrorCode.NoMoreSubtree);
    }

    @Override
    public void skipDescendants() throws XerialException {
    }

    @Override
    public void walk(TreeVisitor treeVisitor) throws XerialException {
        treeVisitor.init(this);
        this.walk(null, this.map, treeVisitor);
        treeVisitor.finish(this);
    }

    private void walk(String string, Object object, TreeVisitor treeVisitor) throws XerialException {
        if (object == null) {
            treeVisitor.visitNode(string, null, this);
            treeVisitor.leaveNode(string, this);
            return;
        }
        assert (object != null);
        Class<?> clazz = object.getClass();
        if (TypeInfo.isArray(clazz)) {
            for (Object object2 : (Object[])object) {
                this.walk(string, object2, treeVisitor);
            }
        } else if (TypeInfo.isCollection(clazz)) {
            for (Object e : (Collection)object) {
                this.walk(string, e, treeVisitor);
            }
        } else if (TypeInfo.isMap(clazz)) {
            treeVisitor.visitNode(string, null, this);
            Map map = (Map)object;
            for (Object k : map.keySet()) {
                this.currentKey = k;
                String string2 = k.toString();
                Object obj = this.map.get(k);
                this.walk(string2, obj, treeVisitor);
            }
            treeVisitor.leaveNode(string, this);
        } else {
            treeVisitor.visitNode(string, object.toString(), this);
            treeVisitor.leaveNode(string, this);
        }
    }

    static class SingleTreeNode
    implements TreeNode {
        private final String nodeName;
        private final String nodeValue;

        public SingleTreeNode(String string, String string2) {
            this.nodeName = string;
            this.nodeValue = string2;
        }

        @Override
        public List<TreeNode> getChildren() {
            return new ArrayList<TreeNode>();
        }

        @Override
        public String getNodeName() {
            return this.nodeName;
        }

        @Override
        public String getNodeValue() {
            return this.nodeValue;
        }
    }
}

