/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.util.graph;

import java.util.HashMap;
import java.util.HashSet;
import org.xerial.util.CollectionUtil;

public class DFA<State, Alphabet> {
    private State _currentState;
    private HashSet<State> _stateSet = new HashSet();
    private HashSet<State> _terminalStateSet = new HashSet();
    private TransitionTable _transitionTable = new TransitionTable();

    public DFA(State State2) {
        this._currentState = State2;
    }

    public void addState(State State2) {
        this._stateSet.add(State2);
    }

    public void addTerminalState(State State2) {
        this._stateSet.add(State2);
        this._terminalStateSet.add(State2);
    }

    public void addTransition(State State2, Alphabet Alphabet, State State3) {
        this._stateSet.add(State2);
        this._stateSet.add(State3);
        this._transitionTable.addTransition(State2, Alphabet, State3);
    }

    public boolean isTerminated() {
        if (this._currentState == null) {
            return false;
        }
        return this._terminalStateSet.contains(this._currentState);
    }

    public State transit(Alphabet Alphabet) {
        if (this._currentState == null) {
            return null;
        }
        Object State2 = this._transitionTable.nextState(this._currentState, Alphabet);
        this._currentState = State2;
        return this._currentState;
    }

    public String toString() {
        return this._transitionTable.toString();
    }

    class TransitionTable
    extends HashMap<State, TransitionTargetTable> {
        private static final long serialVersionUID = 1L;

        TransitionTable() {
        }

        public void addTransition(State State2, Alphabet Alphabet, State State3) {
            TransitionTargetTable transitionTargetTable = (TransitionTargetTable)this.get(State2);
            if (transitionTargetTable == null) {
                transitionTargetTable = this.put(State2, new TransitionTargetTable());
            }
            transitionTargetTable.put(Alphabet, State3);
        }

        public State nextState(State State2, Alphabet Alphabet) {
            TransitionTargetTable transitionTargetTable = (TransitionTargetTable)this.get(State2);
            if (transitionTargetTable == null) {
                return null;
            }
            return transitionTargetTable.get(Alphabet);
        }

        @Override
        public String toString() {
            return CollectionUtil.displayMap(this, ":", "\n");
        }
    }

    class TransitionTargetTable
    extends HashMap<Alphabet, State> {
        private static final long serialVersionUID = 1L;

        TransitionTargetTable() {
        }

        @Override
        public String toString() {
            return CollectionUtil.displayMap(this, "->", ", ");
        }
    }
}

