/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.util.log;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xerial.util.log.LogLevel;
import org.xerial.util.log.LogWriter;
import org.xerial.util.log.Logger;

public class SilkLogWriter
implements LogWriter {
    private Writer logOut = new OutputStreamWriter(System.err);
    public static final String NEW_LINE = System.getProperty("line.separator");
    private static Pattern leadingHyphen = Pattern.compile("\\s*-");

    public SilkLogWriter() {
    }

    public SilkLogWriter(Writer writer) {
        this.logOut = writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(Logger logger, LogLevel logLevel, Object object) throws IOException {
        if (this.logOut == null) {
            return;
        }
        DateFormat dateFormat = DateFormat.getDateTimeInstance();
        SilkLogWriter silkLogWriter = this;
        synchronized (silkLogWriter) {
            Date date = new Date();
            this.logOut.write(String.format("-log(level:%s, name:%s, time:\"%s\")", logLevel.name().toLowerCase(), logger.getLoggerName(), dateFormat.format(date)));
            if (object != null) {
                this.logOut.write(">>");
                this.logOut.write(NEW_LINE);
                String string = SilkLogWriter.escapeText(object.toString());
                this.logOut.write(string);
            }
            this.logOut.write(NEW_LINE);
            this.logOut.flush();
        }
    }

    public static String escapeText(String string) {
        String[] stringArray = string.split("\r?\n");
        if (stringArray == null) {
            return SilkLogWriter.escapeDataLine(string);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : stringArray) {
            arrayList.add(SilkLogWriter.escapeDataLine(string2));
        }
        return SilkLogWriter.join(arrayList, NEW_LINE);
    }

    private static String escapeDataLine(String string) {
        if (string == null) {
            return string;
        }
        Matcher matcher = leadingHyphen.matcher(string);
        if (matcher.lookingAt()) {
            int n = matcher.end();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string.substring(0, n - 1));
            stringBuilder.append("\\");
            stringBuilder.append(string.substring(n - 1));
            return stringBuilder.toString();
        }
        return string;
    }

    public static <T> String join(Collection<T> collection, String string) {
        if (collection == null) {
            return "";
        }
        int n = collection.size();
        if (n == 0) {
            return "";
        }
        Iterator<T> iterator = collection.iterator();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; iterator.hasNext() && i < n - 1; ++i) {
            T t = iterator.next();
            if (t != null) {
                stringBuilder.append(t.toString());
            } else {
                stringBuilder.append("null");
            }
            stringBuilder.append(string);
        }
        T t = iterator.next();
        if (t != null) {
            stringBuilder.append(t.toString());
        } else {
            stringBuilder.append("null");
        }
        return stringBuilder.toString();
    }
}

