/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.util.thread;

import java.util.LinkedList;
import org.xerial.util.thread.ThreadGroup;
import org.xerial.util.thread.WorkerThread;

public class ThreadManager {
    private LinkedList<Runnable> _taskQueue = new LinkedList();
    private ThreadGroup<WorkerThread> _threadGroup = new ThreadGroup();
    private int _numMaximumThread = 5;
    private int _taskQueueMaxSize = 100;
    private boolean _isInTerminatePhase = false;

    public ThreadManager() {
        this.prepareWorkerThreads();
    }

    public ThreadManager(int n, int n2) {
        this._numMaximumThread = n;
        this._taskQueueMaxSize = n2;
        this.prepareWorkerThreads();
    }

    private synchronized void prepareWorkerThreads() {
        for (int i = 0; i < this._numMaximumThread; ++i) {
            WorkerThread workerThread = new WorkerThread(this);
            this._threadGroup.addThread(workerThread);
            workerThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTask(Runnable runnable) throws InterruptedException {
        if (runnable == null) {
            throw new NullPointerException("task is null");
        }
        ThreadManager threadManager = this;
        synchronized (threadManager) {
            while (this._taskQueue.size() >= this._taskQueueMaxSize) {
                this.wait();
            }
            this._taskQueue.add(runnable);
            this.notify();
        }
    }

    synchronized Runnable nextWork() throws InterruptedException {
        while (this._taskQueue.isEmpty() && !this._isInTerminatePhase) {
            this.wait();
        }
        Runnable runnable = this._taskQueue.poll();
        this.notifyAll();
        if (this._isInTerminatePhase && this._taskQueue.isEmpty()) {
            return null;
        }
        return runnable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void joinAll() throws InterruptedException {
        ThreadManager threadManager = this;
        synchronized (threadManager) {
            while (!this._taskQueue.isEmpty()) {
                this.wait();
            }
            this._isInTerminatePhase = true;
            this.notifyAll();
        }
        this._threadGroup.joinAll();
    }

    public synchronized void terminateAll() {
        this._isInTerminatePhase = true;
        this._threadGroup.interruptAll();
    }
}

