/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.deliver;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.ParseException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.cache.ResolutionCacheManager;
import org.apache.ivy.core.deliver.DeliverEngineSettings;
import org.apache.ivy.core.deliver.DeliverOptions;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.plugins.parser.xml.UpdateOptions;
import org.apache.ivy.plugins.parser.xml.XmlModuleDescriptorUpdater;
import org.apache.ivy.plugins.report.XmlReportParser;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.util.ConfigurationUtils;
import org.apache.ivy.util.Message;
import org.xml.sax.SAXException;

public class DeliverEngine {
    private DeliverEngineSettings settings;

    public DeliverEngine(DeliverEngineSettings deliverEngineSettings) {
        this.settings = deliverEngineSettings;
    }

    public void deliver(String string, String string2, DeliverOptions deliverOptions) throws IOException, ParseException {
        String string3 = deliverOptions.getResolveId();
        if (string3 == null) {
            throw new IllegalArgumentException("A resolveId must be specified for delivering.");
        }
        File[] fileArray = this.getCache().getConfigurationResolveReportsInCache(string3);
        if (fileArray.length == 0) {
            throw new IllegalStateException("No previous resolve found for id '" + string3 + "' Please resolve dependencies before delivering.");
        }
        XmlReportParser xmlReportParser = new XmlReportParser();
        xmlReportParser.parse(fileArray[0]);
        ModuleRevisionId moduleRevisionId = xmlReportParser.getResolvedModule();
        this.deliver(moduleRevisionId, string, string2, deliverOptions);
    }

    private ResolutionCacheManager getCache() {
        return this.settings.getResolutionCacheManager();
    }

    public void deliver(ModuleRevisionId moduleRevisionId, String string, String string2, DeliverOptions deliverOptions) throws IOException, ParseException {
        Object object;
        Object sAXException;
        Object object2;
        Object object3;
        Message.info(":: delivering :: " + moduleRevisionId + " :: " + string + " :: " + deliverOptions.getStatus() + " :: " + deliverOptions.getPubdate());
        Message.verbose("\toptions = " + deliverOptions);
        long l = System.currentTimeMillis();
        string2 = this.settings.substitute(string2);
        ModuleDescriptor moduleDescriptor = this.getCache().getResolvedModuleDescriptor(moduleRevisionId);
        moduleDescriptor.setResolvedModuleRevisionId(ModuleRevisionId.newInstance(moduleDescriptor.getModuleRevisionId(), deliverOptions.getPubBranch() == null ? moduleRevisionId.getBranch() : deliverOptions.getPubBranch(), string));
        moduleDescriptor.setResolvedPublicationDate(deliverOptions.getPubdate());
        HashMap<Object, String> hashMap = new HashMap<Object, String>();
        HashMap<String[], String> hashMap2 = new HashMap<String[], String>();
        HashMap<ModuleRevisionId, String> hashMap3 = new HashMap<ModuleRevisionId, String>();
        File file = this.getCache().getResolvedIvyPropertiesInCache(moduleRevisionId);
        if (!file.exists()) {
            throw new IllegalStateException("ivy properties not found in cache for " + moduleRevisionId + "; please resolve dependencies before delivering!");
        }
        Properties properties = new Properties();
        FileInputStream fileInputStream = new FileInputStream(file);
        properties.load(fileInputStream);
        fileInputStream.close();
        for (String dependencyDescriptorArray2 : properties.keySet()) {
            String[] i = properties.getProperty(dependencyDescriptorArray2).split(" ");
            object3 = ModuleRevisionId.decode(dependencyDescriptorArray2);
            if (deliverOptions.isResolveDynamicRevisions()) {
                hashMap.put(object3, i[0]);
                if (i.length >= 4 && i[3] != null && !"null".equals(i[3])) {
                    hashMap2.put((String[])object3, i[3]);
                }
            }
            hashMap3.put((ModuleRevisionId)object3, i[1]);
            if (!deliverOptions.isReplaceForcedRevisions()) continue;
            if (i.length <= 2) {
                throw new IllegalStateException("ivy properties file generated by an older version of Ivy which doesn't support replacing forced revisions!");
            }
            hashMap.put(object3, i[2]);
        }
        HashMap hashMap4 = new HashMap();
        DependencyDescriptor[] dependencyDescriptorArray = moduleDescriptor.getDependencies();
        for (int file2 = 0; file2 < dependencyDescriptorArray.length; ++file2) {
            object3 = (String)hashMap.get(dependencyDescriptorArray[file2].getDependencyRevisionId());
            if (object3 == null) {
                object3 = dependencyDescriptorArray[file2].getDependencyRevisionId().getRevision();
            }
            if ((object2 = (String)hashMap2.get(dependencyDescriptorArray[file2].getDependencyRevisionId())) == null || "null".equals(object2)) {
                object2 = dependencyDescriptorArray[file2].getDependencyRevisionId().getBranch();
            }
            sAXException = (String)hashMap3.get(dependencyDescriptorArray[file2].getDependencyRevisionId());
            object = null;
            object = object2 == null ? ModuleRevisionId.newInstance(dependencyDescriptorArray[file2].getDependencyRevisionId(), (String)object3) : ModuleRevisionId.newInstance(dependencyDescriptorArray[file2].getDependencyRevisionId(), (String)object2, (String)object3);
            hashMap4.put(dependencyDescriptorArray[file2].getDependencyRevisionId(), deliverOptions.getPdrResolver().resolve(moduleDescriptor, deliverOptions.getStatus(), (ModuleRevisionId)object, (String)sAXException));
        }
        File file2 = this.settings.resolveFile(IvyPatternHelper.substitute(string2, moduleDescriptor.getResolvedModuleRevisionId()));
        Message.info("\tdelivering ivy file to " + file2);
        object3 = ConfigurationUtils.replaceWildcards(deliverOptions.getConfs(), moduleDescriptor);
        object2 = new HashSet<String>(Arrays.asList(moduleDescriptor.getConfigurationsNames()));
        object2.removeAll(Arrays.asList(object3));
        try {
            sAXException = new UpdateOptions().setSettings(this.settings).setResolvedRevisions(hashMap4).setStatus(deliverOptions.getStatus()).setRevision(string).setBranch(deliverOptions.getPubBranch()).setPubdate(deliverOptions.getPubdate()).setGenerateRevConstraint(deliverOptions.isGenerateRevConstraint()).setMerge(deliverOptions.isMerge()).setMergedDescriptor(moduleDescriptor).setConfsToExclude(object2.toArray(new String[object2.size()]));
            if (!hashMap2.isEmpty()) {
                sAXException = ((UpdateOptions)sAXException).setResolvedBranches(hashMap2);
            }
            object = moduleDescriptor.getResource();
            XmlModuleDescriptorUpdater.update(object.openStream(), (Resource)object, file2, (UpdateOptions)sAXException);
        }
        catch (SAXException sAXException2) {
            throw new RuntimeException("bad ivy file in cache for " + moduleRevisionId, sAXException2);
        }
        Message.verbose("\tdeliver done (" + (System.currentTimeMillis() - l) + "ms)");
    }
}

