/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbt.jacoco.report;

import com.github.sbt.jacoco.filter.FilteringAnalyzer;
import com.github.sbt.jacoco.report.DirectoriesSourceFileLocator;
import com.github.sbt.jacoco.report.JacocoReportSettings;
import com.github.sbt.jacoco.report.JacocoSourceSettings;
import com.github.sbt.jacoco.report.formats.JacocoReportFormat;
import java.io.File;
import java.io.Serializable;
import java.text.DecimalFormat;
import org.jacoco.core.analysis.CoverageBuilder;
import org.jacoco.core.analysis.IBundleCoverage;
import org.jacoco.core.analysis.ICounter;
import org.jacoco.core.analysis.ICoverageVisitor;
import org.jacoco.core.data.ExecutionDataStore;
import org.jacoco.core.data.SessionInfoStore;
import org.jacoco.core.tools.ExecFileLoader;
import org.jacoco.report.IReportVisitor;
import org.jacoco.report.ISourceFileLocator;
import sbt.internal.util.Init;
import sbt.std.TaskStreams;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005=d\u0001B\u0001\u0003\u00015\u0011aAU3q_J$(BA\u0002\u0005\u0003\u0019\u0011X\r]8si*\u0011QAB\u0001\u0007U\u0006\u001cwnY8\u000b\u0005\u001dA\u0011aA:ci*\u0011\u0011BC\u0001\u0007O&$\b.\u001e2\u000b\u0003-\t1aY8n\u0007\u0001\u0019\"\u0001\u0001\b\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g\u0011!)\u0002A!A!\u0002\u00131\u0012AE3yK\u000e,H/[8o\t\u0006$\u0018MR5mKN\u00042aF\u0010#\u001d\tARD\u0004\u0002\u001a95\t!D\u0003\u0002\u001c\u0019\u00051AH]8pizJ\u0011!E\u0005\u0003=A\tq\u0001]1dW\u0006<W-\u0003\u0002!C\t\u00191+Z9\u000b\u0005y\u0001\u0002CA\u0012)\u001b\u0005!#BA\u0013'\u0003\tIwNC\u0001(\u0003\u0011Q\u0017M^1\n\u0005%\"#\u0001\u0002$jY\u0016D\u0001b\u000b\u0001\u0003\u0002\u0003\u0006IAF\u0001\u0011G2\f7o\u001d#je\u0016\u001cGo\u001c:jKND\u0001\"\f\u0001\u0003\u0002\u0003\u0006IAF\u0001\u0012g>,(oY3ESJ,7\r^8sS\u0016\u001c\b\u0002C\u0018\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0019\u0002\u001dM|WO]2f'\u0016$H/\u001b8hgB\u0011\u0011GM\u0007\u0002\u0005%\u00111G\u0001\u0002\u0015\u0015\u0006\u001cwnY8T_V\u00148-Z*fiRLgnZ:\t\u0011U\u0002!\u0011!Q\u0001\nY\naB]3q_J$8+\u001a;uS:<7\u000f\u0005\u00022o%\u0011\u0001H\u0001\u0002\u0015\u0015\u0006\u001cwnY8SKB|'\u000f^*fiRLgnZ:\t\u0011i\u0002!\u0011!Q\u0001\n\t\nqB]3q_J$H)\u001b:fGR|'/\u001f\u0005\ty\u0001\u0011\t\u0011)A\u0005{\u000591\u000f\u001e:fC6\u001c\bC\u0001 E\u001d\ty\u0014I\u0004\u0002\u001a\u0001&\tq!\u0003\u0002C\u0007\u0006!1*Z=t\u0015\u00059\u0011BA#G\u0005-!\u0016m]6TiJ,\u0017-\\:\u000b\u0005\t\u001b\u0005\"\u0002%\u0001\t\u0003I\u0015A\u0002\u001fj]&$h\b\u0006\u0005K\u00172kej\u0014)R!\t\t\u0004\u0001C\u0003\u0016\u000f\u0002\u0007a\u0003C\u0003,\u000f\u0002\u0007a\u0003C\u0003.\u000f\u0002\u0007a\u0003C\u00030\u000f\u0002\u0007\u0001\u0007C\u00036\u000f\u0002\u0007a\u0007C\u0003;\u000f\u0002\u0007!\u0005C\u0003=\u000f\u0002\u0007Q\bC\u0004T\u0001\t\u0007I\u0011\u0002+\u0002!A,'oY3oi\u0006<WMR8s[\u0006$X#A+\u0011\u0005YKV\"A,\u000b\u0005a3\u0013\u0001\u0002;fqRL!AW,\u0003\u001b\u0011+7-[7bY\u001a{'/\\1u\u0011\u0019a\u0006\u0001)A\u0005+\u0006\t\u0002/\u001a:dK:$\u0018mZ3G_Jl\u0017\r\u001e\u0011\t\u000by\u0003A\u0011A0\u0002\u0011\u001d,g.\u001a:bi\u0016$\u0012\u0001\u0019\t\u0003\u001f\u0005L!A\u0019\t\u0003\tUs\u0017\u000e\u001e\u0005\u0006I\u0002!\t!Z\u0001\u000eG\",7m[\"pm\u0016\u0014\u0018mZ3\u0015\u0005\u0019L\u0007CA\bh\u0013\tA\u0007CA\u0004C_>dW-\u00198\t\u000b)\u001c\u0007\u0019A6\u0002\r\t,h\u000e\u001a7f!\taG/D\u0001n\u0015\tqw.\u0001\u0005b]\u0006d\u0017p]5t\u0015\t\u0001\u0018/\u0001\u0003d_J,'BA\u0003s\u0015\u0005\u0019\u0018aA8sO&\u0011Q/\u001c\u0002\u0010\u0013\n+h\u000e\u001a7f\u0007>4XM]1hK\"1q\u000f\u0001C\u0001\ta\fAb\u00195fG.\u001cu.\u001e8uKJ$\u0002BZ=\u0002\b\u0005E\u00111\u0004\u0005\u0006uZ\u0004\ra_\u0001\u0005k:LG\u000fE\u0002}\u0003\u0003q!! @\u0011\u0005e\u0001\u0012BA@\u0011\u0003\u0019\u0001&/\u001a3fM&!\u00111AA\u0003\u0005\u0019\u0019FO]5oO*\u0011q\u0010\u0005\u0005\b\u0003\u00131\b\u0019AA\u0006\u0003\u0005\u0019\u0007c\u00017\u0002\u000e%\u0019\u0011qB7\u0003\u0011%\u001bu.\u001e8uKJDq!a\u0005w\u0001\u0004\t)\"\u0001\u0005sKF,\u0018N]3e!\ry\u0011qC\u0005\u0004\u00033\u0001\"A\u0002#pk\ndW\rC\u0004\u0002\u001eY\u0004\r!a\b\u0002\u001dM,X.\\1ss\n+\u0018\u000e\u001c3feB\u0019q#!\t\n\u0007\u0005\r\u0012EA\u0007TiJLgn\u001a\"vS2$WM\u001d\u0005\b\u0003O\u0001A\u0011BA\u0015\u0003Eaw.\u00193Fq\u0016\u001cW\u000f^5p]\u0012\u000bG/Y\u000b\u0003\u0003W\u0001raDA\u0017\u0003c\ti$C\u0002\u00020A\u0011a\u0001V;qY\u0016\u0014\u0004\u0003BA\u001a\u0003si!!!\u000e\u000b\u0007\u0005]r.\u0001\u0003eCR\f\u0017\u0002BA\u001e\u0003k\u0011!#\u0012=fGV$\u0018n\u001c8ECR\f7\u000b^8sKB!\u00111GA \u0013\u0011\t\t%!\u000e\u0003!M+7o]5p]&sgm\\*u_J,\u0007bBA#\u0001\u0011%\u0011qI\u0001\u0011C:\fG.\u001f>f'R\u0014Xo\u0019;ve\u0016$Ra[A%\u0003\u001bB\u0001\"a\u0013\u0002D\u0001\u0007\u0011\u0011G\u0001\u0013Kb,7-\u001e;j_:$\u0015\r^1Ti>\u0014X\r\u0003\u0005\u0002P\u0005\r\u0003\u0019AA\u001f\u0003A\u0019Xm]:j_:LeNZ8Ti>\u0014X\rC\u0004\u0002T\u0001!I!!\u0016\u0002\u0019\r\u0014X-\u0019;f%\u0016\u0004xN\u001d;\u0015\u0013\u0001\f9&a\u001a\u0002l\u00055\u0004\u0002CA-\u0003#\u0002\r!a\u0017\u0002\u0019I,\u0007o\u001c:u\r>\u0014X.\u0019;\u0011\t\u0005u\u00131M\u0007\u0003\u0003?R1!!\u0019\u0003\u0003\u001d1wN]7biNLA!!\u001a\u0002`\t\u0011\"*Y2pG>\u0014V\r]8si\u001a{'/\\1u\u0011\u001d\tI'!\u0015A\u0002-\faBY;oI2,7i\u001c<fe\u0006<W\r\u0003\u0005\u0002L\u0005E\u0003\u0019AA\u0019\u0011!\ty%!\u0015A\u0002\u0005u\u0002")
public class Report {
    private final Seq<File> executionDataFiles;
    private final Seq<File> classDirectories;
    private final Seq<File> sourceDirectories;
    private final JacocoSourceSettings sourceSettings;
    private final JacocoReportSettings reportSettings;
    private final File reportDirectory;
    private final TaskStreams<Init.ScopedKey<?>> streams;
    private final DecimalFormat percentageFormat;

    private DecimalFormat percentageFormat() {
        return this.percentageFormat;
    }

    public void generate() {
        Tuple2<ExecutionDataStore, SessionInfoStore> tuple2 = this.loadExecutionData();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        ExecutionDataStore executionDataStore = (ExecutionDataStore)tuple2._1();
        SessionInfoStore sessionInfoStore = (SessionInfoStore)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)executionDataStore, (Object)sessionInfoStore);
        Tuple2 tuple23 = tuple22;
        ExecutionDataStore executionDataStore2 = (ExecutionDataStore)tuple23._1();
        SessionInfoStore sessionInfoStore2 = (SessionInfoStore)tuple23._2();
        IBundleCoverage bundleCoverage = this.analyzeStructure(executionDataStore2, sessionInfoStore2);
        this.reportSettings.formats().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            this.createReport(x$2, bundleCoverage, executionDataStore2, sessionInfoStore2);
            return BoxedUnit.UNIT;
        });
        if (!this.checkCoverage(bundleCoverage)) {
            this.streams.log().error((Function0 & Serializable & scala.Serializable)() -> "Required coverage is not met");
            throw scala.sys.package$.MODULE$.exit(1);
        }
    }

    public boolean checkCoverage(IBundleCoverage bundle) {
        StringBuilder sb = package$.MODULE$.StringBuilder().newBuilder();
        sb.$plus$plus$eq("\n------- ");
        sb.$plus$plus$eq(this.reportSettings.title());
        sb.$plus$plus$eq(" -------\n\n");
        boolean bl = this.checkCounter("Lines", bundle.getLineCounter(), this.reportSettings.thresholds().line(), sb);
        boolean bl2 = this.checkCounter("Instructions", bundle.getInstructionCounter(), this.reportSettings.thresholds().instruction(), sb);
        boolean bl3 = this.checkCounter("Branches", bundle.getBranchCounter(), this.reportSettings.thresholds().branch(), sb);
        boolean bl4 = this.checkCounter("Methods", bundle.getMethodCounter(), this.reportSettings.thresholds().method(), sb);
        boolean bl5 = this.checkCounter("Complexity", bundle.getComplexityCounter(), this.reportSettings.thresholds().complexity(), sb);
        boolean bl6 = this.checkCounter("Class", bundle.getClassCounter(), this.reportSettings.thresholds().clazz(), sb);
        List checkResult = Nil$.MODULE$.$colon$colon((Object)BoxesRunTime.boxToBoolean((boolean)bl6)).$colon$colon((Object)BoxesRunTime.boxToBoolean((boolean)bl5)).$colon$colon((Object)BoxesRunTime.boxToBoolean((boolean)bl4)).$colon$colon((Object)BoxesRunTime.boxToBoolean((boolean)bl3)).$colon$colon((Object)BoxesRunTime.boxToBoolean((boolean)bl2)).$colon$colon((Object)BoxesRunTime.boxToBoolean((boolean)bl));
        sb.$plus$plus$eq("\nCheck ");
        sb.$plus$plus$eq(this.reportDirectory.getAbsolutePath());
        sb.$plus$plus$eq(" for detailed report\n ");
        this.streams.log().info((Function0 & Serializable & scala.Serializable)() -> sb.toString());
        return !checkResult.contains((Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    public boolean checkCounter(String unit, ICounter c, double required, StringBuilder summaryBuilder) {
        int missedCount = c.getMissedCount();
        int totalCount = c.getTotalCount();
        double coveredRatio = Predef$.MODULE$.double2Double(c.getCoveredRatio()).isNaN() ? 0.0 : c.getCoveredRatio();
        double ratioPercent = coveredRatio * (double)100;
        boolean success = ratioPercent >= required;
        String sign = success ? ">=" : "<";
        String status = success ? "OK" : "NOK";
        String formattedRatio = this.percentageFormat().format(ratioPercent);
        summaryBuilder.$plus$plus$eq(unit);
        summaryBuilder.$plus$plus$eq(": ");
        summaryBuilder.$plus$plus$eq(formattedRatio);
        summaryBuilder.$plus$plus$eq("% (");
        summaryBuilder.$plus$plus$eq(sign);
        summaryBuilder.$plus$plus$eq(" required ");
        summaryBuilder.$plus$plus$eq(((Object)BoxesRunTime.boxToDouble((double)required)).toString());
        summaryBuilder.$plus$plus$eq("%) covered, ");
        summaryBuilder.$plus$plus$eq(((Object)BoxesRunTime.boxToInteger((int)missedCount)).toString());
        summaryBuilder.$plus$plus$eq(" of ");
        summaryBuilder.$plus$plus$eq(((Object)BoxesRunTime.boxToInteger((int)totalCount)).toString());
        summaryBuilder.$plus$plus$eq(" missed, ");
        summaryBuilder.$plus$plus$eq(status);
        summaryBuilder.$plus$plus$eq("\n");
        return success;
    }

    private Tuple2<ExecutionDataStore, SessionInfoStore> loadExecutionData() {
        ExecFileLoader loader = new ExecFileLoader();
        this.executionDataFiles.foreach((Function1 & Serializable & scala.Serializable)f -> {
            Report.$anonfun$loadExecutionData$1(loader, f);
            return BoxedUnit.UNIT;
        });
        return new Tuple2((Object)loader.getExecutionDataStore(), (Object)loader.getSessionInfoStore());
    }

    private IBundleCoverage analyzeStructure(ExecutionDataStore executionDataStore, SessionInfoStore sessionInfoStore) {
        CoverageBuilder coverageBuilder = new CoverageBuilder();
        FilteringAnalyzer analyzer = new FilteringAnalyzer(executionDataStore, (ICoverageVisitor)coverageBuilder);
        this.classDirectories.foreach((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)analyzer.analyzeAll(x$1)));
        return coverageBuilder.getBundle(this.reportSettings.title());
    }

    private void createReport(JacocoReportFormat reportFormat, IBundleCoverage bundleCoverage, ExecutionDataStore executionDataStore, SessionInfoStore sessionInfoStore) {
        IReportVisitor visitor = reportFormat.createVisitor(this.reportDirectory, this.reportSettings.fileEncoding());
        visitor.visitInfo(sessionInfoStore.getInfos(), executionDataStore.getContents());
        visitor.visitBundle(bundleCoverage, (ISourceFileLocator)new DirectoriesSourceFileLocator(this.sourceDirectories, this.sourceSettings));
        visitor.visitEnd();
    }

    public static final /* synthetic */ void $anonfun$loadExecutionData$1(ExecFileLoader loader$1, File f) {
        block0: {
            if (!f.exists()) break block0;
            loader$1.load(f);
        }
    }

    public Report(Seq<File> executionDataFiles, Seq<File> classDirectories, Seq<File> sourceDirectories, JacocoSourceSettings sourceSettings, JacocoReportSettings reportSettings, File reportDirectory, TaskStreams<Init.ScopedKey<?>> streams) {
        this.executionDataFiles = executionDataFiles;
        this.classDirectories = classDirectories;
        this.sourceDirectories = sourceDirectories;
        this.sourceSettings = sourceSettings;
        this.reportSettings = reportSettings;
        this.reportDirectory = reportDirectory;
        this.streams = streams;
        this.percentageFormat = new DecimalFormat("#.##");
    }
}

