/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.DetectorFactory;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.Plugin;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.cloud.CloudPlugin;
import edu.umd.cs.findbugs.updates.UpdateChecker;
import edu.umd.cs.findbugs.util.FutureValue;
import edu.umd.cs.findbugs.util.Util;
import java.io.InputStream;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.CheckForNull;

public class Version {
    public static final int MAJOR = 3;
    public static final int MINOR = 0;
    public static final int PATCHLEVEL = 1;
    public static final boolean IS_DEVELOPMENT = false;
    public static final int RELEASE_CANDIDATE = 0;
    public static final String GIT_REVISION;
    private static final String COMPUTED_DATE;
    public static final String DATE;
    public static final String CORE_PLUGIN_RELEASE_DATE;
    private static final String COMPUTED_ECLIPSE_DATE;
    private static final String COMPUTED_PLUGIN_RELEASE_DATE;
    private static String applicationName;
    private static String applicationVersion;
    public static final int PREVIEW = 0;
    private static final String RELEASE_SUFFIX_WORD;
    public static final String RELEASE_BASE = "3.0.1";
    public static final String COMPUTED_RELEASE;
    public static final String RELEASE;
    private static final String COMPUTED_ECLIPSE_UI_VERSION;
    public static final String WEBSITE = "http://findbugs.sourceforge.net";
    public static final String DOWNLOADS_WEBSITE = "http://prdownloads.sourceforge.net/findbugs";
    public static final String SUPPORT_EMAIL = "http://findbugs.sourceforge.net/reportingBugs.html";
    private static Date releaseDate;

    public static void registerApplication(String name, String version) {
        applicationName = name;
        applicationVersion = version;
    }

    @CheckForNull
    public static String getApplicationName() {
        return applicationName;
    }

    @CheckForNull
    public static String getApplicationVersion() {
        return applicationVersion;
    }

    public static void main(String[] argv) throws InterruptedException {
        if (argv.length == 0) {
            Version.printVersion(false);
            return;
        }
        String arg = argv[0];
        if ("-release".equals(arg)) {
            System.out.println(RELEASE);
        } else if ("-date".equals(arg)) {
            System.out.println(DATE);
        } else if ("-props".equals(arg)) {
            System.out.println("release.base=3.0.1");
            System.out.println("release.number=" + COMPUTED_RELEASE);
            System.out.println("release.date=" + COMPUTED_DATE);
            System.out.println("plugin.release.date=" + COMPUTED_PLUGIN_RELEASE_DATE);
            System.out.println("eclipse.ui.version=" + COMPUTED_ECLIPSE_UI_VERSION);
            System.out.println("findbugs.website=http://findbugs.sourceforge.net");
            System.out.println("findbugs.downloads.website=http://prdownloads.sourceforge.net/findbugs");
            System.out.println("findbugs.git.revision=" + GIT_REVISION);
        } else if ("-plugins".equals(arg)) {
            DetectorFactoryCollection.instance();
            for (Plugin p : Plugin.getAllPlugins()) {
                String website;
                System.out.println("Plugin: " + p.getPluginId());
                System.out.println("  description: " + p.getShortDescription());
                System.out.println("     provider: " + p.getProvider());
                String version = p.getVersion();
                if (version != null && version.length() > 0) {
                    System.out.println("      version: " + version);
                }
                if ((website = p.getWebsite()) != null && website.length() > 0) {
                    System.out.println("      website: " + website);
                }
                System.out.println();
            }
        } else if ("-configuration".equals(arg)) {
            Version.printVersion(true);
        } else {
            Version.usage();
            System.exit(1);
        }
    }

    private static void usage() {
        System.err.println("Usage: " + Version.class.getName() + "  [(-release|-date|-props|-configuration)]");
    }

    public static String getReleaseWithDateIfDev() {
        return RELEASE;
    }

    @CheckForNull
    public static Date getReleaseDate() {
        return releaseDate;
    }

    public static void printVersion(boolean justPrintConfiguration) throws InterruptedException {
        System.out.println("FindBugs " + COMPUTED_RELEASE);
        if (justPrintConfiguration) {
            for (Plugin plugin : Plugin.getAllPlugins()) {
                Plugin parent;
                System.out.printf("Plugin %s, version %s, loaded from %s%n", plugin.getPluginId(), plugin.getVersion(), plugin.getPluginLoader().getURL());
                if (plugin.isCorePlugin()) {
                    System.out.println("  is core plugin");
                }
                if (plugin.isInitialPlugin()) {
                    System.out.println("  is initial plugin");
                }
                if (plugin.isEnabledByDefault()) {
                    System.out.println("  is enabled by default");
                }
                if (plugin.isGloballyEnabled()) {
                    System.out.println("  is globally enabled");
                }
                if ((parent = plugin.getParentPlugin()) != null) {
                    System.out.println("  has parent plugin " + parent.getPluginId());
                }
                for (CloudPlugin cloudPlugin : plugin.getCloudPlugins()) {
                    System.out.printf("  cloud %s%n", cloudPlugin.getId());
                    System.out.printf("     %s%n", cloudPlugin.getDescription());
                }
                for (DetectorFactory factory : plugin.getDetectorFactories()) {
                    System.out.printf("  detector %s%n", factory.getShortName());
                }
                System.out.println();
            }
            Version.printPluginUpdates(true, 10);
        } else {
            Version.printPluginUpdates(false, 3);
        }
    }

    private static void printPluginUpdates(boolean verbose, int secondsToWait) throws InterruptedException {
        block9: {
            DetectorFactoryCollection dfc = DetectorFactoryCollection.instance();
            if (dfc.getUpdateChecker().updateChecksGloballyDisabled()) {
                if (verbose) {
                    System.out.println();
                    System.out.print("Update checking globally disabled");
                }
                return;
            }
            if (verbose) {
                System.out.println();
                System.out.print("Checking for plugin updates...");
            }
            FutureValue<Collection<UpdateChecker.PluginUpdate>> updateHolder = dfc.getUpdates();
            try {
                Collection<UpdateChecker.PluginUpdate> updates = updateHolder.get(secondsToWait, TimeUnit.SECONDS);
                if (updates.isEmpty()) {
                    if (verbose) {
                        System.out.println("none!");
                    }
                } else {
                    System.out.println();
                    for (UpdateChecker.PluginUpdate update : updates) {
                        System.out.println(update);
                        System.out.println();
                    }
                }
            }
            catch (TimeoutException e) {
                if (!verbose) break block9;
                System.out.println("Timeout while trying to get updates");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    static {
        Date parsedDate;
        String tmp;
        GIT_REVISION = System.getProperty("git.revision", "UNKNOWN");
        applicationName = "";
        applicationVersion = "";
        SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss z, dd MMMM, yyyy", Locale.ENGLISH);
        SimpleDateFormat eclipseDateFormat = new SimpleDateFormat("yyyyMMdd", Locale.ENGLISH);
        SimpleDateFormat releaseDateFormat = new SimpleDateFormat("MM/dd/yyyy hh:mm aa z", Locale.ENGLISH);
        Date now = new Date();
        COMPUTED_DATE = dateFormat.format(now);
        COMPUTED_ECLIPSE_DATE = eclipseDateFormat.format(now);
        COMPUTED_PLUGIN_RELEASE_DATE = tmp = releaseDateFormat.format(now);
        String suffix = "dev-" + COMPUTED_ECLIPSE_DATE;
        if (!"Unknown".equals(GIT_REVISION)) {
            suffix = suffix + "-" + GIT_REVISION;
        }
        RELEASE_SUFFIX_WORD = suffix;
        COMPUTED_RELEASE = RELEASE_BASE + "";
        COMPUTED_ECLIPSE_UI_VERSION = "3.0.1." + COMPUTED_ECLIPSE_DATE;
        Class<Version> c = Version.class;
        URL u = c.getResource(c.getSimpleName() + ".class");
        boolean fromFile = "file".equals(u.getProtocol());
        InputStream in = null;
        String release = null;
        String date = null;
        String plugin_release_date = null;
        if (!fromFile) {
            block12: {
                try {
                    Properties versionProperties = new Properties();
                    in = Version.class.getResourceAsStream("version.properties");
                    if (in == null) break block12;
                    versionProperties.load(in);
                    release = (String)versionProperties.get("release.number");
                    date = (String)versionProperties.get("release.date");
                    plugin_release_date = (String)versionProperties.get("plugin.release.date");
                }
                catch (Exception e) {
                    Util.closeSilently(in);
                    catch (Throwable throwable) {
                        Util.closeSilently(in);
                        throw throwable;
                    }
                }
            }
            Util.closeSilently(in);
        }
        if (release == null) {
            release = COMPUTED_RELEASE;
        }
        if (date == null) {
            date = COMPUTED_DATE;
        }
        if (plugin_release_date == null) {
            plugin_release_date = COMPUTED_PLUGIN_RELEASE_DATE;
        }
        RELEASE = release;
        DATE = date;
        CORE_PLUGIN_RELEASE_DATE = plugin_release_date;
        try {
            SimpleDateFormat fmt = new SimpleDateFormat("MM/dd/yyyy hh:mm aa z", Locale.ENGLISH);
            parsedDate = fmt.parse(CORE_PLUGIN_RELEASE_DATE);
        }
        catch (ParseException e) {
            if (SystemProperties.ASSERTIONS_ENABLED) {
                e.printStackTrace();
            }
            parsedDate = null;
        }
        releaseDate = parsedDate;
    }
}

