/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.constant;

import javax.annotation.Nullable;

public class Constant {
    private final Object value;
    public static final Constant NOT_CONSTANT = new Constant(null);

    public Constant(@Nullable Object value) {
        this.value = value;
    }

    public Object getConstantValue() {
        return this.value;
    }

    public boolean isConstant() {
        return this.value != null;
    }

    public boolean isConstantString() {
        return this.isConstant() && this.value instanceof String;
    }

    public String getConstantString() {
        return (String)this.value;
    }

    public boolean isConstantInteger() {
        return this.isConstant() && this.value instanceof Integer;
    }

    public int getConstantInt() {
        return (Integer)this.value;
    }

    public static Constant merge(Constant a, Constant b) {
        if (!a.isConstant() || !b.isConstant()) {
            return NOT_CONSTANT;
        }
        if (a.value.getClass() != b.value.getClass() || !a.value.equals(b.value)) {
            return NOT_CONSTANT;
        }
        return a;
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Constant other = (Constant)obj;
        if (other.value == this.value) {
            return true;
        }
        if (other.value == null || this.value == null) {
            return false;
        }
        return this.value.equals(other.value);
    }

    public int hashCode() {
        return this.value == null ? 123 : this.value.hashCode();
    }

    public String toString() {
        if (!this.isConstant()) {
            return "-";
        }
        return "<" + this.value.toString() + ">";
    }
}

