/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.jsr305;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.AbstractDataflowAnalysis;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Edge;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.jsr305.SourceSinkInfo;
import edu.umd.cs.findbugs.ba.jsr305.TypeQualifierValue;
import edu.umd.cs.findbugs.ba.jsr305.TypeQualifierValueSet;
import edu.umd.cs.findbugs.ba.vna.ValueNumber;
import edu.umd.cs.findbugs.ba.vna.ValueNumberDataflow;
import edu.umd.cs.findbugs.ba.vna.ValueNumberFrame;
import edu.umd.cs.findbugs.util.ClassName;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;

public abstract class TypeQualifierDataflowAnalysis
extends AbstractDataflowAnalysis<TypeQualifierValueSet> {
    static final boolean DEBUG_VERBOSE = SystemProperties.getBoolean("ctq.dataflow.debug.verbose");
    protected final XMethod xmethod;
    protected final CFG cfg;
    protected final ValueNumberDataflow vnaDataflow;
    protected final TypeQualifierValue<?> typeQualifierValue;
    protected final ConstantPoolGen cpg;
    private final Map<Location, Set<SourceSinkInfo>> sourceSinkMap;

    static String primitiveType(String simpleClass) {
        if ("Integer".equals(simpleClass)) {
            return "int";
        }
        return simpleClass.toLowerCase();
    }

    static boolean isIdentifyFunctionForTypeQualifiers(XMethod m) {
        String className = m.getClassName();
        if (!className.startsWith("java.lang")) {
            return false;
        }
        String methodName = m.getName();
        if (m.isStatic()) {
            if (!"valueOf".equals(methodName)) {
                return false;
            }
            String signature = m.getSignature();
            if (signature.charAt(2) != ')') {
                return false;
            }
        } else {
            String simpleClassName = ClassName.extractSimpleName(className);
            if (!methodName.equals(TypeQualifierDataflowAnalysis.primitiveType(simpleClassName) + "Value")) {
                return false;
            }
            String signature = m.getSignature();
            if (signature.charAt(1) != ')') {
                return false;
            }
        }
        return true;
    }

    public TypeQualifierDataflowAnalysis(XMethod xmethod, CFG cfg, ValueNumberDataflow vnaDataflow, ConstantPoolGen cpg, TypeQualifierValue<?> typeQualifierValue) {
        this.xmethod = xmethod;
        this.cfg = cfg;
        this.vnaDataflow = vnaDataflow;
        this.cpg = cpg;
        this.typeQualifierValue = typeQualifierValue;
        this.sourceSinkMap = new HashMap<Location, Set<SourceSinkInfo>>();
    }

    @Override
    public void initEntryFact(TypeQualifierValueSet result) throws DataflowAnalysisException {
        result.makeValid();
    }

    @Override
    public boolean isFactValid(TypeQualifierValueSet fact) {
        return fact.isValid();
    }

    @Override
    public void copy(TypeQualifierValueSet source, TypeQualifierValueSet dest) {
        dest.makeSameAs(source);
    }

    @Override
    public TypeQualifierValueSet createFact() {
        return new TypeQualifierValueSet(this.typeQualifierValue);
    }

    @Override
    public boolean isTop(TypeQualifierValueSet fact) {
        return fact.isTop();
    }

    @Override
    public void makeFactTop(TypeQualifierValueSet fact) {
        fact.setTop();
    }

    @Override
    public void meetInto(TypeQualifierValueSet fact, Edge edge, TypeQualifierValueSet result) throws DataflowAnalysisException {
        if (fact.isTop() || result.isBottom()) {
            return;
        }
        if (fact.isBottom() || result.isTop()) {
            result.makeSameAs(fact);
            return;
        }
        assert (fact.isValid());
        assert (result.isValid());
        result.mergeWith(fact);
    }

    @Override
    public boolean same(TypeQualifierValueSet fact1, TypeQualifierValueSet fact2) {
        return fact1.equals(fact2);
    }

    @Override
    public void edgeTransfer(Edge edge, TypeQualifierValueSet fact) throws DataflowAnalysisException {
        if (!fact.isValid()) {
            return;
        }
        ValueNumberFrame targetVnaFrame = (ValueNumberFrame)this.vnaDataflow.getStartFact((BasicBlock)edge.getTarget());
        ValueNumberFrame sourceVnaFrame = (ValueNumberFrame)this.vnaDataflow.getResultFact((BasicBlock)edge.getSource());
        if (!targetVnaFrame.isValid() || !sourceVnaFrame.isValid()) {
            return;
        }
        int numSlotsToMerge = Math.min(sourceVnaFrame.getNumSlots(), targetVnaFrame.getNumSlots());
        for (int i = 0; i < numSlotsToMerge; ++i) {
            ValueNumber sourceVN;
            ValueNumber targetVN = (ValueNumber)targetVnaFrame.getValue(i);
            if (targetVN.equals(sourceVN = (ValueNumber)sourceVnaFrame.getValue(i)) || !targetVN.hasFlag(8)) continue;
            if (DEBUG_VERBOSE) {
                System.out.println("Phi node: " + fact.valueNumberToString(sourceVN) + " -> " + fact.valueNumberToString(targetVN));
            }
            this.propagateAcrossPhiNode(fact, sourceVN, targetVN);
            if (!DEBUG_VERBOSE) continue;
            String dir = this.isForwards() ? "forwards" : "backwards";
            System.out.println("After propagating phi node " + dir + ": " + fact.toString());
        }
    }

    protected abstract void propagateAcrossPhiNode(TypeQualifierValueSet var1, ValueNumber var2, ValueNumber var3);

    public abstract void registerSourceSinkLocations() throws DataflowAnalysisException;

    protected void registerSourceSink(SourceSinkInfo sourceSinkInfo) {
        Set<SourceSinkInfo> set = this.sourceSinkMap.get(sourceSinkInfo.getLocation());
        if (set == null) {
            set = new HashSet<SourceSinkInfo>();
            this.sourceSinkMap.put(sourceSinkInfo.getLocation(), set);
        }
        set.add(sourceSinkInfo);
    }

    public Set<SourceSinkInfo> getSourceSinkInfoSet(Location location) {
        Set<SourceSinkInfo> result = this.sourceSinkMap.get(location);
        return result != null ? result : Collections.emptySet();
    }

    @Override
    public void transferInstruction(InstructionHandle handle, BasicBlock basicBlock, TypeQualifierValueSet fact) throws DataflowAnalysisException {
        InvokeInstruction ii;
        XMethod m;
        if (!fact.isValid()) {
            return;
        }
        Location location = new Location(handle, basicBlock);
        Instruction i = handle.getInstruction();
        if (i instanceof InvokeInstruction && TypeQualifierDataflowAnalysis.isIdentifyFunctionForTypeQualifiers(m = XFactory.createXMethod(ii = (InvokeInstruction)i, this.cpg))) {
            ValueNumberFrame vnaFrameAtLocation = (ValueNumberFrame)this.vnaDataflow.getFactAtLocation(location);
            ValueNumberFrame vnaFrameAfterInstruction = (ValueNumberFrame)this.vnaDataflow.getFactAfterLocation(location);
            ValueNumber in = (ValueNumber)vnaFrameAtLocation.getStackValue(0);
            ValueNumber out = (ValueNumber)vnaFrameAfterInstruction.getStackValue(0);
            fact.copyInfo(in, out);
            return;
        }
        Set<SourceSinkInfo> sourceSinkSet = this.sourceSinkMap.get(location);
        if (sourceSinkSet != null) {
            if (DEBUG_VERBOSE) {
                System.out.println("Modeling source/sink at " + location.toCompactString() + ": " + sourceSinkSet.toString());
            }
            for (SourceSinkInfo sourceSinkInfo : sourceSinkSet) {
                fact.modelSourceSink(sourceSinkInfo);
            }
        }
    }
}

