/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import org.apache.bcel.classfile.Code;

public class MutableEnum
extends OpcodeStackDetector {
    private final BugReporter reporter;
    private boolean skip;

    public MutableEnum(BugReporter reporter) {
        this.reporter = reporter;
    }

    @Override
    public void visitClassContext(ClassContext classContext) {
        if (!classContext.getJavaClass().isEnum() || !classContext.getJavaClass().isPublic()) {
            return;
        }
        boolean hasInterestingField = false;
        for (XField xField : classContext.getXClass().getXFields()) {
            if (xField.isStatic() || xField.isFinal() || xField.isSynthetic()) continue;
            if (xField.isPublic()) {
                this.reporter.reportBug(new BugInstance("ME_MUTABLE_ENUM_FIELD", 2).addClass(classContext.getJavaClass()).addField(xField));
                continue;
            }
            hasInterestingField = true;
        }
        if (hasInterestingField) {
            super.visitClassContext(classContext);
        }
    }

    @Override
    public boolean shouldVisitCode(Code obj) {
        this.skip = false;
        return this.getXMethod().isPublic() && this.getNumberMethodArguments() > 0;
    }

    @Override
    public void sawOpcode(int seen) {
        OpcodeStack.Item val;
        XField xField;
        if (this.skip) {
            return;
        }
        if (MutableEnum.isBranch(seen) || seen == 191 || this.isReturn(seen)) {
            this.skip = true;
        }
        if (seen == 181 && (xField = this.getXFieldOperand()) != null && xField.getClassDescriptor().getClassName().equals(this.getClassName()) && (val = this.getStack().getStackItem(0)).isInitialParameter()) {
            this.reporter.reportBug(new BugInstance("ME_ENUM_FIELD_SETTER", 2).addClassAndMethod(this).addField(xField).addSourceLine(this));
        }
    }
}

