/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.RepositoryLookupFailureCallback;
import edu.umd.cs.findbugs.detect.Stream;
import edu.umd.cs.findbugs.detect.StreamFactory;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.GETSTATIC;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.ObjectType;

public class StaticFieldLoadStreamFactory
implements StreamFactory {
    public String streamBaseClass;
    public String className;
    public String fieldName;
    public String fieldSig;

    public StaticFieldLoadStreamFactory(String streamBaseClass, String className, String fieldName, String fieldSig) {
        this.streamBaseClass = streamBaseClass;
        this.className = className;
        this.fieldName = fieldName;
        this.fieldSig = fieldSig;
    }

    @Override
    public Stream createStream(Location location, ObjectType type, ConstantPoolGen cpg, RepositoryLookupFailureCallback lookupFailureCallback) {
        Instruction ins = location.getHandle().getInstruction();
        if (ins.getOpcode() != 178) {
            return null;
        }
        GETSTATIC getstatic = (GETSTATIC)ins;
        if (!(this.className.equals(getstatic.getClassName(cpg)) && this.fieldName.equals(getstatic.getName(cpg)) && this.fieldSig.equals(getstatic.getSignature(cpg)))) {
            return null;
        }
        return new Stream(location, type.getClassName(), this.streamBaseClass).setIgnoreImplicitExceptions(true).setIsOpenOnCreation(true);
    }
}

