/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.gui2;

import edu.umd.cs.findbugs.FindBugsCommandLine;
import edu.umd.cs.findbugs.gui2.GUISaveState;
import java.io.File;
import java.io.IOException;
import javax.swing.UIManager;

public class GUI2CommandLine
extends FindBugsCommandLine {
    private float fontSize = 12.0f;
    private boolean fontSizeSpecified = false;
    private boolean docking = true;
    private int priority = 4;
    private File saveFile;

    public GUI2CommandLine() {
        super(true);
    }

    @Override
    protected void handleOption(String option, String optionExtraPart) {
        if ("-clear".equals(option)) {
            GUISaveState.clear();
            System.exit(0);
        } else if ("-d".equals(option) || "--nodock".equals(option)) {
            this.docking = false;
        } else if ("-look".equals(option)) {
            String arg = optionExtraPart;
            String theme = null;
            if ("plastic".equals(arg)) {
                theme = "com.jgoodies.plaf.plastic.PlasticXPLookAndFeel";
            } else if ("gtk".equals(arg)) {
                theme = "com.sun.java.swing.plaf.gtk.GTKLookAndFeel";
            } else if ("native".equals(arg)) {
                theme = UIManager.getSystemLookAndFeelClassName();
            } else {
                System.err.println("Style '" + arg + "' not supported");
            }
            if (theme != null) {
                try {
                    UIManager.setLookAndFeel(theme);
                }
                catch (Exception e) {
                    System.err.println("Couldn't load " + arg + " look and feel: " + e.toString());
                }
            }
        } else {
            super.handleOption(option, optionExtraPart);
        }
    }

    @Override
    protected void handleOptionWithArgument(String option, String argument) throws IOException {
        if ("-f".equals(option)) {
            try {
                this.fontSize = Float.parseFloat(argument);
                this.fontSizeSpecified = true;
            }
            catch (NumberFormatException e) {}
        } else if ("-priority".equals(option)) {
            try {
                this.priority = Integer.parseInt(argument);
            }
            catch (NumberFormatException numberFormatException) {}
        } else if ("-loadBugs".equals(option) || "-loadbugs".equals(option)) {
            this.saveFile = new File(argument);
            if (!this.saveFile.exists()) {
                System.err.println("Bugs file \"" + argument + "\" could not be found");
                System.exit(1);
            }
        } else {
            super.handleOptionWithArgument(option, argument);
        }
    }

    public float getFontSize() {
        return this.fontSize;
    }

    public boolean isFontSizeSpecified() {
        return this.fontSizeSpecified;
    }

    public boolean getDocking() {
        return this.docking;
    }

    public void setDocking(boolean docking) {
        this.docking = docking;
    }

    public int getPriority() {
        return this.priority;
    }

    public File getSaveFile() {
        return this.saveFile;
    }

    public void setSaveFile(File saveFile) {
        this.saveFile = saveFile;
    }
}

