/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.gui2;

import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.FindBugs;
import edu.umd.cs.findbugs.I18N;
import edu.umd.cs.findbugs.L10N;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.cloud.Cloud;
import edu.umd.cs.findbugs.filter.Filter;
import edu.umd.cs.findbugs.filter.Matcher;
import edu.umd.cs.findbugs.gui.AnnotatedString;
import edu.umd.cs.findbugs.gui2.Driver;
import edu.umd.cs.findbugs.gui2.FilterActivity;
import edu.umd.cs.findbugs.gui2.FilterListener;
import edu.umd.cs.findbugs.gui2.GUISaveState;
import edu.umd.cs.findbugs.gui2.MainFrame;
import edu.umd.cs.findbugs.gui2.MainFrameHelper;
import edu.umd.cs.findbugs.gui2.NewProjectWizard;
import edu.umd.cs.findbugs.gui2.PreferencesFrame;
import edu.umd.cs.findbugs.gui2.RecentMenu;
import edu.umd.cs.findbugs.gui2.SaveType;
import edu.umd.cs.findbugs.gui2.SorterDialog;
import edu.umd.cs.findbugs.gui2.ViewFilter;
import edu.umd.cs.findbugs.updates.UpdateChecker;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import javax.swing.ActionMap;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;

public class MainFrameMenu
implements Serializable {
    private final MainFrame mainFrame;
    JMenuItem reconfigMenuItem = MainFrameHelper.newJMenuItem("menu.reconfig", "Reconfigure...", 70);
    JMenuItem redoAnalysis;
    JMenuItem closeProjectItem;
    RecentMenu recentMenuCache;
    JMenu recentMenu;
    JMenuItem preferencesMenuItem;
    JMenu viewMenu;
    JMenuItem saveMenuItem = MainFrameHelper.newJMenuItem("menu.save_item", "Save", 83);
    private Class<?> osxAdapter;
    private Method osxPrefsEnableMethod;
    private JMenuItem saveAsMenuItem;
    private JMenuItem groupByMenuItem;

    public MainFrameMenu(MainFrame mainFrame) {
        this.mainFrame = mainFrame;
    }

    JMenuItem createRecentItem(final File f, final SaveType localSaveType) {
        if (MainFrame.GUI2_DEBUG) {
            System.out.println("createRecentItem(" + f + ", " + (Object)((Object)localSaveType) + ")");
        }
        String name = f.getName();
        JMenuItem item = new JMenuItem(name);
        item.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    MainFrameMenu.this.mainFrame.setCursor(new Cursor(3));
                    if (!f.exists()) {
                        JOptionPane.showMessageDialog(null, L10N.getLocalString("msg.proj_not_found", "This project can no longer be found"));
                        GUISaveState.getInstance().fileNotFound(f);
                        return;
                    }
                    GUISaveState.getInstance().fileReused(f);
                    MainFrameMenu.this.recentMenuCache.addRecentFile(f);
                    if (!f.exists()) {
                        throw new IllegalStateException("User used a recent projects menu item that didn't exist.");
                    }
                    if (MainFrameMenu.this.mainFrame.getCurProject() != null && MainFrameMenu.this.mainFrame.isProjectChanged()) {
                        int response = JOptionPane.showConfirmDialog(MainFrameMenu.this.mainFrame, L10N.getLocalString("dlg.save_current_changes", "The current project has been changed, Save current changes?"), L10N.getLocalString("dlg.save_changes", "Save Changes?"), 1, 2);
                        if (response == 0) {
                            if (MainFrameMenu.this.mainFrame.getSaveFile() != null) {
                                MainFrameMenu.this.mainFrame.getMainFrameLoadSaveHelper().save();
                            } else {
                                MainFrameMenu.this.mainFrame.getMainFrameLoadSaveHelper().saveAs();
                            }
                        } else if (response == 2) {
                            return;
                        }
                    }
                    SaveType st = SaveType.forFile(f);
                    boolean result = true;
                    switch (st) {
                        case XML_ANALYSIS: {
                            result = MainFrameMenu.this.mainFrame.openAnalysis(f, st);
                            break;
                        }
                        case FBP_FILE: {
                            result = MainFrameMenu.this.mainFrame.getMainFrameLoadSaveHelper().openFBPFile(f);
                            break;
                        }
                        case FBA_FILE: {
                            result = MainFrameMenu.this.mainFrame.getMainFrameLoadSaveHelper().openFBAFile(f);
                            break;
                        }
                        default: {
                            MainFrameMenu.this.mainFrame.error("Wrong file type in recent menu item.");
                        }
                    }
                    if (!result) {
                        JOptionPane.showMessageDialog(MainFrame.getInstance(), "There was an error in opening the file", "Recent Menu Opening Error", 2);
                    }
                }
                finally {
                    MainFrameMenu.this.mainFrame.setCursor(new Cursor(0));
                    MainFrameMenu.this.mainFrame.setSaveType(localSaveType);
                }
            }
        });
        item.setFont(item.getFont().deriveFont(Driver.getFontSize()));
        return item;
    }

    JMenuBar createMainMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = MainFrameHelper.newJMenu("menu.file_menu", "File");
        fileMenu.setMnemonic(70);
        JMenu editMenu = MainFrameHelper.newJMenu("menu.edit_menu", "Edit");
        editMenu.setMnemonic(69);
        JMenuItem openMenuItem = MainFrameHelper.newJMenuItem("menu.open_item", "Open...", 79);
        this.recentMenu = MainFrameHelper.newJMenu("menu.recent_menu", "Recent");
        this.recentMenuCache = new RecentMenu(this.recentMenu);
        this.saveAsMenuItem = MainFrameHelper.newJMenuItem("menu.saveas_item", "Save As...", 65);
        JMenuItem importFilter = MainFrameHelper.newJMenuItem("menu.importFilter_item", "Import bug filters...");
        JMenuItem exportFilter = MainFrameHelper.newJMenuItem("menu.exportFilter_item", "Export bug filters...");
        JMenuItem exitMenuItem = null;
        if (!MainFrame.MAC_OS_X) {
            exitMenuItem = MainFrameHelper.newJMenuItem("menu.exit", "Exit", 88);
            exitMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    MainFrameMenu.this.mainFrame.callOnClose();
                }
            });
        }
        JMenu windowMenu = this.mainFrame.getGuiLayout().createWindowMenu();
        JMenuItem newProjectMenuItem = null;
        if (!FindBugs.isNoAnalysis()) {
            newProjectMenuItem = MainFrameHelper.newJMenuItem("menu.new_item", "New Project", 78);
            MainFrameHelper.attachAcceleratorKey(newProjectMenuItem, 78);
            newProjectMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    MainFrameMenu.this.mainFrame.createNewProjectFromMenuItem();
                }
            });
        }
        this.reconfigMenuItem.setEnabled(false);
        MainFrameHelper.attachAcceleratorKey(this.reconfigMenuItem, 70);
        this.reconfigMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (!MainFrameMenu.this.mainFrame.canNavigateAway()) {
                    return;
                }
                new NewProjectWizard(MainFrameMenu.this.mainFrame.getCurProject());
            }
        });
        JMenuItem mergeMenuItem = MainFrameHelper.newJMenuItem("menu.mergeAnalysis", "Merge Analysis...");
        mergeMenuItem.setEnabled(true);
        mergeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrameMenu.this.mainFrame.getMainFrameLoadSaveHelper().mergeAnalysis();
            }
        });
        if (!FindBugs.isNoAnalysis()) {
            this.redoAnalysis = MainFrameHelper.newJMenuItem("menu.rerunAnalysis", "Redo Analysis", 82);
            this.redoAnalysis.setEnabled(false);
            MainFrameHelper.attachAcceleratorKey(this.redoAnalysis, 82);
            this.redoAnalysis.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    MainFrameMenu.this.mainFrame.redoAnalysis();
                }
            });
        }
        this.closeProjectItem = MainFrameHelper.newJMenuItem("menu.closeProject", "Close Project");
        this.closeProjectItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrameMenu.this.mainFrame.getMainFrameLoadSaveHelper().closeProject();
                MainFrameMenu.this.mainFrame.clearBugCollection();
            }
        });
        this.closeProjectItem.setEnabled(false);
        openMenuItem.setEnabled(true);
        MainFrameHelper.attachAcceleratorKey(openMenuItem, 79);
        openMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrameMenu.this.mainFrame.getMainFrameLoadSaveHelper().open();
            }
        });
        this.saveAsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrameMenu.this.mainFrame.getMainFrameLoadSaveHelper().saveAs();
            }
        });
        exportFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrameMenu.this.mainFrame.getMainFrameLoadSaveHelper().exportFilter();
            }
        });
        importFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrameMenu.this.mainFrame.getMainFrameLoadSaveHelper().importFilter();
            }
        });
        this.saveMenuItem.setEnabled(false);
        MainFrameHelper.attachAcceleratorKey(this.saveMenuItem, 83);
        this.saveMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrameMenu.this.mainFrame.getMainFrameLoadSaveHelper().save();
            }
        });
        if (!FindBugs.isNoAnalysis()) {
            fileMenu.add(newProjectMenuItem);
        }
        fileMenu.add(openMenuItem);
        fileMenu.add(this.recentMenu);
        fileMenu.addSeparator();
        fileMenu.add(this.saveAsMenuItem);
        fileMenu.add(this.saveMenuItem);
        fileMenu.addSeparator();
        fileMenu.add(this.reconfigMenuItem);
        if (!FindBugs.isNoAnalysis()) {
            fileMenu.add(this.redoAnalysis);
        }
        fileMenu.addSeparator();
        fileMenu.add(this.closeProjectItem);
        fileMenu.addSeparator();
        fileMenu.add(importFilter);
        fileMenu.add(exportFilter);
        if (exitMenuItem != null) {
            fileMenu.addSeparator();
            fileMenu.add(exitMenuItem);
        }
        menuBar.add(fileMenu);
        JMenuItem cutMenuItem = new JMenuItem(new CutAction());
        JMenuItem copyMenuItem = new JMenuItem(new CopyAction());
        JMenuItem pasteMenuItem = new JMenuItem(new PasteAction());
        this.preferencesMenuItem = MainFrameHelper.newJMenuItem("menu.preferences_menu", "Preferences...");
        this.groupByMenuItem = MainFrameHelper.newJMenuItem("menu.sortConfiguration", "Sort Configuration...");
        JMenuItem goToLineMenuItem = MainFrameHelper.newJMenuItem("menu.gotoLine", "Go to line...");
        MainFrameHelper.attachAcceleratorKey(cutMenuItem, 88);
        MainFrameHelper.attachAcceleratorKey(copyMenuItem, 67);
        MainFrameHelper.attachAcceleratorKey(pasteMenuItem, 86);
        this.preferencesMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrameMenu.this.mainFrame.preferences();
            }
        });
        this.groupByMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (!MainFrameMenu.this.mainFrame.canNavigateAway()) {
                    return;
                }
                SorterDialog.getInstance().setLocationRelativeTo(MainFrameMenu.this.mainFrame);
                SorterDialog.getInstance().setVisible(true);
            }
        });
        MainFrameHelper.attachAcceleratorKey(goToLineMenuItem, 76);
        goToLineMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainFrameMenu.this.mainFrame.getGuiLayout().makeSourceVisible();
                try {
                    int num = Integer.parseInt(JOptionPane.showInputDialog(MainFrameMenu.this.mainFrame, "", L10N.getLocalString("dlg.go_to_line_lbl", "Go To Line") + ":", 3));
                    MainFrameMenu.this.mainFrame.getSourceCodeDisplayer().showLine(num);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        editMenu.add(cutMenuItem);
        editMenu.add(copyMenuItem);
        editMenu.add(pasteMenuItem);
        editMenu.addSeparator();
        editMenu.add(goToLineMenuItem);
        editMenu.addSeparator();
        if (!MainFrame.MAC_OS_X) {
            editMenu.add(this.preferencesMenuItem);
        }
        menuBar.add(editMenu);
        if (windowMenu != null) {
            menuBar.add(windowMenu);
        }
        this.viewMenu = MainFrameHelper.newJMenu("menu.view_menu", "View");
        this.setViewMenu();
        menuBar.add(this.viewMenu);
        ActionMap map = this.mainFrame.getMainFrameTree().getTree().getActionMap();
        JMenu navMenu = MainFrameHelper.newJMenu("menu.navigation", "Navigation");
        this.addNavItem(map, navMenu, "menu.expand", "Expand", "expand", 39);
        this.addNavItem(map, navMenu, "menu.collapse", "Collapse", "collapse", 37);
        this.addNavItem(map, navMenu, "menu.up", "Up", "selectPrevious", 38);
        this.addNavItem(map, navMenu, "menu.down", "Down", "selectNext", 40);
        menuBar.add(navMenu);
        JMenu designationMenu = MainFrameHelper.newJMenu("menu.designation", "Designation");
        int i = 0;
        int[] keyEvents = new int[]{49, 50, 51, 52, 53, 54, 55, 56, 57};
        for (String key : I18N.instance().getUserDesignationKeys(true)) {
            String name = I18N.instance().getUserDesignation(key);
            this.mainFrame.addDesignationItem(designationMenu, key, name, keyEvents[i++]);
        }
        menuBar.add(designationMenu);
        if (!MainFrame.MAC_OS_X) {
            JMenu helpMenu = MainFrameHelper.newJMenu("menu.help_menu", "Help");
            JMenuItem aboutItem = MainFrameHelper.newJMenuItem("menu.about_item", "About FindBugs");
            helpMenu.add(aboutItem);
            aboutItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    MainFrameMenu.this.mainFrame.about();
                }
            });
            JMenuItem updateItem = MainFrameHelper.newJMenuItem("menu.check_for_updates", "Check for Updates...");
            UpdateChecker checker = DetectorFactoryCollection.instance().getUpdateChecker();
            boolean disabled = checker.updateChecksGloballyDisabled();
            updateItem.setEnabled(!disabled);
            if (disabled) {
                updateItem.setToolTipText("Update checks disabled by plugin: " + checker.getPluginThatDisabledUpdateChecks());
            }
            helpMenu.add(updateItem);
            updateItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    DetectorFactoryCollection.instance().checkForUpdates(true);
                }
            });
            menuBar.add(helpMenu);
        }
        return menuBar;
    }

    /*
     * WARNING - void declaration
     */
    void setViewMenu() {
        void var8_22;
        JRadioButtonMenuItem rbMenuItem;
        Cloud cloud = this.mainFrame.getBugCollection() == null ? null : this.mainFrame.getBugCollection().getCloud();
        this.viewMenu.removeAll();
        this.viewMenu.add(this.groupByMenuItem);
        if (cloud != null && cloud.supportsCloudSummaries()) {
            JMenuItem cloudReport = new JMenuItem("Cloud summary");
            cloudReport.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainFrameMenu.this.mainFrame.displayCloudReport();
                }
            });
            this.viewMenu.add(cloudReport);
        }
        if (this.mainFrame.getProjectPackagePrefixes().size() > 0 && this.mainFrame.getBugCollection() != null) {
            JMenuItem selectPackagePrefixMenu = new JMenuItem("Select class search strings by project...");
            selectPackagePrefixMenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainFrameMenu.this.mainFrame.selectPackagePrefixByProject();
                }
            });
            this.viewMenu.add(selectPackagePrefixMenu);
        }
        if (this.viewMenu.getItemCount() > 0) {
            this.viewMenu.addSeparator();
        }
        ButtonGroup rankButtonGroup = new ButtonGroup();
        for (final ViewFilter.RankFilter r : ViewFilter.RankFilter.values()) {
            JRadioButtonMenuItem rbMenuItem2 = new JRadioButtonMenuItem(r.toString());
            AnnotatedString.localiseButton(rbMenuItem2, "menu.rankFilter_" + r.name().toLowerCase(Locale.ENGLISH), r.toString(), true);
            rankButtonGroup.add(rbMenuItem2);
            if (r == ViewFilter.RankFilter.ALL) {
                rbMenuItem2.setSelected(true);
            }
            rbMenuItem2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainFrameMenu.this.mainFrame.getViewFilter().setRank(r);
                    MainFrameMenu.this.mainFrame.resetViewCache();
                }
            });
            this.viewMenu.add(rbMenuItem2);
        }
        this.viewMenu.addSeparator();
        ButtonGroup priorityButtonGroup = new ButtonGroup();
        for (final ViewFilter.PriorityFilter r : ViewFilter.PriorityFilter.values()) {
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(r.toString());
            AnnotatedString.localiseButton(jRadioButtonMenuItem, "menu.priorityFilter_" + r.name().toLowerCase(Locale.ENGLISH), r.toString(), true);
            priorityButtonGroup.add(jRadioButtonMenuItem);
            if (r == ViewFilter.PriorityFilter.ALL_BUGS) {
                jRadioButtonMenuItem.setSelected(true);
            }
            jRadioButtonMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainFrameMenu.this.mainFrame.getViewFilter().setPriority(r);
                    MainFrameMenu.this.mainFrame.resetViewCache();
                }
            });
            this.viewMenu.add(jRadioButtonMenuItem);
        }
        this.viewMenu.addSeparator();
        if (cloud != null && cloud.getMode() == Cloud.Mode.COMMUNAL) {
            ButtonGroup overallClassificationButtonGroup = new ButtonGroup();
            for (final ViewFilter.OverallClassificationFilter overallClassificationFilter : ViewFilter.OverallClassificationFilter.values()) {
                if (!overallClassificationFilter.supported(cloud)) continue;
                rbMenuItem = new JRadioButtonMenuItem(overallClassificationFilter.toString());
                AnnotatedString.localiseButton(rbMenuItem, "menu.classificatonFilter_" + overallClassificationFilter.name().toLowerCase(Locale.ENGLISH), overallClassificationFilter.toString(), true);
                overallClassificationButtonGroup.add(rbMenuItem);
                if (overallClassificationFilter == ViewFilter.OverallClassificationFilter.ALL) {
                    rbMenuItem.setSelected(true);
                }
                rbMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        MainFrameMenu.this.mainFrame.getViewFilter().setClassification(overallClassificationFilter);
                        MainFrameMenu.this.mainFrame.resetViewCache();
                    }
                });
                this.viewMenu.add(rbMenuItem);
            }
            this.viewMenu.addSeparator();
        }
        ButtonGroup evalButtonGroup = new ButtonGroup();
        for (final ViewFilter.CloudFilter cloudFilter : ViewFilter.CloudFilter.values()) {
            if (cloud != null && !cloudFilter.supported(cloud)) continue;
            rbMenuItem = new JRadioButtonMenuItem(cloudFilter.toString());
            AnnotatedString.localiseButton(rbMenuItem, "menu.cloudFilter_" + cloudFilter.name().toLowerCase(Locale.ENGLISH), cloudFilter.toString(), true);
            evalButtonGroup.add(rbMenuItem);
            if (cloudFilter == ViewFilter.CloudFilter.ALL) {
                rbMenuItem.setSelected(true);
            }
            rbMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainFrameMenu.this.mainFrame.getViewFilter().setEvaluation(cloudFilter);
                    MainFrameMenu.this.mainFrame.resetViewCache();
                }
            });
            this.viewMenu.add(rbMenuItem);
        }
        this.viewMenu.addSeparator();
        ButtonGroup ageButtonGroup = new ButtonGroup();
        ViewFilter.FirstSeenFilter[] arr$ = ViewFilter.FirstSeenFilter.values();
        int len$ = arr$.length;
        boolean bl = false;
        while (var8_22 < len$) {
            final ViewFilter.FirstSeenFilter r = arr$[var8_22];
            JRadioButtonMenuItem rbMenuItem4 = new JRadioButtonMenuItem(r.toString());
            AnnotatedString.localiseButton(rbMenuItem4, "menu.firstSeenFilter_" + r.name().toLowerCase(Locale.ENGLISH), r.toString(), true);
            ageButtonGroup.add(rbMenuItem4);
            if (r == ViewFilter.FirstSeenFilter.ALL) {
                rbMenuItem4.setSelected(true);
            }
            rbMenuItem4.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainFrameMenu.this.mainFrame.getViewFilter().setFirstSeen(r);
                    MainFrameMenu.this.mainFrame.resetViewCache();
                }
            });
            this.viewMenu.add(rbMenuItem4);
            ++var8_22;
        }
        this.viewMenu.addSeparator();
        final Filter suppressionFilter = MainFrame.getInstance().getProject().getSuppressionFilter();
        Collection<Matcher> filters = suppressionFilter.getChildren();
        JMenuItem jMenuItem = new JMenuItem(filters.isEmpty() ? "Add Filters..." : "Filters...");
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreferencesFrame preferenceFrame = PreferencesFrame.getInstance();
                preferenceFrame.showFilterPane();
                preferenceFrame.setLocationRelativeTo(MainFrameMenu.this.mainFrame);
                preferenceFrame.setVisible(true);
            }
        });
        this.viewMenu.add(jMenuItem);
        for (final Matcher m : filters) {
            JCheckBoxMenuItem f = new JCheckBoxMenuItem(m.toString(), suppressionFilter.isEnabled(m));
            this.viewMenu.add(f);
            f.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    boolean enabled = e.getStateChange() == 1;
                    suppressionFilter.setEnabled(m, enabled);
                    FilterActivity.notifyListeners(enabled ? FilterListener.Action.FILTERING : FilterListener.Action.UNFILTERING, null);
                }
            });
        }
    }

    public void addFileToRecent(File xmlFile) {
        ArrayList<File> xmlFiles = GUISaveState.getInstance().getRecentFiles();
        if (!xmlFiles.contains(xmlFile)) {
            GUISaveState.getInstance().addRecentFile(xmlFile);
        }
        this.recentMenuCache.addRecentFile(xmlFile);
    }

    public JMenuItem getSaveMenuItem() {
        return this.saveMenuItem;
    }

    public JMenuItem getReconfigMenuItem() {
        return this.reconfigMenuItem;
    }

    public void enableRecentMenu(boolean enable) {
        this.recentMenu.setEnabled(enable);
    }

    public JMenuItem getPreferencesMenuItem() {
        return this.preferencesMenuItem;
    }

    void setSaveMenu(MainFrame mainFrame) {
        File s = mainFrame.getSaveFile();
        this.getSaveMenuItem().setEnabled(mainFrame.projectChanged() && s != null && mainFrame.getSaveType() != SaveType.FBP_FILE && s.exists());
    }

    public void enablePreferencesMenuItem(boolean b) {
        this.getPreferencesMenuItem().setEnabled(b);
        if (MainFrame.MAC_OS_X && this.osxPrefsEnableMethod != null) {
            Object[] args = new Object[]{b};
            try {
                this.osxPrefsEnableMethod.invoke(this.osxAdapter, args);
            }
            catch (Exception e) {
                System.err.println("Exception while enabling Preferences menu: " + e);
            }
        }
    }

    public void initOSX() throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        this.osxAdapter = Class.forName("edu.umd.cs.findbugs.gui2.OSXAdapter");
        Method registerMethod = this.osxAdapter.getDeclaredMethod("registerMacOSXApplication", MainFrame.class);
        if (registerMethod != null) {
            registerMethod.invoke(this.osxAdapter, this.mainFrame);
        }
        this.osxPrefsEnableMethod = this.osxAdapter.getDeclaredMethod("enablePrefs", Boolean.TYPE);
    }

    public JMenuItem getCloseProjectItem() {
        return this.closeProjectItem;
    }

    public void enableOrDisableItems(Project curProject, BugCollection bugCollection) {
        boolean haveBugs = bugCollection != null;
        boolean haveCodeToAnalyze = curProject != null && !curProject.getFileList().isEmpty();
        this.redoAnalysis.setEnabled(haveBugs && haveCodeToAnalyze);
        this.closeProjectItem.setEnabled(haveBugs);
        this.saveMenuItem.setEnabled(haveBugs);
        this.saveAsMenuItem.setEnabled(haveBugs);
        this.reconfigMenuItem.setEnabled(haveBugs);
        this.groupByMenuItem.setEnabled(haveBugs);
    }

    private void addNavItem(ActionMap map, JMenu navMenu, String menuNameKey, String menuNameDefault, String actionName, int keyEvent) {
        JMenuItem toggleItem = MainFrameHelper.newJMenuItem(menuNameKey, menuNameDefault);
        toggleItem.addActionListener(this.mainFrame.getMainFrameTree().treeActionAdapter(map, actionName));
        MainFrameHelper.attachAcceleratorKeyNoCtrl(toggleItem, keyEvent);
        navMenu.add(toggleItem);
    }

    static class PasteAction
    extends TextAction {
        public PasteAction() {
            super(L10N.getLocalString("txt.paste", "Paste"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JTextComponent text = this.getTextComponent(evt);
            if (text == null) {
                return;
            }
            text.paste();
        }
    }

    static class CopyAction
    extends TextAction {
        public CopyAction() {
            super(L10N.getLocalString("txt.copy", "Copy"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JTextComponent text = this.getTextComponent(evt);
            if (text == null) {
                return;
            }
            text.copy();
        }
    }

    static class CutAction
    extends TextAction {
        public CutAction() {
            super(L10N.getLocalString("txt.cut", "Cut"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JTextComponent text = this.getTextComponent(evt);
            if (text == null) {
                return;
            }
            text.cut();
        }
    }
}

