/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.gui2;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugRanker;
import edu.umd.cs.findbugs.cloud.Cloud;
import edu.umd.cs.findbugs.gui2.FilterActivity;
import edu.umd.cs.findbugs.gui2.FilterListener;
import edu.umd.cs.findbugs.gui2.MainFrame;
import edu.umd.cs.findbugs.internalAnnotations.DottedClassName;
import edu.umd.cs.findbugs.util.ClassName;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;

public class ViewFilter {
    static final int NO_MATTER_WHEN_FIRST_SEEN = 400000;
    final MainFrame mf;
    RankFilter rank = RankFilter.ALL;
    PriorityFilter priority = PriorityFilter.ALL_BUGS;
    CloudFilter eval = CloudFilter.ALL;
    OverallClassificationFilter classificationFilter = OverallClassificationFilter.ALL;
    FirstSeenFilter firstSeen = FirstSeenFilter.ALL;
    String[] classSearchStrings;
    static final Pattern legalClassSearchString = Pattern.compile("[\\p{javaLowerCase}\\p{javaUpperCase}0-9.$/_]*");

    public ViewFilter(MainFrame mf) {
        this.mf = mf;
    }

    void setPackagesToDisplay(String value) {
        if ((value = value.replace('/', '.').trim()).length() == 0) {
            this.classSearchStrings = new String[0];
        } else {
            String[] parts;
            for (String p : parts = value.split("[ ,:]+")) {
                if (legalClassSearchString.matcher(p).matches()) continue;
                throw new IllegalArgumentException("Classname filter must be legal Java identifier: " + p);
            }
            this.classSearchStrings = parts;
        }
        FilterActivity.notifyListeners(FilterListener.Action.FILTERING, null);
    }

    public RankFilter getRank() {
        return this.rank;
    }

    public void setRank(RankFilter rank) {
        this.rank = rank;
        FilterActivity.notifyListeners(FilterListener.Action.FILTERING, null);
    }

    public PriorityFilter getPriority() {
        return this.priority;
    }

    public void setPriority(PriorityFilter priority) {
        this.priority = priority;
        FilterActivity.notifyListeners(FilterListener.Action.FILTERING, null);
    }

    public CloudFilter getEvaluation() {
        return this.eval;
    }

    public void setEvaluation(CloudFilter eval) {
        if (this.eval == eval) {
            return;
        }
        this.eval = eval;
        FilterActivity.notifyListeners(FilterListener.Action.FILTERING, null);
    }

    public void setClassification(OverallClassificationFilter classificationFilter) {
        if (this.classificationFilter == classificationFilter) {
            return;
        }
        this.classificationFilter = classificationFilter;
        FilterActivity.notifyListeners(FilterListener.Action.FILTERING, null);
    }

    public FirstSeenFilter getFirstSeen() {
        return this.firstSeen;
    }

    public void setFirstSeen(FirstSeenFilter firstSeen) {
        this.firstSeen = firstSeen;
        FilterActivity.notifyListeners(FilterListener.Action.FILTERING, null);
    }

    public String[] getPackagePrefixes() {
        return this.classSearchStrings;
    }

    public boolean showIgnoringPackagePrefixes(BugInstance b) {
        if (!this.firstSeen.show(this.mf, b)) {
            return false;
        }
        if (!this.rank.show(this.mf, b)) {
            return false;
        }
        if (!this.priority.show(this.mf, b)) {
            return false;
        }
        if (!this.eval.show(this.mf, b)) {
            return false;
        }
        return this.classificationFilter.show(this.mf, b);
    }

    @Deprecated
    public static boolean matchedPrefixes(String[] classSearchStrings, @DottedClassName String className) {
        return ClassName.matchedPrefixes(classSearchStrings, className);
    }

    public boolean show(BugInstance b) {
        String className = b.getPrimaryClass().getClassName();
        return ClassName.matchedPrefixes(this.classSearchStrings, className) && this.showIgnoringPackagePrefixes(b);
    }

    static enum FirstSeenFilter implements ViewFilterEnum
    {
        LAST_DAY(1, "Last day"),
        LAST_3_DAYS(3, "Last 3 days"),
        LAST_WEEK(7, "Last week"),
        LAST_MONTH(30, "Last month"),
        LAST_THREE_MONTHS(91, "Last 90 days"),
        LAST_YEAR(365, "Last year"),
        ALL(Integer.MAX_VALUE, "All time"){

            @Override
            public boolean show(MainFrame mf, BugInstance b) {
                return true;
            }
        };

        final int maxDays;
        final String displayName;

        private FirstSeenFilter(int days, String displayName) {
            this.maxDays = days;
            this.displayName = displayName;
        }

        @Override
        public boolean show(MainFrame mf, BugInstance b) {
            Cloud cloud = mf.getBugCollection().getCloud();
            if (!cloud.isInCloud(b)) {
                return false;
            }
            long firstSeen = cloud.getFirstSeen(b);
            long time = System.currentTimeMillis() - firstSeen;
            long days = TimeUnit.SECONDS.convert(time, TimeUnit.MILLISECONDS) / 3600L / 24L;
            return days < (long)this.maxDays;
        }

        public String toString() {
            return this.displayName;
        }
    }

    static enum CloudFilter implements ViewFilterEnum
    {
        MY_REVIEWS("Classified by me"){

            @Override
            boolean show(Cloud cloud, BugInstance b) {
                return cloud.getReviewers(b).contains(cloud.getUser());
            }
        }
        ,
        NOT_REVIEWED_BY_ME("Not classified by me"){

            @Override
            boolean show(Cloud cloud, BugInstance b) {
                return !cloud.getReviewers(b).contains(cloud.getUser());
            }
        }
        ,
        NO_REVIEWS("No one has classified"){

            @Override
            boolean show(Cloud cloud, BugInstance b) {
                return cloud.getReviewers(b).isEmpty();
            }

            @Override
            public boolean supported(Cloud cloud) {
                return cloud.getMode() != Cloud.Mode.SECRET;
            }
        }
        ,
        HAS_REVIEWS("Someone has classified"){

            @Override
            boolean show(Cloud cloud, BugInstance b) {
                return !cloud.getReviewers(b).isEmpty();
            }

            @Override
            public boolean supported(Cloud cloud) {
                return cloud.getMode() != Cloud.Mode.SECRET;
            }
        }
        ,
        NO_ONE_COMMITTED_TO_FIXING("Has no fixers"){

            @Override
            boolean show(Cloud cloud, BugInstance b) {
                return this.supported(cloud) && cloud.claimedBy(b) != null;
            }

            @Override
            public boolean supported(Cloud cloud) {
                return cloud.supportsClaims() && cloud.getMode() != Cloud.Mode.SECRET;
            }
        }
        ,
        I_WILL_FIX("I will fix"){

            @Override
            boolean show(Cloud cloud, BugInstance b) {
                return cloud.getIWillFix(b);
            }
        }
        ,
        HAS_FILED_BUGS("Has entry in bug database"){

            @Override
            boolean show(Cloud cloud, BugInstance b) {
                return cloud.getBugLinkStatus(b).bugIsFiled();
            }

            @Override
            public boolean supported(Cloud cloud) {
                return cloud.supportsBugLinks();
            }
        }
        ,
        NO_FILED_BUGS("Don't have entry in bug database"){

            @Override
            boolean show(Cloud cloud, BugInstance b) {
                return !cloud.getBugLinkStatus(b).bugIsFiled();
            }

            @Override
            public boolean supported(Cloud cloud) {
                return cloud.supportsBugLinks();
            }
        }
        ,
        WILL_NOT_FIX("bug database entry marked Will Not Fix"){

            @Override
            boolean show(Cloud cloud, BugInstance b) {
                return cloud.getWillNotBeFixed(b);
            }

            @Override
            public boolean supported(Cloud cloud) {
                return cloud.supportsBugLinks();
            }
        }
        ,
        BUG_STATUS_IS_UNASSIGNED("bug database entry is unassigned"){

            @Override
            boolean show(Cloud cloud, BugInstance b) {
                return cloud.getBugIsUnassigned(b);
            }

            @Override
            public boolean supported(Cloud cloud) {
                return cloud.supportsBugLinks();
            }
        }
        ,
        ALL("All issues"){

            @Override
            boolean show(Cloud cloud, BugInstance b) {
                return true;
            }

            @Override
            public boolean show(MainFrame mf, BugInstance b) {
                return true;
            }
        };

        final String displayName;

        private CloudFilter(String displayName) {
            this.displayName = displayName;
        }

        abstract boolean show(Cloud var1, BugInstance var2);

        public boolean supported(Cloud cloud) {
            return true;
        }

        @Override
        public boolean show(MainFrame mf, BugInstance b) {
            Cloud c = mf.getBugCollection().getCloud();
            return c.isInCloud(b) && this.show(c, b);
        }

        public String toString() {
            return this.displayName;
        }
    }

    static enum OverallClassificationFilter implements ViewFilterEnum
    {
        NOT_HARMLESS("Not classified as harmless"){

            @Override
            boolean show(Cloud cloud, BugInstance b) {
                double score = cloud.getClassificationScore(b);
                if (score <= (double)Cloud.UserDesignation.MOSTLY_HARMLESS.score()) {
                    return false;
                }
                score = cloud.getPortionObsoleteClassifications(b);
                return !(score >= 0.5);
            }
        }
        ,
        SHOULD_FIX("Overall classification is should fix"){

            @Override
            boolean show(Cloud cloud, BugInstance b) {
                double score = cloud.getClassificationScore(b);
                return score >= (double)Cloud.UserDesignation.SHOULD_FIX.score();
            }
        }
        ,
        DONT_FIX("Overall classification is don't fix"){

            @Override
            boolean show(Cloud cloud, BugInstance b) {
                double score = cloud.getClassificationScore(b);
                return score <= (double)Cloud.UserDesignation.MOSTLY_HARMLESS.score();
            }
        }
        ,
        OBSOLETE("Overall classification is obsolete code"){

            @Override
            boolean show(Cloud cloud, BugInstance b) {
                double score = cloud.getPortionObsoleteClassifications(b);
                return score >= 0.5;
            }
        }
        ,
        UNCERTAIN("Overall classification is uncertain"){

            @Override
            boolean show(Cloud cloud, BugInstance b) {
                if (SHOULD_FIX.show(cloud, b) || DONT_FIX.show(cloud, b) || OBSOLETE.show(cloud, b)) {
                    return false;
                }
                return cloud.getNumberReviewers(b) >= 2;
            }
        }
        ,
        HIGH_VARIANCE("Controversial"){

            @Override
            boolean show(Cloud cloud, BugInstance b) {
                double variance = cloud.getClassificationDisagreement(b);
                return variance > 0.26;
            }
        }
        ,
        ALL("All issues"){

            @Override
            public boolean show(MainFrame mf, BugInstance b) {
                return true;
            }

            @Override
            boolean show(Cloud cloud, BugInstance b) {
                return true;
            }
        };

        final String displayName;

        private OverallClassificationFilter(String displayName) {
            this.displayName = displayName;
        }

        abstract boolean show(Cloud var1, BugInstance var2);

        public boolean supported(Cloud cloud) {
            return true;
        }

        @Override
        public boolean show(MainFrame mf, BugInstance b) {
            Cloud c = mf.getBugCollection().getCloud();
            return c.isInCloud(b) && this.show(c, b);
        }

        public String toString() {
            return this.displayName;
        }
    }

    static enum RankFilter implements ViewFilterEnum
    {
        SCARIEST(4, "Scariest"),
        SCARY(9, "Scary"),
        TROUBLING(14, "Troubling"),
        ALL(Integer.MAX_VALUE, "All bug ranks");

        final int maxRank;
        final String displayName;

        private RankFilter(int maxRank, String displayName) {
            this.maxRank = maxRank;
            this.displayName = displayName;
        }

        @Override
        public boolean show(MainFrame mf, BugInstance b) {
            int rank = BugRanker.findRank(b);
            return rank <= this.maxRank;
        }

        public String toString() {
            if (this.maxRank < Integer.MAX_VALUE) {
                return this.displayName + " (Ranks 1 - " + this.maxRank + ")";
            }
            return this.displayName;
        }
    }

    static enum PriorityFilter implements ViewFilterEnum
    {
        HIGH_PRIORITY(1, "High priority only"),
        NORMAL_PRIORITY(2, "High and normal priority"),
        ALL_BUGS(10, "All bug priorities");

        final int maxPriority;
        final String displayName;

        private PriorityFilter(int maxPriority, String displayName) {
            this.maxPriority = maxPriority;
            this.displayName = displayName;
        }

        @Override
        public boolean show(MainFrame mf, BugInstance b) {
            return b.getPriority() <= this.maxPriority;
        }

        public String toString() {
            return this.displayName;
        }
    }

    static interface ViewFilterEnum {
        public boolean show(MainFrame var1, BugInstance var2);
    }
}

