/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.workflow;

import edu.umd.cs.findbugs.FindBugs;
import edu.umd.cs.findbugs.charsets.UTF8;
import edu.umd.cs.findbugs.charsets.UserTextFile;
import edu.umd.cs.findbugs.config.CommandLine;
import edu.umd.cs.findbugs.util.DualKeyHashMap;
import edu.umd.cs.findbugs.util.Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class CountClassVersions {
    public static List<String> readFromStandardInput() throws IOException {
        return CountClassVersions.readFrom(UserTextFile.reader(System.in));
    }

    public static List<String> readFrom(Reader r) throws IOException {
        BufferedReader in = new BufferedReader(r);
        LinkedList<String> lst = new LinkedList<String>();
        String s;
        while ((s = in.readLine()) != null) {
            lst.add(s);
        }
        return lst;
    }

    public static void main(String[] args) throws Exception {
        FindBugs.setNoAnalysis();
        CountClassVersionsCommandLine commandLine = new CountClassVersionsCommandLine();
        int argCount = commandLine.parse(args, 0, Integer.MAX_VALUE, "Usage: " + CountClassVersions.class.getName() + " [options] [<jarFile>+] ");
        List<String> fileList = commandLine.inputFileList != null ? CountClassVersions.readFrom(UTF8.fileReader(commandLine.inputFileList)) : (argCount == args.length ? CountClassVersions.readFromStandardInput() : Arrays.asList(args).subList(argCount, args.length - 1));
        byte[] buffer = new byte[8192];
        MessageDigest digest = Util.getMD5Digest();
        DualKeyHashMap<String, String, String> map = new DualKeyHashMap<String, String, String>();
        for (String fInName : fileList) {
            File f = new File(fInName);
            if (f.lastModified() < commandLine.maxAge) {
                System.err.println("Skipping " + fInName + ", too old (" + new Date(f.lastModified()) + ")");
                continue;
            }
            System.err.println("Opening " + f);
            try {
                ZipFile zipInputFile = new ZipFile(f);
                Throwable throwable = null;
                try {
                    ZipEntry ze;
                    Enumeration<? extends ZipEntry> e = zipInputFile.entries();
                    while (e.hasMoreElements() && (ze = e.nextElement()) != null) {
                        int bytesRead;
                        String name;
                        if (ze.isDirectory() || !(name = ze.getName()).endsWith(".class") || !name.replace('/', '.').startsWith(commandLine.prefix)) continue;
                        InputStream zipIn = zipInputFile.getInputStream(ze);
                        while ((bytesRead = zipIn.read(buffer)) >= 0) {
                            digest.update(buffer, 0, bytesRead);
                        }
                        String hash = new BigInteger(1, digest.digest()).toString(16);
                        map.put(name, hash, fInName);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (zipInputFile == null) continue;
                    if (throwable != null) {
                        try {
                            zipInputFile.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    zipInputFile.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        for (String s : map.keySet()) {
            Map values = map.get(s);
            if (values.size() <= 1) continue;
            System.out.println(values.size() + "\t" + s + "\t" + values.values());
        }
    }

    static class CountClassVersionsCommandLine
    extends CommandLine {
        public String prefix = "";
        public String inputFileList;
        long maxAge = Long.MIN_VALUE;

        CountClassVersionsCommandLine() {
            this.addOption("-maxAge", "days", "maximum age in days (ignore jar files older than this");
            this.addOption("-inputFileList", "filename", "text file containing names of jar files");
            this.addOption("-prefix", "class name prefix", "prefix of class names that should be analyzed e.g., edu.umd.cs.)");
        }

        @Override
        protected void handleOption(String option, String optionExtraPart) throws IOException {
            throw new IllegalArgumentException("Unknown option : " + option);
        }

        @Override
        protected void handleOptionWithArgument(String option, String argument) throws IOException {
            if ("-prefix".equals(option)) {
                this.prefix = argument;
            } else if ("-inputFileList".equals(option)) {
                this.inputFileList = argument;
            } else if ("-maxAge".equals(option)) {
                this.maxAge = System.currentTimeMillis() - 86400000L * (long)Integer.parseInt(argument);
            } else {
                throw new IllegalArgumentException("Unknown option : " + option);
            }
        }
    }
}

