/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.workflow;

import edu.umd.cs.findbugs.AnalysisError;
import edu.umd.cs.findbugs.FindBugs;
import edu.umd.cs.findbugs.SortedBugCollection;

public class ListErrors {
    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.out.println("Usage: " + ListErrors.class.getName() + " <bug collection>");
            System.exit(1);
        }
        FindBugs.setNoAnalysis();
        SortedBugCollection bugCollection = new SortedBugCollection();
        bugCollection.readXML(args[0]);
        for (AnalysisError analysisError : bugCollection.getErrors()) {
            String msg = analysisError.getExceptionMessage();
            if (msg != null && msg.trim().length() > 0) {
                System.out.println(analysisError.getMessage() + " : " + msg);
                continue;
            }
            System.out.println(analysisError.getMessage());
        }
    }
}

