/*
 * @(#)Skeleton.java	1.6 98/07/01
 *
 * Copyright 1995-1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 * 
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */
package java.rmi.server;

import java.rmi.Remote;

/** Used solely by the implementation.<p>
 * Every skeleton class generated by the rmic stub compiler implements
 * this interface. A skeleton for a remote object is a server-side entity
 * that dispatches calls to the actual remote object implementation.
 */
public interface Skeleton {
    /**
     * Unmarshals arguments, calls the actual remote object implementation,
     * and marshals the return value or any exception.
     *
     * @exception java.lang.Exception if a general exception occurs.
     */
    void dispatch(Remote obj, RemoteCall theCall, int opnum, long hash)
	throws Exception;

    Operation[] getOperations();
}
