/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.ws.processor.generator;

import com.sun.codemodel.internal.CodeWriter;
import com.sun.codemodel.internal.JCodeModel;
import com.sun.codemodel.internal.writer.ProgressCodeWriter;
import com.sun.tools.internal.ws.processor.config.Configuration;
import com.sun.tools.internal.ws.processor.generator.GeneratorBase;
import com.sun.tools.internal.ws.processor.model.Model;
import com.sun.tools.internal.ws.processor.model.jaxb.JAXBType;
import com.sun.tools.internal.ws.processor.model.jaxb.RpcLitStructure;
import com.sun.tools.internal.ws.processor.modeler.wsdl.ConsoleErrorReporter;
import com.sun.tools.internal.ws.wscompile.WSCodeWriter;
import com.sun.tools.internal.xjc.api.ErrorListener;
import com.sun.tools.internal.xjc.api.S2JJAXBModel;
import com.sun.xml.internal.ws.encoding.soap.SOAPVersion;
import java.util.Properties;
import org.xml.sax.SAXParseException;

public class JAXBTypeGenerator
extends GeneratorBase {
    private static boolean doneGeneration = true;

    public JAXBTypeGenerator() {
    }

    public JAXBTypeGenerator(Model model, Configuration configuration, Properties properties) {
        super(model, configuration, properties);
    }

    public GeneratorBase getGenerator(Model model, Configuration configuration, Properties properties) {
        return new JAXBTypeGenerator(model, configuration, properties);
    }

    public GeneratorBase getGenerator(Model model, Configuration configuration, Properties properties, SOAPVersion sOAPVersion) {
        return new JAXBTypeGenerator(model, configuration, properties);
    }

    public void visit(JAXBType jAXBType) throws Exception {
        if (jAXBType.getJaxbModel() == null) {
            return;
        }
        S2JJAXBModel s2JJAXBModel = jAXBType.getJaxbModel().getS2JJAXBModel();
        if (s2JJAXBModel != null) {
            this.generateJAXBClasses(s2JJAXBModel);
        }
    }

    public void visit(RpcLitStructure rpcLitStructure) throws Exception {
        S2JJAXBModel s2JJAXBModel = rpcLitStructure.getJaxbModel().getS2JJAXBModel();
        this.generateJAXBClasses(s2JJAXBModel);
    }

    private void generateJAXBClasses(S2JJAXBModel s2JJAXBModel) throws Exception {
        if (doneGeneration) {
            return;
        }
        JCodeModel jCodeModel = null;
        CodeWriter codeWriter = new WSCodeWriter(this.sourceDir, this.env);
        if (this.env.verbose()) {
            codeWriter = new ProgressCodeWriter(codeWriter, System.out);
        }
        jCodeModel = s2JJAXBModel.generateCode(null, new ConsoleErrorReporter(this.env, this.printStackTrace));
        jCodeModel.build(codeWriter);
        doneGeneration = true;
    }

    public static class JAXBErrorListener
    implements ErrorListener {
        public void error(SAXParseException sAXParseException) {
        }

        public void fatalError(SAXParseException sAXParseException) {
        }

        public void warning(SAXParseException sAXParseException) {
        }

        public void info(SAXParseException sAXParseException) {
        }
    }
}

