/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.ws.processor.util;

import com.sun.mirror.apt.Filer;
import com.sun.tools.internal.ws.processor.util.ProcessorEnvironment;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.StringTokenizer;

public abstract class ProcessorEnvironmentBase
implements ProcessorEnvironment {
    protected URLClassLoader classLoader = null;
    protected Filer filer = null;

    public URLClassLoader getClassLoader() {
        if (this.classLoader == null) {
            this.classLoader = new URLClassLoader(ProcessorEnvironmentBase.pathToURLs(this.getClassPath()), this.getClass().getClassLoader());
        }
        return this.classLoader;
    }

    public static URL[] pathToURLs(String string) {
        URL[] uRLArray;
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        URL[] uRLArray2 = new URL[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            uRLArray = ProcessorEnvironmentBase.fileToURL(new File(stringTokenizer.nextToken()));
            if (uRLArray == null) continue;
            uRLArray2[n++] = uRLArray;
        }
        if (uRLArray2.length != n) {
            uRLArray = new URL[n];
            System.arraycopy(uRLArray2, 0, uRLArray, 0, n);
            uRLArray2 = uRLArray;
        }
        return uRLArray2;
    }

    public static URL fileToURL(File file) {
        String string;
        try {
            string = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            string = file.getAbsolutePath();
        }
        string = string.replace(File.separatorChar, '/');
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        if (!file.isFile()) {
            string = string + "/";
        }
        try {
            return new URL("file", "", string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException("file");
        }
    }

    public Filer getFiler() {
        return this.filer;
    }

    public void setFiler(Filer filer) {
        this.filer = filer;
    }
}

