/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.util.logging.Level;
import java.util.logging.Logger;
import sun.awt.X11.Native;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XlibWrapper;
import sun.java2d.DisposerRecord;
import sun.misc.Unsafe;

class UnsafeXDisposerRecord
implements DisposerRecord {
    private static final Logger log = Logger.getLogger("sun.awt.X11.UnsafeXDisposerRecord");
    private static Unsafe unsafe = XlibWrapper.unsafe;
    final long[] unsafe_ptrs;
    final long[] x_ptrs;
    final String name;
    volatile boolean disposed;
    final Throwable place;

    public UnsafeXDisposerRecord(String string, long[] lArray, long[] lArray2) {
        this.unsafe_ptrs = lArray;
        this.x_ptrs = lArray2;
        this.name = string;
        this.place = XlibWrapper.isBuildInternal ? new Throwable() : null;
    }

    public UnsafeXDisposerRecord(String string, long ... lArray) {
        this.unsafe_ptrs = lArray;
        this.x_ptrs = null;
        this.name = string;
        this.place = XlibWrapper.isBuildInternal ? new Throwable() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        XToolkit.awtLock();
        try {
            if (!this.disposed) {
                if (XlibWrapper.isBuildInternal && "Java2D Disposer".equals(Thread.currentThread().getName()) && log.isLoggable(Level.WARNING)) {
                    if (this.place != null) {
                        log.log(Level.WARNING, this.name + " object was not disposed before finalization!", this.place);
                    } else {
                        log.log(Level.WARNING, this.name + " object was not disposed before finalization!");
                    }
                }
                if (this.unsafe_ptrs != null) {
                    for (long l : this.unsafe_ptrs) {
                        if (l == 0L) continue;
                        unsafe.freeMemory(l);
                    }
                }
                if (this.x_ptrs != null) {
                    for (long l : this.x_ptrs) {
                        if (l == 0L) continue;
                        if (Native.getLong(l) != 0L) {
                            XlibWrapper.XFree(Native.getLong(l));
                        }
                        unsafe.freeMemory(l);
                    }
                }
                this.disposed = true;
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            XToolkit.awtUnlock();
            throw throwable;
        }
        XToolkit.awtUnlock();
    }
}

